/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.html.docbook.DBTConstants;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.Row;
import org.dbdoclet.trafo.tag.html.Tr;

public class TrEditor extends Editor {

    @Override
    public EditorInstruction edit(EditorInstruction values) throws EditorException {

        setValues(super.edit(values));
        DocBookTagFactory dbfactory = values.getTagFactory();

		Script script = getTransformer().getScript();
		boolean decomposeTables = script.isParameterEnabled(
				DBTConstants.SECTION_DOCBOOK,
				DBTConstants.PARAM_DOCBOOK_DECOMPOSE_TABLES,
				DBTConstants.DEFAULT_DECOMPOSE_TABLES);

		if (decomposeTables || getHtmlElement().isMute()) {
            traverse(true);
            return finalizeValues();
        }

        Tr tr = (Tr) values.getHtmlElement();
        Integer height = tr.getHeight();
        
        if (height != null && height == 0) {
        	traverse(false);
        	return finalizeValues();
        }
        
        if (getParent() instanceof org.dbdoclet.trafo.tag.docbook.Tgroup
                || getParent() instanceof org.dbdoclet.trafo.tag.docbook.EntryTbl) {

            setCurrent(dbfactory.createTbody());
            getCurrent().setParentNode(getParent());
            getParent().appendChild(getCurrent());
            setParent(getCurrent());
        }

        Row row = dbfactory.createRow();
        copyCommonAttributes(getHtmlElement(), row);
        setCurrent(row);
        getParent().appendChild(getCurrent());
        traverse(true);

        return finalizeValues();
    }
}
