/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.html.docbook.DBTConstants;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.xiphias.dom.ElementImpl;

public class ThEditor extends Editor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		setValues(super.edit(values));
		DocBookTagFactory dbfactory = values.getTagFactory();

		Script script = getTransformer().getScript();
		boolean decomposeTables = script.isParameterEnabled(
				DBTConstants.SECTION_DOCBOOK,
				DBTConstants.PARAM_DOCBOOK_DECOMPOSE_TABLES,
				DBTConstants.DEFAULT_DECOMPOSE_TABLES);

		if (decomposeTables || getHtmlElement().isMute()) {

			traverse(true);
			return finalizeValues();
		}

		org.dbdoclet.trafo.tag.html.Th th = (org.dbdoclet.trafo.tag.html.Th) getHtmlElement();
		org.dbdoclet.trafo.tag.docbook.Entry entry = dbfactory.createEntry();

		entry.setAlign(th.getAlign());
		entry.setChar(th.getChar());
		entry.setCharOff(th.getCharOff());
		entry.setVAlign(th.getVAlign());

		int colspan = th.getColspan();

		if (colspan > 1) {

			entry.setNameSt("c" + th.getIndex());
			entry.setNameEnd("c" + ((th.getIndex() + colspan) - 1));
		}

		int rowspan = th.getRowspan();

		if (rowspan > 0) {
			entry.setMorerows(rowspan);
		}

		org.dbdoclet.trafo.tag.docbook.Para para = dbfactory.createPara();
		para.setFormatType(ElementImpl.FORMAT_INLINE);

		org.dbdoclet.trafo.tag.docbook.Emphasis emph = dbfactory
				.createEmphasis();

		emph.setRole(DBTConstants.DEFAULT_EMPHASIS_ROLE_BOLD);

		entry.appendChild(para);
		para.appendChild(emph);

		getParent().appendChild(entry);
		setCurrent(emph);

		traverse(true);

		return finalizeValues();
	}
}
