/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.html.docbook.DocBookTransformer;
import org.dbdoclet.trafo.tag.docbook.DocBookElement;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.html.HtmlElement;
import org.dbdoclet.xiphias.dom.CharacterDataImpl;

public class EditorInstruction {

    private DocBookElement current;
    private DocBookElement parent;
    private HtmlElement child;
    private Object anything;
    private DocBookTransformer transformer;
    private CharacterDataImpl characterDataNode;
    private boolean doIgnore = false;
    private boolean doTraverse = true;
    private DocBookTransformer.DocumentElementType codeContext;

    public boolean doIgnore() {

	return doIgnore;
    }

    public void doIgnore(boolean ignore) {

	this.doIgnore = ignore;
    }

    public boolean doTraverse() {

	return doTraverse;
    }

    public void doTraverse(boolean traverse) {

	this.doTraverse = traverse;
    }

    public Object getAnything() {

	return anything;
    }

    public HtmlElement getHtmlElement() {

	return child;
    }

    public DocBookTransformer.DocumentElementType getCodeContext() {
	return codeContext;
    }

    public DocBookElement getCurrent() {

	return current;
    }

    public DocBookElement getParent() {

	return parent;
    }

    public DocBookTagFactory getTagFactory() {

	return transformer.getTagFactory();
    }

    public CharacterDataImpl getCharacterDataNode() {

	return characterDataNode;
    }

    public DocBookTransformer getTransformer() {
	return transformer;
    }

    public void setAnything(Object anything) {

	this.anything = anything;
    }

    public void setChild(HtmlElement child) {

	this.child = child;
    }

    public void setCodeContext(DocBookTransformer.DocumentElementType context) {

	this.codeContext = context;
    }

    public void setCurrent(DocBookElement current) {

	this.current = current;
    }

    public void setParent(DocBookElement parent) {

	this.parent = parent;
    }

    public void setCharacterDataNode(CharacterDataImpl characterDataNode) {

	this.characterDataNode = characterDataNode;
    }

    public void setTransformer(DocBookTransformer transformer) {
	this.transformer = transformer;
    }

    @Override
	public String toString() {

	String buffer = "";

	buffer += ("\nEditor values:\n" + "current.........: " + current + "\n"
		   + "parent..........: " + parent + "\n" + "child...........: " + child + "\n"
		   + "code context....: " + codeContext + "\n" + "do ignore.......: " + doIgnore
		   + "\n" + "do traverse.....: " + doTraverse + "\n");

	return buffer;
    }
}
