/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.tag.docbook.DocBookElement;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.Term;
import org.dbdoclet.trafo.tag.docbook.VarListEntry;
import org.dbdoclet.trafo.tag.docbook.VariableList;
import org.dbdoclet.xiphias.dom.ElementImpl;

public class DtEditor extends Editor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		DocBookElement entry = null;

		setValues(super.edit(values));
		DocBookTagFactory dbfactory = values.getTagFactory();

		if (getParent() instanceof VariableList) {

			entry = dbfactory.createVarListEntry();
			entry.setParentNode(getParent());
			getParent().appendChild(entry);

		} else if (getParent() instanceof VarListEntry) {

			setParent((DocBookElement) getParent().getParentNode());

			if ((getParent() != null) && getParent() instanceof VariableList) {

				getCurrent().appendChild(
						dbfactory.createListItem().appendChild(
								dbfactory.createPara().setFormatType(
										ElementImpl.FORMAT_INLINE)));

				entry = dbfactory.createVarListEntry();
				entry.setParentNode(getParent());
				getParent().appendChild(entry);
				
			} else {

				return finalizeValues();
			}
			
		} else {

			return finalizeValues();
		}

		Term term = dbfactory.createTerm();
		copyCommonAttributes(getHtmlElement(), term);
		
		setCurrent(term);
		getCurrent().setParentNode(entry);

		entry.appendChild(getCurrent());

		setParent(entry);
		setAnything(getCurrent());

		traverse(true);

		return finalizeValues();
	}
}
