/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.trafo.html.docbook.editor;

import org.dbdoclet.trafo.tag.docbook.DocBookElement;
import org.dbdoclet.trafo.tag.docbook.DocBookTagFactory;
import org.dbdoclet.trafo.tag.docbook.ListItem;
import org.dbdoclet.trafo.tag.docbook.Para;
import org.dbdoclet.trafo.tag.docbook.Term;
import org.dbdoclet.trafo.tag.docbook.VarListEntry;
import org.dbdoclet.trafo.tag.docbook.VariableList;

public class DdEditor extends Editor {

	@Override
	public EditorInstruction edit(EditorInstruction values)
			throws EditorException {

		DocBookElement list = null;

		setValues(super.edit(values));
		DocBookTagFactory dbfactory = values.getTagFactory();

		// Try to detect two sequenced dd tags.
		if (getParent() instanceof VariableList) {

			if (getAnything() instanceof ListItem) {

				list = (ListItem) getAnything();

			} else {

				VarListEntry entry = dbfactory.createVarListEntry();
				getParent().appendChild(entry);

				Term term = dbfactory.createTerm();
				entry.appendChild(term);

				list = dbfactory.createListItem();
				entry.appendChild(list);
			}

		} else if (getParent() instanceof VarListEntry) {

			list = dbfactory.createListItem();
			getParent().appendChild(list);
			setAnything(list);
			setParent((DocBookElement) getParent().getParentNode());
		} // end of else

		if (list == null) {

			return finalizeValues();
		} // end of else

		Para para = dbfactory.createPara();
		copyCommonAttributes(getHtmlElement(), para);
		setCurrent(para);
		list.appendChild(getCurrent());
		traverse(true);

		return finalizeValues();
	}
}
