package org.dbdoclet.trafo;

import java.io.File;
import java.io.IOException;

import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.dbdoclet.trafo.script.Script;
import org.dbdoclet.trafo.script.parser.TrafoScriptLexer;
import org.dbdoclet.trafo.script.parser.TrafoScriptParser;
import org.dbdoclet.trafo.script.parser.TrafoScriptWalker;

public class TrafoScriptManager {

	/**
	 * Parsen einer Skript-Datei.
	 * 
	 * @param scriptFile
	 * @return Script
	 * @throws TrafoException
	 */
	public static Script parseScript(File scriptFile) throws TrafoException {

		try {
			TrafoScriptLexer lex = new TrafoScriptLexer(new ANTLRFileStream(
					scriptFile.getAbsolutePath(), "UTF8"));
			return TrafoScriptManager.parseScript(lex);
		} catch (Exception oops) {
			throw new TrafoException(oops);
		}
	}

	/**
	 * Parsen eines Skript-Puffers.
	 * 
	 * @param scriptBuffer
	 * @return Script
	 * @throws IOException
	 * @throws RecognitionException
	 */
	public static Script parseScript(String scriptBuffer) throws IOException,
			RecognitionException {

		TrafoScriptLexer lex = new TrafoScriptLexer(new ANTLRStringStream(
				scriptBuffer));
		return TrafoScriptManager.parseScript(lex);
	}

	static Script parseScript(TrafoScriptLexer lex) throws RecognitionException {
		CommonTokenStream tokens = new CommonTokenStream(lex);

		TrafoScriptParser parser = new TrafoScriptParser(tokens);
		TrafoScriptParser.parse_return r = parser.parse();
		CommonTreeNodeStream nodes = new CommonTreeNodeStream(r.getTree());

		TrafoScriptWalker walker = new TrafoScriptWalker(nodes);
		walker.parse();

		Script script = walker.getScript();
		return script;
	}

}
