/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.service;

import java.text.MessageFormat;

/**
 * Die Klasse <code>MessageServices</code> stellt eine Sammlung statischer
 * Methoden zur Bearbeitung von Zeichenketten und/oder deren
 * Internationalisierung zur Verfügung.
 * 
 * @author <a href="mailto:michael.fuchs@unico-group.com">Michael Fuchs</a>
 * */

public class MessageServices {

    /**
     * Die Methode <code>format</code> formatiert eine Zeichenkette im Format
     * der Klasse <code>MessageFormat</code>.
     * 
     * Die Zeichenkette kann einen Platzhalter namens <code>{0}</code>
     * enthalten.
     * 
     * @param str
     *            a <code>String</code> value
     * @param arg1
     *            a <code>Object</code> value
     * @return a <code>String</code> value
     */
    public static String format(String str, Object arg1) {

	if (arg1 == null) {
	    arg1 = "(NULL Pointer)";
	}

	Object[] arguments = { arg1 };

	return MessageFormat.format(str, arguments);
    }

    /**
     * Die Methode <code>format</code> formatiert eine Zeichenkette im Format
     * der Klasse <code>MessageFormat</code>.
     * 
     * Die Zeichenkette kann zwei Platzhalter namens <code>{0}</code> und
     * <code>{1}</code> enthalten.
     * 
     * @param str
     *            a <code>String</code> value
     * @param arg1
     *            a <code>Object</code> value
     * @param arg2
     *            <code>Object</code>
     * @return a <code>String</code> value
     */
    public static String format(String str, Object arg1, Object arg2) {

	Object[] arguments = { arg1, arg2 };

	return MessageFormat.format(str, arguments);
    }

    /**
     * Die Methode <code>format</code> formatiert eine Zeichenkette im Format
     * der Klasse <code>MessageFormat</code>.
     * 
     * Die Zeichenkette kann einen Platzhalter namens <code>{0}</code>,
     * <code>{1}</code> und <code>{2}</code> enthalten.
     * 
     * @param str
     *            a <code>String</code> value
     * @param arg1
     *            a <code>Object</code> value
     * @param arg2
     *            <code>Object</code>
     * @param arg3
     *            <code>Object</code>
     * @return a <code>String</code> value
     */
    public static String format(String str, Object arg1, Object arg2, Object arg3) {

	Object[] arguments = { arg1, arg2, arg3 };

	return MessageFormat.format(str, arguments);
    }

    public static String format(String str, Object arg1, Object arg2, Object arg3, Object arg4) {

	Object[] arguments = { arg1, arg2, arg3, arg4 };
	return MessageFormat.format(str, arguments);
    }

    public static String format(String str, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {

	Object[] arguments = { arg1, arg2, arg3, arg4, arg5 };
	return MessageFormat.format(str, arguments);
    }

    public static String format(String str, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {

	Object[] arguments = { arg1, arg2, arg3, arg4, arg5, arg6 };
	return MessageFormat.format(str, arguments);
    }

    public static String format(String str, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {

	Object[] arguments = { arg1, arg2, arg3, arg4, arg5, arg6, arg7 };
	return MessageFormat.format(str, arguments);
    }

    public static String format(String str, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) {

	Object[] arguments = { arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8 };
	return MessageFormat.format(str, arguments);
    }

    public static String format(String str, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) {

	Object[] arguments = { arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9 };
	return MessageFormat.format(str, arguments);
    }
}
