/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.option;

import java.io.PrintWriter;
import java.io.StringWriter;



/**
 * Describe class <code>OptionException</code> here.
 *
 * @author <a href="mailto:mfuchs@unico-consulting.com">Michael Fuchs</a>
 * @version 1.0
 */
public class OptionException extends RuntimeException {

    private static final long serialVersionUID = 1L;

    private Exception cause;
    private String msg;

    /**
     * Creates a new <code>OptionException</code> instance.
     *
     * @param msg a <code>String</code> value
     */
    public OptionException(String msg) {

        super(msg);

        this.msg = msg;
        this.cause = null;
    }
    
    /**
     * Creates a new <code>OptionException</code> instance.
     *
     * @param oops an <code>Exception</code> value
     */
    public OptionException(Exception oops) {

        super(oops.getMessage());

        this.msg = "";
        this.cause = oops;
    }

    /**
     * Describe <code>getMessage</code> method here.
     *
     * @return an <code>Exception</code> value
     */
    public String getMessage() {

        if (cause == null) {
            return msg;
        } 

        StringWriter buffer = new StringWriter();
        cause.printStackTrace(new PrintWriter(buffer));
        return buffer.toString();
    }
}
/*
 * $Log$
 */
