/* 
 * Copyright (C) 2001-2012 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.option;

import java.io.File;

/**
 * Die Klasse <code>FileOption</code> verarbeitet ein Argument der
 * Kommandozeile, das eine Datei spezifiziert. 
 * 
 * @author michael
 * 
 */
public class FileOption extends Option<File> {

	private boolean isExisting = false;

	public FileOption() {

		super();
		hasArgument(true);
	}

	public FileOption(String longName) {

		super(longName);
		hasArgument(true);
	}

	public FileOption(String longName, String shortName) {

		super(longName, shortName);
		hasArgument(true);
	}

	@Override
	public void addValueFromString(String value) {
		addValue(new File(expandPath(value)));
	}

	public void isExisting(boolean value) {
		isExisting = value;
	}

	@Override
	public void setValueFromString(String value) {
		setValue(new File(expandPath(value)));
	}

	protected boolean checkArgument(String arg) {

		arg = expandPath(arg);
		
		File file = new File(arg);

		if (isExisting == true && file.exists() == false) {
			return false;
		}

		if (file.exists() == true && file.isFile() == false) {
			return false;
		}

		return true;
	}
	
	@Override
	public OptionType getType() {
		return OptionType.FILE;
	}
}
