/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: lzw.h,v 1.1.26.1 2004/07/09 01:54:26 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _LZW_CODEC_H
#define _LZW_CODEC_H

#include "hxtypes.h"
#include "hxresult.h"

class LZWCodec
{
protected:
    enum
    {
        kMaxLZWBits = 12,
        kMaxLZWVal  = 4096
    };

    /* Decompression member variables */
    BOOL   m_bFresh;
    BOOL   m_bPostClearCode;
    INT32  m_lCodeSize;
    INT32  m_lSetCodeSize;
    INT32  m_lMaxCode;
    INT32  m_lMaxCodeSize;
    INT32  m_lFirstCode;
    INT32  m_lOldCode;
    INT32  m_lClearCode;
    INT32  m_lEndCode;
    INT32  m_lTable[2][kMaxLZWVal];
    INT32  m_lStack[kMaxLZWVal << 1];
    INT32 *m_plStackPtr;

    /* Decompression input buffer variables */
    BYTE  *m_pCompressedBuffer;
    INT32  m_lCompressedBufferSize;
    INT32  m_lCompressedBytesCopied;
    BYTE  *m_pCurByte;
    INT32  m_lCurBit;
    INT32  m_lBytesInBuffer;
    BOOL   m_bFinished;
    BOOL   m_bSuspended;
    BOOL   m_bAllCompressedDataCopied;

    inline void ClearTables()
    {
        INT32 i;
        for (i = 0; i < m_lClearCode; i++)
        {
            m_lTable[0][i] = 0;
            m_lTable[1][i] = i;
        }
        for (; i < kMaxLZWVal; i++)
        {
            m_lTable[0][i] = m_lTable[1][i] = 0;
        }
    };

    inline INT32 GetCode()
    {
        /* Make copy of state variables in case we run out of data */
        BYTE  *pCurByte       = m_pCurByte;
        INT32  lCurBit        = m_lCurBit;
        INT32  lBytesInBuffer = m_lBytesInBuffer;

        // Check to make sure we have some data
        if (lBytesInBuffer < 0)
        {
            return -1;
        }

        INT32 lCode = 0;
        for (INT32 i = 0; i < m_lCodeSize; i++)
        {
            /* Copy the current bit */
            if (*pCurByte & (1 << lCurBit))
            {
                lCode |= 1 << i;
            }

            /* Increment the bit counter */
            lCurBit++;

            /* Update the buffer variables as necessary */
            if (lCurBit == 8)
            {
                if (lBytesInBuffer == 0 && i < m_lCodeSize - 1)
                {
                    return -1;
                }
                pCurByte++;
                lCurBit = 0;
                lBytesInBuffer--;
            }
        }

        /* We were successful, so update the state variables */
        m_pCurByte       = pCurByte;
        m_lCurBit        = lCurBit;
        m_lBytesInBuffer = lBytesInBuffer;

        return lCode;
    };
public:
    LZWCodec();

    ~LZWCodec();

    inline BOOL Finished()  { return m_bFinished;  }
    inline BOOL Suspended() { return m_bSuspended; }

    HX_RESULT SetCompressedBufferSize(INT32 lSize);
    HX_RESULT InitDecompress(INT32 lMinCodeBits);
    HX_RESULT AppendCompressedBuffer(BYTE *pBuffer, INT32 lBufLen);
    HX_RESULT LZWReadByte(INT32 &rlSymbol);
};

#endif
