/*-----------------------------------------------------------------------
  The Lazy Virtual Machine.

  Daan Leijen.

  Copyright 2001, Daan Leijen. All rights reserved. This file is
  distributed under the terms of the GNU Library General Public License.
-----------------------------------------------------------------------*/

/* $Id: primfloat.h 224 2004-05-06 18:45:09Z uust $ */
#ifndef _primfloat_h
#define _primfloat_h


#include "fail.h" /* just for [exn_arithmetic] */


floating_t float_of_string( const char* s );
long fp_near_int( double x ) ;

/*----------------------------------------------------------------------
-- IEEE floating point interface
----------------------------------------------------------------------*/
enum fp_round {
  fp_round_near,
  fp_round_up,
  fp_round_down,
  fp_round_zero,

  fp_round_count
};

enum fp_round fp_get_round( void );
enum fp_round fp_set_round( enum fp_round rnd );

long fp_sticky_mask( enum exn_arithmetic ex );
long fp_get_sticky( void );
long fp_set_sticky( long sticky );


long fp_trap_mask_default(void);
long fp_trap_mask( enum exn_arithmetic ex );
long fp_get_traps( void );
long fp_set_traps( long traps );

/* the following two functions can be called from
   a signal handler and should always succeed */
long fp_clear( void );
void fp_reset( void );
void fp_save( long* sticky, long* traps, enum fp_round* round );
void fp_restore( long sticky, long traps, enum fp_round round );

#endif /* _primfloat_h */
