/*-----------------------------------------------------------------------
  The Lazy Virtual Machine.

  Daan Leijen.

  Copyright 2001, Daan Leijen. All rights reserved. This file is
  distributed under the terms of the GNU Library General Public License.
-----------------------------------------------------------------------*/

/* $Id: primstring.c 215 2004-01-12 12:04:30Z cvs-3 $ */

#include "mlvalues.h"
#include "memory.h"
#include "alloc.h"
#include "fail.h"
#include "primstring.h"

value prim_string_of_chars( long len, value chars )
{
  CAMLparam1(chars);
  CAMLlocal2(str,charval);
  char* s;
  long i;

  str = alloc_string(len);
  s   = String_val(str);

  for( i = 0; i < len; i++ ) {
    if (Is_atom(chars)) break;
    if (!is_heap_val(chars)) break;
    while (Tag_val(chars) == Ind_tag) { chars = Field(chars,0); }
    if (Tag_val(chars) != 1) break;
    charval = Field(chars,0);
    while (is_heap_val(charval) && Tag_val(charval)==Ind_tag) { charval = Field(charval,0); }
    if (!Is_long(charval)) break;
    s[i] = (char)Long_val(charval);
    chars = Field(chars,1);
  }
  if (i < len) s[i] = 0;
  CAMLreturn(str);
}

value prim_chars_of_string( value str )
{
  CAMLparam1(str);
  CAMLlocal2(chars,cons);
  char* s;
  long  i;
  long len;

  chars = Atom(0);
  if (!is_heap_val(str) || Tag_val(str) != String_tag)
    raise_invalid_argument( "prim_chars_of_string" );

  len = string_length(str);
  s   = String_val(str);

  for( i = len-1; i >= 0; i-- ) {
    cons = alloc_small(2,1);
    Field(cons,0) = Val_long(s[i]);
    Field(cons,1) = chars;
    chars = cons;
  }

  CAMLreturn(chars);
}

long prim_string_length( value str )
{
  if (!is_heap_val(str) || Tag_val(str) != String_tag)
    raise_invalid_argument( "prim_string_length" );
  return string_length(str);
}
