/*
 * ha_logger.c utility to log a message to the logging daemon
 *
 * Copyright (C) 2004 Guochun Shi <gshi@ncsa.uiuc.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */
#include <portability.h>
#include <glib.h>
#include <clplumbing/cl_log.h>
#include <clplumbing/ipc.h>
#include <clplumbing/GSource.h>
#include <clplumbing/cl_malloc.h>
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <ha_config.h>
#include <clplumbing/loggingdaemon.h>
#include <syslog.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <errno.h>
#include <netinet/in.h>

#define EXIT_OK		0
#define EXIT_FAIL	1

int LogToDaemon(int priority, const char * buf, int bstrlen, gboolean use_pri_str);
void            cl_log(int priority, const char * fmt, ...) G_GNUC_PRINTF(2,3);
static void
usage(int argc, char** argv)
{
	printf("usage: "
	       "%s: [option] <destination> <message>\n\n"
	       "options:"
	       "	-E <entity> The message will be printed with the given entity\n"
	       "@destination  can be  either ha-log or ha-debug\n"
	       "@message is the message you want to log into file\n\n",
	       argv[0]);	
	return;
}
int
main(int argc, char** argv)
{
	int	priority; 
	char*	entity = NULL;
	int	c;
	char*	msg;
	char*	logtype;

	
	while (( c =getopt(argc, argv,"E:h")) != -1){
		switch(c){
			
		case 'E':
			entity = optarg;
			break;
		case 'h':
			usage(argc, argv);
			exit(1);		
		default:
			continue;
		}
		
	}
	
	if ( argc - optind != 2){
		cl_log(LOG_ERR, "Wrong argument");
		goto err_exit;
	}
	
	
	logtype = argv[optind];
	msg = argv[optind+1];
	
	if (entity != NULL){
		cl_log_set_entity(entity);		
	}
	
	if (strcmp(logtype, "ha-log") == 0){
		priority = LOG_INFO;
	} else if (strcmp(logtype, "ha-debug") == 0){
		priority = LOG_DEBUG;
	}else{
		goto err_exit;
	}
	
	if(!cl_log_test_logd()){
		return EXIT_FAIL;
	}
	
        if (LogToDaemon(priority, msg,strlen(msg), FALSE) == HA_OK){
		return EXIT_OK;
	}else {
		return EXIT_FAIL;
	}
	
 err_exit:
	usage(argc, argv);
	return(1);

}

