#!/bin/bash
#
# Copyright (C) 2004 Andrew Beekhof  <andrew@beekhof.net>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#

required_nodes=1
testdir=/usr/lib/heartbeat/crmtest
. ${testdir}/helper.sh || exit 1

while [ $iteration -lt $repeats ]; do
    iteration=`expr $iteration + 1`
    echo -ne "$test_type : Iteration $iteration of $repeats"
    echo "########### Begining iteration $iteration of $repeats ###########"
(

# make *sure* theres nothing left over from last time
crm-cleanup

#----

start_node $test_node_1

#----

do_cmd echo "Analyse CRMd startup"
do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search  -a -m 90 \
    -s "crmd(.*) State transition (.*) \-> S_ELECTION" \
    -s "crmd(.*) State transition (.*) \-> S_INTEGRATION" 
cts_assert "DC election on ${test_node_1} failed."

do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search  -a -m 900 \
    -s "Updating node state to member for ${test_node_1}" \
    -s "crmd(.*) State transition (.*) \-> S_IDLE" 
cts_assert "IDLE and CRMd join on ${test_node_1} failed."

do_cmd wait_for_state S_IDLE 30 $test_node_1 
cts_assert "S_IDLE not reached on $test_node_1 (startup)!"

#----

do_cmd echo Create the first constraint and wait for S_IDLE
crm_log_pos=$(stat -L -c %s $logfile)
do_cmd make_constraint $test_node_1 rsc1 can
cts_assert "Creation of first constraint failed."
do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search -a -m 120 \
    -s "crmd(.*) State transition (.*) \-> S_IDLE" 
#cts_assert S_IDLE not reached after first constraint created

#----

do_cmd echo Create the second constraint and wait for S_IDLE
crm_log_pos=$(stat -L -c %s $logfile)
do_cmd make_constraint $test_node_1 rsc2 can
cts_assert "Creation of second constraint failed."
do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search -a -m 120 \
    -s "crmd(.*) State transition (.*) \-> S_IDLE" 
#cts_assert S_IDLE not reached after second constraint created

#----

do_cmd echo Create the first resource and wait for S_IDLE after start
args="<nvpair id=\\\"bsc-ip-1\\\" name=\\\"ip\\\" value=\\\"${ip_rsc_1}\\\"/>"
args="$args <nvpair id=\\\"ident-string-1\\\" name=\\\"ident-string\\\" value=\\\"Linux-HA TEST configuration file - REMOVEME!!\\\"/>"
crm_log_pos=$(stat -L -c %s $logfile)
do_cmd make_resource $test_node_1 rsc1 ocf IPaddr - - - $args
cts_assert "Creation of first resource failed."
do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search -a -m 300 \
    -s "crmd(.*) State transition (.*) \-> S_IDLE"  \
    -s "crmd(.*) Performing op start(.*) on rsc1"
cts_assert S_IDLE not reached after first resource created

#----

do_cmd echo Create the second resource and wait for S_IDLE after start
args="<nvpair id=\\\"bsc-ip-2\\\" name=\\\"ip\\\" value=\\\"${ip_rsc_2}\\\"/>"
args="$args <nvpair id=\\\"ident-string-2\\\" name=\\\"ident-string\\\" value=\\\"Linux-HA TEST configuration file - REMOVEME!!\\\"/>"
crm_log_pos=$(stat -L -c %s $logfile)
do_cmd make_resource $test_node_1 rsc2 ocf IPaddr - - - $args
cts_assert "Creation of second resource failed."
do_cmd ${testdir}/testutils.pl -p $crm_log_pos -l ${logfile} --search -a -m 300 \
    -s "crmd(.*) State transition (.*) \-> S_IDLE"  \
    -s "crmd(.*) Performing op start(.*) on rsc2"
cts_assert S_IDLE not reached after second resource created

#----

do_cmd echo Check for S_IDLE, the DC and running resources
do_cmd wait_for_state S_IDLE 30 DC $test_node_1 
cts_assert "S_IDLE not reached on $test_node_1 after CIB create"

do_cmd is_running rsc1 $test_node_1
cts_assert "rsc1 NOT running"

do_cmd wait_for_state S_IDLE 30 $test_node_1 
cts_assert "S_IDLE not maintained on $test_node_1!"

do_cmd is_running rsc2 $test_node_1
cts_assert "rsc2 NOT running"

do_cmd is_dc $test_node_1
cts_assert "$test_node_1 is supposed to be the DC"

do_cmd is_running rsc1 $test_node_1 x$test_node_1
cts_assert_false "rsc1 IS running on x$test_node_1"

do_cmd is_running rsc1 $test_node_1 $test_node_1
cts_assert "rsc1 NOT running on $test_node_1"

do_cmd is_running rsc2 $test_node_1 $test_node_1
cts_assert "rsc2 NOT running on $test_node_1"

#----

stop_node $test_node_1 

#----
    
do_cmd remote_cmd $CRMD_USER $test_node_1 killall -9q crmd

echo "test: PASSED"
)

done
