#include <stdio.h>
#include "finitemap.h"

int cmp (int a, int b) { return (b-a); }

void
showItem (int key, int value)
{
  fprintf (stdout, "(%d)", key);
}

void
showFM (int i, FiniteMap fm)
{
  fprintf (stdout, "Tree %d\n",i);
  FM_traverse (fm, (FMTraversal)showItem);
  fprintf (stdout, "\n------\n\n");
}

void
debugFM (int i, FiniteMap fm)
{
  fprintf (stdout, "Tree %d\n",i);
  if (fm) Tree_debug(fm->root);
  fprintf (stdout, "\n------\n\n");
}

int
main ()
{
  int i;
  FiniteMap fm;
  fm = FM_new ((FMComparison)cmp, (FMFreeItem)0);
  showFM (0, fm);

  for (i=1; i<=65; i++) {
    FM_insert(fm,(cast)i,(cast)0);
    debugFM (i, fm);
  }

  exit(0);
}
