-- Low-level routines specifically for hat-detect.
module Detect
  ( findMain, edtNextChild
  , ParentSet, newParentSet
  , anySuspect
  ) where

import LowLevel (FileNode(..),nil,unevaluated
                ,SimpleNodeType(..),simpleNodeType,NodeType(..),nodeType)
import Foreign
import Numeric (showHex)

data PS
type ParentSet = Ptr PS

foreign import ccall newParentSet    :: FileNode -> IO ParentSet
foreign import ccall freeParentSet   :: ParentSet -> IO ()
foreign import ccall extendParentSet :: ParentSet -> FileNode -> IO ()

foreign import ccall findMain        :: IO FileNode
foreign import ccall nextChild       :: ParentSet -> IO FileNode
foreign import ccall anySuspect      :: FileNode -> IO Bool

-- For debugging:
-- foreign import ccall showParentSet   :: ParentSet -> IO ()

edtNextChild :: ParentSet -> IO FileNode
edtNextChild ps = do
 -- candidate ps
    c <- candidate ps
    b <- anySuspect c
    if c==LowLevel.nil || b then return c else edtNextChild ps
  where
  candidate ps = do
    c <- nextChild ps
 -- putStrLn ("edtNextChild: "++showHex (int c) "")
    if c==LowLevel.unevaluated	-- actually EOF
      then return LowLevel.nil
      else if c==LowLevel.nil
      then candidate ps
      else case simpleNodeType c of
        NodeConditional -> do extendParentSet ps c
                              --showParentSet ps
                              candidate ps
        NodeIdentifier  -> candidate ps
        NodeBasicValue  -> candidate ps
        NodeCAF         -> return c
        NodeApplication -> case nodeType c of
                             ExpApp      -> return c
                             ExpValueApp -> candidate ps
        NodeSugar       -> return c
        NodeSpecial     -> case nodeType c of
                             ExpProjection -> return c
                             _             -> do extendParentSet ps c
                                                 candidate ps
        _               -> error "unexpected node in edtNextChild"
