{-# OPTIONS_HADDOCK hide #-}
{-# OPTIONS_GHC -fno-warn-unused-imports #-}
-- -*-haskell-*-
-- -------------------- automatically generated file - do not edit ------------
--  Callback installers for the GIMP Toolkit (GTK) Binding for Haskell
--
--  Author : Axel Simon
--
--  Created: 1 July 2000
--
--  Copyright (C) 2000-2005 Axel Simon
--
--  This library is free software; you can redistribute it and/or
--  modify it under the terms of the GNU Lesser General Public
--  License as published by the Free Software Foundation; either
--  version 2.1 of the License, or (at your option) any later version.
--
--  This library is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
--  Lesser General Public License for more details.
--
-- #hide

-- These functions are used to connect signals to widgets. They are auto-
-- matically created through HookGenerator.hs which takes a list of possible
-- function signatures that are included in the GTK sources (gtkmarshal.list).
--
-- The object system in the second version of GTK is based on GObject from
-- GLIB. This base class is rather primitive in that it only implements
-- ref and unref methods (and others that are not interesting to us). If
-- the marshall list mentions OBJECT it refers to an instance of this
-- GObject which is automatically wrapped with a ref and unref call.
-- Structures which are not derived from GObject have to be passed as
-- BOXED which gives the signal connect function a possibility to do the
-- conversion into a proper ForeignPtr type. In special cases the signal
-- connect function use a PTR type which will then be mangled in the
-- user function directly. The latter is needed if a signal delivers a
-- pointer to a string and its length in a separate integer.
--
module Graphics.UI.Gtk.WebKit.Signals (
  module System.Glib.Signals,

  connect_PTR_PTR__NONE,
  connect_OBJECT__BOOL,
  connect_OBJECT_GLIBSTRING_BOXED__BOOL,
  connect_OBJECT__PTR,
  connect_INT_INT_GLIBSTRING__BOOL,
  connect_GLIBSTRING_GLIBSTRING_INT_GLIBSTRING__BOOL,
  connect_OBJECT_GLIBSTRING__BOOL,
  connect_OBJECT_GLIBSTRING_GLIBSTRING__BOOL,
  connect_OBJECT_OBJECT__BOOL,
  connect_OBJECT_OBJECT_OBJECT_OBJECT__BOOL,
  connect_OBJECT_OBJECT_GLIBSTRING_OBJECT__BOOL,
  connect_OBJECT_OBJECT_OBJECT_OBJECT__NONE,
  connect_OBJECT_OBJECT_MOBJECT_MOBJECT__NONE,
  connect_ENUM_INT__BOOL,
  connect_NONE__BOOL,
  connect_NONE__NONE,
  connect_MGLIBSTRING_MGLIBSTRING__NONE,
  connect_OBJECT_GLIBSTRING__NONE,
  connect_OBJECT_OBJECT__NONE,
  connect_GLIBSTRING_GLIBSTRING__NONE,
  connect_OBJECT__NONE,
  connect_INT__NONE,
  connect_GLIBSTRING__NONE,
  
  ) where

import Control.Monad	(liftM)

import System.Glib.FFI
import System.Glib.UTFString   (peekUTFString,maybePeekUTFString)
import qualified System.Glib.UTFString as Glib
import System.Glib.GError      (failOnGError)
{#import System.Glib.Signals#}
{#import System.Glib.GObject#}
import Graphics.UI.GtkInternals


{#context lib="gtk" prefix="gtk" #}


-- Here are the generators that turn a Haskell function into
-- a C function pointer. The fist Argument is always the widget,
-- the last one is the user g_pointer. Both are ignored.


connect_PTR_PTR__NONE :: 
  GObjectClass obj => SignalName ->
  ConnectAfter -> obj ->
  (Ptr a -> Ptr b -> IO ()) ->
  IO (ConnectId obj)
connect_PTR_PTR__NONE signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Ptr () -> Ptr () -> IO ()
        action _ ptr1 ptr2 =
          failOnGError $
          user (castPtr ptr1) (castPtr ptr2)

connect_OBJECT__BOOL :: 
  (GObjectClass a', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> IO Bool) ->
  IO (ConnectId obj)
connect_OBJECT__BOOL signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Ptr GObject -> IO Bool
        action _ obj1 =
          failOnGError $
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj1) >>= \obj1' ->
          user (unsafeCastGObject obj1')

connect_OBJECT_GLIBSTRING_BOXED__BOOL :: 
  (GObjectClass a', Glib.GlibString b', GObjectClass obj) => SignalName ->
  (Ptr c' -> IO c) -> 
  ConnectAfter -> obj ->
  (a' -> b' -> c -> IO Bool) ->
  IO (ConnectId obj)
connect_OBJECT_GLIBSTRING_BOXED__BOOL signal boxedPre3 after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Ptr GObject -> CString -> Ptr () -> IO Bool
        action _ obj1 str2 box3 =
          failOnGError $
          boxedPre3 (castPtr box3) >>= \box3' ->
          peekUTFString str2 >>= \str2' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj1) >>= \obj1' ->
          user (unsafeCastGObject obj1') str2' box3'

connect_OBJECT__PTR :: 
  (GObjectClass a', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> IO (Ptr b)) ->
  IO (ConnectId obj)
connect_OBJECT__PTR signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Ptr GObject -> IO (Ptr ())
        action _ obj1 =
          failOnGError $
          liftM castPtr $ 
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj1) >>= \obj1' ->
          user (unsafeCastGObject obj1')

connect_INT_INT_GLIBSTRING__BOOL :: 
  (Glib.GlibString c', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (Int -> Int -> c' -> IO Bool) ->
  IO (ConnectId obj)
connect_INT_INT_GLIBSTRING__BOOL signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Int -> Int -> CString -> IO Bool
        action _ int1 int2 str3 =
          failOnGError $
          peekUTFString str3 >>= \str3' ->
          user int1 int2 str3'

connect_GLIBSTRING_GLIBSTRING_INT_GLIBSTRING__BOOL :: 
  (Glib.GlibString a', Glib.GlibString b', Glib.GlibString d', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> b' -> Int -> d' -> IO Bool) ->
  IO (ConnectId obj)
connect_GLIBSTRING_GLIBSTRING_INT_GLIBSTRING__BOOL signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> CString -> CString -> Int -> CString -> IO Bool
        action _ str1 str2 int3 str4 =
          failOnGError $
          peekUTFString str4 >>= \str4' ->
          peekUTFString str2 >>= \str2' ->
          peekUTFString str1 >>= \str1' ->
          user str1' str2' int3 str4'

connect_OBJECT_GLIBSTRING__BOOL :: 
  (GObjectClass a', Glib.GlibString b', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> b' -> IO Bool) ->
  IO (ConnectId obj)
connect_OBJECT_GLIBSTRING__BOOL signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Ptr GObject -> CString -> IO Bool
        action _ obj1 str2 =
          failOnGError $
          peekUTFString str2 >>= \str2' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj1) >>= \obj1' ->
          user (unsafeCastGObject obj1') str2'

connect_OBJECT_GLIBSTRING_GLIBSTRING__BOOL :: 
  (GObjectClass a', Glib.GlibString b', Glib.GlibString c', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> b' -> c' -> IO Bool) ->
  IO (ConnectId obj)
connect_OBJECT_GLIBSTRING_GLIBSTRING__BOOL signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Ptr GObject -> CString -> CString -> IO Bool
        action _ obj1 str2 str3 =
          failOnGError $
          peekUTFString str3 >>= \str3' ->
          peekUTFString str2 >>= \str2' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj1) >>= \obj1' ->
          user (unsafeCastGObject obj1') str2' str3'

connect_OBJECT_OBJECT__BOOL :: 
  (GObjectClass a', GObjectClass b', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> b' -> IO Bool) ->
  IO (ConnectId obj)
connect_OBJECT_OBJECT__BOOL signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Ptr GObject -> Ptr GObject -> IO Bool
        action _ obj1 obj2 =
          failOnGError $
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj2) >>= \obj2' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj1) >>= \obj1' ->
          user (unsafeCastGObject obj1') (unsafeCastGObject obj2')

connect_OBJECT_OBJECT_OBJECT_OBJECT__BOOL :: 
  (GObjectClass a', GObjectClass b', GObjectClass c', GObjectClass d', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> b' -> c' -> d' -> IO Bool) ->
  IO (ConnectId obj)
connect_OBJECT_OBJECT_OBJECT_OBJECT__BOOL signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Ptr GObject -> Ptr GObject -> Ptr GObject -> Ptr GObject -> IO Bool
        action _ obj1 obj2 obj3 obj4 =
          failOnGError $
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj4) >>= \obj4' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj3) >>= \obj3' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj2) >>= \obj2' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj1) >>= \obj1' ->
          user (unsafeCastGObject obj1') (unsafeCastGObject obj2') (unsafeCastGObject obj3') (unsafeCastGObject obj4')

connect_OBJECT_OBJECT_GLIBSTRING_OBJECT__BOOL :: 
  (GObjectClass a', GObjectClass b', Glib.GlibString c', GObjectClass d', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> b' -> c' -> d' -> IO Bool) ->
  IO (ConnectId obj)
connect_OBJECT_OBJECT_GLIBSTRING_OBJECT__BOOL signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Ptr GObject -> Ptr GObject -> CString -> Ptr GObject -> IO Bool
        action _ obj1 obj2 str3 obj4 =
          failOnGError $
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj4) >>= \obj4' ->
          peekUTFString str3 >>= \str3' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj2) >>= \obj2' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj1) >>= \obj1' ->
          user (unsafeCastGObject obj1') (unsafeCastGObject obj2') str3' (unsafeCastGObject obj4')

connect_OBJECT_OBJECT_OBJECT_OBJECT__NONE :: 
  (GObjectClass a', GObjectClass b', GObjectClass c', GObjectClass d', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> b' -> c' -> d' -> IO ()) ->
  IO (ConnectId obj)
connect_OBJECT_OBJECT_OBJECT_OBJECT__NONE signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Ptr GObject -> Ptr GObject -> Ptr GObject -> Ptr GObject -> IO ()
        action _ obj1 obj2 obj3 obj4 =
          failOnGError $
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj4) >>= \obj4' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj3) >>= \obj3' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj2) >>= \obj2' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj1) >>= \obj1' ->
          user (unsafeCastGObject obj1') (unsafeCastGObject obj2') (unsafeCastGObject obj3') (unsafeCastGObject obj4')

connect_OBJECT_OBJECT_MOBJECT_MOBJECT__NONE :: 
  (GObjectClass a', GObjectClass b', GObjectClass c', GObjectClass d', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> b' -> Maybe c' -> Maybe d' -> IO ()) ->
  IO (ConnectId obj)
connect_OBJECT_OBJECT_MOBJECT_MOBJECT__NONE signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Ptr GObject -> Ptr GObject -> Ptr GObject -> Ptr GObject -> IO ()
        action _ obj1 obj2 obj3 obj4 =
          failOnGError $
          maybeNull (makeNewGObject (GObject, objectUnrefFromMainloop)) (return obj4) >>= \obj4' ->
          maybeNull (makeNewGObject (GObject, objectUnrefFromMainloop)) (return obj3) >>= \obj3' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj2) >>= \obj2' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj1) >>= \obj1' ->
          user (unsafeCastGObject obj1') (unsafeCastGObject obj2') (liftM unsafeCastGObject obj3') (liftM unsafeCastGObject obj4')

connect_ENUM_INT__BOOL :: 
  (Enum a, GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a -> Int -> IO Bool) ->
  IO (ConnectId obj)
connect_ENUM_INT__BOOL signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Int -> Int -> IO Bool
        action _ enum1 int2 =
          failOnGError $
          user (toEnum enum1) int2

connect_NONE__BOOL :: 
  GObjectClass obj => SignalName ->
  ConnectAfter -> obj ->
  (IO Bool) ->
  IO (ConnectId obj)
connect_NONE__BOOL signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> IO Bool
        action _ =
          failOnGError $
          user

connect_NONE__NONE :: 
  GObjectClass obj => SignalName ->
  ConnectAfter -> obj ->
  (IO ()) ->
  IO (ConnectId obj)
connect_NONE__NONE signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> IO ()
        action _ =
          failOnGError $
          user

connect_MGLIBSTRING_MGLIBSTRING__NONE :: 
  (Glib.GlibString a', Glib.GlibString b', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (Maybe a' -> Maybe b' -> IO ()) ->
  IO (ConnectId obj)
connect_MGLIBSTRING_MGLIBSTRING__NONE signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> CString -> CString -> IO ()
        action _ str1 str2 =
          failOnGError $
          maybePeekUTFString str2 >>= \str2' ->
          maybePeekUTFString str1 >>= \str1' ->
          user str1' str2'

connect_OBJECT_GLIBSTRING__NONE :: 
  (GObjectClass a', Glib.GlibString b', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> b' -> IO ()) ->
  IO (ConnectId obj)
connect_OBJECT_GLIBSTRING__NONE signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Ptr GObject -> CString -> IO ()
        action _ obj1 str2 =
          failOnGError $
          peekUTFString str2 >>= \str2' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj1) >>= \obj1' ->
          user (unsafeCastGObject obj1') str2'

connect_OBJECT_OBJECT__NONE :: 
  (GObjectClass a', GObjectClass b', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> b' -> IO ()) ->
  IO (ConnectId obj)
connect_OBJECT_OBJECT__NONE signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Ptr GObject -> Ptr GObject -> IO ()
        action _ obj1 obj2 =
          failOnGError $
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj2) >>= \obj2' ->
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj1) >>= \obj1' ->
          user (unsafeCastGObject obj1') (unsafeCastGObject obj2')

connect_GLIBSTRING_GLIBSTRING__NONE :: 
  (Glib.GlibString a', Glib.GlibString b', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> b' -> IO ()) ->
  IO (ConnectId obj)
connect_GLIBSTRING_GLIBSTRING__NONE signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> CString -> CString -> IO ()
        action _ str1 str2 =
          failOnGError $
          peekUTFString str2 >>= \str2' ->
          peekUTFString str1 >>= \str1' ->
          user str1' str2'

connect_OBJECT__NONE :: 
  (GObjectClass a', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> IO ()) ->
  IO (ConnectId obj)
connect_OBJECT__NONE signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Ptr GObject -> IO ()
        action _ obj1 =
          failOnGError $
          makeNewGObject (GObject, objectUnrefFromMainloop) (return obj1) >>= \obj1' ->
          user (unsafeCastGObject obj1')

connect_INT__NONE :: 
  GObjectClass obj => SignalName ->
  ConnectAfter -> obj ->
  (Int -> IO ()) ->
  IO (ConnectId obj)
connect_INT__NONE signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> Int -> IO ()
        action _ int1 =
          failOnGError $
          user int1

connect_GLIBSTRING__NONE :: 
  (Glib.GlibString a', GObjectClass obj) => SignalName ->
  ConnectAfter -> obj ->
  (a' -> IO ()) ->
  IO (ConnectId obj)
connect_GLIBSTRING__NONE signal after obj user =
  connectGeneric signal after obj action
  where action :: Ptr GObject -> CString -> IO ()
        action _ str1 =
          failOnGError $
          peekUTFString str1 >>= \str1' ->
          user str1'

