import Network.SMTP.ClientSession
import Network.SMTP.Client
import Network.Socket
import System.Time
import System.IO
import Data.Bits
import Data.IORef

myDomain = "example.com"
smtpHost = "hubert.blacksapphire.com"    -- <-- Your SMTP server here

-- This will send the author an email.  I don't mind!
main = do
    now <- getClockTime
    nowCT <- toCalendarTime now
    let message = Message [
                From [NameAddr (Just "Mr. Nobody") "nobody@example.com"],
                To   [NameAddr (Just "Stephen Blackheath") "unprintable.distances.stephen@blacksapphire.com"],
                Subject "I'm using SMTPClient!",
                Date nowCT
            ]
            ("Dear Sir,\n"++
             "It has come to my attention that this is an email.\n"++
             "Yours sincerely,\n"++
             "Mr. Nobody\n")
    addrs <- getAddrInfo Nothing (Just smtpHost) Nothing
    let SockAddrInet _ hostAddr = addrAddress (addrs !! 0)
        sockAddr = SockAddrInet (fromIntegral 25) hostAddr
    putStrLn $ "connecting to "++show sockAddr
    sentRef <- newIORef []
    sendSMTP' (hPutStrLn stderr) (Just sentRef) myDomain
        sockAddr [message]
    statuses <- readIORef sentRef
    -- If no exception was caught, statuses is guaranteed to be
    -- the same length as the list of input messages, therefore head won't fail here.
    case head statuses of
        Nothing     -> putStrLn "Message successfully sent"
        Just status -> putStrLn $ "Message send failed with status "++show status

