{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Xslt (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "xslt"
  , sFilename = "xslt.xml"
  , sShortname = "Xslt"
  , sContexts =
      fromList
        [ ( "CDATA"
          , Context
              { cName = "CDATA"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectIdentifier
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = StringDetect "]]>"
                      , rAttribute = BaseNTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = StringDetect "]]&gt;"
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Doctype"
          , Context
              { cName = "Doctype"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '>'
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '['
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "Doctype Internal Subset" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Doctype Internal Subset"
          , Context
              { cName = "Doctype Internal Subset"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar ']'
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "<!(ELEMENT|ENTITY|ATTLIST|NOTATION)\\b"
                              , reCompiled =
                                  Just (compileRegex True "<!(ELEMENT|ENTITY|ATTLIST|NOTATION)\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "Doctype Markupdecl" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "<!--"
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "comment" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "<\\?[\\w:_-]*"
                              , reCompiled = Just (compileRegex True "<\\?[\\w:_-]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "PI" ) ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "xslt" , "FindPEntityRefs" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Doctype Markupdecl"
          , Context
              { cName = "Doctype Markupdecl"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '>'
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "Doctype Markupdecl DQ" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "Doctype Markupdecl SQ" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Doctype Markupdecl DQ"
          , Context
              { cName = "Doctype Markupdecl DQ"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "xslt" , "FindPEntityRefs" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Doctype Markupdecl SQ"
          , Context
              { cName = "Doctype Markupdecl SQ"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "xslt" , "FindPEntityRefs" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "FindPEntityRefs"
          , Context
              { cName = "FindPEntityRefs"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "&(#[0-9]+|#[xX][0-9A-Fa-f]+|[A-Za-z_:][\\w.:_-]*);"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "&(#[0-9]+|#[xX][0-9A-Fa-f]+|[A-Za-z_:][\\w.:_-]*);")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "%[A-Za-z_:][\\w.:_-]*;"
                              , reCompiled = Just (compileRegex True "%[A-Za-z_:][\\w.:_-]*;")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = AnyChar "&%"
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "PI"
          , Context
              { cName = "PI"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '?' '>'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "attrValue"
          , Context
              { cName = "attrValue"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '/' '>'
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '>'
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "string" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "sqstring" ) ]
                      }
                  ]
              , cAttribute = ErrorTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "attributes"
          , Context
              { cName = "attributes"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '/' '>'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '>'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\s*=\\s*"
                              , reCompiled = Just (compileRegex True "\\s*=\\s*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "attrValue" ) ]
                      }
                  ]
              , cAttribute = OtherTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "comment"
          , Context
              { cName = "comment"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = StringDetect "-->"
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "-(-(?!->))+"
                              , reCompiled = Just (compileRegex True "-(-(?!->))+")
                              , reCaseSensitive = True
                              }
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "(FIXME|TODO|HACK)"
                              , reCompiled = Just (compileRegex True "(FIXME|TODO|HACK)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = AlertTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "detectEntRef"
          , Context
              { cName = "detectEntRef"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "&(#[0-9]+|#[xX][0-9A-Fa-f]+|[A-Za-z_:][\\w.:_-]*);"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "&(#[0-9]+|#[xX][0-9A-Fa-f]+|[A-Za-z_:][\\w.:_-]*);")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "normalText"
          , Context
              { cName = "normalText"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = StringDetect "<!--"
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "comment" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "<![CDATA["
                      , rAttribute = BaseNTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "CDATA" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "<!DOCTYPE\\s+"
                              , reCompiled = Just (compileRegex True "<!DOCTYPE\\s+")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "Doctype" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "<\\?[\\w:_-]*"
                              , reCompiled = Just (compileRegex True "<\\?[\\w:_-]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "PI" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '<'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "tagname" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "&(#[0-9]+|#[xX][0-9A-Fa-f]+|[A-Za-z_:][\\w.:_-]*);"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "&(#[0-9]+|#[xX][0-9A-Fa-f]+|[A-Za-z_:][\\w.:_-]*);")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "sqstring"
          , Context
              { cName = "sqstring"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '{'
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "sqxpath" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "xslt" , "detectEntRef" )
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "sqxpath"
          , Context
              { cName = "sqxpath"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !\"%&()*+,./;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "boolean"
                               , "ceiling"
                               , "concat"
                               , "contains"
                               , "count"
                               , "current"
                               , "document"
                               , "element-available"
                               , "false"
                               , "floor"
                               , "format-number"
                               , "function-available"
                               , "generate-id"
                               , "id"
                               , "key"
                               , "lang"
                               , "last"
                               , "local-name"
                               , "name"
                               , "namespace-uri"
                               , "normalize-space"
                               , "not"
                               , "number"
                               , "position"
                               , "round"
                               , "starts-with"
                               , "string"
                               , "string-length"
                               , "substring"
                               , "substring-after"
                               , "substring-before"
                               , "sum"
                               , "system-property"
                               , "text"
                               , "translate"
                               , "true"
                               , "unparsed-entity-uri"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !\"%&()*+,./;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "abs"
                               , "adjust-date-to-timezone"
                               , "adjust-dateTime-to-timezone"
                               , "adjust-time-to-timezone"
                               , "avg"
                               , "base-uri"
                               , "codepoints-to-string"
                               , "collection"
                               , "compare"
                               , "current-date"
                               , "current-dateTime"
                               , "current-group"
                               , "current-grouping-key"
                               , "current-time"
                               , "data"
                               , "dateTime"
                               , "day-from-date"
                               , "day-from-dateTime"
                               , "days-from-duration"
                               , "deep-equal"
                               , "default-collation"
                               , "distinct-values"
                               , "doc"
                               , "document-uri"
                               , "empty"
                               , "ends-with"
                               , "error"
                               , "escape-uri"
                               , "exactly-one"
                               , "exists"
                               , "expanded-QName"
                               , "format-date"
                               , "format-dateTime"
                               , "format-time"
                               , "hours-from-dateTime"
                               , "hours-from-duration"
                               , "hours-from-time"
                               , "idref"
                               , "implicit-timezone"
                               , "in-scope-prefixes"
                               , "index-of"
                               , "input"
                               , "insert-before"
                               , "local-name-from-QName"
                               , "lower-case"
                               , "matches"
                               , "max"
                               , "min"
                               , "minutes-from-dateTime"
                               , "minutes-from-duration"
                               , "minutes-from-time"
                               , "month-from-date"
                               , "month-from-dateTime"
                               , "months-from-duration"
                               , "namespace-uri-for-prefix"
                               , "namespace-uri-from-QName"
                               , "node-kind"
                               , "node-name"
                               , "normalize-unicode"
                               , "one-or-more"
                               , "QName"
                               , "regex-group"
                               , "remove"
                               , "replace"
                               , "resolve-QName"
                               , "resolve-uri"
                               , "reverse"
                               , "root"
                               , "round-half-to-even"
                               , "seconds-from-dateTime"
                               , "seconds-from-duration"
                               , "seconds-from-time"
                               , "sequence-node-identical"
                               , "static-base-uri"
                               , "string-join"
                               , "string-to-codepoints"
                               , "subsequence"
                               , "subtract-dates-yielding-dayTimeDuration"
                               , "subtract-dates-yielding-yearMonthDuration"
                               , "subtract-dateTimes-yielding-dayTimeDuration"
                               , "subtract-dateTimes-yielding-yearMonthDuration"
                               , "timezone-from-date"
                               , "timezone-from-dateTime"
                               , "timezone-from-time"
                               , "tokenize"
                               , "trace"
                               , "unordered"
                               , "unparsed-entity-public-id"
                               , "unparsed-text"
                               , "upper-case"
                               , "year-from-date"
                               , "year-from-dateTime"
                               , "years-from-duration"
                               , "zero-or-one"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "(ancestor|ancestor-or-self|attribute|child|descendant|descendant-or-self|following|following-sibling|namespace|parent|preceding|preceding-sibling|self)::"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "(ancestor|ancestor-or-self|attribute|child|descendant|descendant-or-self|following|following-sibling|namespace|parent|preceding|preceding-sibling|self)::")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "xpathstring" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "@[A-Za-z_:][\\w.:_-]*"
                              , reCompiled = Just (compileRegex True "@[A-Za-z_:][\\w.:_-]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\$[A-Za-z_:][\\w.:_-]*"
                              , reCompiled = Just (compileRegex True "\\$[A-Za-z_:][\\w.:_-]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[A-Za-z_:][\\w.:_-]*"
                              , reCompiled = Just (compileRegex True "[A-Za-z_:][\\w.:_-]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "xslt" , "detectEntRef" )
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = OtherTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "sqxpathstring"
          , Context
              { cName = "sqxpathstring"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "xslt" , "detectEntRef" )
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "string"
          , Context
              { cName = "string"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '{'
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "xpath" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "xslt" , "detectEntRef" )
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "tagname"
          , Context
              { cName = "tagname"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !\"%&()*+,./;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "xsl:apply-imports"
                               , "xsl:apply-templates"
                               , "xsl:attribute"
                               , "xsl:attribute-set"
                               , "xsl:call-template"
                               , "xsl:choose"
                               , "xsl:comment"
                               , "xsl:copy"
                               , "xsl:copy-of"
                               , "xsl:decimal-format"
                               , "xsl:element"
                               , "xsl:fallback"
                               , "xsl:for-each"
                               , "xsl:if"
                               , "xsl:import"
                               , "xsl:include"
                               , "xsl:key"
                               , "xsl:message"
                               , "xsl:namespace-alias"
                               , "xsl:number"
                               , "xsl:otherwise"
                               , "xsl:output"
                               , "xsl:param"
                               , "xsl:preserve-space"
                               , "xsl:processing-instruction"
                               , "xsl:sort"
                               , "xsl:strip-space"
                               , "xsl:stylesheet"
                               , "xsl:template"
                               , "xsl:text"
                               , "xsl:transform"
                               , "xsl:value-of"
                               , "xsl:variable"
                               , "xsl:when"
                               , "xsl:with-param"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "xattributes" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !\"%&()*+,./;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "xsl:analyze-string"
                               , "xsl:character-map"
                               , "xsl:document"
                               , "xsl:for-each-group"
                               , "xsl:function"
                               , "xsl:import-schema"
                               , "xsl:matching-substring"
                               , "xsl:namespace"
                               , "xsl:next-match"
                               , "xsl:non-matching-substring"
                               , "xsl:output-character"
                               , "xsl:perform-sort"
                               , "xsl:result-document"
                               , "xsl:sequence"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "xattributes" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\s*"
                              , reCompiled = Just (compileRegex True "\\s*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "attributes" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '>'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = KeywordTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "xattrValue"
          , Context
              { cName = "xattrValue"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '/' '>'
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '>'
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "xpath" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "sqxpath" ) ]
                      }
                  ]
              , cAttribute = ErrorTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "xattributes"
          , Context
              { cName = "xattributes"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '/' '>'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '>'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "select\\s*=\\s*"
                              , reCompiled = Just (compileRegex True "select\\s*=\\s*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "xattrValue" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "test\\s*=\\s*"
                              , reCompiled = Just (compileRegex True "test\\s*=\\s*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "xattrValue" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "match\\s*=\\s*"
                              , reCompiled = Just (compileRegex True "match\\s*=\\s*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "xattrValue" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\s*=\\s*"
                              , reCompiled = Just (compileRegex True "\\s*=\\s*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "attrValue" ) ]
                      }
                  ]
              , cAttribute = OtherTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "xpath"
          , Context
              { cName = "xpath"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !\"%&()*+,./;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "boolean"
                               , "ceiling"
                               , "concat"
                               , "contains"
                               , "count"
                               , "current"
                               , "document"
                               , "element-available"
                               , "false"
                               , "floor"
                               , "format-number"
                               , "function-available"
                               , "generate-id"
                               , "id"
                               , "key"
                               , "lang"
                               , "last"
                               , "local-name"
                               , "name"
                               , "namespace-uri"
                               , "normalize-space"
                               , "not"
                               , "number"
                               , "position"
                               , "round"
                               , "starts-with"
                               , "string"
                               , "string-length"
                               , "substring"
                               , "substring-after"
                               , "substring-before"
                               , "sum"
                               , "system-property"
                               , "text"
                               , "translate"
                               , "true"
                               , "unparsed-entity-uri"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !\"%&()*+,./;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "abs"
                               , "adjust-date-to-timezone"
                               , "adjust-dateTime-to-timezone"
                               , "adjust-time-to-timezone"
                               , "avg"
                               , "base-uri"
                               , "codepoints-to-string"
                               , "collection"
                               , "compare"
                               , "current-date"
                               , "current-dateTime"
                               , "current-group"
                               , "current-grouping-key"
                               , "current-time"
                               , "data"
                               , "dateTime"
                               , "day-from-date"
                               , "day-from-dateTime"
                               , "days-from-duration"
                               , "deep-equal"
                               , "default-collation"
                               , "distinct-values"
                               , "doc"
                               , "document-uri"
                               , "empty"
                               , "ends-with"
                               , "error"
                               , "escape-uri"
                               , "exactly-one"
                               , "exists"
                               , "expanded-QName"
                               , "format-date"
                               , "format-dateTime"
                               , "format-time"
                               , "hours-from-dateTime"
                               , "hours-from-duration"
                               , "hours-from-time"
                               , "idref"
                               , "implicit-timezone"
                               , "in-scope-prefixes"
                               , "index-of"
                               , "input"
                               , "insert-before"
                               , "local-name-from-QName"
                               , "lower-case"
                               , "matches"
                               , "max"
                               , "min"
                               , "minutes-from-dateTime"
                               , "minutes-from-duration"
                               , "minutes-from-time"
                               , "month-from-date"
                               , "month-from-dateTime"
                               , "months-from-duration"
                               , "namespace-uri-for-prefix"
                               , "namespace-uri-from-QName"
                               , "node-kind"
                               , "node-name"
                               , "normalize-unicode"
                               , "one-or-more"
                               , "QName"
                               , "regex-group"
                               , "remove"
                               , "replace"
                               , "resolve-QName"
                               , "resolve-uri"
                               , "reverse"
                               , "root"
                               , "round-half-to-even"
                               , "seconds-from-dateTime"
                               , "seconds-from-duration"
                               , "seconds-from-time"
                               , "sequence-node-identical"
                               , "static-base-uri"
                               , "string-join"
                               , "string-to-codepoints"
                               , "subsequence"
                               , "subtract-dates-yielding-dayTimeDuration"
                               , "subtract-dates-yielding-yearMonthDuration"
                               , "subtract-dateTimes-yielding-dayTimeDuration"
                               , "subtract-dateTimes-yielding-yearMonthDuration"
                               , "timezone-from-date"
                               , "timezone-from-dateTime"
                               , "timezone-from-time"
                               , "tokenize"
                               , "trace"
                               , "unordered"
                               , "unparsed-entity-public-id"
                               , "unparsed-text"
                               , "upper-case"
                               , "year-from-date"
                               , "year-from-dateTime"
                               , "years-from-duration"
                               , "zero-or-one"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "(ancestor|ancestor-or-self|attribute|child|descendant|descendant-or-self|following|following-sibling|namespace|parent|preceding|preceding-sibling|self)::"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "(ancestor|ancestor-or-self|attribute|child|descendant|descendant-or-self|following|following-sibling|namespace|parent|preceding|preceding-sibling|self)::")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "xslt" , "sqxpathstring" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "@[A-Za-z_:][\\w.:_-]*"
                              , reCompiled = Just (compileRegex True "@[A-Za-z_:][\\w.:_-]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\$[A-Za-z_:][\\w.:_-]*"
                              , reCompiled = Just (compileRegex True "\\$[A-Za-z_:][\\w.:_-]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[A-Za-z_:][\\w.:_-]*"
                              , reCompiled = Just (compileRegex True "[A-Za-z_:][\\w.:_-]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "xslt" , "detectEntRef" )
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = OtherTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "xpathstring"
          , Context
              { cName = "xpathstring"
              , cSyntax = "xslt"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "xslt" , "detectEntRef" )
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Peter Lammich (views@gmx.de)"
  , sVersion = "2"
  , sLicense = "LGPL"
  , sExtensions = [ "*.xsl" , "*.xslt" ]
  , sStartingContext = "normalText"
  }
