{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Tcl (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "Tcl/Tk"
  , sFilename = "tcl.xml"
  , sShortname = "Tcl"
  , sContexts =
      fromList
        [ ( "Base"
          , Context
              { cName = "Base"
              , cSyntax = "Tcl/Tk"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "#\\s*BEGIN.*$"
                              , reCompiled = Just (compileRegex True "#\\s*BEGIN.*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = RegionMarkerTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "#\\s*END.*$"
                              , reCompiled = Just (compileRegex True "#\\s*END.*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = RegionMarkerTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "AppleScript"
                               , "OptProc"
                               , "after"
                               , "append"
                               , "argc"
                               , "argv"
                               , "array"
                               , "auto_execk"
                               , "auto_execok"
                               , "auto_import"
                               , "auto_load"
                               , "auto_mkindex"
                               , "auto_mkindex_old"
                               , "auto_path"
                               , "auto_qualify"
                               , "auto_reset"
                               , "beep"
                               , "bell"
                               , "bgerror"
                               , "binary"
                               , "bind"
                               , "bindtags"
                               , "break"
                               , "button"
                               , "canvas"
                               , "case"
                               , "catch"
                               , "cd"
                               , "chan"
                               , "checkbutton"
                               , "clipboard"
                               , "clock"
                               , "close"
                               , "combobox"
                               , "concat"
                               , "console"
                               , "continue"
                               , "dde"
                               , "destroy"
                               , "dict"
                               , "else"
                               , "elseif"
                               , "encoding"
                               , "entry"
                               , "env"
                               , "eof"
                               , "error"
                               , "errorCode"
                               , "errorInfo"
                               , "eval"
                               , "event"
                               , "exec"
                               , "exit"
                               , "expr"
                               , "fblocked"
                               , "fconfigure"
                               , "fcopy"
                               , "file"
                               , "fileevent"
                               , "flush"
                               , "focus"
                               , "font"
                               , "for"
                               , "foreach"
                               , "format"
                               , "frame"
                               , "gets"
                               , "glob"
                               , "global"
                               , "grab"
                               , "grid"
                               , "history"
                               , "if"
                               , "image"
                               , "incr"
                               , "info"
                               , "interp"
                               , "join"
                               , "label"
                               , "labelframe"
                               , "lappend"
                               , "lassign"
                               , "lindex"
                               , "linsert"
                               , "list"
                               , "listbox"
                               , "llength"
                               , "load"
                               , "lower"
                               , "lrange"
                               , "lremove"
                               , "lrepeat"
                               , "lreplace"
                               , "lreverse"
                               , "lsearch"
                               , "lset"
                               , "lsort"
                               , "menu"
                               , "menubutton"
                               , "message"
                               , "namespace"
                               , "notebook"
                               , "open"
                               , "option"
                               , "pack"
                               , "package"
                               , "panedwindow"
                               , "parray"
                               , "pid"
                               , "pkg_mkIndex"
                               , "place"
                               , "proc"
                               , "progressbar"
                               , "puts"
                               , "pwd"
                               , "radiobutton"
                               , "raise"
                               , "read"
                               , "regexp"
                               , "registry"
                               , "regsub"
                               , "rename"
                               , "resource"
                               , "return"
                               , "scale"
                               , "scan"
                               , "scrollbar"
                               , "seek"
                               , "selection"
                               , "send"
                               , "separator"
                               , "set"
                               , "sizegrip"
                               , "socket"
                               , "source"
                               , "spinbox"
                               , "split"
                               , "string"
                               , "style"
                               , "subst"
                               , "switch"
                               , "tclLog"
                               , "tcl_endOfWord"
                               , "tcl_findLibrary"
                               , "tcl_library"
                               , "tcl_patchLevel"
                               , "tcl_platform"
                               , "tcl_precision"
                               , "tcl_rcFileName"
                               , "tcl_rcRsrcName"
                               , "tcl_startOfNextWord"
                               , "tcl_startOfPreviousWord"
                               , "tcl_traceCompile"
                               , "tcl_traceExec"
                               , "tcl_version"
                               , "tcl_wordBreakAfter"
                               , "tcl_wordBreakBefore"
                               , "tell"
                               , "text"
                               , "time"
                               , "tk"
                               , "tkTabToWindow"
                               , "tk_chooseColor"
                               , "tk_chooseDirectory"
                               , "tk_focusFollowMouse"
                               , "tk_focusNext"
                               , "tk_focusPrev"
                               , "tk_getOpenFile"
                               , "tk_getSaveFile"
                               , "tk_library"
                               , "tk_menuSetFocus"
                               , "tk_messageBox"
                               , "tk_optionMenu"
                               , "tk_patchLevel"
                               , "tk_popup"
                               , "tk_strictMotif"
                               , "tk_textCopy"
                               , "tk_textCut"
                               , "tk_textPaste"
                               , "tk_version"
                               , "tkwait"
                               , "toplevel"
                               , "trace"
                               , "traverseTo"
                               , "treeview"
                               , "unknown"
                               , "unload"
                               , "unset"
                               , "update"
                               , "uplevel"
                               , "upvar"
                               , "variable"
                               , "vwait"
                               , "while"
                               , "winfo"
                               , "wm"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "activate"
                               , "actual"
                               , "add"
                               , "addtag"
                               , "append"
                               , "appname"
                               , "args"
                               , "aspect"
                               , "atime"
                               , "atom"
                               , "atomname"
                               , "attributes"
                               , "bbox"
                               , "bind"
                               , "body"
                               , "broadcast"
                               , "bytelength"
                               , "cancel"
                               , "canvasx"
                               , "canvasy"
                               , "caret"
                               , "cells"
                               , "cget"
                               , "channels"
                               , "children"
                               , "class"
                               , "clear"
                               , "clicks"
                               , "client"
                               , "clone"
                               , "cmdcount"
                               , "colormapfull"
                               , "colormapwindows"
                               , "command"
                               , "commands"
                               , "compare"
                               , "complete"
                               , "configure"
                               , "containing"
                               , "convertfrom"
                               , "convertto"
                               , "coords"
                               , "copy"
                               , "create"
                               , "current"
                               , "curselection"
                               , "dchars"
                               , "debug"
                               , "default"
                               , "deiconify"
                               , "delete"
                               , "delta"
                               , "depth"
                               , "deselect"
                               , "dirname"
                               , "dlineinfo"
                               , "dtag"
                               , "dump"
                               , "edit"
                               , "entrycget"
                               , "entryconfigure"
                               , "equal"
                               , "executable"
                               , "exists"
                               , "extension"
                               , "families"
                               , "find"
                               , "first"
                               , "flash"
                               , "focus"
                               , "focusmodel"
                               , "forget"
                               , "format"
                               , "fpixels"
                               , "fraction"
                               , "frame"
                               , "functions"
                               , "generate"
                               , "geometry"
                               , "get"
                               , "gettags"
                               , "globals"
                               , "grid"
                               , "group"
                               , "handle"
                               , "height"
                               , "hide"
                               , "hostname"
                               , "iconbitmap"
                               , "iconify"
                               , "iconmask"
                               , "iconname"
                               , "iconposition"
                               , "iconwindow"
                               , "icursor"
                               , "id"
                               , "identify"
                               , "idle"
                               , "ifneeded"
                               , "image"
                               , "index"
                               , "info"
                               , "insert"
                               , "interps"
                               , "inuse"
                               , "invoke"
                               , "is"
                               , "isdirectory"
                               , "isfile"
                               , "ismapped"
                               , "itemcget"
                               , "itemconfigure"
                               , "join"
                               , "keys"
                               , "last"
                               , "length"
                               , "level"
                               , "library"
                               , "link"
                               , "loaded"
                               , "locals"
                               , "lower"
                               , "lstat"
                               , "manager"
                               , "map"
                               , "mark"
                               , "match"
                               , "maxsize"
                               , "measure"
                               , "metrics"
                               , "minsize"
                               , "mkdir"
                               , "move"
                               , "mtime"
                               , "name"
                               , "nameofexecutable"
                               , "names"
                               , "nativename"
                               , "nearest"
                               , "normalize"
                               , "number"
                               , "overrideredirect"
                               , "own"
                               , "owned"
                               , "panecget"
                               , "paneconfigure"
                               , "panes"
                               , "parent"
                               , "patchlevel"
                               , "pathname"
                               , "pathtype"
                               , "pixels"
                               , "pointerx"
                               , "pointerxy"
                               , "pointery"
                               , "positionfrom"
                               , "post"
                               , "postcascade"
                               , "postscript"
                               , "present"
                               , "procs"
                               , "protocol"
                               , "provide"
                               , "proxy"
                               , "raise"
                               , "range"
                               , "readable"
                               , "readlink"
                               , "release"
                               , "remove"
                               , "rename"
                               , "repeat"
                               , "replace"
                               , "reqheight"
                               , "require"
                               , "reqwidth"
                               , "resizable"
                               , "rgb"
                               , "rootname"
                               , "rootx"
                               , "rooty"
                               , "scale"
                               , "scaling"
                               , "scan"
                               , "screen"
                               , "screencells"
                               , "screendepth"
                               , "screenheight"
                               , "screenmmheight"
                               , "screenmmwidth"
                               , "screenvisual"
                               , "screenwidth"
                               , "script"
                               , "search"
                               , "seconds"
                               , "see"
                               , "select"
                               , "selection"
                               , "separator"
                               , "server"
                               , "set"
                               , "sharedlibextension"
                               , "show"
                               , "size"
                               , "sizefrom"
                               , "split"
                               , "stackorder"
                               , "stat"
                               , "state"
                               , "status"
                               , "system"
                               , "tag"
                               , "tail"
                               , "tclversion"
                               , "title"
                               , "tolower"
                               , "toplevel"
                               , "totitle"
                               , "toupper"
                               , "transient"
                               , "trim"
                               , "trimleft"
                               , "trimright"
                               , "type"
                               , "types"
                               , "unknown"
                               , "unpost"
                               , "useinputmethods"
                               , "validate"
                               , "values"
                               , "variable"
                               , "vars"
                               , "vcompare"
                               , "vdelete"
                               , "versions"
                               , "viewable"
                               , "vinfo"
                               , "visual"
                               , "visualid"
                               , "visualsavailable"
                               , "volumes"
                               , "vrootheight"
                               , "vrootwidth"
                               , "vrootx"
                               , "vrooty"
                               , "vsatisfies"
                               , "width"
                               , "window"
                               , "windowingsystem"
                               , "withdraw"
                               , "wordend"
                               , "wordstart"
                               , "writable"
                               , "x"
                               , "xview"
                               , "y"
                               ])
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Float
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\\\."
                              , reCompiled = Just (compileRegex True "\\\\.")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\s-\\w+"
                              , reCompiled = Just (compileRegex True "\\s-\\w+")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\$\\{([^\\}]|\\\\\\})+\\}"
                              , reCompiled =
                                  Just (compileRegex True "\\$\\{([^\\}]|\\\\\\})+\\}")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\$(::|\\w)+"
                              , reCompiled = Just (compileRegex True "\\$(::|\\w)+")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\"{2}"
                              , reCompiled = Just (compileRegex True "\"{2}")
                              , reCaseSensitive = True
                              }
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\""
                              , reCompiled = Just (compileRegex True "\"")
                              , reCaseSensitive = True
                              }
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Tcl/Tk" , "String" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar ';'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Tcl/Tk" , "New command line" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Tcl/Tk" , "Comment" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '{'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '['
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar ']'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Comment"
          , Context
              { cName = "Comment"
              , cSyntax = "Tcl/Tk"
              , cRules = []
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "New command line"
          , Context
              { cName = "New command line"
              , cSyntax = "Tcl/Tk"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\s*#"
                              , reCompiled = Just (compileRegex True "\\s*#")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Tcl/Tk" , "Comment" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "."
                              , reCompiled = Just (compileRegex True ".")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = True
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "String"
          , Context
              { cName = "String"
              , cSyntax = "Tcl/Tk"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\\\."
                              , reCompiled = Just (compileRegex True "\\\\.")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = ""
  , sVersion = "3"
  , sLicense = "BSD"
  , sExtensions = [ "*.tcl" , "*.tk" ]
  , sStartingContext = "Base"
  }
