{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.SqlPostgresql (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "SQL (PostgreSQL)"
  , sFilename = "sql-postgresql.xml"
  , sShortname = "SqlPostgresql"
  , sContexts =
      fromList
        [ ( "CreateFunction"
          , Context
              { cName = "CreateFunction"
              , cSyntax = "SQL (PostgreSQL)"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\$([^\\$\\n\\r]*)\\$"
                              , reCompiled = Nothing
                              , reCaseSensitive = False
                              }
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "SQL (PostgreSQL)" , "FunctionBody" ) ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "SQL (PostgreSQL)" , "Normal" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "FunctionBody"
          , Context
              { cName = "FunctionBody"
              , cSyntax = "SQL (PostgreSQL)"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\$%1\\$"
                              , reCompiled = Nothing
                              , reCaseSensitive = False
                              }
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "SQL (PostgreSQL)" , "Normal" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = True
              }
          )
        , ( "Identifier"
          , Context
              { cName = "Identifier"
              , cSyntax = "SQL (PostgreSQL)"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = OtherTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "MultiLineComment"
          , Context
              { cName = "MultiLineComment"
              , cSyntax = "SQL (PostgreSQL)"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "MultiLineString"
          , Context
              { cName = "MultiLineString"
              , cSyntax = "SQL (PostgreSQL)"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\$%1\\$"
                              , reCompiled = Nothing
                              , reCaseSensitive = False
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = True
              }
          )
        , ( "Normal"
          , Context
              { cName = "Normal"
              , cSyntax = "SQL (PostgreSQL)"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "create\\s+(or\\s+replace\\s+)?function"
                              , reCompiled =
                                  Just (compileRegex False "create\\s+(or\\s+replace\\s+)?function")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "SQL (PostgreSQL)" , "CreateFunction" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "do\\s+\\$([^\\$\\n\\r]*)\\$"
                              , reCompiled =
                                  Just (compileRegex False "do\\s+\\$([^\\$\\n\\r]*)\\$")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "SQL (PostgreSQL)" , "FunctionBody" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n (),;[\\]{}"
                              }
                            (makeWordSet
                               False
                               [ "ABORT"
                               , "ACCESS"
                               , "ACTION"
                               , "ADD"
                               , "ADMIN"
                               , "AFTER"
                               , "AGGREGATE"
                               , "ALIAS"
                               , "ALL"
                               , "ALLOCATE"
                               , "ALTER"
                               , "ANALYSE"
                               , "ANALYZE"
                               , "ANY"
                               , "ARE"
                               , "AS"
                               , "ASC"
                               , "ASENSITIVE"
                               , "ASSERTION"
                               , "ASSIGNMENT"
                               , "ASYMMETRIC"
                               , "AT"
                               , "ATOMIC"
                               , "AUTHORIZATION"
                               , "BACKWARD"
                               , "BEFORE"
                               , "BEGIN"
                               , "BETWEEN"
                               , "BINARY"
                               , "BOTH"
                               , "BREADTH"
                               , "BY"
                               , "C"
                               , "CACHE"
                               , "CALL"
                               , "CALLED"
                               , "CARDINALITY"
                               , "CASCADE"
                               , "CASCADED"
                               , "CASE"
                               , "CAST"
                               , "CATALOG"
                               , "CATALOG_NAME"
                               , "CHAIN"
                               , "CHAR_LENGTH"
                               , "CHARACTER_LENGTH"
                               , "CHARACTER_SET_CATALOG"
                               , "CHARACTER_SET_NAME"
                               , "CHARACTER_SET_SCHEMA"
                               , "CHARACTERISTICS"
                               , "CHECK"
                               , "CHECKED"
                               , "CHECKPOINT"
                               , "CLASS"
                               , "CLASS_ORIGIN"
                               , "CLOB"
                               , "CLOSE"
                               , "CLUSTER"
                               , "COALESCE"
                               , "COBOL"
                               , "COLLATE"
                               , "COLLATION"
                               , "COLLATION_CATALOG"
                               , "COLLATION_NAME"
                               , "COLLATION_SCHEMA"
                               , "COLUMN"
                               , "COLUMN_NAME"
                               , "COMMAND_FUNCTION"
                               , "COMMAND_FUNCTION_CODE"
                               , "COMMENT"
                               , "COMMIT"
                               , "COMMITTED"
                               , "COMPLETION"
                               , "CONDITION_NUMBER"
                               , "CONNECT"
                               , "CONNECTION"
                               , "CONNECTION_NAME"
                               , "CONSTRAINT"
                               , "CONSTRAINT_CATALOG"
                               , "CONSTRAINT_NAME"
                               , "CONSTRAINT_SCHEMA"
                               , "CONSTRAINTS"
                               , "CONSTRUCTOR"
                               , "CONTAINS"
                               , "CONTINUE"
                               , "CONVERT"
                               , "COPY"
                               , "CORRESPONDING"
                               , "COUNT"
                               , "CREATE"
                               , "CREATEDB"
                               , "CREATEUSER"
                               , "CROSS"
                               , "CUBE"
                               , "CURRENT"
                               , "CURRENT_DATE"
                               , "CURRENT_PATH"
                               , "CURRENT_ROLE"
                               , "CURRENT_TIME"
                               , "CURRENT_TIMESTAMP"
                               , "CURRENT_USER"
                               , "CURSOR"
                               , "CURSOR_NAME"
                               , "CYCLE"
                               , "DATA"
                               , "DATABASE"
                               , "DATE"
                               , "DATETIME_INTERVAL_CODE"
                               , "DATETIME_INTERVAL_PRECISION"
                               , "DAY"
                               , "DEALLOCATE"
                               , "DEC"
                               , "DECIMAL"
                               , "DECLARE"
                               , "DEFAULT"
                               , "DEFERRABLE"
                               , "DEFERRED"
                               , "DEFINED"
                               , "DEFINER"
                               , "DELETE"
                               , "DELIMITERS"
                               , "DEPTH"
                               , "DEREF"
                               , "DESC"
                               , "DESCRIBE"
                               , "DESCRIPTOR"
                               , "DESTROY"
                               , "DESTRUCTOR"
                               , "DETERMINISTIC"
                               , "DIAGNOSTICS"
                               , "DICTIONARY"
                               , "DISCONNECT"
                               , "DISPATCH"
                               , "DISTINCT"
                               , "DO"
                               , "DOMAIN"
                               , "DOUBLE"
                               , "DROP"
                               , "DYNAMIC"
                               , "DYNAMIC_FUNCTION"
                               , "DYNAMIC_FUNCTION_CODE"
                               , "EACH"
                               , "ELSE"
                               , "ENCODING"
                               , "ENCRYPTED"
                               , "END"
                               , "END-EXEC"
                               , "EQUALS"
                               , "ESCAPE"
                               , "EVERY"
                               , "EXCEPT"
                               , "EXCEPTION"
                               , "EXCLUSIVE"
                               , "EXEC"
                               , "EXECUTE"
                               , "EXISTING"
                               , "EXISTS"
                               , "EXPLAIN"
                               , "EXTERNAL"
                               , "FALSE"
                               , "FETCH"
                               , "FINAL"
                               , "FIRST"
                               , "FOR"
                               , "FORCE"
                               , "FOREIGN"
                               , "FORTRAN"
                               , "FORWARD"
                               , "FOUND"
                               , "FREE"
                               , "FREEZE"
                               , "FROM"
                               , "FULL"
                               , "FUNCTION"
                               , "G"
                               , "GENERAL"
                               , "GENERATED"
                               , "GET"
                               , "GLOBAL"
                               , "GO"
                               , "GOTO"
                               , "GRANT"
                               , "GRANTED"
                               , "GROUP"
                               , "GROUPING"
                               , "HANDLER"
                               , "HAVING"
                               , "HIERARCHY"
                               , "HOLD"
                               , "HOST"
                               , "HOUR"
                               , "IDENTITY"
                               , "IGNORE"
                               , "ILIKE"
                               , "IMMEDIATE"
                               , "IMMUTABLE"
                               , "IMPLEMENTATION"
                               , "IN"
                               , "INCREMENT"
                               , "INDEX"
                               , "INDICATOR"
                               , "INFIX"
                               , "INHERITS"
                               , "INITIALIZE"
                               , "INITIALLY"
                               , "INNER"
                               , "INOUT"
                               , "INPUT"
                               , "INSENSITIVE"
                               , "INSERT"
                               , "INSTANCE"
                               , "INSTANTIABLE"
                               , "INSTEAD"
                               , "INTERSECT"
                               , "INTERVAL"
                               , "INTO"
                               , "INVOKER"
                               , "IS"
                               , "ISNULL"
                               , "ISOLATION"
                               , "ITERATE"
                               , "JOIN"
                               , "K"
                               , "KEY"
                               , "KEY_MEMBER"
                               , "KEY_TYPE"
                               , "LANCOMPILER"
                               , "LANGUAGE"
                               , "LARGE"
                               , "LAST"
                               , "LATERAL"
                               , "LEADING"
                               , "LEFT"
                               , "LENGTH"
                               , "LESS"
                               , "LEVEL"
                               , "LIKE"
                               , "LIMIT"
                               , "LISTEN"
                               , "LOAD"
                               , "LOCAL"
                               , "LOCALTIME"
                               , "LOCALTIMESTAMP"
                               , "LOCATION"
                               , "LOCATOR"
                               , "LOCK"
                               , "LOWER"
                               , "M"
                               , "MAP"
                               , "MATCH"
                               , "MAX"
                               , "MAXVALUE"
                               , "MESSAGE_LENGTH"
                               , "MESSAGE_OCTET_LENGTH"
                               , "MESSAGE_TEXT"
                               , "METHOD"
                               , "MIN"
                               , "MINUTE"
                               , "MINVALUE"
                               , "MOD"
                               , "MODE"
                               , "MODIFIES"
                               , "MODIFY"
                               , "MODULE"
                               , "MONTH"
                               , "MORE"
                               , "MOVE"
                               , "MUMPS"
                               , "NAME"
                               , "NAMES"
                               , "NATIONAL"
                               , "NATURAL"
                               , "NEW"
                               , "NEXT"
                               , "NO"
                               , "NOCREATEDB"
                               , "NOCREATEUSER"
                               , "NONE"
                               , "NOT"
                               , "NOTHING"
                               , "NOTIFY"
                               , "NOTNULL"
                               , "NULL"
                               , "NULLABLE"
                               , "NULLIF"
                               , "NUMBER"
                               , "NUMERIC"
                               , "OBJECT"
                               , "OCTET_LENGTH"
                               , "OF"
                               , "OFF"
                               , "OFFSET"
                               , "OIDS"
                               , "OLD"
                               , "ON"
                               , "ONLY"
                               , "OPEN"
                               , "OPERATION"
                               , "OPERATOR"
                               , "OPTION"
                               , "OPTIONS"
                               , "ORDER"
                               , "ORDINALITY"
                               , "OUT"
                               , "OUTER"
                               , "OUTPUT"
                               , "OVERLAPS"
                               , "OVERLAY"
                               , "OVERRIDING"
                               , "OWNER"
                               , "PAD"
                               , "PARAMETER"
                               , "PARAMETER_MODE"
                               , "PARAMETER_NAME"
                               , "PARAMETER_ORDINAL_POSITION"
                               , "PARAMETER_SPECIFIC_CATALOG"
                               , "PARAMETER_SPECIFIC_NAME"
                               , "PARAMETER_SPECIFIC_SCHEMA"
                               , "PARAMETERS"
                               , "PARTIAL"
                               , "PASCAL"
                               , "PASSWORD"
                               , "PATH"
                               , "PENDANT"
                               , "PLI"
                               , "POSITION"
                               , "POSTFIX"
                               , "PRECISION"
                               , "PREFIX"
                               , "PREORDER"
                               , "PREPARE"
                               , "PRESERVE"
                               , "PRIMARY"
                               , "PRIOR"
                               , "PRIVILEGES"
                               , "PROCEDURAL"
                               , "PROCEDURE"
                               , "PUBLIC"
                               , "READ"
                               , "READS"
                               , "REAL"
                               , "RECURSIVE"
                               , "REF"
                               , "REFERENCES"
                               , "REFERENCING"
                               , "REINDEX"
                               , "RELATIVE"
                               , "RENAME"
                               , "REPEATABLE"
                               , "REPLACE"
                               , "RESET"
                               , "RESTRICT"
                               , "RESULT"
                               , "RETURN"
                               , "RETURNED_LENGTH"
                               , "RETURNED_OCTET_LENGTH"
                               , "RETURNED_SQLSTATE"
                               , "RETURNS"
                               , "REVOKE"
                               , "RIGHT"
                               , "ROLE"
                               , "ROLLBACK"
                               , "ROLLUP"
                               , "ROUTINE"
                               , "ROUTINE_CATALOG"
                               , "ROUTINE_NAME"
                               , "ROUTINE_SCHEMA"
                               , "ROW"
                               , "ROW_COUNT"
                               , "ROWS"
                               , "RULE"
                               , "SAVEPOINT"
                               , "SCALE"
                               , "SCHEMA"
                               , "SCHEMA_NAME"
                               , "SCOPE"
                               , "SCROLL"
                               , "SEARCH"
                               , "SECOND"
                               , "SECTION"
                               , "SECURITY"
                               , "SELECT"
                               , "SELF"
                               , "SENSITIVE"
                               , "SEQUENCE"
                               , "SERIALIZABLE"
                               , "SERVER_NAME"
                               , "SESSION"
                               , "SESSION_USER"
                               , "SET"
                               , "SETOF"
                               , "SETS"
                               , "SHARE"
                               , "SHOW"
                               , "SIMILAR"
                               , "SIMPLE"
                               , "SIZE"
                               , "SOME"
                               , "SOURCE"
                               , "SPACE"
                               , "SPECIFIC"
                               , "SPECIFIC_NAME"
                               , "SPECIFICTYPE"
                               , "SQL"
                               , "SQLCODE"
                               , "SQLERROR"
                               , "SQLEXCEPTION"
                               , "SQLSTATE"
                               , "SQLWARNING"
                               , "STABLE"
                               , "START"
                               , "STATE"
                               , "STATEMENT"
                               , "STATIC"
                               , "STATISTICS"
                               , "STDIN"
                               , "STDOUT"
                               , "STRUCTURE"
                               , "STYLE"
                               , "SUBCLASS_ORIGIN"
                               , "SUBLIST"
                               , "SUBSTRING"
                               , "SUM"
                               , "SYMMETRIC"
                               , "SYSID"
                               , "SYSTEM"
                               , "SYSTEM_USER"
                               , "TABLE"
                               , "TABLE_NAME"
                               , "TEMP"
                               , "TEMPLATE"
                               , "TEMPORARY"
                               , "TERMINATE"
                               , "THAN"
                               , "THEN"
                               , "TIMEZONE_HOUR"
                               , "TIMEZONE_MINUTE"
                               , "TO"
                               , "TOAST"
                               , "TRAILING"
                               , "TRANSACTION"
                               , "TRANSACTION_ACTIVE"
                               , "TRANSACTIONS_COMMITTED"
                               , "TRANSACTIONS_ROLLED_BACK"
                               , "TRANSFORM"
                               , "TRANSFORMS"
                               , "TRANSLATE"
                               , "TRANSLATION"
                               , "TREAT"
                               , "TRIGGER"
                               , "TRIGGER_CATALOG"
                               , "TRIGGER_NAME"
                               , "TRIGGER_SCHEMA"
                               , "TRIM"
                               , "TRUE"
                               , "TRUNCATE"
                               , "TRUSTED"
                               , "TYPE"
                               , "UNCOMMITTED"
                               , "UNDER"
                               , "UNENCRYPTED"
                               , "UNION"
                               , "UNIQUE"
                               , "UNKNOWN"
                               , "UNLISTEN"
                               , "UNNAMED"
                               , "UNNEST"
                               , "UNTIL"
                               , "UPDATE"
                               , "UPPER"
                               , "USAGE"
                               , "USER"
                               , "USER_DEFINED_TYPE_CATALOG"
                               , "USER_DEFINED_TYPE_NAME"
                               , "USER_DEFINED_TYPE_SCHEMA"
                               , "USING"
                               , "VACUUM"
                               , "VALID"
                               , "VALUE"
                               , "VALUES"
                               , "VARIABLE"
                               , "VARYING"
                               , "VERBOSE"
                               , "VERSION"
                               , "VIEW"
                               , "VOLATILE"
                               , "WHEN"
                               , "WHENEVER"
                               , "WHERE"
                               , "WHILE"
                               , "WITH"
                               , "WITHOUT"
                               , "WORK"
                               , "WRITE"
                               , "YEAR"
                               , "ZONE"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n (),;[\\]{}"
                              }
                            (makeWordSet
                               False
                               [ "!"
                               , "!!"
                               , "!="
                               , "!~"
                               , "!~*"
                               , "#"
                               , "##"
                               , "%"
                               , "&"
                               , "&&"
                               , "&<"
                               , "&>"
                               , "*"
                               , "**"
                               , "+"
                               , "-"
                               , ".."
                               , "/"
                               , ":="
                               , "<"
                               , "<->"
                               , "<<"
                               , "<<="
                               , "<="
                               , "<>"
                               , "<^"
                               , "="
                               , "=>"
                               , ">"
                               , ">="
                               , ">>"
                               , ">>="
                               , ">^"
                               , "?#"
                               , "?-"
                               , "?-|"
                               , "?|"
                               , "?||"
                               , "@"
                               , "@-@"
                               , "@@"
                               , "^"
                               , "^="
                               , "AND"
                               , "NOT"
                               , "OR"
                               , "|"
                               , "|/"
                               , "||"
                               , "||/"
                               , "~"
                               , "~*"
                               , "~="
                               ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n (),;[\\]{}"
                              }
                            (makeWordSet
                               False
                               [ "ABBREV"
                               , "ABS"
                               , "ACOS"
                               , "AGE"
                               , "AREA"
                               , "ASCII"
                               , "ASIN"
                               , "ATAN"
                               , "ATAN2"
                               , "AVG"
                               , "BIT_LENGTH"
                               , "BOX"
                               , "BROADCAST"
                               , "BTRIM"
                               , "CBRT"
                               , "CEIL"
                               , "CENTER"
                               , "CHAR_LENGTH"
                               , "CHARACTER_LENGTH"
                               , "CHR"
                               , "CIRCLE"
                               , "COALESCE"
                               , "COL_DESCRIPTION"
                               , "CONVERT"
                               , "COS"
                               , "COT"
                               , "COUNT"
                               , "CURRVAL"
                               , "DATE_PART"
                               , "DATE_TRUNC"
                               , "DECODE"
                               , "DEGREES"
                               , "DIAMETER"
                               , "ENCODE"
                               , "EXP"
                               , "EXTRACT"
                               , "FLOOR"
                               , "HAS_TABLE_PRIVILEGE"
                               , "HEIGHT"
                               , "HOST"
                               , "INITCAP"
                               , "ISCLOSED"
                               , "ISFINITE"
                               , "ISOPEN"
                               , "LENGTH"
                               , "LN"
                               , "LOG"
                               , "LOWER"
                               , "LPAD"
                               , "LSEG"
                               , "LTRIM"
                               , "MASKLEN"
                               , "MAX"
                               , "MIN"
                               , "MOD"
                               , "NETMASK"
                               , "NETWORK"
                               , "NEXTVAL"
                               , "NOW"
                               , "NPOINT"
                               , "NULLIF"
                               , "OBJ_DESCRIPTION"
                               , "OCTET_LENGTH"
                               , "PATH"
                               , "PCLOSE"
                               , "PG_CLIENT_ENCODING"
                               , "PG_GET_INDEXDEF"
                               , "PG_GET_RULEDEF"
                               , "PG_GET_USERBYID"
                               , "PG_GET_VIEWDEF"
                               , "PI"
                               , "POINT"
                               , "POLYGON"
                               , "POPEN"
                               , "POSITION"
                               , "POW"
                               , "RADIANS"
                               , "RADIUS"
                               , "RANDOM"
                               , "REPEAT"
                               , "ROUND"
                               , "RPAD"
                               , "RTRIM"
                               , "SET_MASKLEN"
                               , "SETVAL"
                               , "SIGN"
                               , "SIN"
                               , "SQRT"
                               , "STDDEV"
                               , "STRPOS"
                               , "SUBSTR"
                               , "SUBSTRING"
                               , "SUM"
                               , "TAN"
                               , "TIMEOFDAY"
                               , "TIMESTAMP"
                               , "TO_ASCII"
                               , "TO_CHAR"
                               , "TO_DATE"
                               , "TO_NUMBER"
                               , "TO_TIMESTAMP"
                               , "TRANSLATE"
                               , "TRIM"
                               , "TRUNC"
                               , "UPPER"
                               , "VARIANCE"
                               , "WIDTH"
                               ])
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n (),;[\\]{}"
                              }
                            (makeWordSet
                               False
                               [ "BIGINT"
                               , "BIGSERIAL"
                               , "BIT"
                               , "BIT VARYING"
                               , "BOOL"
                               , "BOOLEAN"
                               , "BOX"
                               , "BYTEA"
                               , "CHAR"
                               , "CHARACTER"
                               , "CHARACTER VARYING"
                               , "CIDR"
                               , "CIRCLE"
                               , "DATE"
                               , "DECIMAL"
                               , "DOUBLE PRECISION"
                               , "FLOAT8"
                               , "INET"
                               , "INT"
                               , "INT2"
                               , "INT4"
                               , "INT8"
                               , "INTEGER"
                               , "INTERVAL"
                               , "LINE"
                               , "LSEG"
                               , "LZTEXT"
                               , "MACADDR"
                               , "MONEY"
                               , "NUMERIC"
                               , "OID"
                               , "PATH"
                               , "POINT"
                               , "POLYGON"
                               , "REAL"
                               , "SERIAL"
                               , "SERIAL8"
                               , "SMALLINT"
                               , "TEXT"
                               , "TIME"
                               , "TIMESTAMP"
                               , "TIMESTAMP WITH TIMEZONE"
                               , "TIMESTAMPTZ"
                               , "TIMETZ"
                               , "VARBIT"
                               , "VARCHAR"
                               ])
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "%bulk_exceptions\\b"
                              , reCompiled = Just (compileRegex False "%bulk_exceptions\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "%bulk_rowcount\\b"
                              , reCompiled = Just (compileRegex False "%bulk_rowcount\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "%found\\b"
                              , reCompiled = Just (compileRegex False "%found\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "%isopen\\b"
                              , reCompiled = Just (compileRegex False "%isopen\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "%notfound\\b"
                              , reCompiled = Just (compileRegex False "%notfound\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "%rowcount\\b"
                              , reCompiled = Just (compileRegex False "%rowcount\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "%rowtype\\b"
                              , reCompiled = Just (compileRegex False "%rowtype\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "%type\\b"
                              , reCompiled = Just (compileRegex False "%type\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Float
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "SQL (PostgreSQL)" , "String" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "SQL (PostgreSQL)" , "SingleLineComment" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '-' '-'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "SQL (PostgreSQL)" , "SingleLineComment" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '/' '*'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "SQL (PostgreSQL)" , "MultiLineComment" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "rem\\b"
                              , reCompiled = Just (compileRegex False "rem\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Just 0
                      , rContextSwitch =
                          [ Push ( "SQL (PostgreSQL)" , "SingleLineComment" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "SQL (PostgreSQL)" , "Identifier" ) ]
                      }
                  , Rule
                      { rMatcher = AnyChar ":&"
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "/$"
                              , reCompiled = Just (compileRegex False "/$")
                              , reCaseSensitive = False
                              }
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Just 0
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "@@?[^@ \\t\\r\\n]"
                              , reCompiled = Just (compileRegex False "@@?[^@ \\t\\r\\n]")
                              , reCaseSensitive = False
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Just 0
                      , rContextSwitch = [ Push ( "SQL (PostgreSQL)" , "Preprocessor" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\$([^\\$\\n\\r]*)\\$"
                              , reCompiled = Nothing
                              , reCaseSensitive = False
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "SQL (PostgreSQL)" , "MultiLineString" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Preprocessor"
          , Context
              { cName = "Preprocessor"
              , cSyntax = "SQL (PostgreSQL)"
              , cRules = []
              , cAttribute = OtherTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "SingleLineComment"
          , Context
              { cName = "SingleLineComment"
              , cSyntax = "SQL (PostgreSQL)"
              , cRules = []
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "String"
          , Context
              { cName = "String"
              , cSyntax = "SQL (PostgreSQL)"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '&'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Shane Wright (me@shanewright.co.uk)"
  , sVersion = "2"
  , sLicense = ""
  , sExtensions = [ "*.sql" , "*.SQL" , "*.ddl" , "*.DDL" ]
  , sStartingContext = "Normal"
  }
