{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.SqlMysql (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "SQL (MySQL)"
  , sFilename = "sql-mysql.xml"
  , sShortname = "SqlMysql"
  , sContexts =
      fromList
        [ ( "MultiLineComment"
          , Context
              { cName = "MultiLineComment"
              , cSyntax = "SQL (MySQL)"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Name"
          , Context
              { cName = "Name"
              , cSyntax = "SQL (MySQL)"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '`'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Normal"
          , Context
              { cName = "Normal"
              , cSyntax = "SQL (MySQL)"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "SET(?=\\s*\\()"
                              , reCompiled = Just (compileRegex False "SET(?=\\s*\\()")
                              , reCaseSensitive = False
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCHARACTER SET\\b"
                              , reCompiled = Just (compileRegex False "\\bCHARACTER SET\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n %&(),;?[\\]{}"
                              }
                            (makeWordSet
                               False
                               [ "ACCESS"
                               , "ADD"
                               , "ALL"
                               , "ALTER"
                               , "ANALYZE"
                               , "AND"
                               , "AS"
                               , "ASC"
                               , "AUTO_INCREMENT"
                               , "BDB"
                               , "BERKELEYDB"
                               , "BETWEEN"
                               , "BOTH"
                               , "BY"
                               , "CASCADE"
                               , "CASE"
                               , "CHANGE"
                               , "CHARSET"
                               , "COLUMN"
                               , "COLUMNS"
                               , "CONSTRAINT"
                               , "CREATE"
                               , "CROSS"
                               , "CURRENT_DATE"
                               , "CURRENT_TIME"
                               , "CURRENT_TIMESTAMP"
                               , "DATABASE"
                               , "DATABASES"
                               , "DAY_HOUR"
                               , "DAY_MINUTE"
                               , "DAY_SECOND"
                               , "DEC"
                               , "DEFAULT"
                               , "DELAYED"
                               , "DELETE"
                               , "DESC"
                               , "DESCRIBE"
                               , "DISTINCT"
                               , "DISTINCTROW"
                               , "DROP"
                               , "ELSE"
                               , "ENCLOSED"
                               , "ESCAPED"
                               , "EXISTS"
                               , "EXPLAIN"
                               , "FIELDS"
                               , "FOR"
                               , "FOREIGN"
                               , "FROM"
                               , "FULLTEXT"
                               , "FUNCTION"
                               , "GRANT"
                               , "GROUP"
                               , "HAVING"
                               , "HIGH_PRIORITY"
                               , "IF"
                               , "IGNORE"
                               , "IN"
                               , "INDEX"
                               , "INFILE"
                               , "INNER"
                               , "INNODB"
                               , "INSERT"
                               , "INTERVAL"
                               , "INTO"
                               , "IS"
                               , "JOIN"
                               , "KEY"
                               , "KEYS"
                               , "KILL"
                               , "LEADING"
                               , "LEFT"
                               , "LIKE"
                               , "LIMIT"
                               , "LINES"
                               , "LOAD"
                               , "LOCK"
                               , "LOW_PRIORITY"
                               , "MASTER_SERVER_ID"
                               , "MATCH"
                               , "MRG_MYISAM"
                               , "NATIONAL"
                               , "NATURAL"
                               , "NOT"
                               , "NULL"
                               , "NUMERIC"
                               , "ON"
                               , "OPTIMIZE"
                               , "OPTION"
                               , "OPTIONALLY"
                               , "OR"
                               , "ORDER"
                               , "OUTER"
                               , "OUTFILE"
                               , "PARTIAL"
                               , "PRECISION"
                               , "PRIMARY"
                               , "PRIVILEGES"
                               , "PROCEDURE"
                               , "PURGE"
                               , "READ"
                               , "REFERENCES"
                               , "REGEXP"
                               , "RENAME"
                               , "REPLACE"
                               , "REQUIRE"
                               , "RESTRICT"
                               , "RETURNS"
                               , "REVOKE"
                               , "RIGHT"
                               , "RLIKE"
                               , "SELECT"
                               , "SET"
                               , "SHOW"
                               , "SONAME"
                               , "SQL_BIG_RESULT"
                               , "SQL_CALC_FOUND_ROWS"
                               , "SQL_SMALL_RESULT"
                               , "SSL"
                               , "STARTING"
                               , "STRAIGHT_JOIN"
                               , "STRIPED"
                               , "TABLE"
                               , "TABLES"
                               , "TERMINATED"
                               , "THEN"
                               , "TO"
                               , "TRAILING"
                               , "TRUNCATE"
                               , "TYPE"
                               , "UNION"
                               , "UNIQUE"
                               , "UNLOCK"
                               , "UNSIGNED"
                               , "UPDATE"
                               , "USAGE"
                               , "USE"
                               , "USER_RESOURCES"
                               , "USING"
                               , "VALUES"
                               , "VARYING"
                               , "WHEN"
                               , "WHERE"
                               , "WHILE"
                               , "WITH"
                               , "WRITE"
                               , "XOR"
                               , "YEAR_MONTH"
                               , "ZEROFILL"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n %&(),;?[\\]{}"
                              }
                            (makeWordSet
                               False
                               [ "!="
                               , "*"
                               , "**"
                               , "+"
                               , "-"
                               , ".."
                               , "/"
                               , ":="
                               , "<"
                               , "<="
                               , "<>"
                               , "="
                               , "=>"
                               , ">"
                               , ">="
                               , "^="
                               , "||"
                               , "~="
                               ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n %&(),;?[\\]{}"
                              }
                            (makeWordSet
                               False
                               [ "ABS"
                               , "ACOS"
                               , "ADDDATE"
                               , "AES_DECRYPT"
                               , "AES_ENCRYPT"
                               , "ASCII"
                               , "ASIN"
                               , "ATAN"
                               , "ATAN2"
                               , "AVG"
                               , "BENCHMARK"
                               , "BIN"
                               , "BIT_AND"
                               , "BIT_COUNT"
                               , "BIT_LENGTH"
                               , "BIT_OR"
                               , "CAST"
                               , "CEILING"
                               , "CHAR"
                               , "CHAR_LENGTH"
                               , "CHARACTER_LENGTH"
                               , "CONCAT"
                               , "CONCAT_WS"
                               , "CONNECTION_ID"
                               , "CONV"
                               , "CONVERT"
                               , "COS"
                               , "COT"
                               , "COUNT"
                               , "CURDATE"
                               , "CURRENT_DATE"
                               , "CURRENT_TIME"
                               , "CURRENT_TIMESTAMP"
                               , "CURTIME"
                               , "DATABASE"
                               , "DATE_ADD"
                               , "DATE_FORMAT"
                               , "DATE_SUB"
                               , "DAYNAME"
                               , "DAYOFMONTH"
                               , "DAYOFWEEK"
                               , "DAYOFYEAR"
                               , "DECODE"
                               , "DEGREES"
                               , "DES_DECRYPT"
                               , "DES_ENCRYPT"
                               , "ELT"
                               , "ENCODE"
                               , "ENCRYPT"
                               , "EXP"
                               , "EXPORT_SET"
                               , "EXTRACT"
                               , "FIELD"
                               , "FIND_IN_SET"
                               , "FLOOR"
                               , "FORMAT"
                               , "FOUND_ROWS"
                               , "FROM_DAYS"
                               , "FROM_UNIXTIME"
                               , "GET_LOCK"
                               , "GREATEST"
                               , "HEX"
                               , "HOUR"
                               , "INET_ATON"
                               , "INET_NTOA"
                               , "INSERT"
                               , "INSTR"
                               , "IS_FREE_LOCK"
                               , "LAST_INSERT_ID"
                               , "LCASE"
                               , "LEAST"
                               , "LEFT"
                               , "LENGTH"
                               , "LN"
                               , "LOAD_FILE"
                               , "LOCATE"
                               , "LOG"
                               , "LOG10"
                               , "LOG2"
                               , "LOWER"
                               , "LPAD"
                               , "LTRIM"
                               , "MAKE_SET"
                               , "MASTER_POS_WAIT"
                               , "MAX"
                               , "MD5"
                               , "MID"
                               , "MIN"
                               , "MINUTE"
                               , "MOD"
                               , "MONTH"
                               , "MONTHNAME"
                               , "NOW"
                               , "OCT"
                               , "OCTET_LENGTH"
                               , "ORD"
                               , "PASSWORD"
                               , "PERIOD_ADD"
                               , "PERIOD_DIFF"
                               , "PI"
                               , "POSITION"
                               , "POW"
                               , "POWER"
                               , "QUARTER"
                               , "QUOTE"
                               , "RADIANS"
                               , "RAND"
                               , "RELEASE_LOCK"
                               , "REPEAT"
                               , "REPLACE"
                               , "REVERSE"
                               , "RIGHT"
                               , "ROUND"
                               , "RPAD"
                               , "RTRIM"
                               , "SEC_TO_TIME"
                               , "SECOND"
                               , "SESSION_USER"
                               , "SHA"
                               , "SHA1"
                               , "SIGN"
                               , "SIN"
                               , "SOUNDEX"
                               , "SPACE"
                               , "SQRT"
                               , "STD"
                               , "STDDEV"
                               , "SUBDATE"
                               , "SUBSTRING"
                               , "SUBSTRING_INDEX"
                               , "SUM"
                               , "SYSDATE"
                               , "SYSTEM_USER"
                               , "TAN"
                               , "TIME_FORMAT"
                               , "TIME_TO_SEC"
                               , "TO_DAYS"
                               , "TRIM"
                               , "UCASE"
                               , "UNIX_TIMESTAMP"
                               , "UPPER"
                               , "USER"
                               , "VERSION"
                               , "WEEK"
                               , "WEEKDAY"
                               , "YEAR"
                               , "YEARWEEK"
                               ])
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n %&(),;?[\\]{}"
                              }
                            (makeWordSet
                               False
                               [ "BIGINT"
                               , "BINARY"
                               , "BIT"
                               , "BLOB"
                               , "BOOL"
                               , "BOOLEAN"
                               , "CHAR"
                               , "CHARACTER"
                               , "DATE"
                               , "DATETIME"
                               , "DEC"
                               , "DECIMAL"
                               , "DOUBLE"
                               , "ENUM"
                               , "FIXED"
                               , "FLOAT"
                               , "INT"
                               , "INTEGER"
                               , "LONG"
                               , "LONGBLOB"
                               , "LONGTEXT"
                               , "MEDIUMBLOB"
                               , "MEDIUMINT"
                               , "MEDIUMTEXT"
                               , "MIDDLEINT"
                               , "NUMERIC"
                               , "REAL"
                               , "SERIAL"
                               , "SMALLINT"
                               , "TEXT"
                               , "TIME"
                               , "TIMESTAMP"
                               , "TINYBLOB"
                               , "TINYINT"
                               , "TINYTEXT"
                               , "VARBINARY"
                               , "VARCHAR"
                               , "YEAR"
                               ])
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectIdentifier
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "%(?:bulk_(?:exceptions|rowcount)|found|isopen|notfound|rowcount|rowtype|type)\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       False
                                       "%(?:bulk_(?:exceptions|rowcount)|found|isopen|notfound|rowcount|rowtype|type)\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCHex
                      , rAttribute = BaseNTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Float
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "SQL (MySQL)" , "String" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "SQL (MySQL)" , "String2" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '`'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "SQL (MySQL)" , "Name" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "SQL (MySQL)" , "SingleLineComment" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '-' '-'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "SQL (MySQL)" , "SingleLineComment" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '/' '*'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "SQL (MySQL)" , "MultiLineComment" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "rem\\b"
                              , reCompiled = Just (compileRegex False "rem\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Just 0
                      , rContextSwitch = [ Push ( "SQL (MySQL)" , "SingleLineComment" ) ]
                      }
                  , Rule
                      { rMatcher = AnyChar ":&"
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "/$"
                              , reCompiled = Just (compileRegex False "/$")
                              , reCaseSensitive = False
                              }
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Just 0
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "@@?[^@ \\t\\r\\n]"
                              , reCompiled = Just (compileRegex False "@@?[^@ \\t\\r\\n]")
                              , reCaseSensitive = False
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Just 0
                      , rContextSwitch = [ Push ( "SQL (MySQL)" , "Preprocessor" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '.'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Preprocessor"
          , Context
              { cName = "Preprocessor"
              , cSyntax = "SQL (MySQL)"
              , cRules = []
              , cAttribute = OtherTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "SingleLineComment"
          , Context
              { cName = "SingleLineComment"
              , cSyntax = "SQL (MySQL)"
              , cRules = []
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "String"
          , Context
              { cName = "String"
              , cSyntax = "SQL (MySQL)"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '&'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "String2"
          , Context
              { cName = "String2"
              , cSyntax = "SQL (MySQL)"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '&'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Shane Wright (me@shanewright.co.uk)"
  , sVersion = "2"
  , sLicense = ""
  , sExtensions = [ "*.sql" , "*.SQL" , "*.ddl" , "*.DDL" ]
  , sStartingContext = "Normal"
  }
