{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Scheme (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "Scheme"
  , sFilename = "scheme.xml"
  , sShortname = "Scheme"
  , sContexts =
      fromList
        [ ( "Default"
          , Context
              { cName = "Default"
              , cSyntax = "Scheme"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = ";+\\s*BEGIN.*$"
                              , reCompiled = Just (compileRegex True ";+\\s*BEGIN.*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = RegionMarkerTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = ";+\\s*END.*$"
                              , reCompiled = Just (compileRegex True ";+\\s*END.*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = RegionMarkerTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = ";.*$"
                              , reCompiled = Just (compileRegex True ";.*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '#' '!'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scheme" , "MultiLineComment" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n %&(),.;[]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "abs"
                               , "acos"
                               , "and"
                               , "angle"
                               , "append"
                               , "applymap"
                               , "asin"
                               , "assoc"
                               , "assq"
                               , "assv"
                               , "atan"
                               , "begin"
                               , "boolean?"
                               , "break"
                               , "caaaar"
                               , "caaadr"
                               , "caaar"
                               , "caadar"
                               , "caaddr"
                               , "caadr"
                               , "caar"
                               , "cadaar"
                               , "cadadr"
                               , "cadar"
                               , "caddar"
                               , "cadddr"
                               , "caddr"
                               , "cadr"
                               , "call-with-current-continuation"
                               , "call-with-input-file"
                               , "call-with-output-file"
                               , "call-with-values"
                               , "call/cc"
                               , "car"
                               , "case"
                               , "catch"
                               , "cdaaar"
                               , "cdaadr"
                               , "cdaar"
                               , "cdadar"
                               , "cdaddr"
                               , "cdadr"
                               , "cdar"
                               , "cddaar"
                               , "cddadr"
                               , "cddar"
                               , "cdddar"
                               , "cddddr"
                               , "cdddr"
                               , "cddr"
                               , "cdr"
                               , "ceiling"
                               , "char->integer"
                               , "char-alphabetic?"
                               , "char-ci<=?"
                               , "char-ci=?"
                               , "char-ci>=?"
                               , "char-ci>?"
                               , "char-downcase"
                               , "char-lower-case?"
                               , "char-numeric?"
                               , "char-ready?"
                               , "char-upcase"
                               , "char-upper-case?"
                               , "char-whitespace?"
                               , "char<=?"
                               , "char<?c"
                               , "char=?"
                               , "char>=?"
                               , "char>?"
                               , "char?"
                               , "close-input-port"
                               , "close-output-port"
                               , "complex?"
                               , "cond"
                               , "cons"
                               , "continue"
                               , "cos"
                               , "current-input-port"
                               , "current-output-port"
                               , "denominator"
                               , "display"
                               , "do"
                               , "dynamic-wind"
                               , "else"
                               , "eof-object?"
                               , "eq?"
                               , "equal?"
                               , "eqv?"
                               , "eval"
                               , "even?"
                               , "exact->inexact"
                               , "exact?"
                               , "exp"
                               , "expt"
                               , "floor"
                               , "for-each"
                               , "force"
                               , "gcd"
                               , "har-ci<?"
                               , "if"
                               , "imag-part"
                               , "inexact->exact"
                               , "inexact?"
                               , "input-port?"
                               , "integer->char"
                               , "integer?"
                               , "interaction-environment"
                               , "lambda"
                               , "lcm"
                               , "length"
                               , "let"
                               , "let*"
                               , "let-syntax"
                               , "letrec"
                               , "letrec-syntax"
                               , "list"
                               , "list->string"
                               , "list-ref"
                               , "list-tail"
                               , "list?"
                               , "load"
                               , "log"
                               , "magnitude"
                               , "make-polar"
                               , "make-rectangular"
                               , "make-string"
                               , "make-vector"
                               , "max"
                               , "member"
                               , "memq"
                               , "memv"
                               , "min"
                               , "modulo"
                               , "negative?"
                               , "newline"
                               , "not"
                               , "null-environment"
                               , "null?"
                               , "number->string"
                               , "number?"
                               , "numerator"
                               , "odd?"
                               , "open-input-file"
                               , "open-output-file"
                               , "or"
                               , "output-port?"
                               , "pair?"
                               , "peek-char"
                               , "port?"
                               , "positive?"
                               , "procedure?"
                               , "quotient"
                               , "rational?"
                               , "rationalize"
                               , "read"
                               , "read-char"
                               , "real-part"
                               , "real?"
                               , "remainder"
                               , "reverse"
                               , "round"
                               , "scheme-report-environment"
                               , "set-car!"
                               , "set-cdr!"
                               , "sin"
                               , "sqrt"
                               , "string"
                               , "string->list"
                               , "string->number"
                               , "string->symbol"
                               , "string-append"
                               , "string-ci<=?"
                               , "string-ci<?"
                               , "string-ci=?"
                               , "string-ci>=?"
                               , "string-ci>?"
                               , "string-copy"
                               , "string-fill!"
                               , "string-length"
                               , "string-ref"
                               , "string-set!"
                               , "string<=?"
                               , "string<?"
                               , "string=?"
                               , "string>=?"
                               , "string>?"
                               , "string?"
                               , "substring"
                               , "symbol->string"
                               , "symbol?"
                               , "syntax-rules"
                               , "tan"
                               , "transcript-off"
                               , "transcript-on"
                               , "truncate"
                               , "values"
                               , "vector"
                               , "vector->listlist->vector"
                               , "vector-fill!"
                               , "vector-length"
                               , "vector-ref"
                               , "vector-set!"
                               , "vector?"
                               , "while"
                               , "with-input-from-file"
                               , "with-output-to-file"
                               , "write"
                               , "write-char"
                               , "zero?"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n %&(),.;[]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "*)"
                               , "*,*"
                               , "+"
                               , "-"
                               , "/"
                               , "<"
                               , "<="
                               , "="
                               , "=>"
                               , ">"
                               , ">="
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n %&(),.;[]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "define"
                               , "define*"
                               , "define*-public"
                               , "define-accessor"
                               , "define-class"
                               , "define-generic"
                               , "define-macro"
                               , "define-method"
                               , "define-module"
                               , "define-private"
                               , "define-public"
                               , "define-reader-ctor"
                               , "define-syntax"
                               , "define-syntax-macro"
                               , "defined?"
                               , "defmacro"
                               , "defmacro*"
                               , "defmacro*-public"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scheme" , "function_decl" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n %&(),.;[]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "#\\ack"
                               , "#\\backspace"
                               , "#\\bel"
                               , "#\\bs"
                               , "#\\can"
                               , "#\\cr"
                               , "#\\dc1"
                               , "#\\dc2"
                               , "#\\dc3"
                               , "#\\dc4"
                               , "#\\dle"
                               , "#\\em"
                               , "#\\enq"
                               , "#\\eot"
                               , "#\\esc"
                               , "#\\etb"
                               , "#\\etx"
                               , "#\\fs"
                               , "#\\gs"
                               , "#\\ht"
                               , "#\\nak"
                               , "#\\newline"
                               , "#\\nl"
                               , "#\\np"
                               , "#\\nul"
                               , "#\\null"
                               , "#\\page"
                               , "#\\return"
                               , "#\\rs"
                               , "#\\si"
                               , "#\\so"
                               , "#\\soh"
                               , "#\\sp"
                               , "#\\space"
                               , "#\\stx"
                               , "#\\sub"
                               , "#\\syn"
                               , "#\\tab"
                               , "#\\us"
                               , "#\\vt"
                               ])
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "#\\\\."
                              , reCompiled = Just (compileRegex True "#\\\\.")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scheme" , "String" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "#[bodxei]"
                              , reCompiled = Just (compileRegex True "#[bodxei]")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scheme" , "SpecialNumber" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "#[tf]"
                              , reCompiled = Just (compileRegex True "#[tf]")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Float
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '('
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scheme" , "Level1" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Level0"
          , Context
              { cName = "Level0"
              , cSyntax = "Scheme"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '('
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scheme" , "Level1" ) ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Scheme" , "Default" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Level1"
          , Context
              { cName = "Level1"
              , cSyntax = "Scheme"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '('
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scheme" , "Level2" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar ')'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Scheme" , "Default" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Level2"
          , Context
              { cName = "Level2"
              , cSyntax = "Scheme"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '('
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scheme" , "Level3" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar ')'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Scheme" , "Default" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Level3"
          , Context
              { cName = "Level3"
              , cSyntax = "Scheme"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '('
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scheme" , "Level4" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar ')'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Scheme" , "Default" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Level4"
          , Context
              { cName = "Level4"
              , cSyntax = "Scheme"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '('
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scheme" , "Level5" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar ')'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Scheme" , "Default" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Level5"
          , Context
              { cName = "Level5"
              , cSyntax = "Scheme"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '('
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scheme" , "Level6" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar ')'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Scheme" , "Default" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Level6"
          , Context
              { cName = "Level6"
              , cSyntax = "Scheme"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '('
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scheme" , "Level1" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar ')'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Scheme" , "Default" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "MultiLineComment"
          , Context
              { cName = "MultiLineComment"
              , cSyntax = "Scheme"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "!#\\s*$"
                              , reCompiled = Just (compileRegex True "!#\\s*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Just 0
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "SpecialNumber"
          , Context
              { cName = "SpecialNumber"
              , cSyntax = "Scheme"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\d*(\\.\\d+)?"
                              , reCompiled = Just (compileRegex True "\\d*(\\.\\d+)?")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = True
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "String"
          , Context
              { cName = "String"
              , cSyntax = "Scheme"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n %&(),.;[]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "#\\ack"
                               , "#\\backspace"
                               , "#\\bel"
                               , "#\\bs"
                               , "#\\can"
                               , "#\\cr"
                               , "#\\dc1"
                               , "#\\dc2"
                               , "#\\dc3"
                               , "#\\dc4"
                               , "#\\dle"
                               , "#\\em"
                               , "#\\enq"
                               , "#\\eot"
                               , "#\\esc"
                               , "#\\etb"
                               , "#\\etx"
                               , "#\\fs"
                               , "#\\gs"
                               , "#\\ht"
                               , "#\\nak"
                               , "#\\newline"
                               , "#\\nl"
                               , "#\\np"
                               , "#\\nul"
                               , "#\\null"
                               , "#\\page"
                               , "#\\return"
                               , "#\\rs"
                               , "#\\si"
                               , "#\\so"
                               , "#\\soh"
                               , "#\\sp"
                               , "#\\space"
                               , "#\\stx"
                               , "#\\sub"
                               , "#\\syn"
                               , "#\\tab"
                               , "#\\us"
                               , "#\\vt"
                               ])
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "#\\\\."
                              , reCompiled = Just (compileRegex True "#\\\\.")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' '"'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' '\\'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "function_decl"
          , Context
              { cName = "function_decl"
              , cSyntax = "Scheme"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\s*[A-Za-z0-9-+\\<\\>//\\*]*\\s*"
                              , reCompiled =
                                  Just (compileRegex True "\\s*[A-Za-z0-9-+\\<\\>//\\*]*\\s*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = FunctionTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Dominik Haumann (dhdev@gmx.de)"
  , sVersion = "3"
  , sLicense = "LGPLv2+"
  , sExtensions = [ "*.scm" , "*.ss" , "*.scheme" , "*.guile" ]
  , sStartingContext = "Level0"
  }
