{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Scala (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "Scala"
  , sFilename = "scala.xml"
  , sShortname = "Scala"
  , sContexts =
      fromList
        [ ( "Commentar 1"
          , Context
              { cName = "Commentar 1"
              , cSyntax = "Scala"
              , cRules = []
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Commentar 2"
          , Context
              { cName = "Commentar 2"
              , cSyntax = "Scala"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Member"
          , Context
              { cName = "Member"
              , cSyntax = "Scala"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b[_a-zA-Z]\\w*(?=[\\s]*)"
                              , reCompiled =
                                  Just (compileRegex True "\\b[_a-zA-Z]\\w*(?=[\\s]*)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = True
              , cFallthroughContext = [ Pop ]
              , cDynamic = False
              }
          )
        , ( "Normal"
          , Context
              { cName = "Normal"
              , cSyntax = "Scala"
              , cRules =
                  [ Rule
                      { rMatcher = IncludeRules ( "Javadoc" , "" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "abstract"
                               , "case"
                               , "catch"
                               , "class"
                               , "def"
                               , "do"
                               , "else"
                               , "extends"
                               , "false"
                               , "final"
                               , "finally"
                               , "for"
                               , "forSome"
                               , "if"
                               , "implicit"
                               , "import"
                               , "lazy"
                               , "match"
                               , "new"
                               , "null"
                               , "object"
                               , "override"
                               , "package"
                               , "private"
                               , "protected"
                               , "requires"
                               , "return"
                               , "sealed"
                               , "super"
                               , "this"
                               , "throw"
                               , "trait"
                               , "true"
                               , "try"
                               , "type"
                               , "val"
                               , "var"
                               , "while"
                               , "with"
                               , "yield"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "boolean"
                               , "byte"
                               , "char"
                               , "double"
                               , "float"
                               , "int"
                               , "long"
                               , "short"
                               , "unit"
                               ])
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "ACTIVE"
                               , "ACTIVITY_COMPLETED"
                               , "ACTIVITY_REQUIRED"
                               , "ARG_IN"
                               , "ARG_INOUT"
                               , "ARG_OUT"
                               , "AWTError"
                               , "AWTEvent"
                               , "AWTEventListener"
                               , "AWTEventListenerProxy"
                               , "AWTEventMulticaster"
                               , "AWTException"
                               , "AWTKeyStroke"
                               , "AWTPermission"
                               , "AbstractAction"
                               , "AbstractBorder"
                               , "AbstractButton"
                               , "AbstractCellEditor"
                               , "AbstractCollection"
                               , "AbstractColorChooserPanel"
                               , "AbstractDocument"
                               , "AbstractDocument.AttributeContext"
                               , "AbstractDocument.Content"
                               , "AbstractDocument.ElementEdit"
                               , "AbstractExecutorService"
                               , "AbstractInterruptibleChannel"
                               , "AbstractLayoutCache"
                               , "AbstractLayoutCache.NodeDimensions"
                               , "AbstractList"
                               , "AbstractListModel"
                               , "AbstractMap"
                               , "AbstractMethodError"
                               , "AbstractPreferences"
                               , "AbstractQueue"
                               , "AbstractQueuedSynchronizer"
                               , "AbstractSelectableChannel"
                               , "AbstractSelectionKey"
                               , "AbstractSelector"
                               , "AbstractSequentialList"
                               , "AbstractSet"
                               , "AbstractSpinnerModel"
                               , "AbstractTableModel"
                               , "AbstractUndoableEdit"
                               , "AbstractWriter"
                               , "AccessControlContext"
                               , "AccessControlException"
                               , "AccessController"
                               , "AccessException"
                               , "Accessible"
                               , "AccessibleAction"
                               , "AccessibleAttributeSequence"
                               , "AccessibleBundle"
                               , "AccessibleComponent"
                               , "AccessibleContext"
                               , "AccessibleEditableText"
                               , "AccessibleExtendedComponent"
                               , "AccessibleExtendedTable"
                               , "AccessibleExtendedText"
                               , "AccessibleHyperlink"
                               , "AccessibleHypertext"
                               , "AccessibleIcon"
                               , "AccessibleKeyBinding"
                               , "AccessibleObject"
                               , "AccessibleRelation"
                               , "AccessibleRelationSet"
                               , "AccessibleResourceBundle"
                               , "AccessibleRole"
                               , "AccessibleSelection"
                               , "AccessibleState"
                               , "AccessibleStateSet"
                               , "AccessibleStreamable"
                               , "AccessibleTable"
                               , "AccessibleTableModelChange"
                               , "AccessibleText"
                               , "AccessibleTextSequence"
                               , "AccessibleValue"
                               , "AccountException"
                               , "AccountExpiredException"
                               , "AccountLockedException"
                               , "AccountNotFoundException"
                               , "Acl"
                               , "AclEntry"
                               , "AclNotFoundException"
                               , "Action"
                               , "ActionEvent"
                               , "ActionListener"
                               , "ActionMap"
                               , "ActionMapUIResource"
                               , "Activatable"
                               , "ActivateFailedException"
                               , "ActivationDesc"
                               , "ActivationException"
                               , "ActivationGroup"
                               , "ActivationGroupDesc"
                               , "ActivationGroupDesc.CommandEnvironment"
                               , "ActivationGroupID"
                               , "ActivationGroup_Stub"
                               , "ActivationID"
                               , "ActivationInstantiator"
                               , "ActivationMonitor"
                               , "ActivationSystem"
                               , "Activator"
                               , "ActiveEvent"
                               , "ActivityCompletedException"
                               , "ActivityRequiredException"
                               , "AdapterActivator"
                               , "AdapterActivatorOperations"
                               , "AdapterAlreadyExists"
                               , "AdapterAlreadyExistsHelper"
                               , "AdapterInactive"
                               , "AdapterInactiveHelper"
                               , "AdapterManagerIdHelper"
                               , "AdapterNameHelper"
                               , "AdapterNonExistent"
                               , "AdapterNonExistentHelper"
                               , "AdapterStateHelper"
                               , "AddressHelper"
                               , "Adjustable"
                               , "AdjustmentEvent"
                               , "AdjustmentListener"
                               , "Adler32"
                               , "AffineTransform"
                               , "AffineTransformOp"
                               , "AlgorithmParameterGenerator"
                               , "AlgorithmParameterGeneratorSpi"
                               , "AlgorithmParameterSpec"
                               , "AlgorithmParameters"
                               , "AlgorithmParametersSpi"
                               , "AllPermission"
                               , "AlphaComposite"
                               , "AlreadyBound"
                               , "AlreadyBoundException"
                               , "AlreadyBoundHelper"
                               , "AlreadyBoundHolder"
                               , "AlreadyConnectedException"
                               , "AncestorEvent"
                               , "AncestorListener"
                               , "AnnotatedElement"
                               , "Annotation"
                               , "AnnotationFormatError"
                               , "AnnotationTypeMismatchException"
                               , "Any"
                               , "AnyHolder"
                               , "AnySeqHelper"
                               , "AnySeqHolder"
                               , "AppConfigurationEntry"
                               , "AppConfigurationEntry.LoginModuleControlFlag"
                               , "Appendable"
                               , "Applet"
                               , "AppletContext"
                               , "AppletInitializer"
                               , "AppletStub"
                               , "ApplicationException"
                               , "Arc2D"
                               , "Arc2D.Double"
                               , "Arc2D.Float"
                               , "Area"
                               , "AreaAveragingScaleFilter"
                               , "ArithmeticException"
                               , "Array"
                               , "ArrayBlockingQueue"
                               , "ArrayIndexOutOfBoundsException"
                               , "ArrayList"
                               , "ArrayStoreException"
                               , "ArrayType"
                               , "Arrays"
                               , "AssertionError"
                               , "AsyncBoxView"
                               , "AsynchronousCloseException"
                               , "AtomicBoolean"
                               , "AtomicInteger"
                               , "AtomicIntegerArray"
                               , "AtomicIntegerFieldUpdater"
                               , "AtomicLong"
                               , "AtomicLongArray"
                               , "AtomicLongFieldUpdater"
                               , "AtomicMarkableReference"
                               , "AtomicReference"
                               , "AtomicReferenceArray"
                               , "AtomicReferenceFieldUpdater"
                               , "AtomicStampedReference"
                               , "Attr"
                               , "Attribute"
                               , "AttributeChangeNotification"
                               , "AttributeChangeNotificationFilter"
                               , "AttributeException"
                               , "AttributeInUseException"
                               , "AttributeList"
                               , "AttributeListImpl"
                               , "AttributeModificationException"
                               , "AttributeNotFoundException"
                               , "AttributeSet"
                               , "AttributeSet.CharacterAttribute"
                               , "AttributeSet.ColorAttribute"
                               , "AttributeSet.FontAttribute"
                               , "AttributeSet.ParagraphAttribute"
                               , "AttributeSetUtilities"
                               , "AttributeValueExp"
                               , "AttributedCharacterIterator"
                               , "AttributedCharacterIterator.Attribute"
                               , "AttributedString"
                               , "Attributes"
                               , "Attributes.Name"
                               , "Attributes2"
                               , "Attributes2Impl"
                               , "AttributesImpl"
                               , "AudioClip"
                               , "AudioFileFormat"
                               , "AudioFileFormat.Type"
                               , "AudioFileReader"
                               , "AudioFileWriter"
                               , "AudioFormat"
                               , "AudioFormat.Encoding"
                               , "AudioInputStream"
                               , "AudioPermission"
                               , "AudioSystem"
                               , "AuthPermission"
                               , "AuthProvider"
                               , "AuthenticationException"
                               , "AuthenticationNotSupportedException"
                               , "Authenticator"
                               , "Authenticator.RequestorType"
                               , "AuthorizeCallback"
                               , "Autoscroll"
                               , "BAD_CONTEXT"
                               , "BAD_INV_ORDER"
                               , "BAD_OPERATION"
                               , "BAD_PARAM"
                               , "BAD_POLICY"
                               , "BAD_POLICY_TYPE"
                               , "BAD_POLICY_VALUE"
                               , "BAD_QOS"
                               , "BAD_TYPECODE"
                               , "BMPImageWriteParam"
                               , "BackingStoreException"
                               , "BadAttributeValueExpException"
                               , "BadBinaryOpValueExpException"
                               , "BadKind"
                               , "BadLocationException"
                               , "BadPaddingException"
                               , "BadStringOperationException"
                               , "BandCombineOp"
                               , "BandedSampleModel"
                               , "BaseRowSet"
                               , "BasicArrowButton"
                               , "BasicAttribute"
                               , "BasicAttributes"
                               , "BasicBorders"
                               , "BasicBorders.ButtonBorder"
                               , "BasicBorders.FieldBorder"
                               , "BasicBorders.MarginBorder"
                               , "BasicBorders.MenuBarBorder"
                               , "BasicBorders.RadioButtonBorder"
                               , "BasicBorders.RolloverButtonBorder"
                               , "BasicBorders.SplitPaneBorder"
                               , "BasicBorders.ToggleButtonBorder"
                               , "BasicButtonListener"
                               , "BasicButtonUI"
                               , "BasicCheckBoxMenuItemUI"
                               , "BasicCheckBoxUI"
                               , "BasicColorChooserUI"
                               , "BasicComboBoxEditor"
                               , "BasicComboBoxEditor.UIResource"
                               , "BasicComboBoxRenderer"
                               , "BasicComboBoxRenderer.UIResource"
                               , "BasicComboBoxUI"
                               , "BasicComboPopup"
                               , "BasicControl"
                               , "BasicDesktopIconUI"
                               , "BasicDesktopPaneUI"
                               , "BasicDirectoryModel"
                               , "BasicEditorPaneUI"
                               , "BasicFileChooserUI"
                               , "BasicFormattedTextFieldUI"
                               , "BasicGraphicsUtils"
                               , "BasicHTML"
                               , "BasicIconFactory"
                               , "BasicInternalFrameTitlePane"
                               , "BasicInternalFrameUI"
                               , "BasicLabelUI"
                               , "BasicListUI"
                               , "BasicLookAndFeel"
                               , "BasicMenuBarUI"
                               , "BasicMenuItemUI"
                               , "BasicMenuUI"
                               , "BasicOptionPaneUI"
                               , "BasicOptionPaneUI.ButtonAreaLayout"
                               , "BasicPanelUI"
                               , "BasicPasswordFieldUI"
                               , "BasicPermission"
                               , "BasicPopupMenuSeparatorUI"
                               , "BasicPopupMenuUI"
                               , "BasicProgressBarUI"
                               , "BasicRadioButtonMenuItemUI"
                               , "BasicRadioButtonUI"
                               , "BasicRootPaneUI"
                               , "BasicScrollBarUI"
                               , "BasicScrollPaneUI"
                               , "BasicSeparatorUI"
                               , "BasicSliderUI"
                               , "BasicSpinnerUI"
                               , "BasicSplitPaneDivider"
                               , "BasicSplitPaneUI"
                               , "BasicStroke"
                               , "BasicTabbedPaneUI"
                               , "BasicTableHeaderUI"
                               , "BasicTableUI"
                               , "BasicTextAreaUI"
                               , "BasicTextFieldUI"
                               , "BasicTextPaneUI"
                               , "BasicTextUI"
                               , "BasicTextUI.BasicCaret"
                               , "BasicTextUI.BasicHighlighter"
                               , "BasicToggleButtonUI"
                               , "BasicToolBarSeparatorUI"
                               , "BasicToolBarUI"
                               , "BasicToolTipUI"
                               , "BasicTreeUI"
                               , "BasicViewportUI"
                               , "BatchUpdateException"
                               , "BeanContext"
                               , "BeanContextChild"
                               , "BeanContextChildComponentProxy"
                               , "BeanContextChildSupport"
                               , "BeanContextContainerProxy"
                               , "BeanContextEvent"
                               , "BeanContextMembershipEvent"
                               , "BeanContextMembershipListener"
                               , "BeanContextProxy"
                               , "BeanContextServiceAvailableEvent"
                               , "BeanContextServiceProvider"
                               , "BeanContextServiceProviderBeanInfo"
                               , "BeanContextServiceRevokedEvent"
                               , "BeanContextServiceRevokedListener"
                               , "BeanContextServices"
                               , "BeanContextServicesListener"
                               , "BeanContextServicesSupport"
                               , "BeanContextServicesSupport.BCSSServiceProvider"
                               , "BeanContextSupport"
                               , "BeanContextSupport.BCSIterator"
                               , "BeanDescriptor"
                               , "BeanInfo"
                               , "Beans"
                               , "BevelBorder"
                               , "Bidi"
                               , "BigDecimal"
                               , "BigInteger"
                               , "BinaryRefAddr"
                               , "BindException"
                               , "Binding"
                               , "BindingHelper"
                               , "BindingHolder"
                               , "BindingIterator"
                               , "BindingIteratorHelper"
                               , "BindingIteratorHolder"
                               , "BindingIteratorOperations"
                               , "BindingIteratorPOA"
                               , "BindingListHelper"
                               , "BindingListHolder"
                               , "BindingType"
                               , "BindingTypeHelper"
                               , "BindingTypeHolder"
                               , "BitSet"
                               , "Blob"
                               , "BlockView"
                               , "BlockingQueue"
                               , "Book"
                               , "Boolean"
                               , "BooleanControl"
                               , "BooleanControl.Type"
                               , "BooleanHolder"
                               , "BooleanSeqHelper"
                               , "BooleanSeqHolder"
                               , "Border"
                               , "BorderFactory"
                               , "BorderLayout"
                               , "BorderUIResource"
                               , "BorderUIResource.BevelBorderUIResource"
                               , "BorderUIResource.CompoundBorderUIResource"
                               , "BorderUIResource.EmptyBorderUIResource"
                               , "BorderUIResource.EtchedBorderUIResource"
                               , "BorderUIResource.LineBorderUIResource"
                               , "BorderUIResource.MatteBorderUIResource"
                               , "BorderUIResource.TitledBorderUIResource"
                               , "BoundedRangeModel"
                               , "Bounds"
                               , "Box"
                               , "Box.Filler"
                               , "BoxLayout"
                               , "BoxView"
                               , "BoxedValueHelper"
                               , "BreakIterator"
                               , "BrokenBarrierException"
                               , "Buffer"
                               , "BufferCapabilities"
                               , "BufferCapabilities.FlipContents"
                               , "BufferOverflowException"
                               , "BufferStrategy"
                               , "BufferUnderflowException"
                               , "BufferedImage"
                               , "BufferedImageFilter"
                               , "BufferedImageOp"
                               , "BufferedInputStream"
                               , "BufferedOutputStream"
                               , "BufferedReader"
                               , "BufferedWriter"
                               , "Button"
                               , "ButtonGroup"
                               , "ButtonModel"
                               , "ButtonUI"
                               , "Byte"
                               , "ByteArrayInputStream"
                               , "ByteArrayOutputStream"
                               , "ByteBuffer"
                               , "ByteChannel"
                               , "ByteHolder"
                               , "ByteLookupTable"
                               , "ByteOrder"
                               , "CDATASection"
                               , "CMMException"
                               , "CODESET_INCOMPATIBLE"
                               , "COMM_FAILURE"
                               , "CRC32"
                               , "CRL"
                               , "CRLException"
                               , "CRLSelector"
                               , "CSS"
                               , "CSS.Attribute"
                               , "CTX_RESTRICT_SCOPE"
                               , "CacheRequest"
                               , "CacheResponse"
                               , "CachedRowSet"
                               , "Calendar"
                               , "Callable"
                               , "CallableStatement"
                               , "Callback"
                               , "CallbackHandler"
                               , "CancelablePrintJob"
                               , "CancellationException"
                               , "CancelledKeyException"
                               , "CannotProceed"
                               , "CannotProceedException"
                               , "CannotProceedHelper"
                               , "CannotProceedHolder"
                               , "CannotRedoException"
                               , "CannotUndoException"
                               , "Canvas"
                               , "CardLayout"
                               , "Caret"
                               , "CaretEvent"
                               , "CaretListener"
                               , "CellEditor"
                               , "CellEditorListener"
                               , "CellRendererPane"
                               , "CertPath"
                               , "CertPath.CertPathRep"
                               , "CertPathBuilder"
                               , "CertPathBuilderException"
                               , "CertPathBuilderResult"
                               , "CertPathBuilderSpi"
                               , "CertPathParameters"
                               , "CertPathTrustManagerParameters"
                               , "CertPathValidator"
                               , "CertPathValidatorException"
                               , "CertPathValidatorResult"
                               , "CertPathValidatorSpi"
                               , "CertSelector"
                               , "CertStore"
                               , "CertStoreException"
                               , "CertStoreParameters"
                               , "CertStoreSpi"
                               , "Certificate"
                               , "Certificate.CertificateRep"
                               , "CertificateEncodingException"
                               , "CertificateException"
                               , "CertificateExpiredException"
                               , "CertificateFactory"
                               , "CertificateFactorySpi"
                               , "CertificateNotYetValidException"
                               , "CertificateParsingException"
                               , "ChangeEvent"
                               , "ChangeListener"
                               , "ChangedCharSetException"
                               , "Channel"
                               , "ChannelBinding"
                               , "Channels"
                               , "CharArrayReader"
                               , "CharArrayWriter"
                               , "CharBuffer"
                               , "CharConversionException"
                               , "CharHolder"
                               , "CharSeqHelper"
                               , "CharSeqHolder"
                               , "CharSequence"
                               , "Character"
                               , "Character.Subset"
                               , "Character.UnicodeBlock"
                               , "CharacterCodingException"
                               , "CharacterData"
                               , "CharacterIterator"
                               , "Charset"
                               , "CharsetDecoder"
                               , "CharsetEncoder"
                               , "CharsetProvider"
                               , "Checkbox"
                               , "CheckboxGroup"
                               , "CheckboxMenuItem"
                               , "CheckedInputStream"
                               , "CheckedOutputStream"
                               , "Checksum"
                               , "Choice"
                               , "ChoiceCallback"
                               , "ChoiceFormat"
                               , "Chromaticity"
                               , "Cipher"
                               , "CipherInputStream"
                               , "CipherOutputStream"
                               , "CipherSpi"
                               , "Class"
                               , "ClassCastException"
                               , "ClassCircularityError"
                               , "ClassDefinition"
                               , "ClassDesc"
                               , "ClassFileTransformer"
                               , "ClassFormatError"
                               , "ClassLoader"
                               , "ClassLoaderRepository"
                               , "ClassLoadingMXBean"
                               , "ClassNotFoundException"
                               , "ClientRequestInfo"
                               , "ClientRequestInfoOperations"
                               , "ClientRequestInterceptor"
                               , "ClientRequestInterceptorOperations"
                               , "Clip"
                               , "Clipboard"
                               , "ClipboardOwner"
                               , "Clob"
                               , "CloneNotSupportedException"
                               , "Cloneable"
                               , "Closeable"
                               , "ClosedByInterruptException"
                               , "ClosedChannelException"
                               , "ClosedSelectorException"
                               , "CodeSets"
                               , "CodeSigner"
                               , "CodeSource"
                               , "Codec"
                               , "CodecFactory"
                               , "CodecFactoryHelper"
                               , "CodecFactoryOperations"
                               , "CodecOperations"
                               , "CoderMalfunctionError"
                               , "CoderResult"
                               , "CodingErrorAction"
                               , "CollationElementIterator"
                               , "CollationKey"
                               , "Collator"
                               , "Collection"
                               , "CollectionCertStoreParameters"
                               , "Collections"
                               , "Color"
                               , "ColorChooserComponentFactory"
                               , "ColorChooserUI"
                               , "ColorConvertOp"
                               , "ColorModel"
                               , "ColorSelectionModel"
                               , "ColorSpace"
                               , "ColorSupported"
                               , "ColorType"
                               , "ColorUIResource"
                               , "ComboBoxEditor"
                               , "ComboBoxModel"
                               , "ComboBoxUI"
                               , "ComboPopup"
                               , "Comment"
                               , "CommunicationException"
                               , "Comparable"
                               , "Comparator"
                               , "CompilationMXBean"
                               , "Compiler"
                               , "CompletionService"
                               , "CompletionStatus"
                               , "CompletionStatusHelper"
                               , "Component"
                               , "ComponentAdapter"
                               , "ComponentColorModel"
                               , "ComponentEvent"
                               , "ComponentIdHelper"
                               , "ComponentInputMap"
                               , "ComponentInputMapUIResource"
                               , "ComponentListener"
                               , "ComponentOrientation"
                               , "ComponentSampleModel"
                               , "ComponentUI"
                               , "ComponentView"
                               , "Composite"
                               , "CompositeContext"
                               , "CompositeData"
                               , "CompositeDataSupport"
                               , "CompositeName"
                               , "CompositeType"
                               , "CompositeView"
                               , "CompoundBorder"
                               , "CompoundControl"
                               , "CompoundControl.Type"
                               , "CompoundEdit"
                               , "CompoundName"
                               , "Compression"
                               , "ConcurrentHashMap"
                               , "ConcurrentLinkedQueue"
                               , "ConcurrentMap"
                               , "ConcurrentModificationException"
                               , "Condition"
                               , "Configuration"
                               , "ConfigurationException"
                               , "ConfirmationCallback"
                               , "ConnectException"
                               , "ConnectIOException"
                               , "Connection"
                               , "ConnectionEvent"
                               , "ConnectionEventListener"
                               , "ConnectionPendingException"
                               , "ConnectionPoolDataSource"
                               , "ConsoleHandler"
                               , "Constructor"
                               , "Container"
                               , "ContainerAdapter"
                               , "ContainerEvent"
                               , "ContainerListener"
                               , "ContainerOrderFocusTraversalPolicy"
                               , "ContentHandler"
                               , "ContentHandlerFactory"
                               , "ContentModel"
                               , "Context"
                               , "ContextList"
                               , "ContextNotEmptyException"
                               , "ContextualRenderedImageFactory"
                               , "Control"
                               , "Control.Type"
                               , "ControlFactory"
                               , "ControllerEventListener"
                               , "ConvolveOp"
                               , "CookieHandler"
                               , "CookieHolder"
                               , "Copies"
                               , "CopiesSupported"
                               , "CopyOnWriteArrayList"
                               , "CopyOnWriteArraySet"
                               , "CountDownLatch"
                               , "CounterMonitor"
                               , "CounterMonitorMBean"
                               , "CredentialException"
                               , "CredentialExpiredException"
                               , "CredentialNotFoundException"
                               , "CropImageFilter"
                               , "CubicCurve2D"
                               , "CubicCurve2D.Double"
                               , "CubicCurve2D.Float"
                               , "Currency"
                               , "Current"
                               , "CurrentHelper"
                               , "CurrentHolder"
                               , "CurrentOperations"
                               , "Cursor"
                               , "CustomMarshal"
                               , "CustomValue"
                               , "Customizer"
                               , "CyclicBarrier"
                               , "DATA_CONVERSION"
                               , "DESKeySpec"
                               , "DESedeKeySpec"
                               , "DGC"
                               , "DHGenParameterSpec"
                               , "DHKey"
                               , "DHParameterSpec"
                               , "DHPrivateKey"
                               , "DHPrivateKeySpec"
                               , "DHPublicKey"
                               , "DHPublicKeySpec"
                               , "DISCARDING"
                               , "DOMConfiguration"
                               , "DOMError"
                               , "DOMErrorHandler"
                               , "DOMException"
                               , "DOMImplementation"
                               , "DOMImplementationLS"
                               , "DOMImplementationList"
                               , "DOMImplementationRegistry"
                               , "DOMImplementationSource"
                               , "DOMLocator"
                               , "DOMResult"
                               , "DOMSource"
                               , "DOMStringList"
                               , "DSAKey"
                               , "DSAKeyPairGenerator"
                               , "DSAParameterSpec"
                               , "DSAParams"
                               , "DSAPrivateKey"
                               , "DSAPrivateKeySpec"
                               , "DSAPublicKey"
                               , "DSAPublicKeySpec"
                               , "DTD"
                               , "DTDConstants"
                               , "DTDHandler"
                               , "DataBuffer"
                               , "DataBufferByte"
                               , "DataBufferDouble"
                               , "DataBufferFloat"
                               , "DataBufferInt"
                               , "DataBufferShort"
                               , "DataBufferUShort"
                               , "DataFlavor"
                               , "DataFormatException"
                               , "DataInput"
                               , "DataInputStream"
                               , "DataLine"
                               , "DataLine.Info"
                               , "DataOutput"
                               , "DataOutputStream"
                               , "DataSource"
                               , "DataTruncation"
                               , "DatabaseMetaData"
                               , "DatagramChannel"
                               , "DatagramPacket"
                               , "DatagramSocket"
                               , "DatagramSocketImpl"
                               , "DatagramSocketImplFactory"
                               , "DatatypeConfigurationException"
                               , "DatatypeConstants"
                               , "DatatypeConstants.Field"
                               , "DatatypeFactory"
                               , "Date"
                               , "DateFormat"
                               , "DateFormat.Field"
                               , "DateFormatSymbols"
                               , "DateFormatter"
                               , "DateTimeAtCompleted"
                               , "DateTimeAtCreation"
                               , "DateTimeAtProcessing"
                               , "DateTimeSyntax"
                               , "DebugGraphics"
                               , "DecimalFormat"
                               , "DecimalFormatSymbols"
                               , "DeclHandler"
                               , "DefaultBoundedRangeModel"
                               , "DefaultButtonModel"
                               , "DefaultCaret"
                               , "DefaultCellEditor"
                               , "DefaultColorSelectionModel"
                               , "DefaultComboBoxModel"
                               , "DefaultDesktopManager"
                               , "DefaultEditorKit"
                               , "DefaultEditorKit.BeepAction"
                               , "DefaultEditorKit.CopyAction"
                               , "DefaultEditorKit.CutAction"
                               , "DefaultEditorKit.DefaultKeyTypedAction"
                               , "DefaultEditorKit.InsertBreakAction"
                               , "DefaultEditorKit.InsertContentAction"
                               , "DefaultEditorKit.InsertTabAction"
                               , "DefaultEditorKit.PasteAction"
                               , "DefaultFocusManager"
                               , "DefaultFocusTraversalPolicy"
                               , "DefaultFormatter"
                               , "DefaultFormatterFactory"
                               , "DefaultHandler"
                               , "DefaultHandler2"
                               , "DefaultHighlighter"
                               , "DefaultHighlighter.DefaultHighlightPainter"
                               , "DefaultKeyboardFocusManager"
                               , "DefaultListCellRenderer"
                               , "DefaultListCellRenderer.UIResource"
                               , "DefaultListModel"
                               , "DefaultListSelectionModel"
                               , "DefaultLoaderRepository"
                               , "DefaultMenuLayout"
                               , "DefaultMetalTheme"
                               , "DefaultMutableTreeNode"
                               , "DefaultPersistenceDelegate"
                               , "DefaultSingleSelectionModel"
                               , "DefaultStyledDocument"
                               , "DefaultStyledDocument.AttributeUndoableEdit"
                               , "DefaultStyledDocument.ElementSpec"
                               , "DefaultTableCellRenderer"
                               , "DefaultTableCellRenderer.UIResource"
                               , "DefaultTableColumnModel"
                               , "DefaultTableModel"
                               , "DefaultTextUI"
                               , "DefaultTreeCellEditor"
                               , "DefaultTreeCellRenderer"
                               , "DefaultTreeModel"
                               , "DefaultTreeSelectionModel"
                               , "DefinitionKind"
                               , "DefinitionKindHelper"
                               , "Deflater"
                               , "DeflaterOutputStream"
                               , "DelayQueue"
                               , "Delayed"
                               , "Delegate"
                               , "DelegationPermission"
                               , "Deprecated"
                               , "Descriptor"
                               , "DescriptorAccess"
                               , "DescriptorSupport"
                               , "DesignMode"
                               , "DesktopIconUI"
                               , "DesktopManager"
                               , "DesktopPaneUI"
                               , "Destination"
                               , "DestroyFailedException"
                               , "Destroyable"
                               , "Dialog"
                               , "Dictionary"
                               , "DigestException"
                               , "DigestInputStream"
                               , "DigestOutputStream"
                               , "Dimension"
                               , "Dimension2D"
                               , "DimensionUIResource"
                               , "DirContext"
                               , "DirObjectFactory"
                               , "DirStateFactory"
                               , "DirStateFactory.Result"
                               , "DirectColorModel"
                               , "DirectoryManager"
                               , "DisplayMode"
                               , "DnDConstants"
                               , "Doc"
                               , "DocAttribute"
                               , "DocAttributeSet"
                               , "DocFlavor"
                               , "DocFlavor.BYTE_ARRAY"
                               , "DocFlavor.CHAR_ARRAY"
                               , "DocFlavor.INPUT_STREAM"
                               , "DocFlavor.READER"
                               , "DocFlavor.SERVICE_FORMATTED"
                               , "DocFlavor.STRING"
                               , "DocFlavor.URL"
                               , "DocPrintJob"
                               , "Document"
                               , "DocumentBuilder"
                               , "DocumentBuilderFactory"
                               , "DocumentEvent"
                               , "DocumentEvent.ElementChange"
                               , "DocumentEvent.EventType"
                               , "DocumentFilter"
                               , "DocumentFilter.FilterBypass"
                               , "DocumentFragment"
                               , "DocumentHandler"
                               , "DocumentListener"
                               , "DocumentName"
                               , "DocumentParser"
                               , "DocumentType"
                               , "Documented"
                               , "DomainCombiner"
                               , "DomainManager"
                               , "DomainManagerOperations"
                               , "Double"
                               , "DoubleBuffer"
                               , "DoubleHolder"
                               , "DoubleSeqHelper"
                               , "DoubleSeqHolder"
                               , "DragGestureEvent"
                               , "DragGestureListener"
                               , "DragGestureRecognizer"
                               , "DragSource"
                               , "DragSourceAdapter"
                               , "DragSourceContext"
                               , "DragSourceDragEvent"
                               , "DragSourceDropEvent"
                               , "DragSourceEvent"
                               , "DragSourceListener"
                               , "DragSourceMotionListener"
                               , "Driver"
                               , "DriverManager"
                               , "DriverPropertyInfo"
                               , "DropTarget"
                               , "DropTarget.DropTargetAutoScroller"
                               , "DropTargetAdapter"
                               , "DropTargetContext"
                               , "DropTargetDragEvent"
                               , "DropTargetDropEvent"
                               , "DropTargetEvent"
                               , "DropTargetListener"
                               , "DuplicateFormatFlagsException"
                               , "DuplicateName"
                               , "DuplicateNameHelper"
                               , "Duration"
                               , "DynAny"
                               , "DynAnyFactory"
                               , "DynAnyFactoryHelper"
                               , "DynAnyFactoryOperations"
                               , "DynAnyHelper"
                               , "DynAnyOperations"
                               , "DynAnySeqHelper"
                               , "DynArray"
                               , "DynArrayHelper"
                               , "DynArrayOperations"
                               , "DynEnum"
                               , "DynEnumHelper"
                               , "DynEnumOperations"
                               , "DynFixed"
                               , "DynFixedHelper"
                               , "DynFixedOperations"
                               , "DynSequence"
                               , "DynSequenceHelper"
                               , "DynSequenceOperations"
                               , "DynStruct"
                               , "DynStructHelper"
                               , "DynStructOperations"
                               , "DynUnion"
                               , "DynUnionHelper"
                               , "DynUnionOperations"
                               , "DynValue"
                               , "DynValueBox"
                               , "DynValueBoxOperations"
                               , "DynValueCommon"
                               , "DynValueCommonOperations"
                               , "DynValueHelper"
                               , "DynValueOperations"
                               , "DynamicImplementation"
                               , "DynamicMBean"
                               , "ECField"
                               , "ECFieldF2m"
                               , "ECFieldFp"
                               , "ECGenParameterSpec"
                               , "ECKey"
                               , "ECParameterSpec"
                               , "ECPoint"
                               , "ECPrivateKey"
                               , "ECPrivateKeySpec"
                               , "ECPublicKey"
                               , "ECPublicKeySpec"
                               , "ENCODING_CDR_ENCAPS"
                               , "EOFException"
                               , "EditorKit"
                               , "Element"
                               , "ElementIterator"
                               , "ElementType"
                               , "Ellipse2D"
                               , "Ellipse2D.Double"
                               , "Ellipse2D.Float"
                               , "EllipticCurve"
                               , "EmptyBorder"
                               , "EmptyStackException"
                               , "EncodedKeySpec"
                               , "Encoder"
                               , "Encoding"
                               , "EncryptedPrivateKeyInfo"
                               , "Entity"
                               , "EntityReference"
                               , "EntityResolver"
                               , "EntityResolver2"
                               , "Enum"
                               , "EnumConstantNotPresentException"
                               , "EnumControl"
                               , "EnumControl.Type"
                               , "EnumMap"
                               , "EnumSet"
                               , "EnumSyntax"
                               , "Enumeration"
                               , "Environment"
                               , "Error"
                               , "ErrorHandler"
                               , "ErrorListener"
                               , "ErrorManager"
                               , "EtchedBorder"
                               , "Event"
                               , "EventContext"
                               , "EventDirContext"
                               , "EventHandler"
                               , "EventListener"
                               , "EventListenerList"
                               , "EventListenerProxy"
                               , "EventObject"
                               , "EventQueue"
                               , "EventSetDescriptor"
                               , "Exception"
                               , "ExceptionDetailMessage"
                               , "ExceptionInInitializerError"
                               , "ExceptionList"
                               , "ExceptionListener"
                               , "Exchanger"
                               , "ExecutionException"
                               , "Executor"
                               , "ExecutorCompletionService"
                               , "ExecutorService"
                               , "Executors"
                               , "ExemptionMechanism"
                               , "ExemptionMechanismException"
                               , "ExemptionMechanismSpi"
                               , "ExpandVetoException"
                               , "ExportException"
                               , "Expression"
                               , "ExtendedRequest"
                               , "ExtendedResponse"
                               , "Externalizable"
                               , "FREE_MEM"
                               , "FactoryConfigurationError"
                               , "FailedLoginException"
                               , "FeatureDescriptor"
                               , "Fidelity"
                               , "Field"
                               , "FieldNameHelper"
                               , "FieldPosition"
                               , "FieldView"
                               , "File"
                               , "FileCacheImageInputStream"
                               , "FileCacheImageOutputStream"
                               , "FileChannel"
                               , "FileChannel.MapMode"
                               , "FileChooserUI"
                               , "FileDescriptor"
                               , "FileDialog"
                               , "FileFilter"
                               , "FileHandler"
                               , "FileImageInputStream"
                               , "FileImageOutputStream"
                               , "FileInputStream"
                               , "FileLock"
                               , "FileLockInterruptionException"
                               , "FileNameMap"
                               , "FileNotFoundException"
                               , "FileOutputStream"
                               , "FilePermission"
                               , "FileReader"
                               , "FileSystemView"
                               , "FileView"
                               , "FileWriter"
                               , "FilenameFilter"
                               , "Filter"
                               , "FilterInputStream"
                               , "FilterOutputStream"
                               , "FilterReader"
                               , "FilterWriter"
                               , "FilteredImageSource"
                               , "FilteredRowSet"
                               , "Finishings"
                               , "FixedHeightLayoutCache"
                               , "FixedHolder"
                               , "FlatteningPathIterator"
                               , "FlavorEvent"
                               , "FlavorException"
                               , "FlavorListener"
                               , "FlavorMap"
                               , "FlavorTable"
                               , "Float"
                               , "FloatBuffer"
                               , "FloatControl"
                               , "FloatControl.Type"
                               , "FloatHolder"
                               , "FloatSeqHelper"
                               , "FloatSeqHolder"
                               , "FlowLayout"
                               , "FlowView"
                               , "FlowView.FlowStrategy"
                               , "Flushable"
                               , "FocusAdapter"
                               , "FocusEvent"
                               , "FocusListener"
                               , "FocusManager"
                               , "FocusTraversalPolicy"
                               , "Font"
                               , "FontFormatException"
                               , "FontMetrics"
                               , "FontRenderContext"
                               , "FontUIResource"
                               , "FormSubmitEvent"
                               , "FormSubmitEvent.MethodType"
                               , "FormView"
                               , "Format"
                               , "Format.Field"
                               , "FormatConversionProvider"
                               , "FormatFlagsConversionMismatchException"
                               , "FormatMismatch"
                               , "FormatMismatchHelper"
                               , "Formattable"
                               , "FormattableFlags"
                               , "Formatter"
                               , "FormatterClosedException"
                               , "ForwardRequest"
                               , "ForwardRequestHelper"
                               , "Frame"
                               , "Future"
                               , "FutureTask"
                               , "GSSContext"
                               , "GSSCredential"
                               , "GSSException"
                               , "GSSManager"
                               , "GSSName"
                               , "GZIPInputStream"
                               , "GZIPOutputStream"
                               , "GapContent"
                               , "GarbageCollectorMXBean"
                               , "GatheringByteChannel"
                               , "GaugeMonitor"
                               , "GaugeMonitorMBean"
                               , "GeneralPath"
                               , "GeneralSecurityException"
                               , "GenericArrayType"
                               , "GenericDeclaration"
                               , "GenericSignatureFormatError"
                               , "GlyphJustificationInfo"
                               , "GlyphMetrics"
                               , "GlyphVector"
                               , "GlyphView"
                               , "GlyphView.GlyphPainter"
                               , "GradientPaint"
                               , "GraphicAttribute"
                               , "Graphics"
                               , "Graphics2D"
                               , "GraphicsConfigTemplate"
                               , "GraphicsConfiguration"
                               , "GraphicsDevice"
                               , "GraphicsEnvironment"
                               , "GrayFilter"
                               , "GregorianCalendar"
                               , "GridBagConstraints"
                               , "GridBagLayout"
                               , "GridLayout"
                               , "Group"
                               , "Guard"
                               , "GuardedObject"
                               , "HOLDING"
                               , "HTML"
                               , "HTML.Attribute"
                               , "HTML.Tag"
                               , "HTML.UnknownTag"
                               , "HTMLDocument"
                               , "HTMLDocument.Iterator"
                               , "HTMLEditorKit"
                               , "HTMLEditorKit.HTMLFactory"
                               , "HTMLEditorKit.HTMLTextAction"
                               , "HTMLEditorKit.InsertHTMLTextAction"
                               , "HTMLEditorKit.LinkController"
                               , "HTMLEditorKit.Parser"
                               , "HTMLEditorKit.ParserCallback"
                               , "HTMLFrameHyperlinkEvent"
                               , "HTMLWriter"
                               , "Handler"
                               , "HandlerBase"
                               , "HandshakeCompletedEvent"
                               , "HandshakeCompletedListener"
                               , "HasControls"
                               , "HashAttributeSet"
                               , "HashDocAttributeSet"
                               , "HashMap"
                               , "HashPrintJobAttributeSet"
                               , "HashPrintRequestAttributeSet"
                               , "HashPrintServiceAttributeSet"
                               , "HashSet"
                               , "Hashtable"
                               , "HeadlessException"
                               , "HierarchyBoundsAdapter"
                               , "HierarchyBoundsListener"
                               , "HierarchyEvent"
                               , "HierarchyListener"
                               , "Highlighter"
                               , "Highlighter.Highlight"
                               , "Highlighter.HighlightPainter"
                               , "HostnameVerifier"
                               , "HttpRetryException"
                               , "HttpURLConnection"
                               , "HttpsURLConnection"
                               , "HyperlinkEvent"
                               , "HyperlinkEvent.EventType"
                               , "HyperlinkListener"
                               , "ICC_ColorSpace"
                               , "ICC_Profile"
                               , "ICC_ProfileGray"
                               , "ICC_ProfileRGB"
                               , "IDLEntity"
                               , "IDLType"
                               , "IDLTypeHelper"
                               , "IDLTypeOperations"
                               , "ID_ASSIGNMENT_POLICY_ID"
                               , "ID_UNIQUENESS_POLICY_ID"
                               , "IIOByteBuffer"
                               , "IIOException"
                               , "IIOImage"
                               , "IIOInvalidTreeException"
                               , "IIOMetadata"
                               , "IIOMetadataController"
                               , "IIOMetadataFormat"
                               , "IIOMetadataFormatImpl"
                               , "IIOMetadataNode"
                               , "IIOParam"
                               , "IIOParamController"
                               , "IIOReadProgressListener"
                               , "IIOReadUpdateListener"
                               , "IIOReadWarningListener"
                               , "IIORegistry"
                               , "IIOServiceProvider"
                               , "IIOWriteProgressListener"
                               , "IIOWriteWarningListener"
                               , "IMPLICIT_ACTIVATION_POLICY_ID"
                               , "IMP_LIMIT"
                               , "INACTIVE"
                               , "INITIALIZE"
                               , "INTERNAL"
                               , "INTF_REPOS"
                               , "INVALID_ACTIVITY"
                               , "INVALID_TRANSACTION"
                               , "INV_FLAG"
                               , "INV_IDENT"
                               , "INV_OBJREF"
                               , "INV_POLICY"
                               , "IOException"
                               , "IOR"
                               , "IORHelper"
                               , "IORHolder"
                               , "IORInfo"
                               , "IORInfoOperations"
                               , "IORInterceptor"
                               , "IORInterceptorOperations"
                               , "IORInterceptor_3_0"
                               , "IORInterceptor_3_0Helper"
                               , "IORInterceptor_3_0Holder"
                               , "IORInterceptor_3_0Operations"
                               , "IRObject"
                               , "IRObjectOperations"
                               , "Icon"
                               , "IconUIResource"
                               , "IconView"
                               , "IdAssignmentPolicy"
                               , "IdAssignmentPolicyOperations"
                               , "IdAssignmentPolicyValue"
                               , "IdUniquenessPolicy"
                               , "IdUniquenessPolicyOperations"
                               , "IdUniquenessPolicyValue"
                               , "IdentifierHelper"
                               , "Identity"
                               , "IdentityHashMap"
                               , "IdentityScope"
                               , "IllegalAccessError"
                               , "IllegalAccessException"
                               , "IllegalArgumentException"
                               , "IllegalBlockSizeException"
                               , "IllegalBlockingModeException"
                               , "IllegalCharsetNameException"
                               , "IllegalClassFormatException"
                               , "IllegalComponentStateException"
                               , "IllegalFormatCodePointException"
                               , "IllegalFormatConversionException"
                               , "IllegalFormatException"
                               , "IllegalFormatFlagsException"
                               , "IllegalFormatPrecisionException"
                               , "IllegalFormatWidthException"
                               , "IllegalMonitorStateException"
                               , "IllegalPathStateException"
                               , "IllegalSelectorException"
                               , "IllegalStateException"
                               , "IllegalThreadStateException"
                               , "Image"
                               , "ImageCapabilities"
                               , "ImageConsumer"
                               , "ImageFilter"
                               , "ImageGraphicAttribute"
                               , "ImageIO"
                               , "ImageIcon"
                               , "ImageInputStream"
                               , "ImageInputStreamImpl"
                               , "ImageInputStreamSpi"
                               , "ImageObserver"
                               , "ImageOutputStream"
                               , "ImageOutputStreamImpl"
                               , "ImageOutputStreamSpi"
                               , "ImageProducer"
                               , "ImageReadParam"
                               , "ImageReader"
                               , "ImageReaderSpi"
                               , "ImageReaderWriterSpi"
                               , "ImageTranscoder"
                               , "ImageTranscoderSpi"
                               , "ImageTypeSpecifier"
                               , "ImageView"
                               , "ImageWriteParam"
                               , "ImageWriter"
                               , "ImageWriterSpi"
                               , "ImagingOpException"
                               , "ImplicitActivationPolicy"
                               , "ImplicitActivationPolicyOperations"
                               , "ImplicitActivationPolicyValue"
                               , "IncompatibleClassChangeError"
                               , "IncompleteAnnotationException"
                               , "InconsistentTypeCode"
                               , "InconsistentTypeCodeHelper"
                               , "IndexColorModel"
                               , "IndexOutOfBoundsException"
                               , "IndexedPropertyChangeEvent"
                               , "IndexedPropertyDescriptor"
                               , "IndirectionException"
                               , "Inet4Address"
                               , "Inet6Address"
                               , "InetAddress"
                               , "InetSocketAddress"
                               , "Inflater"
                               , "InflaterInputStream"
                               , "InheritableThreadLocal"
                               , "Inherited"
                               , "InitialContext"
                               , "InitialContextFactory"
                               , "InitialContextFactoryBuilder"
                               , "InitialDirContext"
                               , "InitialLdapContext"
                               , "InlineView"
                               , "InputContext"
                               , "InputEvent"
                               , "InputMap"
                               , "InputMapUIResource"
                               , "InputMethod"
                               , "InputMethodContext"
                               , "InputMethodDescriptor"
                               , "InputMethodEvent"
                               , "InputMethodHighlight"
                               , "InputMethodListener"
                               , "InputMethodRequests"
                               , "InputMismatchException"
                               , "InputSource"
                               , "InputStream"
                               , "InputStreamReader"
                               , "InputSubset"
                               , "InputVerifier"
                               , "Insets"
                               , "InsetsUIResource"
                               , "InstanceAlreadyExistsException"
                               , "InstanceNotFoundException"
                               , "InstantiationError"
                               , "InstantiationException"
                               , "Instrument"
                               , "Instrumentation"
                               , "InsufficientResourcesException"
                               , "IntBuffer"
                               , "IntHolder"
                               , "Integer"
                               , "IntegerSyntax"
                               , "Interceptor"
                               , "InterceptorOperations"
                               , "InternalError"
                               , "InternalFrameAdapter"
                               , "InternalFrameEvent"
                               , "InternalFrameFocusTraversalPolicy"
                               , "InternalFrameListener"
                               , "InternalFrameUI"
                               , "InternationalFormatter"
                               , "InterruptedException"
                               , "InterruptedIOException"
                               , "InterruptedNamingException"
                               , "InterruptibleChannel"
                               , "IntrospectionException"
                               , "Introspector"
                               , "Invalid"
                               , "InvalidActivityException"
                               , "InvalidAddress"
                               , "InvalidAddressHelper"
                               , "InvalidAddressHolder"
                               , "InvalidAlgorithmParameterException"
                               , "InvalidApplicationException"
                               , "InvalidAttributeIdentifierException"
                               , "InvalidAttributeValueException"
                               , "InvalidAttributesException"
                               , "InvalidClassException"
                               , "InvalidDnDOperationException"
                               , "InvalidKeyException"
                               , "InvalidKeySpecException"
                               , "InvalidMarkException"
                               , "InvalidMidiDataException"
                               , "InvalidName"
                               , "InvalidNameException"
                               , "InvalidNameHelper"
                               , "InvalidNameHolder"
                               , "InvalidObjectException"
                               , "InvalidOpenTypeException"
                               , "InvalidParameterException"
                               , "InvalidParameterSpecException"
                               , "InvalidPolicy"
                               , "InvalidPolicyHelper"
                               , "InvalidPreferencesFormatException"
                               , "InvalidPropertiesFormatException"
                               , "InvalidRelationIdException"
                               , "InvalidRelationServiceException"
                               , "InvalidRelationTypeException"
                               , "InvalidRoleInfoException"
                               , "InvalidRoleValueException"
                               , "InvalidSearchControlsException"
                               , "InvalidSearchFilterException"
                               , "InvalidSeq"
                               , "InvalidSlot"
                               , "InvalidSlotHelper"
                               , "InvalidTargetObjectTypeException"
                               , "InvalidTransactionException"
                               , "InvalidTypeForEncoding"
                               , "InvalidTypeForEncodingHelper"
                               , "InvalidValue"
                               , "InvalidValueHelper"
                               , "InvocationEvent"
                               , "InvocationHandler"
                               , "InvocationTargetException"
                               , "InvokeHandler"
                               , "IstringHelper"
                               , "ItemEvent"
                               , "ItemListener"
                               , "ItemSelectable"
                               , "Iterable"
                               , "Iterator"
                               , "IvParameterSpec"
                               , "JApplet"
                               , "JButton"
                               , "JCheckBox"
                               , "JCheckBoxMenuItem"
                               , "JColorChooser"
                               , "JComboBox"
                               , "JComboBox.KeySelectionManager"
                               , "JComponent"
                               , "JDesktopPane"
                               , "JDialog"
                               , "JEditorPane"
                               , "JFileChooser"
                               , "JFormattedTextField"
                               , "JFormattedTextField.AbstractFormatter"
                               , "JFormattedTextField.AbstractFormatterFactory"
                               , "JFrame"
                               , "JInternalFrame"
                               , "JInternalFrame.JDesktopIcon"
                               , "JLabel"
                               , "JLayeredPane"
                               , "JList"
                               , "JMException"
                               , "JMRuntimeException"
                               , "JMXAuthenticator"
                               , "JMXConnectionNotification"
                               , "JMXConnector"
                               , "JMXConnectorFactory"
                               , "JMXConnectorProvider"
                               , "JMXConnectorServer"
                               , "JMXConnectorServerFactory"
                               , "JMXConnectorServerMBean"
                               , "JMXConnectorServerProvider"
                               , "JMXPrincipal"
                               , "JMXProviderException"
                               , "JMXServerErrorException"
                               , "JMXServiceURL"
                               , "JMenu"
                               , "JMenuBar"
                               , "JMenuItem"
                               , "JOptionPane"
                               , "JPEGHuffmanTable"
                               , "JPEGImageReadParam"
                               , "JPEGImageWriteParam"
                               , "JPEGQTable"
                               , "JPanel"
                               , "JPasswordField"
                               , "JPopupMenu"
                               , "JPopupMenu.Separator"
                               , "JProgressBar"
                               , "JRadioButton"
                               , "JRadioButtonMenuItem"
                               , "JRootPane"
                               , "JScrollBar"
                               , "JScrollPane"
                               , "JSeparator"
                               , "JSlider"
                               , "JSpinner"
                               , "JSpinner.DateEditor"
                               , "JSpinner.DefaultEditor"
                               , "JSpinner.ListEditor"
                               , "JSpinner.NumberEditor"
                               , "JSplitPane"
                               , "JTabbedPane"
                               , "JTable"
                               , "JTable.PrintMode"
                               , "JTableHeader"
                               , "JTextArea"
                               , "JTextComponent"
                               , "JTextComponent.KeyBinding"
                               , "JTextField"
                               , "JTextPane"
                               , "JToggleButton"
                               , "JToggleButton.ToggleButtonModel"
                               , "JToolBar"
                               , "JToolBar.Separator"
                               , "JToolTip"
                               , "JTree"
                               , "JTree.DynamicUtilTreeNode"
                               , "JTree.EmptySelectionModel"
                               , "JViewport"
                               , "JWindow"
                               , "JarEntry"
                               , "JarException"
                               , "JarFile"
                               , "JarInputStream"
                               , "JarOutputStream"
                               , "JarURLConnection"
                               , "JdbcRowSet"
                               , "JobAttributes"
                               , "JobAttributes.DefaultSelectionType"
                               , "JobAttributes.DestinationType"
                               , "JobAttributes.DialogType"
                               , "JobAttributes.MultipleDocumentHandlingType"
                               , "JobAttributes.SidesType"
                               , "JobHoldUntil"
                               , "JobImpressions"
                               , "JobImpressionsCompleted"
                               , "JobImpressionsSupported"
                               , "JobKOctets"
                               , "JobKOctetsProcessed"
                               , "JobKOctetsSupported"
                               , "JobMediaSheets"
                               , "JobMediaSheetsCompleted"
                               , "JobMediaSheetsSupported"
                               , "JobMessageFromOperator"
                               , "JobName"
                               , "JobOriginatingUserName"
                               , "JobPriority"
                               , "JobPrioritySupported"
                               , "JobSheets"
                               , "JobState"
                               , "JobStateReason"
                               , "JobStateReasons"
                               , "JoinRowSet"
                               , "Joinable"
                               , "KerberosKey"
                               , "KerberosPrincipal"
                               , "KerberosTicket"
                               , "Kernel"
                               , "Key"
                               , "KeyAdapter"
                               , "KeyAgreement"
                               , "KeyAgreementSpi"
                               , "KeyAlreadyExistsException"
                               , "KeyEvent"
                               , "KeyEventDispatcher"
                               , "KeyEventPostProcessor"
                               , "KeyException"
                               , "KeyFactory"
                               , "KeyFactorySpi"
                               , "KeyGenerator"
                               , "KeyGeneratorSpi"
                               , "KeyListener"
                               , "KeyManagementException"
                               , "KeyManager"
                               , "KeyManagerFactory"
                               , "KeyManagerFactorySpi"
                               , "KeyPair"
                               , "KeyPairGenerator"
                               , "KeyPairGeneratorSpi"
                               , "KeyRep"
                               , "KeyRep.Type"
                               , "KeySpec"
                               , "KeyStore"
                               , "KeyStore.Builder"
                               , "KeyStore.CallbackHandlerProtection"
                               , "KeyStore.Entry"
                               , "KeyStore.LoadStoreParameter"
                               , "KeyStore.PasswordProtection"
                               , "KeyStore.PrivateKeyEntry"
                               , "KeyStore.ProtectionParameter"
                               , "KeyStore.SecretKeyEntry"
                               , "KeyStore.TrustedCertificateEntry"
                               , "KeyStoreBuilderParameters"
                               , "KeyStoreException"
                               , "KeyStoreSpi"
                               , "KeyStroke"
                               , "KeyboardFocusManager"
                               , "Keymap"
                               , "LDAPCertStoreParameters"
                               , "LIFESPAN_POLICY_ID"
                               , "LOCATION_FORWARD"
                               , "LSException"
                               , "LSInput"
                               , "LSLoadEvent"
                               , "LSOutput"
                               , "LSParser"
                               , "LSParserFilter"
                               , "LSProgressEvent"
                               , "LSResourceResolver"
                               , "LSSerializer"
                               , "LSSerializerFilter"
                               , "Label"
                               , "LabelUI"
                               , "LabelView"
                               , "LanguageCallback"
                               , "LastOwnerException"
                               , "LayeredHighlighter"
                               , "LayeredHighlighter.LayerPainter"
                               , "LayoutFocusTraversalPolicy"
                               , "LayoutManager"
                               , "LayoutManager2"
                               , "LayoutQueue"
                               , "LdapContext"
                               , "LdapName"
                               , "LdapReferralException"
                               , "Lease"
                               , "Level"
                               , "LexicalHandler"
                               , "LifespanPolicy"
                               , "LifespanPolicyOperations"
                               , "LifespanPolicyValue"
                               , "LimitExceededException"
                               , "Line"
                               , "Line.Info"
                               , "Line2D"
                               , "Line2D.Double"
                               , "Line2D.Float"
                               , "LineBorder"
                               , "LineBreakMeasurer"
                               , "LineEvent"
                               , "LineEvent.Type"
                               , "LineListener"
                               , "LineMetrics"
                               , "LineNumberInputStream"
                               , "LineNumberReader"
                               , "LineUnavailableException"
                               , "LinkException"
                               , "LinkLoopException"
                               , "LinkRef"
                               , "LinkageError"
                               , "LinkedBlockingQueue"
                               , "LinkedHashMap"
                               , "LinkedHashSet"
                               , "LinkedList"
                               , "List"
                               , "ListCellRenderer"
                               , "ListDataEvent"
                               , "ListDataListener"
                               , "ListIterator"
                               , "ListModel"
                               , "ListResourceBundle"
                               , "ListSelectionEvent"
                               , "ListSelectionListener"
                               , "ListSelectionModel"
                               , "ListUI"
                               , "ListView"
                               , "ListenerNotFoundException"
                               , "LoaderHandler"
                               , "LocalObject"
                               , "Locale"
                               , "LocateRegistry"
                               , "Locator"
                               , "Locator2"
                               , "Locator2Impl"
                               , "LocatorImpl"
                               , "Lock"
                               , "LockSupport"
                               , "LogManager"
                               , "LogRecord"
                               , "LogStream"
                               , "Logger"
                               , "LoggingMXBean"
                               , "LoggingPermission"
                               , "LoginContext"
                               , "LoginException"
                               , "LoginModule"
                               , "Long"
                               , "LongBuffer"
                               , "LongHolder"
                               , "LongLongSeqHelper"
                               , "LongLongSeqHolder"
                               , "LongSeqHelper"
                               , "LongSeqHolder"
                               , "LookAndFeel"
                               , "LookupOp"
                               , "LookupTable"
                               , "MARSHAL"
                               , "MBeanAttributeInfo"
                               , "MBeanConstructorInfo"
                               , "MBeanException"
                               , "MBeanFeatureInfo"
                               , "MBeanInfo"
                               , "MBeanNotificationInfo"
                               , "MBeanOperationInfo"
                               , "MBeanParameterInfo"
                               , "MBeanPermission"
                               , "MBeanRegistration"
                               , "MBeanRegistrationException"
                               , "MBeanServer"
                               , "MBeanServerBuilder"
                               , "MBeanServerConnection"
                               , "MBeanServerDelegate"
                               , "MBeanServerDelegateMBean"
                               , "MBeanServerFactory"
                               , "MBeanServerForwarder"
                               , "MBeanServerInvocationHandler"
                               , "MBeanServerNotification"
                               , "MBeanServerNotificationFilter"
                               , "MBeanServerPermission"
                               , "MBeanTrustPermission"
                               , "MGF1ParameterSpec"
                               , "MLet"
                               , "MLetMBean"
                               , "Mac"
                               , "MacSpi"
                               , "MalformedInputException"
                               , "MalformedLinkException"
                               , "MalformedObjectNameException"
                               , "MalformedParameterizedTypeException"
                               , "MalformedURLException"
                               , "ManageReferralControl"
                               , "ManagementFactory"
                               , "ManagementPermission"
                               , "ManagerFactoryParameters"
                               , "Manifest"
                               , "Map"
                               , "Map.Entry"
                               , "MappedByteBuffer"
                               , "MarshalException"
                               , "MarshalledObject"
                               , "MaskFormatter"
                               , "MatchResult"
                               , "Matcher"
                               , "Math"
                               , "MathContext"
                               , "MatteBorder"
                               , "Media"
                               , "MediaName"
                               , "MediaPrintableArea"
                               , "MediaSize"
                               , "MediaSize.Engineering"
                               , "MediaSize.ISO"
                               , "MediaSize.JIS"
                               , "MediaSize.NA"
                               , "MediaSize.Other"
                               , "MediaSizeName"
                               , "MediaTracker"
                               , "MediaTray"
                               , "Member"
                               , "MemoryCacheImageInputStream"
                               , "MemoryCacheImageOutputStream"
                               , "MemoryHandler"
                               , "MemoryImageSource"
                               , "MemoryMXBean"
                               , "MemoryManagerMXBean"
                               , "MemoryNotificationInfo"
                               , "MemoryPoolMXBean"
                               , "MemoryType"
                               , "MemoryUsage"
                               , "Menu"
                               , "MenuBar"
                               , "MenuBarUI"
                               , "MenuComponent"
                               , "MenuContainer"
                               , "MenuDragMouseEvent"
                               , "MenuDragMouseListener"
                               , "MenuElement"
                               , "MenuEvent"
                               , "MenuItem"
                               , "MenuItemUI"
                               , "MenuKeyEvent"
                               , "MenuKeyListener"
                               , "MenuListener"
                               , "MenuSelectionManager"
                               , "MenuShortcut"
                               , "MessageDigest"
                               , "MessageDigestSpi"
                               , "MessageFormat"
                               , "MessageFormat.Field"
                               , "MessageProp"
                               , "MetaEventListener"
                               , "MetaMessage"
                               , "MetalBorders"
                               , "MetalBorders.ButtonBorder"
                               , "MetalBorders.Flush3DBorder"
                               , "MetalBorders.InternalFrameBorder"
                               , "MetalBorders.MenuBarBorder"
                               , "MetalBorders.MenuItemBorder"
                               , "MetalBorders.OptionDialogBorder"
                               , "MetalBorders.PaletteBorder"
                               , "MetalBorders.PopupMenuBorder"
                               , "MetalBorders.RolloverButtonBorder"
                               , "MetalBorders.ScrollPaneBorder"
                               , "MetalBorders.TableHeaderBorder"
                               , "MetalBorders.TextFieldBorder"
                               , "MetalBorders.ToggleButtonBorder"
                               , "MetalBorders.ToolBarBorder"
                               , "MetalButtonUI"
                               , "MetalCheckBoxIcon"
                               , "MetalCheckBoxUI"
                               , "MetalComboBoxButton"
                               , "MetalComboBoxEditor"
                               , "MetalComboBoxEditor.UIResource"
                               , "MetalComboBoxIcon"
                               , "MetalComboBoxUI"
                               , "MetalDesktopIconUI"
                               , "MetalFileChooserUI"
                               , "MetalIconFactory"
                               , "MetalIconFactory.FileIcon16"
                               , "MetalIconFactory.FolderIcon16"
                               , "MetalIconFactory.PaletteCloseIcon"
                               , "MetalIconFactory.TreeControlIcon"
                               , "MetalIconFactory.TreeFolderIcon"
                               , "MetalIconFactory.TreeLeafIcon"
                               , "MetalInternalFrameTitlePane"
                               , "MetalInternalFrameUI"
                               , "MetalLabelUI"
                               , "MetalLookAndFeel"
                               , "MetalMenuBarUI"
                               , "MetalPopupMenuSeparatorUI"
                               , "MetalProgressBarUI"
                               , "MetalRadioButtonUI"
                               , "MetalRootPaneUI"
                               , "MetalScrollBarUI"
                               , "MetalScrollButton"
                               , "MetalScrollPaneUI"
                               , "MetalSeparatorUI"
                               , "MetalSliderUI"
                               , "MetalSplitPaneUI"
                               , "MetalTabbedPaneUI"
                               , "MetalTextFieldUI"
                               , "MetalTheme"
                               , "MetalToggleButtonUI"
                               , "MetalToolBarUI"
                               , "MetalToolTipUI"
                               , "MetalTreeUI"
                               , "Method"
                               , "MethodDescriptor"
                               , "MidiChannel"
                               , "MidiDevice"
                               , "MidiDevice.Info"
                               , "MidiDeviceProvider"
                               , "MidiEvent"
                               , "MidiFileFormat"
                               , "MidiFileReader"
                               , "MidiFileWriter"
                               , "MidiMessage"
                               , "MidiSystem"
                               , "MidiUnavailableException"
                               , "MimeTypeParseException"
                               , "MinimalHTMLWriter"
                               , "MissingFormatArgumentException"
                               , "MissingFormatWidthException"
                               , "MissingResourceException"
                               , "Mixer"
                               , "Mixer.Info"
                               , "MixerProvider"
                               , "ModelMBean"
                               , "ModelMBeanAttributeInfo"
                               , "ModelMBeanConstructorInfo"
                               , "ModelMBeanInfo"
                               , "ModelMBeanInfoSupport"
                               , "ModelMBeanNotificationBroadcaster"
                               , "ModelMBeanNotificationInfo"
                               , "ModelMBeanOperationInfo"
                               , "ModificationItem"
                               , "Modifier"
                               , "Monitor"
                               , "MonitorMBean"
                               , "MonitorNotification"
                               , "MonitorSettingException"
                               , "MouseAdapter"
                               , "MouseDragGestureRecognizer"
                               , "MouseEvent"
                               , "MouseInfo"
                               , "MouseInputAdapter"
                               , "MouseInputListener"
                               , "MouseListener"
                               , "MouseMotionAdapter"
                               , "MouseMotionListener"
                               , "MouseWheelEvent"
                               , "MouseWheelListener"
                               , "MultiButtonUI"
                               , "MultiColorChooserUI"
                               , "MultiComboBoxUI"
                               , "MultiDesktopIconUI"
                               , "MultiDesktopPaneUI"
                               , "MultiDoc"
                               , "MultiDocPrintJob"
                               , "MultiDocPrintService"
                               , "MultiFileChooserUI"
                               , "MultiInternalFrameUI"
                               , "MultiLabelUI"
                               , "MultiListUI"
                               , "MultiLookAndFeel"
                               , "MultiMenuBarUI"
                               , "MultiMenuItemUI"
                               , "MultiOptionPaneUI"
                               , "MultiPanelUI"
                               , "MultiPixelPackedSampleModel"
                               , "MultiPopupMenuUI"
                               , "MultiProgressBarUI"
                               , "MultiRootPaneUI"
                               , "MultiScrollBarUI"
                               , "MultiScrollPaneUI"
                               , "MultiSeparatorUI"
                               , "MultiSliderUI"
                               , "MultiSpinnerUI"
                               , "MultiSplitPaneUI"
                               , "MultiTabbedPaneUI"
                               , "MultiTableHeaderUI"
                               , "MultiTableUI"
                               , "MultiTextUI"
                               , "MultiToolBarUI"
                               , "MultiToolTipUI"
                               , "MultiTreeUI"
                               , "MultiViewportUI"
                               , "MulticastSocket"
                               , "MultipleComponentProfileHelper"
                               , "MultipleComponentProfileHolder"
                               , "MultipleDocumentHandling"
                               , "MultipleMaster"
                               , "MutableAttributeSet"
                               , "MutableComboBoxModel"
                               , "MutableTreeNode"
                               , "NON_EXISTENT"
                               , "NO_IMPLEMENT"
                               , "NO_MEMORY"
                               , "NO_PERMISSION"
                               , "NO_RESOURCES"
                               , "NO_RESPONSE"
                               , "NVList"
                               , "Name"
                               , "NameAlreadyBoundException"
                               , "NameCallback"
                               , "NameClassPair"
                               , "NameComponent"
                               , "NameComponentHelper"
                               , "NameComponentHolder"
                               , "NameDynAnyPair"
                               , "NameDynAnyPairHelper"
                               , "NameDynAnyPairSeqHelper"
                               , "NameHelper"
                               , "NameHolder"
                               , "NameList"
                               , "NameNotFoundException"
                               , "NameParser"
                               , "NameValuePair"
                               , "NameValuePairHelper"
                               , "NameValuePairSeqHelper"
                               , "NamedNodeMap"
                               , "NamedValue"
                               , "NamespaceChangeListener"
                               , "NamespaceContext"
                               , "NamespaceSupport"
                               , "Naming"
                               , "NamingContext"
                               , "NamingContextExt"
                               , "NamingContextExtHelper"
                               , "NamingContextExtHolder"
                               , "NamingContextExtOperations"
                               , "NamingContextExtPOA"
                               , "NamingContextHelper"
                               , "NamingContextHolder"
                               , "NamingContextOperations"
                               , "NamingContextPOA"
                               , "NamingEnumeration"
                               , "NamingEvent"
                               , "NamingException"
                               , "NamingExceptionEvent"
                               , "NamingListener"
                               , "NamingManager"
                               , "NamingSecurityException"
                               , "NavigationFilter"
                               , "NavigationFilter.FilterBypass"
                               , "NegativeArraySizeException"
                               , "NetPermission"
                               , "NetworkInterface"
                               , "NoClassDefFoundError"
                               , "NoConnectionPendingException"
                               , "NoContext"
                               , "NoContextHelper"
                               , "NoInitialContextException"
                               , "NoPermissionException"
                               , "NoRouteToHostException"
                               , "NoServant"
                               , "NoServantHelper"
                               , "NoSuchAlgorithmException"
                               , "NoSuchAttributeException"
                               , "NoSuchElementException"
                               , "NoSuchFieldError"
                               , "NoSuchFieldException"
                               , "NoSuchMethodError"
                               , "NoSuchMethodException"
                               , "NoSuchObjectException"
                               , "NoSuchPaddingException"
                               , "NoSuchProviderException"
                               , "Node"
                               , "NodeChangeEvent"
                               , "NodeChangeListener"
                               , "NodeList"
                               , "NonReadableChannelException"
                               , "NonWritableChannelException"
                               , "NoninvertibleTransformException"
                               , "NotActiveException"
                               , "NotBoundException"
                               , "NotCompliantMBeanException"
                               , "NotContextException"
                               , "NotEmpty"
                               , "NotEmptyHelper"
                               , "NotEmptyHolder"
                               , "NotFound"
                               , "NotFoundHelper"
                               , "NotFoundHolder"
                               , "NotFoundReason"
                               , "NotFoundReasonHelper"
                               , "NotFoundReasonHolder"
                               , "NotOwnerException"
                               , "NotSerializableException"
                               , "NotYetBoundException"
                               , "NotYetConnectedException"
                               , "Notation"
                               , "Notification"
                               , "NotificationBroadcaster"
                               , "NotificationBroadcasterSupport"
                               , "NotificationEmitter"
                               , "NotificationFilter"
                               , "NotificationFilterSupport"
                               , "NotificationListener"
                               , "NotificationResult"
                               , "NullCipher"
                               , "NullPointerException"
                               , "Number"
                               , "NumberFormat"
                               , "NumberFormat.Field"
                               , "NumberFormatException"
                               , "NumberFormatter"
                               , "NumberOfDocuments"
                               , "NumberOfInterveningJobs"
                               , "NumberUp"
                               , "NumberUpSupported"
                               , "NumericShaper"
                               , "OAEPParameterSpec"
                               , "OBJECT_NOT_EXIST"
                               , "OBJ_ADAPTER"
                               , "OMGVMCID"
                               , "ORB"
                               , "ORBIdHelper"
                               , "ORBInitInfo"
                               , "ORBInitInfoOperations"
                               , "ORBInitializer"
                               , "ORBInitializerOperations"
                               , "ObjID"
                               , "Object"
                               , "ObjectAlreadyActive"
                               , "ObjectAlreadyActiveHelper"
                               , "ObjectChangeListener"
                               , "ObjectFactory"
                               , "ObjectFactoryBuilder"
                               , "ObjectHelper"
                               , "ObjectHolder"
                               , "ObjectIdHelper"
                               , "ObjectImpl"
                               , "ObjectInput"
                               , "ObjectInputStream"
                               , "ObjectInputStream.GetField"
                               , "ObjectInputValidation"
                               , "ObjectInstance"
                               , "ObjectName"
                               , "ObjectNotActive"
                               , "ObjectNotActiveHelper"
                               , "ObjectOutput"
                               , "ObjectOutputStream"
                               , "ObjectOutputStream.PutField"
                               , "ObjectReferenceFactory"
                               , "ObjectReferenceFactoryHelper"
                               , "ObjectReferenceFactoryHolder"
                               , "ObjectReferenceTemplate"
                               , "ObjectReferenceTemplateHelper"
                               , "ObjectReferenceTemplateHolder"
                               , "ObjectReferenceTemplateSeqHelper"
                               , "ObjectReferenceTemplateSeqHolder"
                               , "ObjectStreamClass"
                               , "ObjectStreamConstants"
                               , "ObjectStreamException"
                               , "ObjectStreamField"
                               , "ObjectView"
                               , "Observable"
                               , "Observer"
                               , "OceanTheme"
                               , "OctetSeqHelper"
                               , "OctetSeqHolder"
                               , "Oid"
                               , "OpenDataException"
                               , "OpenMBeanAttributeInfo"
                               , "OpenMBeanAttributeInfoSupport"
                               , "OpenMBeanConstructorInfo"
                               , "OpenMBeanConstructorInfoSupport"
                               , "OpenMBeanInfo"
                               , "OpenMBeanInfoSupport"
                               , "OpenMBeanOperationInfo"
                               , "OpenMBeanOperationInfoSupport"
                               , "OpenMBeanParameterInfo"
                               , "OpenMBeanParameterInfoSupport"
                               , "OpenType"
                               , "OperatingSystemMXBean"
                               , "Operation"
                               , "OperationNotSupportedException"
                               , "OperationsException"
                               , "Option"
                               , "OptionPaneUI"
                               , "OptionalDataException"
                               , "OrientationRequested"
                               , "OutOfMemoryError"
                               , "OutputDeviceAssigned"
                               , "OutputKeys"
                               , "OutputStream"
                               , "OutputStreamWriter"
                               , "OverlappingFileLockException"
                               , "OverlayLayout"
                               , "Override"
                               , "Owner"
                               , "PBEKey"
                               , "PBEKeySpec"
                               , "PBEParameterSpec"
                               , "PDLOverrideSupported"
                               , "PERSIST_STORE"
                               , "PKCS8EncodedKeySpec"
                               , "PKIXBuilderParameters"
                               , "PKIXCertPathBuilderResult"
                               , "PKIXCertPathChecker"
                               , "PKIXCertPathValidatorResult"
                               , "PKIXParameters"
                               , "POA"
                               , "POAHelper"
                               , "POAManager"
                               , "POAManagerOperations"
                               , "POAOperations"
                               , "PRIVATE_MEMBER"
                               , "PSSParameterSpec"
                               , "PSource"
                               , "PSource.PSpecified"
                               , "PUBLIC_MEMBER"
                               , "Pack200"
                               , "Pack200.Packer"
                               , "Pack200.Unpacker"
                               , "Package"
                               , "PackedColorModel"
                               , "PageAttributes"
                               , "PageAttributes.ColorType"
                               , "PageAttributes.MediaType"
                               , "PageAttributes.OrientationRequestedType"
                               , "PageAttributes.OriginType"
                               , "PageAttributes.PrintQualityType"
                               , "PageFormat"
                               , "PageRanges"
                               , "Pageable"
                               , "PagedResultsControl"
                               , "PagedResultsResponseControl"
                               , "PagesPerMinute"
                               , "PagesPerMinuteColor"
                               , "Paint"
                               , "PaintContext"
                               , "PaintEvent"
                               , "Panel"
                               , "PanelUI"
                               , "Paper"
                               , "ParagraphView"
                               , "Parameter"
                               , "ParameterBlock"
                               , "ParameterDescriptor"
                               , "ParameterMetaData"
                               , "ParameterMode"
                               , "ParameterModeHelper"
                               , "ParameterModeHolder"
                               , "ParameterizedType"
                               , "ParseException"
                               , "ParsePosition"
                               , "Parser"
                               , "ParserAdapter"
                               , "ParserConfigurationException"
                               , "ParserDelegator"
                               , "ParserFactory"
                               , "PartialResultException"
                               , "PasswordAuthentication"
                               , "PasswordCallback"
                               , "PasswordView"
                               , "Patch"
                               , "PathIterator"
                               , "Pattern"
                               , "PatternSyntaxException"
                               , "Permission"
                               , "PermissionCollection"
                               , "Permissions"
                               , "PersistenceDelegate"
                               , "PersistentMBean"
                               , "PhantomReference"
                               , "Pipe"
                               , "Pipe.SinkChannel"
                               , "Pipe.SourceChannel"
                               , "PipedInputStream"
                               , "PipedOutputStream"
                               , "PipedReader"
                               , "PipedWriter"
                               , "PixelGrabber"
                               , "PixelInterleavedSampleModel"
                               , "PlainDocument"
                               , "PlainView"
                               , "Point"
                               , "Point2D"
                               , "Point2D.Double"
                               , "Point2D.Float"
                               , "PointerInfo"
                               , "Policy"
                               , "PolicyError"
                               , "PolicyErrorCodeHelper"
                               , "PolicyErrorHelper"
                               , "PolicyErrorHolder"
                               , "PolicyFactory"
                               , "PolicyFactoryOperations"
                               , "PolicyHelper"
                               , "PolicyHolder"
                               , "PolicyListHelper"
                               , "PolicyListHolder"
                               , "PolicyNode"
                               , "PolicyOperations"
                               , "PolicyQualifierInfo"
                               , "PolicyTypeHelper"
                               , "Polygon"
                               , "PooledConnection"
                               , "Popup"
                               , "PopupFactory"
                               , "PopupMenu"
                               , "PopupMenuEvent"
                               , "PopupMenuListener"
                               , "PopupMenuUI"
                               , "Port"
                               , "Port.Info"
                               , "PortUnreachableException"
                               , "PortableRemoteObject"
                               , "PortableRemoteObjectDelegate"
                               , "Position"
                               , "Position.Bias"
                               , "Predicate"
                               , "PreferenceChangeEvent"
                               , "PreferenceChangeListener"
                               , "Preferences"
                               , "PreferencesFactory"
                               , "PreparedStatement"
                               , "PresentationDirection"
                               , "Principal"
                               , "PrincipalHolder"
                               , "PrintEvent"
                               , "PrintException"
                               , "PrintGraphics"
                               , "PrintJob"
                               , "PrintJobAdapter"
                               , "PrintJobAttribute"
                               , "PrintJobAttributeEvent"
                               , "PrintJobAttributeListener"
                               , "PrintJobAttributeSet"
                               , "PrintJobEvent"
                               , "PrintJobListener"
                               , "PrintQuality"
                               , "PrintRequestAttribute"
                               , "PrintRequestAttributeSet"
                               , "PrintService"
                               , "PrintServiceAttribute"
                               , "PrintServiceAttributeEvent"
                               , "PrintServiceAttributeListener"
                               , "PrintServiceAttributeSet"
                               , "PrintServiceLookup"
                               , "PrintStream"
                               , "PrintWriter"
                               , "Printable"
                               , "PrinterAbortException"
                               , "PrinterException"
                               , "PrinterGraphics"
                               , "PrinterIOException"
                               , "PrinterInfo"
                               , "PrinterIsAcceptingJobs"
                               , "PrinterJob"
                               , "PrinterLocation"
                               , "PrinterMakeAndModel"
                               , "PrinterMessageFromOperator"
                               , "PrinterMoreInfo"
                               , "PrinterMoreInfoManufacturer"
                               , "PrinterName"
                               , "PrinterResolution"
                               , "PrinterState"
                               , "PrinterStateReason"
                               , "PrinterStateReasons"
                               , "PrinterURI"
                               , "PriorityBlockingQueue"
                               , "PriorityQueue"
                               , "PrivateClassLoader"
                               , "PrivateCredentialPermission"
                               , "PrivateKey"
                               , "PrivateMLet"
                               , "PrivilegedAction"
                               , "PrivilegedActionException"
                               , "PrivilegedExceptionAction"
                               , "Process"
                               , "ProcessBuilder"
                               , "ProcessingInstruction"
                               , "ProfileDataException"
                               , "ProfileIdHelper"
                               , "ProgressBarUI"
                               , "ProgressMonitor"
                               , "ProgressMonitorInputStream"
                               , "Properties"
                               , "PropertyChangeEvent"
                               , "PropertyChangeListener"
                               , "PropertyChangeListenerProxy"
                               , "PropertyChangeSupport"
                               , "PropertyDescriptor"
                               , "PropertyEditor"
                               , "PropertyEditorManager"
                               , "PropertyEditorSupport"
                               , "PropertyPermission"
                               , "PropertyResourceBundle"
                               , "PropertyVetoException"
                               , "ProtectionDomain"
                               , "ProtocolException"
                               , "Provider"
                               , "Provider.Service"
                               , "ProviderException"
                               , "Proxy"
                               , "Proxy.Type"
                               , "ProxySelector"
                               , "PublicKey"
                               , "PushbackInputStream"
                               , "PushbackReader"
                               , "QName"
                               , "QuadCurve2D"
                               , "QuadCurve2D.Double"
                               , "QuadCurve2D.Float"
                               , "Query"
                               , "QueryEval"
                               , "QueryExp"
                               , "Queue"
                               , "QueuedJobCount"
                               , "RC2ParameterSpec"
                               , "RC5ParameterSpec"
                               , "REBIND"
                               , "REQUEST_PROCESSING_POLICY_ID"
                               , "RGBImageFilter"
                               , "RMIClassLoader"
                               , "RMIClassLoaderSpi"
                               , "RMIClientSocketFactory"
                               , "RMIConnection"
                               , "RMIConnectionImpl"
                               , "RMIConnectionImpl_Stub"
                               , "RMIConnector"
                               , "RMIConnectorServer"
                               , "RMICustomMaxStreamFormat"
                               , "RMIFailureHandler"
                               , "RMIIIOPServerImpl"
                               , "RMIJRMPServerImpl"
                               , "RMISecurityException"
                               , "RMISecurityManager"
                               , "RMIServer"
                               , "RMIServerImpl"
                               , "RMIServerImpl_Stub"
                               , "RMIServerSocketFactory"
                               , "RMISocketFactory"
                               , "RSAKey"
                               , "RSAKeyGenParameterSpec"
                               , "RSAMultiPrimePrivateCrtKey"
                               , "RSAMultiPrimePrivateCrtKeySpec"
                               , "RSAOtherPrimeInfo"
                               , "RSAPrivateCrtKey"
                               , "RSAPrivateCrtKeySpec"
                               , "RSAPrivateKey"
                               , "RSAPrivateKeySpec"
                               , "RSAPublicKey"
                               , "RSAPublicKeySpec"
                               , "RTFEditorKit"
                               , "Random"
                               , "RandomAccess"
                               , "RandomAccessFile"
                               , "Raster"
                               , "RasterFormatException"
                               , "RasterOp"
                               , "Rdn"
                               , "ReadOnlyBufferException"
                               , "ReadWriteLock"
                               , "Readable"
                               , "ReadableByteChannel"
                               , "Reader"
                               , "RealmCallback"
                               , "RealmChoiceCallback"
                               , "Receiver"
                               , "Rectangle"
                               , "Rectangle2D"
                               , "Rectangle2D.Double"
                               , "Rectangle2D.Float"
                               , "RectangularShape"
                               , "ReentrantLock"
                               , "ReentrantReadWriteLock"
                               , "ReentrantReadWriteLock.ReadLock"
                               , "ReentrantReadWriteLock.WriteLock"
                               , "Ref"
                               , "RefAddr"
                               , "Reference"
                               , "ReferenceQueue"
                               , "ReferenceUriSchemesSupported"
                               , "Referenceable"
                               , "ReferralException"
                               , "ReflectPermission"
                               , "ReflectionException"
                               , "RefreshFailedException"
                               , "Refreshable"
                               , "Region"
                               , "RegisterableService"
                               , "Registry"
                               , "RegistryHandler"
                               , "RejectedExecutionException"
                               , "RejectedExecutionHandler"
                               , "Relation"
                               , "RelationException"
                               , "RelationNotFoundException"
                               , "RelationNotification"
                               , "RelationService"
                               , "RelationServiceMBean"
                               , "RelationServiceNotRegisteredException"
                               , "RelationSupport"
                               , "RelationSupportMBean"
                               , "RelationType"
                               , "RelationTypeNotFoundException"
                               , "RelationTypeSupport"
                               , "RemarshalException"
                               , "Remote"
                               , "RemoteCall"
                               , "RemoteException"
                               , "RemoteObject"
                               , "RemoteObjectInvocationHandler"
                               , "RemoteRef"
                               , "RemoteServer"
                               , "RemoteStub"
                               , "RenderContext"
                               , "RenderableImage"
                               , "RenderableImageOp"
                               , "RenderableImageProducer"
                               , "RenderedImage"
                               , "RenderedImageFactory"
                               , "Renderer"
                               , "RenderingHints"
                               , "RenderingHints.Key"
                               , "RepaintManager"
                               , "ReplicateScaleFilter"
                               , "RepositoryIdHelper"
                               , "Request"
                               , "RequestInfo"
                               , "RequestInfoOperations"
                               , "RequestProcessingPolicy"
                               , "RequestProcessingPolicyOperations"
                               , "RequestProcessingPolicyValue"
                               , "RequestingUserName"
                               , "RequiredModelMBean"
                               , "RescaleOp"
                               , "ResolutionSyntax"
                               , "ResolveResult"
                               , "Resolver"
                               , "ResourceBundle"
                               , "ResponseCache"
                               , "ResponseHandler"
                               , "Result"
                               , "ResultSet"
                               , "ResultSetMetaData"
                               , "Retention"
                               , "RetentionPolicy"
                               , "ReverbType"
                               , "Robot"
                               , "Role"
                               , "RoleInfo"
                               , "RoleInfoNotFoundException"
                               , "RoleList"
                               , "RoleNotFoundException"
                               , "RoleResult"
                               , "RoleStatus"
                               , "RoleUnresolved"
                               , "RoleUnresolvedList"
                               , "RootPaneContainer"
                               , "RootPaneUI"
                               , "RoundRectangle2D"
                               , "RoundRectangle2D.Double"
                               , "RoundRectangle2D.Float"
                               , "RoundingMode"
                               , "RowMapper"
                               , "RowSet"
                               , "RowSetEvent"
                               , "RowSetInternal"
                               , "RowSetListener"
                               , "RowSetMetaData"
                               , "RowSetMetaDataImpl"
                               , "RowSetReader"
                               , "RowSetWarning"
                               , "RowSetWriter"
                               , "RuleBasedCollator"
                               , "RunTime"
                               , "RunTimeOperations"
                               , "Runnable"
                               , "Runtime"
                               , "RuntimeErrorException"
                               , "RuntimeException"
                               , "RuntimeMBeanException"
                               , "RuntimeMXBean"
                               , "RuntimeOperationsException"
                               , "RuntimePermission"
                               , "SAXException"
                               , "SAXNotRecognizedException"
                               , "SAXNotSupportedException"
                               , "SAXParseException"
                               , "SAXParser"
                               , "SAXParserFactory"
                               , "SAXResult"
                               , "SAXSource"
                               , "SAXTransformerFactory"
                               , "SERVANT_RETENTION_POLICY_ID"
                               , "SQLData"
                               , "SQLException"
                               , "SQLInput"
                               , "SQLInputImpl"
                               , "SQLOutput"
                               , "SQLOutputImpl"
                               , "SQLPermission"
                               , "SQLWarning"
                               , "SSLContext"
                               , "SSLContextSpi"
                               , "SSLEngine"
                               , "SSLEngineResult"
                               , "SSLEngineResult.HandshakeStatus"
                               , "SSLEngineResult.Status"
                               , "SSLException"
                               , "SSLHandshakeException"
                               , "SSLKeyException"
                               , "SSLPeerUnverifiedException"
                               , "SSLPermission"
                               , "SSLProtocolException"
                               , "SSLServerSocket"
                               , "SSLServerSocketFactory"
                               , "SSLSession"
                               , "SSLSessionBindingEvent"
                               , "SSLSessionBindingListener"
                               , "SSLSessionContext"
                               , "SSLSocket"
                               , "SSLSocketFactory"
                               , "SUCCESSFUL"
                               , "SYNC_WITH_TRANSPORT"
                               , "SYSTEM_EXCEPTION"
                               , "SampleModel"
                               , "Sasl"
                               , "SaslClient"
                               , "SaslClientFactory"
                               , "SaslException"
                               , "SaslServer"
                               , "SaslServerFactory"
                               , "Savepoint"
                               , "Scanner"
                               , "ScatteringByteChannel"
                               , "ScheduledExecutorService"
                               , "ScheduledFuture"
                               , "ScheduledThreadPoolExecutor"
                               , "Schema"
                               , "SchemaFactory"
                               , "SchemaFactoryLoader"
                               , "SchemaViolationException"
                               , "ScrollBarUI"
                               , "ScrollPane"
                               , "ScrollPaneAdjustable"
                               , "ScrollPaneConstants"
                               , "ScrollPaneLayout"
                               , "ScrollPaneLayout.UIResource"
                               , "ScrollPaneUI"
                               , "Scrollable"
                               , "Scrollbar"
                               , "SealedObject"
                               , "SearchControls"
                               , "SearchResult"
                               , "SecretKey"
                               , "SecretKeyFactory"
                               , "SecretKeyFactorySpi"
                               , "SecretKeySpec"
                               , "SecureCacheResponse"
                               , "SecureClassLoader"
                               , "SecureRandom"
                               , "SecureRandomSpi"
                               , "Security"
                               , "SecurityException"
                               , "SecurityManager"
                               , "SecurityPermission"
                               , "Segment"
                               , "SelectableChannel"
                               , "SelectionKey"
                               , "Selector"
                               , "SelectorProvider"
                               , "Semaphore"
                               , "SeparatorUI"
                               , "Sequence"
                               , "SequenceInputStream"
                               , "Sequencer"
                               , "Sequencer.SyncMode"
                               , "SerialArray"
                               , "SerialBlob"
                               , "SerialClob"
                               , "SerialDatalink"
                               , "SerialException"
                               , "SerialJavaObject"
                               , "SerialRef"
                               , "SerialStruct"
                               , "Serializable"
                               , "SerializablePermission"
                               , "Servant"
                               , "ServantActivator"
                               , "ServantActivatorHelper"
                               , "ServantActivatorOperations"
                               , "ServantActivatorPOA"
                               , "ServantAlreadyActive"
                               , "ServantAlreadyActiveHelper"
                               , "ServantLocator"
                               , "ServantLocatorHelper"
                               , "ServantLocatorOperations"
                               , "ServantLocatorPOA"
                               , "ServantManager"
                               , "ServantManagerOperations"
                               , "ServantNotActive"
                               , "ServantNotActiveHelper"
                               , "ServantObject"
                               , "ServantRetentionPolicy"
                               , "ServantRetentionPolicyOperations"
                               , "ServantRetentionPolicyValue"
                               , "ServerCloneException"
                               , "ServerError"
                               , "ServerException"
                               , "ServerIdHelper"
                               , "ServerNotActiveException"
                               , "ServerRef"
                               , "ServerRequest"
                               , "ServerRequestInfo"
                               , "ServerRequestInfoOperations"
                               , "ServerRequestInterceptor"
                               , "ServerRequestInterceptorOperations"
                               , "ServerRuntimeException"
                               , "ServerSocket"
                               , "ServerSocketChannel"
                               , "ServerSocketFactory"
                               , "ServiceContext"
                               , "ServiceContextHelper"
                               , "ServiceContextHolder"
                               , "ServiceContextListHelper"
                               , "ServiceContextListHolder"
                               , "ServiceDetail"
                               , "ServiceDetailHelper"
                               , "ServiceIdHelper"
                               , "ServiceInformation"
                               , "ServiceInformationHelper"
                               , "ServiceInformationHolder"
                               , "ServiceNotFoundException"
                               , "ServicePermission"
                               , "ServiceRegistry"
                               , "ServiceRegistry.Filter"
                               , "ServiceUI"
                               , "ServiceUIFactory"
                               , "ServiceUnavailableException"
                               , "Set"
                               , "SetOfIntegerSyntax"
                               , "SetOverrideType"
                               , "SetOverrideTypeHelper"
                               , "Severity"
                               , "Shape"
                               , "ShapeGraphicAttribute"
                               , "SheetCollate"
                               , "Short"
                               , "ShortBuffer"
                               , "ShortBufferException"
                               , "ShortHolder"
                               , "ShortLookupTable"
                               , "ShortMessage"
                               , "ShortSeqHelper"
                               , "ShortSeqHolder"
                               , "Sides"
                               , "Signature"
                               , "SignatureException"
                               , "SignatureSpi"
                               , "SignedObject"
                               , "Signer"
                               , "SimpleAttributeSet"
                               , "SimpleBeanInfo"
                               , "SimpleDateFormat"
                               , "SimpleDoc"
                               , "SimpleFormatter"
                               , "SimpleTimeZone"
                               , "SimpleType"
                               , "SinglePixelPackedSampleModel"
                               , "SingleSelectionModel"
                               , "Size2DSyntax"
                               , "SizeLimitExceededException"
                               , "SizeRequirements"
                               , "SizeSequence"
                               , "Skeleton"
                               , "SkeletonMismatchException"
                               , "SkeletonNotFoundException"
                               , "SliderUI"
                               , "Socket"
                               , "SocketAddress"
                               , "SocketChannel"
                               , "SocketException"
                               , "SocketFactory"
                               , "SocketHandler"
                               , "SocketImpl"
                               , "SocketImplFactory"
                               , "SocketOptions"
                               , "SocketPermission"
                               , "SocketSecurityException"
                               , "SocketTimeoutException"
                               , "SoftBevelBorder"
                               , "SoftReference"
                               , "SortControl"
                               , "SortKey"
                               , "SortResponseControl"
                               , "SortedMap"
                               , "SortedSet"
                               , "SortingFocusTraversalPolicy"
                               , "Soundbank"
                               , "SoundbankReader"
                               , "SoundbankResource"
                               , "Source"
                               , "SourceDataLine"
                               , "SourceLocator"
                               , "SpinnerDateModel"
                               , "SpinnerListModel"
                               , "SpinnerModel"
                               , "SpinnerNumberModel"
                               , "SpinnerUI"
                               , "SplitPaneUI"
                               , "Spring"
                               , "SpringLayout"
                               , "SpringLayout.Constraints"
                               , "SslRMIClientSocketFactory"
                               , "SslRMIServerSocketFactory"
                               , "Stack"
                               , "StackOverflowError"
                               , "StackTraceElement"
                               , "StandardMBean"
                               , "StartTlsRequest"
                               , "StartTlsResponse"
                               , "State"
                               , "StateEdit"
                               , "StateEditable"
                               , "StateFactory"
                               , "Statement"
                               , "StreamCorruptedException"
                               , "StreamHandler"
                               , "StreamPrintService"
                               , "StreamPrintServiceFactory"
                               , "StreamResult"
                               , "StreamSource"
                               , "StreamTokenizer"
                               , "Streamable"
                               , "StreamableValue"
                               , "StrictMath"
                               , "String"
                               , "StringBuffer"
                               , "StringBufferInputStream"
                               , "StringBuilder"
                               , "StringCharacterIterator"
                               , "StringContent"
                               , "StringHolder"
                               , "StringIndexOutOfBoundsException"
                               , "StringMonitor"
                               , "StringMonitorMBean"
                               , "StringNameHelper"
                               , "StringReader"
                               , "StringRefAddr"
                               , "StringSelection"
                               , "StringSeqHelper"
                               , "StringSeqHolder"
                               , "StringTokenizer"
                               , "StringValueExp"
                               , "StringValueHelper"
                               , "StringWriter"
                               , "Stroke"
                               , "Struct"
                               , "StructMember"
                               , "StructMemberHelper"
                               , "Stub"
                               , "StubDelegate"
                               , "StubNotFoundException"
                               , "Style"
                               , "StyleConstants"
                               , "StyleConstants.CharacterConstants"
                               , "StyleConstants.ColorConstants"
                               , "StyleConstants.FontConstants"
                               , "StyleConstants.ParagraphConstants"
                               , "StyleContext"
                               , "StyleSheet"
                               , "StyleSheet.BoxPainter"
                               , "StyleSheet.ListPainter"
                               , "StyledDocument"
                               , "StyledEditorKit"
                               , "StyledEditorKit.AlignmentAction"
                               , "StyledEditorKit.BoldAction"
                               , "StyledEditorKit.FontFamilyAction"
                               , "StyledEditorKit.FontSizeAction"
                               , "StyledEditorKit.ForegroundAction"
                               , "StyledEditorKit.ItalicAction"
                               , "StyledEditorKit.StyledTextAction"
                               , "StyledEditorKit.UnderlineAction"
                               , "Subject"
                               , "SubjectDelegationPermission"
                               , "SubjectDomainCombiner"
                               , "SupportedValuesAttribute"
                               , "SuppressWarnings"
                               , "SwingConstants"
                               , "SwingPropertyChangeSupport"
                               , "SwingUtilities"
                               , "SyncFactory"
                               , "SyncFactoryException"
                               , "SyncFailedException"
                               , "SyncProvider"
                               , "SyncProviderException"
                               , "SyncResolver"
                               , "SyncScopeHelper"
                               , "SynchronousQueue"
                               , "SynthConstants"
                               , "SynthContext"
                               , "SynthGraphicsUtils"
                               , "SynthLookAndFeel"
                               , "SynthPainter"
                               , "SynthStyle"
                               , "SynthStyleFactory"
                               , "Synthesizer"
                               , "SysexMessage"
                               , "System"
                               , "SystemColor"
                               , "SystemException"
                               , "SystemFlavorMap"
                               , "TAG_ALTERNATE_IIOP_ADDRESS"
                               , "TAG_CODE_SETS"
                               , "TAG_INTERNET_IOP"
                               , "TAG_JAVA_CODEBASE"
                               , "TAG_MULTIPLE_COMPONENTS"
                               , "TAG_ORB_TYPE"
                               , "TAG_POLICIES"
                               , "TAG_RMI_CUSTOM_MAX_STREAM_FORMAT"
                               , "TCKind"
                               , "THREAD_POLICY_ID"
                               , "TIMEOUT"
                               , "TRANSACTION_MODE"
                               , "TRANSACTION_REQUIRED"
                               , "TRANSACTION_ROLLEDBACK"
                               , "TRANSACTION_UNAVAILABLE"
                               , "TRANSIENT"
                               , "TRANSPORT_RETRY"
                               , "TabExpander"
                               , "TabSet"
                               , "TabStop"
                               , "TabableView"
                               , "TabbedPaneUI"
                               , "TableCellEditor"
                               , "TableCellRenderer"
                               , "TableColumn"
                               , "TableColumnModel"
                               , "TableColumnModelEvent"
                               , "TableColumnModelListener"
                               , "TableHeaderUI"
                               , "TableModel"
                               , "TableModelEvent"
                               , "TableModelListener"
                               , "TableUI"
                               , "TableView"
                               , "TabularData"
                               , "TabularDataSupport"
                               , "TabularType"
                               , "TagElement"
                               , "TaggedComponent"
                               , "TaggedComponentHelper"
                               , "TaggedComponentHolder"
                               , "TaggedProfile"
                               , "TaggedProfileHelper"
                               , "TaggedProfileHolder"
                               , "Target"
                               , "TargetDataLine"
                               , "TargetedNotification"
                               , "Templates"
                               , "TemplatesHandler"
                               , "Text"
                               , "TextAction"
                               , "TextArea"
                               , "TextAttribute"
                               , "TextComponent"
                               , "TextEvent"
                               , "TextField"
                               , "TextHitInfo"
                               , "TextInputCallback"
                               , "TextLayout"
                               , "TextLayout.CaretPolicy"
                               , "TextListener"
                               , "TextMeasurer"
                               , "TextOutputCallback"
                               , "TextSyntax"
                               , "TextUI"
                               , "TexturePaint"
                               , "Thread"
                               , "Thread.State"
                               , "Thread.UncaughtExceptionHandler"
                               , "ThreadDeath"
                               , "ThreadFactory"
                               , "ThreadGroup"
                               , "ThreadInfo"
                               , "ThreadLocal"
                               , "ThreadMXBean"
                               , "ThreadPolicy"
                               , "ThreadPolicyOperations"
                               , "ThreadPolicyValue"
                               , "ThreadPoolExecutor"
                               , "ThreadPoolExecutor.AbortPolicy"
                               , "ThreadPoolExecutor.CallerRunsPolicy"
                               , "ThreadPoolExecutor.DiscardOldestPolicy"
                               , "ThreadPoolExecutor.DiscardPolicy"
                               , "Throwable"
                               , "Tie"
                               , "TileObserver"
                               , "Time"
                               , "TimeLimitExceededException"
                               , "TimeUnit"
                               , "TimeZone"
                               , "TimeoutException"
                               , "Timer"
                               , "TimerAlarmClockNotification"
                               , "TimerMBean"
                               , "TimerNotification"
                               , "TimerTask"
                               , "Timestamp"
                               , "TitledBorder"
                               , "TooManyListenersException"
                               , "ToolBarUI"
                               , "ToolTipManager"
                               , "ToolTipUI"
                               , "Toolkit"
                               , "Track"
                               , "TransactionRequiredException"
                               , "TransactionRolledbackException"
                               , "TransactionService"
                               , "TransactionalWriter"
                               , "TransferHandler"
                               , "Transferable"
                               , "TransformAttribute"
                               , "Transformer"
                               , "TransformerConfigurationException"
                               , "TransformerException"
                               , "TransformerFactory"
                               , "TransformerFactoryConfigurationError"
                               , "TransformerHandler"
                               , "Transmitter"
                               , "Transparency"
                               , "TreeCellEditor"
                               , "TreeCellRenderer"
                               , "TreeExpansionEvent"
                               , "TreeExpansionListener"
                               , "TreeMap"
                               , "TreeModel"
                               , "TreeModelEvent"
                               , "TreeModelListener"
                               , "TreeNode"
                               , "TreePath"
                               , "TreeSelectionEvent"
                               , "TreeSelectionListener"
                               , "TreeSelectionModel"
                               , "TreeSet"
                               , "TreeUI"
                               , "TreeWillExpandListener"
                               , "TrustAnchor"
                               , "TrustManager"
                               , "TrustManagerFactory"
                               , "TrustManagerFactorySpi"
                               , "Type"
                               , "TypeCode"
                               , "TypeCodeHolder"
                               , "TypeInfo"
                               , "TypeInfoProvider"
                               , "TypeMismatch"
                               , "TypeMismatchHelper"
                               , "TypeNotPresentException"
                               , "TypeVariable"
                               , "Types"
                               , "UID"
                               , "UIDefaults"
                               , "UIDefaults.ActiveValue"
                               , "UIDefaults.LazyInputMap"
                               , "UIDefaults.LazyValue"
                               , "UIDefaults.ProxyLazyValue"
                               , "UIManager"
                               , "UIManager.LookAndFeelInfo"
                               , "UIResource"
                               , "ULongLongSeqHelper"
                               , "ULongLongSeqHolder"
                               , "ULongSeqHelper"
                               , "ULongSeqHolder"
                               , "UNKNOWN"
                               , "UNSUPPORTED_POLICY"
                               , "UNSUPPORTED_POLICY_VALUE"
                               , "URI"
                               , "URIException"
                               , "URIResolver"
                               , "URISyntax"
                               , "URISyntaxException"
                               , "URL"
                               , "URLClassLoader"
                               , "URLConnection"
                               , "URLDecoder"
                               , "URLEncoder"
                               , "URLStreamHandler"
                               , "URLStreamHandlerFactory"
                               , "URLStringHelper"
                               , "USER_EXCEPTION"
                               , "UShortSeqHelper"
                               , "UShortSeqHolder"
                               , "UTFDataFormatException"
                               , "UUID"
                               , "UndeclaredThrowableException"
                               , "UndoManager"
                               , "UndoableEdit"
                               , "UndoableEditEvent"
                               , "UndoableEditListener"
                               , "UndoableEditSupport"
                               , "UnexpectedException"
                               , "UnicastRemoteObject"
                               , "UnionMember"
                               , "UnionMemberHelper"
                               , "UnknownEncoding"
                               , "UnknownEncodingHelper"
                               , "UnknownError"
                               , "UnknownException"
                               , "UnknownFormatConversionException"
                               , "UnknownFormatFlagsException"
                               , "UnknownGroupException"
                               , "UnknownHostException"
                               , "UnknownObjectException"
                               , "UnknownServiceException"
                               , "UnknownUserException"
                               , "UnknownUserExceptionHelper"
                               , "UnknownUserExceptionHolder"
                               , "UnmappableCharacterException"
                               , "UnmarshalException"
                               , "UnmodifiableClassException"
                               , "UnmodifiableSetException"
                               , "UnrecoverableEntryException"
                               , "UnrecoverableKeyException"
                               , "Unreferenced"
                               , "UnresolvedAddressException"
                               , "UnresolvedPermission"
                               , "UnsatisfiedLinkError"
                               , "UnsolicitedNotification"
                               , "UnsolicitedNotificationEvent"
                               , "UnsolicitedNotificationListener"
                               , "UnsupportedAddressTypeException"
                               , "UnsupportedAudioFileException"
                               , "UnsupportedCallbackException"
                               , "UnsupportedCharsetException"
                               , "UnsupportedClassVersionError"
                               , "UnsupportedEncodingException"
                               , "UnsupportedFlavorException"
                               , "UnsupportedLookAndFeelException"
                               , "UnsupportedOperationException"
                               , "UserDataHandler"
                               , "UserException"
                               , "Util"
                               , "UtilDelegate"
                               , "Utilities"
                               , "VMID"
                               , "VM_ABSTRACT"
                               , "VM_CUSTOM"
                               , "VM_NONE"
                               , "VM_TRUNCATABLE"
                               , "Validator"
                               , "ValidatorHandler"
                               , "ValueBase"
                               , "ValueBaseHelper"
                               , "ValueBaseHolder"
                               , "ValueExp"
                               , "ValueFactory"
                               , "ValueHandler"
                               , "ValueHandlerMultiFormat"
                               , "ValueInputStream"
                               , "ValueMember"
                               , "ValueMemberHelper"
                               , "ValueOutputStream"
                               , "VariableHeightLayoutCache"
                               , "Vector"
                               , "VerifyError"
                               , "VersionSpecHelper"
                               , "VetoableChangeListener"
                               , "VetoableChangeListenerProxy"
                               , "VetoableChangeSupport"
                               , "View"
                               , "ViewFactory"
                               , "ViewportLayout"
                               , "ViewportUI"
                               , "VirtualMachineError"
                               , "Visibility"
                               , "VisibilityHelper"
                               , "VoiceStatus"
                               , "Void"
                               , "VolatileImage"
                               , "WCharSeqHelper"
                               , "WCharSeqHolder"
                               , "WStringSeqHelper"
                               , "WStringSeqHolder"
                               , "WStringValueHelper"
                               , "WeakHashMap"
                               , "WeakReference"
                               , "WebRowSet"
                               , "WildcardType"
                               , "Window"
                               , "WindowAdapter"
                               , "WindowConstants"
                               , "WindowEvent"
                               , "WindowFocusListener"
                               , "WindowListener"
                               , "WindowStateListener"
                               , "WrappedPlainView"
                               , "WritableByteChannel"
                               , "WritableRaster"
                               , "WritableRenderedImage"
                               , "WriteAbortedException"
                               , "Writer"
                               , "WrongAdapter"
                               , "WrongAdapterHelper"
                               , "WrongPolicy"
                               , "WrongPolicyHelper"
                               , "WrongTransaction"
                               , "WrongTransactionHelper"
                               , "WrongTransactionHolder"
                               , "X500Principal"
                               , "X500PrivateCredential"
                               , "X509CRL"
                               , "X509CRLEntry"
                               , "X509CRLSelector"
                               , "X509CertSelector"
                               , "X509Certificate"
                               , "X509EncodedKeySpec"
                               , "X509ExtendedKeyManager"
                               , "X509Extension"
                               , "X509KeyManager"
                               , "X509TrustManager"
                               , "XAConnection"
                               , "XADataSource"
                               , "XAException"
                               , "XAResource"
                               , "XMLConstants"
                               , "XMLDecoder"
                               , "XMLEncoder"
                               , "XMLFilter"
                               , "XMLFilterImpl"
                               , "XMLFormatter"
                               , "XMLGregorianCalendar"
                               , "XMLParseException"
                               , "XMLReader"
                               , "XMLReaderAdapter"
                               , "XMLReaderFactory"
                               , "XPath"
                               , "XPathConstants"
                               , "XPathException"
                               , "XPathExpression"
                               , "XPathExpressionException"
                               , "XPathFactory"
                               , "XPathFactoryConfigurationException"
                               , "XPathFunction"
                               , "XPathFunctionException"
                               , "XPathFunctionResolver"
                               , "XPathVariableResolver"
                               , "Xid"
                               , "XmlReader"
                               , "XmlWriter"
                               , "ZipEntry"
                               , "ZipException"
                               , "ZipFile"
                               , "ZipInputStream"
                               , "ZipOutputStream"
                               , "ZoneView"
                               , "_BindingIteratorImplBase"
                               , "_BindingIteratorStub"
                               , "_DynAnyFactoryStub"
                               , "_DynAnyStub"
                               , "_DynArrayStub"
                               , "_DynEnumStub"
                               , "_DynFixedStub"
                               , "_DynSequenceStub"
                               , "_DynStructStub"
                               , "_DynUnionStub"
                               , "_DynValueStub"
                               , "_IDLTypeStub"
                               , "_NamingContextExtStub"
                               , "_NamingContextImplBase"
                               , "_NamingContextStub"
                               , "_PolicyStub"
                               , "_Remote_Stub"
                               , "_ServantActivatorStub"
                               , "_ServantLocatorStub"
                               ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "Actor"
                               , "ActorProxy"
                               , "ActorTask"
                               , "ActorThread"
                               , "AllRef"
                               , "Any"
                               , "AnyRef"
                               , "Application"
                               , "AppliedType"
                               , "Array"
                               , "ArrayBuffer"
                               , "Attribute"
                               , "BoxedArray"
                               , "BoxedBooleanArray"
                               , "BoxedByteArray"
                               , "BoxedCharArray"
                               , "Buffer"
                               , "BufferedIterator"
                               , "Char"
                               , "Console"
                               , "Enumeration"
                               , "Fluid"
                               , "Function"
                               , "IScheduler"
                               , "ImmutableMapAdaptor"
                               , "ImmutableSetAdaptor"
                               , "Int"
                               , "Iterable"
                               , "List"
                               , "ListBuffer"
                               , "None"
                               , "Option"
                               , "Ordered"
                               , "Pair"
                               , "PartialFunction"
                               , "Pid"
                               , "Predef"
                               , "PriorityQueue"
                               , "PriorityQueueProxy"
                               , "Reaction"
                               , "Ref"
                               , "Responder"
                               , "RichInt"
                               , "RichString"
                               , "Rule"
                               , "RuleTransformer"
                               , "Script"
                               , "Seq"
                               , "SerialVersionUID"
                               , "Some"
                               , "Stream"
                               , "Symbol"
                               , "TcpService"
                               , "TcpServiceWorker"
                               , "Triple"
                               , "Unit"
                               , "Value"
                               , "WorkerThread"
                               , "serializable"
                               , "transient"
                               , "volatile"
                               ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Float
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren =
                          [ Rule
                              { rMatcher = AnyChar "fF"
                              , rAttribute = FloatTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = True
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          ]
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCOct
                      , rAttribute = BaseNTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCHex
                      , rAttribute = BaseNTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren =
                          [ Rule
                              { rMatcher = StringDetect "ULL"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          , Rule
                              { rMatcher = StringDetect "LUL"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          , Rule
                              { rMatcher = StringDetect "LLU"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          , Rule
                              { rMatcher = StringDetect "UL"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          , Rule
                              { rMatcher = StringDetect "LU"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          , Rule
                              { rMatcher = StringDetect "LL"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          , Rule
                              { rMatcher = StringDetect "U"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          , Rule
                              { rMatcher = StringDetect "L"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          ]
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCChar
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "//\\s*BEGIN.*$"
                              , reCompiled = Just (compileRegex True "//\\s*BEGIN.*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "//\\s*END.*$"
                              , reCompiled = Just (compileRegex True "//\\s*END.*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scala" , "String" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\.(format|printf)\\b"
                              , reCompiled = Just (compileRegex True "\\.(format|printf)\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scala" , "Printf" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '/' '/'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scala" , "Commentar 1" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '/' '*'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scala" , "Commentar 2" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '{'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\b[_\\w][_\\w\\d]*(?=[\\s]*(/\\*\\s*\\d+\\s*\\*/\\s*)?[(])"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\b[_\\w][_\\w\\d]*(?=[\\s]*(/\\*\\s*\\d+\\s*\\*/\\s*)?[(])")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[.]{1,1}"
                              , reCompiled = Just (compileRegex True "[.]{1,1}")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scala" , "Member" ) ]
                      }
                  , Rule
                      { rMatcher = AnyChar ":!%&()+,-/.*<=>?[]|~^;"
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Printf"
          , Context
              { cName = "Printf"
              , cSyntax = "Scala"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar ';'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Scala" , "PrintfString" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "PrintfString"
          , Context
              { cName = "PrintfString"
              , cSyntax = "Scala"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "%(\\d+\\$)?(-|#|\\+|\\ |0|,|\\()*\\d*(\\.\\d+)?[a-hosxA-CEGHSX]"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "%(\\d+\\$)?(-|#|\\+|\\ |0|,|\\()*\\d*(\\.\\d+)?[a-hosxA-CEGHSX]")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "%(\\d+\\$)?(-|#|\\+|\\ |0|,|\\()*\\d*(t|T)(a|A|b|B|c|C|d|D|e|F|h|H|I|j|k|l|L|m|M|N|p|P|Q|r|R|s|S|T|y|Y|z|Z)"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "%(\\d+\\$)?(-|#|\\+|\\ |0|,|\\()*\\d*(t|T)(a|A|b|B|c|C|d|D|e|F|h|H|I|j|k|l|L|m|M|N|p|P|Q|r|R|s|S|T|y|Y|z|Z)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "%(%|n)"
                              , reCompiled = Just (compileRegex True "%(%|n)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "String"
          , Context
              { cName = "String"
              , cSyntax = "Scala"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Stephane Micheloud (stephane.micheloud@epfl.ch)"
  , sVersion = "2"
  , sLicense = "LGPL"
  , sExtensions = [ "*.scala" ]
  , sStartingContext = "Normal"
  }
