{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.R (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "R Script"
  , sFilename = "r.xml"
  , sShortname = "R"
  , sContexts =
      fromList
        [ ( "Comment"
          , Context
              { cName = "Comment"
              , cSyntax = "R Script"
              , cRules =
                  [ Rule
                      { rMatcher = IncludeRules ( "Alerts" , "" )
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "CommonRules"
          , Context
              { cName = "CommonRules"
              , cSyntax = "R Script"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "R Script" , "string" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "R Script" , "string2" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '`'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "R Script" , "backquotedsymbol" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !$%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "break"
                               , "else"
                               , "for"
                               , "function"
                               , "if"
                               , "in"
                               , "next"
                               , "repeat"
                               , "switch"
                               , "while"
                               ])
                      , rAttribute = ControlFlowTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !$%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "FALSE"
                               , "Inf"
                               , "NA"
                               , "NA_character_"
                               , "NA_complex_"
                               , "NA_integer_"
                               , "NA_real_"
                               , "NULL"
                               , "NaN"
                               , "TRUE"
                               ])
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Float
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[a-zA-Z_]+[a-zA-Z_\\.0-9]*(?=[\\s]*[(])"
                              , reCompiled =
                                  Just (compileRegex True "[a-zA-Z_]+[a-zA-Z_\\.0-9]*(?=[\\s]*[(])")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\.[a-zA-Z_\\.]+[a-zA-Z_\\.0-9]*(?=[\\s]*[(])"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\.[a-zA-Z_\\.]+[a-zA-Z_\\.0-9]*(?=[\\s]*[(])")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\("
                              , reCompiled = Just (compileRegex True "\\(")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "R Script" , "parenthesis" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "##"
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "R Script" , "Headline" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "R Script" , "Comment" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[<]{1,2}\\-"
                              , reCompiled = Just (compileRegex True "[<]{1,2}\\-")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "R Script" , "operator_rhs" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\-[>]{1,2}"
                              , reCompiled = Just (compileRegex True "\\-[>]{1,2}")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "R Script" , "operator_rhs" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "=(?!=)"
                              , reCompiled = Just (compileRegex True "=(?!=)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "R Script" , "operator_rhs" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "(\\+|\\-|\\*{1,2}|/|<=?|>=?|={1,2}|\\!=?|\\|{1,2}|&{1,2}|:{1,3}|\\^|@|\\$|~)"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "(\\+|\\-|\\*{1,2}|/|<=?|>=?|={1,2}|\\!=?|\\|{1,2}|&{1,2}|:{1,3}|\\^|@|\\$|~)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OperatorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "R Script" , "operator_rhs" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "%[^%]*%"
                              , reCompiled = Just (compileRegex True "%[^%]*%")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OperatorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "R Script" , "operator_rhs" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '{'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "R Script" , "ctx0" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '['
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar ']'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Headline"
          , Context
              { cName = "Headline"
              , cSyntax = "R Script"
              , cRules =
                  [ Rule
                      { rMatcher = IncludeRules ( "Alerts" , "" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "backquotedsymbol"
          , Context
              { cName = "backquotedsymbol"
              , cSyntax = "R Script"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '`'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "ctx0"
          , Context
              { cName = "ctx0"
              , cSyntax = "R Script"
              , cRules =
                  [ Rule
                      { rMatcher = IncludeRules ( "R Script" , "CommonRules" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar ')'
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "level0"
          , Context
              { cName = "level0"
              , cSyntax = "R Script"
              , cRules =
                  [ Rule
                      { rMatcher = IncludeRules ( "R Script" , "CommonRules" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar ')'
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "operator_rhs"
          , Context
              { cName = "operator_rhs"
              , cSyntax = "R Script"
              , cRules =
                  [ Rule
                      { rMatcher = StringDetect "##"
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "R Script" , "Headline" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "R Script" , "Comment" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar ' '
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "(\\*|/|<|>|\\!=|=|\\||&|:|\\^|@|\\$|~)"
                              , reCompiled =
                                  Just (compileRegex True "(\\*|/|<|>|\\!=|=|\\||&|:|\\^|@|\\$|~)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = True
              , cFallthroughContext = [ Pop ]
              , cDynamic = False
              }
          )
        , ( "parenthesis"
          , Context
              { cName = "parenthesis"
              , cSyntax = "R Script"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar ')'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[a-zA-Z_\\.][0-9a-zA-Z_\\.]*[\\s]*=(?=([^=]|$))"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "[a-zA-Z_\\.][0-9a-zA-Z_\\.]*[\\s]*=(?=([^=]|$))")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "R Script" , "CommonRules" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "string"
          , Context
              { cName = "string"
              , cSyntax = "R Script"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "string2"
          , Context
              { cName = "string2"
              , cSyntax = "R Script"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = ""
  , sVersion = "6"
  , sLicense = "GPLv2"
  , sExtensions = [ "*.R" , "*.r" , "*.S" , "*.s" , "*.q" ]
  , sStartingContext = "level0"
  }
