{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Modula2 (syntax) where

import Skylighting.Types
import Data.Map
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "Modula-2"
  , sFilename = "modula-2.xml"
  , sShortname = "Modula2"
  , sContexts =
      fromList
        [ ( "Comment2"
          , Context
              { cName = "Comment2"
              , cSyntax = "Modula-2"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' ')'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Comment3"
          , Context
              { cName = "Comment3"
              , cSyntax = "Modula-2"
              , cRules = []
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Normal"
          , Context
              { cName = "Normal"
              , cSyntax = "Modula-2"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "ABS"
                               , "AND"
                               , "ARRAY"
                               , "ASM"
                               , "BEGIN"
                               , "BITSET"
                               , "BY"
                               , "CAP"
                               , "CASE"
                               , "CHR"
                               , "CONST"
                               , "DEC"
                               , "DEFINITION"
                               , "DIV"
                               , "DO"
                               , "ELSE"
                               , "ELSIF"
                               , "END"
                               , "EXCL"
                               , "EXIT"
                               , "EXPORT"
                               , "FALSE"
                               , "FOR"
                               , "FOREIGN"
                               , "FROM"
                               , "HALT"
                               , "HIGH"
                               , "IF"
                               , "IMPLEMENTATION"
                               , "IMPORT"
                               , "IN"
                               , "INC"
                               , "INCL"
                               , "IOTRANSFER"
                               , "LOOP"
                               , "MAX"
                               , "MIN"
                               , "MOD"
                               , "MODULE"
                               , "NEWPROCESS"
                               , "NIL"
                               , "NOT"
                               , "ODD"
                               , "OF"
                               , "OR"
                               , "ORD"
                               , "PROC"
                               , "PROCEDURE"
                               , "QUALIFIED"
                               , "RECORD"
                               , "REPEAT"
                               , "RETURN"
                               , "SET"
                               , "THEN"
                               , "TO"
                               , "TRANSFER"
                               , "TRUE"
                               , "TRUNC"
                               , "TYPE"
                               , "UNTIL"
                               , "VAL"
                               , "VAR"
                               , "WHILE"
                               , "WITH"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "ALLOCATE"
                               , "ASSEMBLER"
                               , "Accessible"
                               , "Append"
                               , "Assign"
                               , "CAPS"
                               , "Close"
                               , "Concat"
                               , "Copy"
                               , "DEALLOCATE"
                               , "Delete"
                               , "Done"
                               , "EOF"
                               , "EmptyString"
                               , "Erase"
                               , "GetArgs"
                               , "GetCard"
                               , "GetChar"
                               , "GetEnv"
                               , "GetInt"
                               , "GetLongReal"
                               , "GetReal"
                               , "GetString"
                               , "Insert"
                               , "Length"
                               , "Open"
                               , "OpenInput"
                               , "OpenOutput"
                               , "PutBf"
                               , "PutCard"
                               , "PutChar"
                               , "PutInt"
                               , "PutLn"
                               , "PutLongReal"
                               , "PutReal"
                               , "PutString"
                               , "Read"
                               , "ReadCard"
                               , "ReadInt"
                               , "ReadLongReal"
                               , "ReadReal"
                               , "ReadString"
                               , "ResetClock"
                               , "SIZE"
                               , "StrEq"
                               , "SystemTime"
                               , "UserTime"
                               , "Write"
                               , "WriteBf"
                               , "WriteCard"
                               , "WriteInt"
                               , "WriteLn"
                               , "WriteLongReal"
                               , "WriteReal"
                               , "WriteString"
                               , "compare"
                               , "pos"
                               ])
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "ADDRESS"
                               , "ADR"
                               , "BOOLEAN"
                               , "CARDINAL"
                               , "CHAR"
                               , "File"
                               , "INTEGER"
                               , "LONGINT"
                               , "LONGREAL"
                               , "POINTER"
                               , "REAL"
                               , "SHORTCARD"
                               , "SHORTINT"
                               ])
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Float
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Modula-2" , "String1" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Modula-2" , "String2" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "(*$"
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Modula-2" , "Prep1" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '(' '*'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Modula-2" , "Comment2" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Prep1"
          , Context
              { cName = "Prep1"
              , cSyntax = "Modula-2"
              , cRules =
                  [ Rule
                      { rMatcher = StringDetect "$*)"
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Modula-2" , "Prep1" ) ]
                      }
                  ]
              , cAttribute = OtherTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "String1"
          , Context
              { cName = "String1"
              , cSyntax = "Modula-2"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "String2"
          , Context
              { cName = "String2"
              , cSyntax = "Modula-2"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = ""
  , sVersion = "2"
  , sLicense = ""
  , sExtensions = [ "*.mod" , "*.def" , "*.mi" , "*.md" ]
  , sStartingContext = "Normal"
  }
