{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Metafont (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "Metapost/Metafont"
  , sFilename = "metafont.xml"
  , sShortname = "Metafont"
  , sContexts =
      fromList
        [ ( "Comment"
          , Context
              { cName = "Comment"
              , cSyntax = "Metapost/Metafont"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "(FIXME|TODO):?"
                              , reCompiled = Just (compileRegex True "(FIXME|TODO):?")
                              , reCaseSensitive = True
                              }
                      , rAttribute = AlertTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '\215'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "ContrSeq"
          , Context
              { cName = "ContrSeq"
              , cSyntax = "Metapost/Metafont"
              , cRules =
                  [ Rule
                      { rMatcher = StringDetect "verb*"
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Metapost/Metafont" , "Verb" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "verb(?=[^a-zA-Z])"
                              , reCompiled = Just (compileRegex True "verb(?=[^a-zA-Z])")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Metapost/Metafont" , "Verb" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\215'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[a-zA-Z]+(\\+?|\\*{0,3})"
                              , reCompiled = Just (compileRegex True "[a-zA-Z]+(\\+?|\\*{0,3})")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[^a-zA-Z]"
                              , reCompiled = Just (compileRegex True "[^a-zA-Z]")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "MathContrSeq"
          , Context
              { cName = "MathContrSeq"
              , cSyntax = "Metapost/Metafont"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '\215'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[a-zA-Z]+\\*?"
                              , reCompiled = Just (compileRegex True "[a-zA-Z]+\\*?")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[^a-zA-Z]"
                              , reCompiled = Just (compileRegex True "[^a-zA-Z]")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "MathMode"
          , Context
              { cName = "MathMode"
              , cSyntax = "Metapost/Metafont"
              , cRules =
                  [ Rule
                      { rMatcher = StringDetect "$$"
                      , rAttribute = AlertTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '\\'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "Metapost/Metafont" , "MathContrSeq" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' ')'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' ']'
                      , rAttribute = AlertTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Normal Text"
          , Context
              { cName = "Normal Text"
              , cSyntax = "Metapost/Metafont"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "and"
                               , "charexists"
                               , "false"
                               , "known"
                               , "not"
                               , "odd"
                               , "or"
                               , "true"
                               , "unknown"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "abs"
                               , "angle"
                               , "ASCII"
                               , "ceiling"
                               , "cosd"
                               , "directiontime"
                               , "div"
                               , "dotprod"
                               , "floor"
                               , "hex"
                               , "length"
                               , "max"
                               , "mexp"
                               , "min"
                               , "mlog"
                               , "mod"
                               , "normaldeviate"
                               , "oct"
                               , "sind"
                               , "sqrt"
                               , "totalweight"
                               , "turningnumber"
                               , "uniformdeviate"
                               , "xpart"
                               , "xxpart"
                               , "xypart"
                               , "ypart"
                               , "yxpart"
                               , "yypart"
                               ])
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "autorounding"
                               , "boundarychar"
                               , "charcode"
                               , "chardp"
                               , "chardx"
                               , "chardy"
                               , "charext"
                               , "charht"
                               , "charic"
                               , "charwd"
                               , "day"
                               , "designsize"
                               , "fillin"
                               , "fontmaking"
                               , "granularity"
                               , "hppp"
                               , "month"
                               , "pausing"
                               , "proofing"
                               , "showstopping"
                               , "smoothing"
                               , "time"
                               , "tracingcapsules"
                               , "tracingchoices"
                               , "tracingcommands"
                               , "tracingedges"
                               , "tracingequations"
                               , "tracingmacros"
                               , "tracingonline"
                               , "tracingoutput"
                               , "tracingpens"
                               , "tracingrestores"
                               , "tracingspecs"
                               , "tracingstats"
                               , "tracingtitles"
                               , "turningcheck"
                               , "vppp"
                               , "warningcheck"
                               , "xoffset"
                               , "year"
                               , "yoffset"
                               ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "of"
                               , "penoffset"
                               , "point"
                               , "postcontrol"
                               , "precontrol"
                               , "rotated"
                               , "scaled"
                               , "shifted"
                               , "slanted"
                               , "transformed"
                               , "xscaled"
                               , "yscaled"
                               , "zscaled"
                               ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "atleast"
                               , "controls"
                               , "curl"
                               , "cycle"
                               , "makepath"
                               , "reverse"
                               , "subpath"
                               , "tension"
                               ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet False [ "makepen" , "nullpen" , "pencircle" ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet False [ "nullpicture" ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "char"
                               , "decimal"
                               , "jobname"
                               , "readstring"
                               , "str"
                               , "substring"
                               ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "addto"
                               , "also"
                               , "at"
                               , "batchmode"
                               , "contour"
                               , "cull"
                               , "delimiters"
                               , "display"
                               , "doublepath"
                               , "dropping"
                               , "dump"
                               , "end"
                               , "errhelp"
                               , "errmessage"
                               , "errorstopmode"
                               , "everyjob"
                               , "from"
                               , "interim"
                               , "inwindow"
                               , "keeping"
                               , "let"
                               , "message"
                               , "newinternal"
                               , "nonstopmode"
                               , "numspecial"
                               , "openwindow"
                               , "outer"
                               , "randomseed"
                               , "save"
                               , "scrollmode"
                               , "shipout"
                               , "show"
                               , "showdependencies"
                               , "showstats"
                               , "showtoken"
                               , "showvariable"
                               , "special"
                               , "to"
                               , "withpen"
                               , "withweight"
                               ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "boolean"
                               , "numeric"
                               , "pair"
                               , "path"
                               , "pen"
                               , "picture"
                               , "string"
                               , "transform"
                               ])
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "expr"
                               , "primary"
                               , "primarydef"
                               , "secondary"
                               , "secondarydef"
                               , "suffix"
                               , "tertiary"
                               , "tertiarydef"
                               , "text"
                               ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False [ "else" , "elseif" , "exitif" , "step" , "until" , "upto" ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "charlist"
                               , "endinput"
                               , "expandafter"
                               , "extensible"
                               , "fontdimen"
                               , "headerbyte"
                               , "inner"
                               , "input"
                               , "intersectiontimes"
                               , "kern"
                               , "ligtable"
                               , "quote"
                               , "scantokens"
                               , "skipto"
                               ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "addto_currentpicture"
                               , "aspect_ratio"
                               , "base_name"
                               , "base_version"
                               , "blacker"
                               , "blankpicture"
                               , "bot"
                               , "bye"
                               , "byte"
                               , "capsule_def"
                               , "change_width"
                               , "clear_pen_memory"
                               , "clearit"
                               , "clearpen"
                               , "clearxy"
                               , "counterclockwise"
                               , "culldraw"
                               , "cullit"
                               , "currentpen"
                               , "currentpen_path"
                               , "currentpicture"
                               , "currenttransform"
                               , "currentwindow"
                               , "cutdraw"
                               , "cutoff"
                               , "d"
                               , "decr"
                               , "define_blacker_pixels"
                               , "define_corrected_pixels"
                               , "define_good_x_pixels"
                               , "define_good_y_pixels"
                               , "define_horizontal_corrected_pixels"
                               , "define_pixels"
                               , "define_whole_blacker_pixels"
                               , "define_whole_pixels"
                               , "define_whole_vertical_blacker_pixels"
                               , "define_whole_vertical_pixels"
                               , "dir"
                               , "direction"
                               , "directionpoint"
                               , "displaying"
                               , "ditto"
                               , "down"
                               , "downto"
                               , "draw"
                               , "drawdot"
                               , "eps"
                               , "epsilon"
                               , "erase"
                               , "exitunless"
                               , "extra_setup"
                               , "fill"
                               , "filldraw"
                               , "fix_units"
                               , "flex"
                               , "font_coding_scheme"
                               , "font_extra_space"
                               , "font_identifier"
                               , "font_normal_shrink"
                               , "font_normal_space"
                               , "font_normal_stretch"
                               , "font_quad"
                               , "font_setup"
                               , "font_size"
                               , "font_slant"
                               , "font_x_height"
                               , "fullcircle"
                               , "generate"
                               , "gfcorners"
                               , "gobble"
                               , "gobbled"
                               , "grayfont"
                               , "h"
                               , "halfcircle"
                               , "hide"
                               , "hround"
                               , "identity"
                               , "image_rules"
                               , "incr"
                               , "infinity"
                               , "interact"
                               , "interpath"
                               , "intersectionpoint"
                               , "inverse"
                               , "italcorr"
                               , "join_radius"
                               , "killtext"
                               , "labelfont"
                               , "labels"
                               , "left"
                               , "lft"
                               , "localfont"
                               , "loggingall"
                               , "lowres"
                               , "lowres_fix"
                               , "mag"
                               , "magstep"
                               , "makebox"
                               , "makegrid"
                               , "makelabel"
                               , "maketicks"
                               , "mode"
                               , "mode_def"
                               , "mode_name"
                               , "mode_setup"
                               , "nodisplays"
                               , "notransforms"
                               , "number_of_modes"
                               , "numtok"
                               , "o_correction"
                               , "openit"
                               , "origin"
                               , "pen_bot"
                               , "pen_lft"
                               , "pen_rt"
                               , "pen_top"
                               , "penlabels"
                               , "penpos"
                               , "penrazor"
                               , "penspeck"
                               , "pensquare"
                               , "penstroke"
                               , "pickup"
                               , "pixels_per_inch"
                               , "proof"
                               , "proofoffset"
                               , "proofrule"
                               , "proofrulethickness"
                               , "quartercircle"
                               , "range"
                               , "reflectedabout"
                               , "relax"
                               , "right"
                               , "rotatedabout"
                               , "rotatedaround"
                               , "round"
                               , "rt"
                               , "rulepen"
                               , "savepen"
                               , "screen_cols"
                               , "screen_rows"
                               , "screenchars"
                               , "screenrule"
                               , "screenstrokes"
                               , "shipit"
                               , "showit"
                               , "slantfont"
                               , "smode"
                               , "smoke"
                               , "softjoin"
                               , "solve"
                               , "stop"
                               , "superellipse"
                               , "takepower"
                               , "tensepath"
                               , "titlefont"
                               , "tolerance"
                               , "top"
                               , "tracingall"
                               , "tracingnone"
                               , "undraw"
                               , "undrawdot"
                               , "unfill"
                               , "unfilldraw"
                               , "unitpixel"
                               , "unitsquare"
                               , "unitvector"
                               , "up"
                               , "upto"
                               , "vround"
                               , "w"
                               , "whatever"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "bluepart"
                               , "clip"
                               , "color"
                               , "dashed"
                               , "fontsize"
                               , "greenpart"
                               , "infont"
                               , "linecap"
                               , "linejoin"
                               , "llcorner"
                               , "lrcorner"
                               , "miterlimit"
                               , "mpxbreak"
                               , "prologues"
                               , "redpart"
                               , "setbounds"
                               , "tracinglostchars"
                               , "truecorners"
                               , "ulcorner"
                               , "urcorner"
                               , "withcolor"
                               ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "ahangle"
                               , "ahlength"
                               , "arrowhead"
                               , "background"
                               , "base_name"
                               , "base_version"
                               , "bbox"
                               , "bboxmargin"
                               , "beveled"
                               , "black"
                               , "blacker"
                               , "blankpicture"
                               , "blue"
                               , "bot"
                               , "boxit"
                               , "boxjoin"
                               , "bpath"
                               , "buildcycle"
                               , "butt"
                               , "bye"
                               , "byte"
                               , "capsule_def"
                               , "center"
                               , "change_width"
                               , "circleit"
                               , "circmargin"
                               , "clear_pen_memory"
                               , "clearit"
                               , "clearpen"
                               , "clearxy"
                               , "counterclockwise"
                               , "cullit"
                               , "currentpen"
                               , "currentpen_path"
                               , "currentpicture"
                               , "currenttransform"
                               , "cutafter"
                               , "cutbefore"
                               , "cutdraw"
                               , "cuttings"
                               , "dashpattern"
                               , "decr"
                               , "defaultdx"
                               , "defaultdy"
                               , "defaultfont"
                               , "defaultpen"
                               , "defaultscale"
                               , "define_blacker_pixels"
                               , "define_corrected_pixels"
                               , "define_good_x_pixels"
                               , "define_good_y_pixels"
                               , "define_horizontal_corrected_pixels"
                               , "define_pixels"
                               , "define_whole_blacker_pixels"
                               , "define_whole_vertical_blacker_pixels"
                               , "define_whole_vertical_pixels"
                               , "dir"
                               , "direction"
                               , "directionpoint"
                               , "ditto"
                               , "dotlabel"
                               , "dotlabels"
                               , "down"
                               , "downto"
                               , "draw"
                               , "drawarrow"
                               , "drawboxed"
                               , "drawboxes"
                               , "drawdblarrow"
                               , "drawdot"
                               , "drawoptions"
                               , "drawunboxed"
                               , "EOF"
                               , "eps"
                               , "epsilon"
                               , "erase"
                               , "evenly"
                               , "exitunless"
                               , "extra_setup"
                               , "fill"
                               , "filldraw"
                               , "fixpos"
                               , "fixsize"
                               , "flex"
                               , "font_coding_scheme"
                               , "font_extra_space"
                               , "font_identifier"
                               , "font_normal_shrink"
                               , "font_normal_space"
                               , "font_normal_stretch"
                               , "font_quad"
                               , "font_size"
                               , "font_slant"
                               , "font_x_height"
                               , "fullcircle"
                               , "gfcorners"
                               , "gobble"
                               , "gobbled"
                               , "grayfont"
                               , "green"
                               , "halfcircle"
                               , "hide"
                               , "hround"
                               , "identity"
                               , "image"
                               , "imagerules"
                               , "incr"
                               , "infinity"
                               , "interact"
                               , "interpath"
                               , "intersectionpoint"
                               , "inverse"
                               , "italcorr"
                               , "label"
                               , "labelfont"
                               , "labeloffset"
                               , "labels"
                               , "left"
                               , "lft"
                               , "llft"
                               , "loggingall"
                               , "lowres_fix"
                               , "lrt"
                               , "magstep"
                               , "makebox"
                               , "makegrid"
                               , "makelabel"
                               , "maketicks"
                               , "mitered"
                               , "mode_def"
                               , "mode_setup"
                               , "nodisplays"
                               , "notransforms"
                               , "numeric_pickup"
                               , "numtok"
                               , "o_correction"
                               , "openit"
                               , "origin"
                               , "pen_bot"
                               , "pen_lft"
                               , "pen_rt"
                               , "pen_top"
                               , "penlabel"
                               , "penpos"
                               , "penrazor"
                               , "penspeck"
                               , "pensquare"
                               , "penstroke"
                               , "pic"
                               , "pickup"
                               , "proofoffset"
                               , "proofrule"
                               , "proofrulethickness"
                               , "quartercircle"
                               , "range"
                               , "red"
                               , "reflectedabout"
                               , "relax"
                               , "right"
                               , "rotatedabout"
                               , "rotatedaround"
                               , "round"
                               , "rounded"
                               , "rt"
                               , "rulepen"
                               , "savepen"
                               , "screenchars"
                               , "screenrule"
                               , "screenstrokes"
                               , "shipit"
                               , "showit"
                               , "slantfont"
                               , "smode"
                               , "softjoin"
                               , "solve"
                               , "squared"
                               , "stop"
                               , "superellipse"
                               , "takepower"
                               , "tensepath"
                               , "thelabel"
                               , "thru"
                               , "titlefont"
                               , "top"
                               , "tracingall"
                               , "tracingnone"
                               , "ulft"
                               , "undraw"
                               , "undrawdot"
                               , "unfill"
                               , "unfilldraw"
                               , "unitpixel"
                               , "unitsquare"
                               , "unitvector"
                               , "up"
                               , "upto"
                               , "urt"
                               , "vround"
                               , "whatever"
                               , "white"
                               , "withdots"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '%'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Metapost/Metafont" , "Comment" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Metapost/Metafont" , "string" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "(\\+|\\-|\\*|\\/|\\=|\\:\\=)"
                              , reCompiled =
                                  Just (compileRegex True "(\\+|\\-|\\*|\\/|\\=|\\:\\=)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '.' '.'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCOct
                      , rAttribute = BaseNTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCHex
                      , rAttribute = BaseNTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Float
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b(bp|cc|cm|dd|in|mm|pc|pt)\\b"
                              , reCompiled =
                                  Just (compileRegex True "\\b(bp|cc|cm|dd|in|mm|pc|pt)\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b-?\\d+(bp|cc|cm|dd|in|mm|pc|pt)#?\\b"
                              , reCompiled =
                                  Just (compileRegex True "\\b-?\\d+(bp|cc|cm|dd|in|mm|pc|pt)#?\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b-?\\.\\d+(bp|cc|cm|dd|in|mm|pc|pt)#?\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex True "\\b-?\\.\\d+(bp|cc|cm|dd|in|mm|pc|pt)#?\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b-?\\d+\\.\\d+(bp|cc|cm|dd|in|mm|pc|pt)#?\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\b-?\\d+\\.\\d+(bp|cc|cm|dd|in|mm|pc|pt)#?\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b[xy]\\d(\\w|\\')*"
                              , reCompiled = Just (compileRegex True "\\b[xy]\\d(\\w|\\')*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bz\\d(\\w|\\')*"
                              , reCompiled = Just (compileRegex True "\\bz\\d(\\w|\\')*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bp\\d(\\w|\\')*"
                              , reCompiled = Just (compileRegex True "\\bp\\d(\\w|\\')*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b(verbatimtex|btex)\\b"
                              , reCompiled = Just (compileRegex False "\\b(verbatimtex|btex)\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Metapost/Metafont" , "TeXMode" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bbegin(group|fig|char)\\b"
                              , reCompiled =
                                  Just (compileRegex False "\\bbegin(group|fig|char)\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bend(group|fig|char)\\b"
                              , reCompiled =
                                  Just (compileRegex False "\\bend(group|fig|char)\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bextra_begin(group|fig|char)\\b"
                              , reCompiled =
                                  Just (compileRegex False "\\bextra_begin(group|fig|char)\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bextra_end(group|fig|char)\\b"
                              , reCompiled =
                                  Just (compileRegex False "\\bextra_end(group|fig|char)\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b(def|vardef)\\b"
                              , reCompiled = Just (compileRegex False "\\b(def|vardef)\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\benddef\\b"
                              , reCompiled = Just (compileRegex False "\\benddef\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bif\\b"
                              , reCompiled = Just (compileRegex False "\\bif\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bfi\\b"
                              , reCompiled = Just (compileRegex False "\\bfi\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b(for|forsuffixes|forever)\\b"
                              , reCompiled =
                                  Just (compileRegex False "\\b(for|forsuffixes|forever)\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bendfor\\b"
                              , reCompiled = Just (compileRegex False "\\bendfor\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "TeXMode"
          , Context
              { cName = "TeXMode"
              , cSyntax = "Metapost/Metafont"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '\\'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Metapost/Metafont" , "ContrSeq" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Metapost/Metafont" , "MathMode" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "\\("
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Metapost/Metafont" , "MathMode" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\betex\\b"
                              , reCompiled = Just (compileRegex False "\\betex\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "ToEndOfLine"
          , Context
              { cName = "ToEndOfLine"
              , cSyntax = "Metapost/Metafont"
              , cRules = []
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Verb"
          , Context
              { cName = "Verb"
              , cSyntax = "Metapost/Metafont"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "(.)"
                              , reCompiled = Nothing
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Metapost/Metafont" , "VerbEnd" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop , Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "VerbEnd"
          , Context
              { cName = "VerbEnd"
              , cSyntax = "Metapost/Metafont"
              , cRules =
                  [ Rule
                      { rMatcher = StringDetect "%1"
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\215'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[^%1\\xd7]*"
                              , reCompiled = Nothing
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop , Pop , Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = True
              }
          )
        , ( "string"
          , Context
              { cName = "string"
              , cSyntax = "Metapost/Metafont"
              , cRules =
                  [ Rule
                      { rMatcher = DetectIdentifier
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' '\\'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Yedvilun (yedvilun@gmail.com)"
  , sVersion = "1"
  , sLicense = "LGPL"
  , sExtensions = [ "*.mp" , "*.mps" , "*.mpost" , "*.mf" ]
  , sStartingContext = "Normal Text"
  }
