{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Mathematica (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "Mathematica"
  , sFilename = "mathematica.xml"
  , sShortname = "Mathematica"
  , sContexts =
      fromList
        [ ( "Normal"
          , Context
              { cName = "Normal"
              , cSyntax = "Mathematica"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n !&()*+,./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "$"
                               , "$Aborted"
                               , "$AssertFunction"
                               , "$Assumptions"
                               , "$BaseDirectory"
                               , "$BatchInput"
                               , "$BatchOutput"
                               , "$ByteOrdering"
                               , "$Canceled"
                               , "$CharacterEncoding"
                               , "$CharacterEncodings"
                               , "$CommandLine"
                               , "$CompilationTarget"
                               , "$ConfiguredKernels"
                               , "$Context"
                               , "$ContextPath"
                               , "$ControlActiveSetting"
                               , "$CreationDate"
                               , "$CurrentLink"
                               , "$DateStringFormat"
                               , "$DefaultImagingDevice"
                               , "$Display"
                               , "$DisplayFunction"
                               , "$DistributedContexts"
                               , "$DynamicEvaluation"
                               , "$Echo"
                               , "$Epilog"
                               , "$ExportFormats"
                               , "$Failed"
                               , "$FrontEnd"
                               , "$FrontEndSession"
                               , "$GeoLocation"
                               , "$HistoryLength"
                               , "$HomeDirectory"
                               , "$IgnoreEOF"
                               , "$ImagingDevices"
                               , "$ImportFormats"
                               , "$InitialDirectory"
                               , "$Input"
                               , "$InputFileName"
                               , "$Inspector"
                               , "$InstallationDirectory"
                               , "$IterationLimit"
                               , "$KernelCount"
                               , "$KernelID"
                               , "$Language"
                               , "$LibraryPath"
                               , "$LicenseExpirationDate"
                               , "$LicenseID"
                               , "$LicenseServer"
                               , "$Line"
                               , "$Linked"
                               , "$MachineAddresses"
                               , "$MachineDomains"
                               , "$MachineEpsilon"
                               , "$MachineID"
                               , "$MachineName"
                               , "$MachinePrecision"
                               , "$MachineType"
                               , "$MaxExtraPrecision"
                               , "$MaxMachineNumber"
                               , "$MaxNumber"
                               , "$MaxPiecewiseCases"
                               , "$MaxPrecision"
                               , "$MaxRootDegree"
                               , "$MessageGroups"
                               , "$MessageList"
                               , "$MessagePrePrint"
                               , "$Messages"
                               , "$MinMachineNumber"
                               , "$MinNumber"
                               , "$MinPrecision"
                               , "$ModuleNumber"
                               , "$NewMessage"
                               , "$NewSymbol"
                               , "$Notebooks"
                               , "$NumberMarks"
                               , "$OperatingSystem"
                               , "$Output"
                               , "$OutputSizeLimit"
                               , "$Packages"
                               , "$ParentLink"
                               , "$ParentProcessID"
                               , "$Path"
                               , "$PathnameSeparator"
                               , "$PerformanceGoal"
                               , "$Post"
                               , "$Pre"
                               , "$PrePrint"
                               , "$PreRead"
                               , "$ProcessID"
                               , "$ProcessorCount"
                               , "$ProcessorType"
                               , "$RecursionLimit"
                               , "$ReleaseNumber"
                               , "$RootDirectory"
                               , "$ScheduledTask"
                               , "$ScriptCommandLine"
                               , "$SessionID"
                               , "$SharedFunctions"
                               , "$SharedVariables"
                               , "$SoundDisplayFunction"
                               , "$SyntaxHandler"
                               , "$System"
                               , "$SystemCharacterEncoding"
                               , "$SystemID"
                               , "$SystemWordLength"
                               , "$TemporaryDirectory"
                               , "$TimedOut"
                               , "$TimeUnit"
                               , "$TimeZone"
                               , "$Urgent"
                               , "$UserBaseDirectory"
                               , "$UserDocumentsDirectory"
                               , "$UserName"
                               , "$Version"
                               , "$VersionNumber"
                               , "A"
                               , "AbelianGroup"
                               , "Abort"
                               , "AbortKernels"
                               , "AbortProtect"
                               , "Abs"
                               , "AbsoluteCurrentValue"
                               , "AbsoluteDashing"
                               , "AbsoluteFileName"
                               , "AbsoluteOptions"
                               , "AbsolutePointSize"
                               , "AbsoluteThickness"
                               , "AbsoluteTime"
                               , "AbsoluteTiming"
                               , "AccountingForm"
                               , "Accumulate"
                               , "Accuracy"
                               , "AccuracyGoal"
                               , "ActionMenu"
                               , "ActiveStyle"
                               , "AcyclicGraphQ"
                               , "AddTo"
                               , "AdjacencyGraph"
                               , "AdjacencyMatrix"
                               , "AdjustmentBox"
                               , "AffineTransform"
                               , "AiryAi"
                               , "AiryAiPrime"
                               , "AiryAiZero"
                               , "AiryBi"
                               , "AiryBiPrime"
                               , "AiryBiZero"
                               , "AlgebraicIntegerQ"
                               , "AlgebraicNumber"
                               , "AlgebraicNumberDenominator"
                               , "AlgebraicNumberNorm"
                               , "AlgebraicNumberPolynomial"
                               , "AlgebraicNumberTrace"
                               , "Algebraics"
                               , "AlgebraicUnitQ"
                               , "Alignment"
                               , "AlignmentPoint"
                               , "All"
                               , "AllowGroupClose"
                               , "AllowReverseGroupClose"
                               , "AlphaChannel"
                               , "AlternatingGroup"
                               , "AlternativeHypothesis"
                               , "Alternatives"
                               , "AnchoredSearch"
                               , "And"
                               , "AndersonDarlingTest"
                               , "AngerJ"
                               , "AngleBracket"
                               , "Animate"
                               , "AnimationDirection"
                               , "AnimationDisplayTime"
                               , "AnimationRate"
                               , "AnimationRepetitions"
                               , "AnimationRunning"
                               , "Animator"
                               , "Annotation"
                               , "Annuity"
                               , "AnnuityDue"
                               , "Antialiasing"
                               , "Apart"
                               , "ApartSquareFree"
                               , "Appearance"
                               , "AppearanceElements"
                               , "AppellF1"
                               , "Append"
                               , "AppendTo"
                               , "Apply"
                               , "ArcCos"
                               , "ArcCosh"
                               , "ArcCot"
                               , "ArcCoth"
                               , "ArcCsc"
                               , "ArcCsch"
                               , "ArcSec"
                               , "ArcSech"
                               , "ArcSin"
                               , "ArcSinDistribution"
                               , "ArcSinh"
                               , "ArcTan"
                               , "ArcTanh"
                               , "Arg"
                               , "ArgMax"
                               , "ArgMin"
                               , "ArithmeticGeometricMean"
                               , "Array"
                               , "ArrayComponents"
                               , "ArrayDepth"
                               , "ArrayFlatten"
                               , "ArrayPad"
                               , "ArrayPlot"
                               , "ArrayQ"
                               , "ArrayRules"
                               , "Arrow"
                               , "Arrowheads"
                               , "AspectRatio"
                               , "Assert"
                               , "Assuming"
                               , "Assumptions"
                               , "AstronomicalData"
                               , "Asynchronous"
                               , "AtomQ"
                               , "Attributes"
                               , "AugmentedSymmetricPolynomial"
                               , "AutoAction"
                               , "AutoIndent"
                               , "AutoItalicWords"
                               , "Automatic"
                               , "AutoMultiplicationSymbol"
                               , "AutorunSequencing"
                               , "AutoScroll"
                               , "AutoSpacing"
                               , "Axes"
                               , "AxesEdge"
                               , "AxesLabel"
                               , "AxesOrigin"
                               , "AxesStyle"
                               , "Axis"
                               , "B"
                               , "BabyMonsterGroupB"
                               , "Back"
                               , "Background"
                               , "Backslash"
                               , "Backward"
                               , "Band"
                               , "BarabasiAlbertGraphDistribution"
                               , "BarChart"
                               , "BarChart3D"
                               , "BarnesG"
                               , "BarOrigin"
                               , "BarSpacing"
                               , "BaseForm"
                               , "Baseline"
                               , "BaselinePosition"
                               , "BaseStyle"
                               , "BatesDistribution"
                               , "BattleLemarieWavelet"
                               , "Because"
                               , "BeckmannDistribution"
                               , "Beep"
                               , "Begin"
                               , "BeginDialogPacket"
                               , "BeginPackage"
                               , "BellB"
                               , "BellY"
                               , "BenfordDistribution"
                               , "BeniniDistribution"
                               , "BenktanderGibratDistribution"
                               , "BenktanderWeibullDistribution"
                               , "BernoulliB"
                               , "BernoulliDistribution"
                               , "BernoulliGraphDistribution"
                               , "BernsteinBasis"
                               , "BesselI"
                               , "BesselJ"
                               , "BesselJZero"
                               , "BesselK"
                               , "BesselY"
                               , "BesselYZero"
                               , "Beta"
                               , "BetaBinomialDistribution"
                               , "BetaDistribution"
                               , "BetaNegativeBinomialDistribution"
                               , "BetaPrimeDistribution"
                               , "BetaRegularized"
                               , "BetweennessCentrality"
                               , "BezierCurve"
                               , "BezierFunction"
                               , "BilateralFilter"
                               , "Binarize"
                               , "BinaryFormat"
                               , "BinaryImageQ"
                               , "BinaryRead"
                               , "BinaryReadList"
                               , "BinaryWrite"
                               , "BinCounts"
                               , "BinLists"
                               , "Binomial"
                               , "BinomialDistribution"
                               , "BinormalDistribution"
                               , "BiorthogonalSplineWavelet"
                               , "BipartiteGraphQ"
                               , "BirnbaumSaundersDistribution"
                               , "BitAnd"
                               , "BitClear"
                               , "BitGet"
                               , "BitLength"
                               , "BitNot"
                               , "BitOr"
                               , "BitSet"
                               , "BitShiftLeft"
                               , "BitShiftRight"
                               , "BitXor"
                               , "Black"
                               , "Blank"
                               , "BlankNullSequence"
                               , "BlankSequence"
                               , "Blend"
                               , "Block"
                               , "BlockRandom"
                               , "Blue"
                               , "Blur"
                               , "BodePlot"
                               , "Bold"
                               , "Bookmarks"
                               , "Boole"
                               , "BooleanConvert"
                               , "BooleanCountingFunction"
                               , "BooleanFunction"
                               , "BooleanGraph"
                               , "BooleanMaxterms"
                               , "BooleanMinimize"
                               , "BooleanMinterms"
                               , "Booleans"
                               , "BooleanTable"
                               , "BooleanVariables"
                               , "BorderDimensions"
                               , "BorelTannerDistribution"
                               , "Bottom"
                               , "BottomHatTransform"
                               , "BoundaryStyle"
                               , "BoxData"
                               , "Boxed"
                               , "BoxMatrix"
                               , "BoxRatios"
                               , "BoxStyle"
                               , "BoxWhiskerChart"
                               , "BracketingBar"
                               , "BrayCurtisDistance"
                               , "BreadthFirstScan"
                               , "Break"
                               , "Brown"
                               , "BrownForsytheTest"
                               , "BSplineBasis"
                               , "BSplineCurve"
                               , "BSplineFunction"
                               , "BSplineSurface"
                               , "BubbleChart"
                               , "BubbleChart3D"
                               , "BubbleScale"
                               , "BubbleSizes"
                               , "ButterflyGraph"
                               , "Button"
                               , "ButtonBar"
                               , "ButtonBox"
                               , "ButtonData"
                               , "ButtonFrame"
                               , "ButtonFunction"
                               , "ButtonMinHeight"
                               , "ButtonNotebook"
                               , "ButtonSource"
                               , "Byte"
                               , "ByteCount"
                               , "ByteOrdering"
                               , "C"
                               , "CallPacket"
                               , "CanberraDistance"
                               , "Cancel"
                               , "CancelButton"
                               , "CandlestickChart"
                               , "Cap"
                               , "CapForm"
                               , "CapitalDifferentialD"
                               , "CarmichaelLambda"
                               , "Cases"
                               , "Cashflow"
                               , "Casoratian"
                               , "Catalan"
                               , "CatalanNumber"
                               , "Catch"
                               , "CauchyDistribution"
                               , "CayleyGraph"
                               , "CDF"
                               , "CDFWavelet"
                               , "Ceiling"
                               , "Cell"
                               , "CellAutoOverwrite"
                               , "CellBaseline"
                               , "CellChangeTimes"
                               , "CellContext"
                               , "CellDingbat"
                               , "CellDynamicExpression"
                               , "CellEditDuplicate"
                               , "CellEpilog"
                               , "CellEvaluationDuplicate"
                               , "CellEvaluationFunction"
                               , "CellEventActions"
                               , "CellFrame"
                               , "CellFrameMargins"
                               , "CellGroup"
                               , "CellGroupData"
                               , "CellGrouping"
                               , "CellLabel"
                               , "CellLabelAutoDelete"
                               , "CellMargins"
                               , "CellOpen"
                               , "CellPrint"
                               , "CellProlog"
                               , "CellTags"
                               , "CellularAutomaton"
                               , "CensoredDistribution"
                               , "Censoring"
                               , "Center"
                               , "CenterDot"
                               , "CentralMoment"
                               , "CentralMomentGeneratingFunction"
                               , "CForm"
                               , "ChampernowneNumber"
                               , "ChanVeseBinarize"
                               , "Character"
                               , "CharacterEncoding"
                               , "CharacteristicFunction"
                               , "CharacteristicPolynomial"
                               , "CharacterRange"
                               , "Characters"
                               , "ChartBaseStyle"
                               , "ChartElementFunction"
                               , "ChartElements"
                               , "ChartLabels"
                               , "ChartLayout"
                               , "ChartLegends"
                               , "ChartStyle"
                               , "ChebyshevT"
                               , "ChebyshevU"
                               , "Check"
                               , "CheckAbort"
                               , "Checkbox"
                               , "CheckboxBar"
                               , "ChemicalData"
                               , "ChessboardDistance"
                               , "ChiDistribution"
                               , "ChineseRemainder"
                               , "ChiSquareDistribution"
                               , "ChoiceButtons"
                               , "ChoiceDialog"
                               , "CholeskyDecomposition"
                               , "Chop"
                               , "Circle"
                               , "CircleDot"
                               , "CircleMinus"
                               , "CirclePlus"
                               , "CircleTimes"
                               , "CirculantGraph"
                               , "CityData"
                               , "Clear"
                               , "ClearAll"
                               , "ClearAttributes"
                               , "ClearSystemCache"
                               , "ClebschGordan"
                               , "ClickPane"
                               , "Clip"
                               , "ClippingStyle"
                               , "Clock"
                               , "Close"
                               , "CloseKernels"
                               , "ClosenessCentrality"
                               , "Closing"
                               , "ClusteringComponents"
                               , "CMYKColor"
                               , "Coefficient"
                               , "CoefficientArrays"
                               , "CoefficientList"
                               , "CoefficientRules"
                               , "CoifletWavelet"
                               , "Collect"
                               , "Colon"
                               , "ColorCombine"
                               , "ColorConvert"
                               , "ColorData"
                               , "ColorDataFunction"
                               , "ColorFunction"
                               , "ColorFunctionScaling"
                               , "Colorize"
                               , "ColorNegate"
                               , "ColorQuantize"
                               , "ColorRules"
                               , "ColorSeparate"
                               , "ColorSetter"
                               , "ColorSlider"
                               , "ColorSpace"
                               , "Column"
                               , "ColumnAlignments"
                               , "ColumnLines"
                               , "ColumnsEqual"
                               , "ColumnSpacings"
                               , "ColumnWidths"
                               , "Commonest"
                               , "CommonestFilter"
                               , "CompilationOptions"
                               , "CompilationTarget"
                               , "Compile"
                               , "Compiled"
                               , "CompiledFunction"
                               , "Complement"
                               , "CompleteGraph"
                               , "CompleteGraphQ"
                               , "CompleteKaryTree"
                               , "Complex"
                               , "Complexes"
                               , "ComplexExpand"
                               , "ComplexInfinity"
                               , "ComplexityFunction"
                               , "ComponentMeasurements"
                               , "ComposeList"
                               , "ComposeSeries"
                               , "Composition"
                               , "CompoundExpression"
                               , "Compress"
                               , "Condition"
                               , "ConditionalExpression"
                               , "Conditioned"
                               , "Cone"
                               , "ConfidenceLevel"
                               , "Congruent"
                               , "Conjugate"
                               , "ConjugateTranspose"
                               , "Conjunction"
                               , "ConnectedComponents"
                               , "ConnectedGraphQ"
                               , "ConoverTest"
                               , "Constant"
                               , "ConstantArray"
                               , "Constants"
                               , "ContentPadding"
                               , "ContentSelectable"
                               , "ContentSize"
                               , "Context"
                               , "Contexts"
                               , "ContextToFileName"
                               , "Continue"
                               , "ContinuedFraction"
                               , "ContinuedFractionK"
                               , "ContinuousAction"
                               , "ContinuousTimeModelQ"
                               , "ContinuousWaveletData"
                               , "ContinuousWaveletTransform"
                               , "ContourDetect"
                               , "ContourLabels"
                               , "ContourPlot"
                               , "ContourPlot3D"
                               , "Contours"
                               , "ContourShading"
                               , "ContourStyle"
                               , "ContraharmonicMean"
                               , "Control"
                               , "ControlActive"
                               , "ControllabilityGramian"
                               , "ControllabilityMatrix"
                               , "ControllableDecomposition"
                               , "ControllableModelQ"
                               , "ControllerInformation"
                               , "ControllerLinking"
                               , "ControllerManipulate"
                               , "ControllerMethod"
                               , "ControllerPath"
                               , "ControllerState"
                               , "ControlPlacement"
                               , "ControlsRendering"
                               , "ControlType"
                               , "Convergents"
                               , "ConversionRules"
                               , "Convolve"
                               , "ConwayGroupCo1"
                               , "ConwayGroupCo2"
                               , "ConwayGroupCo3"
                               , "CoordinatesToolOptions"
                               , "CoprimeQ"
                               , "Coproduct"
                               , "CopulaDistribution"
                               , "Copyable"
                               , "CopyDirectory"
                               , "CopyFile"
                               , "CopyToClipboard"
                               , "CornerFilter"
                               , "CornerNeighbors"
                               , "Correlation"
                               , "CorrelationDistance"
                               , "Cos"
                               , "Cosh"
                               , "CoshIntegral"
                               , "CosineDistance"
                               , "CosIntegral"
                               , "Cot"
                               , "Coth"
                               , "Count"
                               , "CountRoots"
                               , "CountryData"
                               , "Covariance"
                               , "CovarianceEstimatorFunction"
                               , "CramerVonMisesTest"
                               , "CreateArchive"
                               , "CreateDialog"
                               , "CreateDirectory"
                               , "CreateDocument"
                               , "CreateIntermediateDirectories"
                               , "CreatePalette"
                               , "CreateScheduledTask"
                               , "CreateWindow"
                               , "CriticalSection"
                               , "Cross"
                               , "CrossingDetect"
                               , "CrossMatrix"
                               , "Csc"
                               , "Csch"
                               , "Cubics"
                               , "Cuboid"
                               , "Cumulant"
                               , "CumulantGeneratingFunction"
                               , "Cup"
                               , "CupCap"
                               , "CurrentImage"
                               , "CurrentValue"
                               , "CurvatureFlowFilter"
                               , "CurveClosed"
                               , "Cyan"
                               , "CycleGraph"
                               , "Cycles"
                               , "CyclicGroup"
                               , "Cyclotomic"
                               , "Cylinder"
                               , "CylindricalDecomposition"
                               , "D"
                               , "DagumDistribution"
                               , "DamerauLevenshteinDistance"
                               , "Darker"
                               , "Dashed"
                               , "Dashing"
                               , "DataDistribution"
                               , "DataRange"
                               , "DataReversed"
                               , "DateDifference"
                               , "DateFunction"
                               , "DateList"
                               , "DateListLogPlot"
                               , "DateListPlot"
                               , "DatePattern"
                               , "DatePlus"
                               , "DateString"
                               , "DateTicksFormat"
                               , "DaubechiesWavelet"
                               , "DavisDistribution"
                               , "DawsonF"
                               , "DeBruijnGraph"
                               , "DeclarePackage"
                               , "Decompose"
                               , "Decrement"
                               , "DedekindEta"
                               , "Default"
                               , "DefaultAxesStyle"
                               , "DefaultBaseStyle"
                               , "DefaultBoxStyle"
                               , "DefaultButton"
                               , "DefaultDuplicateCellStyle"
                               , "DefaultDuration"
                               , "DefaultElement"
                               , "DefaultFaceGridsStyle"
                               , "DefaultFieldHintStyle"
                               , "DefaultFrameStyle"
                               , "DefaultFrameTicksStyle"
                               , "DefaultGridLinesStyle"
                               , "DefaultLabelStyle"
                               , "DefaultMenuStyle"
                               , "DefaultNewCellStyle"
                               , "DefaultOptions"
                               , "DefaultTicksStyle"
                               , "Defer"
                               , "Definition"
                               , "Degree"
                               , "DegreeCentrality"
                               , "DegreeGraphDistribution"
                               , "Deinitialization"
                               , "Del"
                               , "Deletable"
                               , "Delete"
                               , "DeleteBorderComponents"
                               , "DeleteCases"
                               , "DeleteContents"
                               , "DeleteDirectory"
                               , "DeleteDuplicates"
                               , "DeleteFile"
                               , "DeleteSmallComponents"
                               , "Delimiter"
                               , "DelimiterFlashTime"
                               , "Denominator"
                               , "DensityHistogram"
                               , "DensityPlot"
                               , "DependentVariables"
                               , "Deploy"
                               , "Deployed"
                               , "Depth"
                               , "DepthFirstScan"
                               , "Derivative"
                               , "DerivativeFilter"
                               , "DesignMatrix"
                               , "Det"
                               , "DGaussianWavelet"
                               , "Diagonal"
                               , "DiagonalMatrix"
                               , "Dialog"
                               , "DialogInput"
                               , "DialogNotebook"
                               , "DialogProlog"
                               , "DialogReturn"
                               , "DialogSymbols"
                               , "Diamond"
                               , "DiamondMatrix"
                               , "DiceDissimilarity"
                               , "DictionaryLookup"
                               , "DifferenceDelta"
                               , "DifferenceRoot"
                               , "DifferenceRootReduce"
                               , "Differences"
                               , "DifferentialD"
                               , "DifferentialRoot"
                               , "DifferentialRootReduce"
                               , "DigitBlock"
                               , "DigitCharacter"
                               , "DigitCount"
                               , "DigitQ"
                               , "DihedralGroup"
                               , "Dilation"
                               , "Dimensions"
                               , "DiracComb"
                               , "DiracDelta"
                               , "DirectedEdge"
                               , "DirectedEdges"
                               , "DirectedGraph"
                               , "DirectedGraphQ"
                               , "DirectedInfinity"
                               , "Direction"
                               , "Directive"
                               , "Directory"
                               , "DirectoryName"
                               , "DirectoryQ"
                               , "DirectoryStack"
                               , "DirichletCharacter"
                               , "DirichletConvolve"
                               , "DirichletDistribution"
                               , "DirichletL"
                               , "DirichletTransform"
                               , "DiscreteConvolve"
                               , "DiscreteDelta"
                               , "DiscreteIndicator"
                               , "DiscreteLQEstimatorGains"
                               , "DiscreteLQRegulatorGains"
                               , "DiscreteLyapunovSolve"
                               , "DiscretePlot"
                               , "DiscretePlot3D"
                               , "DiscreteRatio"
                               , "DiscreteRiccatiSolve"
                               , "DiscreteShift"
                               , "DiscreteTimeModelQ"
                               , "DiscreteUniformDistribution"
                               , "DiscreteWaveletData"
                               , "DiscreteWaveletPacketTransform"
                               , "DiscreteWaveletTransform"
                               , "Discriminant"
                               , "Disjunction"
                               , "Disk"
                               , "DiskMatrix"
                               , "Dispatch"
                               , "DispersionEstimatorFunction"
                               , "DisplayAllSteps"
                               , "DisplayEndPacket"
                               , "DisplayForm"
                               , "DisplayFunction"
                               , "DisplayPacket"
                               , "DistanceFunction"
                               , "DistanceTransform"
                               , "Distribute"
                               , "Distributed"
                               , "DistributedContexts"
                               , "DistributeDefinitions"
                               , "DistributionChart"
                               , "DistributionFitTest"
                               , "DistributionParameterAssumptions"
                               , "DistributionParameterQ"
                               , "Divide"
                               , "DivideBy"
                               , "Dividers"
                               , "Divisible"
                               , "Divisors"
                               , "DivisorSigma"
                               , "DivisorSum"
                               , "DMSList"
                               , "DMSString"
                               , "Do"
                               , "DockedCells"
                               , "DocumentNotebook"
                               , "Dot"
                               , "DotDashed"
                               , "DotEqual"
                               , "Dotted"
                               , "DoubleBracketingBar"
                               , "DoubleDownArrow"
                               , "DoubleLeftArrow"
                               , "DoubleLeftRightArrow"
                               , "DoubleLongLeftArrow"
                               , "DoubleLongLeftRightArrow"
                               , "DoubleLongRightArrow"
                               , "DoubleRightArrow"
                               , "DoubleUpArrow"
                               , "DoubleUpDownArrow"
                               , "DoubleVerticalBar"
                               , "DownArrow"
                               , "DownArrowBar"
                               , "DownArrowUpArrow"
                               , "DownLeftRightVector"
                               , "DownLeftTeeVector"
                               , "DownLeftVector"
                               , "DownLeftVectorBar"
                               , "DownRightTeeVector"
                               , "DownRightVector"
                               , "DownRightVectorBar"
                               , "DownTeeArrow"
                               , "DownValues"
                               , "DragAndDrop"
                               , "Drop"
                               , "DSolve"
                               , "Dt"
                               , "DualSystemsModel"
                               , "DumpSave"
                               , "Dynamic"
                               , "DynamicEvaluationTimeout"
                               , "DynamicModule"
                               , "DynamicModuleValues"
                               , "DynamicSetting"
                               , "DynamicWrapper"
                               , "E"
                               , "EdgeAdd"
                               , "EdgeCount"
                               , "EdgeCoverQ"
                               , "EdgeDelete"
                               , "EdgeDetect"
                               , "EdgeForm"
                               , "EdgeIndex"
                               , "EdgeLabeling"
                               , "EdgeLabels"
                               , "EdgeList"
                               , "EdgeQ"
                               , "EdgeRenderingFunction"
                               , "EdgeRules"
                               , "EdgeShapeFunction"
                               , "EdgeStyle"
                               , "EdgeWeight"
                               , "Editable"
                               , "EditDistance"
                               , "EffectiveInterest"
                               , "Eigensystem"
                               , "Eigenvalues"
                               , "EigenvectorCentrality"
                               , "Eigenvectors"
                               , "Element"
                               , "ElementData"
                               , "Eliminate"
                               , "EllipticE"
                               , "EllipticExp"
                               , "EllipticExpPrime"
                               , "EllipticF"
                               , "EllipticK"
                               , "EllipticLog"
                               , "EllipticNomeQ"
                               , "EllipticPi"
                               , "EllipticTheta"
                               , "EllipticThetaPrime"
                               , "EmitSound"
                               , "EmpiricalDistribution"
                               , "EmptyGraphQ"
                               , "Enabled"
                               , "Encode"
                               , "End"
                               , "EndDialogPacket"
                               , "EndOfFile"
                               , "EndOfLine"
                               , "EndOfString"
                               , "EndPackage"
                               , "EngineeringForm"
                               , "EnterExpressionPacket"
                               , "EnterTextPacket"
                               , "Entropy"
                               , "EntropyFilter"
                               , "Environment"
                               , "Epilog"
                               , "Equal"
                               , "EqualTilde"
                               , "Equilibrium"
                               , "Equivalent"
                               , "Erf"
                               , "Erfc"
                               , "Erfi"
                               , "ErlangDistribution"
                               , "Erosion"
                               , "ErrorBox"
                               , "EstimatedDistribution"
                               , "EstimatorGains"
                               , "EstimatorRegulator"
                               , "EuclideanDistance"
                               , "EulerE"
                               , "EulerGamma"
                               , "EulerianGraphQ"
                               , "EulerPhi"
                               , "Evaluatable"
                               , "Evaluate"
                               , "EvaluatePacket"
                               , "EvaluationElements"
                               , "EvaluationMonitor"
                               , "EvaluationNotebook"
                               , "EvaluationObject"
                               , "Evaluator"
                               , "EvenQ"
                               , "EventHandler"
                               , "EventLabels"
                               , "ExactNumberQ"
                               , "ExampleData"
                               , "Except"
                               , "ExcludedForms"
                               , "ExcludePods"
                               , "Exclusions"
                               , "ExclusionsStyle"
                               , "Exists"
                               , "Exit"
                               , "Exp"
                               , "Expand"
                               , "ExpandAll"
                               , "ExpandDenominator"
                               , "ExpandFileName"
                               , "ExpandNumerator"
                               , "Expectation"
                               , "ExpGammaDistribution"
                               , "ExpIntegralE"
                               , "ExpIntegralEi"
                               , "Exponent"
                               , "ExponentFunction"
                               , "ExponentialDistribution"
                               , "ExponentialFamily"
                               , "ExponentialGeneratingFunction"
                               , "ExponentialMovingAverage"
                               , "ExponentialPowerDistribution"
                               , "ExponentStep"
                               , "Export"
                               , "ExportString"
                               , "Expression"
                               , "ExpressionCell"
                               , "ExpToTrig"
                               , "ExtendedGCD"
                               , "Extension"
                               , "ExtentElementFunction"
                               , "ExtentMarkers"
                               , "ExtentSize"
                               , "Extract"
                               , "ExtractArchive"
                               , "ExtremeValueDistribution"
                               , "F"
                               , "FaceForm"
                               , "FaceGrids"
                               , "FaceGridsStyle"
                               , "Factor"
                               , "Factorial"
                               , "Factorial2"
                               , "FactorialMoment"
                               , "FactorialMomentGeneratingFunction"
                               , "FactorialPower"
                               , "FactorInteger"
                               , "FactorList"
                               , "FactorSquareFree"
                               , "FactorSquareFreeList"
                               , "FactorTerms"
                               , "FactorTermsList"
                               , "False"
                               , "FeedbackType"
                               , "Fibonacci"
                               , "FieldHint"
                               , "FieldHintStyle"
                               , "FieldMasked"
                               , "FieldSize"
                               , "FileBaseName"
                               , "FileByteCount"
                               , "FileDate"
                               , "FileExistsQ"
                               , "FileExtension"
                               , "FileFormat"
                               , "FileHash"
                               , "FileNameDepth"
                               , "FileNameDrop"
                               , "FileNameJoin"
                               , "FileNames"
                               , "FileNameSetter"
                               , "FileNameSplit"
                               , "FileNameTake"
                               , "FilePrint"
                               , "FileType"
                               , "FilledCurve"
                               , "Filling"
                               , "FillingStyle"
                               , "FillingTransform"
                               , "FilterRules"
                               , "FinancialBond"
                               , "FinancialData"
                               , "FinancialDerivative"
                               , "FinancialIndicator"
                               , "Find"
                               , "FindArgMax"
                               , "FindArgMin"
                               , "FindClique"
                               , "FindClusters"
                               , "FindCurvePath"
                               , "FindDistributionParameters"
                               , "FindDivisions"
                               , "FindEdgeCover"
                               , "FindEulerianCycle"
                               , "FindFile"
                               , "FindFit"
                               , "FindGeneratingFunction"
                               , "FindGeoLocation"
                               , "FindGeometricTransform"
                               , "FindGraphIsomorphism"
                               , "FindHamiltonianCycle"
                               , "FindIndependentEdgeSet"
                               , "FindIndependentVertexSet"
                               , "FindInstance"
                               , "FindIntegerNullVector"
                               , "FindLibrary"
                               , "FindLinearRecurrence"
                               , "FindList"
                               , "FindMaximum"
                               , "FindMaxValue"
                               , "FindMinimum"
                               , "FindMinValue"
                               , "FindPermutation"
                               , "FindRoot"
                               , "FindSequenceFunction"
                               , "FindShortestPath"
                               , "FindShortestTour"
                               , "FindThreshold"
                               , "FindVertexCover"
                               , "FinishDynamic"
                               , "FiniteAbelianGroupCount"
                               , "FiniteGroupCount"
                               , "FiniteGroupData"
                               , "First"
                               , "FischerGroupFi22"
                               , "FischerGroupFi23"
                               , "FischerGroupFi24Prime"
                               , "FisherHypergeometricDistribution"
                               , "FisherRatioTest"
                               , "FisherZDistribution"
                               , "Fit"
                               , "FittedModel"
                               , "FixedPoint"
                               , "FixedPointList"
                               , "Flat"
                               , "Flatten"
                               , "FlattenAt"
                               , "FlipView"
                               , "Floor"
                               , "Fold"
                               , "FoldList"
                               , "FontColor"
                               , "FontFamily"
                               , "FontSize"
                               , "FontSlant"
                               , "FontSubstitutions"
                               , "FontTracking"
                               , "FontVariations"
                               , "FontWeight"
                               , "For"
                               , "ForAll"
                               , "Format"
                               , "FormatType"
                               , "FormBox"
                               , "FortranForm"
                               , "Forward"
                               , "ForwardBackward"
                               , "Fourier"
                               , "FourierCoefficient"
                               , "FourierCosCoefficient"
                               , "FourierCosSeries"
                               , "FourierCosTransform"
                               , "FourierDCT"
                               , "FourierDST"
                               , "FourierParameters"
                               , "FourierSequenceTransform"
                               , "FourierSeries"
                               , "FourierSinCoefficient"
                               , "FourierSinSeries"
                               , "FourierSinTransform"
                               , "FourierTransform"
                               , "FourierTrigSeries"
                               , "FractionalPart"
                               , "FractionBox"
                               , "Frame"
                               , "FrameBox"
                               , "Framed"
                               , "FrameLabel"
                               , "FrameMargins"
                               , "FrameStyle"
                               , "FrameTicks"
                               , "FrameTicksStyle"
                               , "FRatioDistribution"
                               , "FrechetDistribution"
                               , "FreeQ"
                               , "FresnelC"
                               , "FresnelS"
                               , "FrobeniusNumber"
                               , "FrobeniusSolve"
                               , "FromCharacterCode"
                               , "FromCoefficientRules"
                               , "FromContinuedFraction"
                               , "FromDigits"
                               , "FromDMS"
                               , "Front"
                               , "FrontEndDynamicExpression"
                               , "FrontEndEventActions"
                               , "FrontEndExecute"
                               , "FrontEndToken"
                               , "FrontEndTokenExecute"
                               , "Full"
                               , "FullDefinition"
                               , "FullForm"
                               , "FullGraphics"
                               , "FullSimplify"
                               , "Function"
                               , "FunctionExpand"
                               , "FunctionInterpolation"
                               , "FunctionSpace"
                               , "G"
                               , "GaborWavelet"
                               , "GainMargins"
                               , "GainPhaseMargins"
                               , "Gamma"
                               , "GammaDistribution"
                               , "GammaRegularized"
                               , "GapPenalty"
                               , "Gather"
                               , "GatherBy"
                               , "GaussianFilter"
                               , "GaussianIntegers"
                               , "GaussianMatrix"
                               , "GCD"
                               , "GegenbauerC"
                               , "General"
                               , "GeneralizedLinearModelFit"
                               , "GenerateConditions"
                               , "GeneratedCell"
                               , "GeneratedParameters"
                               , "GeneratingFunction"
                               , "GenericCylindricalDecomposition"
                               , "GenomeData"
                               , "GenomeLookup"
                               , "GeodesicDilation"
                               , "GeodesicErosion"
                               , "GeoDestination"
                               , "GeodesyData"
                               , "GeoDirection"
                               , "GeoDistance"
                               , "GeoGridPosition"
                               , "GeometricDistribution"
                               , "GeometricMean"
                               , "GeometricMeanFilter"
                               , "GeometricTransformation"
                               , "GeoPosition"
                               , "GeoPositionENU"
                               , "GeoPositionXYZ"
                               , "GeoProjectionData"
                               , "Get"
                               , "Glaisher"
                               , "Glow"
                               , "GoldenRatio"
                               , "GompertzMakehamDistribution"
                               , "Goto"
                               , "Gradient"
                               , "GradientFilter"
                               , "Graph"
                               , "GraphCenter"
                               , "GraphComplement"
                               , "GraphData"
                               , "GraphDiameter"
                               , "GraphDifference"
                               , "GraphDisjointUnion"
                               , "GraphDistance"
                               , "GraphDistanceMatrix"
                               , "GraphHighlight"
                               , "GraphHighlightStyle"
                               , "Graphics"
                               , "Graphics3D"
                               , "GraphicsColumn"
                               , "GraphicsComplex"
                               , "GraphicsGrid"
                               , "GraphicsGroup"
                               , "GraphicsRow"
                               , "GraphIntersection"
                               , "GraphLayout"
                               , "GraphPeriphery"
                               , "GraphPlot"
                               , "GraphPlot3D"
                               , "GraphPower"
                               , "GraphQ"
                               , "GraphRadius"
                               , "GraphStyle"
                               , "GraphUnion"
                               , "Gray"
                               , "GrayLevel"
                               , "Greater"
                               , "GreaterEqual"
                               , "GreaterEqualLess"
                               , "GreaterFullEqual"
                               , "GreaterGreater"
                               , "GreaterLess"
                               , "GreaterSlantEqual"
                               , "GreaterTilde"
                               , "Green"
                               , "Grid"
                               , "GridBox"
                               , "GridDefaultElement"
                               , "GridGraph"
                               , "GridLines"
                               , "GridLinesStyle"
                               , "GroebnerBasis"
                               , "GroupActionBase"
                               , "GroupCentralizer"
                               , "GroupElementPosition"
                               , "GroupElementQ"
                               , "GroupElements"
                               , "GroupGenerators"
                               , "GroupMultiplicationTable"
                               , "GroupOrbits"
                               , "GroupOrder"
                               , "GroupPageBreakWithin"
                               , "GroupSetwiseStabilizer"
                               , "GroupStabilizer"
                               , "GroupStabilizerChain"
                               , "Gudermannian"
                               , "GumbelDistribution"
                               , "H"
                               , "HaarWavelet"
                               , "HalfNormalDistribution"
                               , "HamiltonianGraphQ"
                               , "HammingDistance"
                               , "HankelH1"
                               , "HankelH2"
                               , "HankelMatrix"
                               , "HaradaNortonGroupHN"
                               , "HararyGraph"
                               , "HarmonicMean"
                               , "HarmonicMeanFilter"
                               , "HarmonicNumber"
                               , "Hash"
                               , "Haversine"
                               , "HazardFunction"
                               , "Head"
                               , "Heads"
                               , "HeavisideLambda"
                               , "HeavisidePi"
                               , "HeavisideTheta"
                               , "HeldGroupHe"
                               , "HermiteDecomposition"
                               , "HermiteH"
                               , "HermitianMatrixQ"
                               , "HessenbergDecomposition"
                               , "HexadecimalCharacter"
                               , "HighlightGraph"
                               , "HigmanSimsGroupHS"
                               , "HilbertMatrix"
                               , "Histogram"
                               , "Histogram3D"
                               , "HistogramDistribution"
                               , "HistogramList"
                               , "HitMissTransform"
                               , "HITSCentrality"
                               , "Hold"
                               , "HoldAll"
                               , "HoldAllComplete"
                               , "HoldComplete"
                               , "HoldFirst"
                               , "HoldForm"
                               , "HoldPattern"
                               , "HoldRest"
                               , "HornerForm"
                               , "HotellingTSquareDistribution"
                               , "HoytDistribution"
                               , "Hue"
                               , "HumpDownHump"
                               , "HumpEqual"
                               , "HurwitzLerchPhi"
                               , "HurwitzZeta"
                               , "HyperbolicDistribution"
                               , "HypercubeGraph"
                               , "Hyperfactorial"
                               , "Hypergeometric0F1"
                               , "Hypergeometric0F1Regularized"
                               , "Hypergeometric1F1"
                               , "Hypergeometric1F1Regularized"
                               , "Hypergeometric2F1"
                               , "Hypergeometric2F1Regularized"
                               , "HypergeometricDistribution"
                               , "HypergeometricPFQ"
                               , "HypergeometricPFQRegularized"
                               , "HypergeometricU"
                               , "Hyperlink"
                               , "Hyphenation"
                               , "HypothesisTestData"
                               , "I"
                               , "Identity"
                               , "IdentityMatrix"
                               , "If"
                               , "IgnoreCase"
                               , "Im"
                               , "Image"
                               , "ImageAdd"
                               , "ImageAdjust"
                               , "ImageAlign"
                               , "ImageApply"
                               , "ImageAspectRatio"
                               , "ImageAssemble"
                               , "ImageCapture"
                               , "ImageChannels"
                               , "ImageClip"
                               , "ImageColorSpace"
                               , "ImageCompose"
                               , "ImageConvolve"
                               , "ImageCooccurrence"
                               , "ImageCorrelate"
                               , "ImageCorrespondingPoints"
                               , "ImageCrop"
                               , "ImageData"
                               , "ImageDeconvolve"
                               , "ImageDifference"
                               , "ImageDimensions"
                               , "ImageEffect"
                               , "ImageFilter"
                               , "ImageForestingComponents"
                               , "ImageForwardTransformation"
                               , "ImageHistogram"
                               , "ImageKeypoints"
                               , "ImageLevels"
                               , "ImageLines"
                               , "ImageMargins"
                               , "ImageMultiply"
                               , "ImagePad"
                               , "ImagePadding"
                               , "ImagePartition"
                               , "ImagePerspectiveTransformation"
                               , "ImageQ"
                               , "ImageReflect"
                               , "ImageResize"
                               , "ImageResolution"
                               , "ImageRotate"
                               , "ImageScaled"
                               , "ImageSize"
                               , "ImageSizeAction"
                               , "ImageSizeMultipliers"
                               , "ImageSubtract"
                               , "ImageTake"
                               , "ImageTransformation"
                               , "ImageTrim"
                               , "ImageType"
                               , "ImageValue"
                               , "Implies"
                               , "Import"
                               , "ImportString"
                               , "In"
                               , "IncidenceGraph"
                               , "IncidenceMatrix"
                               , "IncludeConstantBasis"
                               , "IncludePods"
                               , "Increment"
                               , "IndependentEdgeSetQ"
                               , "IndependentVertexSetQ"
                               , "Indeterminate"
                               , "IndexGraph"
                               , "InexactNumberQ"
                               , "Infinity"
                               , "Infix"
                               , "Information"
                               , "Inherited"
                               , "Initialization"
                               , "InitializationCell"
                               , "Inner"
                               , "Inpaint"
                               , "Input"
                               , "InputAliases"
                               , "InputAssumptions"
                               , "InputAutoReplacements"
                               , "InputField"
                               , "InputForm"
                               , "InputNamePacket"
                               , "InputNotebook"
                               , "InputPacket"
                               , "InputStream"
                               , "InputString"
                               , "InputStringPacket"
                               , "Insert"
                               , "InsertResults"
                               , "Inset"
                               , "Install"
                               , "InstallService"
                               , "InString"
                               , "Integer"
                               , "IntegerDigits"
                               , "IntegerExponent"
                               , "IntegerLength"
                               , "IntegerPart"
                               , "IntegerPartitions"
                               , "IntegerQ"
                               , "Integers"
                               , "IntegerString"
                               , "Integrate"
                               , "InteractiveTradingChart"
                               , "Interleaving"
                               , "InternallyBalancedDecomposition"
                               , "InterpolatingFunction"
                               , "InterpolatingPolynomial"
                               , "Interpolation"
                               , "InterpolationOrder"
                               , "Interpretation"
                               , "InterpretationBox"
                               , "InterquartileRange"
                               , "Interrupt"
                               , "Intersection"
                               , "Interval"
                               , "IntervalIntersection"
                               , "IntervalMemberQ"
                               , "IntervalUnion"
                               , "Inverse"
                               , "InverseBetaRegularized"
                               , "InverseCDF"
                               , "InverseChiSquareDistribution"
                               , "InverseContinuousWaveletTransform"
                               , "InverseDistanceTransform"
                               , "InverseEllipticNomeQ"
                               , "InverseErf"
                               , "InverseErfc"
                               , "InverseFourier"
                               , "InverseFourierCosTransform"
                               , "InverseFourierSequenceTransform"
                               , "InverseFourierSinTransform"
                               , "InverseFourierTransform"
                               , "InverseFunction"
                               , "InverseFunctions"
                               , "InverseGammaDistribution"
                               , "InverseGammaRegularized"
                               , "InverseGaussianDistribution"
                               , "InverseGudermannian"
                               , "InverseHaversine"
                               , "InverseJacobiCD"
                               , "InverseJacobiCN"
                               , "InverseJacobiCS"
                               , "InverseJacobiDC"
                               , "InverseJacobiDN"
                               , "InverseJacobiDS"
                               , "InverseJacobiNC"
                               , "InverseJacobiND"
                               , "InverseJacobiNS"
                               , "InverseJacobiSC"
                               , "InverseJacobiSD"
                               , "InverseJacobiSN"
                               , "InverseLaplaceTransform"
                               , "InversePermutation"
                               , "InverseRadon"
                               , "InverseSeries"
                               , "InverseSurvivalFunction"
                               , "InverseWaveletTransform"
                               , "InverseWeierstrassP"
                               , "InverseZTransform"
                               , "Invisible"
                               , "IrreduciblePolynomialQ"
                               , "IsolatingInterval"
                               , "IsomorphicGraphQ"
                               , "IsotopeData"
                               , "Italic"
                               , "Item"
                               , "ItemAspectRatio"
                               , "ItemSize"
                               , "ItemStyle"
                               , "J"
                               , "JaccardDissimilarity"
                               , "JacobiAmplitude"
                               , "JacobiCD"
                               , "JacobiCN"
                               , "JacobiCS"
                               , "JacobiDC"
                               , "JacobiDN"
                               , "JacobiDS"
                               , "JacobiNC"
                               , "JacobiND"
                               , "JacobiNS"
                               , "JacobiP"
                               , "JacobiSC"
                               , "JacobiSD"
                               , "JacobiSN"
                               , "JacobiSymbol"
                               , "JacobiZeta"
                               , "JankoGroupJ1"
                               , "JankoGroupJ2"
                               , "JankoGroupJ3"
                               , "JankoGroupJ4"
                               , "JarqueBeraALMTest"
                               , "JohnsonDistribution"
                               , "Join"
                               , "Joined"
                               , "JoinedCurve"
                               , "JoinForm"
                               , "JordanDecomposition"
                               , "JordanModelDecomposition"
                               , "K"
                               , "KagiChart"
                               , "KalmanEstimator"
                               , "KarhunenLoeveDecomposition"
                               , "KaryTree"
                               , "KatzCentrality"
                               , "KCoreComponents"
                               , "KDistribution"
                               , "KelvinBei"
                               , "KelvinBer"
                               , "KelvinKei"
                               , "KelvinKer"
                               , "KernelMixtureDistribution"
                               , "KernelObject"
                               , "Kernels"
                               , "Khinchin"
                               , "KirchhoffGraph"
                               , "KirchhoffMatrix"
                               , "KleinInvariantJ"
                               , "KnightTourGraph"
                               , "KnotData"
                               , "KolmogorovSmirnovTest"
                               , "KroneckerDelta"
                               , "KroneckerProduct"
                               , "KroneckerSymbol"
                               , "KuiperTest"
                               , "KumaraswamyDistribution"
                               , "Kurtosis"
                               , "KuwaharaFilter"
                               , "L"
                               , "Label"
                               , "Labeled"
                               , "LabelingFunction"
                               , "LabelStyle"
                               , "LaguerreL"
                               , "LandauDistribution"
                               , "LanguageCategory"
                               , "LaplaceDistribution"
                               , "LaplaceTransform"
                               , "LaplacianFilter"
                               , "LaplacianGaussianFilter"
                               , "Large"
                               , "Larger"
                               , "Last"
                               , "Latitude"
                               , "LatitudeLongitude"
                               , "LatticeData"
                               , "LatticeReduce"
                               , "LaunchKernels"
                               , "LayeredGraphPlot"
                               , "LayerSizeFunction"
                               , "LCM"
                               , "LeafCount"
                               , "LeastSquares"
                               , "Left"
                               , "LeftArrow"
                               , "LeftArrowBar"
                               , "LeftArrowRightArrow"
                               , "LeftDownTeeVector"
                               , "LeftDownVector"
                               , "LeftDownVectorBar"
                               , "LeftRightArrow"
                               , "LeftRightVector"
                               , "LeftTeeArrow"
                               , "LeftTeeVector"
                               , "LeftTriangle"
                               , "LeftTriangleBar"
                               , "LeftTriangleEqual"
                               , "LeftUpDownVector"
                               , "LeftUpTeeVector"
                               , "LeftUpVector"
                               , "LeftUpVectorBar"
                               , "LeftVector"
                               , "LeftVectorBar"
                               , "LegendAppearance"
                               , "Legended"
                               , "LegendreP"
                               , "LegendreQ"
                               , "Length"
                               , "LengthWhile"
                               , "LerchPhi"
                               , "Less"
                               , "LessEqual"
                               , "LessEqualGreater"
                               , "LessFullEqual"
                               , "LessGreater"
                               , "LessLess"
                               , "LessSlantEqual"
                               , "LessTilde"
                               , "LetterCharacter"
                               , "LetterQ"
                               , "Level"
                               , "LeveneTest"
                               , "LeviCivitaTensor"
                               , "LevyDistribution"
                               , "LibraryFunction"
                               , "LibraryFunctionError"
                               , "LibraryFunctionInformation"
                               , "LibraryFunctionLoad"
                               , "LibraryFunctionUnload"
                               , "LibraryLoad"
                               , "LibraryUnload"
                               , "LiftingFilterData"
                               , "LiftingWaveletTransform"
                               , "LightBlue"
                               , "LightBrown"
                               , "LightCyan"
                               , "Lighter"
                               , "LightGray"
                               , "LightGreen"
                               , "Lighting"
                               , "LightingAngle"
                               , "LightMagenta"
                               , "LightOrange"
                               , "LightPink"
                               , "LightPurple"
                               , "LightRed"
                               , "LightYellow"
                               , "Likelihood"
                               , "Limit"
                               , "LimitsPositioning"
                               , "LindleyDistribution"
                               , "Line"
                               , "LinearFractionalTransform"
                               , "LinearModelFit"
                               , "LinearOffsetFunction"
                               , "LinearProgramming"
                               , "LinearRecurrence"
                               , "LinearSolve"
                               , "LinearSolveFunction"
                               , "LineBreakChart"
                               , "LineGraph"
                               , "LineIndent"
                               , "LineIndentMaxFraction"
                               , "LineIntegralConvolutionPlot"
                               , "LineIntegralConvolutionScale"
                               , "LineSpacing"
                               , "LinkClose"
                               , "LinkConnect"
                               , "LinkCreate"
                               , "LinkFunction"
                               , "LinkInterrupt"
                               , "LinkLaunch"
                               , "LinkObject"
                               , "LinkPatterns"
                               , "LinkProtocol"
                               , "LinkRead"
                               , "LinkReadyQ"
                               , "Links"
                               , "LinkWrite"
                               , "LiouvilleLambda"
                               , "List"
                               , "Listable"
                               , "ListAnimate"
                               , "ListContourPlot"
                               , "ListContourPlot3D"
                               , "ListConvolve"
                               , "ListCorrelate"
                               , "ListCurvePathPlot"
                               , "ListDeconvolve"
                               , "ListDensityPlot"
                               , "ListInterpolation"
                               , "ListLineIntegralConvolutionPlot"
                               , "ListLinePlot"
                               , "ListLogLinearPlot"
                               , "ListLogLogPlot"
                               , "ListLogPlot"
                               , "ListPlay"
                               , "ListPlot"
                               , "ListPlot3D"
                               , "ListPointPlot3D"
                               , "ListPolarPlot"
                               , "ListStreamDensityPlot"
                               , "ListStreamPlot"
                               , "ListSurfacePlot3D"
                               , "ListVectorDensityPlot"
                               , "ListVectorPlot"
                               , "ListVectorPlot3D"
                               , "LocalizeVariables"
                               , "LocationEquivalenceTest"
                               , "LocationTest"
                               , "Locator"
                               , "LocatorAutoCreate"
                               , "LocatorPane"
                               , "LocatorRegion"
                               , "Locked"
                               , "Log"
                               , "Log10"
                               , "Log2"
                               , "LogBarnesG"
                               , "LogGamma"
                               , "LogGammaDistribution"
                               , "LogicalExpand"
                               , "LogIntegral"
                               , "LogisticDistribution"
                               , "LogitModelFit"
                               , "LogLikelihood"
                               , "LogLinearPlot"
                               , "LogLogisticDistribution"
                               , "LogLogPlot"
                               , "LogNormalDistribution"
                               , "LogPlot"
                               , "LogSeriesDistribution"
                               , "Longest"
                               , "LongestCommonSequence"
                               , "LongestCommonSubsequence"
                               , "Longitude"
                               , "LongLeftArrow"
                               , "LongLeftRightArrow"
                               , "LongRightArrow"
                               , "LoopFreeGraphQ"
                               , "LowerCaseQ"
                               , "LowerLeftArrow"
                               , "LowerRightArrow"
                               , "LowerTriangularize"
                               , "LQEstimatorGains"
                               , "LQGRegulator"
                               , "LQOutputRegulatorGains"
                               , "LQRegulatorGains"
                               , "LucasL"
                               , "LUDecomposition"
                               , "LyapunovSolve"
                               , "LyonsGroupLy"
                               , "M"
                               , "MachineNumberQ"
                               , "MachinePrecision"
                               , "Magenta"
                               , "Magnification"
                               , "Magnify"
                               , "Majority"
                               , "MakeBoxes"
                               , "MakeExpression"
                               , "MangoldtLambda"
                               , "ManhattanDistance"
                               , "Manipulate"
                               , "Manipulator"
                               , "MannWhitneyTest"
                               , "MantissaExponent"
                               , "Manual"
                               , "Map"
                               , "MapAll"
                               , "MapAt"
                               , "MapIndexed"
                               , "MapThread"
                               , "MarcumQ"
                               , "MardiaCombinedTest"
                               , "MardiaKurtosisTest"
                               , "MardiaSkewnessTest"
                               , "MarginalDistribution"
                               , "Masking"
                               , "MatchingDissimilarity"
                               , "MatchLocalNames"
                               , "MatchQ"
                               , "MathieuC"
                               , "MathieuCharacteristicA"
                               , "MathieuCharacteristicB"
                               , "MathieuCharacteristicExponent"
                               , "MathieuCPrime"
                               , "MathieuGroupM11"
                               , "MathieuGroupM12"
                               , "MathieuGroupM22"
                               , "MathieuGroupM23"
                               , "MathieuGroupM24"
                               , "MathieuS"
                               , "MathieuSPrime"
                               , "MathMLForm"
                               , "MatrixExp"
                               , "MatrixForm"
                               , "MatrixPlot"
                               , "MatrixPower"
                               , "MatrixQ"
                               , "MatrixRank"
                               , "Max"
                               , "MaxDetect"
                               , "MaxExtraBandwidths"
                               , "MaxExtraConditions"
                               , "MaxFilter"
                               , "Maximize"
                               , "MaxIterations"
                               , "MaxMemoryUsed"
                               , "MaxMixtureKernels"
                               , "MaxPlotPoints"
                               , "MaxRecursion"
                               , "MaxStableDistribution"
                               , "MaxStepFraction"
                               , "MaxSteps"
                               , "MaxStepSize"
                               , "MaxValue"
                               , "MaxwellDistribution"
                               , "McLaughlinGroupMcL"
                               , "Mean"
                               , "MeanDeviation"
                               , "MeanFilter"
                               , "MeanShift"
                               , "MeanShiftFilter"
                               , "Median"
                               , "MedianDeviation"
                               , "MedianFilter"
                               , "Medium"
                               , "MeijerG"
                               , "MemberQ"
                               , "MemoryConstrained"
                               , "MemoryInUse"
                               , "MenuCommandKey"
                               , "MenuPacket"
                               , "MenuSortingValue"
                               , "MenuStyle"
                               , "MenuView"
                               , "Mesh"
                               , "MeshFunctions"
                               , "MeshShading"
                               , "MeshStyle"
                               , "Message"
                               , "MessageDialog"
                               , "MessageList"
                               , "MessageName"
                               , "MessagePacket"
                               , "Messages"
                               , "Method"
                               , "MexicanHatWavelet"
                               , "MeyerWavelet"
                               , "Min"
                               , "MinDetect"
                               , "MinFilter"
                               , "MinimalPolynomial"
                               , "MinimalStateSpaceModel"
                               , "Minimize"
                               , "Minors"
                               , "MinStableDistribution"
                               , "Minus"
                               , "MinusPlus"
                               , "MinValue"
                               , "Missing"
                               , "MixtureDistribution"
                               , "Mod"
                               , "Modal"
                               , "ModularLambda"
                               , "Module"
                               , "Modulus"
                               , "MoebiusMu"
                               , "Moment"
                               , "MomentConvert"
                               , "MomentEvaluate"
                               , "MomentGeneratingFunction"
                               , "Monitor"
                               , "MonomialList"
                               , "MonsterGroupM"
                               , "MorletWavelet"
                               , "MorphologicalBinarize"
                               , "MorphologicalBranchPoints"
                               , "MorphologicalComponents"
                               , "MorphologicalEulerNumber"
                               , "MorphologicalGraph"
                               , "MorphologicalPerimeter"
                               , "MorphologicalTransform"
                               , "Most"
                               , "MouseAnnotation"
                               , "MouseAppearance"
                               , "Mouseover"
                               , "MousePosition"
                               , "MovingAverage"
                               , "MovingMedian"
                               , "MoyalDistribution"
                               , "MultiedgeStyle"
                               , "Multinomial"
                               , "MultinomialDistribution"
                               , "MultinormalDistribution"
                               , "MultiplicativeOrder"
                               , "MultivariateHypergeometricDistribution"
                               , "MultivariatePoissonDistribution"
                               , "MultivariateTDistribution"
                               , "N"
                               , "NakagamiDistribution"
                               , "NameQ"
                               , "Names"
                               , "Nand"
                               , "NArgMax"
                               , "NArgMin"
                               , "NCache"
                               , "NDSolve"
                               , "Nearest"
                               , "NearestFunction"
                               , "NeedlemanWunschSimilarity"
                               , "Needs"
                               , "Negative"
                               , "NegativeBinomialDistribution"
                               , "NegativeMultinomialDistribution"
                               , "NeighborhoodGraph"
                               , "Nest"
                               , "NestedGreaterGreater"
                               , "NestedLessLess"
                               , "NestList"
                               , "NestWhile"
                               , "NestWhileList"
                               , "NevilleThetaC"
                               , "NevilleThetaD"
                               , "NevilleThetaN"
                               , "NevilleThetaS"
                               , "NExpectation"
                               , "NextPrime"
                               , "NHoldAll"
                               , "NHoldFirst"
                               , "NHoldRest"
                               , "NicholsGridLines"
                               , "NicholsPlot"
                               , "NIntegrate"
                               , "NMaximize"
                               , "NMaxValue"
                               , "NMinimize"
                               , "NMinValue"
                               , "NominalVariables"
                               , "NoncentralBetaDistribution"
                               , "NoncentralChiSquareDistribution"
                               , "NoncentralFRatioDistribution"
                               , "NoncentralStudentTDistribution"
                               , "NonCommutativeMultiply"
                               , "NonConstants"
                               , "None"
                               , "NonlinearModelFit"
                               , "NonNegative"
                               , "NonPositive"
                               , "Nor"
                               , "NorlundB"
                               , "Norm"
                               , "Normal"
                               , "NormalDistribution"
                               , "Normalize"
                               , "NormalizedSquaredEuclideanDistance"
                               , "NormalsFunction"
                               , "NormFunction"
                               , "Not"
                               , "NotCongruent"
                               , "NotCupCap"
                               , "NotDoubleVerticalBar"
                               , "Notebook"
                               , "NotebookApply"
                               , "NotebookAutoSave"
                               , "NotebookClose"
                               , "NotebookDelete"
                               , "NotebookDirectory"
                               , "NotebookDynamicExpression"
                               , "NotebookEvaluate"
                               , "NotebookEventActions"
                               , "NotebookFileName"
                               , "NotebookFind"
                               , "NotebookGet"
                               , "NotebookInformation"
                               , "NotebookLocate"
                               , "NotebookObject"
                               , "NotebookOpen"
                               , "NotebookPrint"
                               , "NotebookPut"
                               , "NotebookRead"
                               , "Notebooks"
                               , "NotebookSave"
                               , "NotebookSelection"
                               , "NotebookWrite"
                               , "NotElement"
                               , "NotEqualTilde"
                               , "NotExists"
                               , "NotGreater"
                               , "NotGreaterEqual"
                               , "NotGreaterFullEqual"
                               , "NotGreaterGreater"
                               , "NotGreaterLess"
                               , "NotGreaterSlantEqual"
                               , "NotGreaterTilde"
                               , "NotHumpDownHump"
                               , "NotHumpEqual"
                               , "NotLeftTriangle"
                               , "NotLeftTriangleBar"
                               , "NotLeftTriangleEqual"
                               , "NotLess"
                               , "NotLessEqual"
                               , "NotLessFullEqual"
                               , "NotLessGreater"
                               , "NotLessLess"
                               , "NotLessSlantEqual"
                               , "NotLessTilde"
                               , "NotNestedGreaterGreater"
                               , "NotNestedLessLess"
                               , "NotPrecedes"
                               , "NotPrecedesEqual"
                               , "NotPrecedesSlantEqual"
                               , "NotPrecedesTilde"
                               , "NotReverseElement"
                               , "NotRightTriangle"
                               , "NotRightTriangleBar"
                               , "NotRightTriangleEqual"
                               , "NotSquareSubset"
                               , "NotSquareSubsetEqual"
                               , "NotSquareSuperset"
                               , "NotSquareSupersetEqual"
                               , "NotSubset"
                               , "NotSubsetEqual"
                               , "NotSucceeds"
                               , "NotSucceedsEqual"
                               , "NotSucceedsSlantEqual"
                               , "NotSucceedsTilde"
                               , "NotSuperset"
                               , "NotSupersetEqual"
                               , "NotTilde"
                               , "NotTildeEqual"
                               , "NotTildeFullEqual"
                               , "NotTildeTilde"
                               , "NotVerticalBar"
                               , "NProbability"
                               , "NProduct"
                               , "NRoots"
                               , "NSolve"
                               , "NSum"
                               , "Null"
                               , "NullRecords"
                               , "NullSpace"
                               , "NullWords"
                               , "Number"
                               , "NumberFieldClassNumber"
                               , "NumberFieldDiscriminant"
                               , "NumberFieldFundamentalUnits"
                               , "NumberFieldIntegralBasis"
                               , "NumberFieldNormRepresentatives"
                               , "NumberFieldRegulator"
                               , "NumberFieldRootsOfUnity"
                               , "NumberFieldSignature"
                               , "NumberForm"
                               , "NumberFormat"
                               , "NumberMarks"
                               , "NumberMultiplier"
                               , "NumberPadding"
                               , "NumberPoint"
                               , "NumberQ"
                               , "NumberSeparator"
                               , "NumberSigns"
                               , "NumberString"
                               , "Numerator"
                               , "NumericFunction"
                               , "NumericQ"
                               , "NyquistGridLines"
                               , "NyquistPlot"
                               , "O"
                               , "ObservabilityGramian"
                               , "ObservabilityMatrix"
                               , "ObservableDecomposition"
                               , "ObservableModelQ"
                               , "OddQ"
                               , "Off"
                               , "Offset"
                               , "On"
                               , "ONanGroupON"
                               , "OneIdentity"
                               , "Opacity"
                               , "OpenAppend"
                               , "Opener"
                               , "OpenerView"
                               , "Opening"
                               , "OpenRead"
                               , "OpenWrite"
                               , "Operate"
                               , "OperatingSystem"
                               , "Optional"
                               , "Options"
                               , "OptionsPattern"
                               , "OptionValue"
                               , "Or"
                               , "Orange"
                               , "Order"
                               , "OrderDistribution"
                               , "OrderedQ"
                               , "Ordering"
                               , "Orderless"
                               , "Orthogonalize"
                               , "Out"
                               , "Outer"
                               , "OutputControllabilityMatrix"
                               , "OutputControllableModelQ"
                               , "OutputForm"
                               , "OutputNamePacket"
                               , "OutputResponse"
                               , "OutputSizeLimit"
                               , "OutputStream"
                               , "OverBar"
                               , "OverDot"
                               , "Overflow"
                               , "OverHat"
                               , "Overlaps"
                               , "Overlay"
                               , "Overscript"
                               , "OverscriptBox"
                               , "OverTilde"
                               , "OverVector"
                               , "OwenT"
                               , "OwnValues"
                               , "P"
                               , "PackingMethod"
                               , "PaddedForm"
                               , "Padding"
                               , "PadeApproximant"
                               , "PadLeft"
                               , "PadRight"
                               , "PageBreakAbove"
                               , "PageBreakBelow"
                               , "PageBreakWithin"
                               , "PageFooters"
                               , "PageHeaders"
                               , "PageRankCentrality"
                               , "PageWidth"
                               , "PairedBarChart"
                               , "PairedHistogram"
                               , "PairedTTest"
                               , "PairedZTest"
                               , "PaletteNotebook"
                               , "Pane"
                               , "Panel"
                               , "Paneled"
                               , "PaneSelector"
                               , "ParabolicCylinderD"
                               , "ParagraphIndent"
                               , "ParagraphSpacing"
                               , "ParallelArray"
                               , "ParallelCombine"
                               , "ParallelDo"
                               , "ParallelEvaluate"
                               , "Parallelization"
                               , "Parallelize"
                               , "ParallelMap"
                               , "ParallelNeeds"
                               , "ParallelProduct"
                               , "ParallelSubmit"
                               , "ParallelSum"
                               , "ParallelTable"
                               , "ParallelTry"
                               , "ParameterEstimator"
                               , "ParameterMixtureDistribution"
                               , "ParametricPlot"
                               , "ParametricPlot3D"
                               , "ParentDirectory"
                               , "ParetoDistribution"
                               , "Part"
                               , "ParticleData"
                               , "Partition"
                               , "PartitionsP"
                               , "PartitionsQ"
                               , "PascalDistribution"
                               , "PassEventsDown"
                               , "PassEventsUp"
                               , "Paste"
                               , "PasteButton"
                               , "Path"
                               , "PathGraph"
                               , "PathGraphQ"
                               , "Pattern"
                               , "PatternSequence"
                               , "PatternTest"
                               , "PauliMatrix"
                               , "PaulWavelet"
                               , "Pause"
                               , "PDF"
                               , "PearsonChiSquareTest"
                               , "PearsonDistribution"
                               , "PerformanceGoal"
                               , "PermutationCycles"
                               , "PermutationCyclesQ"
                               , "PermutationGroup"
                               , "PermutationLength"
                               , "PermutationList"
                               , "PermutationListQ"
                               , "PermutationMax"
                               , "PermutationMin"
                               , "PermutationOrder"
                               , "PermutationPower"
                               , "PermutationProduct"
                               , "PermutationReplace"
                               , "Permutations"
                               , "PermutationSupport"
                               , "Permute"
                               , "PeronaMalikFilter"
                               , "PERTDistribution"
                               , "PetersenGraph"
                               , "PhaseMargins"
                               , "Pi"
                               , "Pick"
                               , "Piecewise"
                               , "PiecewiseExpand"
                               , "PieChart"
                               , "PieChart3D"
                               , "Pink"
                               , "PixelConstrained"
                               , "PixelValue"
                               , "Placed"
                               , "Placeholder"
                               , "PlaceholderReplace"
                               , "Plain"
                               , "Play"
                               , "PlayRange"
                               , "Plot"
                               , "Plot3D"
                               , "PlotLabel"
                               , "PlotLayout"
                               , "PlotMarkers"
                               , "PlotPoints"
                               , "PlotRange"
                               , "PlotRangeClipping"
                               , "PlotRangePadding"
                               , "PlotRegion"
                               , "PlotStyle"
                               , "Plus"
                               , "PlusMinus"
                               , "Pochhammer"
                               , "PodStates"
                               , "PodWidth"
                               , "Point"
                               , "PointFigureChart"
                               , "PointSize"
                               , "PoissonConsulDistribution"
                               , "PoissonDistribution"
                               , "PolarAxes"
                               , "PolarAxesOrigin"
                               , "PolarGridLines"
                               , "PolarPlot"
                               , "PolarTicks"
                               , "PoleZeroMarkers"
                               , "PolyaAeppliDistribution"
                               , "PolyGamma"
                               , "Polygon"
                               , "PolyhedronData"
                               , "PolyLog"
                               , "PolynomialExtendedGCD"
                               , "PolynomialGCD"
                               , "PolynomialLCM"
                               , "PolynomialMod"
                               , "PolynomialQ"
                               , "PolynomialQuotient"
                               , "PolynomialQuotientRemainder"
                               , "PolynomialReduce"
                               , "PolynomialRemainder"
                               , "PopupMenu"
                               , "PopupView"
                               , "PopupWindow"
                               , "Position"
                               , "Positive"
                               , "PositiveDefiniteMatrixQ"
                               , "PossibleZeroQ"
                               , "Postfix"
                               , "Power"
                               , "PowerDistribution"
                               , "PowerExpand"
                               , "PowerMod"
                               , "PowerModList"
                               , "PowersRepresentations"
                               , "PowerSymmetricPolynomial"
                               , "PrecedenceForm"
                               , "Precedes"
                               , "PrecedesEqual"
                               , "PrecedesSlantEqual"
                               , "PrecedesTilde"
                               , "Precision"
                               , "PrecisionGoal"
                               , "PreDecrement"
                               , "PreemptProtect"
                               , "Prefix"
                               , "PreIncrement"
                               , "Prepend"
                               , "PrependTo"
                               , "PreserveImageOptions"
                               , "PriceGraphDistribution"
                               , "Prime"
                               , "PrimeNu"
                               , "PrimeOmega"
                               , "PrimePi"
                               , "PrimePowerQ"
                               , "PrimeQ"
                               , "Primes"
                               , "PrimeZetaP"
                               , "PrimitiveRoot"
                               , "PrincipalComponents"
                               , "PrincipalValue"
                               , "Print"
                               , "PrintingStyleEnvironment"
                               , "PrintTemporary"
                               , "Probability"
                               , "ProbabilityDistribution"
                               , "ProbabilityPlot"
                               , "ProbabilityScalePlot"
                               , "ProbitModelFit"
                               , "Product"
                               , "ProductDistribution"
                               , "ProductLog"
                               , "ProgressIndicator"
                               , "Projection"
                               , "Prolog"
                               , "Properties"
                               , "Property"
                               , "PropertyList"
                               , "PropertyValue"
                               , "Proportion"
                               , "Proportional"
                               , "Protect"
                               , "Protected"
                               , "ProteinData"
                               , "Pruning"
                               , "PseudoInverse"
                               , "Purple"
                               , "Put"
                               , "PutAppend"
                               , "Q"
                               , "QBinomial"
                               , "QFactorial"
                               , "QGamma"
                               , "QHypergeometricPFQ"
                               , "QPochhammer"
                               , "QPolyGamma"
                               , "QRDecomposition"
                               , "QuadraticIrrationalQ"
                               , "Quantile"
                               , "QuantilePlot"
                               , "Quartics"
                               , "QuartileDeviation"
                               , "Quartiles"
                               , "QuartileSkewness"
                               , "Quiet"
                               , "Quit"
                               , "Quotient"
                               , "QuotientRemainder"
                               , "R"
                               , "RadicalBox"
                               , "RadioButton"
                               , "RadioButtonBar"
                               , "Radon"
                               , "RamanujanTau"
                               , "RamanujanTauL"
                               , "RamanujanTauTheta"
                               , "RamanujanTauZ"
                               , "RandomChoice"
                               , "RandomComplex"
                               , "RandomGraph"
                               , "RandomImage"
                               , "RandomInteger"
                               , "RandomPermutation"
                               , "RandomPrime"
                               , "RandomReal"
                               , "RandomSample"
                               , "RandomVariate"
                               , "Range"
                               , "RangeFilter"
                               , "RankedMax"
                               , "RankedMin"
                               , "Raster"
                               , "Rasterize"
                               , "RasterSize"
                               , "Rational"
                               , "Rationalize"
                               , "Rationals"
                               , "Ratios"
                               , "RawBoxes"
                               , "RawData"
                               , "RayleighDistribution"
                               , "Re"
                               , "Read"
                               , "ReadList"
                               , "ReadProtected"
                               , "Real"
                               , "RealBlockDiagonalForm"
                               , "RealDigits"
                               , "RealExponent"
                               , "Reals"
                               , "Reap"
                               , "Record"
                               , "RecordLists"
                               , "RecordSeparators"
                               , "Rectangle"
                               , "RectangleChart"
                               , "RectangleChart3D"
                               , "RecurrenceTable"
                               , "Red"
                               , "Reduce"
                               , "ReferenceLineStyle"
                               , "Refine"
                               , "ReflectionMatrix"
                               , "ReflectionTransform"
                               , "Refresh"
                               , "RefreshRate"
                               , "RegionBinarize"
                               , "RegionFunction"
                               , "RegionPlot"
                               , "RegionPlot3D"
                               , "RegularExpression"
                               , "Regularization"
                               , "ReleaseHold"
                               , "ReliefImage"
                               , "ReliefPlot"
                               , "Remove"
                               , "RemoveAlphaChannel"
                               , "RemoveProperty"
                               , "RemoveScheduledTask"
                               , "RenameDirectory"
                               , "RenameFile"
                               , "RenkoChart"
                               , "Repeated"
                               , "RepeatedNull"
                               , "Replace"
                               , "ReplaceAll"
                               , "ReplaceList"
                               , "ReplacePart"
                               , "ReplaceRepeated"
                               , "Resampling"
                               , "Rescale"
                               , "RescalingTransform"
                               , "ResetDirectory"
                               , "ResetScheduledTask"
                               , "Residue"
                               , "Resolve"
                               , "Rest"
                               , "Resultant"
                               , "ResumePacket"
                               , "Return"
                               , "ReturnExpressionPacket"
                               , "ReturnPacket"
                               , "ReturnTextPacket"
                               , "Reverse"
                               , "ReverseBiorthogonalSplineWavelet"
                               , "ReverseElement"
                               , "ReverseEquilibrium"
                               , "ReverseGraph"
                               , "ReverseUpEquilibrium"
                               , "RevolutionAxis"
                               , "RevolutionPlot3D"
                               , "RGBColor"
                               , "RiccatiSolve"
                               , "RiceDistribution"
                               , "RidgeFilter"
                               , "RiemannR"
                               , "RiemannSiegelTheta"
                               , "RiemannSiegelZ"
                               , "Riffle"
                               , "Right"
                               , "RightArrow"
                               , "RightArrowBar"
                               , "RightArrowLeftArrow"
                               , "RightCosetRepresentative"
                               , "RightDownTeeVector"
                               , "RightDownVector"
                               , "RightDownVectorBar"
                               , "RightTeeArrow"
                               , "RightTeeVector"
                               , "RightTriangle"
                               , "RightTriangleBar"
                               , "RightTriangleEqual"
                               , "RightUpDownVector"
                               , "RightUpTeeVector"
                               , "RightUpVector"
                               , "RightUpVectorBar"
                               , "RightVector"
                               , "RightVectorBar"
                               , "RogersTanimotoDissimilarity"
                               , "Root"
                               , "RootApproximant"
                               , "RootIntervals"
                               , "RootLocusPlot"
                               , "RootMeanSquare"
                               , "RootOfUnityQ"
                               , "RootReduce"
                               , "Roots"
                               , "RootSum"
                               , "Rotate"
                               , "RotateLabel"
                               , "RotateLeft"
                               , "RotateRight"
                               , "RotationAction"
                               , "RotationMatrix"
                               , "RotationTransform"
                               , "Round"
                               , "RoundingRadius"
                               , "Row"
                               , "RowAlignments"
                               , "RowBox"
                               , "RowLines"
                               , "RowMinHeight"
                               , "RowReduce"
                               , "RowsEqual"
                               , "RowSpacings"
                               , "RSolve"
                               , "RudvalisGroupRu"
                               , "Rule"
                               , "RuleDelayed"
                               , "Run"
                               , "RunScheduledTask"
                               , "RunThrough"
                               , "RuntimeAttributes"
                               , "RuntimeOptions"
                               , "RussellRaoDissimilarity"
                               , "S"
                               , "SameQ"
                               , "SameTest"
                               , "SampleDepth"
                               , "SampledSoundFunction"
                               , "SampledSoundList"
                               , "SampleRate"
                               , "SamplingPeriod"
                               , "SatisfiabilityCount"
                               , "SatisfiabilityInstances"
                               , "SatisfiableQ"
                               , "Save"
                               , "SaveDefinitions"
                               , "SawtoothWave"
                               , "Scale"
                               , "Scaled"
                               , "ScalingFunctions"
                               , "ScalingMatrix"
                               , "ScalingTransform"
                               , "Scan"
                               , "ScheduledTaskObject"
                               , "ScheduledTasks"
                               , "SchurDecomposition"
                               , "ScientificForm"
                               , "ScreenStyleEnvironment"
                               , "ScriptBaselineShifts"
                               , "ScriptMinSize"
                               , "ScriptSizeMultipliers"
                               , "Scrollbars"
                               , "ScrollPosition"
                               , "Sec"
                               , "Sech"
                               , "SechDistribution"
                               , "SectorChart"
                               , "SectorChart3D"
                               , "SectorOrigin"
                               , "SectorSpacing"
                               , "SeedRandom"
                               , "Select"
                               , "Selectable"
                               , "SelectComponents"
                               , "SelectedNotebook"
                               , "SelectionAnimate"
                               , "SelectionCreateCell"
                               , "SelectionEvaluate"
                               , "SelectionEvaluateCreateCell"
                               , "SelectionMove"
                               , "SelfLoopStyle"
                               , "SemialgebraicComponentInstances"
                               , "SendMail"
                               , "Sequence"
                               , "SequenceAlignment"
                               , "SequenceHold"
                               , "Series"
                               , "SeriesCoefficient"
                               , "SeriesData"
                               , "SessionTime"
                               , "Set"
                               , "SetAccuracy"
                               , "SetAlphaChannel"
                               , "SetAttributes"
                               , "SetDelayed"
                               , "SetDirectory"
                               , "SetFileDate"
                               , "SetOptions"
                               , "SetPrecision"
                               , "SetProperty"
                               , "SetSelectedNotebook"
                               , "SetSharedFunction"
                               , "SetSharedVariable"
                               , "SetStreamPosition"
                               , "SetSystemOptions"
                               , "Setter"
                               , "SetterBar"
                               , "Setting"
                               , "Shallow"
                               , "ShannonWavelet"
                               , "ShapiroWilkTest"
                               , "Share"
                               , "Sharpen"
                               , "ShearingMatrix"
                               , "ShearingTransform"
                               , "Short"
                               , "ShortDownArrow"
                               , "Shortest"
                               , "ShortestPathFunction"
                               , "ShortLeftArrow"
                               , "ShortRightArrow"
                               , "ShortUpArrow"
                               , "Show"
                               , "ShowAutoStyles"
                               , "ShowCellBracket"
                               , "ShowCellLabel"
                               , "ShowCellTags"
                               , "ShowCursorTracker"
                               , "ShowGroupOpener"
                               , "ShowPageBreaks"
                               , "ShowSelection"
                               , "ShowSpecialCharacters"
                               , "ShowStringCharacters"
                               , "ShrinkingDelay"
                               , "SiegelTheta"
                               , "SiegelTukeyTest"
                               , "Sign"
                               , "Signature"
                               , "SignedRankTest"
                               , "SignificanceLevel"
                               , "SignPadding"
                               , "SignTest"
                               , "SimilarityRules"
                               , "SimpleGraph"
                               , "SimpleGraphQ"
                               , "Simplify"
                               , "Sin"
                               , "Sinc"
                               , "SinghMaddalaDistribution"
                               , "SingleLetterItalics"
                               , "SingularValueDecomposition"
                               , "SingularValueList"
                               , "SingularValuePlot"
                               , "Sinh"
                               , "SinhIntegral"
                               , "SinIntegral"
                               , "SixJSymbol"
                               , "Skeleton"
                               , "SkeletonTransform"
                               , "SkellamDistribution"
                               , "Skewness"
                               , "SkewNormalDistribution"
                               , "Skip"
                               , "Slider"
                               , "Slider2D"
                               , "SlideView"
                               , "Slot"
                               , "SlotSequence"
                               , "Small"
                               , "SmallCircle"
                               , "Smaller"
                               , "SmithWatermanSimilarity"
                               , "SmoothDensityHistogram"
                               , "SmoothHistogram"
                               , "SmoothHistogram3D"
                               , "SmoothKernelDistribution"
                               , "SokalSneathDissimilarity"
                               , "Solve"
                               , "SolveAlways"
                               , "Sort"
                               , "SortBy"
                               , "Sound"
                               , "SoundNote"
                               , "SoundVolume"
                               , "Sow"
                               , "Spacer"
                               , "Spacings"
                               , "Span"
                               , "SpanFromAbove"
                               , "SpanFromBoth"
                               , "SpanFromLeft"
                               , "SparseArray"
                               , "Speak"
                               , "Specularity"
                               , "SpellingCorrection"
                               , "Sphere"
                               , "SphericalBesselJ"
                               , "SphericalBesselY"
                               , "SphericalHankelH1"
                               , "SphericalHankelH2"
                               , "SphericalHarmonicY"
                               , "SphericalPlot3D"
                               , "SphericalRegion"
                               , "SpheroidalEigenvalue"
                               , "SpheroidalJoiningFactor"
                               , "SpheroidalPS"
                               , "SpheroidalPSPrime"
                               , "SpheroidalQS"
                               , "SpheroidalQSPrime"
                               , "SpheroidalRadialFactor"
                               , "SpheroidalS1"
                               , "SpheroidalS1Prime"
                               , "SpheroidalS2"
                               , "SpheroidalS2Prime"
                               , "Splice"
                               , "SplineClosed"
                               , "SplineDegree"
                               , "SplineKnots"
                               , "SplineWeights"
                               , "Split"
                               , "SplitBy"
                               , "SpokenString"
                               , "Sqrt"
                               , "SqrtBox"
                               , "Square"
                               , "SquaredEuclideanDistance"
                               , "SquareFreeQ"
                               , "SquareIntersection"
                               , "SquaresR"
                               , "SquareSubset"
                               , "SquareSubsetEqual"
                               , "SquareSuperset"
                               , "SquareSupersetEqual"
                               , "SquareUnion"
                               , "SquareWave"
                               , "StabilityMargins"
                               , "StabilityMarginsStyle"
                               , "StableDistribution"
                               , "Stack"
                               , "StackBegin"
                               , "StackComplete"
                               , "StackInhibit"
                               , "StandardDeviation"
                               , "StandardDeviationFilter"
                               , "StandardForm"
                               , "Standardize"
                               , "Star"
                               , "StarGraph"
                               , "StartingStepSize"
                               , "StartOfLine"
                               , "StartOfString"
                               , "StartScheduledTask"
                               , "StateFeedbackGains"
                               , "StateOutputEstimator"
                               , "StateResponse"
                               , "StateSpaceModel"
                               , "StateSpaceRealization"
                               , "StateSpaceTransform"
                               , "StationaryWaveletPacketTransform"
                               , "StationaryWaveletTransform"
                               , "StatusArea"
                               , "StepMonitor"
                               , "StieltjesGamma"
                               , "StirlingS1"
                               , "StirlingS2"
                               , "StopScheduledTask"
                               , "StreamColorFunction"
                               , "StreamColorFunctionScaling"
                               , "StreamDensityPlot"
                               , "StreamPlot"
                               , "StreamPoints"
                               , "StreamPosition"
                               , "Streams"
                               , "StreamScale"
                               , "StreamStyle"
                               , "String"
                               , "StringCases"
                               , "StringCount"
                               , "StringDrop"
                               , "StringExpression"
                               , "StringForm"
                               , "StringFormat"
                               , "StringFreeQ"
                               , "StringInsert"
                               , "StringJoin"
                               , "StringLength"
                               , "StringMatchQ"
                               , "StringPosition"
                               , "StringQ"
                               , "StringReplace"
                               , "StringReplaceList"
                               , "StringReplacePart"
                               , "StringReverse"
                               , "StringSkeleton"
                               , "StringSplit"
                               , "StringTake"
                               , "StringToStream"
                               , "StringTrim"
                               , "StructuredSelection"
                               , "StruveH"
                               , "StruveL"
                               , "Stub"
                               , "StudentTDistribution"
                               , "Style"
                               , "StyleBox"
                               , "StyleData"
                               , "StyleDefinitions"
                               , "Subfactorial"
                               , "Subgraph"
                               , "SubMinus"
                               , "SubPlus"
                               , "Subresultants"
                               , "Subscript"
                               , "SubscriptBox"
                               , "Subset"
                               , "SubsetEqual"
                               , "Subsets"
                               , "SubStar"
                               , "Subsuperscript"
                               , "SubsuperscriptBox"
                               , "Subtract"
                               , "SubtractFrom"
                               , "Succeeds"
                               , "SucceedsEqual"
                               , "SucceedsSlantEqual"
                               , "SucceedsTilde"
                               , "SuchThat"
                               , "Sum"
                               , "SumConvergence"
                               , "SuperDagger"
                               , "SuperMinus"
                               , "SuperPlus"
                               , "Superscript"
                               , "SuperscriptBox"
                               , "Superset"
                               , "SupersetEqual"
                               , "SuperStar"
                               , "SurvivalDistribution"
                               , "SurvivalFunction"
                               , "SuspendPacket"
                               , "SuzukiDistribution"
                               , "SuzukiGroupSuz"
                               , "Switch"
                               , "Symbol"
                               , "SymbolName"
                               , "SymletWavelet"
                               , "SymmetricGroup"
                               , "SymmetricMatrixQ"
                               , "SymmetricPolynomial"
                               , "SymmetricReduction"
                               , "SynchronousInitialization"
                               , "SynchronousUpdating"
                               , "SyntaxInformation"
                               , "SyntaxLength"
                               , "SyntaxPacket"
                               , "SyntaxQ"
                               , "SystemDialogInput"
                               , "SystemInformation"
                               , "SystemOpen"
                               , "SystemOptions"
                               , "SystemsModelDelete"
                               , "SystemsModelDimensions"
                               , "SystemsModelExtract"
                               , "SystemsModelFeedbackConnect"
                               , "SystemsModelLabels"
                               , "SystemsModelOrder"
                               , "SystemsModelParallelConnect"
                               , "SystemsModelSeriesConnect"
                               , "SystemsModelStateFeedbackConnect"
                               , "T"
                               , "Table"
                               , "TableAlignments"
                               , "TableDepth"
                               , "TableDirections"
                               , "TableForm"
                               , "TableHeadings"
                               , "TableSpacing"
                               , "TabView"
                               , "TagBox"
                               , "TaggingRules"
                               , "TagSet"
                               , "TagSetDelayed"
                               , "TagUnset"
                               , "Take"
                               , "TakeWhile"
                               , "Tally"
                               , "Tan"
                               , "Tanh"
                               , "TargetFunctions"
                               , "TautologyQ"
                               , "Temporary"
                               , "TeXForm"
                               , "Text"
                               , "TextAlignment"
                               , "TextCell"
                               , "TextClipboardType"
                               , "TextData"
                               , "TextJustification"
                               , "TextPacket"
                               , "TextRecognize"
                               , "Texture"
                               , "TextureCoordinateFunction"
                               , "TextureCoordinateScaling"
                               , "Therefore"
                               , "Thick"
                               , "Thickness"
                               , "Thin"
                               , "Thinning"
                               , "ThompsonGroupTh"
                               , "Thread"
                               , "ThreeJSymbol"
                               , "Threshold"
                               , "Through"
                               , "Throw"
                               , "Thumbnail"
                               , "Ticks"
                               , "TicksStyle"
                               , "Tilde"
                               , "TildeEqual"
                               , "TildeFullEqual"
                               , "TildeTilde"
                               , "TimeConstrained"
                               , "TimeConstraint"
                               , "Times"
                               , "TimesBy"
                               , "TimeUsed"
                               , "TimeValue"
                               , "TimeZone"
                               , "Timing"
                               , "Tiny"
                               , "TitsGroupT"
                               , "ToBoxes"
                               , "ToCharacterCode"
                               , "ToContinuousTimeModel"
                               , "ToDiscreteTimeModel"
                               , "ToeplitzMatrix"
                               , "ToExpression"
                               , "Together"
                               , "Toggler"
                               , "TogglerBar"
                               , "TokenWords"
                               , "Tolerance"
                               , "ToLowerCase"
                               , "ToNumberField"
                               , "Tooltip"
                               , "TooltipDelay"
                               , "Top"
                               , "TopHatTransform"
                               , "TopologicalSort"
                               , "ToRadicals"
                               , "ToRules"
                               , "ToString"
                               , "Total"
                               , "TotalVariationFilter"
                               , "TotalWidth"
                               , "ToUpperCase"
                               , "Tr"
                               , "Trace"
                               , "TraceAbove"
                               , "TraceBackward"
                               , "TraceDepth"
                               , "TraceDialog"
                               , "TraceForward"
                               , "TraceOff"
                               , "TraceOn"
                               , "TraceOriginal"
                               , "TracePrint"
                               , "TraceScan"
                               , "TrackedSymbols"
                               , "TradingChart"
                               , "TraditionalForm"
                               , "TransferFunctionCancel"
                               , "TransferFunctionExpand"
                               , "TransferFunctionFactor"
                               , "TransferFunctionModel"
                               , "TransferFunctionPoles"
                               , "TransferFunctionZeros"
                               , "TransformationFunction"
                               , "TransformationFunctions"
                               , "TransformationMatrix"
                               , "TransformedDistribution"
                               , "Translate"
                               , "TranslationTransform"
                               , "Transparent"
                               , "Transpose"
                               , "TreeForm"
                               , "TreeGraph"
                               , "TreeGraphQ"
                               , "TreePlot"
                               , "TrendStyle"
                               , "TriangleWave"
                               , "TriangularDistribution"
                               , "Trig"
                               , "TrigExpand"
                               , "TrigFactor"
                               , "TrigFactorList"
                               , "Trigger"
                               , "TrigReduce"
                               , "TrigToExp"
                               , "TrimmedMean"
                               , "True"
                               , "TrueQ"
                               , "TruncatedDistribution"
                               , "TTest"
                               , "Tube"
                               , "TukeyLambdaDistribution"
                               , "Tuples"
                               , "TuranGraph"
                               , "TuringMachine"
                               , "U"
                               , "Uncompress"
                               , "Undefined"
                               , "UnderBar"
                               , "Underflow"
                               , "Underlined"
                               , "Underoverscript"
                               , "UnderoverscriptBox"
                               , "Underscript"
                               , "UnderscriptBox"
                               , "UndirectedEdge"
                               , "UndirectedGraph"
                               , "UndirectedGraphQ"
                               , "Unequal"
                               , "Unevaluated"
                               , "UniformDistribution"
                               , "UniformGraphDistribution"
                               , "UniformSumDistribution"
                               , "Uninstall"
                               , "Union"
                               , "UnionPlus"
                               , "Unique"
                               , "UnitBox"
                               , "Unitize"
                               , "UnitStep"
                               , "UnitTriangle"
                               , "UnitVector"
                               , "Unprotect"
                               , "UnsameQ"
                               , "UnsavedVariables"
                               , "Unset"
                               , "UnsetShared"
                               , "UpArrow"
                               , "UpArrowBar"
                               , "UpArrowDownArrow"
                               , "Update"
                               , "UpdateInterval"
                               , "UpDownArrow"
                               , "UpEquilibrium"
                               , "UpperCaseQ"
                               , "UpperLeftArrow"
                               , "UpperRightArrow"
                               , "UpperTriangularize"
                               , "UpSet"
                               , "UpSetDelayed"
                               , "UpTeeArrow"
                               , "UpValues"
                               , "UsingFrontEnd"
                               , "V"
                               , "ValidationLength"
                               , "ValueQ"
                               , "Variables"
                               , "Variance"
                               , "VarianceEquivalenceTest"
                               , "VarianceEstimatorFunction"
                               , "VarianceTest"
                               , "VectorAngle"
                               , "VectorColorFunction"
                               , "VectorColorFunctionScaling"
                               , "VectorDensityPlot"
                               , "VectorPlot"
                               , "VectorPlot3D"
                               , "VectorPoints"
                               , "VectorQ"
                               , "VectorScale"
                               , "VectorStyle"
                               , "Vee"
                               , "Verbatim"
                               , "VerifyConvergence"
                               , "VerifyTestAssumptions"
                               , "VertexAdd"
                               , "VertexColors"
                               , "VertexComponent"
                               , "VertexCoordinateRules"
                               , "VertexCoordinates"
                               , "VertexCount"
                               , "VertexCoverQ"
                               , "VertexDegree"
                               , "VertexDelete"
                               , "VertexEccentricity"
                               , "VertexInComponent"
                               , "VertexInDegree"
                               , "VertexIndex"
                               , "VertexLabeling"
                               , "VertexLabels"
                               , "VertexList"
                               , "VertexNormals"
                               , "VertexOutComponent"
                               , "VertexOutDegree"
                               , "VertexQ"
                               , "VertexRenderingFunction"
                               , "VertexReplace"
                               , "VertexShape"
                               , "VertexShapeFunction"
                               , "VertexSize"
                               , "VertexStyle"
                               , "VertexTextureCoordinates"
                               , "VertexWeight"
                               , "VerticalBar"
                               , "VerticalSeparator"
                               , "VerticalSlider"
                               , "VerticalTilde"
                               , "ViewAngle"
                               , "ViewCenter"
                               , "ViewMatrix"
                               , "ViewPoint"
                               , "ViewRange"
                               , "ViewVector"
                               , "ViewVertical"
                               , "Visible"
                               , "VonMisesDistribution"
                               , "W"
                               , "WaitAll"
                               , "WaitNext"
                               , "WakebyDistribution"
                               , "WalleniusHypergeometricDistribution"
                               , "WaringYuleDistribution"
                               , "WatershedComponents"
                               , "WatsonUSquareTest"
                               , "WattsStrogatzGraphDistribution"
                               , "WaveletBestBasis"
                               , "WaveletFilterCoefficients"
                               , "WaveletImagePlot"
                               , "WaveletListPlot"
                               , "WaveletMapIndexed"
                               , "WaveletMatrixPlot"
                               , "WaveletPhi"
                               , "WaveletPsi"
                               , "WaveletScale"
                               , "WaveletScalogram"
                               , "WaveletThreshold"
                               , "WeatherData"
                               , "WeberE"
                               , "Wedge"
                               , "WeibullDistribution"
                               , "WeierstrassHalfPeriods"
                               , "WeierstrassInvariants"
                               , "WeierstrassP"
                               , "WeierstrassPPrime"
                               , "WeierstrassSigma"
                               , "WeierstrassZeta"
                               , "WeightedAdjacencyGraph"
                               , "WeightedAdjacencyMatrix"
                               , "WeightedGraphQ"
                               , "Weights"
                               , "WheelGraph"
                               , "Which"
                               , "While"
                               , "White"
                               , "Whitespace"
                               , "WhitespaceCharacter"
                               , "WhittakerM"
                               , "WhittakerW"
                               , "WienerFilter"
                               , "WignerD"
                               , "WignerSemicircleDistribution"
                               , "WindowClickSelect"
                               , "WindowElements"
                               , "WindowFloating"
                               , "WindowFrame"
                               , "WindowMargins"
                               , "WindowMovable"
                               , "WindowOpacity"
                               , "WindowSize"
                               , "WindowStatusArea"
                               , "WindowTitle"
                               , "WindowToolbars"
                               , "With"
                               , "WolframAlpha"
                               , "Word"
                               , "WordBoundary"
                               , "WordCharacter"
                               , "WordData"
                               , "WordSearch"
                               , "WordSeparators"
                               , "WorkingPrecision"
                               , "Write"
                               , "WriteString"
                               , "Wronskian"
                               , "X"
                               , "XMLElement"
                               , "XMLObject"
                               , "Xnor"
                               , "Xor"
                               , "Y"
                               , "Yellow"
                               , "YuleDissimilarity"
                               , "Z"
                               , "ZernikeR"
                               , "ZeroTest"
                               , "Zeta"
                               , "ZetaZero"
                               , "ZipfDistribution"
                               , "ZTest"
                               , "ZTransform"
                               ])
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Float
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[a-zA-Z_0-9]+\\_"
                              , reCompiled = Just (compileRegex True "[a-zA-Z_0-9]+\\_")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "(\\-\\>|\\/\\.)"
                              , reCompiled = Just (compileRegex True "(\\-\\>|\\/\\.)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = AnyChar "+*/%\\|-^"
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "(:=|=)"
                              , reCompiled = Just (compileRegex True "(:=|=)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Sven Brauch (svenbrauch@gmail.com)"
  , sVersion = "9"
  , sLicense = "LGPL"
  , sExtensions = [ "*.nb" ]
  , sStartingContext = "Normal"
  }
