{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Makefile (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "Makefile"
  , sFilename = "makefile.xml"
  , sShortname = "Makefile"
  , sContexts =
      fromList
        [ ( "Comment"
          , Context
              { cName = "Comment"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Alerts" , "" )
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Modelines" , "" )
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "assign"
          , Context
              { cName = "assign"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '='
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "value" ) ]
                      }
                  ]
              , cAttribute = CharTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "bmake_conditional"
          , Context
              { cName = "bmake_conditional"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Makefile" , "strings_and_vars" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True [ "commands" , "defined" , "empty" , "exists" , "target" ])
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "bmake_expression" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '&' '&'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '|' '|'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '!' '='
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '=' '='
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '!'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCHex
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectIdentifier
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = LineContinue
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "bmake_expression"
          , Context
              { cName = "bmake_expression"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Makefile" , "strings_and_vars" )
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '('
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar ')'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectIdentifier
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "bmake_for_loop"
          , Context
              { cName = "bmake_for_loop"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Makefile" , "strings_and_vars" )
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = WordDetect "in"
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "bmake_include"
          , Context
              { cName = "bmake_include"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = RangeDetect '<' '>'
                      , rAttribute = ImportTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = RangeDetect '"' '"'
                      , rAttribute = ImportTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "bmake_message"
          , Context
              { cName = "bmake_message"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "bmake_other_stmts"
          , Context
              { cName = "bmake_other_stmts"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Makefile" , "strings_and_vars" )
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "bmake_special_target"
          , Context
              { cName = "bmake_special_target"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar ':'
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Push ( "Makefile" , "prereq" ) ]
                      }
                  ]
              , cAttribute = ErrorTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Push ( "Makefile" , "rule" ) ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "bmake_var_modifier"
          , Context
              { cName = "bmake_var_modifier"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  , Rule
                      { rMatcher = AnyChar "EHOQRTuLP"
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Push ( "Makefile" , "expect}" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars 's' 'h'
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Push ( "Makefile" , "expect}" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars 'O' 'x'
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Push ( "Makefile" , "expect}" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars 't' 'A'
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Push ( "Makefile" , "expect}" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars 't' 'L'
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Push ( "Makefile" , "expect}" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "gmtime"
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Push ( "Makefile" , "expect}" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "hash"
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Push ( "Makefile" , "expect}" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "localtime"
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Push ( "Makefile" , "expect}" ) ]
                      }
                  , Rule
                      { rMatcher = AnyChar "MNDU"
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Pop , Push ( "Makefile" , "bmake_var_modifier_arg" ) ]
                      }
                  , Rule
                      { rMatcher = AnyChar "SC"
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Pop , Push ( "Makefile" , "bmake_var_modifier_arg" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars ':' '='
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Pop , Push ( "Makefile" , "bmake_var_modifier_arg" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect ":?="
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Pop , Push ( "Makefile" , "bmake_var_modifier_arg" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect ":+="
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Pop , Push ( "Makefile" , "bmake_var_modifier_arg" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect ":!="
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Pop , Push ( "Makefile" , "bmake_var_modifier_arg" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars 't' 'u'
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Pop , Push ( "Makefile" , "bmake_var_modifier_arg" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars 't' 'W'
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Pop , Push ( "Makefile" , "bmake_var_modifier_arg" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars 't' 'w'
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Pop , Push ( "Makefile" , "bmake_var_modifier_arg" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars 't' 's'
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Pop , Push ( "Makefile" , "bmake_var_modifier_arg" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = ""
                              , reCompiled = Just (compileRegex True "")
                              , reCaseSensitive = True
                              }
                      , rAttribute = SpecialStringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Makefile" , "bmake_var_modifier_arg" )
                      , rAttribute = SpecialStringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = SpecialStringTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = True
              , cFallthroughContext =
                  [ Pop , Push ( "Makefile" , "bmake_var_modifier_arg" ) ]
              , cDynamic = False
              }
          )
        , ( "bmake_var_modifier_arg"
          , Context
              { cName = "bmake_var_modifier_arg"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' '}'
                      , rAttribute = SpecialStringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop , Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' ':'
                      , rAttribute = SpecialStringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar ':'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Pop , Push ( "Makefile" , "bmake_var_modifier" ) ]
                      }
                  ]
              , cAttribute = SpecialStringTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "call("
          , Context
              { cName = "call("
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "abspath"
                               , "addprefix"
                               , "addsuffix"
                               , "and"
                               , "basename"
                               , "call"
                               , "dir"
                               , "error"
                               , "eval"
                               , "filter"
                               , "filter-out"
                               , "findstring"
                               , "firstword"
                               , "flavor"
                               , "foreach"
                               , "if"
                               , "info"
                               , "join"
                               , "lastword"
                               , "notdir"
                               , "or"
                               , "origin"
                               , "patsubst"
                               , "realpath"
                               , "shell"
                               , "sort"
                               , "strip"
                               , "subst"
                               , "suffix"
                               , "value"
                               , "warning"
                               , "wildcard"
                               , "word"
                               , "wordlist"
                               , "words"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "callFunc(" ) ]
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = True
              , cFallthroughContext = [ Push ( "Makefile" , "callVar(" ) ]
              , cDynamic = False
              }
          )
        , ( "callFunc("
          , Context
              { cName = "callFunc("
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar ')'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar ','
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "string'" ) ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "callFunc{"
          , Context
              { cName = "callFunc{"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar ','
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "string'" ) ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "callVar("
          , Context
              { cName = "callVar("
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar ')'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  , Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = AnyChar "=#:"
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "callVar{"
          , Context
              { cName = "callVar{"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  , Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' ':'
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Push ( "Makefile" , "expect}" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Pop , Push ( "Makefile" , "bmake_var_modifier_arg" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar ':'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "bmake_var_modifier" ) ]
                      }
                  , Rule
                      { rMatcher = AnyChar "=#"
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "call{"
          , Context
              { cName = "call{"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "abspath"
                               , "addprefix"
                               , "addsuffix"
                               , "and"
                               , "basename"
                               , "call"
                               , "dir"
                               , "error"
                               , "eval"
                               , "filter"
                               , "filter-out"
                               , "findstring"
                               , "firstword"
                               , "flavor"
                               , "foreach"
                               , "if"
                               , "info"
                               , "join"
                               , "lastword"
                               , "notdir"
                               , "or"
                               , "origin"
                               , "patsubst"
                               , "realpath"
                               , "shell"
                               , "sort"
                               , "strip"
                               , "subst"
                               , "suffix"
                               , "value"
                               , "warning"
                               , "wildcard"
                               , "word"
                               , "wordlist"
                               , "words"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "callFunc{" ) ]
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = True
              , cFallthroughContext = [ Push ( "Makefile" , "callVar{" ) ]
              , cDynamic = False
              }
          )
        , ( "dollar"
          , Context
              { cName = "dollar"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '('
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "call(" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '{'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "call{" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "."
                              , reCompiled = Just (compileRegex True ".")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = CharTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "expect}"
          , Context
              { cName = "expect}"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '\\' '}'
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop , Pop , Pop ]
                      }
                  ]
              , cAttribute = ErrorTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop , Pop , Pop , Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "gmake_else"
          , Context
              { cName = "gmake_else"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ "if" , "ifdef" , "ifeq" , "ifndef" , "ifneq" ])
                      , rAttribute = ControlFlowTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Makefile" , "strings_and_vars" )
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = ErrorTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "normal"
          , Context
              { cName = "normal"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "Comment" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True [ ".if" , ".ifdef" , ".ifmake" , ".ifndef" , ".ifnmake" ])
                      , rAttribute = ControlFlowTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "bmake_conditional" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ ".elif"
                               , ".elifdef"
                               , ".elifmake"
                               , ".elifndef"
                               , ".elifnmake"
                               , ".else"
                               ])
                      , rAttribute = ControlFlowTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "bmake_conditional" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ ".endif" ])
                      , rAttribute = ControlFlowTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ "if" , "ifdef" , "ifeq" , "ifndef" , "ifneq" ])
                      , rAttribute = ControlFlowTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ "else" ])
                      , rAttribute = ControlFlowTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "gmake_else" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ "endif" ])
                      , rAttribute = ControlFlowTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ "-include" , "define" , "endef" , "include" ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ ".export"
                               , ".export-env"
                               , ".undef"
                               , ".unexport"
                               , ".unexport-env"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "bmake_other_stmts" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[^\\s:?]*\\s*(?=:=|=|\\+=|\\?=)"
                              , reCompiled =
                                  Just (compileRegex True "[^\\s:?]*\\s*(?=:=|=|\\+=|\\?=)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "assign" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ ".BEGIN"
                               , ".DEFAULT"
                               , ".END"
                               , ".ERROR"
                               , ".IGNORE"
                               , ".INTERRUPT"
                               , ".MAIN"
                               , ".MAKEFLAGS"
                               , ".NOPATH"
                               , ".NOTPARALLEL"
                               , ".NO_PARALLEL"
                               , ".OBJDIR"
                               , ".ORDER"
                               , ".PATH"
                               , ".PHONY"
                               , ".PRECIOUS"
                               , ".SHELL"
                               , ".SILENT"
                               , ".STALE"
                               , ".SUFFIXES"
                               ])
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "bmake_special_target" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\.PATH\\.[^:]*:"
                              , reCompiled = Just (compileRegex True "\\.PATH\\.[^:]*:")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "prereq" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ ".-include" , ".include" , ".sinclude" ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "bmake_include" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ ".error" , ".info" , ".warning" ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "bmake_message" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ ".for" ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "bmake_for_loop" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ ".endfor" ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\.[^.][^:]*:"
                              , reCompiled = Just (compileRegex True "\\.[^.][^:]*:")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Just 0
                      , rContextSwitch = [ Push ( "Makefile" , "prereq" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[^:]*:"
                              , reCompiled = Just (compileRegex True "[^:]*:")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Just 0
                      , rContextSwitch = [ Push ( "Makefile" , "prereq" ) ]
                      }
                  , Rule
                      { rMatcher = DetectIdentifier
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "string\"" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "string'" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' '#'
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' '\\'
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = AnyChar "@-"
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "silent" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "prereq"
          , Context
              { cName = "prereq"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ ".EXEC"
                               , ".IGNORE"
                               , ".MADE"
                               , ".MAKE"
                               , ".META"
                               , ".NOMETA"
                               , ".NOMETA_CMP"
                               , ".NOPATH"
                               , ".NOTMAIN"
                               , ".OPTIONAL"
                               , ".PHONY"
                               , ".PRECIOUS"
                               , ".RECURSIVE"
                               , ".SILENT"
                               , ".USE"
                               , ".USEBEFORE"
                               , ".WAIT"
                               ])
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectIdentifier
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = LineContinue
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' '#'
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' '\\'
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "Comment" ) ]
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Push ( "Makefile" , "rule" ) ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "rule"
          , Context
              { cName = "rule"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = " +"
                              , reCompiled = Just (compileRegex True " +")
                              , reCaseSensitive = True
                              }
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Just 0
                      , rContextSwitch = [ Pop , Pop , Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[^\\t]"
                              , reCompiled = Just (compileRegex True "[^\\t]")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = True
                      , rFirstNonspace = True
                      , rColumn = Just 0
                      , rContextSwitch = [ Pop , Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectIdentifier
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "string\"" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "string'" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' '#'
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' '\\'
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = AnyChar "@-"
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "silent" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "Comment" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "silent"
          , Context
              { cName = "silent"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectIdentifier
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "string\"" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "string'" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' '#'
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '\\' '\\'
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "Comment" ) ]
                      }
                  ]
              , cAttribute = FunctionTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "string\""
          , Context
              { cName = "string\""
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "string'"
          , Context
              { cName = "string'"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "strings_and_vars"
          , Context
              { cName = "strings_and_vars"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "string\"" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "string'" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "Comment" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "value"
          , Context
              { cName = "value"
              , cSyntax = "Makefile"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '$'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Makefile" , "dollar" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "@[-_\\d\\w]*@"
                              , reCompiled = Just (compileRegex True "@[-_\\d\\w]*@")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar ';'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop , Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Per Wigren (wigren@home.se)"
  , sVersion = "4"
  , sLicense = ""
  , sExtensions =
      [ "GNUmakefile"
      , "Makefile"
      , "makefile"
      , "GNUmakefile.*"
      , "Makefile.*"
      , "makefile.*"
      , "*.mk"
      ]
  , sStartingContext = "normal"
  }
