{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.M4 (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "GNU M4"
  , sFilename = "m4.xml"
  , sShortname = "M4"
  , sContexts =
      fromList
        [ ( "Normal Text"
          , Context
              { cName = "Normal Text"
              , cSyntax = "GNU M4"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "__file__"
                               , "__line__"
                               , "__program__"
                               , "builtin"
                               , "changecom"
                               , "changequote"
                               , "changeword"
                               , "debugfile"
                               , "debugmode"
                               , "decr"
                               , "define"
                               , "defn"
                               , "divert"
                               , "divnum"
                               , "dnl"
                               , "dumpdef"
                               , "errprint"
                               , "esyscmd"
                               , "eval"
                               , "format"
                               , "ifdef"
                               , "ifelse"
                               , "include"
                               , "incr"
                               , "index"
                               , "indir"
                               , "len"
                               , "m4exit"
                               , "m4wrap"
                               , "maketemp"
                               , "mkstemp"
                               , "patsubst"
                               , "popdef"
                               , "pushdef"
                               , "regexp"
                               , "shift"
                               , "sinclude"
                               , "substr"
                               , "syscmd"
                               , "sysval"
                               , "traceoff"
                               , "traceon"
                               , "translit"
                               , "undefine"
                               , "undivert"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "m4___file__"
                               , "m4___line__"
                               , "m4___program__"
                               , "m4_builtin"
                               , "m4_changecom"
                               , "m4_changequote"
                               , "m4_changeword"
                               , "m4_debugfile"
                               , "m4_debugmode"
                               , "m4_decr"
                               , "m4_define"
                               , "m4_defn"
                               , "m4_divert"
                               , "m4_divnum"
                               , "m4_dnl"
                               , "m4_dumpdef"
                               , "m4_errprint"
                               , "m4_esyscmd"
                               , "m4_eval"
                               , "m4_format"
                               , "m4_ifdef"
                               , "m4_ifelse"
                               , "m4_include"
                               , "m4_incr"
                               , "m4_index"
                               , "m4_indir"
                               , "m4_len"
                               , "m4_m4exit"
                               , "m4_m4wrap"
                               , "m4_maketemp"
                               , "m4_mkstemp"
                               , "m4_patsubst"
                               , "m4_popdef"
                               , "m4_pushdef"
                               , "m4_regexp"
                               , "m4_shift"
                               , "m4_sinclude"
                               , "m4_substr"
                               , "m4_syscmd"
                               , "m4_sysval"
                               , "m4_traceoff"
                               , "m4_traceon"
                               , "m4_translit"
                               , "m4_undefine"
                               , "m4_undivert"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "__gnu__"
                               , "__os2__"
                               , "__unix__"
                               , "__windows__"
                               , "os2"
                               , "unix"
                               , "windows"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "m4___gnu__"
                               , "m4___os2__"
                               , "m4___unix__"
                               , "m4___windows__"
                               , "m4_os2"
                               , "m4_unix"
                               , "m4_windows"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[a-zA-Z_]\\w+"
                              , reCompiled = Just (compileRegex True "[a-zA-Z_]\\w+")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\$([1-9]\\d*|0|\\#|\\*|\\@|\\{([1-9]\\d*|0)\\})"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\$([1-9]\\d*|0|\\#|\\*|\\@|\\{([1-9]\\d*|0)\\})")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "([1-9]\\d*|0|0x[0-9abcdefABCDEF]+)"
                              , reCompiled =
                                  Just (compileRegex True "([1-9]\\d*|0|0x[0-9abcdefABCDEF]+)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "#.*$"
                              , reCompiled = Just (compileRegex True "#.*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar ','
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '('
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "GNU M4" , "inparenthesis" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar ')'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[+*/%\\|=\\!<>!^&~-]"
                              , reCompiled = Just (compileRegex True "[+*/%\\|=\\!<>!^&~-]")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "inparenthesis"
          , Context
              { cName = "inparenthesis"
              , cSyntax = "GNU M4"
              , cRules =
                  [ Rule
                      { rMatcher = IncludeRules ( "GNU M4" , "Normal Text" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Jaak Ristioja"
  , sVersion = "2"
  , sLicense = "New BSD License"
  , sExtensions = [ "*.m4" ]
  , sStartingContext = "Normal Text"
  }
