{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Lua (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "Lua"
  , sFilename = "lua.xml"
  , sShortname = "Lua"
  , sContexts =
      fromList
        [ ( "Block Comment"
          , Context
              { cName = "Block Comment"
              , cSyntax = "Lua"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\]%1\\]"
                              , reCompiled = Nothing
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '-' '-'
                      , rAttribute = AlertTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !\"%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ "FIXME" , "NOTE" , "TODO" ])
                      , rAttribute = AlertTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = True
              }
          )
        , ( "Comment"
          , Context
              { cName = "Comment"
              , cSyntax = "Lua"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '-' '-'
                      , rAttribute = AlertTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !\"%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ "FIXME" , "NOTE" , "TODO" ])
                      , rAttribute = AlertTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Error"
          , Context
              { cName = "Error"
              , cSyntax = "Lua"
              , cRules = []
              , cAttribute = ErrorTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Normal"
          , Context
              { cName = "Normal"
              , cSyntax = "Lua"
              , cRules =
                  [ Rule
                      { rMatcher = IncludeRules ( "DoxygenLua" , "" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !\"%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "foreach" , "foreachi" , "table.foreach" , "table.foreachi" ])
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "--\\[(=*)\\["
                              , reCompiled = Nothing
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Lua" , "Block Comment" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '-' '-'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Lua" , "Comment" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\[(=*)\\["
                              , reCompiled = Nothing
                              , reCaseSensitive = True
                              }
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Lua" , "String_block" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Lua" , "String_single" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Lua" , "String_double" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !\"%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "LUA_PATH"
                               , "_ALERT"
                               , "_ERRORMESSAGE"
                               , "_LOADED"
                               , "_VERSION"
                               , "abs"
                               , "acos"
                               , "appendto"
                               , "ascii"
                               , "asin"
                               , "assert"
                               , "atan"
                               , "atan2"
                               , "call"
                               , "ceil"
                               , "cgilua"
                               , "cgilua.addclosefunction"
                               , "cgilua.addopenfunction"
                               , "cgilua.addscripthandler"
                               , "cgilua.buildprocesshandler"
                               , "cgilua.contentheader"
                               , "cgilua.cookies"
                               , "cgilua.cookies.delete"
                               , "cgilua.cookies.get"
                               , "cgilua.cookies.set"
                               , "cgilua.cookies.sethtml"
                               , "cgilua.doif"
                               , "cgilua.doscript"
                               , "cgilua.errorlog"
                               , "cgilua.handlelp"
                               , "cgilua.header"
                               , "cgilua.htmlheader"
                               , "cgilua.lp.compile"
                               , "cgilua.lp.include"
                               , "cgilua.lp.setcompatmode"
                               , "cgilua.lp.setoutfunc"
                               , "cgilua.lp.translate"
                               , "cgilua.mkabsoluteurl"
                               , "cgilua.mkurlpath"
                               , "cgilua.pack"
                               , "cgilua.put"
                               , "cgilua.redirect"
                               , "cgilua.script_file"
                               , "cgilua.script_path"
                               , "cgilua.script_pdir"
                               , "cgilua.script_vdir"
                               , "cgilua.script_vpath"
                               , "cgilua.serialize"
                               , "cgilua.servervariable"
                               , "cgilua.session"
                               , "cgilua.session.close"
                               , "cgilua.session.data"
                               , "cgilua.session.delete"
                               , "cgilua.session.load"
                               , "cgilua.session.new"
                               , "cgilua.session.open"
                               , "cgilua.session.save"
                               , "cgilua.session.setsessiondir"
                               , "cgilua.seterrorhandler"
                               , "cgilua.seterroroutput"
                               , "cgilua.setmaxfilesize"
                               , "cgilua.setmaxinput"
                               , "cgilua.setoutfunc"
                               , "cgilua.splitpath"
                               , "cgilua.urlcode.encodetable"
                               , "cgilua.urlcode.escape"
                               , "cgilua.urlcode.insertfield"
                               , "cgilua.urlcode.parsequery"
                               , "cgilua.urlcode.unescape"
                               , "cgilua.urlpath"
                               , "clock"
                               , "close"
                               , "closefile"
                               , "collectgarbage"
                               , "commit"
                               , "connect"
                               , "copytagmethods"
                               , "cos"
                               , "date"
                               , "debug.gethook"
                               , "debug.getinfo"
                               , "debug.getlocal"
                               , "debug.sethook"
                               , "debug.setlocal"
                               , "deg"
                               , "dofile"
                               , "dostring"
                               , "error"
                               , "execute"
                               , "exit"
                               , "exp"
                               , "fetch"
                               , "files"
                               , "floor"
                               , "flush"
                               , "foreach"
                               , "foreachi"
                               , "format"
                               , "frexp"
                               , "gcinfo"
                               , "getcolnames"
                               , "getcoltypes"
                               , "getenv"
                               , "getglobal"
                               , "getglobals"
                               , "getinfo"
                               , "getlocal"
                               , "getmetatable"
                               , "getn"
                               , "gettagmethod"
                               , "globals"
                               , "gsub"
                               , "io.close"
                               , "io.flush"
                               , "io.input"
                               , "io.lines"
                               , "io.open"
                               , "io.output"
                               , "io.read"
                               , "io.stderr"
                               , "io.stdin"
                               , "io.stdout"
                               , "io.tmpfile"
                               , "io.write"
                               , "ipairs"
                               , "ldexp"
                               , "lfs"
                               , "lfs.attributes"
                               , "lfs.chdir"
                               , "lfs.currentdir"
                               , "lfs.dir"
                               , "lfs.lock"
                               , "lfs.mkdir"
                               , "lfs.rmdir"
                               , "lfs.touch"
                               , "lfs.unlock"
                               , "lines"
                               , "loadfile"
                               , "loadstring"
                               , "log"
                               , "log10"
                               , "math.abs"
                               , "math.acos"
                               , "math.asin"
                               , "math.atan"
                               , "math.atan2"
                               , "math.ceil"
                               , "math.cos"
                               , "math.deg"
                               , "math.exp"
                               , "math.floor"
                               , "math.frexp"
                               , "math.ldexp"
                               , "math.log"
                               , "math.log10"
                               , "math.max"
                               , "math.min"
                               , "math.mod"
                               , "math.rad"
                               , "math.random"
                               , "math.randomseed"
                               , "math.sin"
                               , "math.squrt"
                               , "math.tan"
                               , "max"
                               , "min"
                               , "mod"
                               , "newtag"
                               , "next"
                               , "numrows"
                               , "openfile"
                               , "os.clock"
                               , "os.date"
                               , "os.difftime"
                               , "os.execute"
                               , "os.exit"
                               , "os.getenv"
                               , "os.remove"
                               , "os.rename"
                               , "os.setlocale"
                               , "os.time"
                               , "os.tmpname"
                               , "pairs"
                               , "pcall"
                               , "print"
                               , "rad"
                               , "random"
                               , "randomseed"
                               , "rawget"
                               , "rawset"
                               , "read"
                               , "readfrom"
                               , "remove"
                               , "rename"
                               , "require"
                               , "rollback"
                               , "seek"
                               , "setautocommit"
                               , "setcallhook"
                               , "setglobal"
                               , "setglobals"
                               , "setlinehook"
                               , "setlocal"
                               , "setlocale"
                               , "setmetatable"
                               , "settag"
                               , "settagmethod"
                               , "sin"
                               , "sort"
                               , "squrt"
                               , "strbyte"
                               , "strchar"
                               , "strfind"
                               , "string.byte"
                               , "string.char"
                               , "string.find"
                               , "string.format"
                               , "string.gfind"
                               , "string.gsub"
                               , "string.len"
                               , "string.lower"
                               , "string.rep"
                               , "string.sub"
                               , "string.upper"
                               , "strlen"
                               , "strlower"
                               , "strrep"
                               , "strsub"
                               , "strupper"
                               , "table.concat"
                               , "table.foreach"
                               , "table.foreachi"
                               , "table.getn"
                               , "table.insert"
                               , "table.remove"
                               , "table.setn"
                               , "table.sort"
                               , "tag"
                               , "tan"
                               , "tinsert"
                               , "tmpname"
                               , "tonumber"
                               , "tostring"
                               , "tremove"
                               , "type"
                               , "unpack"
                               , "write"
                               , "writeto"
                               , "zip"
                               , "zip.open"
                               , "zip.openfile"
                               ])
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bfunction\\b"
                              , reCompiled = Just (compileRegex True "\\bfunction\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !\"%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True [ "and" , "function" , "in" , "local" , "not" , "or" ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !\"%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ "false" , "nil" , "true" ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\belse\\b"
                              , reCompiled = Just (compileRegex True "\\belse\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\belseif\\b"
                              , reCompiled = Just (compileRegex True "\\belseif\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bdo\\b"
                              , reCompiled = Just (compileRegex True "\\bdo\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bif\\b"
                              , reCompiled = Just (compileRegex True "\\bif\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bend\\b"
                              , reCompiled = Just (compileRegex True "\\bend\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !\"%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "break"
                               , "do"
                               , "else"
                               , "elseif"
                               , "end"
                               , "for"
                               , "if"
                               , "repeat"
                               , "return"
                               , "then"
                               , "until"
                               , "while"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '{'
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b\\d*\\.?\\d*(e|e\\-|e\\+)?\\d+\\b"
                              , reCompiled =
                                  Just (compileRegex True "\\b\\d*\\.?\\d*(e|e\\-|e\\+)?\\d+\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b-?0[xX][0-9a-fA-F]+\\b"
                              , reCompiled = Just (compileRegex True "\\b-?0[xX][0-9a-fA-F]+\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b[a-zA-Z_][a-zA-Z0-9_]*(?=\\s*([({'\"]|\\[\\[))\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\b[a-zA-Z_][a-zA-Z0-9_]*(?=\\s*([({'\"]|\\[\\[))\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b[A-Z_][A-Z0-9_]*\\b"
                              , reCompiled = Just (compileRegex True "\\b[A-Z_][A-Z0-9_]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b[a-zA-Z_][a-zA-Z0-9_]*\\b"
                              , reCompiled =
                                  Just (compileRegex True "\\b[a-zA-Z_][a-zA-Z0-9_]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '!' '='
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '-' '='
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '+' '='
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '+' '+'
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '.' '='
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = AnyChar "[]().,=~+-*/^><#;"
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "String_block"
          , Context
              { cName = "String_block"
              , cSyntax = "Lua"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\\\(a|b|f|n|r|t|v|\\\\|\"|\\'|[|])"
                              , reCompiled =
                                  Just (compileRegex True "\\\\(a|b|f|n|r|t|v|\\\\|\"|\\'|[|])")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\]%1\\]"
                              , reCompiled = Nothing
                              , reCaseSensitive = True
                              }
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = True
              }
          )
        , ( "String_double"
          , Context
              { cName = "String_double"
              , cSyntax = "Lua"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\\\[abfnrtv'\"\\\\\\[\\]]"
                              , reCompiled =
                                  Just (compileRegex True "\\\\[abfnrtv'\"\\\\\\[\\]]")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Push ( "Lua" , "Error" ) ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "String_single"
          , Context
              { cName = "String_single"
              , cSyntax = "Lua"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\\\(a|b|f|n|r|t|v|\\\\|\"|\\'|[|])"
                              , reCompiled =
                                  Just (compileRegex True "\\\\(a|b|f|n|r|t|v|\\\\|\"|\\'|[|])")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Push ( "Lua" , "Error" ) ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = ""
  , sVersion = "2"
  , sLicense = ""
  , sExtensions = [ "*.lua" ]
  , sStartingContext = "Normal"
  }
