{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Llvm (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "LLVM"
  , sFilename = "llvm.xml"
  , sShortname = "Llvm"
  , sContexts =
      fromList
        [ ( "comment"
          , Context
              { cName = "comment"
              , cSyntax = "LLVM"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Alerts" , "" )
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectIdentifier
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "llvm"
          , Context
              { cName = "llvm"
              , cSyntax = "LLVM"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = AnyChar "@%"
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "LLVM" , "symbol" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '{'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar ';'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "LLVM" , "comment" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "LLVM" , "string" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "i[0-9]+"
                              , reCompiled = Just (compileRegex True "i[0-9]+")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[-a-zA-Z$._][-a-zA-Z$._0-9]*:"
                              , reCompiled =
                                  Just (compileRegex True "[-a-zA-Z$._][-a-zA-Z$._0-9]*:")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "alias"
                               , "align"
                               , "alignstack"
                               , "asm"
                               , "begin"
                               , "blockaddress"
                               , "constant"
                               , "datalayout"
                               , "declare"
                               , "define"
                               , "end"
                               , "false"
                               , "gc"
                               , "global"
                               , "inbounds"
                               , "module"
                               , "nsw"
                               , "null"
                               , "nuw"
                               , "sideeffect"
                               , "tail"
                               , "target"
                               , "to"
                               , "triple"
                               , "true"
                               , "type"
                               , "undef"
                               , "unwind"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "appending"
                               , "available_externally"
                               , "common"
                               , "dllexport"
                               , "dllimport"
                               , "extern_weak"
                               , "internal"
                               , "linkonce"
                               , "linkonce_odr"
                               , "private"
                               , "weak"
                               , "weak_odr"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ "cc" , "ccc" , "coldcc" , "fastcc" ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ "default" , "hidden" , "protected" ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "byval"
                               , "inreg"
                               , "nest"
                               , "noalias"
                               , "nocapture"
                               , "signext"
                               , "sret"
                               , "zeroext"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "alignstack"
                               , "alwaysinline"
                               , "inlinehint"
                               , "naked"
                               , "noimplicitfloat"
                               , "noinline"
                               , "noredzone"
                               , "noreturn"
                               , "nounwind"
                               , "optnone"
                               , "optsize"
                               , "readnone"
                               , "readonly"
                               , "ssp"
                               , "sspreq"
                               , "sspstrong"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "double"
                               , "float"
                               , "fp128"
                               , "label"
                               , "metadata"
                               , "opaque"
                               , "ppc_fp128"
                               , "void"
                               , "x86_fp80"
                               , "x86mmx"
                               ])
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "llvm.compiler.used"
                               , "llvm.global_ctors"
                               , "llvm.global_dtors"
                               , "llvm.used"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "add"
                               , "addrspacecast"
                               , "alloca"
                               , "and"
                               , "ashr"
                               , "bitcast"
                               , "br"
                               , "call"
                               , "extractelement"
                               , "extractvalue"
                               , "fadd"
                               , "fcmp"
                               , "fdiv"
                               , "fmul"
                               , "fpext"
                               , "fptosi"
                               , "fptoui"
                               , "fptrunc"
                               , "frem"
                               , "fsub"
                               , "getelementptr"
                               , "icmp"
                               , "indirectbr"
                               , "insertelement"
                               , "insertvalue"
                               , "inttoptr"
                               , "invoke"
                               , "load"
                               , "lshr"
                               , "mul"
                               , "or"
                               , "phi"
                               , "ptrtoint"
                               , "ret"
                               , "sdiv"
                               , "select"
                               , "sext"
                               , "shl"
                               , "shufflevector"
                               , "sitofp"
                               , "srem"
                               , "store"
                               , "sub"
                               , "switch"
                               , "trunc"
                               , "udiv"
                               , "uitofp"
                               , "unreachable"
                               , "unwind"
                               , "urem"
                               , "va_arg"
                               , "xor"
                               , "zext"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-/:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "eq"
                               , "ne"
                               , "oeq"
                               , "oge"
                               , "ogt"
                               , "ole"
                               , "olt"
                               , "one"
                               , "ord"
                               , "sge"
                               , "sgt"
                               , "sle"
                               , "slt"
                               , "ueq"
                               , "uge"
                               , "ugt"
                               , "ule"
                               , "ult"
                               , "une"
                               , "uno"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "string"
          , Context
              { cName = "string"
              , cSyntax = "LLVM"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "symbol"
          , Context
              { cName = "symbol"
              , cSyntax = "LLVM"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "LLVM" , "symbol-string" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "([-a-zA-Z$._][-a-zA-Z$._0-9]*|[0-9]+)"
                              , reCompiled =
                                  Just (compileRegex True "([-a-zA-Z$._][-a-zA-Z$._0-9]*|[0-9]+)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = FunctionTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "symbol-string"
          , Context
              { cName = "symbol-string"
              , cSyntax = "LLVM"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  ]
              , cAttribute = FunctionTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "LLVM Team"
  , sVersion = "1.00"
  , sLicense = "LLVM Release License"
  , sExtensions = [ "*.ll" ]
  , sStartingContext = "llvm"
  }
