{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Eiffel (syntax) where

import Skylighting.Types
import Data.Map
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "Eiffel"
  , sFilename = "eiffel.xml"
  , sShortname = "Eiffel"
  , sContexts =
      fromList
        [ ( "Documentation"
          , Context
              { cName = "Documentation"
              , cSyntax = "Eiffel"
              , cRules = []
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Normal"
          , Context
              { cName = "Normal"
              , cSyntax = "Eiffel"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "agent"
                               , "alias"
                               , "all"
                               , "and"
                               , "as"
                               , "assign"
                               , "class"
                               , "convert"
                               , "create"
                               , "creation"
                               , "debug"
                               , "deferred"
                               , "do"
                               , "else"
                               , "elseif"
                               , "end"
                               , "expanded"
                               , "export"
                               , "external"
                               , "feature"
                               , "from"
                               , "frozen"
                               , "if"
                               , "implies"
                               , "indexing"
                               , "infix"
                               , "inherit"
                               , "inspect"
                               , "is"
                               , "like"
                               , "local"
                               , "loop"
                               , "not"
                               , "obsolete"
                               , "old"
                               , "once"
                               , "or"
                               , "prefix"
                               , "pure"
                               , "redefine"
                               , "reference"
                               , "rename"
                               , "rescue"
                               , "retry"
                               , "separate"
                               , "then"
                               , "undefine"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "Current"
                               , "False"
                               , "Precursor"
                               , "Result"
                               , "TUPLE"
                               , "True"
                               ])
                      , rAttribute = ConstantTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True [ "check" , "ensure" , "invariant" , "require" , "variant" ])
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Float
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCChar
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Eiffel" , "Quoted String" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '-' '-'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Eiffel" , "Documentation" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Quoted String"
          , Context
              { cName = "Quoted String"
              , cSyntax = "Eiffel"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Sebastian Vuorinen"
  , sVersion = "2"
  , sLicense = ""
  , sExtensions = [ "*.e" ]
  , sStartingContext = "Normal"
  }
