{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Doxygenlua (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "DoxygenLua"
  , sFilename = "doxygenlua.xml"
  , sShortname = "Doxygenlua"
  , sContexts =
      fromList
        [ ( "BlockComment"
          , Context
              { cName = "BlockComment"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\]%1\\]"
                              , reCompiled = Nothing
                              , reCaseSensitive = True
                              }
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Alerts" , "" )
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '@' '{'
                      , rAttribute = RegionMarkerTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '@' '}'
                      , rAttribute = RegionMarkerTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[]^{|}"
                              }
                            (makeWordSet
                               False
                               [ "@#"
                               , "@$"
                               , "@@"
                               , "@\\"
                               , "@arg"
                               , "@attention"
                               , "@author"
                               , "@callgraph"
                               , "@code"
                               , "@dot"
                               , "@else"
                               , "@endcode"
                               , "@endcond"
                               , "@enddot"
                               , "@endhtmlonly"
                               , "@endif"
                               , "@endlatexonly"
                               , "@endlink"
                               , "@endmanonly"
                               , "@endverbatim"
                               , "@endxmlonly"
                               , "@f$"
                               , "@f["
                               , "@f]"
                               , "@hideinitializer"
                               , "@htmlonly"
                               , "@interface"
                               , "@internal"
                               , "@invariant"
                               , "@latexonly"
                               , "@li"
                               , "@manonly"
                               , "@n"
                               , "@nosubgrouping"
                               , "@note"
                               , "@only"
                               , "@post"
                               , "@pre"
                               , "@remarks"
                               , "@return"
                               , "@returns"
                               , "@sa"
                               , "@see"
                               , "@showinitializer"
                               , "@since"
                               , "@test"
                               , "@todo"
                               , "@verbatim"
                               , "@warning"
                               , "@xmlonly"
                               , "@~"
                               , "\\#"
                               , "\\$"
                               , "\\@"
                               , "\\\\"
                               , "\\arg"
                               , "\\attention"
                               , "\\author"
                               , "\\callgraph"
                               , "\\code"
                               , "\\dot"
                               , "\\else"
                               , "\\endcode"
                               , "\\endcond"
                               , "\\enddot"
                               , "\\endhtmlonly"
                               , "\\endif"
                               , "\\endlatexonly"
                               , "\\endlink"
                               , "\\endmanonly"
                               , "\\endverbatim"
                               , "\\endxmlonly"
                               , "\\f$"
                               , "\\f["
                               , "\\f]"
                               , "\\hideinitializer"
                               , "\\htmlonly"
                               , "\\interface"
                               , "\\internal"
                               , "\\invariant"
                               , "\\latexonly"
                               , "\\li"
                               , "\\manonly"
                               , "\\n"
                               , "\\nosubgrouping"
                               , "\\note"
                               , "\\only"
                               , "\\post"
                               , "\\pre"
                               , "\\remarks"
                               , "\\return"
                               , "\\returns"
                               , "\\sa"
                               , "\\see"
                               , "\\showinitializer"
                               , "\\since"
                               , "\\test"
                               , "\\todo"
                               , "\\verbatim"
                               , "\\warning"
                               , "\\xmlonly"
                               , "\\~"
                               ])
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[]^{|}"
                              }
                            (makeWordSet
                               False
                               [ "@a"
                               , "@addtogroup"
                               , "@anchor"
                               , "@b"
                               , "@c"
                               , "@class"
                               , "@cond"
                               , "@copydoc"
                               , "@def"
                               , "@dontinclude"
                               , "@dotfile"
                               , "@e"
                               , "@elseif"
                               , "@em"
                               , "@enum"
                               , "@example"
                               , "@exception"
                               , "@exceptions"
                               , "@file"
                               , "@htmlinclude"
                               , "@if"
                               , "@ifnot"
                               , "@include"
                               , "@link"
                               , "@namespace"
                               , "@p"
                               , "@package"
                               , "@ref"
                               , "@relates"
                               , "@relatesalso"
                               , "@retval"
                               , "@throw"
                               , "@throws"
                               , "@verbinclude"
                               , "@version"
                               , "@xrefitem"
                               , "\\a"
                               , "\\addtogroup"
                               , "\\anchor"
                               , "\\b"
                               , "\\c"
                               , "\\class"
                               , "\\cond"
                               , "\\copydoc"
                               , "\\def"
                               , "\\dontinclude"
                               , "\\dotfile"
                               , "\\e"
                               , "\\elseif"
                               , "\\em"
                               , "\\enum"
                               , "\\example"
                               , "\\exception"
                               , "\\exceptions"
                               , "\\file"
                               , "\\htmlinclude"
                               , "\\if"
                               , "\\ifnot"
                               , "\\include"
                               , "\\link"
                               , "\\namespace"
                               , "\\p"
                               , "\\package"
                               , "\\ref"
                               , "\\relates"
                               , "\\relatesalso"
                               , "\\retval"
                               , "\\throw"
                               , "\\throws"
                               , "\\verbinclude"
                               , "\\version"
                               , "\\xrefitem"
                               ])
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_TagWord" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[]^{|}"
                              }
                            (makeWordSet False [ "@param" , "\\param" ])
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_TagParam" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[]^{|}"
                              }
                            (makeWordSet False [ "@image" , "\\image" ])
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_TagWordWord" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[]^{|}"
                              }
                            (makeWordSet
                               False
                               [ "@addindex"
                               , "@brief"
                               , "@bug"
                               , "@date"
                               , "@deprecated"
                               , "@fn"
                               , "@ingroup"
                               , "@line"
                               , "@mainpage"
                               , "@name"
                               , "@overload"
                               , "@par"
                               , "@short"
                               , "@skip"
                               , "@skipline"
                               , "@typedef"
                               , "@until"
                               , "@var"
                               , "\\addindex"
                               , "\\brief"
                               , "\\bug"
                               , "\\date"
                               , "\\deprecated"
                               , "\\fn"
                               , "\\ingroup"
                               , "\\line"
                               , "\\mainpage"
                               , "\\name"
                               , "\\overload"
                               , "\\par"
                               , "\\short"
                               , "\\skip"
                               , "\\skipline"
                               , "\\typedef"
                               , "\\until"
                               , "\\var"
                               ])
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_TagString" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[]^{|}"
                              }
                            (makeWordSet
                               False
                               [ "@defgroup"
                               , "@page"
                               , "@paragraph"
                               , "@section"
                               , "@struct"
                               , "@subsection"
                               , "@subsubsection"
                               , "@union"
                               , "@weakgroup"
                               , "\\defgroup"
                               , "\\page"
                               , "\\paragraph"
                               , "\\section"
                               , "\\struct"
                               , "\\subsection"
                               , "\\subsubsection"
                               , "\\union"
                               , "\\weakgroup"
                               ])
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_TagWordString" ) ]
                      }
                  , Rule
                      { rMatcher = DetectIdentifier
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\\\(<|>)"
                              , reCompiled = Just (compileRegex True "\\\\(<|>)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '<' '<'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "<\\s*\\/?\\s*[a-zA-Z_:][a-zA-Z0-9._:-]*"
                              , reCompiled =
                                  Just (compileRegex True "<\\s*\\/?\\s*[a-zA-Z_:][a-zA-Z0-9._:-]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_htmltag" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "<!--"
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_htmlcomment" ) ]
                      }
                  ]
              , cAttribute = DocumentationTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = True
              }
          )
        , ( "LineComment"
          , Context
              { cName = "LineComment"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Alerts" , "" )
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[]^{|}"
                              }
                            (makeWordSet
                               False
                               [ "@#"
                               , "@$"
                               , "@@"
                               , "@\\"
                               , "@arg"
                               , "@attention"
                               , "@author"
                               , "@callgraph"
                               , "@code"
                               , "@dot"
                               , "@else"
                               , "@endcode"
                               , "@endcond"
                               , "@enddot"
                               , "@endhtmlonly"
                               , "@endif"
                               , "@endlatexonly"
                               , "@endlink"
                               , "@endmanonly"
                               , "@endverbatim"
                               , "@endxmlonly"
                               , "@f$"
                               , "@f["
                               , "@f]"
                               , "@hideinitializer"
                               , "@htmlonly"
                               , "@interface"
                               , "@internal"
                               , "@invariant"
                               , "@latexonly"
                               , "@li"
                               , "@manonly"
                               , "@n"
                               , "@nosubgrouping"
                               , "@note"
                               , "@only"
                               , "@post"
                               , "@pre"
                               , "@remarks"
                               , "@return"
                               , "@returns"
                               , "@sa"
                               , "@see"
                               , "@showinitializer"
                               , "@since"
                               , "@test"
                               , "@todo"
                               , "@verbatim"
                               , "@warning"
                               , "@xmlonly"
                               , "@~"
                               , "\\#"
                               , "\\$"
                               , "\\@"
                               , "\\\\"
                               , "\\arg"
                               , "\\attention"
                               , "\\author"
                               , "\\callgraph"
                               , "\\code"
                               , "\\dot"
                               , "\\else"
                               , "\\endcode"
                               , "\\endcond"
                               , "\\enddot"
                               , "\\endhtmlonly"
                               , "\\endif"
                               , "\\endlatexonly"
                               , "\\endlink"
                               , "\\endmanonly"
                               , "\\endverbatim"
                               , "\\endxmlonly"
                               , "\\f$"
                               , "\\f["
                               , "\\f]"
                               , "\\hideinitializer"
                               , "\\htmlonly"
                               , "\\interface"
                               , "\\internal"
                               , "\\invariant"
                               , "\\latexonly"
                               , "\\li"
                               , "\\manonly"
                               , "\\n"
                               , "\\nosubgrouping"
                               , "\\note"
                               , "\\only"
                               , "\\post"
                               , "\\pre"
                               , "\\remarks"
                               , "\\return"
                               , "\\returns"
                               , "\\sa"
                               , "\\see"
                               , "\\showinitializer"
                               , "\\since"
                               , "\\test"
                               , "\\todo"
                               , "\\verbatim"
                               , "\\warning"
                               , "\\xmlonly"
                               , "\\~"
                               ])
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[]^{|}"
                              }
                            (makeWordSet
                               False
                               [ "@a"
                               , "@addtogroup"
                               , "@anchor"
                               , "@b"
                               , "@c"
                               , "@class"
                               , "@cond"
                               , "@copydoc"
                               , "@def"
                               , "@dontinclude"
                               , "@dotfile"
                               , "@e"
                               , "@elseif"
                               , "@em"
                               , "@enum"
                               , "@example"
                               , "@exception"
                               , "@exceptions"
                               , "@file"
                               , "@htmlinclude"
                               , "@if"
                               , "@ifnot"
                               , "@include"
                               , "@link"
                               , "@namespace"
                               , "@p"
                               , "@package"
                               , "@ref"
                               , "@relates"
                               , "@relatesalso"
                               , "@retval"
                               , "@throw"
                               , "@throws"
                               , "@verbinclude"
                               , "@version"
                               , "@xrefitem"
                               , "\\a"
                               , "\\addtogroup"
                               , "\\anchor"
                               , "\\b"
                               , "\\c"
                               , "\\class"
                               , "\\cond"
                               , "\\copydoc"
                               , "\\def"
                               , "\\dontinclude"
                               , "\\dotfile"
                               , "\\e"
                               , "\\elseif"
                               , "\\em"
                               , "\\enum"
                               , "\\example"
                               , "\\exception"
                               , "\\exceptions"
                               , "\\file"
                               , "\\htmlinclude"
                               , "\\if"
                               , "\\ifnot"
                               , "\\include"
                               , "\\link"
                               , "\\namespace"
                               , "\\p"
                               , "\\package"
                               , "\\ref"
                               , "\\relates"
                               , "\\relatesalso"
                               , "\\retval"
                               , "\\throw"
                               , "\\throws"
                               , "\\verbinclude"
                               , "\\version"
                               , "\\xrefitem"
                               ])
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_TagWord" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[]^{|}"
                              }
                            (makeWordSet False [ "@param" , "\\param" ])
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_TagParam" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[]^{|}"
                              }
                            (makeWordSet False [ "@image" , "\\image" ])
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_TagWordWord" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[]^{|}"
                              }
                            (makeWordSet
                               False
                               [ "@addindex"
                               , "@brief"
                               , "@bug"
                               , "@date"
                               , "@deprecated"
                               , "@fn"
                               , "@ingroup"
                               , "@line"
                               , "@mainpage"
                               , "@name"
                               , "@overload"
                               , "@par"
                               , "@short"
                               , "@skip"
                               , "@skipline"
                               , "@typedef"
                               , "@until"
                               , "@var"
                               , "\\addindex"
                               , "\\brief"
                               , "\\bug"
                               , "\\date"
                               , "\\deprecated"
                               , "\\fn"
                               , "\\ingroup"
                               , "\\line"
                               , "\\mainpage"
                               , "\\name"
                               , "\\overload"
                               , "\\par"
                               , "\\short"
                               , "\\skip"
                               , "\\skipline"
                               , "\\typedef"
                               , "\\until"
                               , "\\var"
                               ])
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_TagString" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[]^{|}"
                              }
                            (makeWordSet
                               False
                               [ "@defgroup"
                               , "@page"
                               , "@paragraph"
                               , "@section"
                               , "@struct"
                               , "@subsection"
                               , "@subsubsection"
                               , "@union"
                               , "@weakgroup"
                               , "\\defgroup"
                               , "\\page"
                               , "\\paragraph"
                               , "\\section"
                               , "\\struct"
                               , "\\subsection"
                               , "\\subsubsection"
                               , "\\union"
                               , "\\weakgroup"
                               ])
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_TagWordString" ) ]
                      }
                  , Rule
                      { rMatcher = DetectIdentifier
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = StringDetect "<!--"
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_htmlcomment" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '<' '<'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "<\\s*\\/?\\s*[a-zA-Z_:][a-zA-Z0-9._:-]*"
                              , reCompiled =
                                  Just (compileRegex True "<\\s*\\/?\\s*[a-zA-Z_:][a-zA-Z0-9._:-]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_htmltag" ) ]
                      }
                  ]
              , cAttribute = DocumentationTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "ML_Tag2ndWord"
          , Context
              { cName = "ML_Tag2ndWord"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = True
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "DoxygenLua" , "SL_Tag2ndWord" )
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DocumentationTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop , Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "ML_TagParam"
          , Context
              { cName = "ML_TagParam"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = True
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = StringDetect "[in]"
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_Tag2ndWord" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "[out]"
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_Tag2ndWord" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "[in,out]"
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_Tag2ndWord" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\S(?=([][,?;()]|\\.$|\\.?\\s))"
                              , reCompiled =
                                  Just (compileRegex True "\\S(?=([][,?;()]|\\.$|\\.?\\s))")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentVarTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\S"
                              , reCompiled = Just (compileRegex True "\\S")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentVarTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DocumentationTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "ML_TagString"
          , Context
              { cName = "ML_TagString"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = True
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = StringDetect "<!--"
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_htmlcomment" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '<' '<'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "<\\s*\\/?\\s*[a-zA-Z_:][a-zA-Z0-9._:-]*"
                              , reCompiled =
                                  Just (compileRegex True "<\\s*\\/?\\s*[a-zA-Z_:][a-zA-Z0-9._:-]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_htmltag" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "."
                              , reCompiled = Just (compileRegex True ".")
                              , reCaseSensitive = True
                              }
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DocumentationTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "ML_TagWord"
          , Context
              { cName = "ML_TagWord"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = True
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "DoxygenLua" , "SL_TagWord" )
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DocumentationTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "ML_TagWordString"
          , Context
              { cName = "ML_TagWordString"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = True
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "DoxygenLua" , "SL_TagWordString" )
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DocumentationTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "ML_TagWordWord"
          , Context
              { cName = "ML_TagWordWord"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = True
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\S(?=([][,?;()]|\\.$|\\.?\\s))"
                              , reCompiled =
                                  Just (compileRegex True "\\S(?=([][,?;()]|\\.$|\\.?\\s))")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentVarTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_Tag2ndWord" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\S"
                              , reCompiled = Just (compileRegex True "\\S")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentVarTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DocumentationTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "ML_htmlcomment"
          , Context
              { cName = "ML_htmlcomment"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = True
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Alerts" , "" )
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = StringDetect "-->"
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "ML_htmltag"
          , Context
              { cName = "ML_htmltag"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = True
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '/' '>'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '>'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\s*=\\s*"
                              , reCompiled = Just (compileRegex True "\\s*=\\s*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_identifiers" ) ]
                      }
                  ]
              , cAttribute = OtherTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "ML_identifiers"
          , Context
              { cName = "ML_identifiers"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = True
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\s*#?[a-zA-Z0-9]*"
                              , reCompiled = Just (compileRegex True "\\s*#?[a-zA-Z0-9]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_types1" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "ML_types2" ) ]
                      }
                  ]
              , cAttribute = OtherTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "ML_types1"
          , Context
              { cName = "ML_types1"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = True
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "ML_types2"
          , Context
              { cName = "ML_types2"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = True
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Normal"
          , Context
              { cName = "Normal"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "--\\[(=*)\\["
                              , reCompiled = Nothing
                              , reCaseSensitive = True
                              }
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "BlockComment" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "--"
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "LineComment" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "SL_Tag2ndWord"
          , Context
              { cName = "SL_Tag2ndWord"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\S(?=([][,?;()]|\\.$|\\.?\\s))"
                              , reCompiled =
                                  Just (compileRegex True "\\S(?=([][,?;()]|\\.$|\\.?\\s))")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentVarTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\S"
                              , reCompiled = Just (compileRegex True "\\S")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentVarTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DocumentationTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop , Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "SL_TagParam"
          , Context
              { cName = "SL_TagParam"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = StringDetect "[in]"
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_Tag2ndWord" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "[out]"
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_Tag2ndWord" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "[in,out]"
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_Tag2ndWord" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\S(?=([][,?;()]|\\.$|\\.?\\s))"
                              , reCompiled =
                                  Just (compileRegex True "\\S(?=([][,?;()]|\\.$|\\.?\\s))")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentVarTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\S"
                              , reCompiled = Just (compileRegex True "\\S")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentVarTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DocumentationTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "SL_TagString"
          , Context
              { cName = "SL_TagString"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = StringDetect "<!--"
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_htmlcomment" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '<' '<'
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "<\\s*\\/?\\s*[a-zA-Z_:][a-zA-Z0-9._:-]*"
                              , reCompiled =
                                  Just (compileRegex True "<\\s*\\/?\\s*[a-zA-Z_:][a-zA-Z0-9._:-]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_htmltag" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "."
                              , reCompiled = Just (compileRegex True ".")
                              , reCaseSensitive = True
                              }
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DocumentationTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "SL_TagWord"
          , Context
              { cName = "SL_TagWord"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims = Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[]^{|}"
                              }
                            (makeWordSet
                               False
                               [ "@a"
                               , "@addtogroup"
                               , "@anchor"
                               , "@b"
                               , "@c"
                               , "@class"
                               , "@cond"
                               , "@copydoc"
                               , "@def"
                               , "@dontinclude"
                               , "@dotfile"
                               , "@e"
                               , "@elseif"
                               , "@em"
                               , "@enum"
                               , "@example"
                               , "@exception"
                               , "@exceptions"
                               , "@file"
                               , "@htmlinclude"
                               , "@if"
                               , "@ifnot"
                               , "@include"
                               , "@link"
                               , "@namespace"
                               , "@p"
                               , "@package"
                               , "@ref"
                               , "@relates"
                               , "@relatesalso"
                               , "@retval"
                               , "@throw"
                               , "@throws"
                               , "@verbinclude"
                               , "@version"
                               , "@xrefitem"
                               , "\\a"
                               , "\\addtogroup"
                               , "\\anchor"
                               , "\\b"
                               , "\\c"
                               , "\\class"
                               , "\\cond"
                               , "\\copydoc"
                               , "\\def"
                               , "\\dontinclude"
                               , "\\dotfile"
                               , "\\e"
                               , "\\elseif"
                               , "\\em"
                               , "\\enum"
                               , "\\example"
                               , "\\exception"
                               , "\\exceptions"
                               , "\\file"
                               , "\\htmlinclude"
                               , "\\if"
                               , "\\ifnot"
                               , "\\include"
                               , "\\link"
                               , "\\namespace"
                               , "\\p"
                               , "\\package"
                               , "\\ref"
                               , "\\relates"
                               , "\\relatesalso"
                               , "\\retval"
                               , "\\throw"
                               , "\\throws"
                               , "\\verbinclude"
                               , "\\version"
                               , "\\xrefitem"
                               ])
                      , rAttribute = AnnotationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = True
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\S(?=([][,?;()]|\\.$|\\.?\\s))"
                              , reCompiled =
                                  Just (compileRegex True "\\S(?=([][,?;()]|\\.$|\\.?\\s))")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentVarTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\S"
                              , reCompiled = Just (compileRegex True "\\S")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentVarTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DocumentationTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "SL_TagWordString"
          , Context
              { cName = "SL_TagWordString"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\S(?=([][,?;()]|\\.$|\\.?\\s))"
                              , reCompiled =
                                  Just (compileRegex True "\\S(?=([][,?;()]|\\.$|\\.?\\s))")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentVarTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\S"
                              , reCompiled = Just (compileRegex True "\\S")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentVarTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DocumentationTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "SL_TagWordWord"
          , Context
              { cName = "SL_TagWordWord"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = DocumentationTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\S(?=([][,?;()]|\\.$|\\.?\\s))"
                              , reCompiled =
                                  Just (compileRegex True "\\S(?=([][,?;()]|\\.$|\\.?\\s))")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentVarTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_Tag2ndWord" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\S"
                              , reCompiled = Just (compileRegex True "\\S")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentVarTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = DocumentationTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "SL_htmlcomment"
          , Context
              { cName = "SL_htmlcomment"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = IncludeRules ( "Alerts" , "" )
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = StringDetect "-->"
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "SL_htmltag"
          , Context
              { cName = "SL_htmltag"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '/' '>'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '>'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\s*=\\s*"
                              , reCompiled = Just (compileRegex True "\\s*=\\s*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_identifiers" ) ]
                      }
                  ]
              , cAttribute = OtherTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "SL_identifiers"
          , Context
              { cName = "SL_identifiers"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\s*#?[a-zA-Z0-9]*"
                              , reCompiled = Just (compileRegex True "\\s*#?[a-zA-Z0-9]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_types1" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "DoxygenLua" , "SL_types2" ) ]
                      }
                  ]
              , cAttribute = OtherTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "SL_types1"
          , Context
              { cName = "SL_types1"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "SL_types2"
          , Context
              { cName = "SL_types2"
              , cSyntax = "DoxygenLua"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Bruno Massa (brmassa@gmail.com)"
  , sVersion = "3"
  , sLicense = "LGPLv2+"
  , sExtensions = [ "*.dox" , "*.doxygen" ]
  , sStartingContext = "Normal"
  }
