{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Coffee (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "CoffeeScript"
  , sFilename = "coffee.xml"
  , sShortname = "Coffee"
  , sContexts =
      fromList
        [ ( "Class"
          , Context
              { cName = "Class"
              , cSyntax = "CoffeeScript"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[@$:.\\w\\[\\]]+"
                              , reCompiled = Just (compileRegex True "[@$:.\\w\\[\\]]+")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Comment"
          , Context
              { cName = "Comment"
              , cSyntax = "CoffeeScript"
              , cRules =
                  [ Rule
                      { rMatcher = IncludeRules ( "Alerts_indent" , "" )
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Embedding"
          , Context
              { cName = "Embedding"
              , cSyntax = "CoffeeScript"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Heredoc"
          , Context
              { cName = "Heredoc"
              , cSyntax = "CoffeeScript"
              , cRules =
                  [ Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = StringDetect "'''"
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Javascript"
          , Context
              { cName = "Javascript"
              , cSyntax = "CoffeeScript"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '`'
                      , rAttribute = AlertTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "JavaScript" , "Normal" )
                      , rAttribute = AlertTok
                      , rIncludeAttribute = True
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = AlertTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Multiline Comment"
          , Context
              { cName = "Multiline Comment"
              , cSyntax = "CoffeeScript"
              , cRules =
                  [ Rule
                      { rMatcher = StringDetect "###"
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Alerts_indent" , "" )
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Multiline Regex"
          , Context
              { cName = "Multiline Regex"
              , cSyntax = "CoffeeScript"
              , cRules =
                  [ Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CoffeeScript" , "Comment" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "///[mig]{0,3}"
                              , reCompiled = Just (compileRegex True "///[mig]{0,3}")
                              , reCaseSensitive = True
                              }
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Normal"
          , Context
              { cName = "Normal"
              , cSyntax = "CoffeeScript"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Float
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCOct
                      , rAttribute = BaseNTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCHex
                      , rAttribute = BaseNTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !#%&'()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "and"
                               , "break"
                               , "by"
                               , "catch"
                               , "constructor"
                               , "continue"
                               , "delete"
                               , "do"
                               , "else"
                               , "finally"
                               , "for"
                               , "if"
                               , "in"
                               , "is"
                               , "isnt"
                               , "loop"
                               , "not"
                               , "of"
                               , "or"
                               , "return"
                               , "super"
                               , "switch"
                               , "then"
                               , "throw"
                               , "try"
                               , "typeof"
                               , "unless"
                               , "until"
                               , "when"
                               , "where"
                               , "while"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !#%&'()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ "class" , "extends" , "instanceof" , "new" ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CoffeeScript" , "Class" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !#%&'()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "Infinity"
                               , "NaN"
                               , "false"
                               , "no"
                               , "null"
                               , "off"
                               , "on"
                               , "true"
                               , "undefined"
                               , "yes"
                               ])
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !#%&'()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "__bind"
                               , "__extends"
                               , "__hasProp"
                               , "__indexOf"
                               , "__slice"
                               , "case"
                               , "const"
                               , "default"
                               , "enum"
                               , "export"
                               , "function"
                               , "import"
                               , "let"
                               , "native"
                               , "var"
                               , "void"
                               , "with"
                               ])
                      , rAttribute = AlertTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !#%&'()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "Array"
                               , "Boolean"
                               , "Date"
                               , "Function"
                               , "Math"
                               , "Number"
                               , "Object"
                               , "RegExp"
                               , "String"
                               , "clearInterval"
                               , "clearTimeout"
                               , "console"
                               , "decodeURI"
                               , "decodeURIComponent"
                               , "encodeURI"
                               , "encodeURIComponent"
                               , "escape"
                               , "eval"
                               , "isFinite"
                               , "isNaN"
                               , "parseFloat"
                               , "parseInt"
                               , "setInterval"
                               , "setTimeout"
                               , "unescape"
                               ])
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !#%&'()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "alert"
                               , "document"
                               , "history"
                               , "location"
                               , "navigator"
                               , "prompt"
                               , "screen"
                               , "window"
                               ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !#%&'()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ "GLOBAL" , "exports" , "process" , "require" ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "(@[_$a-zA-Z][$\\w]*|\\bthis)\\b"
                              , reCompiled =
                                  Just (compileRegex True "(@[_$a-zA-Z][$\\w]*|\\bthis)\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "(\\((\\'[^']*'|\"[^\"]*\"|[^()])*\\))?\\s*(-|=)>"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       False "(\\((\\'[^']*'|\"[^\"]*\"|[^()])*\\))?\\s*(-|=)>")
                              , reCaseSensitive = False
                              }
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[_$a-z][$\\w]*\\b"
                              , reCompiled = Just (compileRegex False "[_$a-z][$\\w]*\\b")
                              , reCaseSensitive = False
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = StringDetect "'''"
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CoffeeScript" , "Heredoc" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "\"\"\""
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CoffeeScript" , "Rich Heredoc" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CoffeeScript" , "String" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CoffeeScript" , "Rich String" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '`'
                      , rAttribute = AlertTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CoffeeScript" , "Javascript" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "###"
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "CoffeeScript" , "Multiline Comment" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CoffeeScript" , "Comment" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "///"
                              , reCompiled = Just (compileRegex True "///")
                              , reCaseSensitive = True
                              }
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CoffeeScript" , "Multiline Regex" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "/([^/\\\\\\r\\n]|\\\\.)*/[mig]{0,3}"
                              , reCompiled =
                                  Just (compileRegex True "/([^/\\\\\\r\\n]|\\\\.)*/[mig]{0,3}")
                              , reCaseSensitive = True
                              }
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = AnyChar "():!%&+,-/.*<=>?[]|~^;{}"
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Rich Heredoc"
          , Context
              { cName = "Rich Heredoc"
              , cSyntax = "CoffeeScript"
              , cRules =
                  [ Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '#' '{'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CoffeeScript" , "Embedding" ) ]
                      }
                  , Rule
                      { rMatcher = StringDetect "\"\"\""
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Rich String"
          , Context
              { cName = "Rich String"
              , cSyntax = "CoffeeScript"
              , cRules =
                  [ Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '#' '{'
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CoffeeScript" , "Embedding" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "String"
          , Context
              { cName = "String"
              , cSyntax = "CoffeeScript"
              , cRules =
                  [ Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '\''
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Max Shawabkeh (max99x@gmail.com)"
  , sVersion = "2"
  , sLicense = "MIT"
  , sExtensions = [ "Cakefile" , "*.coffee" , "*.coco" ]
  , sStartingContext = "Normal"
  }
