{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Cmake (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "CMake"
  , sFilename = "cmake.xml"
  , sShortname = "Cmake"
  , sContexts =
      fromList
        [ ( "Bracketed Comment"
          , Context
              { cName = "Bracketed Comment"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "#?\\]%1\\]"
                              , reCompiled = Nothing
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Just 0
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Alerts" , "" )
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Modelines" , "" )
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = True
              }
          )
        , ( "Bracketed String"
          , Context
              { cName = "Bracketed String"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\]%1\\]"
                              , reCompiled = Nothing
                              , reCaseSensitive = True
                              }
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = True
              }
          )
        , ( "Command Args"
          , Context
              { cName = "Command Args"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "AFTER"
                               , "ALIAS"
                               , "ALL"
                               , "ALPHABET"
                               , "AND"
                               , "APPEND"
                               , "APPENDNUMBER_ERRORS"
                               , "APPEND_STRING"
                               , "ARCHIVE"
                               , "ARGS"
                               , "ASCII"
                               , "AUTHOR_WARNING"
                               , "BEFORE"
                               , "BRIEF_DOCS"
                               , "BUILD"
                               , "BUNDLE"
                               , "BYPRODUCTS"
                               , "CACHE"
                               , "CACHED_VARIABLE"
                               , "CDASH_UPLOAD"
                               , "CDASH_UPLOAD_TYPE"
                               , "CLEAR"
                               , "CMAKE_FIND_ROOT_PATH_BOTH"
                               , "CMAKE_FLAGS"
                               , "CODE"
                               , "COMMAND"
                               , "COMMAND_NAME"
                               , "COMMENT"
                               , "COMPARE"
                               , "COMPILE_DEFINITIONS"
                               , "COMPILE_OUTPUT_VARIABLE"
                               , "COMPILE_RESULT_VAR"
                               , "COMPONENT"
                               , "COMPONENTS"
                               , "CONCAT"
                               , "CONDITION"
                               , "CONFIG"
                               , "CONFIGS"
                               , "CONFIGURATION"
                               , "CONFIGURATIONS"
                               , "CONFIGURE"
                               , "CONTENT"
                               , "COPY"
                               , "COPYONLY"
                               , "COPY_FILE"
                               , "COPY_FILE_ERROR"
                               , "CRLF"
                               , "DEFINED"
                               , "DEFINITION"
                               , "DEPENDS"
                               , "DESTINATION"
                               , "DIRECTORY"
                               , "DIRECTORY_PERMISSIONS"
                               , "DOC"
                               , "DOS"
                               , "DOWNLOAD"
                               , "END"
                               , "ENV"
                               , "EQUAL"
                               , "ERROR_FILE"
                               , "ERROR_QUIET"
                               , "ERROR_STRIP_TRAILING_WHITESPACE"
                               , "ERROR_VARIABLE"
                               , "ESCAPE_QUOTES"
                               , "EXACT"
                               , "EXCLUDE"
                               , "EXCLUDE_FROM_ALL"
                               , "EXCLUDE_LABEL"
                               , "EXISTS"
                               , "EXPECTED_HASH"
                               , "EXPECTED_MD5"
                               , "EXPORT"
                               , "EXPORT_LINK_INTERFACE_LIBRARIES"
                               , "EXPR"
                               , "EXTRA_INCLUDE"
                               , "FATAL_ERROR"
                               , "FILE"
                               , "FILES"
                               , "FILES_MATCHING"
                               , "FILE_PERMISSIONS"
                               , "FIND"
                               , "FLAGS"
                               , "FOLLOW_SYMLINKS"
                               , "FORCE"
                               , "FRAMEWORK"
                               , "FULL_DOCS"
                               , "FUNCTION"
                               , "GENERATE"
                               , "GENEX_STRIP"
                               , "GET"
                               , "GLOB"
                               , "GLOBAL"
                               , "GLOB_RECURSE"
                               , "GREATER"
                               , "GROUP_EXECUTE"
                               , "GROUP_READ"
                               , "GUARD"
                               , "GUID"
                               , "HEX"
                               , "HINTS"
                               , "IMPLICIT_DEPENDS"
                               , "IMPORTED"
                               , "IN"
                               , "INACTIVITY_TIMEOUT"
                               , "INCLUDE"
                               , "INCLUDES"
                               , "INCLUDE_INTERNALS"
                               , "INCLUDE_LABEL"
                               , "INHERITED"
                               , "INPUT"
                               , "INPUT_FILE"
                               , "INSERT"
                               , "INSTALL"
                               , "INTERFACE"
                               , "IS_ABSOLUTE"
                               , "IS_DIRECTORY"
                               , "IS_NEWER_THAN"
                               , "IS_SYMLINK"
                               , "ITEMS"
                               , "LABELS"
                               , "LANGUAGES"
                               , "LENGTH"
                               , "LENGTH_MAXIMUM"
                               , "LENGTH_MINIMUM"
                               , "LESS"
                               , "LF"
                               , "LIBRARY"
                               , "LIMIT"
                               , "LIMIT_COUNT"
                               , "LIMIT_INPUT"
                               , "LIMIT_OUTPUT"
                               , "LINK_INTERFACE_LIBRARIES"
                               , "LINK_LIBRARIES"
                               , "LINK_PRIVATE"
                               , "LINK_PUBLIC"
                               , "LISTS"
                               , "LIST_DIRECTORIES"
                               , "LOCK"
                               , "LOG"
                               , "MACOSX_BUNDLE"
                               , "MAIN_DEPENDENCY"
                               , "MAKE_C_IDENTIFIER"
                               , "MAKE_DIRECTORY"
                               , "MATCH"
                               , "MATCHALL"
                               , "MATCHES"
                               , "MD5"
                               , "MESSAGE_NEVER"
                               , "MODULE"
                               , "NAME"
                               , "NAMELINK_ONLY"
                               , "NAMELINK_SKIP"
                               , "NAMES"
                               , "NAMESPACE"
                               , "NAMES_PER_DIR"
                               , "NEW"
                               , "NEWLINE_CONSUME"
                               , "NEWLINE_STYLE"
                               , "NEW_PROCESS"
                               , "NOT"
                               , "NOTEQUAL"
                               , "NO_CMAKE_BUILDS_PATH"
                               , "NO_CMAKE_ENVIRONMENT_PATH"
                               , "NO_CMAKE_FIND_ROOT_PATH"
                               , "NO_CMAKE_PACKAGE_REGISTRY"
                               , "NO_CMAKE_PATH"
                               , "NO_CMAKE_SYSTEM_PACKAGE_REGISTRY"
                               , "NO_CMAKE_SYSTEM_PATH"
                               , "NO_DEFAULT_PATH"
                               , "NO_HEX_CONVERSION"
                               , "NO_MODULE"
                               , "NO_POLICY_SCOPE"
                               , "NO_SOURCE_PERMISSIONS"
                               , "NO_SYSTEM_ENVIRONMENT_PATH"
                               , "NUMBER_ERRORS"
                               , "NUMBER_WARNINGS"
                               , "OBJECT"
                               , "OFF"
                               , "OFFSET"
                               , "OLD"
                               , "ON"
                               , "ONLY_CMAKE_FIND_ROOT_PATH"
                               , "OPTIONAL"
                               , "OPTIONAL_COMPONENTS"
                               , "OPTIONS"
                               , "OR"
                               , "OUTPUT"
                               , "OUTPUT_DIRECTORY"
                               , "OUTPUT_FILE"
                               , "OUTPUT_QUIET"
                               , "OUTPUT_STRIP_TRAILING_WHITESPACE"
                               , "OUTPUT_VARIABLE"
                               , "OWNER_EXECUTE"
                               , "OWNER_READ"
                               , "OWNER_WRITE"
                               , "PACKAGE"
                               , "PARALLEL_LEVEL"
                               , "PARENT_SCOPE"
                               , "PARTS"
                               , "PATHS"
                               , "PATH_SUFFIXES"
                               , "PATH_TO_MESA"
                               , "PATTERN"
                               , "PERMISSIONS"
                               , "PLATFORM"
                               , "POLICY"
                               , "POP"
                               , "POST_BUILD"
                               , "PREORDER"
                               , "PRE_BUILD"
                               , "PRE_LINK"
                               , "PRIVATE"
                               , "PRIVATE_HEADER"
                               , "PROCESS"
                               , "PROGRAM"
                               , "PROGRAMS"
                               , "PROGRAM_ARGS"
                               , "PROJECT_NAME"
                               , "PROPERTIES"
                               , "PROPERTY"
                               , "PUBLIC"
                               , "PUBLIC_HEADER"
                               , "PUSH"
                               , "QUERY"
                               , "QUIET"
                               , "RANDOM"
                               , "RANDOM_SEED"
                               , "RANGE"
                               , "READ"
                               , "READ_WITH_PREFIX"
                               , "REGEX"
                               , "REGULAR_EXPRESSION"
                               , "RELATIVE"
                               , "RELATIVE_PATH"
                               , "RELEASE"
                               , "REMOVE"
                               , "REMOVE_AT"
                               , "REMOVE_DUPLICATES"
                               , "REMOVE_ITEM"
                               , "REMOVE_RECURSE"
                               , "RENAME"
                               , "REPLACE"
                               , "REQUIRED"
                               , "REQUIRED_VARIABLE1"
                               , "REQUIRED_VARIABLE2"
                               , "RESOURCE"
                               , "RESULT"
                               , "RESULT_VAR"
                               , "RESULT_VARIABLE"
                               , "RETRY_COUNT"
                               , "RETRY_DELAY"
                               , "RETURN_VALUE"
                               , "REVERSE"
                               , "RUNTIME"
                               , "RUNTIME_DIRECTORY"
                               , "RUN_OUTPUT_VARIABLE"
                               , "RUN_RESULT_VAR"
                               , "SCHEDULE_RANDOM"
                               , "SCRIPT"
                               , "SEND_ERROR"
                               , "SET"
                               , "SHA1"
                               , "SHA224"
                               , "SHA256"
                               , "SHA384"
                               , "SHA512"
                               , "SHARED"
                               , "SHOW_PROGRESS"
                               , "SORT"
                               , "SOURCE"
                               , "SOURCES"
                               , "START"
                               , "STATIC"
                               , "STATUS"
                               , "STOP_TIME"
                               , "STREQUAL"
                               , "STRGREATER"
                               , "STRIDE"
                               , "STRINGS"
                               , "STRIP"
                               , "STRLESS"
                               , "SUBSTRING"
                               , "SYSTEM"
                               , "TARGET"
                               , "TARGETS"
                               , "TEST"
                               , "TEST_VARIABLE"
                               , "TIMEOUT"
                               , "TIMESTAMP"
                               , "TLS_CAINFO"
                               , "TLS_VERIFY"
                               , "TOLOWER"
                               , "TOUPPER"
                               , "TO_CMAKE_PATH"
                               , "TO_NATIVE_PATH"
                               , "TRACK"
                               , "TYPE"
                               , "UNIX"
                               , "UNIX_COMMAND"
                               , "UNKNOWN"
                               , "UPLOAD"
                               , "UPPER"
                               , "USES_TERMINAL"
                               , "USE_SOURCE_PERMISSIONS"
                               , "UTC"
                               , "UUID"
                               , "VALUE"
                               , "VARIABLE"
                               , "VERBATIM"
                               , "VERSION"
                               , "VERSION_EQUAL"
                               , "VERSION_GREATER"
                               , "VERSION_LESS"
                               , "WARNING"
                               , "WIN32"
                               , "WINDOWS_COMMAND"
                               , "WORKING_DIRECTORY"
                               , "WRITE"
                               ])
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "ABSOLUTE"
                               , "AVAILABLE_PHYSICAL_MEMORY"
                               , "AVAILABLE_VIRTUAL_MEMORY"
                               , "BOOL"
                               , "EXT"
                               , "FILEPATH"
                               , "FQDN"
                               , "HOSTNAME"
                               , "INTERNAL"
                               , "IN_LIST"
                               , "NAME"
                               , "NAME_WE"
                               , "NUMBER_OF_LOGICAL_CORES"
                               , "NUMBER_OF_PHYSICAL_CORES"
                               , "PATH"
                               , "REALPATH"
                               , "STRING"
                               , "TOTAL_PHYSICAL_MEMORY"
                               , "TOTAL_VIRTUAL_MEMORY"
                               ])
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMP[0-9]+\\b"
                              , reCompiled = Just (compileRegex True "\\bCMP[0-9]+\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "ABSTRACT"
                               , "ADDITIONAL_MAKE_CLEAN_FILES"
                               , "ADVANCED"
                               , "ALIASED_TARGET"
                               , "ALLOW_DUPLICATE_CUSTOM_TARGETS"
                               , "ANDROID_API"
                               , "ANDROID_API_MIN"
                               , "ANDROID_GUI"
                               , "ARCHIVE_OUTPUT_DIRECTORY"
                               , "ARCHIVE_OUTPUT_NAME"
                               , "ATTACHED_FILES"
                               , "ATTACHED_FILES_ON_FAIL"
                               , "AUTOGEN_TARGETS_FOLDER"
                               , "AUTOGEN_TARGET_DEPENDS"
                               , "AUTOMOC"
                               , "AUTOMOC_MOC_OPTIONS"
                               , "AUTOMOC_TARGETS_FOLDER"
                               , "AUTORCC"
                               , "AUTORCC_OPTIONS"
                               , "AUTOUIC"
                               , "AUTOUIC_OPTIONS"
                               , "BUILD_WITH_INSTALL_RPATH"
                               , "BUNDLE"
                               , "BUNDLE_EXTENSION"
                               , "CACHE_VARIABLES"
                               , "CLEAN_NO_CUSTOM"
                               , "CMAKE_CONFIGURE_DEPENDS"
                               , "CMAKE_CXX_KNOWN_FEATURES"
                               , "CMAKE_C_KNOWN_FEATURES"
                               , "COMPATIBLE_INTERFACE_BOOL"
                               , "COMPATIBLE_INTERFACE_NUMBER_MAX"
                               , "COMPATIBLE_INTERFACE_NUMBER_MIN"
                               , "COMPATIBLE_INTERFACE_STRING"
                               , "COMPILE_DEFINITIONS"
                               , "COMPILE_FEATURES"
                               , "COMPILE_FLAGS"
                               , "COMPILE_OPTIONS"
                               , "COMPILE_PDB_NAME"
                               , "COMPILE_PDB_OUTPUT_DIRECTORY"
                               , "COST"
                               , "CPACK_DESKTOP_SHORTCUTS"
                               , "CPACK_NEVER_OVERWRITE"
                               , "CPACK_PERMANENT"
                               , "CPACK_STARTUP_SHORTCUTS"
                               , "CPACK_START_MENU_SHORTCUTS"
                               , "CPACK_WIX_ACL"
                               , "CROSSCOMPILING_EMULATOR"
                               , "CXX_EXTENSIONS"
                               , "CXX_STANDARD"
                               , "CXX_STANDARD_REQUIRED"
                               , "C_EXTENSIONS"
                               , "C_STANDARD"
                               , "C_STANDARD_REQUIRED"
                               , "DEBUG_CONFIGURATIONS"
                               , "DEBUG_POSTFIX"
                               , "DEFINE_SYMBOL"
                               , "DEFINITIONS"
                               , "DEPENDS"
                               , "DISABLED_FEATURES"
                               , "ECLIPSE_EXTRA_NATURES"
                               , "ENABLED_FEATURES"
                               , "ENABLED_LANGUAGES"
                               , "ENABLE_EXPORTS"
                               , "ENVIRONMENT"
                               , "EXCLUDE_FROM_ALL"
                               , "EXCLUDE_FROM_DEFAULT_BUILD"
                               , "EXPORT_NAME"
                               , "EXTERNAL_OBJECT"
                               , "EchoString"
                               , "FAIL_REGULAR_EXPRESSION"
                               , "FIND_LIBRARY_USE_LIB64_PATHS"
                               , "FIND_LIBRARY_USE_OPENBSD_VERSIONING"
                               , "FOLDER"
                               , "FRAMEWORK"
                               , "Fortran_FORMAT"
                               , "Fortran_MODULE_DIRECTORY"
                               , "GENERATED"
                               , "GENERATOR_FILE_NAME"
                               , "GLOBAL_DEPENDS_DEBUG_MODE"
                               , "GLOBAL_DEPENDS_NO_CYCLES"
                               , "GNUtoMS"
                               , "HAS_CXX"
                               , "HEADER_FILE_ONLY"
                               , "HELPSTRING"
                               , "IMPLICIT_DEPENDS_INCLUDE_TRANSFORM"
                               , "IMPORTED"
                               , "IMPORTED_CONFIGURATIONS"
                               , "IMPORTED_IMPLIB"
                               , "IMPORTED_LINK_DEPENDENT_LIBRARIES"
                               , "IMPORTED_LINK_INTERFACE_LANGUAGES"
                               , "IMPORTED_LINK_INTERFACE_LIBRARIES"
                               , "IMPORTED_LINK_INTERFACE_MULTIPLICITY"
                               , "IMPORTED_LOCATION"
                               , "IMPORTED_NO_SONAME"
                               , "IMPORTED_SONAME"
                               , "IMPORT_PREFIX"
                               , "IMPORT_SUFFIX"
                               , "INCLUDE_DIRECTORIES"
                               , "INCLUDE_REGULAR_EXPRESSION"
                               , "INSTALL_NAME_DIR"
                               , "INSTALL_RPATH"
                               , "INSTALL_RPATH_USE_LINK_PATH"
                               , "INTERFACE_AUTOUIC_OPTIONS"
                               , "INTERFACE_COMPILE_DEFINITIONS"
                               , "INTERFACE_COMPILE_FEATURES"
                               , "INTERFACE_COMPILE_OPTIONS"
                               , "INTERFACE_INCLUDE_DIRECTORIES"
                               , "INTERFACE_LINK_LIBRARIES"
                               , "INTERFACE_POSITION_INDEPENDENT_CODE"
                               , "INTERFACE_SOURCES"
                               , "INTERFACE_SYSTEM_INCLUDE_DIRECTORIES"
                               , "INTERPROCEDURAL_OPTIMIZATION"
                               , "IN_TRY_COMPILE"
                               , "JOB_POOLS"
                               , "JOB_POOL_COMPILE"
                               , "JOB_POOL_LINK"
                               , "KEEP_EXTENSION"
                               , "LABELS"
                               , "LANGUAGE"
                               , "LIBRARY_OUTPUT_DIRECTORY"
                               , "LIBRARY_OUTPUT_NAME"
                               , "LINKER_LANGUAGE"
                               , "LINK_DEPENDS"
                               , "LINK_DEPENDS_NO_SHARED"
                               , "LINK_DIRECTORIES"
                               , "LINK_FLAGS"
                               , "LINK_INTERFACE_LIBRARIES"
                               , "LINK_INTERFACE_MULTIPLICITY"
                               , "LINK_LIBRARIES"
                               , "LINK_SEARCH_END_STATIC"
                               , "LINK_SEARCH_START_STATIC"
                               , "LISTFILE_STACK"
                               , "LOCATION"
                               , "MACOSX_BUNDLE"
                               , "MACOSX_BUNDLE_INFO_PLIST"
                               , "MACOSX_FRAMEWORK_INFO_PLIST"
                               , "MACOSX_PACKAGE_LOCATION"
                               , "MACOSX_RPATH"
                               , "MACROS"
                               , "MEASUREMENT"
                               , "MODIFIED"
                               , "NAME"
                               , "NO_SONAME"
                               , "NO_SYSTEM_FROM_IMPORTED"
                               , "OBJECT_DEPENDS"
                               , "OBJECT_OUTPUTS"
                               , "OSX_ARCHITECTURES"
                               , "OUTPUT_NAME"
                               , "PACKAGES_FOUND"
                               , "PACKAGES_NOT_FOUND"
                               , "PARENT_DIRECTORY"
                               , "PASS_REGULAR_EXPRESSION"
                               , "PDB_NAME"
                               , "PDB_OUTPUT_DIRECTORY"
                               , "POSITION_INDEPENDENT_CODE"
                               , "POST_INSTALL_SCRIPT"
                               , "PREDEFINED_TARGETS_FOLDER"
                               , "PREFIX"
                               , "PRE_INSTALL_SCRIPT"
                               , "PRIVATE_HEADER"
                               , "PROCESSORS"
                               , "PROJECT_LABEL"
                               , "PUBLIC_HEADER"
                               , "REPORT_UNDEFINED_PROPERTIES"
                               , "REQUIRED_FILES"
                               , "RESOURCE"
                               , "RESOURCE_LOCK"
                               , "RULE_LAUNCH_COMPILE"
                               , "RULE_LAUNCH_CUSTOM"
                               , "RULE_LAUNCH_LINK"
                               , "RULE_MESSAGES"
                               , "RUNTIME_OUTPUT_DIRECTORY"
                               , "RUNTIME_OUTPUT_NAME"
                               , "RUN_SERIAL"
                               , "SKIP_BUILD_RPATH"
                               , "SKIP_RETURN_CODE"
                               , "SOURCES"
                               , "SOVERSION"
                               , "STATIC_LIBRARY_FLAGS"
                               , "STRINGS"
                               , "SUFFIX"
                               , "SYMBOLIC"
                               , "TARGET_ARCHIVES_MAY_BE_SHARED_LIBS"
                               , "TARGET_SUPPORTS_SHARED_LIBS"
                               , "TEST_INCLUDE_FILE"
                               , "TIMEOUT"
                               , "TYPE"
                               , "USE_FOLDERS"
                               , "VALUE"
                               , "VARIABLES"
                               , "VERSION"
                               , "VISIBILITY_INLINES_HIDDEN"
                               , "VS_DEPLOYMENT_CONTENT"
                               , "VS_DEPLOYMENT_LOCATION"
                               , "VS_DOTNET_REFERENCES"
                               , "VS_DOTNET_TARGET_FRAMEWORK_VERSION"
                               , "VS_GLOBAL_KEYWORD"
                               , "VS_GLOBAL_PROJECT_TYPES"
                               , "VS_GLOBAL_ROOTNAMESPACE"
                               , "VS_KEYWORD"
                               , "VS_SCC_AUXPATH"
                               , "VS_SCC_LOCALPATH"
                               , "VS_SCC_PROJECTNAME"
                               , "VS_SCC_PROVIDER"
                               , "VS_SHADER_ENTRYPOINT"
                               , "VS_SHADER_FLAGS"
                               , "VS_SHADER_MODEL"
                               , "VS_SHADER_TYPE"
                               , "VS_WINRT_COMPONENT"
                               , "VS_WINRT_EXTENSIONS"
                               , "VS_WINRT_REFERENCES"
                               , "VS_XAML_TYPE"
                               , "WILL_FAIL"
                               , "WIN32_EXECUTABLE"
                               , "WORKING_DIRECTORY"
                               , "WRAP_EXCLUDE"
                               , "XCODE_EXPLICIT_FILE_TYPE"
                               , "XCODE_LAST_KNOWN_FILE_TYPE"
                               , "XCTEST"
                               ])
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet True [ "COMMANDS" , "DEFINITION" ])
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "CMake" , "Detect Builtin Variables" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "CMake" , "Macro Args" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Comment"
          , Context
              { cName = "Comment"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Alerts" , "" )
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Modelines" , "" )
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Detect Builtin Variables"
          , Context
              { cName = "Detect Builtin Variables"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "APPLE"
                               , "BORLAND"
                               , "BUILD_SHARED_LIBS"
                               , "CMAKE_ABSOLUTE_DESTINATION_FILES"
                               , "CMAKE_ANDROID_API"
                               , "CMAKE_ANDROID_API_MIN"
                               , "CMAKE_ANDROID_GUI"
                               , "CMAKE_APPBUNDLE_PATH"
                               , "CMAKE_AR"
                               , "CMAKE_ARCHIVE_OUTPUT_DIRECTORY"
                               , "CMAKE_ARGC"
                               , "CMAKE_ARGV0"
                               , "CMAKE_AUTOMOC"
                               , "CMAKE_AUTOMOC_MOC_OPTIONS"
                               , "CMAKE_AUTOMOC_RELAXED_MODE"
                               , "CMAKE_AUTORCC"
                               , "CMAKE_AUTORCC_OPTIONS"
                               , "CMAKE_AUTOUIC"
                               , "CMAKE_AUTOUIC_OPTIONS"
                               , "CMAKE_BACKWARDS_COMPATIBILITY"
                               , "CMAKE_BINARY_DIR"
                               , "CMAKE_BUILD_TOOL"
                               , "CMAKE_BUILD_TYPE"
                               , "CMAKE_BUILD_WITH_INSTALL_RPATH"
                               , "CMAKE_CACHEFILE_DIR"
                               , "CMAKE_CACHE_MAJOR_VERSION"
                               , "CMAKE_CACHE_MINOR_VERSION"
                               , "CMAKE_CACHE_PATCH_VERSION"
                               , "CMAKE_CFG_INTDIR"
                               , "CMAKE_CL_64"
                               , "CMAKE_COLOR_MAKEFILE"
                               , "CMAKE_COMMAND"
                               , "CMAKE_COMPILER_2005"
                               , "CMAKE_COMPILE_PDB_OUTPUT_DIRECTORY"
                               , "CMAKE_CONFIGURATION_TYPES"
                               , "CMAKE_CROSSCOMPILING"
                               , "CMAKE_CROSSCOMPILING_EMULATOR"
                               , "CMAKE_CTEST_COMMAND"
                               , "CMAKE_CURRENT_BINARY_DIR"
                               , "CMAKE_CURRENT_LIST_DIR"
                               , "CMAKE_CURRENT_LIST_FILE"
                               , "CMAKE_CURRENT_LIST_LINE"
                               , "CMAKE_CURRENT_SOURCE_DIR"
                               , "CMAKE_CXX_COMPILE_FEATURES"
                               , "CMAKE_CXX_EXTENSIONS"
                               , "CMAKE_CXX_STANDARD"
                               , "CMAKE_CXX_STANDARD_REQUIRED"
                               , "CMAKE_C_COMPILE_FEATURES"
                               , "CMAKE_C_EXTENSIONS"
                               , "CMAKE_C_STANDARD"
                               , "CMAKE_C_STANDARD_REQUIRED"
                               , "CMAKE_DEBUG_POSTFIX"
                               , "CMAKE_DEBUG_TARGET_PROPERTIES"
                               , "CMAKE_DL_LIBS"
                               , "CMAKE_EDIT_COMMAND"
                               , "CMAKE_ERROR_DEPRECATED"
                               , "CMAKE_ERROR_ON_ABSOLUTE_INSTALL_DESTINATION"
                               , "CMAKE_EXECUTABLE_SUFFIX"
                               , "CMAKE_EXE_LINKER_FLAGS"
                               , "CMAKE_EXPORT_NO_PACKAGE_REGISTRY"
                               , "CMAKE_EXTRA_GENERATOR"
                               , "CMAKE_EXTRA_SHARED_LIBRARY_SUFFIXES"
                               , "CMAKE_FIND_LIBRARY_PREFIXES"
                               , "CMAKE_FIND_LIBRARY_SUFFIXES"
                               , "CMAKE_FIND_NO_INSTALL_PREFIX"
                               , "CMAKE_FIND_PACKAGE_NAME"
                               , "CMAKE_FIND_PACKAGE_NO_PACKAGE_REGISTRY"
                               , "CMAKE_FIND_PACKAGE_NO_SYSTEM_PACKAGE_REGISTRY"
                               , "CMAKE_FIND_PACKAGE_WARN_NO_MODULE"
                               , "CMAKE_FIND_ROOT_PATH"
                               , "CMAKE_FIND_ROOT_PATH_MODE_INCLUDE"
                               , "CMAKE_FIND_ROOT_PATH_MODE_LIBRARY"
                               , "CMAKE_FIND_ROOT_PATH_MODE_PACKAGE"
                               , "CMAKE_FIND_ROOT_PATH_MODE_PROGRAM"
                               , "CMAKE_FRAMEWORK_PATH"
                               , "CMAKE_Fortran_FORMAT"
                               , "CMAKE_Fortran_MODDIR_DEFAULT"
                               , "CMAKE_Fortran_MODDIR_FLAG"
                               , "CMAKE_Fortran_MODOUT_FLAG"
                               , "CMAKE_Fortran_MODULE_DIRECTORY"
                               , "CMAKE_GENERATOR"
                               , "CMAKE_GENERATOR_PLATFORM"
                               , "CMAKE_GENERATOR_TOOLSET"
                               , "CMAKE_GNUtoMS"
                               , "CMAKE_HOME_DIRECTORY"
                               , "CMAKE_HOST_APPLE"
                               , "CMAKE_HOST_SYSTEM"
                               , "CMAKE_HOST_SYSTEM_NAME"
                               , "CMAKE_HOST_SYSTEM_PROCESSOR"
                               , "CMAKE_HOST_SYSTEM_VERSION"
                               , "CMAKE_HOST_UNIX"
                               , "CMAKE_HOST_WIN32"
                               , "CMAKE_IGNORE_PATH"
                               , "CMAKE_IMPORT_LIBRARY_PREFIX"
                               , "CMAKE_IMPORT_LIBRARY_SUFFIX"
                               , "CMAKE_INCLUDE_CURRENT_DIR"
                               , "CMAKE_INCLUDE_CURRENT_DIR_IN_INTERFACE"
                               , "CMAKE_INCLUDE_DIRECTORIES_BEFORE"
                               , "CMAKE_INCLUDE_DIRECTORIES_PROJECT_BEFORE"
                               , "CMAKE_INCLUDE_PATH"
                               , "CMAKE_INSTALL_DEFAULT_COMPONENT_NAME"
                               , "CMAKE_INSTALL_MESSAGE"
                               , "CMAKE_INSTALL_NAME_DIR"
                               , "CMAKE_INSTALL_PREFIX"
                               , "CMAKE_INSTALL_RPATH"
                               , "CMAKE_INSTALL_RPATH_USE_LINK_PATH"
                               , "CMAKE_INTERNAL_PLATFORM_ABI"
                               , "CMAKE_JOB_POOL_COMPILE"
                               , "CMAKE_JOB_POOL_LINK"
                               , "CMAKE_LIBRARY_ARCHITECTURE"
                               , "CMAKE_LIBRARY_ARCHITECTURE_REGEX"
                               , "CMAKE_LIBRARY_OUTPUT_DIRECTORY"
                               , "CMAKE_LIBRARY_PATH"
                               , "CMAKE_LIBRARY_PATH_FLAG"
                               , "CMAKE_LINK_DEF_FILE_FLAG"
                               , "CMAKE_LINK_DEPENDS_NO_SHARED"
                               , "CMAKE_LINK_INTERFACE_LIBRARIES"
                               , "CMAKE_LINK_LIBRARY_FILE_FLAG"
                               , "CMAKE_LINK_LIBRARY_FLAG"
                               , "CMAKE_LINK_LIBRARY_SUFFIX"
                               , "CMAKE_MACOSX_BUNDLE"
                               , "CMAKE_MACOSX_RPATH"
                               , "CMAKE_MAJOR_VERSION"
                               , "CMAKE_MAKE_PROGRAM"
                               , "CMAKE_MATCH_COUNT"
                               , "CMAKE_MFC_FLAG"
                               , "CMAKE_MINIMUM_REQUIRED_VERSION"
                               , "CMAKE_MINOR_VERSION"
                               , "CMAKE_MODULE_LINKER_FLAGS"
                               , "CMAKE_MODULE_PATH"
                               , "CMAKE_NOT_USING_CONFIG_FLAGS"
                               , "CMAKE_NO_BUILTIN_CHRPATH"
                               , "CMAKE_NO_SYSTEM_FROM_IMPORTED"
                               , "CMAKE_OBJECT_PATH_MAX"
                               , "CMAKE_OSX_ARCHITECTURES"
                               , "CMAKE_OSX_DEPLOYMENT_TARGET"
                               , "CMAKE_OSX_SYSROOT"
                               , "CMAKE_PARENT_LIST_FILE"
                               , "CMAKE_PATCH_VERSION"
                               , "CMAKE_PDB_OUTPUT_DIRECTORY"
                               , "CMAKE_POSITION_INDEPENDENT_CODE"
                               , "CMAKE_PREFIX_PATH"
                               , "CMAKE_PROGRAM_PATH"
                               , "CMAKE_PROJECT_NAME"
                               , "CMAKE_RANLIB"
                               , "CMAKE_ROOT"
                               , "CMAKE_RUNTIME_OUTPUT_DIRECTORY"
                               , "CMAKE_SCRIPT_MODE_FILE"
                               , "CMAKE_SHARED_LIBRARY_PREFIX"
                               , "CMAKE_SHARED_LIBRARY_SUFFIX"
                               , "CMAKE_SHARED_LINKER_FLAGS"
                               , "CMAKE_SHARED_MODULE_PREFIX"
                               , "CMAKE_SHARED_MODULE_SUFFIX"
                               , "CMAKE_SIZEOF_VOID_P"
                               , "CMAKE_SKIP_BUILD_RPATH"
                               , "CMAKE_SKIP_INSTALL_ALL_DEPENDENCY"
                               , "CMAKE_SKIP_INSTALL_RPATH"
                               , "CMAKE_SKIP_INSTALL_RULES"
                               , "CMAKE_SKIP_RPATH"
                               , "CMAKE_SOURCE_DIR"
                               , "CMAKE_STAGING_PREFIX"
                               , "CMAKE_STANDARD_LIBRARIES"
                               , "CMAKE_STATIC_LIBRARY_PREFIX"
                               , "CMAKE_STATIC_LIBRARY_SUFFIX"
                               , "CMAKE_STATIC_LINKER_FLAGS"
                               , "CMAKE_SYSROOT"
                               , "CMAKE_SYSTEM"
                               , "CMAKE_SYSTEM_IGNORE_PATH"
                               , "CMAKE_SYSTEM_INCLUDE_PATH"
                               , "CMAKE_SYSTEM_LIBRARY_PATH"
                               , "CMAKE_SYSTEM_NAME"
                               , "CMAKE_SYSTEM_PREFIX_PATH"
                               , "CMAKE_SYSTEM_PROCESSOR"
                               , "CMAKE_SYSTEM_PROGRAM_PATH"
                               , "CMAKE_SYSTEM_VERSION"
                               , "CMAKE_TOOLCHAIN_FILE"
                               , "CMAKE_TRY_COMPILE_CONFIGURATION"
                               , "CMAKE_TWEAK_VERSION"
                               , "CMAKE_USER_MAKE_RULES_OVERRIDE"
                               , "CMAKE_USE_RELATIVE_PATHS"
                               , "CMAKE_VERBOSE_MAKEFILE"
                               , "CMAKE_VERSION"
                               , "CMAKE_VISIBILITY_INLINES_HIDDEN"
                               , "CMAKE_VS_DEVENV_COMMAND"
                               , "CMAKE_VS_INCLUDE_INSTALL_TO_DEFAULT_BUILD"
                               , "CMAKE_VS_INTEL_Fortran_PROJECT_VERSION"
                               , "CMAKE_VS_MSBUILD_COMMAND"
                               , "CMAKE_VS_MSDEV_COMMAND"
                               , "CMAKE_VS_NsightTegra_VERSION"
                               , "CMAKE_VS_PLATFORM_NAME"
                               , "CMAKE_VS_PLATFORM_TOOLSET"
                               , "CMAKE_WARN_DEPRECATED"
                               , "CMAKE_WARN_ON_ABSOLUTE_INSTALL_DESTINATION"
                               , "CMAKE_WIN32_EXECUTABLE"
                               , "CMAKE_XCODE_PLATFORM_TOOLSET"
                               , "CPACK_ABSOLUTE_DESTINATION_FILES"
                               , "CPACK_COMPONENT_INCLUDE_TOPLEVEL_DIRECTORY"
                               , "CPACK_ERROR_ON_ABSOLUTE_INSTALL_DESTINATION"
                               , "CPACK_INCLUDE_TOPLEVEL_DIRECTORY"
                               , "CPACK_INSTALL_SCRIPT"
                               , "CPACK_PACKAGING_INSTALL_PREFIX"
                               , "CPACK_SET_DESTDIR"
                               , "CPACK_WARN_ON_ABSOLUTE_INSTALL_DESTINATION"
                               , "CTEST_BINARY_DIRECTORY"
                               , "CTEST_BUILD_COMMAND"
                               , "CTEST_BUILD_NAME"
                               , "CTEST_BZR_COMMAND"
                               , "CTEST_BZR_UPDATE_OPTIONS"
                               , "CTEST_CHECKOUT_COMMAND"
                               , "CTEST_CONFIGURATION_TYPE"
                               , "CTEST_CONFIGURE_COMMAND"
                               , "CTEST_COVERAGE_COMMAND"
                               , "CTEST_COVERAGE_EXTRA_FLAGS"
                               , "CTEST_CURL_OPTIONS"
                               , "CTEST_CVS_CHECKOUT"
                               , "CTEST_CVS_COMMAND"
                               , "CTEST_CVS_UPDATE_OPTIONS"
                               , "CTEST_DROP_LOCATION"
                               , "CTEST_DROP_METHOD"
                               , "CTEST_DROP_SITE"
                               , "CTEST_DROP_SITE_CDASH"
                               , "CTEST_DROP_SITE_PASSWORD"
                               , "CTEST_DROP_SITE_USER"
                               , "CTEST_GIT_COMMAND"
                               , "CTEST_GIT_UPDATE_CUSTOM"
                               , "CTEST_GIT_UPDATE_OPTIONS"
                               , "CTEST_HG_COMMAND"
                               , "CTEST_HG_UPDATE_OPTIONS"
                               , "CTEST_MEMORYCHECK_COMMAND"
                               , "CTEST_MEMORYCHECK_COMMAND_OPTIONS"
                               , "CTEST_MEMORYCHECK_SANITIZER_OPTIONS"
                               , "CTEST_MEMORYCHECK_SUPPRESSIONS_FILE"
                               , "CTEST_MEMORYCHECK_TYPE"
                               , "CTEST_NIGHTLY_START_TIME"
                               , "CTEST_P4_CLIENT"
                               , "CTEST_P4_COMMAND"
                               , "CTEST_P4_OPTIONS"
                               , "CTEST_P4_UPDATE_OPTIONS"
                               , "CTEST_SCP_COMMAND"
                               , "CTEST_SITE"
                               , "CTEST_SOURCE_DIRECTORY"
                               , "CTEST_SVN_COMMAND"
                               , "CTEST_SVN_OPTIONS"
                               , "CTEST_SVN_UPDATE_OPTIONS"
                               , "CTEST_TEST_TIMEOUT"
                               , "CTEST_TRIGGER_SITE"
                               , "CTEST_UPDATE_COMMAND"
                               , "CTEST_UPDATE_OPTIONS"
                               , "CTEST_UPDATE_VERSION_ONLY"
                               , "CTEST_USE_LAUNCHERS"
                               , "CYGWIN"
                               , "ENV"
                               , "EXECUTABLE_OUTPUT_PATH"
                               , "GHS-MULTI"
                               , "LIBRARY_OUTPUT_PATH"
                               , "MINGW"
                               , "MSVC"
                               , "MSVC10"
                               , "MSVC11"
                               , "MSVC12"
                               , "MSVC14"
                               , "MSVC60"
                               , "MSVC70"
                               , "MSVC71"
                               , "MSVC80"
                               , "MSVC90"
                               , "MSVC_IDE"
                               , "MSVC_VERSION"
                               , "PROJECT_BINARY_DIR"
                               , "PROJECT_NAME"
                               , "PROJECT_SOURCE_DIR"
                               , "PROJECT_VERSION"
                               , "PROJECT_VERSION_MAJOR"
                               , "PROJECT_VERSION_MINOR"
                               , "PROJECT_VERSION_PATCH"
                               , "PROJECT_VERSION_TWEAK"
                               , "UNIX"
                               , "WIN32"
                               , "WINCE"
                               , "WINDOWS_PHONE"
                               , "WINDOWS_STORE"
                               , "XCODE_VERSION"
                               ])
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          IncludeRules ( "CMake" , "Detect More Builtin Variables" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Detect Generator Expressions"
          , Context
              { cName = "Detect Generator Expressions"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '$' '<'
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Generator Expression" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Detect More Builtin Variables"
          , Context
              { cName = "Detect More Builtin Variables"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_ARCHIVE_OUTPUT_DIRECTORY_[A-Za-z_][A-Za-z_0-9]*\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_ARCHIVE_OUTPUT_DIRECTORY_[A-Za-z_][A-Za-z_0-9]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_COMPILER_IS_GNU[A-Za-z_][A-Za-z_0-9]*\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_COMPILER_IS_GNU[A-Za-z_][A-Za-z_0-9]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_COMPILE_PDB_OUTPUT_DIRECTORY_[A-Za-z_][A-Za-z_0-9]*\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_COMPILE_PDB_OUTPUT_DIRECTORY_[A-Za-z_][A-Za-z_0-9]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_DISABLE_FIND_PACKAGE_[A-Za-z_][A-Za-z_0-9]*\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_DISABLE_FIND_PACKAGE_[A-Za-z_][A-Za-z_0-9]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_EXE_LINKER_FLAGS_[A-Za-z_][A-Za-z_0-9]*\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_EXE_LINKER_FLAGS_[A-Za-z_][A-Za-z_0-9]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_LIBRARY_OUTPUT_DIRECTORY_[A-Za-z_][A-Za-z_0-9]*\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_LIBRARY_OUTPUT_DIRECTORY_[A-Za-z_][A-Za-z_0-9]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_MAP_IMPORTED_CONFIG_[A-Za-z_][A-Za-z_0-9]*\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_MAP_IMPORTED_CONFIG_[A-Za-z_][A-Za-z_0-9]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_MODULE_LINKER_FLAGS_[A-Za-z_][A-Za-z_0-9]*\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_MODULE_LINKER_FLAGS_[A-Za-z_][A-Za-z_0-9]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_PDB_OUTPUT_DIRECTORY_[A-Za-z_][A-Za-z_0-9]*\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_PDB_OUTPUT_DIRECTORY_[A-Za-z_][A-Za-z_0-9]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_POLICY_DEFAULT_CMP[0-9]+\\b"
                              , reCompiled =
                                  Just (compileRegex True "\\bCMAKE_POLICY_DEFAULT_CMP[0-9]+\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_POLICY_WARNING_CMP[0-9]+\\b"
                              , reCompiled =
                                  Just (compileRegex True "\\bCMAKE_POLICY_WARNING_CMP[0-9]+\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_PROJECT_[A-Za-z_][A-Za-z_0-9]*_INCLUDE\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_PROJECT_[A-Za-z_][A-Za-z_0-9]*_INCLUDE\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_RUNTIME_OUTPUT_DIRECTORY_[A-Za-z_][A-Za-z_0-9]*\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_RUNTIME_OUTPUT_DIRECTORY_[A-Za-z_][A-Za-z_0-9]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_SHARED_LINKER_FLAGS_[A-Za-z_][A-Za-z_0-9]*\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_SHARED_LINKER_FLAGS_[A-Za-z_][A-Za-z_0-9]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_STATIC_LINKER_FLAGS_[A-Za-z_][A-Za-z_0-9]*\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_STATIC_LINKER_FLAGS_[A-Za-z_][A-Za-z_0-9]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_USER_MAKE_RULES_OVERRIDE_[A-Za-z_][A-Za-z_0-9]*\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_USER_MAKE_RULES_OVERRIDE_[A-Za-z_][A-Za-z_0-9]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_XCODE_ATTRIBUTE_[A-Za-z_][A-Za-z_0-9]*\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_XCODE_ATTRIBUTE_[A-Za-z_][A-Za-z_0-9]*\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_ARCHIVE_APPEND\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_ARCHIVE_APPEND\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_ARCHIVE_CREATE\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_ARCHIVE_CREATE\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_ARCHIVE_FINISH\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_ARCHIVE_FINISH\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_ABI\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_ABI\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_EXTERNAL_TOOLCHAIN\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_EXTERNAL_TOOLCHAIN\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_ID\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_ID\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_LOADED\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_LOADED\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_TARGET\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_TARGET\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_VERSION\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILER_VERSION\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILE_OBJECT\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_COMPILE_OBJECT\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_CREATE_SHARED_LIBRARY\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_CREATE_SHARED_LIBRARY\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_CREATE_SHARED_MODULE\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_CREATE_SHARED_MODULE\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_CREATE_STATIC_LIBRARY\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_CREATE_STATIC_LIBRARY\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_FLAGS\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_FLAGS\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_FLAGS_DEBUG\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_FLAGS_DEBUG\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_FLAGS_MINSIZEREL\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_FLAGS_MINSIZEREL\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_FLAGS_RELEASE\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_FLAGS_RELEASE\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_FLAGS_RELWITHDEBINFO\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_FLAGS_RELWITHDEBINFO\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_GHS_KERNEL_FLAGS_DEBUG\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_GHS_KERNEL_FLAGS_DEBUG\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_GHS_KERNEL_FLAGS_MINSIZEREL\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_GHS_KERNEL_FLAGS_MINSIZEREL\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_GHS_KERNEL_FLAGS_RELEASE\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_GHS_KERNEL_FLAGS_RELEASE\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_GHS_KERNEL_FLAGS_RELWITHDEBINFO\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_GHS_KERNEL_FLAGS_RELWITHDEBINFO\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IGNORE_EXTENSIONS\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IGNORE_EXTENSIONS\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IMPLICIT_INCLUDE_DIRECTORIES\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IMPLICIT_INCLUDE_DIRECTORIES\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IMPLICIT_LINK_DIRECTORIES\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IMPLICIT_LINK_DIRECTORIES\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IMPLICIT_LINK_FRAMEWORK_DIRECTORIES\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IMPLICIT_LINK_FRAMEWORK_DIRECTORIES\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IMPLICIT_LINK_LIBRARIES\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_IMPLICIT_LINK_LIBRARIES\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_INCLUDE_WHAT_YOU_USE\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_INCLUDE_WHAT_YOU_USE\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_LIBRARY_ARCHITECTURE\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_LIBRARY_ARCHITECTURE\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_LINKER_PREFERENCE\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_LINKER_PREFERENCE\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_LINKER_PREFERENCE_PROPAGATES\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_LINKER_PREFERENCE_PROPAGATES\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_LINK_EXECUTABLE\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_LINK_EXECUTABLE\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_OUTPUT_EXTENSION\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_OUTPUT_EXTENSION\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_PLATFORM_ID\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_PLATFORM_ID\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_POSTFIX\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_POSTFIX\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_SIMULATE_ID\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_SIMULATE_ID\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_SIMULATE_VERSION\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_SIMULATE_VERSION\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_SIZEOF_DATA_PTR\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_SIZEOF_DATA_PTR\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_SOURCE_FILE_EXTENSIONS\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_SOURCE_FILE_EXTENSIONS\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_VISIBILITY_PRESET\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "\\bCMAKE_[A-Za-z_][A-Za-z_0-9]*_VISIBILITY_PRESET\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b[A-Za-z_][A-Za-z_0-9]*_BINARY_DIR\\b"
                              , reCompiled =
                                  Just (compileRegex True "\\b[A-Za-z_][A-Za-z_0-9]*_BINARY_DIR\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b[A-Za-z_][A-Za-z_0-9]*_SOURCE_DIR\\b"
                              , reCompiled =
                                  Just (compileRegex True "\\b[A-Za-z_][A-Za-z_0-9]*_SOURCE_DIR\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b[A-Za-z_][A-Za-z_0-9]*_VERSION\\b"
                              , reCompiled =
                                  Just (compileRegex True "\\b[A-Za-z_][A-Za-z_0-9]*_VERSION\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b[A-Za-z_][A-Za-z_0-9]*_VERSION_MAJOR\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex True "\\b[A-Za-z_][A-Za-z_0-9]*_VERSION_MAJOR\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b[A-Za-z_][A-Za-z_0-9]*_VERSION_MINOR\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex True "\\b[A-Za-z_][A-Za-z_0-9]*_VERSION_MINOR\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b[A-Za-z_][A-Za-z_0-9]*_VERSION_PATCH\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex True "\\b[A-Za-z_][A-Za-z_0-9]*_VERSION_PATCH\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b[A-Za-z_][A-Za-z_0-9]*_VERSION_TWEAK\\b"
                              , reCompiled =
                                  Just
                                    (compileRegex True "\\b[A-Za-z_][A-Za-z_0-9]*_VERSION_TWEAK\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Detect Variables"
          , Context
              { cName = "Detect Variables"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\$ENV\\{\\s*[\\w-]+\\s*\\}"
                              , reCompiled =
                                  Just (compileRegex True "\\$ENV\\{\\s*[\\w-]+\\s*\\}")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '$' '{'
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "VarSubst" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "DetectSimpleGEEnd"
          , Context
              { cName = "DetectSimpleGEEnd"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '>'
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop , Pop ]
                      }
                  ]
              , cAttribute = OtherTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop , Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Generator Expression"
          , Context
              { cName = "Generator Expression"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher =
                          IncludeRules ( "CMake" , "Detect Generator Expressions" )
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '>'
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "ANGLE-R"
                               , "COMMA"
                               , "CONFIGURATION"
                               , "INSTALL_PREFIX"
                               , "SEMICOLON"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "DetectSimpleGEEnd" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "0"
                               , "1"
                               , "AND"
                               , "ANGLE-R"
                               , "BOOL"
                               , "BUILD_INTERFACE"
                               , "COMMA"
                               , "COMPILER_FEATURES"
                               , "CONFIG"
                               , "CONFIGURATION"
                               , "CXX_COMPILER_ID"
                               , "CXX_COMPILER_VERSION"
                               , "C_COMPILER_ID"
                               , "C_COMPILER_VERSION"
                               , "EQUAL"
                               , "INSTALL_INTERFACE"
                               , "INSTALL_PREFIX"
                               , "JOIN"
                               , "LINK_ONLY"
                               , "LOWER_CASE"
                               , "MAKE_C_IDENTIFIER"
                               , "NOT"
                               , "OR"
                               , "PLATFORM_ID"
                               , "SEMICOLON"
                               , "STREQUAL"
                               , "TARGET_DIR"
                               , "TARGET_FILE"
                               , "TARGET_FILE_DIR"
                               , "TARGET_FILE_NAME"
                               , "TARGET_LINKER_FILE"
                               , "TARGET_LINKER_FILE_DIR"
                               , "TARGET_LINKER_FILE_NAME"
                               , "TARGET_NAME"
                               , "TARGET_OBJECTS"
                               , "TARGET_PDB_FILE"
                               , "TARGET_PDB_FILE_DIR"
                               , "TARGET_PDB_FILE_NAME"
                               , "TARGET_POLICY"
                               , "TARGET_PROPERTY"
                               , "TARGET_SONAME_FILE"
                               , "TARGET_SONAME_FILE_DIR"
                               , "TARGET_SONAME_FILE_NAME"
                               , "UPPER_CASE"
                               , "VERSION_EQUAL"
                               , "VERSION_GREATER"
                               , "VERSION_LESS"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "CMake" , "Detect Variables" )
                      , rAttribute = OtherTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = OtherTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Macro Args"
          , Context
              { cName = "Macro Args"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar ')'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\\\[\"$n\\\\]"
                              , reCompiled = Just (compileRegex True "\\\\[\"$n\\\\]")
                              , reCaseSensitive = True
                              }
                      , rAttribute = SpecialCharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "String" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\[(=*)\\["
                              , reCompiled = Just (compileRegex True "\\[(=*)\\[")
                              , reCaseSensitive = True
                              }
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Bracketed String" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Comment" ) ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "CMake" , "Detect Builtin Variables" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "CMake" , "Detect Variables" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          IncludeRules ( "CMake" , "Detect Generator Expressions" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Normal Text"
          , Context
              { cName = "Normal Text"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = WordDetect "if"
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Command Args" ) ]
                      }
                  , Rule
                      { rMatcher = WordDetect "else"
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Command Args" ) ]
                      }
                  , Rule
                      { rMatcher = WordDetect "elseif"
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Command Args" ) ]
                      }
                  , Rule
                      { rMatcher = WordDetect "endif"
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Command Args" ) ]
                      }
                  , Rule
                      { rMatcher = WordDetect "macro"
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Command Args" ) ]
                      }
                  , Rule
                      { rMatcher = WordDetect "endmacro"
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Command Args" ) ]
                      }
                  , Rule
                      { rMatcher = WordDetect "foreach"
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Command Args" ) ]
                      }
                  , Rule
                      { rMatcher = WordDetect "endforeach"
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Command Args" ) ]
                      }
                  , Rule
                      { rMatcher = WordDetect "while"
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Command Args" ) ]
                      }
                  , Rule
                      { rMatcher = WordDetect "endwhile"
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Command Args" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "add_compile_options"
                               , "add_custom_command"
                               , "add_custom_target"
                               , "add_definitions"
                               , "add_dependencies"
                               , "add_executable"
                               , "add_library"
                               , "add_subdirectory"
                               , "add_test"
                               , "aux_source_directory"
                               , "break"
                               , "build_command"
                               , "build_name"
                               , "cmake_host_system_information"
                               , "cmake_minimum_required"
                               , "cmake_policy"
                               , "configure_file"
                               , "continue"
                               , "create_test_sourcelist"
                               , "ctest_build"
                               , "ctest_configure"
                               , "ctest_coverage"
                               , "ctest_empty_binary_directory"
                               , "ctest_memcheck"
                               , "ctest_read_custom_files"
                               , "ctest_run_script"
                               , "ctest_sleep"
                               , "ctest_start"
                               , "ctest_submit"
                               , "ctest_test"
                               , "ctest_update"
                               , "ctest_upload"
                               , "define_property"
                               , "else"
                               , "elseif"
                               , "enable_language"
                               , "enable_testing"
                               , "endforeach"
                               , "endfunction"
                               , "endif"
                               , "endmacro"
                               , "endwhile"
                               , "exec_program"
                               , "execute_process"
                               , "export"
                               , "export_library_dependencies"
                               , "file"
                               , "find_file"
                               , "find_library"
                               , "find_package"
                               , "find_path"
                               , "find_program"
                               , "fltk_wrap_ui"
                               , "foreach"
                               , "function"
                               , "get_cmake_property"
                               , "get_directory_property"
                               , "get_filename_component"
                               , "get_property"
                               , "get_source_file_property"
                               , "get_target_property"
                               , "get_test_property"
                               , "if"
                               , "include"
                               , "include_directories"
                               , "include_external_msproject"
                               , "include_regular_expression"
                               , "install"
                               , "install_files"
                               , "install_programs"
                               , "install_targets"
                               , "link_directories"
                               , "link_libraries"
                               , "list"
                               , "load_cache"
                               , "load_command"
                               , "macro"
                               , "make_directory"
                               , "mark_as_advanced"
                               , "math"
                               , "message"
                               , "option"
                               , "output_required_files"
                               , "project"
                               , "qt_wrap_cpp"
                               , "qt_wrap_ui"
                               , "remove"
                               , "remove_definitions"
                               , "return"
                               , "separate_arguments"
                               , "set"
                               , "set_directory_properties"
                               , "set_property"
                               , "set_source_files_properties"
                               , "set_target_properties"
                               , "set_tests_properties"
                               , "site_name"
                               , "source_group"
                               , "string"
                               , "subdir_depends"
                               , "subdirs"
                               , "target_compile_definitions"
                               , "target_compile_features"
                               , "target_compile_options"
                               , "target_include_directories"
                               , "target_link_libraries"
                               , "target_sources"
                               , "try_compile"
                               , "try_run"
                               , "unset"
                               , "use_mangled_mesa"
                               , "utility_source"
                               , "variable_requires"
                               , "variable_watch"
                               , "while"
                               , "write_file"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Command Args" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "itk_wrap_tcl"
                               , "vtk_make_instantiator"
                               , "vtk_wrap_java"
                               , "vtk_wrap_python"
                               , "vtk_wrap_tcl"
                               ])
                      , rAttribute = ExtensionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = False
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "#\\s*BEGIN.*$"
                              , reCompiled = Just (compileRegex True "#\\s*BEGIN.*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = RegionMarkerTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "#\\s*END.*$"
                              , reCompiled = Just (compileRegex True "#\\s*END.*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = RegionMarkerTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "#\\[(=*)\\[\\.rst:"
                              , reCompiled = Just (compileRegex True "#\\[(=*)\\[\\.rst:")
                              , reCaseSensitive = True
                              }
                      , rAttribute = RegionMarkerTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Just 0
                      , rContextSwitch = [ Push ( "CMake" , "RST Documentation" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "#\\[(=*)\\["
                              , reCompiled = Just (compileRegex True "#\\[(=*)\\[")
                              , reCaseSensitive = True
                              }
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Just 0
                      , rContextSwitch = [ Push ( "CMake" , "Bracketed Comment" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Comment" ) ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "CMake" , "Detect Variables" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\w+\\s*(?=\\()"
                              , reCompiled = Just (compileRegex True "\\w+\\s*(?=\\()")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "CMake" , "Macro Args" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "RST Documentation"
          , Context
              { cName = "RST Documentation"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "#?\\]%1\\]"
                              , reCompiled = Nothing
                              , reCaseSensitive = True
                              }
                      , rAttribute = RegionMarkerTok
                      , rIncludeAttribute = False
                      , rDynamic = True
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Just 0
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = True
              }
          )
        , ( "String"
          , Context
              { cName = "String"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\"(?=[ );]|$)"
                              , reCompiled = Just (compileRegex True "\"(?=[ );]|$)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\\\[\"$nrt\\\\]"
                              , reCompiled = Just (compileRegex True "\\\\[\"$nrt\\\\]")
                              , reCaseSensitive = True
                              }
                      , rAttribute = SpecialCharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "CMake" , "Detect Variables" )
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          IncludeRules ( "CMake" , "Detect Generator Expressions" )
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "VarSubst"
          , Context
              { cName = "VarSubst"
              , cSyntax = "CMake"
              , cRules =
                  [ Rule
                      { rMatcher = IncludeRules ( "CMake" , "Detect Builtin Variables" )
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectIdentifier
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "CMake" , "Detect Variables" )
                      , rAttribute = VariableTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = VariableTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Alexander Neundorf (neundorf@kde.org)"
  , sVersion = "3"
  , sLicense = "LGPLv2+"
  , sExtensions = [ "CMakeLists.txt" , "*.cmake" , "*.cmake.in" ]
  , sStartingContext = "Normal Text"
  }
