{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Ats (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "ATS"
  , sFilename = "ats.xml"
  , sShortname = "Ats"
  , sContexts =
      fromList
        [ ( "Existential Context"
          , Context
              { cName = "Existential Context"
              , cSyntax = "ATS"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar ']'
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Function Keyword Context"
          , Context
              { cName = "Function Keyword Context"
              , cSyntax = "ATS"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '='
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = DetectChar '{'
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "ATS" , "Universal Context" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '['
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "ATS" , "Existential Context" ) ]
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "ATS" , "Normal" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Multiline C-style Comment"
          , Context
              { cName = "Multiline C-style Comment"
              , cSyntax = "ATS"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Multiline Comment"
          , Context
              { cName = "Multiline Comment"
              , cSyntax = "ATS"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' ')'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '(' '*'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "ATS" , "Multiline Comment" ) ]
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Normal"
          , Context
              { cName = "Normal"
              , cSyntax = "ATS"
              , cRules =
                  [ Rule
                      { rMatcher = StringDetect "////"
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "ATS" , "Rest-of-file Comment" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '(' '*'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "ATS" , "Multiline Comment" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '/' '*'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "ATS" , "Multiline C-style Comment" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '/' '/'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "ATS" , "Singleline C++ style Comment" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '.' '<'
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "ATS" , "Termination Metrics Context" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "`\\s*[A-Za-z\\300-\\326\\330-\\366\\370-\\377_][A-Za-z\\300-\\326\\330-\\366\\370-\\3770-9_']*"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "`\\s*[A-Za-z\\300-\\326\\330-\\366\\370-\\377_][A-Za-z\\300-\\326\\330-\\366\\370-\\3770-9_']*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "absprop"
                               , "abst0ype"
                               , "abstype"
                               , "absview"
                               , "absviewt0ype"
                               , "absviewtype"
                               , "absvt0ype"
                               , "absvtype"
                               , "and"
                               , "as"
                               , "assume"
                               , "begin"
                               , "break"
                               , "classdec"
                               , "continue"
                               , "dataprop"
                               , "datasort"
                               , "datatype"
                               , "dataview"
                               , "dataviewtype"
                               , "datavtype"
                               , "do"
                               , "dynload"
                               , "else"
                               , "end"
                               , "exception"
                               , "extern"
                               , "extval"
                               , "extype"
                               , "for"
                               , "if"
                               , "in"
                               , "infix"
                               , "infixl"
                               , "infixr"
                               , "let"
                               , "local"
                               , "macdef"
                               , "macrodef"
                               , "nonfix"
                               , "of"
                               , "op"
                               , "overload"
                               , "postfix"
                               , "prefix"
                               , "propdef"
                               , "prval"
                               , "prvar"
                               , "rec"
                               , "scase"
                               , "sif"
                               , "sortdef"
                               , "sta"
                               , "stacst"
                               , "stadef"
                               , "staload"
                               , "stavar"
                               , "symelim"
                               , "symintr"
                               , "then"
                               , "tkindef"
                               , "try"
                               , "type"
                               , "typedef"
                               , "val"
                               , "var"
                               , "viewdef"
                               , "viewtypedef"
                               , "vtypedef"
                               , "when"
                               , "where"
                               , "while"
                               , "with"
                               , "withprop"
                               , "withtype"
                               , "withview"
                               , "withviewtype"
                               , "withvtype"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "castfn"
                               , "fix"
                               , "fn"
                               , "fnx"
                               , "fun"
                               , "implement"
                               , "implmnt"
                               , "lam"
                               , "llam"
                               , "praxi"
                               , "prfn"
                               , "prfun"
                               , "primplement"
                               , "primplmnt"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "ATS" , "Function Keyword Context" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "#assert"
                               , "#define"
                               , "#elif"
                               , "#elifdef"
                               , "#elifndef"
                               , "#else"
                               , "#endif"
                               , "#error"
                               , "#if"
                               , "#ifdef"
                               , "#ifndef"
                               , "#include"
                               , "#print"
                               , "#then"
                               , "#undef"
                               , "$arrpsz"
                               , "$arrptrsize"
                               , "$delay"
                               , "$effmask"
                               , "$effmask_all"
                               , "$effmask_exn"
                               , "$effmask_ntm"
                               , "$effmask_ref"
                               , "$effmask_wrt"
                               , "$extern"
                               , "$extkind"
                               , "$extval"
                               , "$extype"
                               , "$extype_struct"
                               , "$ldelay"
                               , "$list"
                               , "$list_t"
                               , "$list_vt"
                               , "$lst"
                               , "$lst_t"
                               , "$lst_vt"
                               , "$myfilename"
                               , "$myfunction"
                               , "$mylocation"
                               , "$raise"
                               , "$rec"
                               , "$rec_t"
                               , "$rec_vt"
                               , "$record"
                               , "$record_t"
                               , "$record_vt"
                               , "$showtype"
                               , "$tup"
                               , "$tup_t"
                               , "$tup_vt"
                               , "$tuple"
                               , "$tuple_t"
                               , "$tuple_vt"
                               ])
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "[A-Za-z\\300-\\326\\330-\\366\\370-\\377_][A-Za-z\\300-\\326\\330-\\366\\370-\\3770-9_']*"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "[A-Za-z\\300-\\326\\330-\\366\\370-\\377_][A-Za-z\\300-\\326\\330-\\366\\370-\\3770-9_']*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "~?0[xX][0-9A-Fa-f_]+"
                              , reCompiled = Just (compileRegex True "~?0[xX][0-9A-Fa-f_]+")
                              , reCaseSensitive = True
                              }
                      , rAttribute = BaseNTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "~?[0-9][0-9_]*((\\.([0-9][0-9_]*)?([eE][-+]?[0-9][0-9_]*)?)|([eE][-+]?[0-9][0-9_]*))"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "~?[0-9][0-9_]*((\\.([0-9][0-9_]*)?([eE][-+]?[0-9][0-9_]*)?)|([eE][-+]?[0-9][0-9_]*))")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "~?[0-9][0-9_]*"
                              , reCompiled = Just (compileRegex True "~?[0-9][0-9_]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Rest-of-file Comment"
          , Context
              { cName = "Rest-of-file Comment"
              , cSyntax = "ATS"
              , cRules = []
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Singleline C++ style Comment"
          , Context
              { cName = "Singleline C++ style Comment"
              , cSyntax = "ATS"
              , cRules = []
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "String Context"
          , Context
              { cName = "String Context"
              , cSyntax = "ATS"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "(\\\\[ntbr'\"\\\\]|\\\\[0-9]{3}|\\\\x[0-9A-Fa-f]{2})"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True "(\\\\[ntbr'\"\\\\]|\\\\[0-9]{3}|\\\\x[0-9A-Fa-f]{2})")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\\\$"
                              , reCompiled = Just (compileRegex True "\\\\$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Termination Metrics Context"
          , Context
              { cName = "Termination Metrics Context"
              , cSyntax = "ATS"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '>' '.'
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Universal Context"
          , Context
              { cName = "Universal Context"
              , cSyntax = "ATS"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = DataTypeTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Kiwamu Okabe (kiwamu@debian.or.jp)"
  , sVersion = "0.01"
  , sLicense = "LGPL"
  , sExtensions = [ "*.dats" , "*.sats" , "*.hats" ]
  , sStartingContext = "Normal"
  }
