{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Asn1 (syntax) where

import Skylighting.Types
import Data.Map
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "ASN.1"
  , sFilename = "asn1.xml"
  , sShortname = "Asn1"
  , sContexts =
      fromList
        [ ( "Comment"
          , Context
              { cName = "Comment"
              , cSyntax = "ASN.1"
              , cRules = []
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Normal Text"
          , Context
              { cName = "Normal Text"
              , cSyntax = "ASN.1"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "APPLICATION"
                               , "BEGIN"
                               , "DEFAULT"
                               , "DEFINITIONS"
                               , "END"
                               , "EXPORTS"
                               , "FALSE"
                               , "FROM"
                               , "IMPORTS"
                               , "OPTIONAL"
                               , "PRIVATE"
                               , "TRUE"
                               , "UNIVERSAL"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "BOOLEAN"
                               , "CHOICE"
                               , "ENUMERATED"
                               , "INTEGER"
                               , "NULL"
                               , "OCTET STRING"
                               , "OF"
                               , "REAL"
                               , "SEQUENCE"
                               , "SET"
                               , "StringStore"
                               , "VisibleString"
                               ])
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Detect2Chars '-' '-'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "ASN.1" , "Comment" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Philippe Rigault"
  , sVersion = "2"
  , sLicense = "GPL"
  , sExtensions = [ "*.asn" , "*.asn1" ]
  , sStartingContext = "Normal Text"
  }
