{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Apache (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "Apache Configuration"
  , sFilename = "apache.xml"
  , sShortname = "Apache"
  , sContexts =
      fromList
        [ ( "Alert"
          , Context
              { cName = "Alert"
              , cSyntax = "Apache Configuration"
              , cRules = []
              , cAttribute = ErrorTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Alternative Directives"
          , Context
              { cName = "Alternative Directives"
              , cSyntax = "Apache Configuration"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "alert"
                               , "All"
                               , "Allow,Deny"
                               , "always"
                               , "Any"
                               , "Ascending"
                               , "auth"
                               , "auth-int"
                               , "AuthConfig"
                               , "Basic"
                               , "Block"
                               , "CompatEnvVars"
                               , "Connection"
                               , "Cookie"
                               , "Cookie2"
                               , "crit"
                               , "Date"
                               , "DB"
                               , "dbm:"
                               , "dc:"
                               , "debug"
                               , "Default"
                               , "Deny,Allow"
                               , "Descending"
                               , "Description"
                               , "Digest"
                               , "DNS"
                               , "Double"
                               , "EMail"
                               , "emerg"
                               , "error"
                               , "ExecCGI"
                               , "ExportCertData"
                               , "FakeBasicAuth"
                               , "Fallback"
                               , "fcntl"
                               , "fcntl:"
                               , "file:"
                               , "FileInfo"
                               , "Filters"
                               , "finding"
                               , "flock"
                               , "flock:"
                               , "FollowSymLinks"
                               , "formatted"
                               , "Full"
                               , "GDBM"
                               , "GDSF"
                               , "Handlers"
                               , "Ignore"
                               , "Includes"
                               , "IncludesNOEXEC"
                               , "Indexes"
                               , "info"
                               , "inherit"
                               , "INode"
                               , "IsError"
                               , "Keep-Alive"
                               , "Limit"
                               , "LRU"
                               , "Major"
                               , "map"
                               , "MD5"
                               , "MD5-sess"
                               , "Min"
                               , "Minimal"
                               , "Minor"
                               , "MTime"
                               , "MultiViews"
                               , "Mutual-failure"
                               , "Name"
                               , "NDBM"
                               , "NegotiatedOnly"
                               , "Netscape"
                               , "never"
                               , "no"
                               , "nocontent"
                               , "None"
                               , "nonenotnull"
                               , "notice"
                               , "Off"
                               , "On"
                               , "optional"
                               , "optional_no_ca"
                               , "Options"
                               , "OptRenegotiate"
                               , "OS"
                               , "posixsem"
                               , "Prefer"
                               , "Prod"
                               , "ProductOnly"
                               , "Proxy-Authenticate"
                               , "Proxy-Authorization"
                               , "pthread"
                               , "referer"
                               , "Registry"
                               , "Registry-Strict"
                               , "require"
                               , "RFC2109"
                               , "RFC2965"
                               , "Script"
                               , "SDBM"
                               , "searching"
                               , "sem"
                               , "semiformatted"
                               , "shm:"
                               , "Size"
                               , "SSL"
                               , "SSLv2"
                               , "SSLv3"
                               , "StartBody"
                               , "STARTTLS"
                               , "StdEnvVars"
                               , "StrictRequire"
                               , "SymLinksIfOwnerMatch"
                               , "sysvsem"
                               , "TE"
                               , "TLS"
                               , "TLSv1"
                               , "Trailers"
                               , "Transfer-Encoding"
                               , "unformatted"
                               , "Upgrade"
                               , "warn"
                               , "yes"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '-'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '+'
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          IncludeRules ( "Apache Configuration" , "Comment Alert" )
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = CharTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Comment"
          , Context
              { cName = "Comment"
              , cSyntax = "Apache Configuration"
              , cRules =
                  [ Rule
                      { rMatcher = DetectSpaces
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = IncludeRules ( "Alerts" , "" )
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectIdentifier
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Comment Alert"
          , Context
              { cName = "Comment Alert"
              , cSyntax = "Apache Configuration"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = ErrorTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Apache Configuration" , "Alert" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Container Close"
          , Context
              { cName = "Container Close"
              , cSyntax = "Apache Configuration"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '>'
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Apache Configuration" , "Alert" ) ]
                      }
                  ]
              , cAttribute = FunctionTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Container Open"
          , Context
              { cName = "Container Open"
              , cSyntax = "Apache Configuration"
              , cRules =
                  [ Rule
                      { rMatcher = DetectChar '>'
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Apache Configuration" , "Alert" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[^#>]*"
                              , reCompiled = Just (compileRegex True "[^#>]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = AttributeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          IncludeRules ( "Apache Configuration" , "Comment Alert" )
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = FunctionTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Integer Directives"
          , Context
              { cName = "Integer Directives"
              , cSyntax = "Apache Configuration"
              , cRules =
                  [ Rule
                      { rMatcher = Float
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "Apache Configuration" , "Integer Directives" ) ]
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "Apache Configuration" , "Integer Directives" ) ]
                      }
                  , Rule
                      { rMatcher =
                          IncludeRules ( "Apache Configuration" , "Comment Alert" )
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = CharTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "String Directives"
          , Context
              { cName = "String Directives"
              , cSyntax = "Apache Configuration"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[^#]*"
                              , reCompiled = Just (compileRegex True "[^#]*")
                              , reCaseSensitive = True
                              }
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          IncludeRules ( "Apache Configuration" , "Comment Alert" )
                      , rAttribute = ExtensionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = ExtensionTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "apache"
          , Context
              { cName = "apache"
              , cSyntax = "Apache Configuration"
              , cRules =
                  [ Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "AcceptFilter"
                               , "AccessFileName"
                               , "Action"
                               , "AddAlt"
                               , "AddAltByEncoding"
                               , "AddAltByType"
                               , "AddCharset"
                               , "AddDefaultCharset"
                               , "AddDescription"
                               , "AddEncoding"
                               , "AddHandler"
                               , "AddIcon"
                               , "AddIconByEncoding"
                               , "AddIconByType"
                               , "AddInputFilter"
                               , "AddLanguage"
                               , "AddModuleInfo"
                               , "AddOutputFilter"
                               , "AddOutputFilterByType"
                               , "AddType"
                               , "Alias"
                               , "AliasMatch"
                               , "Allow"
                               , "Anonymous"
                               , "AuthBasicProvider"
                               , "AuthDBMGroupFile"
                               , "AuthDBMUserFile"
                               , "AuthDigestDomain"
                               , "AuthDigestFile"
                               , "AuthDigestGroupFile"
                               , "AuthDigestNonceFormat"
                               , "AuthDigestProvider"
                               , "AuthGroupFile"
                               , "AuthLDAPBindDN"
                               , "AuthLDAPBindPassword"
                               , "AuthLDAPCharsetConfig"
                               , "AuthLDAPGroupAttribute"
                               , "AuthLDAPUrl"
                               , "AuthName"
                               , "AuthUserFile"
                               , "BrowserMatch"
                               , "BrowserMatchNoCase"
                               , "BS2000Account"
                               , "CacheDisable"
                               , "CacheEnable"
                               , "CacheFile"
                               , "CacheGcClean"
                               , "CacheGcUnused"
                               , "CacheRoot"
                               , "CGIMapExtension"
                               , "CharsetDefault"
                               , "CharsetOptions"
                               , "CharsetSourceEnc"
                               , "CookieDomain"
                               , "CookieLog"
                               , "CookieName"
                               , "CoreDumpDirectory"
                               , "CustomLog"
                               , "Dav"
                               , "DavGenericLockDB"
                               , "DavLockDB"
                               , "DBDParams"
                               , "DBDPrepareSQL"
                               , "DBDriver"
                               , "DefaultIcon"
                               , "DefaultLanguage"
                               , "DefaultType"
                               , "DeflateFilterNote"
                               , "Deny"
                               , "DirectoryIndex"
                               , "DocumentRoot"
                               , "ErrorDocument"
                               , "ErrorLog"
                               , "Example"
                               , "ExpiresByType"
                               , "ExpiresDefault"
                               , "ExtFilterDefine"
                               , "ExtFilterOptions"
                               , "FilterChain"
                               , "FilterDeclare"
                               , "FilterProtocol"
                               , "FilterProvider"
                               , "FilterTrace"
                               , "ForceType"
                               , "ForensicLog"
                               , "Group"
                               , "Header"
                               , "HeaderName"
                               , "ImapBase"
                               , "Include"
                               , "IndexIgnore"
                               , "IndexOptions"
                               , "IndexStyleSheet"
                               , "ISAPICacheFile"
                               , "LanguagePriority"
                               , "LDAPSharedCacheFile"
                               , "LDAPTrustedCA"
                               , "LDAPTrustedCAType"
                               , "LDAPTrustedClientCert"
                               , "LDAPTrustedGlobalCert"
                               , "Listen"
                               , "LoadFile"
                               , "LoadModule"
                               , "LockFile"
                               , "LogFormat"
                               , "MetaDir"
                               , "MetaSuffix"
                               , "MimeMagicFile"
                               , "MMapFile"
                               , "NameVirtualHost"
                               , "NoProxy"
                               , "NWSSLTrustedCerts"
                               , "NWSSLUpgradeable"
                               , "PassEnv"
                               , "PidFile"
                               , "ProxyBlock"
                               , "ProxyDomain"
                               , "ProxyPass"
                               , "ProxyPassReverse"
                               , "ProxyPassReverseCookieDomain"
                               , "ProxyPassReverseCookiePath"
                               , "ProxyRemote"
                               , "ProxyRemoteMatch"
                               , "ReadmeName"
                               , "Redirect"
                               , "RedirectMatch"
                               , "RedirectPermanent"
                               , "RedirectTemp"
                               , "RemoveCharset"
                               , "RemoveEncoding"
                               , "RemoveHandler"
                               , "RemoveInputFilter"
                               , "RemoveLanguage"
                               , "RemoveOutputFilter"
                               , "RemoveType"
                               , "RequestHeader"
                               , "Require"
                               , "RewriteBase"
                               , "RewriteCond"
                               , "RewriteLock"
                               , "RewriteLog"
                               , "RewriteMap"
                               , "RewriteRule"
                               , "ScoreBoardFile"
                               , "Script"
                               , "ScriptAlias"
                               , "ScriptAliasMatch"
                               , "ScriptLog"
                               , "ScriptSock"
                               , "SecureListen"
                               , "ServerAdmin"
                               , "ServerAlias"
                               , "ServerName"
                               , "ServerPath"
                               , "ServerRoot"
                               , "SetEnv"
                               , "SetEnvIf"
                               , "SetEnvIfNoCase"
                               , "SetHandler"
                               , "SetInputFilter"
                               , "SetOutputFilter"
                               , "SSIEndTag"
                               , "SSIErrorMsg"
                               , "SSIStartTag"
                               , "SSITimeFormat"
                               , "SSIUndefinedEcho"
                               , "SSLCACertificateFile"
                               , "SSLCACertificatePath"
                               , "SSLCADNRequestFile"
                               , "SSLCADNRequestPath"
                               , "SSLCARevocationFile"
                               , "SSLCARevocationPath"
                               , "SSLCertificateChainFile"
                               , "SSLCertificateFile"
                               , "SSLCertificateKeyFile"
                               , "SSLCipherSuite"
                               , "SSLCryptoDevice"
                               , "SSLHonorCiperOrder"
                               , "SSLPassPhraseDialog"
                               , "SSLProxyCACertificateFile"
                               , "SSLProxyCACertificatePath"
                               , "SSLProxyCARevocationFile"
                               , "SSLProxyCARevocationPath"
                               , "SSLProxyCipherSuite"
                               , "SSLProxyMachineCertificateFile"
                               , "SSLProxyMachineCertificatePath"
                               , "SSLProxyProtocol"
                               , "SSLRandomSeed"
                               , "SSLRequire"
                               , "SSLRequireSSL"
                               , "SSLUserName"
                               , "SuexecUserGroup"
                               , "TransferLog"
                               , "TypesConfig"
                               , "UnsetEnv"
                               , "User"
                               , "UserDir"
                               , "VirtualDocumentRoot"
                               , "VirtualDocumentRootIP"
                               , "VirtualScriptAlias"
                               , "VirtualScriptAliasIP"
                               , "Win32DisableAcceptEx"
                               ])
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "Apache Configuration" , "String Directives" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "AllowCONNECT"
                               , "AssignUserID"
                               , "AuthDigestNonceLifetime"
                               , "AuthDigestShmemSize"
                               , "CacheDefaultExpire"
                               , "CacheDirLength"
                               , "CacheDirLevels"
                               , "CacheForceCompletion"
                               , "CacheGcDaily"
                               , "CacheGcInterval"
                               , "CacheGcMemUsage"
                               , "CacheLastModifiedFactor"
                               , "CacheMaxExpire"
                               , "CacheMaxFileSize"
                               , "CacheMinFileSize"
                               , "CacheSize"
                               , "CacheTimeMargin"
                               , "ChildPerUserID"
                               , "CookieExpires"
                               , "DavMinTimeout"
                               , "DBDExptime"
                               , "DBDKeep"
                               , "DBDMax"
                               , "DBDMin"
                               , "DBDPersist"
                               , "DeflateBufferSize"
                               , "DeflateCompressionLevel"
                               , "DeflateMemLevel"
                               , "DeflateWindowSize"
                               , "IdentityCheckTimeout"
                               , "ISAPIReadAheadBuffer"
                               , "KeepAliveTimeout"
                               , "LDAPCacheEntries"
                               , "LDAPCacheTTL"
                               , "LDAPConnectionTimeout"
                               , "LDAPOpCacheEntries"
                               , "LDAPOpCacheTTL"
                               , "LDAPSharedCacheSize"
                               , "LimitInternalRecursion"
                               , "LimitRequestBody"
                               , "LimitRequestFields"
                               , "LimitRequestFieldsize"
                               , "LimitRequestLine"
                               , "LimitXMLRequestBody"
                               , "ListenBacklog"
                               , "MaxClients"
                               , "MaxKeepAliveRequests"
                               , "MaxMemFree"
                               , "MaxRequestsPerChild"
                               , "MaxRequestsPerThread"
                               , "MaxSpareServers"
                               , "MaxSpareThreads"
                               , "MaxThreads"
                               , "MaxThreadsPerChild"
                               , "MCacheMaxObjectCount"
                               , "MCacheMaxObjectSize"
                               , "MCacheMaxStreamingBuffer"
                               , "MCacheMinObjectSize"
                               , "MCacheSize"
                               , "MinSpareServers"
                               , "MinSpareThreads"
                               , "NumServers"
                               , "ProxyIOBufferSize"
                               , "ProxyMaxForwards"
                               , "ProxyReceiveBufferSize"
                               , "ProxyTimeout"
                               , "RewriteLogLevel"
                               , "RLimitCPU"
                               , "RLimitMEM"
                               , "RLimitNPROC"
                               , "ScriptLogBuffer"
                               , "ScriptLogLength"
                               , "SendBufferSize"
                               , "ServerLimit"
                               , "SSLProxyVerifyDepth"
                               , "SSLSessionCacheTimeout"
                               , "SSLVerifyDepth"
                               , "StartServers"
                               , "StartThreads"
                               , "ThreadLimit"
                               , "ThreadsPerChild"
                               , "ThreadStackSize"
                               , "TimeOut"
                               ])
                      , rAttribute = ExtensionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "Apache Configuration" , "Integer Directives" ) ]
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = False
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               False
                               [ "AcceptMutex"
                               , "AcceptPathInfo"
                               , "AllowEncodedSlashes"
                               , "AllowOverride"
                               , "Anonymous_Authoritative"
                               , "Anonymous_LogEmail"
                               , "Anonymous_MustGiveEmail"
                               , "Anonymous_NoUserID"
                               , "Anonymous_VerifyEmail"
                               , "AuthAuthoritative"
                               , "AuthBasicAuthoritative"
                               , "AuthBasicProvider"
                               , "AuthDBMAuthoritative"
                               , "AuthDBMType"
                               , "AuthDefaultAuthoritative"
                               , "AuthDigestAlgorithm"
                               , "AuthDigestNcCheck"
                               , "AuthDigestQop"
                               , "AuthLDAPAuthoritative"
                               , "AuthLDAPCompareDNOnServer"
                               , "AuthLDAPDereferenceAliases"
                               , "AuthLDAPEnabled"
                               , "AuthLDAPFrontPageHack"
                               , "AuthLDAPGroupAttributeIsDN"
                               , "AuthLDAPRemoteUserIsDN"
                               , "AuthType"
                               , "AuthzDBMAuthoritative"
                               , "AuthzDBMType"
                               , "AuthzDefaultAuthoritative"
                               , "AuthzGroupFileAuthoritative"
                               , "AuthzLDAPAuthoritative"
                               , "AuthzOwnerAuthoritative"
                               , "AuthzUserAuthoritative"
                               , "BufferedLogs"
                               , "CacheExpiryCheck"
                               , "CacheIgnoreCacheControl"
                               , "CacheIgnoreHeaders"
                               , "CacheIgnoreNoLastMod"
                               , "CacheNegotiatedDocs"
                               , "CacheStoreNoStore"
                               , "CacheStorePrivate"
                               , "CheckSpelling"
                               , "ContentDigest"
                               , "CookieStyle"
                               , "CookieTracking"
                               , "CoreDumpDirectory"
                               , "CustomLog"
                               , "DavDepthInfinity"
                               , "DirectorySlash"
                               , "DumpIOInput"
                               , "DumpIOOutput"
                               , "EnableExceptionHook"
                               , "EnableMMAP"
                               , "EnableSendfile"
                               , "ExpiresActive"
                               , "ExtendedStatus"
                               , "FileETag"
                               , "ForceLanguagePriority"
                               , "HostnameLookups"
                               , "IdentityCheck"
                               , "ImapDefault"
                               , "ImapMenu"
                               , "IndexOrderDefault"
                               , "ISAPIAppendLogToErrors"
                               , "ISAPIAppendLogToQuery"
                               , "ISAPIFakeAsync"
                               , "ISAPILogNotSupported"
                               , "KeepAlive"
                               , "LDAPTrustedMode"
                               , "LDAPVerifyServerCert"
                               , "LogLevel"
                               , "MCacheRemovalAlgorithm"
                               , "MetaFiles"
                               , "ModMimeUsePathInfo"
                               , "MultiviewsMatch"
                               , "Options"
                               , "Order"
                               , "ProtocolEcho"
                               , "ProxyBadHeader"
                               , "ProxyErrorOverride"
                               , "ProxyPreserveHost"
                               , "ProxyRequests"
                               , "ProxyVia"
                               , "RewriteEngine"
                               , "RewriteOptions"
                               , "Satisfy"
                               , "ScriptInterpreterSource"
                               , "ServerSignature"
                               , "ServerTokens"
                               , "SSLEngine"
                               , "SSLMutex"
                               , "SSLOptions"
                               , "SSLProtocol"
                               , "SSLProxyEngine"
                               , "SSLProxyVerify"
                               , "SSLSessionCache"
                               , "SSLVerifyClient"
                               , "UseCanonicalName"
                               , "XBitHack"
                               ])
                      , rAttribute = ExtensionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "Apache Configuration" , "Alternative Directives" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "<\\w+"
                              , reCompiled = Just (compileRegex True "<\\w+")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "Apache Configuration" , "Container Open" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "</\\w+"
                              , reCompiled = Just (compileRegex True "</\\w+")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "Apache Configuration" , "Container Close" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '#'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = True
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "Apache Configuration" , "Comment" ) ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Jan Janssen (medhefgo@googlemail.com)"
  , sVersion = "2"
  , sLicense = "LGPL"
  , sExtensions =
      [ "httpd.conf"
      , "httpd2.conf"
      , "apache.conf"
      , "apache2.conf"
      , ".htaccess*"
      , ".htpasswd*"
      ]
  , sStartingContext = "apache"
  }
