{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.AlertIndent (syntax) where

import Skylighting.Types
import Data.Map

syntax :: Syntax
syntax = Syntax
  { sName = "Alerts_indent"
  , sFilename = "alert_indent.xml"
  , sShortname = "AlertIndent"
  , sContexts =
      fromList
        [ ( "Normal Text"
          , Context
              { cName = "Normal Text"
              , cSyntax = "Alerts_indent"
              , cRules =
                  [ Rule
                      { rMatcher = IncludeRules ( "Alerts" , "" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Dominik Haumann (dhdev@gmx.de)"
  , sVersion = "3"
  , sLicense = "LGPLv2+"
  , sExtensions = []
  , sStartingContext = "Normal Text"
  }
