{-# LANGUAGE OverloadedStrings #-}
module Skylighting.Syntax.Actionscript (syntax) where

import Skylighting.Types
import Data.Map
import Skylighting.Regex
import qualified Data.Set

syntax :: Syntax
syntax = Syntax
  { sName = "ActionScript 2.0"
  , sFilename = "actionscript.xml"
  , sShortname = "Actionscript"
  , sContexts =
      fromList
        [ ( "Commentar 1"
          , Context
              { cName = "Commentar 1"
              , cSyntax = "ActionScript 2.0"
              , cRules = []
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Commentar 2"
          , Context
              { cName = "Commentar 2"
              , cSyntax = "ActionScript 2.0"
              , cRules =
                  [ Rule
                      { rMatcher = Detect2Chars '*' '/'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = CommentTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Imports"
          , Context
              { cName = "Imports"
              , cSyntax = "ActionScript 2.0"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\s*.*$"
                              , reCompiled = Just (compileRegex True "\\s*.*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = ImportTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "Member"
          , Context
              { cName = "Member"
              , cSyntax = "ActionScript 2.0"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b[_a-zA-Z]\\w*(?=[\\s]*)"
                              , reCompiled =
                                  Just (compileRegex True "\\b[_a-zA-Z]\\w*(?=[\\s]*)")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = True
              , cFallthroughContext = [ Pop ]
              , cDynamic = False
              }
          )
        , ( "Normal"
          , Context
              { cName = "Normal"
              , cSyntax = "ActionScript 2.0"
              , cRules =
                  [ Rule
                      { rMatcher = IncludeRules ( "Javadoc" , "" )
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "_accProps"
                               , "_focusrect"
                               , "_global"
                               , "_highquality"
                               , "_level"
                               , "_parent"
                               , "_quality"
                               , "_root"
                               , "_soundbuftime"
                               , "maxscroll"
                               , "scroll"
                               , "this"
                               ])
                      , rAttribute = AttributeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "asfunction"
                               , "call"
                               , "chr"
                               , "clearInterval"
                               , "duplicateMovieClip"
                               , "escape"
                               , "eval"
                               , "fscommand"
                               , "getProperty"
                               , "getTimer"
                               , "getURL"
                               , "getVersion"
                               , "gotoAndPlay"
                               , "gotoAndStop"
                               , "ifFrameLoaded"
                               , "int"
                               , "isFinite"
                               , "isNaN"
                               , "length"
                               , "loadMovie"
                               , "loadMovieNum"
                               , "loadVariables"
                               , "loadVariablesNum"
                               , "mbchr"
                               , "mblength"
                               , "mbord"
                               , "mbsubstring"
                               , "nextFrame"
                               , "nextScene"
                               , "on"
                               , "onClipEvent"
                               , "ord"
                               , "parseFloat"
                               , "parseInt"
                               , "play"
                               , "prevFrame"
                               , "prevScene"
                               , "print"
                               , "printAsBitmap"
                               , "printAsBitmapNum"
                               , "printNum"
                               , "random"
                               , "removeMovieClip"
                               , "setInterval"
                               , "setProperty"
                               , "showRedrawRegions"
                               , "startDrag"
                               , "stop"
                               , "stopAllSounds"
                               , "stopDrag"
                               , "substring"
                               , "targetPath"
                               , "tellTarget"
                               , "toggleHighQuality"
                               , "trace"
                               , "typeof"
                               , "unescape"
                               , "unloadMovie"
                               , "unloadMovieNum"
                               , "updateAfterEvent"
                               ])
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "Accessibility"
                               , "Accordion"
                               , "Alert"
                               , "Binding"
                               , "Button"
                               , "Camera"
                               , "CellRenderer"
                               , "CheckBox"
                               , "Collection"
                               , "Color"
                               , "ComboBox"
                               , "ComponentMixins"
                               , "ContextMenu"
                               , "ContextMenuItem"
                               , "CustomActions"
                               , "CustomFormatter"
                               , "CustomValidator"
                               , "DataGrid"
                               , "DataHolder"
                               , "DataProvider"
                               , "DataSet"
                               , "DataType"
                               , "Date"
                               , "DateChooser"
                               , "DateField"
                               , "Delta"
                               , "DeltaItem"
                               , "DeltaPacket"
                               , "DepthManager"
                               , "EndPoint"
                               , "Error"
                               , "FaultEvent"
                               , "FocusManager"
                               , "Form"
                               , "Function"
                               , "Iterator"
                               , "Key"
                               , "Label"
                               , "List"
                               , "LoadVars"
                               , "Loader"
                               , "LocalConnection"
                               , "Log"
                               , "Math"
                               , "Media"
                               , "Menu"
                               , "MenuBar"
                               , "Microphone"
                               , "Mouse"
                               , "MovieClip"
                               , "MovieClipLoader"
                               , "NetConnection"
                               , "NetStream"
                               , "Number"
                               , "NumericStepper"
                               , "PendingCall"
                               , "PopUpManager"
                               , "PrintJob"
                               , "ProgressBar"
                               , "RDBMSResolver"
                               , "RadioButton"
                               , "RelayResponder"
                               , "SOAPCall"
                               , "Screen"
                               , "ScrollPane"
                               , "Selection"
                               , "SharedObject"
                               , "Slide"
                               , "Sound"
                               , "Stage"
                               , "StyleManager"
                               , "System"
                               , "TextArea"
                               , "TextField"
                               , "TextFormat"
                               , "TextInput"
                               , "TextSnapshot"
                               , "TransferObject"
                               , "Tree"
                               , "TreeDataProvider"
                               , "TypedValue"
                               , "UIComponent"
                               , "UIEventDispatcher"
                               , "UIObject"
                               , "Video"
                               , "WebService"
                               , "WebServiceConnector"
                               , "Window"
                               , "XML"
                               , "XMLConnector"
                               , "XUpdateResolver"
                               ])
                      , rAttribute = BuiltInTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "add"
                               , "and"
                               , "break"
                               , "case"
                               , "catch"
                               , "class"
                               , "continue"
                               , "default"
                               , "delete"
                               , "do"
                               , "dynamic"
                               , "else"
                               , "eq"
                               , "extends"
                               , "finally"
                               , "for"
                               , "function"
                               , "ge"
                               , "get"
                               , "gt"
                               , "if"
                               , "implements"
                               , "import"
                               , "in"
                               , "instanceof"
                               , "interface"
                               , "intrinsic"
                               , "le"
                               , "lt"
                               , "ne"
                               , "new"
                               , "not"
                               , "or"
                               , "private"
                               , "public"
                               , "return"
                               , "set"
                               , "static"
                               , "switch"
                               , "throw"
                               , "try"
                               , "var"
                               , "void"
                               , "while"
                               , "with"
                               ])
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "-Infinity"
                               , "Infinity"
                               , "NaN"
                               , "false"
                               , "newline"
                               , "null"
                               , "true"
                               , "undefined"
                               ])
                      , rAttribute = ConstantTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          Keyword
                            KeywordAttr
                              { keywordCaseSensitive = True
                              , keywordDelims =
                                  Data.Set.fromList "\t\n !%&()*+,-./:;<=>?[\\]^{|}~"
                              }
                            (makeWordSet
                               True
                               [ "Array" , "Boolean" , "Number" , "Object" , "String" , "Void" ])
                      , rAttribute = DataTypeTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Float
                      , rAttribute = FloatTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren =
                          [ Rule
                              { rMatcher = AnyChar "fF"
                              , rAttribute = FloatTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = True
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          ]
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCOct
                      , rAttribute = BaseNTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCHex
                      , rAttribute = BaseNTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = Int
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren =
                          [ Rule
                              { rMatcher = StringDetect "ULL"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          , Rule
                              { rMatcher = StringDetect "LUL"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          , Rule
                              { rMatcher = StringDetect "LLU"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          , Rule
                              { rMatcher = StringDetect "UL"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          , Rule
                              { rMatcher = StringDetect "LU"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          , Rule
                              { rMatcher = StringDetect "LL"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          , Rule
                              { rMatcher = StringDetect "U"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          , Rule
                              { rMatcher = StringDetect "L"
                              , rAttribute = DecValTok
                              , rIncludeAttribute = False
                              , rDynamic = False
                              , rCaseSensitive = False
                              , rChildren = []
                              , rLookahead = False
                              , rFirstNonspace = False
                              , rColumn = Nothing
                              , rContextSwitch = []
                              }
                          ]
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCChar
                      , rAttribute = CharTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "//\\s*BEGIN.*$"
                              , reCompiled = Just (compileRegex True "//\\s*BEGIN.*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "//\\s*END.*$"
                              , reCompiled = Just (compileRegex True "//\\s*END.*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = DecValTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "ActionScript 2.0" , "String" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '/' '/'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "ActionScript 2.0" , "Commentar 1" ) ]
                      }
                  , Rule
                      { rMatcher = Detect2Chars '/' '*'
                      , rAttribute = CommentTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "ActionScript 2.0" , "Commentar 2" ) ]
                      }
                  , Rule
                      { rMatcher = DetectChar '{'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '}'
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\.{3,3}\\s+"
                              , reCompiled = Just (compileRegex True "\\.{3,3}\\s+")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b(import\\s+static)\\b"
                              , reCompiled = Just (compileRegex True "\\b(import\\s+static)\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch =
                          [ Push ( "ActionScript 2.0" , "StaticImports" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\b(package|import)\\b"
                              , reCompiled = Just (compileRegex True "\\b(package|import)\\b")
                              , reCaseSensitive = True
                              }
                      , rAttribute = KeywordTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "ActionScript 2.0" , "Imports" ) ]
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString =
                                  "\\b[_\\w][_\\w\\d]*(?=[\\s]*(/\\*\\s*\\d+\\s*\\*/\\s*)?[(])"
                              , reCompiled =
                                  Just
                                    (compileRegex
                                       True
                                       "\\b[_\\w][_\\w\\d]*(?=[\\s]*(/\\*\\s*\\d+\\s*\\*/\\s*)?[(])")
                              , reCaseSensitive = True
                              }
                      , rAttribute = FunctionTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "[.]{1,1}"
                              , reCompiled = Just (compileRegex True "[.]{1,1}")
                              , reCaseSensitive = True
                              }
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Push ( "ActionScript 2.0" , "Member" ) ]
                      }
                  , Rule
                      { rMatcher = AnyChar ":!%&()+,-/.*<=>?[]|~^;"
                      , rAttribute = NormalTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = []
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "StaticImports"
          , Context
              { cName = "StaticImports"
              , cSyntax = "ActionScript 2.0"
              , cRules =
                  [ Rule
                      { rMatcher =
                          RegExpr
                            RE
                              { reString = "\\s*.*$"
                              , reCompiled = Just (compileRegex True "\\s*.*$")
                              , reCaseSensitive = True
                              }
                      , rAttribute = ImportTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = NormalTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        , ( "String"
          , Context
              { cName = "String"
              , cSyntax = "ActionScript 2.0"
              , cRules =
                  [ Rule
                      { rMatcher = LineContinue
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = HlCStringChar
                      , rAttribute = SpecialStringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = []
                      }
                  , Rule
                      { rMatcher = DetectChar '"'
                      , rAttribute = StringTok
                      , rIncludeAttribute = False
                      , rDynamic = False
                      , rCaseSensitive = True
                      , rChildren = []
                      , rLookahead = False
                      , rFirstNonspace = False
                      , rColumn = Nothing
                      , rContextSwitch = [ Pop ]
                      }
                  ]
              , cAttribute = StringTok
              , cLineEmptyContext = []
              , cLineEndContext = [ Pop ]
              , cLineBeginContext = []
              , cFallthrough = False
              , cFallthroughContext = []
              , cDynamic = False
              }
          )
        ]
  , sAuthor = "Aaron Miller (armantic101@gmail.com)"
  , sVersion = "2"
  , sLicense = "LGPL"
  , sExtensions = [ "*.as" ]
  , sStartingContext = "Normal"
  }
