--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.GL.Functions
-- Copyright   :  (c) Sven Panne 2016
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- All raw functions from the
-- <http://www.opengl.org/registry/ OpenGL registry>.
--
--------------------------------------------------------------------------------

module Graphics.GL.Functions (
  glAccum,
  glAccumxOES,
  glActiveProgramEXT,
  glActiveShaderProgram,
  glActiveShaderProgramEXT,
  glActiveStencilFaceEXT,
  glActiveTexture,
  glActiveTextureARB,
  glActiveVaryingNV,
  glAlphaFragmentOp1ATI,
  glAlphaFragmentOp2ATI,
  glAlphaFragmentOp3ATI,
  glAlphaFunc,
  glAlphaFuncQCOM,
  glAlphaFuncx,
  glAlphaFuncxOES,
  glApplyFramebufferAttachmentCMAAINTEL,
  glApplyTextureEXT,
  glAreProgramsResidentNV,
  glAreTexturesResident,
  glAreTexturesResidentEXT,
  glArrayElement,
  glArrayElementEXT,
  glArrayObjectATI,
  glAsyncMarkerSGIX,
  glAttachObjectARB,
  glAttachShader,
  glBegin,
  glBeginConditionalRender,
  glBeginConditionalRenderNV,
  glBeginConditionalRenderNVX,
  glBeginFragmentShaderATI,
  glBeginOcclusionQueryNV,
  glBeginPerfMonitorAMD,
  glBeginPerfQueryINTEL,
  glBeginQuery,
  glBeginQueryARB,
  glBeginQueryEXT,
  glBeginQueryIndexed,
  glBeginTransformFeedback,
  glBeginTransformFeedbackEXT,
  glBeginTransformFeedbackNV,
  glBeginVertexShaderEXT,
  glBeginVideoCaptureNV,
  glBindAttribLocation,
  glBindAttribLocationARB,
  glBindBuffer,
  glBindBufferARB,
  glBindBufferBase,
  glBindBufferBaseEXT,
  glBindBufferBaseNV,
  glBindBufferOffsetEXT,
  glBindBufferOffsetNV,
  glBindBufferRange,
  glBindBufferRangeEXT,
  glBindBufferRangeNV,
  glBindBuffersBase,
  glBindBuffersRange,
  glBindFragDataLocation,
  glBindFragDataLocationEXT,
  glBindFragDataLocationIndexed,
  glBindFragDataLocationIndexedEXT,
  glBindFragmentShaderATI,
  glBindFramebuffer,
  glBindFramebufferEXT,
  glBindFramebufferOES,
  glBindImageTexture,
  glBindImageTextureEXT,
  glBindImageTextures,
  glBindLightParameterEXT,
  glBindMaterialParameterEXT,
  glBindMultiTextureEXT,
  glBindParameterEXT,
  glBindProgramARB,
  glBindProgramNV,
  glBindProgramPipeline,
  glBindProgramPipelineEXT,
  glBindRenderbuffer,
  glBindRenderbufferEXT,
  glBindRenderbufferOES,
  glBindSampler,
  glBindSamplers,
  glBindTexGenParameterEXT,
  glBindTexture,
  glBindTextureEXT,
  glBindTextureUnit,
  glBindTextureUnitParameterEXT,
  glBindTextures,
  glBindTransformFeedback,
  glBindTransformFeedbackNV,
  glBindVertexArray,
  glBindVertexArrayAPPLE,
  glBindVertexArrayOES,
  glBindVertexBuffer,
  glBindVertexBuffers,
  glBindVertexShaderEXT,
  glBindVideoCaptureStreamBufferNV,
  glBindVideoCaptureStreamTextureNV,
  glBinormal3bEXT,
  glBinormal3bvEXT,
  glBinormal3dEXT,
  glBinormal3dvEXT,
  glBinormal3fEXT,
  glBinormal3fvEXT,
  glBinormal3iEXT,
  glBinormal3ivEXT,
  glBinormal3sEXT,
  glBinormal3svEXT,
  glBinormalPointerEXT,
  glBitmap,
  glBitmapxOES,
  glBlendBarrier,
  glBlendBarrierKHR,
  glBlendBarrierNV,
  glBlendColor,
  glBlendColorEXT,
  glBlendColorxOES,
  glBlendEquation,
  glBlendEquationEXT,
  glBlendEquationIndexedAMD,
  glBlendEquationOES,
  glBlendEquationSeparate,
  glBlendEquationSeparateEXT,
  glBlendEquationSeparateIndexedAMD,
  glBlendEquationSeparateOES,
  glBlendEquationSeparatei,
  glBlendEquationSeparateiARB,
  glBlendEquationSeparateiEXT,
  glBlendEquationSeparateiOES,
  glBlendEquationi,
  glBlendEquationiARB,
  glBlendEquationiEXT,
  glBlendEquationiOES,
  glBlendFunc,
  glBlendFuncIndexedAMD,
  glBlendFuncSeparate,
  glBlendFuncSeparateEXT,
  glBlendFuncSeparateINGR,
  glBlendFuncSeparateIndexedAMD,
  glBlendFuncSeparateOES,
  glBlendFuncSeparatei,
  glBlendFuncSeparateiARB,
  glBlendFuncSeparateiEXT,
  glBlendFuncSeparateiOES,
  glBlendFunci,
  glBlendFunciARB,
  glBlendFunciEXT,
  glBlendFunciOES,
  glBlendParameteriNV,
  glBlitFramebuffer,
  glBlitFramebufferANGLE,
  glBlitFramebufferEXT,
  glBlitFramebufferNV,
  glBlitNamedFramebuffer,
  glBufferAddressRangeNV,
  glBufferData,
  glBufferDataARB,
  glBufferPageCommitmentARB,
  glBufferParameteriAPPLE,
  glBufferStorage,
  glBufferStorageEXT,
  glBufferSubData,
  glBufferSubDataARB,
  glCallCommandListNV,
  glCallList,
  glCallLists,
  glCheckFramebufferStatus,
  glCheckFramebufferStatusEXT,
  glCheckFramebufferStatusOES,
  glCheckNamedFramebufferStatus,
  glCheckNamedFramebufferStatusEXT,
  glClampColor,
  glClampColorARB,
  glClear,
  glClearAccum,
  glClearAccumxOES,
  glClearBufferData,
  glClearBufferSubData,
  glClearBufferfi,
  glClearBufferfv,
  glClearBufferiv,
  glClearBufferuiv,
  glClearColor,
  glClearColorIiEXT,
  glClearColorIuiEXT,
  glClearColorx,
  glClearColorxOES,
  glClearDepth,
  glClearDepthdNV,
  glClearDepthf,
  glClearDepthfOES,
  glClearDepthx,
  glClearDepthxOES,
  glClearIndex,
  glClearNamedBufferData,
  glClearNamedBufferDataEXT,
  glClearNamedBufferSubData,
  glClearNamedBufferSubDataEXT,
  glClearNamedFramebufferfi,
  glClearNamedFramebufferfv,
  glClearNamedFramebufferiv,
  glClearNamedFramebufferuiv,
  glClearPixelLocalStorageuiEXT,
  glClearStencil,
  glClearTexImage,
  glClearTexSubImage,
  glClientActiveTexture,
  glClientActiveTextureARB,
  glClientActiveVertexStreamATI,
  glClientAttribDefaultEXT,
  glClientWaitSync,
  glClientWaitSyncAPPLE,
  glClipControl,
  glClipPlane,
  glClipPlanef,
  glClipPlanefIMG,
  glClipPlanefOES,
  glClipPlanex,
  glClipPlanexIMG,
  glClipPlanexOES,
  glColor3b,
  glColor3bv,
  glColor3d,
  glColor3dv,
  glColor3f,
  glColor3fVertex3fSUN,
  glColor3fVertex3fvSUN,
  glColor3fv,
  glColor3hNV,
  glColor3hvNV,
  glColor3i,
  glColor3iv,
  glColor3s,
  glColor3sv,
  glColor3ub,
  glColor3ubv,
  glColor3ui,
  glColor3uiv,
  glColor3us,
  glColor3usv,
  glColor3xOES,
  glColor3xvOES,
  glColor4b,
  glColor4bv,
  glColor4d,
  glColor4dv,
  glColor4f,
  glColor4fNormal3fVertex3fSUN,
  glColor4fNormal3fVertex3fvSUN,
  glColor4fv,
  glColor4hNV,
  glColor4hvNV,
  glColor4i,
  glColor4iv,
  glColor4s,
  glColor4sv,
  glColor4ub,
  glColor4ubVertex2fSUN,
  glColor4ubVertex2fvSUN,
  glColor4ubVertex3fSUN,
  glColor4ubVertex3fvSUN,
  glColor4ubv,
  glColor4ui,
  glColor4uiv,
  glColor4us,
  glColor4usv,
  glColor4x,
  glColor4xOES,
  glColor4xvOES,
  glColorFormatNV,
  glColorFragmentOp1ATI,
  glColorFragmentOp2ATI,
  glColorFragmentOp3ATI,
  glColorMask,
  glColorMaskIndexedEXT,
  glColorMaski,
  glColorMaskiEXT,
  glColorMaskiOES,
  glColorMaterial,
  glColorP3ui,
  glColorP3uiv,
  glColorP4ui,
  glColorP4uiv,
  glColorPointer,
  glColorPointerEXT,
  glColorPointerListIBM,
  glColorPointervINTEL,
  glColorSubTable,
  glColorSubTableEXT,
  glColorTable,
  glColorTableEXT,
  glColorTableParameterfv,
  glColorTableParameterfvSGI,
  glColorTableParameteriv,
  glColorTableParameterivSGI,
  glColorTableSGI,
  glCombinerInputNV,
  glCombinerOutputNV,
  glCombinerParameterfNV,
  glCombinerParameterfvNV,
  glCombinerParameteriNV,
  glCombinerParameterivNV,
  glCombinerStageParameterfvNV,
  glCommandListSegmentsNV,
  glCompileCommandListNV,
  glCompileShader,
  glCompileShaderARB,
  glCompileShaderIncludeARB,
  glCompressedMultiTexImage1DEXT,
  glCompressedMultiTexImage2DEXT,
  glCompressedMultiTexImage3DEXT,
  glCompressedMultiTexSubImage1DEXT,
  glCompressedMultiTexSubImage2DEXT,
  glCompressedMultiTexSubImage3DEXT,
  glCompressedTexImage1D,
  glCompressedTexImage1DARB,
  glCompressedTexImage2D,
  glCompressedTexImage2DARB,
  glCompressedTexImage3D,
  glCompressedTexImage3DARB,
  glCompressedTexImage3DOES,
  glCompressedTexSubImage1D,
  glCompressedTexSubImage1DARB,
  glCompressedTexSubImage2D,
  glCompressedTexSubImage2DARB,
  glCompressedTexSubImage3D,
  glCompressedTexSubImage3DARB,
  glCompressedTexSubImage3DOES,
  glCompressedTextureImage1DEXT,
  glCompressedTextureImage2DEXT,
  glCompressedTextureImage3DEXT,
  glCompressedTextureSubImage1D,
  glCompressedTextureSubImage1DEXT,
  glCompressedTextureSubImage2D,
  glCompressedTextureSubImage2DEXT,
  glCompressedTextureSubImage3D,
  glCompressedTextureSubImage3DEXT,
  glConservativeRasterParameterfNV,
  glConvolutionFilter1D,
  glConvolutionFilter1DEXT,
  glConvolutionFilter2D,
  glConvolutionFilter2DEXT,
  glConvolutionParameterf,
  glConvolutionParameterfEXT,
  glConvolutionParameterfv,
  glConvolutionParameterfvEXT,
  glConvolutionParameteri,
  glConvolutionParameteriEXT,
  glConvolutionParameteriv,
  glConvolutionParameterivEXT,
  glConvolutionParameterxOES,
  glConvolutionParameterxvOES,
  glCopyBufferSubData,
  glCopyBufferSubDataNV,
  glCopyColorSubTable,
  glCopyColorSubTableEXT,
  glCopyColorTable,
  glCopyColorTableSGI,
  glCopyConvolutionFilter1D,
  glCopyConvolutionFilter1DEXT,
  glCopyConvolutionFilter2D,
  glCopyConvolutionFilter2DEXT,
  glCopyImageSubData,
  glCopyImageSubDataEXT,
  glCopyImageSubDataNV,
  glCopyImageSubDataOES,
  glCopyMultiTexImage1DEXT,
  glCopyMultiTexImage2DEXT,
  glCopyMultiTexSubImage1DEXT,
  glCopyMultiTexSubImage2DEXT,
  glCopyMultiTexSubImage3DEXT,
  glCopyNamedBufferSubData,
  glCopyPathNV,
  glCopyPixels,
  glCopyTexImage1D,
  glCopyTexImage1DEXT,
  glCopyTexImage2D,
  glCopyTexImage2DEXT,
  glCopyTexSubImage1D,
  glCopyTexSubImage1DEXT,
  glCopyTexSubImage2D,
  glCopyTexSubImage2DEXT,
  glCopyTexSubImage3D,
  glCopyTexSubImage3DEXT,
  glCopyTexSubImage3DOES,
  glCopyTextureImage1DEXT,
  glCopyTextureImage2DEXT,
  glCopyTextureLevelsAPPLE,
  glCopyTextureSubImage1D,
  glCopyTextureSubImage1DEXT,
  glCopyTextureSubImage2D,
  glCopyTextureSubImage2DEXT,
  glCopyTextureSubImage3D,
  glCopyTextureSubImage3DEXT,
  glCoverFillPathInstancedNV,
  glCoverFillPathNV,
  glCoverStrokePathInstancedNV,
  glCoverStrokePathNV,
  glCoverageMaskNV,
  glCoverageModulationNV,
  glCoverageModulationTableNV,
  glCoverageOperationNV,
  glCreateBuffers,
  glCreateCommandListsNV,
  glCreateFramebuffers,
  glCreatePerfQueryINTEL,
  glCreateProgram,
  glCreateProgramObjectARB,
  glCreateProgramPipelines,
  glCreateQueries,
  glCreateRenderbuffers,
  glCreateSamplers,
  glCreateShader,
  glCreateShaderObjectARB,
  glCreateShaderProgramEXT,
  glCreateShaderProgramv,
  glCreateShaderProgramvEXT,
  glCreateStatesNV,
  glCreateSyncFromCLeventARB,
  glCreateTextures,
  glCreateTransformFeedbacks,
  glCreateVertexArrays,
  glCullFace,
  glCullParameterdvEXT,
  glCullParameterfvEXT,
  glCurrentPaletteMatrixARB,
  glCurrentPaletteMatrixOES,
  glDebugMessageCallback,
  glDebugMessageCallbackAMD,
  glDebugMessageCallbackARB,
  glDebugMessageCallbackKHR,
  glDebugMessageControl,
  glDebugMessageControlARB,
  glDebugMessageControlKHR,
  glDebugMessageEnableAMD,
  glDebugMessageInsert,
  glDebugMessageInsertAMD,
  glDebugMessageInsertARB,
  glDebugMessageInsertKHR,
  glDeformSGIX,
  glDeformationMap3dSGIX,
  glDeformationMap3fSGIX,
  glDeleteAsyncMarkersSGIX,
  glDeleteBuffers,
  glDeleteBuffersARB,
  glDeleteCommandListsNV,
  glDeleteFencesAPPLE,
  glDeleteFencesNV,
  glDeleteFragmentShaderATI,
  glDeleteFramebuffers,
  glDeleteFramebuffersEXT,
  glDeleteFramebuffersOES,
  glDeleteLists,
  glDeleteNamedStringARB,
  glDeleteNamesAMD,
  glDeleteObjectARB,
  glDeleteOcclusionQueriesNV,
  glDeletePathsNV,
  glDeletePerfMonitorsAMD,
  glDeletePerfQueryINTEL,
  glDeleteProgram,
  glDeleteProgramPipelines,
  glDeleteProgramPipelinesEXT,
  glDeleteProgramsARB,
  glDeleteProgramsNV,
  glDeleteQueries,
  glDeleteQueriesARB,
  glDeleteQueriesEXT,
  glDeleteRenderbuffers,
  glDeleteRenderbuffersEXT,
  glDeleteRenderbuffersOES,
  glDeleteSamplers,
  glDeleteShader,
  glDeleteStatesNV,
  glDeleteSync,
  glDeleteSyncAPPLE,
  glDeleteTextures,
  glDeleteTexturesEXT,
  glDeleteTransformFeedbacks,
  glDeleteTransformFeedbacksNV,
  glDeleteVertexArrays,
  glDeleteVertexArraysAPPLE,
  glDeleteVertexArraysOES,
  glDeleteVertexShaderEXT,
  glDepthBoundsEXT,
  glDepthBoundsdNV,
  glDepthFunc,
  glDepthMask,
  glDepthRange,
  glDepthRangeArrayfvNV,
  glDepthRangeArrayv,
  glDepthRangeIndexed,
  glDepthRangeIndexedfNV,
  glDepthRangedNV,
  glDepthRangef,
  glDepthRangefOES,
  glDepthRangex,
  glDepthRangexOES,
  glDetachObjectARB,
  glDetachShader,
  glDetailTexFuncSGIS,
  glDisable,
  glDisableClientState,
  glDisableClientStateIndexedEXT,
  glDisableClientStateiEXT,
  glDisableDriverControlQCOM,
  glDisableIndexedEXT,
  glDisableVariantClientStateEXT,
  glDisableVertexArrayAttrib,
  glDisableVertexArrayAttribEXT,
  glDisableVertexArrayEXT,
  glDisableVertexAttribAPPLE,
  glDisableVertexAttribArray,
  glDisableVertexAttribArrayARB,
  glDisablei,
  glDisableiEXT,
  glDisableiNV,
  glDisableiOES,
  glDiscardFramebufferEXT,
  glDispatchCompute,
  glDispatchComputeGroupSizeARB,
  glDispatchComputeIndirect,
  glDrawArrays,
  glDrawArraysEXT,
  glDrawArraysIndirect,
  glDrawArraysInstanced,
  glDrawArraysInstancedANGLE,
  glDrawArraysInstancedARB,
  glDrawArraysInstancedBaseInstance,
  glDrawArraysInstancedBaseInstanceEXT,
  glDrawArraysInstancedEXT,
  glDrawArraysInstancedNV,
  glDrawBuffer,
  glDrawBuffers,
  glDrawBuffersARB,
  glDrawBuffersATI,
  glDrawBuffersEXT,
  glDrawBuffersIndexedEXT,
  glDrawBuffersNV,
  glDrawCommandsAddressNV,
  glDrawCommandsNV,
  glDrawCommandsStatesAddressNV,
  glDrawCommandsStatesNV,
  glDrawElementArrayAPPLE,
  glDrawElementArrayATI,
  glDrawElements,
  glDrawElementsBaseVertex,
  glDrawElementsBaseVertexEXT,
  glDrawElementsBaseVertexOES,
  glDrawElementsIndirect,
  glDrawElementsInstanced,
  glDrawElementsInstancedANGLE,
  glDrawElementsInstancedARB,
  glDrawElementsInstancedBaseInstance,
  glDrawElementsInstancedBaseInstanceEXT,
  glDrawElementsInstancedBaseVertex,
  glDrawElementsInstancedBaseVertexBaseInstance,
  glDrawElementsInstancedBaseVertexBaseInstanceEXT,
  glDrawElementsInstancedBaseVertexEXT,
  glDrawElementsInstancedBaseVertexOES,
  glDrawElementsInstancedEXT,
  glDrawElementsInstancedNV,
  glDrawMeshArraysSUN,
  glDrawPixels,
  glDrawRangeElementArrayAPPLE,
  glDrawRangeElementArrayATI,
  glDrawRangeElements,
  glDrawRangeElementsBaseVertex,
  glDrawRangeElementsBaseVertexEXT,
  glDrawRangeElementsBaseVertexOES,
  glDrawRangeElementsEXT,
  glDrawTexfOES,
  glDrawTexfvOES,
  glDrawTexiOES,
  glDrawTexivOES,
  glDrawTexsOES,
  glDrawTexsvOES,
  glDrawTextureNV,
  glDrawTexxOES,
  glDrawTexxvOES,
  glDrawTransformFeedback,
  glDrawTransformFeedbackInstanced,
  glDrawTransformFeedbackNV,
  glDrawTransformFeedbackStream,
  glDrawTransformFeedbackStreamInstanced,
  glEGLImageTargetRenderbufferStorageOES,
  glEGLImageTargetTexture2DOES,
  glEdgeFlag,
  glEdgeFlagFormatNV,
  glEdgeFlagPointer,
  glEdgeFlagPointerEXT,
  glEdgeFlagPointerListIBM,
  glEdgeFlagv,
  glElementPointerAPPLE,
  glElementPointerATI,
  glEnable,
  glEnableClientState,
  glEnableClientStateIndexedEXT,
  glEnableClientStateiEXT,
  glEnableDriverControlQCOM,
  glEnableIndexedEXT,
  glEnableVariantClientStateEXT,
  glEnableVertexArrayAttrib,
  glEnableVertexArrayAttribEXT,
  glEnableVertexArrayEXT,
  glEnableVertexAttribAPPLE,
  glEnableVertexAttribArray,
  glEnableVertexAttribArrayARB,
  glEnablei,
  glEnableiEXT,
  glEnableiNV,
  glEnableiOES,
  glEnd,
  glEndConditionalRender,
  glEndConditionalRenderNV,
  glEndConditionalRenderNVX,
  glEndFragmentShaderATI,
  glEndList,
  glEndOcclusionQueryNV,
  glEndPerfMonitorAMD,
  glEndPerfQueryINTEL,
  glEndQuery,
  glEndQueryARB,
  glEndQueryEXT,
  glEndQueryIndexed,
  glEndTilingQCOM,
  glEndTransformFeedback,
  glEndTransformFeedbackEXT,
  glEndTransformFeedbackNV,
  glEndVertexShaderEXT,
  glEndVideoCaptureNV,
  glEvalCoord1d,
  glEvalCoord1dv,
  glEvalCoord1f,
  glEvalCoord1fv,
  glEvalCoord1xOES,
  glEvalCoord1xvOES,
  glEvalCoord2d,
  glEvalCoord2dv,
  glEvalCoord2f,
  glEvalCoord2fv,
  glEvalCoord2xOES,
  glEvalCoord2xvOES,
  glEvalMapsNV,
  glEvalMesh1,
  glEvalMesh2,
  glEvalPoint1,
  glEvalPoint2,
  glEvaluateDepthValuesARB,
  glExecuteProgramNV,
  glExtGetBufferPointervQCOM,
  glExtGetBuffersQCOM,
  glExtGetFramebuffersQCOM,
  glExtGetProgramBinarySourceQCOM,
  glExtGetProgramsQCOM,
  glExtGetRenderbuffersQCOM,
  glExtGetShadersQCOM,
  glExtGetTexLevelParameterivQCOM,
  glExtGetTexSubImageQCOM,
  glExtGetTexturesQCOM,
  glExtIsProgramBinaryQCOM,
  glExtTexObjectStateOverrideiQCOM,
  glExtractComponentEXT,
  glFeedbackBuffer,
  glFeedbackBufferxOES,
  glFenceSync,
  glFenceSyncAPPLE,
  glFinalCombinerInputNV,
  glFinish,
  glFinishAsyncSGIX,
  glFinishFenceAPPLE,
  glFinishFenceNV,
  glFinishObjectAPPLE,
  glFinishTextureSUNX,
  glFlush,
  glFlushMappedBufferRange,
  glFlushMappedBufferRangeAPPLE,
  glFlushMappedBufferRangeEXT,
  glFlushMappedNamedBufferRange,
  glFlushMappedNamedBufferRangeEXT,
  glFlushPixelDataRangeNV,
  glFlushRasterSGIX,
  glFlushStaticDataIBM,
  glFlushVertexArrayRangeAPPLE,
  glFlushVertexArrayRangeNV,
  glFogCoordFormatNV,
  glFogCoordPointer,
  glFogCoordPointerEXT,
  glFogCoordPointerListIBM,
  glFogCoordd,
  glFogCoorddEXT,
  glFogCoorddv,
  glFogCoorddvEXT,
  glFogCoordf,
  glFogCoordfEXT,
  glFogCoordfv,
  glFogCoordfvEXT,
  glFogCoordhNV,
  glFogCoordhvNV,
  glFogFuncSGIS,
  glFogf,
  glFogfv,
  glFogi,
  glFogiv,
  glFogx,
  glFogxOES,
  glFogxv,
  glFogxvOES,
  glFragmentColorMaterialSGIX,
  glFragmentCoverageColorNV,
  glFragmentLightModelfSGIX,
  glFragmentLightModelfvSGIX,
  glFragmentLightModeliSGIX,
  glFragmentLightModelivSGIX,
  glFragmentLightfSGIX,
  glFragmentLightfvSGIX,
  glFragmentLightiSGIX,
  glFragmentLightivSGIX,
  glFragmentMaterialfSGIX,
  glFragmentMaterialfvSGIX,
  glFragmentMaterialiSGIX,
  glFragmentMaterialivSGIX,
  glFrameTerminatorGREMEDY,
  glFrameZoomSGIX,
  glFramebufferDrawBufferEXT,
  glFramebufferDrawBuffersEXT,
  glFramebufferParameteri,
  glFramebufferPixelLocalStorageSizeEXT,
  glFramebufferReadBufferEXT,
  glFramebufferRenderbuffer,
  glFramebufferRenderbufferEXT,
  glFramebufferRenderbufferOES,
  glFramebufferSampleLocationsfvARB,
  glFramebufferSampleLocationsfvNV,
  glFramebufferTexture,
  glFramebufferTexture1D,
  glFramebufferTexture1DEXT,
  glFramebufferTexture2D,
  glFramebufferTexture2DDownsampleIMG,
  glFramebufferTexture2DEXT,
  glFramebufferTexture2DMultisampleEXT,
  glFramebufferTexture2DMultisampleIMG,
  glFramebufferTexture2DOES,
  glFramebufferTexture3D,
  glFramebufferTexture3DEXT,
  glFramebufferTexture3DOES,
  glFramebufferTextureARB,
  glFramebufferTextureEXT,
  glFramebufferTextureFaceARB,
  glFramebufferTextureFaceEXT,
  glFramebufferTextureLayer,
  glFramebufferTextureLayerARB,
  glFramebufferTextureLayerDownsampleIMG,
  glFramebufferTextureLayerEXT,
  glFramebufferTextureMultisampleMultiviewOVR,
  glFramebufferTextureMultiviewOVR,
  glFramebufferTextureOES,
  glFreeObjectBufferATI,
  glFrontFace,
  glFrustum,
  glFrustumf,
  glFrustumfOES,
  glFrustumx,
  glFrustumxOES,
  glGenAsyncMarkersSGIX,
  glGenBuffers,
  glGenBuffersARB,
  glGenFencesAPPLE,
  glGenFencesNV,
  glGenFragmentShadersATI,
  glGenFramebuffers,
  glGenFramebuffersEXT,
  glGenFramebuffersOES,
  glGenLists,
  glGenNamesAMD,
  glGenOcclusionQueriesNV,
  glGenPathsNV,
  glGenPerfMonitorsAMD,
  glGenProgramPipelines,
  glGenProgramPipelinesEXT,
  glGenProgramsARB,
  glGenProgramsNV,
  glGenQueries,
  glGenQueriesARB,
  glGenQueriesEXT,
  glGenRenderbuffers,
  glGenRenderbuffersEXT,
  glGenRenderbuffersOES,
  glGenSamplers,
  glGenSymbolsEXT,
  glGenTextures,
  glGenTexturesEXT,
  glGenTransformFeedbacks,
  glGenTransformFeedbacksNV,
  glGenVertexArrays,
  glGenVertexArraysAPPLE,
  glGenVertexArraysOES,
  glGenVertexShadersEXT,
  glGenerateMipmap,
  glGenerateMipmapEXT,
  glGenerateMipmapOES,
  glGenerateMultiTexMipmapEXT,
  glGenerateTextureMipmap,
  glGenerateTextureMipmapEXT,
  glGetActiveAtomicCounterBufferiv,
  glGetActiveAttrib,
  glGetActiveAttribARB,
  glGetActiveSubroutineName,
  glGetActiveSubroutineUniformName,
  glGetActiveSubroutineUniformiv,
  glGetActiveUniform,
  glGetActiveUniformARB,
  glGetActiveUniformBlockName,
  glGetActiveUniformBlockiv,
  glGetActiveUniformName,
  glGetActiveUniformsiv,
  glGetActiveVaryingNV,
  glGetArrayObjectfvATI,
  glGetArrayObjectivATI,
  glGetAttachedObjectsARB,
  glGetAttachedShaders,
  glGetAttribLocation,
  glGetAttribLocationARB,
  glGetBooleanIndexedvEXT,
  glGetBooleani_v,
  glGetBooleanv,
  glGetBufferParameteri64v,
  glGetBufferParameteriv,
  glGetBufferParameterivARB,
  glGetBufferParameterui64vNV,
  glGetBufferPointerv,
  glGetBufferPointervARB,
  glGetBufferPointervOES,
  glGetBufferSubData,
  glGetBufferSubDataARB,
  glGetClipPlane,
  glGetClipPlanef,
  glGetClipPlanefOES,
  glGetClipPlanex,
  glGetClipPlanexOES,
  glGetColorTable,
  glGetColorTableEXT,
  glGetColorTableParameterfv,
  glGetColorTableParameterfvEXT,
  glGetColorTableParameterfvSGI,
  glGetColorTableParameteriv,
  glGetColorTableParameterivEXT,
  glGetColorTableParameterivSGI,
  glGetColorTableSGI,
  glGetCombinerInputParameterfvNV,
  glGetCombinerInputParameterivNV,
  glGetCombinerOutputParameterfvNV,
  glGetCombinerOutputParameterivNV,
  glGetCombinerStageParameterfvNV,
  glGetCommandHeaderNV,
  glGetCompressedMultiTexImageEXT,
  glGetCompressedTexImage,
  glGetCompressedTexImageARB,
  glGetCompressedTextureImage,
  glGetCompressedTextureImageEXT,
  glGetCompressedTextureSubImage,
  glGetConvolutionFilter,
  glGetConvolutionFilterEXT,
  glGetConvolutionParameterfv,
  glGetConvolutionParameterfvEXT,
  glGetConvolutionParameteriv,
  glGetConvolutionParameterivEXT,
  glGetConvolutionParameterxvOES,
  glGetCoverageModulationTableNV,
  glGetDebugMessageLog,
  glGetDebugMessageLogAMD,
  glGetDebugMessageLogARB,
  glGetDebugMessageLogKHR,
  glGetDetailTexFuncSGIS,
  glGetDoubleIndexedvEXT,
  glGetDoublei_v,
  glGetDoublei_vEXT,
  glGetDoublev,
  glGetDriverControlStringQCOM,
  glGetDriverControlsQCOM,
  glGetError,
  glGetFenceivNV,
  glGetFinalCombinerInputParameterfvNV,
  glGetFinalCombinerInputParameterivNV,
  glGetFirstPerfQueryIdINTEL,
  glGetFixedv,
  glGetFixedvOES,
  glGetFloatIndexedvEXT,
  glGetFloati_v,
  glGetFloati_vEXT,
  glGetFloati_vNV,
  glGetFloatv,
  glGetFogFuncSGIS,
  glGetFragDataIndex,
  glGetFragDataIndexEXT,
  glGetFragDataLocation,
  glGetFragDataLocationEXT,
  glGetFragmentLightfvSGIX,
  glGetFragmentLightivSGIX,
  glGetFragmentMaterialfvSGIX,
  glGetFragmentMaterialivSGIX,
  glGetFramebufferAttachmentParameteriv,
  glGetFramebufferAttachmentParameterivEXT,
  glGetFramebufferAttachmentParameterivOES,
  glGetFramebufferParameteriv,
  glGetFramebufferParameterivEXT,
  glGetFramebufferPixelLocalStorageSizeEXT,
  glGetGraphicsResetStatus,
  glGetGraphicsResetStatusARB,
  glGetGraphicsResetStatusEXT,
  glGetGraphicsResetStatusKHR,
  glGetHandleARB,
  glGetHistogram,
  glGetHistogramEXT,
  glGetHistogramParameterfv,
  glGetHistogramParameterfvEXT,
  glGetHistogramParameteriv,
  glGetHistogramParameterivEXT,
  glGetHistogramParameterxvOES,
  glGetImageHandleARB,
  glGetImageHandleNV,
  glGetImageTransformParameterfvHP,
  glGetImageTransformParameterivHP,
  glGetInfoLogARB,
  glGetInstrumentsSGIX,
  glGetInteger64i_v,
  glGetInteger64v,
  glGetInteger64vAPPLE,
  glGetIntegerIndexedvEXT,
  glGetIntegeri_v,
  glGetIntegeri_vEXT,
  glGetIntegerui64i_vNV,
  glGetIntegerui64vNV,
  glGetIntegerv,
  glGetInternalformatSampleivNV,
  glGetInternalformati64v,
  glGetInternalformativ,
  glGetInvariantBooleanvEXT,
  glGetInvariantFloatvEXT,
  glGetInvariantIntegervEXT,
  glGetLightfv,
  glGetLightiv,
  glGetLightxOES,
  glGetLightxv,
  glGetLightxvOES,
  glGetListParameterfvSGIX,
  glGetListParameterivSGIX,
  glGetLocalConstantBooleanvEXT,
  glGetLocalConstantFloatvEXT,
  glGetLocalConstantIntegervEXT,
  glGetMapAttribParameterfvNV,
  glGetMapAttribParameterivNV,
  glGetMapControlPointsNV,
  glGetMapParameterfvNV,
  glGetMapParameterivNV,
  glGetMapdv,
  glGetMapfv,
  glGetMapiv,
  glGetMapxvOES,
  glGetMaterialfv,
  glGetMaterialiv,
  glGetMaterialxOES,
  glGetMaterialxv,
  glGetMaterialxvOES,
  glGetMinmax,
  glGetMinmaxEXT,
  glGetMinmaxParameterfv,
  glGetMinmaxParameterfvEXT,
  glGetMinmaxParameteriv,
  glGetMinmaxParameterivEXT,
  glGetMultiTexEnvfvEXT,
  glGetMultiTexEnvivEXT,
  glGetMultiTexGendvEXT,
  glGetMultiTexGenfvEXT,
  glGetMultiTexGenivEXT,
  glGetMultiTexImageEXT,
  glGetMultiTexLevelParameterfvEXT,
  glGetMultiTexLevelParameterivEXT,
  glGetMultiTexParameterIivEXT,
  glGetMultiTexParameterIuivEXT,
  glGetMultiTexParameterfvEXT,
  glGetMultiTexParameterivEXT,
  glGetMultisamplefv,
  glGetMultisamplefvNV,
  glGetNamedBufferParameteri64v,
  glGetNamedBufferParameteriv,
  glGetNamedBufferParameterivEXT,
  glGetNamedBufferParameterui64vNV,
  glGetNamedBufferPointerv,
  glGetNamedBufferPointervEXT,
  glGetNamedBufferSubData,
  glGetNamedBufferSubDataEXT,
  glGetNamedFramebufferAttachmentParameteriv,
  glGetNamedFramebufferAttachmentParameterivEXT,
  glGetNamedFramebufferParameteriv,
  glGetNamedFramebufferParameterivEXT,
  glGetNamedProgramLocalParameterIivEXT,
  glGetNamedProgramLocalParameterIuivEXT,
  glGetNamedProgramLocalParameterdvEXT,
  glGetNamedProgramLocalParameterfvEXT,
  glGetNamedProgramStringEXT,
  glGetNamedProgramivEXT,
  glGetNamedRenderbufferParameteriv,
  glGetNamedRenderbufferParameterivEXT,
  glGetNamedStringARB,
  glGetNamedStringivARB,
  glGetNextPerfQueryIdINTEL,
  glGetObjectBufferfvATI,
  glGetObjectBufferivATI,
  glGetObjectLabel,
  glGetObjectLabelEXT,
  glGetObjectLabelKHR,
  glGetObjectParameterfvARB,
  glGetObjectParameterivAPPLE,
  glGetObjectParameterivARB,
  glGetObjectPtrLabel,
  glGetObjectPtrLabelKHR,
  glGetOcclusionQueryivNV,
  glGetOcclusionQueryuivNV,
  glGetPathColorGenfvNV,
  glGetPathColorGenivNV,
  glGetPathCommandsNV,
  glGetPathCoordsNV,
  glGetPathDashArrayNV,
  glGetPathLengthNV,
  glGetPathMetricRangeNV,
  glGetPathMetricsNV,
  glGetPathParameterfvNV,
  glGetPathParameterivNV,
  glGetPathSpacingNV,
  glGetPathTexGenfvNV,
  glGetPathTexGenivNV,
  glGetPerfCounterInfoINTEL,
  glGetPerfMonitorCounterDataAMD,
  glGetPerfMonitorCounterInfoAMD,
  glGetPerfMonitorCounterStringAMD,
  glGetPerfMonitorCountersAMD,
  glGetPerfMonitorGroupStringAMD,
  glGetPerfMonitorGroupsAMD,
  glGetPerfQueryDataINTEL,
  glGetPerfQueryIdByNameINTEL,
  glGetPerfQueryInfoINTEL,
  glGetPixelMapfv,
  glGetPixelMapuiv,
  glGetPixelMapusv,
  glGetPixelMapxv,
  glGetPixelTexGenParameterfvSGIS,
  glGetPixelTexGenParameterivSGIS,
  glGetPixelTransformParameterfvEXT,
  glGetPixelTransformParameterivEXT,
  glGetPointerIndexedvEXT,
  glGetPointeri_vEXT,
  glGetPointerv,
  glGetPointervEXT,
  glGetPointervKHR,
  glGetPolygonStipple,
  glGetProgramBinary,
  glGetProgramBinaryOES,
  glGetProgramEnvParameterIivNV,
  glGetProgramEnvParameterIuivNV,
  glGetProgramEnvParameterdvARB,
  glGetProgramEnvParameterfvARB,
  glGetProgramInfoLog,
  glGetProgramInterfaceiv,
  glGetProgramLocalParameterIivNV,
  glGetProgramLocalParameterIuivNV,
  glGetProgramLocalParameterdvARB,
  glGetProgramLocalParameterfvARB,
  glGetProgramNamedParameterdvNV,
  glGetProgramNamedParameterfvNV,
  glGetProgramParameterdvNV,
  glGetProgramParameterfvNV,
  glGetProgramPipelineInfoLog,
  glGetProgramPipelineInfoLogEXT,
  glGetProgramPipelineiv,
  glGetProgramPipelineivEXT,
  glGetProgramResourceIndex,
  glGetProgramResourceLocation,
  glGetProgramResourceLocationIndex,
  glGetProgramResourceLocationIndexEXT,
  glGetProgramResourceName,
  glGetProgramResourcefvNV,
  glGetProgramResourceiv,
  glGetProgramStageiv,
  glGetProgramStringARB,
  glGetProgramStringNV,
  glGetProgramSubroutineParameteruivNV,
  glGetProgramiv,
  glGetProgramivARB,
  glGetProgramivNV,
  glGetQueryBufferObjecti64v,
  glGetQueryBufferObjectiv,
  glGetQueryBufferObjectui64v,
  glGetQueryBufferObjectuiv,
  glGetQueryIndexediv,
  glGetQueryObjecti64v,
  glGetQueryObjecti64vEXT,
  glGetQueryObjectiv,
  glGetQueryObjectivARB,
  glGetQueryObjectivEXT,
  glGetQueryObjectui64v,
  glGetQueryObjectui64vEXT,
  glGetQueryObjectuiv,
  glGetQueryObjectuivARB,
  glGetQueryObjectuivEXT,
  glGetQueryiv,
  glGetQueryivARB,
  glGetQueryivEXT,
  glGetRenderbufferParameteriv,
  glGetRenderbufferParameterivEXT,
  glGetRenderbufferParameterivOES,
  glGetSamplerParameterIiv,
  glGetSamplerParameterIivEXT,
  glGetSamplerParameterIivOES,
  glGetSamplerParameterIuiv,
  glGetSamplerParameterIuivEXT,
  glGetSamplerParameterIuivOES,
  glGetSamplerParameterfv,
  glGetSamplerParameteriv,
  glGetSeparableFilter,
  glGetSeparableFilterEXT,
  glGetShaderInfoLog,
  glGetShaderPrecisionFormat,
  glGetShaderSource,
  glGetShaderSourceARB,
  glGetShaderiv,
  glGetSharpenTexFuncSGIS,
  glGetStageIndexNV,
  glGetString,
  glGetStringi,
  glGetSubroutineIndex,
  glGetSubroutineUniformLocation,
  glGetSynciv,
  glGetSyncivAPPLE,
  glGetTexBumpParameterfvATI,
  glGetTexBumpParameterivATI,
  glGetTexEnvfv,
  glGetTexEnviv,
  glGetTexEnvxv,
  glGetTexEnvxvOES,
  glGetTexFilterFuncSGIS,
  glGetTexGendv,
  glGetTexGenfv,
  glGetTexGenfvOES,
  glGetTexGeniv,
  glGetTexGenivOES,
  glGetTexGenxvOES,
  glGetTexImage,
  glGetTexLevelParameterfv,
  glGetTexLevelParameteriv,
  glGetTexLevelParameterxvOES,
  glGetTexParameterIiv,
  glGetTexParameterIivEXT,
  glGetTexParameterIivOES,
  glGetTexParameterIuiv,
  glGetTexParameterIuivEXT,
  glGetTexParameterIuivOES,
  glGetTexParameterPointervAPPLE,
  glGetTexParameterfv,
  glGetTexParameteriv,
  glGetTexParameterxv,
  glGetTexParameterxvOES,
  glGetTextureHandleARB,
  glGetTextureHandleNV,
  glGetTextureImage,
  glGetTextureImageEXT,
  glGetTextureLevelParameterfv,
  glGetTextureLevelParameterfvEXT,
  glGetTextureLevelParameteriv,
  glGetTextureLevelParameterivEXT,
  glGetTextureParameterIiv,
  glGetTextureParameterIivEXT,
  glGetTextureParameterIuiv,
  glGetTextureParameterIuivEXT,
  glGetTextureParameterfv,
  glGetTextureParameterfvEXT,
  glGetTextureParameteriv,
  glGetTextureParameterivEXT,
  glGetTextureSamplerHandleARB,
  glGetTextureSamplerHandleNV,
  glGetTextureSubImage,
  glGetTrackMatrixivNV,
  glGetTransformFeedbackVarying,
  glGetTransformFeedbackVaryingEXT,
  glGetTransformFeedbackVaryingNV,
  glGetTransformFeedbacki64_v,
  glGetTransformFeedbacki_v,
  glGetTransformFeedbackiv,
  glGetTranslatedShaderSourceANGLE,
  glGetUniformBlockIndex,
  glGetUniformBufferSizeEXT,
  glGetUniformIndices,
  glGetUniformLocation,
  glGetUniformLocationARB,
  glGetUniformOffsetEXT,
  glGetUniformSubroutineuiv,
  glGetUniformdv,
  glGetUniformfv,
  glGetUniformfvARB,
  glGetUniformi64vARB,
  glGetUniformi64vNV,
  glGetUniformiv,
  glGetUniformivARB,
  glGetUniformui64vARB,
  glGetUniformui64vNV,
  glGetUniformuiv,
  glGetUniformuivEXT,
  glGetVariantArrayObjectfvATI,
  glGetVariantArrayObjectivATI,
  glGetVariantBooleanvEXT,
  glGetVariantFloatvEXT,
  glGetVariantIntegervEXT,
  glGetVariantPointervEXT,
  glGetVaryingLocationNV,
  glGetVertexArrayIndexed64iv,
  glGetVertexArrayIndexediv,
  glGetVertexArrayIntegeri_vEXT,
  glGetVertexArrayIntegervEXT,
  glGetVertexArrayPointeri_vEXT,
  glGetVertexArrayPointervEXT,
  glGetVertexArrayiv,
  glGetVertexAttribArrayObjectfvATI,
  glGetVertexAttribArrayObjectivATI,
  glGetVertexAttribIiv,
  glGetVertexAttribIivEXT,
  glGetVertexAttribIuiv,
  glGetVertexAttribIuivEXT,
  glGetVertexAttribLdv,
  glGetVertexAttribLdvEXT,
  glGetVertexAttribLi64vNV,
  glGetVertexAttribLui64vARB,
  glGetVertexAttribLui64vNV,
  glGetVertexAttribPointerv,
  glGetVertexAttribPointervARB,
  glGetVertexAttribPointervNV,
  glGetVertexAttribdv,
  glGetVertexAttribdvARB,
  glGetVertexAttribdvNV,
  glGetVertexAttribfv,
  glGetVertexAttribfvARB,
  glGetVertexAttribfvNV,
  glGetVertexAttribiv,
  glGetVertexAttribivARB,
  glGetVertexAttribivNV,
  glGetVideoCaptureStreamdvNV,
  glGetVideoCaptureStreamfvNV,
  glGetVideoCaptureStreamivNV,
  glGetVideoCaptureivNV,
  glGetVideoi64vNV,
  glGetVideoivNV,
  glGetVideoui64vNV,
  glGetVideouivNV,
  glGetnColorTable,
  glGetnColorTableARB,
  glGetnCompressedTexImage,
  glGetnCompressedTexImageARB,
  glGetnConvolutionFilter,
  glGetnConvolutionFilterARB,
  glGetnHistogram,
  glGetnHistogramARB,
  glGetnMapdv,
  glGetnMapdvARB,
  glGetnMapfv,
  glGetnMapfvARB,
  glGetnMapiv,
  glGetnMapivARB,
  glGetnMinmax,
  glGetnMinmaxARB,
  glGetnPixelMapfv,
  glGetnPixelMapfvARB,
  glGetnPixelMapuiv,
  glGetnPixelMapuivARB,
  glGetnPixelMapusv,
  glGetnPixelMapusvARB,
  glGetnPolygonStipple,
  glGetnPolygonStippleARB,
  glGetnSeparableFilter,
  glGetnSeparableFilterARB,
  glGetnTexImage,
  glGetnTexImageARB,
  glGetnUniformdv,
  glGetnUniformdvARB,
  glGetnUniformfv,
  glGetnUniformfvARB,
  glGetnUniformfvEXT,
  glGetnUniformfvKHR,
  glGetnUniformi64vARB,
  glGetnUniformiv,
  glGetnUniformivARB,
  glGetnUniformivEXT,
  glGetnUniformivKHR,
  glGetnUniformui64vARB,
  glGetnUniformuiv,
  glGetnUniformuivARB,
  glGetnUniformuivKHR,
  glGlobalAlphaFactorbSUN,
  glGlobalAlphaFactordSUN,
  glGlobalAlphaFactorfSUN,
  glGlobalAlphaFactoriSUN,
  glGlobalAlphaFactorsSUN,
  glGlobalAlphaFactorubSUN,
  glGlobalAlphaFactoruiSUN,
  glGlobalAlphaFactorusSUN,
  glHint,
  glHintPGI,
  glHistogram,
  glHistogramEXT,
  glIglooInterfaceSGIX,
  glImageTransformParameterfHP,
  glImageTransformParameterfvHP,
  glImageTransformParameteriHP,
  glImageTransformParameterivHP,
  glImportSyncEXT,
  glIndexFormatNV,
  glIndexFuncEXT,
  glIndexMask,
  glIndexMaterialEXT,
  glIndexPointer,
  glIndexPointerEXT,
  glIndexPointerListIBM,
  glIndexd,
  glIndexdv,
  glIndexf,
  glIndexfv,
  glIndexi,
  glIndexiv,
  glIndexs,
  glIndexsv,
  glIndexub,
  glIndexubv,
  glIndexxOES,
  glIndexxvOES,
  glInitNames,
  glInsertComponentEXT,
  glInsertEventMarkerEXT,
  glInstrumentsBufferSGIX,
  glInterleavedArrays,
  glInterpolatePathsNV,
  glInvalidateBufferData,
  glInvalidateBufferSubData,
  glInvalidateFramebuffer,
  glInvalidateNamedFramebufferData,
  glInvalidateNamedFramebufferSubData,
  glInvalidateSubFramebuffer,
  glInvalidateTexImage,
  glInvalidateTexSubImage,
  glIsAsyncMarkerSGIX,
  glIsBuffer,
  glIsBufferARB,
  glIsBufferResidentNV,
  glIsCommandListNV,
  glIsEnabled,
  glIsEnabledIndexedEXT,
  glIsEnabledi,
  glIsEnablediEXT,
  glIsEnablediNV,
  glIsEnablediOES,
  glIsFenceAPPLE,
  glIsFenceNV,
  glIsFramebuffer,
  glIsFramebufferEXT,
  glIsFramebufferOES,
  glIsImageHandleResidentARB,
  glIsImageHandleResidentNV,
  glIsList,
  glIsNameAMD,
  glIsNamedBufferResidentNV,
  glIsNamedStringARB,
  glIsObjectBufferATI,
  glIsOcclusionQueryNV,
  glIsPathNV,
  glIsPointInFillPathNV,
  glIsPointInStrokePathNV,
  glIsProgram,
  glIsProgramARB,
  glIsProgramNV,
  glIsProgramPipeline,
  glIsProgramPipelineEXT,
  glIsQuery,
  glIsQueryARB,
  glIsQueryEXT,
  glIsRenderbuffer,
  glIsRenderbufferEXT,
  glIsRenderbufferOES,
  glIsSampler,
  glIsShader,
  glIsStateNV,
  glIsSync,
  glIsSyncAPPLE,
  glIsTexture,
  glIsTextureEXT,
  glIsTextureHandleResidentARB,
  glIsTextureHandleResidentNV,
  glIsTransformFeedback,
  glIsTransformFeedbackNV,
  glIsVariantEnabledEXT,
  glIsVertexArray,
  glIsVertexArrayAPPLE,
  glIsVertexArrayOES,
  glIsVertexAttribEnabledAPPLE,
  glLabelObjectEXT,
  glLightEnviSGIX,
  glLightModelf,
  glLightModelfv,
  glLightModeli,
  glLightModeliv,
  glLightModelx,
  glLightModelxOES,
  glLightModelxv,
  glLightModelxvOES,
  glLightf,
  glLightfv,
  glLighti,
  glLightiv,
  glLightx,
  glLightxOES,
  glLightxv,
  glLightxvOES,
  glLineStipple,
  glLineWidth,
  glLineWidthx,
  glLineWidthxOES,
  glLinkProgram,
  glLinkProgramARB,
  glListBase,
  glListDrawCommandsStatesClientNV,
  glListParameterfSGIX,
  glListParameterfvSGIX,
  glListParameteriSGIX,
  glListParameterivSGIX,
  glLoadIdentity,
  glLoadIdentityDeformationMapSGIX,
  glLoadMatrixd,
  glLoadMatrixf,
  glLoadMatrixx,
  glLoadMatrixxOES,
  glLoadName,
  glLoadPaletteFromModelViewMatrixOES,
  glLoadProgramNV,
  glLoadTransposeMatrixd,
  glLoadTransposeMatrixdARB,
  glLoadTransposeMatrixf,
  glLoadTransposeMatrixfARB,
  glLoadTransposeMatrixxOES,
  glLockArraysEXT,
  glLogicOp,
  glMakeBufferNonResidentNV,
  glMakeBufferResidentNV,
  glMakeImageHandleNonResidentARB,
  glMakeImageHandleNonResidentNV,
  glMakeImageHandleResidentARB,
  glMakeImageHandleResidentNV,
  glMakeNamedBufferNonResidentNV,
  glMakeNamedBufferResidentNV,
  glMakeTextureHandleNonResidentARB,
  glMakeTextureHandleNonResidentNV,
  glMakeTextureHandleResidentARB,
  glMakeTextureHandleResidentNV,
  glMap1d,
  glMap1f,
  glMap1xOES,
  glMap2d,
  glMap2f,
  glMap2xOES,
  glMapBuffer,
  glMapBufferARB,
  glMapBufferOES,
  glMapBufferRange,
  glMapBufferRangeEXT,
  glMapControlPointsNV,
  glMapGrid1d,
  glMapGrid1f,
  glMapGrid1xOES,
  glMapGrid2d,
  glMapGrid2f,
  glMapGrid2xOES,
  glMapNamedBuffer,
  glMapNamedBufferEXT,
  glMapNamedBufferRange,
  glMapNamedBufferRangeEXT,
  glMapObjectBufferATI,
  glMapParameterfvNV,
  glMapParameterivNV,
  glMapTexture2DINTEL,
  glMapVertexAttrib1dAPPLE,
  glMapVertexAttrib1fAPPLE,
  glMapVertexAttrib2dAPPLE,
  glMapVertexAttrib2fAPPLE,
  glMaterialf,
  glMaterialfv,
  glMateriali,
  glMaterialiv,
  glMaterialx,
  glMaterialxOES,
  glMaterialxv,
  glMaterialxvOES,
  glMatrixFrustumEXT,
  glMatrixIndexPointerARB,
  glMatrixIndexPointerOES,
  glMatrixIndexubvARB,
  glMatrixIndexuivARB,
  glMatrixIndexusvARB,
  glMatrixLoad3x2fNV,
  glMatrixLoad3x3fNV,
  glMatrixLoadIdentityEXT,
  glMatrixLoadTranspose3x3fNV,
  glMatrixLoadTransposedEXT,
  glMatrixLoadTransposefEXT,
  glMatrixLoaddEXT,
  glMatrixLoadfEXT,
  glMatrixMode,
  glMatrixMult3x2fNV,
  glMatrixMult3x3fNV,
  glMatrixMultTranspose3x3fNV,
  glMatrixMultTransposedEXT,
  glMatrixMultTransposefEXT,
  glMatrixMultdEXT,
  glMatrixMultfEXT,
  glMatrixOrthoEXT,
  glMatrixPopEXT,
  glMatrixPushEXT,
  glMatrixRotatedEXT,
  glMatrixRotatefEXT,
  glMatrixScaledEXT,
  glMatrixScalefEXT,
  glMatrixTranslatedEXT,
  glMatrixTranslatefEXT,
  glMaxShaderCompilerThreadsARB,
  glMemoryBarrier,
  glMemoryBarrierByRegion,
  glMemoryBarrierEXT,
  glMinSampleShading,
  glMinSampleShadingARB,
  glMinSampleShadingOES,
  glMinmax,
  glMinmaxEXT,
  glMultMatrixd,
  glMultMatrixf,
  glMultMatrixx,
  glMultMatrixxOES,
  glMultTransposeMatrixd,
  glMultTransposeMatrixdARB,
  glMultTransposeMatrixf,
  glMultTransposeMatrixfARB,
  glMultTransposeMatrixxOES,
  glMultiDrawArrays,
  glMultiDrawArraysEXT,
  glMultiDrawArraysIndirect,
  glMultiDrawArraysIndirectAMD,
  glMultiDrawArraysIndirectBindlessCountNV,
  glMultiDrawArraysIndirectBindlessNV,
  glMultiDrawArraysIndirectCountARB,
  glMultiDrawArraysIndirectEXT,
  glMultiDrawElementArrayAPPLE,
  glMultiDrawElements,
  glMultiDrawElementsBaseVertex,
  glMultiDrawElementsBaseVertexEXT,
  glMultiDrawElementsBaseVertexOES,
  glMultiDrawElementsEXT,
  glMultiDrawElementsIndirect,
  glMultiDrawElementsIndirectAMD,
  glMultiDrawElementsIndirectBindlessCountNV,
  glMultiDrawElementsIndirectBindlessNV,
  glMultiDrawElementsIndirectCountARB,
  glMultiDrawElementsIndirectEXT,
  glMultiDrawRangeElementArrayAPPLE,
  glMultiModeDrawArraysIBM,
  glMultiModeDrawElementsIBM,
  glMultiTexBufferEXT,
  glMultiTexCoord1bOES,
  glMultiTexCoord1bvOES,
  glMultiTexCoord1d,
  glMultiTexCoord1dARB,
  glMultiTexCoord1dv,
  glMultiTexCoord1dvARB,
  glMultiTexCoord1f,
  glMultiTexCoord1fARB,
  glMultiTexCoord1fv,
  glMultiTexCoord1fvARB,
  glMultiTexCoord1hNV,
  glMultiTexCoord1hvNV,
  glMultiTexCoord1i,
  glMultiTexCoord1iARB,
  glMultiTexCoord1iv,
  glMultiTexCoord1ivARB,
  glMultiTexCoord1s,
  glMultiTexCoord1sARB,
  glMultiTexCoord1sv,
  glMultiTexCoord1svARB,
  glMultiTexCoord1xOES,
  glMultiTexCoord1xvOES,
  glMultiTexCoord2bOES,
  glMultiTexCoord2bvOES,
  glMultiTexCoord2d,
  glMultiTexCoord2dARB,
  glMultiTexCoord2dv,
  glMultiTexCoord2dvARB,
  glMultiTexCoord2f,
  glMultiTexCoord2fARB,
  glMultiTexCoord2fv,
  glMultiTexCoord2fvARB,
  glMultiTexCoord2hNV,
  glMultiTexCoord2hvNV,
  glMultiTexCoord2i,
  glMultiTexCoord2iARB,
  glMultiTexCoord2iv,
  glMultiTexCoord2ivARB,
  glMultiTexCoord2s,
  glMultiTexCoord2sARB,
  glMultiTexCoord2sv,
  glMultiTexCoord2svARB,
  glMultiTexCoord2xOES,
  glMultiTexCoord2xvOES,
  glMultiTexCoord3bOES,
  glMultiTexCoord3bvOES,
  glMultiTexCoord3d,
  glMultiTexCoord3dARB,
  glMultiTexCoord3dv,
  glMultiTexCoord3dvARB,
  glMultiTexCoord3f,
  glMultiTexCoord3fARB,
  glMultiTexCoord3fv,
  glMultiTexCoord3fvARB,
  glMultiTexCoord3hNV,
  glMultiTexCoord3hvNV,
  glMultiTexCoord3i,
  glMultiTexCoord3iARB,
  glMultiTexCoord3iv,
  glMultiTexCoord3ivARB,
  glMultiTexCoord3s,
  glMultiTexCoord3sARB,
  glMultiTexCoord3sv,
  glMultiTexCoord3svARB,
  glMultiTexCoord3xOES,
  glMultiTexCoord3xvOES,
  glMultiTexCoord4bOES,
  glMultiTexCoord4bvOES,
  glMultiTexCoord4d,
  glMultiTexCoord4dARB,
  glMultiTexCoord4dv,
  glMultiTexCoord4dvARB,
  glMultiTexCoord4f,
  glMultiTexCoord4fARB,
  glMultiTexCoord4fv,
  glMultiTexCoord4fvARB,
  glMultiTexCoord4hNV,
  glMultiTexCoord4hvNV,
  glMultiTexCoord4i,
  glMultiTexCoord4iARB,
  glMultiTexCoord4iv,
  glMultiTexCoord4ivARB,
  glMultiTexCoord4s,
  glMultiTexCoord4sARB,
  glMultiTexCoord4sv,
  glMultiTexCoord4svARB,
  glMultiTexCoord4x,
  glMultiTexCoord4xOES,
  glMultiTexCoord4xvOES,
  glMultiTexCoordP1ui,
  glMultiTexCoordP1uiv,
  glMultiTexCoordP2ui,
  glMultiTexCoordP2uiv,
  glMultiTexCoordP3ui,
  glMultiTexCoordP3uiv,
  glMultiTexCoordP4ui,
  glMultiTexCoordP4uiv,
  glMultiTexCoordPointerEXT,
  glMultiTexEnvfEXT,
  glMultiTexEnvfvEXT,
  glMultiTexEnviEXT,
  glMultiTexEnvivEXT,
  glMultiTexGendEXT,
  glMultiTexGendvEXT,
  glMultiTexGenfEXT,
  glMultiTexGenfvEXT,
  glMultiTexGeniEXT,
  glMultiTexGenivEXT,
  glMultiTexImage1DEXT,
  glMultiTexImage2DEXT,
  glMultiTexImage3DEXT,
  glMultiTexParameterIivEXT,
  glMultiTexParameterIuivEXT,
  glMultiTexParameterfEXT,
  glMultiTexParameterfvEXT,
  glMultiTexParameteriEXT,
  glMultiTexParameterivEXT,
  glMultiTexRenderbufferEXT,
  glMultiTexSubImage1DEXT,
  glMultiTexSubImage2DEXT,
  glMultiTexSubImage3DEXT,
  glNamedBufferData,
  glNamedBufferDataEXT,
  glNamedBufferPageCommitmentARB,
  glNamedBufferPageCommitmentEXT,
  glNamedBufferStorage,
  glNamedBufferStorageEXT,
  glNamedBufferSubData,
  glNamedBufferSubDataEXT,
  glNamedCopyBufferSubDataEXT,
  glNamedFramebufferDrawBuffer,
  glNamedFramebufferDrawBuffers,
  glNamedFramebufferParameteri,
  glNamedFramebufferParameteriEXT,
  glNamedFramebufferReadBuffer,
  glNamedFramebufferRenderbuffer,
  glNamedFramebufferRenderbufferEXT,
  glNamedFramebufferSampleLocationsfvARB,
  glNamedFramebufferSampleLocationsfvNV,
  glNamedFramebufferTexture,
  glNamedFramebufferTexture1DEXT,
  glNamedFramebufferTexture2DEXT,
  glNamedFramebufferTexture3DEXT,
  glNamedFramebufferTextureEXT,
  glNamedFramebufferTextureFaceEXT,
  glNamedFramebufferTextureLayer,
  glNamedFramebufferTextureLayerEXT,
  glNamedProgramLocalParameter4dEXT,
  glNamedProgramLocalParameter4dvEXT,
  glNamedProgramLocalParameter4fEXT,
  glNamedProgramLocalParameter4fvEXT,
  glNamedProgramLocalParameterI4iEXT,
  glNamedProgramLocalParameterI4ivEXT,
  glNamedProgramLocalParameterI4uiEXT,
  glNamedProgramLocalParameterI4uivEXT,
  glNamedProgramLocalParameters4fvEXT,
  glNamedProgramLocalParametersI4ivEXT,
  glNamedProgramLocalParametersI4uivEXT,
  glNamedProgramStringEXT,
  glNamedRenderbufferStorage,
  glNamedRenderbufferStorageEXT,
  glNamedRenderbufferStorageMultisample,
  glNamedRenderbufferStorageMultisampleCoverageEXT,
  glNamedRenderbufferStorageMultisampleEXT,
  glNamedStringARB,
  glNewList,
  glNewObjectBufferATI,
  glNormal3b,
  glNormal3bv,
  glNormal3d,
  glNormal3dv,
  glNormal3f,
  glNormal3fVertex3fSUN,
  glNormal3fVertex3fvSUN,
  glNormal3fv,
  glNormal3hNV,
  glNormal3hvNV,
  glNormal3i,
  glNormal3iv,
  glNormal3s,
  glNormal3sv,
  glNormal3x,
  glNormal3xOES,
  glNormal3xvOES,
  glNormalFormatNV,
  glNormalP3ui,
  glNormalP3uiv,
  glNormalPointer,
  glNormalPointerEXT,
  glNormalPointerListIBM,
  glNormalPointervINTEL,
  glNormalStream3bATI,
  glNormalStream3bvATI,
  glNormalStream3dATI,
  glNormalStream3dvATI,
  glNormalStream3fATI,
  glNormalStream3fvATI,
  glNormalStream3iATI,
  glNormalStream3ivATI,
  glNormalStream3sATI,
  glNormalStream3svATI,
  glObjectLabel,
  glObjectLabelKHR,
  glObjectPtrLabel,
  glObjectPtrLabelKHR,
  glObjectPurgeableAPPLE,
  glObjectUnpurgeableAPPLE,
  glOrtho,
  glOrthof,
  glOrthofOES,
  glOrthox,
  glOrthoxOES,
  glPNTrianglesfATI,
  glPNTrianglesiATI,
  glPassTexCoordATI,
  glPassThrough,
  glPassThroughxOES,
  glPatchParameterfv,
  glPatchParameteri,
  glPatchParameteriEXT,
  glPatchParameteriOES,
  glPathColorGenNV,
  glPathCommandsNV,
  glPathCoordsNV,
  glPathCoverDepthFuncNV,
  glPathDashArrayNV,
  glPathFogGenNV,
  glPathGlyphIndexArrayNV,
  glPathGlyphIndexRangeNV,
  glPathGlyphRangeNV,
  glPathGlyphsNV,
  glPathMemoryGlyphIndexArrayNV,
  glPathParameterfNV,
  glPathParameterfvNV,
  glPathParameteriNV,
  glPathParameterivNV,
  glPathStencilDepthOffsetNV,
  glPathStencilFuncNV,
  glPathStringNV,
  glPathSubCommandsNV,
  glPathSubCoordsNV,
  glPathTexGenNV,
  glPauseTransformFeedback,
  glPauseTransformFeedbackNV,
  glPixelDataRangeNV,
  glPixelMapfv,
  glPixelMapuiv,
  glPixelMapusv,
  glPixelMapx,
  glPixelStoref,
  glPixelStorei,
  glPixelStorex,
  glPixelTexGenParameterfSGIS,
  glPixelTexGenParameterfvSGIS,
  glPixelTexGenParameteriSGIS,
  glPixelTexGenParameterivSGIS,
  glPixelTexGenSGIX,
  glPixelTransferf,
  glPixelTransferi,
  glPixelTransferxOES,
  glPixelTransformParameterfEXT,
  glPixelTransformParameterfvEXT,
  glPixelTransformParameteriEXT,
  glPixelTransformParameterivEXT,
  glPixelZoom,
  glPixelZoomxOES,
  glPointAlongPathNV,
  glPointParameterf,
  glPointParameterfARB,
  glPointParameterfEXT,
  glPointParameterfSGIS,
  glPointParameterfv,
  glPointParameterfvARB,
  glPointParameterfvEXT,
  glPointParameterfvSGIS,
  glPointParameteri,
  glPointParameteriNV,
  glPointParameteriv,
  glPointParameterivNV,
  glPointParameterx,
  glPointParameterxOES,
  glPointParameterxv,
  glPointParameterxvOES,
  glPointSize,
  glPointSizePointerOES,
  glPointSizex,
  glPointSizexOES,
  glPollAsyncSGIX,
  glPollInstrumentsSGIX,
  glPolygonMode,
  glPolygonModeNV,
  glPolygonOffset,
  glPolygonOffsetClampEXT,
  glPolygonOffsetEXT,
  glPolygonOffsetx,
  glPolygonOffsetxOES,
  glPolygonStipple,
  glPopAttrib,
  glPopClientAttrib,
  glPopDebugGroup,
  glPopDebugGroupKHR,
  glPopGroupMarkerEXT,
  glPopMatrix,
  glPopName,
  glPresentFrameDualFillNV,
  glPresentFrameKeyedNV,
  glPrimitiveBoundingBox,
  glPrimitiveBoundingBoxARB,
  glPrimitiveBoundingBoxEXT,
  glPrimitiveBoundingBoxOES,
  glPrimitiveRestartIndex,
  glPrimitiveRestartIndexNV,
  glPrimitiveRestartNV,
  glPrioritizeTextures,
  glPrioritizeTexturesEXT,
  glPrioritizeTexturesxOES,
  glProgramBinary,
  glProgramBinaryOES,
  glProgramBufferParametersIivNV,
  glProgramBufferParametersIuivNV,
  glProgramBufferParametersfvNV,
  glProgramEnvParameter4dARB,
  glProgramEnvParameter4dvARB,
  glProgramEnvParameter4fARB,
  glProgramEnvParameter4fvARB,
  glProgramEnvParameterI4iNV,
  glProgramEnvParameterI4ivNV,
  glProgramEnvParameterI4uiNV,
  glProgramEnvParameterI4uivNV,
  glProgramEnvParameters4fvEXT,
  glProgramEnvParametersI4ivNV,
  glProgramEnvParametersI4uivNV,
  glProgramLocalParameter4dARB,
  glProgramLocalParameter4dvARB,
  glProgramLocalParameter4fARB,
  glProgramLocalParameter4fvARB,
  glProgramLocalParameterI4iNV,
  glProgramLocalParameterI4ivNV,
  glProgramLocalParameterI4uiNV,
  glProgramLocalParameterI4uivNV,
  glProgramLocalParameters4fvEXT,
  glProgramLocalParametersI4ivNV,
  glProgramLocalParametersI4uivNV,
  glProgramNamedParameter4dNV,
  glProgramNamedParameter4dvNV,
  glProgramNamedParameter4fNV,
  glProgramNamedParameter4fvNV,
  glProgramParameter4dNV,
  glProgramParameter4dvNV,
  glProgramParameter4fNV,
  glProgramParameter4fvNV,
  glProgramParameteri,
  glProgramParameteriARB,
  glProgramParameteriEXT,
  glProgramParameters4dvNV,
  glProgramParameters4fvNV,
  glProgramPathFragmentInputGenNV,
  glProgramStringARB,
  glProgramSubroutineParametersuivNV,
  glProgramUniform1d,
  glProgramUniform1dEXT,
  glProgramUniform1dv,
  glProgramUniform1dvEXT,
  glProgramUniform1f,
  glProgramUniform1fEXT,
  glProgramUniform1fv,
  glProgramUniform1fvEXT,
  glProgramUniform1i,
  glProgramUniform1i64ARB,
  glProgramUniform1i64NV,
  glProgramUniform1i64vARB,
  glProgramUniform1i64vNV,
  glProgramUniform1iEXT,
  glProgramUniform1iv,
  glProgramUniform1ivEXT,
  glProgramUniform1ui,
  glProgramUniform1ui64ARB,
  glProgramUniform1ui64NV,
  glProgramUniform1ui64vARB,
  glProgramUniform1ui64vNV,
  glProgramUniform1uiEXT,
  glProgramUniform1uiv,
  glProgramUniform1uivEXT,
  glProgramUniform2d,
  glProgramUniform2dEXT,
  glProgramUniform2dv,
  glProgramUniform2dvEXT,
  glProgramUniform2f,
  glProgramUniform2fEXT,
  glProgramUniform2fv,
  glProgramUniform2fvEXT,
  glProgramUniform2i,
  glProgramUniform2i64ARB,
  glProgramUniform2i64NV,
  glProgramUniform2i64vARB,
  glProgramUniform2i64vNV,
  glProgramUniform2iEXT,
  glProgramUniform2iv,
  glProgramUniform2ivEXT,
  glProgramUniform2ui,
  glProgramUniform2ui64ARB,
  glProgramUniform2ui64NV,
  glProgramUniform2ui64vARB,
  glProgramUniform2ui64vNV,
  glProgramUniform2uiEXT,
  glProgramUniform2uiv,
  glProgramUniform2uivEXT,
  glProgramUniform3d,
  glProgramUniform3dEXT,
  glProgramUniform3dv,
  glProgramUniform3dvEXT,
  glProgramUniform3f,
  glProgramUniform3fEXT,
  glProgramUniform3fv,
  glProgramUniform3fvEXT,
  glProgramUniform3i,
  glProgramUniform3i64ARB,
  glProgramUniform3i64NV,
  glProgramUniform3i64vARB,
  glProgramUniform3i64vNV,
  glProgramUniform3iEXT,
  glProgramUniform3iv,
  glProgramUniform3ivEXT,
  glProgramUniform3ui,
  glProgramUniform3ui64ARB,
  glProgramUniform3ui64NV,
  glProgramUniform3ui64vARB,
  glProgramUniform3ui64vNV,
  glProgramUniform3uiEXT,
  glProgramUniform3uiv,
  glProgramUniform3uivEXT,
  glProgramUniform4d,
  glProgramUniform4dEXT,
  glProgramUniform4dv,
  glProgramUniform4dvEXT,
  glProgramUniform4f,
  glProgramUniform4fEXT,
  glProgramUniform4fv,
  glProgramUniform4fvEXT,
  glProgramUniform4i,
  glProgramUniform4i64ARB,
  glProgramUniform4i64NV,
  glProgramUniform4i64vARB,
  glProgramUniform4i64vNV,
  glProgramUniform4iEXT,
  glProgramUniform4iv,
  glProgramUniform4ivEXT,
  glProgramUniform4ui,
  glProgramUniform4ui64ARB,
  glProgramUniform4ui64NV,
  glProgramUniform4ui64vARB,
  glProgramUniform4ui64vNV,
  glProgramUniform4uiEXT,
  glProgramUniform4uiv,
  glProgramUniform4uivEXT,
  glProgramUniformHandleui64ARB,
  glProgramUniformHandleui64NV,
  glProgramUniformHandleui64vARB,
  glProgramUniformHandleui64vNV,
  glProgramUniformMatrix2dv,
  glProgramUniformMatrix2dvEXT,
  glProgramUniformMatrix2fv,
  glProgramUniformMatrix2fvEXT,
  glProgramUniformMatrix2x3dv,
  glProgramUniformMatrix2x3dvEXT,
  glProgramUniformMatrix2x3fv,
  glProgramUniformMatrix2x3fvEXT,
  glProgramUniformMatrix2x4dv,
  glProgramUniformMatrix2x4dvEXT,
  glProgramUniformMatrix2x4fv,
  glProgramUniformMatrix2x4fvEXT,
  glProgramUniformMatrix3dv,
  glProgramUniformMatrix3dvEXT,
  glProgramUniformMatrix3fv,
  glProgramUniformMatrix3fvEXT,
  glProgramUniformMatrix3x2dv,
  glProgramUniformMatrix3x2dvEXT,
  glProgramUniformMatrix3x2fv,
  glProgramUniformMatrix3x2fvEXT,
  glProgramUniformMatrix3x4dv,
  glProgramUniformMatrix3x4dvEXT,
  glProgramUniformMatrix3x4fv,
  glProgramUniformMatrix3x4fvEXT,
  glProgramUniformMatrix4dv,
  glProgramUniformMatrix4dvEXT,
  glProgramUniformMatrix4fv,
  glProgramUniformMatrix4fvEXT,
  glProgramUniformMatrix4x2dv,
  glProgramUniformMatrix4x2dvEXT,
  glProgramUniformMatrix4x2fv,
  glProgramUniformMatrix4x2fvEXT,
  glProgramUniformMatrix4x3dv,
  glProgramUniformMatrix4x3dvEXT,
  glProgramUniformMatrix4x3fv,
  glProgramUniformMatrix4x3fvEXT,
  glProgramUniformui64NV,
  glProgramUniformui64vNV,
  glProgramVertexLimitNV,
  glProvokingVertex,
  glProvokingVertexEXT,
  glPushAttrib,
  glPushClientAttrib,
  glPushClientAttribDefaultEXT,
  glPushDebugGroup,
  glPushDebugGroupKHR,
  glPushGroupMarkerEXT,
  glPushMatrix,
  glPushName,
  glQueryCounter,
  glQueryCounterEXT,
  glQueryMatrixxOES,
  glQueryObjectParameteruiAMD,
  glRasterPos2d,
  glRasterPos2dv,
  glRasterPos2f,
  glRasterPos2fv,
  glRasterPos2i,
  glRasterPos2iv,
  glRasterPos2s,
  glRasterPos2sv,
  glRasterPos2xOES,
  glRasterPos2xvOES,
  glRasterPos3d,
  glRasterPos3dv,
  glRasterPos3f,
  glRasterPos3fv,
  glRasterPos3i,
  glRasterPos3iv,
  glRasterPos3s,
  glRasterPos3sv,
  glRasterPos3xOES,
  glRasterPos3xvOES,
  glRasterPos4d,
  glRasterPos4dv,
  glRasterPos4f,
  glRasterPos4fv,
  glRasterPos4i,
  glRasterPos4iv,
  glRasterPos4s,
  glRasterPos4sv,
  glRasterPos4xOES,
  glRasterPos4xvOES,
  glRasterSamplesEXT,
  glReadBuffer,
  glReadBufferIndexedEXT,
  glReadBufferNV,
  glReadInstrumentsSGIX,
  glReadPixels,
  glReadnPixels,
  glReadnPixelsARB,
  glReadnPixelsEXT,
  glReadnPixelsKHR,
  glRectd,
  glRectdv,
  glRectf,
  glRectfv,
  glRecti,
  glRectiv,
  glRects,
  glRectsv,
  glRectxOES,
  glRectxvOES,
  glReferencePlaneSGIX,
  glReleaseShaderCompiler,
  glRenderMode,
  glRenderbufferStorage,
  glRenderbufferStorageEXT,
  glRenderbufferStorageMultisample,
  glRenderbufferStorageMultisampleANGLE,
  glRenderbufferStorageMultisampleAPPLE,
  glRenderbufferStorageMultisampleCoverageNV,
  glRenderbufferStorageMultisampleEXT,
  glRenderbufferStorageMultisampleIMG,
  glRenderbufferStorageMultisampleNV,
  glRenderbufferStorageOES,
  glReplacementCodePointerSUN,
  glReplacementCodeubSUN,
  glReplacementCodeubvSUN,
  glReplacementCodeuiColor3fVertex3fSUN,
  glReplacementCodeuiColor3fVertex3fvSUN,
  glReplacementCodeuiColor4fNormal3fVertex3fSUN,
  glReplacementCodeuiColor4fNormal3fVertex3fvSUN,
  glReplacementCodeuiColor4ubVertex3fSUN,
  glReplacementCodeuiColor4ubVertex3fvSUN,
  glReplacementCodeuiNormal3fVertex3fSUN,
  glReplacementCodeuiNormal3fVertex3fvSUN,
  glReplacementCodeuiSUN,
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN,
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN,
  glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN,
  glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN,
  glReplacementCodeuiTexCoord2fVertex3fSUN,
  glReplacementCodeuiTexCoord2fVertex3fvSUN,
  glReplacementCodeuiVertex3fSUN,
  glReplacementCodeuiVertex3fvSUN,
  glReplacementCodeuivSUN,
  glReplacementCodeusSUN,
  glReplacementCodeusvSUN,
  glRequestResidentProgramsNV,
  glResetHistogram,
  glResetHistogramEXT,
  glResetMinmax,
  glResetMinmaxEXT,
  glResizeBuffersMESA,
  glResolveDepthValuesNV,
  glResolveMultisampleFramebufferAPPLE,
  glResumeTransformFeedback,
  glResumeTransformFeedbackNV,
  glRotated,
  glRotatef,
  glRotatex,
  glRotatexOES,
  glSampleCoverage,
  glSampleCoverageARB,
  glSampleCoveragex,
  glSampleCoveragexOES,
  glSampleMapATI,
  glSampleMaskEXT,
  glSampleMaskIndexedNV,
  glSampleMaskSGIS,
  glSampleMaski,
  glSamplePatternEXT,
  glSamplePatternSGIS,
  glSamplerParameterIiv,
  glSamplerParameterIivEXT,
  glSamplerParameterIivOES,
  glSamplerParameterIuiv,
  glSamplerParameterIuivEXT,
  glSamplerParameterIuivOES,
  glSamplerParameterf,
  glSamplerParameterfv,
  glSamplerParameteri,
  glSamplerParameteriv,
  glScaled,
  glScalef,
  glScalex,
  glScalexOES,
  glScissor,
  glScissorArrayv,
  glScissorArrayvNV,
  glScissorIndexed,
  glScissorIndexedNV,
  glScissorIndexedv,
  glScissorIndexedvNV,
  glSecondaryColor3b,
  glSecondaryColor3bEXT,
  glSecondaryColor3bv,
  glSecondaryColor3bvEXT,
  glSecondaryColor3d,
  glSecondaryColor3dEXT,
  glSecondaryColor3dv,
  glSecondaryColor3dvEXT,
  glSecondaryColor3f,
  glSecondaryColor3fEXT,
  glSecondaryColor3fv,
  glSecondaryColor3fvEXT,
  glSecondaryColor3hNV,
  glSecondaryColor3hvNV,
  glSecondaryColor3i,
  glSecondaryColor3iEXT,
  glSecondaryColor3iv,
  glSecondaryColor3ivEXT,
  glSecondaryColor3s,
  glSecondaryColor3sEXT,
  glSecondaryColor3sv,
  glSecondaryColor3svEXT,
  glSecondaryColor3ub,
  glSecondaryColor3ubEXT,
  glSecondaryColor3ubv,
  glSecondaryColor3ubvEXT,
  glSecondaryColor3ui,
  glSecondaryColor3uiEXT,
  glSecondaryColor3uiv,
  glSecondaryColor3uivEXT,
  glSecondaryColor3us,
  glSecondaryColor3usEXT,
  glSecondaryColor3usv,
  glSecondaryColor3usvEXT,
  glSecondaryColorFormatNV,
  glSecondaryColorP3ui,
  glSecondaryColorP3uiv,
  glSecondaryColorPointer,
  glSecondaryColorPointerEXT,
  glSecondaryColorPointerListIBM,
  glSelectBuffer,
  glSelectPerfMonitorCountersAMD,
  glSeparableFilter2D,
  glSeparableFilter2DEXT,
  glSetFenceAPPLE,
  glSetFenceNV,
  glSetFragmentShaderConstantATI,
  glSetInvariantEXT,
  glSetLocalConstantEXT,
  glSetMultisamplefvAMD,
  glShadeModel,
  glShaderBinary,
  glShaderOp1EXT,
  glShaderOp2EXT,
  glShaderOp3EXT,
  glShaderSource,
  glShaderSourceARB,
  glShaderStorageBlockBinding,
  glSharpenTexFuncSGIS,
  glSpriteParameterfSGIX,
  glSpriteParameterfvSGIX,
  glSpriteParameteriSGIX,
  glSpriteParameterivSGIX,
  glStartInstrumentsSGIX,
  glStartTilingQCOM,
  glStateCaptureNV,
  glStencilClearTagEXT,
  glStencilFillPathInstancedNV,
  glStencilFillPathNV,
  glStencilFunc,
  glStencilFuncSeparate,
  glStencilFuncSeparateATI,
  glStencilMask,
  glStencilMaskSeparate,
  glStencilOp,
  glStencilOpSeparate,
  glStencilOpSeparateATI,
  glStencilOpValueAMD,
  glStencilStrokePathInstancedNV,
  glStencilStrokePathNV,
  glStencilThenCoverFillPathInstancedNV,
  glStencilThenCoverFillPathNV,
  glStencilThenCoverStrokePathInstancedNV,
  glStencilThenCoverStrokePathNV,
  glStopInstrumentsSGIX,
  glStringMarkerGREMEDY,
  glSubpixelPrecisionBiasNV,
  glSwizzleEXT,
  glSyncTextureINTEL,
  glTagSampleBufferSGIX,
  glTangent3bEXT,
  glTangent3bvEXT,
  glTangent3dEXT,
  glTangent3dvEXT,
  glTangent3fEXT,
  glTangent3fvEXT,
  glTangent3iEXT,
  glTangent3ivEXT,
  glTangent3sEXT,
  glTangent3svEXT,
  glTangentPointerEXT,
  glTbufferMask3DFX,
  glTessellationFactorAMD,
  glTessellationModeAMD,
  glTestFenceAPPLE,
  glTestFenceNV,
  glTestObjectAPPLE,
  glTexBuffer,
  glTexBufferARB,
  glTexBufferEXT,
  glTexBufferOES,
  glTexBufferRange,
  glTexBufferRangeEXT,
  glTexBufferRangeOES,
  glTexBumpParameterfvATI,
  glTexBumpParameterivATI,
  glTexCoord1bOES,
  glTexCoord1bvOES,
  glTexCoord1d,
  glTexCoord1dv,
  glTexCoord1f,
  glTexCoord1fv,
  glTexCoord1hNV,
  glTexCoord1hvNV,
  glTexCoord1i,
  glTexCoord1iv,
  glTexCoord1s,
  glTexCoord1sv,
  glTexCoord1xOES,
  glTexCoord1xvOES,
  glTexCoord2bOES,
  glTexCoord2bvOES,
  glTexCoord2d,
  glTexCoord2dv,
  glTexCoord2f,
  glTexCoord2fColor3fVertex3fSUN,
  glTexCoord2fColor3fVertex3fvSUN,
  glTexCoord2fColor4fNormal3fVertex3fSUN,
  glTexCoord2fColor4fNormal3fVertex3fvSUN,
  glTexCoord2fColor4ubVertex3fSUN,
  glTexCoord2fColor4ubVertex3fvSUN,
  glTexCoord2fNormal3fVertex3fSUN,
  glTexCoord2fNormal3fVertex3fvSUN,
  glTexCoord2fVertex3fSUN,
  glTexCoord2fVertex3fvSUN,
  glTexCoord2fv,
  glTexCoord2hNV,
  glTexCoord2hvNV,
  glTexCoord2i,
  glTexCoord2iv,
  glTexCoord2s,
  glTexCoord2sv,
  glTexCoord2xOES,
  glTexCoord2xvOES,
  glTexCoord3bOES,
  glTexCoord3bvOES,
  glTexCoord3d,
  glTexCoord3dv,
  glTexCoord3f,
  glTexCoord3fv,
  glTexCoord3hNV,
  glTexCoord3hvNV,
  glTexCoord3i,
  glTexCoord3iv,
  glTexCoord3s,
  glTexCoord3sv,
  glTexCoord3xOES,
  glTexCoord3xvOES,
  glTexCoord4bOES,
  glTexCoord4bvOES,
  glTexCoord4d,
  glTexCoord4dv,
  glTexCoord4f,
  glTexCoord4fColor4fNormal3fVertex4fSUN,
  glTexCoord4fColor4fNormal3fVertex4fvSUN,
  glTexCoord4fVertex4fSUN,
  glTexCoord4fVertex4fvSUN,
  glTexCoord4fv,
  glTexCoord4hNV,
  glTexCoord4hvNV,
  glTexCoord4i,
  glTexCoord4iv,
  glTexCoord4s,
  glTexCoord4sv,
  glTexCoord4xOES,
  glTexCoord4xvOES,
  glTexCoordFormatNV,
  glTexCoordP1ui,
  glTexCoordP1uiv,
  glTexCoordP2ui,
  glTexCoordP2uiv,
  glTexCoordP3ui,
  glTexCoordP3uiv,
  glTexCoordP4ui,
  glTexCoordP4uiv,
  glTexCoordPointer,
  glTexCoordPointerEXT,
  glTexCoordPointerListIBM,
  glTexCoordPointervINTEL,
  glTexEnvf,
  glTexEnvfv,
  glTexEnvi,
  glTexEnviv,
  glTexEnvx,
  glTexEnvxOES,
  glTexEnvxv,
  glTexEnvxvOES,
  glTexFilterFuncSGIS,
  glTexGend,
  glTexGendv,
  glTexGenf,
  glTexGenfOES,
  glTexGenfv,
  glTexGenfvOES,
  glTexGeni,
  glTexGeniOES,
  glTexGeniv,
  glTexGenivOES,
  glTexGenxOES,
  glTexGenxvOES,
  glTexImage1D,
  glTexImage2D,
  glTexImage2DMultisample,
  glTexImage2DMultisampleCoverageNV,
  glTexImage3D,
  glTexImage3DEXT,
  glTexImage3DMultisample,
  glTexImage3DMultisampleCoverageNV,
  glTexImage3DOES,
  glTexImage4DSGIS,
  glTexPageCommitmentARB,
  glTexPageCommitmentEXT,
  glTexParameterIiv,
  glTexParameterIivEXT,
  glTexParameterIivOES,
  glTexParameterIuiv,
  glTexParameterIuivEXT,
  glTexParameterIuivOES,
  glTexParameterf,
  glTexParameterfv,
  glTexParameteri,
  glTexParameteriv,
  glTexParameterx,
  glTexParameterxOES,
  glTexParameterxv,
  glTexParameterxvOES,
  glTexRenderbufferNV,
  glTexStorage1D,
  glTexStorage1DEXT,
  glTexStorage2D,
  glTexStorage2DEXT,
  glTexStorage2DMultisample,
  glTexStorage3D,
  glTexStorage3DEXT,
  glTexStorage3DMultisample,
  glTexStorage3DMultisampleOES,
  glTexStorageSparseAMD,
  glTexSubImage1D,
  glTexSubImage1DEXT,
  glTexSubImage2D,
  glTexSubImage2DEXT,
  glTexSubImage3D,
  glTexSubImage3DEXT,
  glTexSubImage3DOES,
  glTexSubImage4DSGIS,
  glTextureBarrier,
  glTextureBarrierNV,
  glTextureBuffer,
  glTextureBufferEXT,
  glTextureBufferRange,
  glTextureBufferRangeEXT,
  glTextureColorMaskSGIS,
  glTextureImage1DEXT,
  glTextureImage2DEXT,
  glTextureImage2DMultisampleCoverageNV,
  glTextureImage2DMultisampleNV,
  glTextureImage3DEXT,
  glTextureImage3DMultisampleCoverageNV,
  glTextureImage3DMultisampleNV,
  glTextureLightEXT,
  glTextureMaterialEXT,
  glTextureNormalEXT,
  glTexturePageCommitmentEXT,
  glTextureParameterIiv,
  glTextureParameterIivEXT,
  glTextureParameterIuiv,
  glTextureParameterIuivEXT,
  glTextureParameterf,
  glTextureParameterfEXT,
  glTextureParameterfv,
  glTextureParameterfvEXT,
  glTextureParameteri,
  glTextureParameteriEXT,
  glTextureParameteriv,
  glTextureParameterivEXT,
  glTextureRangeAPPLE,
  glTextureRenderbufferEXT,
  glTextureStorage1D,
  glTextureStorage1DEXT,
  glTextureStorage2D,
  glTextureStorage2DEXT,
  glTextureStorage2DMultisample,
  glTextureStorage2DMultisampleEXT,
  glTextureStorage3D,
  glTextureStorage3DEXT,
  glTextureStorage3DMultisample,
  glTextureStorage3DMultisampleEXT,
  glTextureStorageSparseAMD,
  glTextureSubImage1D,
  glTextureSubImage1DEXT,
  glTextureSubImage2D,
  glTextureSubImage2DEXT,
  glTextureSubImage3D,
  glTextureSubImage3DEXT,
  glTextureView,
  glTextureViewEXT,
  glTextureViewOES,
  glTrackMatrixNV,
  glTransformFeedbackAttribsNV,
  glTransformFeedbackBufferBase,
  glTransformFeedbackBufferRange,
  glTransformFeedbackStreamAttribsNV,
  glTransformFeedbackVaryings,
  glTransformFeedbackVaryingsEXT,
  glTransformFeedbackVaryingsNV,
  glTransformPathNV,
  glTranslated,
  glTranslatef,
  glTranslatex,
  glTranslatexOES,
  glUniform1d,
  glUniform1dv,
  glUniform1f,
  glUniform1fARB,
  glUniform1fv,
  glUniform1fvARB,
  glUniform1i,
  glUniform1i64ARB,
  glUniform1i64NV,
  glUniform1i64vARB,
  glUniform1i64vNV,
  glUniform1iARB,
  glUniform1iv,
  glUniform1ivARB,
  glUniform1ui,
  glUniform1ui64ARB,
  glUniform1ui64NV,
  glUniform1ui64vARB,
  glUniform1ui64vNV,
  glUniform1uiEXT,
  glUniform1uiv,
  glUniform1uivEXT,
  glUniform2d,
  glUniform2dv,
  glUniform2f,
  glUniform2fARB,
  glUniform2fv,
  glUniform2fvARB,
  glUniform2i,
  glUniform2i64ARB,
  glUniform2i64NV,
  glUniform2i64vARB,
  glUniform2i64vNV,
  glUniform2iARB,
  glUniform2iv,
  glUniform2ivARB,
  glUniform2ui,
  glUniform2ui64ARB,
  glUniform2ui64NV,
  glUniform2ui64vARB,
  glUniform2ui64vNV,
  glUniform2uiEXT,
  glUniform2uiv,
  glUniform2uivEXT,
  glUniform3d,
  glUniform3dv,
  glUniform3f,
  glUniform3fARB,
  glUniform3fv,
  glUniform3fvARB,
  glUniform3i,
  glUniform3i64ARB,
  glUniform3i64NV,
  glUniform3i64vARB,
  glUniform3i64vNV,
  glUniform3iARB,
  glUniform3iv,
  glUniform3ivARB,
  glUniform3ui,
  glUniform3ui64ARB,
  glUniform3ui64NV,
  glUniform3ui64vARB,
  glUniform3ui64vNV,
  glUniform3uiEXT,
  glUniform3uiv,
  glUniform3uivEXT,
  glUniform4d,
  glUniform4dv,
  glUniform4f,
  glUniform4fARB,
  glUniform4fv,
  glUniform4fvARB,
  glUniform4i,
  glUniform4i64ARB,
  glUniform4i64NV,
  glUniform4i64vARB,
  glUniform4i64vNV,
  glUniform4iARB,
  glUniform4iv,
  glUniform4ivARB,
  glUniform4ui,
  glUniform4ui64ARB,
  glUniform4ui64NV,
  glUniform4ui64vARB,
  glUniform4ui64vNV,
  glUniform4uiEXT,
  glUniform4uiv,
  glUniform4uivEXT,
  glUniformBlockBinding,
  glUniformBufferEXT,
  glUniformHandleui64ARB,
  glUniformHandleui64NV,
  glUniformHandleui64vARB,
  glUniformHandleui64vNV,
  glUniformMatrix2dv,
  glUniformMatrix2fv,
  glUniformMatrix2fvARB,
  glUniformMatrix2x3dv,
  glUniformMatrix2x3fv,
  glUniformMatrix2x3fvNV,
  glUniformMatrix2x4dv,
  glUniformMatrix2x4fv,
  glUniformMatrix2x4fvNV,
  glUniformMatrix3dv,
  glUniformMatrix3fv,
  glUniformMatrix3fvARB,
  glUniformMatrix3x2dv,
  glUniformMatrix3x2fv,
  glUniformMatrix3x2fvNV,
  glUniformMatrix3x4dv,
  glUniformMatrix3x4fv,
  glUniformMatrix3x4fvNV,
  glUniformMatrix4dv,
  glUniformMatrix4fv,
  glUniformMatrix4fvARB,
  glUniformMatrix4x2dv,
  glUniformMatrix4x2fv,
  glUniformMatrix4x2fvNV,
  glUniformMatrix4x3dv,
  glUniformMatrix4x3fv,
  glUniformMatrix4x3fvNV,
  glUniformSubroutinesuiv,
  glUniformui64NV,
  glUniformui64vNV,
  glUnlockArraysEXT,
  glUnmapBuffer,
  glUnmapBufferARB,
  glUnmapBufferOES,
  glUnmapNamedBuffer,
  glUnmapNamedBufferEXT,
  glUnmapObjectBufferATI,
  glUnmapTexture2DINTEL,
  glUpdateObjectBufferATI,
  glUseProgram,
  glUseProgramObjectARB,
  glUseProgramStages,
  glUseProgramStagesEXT,
  glUseShaderProgramEXT,
  glVDPAUFiniNV,
  glVDPAUGetSurfaceivNV,
  glVDPAUInitNV,
  glVDPAUIsSurfaceNV,
  glVDPAUMapSurfacesNV,
  glVDPAURegisterOutputSurfaceNV,
  glVDPAURegisterVideoSurfaceNV,
  glVDPAUSurfaceAccessNV,
  glVDPAUUnmapSurfacesNV,
  glVDPAUUnregisterSurfaceNV,
  glValidateProgram,
  glValidateProgramARB,
  glValidateProgramPipeline,
  glValidateProgramPipelineEXT,
  glVariantArrayObjectATI,
  glVariantPointerEXT,
  glVariantbvEXT,
  glVariantdvEXT,
  glVariantfvEXT,
  glVariantivEXT,
  glVariantsvEXT,
  glVariantubvEXT,
  glVariantuivEXT,
  glVariantusvEXT,
  glVertex2bOES,
  glVertex2bvOES,
  glVertex2d,
  glVertex2dv,
  glVertex2f,
  glVertex2fv,
  glVertex2hNV,
  glVertex2hvNV,
  glVertex2i,
  glVertex2iv,
  glVertex2s,
  glVertex2sv,
  glVertex2xOES,
  glVertex2xvOES,
  glVertex3bOES,
  glVertex3bvOES,
  glVertex3d,
  glVertex3dv,
  glVertex3f,
  glVertex3fv,
  glVertex3hNV,
  glVertex3hvNV,
  glVertex3i,
  glVertex3iv,
  glVertex3s,
  glVertex3sv,
  glVertex3xOES,
  glVertex3xvOES,
  glVertex4bOES,
  glVertex4bvOES,
  glVertex4d,
  glVertex4dv,
  glVertex4f,
  glVertex4fv,
  glVertex4hNV,
  glVertex4hvNV,
  glVertex4i,
  glVertex4iv,
  glVertex4s,
  glVertex4sv,
  glVertex4xOES,
  glVertex4xvOES,
  glVertexArrayAttribBinding,
  glVertexArrayAttribFormat,
  glVertexArrayAttribIFormat,
  glVertexArrayAttribLFormat,
  glVertexArrayBindVertexBufferEXT,
  glVertexArrayBindingDivisor,
  glVertexArrayColorOffsetEXT,
  glVertexArrayEdgeFlagOffsetEXT,
  glVertexArrayElementBuffer,
  glVertexArrayFogCoordOffsetEXT,
  glVertexArrayIndexOffsetEXT,
  glVertexArrayMultiTexCoordOffsetEXT,
  glVertexArrayNormalOffsetEXT,
  glVertexArrayParameteriAPPLE,
  glVertexArrayRangeAPPLE,
  glVertexArrayRangeNV,
  glVertexArraySecondaryColorOffsetEXT,
  glVertexArrayTexCoordOffsetEXT,
  glVertexArrayVertexAttribBindingEXT,
  glVertexArrayVertexAttribDivisorEXT,
  glVertexArrayVertexAttribFormatEXT,
  glVertexArrayVertexAttribIFormatEXT,
  glVertexArrayVertexAttribIOffsetEXT,
  glVertexArrayVertexAttribLFormatEXT,
  glVertexArrayVertexAttribLOffsetEXT,
  glVertexArrayVertexAttribOffsetEXT,
  glVertexArrayVertexBindingDivisorEXT,
  glVertexArrayVertexBuffer,
  glVertexArrayVertexBuffers,
  glVertexArrayVertexOffsetEXT,
  glVertexAttrib1d,
  glVertexAttrib1dARB,
  glVertexAttrib1dNV,
  glVertexAttrib1dv,
  glVertexAttrib1dvARB,
  glVertexAttrib1dvNV,
  glVertexAttrib1f,
  glVertexAttrib1fARB,
  glVertexAttrib1fNV,
  glVertexAttrib1fv,
  glVertexAttrib1fvARB,
  glVertexAttrib1fvNV,
  glVertexAttrib1hNV,
  glVertexAttrib1hvNV,
  glVertexAttrib1s,
  glVertexAttrib1sARB,
  glVertexAttrib1sNV,
  glVertexAttrib1sv,
  glVertexAttrib1svARB,
  glVertexAttrib1svNV,
  glVertexAttrib2d,
  glVertexAttrib2dARB,
  glVertexAttrib2dNV,
  glVertexAttrib2dv,
  glVertexAttrib2dvARB,
  glVertexAttrib2dvNV,
  glVertexAttrib2f,
  glVertexAttrib2fARB,
  glVertexAttrib2fNV,
  glVertexAttrib2fv,
  glVertexAttrib2fvARB,
  glVertexAttrib2fvNV,
  glVertexAttrib2hNV,
  glVertexAttrib2hvNV,
  glVertexAttrib2s,
  glVertexAttrib2sARB,
  glVertexAttrib2sNV,
  glVertexAttrib2sv,
  glVertexAttrib2svARB,
  glVertexAttrib2svNV,
  glVertexAttrib3d,
  glVertexAttrib3dARB,
  glVertexAttrib3dNV,
  glVertexAttrib3dv,
  glVertexAttrib3dvARB,
  glVertexAttrib3dvNV,
  glVertexAttrib3f,
  glVertexAttrib3fARB,
  glVertexAttrib3fNV,
  glVertexAttrib3fv,
  glVertexAttrib3fvARB,
  glVertexAttrib3fvNV,
  glVertexAttrib3hNV,
  glVertexAttrib3hvNV,
  glVertexAttrib3s,
  glVertexAttrib3sARB,
  glVertexAttrib3sNV,
  glVertexAttrib3sv,
  glVertexAttrib3svARB,
  glVertexAttrib3svNV,
  glVertexAttrib4Nbv,
  glVertexAttrib4NbvARB,
  glVertexAttrib4Niv,
  glVertexAttrib4NivARB,
  glVertexAttrib4Nsv,
  glVertexAttrib4NsvARB,
  glVertexAttrib4Nub,
  glVertexAttrib4NubARB,
  glVertexAttrib4Nubv,
  glVertexAttrib4NubvARB,
  glVertexAttrib4Nuiv,
  glVertexAttrib4NuivARB,
  glVertexAttrib4Nusv,
  glVertexAttrib4NusvARB,
  glVertexAttrib4bv,
  glVertexAttrib4bvARB,
  glVertexAttrib4d,
  glVertexAttrib4dARB,
  glVertexAttrib4dNV,
  glVertexAttrib4dv,
  glVertexAttrib4dvARB,
  glVertexAttrib4dvNV,
  glVertexAttrib4f,
  glVertexAttrib4fARB,
  glVertexAttrib4fNV,
  glVertexAttrib4fv,
  glVertexAttrib4fvARB,
  glVertexAttrib4fvNV,
  glVertexAttrib4hNV,
  glVertexAttrib4hvNV,
  glVertexAttrib4iv,
  glVertexAttrib4ivARB,
  glVertexAttrib4s,
  glVertexAttrib4sARB,
  glVertexAttrib4sNV,
  glVertexAttrib4sv,
  glVertexAttrib4svARB,
  glVertexAttrib4svNV,
  glVertexAttrib4ubNV,
  glVertexAttrib4ubv,
  glVertexAttrib4ubvARB,
  glVertexAttrib4ubvNV,
  glVertexAttrib4uiv,
  glVertexAttrib4uivARB,
  glVertexAttrib4usv,
  glVertexAttrib4usvARB,
  glVertexAttribArrayObjectATI,
  glVertexAttribBinding,
  glVertexAttribDivisor,
  glVertexAttribDivisorANGLE,
  glVertexAttribDivisorARB,
  glVertexAttribDivisorEXT,
  glVertexAttribDivisorNV,
  glVertexAttribFormat,
  glVertexAttribFormatNV,
  glVertexAttribI1i,
  glVertexAttribI1iEXT,
  glVertexAttribI1iv,
  glVertexAttribI1ivEXT,
  glVertexAttribI1ui,
  glVertexAttribI1uiEXT,
  glVertexAttribI1uiv,
  glVertexAttribI1uivEXT,
  glVertexAttribI2i,
  glVertexAttribI2iEXT,
  glVertexAttribI2iv,
  glVertexAttribI2ivEXT,
  glVertexAttribI2ui,
  glVertexAttribI2uiEXT,
  glVertexAttribI2uiv,
  glVertexAttribI2uivEXT,
  glVertexAttribI3i,
  glVertexAttribI3iEXT,
  glVertexAttribI3iv,
  glVertexAttribI3ivEXT,
  glVertexAttribI3ui,
  glVertexAttribI3uiEXT,
  glVertexAttribI3uiv,
  glVertexAttribI3uivEXT,
  glVertexAttribI4bv,
  glVertexAttribI4bvEXT,
  glVertexAttribI4i,
  glVertexAttribI4iEXT,
  glVertexAttribI4iv,
  glVertexAttribI4ivEXT,
  glVertexAttribI4sv,
  glVertexAttribI4svEXT,
  glVertexAttribI4ubv,
  glVertexAttribI4ubvEXT,
  glVertexAttribI4ui,
  glVertexAttribI4uiEXT,
  glVertexAttribI4uiv,
  glVertexAttribI4uivEXT,
  glVertexAttribI4usv,
  glVertexAttribI4usvEXT,
  glVertexAttribIFormat,
  glVertexAttribIFormatNV,
  glVertexAttribIPointer,
  glVertexAttribIPointerEXT,
  glVertexAttribL1d,
  glVertexAttribL1dEXT,
  glVertexAttribL1dv,
  glVertexAttribL1dvEXT,
  glVertexAttribL1i64NV,
  glVertexAttribL1i64vNV,
  glVertexAttribL1ui64ARB,
  glVertexAttribL1ui64NV,
  glVertexAttribL1ui64vARB,
  glVertexAttribL1ui64vNV,
  glVertexAttribL2d,
  glVertexAttribL2dEXT,
  glVertexAttribL2dv,
  glVertexAttribL2dvEXT,
  glVertexAttribL2i64NV,
  glVertexAttribL2i64vNV,
  glVertexAttribL2ui64NV,
  glVertexAttribL2ui64vNV,
  glVertexAttribL3d,
  glVertexAttribL3dEXT,
  glVertexAttribL3dv,
  glVertexAttribL3dvEXT,
  glVertexAttribL3i64NV,
  glVertexAttribL3i64vNV,
  glVertexAttribL3ui64NV,
  glVertexAttribL3ui64vNV,
  glVertexAttribL4d,
  glVertexAttribL4dEXT,
  glVertexAttribL4dv,
  glVertexAttribL4dvEXT,
  glVertexAttribL4i64NV,
  glVertexAttribL4i64vNV,
  glVertexAttribL4ui64NV,
  glVertexAttribL4ui64vNV,
  glVertexAttribLFormat,
  glVertexAttribLFormatNV,
  glVertexAttribLPointer,
  glVertexAttribLPointerEXT,
  glVertexAttribP1ui,
  glVertexAttribP1uiv,
  glVertexAttribP2ui,
  glVertexAttribP2uiv,
  glVertexAttribP3ui,
  glVertexAttribP3uiv,
  glVertexAttribP4ui,
  glVertexAttribP4uiv,
  glVertexAttribParameteriAMD,
  glVertexAttribPointer,
  glVertexAttribPointerARB,
  glVertexAttribPointerNV,
  glVertexAttribs1dvNV,
  glVertexAttribs1fvNV,
  glVertexAttribs1hvNV,
  glVertexAttribs1svNV,
  glVertexAttribs2dvNV,
  glVertexAttribs2fvNV,
  glVertexAttribs2hvNV,
  glVertexAttribs2svNV,
  glVertexAttribs3dvNV,
  glVertexAttribs3fvNV,
  glVertexAttribs3hvNV,
  glVertexAttribs3svNV,
  glVertexAttribs4dvNV,
  glVertexAttribs4fvNV,
  glVertexAttribs4hvNV,
  glVertexAttribs4svNV,
  glVertexAttribs4ubvNV,
  glVertexBindingDivisor,
  glVertexBlendARB,
  glVertexBlendEnvfATI,
  glVertexBlendEnviATI,
  glVertexFormatNV,
  glVertexP2ui,
  glVertexP2uiv,
  glVertexP3ui,
  glVertexP3uiv,
  glVertexP4ui,
  glVertexP4uiv,
  glVertexPointer,
  glVertexPointerEXT,
  glVertexPointerListIBM,
  glVertexPointervINTEL,
  glVertexStream1dATI,
  glVertexStream1dvATI,
  glVertexStream1fATI,
  glVertexStream1fvATI,
  glVertexStream1iATI,
  glVertexStream1ivATI,
  glVertexStream1sATI,
  glVertexStream1svATI,
  glVertexStream2dATI,
  glVertexStream2dvATI,
  glVertexStream2fATI,
  glVertexStream2fvATI,
  glVertexStream2iATI,
  glVertexStream2ivATI,
  glVertexStream2sATI,
  glVertexStream2svATI,
  glVertexStream3dATI,
  glVertexStream3dvATI,
  glVertexStream3fATI,
  glVertexStream3fvATI,
  glVertexStream3iATI,
  glVertexStream3ivATI,
  glVertexStream3sATI,
  glVertexStream3svATI,
  glVertexStream4dATI,
  glVertexStream4dvATI,
  glVertexStream4fATI,
  glVertexStream4fvATI,
  glVertexStream4iATI,
  glVertexStream4ivATI,
  glVertexStream4sATI,
  glVertexStream4svATI,
  glVertexWeightPointerEXT,
  glVertexWeightfEXT,
  glVertexWeightfvEXT,
  glVertexWeighthNV,
  glVertexWeighthvNV,
  glVideoCaptureNV,
  glVideoCaptureStreamParameterdvNV,
  glVideoCaptureStreamParameterfvNV,
  glVideoCaptureStreamParameterivNV,
  glViewport,
  glViewportArrayv,
  glViewportArrayvNV,
  glViewportIndexedf,
  glViewportIndexedfNV,
  glViewportIndexedfv,
  glViewportIndexedfvNV,
  glViewportSwizzleNV,
  glWaitSync,
  glWaitSyncAPPLE,
  glWeightPathsNV,
  glWeightPointerARB,
  glWeightPointerOES,
  glWeightbvARB,
  glWeightdvARB,
  glWeightfvARB,
  glWeightivARB,
  glWeightsvARB,
  glWeightubvARB,
  glWeightuivARB,
  glWeightusvARB,
  glWindowPos2d,
  glWindowPos2dARB,
  glWindowPos2dMESA,
  glWindowPos2dv,
  glWindowPos2dvARB,
  glWindowPos2dvMESA,
  glWindowPos2f,
  glWindowPos2fARB,
  glWindowPos2fMESA,
  glWindowPos2fv,
  glWindowPos2fvARB,
  glWindowPos2fvMESA,
  glWindowPos2i,
  glWindowPos2iARB,
  glWindowPos2iMESA,
  glWindowPos2iv,
  glWindowPos2ivARB,
  glWindowPos2ivMESA,
  glWindowPos2s,
  glWindowPos2sARB,
  glWindowPos2sMESA,
  glWindowPos2sv,
  glWindowPos2svARB,
  glWindowPos2svMESA,
  glWindowPos3d,
  glWindowPos3dARB,
  glWindowPos3dMESA,
  glWindowPos3dv,
  glWindowPos3dvARB,
  glWindowPos3dvMESA,
  glWindowPos3f,
  glWindowPos3fARB,
  glWindowPos3fMESA,
  glWindowPos3fv,
  glWindowPos3fvARB,
  glWindowPos3fvMESA,
  glWindowPos3i,
  glWindowPos3iARB,
  glWindowPos3iMESA,
  glWindowPos3iv,
  glWindowPos3ivARB,
  glWindowPos3ivMESA,
  glWindowPos3s,
  glWindowPos3sARB,
  glWindowPos3sMESA,
  glWindowPos3sv,
  glWindowPos3svARB,
  glWindowPos3svMESA,
  glWindowPos4dMESA,
  glWindowPos4dvMESA,
  glWindowPos4fMESA,
  glWindowPos4fvMESA,
  glWindowPos4iMESA,
  glWindowPos4ivMESA,
  glWindowPos4sMESA,
  glWindowPos4svMESA,
  glWriteMaskEXT
) where

import Control.Monad.IO.Class ( MonadIO(..) )
import Foreign.Marshal.Error ( throwIf )
import Foreign.Ptr ( Ptr, FunPtr, nullFunPtr )
import System.IO.Unsafe ( unsafePerformIO )

import Graphics.GL.Foreign
import Graphics.GL.GetProcAddress ( getProcAddress )
import Graphics.GL.Types

getCommand :: String -> IO (FunPtr a)
getCommand cmd =
  throwIfNullFunPtr ("unknown OpenGL command " ++ cmd) $ getProcAddress cmd

throwIfNullFunPtr :: String -> IO (FunPtr a) -> IO (FunPtr a)
throwIfNullFunPtr = throwIf (== nullFunPtr) . const

-- glAccum ---------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glAccum.xml OpenGL 2.x>.
glAccum
  :: MonadIO m
  => GLenum -- ^ @op@ of type [AccumOp](Graphics-GL-Groups.html#AccumOp).
  -> GLfloat -- ^ @value@ of type @CoordF@.
  -> m ()
glAccum v1 v2 = liftIO $ dyn0 ptr_glAccum v1 v2

{-# NOINLINE ptr_glAccum #-}
ptr_glAccum :: FunPtr (GLenum -> GLfloat -> IO ())
ptr_glAccum = unsafePerformIO $ getCommand "glAccum"

-- glAccumxOES -----------------------------------------------------------------

glAccumxOES
  :: MonadIO m
  => GLenum -- ^ @op@.
  -> GLfixed -- ^ @value@.
  -> m ()
glAccumxOES v1 v2 = liftIO $ dyn1 ptr_glAccumxOES v1 v2

{-# NOINLINE ptr_glAccumxOES #-}
ptr_glAccumxOES :: FunPtr (GLenum -> GLfixed -> IO ())
ptr_glAccumxOES = unsafePerformIO $ getCommand "glAccumxOES"

-- glActiveProgramEXT ----------------------------------------------------------

glActiveProgramEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> m ()
glActiveProgramEXT v1 = liftIO $ dyn2 ptr_glActiveProgramEXT v1

{-# NOINLINE ptr_glActiveProgramEXT #-}
ptr_glActiveProgramEXT :: FunPtr (GLuint -> IO ())
ptr_glActiveProgramEXT = unsafePerformIO $ getCommand "glActiveProgramEXT"

-- glActiveShaderProgram -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glActiveShaderProgram.xhtml OpenGL 4.x>.
glActiveShaderProgram
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> GLuint -- ^ @program@.
  -> m ()
glActiveShaderProgram v1 v2 = liftIO $ dyn3 ptr_glActiveShaderProgram v1 v2

{-# NOINLINE ptr_glActiveShaderProgram #-}
ptr_glActiveShaderProgram :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glActiveShaderProgram = unsafePerformIO $ getCommand "glActiveShaderProgram"

-- glActiveShaderProgramEXT ----------------------------------------------------

glActiveShaderProgramEXT
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> GLuint -- ^ @program@.
  -> m ()
glActiveShaderProgramEXT v1 v2 = liftIO $ dyn3 ptr_glActiveShaderProgramEXT v1 v2

{-# NOINLINE ptr_glActiveShaderProgramEXT #-}
ptr_glActiveShaderProgramEXT :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glActiveShaderProgramEXT = unsafePerformIO $ getCommand "glActiveShaderProgramEXT"

-- glActiveStencilFaceEXT ------------------------------------------------------

glActiveStencilFaceEXT
  :: MonadIO m
  => GLenum -- ^ @face@ of type @StencilFaceDirection@.
  -> m ()
glActiveStencilFaceEXT v1 = liftIO $ dyn4 ptr_glActiveStencilFaceEXT v1

{-# NOINLINE ptr_glActiveStencilFaceEXT #-}
ptr_glActiveStencilFaceEXT :: FunPtr (GLenum -> IO ())
ptr_glActiveStencilFaceEXT = unsafePerformIO $ getCommand "glActiveStencilFaceEXT"

-- glActiveTexture -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glActiveTexture.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glActiveTexture.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glActiveTexture.xhtml OpenGL 4.x>.
glActiveTexture
  :: MonadIO m
  => GLenum -- ^ @texture@ of type @TextureUnit@.
  -> m ()
glActiveTexture v1 = liftIO $ dyn4 ptr_glActiveTexture v1

{-# NOINLINE ptr_glActiveTexture #-}
ptr_glActiveTexture :: FunPtr (GLenum -> IO ())
ptr_glActiveTexture = unsafePerformIO $ getCommand "glActiveTexture"

-- glActiveTextureARB ----------------------------------------------------------

-- | This command is an alias for 'glActiveTexture'.
glActiveTextureARB
  :: MonadIO m
  => GLenum -- ^ @texture@ of type @TextureUnit@.
  -> m ()
glActiveTextureARB v1 = liftIO $ dyn4 ptr_glActiveTextureARB v1

{-# NOINLINE ptr_glActiveTextureARB #-}
ptr_glActiveTextureARB :: FunPtr (GLenum -> IO ())
ptr_glActiveTextureARB = unsafePerformIO $ getCommand "glActiveTextureARB"

-- glActiveVaryingNV -----------------------------------------------------------

glActiveVaryingNV
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m ()
glActiveVaryingNV v1 v2 = liftIO $ dyn5 ptr_glActiveVaryingNV v1 v2

{-# NOINLINE ptr_glActiveVaryingNV #-}
ptr_glActiveVaryingNV :: FunPtr (GLuint -> Ptr GLchar -> IO ())
ptr_glActiveVaryingNV = unsafePerformIO $ getCommand "glActiveVaryingNV"

-- glAlphaFragmentOp1ATI -------------------------------------------------------

glAlphaFragmentOp1ATI
  :: MonadIO m
  => GLenum -- ^ @op@ of type @FragmentOpATI@.
  -> GLuint -- ^ @dst@.
  -> GLuint -- ^ @dstMod@.
  -> GLuint -- ^ @arg1@.
  -> GLuint -- ^ @arg1Rep@.
  -> GLuint -- ^ @arg1Mod@.
  -> m ()
glAlphaFragmentOp1ATI v1 v2 v3 v4 v5 v6 = liftIO $ dyn6 ptr_glAlphaFragmentOp1ATI v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glAlphaFragmentOp1ATI #-}
ptr_glAlphaFragmentOp1ATI :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glAlphaFragmentOp1ATI = unsafePerformIO $ getCommand "glAlphaFragmentOp1ATI"

-- glAlphaFragmentOp2ATI -------------------------------------------------------

glAlphaFragmentOp2ATI
  :: MonadIO m
  => GLenum -- ^ @op@ of type @FragmentOpATI@.
  -> GLuint -- ^ @dst@.
  -> GLuint -- ^ @dstMod@.
  -> GLuint -- ^ @arg1@.
  -> GLuint -- ^ @arg1Rep@.
  -> GLuint -- ^ @arg1Mod@.
  -> GLuint -- ^ @arg2@.
  -> GLuint -- ^ @arg2Rep@.
  -> GLuint -- ^ @arg2Mod@.
  -> m ()
glAlphaFragmentOp2ATI v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn7 ptr_glAlphaFragmentOp2ATI v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glAlphaFragmentOp2ATI #-}
ptr_glAlphaFragmentOp2ATI :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glAlphaFragmentOp2ATI = unsafePerformIO $ getCommand "glAlphaFragmentOp2ATI"

-- glAlphaFragmentOp3ATI -------------------------------------------------------

glAlphaFragmentOp3ATI
  :: MonadIO m
  => GLenum -- ^ @op@ of type @FragmentOpATI@.
  -> GLuint -- ^ @dst@.
  -> GLuint -- ^ @dstMod@.
  -> GLuint -- ^ @arg1@.
  -> GLuint -- ^ @arg1Rep@.
  -> GLuint -- ^ @arg1Mod@.
  -> GLuint -- ^ @arg2@.
  -> GLuint -- ^ @arg2Rep@.
  -> GLuint -- ^ @arg2Mod@.
  -> GLuint -- ^ @arg3@.
  -> GLuint -- ^ @arg3Rep@.
  -> GLuint -- ^ @arg3Mod@.
  -> m ()
glAlphaFragmentOp3ATI v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 = liftIO $ dyn8 ptr_glAlphaFragmentOp3ATI v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12

{-# NOINLINE ptr_glAlphaFragmentOp3ATI #-}
ptr_glAlphaFragmentOp3ATI :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glAlphaFragmentOp3ATI = unsafePerformIO $ getCommand "glAlphaFragmentOp3ATI"

-- glAlphaFunc -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glAlphaFunc.xml OpenGL 2.x>.
glAlphaFunc
  :: MonadIO m
  => GLenum -- ^ @func@ of type [AlphaFunction](Graphics-GL-Groups.html#AlphaFunction).
  -> GLfloat -- ^ @ref@.
  -> m ()
glAlphaFunc v1 v2 = liftIO $ dyn0 ptr_glAlphaFunc v1 v2

{-# NOINLINE ptr_glAlphaFunc #-}
ptr_glAlphaFunc :: FunPtr (GLenum -> GLfloat -> IO ())
ptr_glAlphaFunc = unsafePerformIO $ getCommand "glAlphaFunc"

-- glAlphaFuncQCOM -------------------------------------------------------------

glAlphaFuncQCOM
  :: MonadIO m
  => GLenum -- ^ @func@.
  -> GLclampf -- ^ @ref@.
  -> m ()
glAlphaFuncQCOM v1 v2 = liftIO $ dyn9 ptr_glAlphaFuncQCOM v1 v2

{-# NOINLINE ptr_glAlphaFuncQCOM #-}
ptr_glAlphaFuncQCOM :: FunPtr (GLenum -> GLclampf -> IO ())
ptr_glAlphaFuncQCOM = unsafePerformIO $ getCommand "glAlphaFuncQCOM"

-- glAlphaFuncx ----------------------------------------------------------------

glAlphaFuncx
  :: MonadIO m
  => GLenum -- ^ @func@.
  -> GLfixed -- ^ @ref@.
  -> m ()
glAlphaFuncx v1 v2 = liftIO $ dyn1 ptr_glAlphaFuncx v1 v2

{-# NOINLINE ptr_glAlphaFuncx #-}
ptr_glAlphaFuncx :: FunPtr (GLenum -> GLfixed -> IO ())
ptr_glAlphaFuncx = unsafePerformIO $ getCommand "glAlphaFuncx"

-- glAlphaFuncxOES -------------------------------------------------------------

glAlphaFuncxOES
  :: MonadIO m
  => GLenum -- ^ @func@.
  -> GLfixed -- ^ @ref@ of type @ClampedFixed@.
  -> m ()
glAlphaFuncxOES v1 v2 = liftIO $ dyn1 ptr_glAlphaFuncxOES v1 v2

{-# NOINLINE ptr_glAlphaFuncxOES #-}
ptr_glAlphaFuncxOES :: FunPtr (GLenum -> GLfixed -> IO ())
ptr_glAlphaFuncxOES = unsafePerformIO $ getCommand "glAlphaFuncxOES"

-- glApplyFramebufferAttachmentCMAAINTEL ---------------------------------------

glApplyFramebufferAttachmentCMAAINTEL
  :: MonadIO m
  => m ()
glApplyFramebufferAttachmentCMAAINTEL = liftIO $ dyn10 ptr_glApplyFramebufferAttachmentCMAAINTEL

{-# NOINLINE ptr_glApplyFramebufferAttachmentCMAAINTEL #-}
ptr_glApplyFramebufferAttachmentCMAAINTEL :: FunPtr (IO ())
ptr_glApplyFramebufferAttachmentCMAAINTEL = unsafePerformIO $ getCommand "glApplyFramebufferAttachmentCMAAINTEL"

-- glApplyTextureEXT -----------------------------------------------------------

glApplyTextureEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @LightTextureModeEXT@.
  -> m ()
glApplyTextureEXT v1 = liftIO $ dyn4 ptr_glApplyTextureEXT v1

{-# NOINLINE ptr_glApplyTextureEXT #-}
ptr_glApplyTextureEXT :: FunPtr (GLenum -> IO ())
ptr_glApplyTextureEXT = unsafePerformIO $ getCommand "glApplyTextureEXT"

-- glAreProgramsResidentNV -----------------------------------------------------

glAreProgramsResidentNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @programs@ pointing to @n@ elements of type @GLuint@.
  -> Ptr GLboolean -- ^ @residences@ pointing to @n@ elements of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glAreProgramsResidentNV v1 v2 v3 = liftIO $ dyn11 ptr_glAreProgramsResidentNV v1 v2 v3

{-# NOINLINE ptr_glAreProgramsResidentNV #-}
ptr_glAreProgramsResidentNV :: FunPtr (GLsizei -> Ptr GLuint -> Ptr GLboolean -> IO GLboolean)
ptr_glAreProgramsResidentNV = unsafePerformIO $ getCommand "glAreProgramsResidentNV"

-- glAreTexturesResident -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glAreTexturesResident.xml OpenGL 2.x>.
glAreTexturesResident
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @textures@ pointing to @n@ elements of type @Texture@.
  -> Ptr GLboolean -- ^ @residences@ pointing to @n@ elements of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glAreTexturesResident v1 v2 v3 = liftIO $ dyn11 ptr_glAreTexturesResident v1 v2 v3

{-# NOINLINE ptr_glAreTexturesResident #-}
ptr_glAreTexturesResident :: FunPtr (GLsizei -> Ptr GLuint -> Ptr GLboolean -> IO GLboolean)
ptr_glAreTexturesResident = unsafePerformIO $ getCommand "glAreTexturesResident"

-- glAreTexturesResidentEXT ----------------------------------------------------

glAreTexturesResidentEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @textures@ pointing to @n@ elements of type @Texture@.
  -> Ptr GLboolean -- ^ @residences@ pointing to @n@ elements of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glAreTexturesResidentEXT v1 v2 v3 = liftIO $ dyn11 ptr_glAreTexturesResidentEXT v1 v2 v3

{-# NOINLINE ptr_glAreTexturesResidentEXT #-}
ptr_glAreTexturesResidentEXT :: FunPtr (GLsizei -> Ptr GLuint -> Ptr GLboolean -> IO GLboolean)
ptr_glAreTexturesResidentEXT = unsafePerformIO $ getCommand "glAreTexturesResidentEXT"

-- glArrayElement --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glArrayElement.xml OpenGL 2.x>.
glArrayElement
  :: MonadIO m
  => GLint -- ^ @i@.
  -> m ()
glArrayElement v1 = liftIO $ dyn12 ptr_glArrayElement v1

{-# NOINLINE ptr_glArrayElement #-}
ptr_glArrayElement :: FunPtr (GLint -> IO ())
ptr_glArrayElement = unsafePerformIO $ getCommand "glArrayElement"

-- glArrayElementEXT -----------------------------------------------------------

-- | This command is an alias for 'glArrayElement'.
glArrayElementEXT
  :: MonadIO m
  => GLint -- ^ @i@.
  -> m ()
glArrayElementEXT v1 = liftIO $ dyn12 ptr_glArrayElementEXT v1

{-# NOINLINE ptr_glArrayElementEXT #-}
ptr_glArrayElementEXT :: FunPtr (GLint -> IO ())
ptr_glArrayElementEXT = unsafePerformIO $ getCommand "glArrayElementEXT"

-- glArrayObjectATI ------------------------------------------------------------

glArrayObjectATI
  :: MonadIO m
  => GLenum -- ^ @array@ of type [EnableCap](Graphics-GL-Groups.html#EnableCap).
  -> GLint -- ^ @size@.
  -> GLenum -- ^ @type@ of type @ScalarType@.
  -> GLsizei -- ^ @stride@.
  -> GLuint -- ^ @buffer@.
  -> GLuint -- ^ @offset@.
  -> m ()
glArrayObjectATI v1 v2 v3 v4 v5 v6 = liftIO $ dyn13 ptr_glArrayObjectATI v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glArrayObjectATI #-}
ptr_glArrayObjectATI :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLuint -> GLuint -> IO ())
ptr_glArrayObjectATI = unsafePerformIO $ getCommand "glArrayObjectATI"

-- glAsyncMarkerSGIX -----------------------------------------------------------

glAsyncMarkerSGIX
  :: MonadIO m
  => GLuint -- ^ @marker@.
  -> m ()
glAsyncMarkerSGIX v1 = liftIO $ dyn2 ptr_glAsyncMarkerSGIX v1

{-# NOINLINE ptr_glAsyncMarkerSGIX #-}
ptr_glAsyncMarkerSGIX :: FunPtr (GLuint -> IO ())
ptr_glAsyncMarkerSGIX = unsafePerformIO $ getCommand "glAsyncMarkerSGIX"

-- glAttachObjectARB -----------------------------------------------------------

-- | This command is an alias for 'glAttachShader'.
glAttachObjectARB
  :: MonadIO m
  => GLhandleARB -- ^ @containerObj@ of type @handleARB@.
  -> GLhandleARB -- ^ @obj@ of type @handleARB@.
  -> m ()
glAttachObjectARB v1 v2 = liftIO $ dyn14 ptr_glAttachObjectARB v1 v2

{-# NOINLINE ptr_glAttachObjectARB #-}
ptr_glAttachObjectARB :: FunPtr (GLhandleARB -> GLhandleARB -> IO ())
ptr_glAttachObjectARB = unsafePerformIO $ getCommand "glAttachObjectARB"

-- glAttachShader --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glAttachShader.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glAttachShader.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glAttachShader.xhtml OpenGL 4.x>.
glAttachShader
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @shader@.
  -> m ()
glAttachShader v1 v2 = liftIO $ dyn3 ptr_glAttachShader v1 v2

{-# NOINLINE ptr_glAttachShader #-}
ptr_glAttachShader :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glAttachShader = unsafePerformIO $ getCommand "glAttachShader"

-- glBegin ---------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glBegin.xml OpenGL 2.x>.
glBegin
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> m ()
glBegin v1 = liftIO $ dyn4 ptr_glBegin v1

{-# NOINLINE ptr_glBegin #-}
ptr_glBegin :: FunPtr (GLenum -> IO ())
ptr_glBegin = unsafePerformIO $ getCommand "glBegin"

-- glBeginConditionalRender ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBeginConditionalRender.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBeginConditionalRender.xhtml OpenGL 4.x>.
glBeginConditionalRender
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @mode@ of type @TypeEnum@.
  -> m ()
glBeginConditionalRender v1 v2 = liftIO $ dyn15 ptr_glBeginConditionalRender v1 v2

{-# NOINLINE ptr_glBeginConditionalRender #-}
ptr_glBeginConditionalRender :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glBeginConditionalRender = unsafePerformIO $ getCommand "glBeginConditionalRender"

-- glBeginConditionalRenderNV --------------------------------------------------

-- | This command is an alias for 'glBeginConditionalRender'.
glBeginConditionalRenderNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @mode@ of type @TypeEnum@.
  -> m ()
glBeginConditionalRenderNV v1 v2 = liftIO $ dyn15 ptr_glBeginConditionalRenderNV v1 v2

{-# NOINLINE ptr_glBeginConditionalRenderNV #-}
ptr_glBeginConditionalRenderNV :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glBeginConditionalRenderNV = unsafePerformIO $ getCommand "glBeginConditionalRenderNV"

-- glBeginConditionalRenderNVX -------------------------------------------------

glBeginConditionalRenderNVX
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glBeginConditionalRenderNVX v1 = liftIO $ dyn2 ptr_glBeginConditionalRenderNVX v1

{-# NOINLINE ptr_glBeginConditionalRenderNVX #-}
ptr_glBeginConditionalRenderNVX :: FunPtr (GLuint -> IO ())
ptr_glBeginConditionalRenderNVX = unsafePerformIO $ getCommand "glBeginConditionalRenderNVX"

-- glBeginFragmentShaderATI ----------------------------------------------------

glBeginFragmentShaderATI
  :: MonadIO m
  => m ()
glBeginFragmentShaderATI = liftIO $ dyn10 ptr_glBeginFragmentShaderATI

{-# NOINLINE ptr_glBeginFragmentShaderATI #-}
ptr_glBeginFragmentShaderATI :: FunPtr (IO ())
ptr_glBeginFragmentShaderATI = unsafePerformIO $ getCommand "glBeginFragmentShaderATI"

-- glBeginOcclusionQueryNV -----------------------------------------------------

glBeginOcclusionQueryNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glBeginOcclusionQueryNV v1 = liftIO $ dyn2 ptr_glBeginOcclusionQueryNV v1

{-# NOINLINE ptr_glBeginOcclusionQueryNV #-}
ptr_glBeginOcclusionQueryNV :: FunPtr (GLuint -> IO ())
ptr_glBeginOcclusionQueryNV = unsafePerformIO $ getCommand "glBeginOcclusionQueryNV"

-- glBeginPerfMonitorAMD -------------------------------------------------------

glBeginPerfMonitorAMD
  :: MonadIO m
  => GLuint -- ^ @monitor@.
  -> m ()
glBeginPerfMonitorAMD v1 = liftIO $ dyn2 ptr_glBeginPerfMonitorAMD v1

{-# NOINLINE ptr_glBeginPerfMonitorAMD #-}
ptr_glBeginPerfMonitorAMD :: FunPtr (GLuint -> IO ())
ptr_glBeginPerfMonitorAMD = unsafePerformIO $ getCommand "glBeginPerfMonitorAMD"

-- glBeginPerfQueryINTEL -------------------------------------------------------

glBeginPerfQueryINTEL
  :: MonadIO m
  => GLuint -- ^ @queryHandle@.
  -> m ()
glBeginPerfQueryINTEL v1 = liftIO $ dyn2 ptr_glBeginPerfQueryINTEL v1

{-# NOINLINE ptr_glBeginPerfQueryINTEL #-}
ptr_glBeginPerfQueryINTEL :: FunPtr (GLuint -> IO ())
ptr_glBeginPerfQueryINTEL = unsafePerformIO $ getCommand "glBeginPerfQueryINTEL"

-- glBeginQuery ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBeginQuery.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBeginQuery.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBeginQuery.xhtml OpenGL 4.x>.
glBeginQuery
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @id@.
  -> m ()
glBeginQuery v1 v2 = liftIO $ dyn16 ptr_glBeginQuery v1 v2

{-# NOINLINE ptr_glBeginQuery #-}
ptr_glBeginQuery :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBeginQuery = unsafePerformIO $ getCommand "glBeginQuery"

-- glBeginQueryARB -------------------------------------------------------------

-- | This command is an alias for 'glBeginQuery'.
glBeginQueryARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @id@.
  -> m ()
glBeginQueryARB v1 v2 = liftIO $ dyn16 ptr_glBeginQueryARB v1 v2

{-# NOINLINE ptr_glBeginQueryARB #-}
ptr_glBeginQueryARB :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBeginQueryARB = unsafePerformIO $ getCommand "glBeginQueryARB"

-- glBeginQueryEXT -------------------------------------------------------------

glBeginQueryEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @id@.
  -> m ()
glBeginQueryEXT v1 v2 = liftIO $ dyn16 ptr_glBeginQueryEXT v1 v2

{-# NOINLINE ptr_glBeginQueryEXT #-}
ptr_glBeginQueryEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBeginQueryEXT = unsafePerformIO $ getCommand "glBeginQueryEXT"

-- glBeginQueryIndexed ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBeginQueryIndexed.xhtml OpenGL 4.x>.
glBeginQueryIndexed
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @id@.
  -> m ()
glBeginQueryIndexed v1 v2 v3 = liftIO $ dyn17 ptr_glBeginQueryIndexed v1 v2 v3

{-# NOINLINE ptr_glBeginQueryIndexed #-}
ptr_glBeginQueryIndexed :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
ptr_glBeginQueryIndexed = unsafePerformIO $ getCommand "glBeginQueryIndexed"

-- glBeginTransformFeedback ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBeginTransformFeedback.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBeginTransformFeedback.xhtml OpenGL 4.x>.
glBeginTransformFeedback
  :: MonadIO m
  => GLenum -- ^ @primitiveMode@.
  -> m ()
glBeginTransformFeedback v1 = liftIO $ dyn4 ptr_glBeginTransformFeedback v1

{-# NOINLINE ptr_glBeginTransformFeedback #-}
ptr_glBeginTransformFeedback :: FunPtr (GLenum -> IO ())
ptr_glBeginTransformFeedback = unsafePerformIO $ getCommand "glBeginTransformFeedback"

-- glBeginTransformFeedbackEXT -------------------------------------------------

-- | This command is an alias for 'glBeginTransformFeedback'.
glBeginTransformFeedbackEXT
  :: MonadIO m
  => GLenum -- ^ @primitiveMode@.
  -> m ()
glBeginTransformFeedbackEXT v1 = liftIO $ dyn4 ptr_glBeginTransformFeedbackEXT v1

{-# NOINLINE ptr_glBeginTransformFeedbackEXT #-}
ptr_glBeginTransformFeedbackEXT :: FunPtr (GLenum -> IO ())
ptr_glBeginTransformFeedbackEXT = unsafePerformIO $ getCommand "glBeginTransformFeedbackEXT"

-- glBeginTransformFeedbackNV --------------------------------------------------

-- | This command is an alias for 'glBeginTransformFeedback'.
glBeginTransformFeedbackNV
  :: MonadIO m
  => GLenum -- ^ @primitiveMode@.
  -> m ()
glBeginTransformFeedbackNV v1 = liftIO $ dyn4 ptr_glBeginTransformFeedbackNV v1

{-# NOINLINE ptr_glBeginTransformFeedbackNV #-}
ptr_glBeginTransformFeedbackNV :: FunPtr (GLenum -> IO ())
ptr_glBeginTransformFeedbackNV = unsafePerformIO $ getCommand "glBeginTransformFeedbackNV"

-- glBeginVertexShaderEXT ------------------------------------------------------

glBeginVertexShaderEXT
  :: MonadIO m
  => m ()
glBeginVertexShaderEXT = liftIO $ dyn10 ptr_glBeginVertexShaderEXT

{-# NOINLINE ptr_glBeginVertexShaderEXT #-}
ptr_glBeginVertexShaderEXT :: FunPtr (IO ())
ptr_glBeginVertexShaderEXT = unsafePerformIO $ getCommand "glBeginVertexShaderEXT"

-- glBeginVideoCaptureNV -------------------------------------------------------

glBeginVideoCaptureNV
  :: MonadIO m
  => GLuint -- ^ @video_capture_slot@.
  -> m ()
glBeginVideoCaptureNV v1 = liftIO $ dyn2 ptr_glBeginVideoCaptureNV v1

{-# NOINLINE ptr_glBeginVideoCaptureNV #-}
ptr_glBeginVideoCaptureNV :: FunPtr (GLuint -> IO ())
ptr_glBeginVideoCaptureNV = unsafePerformIO $ getCommand "glBeginVideoCaptureNV"

-- glBindAttribLocation --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBindAttribLocation.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBindAttribLocation.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindAttribLocation.xhtml OpenGL 4.x>.
glBindAttribLocation
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @index@.
  -> Ptr GLchar -- ^ @name@.
  -> m ()
glBindAttribLocation v1 v2 v3 = liftIO $ dyn18 ptr_glBindAttribLocation v1 v2 v3

{-# NOINLINE ptr_glBindAttribLocation #-}
ptr_glBindAttribLocation :: FunPtr (GLuint -> GLuint -> Ptr GLchar -> IO ())
ptr_glBindAttribLocation = unsafePerformIO $ getCommand "glBindAttribLocation"

-- glBindAttribLocationARB -----------------------------------------------------

-- | This command is an alias for 'glBindAttribLocation'.
glBindAttribLocationARB
  :: MonadIO m
  => GLhandleARB -- ^ @programObj@ of type @handleARB@.
  -> GLuint -- ^ @index@.
  -> Ptr GLcharARB -- ^ @name@.
  -> m ()
glBindAttribLocationARB v1 v2 v3 = liftIO $ dyn19 ptr_glBindAttribLocationARB v1 v2 v3

{-# NOINLINE ptr_glBindAttribLocationARB #-}
ptr_glBindAttribLocationARB :: FunPtr (GLhandleARB -> GLuint -> Ptr GLcharARB -> IO ())
ptr_glBindAttribLocationARB = unsafePerformIO $ getCommand "glBindAttribLocationARB"

-- glBindBuffer ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBindBuffer.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBindBuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindBuffer.xhtml OpenGL 4.x>.
glBindBuffer
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLuint -- ^ @buffer@.
  -> m ()
glBindBuffer v1 v2 = liftIO $ dyn16 ptr_glBindBuffer v1 v2

{-# NOINLINE ptr_glBindBuffer #-}
ptr_glBindBuffer :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindBuffer = unsafePerformIO $ getCommand "glBindBuffer"

-- glBindBufferARB -------------------------------------------------------------

-- | This command is an alias for 'glBindBuffer'.
glBindBufferARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLuint -- ^ @buffer@.
  -> m ()
glBindBufferARB v1 v2 = liftIO $ dyn16 ptr_glBindBufferARB v1 v2

{-# NOINLINE ptr_glBindBufferARB #-}
ptr_glBindBufferARB :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindBufferARB = unsafePerformIO $ getCommand "glBindBufferARB"

-- glBindBufferBase ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindBufferBase.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindBufferBase.xhtml OpenGL 4.x>.
glBindBufferBase
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> m ()
glBindBufferBase v1 v2 v3 = liftIO $ dyn17 ptr_glBindBufferBase v1 v2 v3

{-# NOINLINE ptr_glBindBufferBase #-}
ptr_glBindBufferBase :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
ptr_glBindBufferBase = unsafePerformIO $ getCommand "glBindBufferBase"

-- glBindBufferBaseEXT ---------------------------------------------------------

-- | This command is an alias for 'glBindBufferBase'.
glBindBufferBaseEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> m ()
glBindBufferBaseEXT v1 v2 v3 = liftIO $ dyn17 ptr_glBindBufferBaseEXT v1 v2 v3

{-# NOINLINE ptr_glBindBufferBaseEXT #-}
ptr_glBindBufferBaseEXT :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
ptr_glBindBufferBaseEXT = unsafePerformIO $ getCommand "glBindBufferBaseEXT"

-- glBindBufferBaseNV ----------------------------------------------------------

-- | This command is an alias for 'glBindBufferBase'.
glBindBufferBaseNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> m ()
glBindBufferBaseNV v1 v2 v3 = liftIO $ dyn17 ptr_glBindBufferBaseNV v1 v2 v3

{-# NOINLINE ptr_glBindBufferBaseNV #-}
ptr_glBindBufferBaseNV :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
ptr_glBindBufferBaseNV = unsafePerformIO $ getCommand "glBindBufferBaseNV"

-- glBindBufferOffsetEXT -------------------------------------------------------

glBindBufferOffsetEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> m ()
glBindBufferOffsetEXT v1 v2 v3 v4 = liftIO $ dyn20 ptr_glBindBufferOffsetEXT v1 v2 v3 v4

{-# NOINLINE ptr_glBindBufferOffsetEXT #-}
ptr_glBindBufferOffsetEXT :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> IO ())
ptr_glBindBufferOffsetEXT = unsafePerformIO $ getCommand "glBindBufferOffsetEXT"

-- glBindBufferOffsetNV --------------------------------------------------------

-- | This command is an alias for 'glBindBufferOffsetEXT'.
glBindBufferOffsetNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> m ()
glBindBufferOffsetNV v1 v2 v3 v4 = liftIO $ dyn20 ptr_glBindBufferOffsetNV v1 v2 v3 v4

{-# NOINLINE ptr_glBindBufferOffsetNV #-}
ptr_glBindBufferOffsetNV :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> IO ())
ptr_glBindBufferOffsetNV = unsafePerformIO $ getCommand "glBindBufferOffsetNV"

-- glBindBufferRange -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindBufferRange.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindBufferRange.xhtml OpenGL 4.x>.
glBindBufferRange
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> m ()
glBindBufferRange v1 v2 v3 v4 v5 = liftIO $ dyn21 ptr_glBindBufferRange v1 v2 v3 v4 v5

{-# NOINLINE ptr_glBindBufferRange #-}
ptr_glBindBufferRange :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> GLsizeiptr -> IO ())
ptr_glBindBufferRange = unsafePerformIO $ getCommand "glBindBufferRange"

-- glBindBufferRangeEXT --------------------------------------------------------

-- | This command is an alias for 'glBindBufferRange'.
glBindBufferRangeEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> m ()
glBindBufferRangeEXT v1 v2 v3 v4 v5 = liftIO $ dyn21 ptr_glBindBufferRangeEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glBindBufferRangeEXT #-}
ptr_glBindBufferRangeEXT :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> GLsizeiptr -> IO ())
ptr_glBindBufferRangeEXT = unsafePerformIO $ getCommand "glBindBufferRangeEXT"

-- glBindBufferRangeNV ---------------------------------------------------------

-- | This command is an alias for 'glBindBufferRange'.
glBindBufferRangeNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> m ()
glBindBufferRangeNV v1 v2 v3 v4 v5 = liftIO $ dyn21 ptr_glBindBufferRangeNV v1 v2 v3 v4 v5

{-# NOINLINE ptr_glBindBufferRangeNV #-}
ptr_glBindBufferRangeNV :: FunPtr (GLenum -> GLuint -> GLuint -> GLintptr -> GLsizeiptr -> IO ())
ptr_glBindBufferRangeNV = unsafePerformIO $ getCommand "glBindBufferRangeNV"

-- glBindBuffersBase -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindBuffersBase.xhtml OpenGL 4.x>.
glBindBuffersBase
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @buffers@ pointing to @count@ elements of type @GLuint@.
  -> m ()
glBindBuffersBase v1 v2 v3 v4 = liftIO $ dyn22 ptr_glBindBuffersBase v1 v2 v3 v4

{-# NOINLINE ptr_glBindBuffersBase #-}
ptr_glBindBuffersBase :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glBindBuffersBase = unsafePerformIO $ getCommand "glBindBuffersBase"

-- glBindBuffersRange ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindBuffersRange.xhtml OpenGL 4.x>.
glBindBuffersRange
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @buffers@ pointing to @count@ elements of type @GLuint@.
  -> Ptr GLintptr -- ^ @offsets@ pointing to @count@ elements of type @GLintptr@.
  -> Ptr GLsizeiptr -- ^ @sizes@ pointing to @count@ elements of type @GLsizeiptr@.
  -> m ()
glBindBuffersRange v1 v2 v3 v4 v5 v6 = liftIO $ dyn23 ptr_glBindBuffersRange v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glBindBuffersRange #-}
ptr_glBindBuffersRange :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLuint -> Ptr GLintptr -> Ptr GLsizeiptr -> IO ())
ptr_glBindBuffersRange = unsafePerformIO $ getCommand "glBindBuffersRange"

-- glBindFragDataLocation ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindFragDataLocation.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindFragDataLocation.xhtml OpenGL 4.x>.
glBindFragDataLocation
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @color@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m ()
glBindFragDataLocation v1 v2 v3 = liftIO $ dyn18 ptr_glBindFragDataLocation v1 v2 v3

{-# NOINLINE ptr_glBindFragDataLocation #-}
ptr_glBindFragDataLocation :: FunPtr (GLuint -> GLuint -> Ptr GLchar -> IO ())
ptr_glBindFragDataLocation = unsafePerformIO $ getCommand "glBindFragDataLocation"

-- glBindFragDataLocationEXT ---------------------------------------------------

-- | This command is an alias for 'glBindFragDataLocation'.
glBindFragDataLocationEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @color@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m ()
glBindFragDataLocationEXT v1 v2 v3 = liftIO $ dyn18 ptr_glBindFragDataLocationEXT v1 v2 v3

{-# NOINLINE ptr_glBindFragDataLocationEXT #-}
ptr_glBindFragDataLocationEXT :: FunPtr (GLuint -> GLuint -> Ptr GLchar -> IO ())
ptr_glBindFragDataLocationEXT = unsafePerformIO $ getCommand "glBindFragDataLocationEXT"

-- glBindFragDataLocationIndexed -----------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindFragDataLocationIndexed.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindFragDataLocationIndexed.xhtml OpenGL 4.x>.
glBindFragDataLocationIndexed
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @colorNumber@.
  -> GLuint -- ^ @index@.
  -> Ptr GLchar -- ^ @name@.
  -> m ()
glBindFragDataLocationIndexed v1 v2 v3 v4 = liftIO $ dyn24 ptr_glBindFragDataLocationIndexed v1 v2 v3 v4

{-# NOINLINE ptr_glBindFragDataLocationIndexed #-}
ptr_glBindFragDataLocationIndexed :: FunPtr (GLuint -> GLuint -> GLuint -> Ptr GLchar -> IO ())
ptr_glBindFragDataLocationIndexed = unsafePerformIO $ getCommand "glBindFragDataLocationIndexed"

-- glBindFragDataLocationIndexedEXT --------------------------------------------

-- | This command is an alias for 'glBindFragDataLocationIndexed'.
glBindFragDataLocationIndexedEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @colorNumber@.
  -> GLuint -- ^ @index@.
  -> Ptr GLchar -- ^ @name@.
  -> m ()
glBindFragDataLocationIndexedEXT v1 v2 v3 v4 = liftIO $ dyn24 ptr_glBindFragDataLocationIndexedEXT v1 v2 v3 v4

{-# NOINLINE ptr_glBindFragDataLocationIndexedEXT #-}
ptr_glBindFragDataLocationIndexedEXT :: FunPtr (GLuint -> GLuint -> GLuint -> Ptr GLchar -> IO ())
ptr_glBindFragDataLocationIndexedEXT = unsafePerformIO $ getCommand "glBindFragDataLocationIndexedEXT"

-- glBindFragmentShaderATI -----------------------------------------------------

glBindFragmentShaderATI
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glBindFragmentShaderATI v1 = liftIO $ dyn2 ptr_glBindFragmentShaderATI v1

{-# NOINLINE ptr_glBindFragmentShaderATI #-}
ptr_glBindFragmentShaderATI :: FunPtr (GLuint -> IO ())
ptr_glBindFragmentShaderATI = unsafePerformIO $ getCommand "glBindFragmentShaderATI"

-- glBindFramebuffer -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindFramebuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindFramebuffer.xhtml OpenGL 4.x>.
glBindFramebuffer
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLuint -- ^ @framebuffer@.
  -> m ()
glBindFramebuffer v1 v2 = liftIO $ dyn16 ptr_glBindFramebuffer v1 v2

{-# NOINLINE ptr_glBindFramebuffer #-}
ptr_glBindFramebuffer :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindFramebuffer = unsafePerformIO $ getCommand "glBindFramebuffer"

-- glBindFramebufferEXT --------------------------------------------------------

glBindFramebufferEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLuint -- ^ @framebuffer@.
  -> m ()
glBindFramebufferEXT v1 v2 = liftIO $ dyn16 ptr_glBindFramebufferEXT v1 v2

{-# NOINLINE ptr_glBindFramebufferEXT #-}
ptr_glBindFramebufferEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindFramebufferEXT = unsafePerformIO $ getCommand "glBindFramebufferEXT"

-- glBindFramebufferOES --------------------------------------------------------

glBindFramebufferOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @framebuffer@.
  -> m ()
glBindFramebufferOES v1 v2 = liftIO $ dyn16 ptr_glBindFramebufferOES v1 v2

{-# NOINLINE ptr_glBindFramebufferOES #-}
ptr_glBindFramebufferOES :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindFramebufferOES = unsafePerformIO $ getCommand "glBindFramebufferOES"

-- glBindImageTexture ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindImageTexture.xhtml OpenGL 4.x>.
glBindImageTexture
  :: MonadIO m
  => GLuint -- ^ @unit@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLboolean -- ^ @layered@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLint -- ^ @layer@.
  -> GLenum -- ^ @access@.
  -> GLenum -- ^ @format@.
  -> m ()
glBindImageTexture v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn25 ptr_glBindImageTexture v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glBindImageTexture #-}
ptr_glBindImageTexture :: FunPtr (GLuint -> GLuint -> GLint -> GLboolean -> GLint -> GLenum -> GLenum -> IO ())
ptr_glBindImageTexture = unsafePerformIO $ getCommand "glBindImageTexture"

-- glBindImageTextureEXT -------------------------------------------------------

glBindImageTextureEXT
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLboolean -- ^ @layered@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLint -- ^ @layer@.
  -> GLenum -- ^ @access@.
  -> GLint -- ^ @format@.
  -> m ()
glBindImageTextureEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn26 ptr_glBindImageTextureEXT v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glBindImageTextureEXT #-}
ptr_glBindImageTextureEXT :: FunPtr (GLuint -> GLuint -> GLint -> GLboolean -> GLint -> GLenum -> GLint -> IO ())
ptr_glBindImageTextureEXT = unsafePerformIO $ getCommand "glBindImageTextureEXT"

-- glBindImageTextures ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindImageTextures.xhtml OpenGL 4.x>.
glBindImageTextures
  :: MonadIO m
  => GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @textures@ pointing to @count@ elements of type @GLuint@.
  -> m ()
glBindImageTextures v1 v2 v3 = liftIO $ dyn27 ptr_glBindImageTextures v1 v2 v3

{-# NOINLINE ptr_glBindImageTextures #-}
ptr_glBindImageTextures :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glBindImageTextures = unsafePerformIO $ getCommand "glBindImageTextures"

-- glBindLightParameterEXT -----------------------------------------------------

glBindLightParameterEXT
  :: MonadIO m
  => GLenum -- ^ @light@ of type [LightName](Graphics-GL-Groups.html#LightName).
  -> GLenum -- ^ @value@ of type [LightParameter](Graphics-GL-Groups.html#LightParameter).
  -> m GLuint
glBindLightParameterEXT v1 v2 = liftIO $ dyn28 ptr_glBindLightParameterEXT v1 v2

{-# NOINLINE ptr_glBindLightParameterEXT #-}
ptr_glBindLightParameterEXT :: FunPtr (GLenum -> GLenum -> IO GLuint)
ptr_glBindLightParameterEXT = unsafePerformIO $ getCommand "glBindLightParameterEXT"

-- glBindMaterialParameterEXT --------------------------------------------------

glBindMaterialParameterEXT
  :: MonadIO m
  => GLenum -- ^ @face@ of type [MaterialFace](Graphics-GL-Groups.html#MaterialFace).
  -> GLenum -- ^ @value@ of type [MaterialParameter](Graphics-GL-Groups.html#MaterialParameter).
  -> m GLuint
glBindMaterialParameterEXT v1 v2 = liftIO $ dyn28 ptr_glBindMaterialParameterEXT v1 v2

{-# NOINLINE ptr_glBindMaterialParameterEXT #-}
ptr_glBindMaterialParameterEXT :: FunPtr (GLenum -> GLenum -> IO GLuint)
ptr_glBindMaterialParameterEXT = unsafePerformIO $ getCommand "glBindMaterialParameterEXT"

-- glBindMultiTextureEXT -------------------------------------------------------

glBindMultiTextureEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> m ()
glBindMultiTextureEXT v1 v2 v3 = liftIO $ dyn29 ptr_glBindMultiTextureEXT v1 v2 v3

{-# NOINLINE ptr_glBindMultiTextureEXT #-}
ptr_glBindMultiTextureEXT :: FunPtr (GLenum -> GLenum -> GLuint -> IO ())
ptr_glBindMultiTextureEXT = unsafePerformIO $ getCommand "glBindMultiTextureEXT"

-- glBindParameterEXT ----------------------------------------------------------

glBindParameterEXT
  :: MonadIO m
  => GLenum -- ^ @value@ of type @VertexShaderParameterEXT@.
  -> m GLuint
glBindParameterEXT v1 = liftIO $ dyn30 ptr_glBindParameterEXT v1

{-# NOINLINE ptr_glBindParameterEXT #-}
ptr_glBindParameterEXT :: FunPtr (GLenum -> IO GLuint)
ptr_glBindParameterEXT = unsafePerformIO $ getCommand "glBindParameterEXT"

-- glBindProgramARB ------------------------------------------------------------

glBindProgramARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTargetARB@.
  -> GLuint -- ^ @program@.
  -> m ()
glBindProgramARB v1 v2 = liftIO $ dyn16 ptr_glBindProgramARB v1 v2

{-# NOINLINE ptr_glBindProgramARB #-}
ptr_glBindProgramARB :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindProgramARB = unsafePerformIO $ getCommand "glBindProgramARB"

-- glBindProgramNV -------------------------------------------------------------

-- | This command is an alias for 'glBindProgramARB'.
glBindProgramNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @VertexAttribEnumNV@.
  -> GLuint -- ^ @id@.
  -> m ()
glBindProgramNV v1 v2 = liftIO $ dyn16 ptr_glBindProgramNV v1 v2

{-# NOINLINE ptr_glBindProgramNV #-}
ptr_glBindProgramNV :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindProgramNV = unsafePerformIO $ getCommand "glBindProgramNV"

-- glBindProgramPipeline -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindProgramPipeline.xhtml OpenGL 4.x>.
glBindProgramPipeline
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> m ()
glBindProgramPipeline v1 = liftIO $ dyn2 ptr_glBindProgramPipeline v1

{-# NOINLINE ptr_glBindProgramPipeline #-}
ptr_glBindProgramPipeline :: FunPtr (GLuint -> IO ())
ptr_glBindProgramPipeline = unsafePerformIO $ getCommand "glBindProgramPipeline"

-- glBindProgramPipelineEXT ----------------------------------------------------

glBindProgramPipelineEXT
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> m ()
glBindProgramPipelineEXT v1 = liftIO $ dyn2 ptr_glBindProgramPipelineEXT v1

{-# NOINLINE ptr_glBindProgramPipelineEXT #-}
ptr_glBindProgramPipelineEXT :: FunPtr (GLuint -> IO ())
ptr_glBindProgramPipelineEXT = unsafePerformIO $ getCommand "glBindProgramPipelineEXT"

-- glBindRenderbuffer ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindRenderbuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindRenderbuffer.xhtml OpenGL 4.x>.
glBindRenderbuffer
  :: MonadIO m
  => GLenum -- ^ @target@ of type @RenderbufferTarget@.
  -> GLuint -- ^ @renderbuffer@.
  -> m ()
glBindRenderbuffer v1 v2 = liftIO $ dyn16 ptr_glBindRenderbuffer v1 v2

{-# NOINLINE ptr_glBindRenderbuffer #-}
ptr_glBindRenderbuffer :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindRenderbuffer = unsafePerformIO $ getCommand "glBindRenderbuffer"

-- glBindRenderbufferEXT -------------------------------------------------------

glBindRenderbufferEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @RenderbufferTarget@.
  -> GLuint -- ^ @renderbuffer@.
  -> m ()
glBindRenderbufferEXT v1 v2 = liftIO $ dyn16 ptr_glBindRenderbufferEXT v1 v2

{-# NOINLINE ptr_glBindRenderbufferEXT #-}
ptr_glBindRenderbufferEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindRenderbufferEXT = unsafePerformIO $ getCommand "glBindRenderbufferEXT"

-- glBindRenderbufferOES -------------------------------------------------------

glBindRenderbufferOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @renderbuffer@.
  -> m ()
glBindRenderbufferOES v1 v2 = liftIO $ dyn16 ptr_glBindRenderbufferOES v1 v2

{-# NOINLINE ptr_glBindRenderbufferOES #-}
ptr_glBindRenderbufferOES :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindRenderbufferOES = unsafePerformIO $ getCommand "glBindRenderbufferOES"

-- glBindSampler ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindSampler.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindSampler.xhtml OpenGL 4.x>.
glBindSampler
  :: MonadIO m
  => GLuint -- ^ @unit@.
  -> GLuint -- ^ @sampler@.
  -> m ()
glBindSampler v1 v2 = liftIO $ dyn3 ptr_glBindSampler v1 v2

{-# NOINLINE ptr_glBindSampler #-}
ptr_glBindSampler :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glBindSampler = unsafePerformIO $ getCommand "glBindSampler"

-- glBindSamplers --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindSamplers.xhtml OpenGL 4.x>.
glBindSamplers
  :: MonadIO m
  => GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @samplers@ pointing to @count@ elements of type @GLuint@.
  -> m ()
glBindSamplers v1 v2 v3 = liftIO $ dyn27 ptr_glBindSamplers v1 v2 v3

{-# NOINLINE ptr_glBindSamplers #-}
ptr_glBindSamplers :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glBindSamplers = unsafePerformIO $ getCommand "glBindSamplers"

-- glBindTexGenParameterEXT ----------------------------------------------------

glBindTexGenParameterEXT
  :: MonadIO m
  => GLenum -- ^ @unit@ of type @TextureUnit@.
  -> GLenum -- ^ @coord@ of type [TextureCoordName](Graphics-GL-Groups.html#TextureCoordName).
  -> GLenum -- ^ @value@ of type [TextureGenParameter](Graphics-GL-Groups.html#TextureGenParameter).
  -> m GLuint
glBindTexGenParameterEXT v1 v2 v3 = liftIO $ dyn31 ptr_glBindTexGenParameterEXT v1 v2 v3

{-# NOINLINE ptr_glBindTexGenParameterEXT #-}
ptr_glBindTexGenParameterEXT :: FunPtr (GLenum -> GLenum -> GLenum -> IO GLuint)
ptr_glBindTexGenParameterEXT = unsafePerformIO $ getCommand "glBindTexGenParameterEXT"

-- glBindTexture ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBindTexture.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBindTexture.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindTexture.xhtml OpenGL 4.x>.
glBindTexture
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> m ()
glBindTexture v1 v2 = liftIO $ dyn16 ptr_glBindTexture v1 v2

{-# NOINLINE ptr_glBindTexture #-}
ptr_glBindTexture :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindTexture = unsafePerformIO $ getCommand "glBindTexture"

-- glBindTextureEXT ------------------------------------------------------------

-- | This command is an alias for 'glBindTexture'.
glBindTextureEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> m ()
glBindTextureEXT v1 v2 = liftIO $ dyn16 ptr_glBindTextureEXT v1 v2

{-# NOINLINE ptr_glBindTextureEXT #-}
ptr_glBindTextureEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindTextureEXT = unsafePerformIO $ getCommand "glBindTextureEXT"

-- glBindTextureUnit -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindTextureUnit.xhtml OpenGL 4.x>.
glBindTextureUnit
  :: MonadIO m
  => GLuint -- ^ @unit@.
  -> GLuint -- ^ @texture@.
  -> m ()
glBindTextureUnit v1 v2 = liftIO $ dyn3 ptr_glBindTextureUnit v1 v2

{-# NOINLINE ptr_glBindTextureUnit #-}
ptr_glBindTextureUnit :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glBindTextureUnit = unsafePerformIO $ getCommand "glBindTextureUnit"

-- glBindTextureUnitParameterEXT -----------------------------------------------

glBindTextureUnitParameterEXT
  :: MonadIO m
  => GLenum -- ^ @unit@ of type @TextureUnit@.
  -> GLenum -- ^ @value@ of type @VertexShaderTextureUnitParameter@.
  -> m GLuint
glBindTextureUnitParameterEXT v1 v2 = liftIO $ dyn28 ptr_glBindTextureUnitParameterEXT v1 v2

{-# NOINLINE ptr_glBindTextureUnitParameterEXT #-}
ptr_glBindTextureUnitParameterEXT :: FunPtr (GLenum -> GLenum -> IO GLuint)
ptr_glBindTextureUnitParameterEXT = unsafePerformIO $ getCommand "glBindTextureUnitParameterEXT"

-- glBindTextures --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindTextures.xhtml OpenGL 4.x>.
glBindTextures
  :: MonadIO m
  => GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @textures@ pointing to @count@ elements of type @GLuint@.
  -> m ()
glBindTextures v1 v2 v3 = liftIO $ dyn27 ptr_glBindTextures v1 v2 v3

{-# NOINLINE ptr_glBindTextures #-}
ptr_glBindTextures :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glBindTextures = unsafePerformIO $ getCommand "glBindTextures"

-- glBindTransformFeedback -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindTransformFeedback.xhtml OpenGL 4.x>.
glBindTransformFeedback
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @id@.
  -> m ()
glBindTransformFeedback v1 v2 = liftIO $ dyn16 ptr_glBindTransformFeedback v1 v2

{-# NOINLINE ptr_glBindTransformFeedback #-}
ptr_glBindTransformFeedback :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindTransformFeedback = unsafePerformIO $ getCommand "glBindTransformFeedback"

-- glBindTransformFeedbackNV ---------------------------------------------------

glBindTransformFeedbackNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLuint -- ^ @id@.
  -> m ()
glBindTransformFeedbackNV v1 v2 = liftIO $ dyn16 ptr_glBindTransformFeedbackNV v1 v2

{-# NOINLINE ptr_glBindTransformFeedbackNV #-}
ptr_glBindTransformFeedbackNV :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glBindTransformFeedbackNV = unsafePerformIO $ getCommand "glBindTransformFeedbackNV"

-- glBindVertexArray -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBindVertexArray.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBindVertexArray.xhtml OpenGL 4.x>.
glBindVertexArray
  :: MonadIO m
  => GLuint -- ^ @array@.
  -> m ()
glBindVertexArray v1 = liftIO $ dyn2 ptr_glBindVertexArray v1

{-# NOINLINE ptr_glBindVertexArray #-}
ptr_glBindVertexArray :: FunPtr (GLuint -> IO ())
ptr_glBindVertexArray = unsafePerformIO $ getCommand "glBindVertexArray"

-- glBindVertexArrayAPPLE ------------------------------------------------------

glBindVertexArrayAPPLE
  :: MonadIO m
  => GLuint -- ^ @array@.
  -> m ()
glBindVertexArrayAPPLE v1 = liftIO $ dyn2 ptr_glBindVertexArrayAPPLE v1

{-# NOINLINE ptr_glBindVertexArrayAPPLE #-}
ptr_glBindVertexArrayAPPLE :: FunPtr (GLuint -> IO ())
ptr_glBindVertexArrayAPPLE = unsafePerformIO $ getCommand "glBindVertexArrayAPPLE"

-- glBindVertexArrayOES --------------------------------------------------------

-- | This command is an alias for 'glBindVertexArray'.
glBindVertexArrayOES
  :: MonadIO m
  => GLuint -- ^ @array@.
  -> m ()
glBindVertexArrayOES v1 = liftIO $ dyn2 ptr_glBindVertexArrayOES v1

{-# NOINLINE ptr_glBindVertexArrayOES #-}
ptr_glBindVertexArrayOES :: FunPtr (GLuint -> IO ())
ptr_glBindVertexArrayOES = unsafePerformIO $ getCommand "glBindVertexArrayOES"

-- glBindVertexBuffer ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindVertexBuffer.xhtml OpenGL 4.x>.
glBindVertexBuffer
  :: MonadIO m
  => GLuint -- ^ @bindingindex@.
  -> GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizei -- ^ @stride@.
  -> m ()
glBindVertexBuffer v1 v2 v3 v4 = liftIO $ dyn32 ptr_glBindVertexBuffer v1 v2 v3 v4

{-# NOINLINE ptr_glBindVertexBuffer #-}
ptr_glBindVertexBuffer :: FunPtr (GLuint -> GLuint -> GLintptr -> GLsizei -> IO ())
ptr_glBindVertexBuffer = unsafePerformIO $ getCommand "glBindVertexBuffer"

-- glBindVertexBuffers ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBindVertexBuffers.xhtml OpenGL 4.x>.
glBindVertexBuffers
  :: MonadIO m
  => GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @buffers@ pointing to @count@ elements of type @GLuint@.
  -> Ptr GLintptr -- ^ @offsets@ pointing to @count@ elements of type @GLintptr@.
  -> Ptr GLsizei -- ^ @strides@ pointing to @count@ elements of type @GLsizei@.
  -> m ()
glBindVertexBuffers v1 v2 v3 v4 v5 = liftIO $ dyn33 ptr_glBindVertexBuffers v1 v2 v3 v4 v5

{-# NOINLINE ptr_glBindVertexBuffers #-}
ptr_glBindVertexBuffers :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> Ptr GLintptr -> Ptr GLsizei -> IO ())
ptr_glBindVertexBuffers = unsafePerformIO $ getCommand "glBindVertexBuffers"

-- glBindVertexShaderEXT -------------------------------------------------------

glBindVertexShaderEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glBindVertexShaderEXT v1 = liftIO $ dyn2 ptr_glBindVertexShaderEXT v1

{-# NOINLINE ptr_glBindVertexShaderEXT #-}
ptr_glBindVertexShaderEXT :: FunPtr (GLuint -> IO ())
ptr_glBindVertexShaderEXT = unsafePerformIO $ getCommand "glBindVertexShaderEXT"

-- glBindVideoCaptureStreamBufferNV --------------------------------------------

glBindVideoCaptureStreamBufferNV
  :: MonadIO m
  => GLuint -- ^ @video_capture_slot@.
  -> GLuint -- ^ @stream@.
  -> GLenum -- ^ @frame_region@.
  -> GLintptrARB -- ^ @offset@ of type @BufferOffsetARB@.
  -> m ()
glBindVideoCaptureStreamBufferNV v1 v2 v3 v4 = liftIO $ dyn34 ptr_glBindVideoCaptureStreamBufferNV v1 v2 v3 v4

{-# NOINLINE ptr_glBindVideoCaptureStreamBufferNV #-}
ptr_glBindVideoCaptureStreamBufferNV :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptrARB -> IO ())
ptr_glBindVideoCaptureStreamBufferNV = unsafePerformIO $ getCommand "glBindVideoCaptureStreamBufferNV"

-- glBindVideoCaptureStreamTextureNV -------------------------------------------

glBindVideoCaptureStreamTextureNV
  :: MonadIO m
  => GLuint -- ^ @video_capture_slot@.
  -> GLuint -- ^ @stream@.
  -> GLenum -- ^ @frame_region@.
  -> GLenum -- ^ @target@.
  -> GLuint -- ^ @texture@.
  -> m ()
glBindVideoCaptureStreamTextureNV v1 v2 v3 v4 v5 = liftIO $ dyn35 ptr_glBindVideoCaptureStreamTextureNV v1 v2 v3 v4 v5

{-# NOINLINE ptr_glBindVideoCaptureStreamTextureNV #-}
ptr_glBindVideoCaptureStreamTextureNV :: FunPtr (GLuint -> GLuint -> GLenum -> GLenum -> GLuint -> IO ())
ptr_glBindVideoCaptureStreamTextureNV = unsafePerformIO $ getCommand "glBindVideoCaptureStreamTextureNV"

-- glBinormal3bEXT -------------------------------------------------------------

-- | The vector equivalent of this command is 'glBinormal3bvEXT'.
glBinormal3bEXT
  :: MonadIO m
  => GLbyte -- ^ @bx@.
  -> GLbyte -- ^ @by@.
  -> GLbyte -- ^ @bz@.
  -> m ()
glBinormal3bEXT v1 v2 v3 = liftIO $ dyn36 ptr_glBinormal3bEXT v1 v2 v3

{-# NOINLINE ptr_glBinormal3bEXT #-}
ptr_glBinormal3bEXT :: FunPtr (GLbyte -> GLbyte -> GLbyte -> IO ())
ptr_glBinormal3bEXT = unsafePerformIO $ getCommand "glBinormal3bEXT"

-- glBinormal3bvEXT ------------------------------------------------------------

glBinormal3bvEXT
  :: MonadIO m
  => Ptr GLbyte -- ^ @v@ pointing to @3@ elements of type @GLbyte@.
  -> m ()
glBinormal3bvEXT v1 = liftIO $ dyn37 ptr_glBinormal3bvEXT v1

{-# NOINLINE ptr_glBinormal3bvEXT #-}
ptr_glBinormal3bvEXT :: FunPtr (Ptr GLbyte -> IO ())
ptr_glBinormal3bvEXT = unsafePerformIO $ getCommand "glBinormal3bvEXT"

-- glBinormal3dEXT -------------------------------------------------------------

-- | The vector equivalent of this command is 'glBinormal3dvEXT'.
glBinormal3dEXT
  :: MonadIO m
  => GLdouble -- ^ @bx@ of type @CoordD@.
  -> GLdouble -- ^ @by@ of type @CoordD@.
  -> GLdouble -- ^ @bz@ of type @CoordD@.
  -> m ()
glBinormal3dEXT v1 v2 v3 = liftIO $ dyn38 ptr_glBinormal3dEXT v1 v2 v3

{-# NOINLINE ptr_glBinormal3dEXT #-}
ptr_glBinormal3dEXT :: FunPtr (GLdouble -> GLdouble -> GLdouble -> IO ())
ptr_glBinormal3dEXT = unsafePerformIO $ getCommand "glBinormal3dEXT"

-- glBinormal3dvEXT ------------------------------------------------------------

glBinormal3dvEXT
  :: MonadIO m
  => Ptr GLdouble -- ^ @v@ pointing to @3@ elements of type @CoordD@.
  -> m ()
glBinormal3dvEXT v1 = liftIO $ dyn39 ptr_glBinormal3dvEXT v1

{-# NOINLINE ptr_glBinormal3dvEXT #-}
ptr_glBinormal3dvEXT :: FunPtr (Ptr GLdouble -> IO ())
ptr_glBinormal3dvEXT = unsafePerformIO $ getCommand "glBinormal3dvEXT"

-- glBinormal3fEXT -------------------------------------------------------------

-- | The vector equivalent of this command is 'glBinormal3fvEXT'.
glBinormal3fEXT
  :: MonadIO m
  => GLfloat -- ^ @bx@ of type @CoordF@.
  -> GLfloat -- ^ @by@ of type @CoordF@.
  -> GLfloat -- ^ @bz@ of type @CoordF@.
  -> m ()
glBinormal3fEXT v1 v2 v3 = liftIO $ dyn40 ptr_glBinormal3fEXT v1 v2 v3

{-# NOINLINE ptr_glBinormal3fEXT #-}
ptr_glBinormal3fEXT :: FunPtr (GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glBinormal3fEXT = unsafePerformIO $ getCommand "glBinormal3fEXT"

-- glBinormal3fvEXT ------------------------------------------------------------

glBinormal3fvEXT
  :: MonadIO m
  => Ptr GLfloat -- ^ @v@ pointing to @3@ elements of type @CoordF@.
  -> m ()
glBinormal3fvEXT v1 = liftIO $ dyn41 ptr_glBinormal3fvEXT v1

{-# NOINLINE ptr_glBinormal3fvEXT #-}
ptr_glBinormal3fvEXT :: FunPtr (Ptr GLfloat -> IO ())
ptr_glBinormal3fvEXT = unsafePerformIO $ getCommand "glBinormal3fvEXT"

-- glBinormal3iEXT -------------------------------------------------------------

-- | The vector equivalent of this command is 'glBinormal3ivEXT'.
glBinormal3iEXT
  :: MonadIO m
  => GLint -- ^ @bx@.
  -> GLint -- ^ @by@.
  -> GLint -- ^ @bz@.
  -> m ()
glBinormal3iEXT v1 v2 v3 = liftIO $ dyn42 ptr_glBinormal3iEXT v1 v2 v3

{-# NOINLINE ptr_glBinormal3iEXT #-}
ptr_glBinormal3iEXT :: FunPtr (GLint -> GLint -> GLint -> IO ())
ptr_glBinormal3iEXT = unsafePerformIO $ getCommand "glBinormal3iEXT"

-- glBinormal3ivEXT ------------------------------------------------------------

glBinormal3ivEXT
  :: MonadIO m
  => Ptr GLint -- ^ @v@ pointing to @3@ elements of type @GLint@.
  -> m ()
glBinormal3ivEXT v1 = liftIO $ dyn43 ptr_glBinormal3ivEXT v1

{-# NOINLINE ptr_glBinormal3ivEXT #-}
ptr_glBinormal3ivEXT :: FunPtr (Ptr GLint -> IO ())
ptr_glBinormal3ivEXT = unsafePerformIO $ getCommand "glBinormal3ivEXT"

-- glBinormal3sEXT -------------------------------------------------------------

-- | The vector equivalent of this command is 'glBinormal3svEXT'.
glBinormal3sEXT
  :: MonadIO m
  => GLshort -- ^ @bx@.
  -> GLshort -- ^ @by@.
  -> GLshort -- ^ @bz@.
  -> m ()
glBinormal3sEXT v1 v2 v3 = liftIO $ dyn44 ptr_glBinormal3sEXT v1 v2 v3

{-# NOINLINE ptr_glBinormal3sEXT #-}
ptr_glBinormal3sEXT :: FunPtr (GLshort -> GLshort -> GLshort -> IO ())
ptr_glBinormal3sEXT = unsafePerformIO $ getCommand "glBinormal3sEXT"

-- glBinormal3svEXT ------------------------------------------------------------

glBinormal3svEXT
  :: MonadIO m
  => Ptr GLshort -- ^ @v@ pointing to @3@ elements of type @GLshort@.
  -> m ()
glBinormal3svEXT v1 = liftIO $ dyn45 ptr_glBinormal3svEXT v1

{-# NOINLINE ptr_glBinormal3svEXT #-}
ptr_glBinormal3svEXT :: FunPtr (Ptr GLshort -> IO ())
ptr_glBinormal3svEXT = unsafePerformIO $ getCommand "glBinormal3svEXT"

-- glBinormalPointerEXT --------------------------------------------------------

glBinormalPointerEXT
  :: MonadIO m
  => GLenum -- ^ @type@ of type @BinormalPointerTypeEXT@.
  -> GLsizei -- ^ @stride@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(type,stride)@ elements of type @a@.
  -> m ()
glBinormalPointerEXT v1 v2 v3 = liftIO $ dyn46 ptr_glBinormalPointerEXT v1 v2 v3

{-# NOINLINE ptr_glBinormalPointerEXT #-}
ptr_glBinormalPointerEXT :: FunPtr (GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glBinormalPointerEXT = unsafePerformIO $ getCommand "glBinormalPointerEXT"

-- glBitmap --------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glBitmap.xml OpenGL 2.x>.
glBitmap
  :: MonadIO m
  => GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLfloat -- ^ @xorig@ of type @CoordF@.
  -> GLfloat -- ^ @yorig@ of type @CoordF@.
  -> GLfloat -- ^ @xmove@ of type @CoordF@.
  -> GLfloat -- ^ @ymove@ of type @CoordF@.
  -> Ptr GLubyte -- ^ @bitmap@ pointing to @COMPSIZE(width,height)@ elements of type @GLubyte@.
  -> m ()
glBitmap v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn47 ptr_glBitmap v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glBitmap #-}
ptr_glBitmap :: FunPtr (GLsizei -> GLsizei -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> Ptr GLubyte -> IO ())
ptr_glBitmap = unsafePerformIO $ getCommand "glBitmap"

-- glBitmapxOES ----------------------------------------------------------------

glBitmapxOES
  :: MonadIO m
  => GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLfixed -- ^ @xorig@.
  -> GLfixed -- ^ @yorig@.
  -> GLfixed -- ^ @xmove@.
  -> GLfixed -- ^ @ymove@.
  -> Ptr GLubyte -- ^ @bitmap@ pointing to @COMPSIZE(width,height)@ elements of type @GLubyte@.
  -> m ()
glBitmapxOES v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn48 ptr_glBitmapxOES v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glBitmapxOES #-}
ptr_glBitmapxOES :: FunPtr (GLsizei -> GLsizei -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> Ptr GLubyte -> IO ())
ptr_glBitmapxOES = unsafePerformIO $ getCommand "glBitmapxOES"

-- glBlendBarrier --------------------------------------------------------------

glBlendBarrier
  :: MonadIO m
  => m ()
glBlendBarrier = liftIO $ dyn10 ptr_glBlendBarrier

{-# NOINLINE ptr_glBlendBarrier #-}
ptr_glBlendBarrier :: FunPtr (IO ())
ptr_glBlendBarrier = unsafePerformIO $ getCommand "glBlendBarrier"

-- glBlendBarrierKHR -----------------------------------------------------------

-- | This command is an alias for 'glBlendBarrier'.
glBlendBarrierKHR
  :: MonadIO m
  => m ()
glBlendBarrierKHR = liftIO $ dyn10 ptr_glBlendBarrierKHR

{-# NOINLINE ptr_glBlendBarrierKHR #-}
ptr_glBlendBarrierKHR :: FunPtr (IO ())
ptr_glBlendBarrierKHR = unsafePerformIO $ getCommand "glBlendBarrierKHR"

-- glBlendBarrierNV ------------------------------------------------------------

-- | This command is an alias for 'glBlendBarrier'.
glBlendBarrierNV
  :: MonadIO m
  => m ()
glBlendBarrierNV = liftIO $ dyn10 ptr_glBlendBarrierNV

{-# NOINLINE ptr_glBlendBarrierNV #-}
ptr_glBlendBarrierNV :: FunPtr (IO ())
ptr_glBlendBarrierNV = unsafePerformIO $ getCommand "glBlendBarrierNV"

-- glBlendColor ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBlendColor.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBlendColor.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBlendColor.xhtml OpenGL 4.x>.
glBlendColor
  :: MonadIO m
  => GLfloat -- ^ @red@ of type @ColorF@.
  -> GLfloat -- ^ @green@ of type @ColorF@.
  -> GLfloat -- ^ @blue@ of type @ColorF@.
  -> GLfloat -- ^ @alpha@ of type @ColorF@.
  -> m ()
glBlendColor v1 v2 v3 v4 = liftIO $ dyn49 ptr_glBlendColor v1 v2 v3 v4

{-# NOINLINE ptr_glBlendColor #-}
ptr_glBlendColor :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glBlendColor = unsafePerformIO $ getCommand "glBlendColor"

-- glBlendColorEXT -------------------------------------------------------------

-- | This command is an alias for 'glBlendColor'.
glBlendColorEXT
  :: MonadIO m
  => GLfloat -- ^ @red@ of type @ColorF@.
  -> GLfloat -- ^ @green@ of type @ColorF@.
  -> GLfloat -- ^ @blue@ of type @ColorF@.
  -> GLfloat -- ^ @alpha@ of type @ColorF@.
  -> m ()
glBlendColorEXT v1 v2 v3 v4 = liftIO $ dyn49 ptr_glBlendColorEXT v1 v2 v3 v4

{-# NOINLINE ptr_glBlendColorEXT #-}
ptr_glBlendColorEXT :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glBlendColorEXT = unsafePerformIO $ getCommand "glBlendColorEXT"

-- glBlendColorxOES ------------------------------------------------------------

glBlendColorxOES
  :: MonadIO m
  => GLfixed -- ^ @red@ of type @ClampedFixed@.
  -> GLfixed -- ^ @green@ of type @ClampedFixed@.
  -> GLfixed -- ^ @blue@ of type @ClampedFixed@.
  -> GLfixed -- ^ @alpha@ of type @ClampedFixed@.
  -> m ()
glBlendColorxOES v1 v2 v3 v4 = liftIO $ dyn50 ptr_glBlendColorxOES v1 v2 v3 v4

{-# NOINLINE ptr_glBlendColorxOES #-}
ptr_glBlendColorxOES :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glBlendColorxOES = unsafePerformIO $ getCommand "glBlendColorxOES"

-- glBlendEquation -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBlendEquation.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBlendEquation.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBlendEquation.xhtml OpenGL 4.x>.
glBlendEquation
  :: MonadIO m
  => GLenum -- ^ @mode@ of type @BlendEquationMode@.
  -> m ()
glBlendEquation v1 = liftIO $ dyn4 ptr_glBlendEquation v1

{-# NOINLINE ptr_glBlendEquation #-}
ptr_glBlendEquation :: FunPtr (GLenum -> IO ())
ptr_glBlendEquation = unsafePerformIO $ getCommand "glBlendEquation"

-- glBlendEquationEXT ----------------------------------------------------------

-- | This command is an alias for 'glBlendEquation'.
glBlendEquationEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [BlendEquationModeEXT](Graphics-GL-Groups.html#BlendEquationModeEXT).
  -> m ()
glBlendEquationEXT v1 = liftIO $ dyn4 ptr_glBlendEquationEXT v1

{-# NOINLINE ptr_glBlendEquationEXT #-}
ptr_glBlendEquationEXT :: FunPtr (GLenum -> IO ())
ptr_glBlendEquationEXT = unsafePerformIO $ getCommand "glBlendEquationEXT"

-- glBlendEquationIndexedAMD ---------------------------------------------------

-- | This command is an alias for 'glBlendEquationi'.
glBlendEquationIndexedAMD
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @mode@.
  -> m ()
glBlendEquationIndexedAMD v1 v2 = liftIO $ dyn15 ptr_glBlendEquationIndexedAMD v1 v2

{-# NOINLINE ptr_glBlendEquationIndexedAMD #-}
ptr_glBlendEquationIndexedAMD :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glBlendEquationIndexedAMD = unsafePerformIO $ getCommand "glBlendEquationIndexedAMD"

-- glBlendEquationOES ----------------------------------------------------------

glBlendEquationOES
  :: MonadIO m
  => GLenum -- ^ @mode@.
  -> m ()
glBlendEquationOES v1 = liftIO $ dyn4 ptr_glBlendEquationOES v1

{-# NOINLINE ptr_glBlendEquationOES #-}
ptr_glBlendEquationOES :: FunPtr (GLenum -> IO ())
ptr_glBlendEquationOES = unsafePerformIO $ getCommand "glBlendEquationOES"

-- glBlendEquationSeparate -----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBlendEquationSeparate.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBlendEquationSeparate.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBlendEquationSeparate.xhtml OpenGL 4.x>.
glBlendEquationSeparate
  :: MonadIO m
  => GLenum -- ^ @modeRGB@ of type [BlendEquationModeEXT](Graphics-GL-Groups.html#BlendEquationModeEXT).
  -> GLenum -- ^ @modeAlpha@ of type [BlendEquationModeEXT](Graphics-GL-Groups.html#BlendEquationModeEXT).
  -> m ()
glBlendEquationSeparate v1 v2 = liftIO $ dyn51 ptr_glBlendEquationSeparate v1 v2

{-# NOINLINE ptr_glBlendEquationSeparate #-}
ptr_glBlendEquationSeparate :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparate = unsafePerformIO $ getCommand "glBlendEquationSeparate"

-- glBlendEquationSeparateEXT --------------------------------------------------

-- | This command is an alias for 'glBlendEquationSeparate'.
glBlendEquationSeparateEXT
  :: MonadIO m
  => GLenum -- ^ @modeRGB@ of type [BlendEquationModeEXT](Graphics-GL-Groups.html#BlendEquationModeEXT).
  -> GLenum -- ^ @modeAlpha@ of type [BlendEquationModeEXT](Graphics-GL-Groups.html#BlendEquationModeEXT).
  -> m ()
glBlendEquationSeparateEXT v1 v2 = liftIO $ dyn51 ptr_glBlendEquationSeparateEXT v1 v2

{-# NOINLINE ptr_glBlendEquationSeparateEXT #-}
ptr_glBlendEquationSeparateEXT :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparateEXT = unsafePerformIO $ getCommand "glBlendEquationSeparateEXT"

-- glBlendEquationSeparateIndexedAMD -------------------------------------------

-- | This command is an alias for 'glBlendEquationSeparatei'.
glBlendEquationSeparateIndexedAMD
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @modeRGB@.
  -> GLenum -- ^ @modeAlpha@.
  -> m ()
glBlendEquationSeparateIndexedAMD v1 v2 v3 = liftIO $ dyn52 ptr_glBlendEquationSeparateIndexedAMD v1 v2 v3

{-# NOINLINE ptr_glBlendEquationSeparateIndexedAMD #-}
ptr_glBlendEquationSeparateIndexedAMD :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparateIndexedAMD = unsafePerformIO $ getCommand "glBlendEquationSeparateIndexedAMD"

-- glBlendEquationSeparateOES --------------------------------------------------

glBlendEquationSeparateOES
  :: MonadIO m
  => GLenum -- ^ @modeRGB@.
  -> GLenum -- ^ @modeAlpha@.
  -> m ()
glBlendEquationSeparateOES v1 v2 = liftIO $ dyn51 ptr_glBlendEquationSeparateOES v1 v2

{-# NOINLINE ptr_glBlendEquationSeparateOES #-}
ptr_glBlendEquationSeparateOES :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparateOES = unsafePerformIO $ getCommand "glBlendEquationSeparateOES"

-- glBlendEquationSeparatei ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBlendEquationSeparate.xhtml OpenGL 4.x>.
glBlendEquationSeparatei
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @modeRGB@.
  -> GLenum -- ^ @modeAlpha@.
  -> m ()
glBlendEquationSeparatei v1 v2 v3 = liftIO $ dyn52 ptr_glBlendEquationSeparatei v1 v2 v3

{-# NOINLINE ptr_glBlendEquationSeparatei #-}
ptr_glBlendEquationSeparatei :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparatei = unsafePerformIO $ getCommand "glBlendEquationSeparatei"

-- glBlendEquationSeparateiARB -------------------------------------------------

-- | This command is an alias for 'glBlendEquationSeparatei'.
glBlendEquationSeparateiARB
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @modeRGB@.
  -> GLenum -- ^ @modeAlpha@.
  -> m ()
glBlendEquationSeparateiARB v1 v2 v3 = liftIO $ dyn52 ptr_glBlendEquationSeparateiARB v1 v2 v3

{-# NOINLINE ptr_glBlendEquationSeparateiARB #-}
ptr_glBlendEquationSeparateiARB :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparateiARB = unsafePerformIO $ getCommand "glBlendEquationSeparateiARB"

-- glBlendEquationSeparateiEXT -------------------------------------------------

-- | This command is an alias for 'glBlendEquationSeparatei'.
glBlendEquationSeparateiEXT
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @modeRGB@.
  -> GLenum -- ^ @modeAlpha@.
  -> m ()
glBlendEquationSeparateiEXT v1 v2 v3 = liftIO $ dyn52 ptr_glBlendEquationSeparateiEXT v1 v2 v3

{-# NOINLINE ptr_glBlendEquationSeparateiEXT #-}
ptr_glBlendEquationSeparateiEXT :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparateiEXT = unsafePerformIO $ getCommand "glBlendEquationSeparateiEXT"

-- glBlendEquationSeparateiOES -------------------------------------------------

-- | This command is an alias for 'glBlendEquationSeparatei'.
glBlendEquationSeparateiOES
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @modeRGB@.
  -> GLenum -- ^ @modeAlpha@.
  -> m ()
glBlendEquationSeparateiOES v1 v2 v3 = liftIO $ dyn52 ptr_glBlendEquationSeparateiOES v1 v2 v3

{-# NOINLINE ptr_glBlendEquationSeparateiOES #-}
ptr_glBlendEquationSeparateiOES :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendEquationSeparateiOES = unsafePerformIO $ getCommand "glBlendEquationSeparateiOES"

-- glBlendEquationi ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBlendEquation.xhtml OpenGL 4.x>.
glBlendEquationi
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @mode@.
  -> m ()
glBlendEquationi v1 v2 = liftIO $ dyn15 ptr_glBlendEquationi v1 v2

{-# NOINLINE ptr_glBlendEquationi #-}
ptr_glBlendEquationi :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glBlendEquationi = unsafePerformIO $ getCommand "glBlendEquationi"

-- glBlendEquationiARB ---------------------------------------------------------

-- | This command is an alias for 'glBlendEquationi'.
glBlendEquationiARB
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @mode@.
  -> m ()
glBlendEquationiARB v1 v2 = liftIO $ dyn15 ptr_glBlendEquationiARB v1 v2

{-# NOINLINE ptr_glBlendEquationiARB #-}
ptr_glBlendEquationiARB :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glBlendEquationiARB = unsafePerformIO $ getCommand "glBlendEquationiARB"

-- glBlendEquationiEXT ---------------------------------------------------------

-- | This command is an alias for 'glBlendEquationi'.
glBlendEquationiEXT
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @mode@.
  -> m ()
glBlendEquationiEXT v1 v2 = liftIO $ dyn15 ptr_glBlendEquationiEXT v1 v2

{-# NOINLINE ptr_glBlendEquationiEXT #-}
ptr_glBlendEquationiEXT :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glBlendEquationiEXT = unsafePerformIO $ getCommand "glBlendEquationiEXT"

-- glBlendEquationiOES ---------------------------------------------------------

-- | This command is an alias for 'glBlendEquationi'.
glBlendEquationiOES
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @mode@.
  -> m ()
glBlendEquationiOES v1 v2 = liftIO $ dyn15 ptr_glBlendEquationiOES v1 v2

{-# NOINLINE ptr_glBlendEquationiOES #-}
ptr_glBlendEquationiOES :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glBlendEquationiOES = unsafePerformIO $ getCommand "glBlendEquationiOES"

-- glBlendFunc -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBlendFunc.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBlendFunc.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBlendFunc.xhtml OpenGL 4.x>.
glBlendFunc
  :: MonadIO m
  => GLenum -- ^ @sfactor@ of type [BlendingFactorSrc](Graphics-GL-Groups.html#BlendingFactorSrc).
  -> GLenum -- ^ @dfactor@ of type [BlendingFactorDest](Graphics-GL-Groups.html#BlendingFactorDest).
  -> m ()
glBlendFunc v1 v2 = liftIO $ dyn51 ptr_glBlendFunc v1 v2

{-# NOINLINE ptr_glBlendFunc #-}
ptr_glBlendFunc :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glBlendFunc = unsafePerformIO $ getCommand "glBlendFunc"

-- glBlendFuncIndexedAMD -------------------------------------------------------

-- | This command is an alias for 'glBlendFunci'.
glBlendFuncIndexedAMD
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @src@.
  -> GLenum -- ^ @dst@.
  -> m ()
glBlendFuncIndexedAMD v1 v2 v3 = liftIO $ dyn52 ptr_glBlendFuncIndexedAMD v1 v2 v3

{-# NOINLINE ptr_glBlendFuncIndexedAMD #-}
ptr_glBlendFuncIndexedAMD :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncIndexedAMD = unsafePerformIO $ getCommand "glBlendFuncIndexedAMD"

-- glBlendFuncSeparate ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBlendFuncSeparate.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBlendFuncSeparate.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBlendFuncSeparate.xhtml OpenGL 4.x>.
glBlendFuncSeparate
  :: MonadIO m
  => GLenum -- ^ @sfactorRGB@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @dfactorRGB@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @sfactorAlpha@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @dfactorAlpha@ of type @BlendFuncSeparateParameterEXT@.
  -> m ()
glBlendFuncSeparate v1 v2 v3 v4 = liftIO $ dyn53 ptr_glBlendFuncSeparate v1 v2 v3 v4

{-# NOINLINE ptr_glBlendFuncSeparate #-}
ptr_glBlendFuncSeparate :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparate = unsafePerformIO $ getCommand "glBlendFuncSeparate"

-- glBlendFuncSeparateEXT ------------------------------------------------------

-- | This command is an alias for 'glBlendFuncSeparate'.
glBlendFuncSeparateEXT
  :: MonadIO m
  => GLenum -- ^ @sfactorRGB@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @dfactorRGB@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @sfactorAlpha@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @dfactorAlpha@ of type @BlendFuncSeparateParameterEXT@.
  -> m ()
glBlendFuncSeparateEXT v1 v2 v3 v4 = liftIO $ dyn53 ptr_glBlendFuncSeparateEXT v1 v2 v3 v4

{-# NOINLINE ptr_glBlendFuncSeparateEXT #-}
ptr_glBlendFuncSeparateEXT :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparateEXT = unsafePerformIO $ getCommand "glBlendFuncSeparateEXT"

-- glBlendFuncSeparateINGR -----------------------------------------------------

-- | This command is an alias for 'glBlendFuncSeparate'.
glBlendFuncSeparateINGR
  :: MonadIO m
  => GLenum -- ^ @sfactorRGB@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @dfactorRGB@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @sfactorAlpha@ of type @BlendFuncSeparateParameterEXT@.
  -> GLenum -- ^ @dfactorAlpha@ of type @BlendFuncSeparateParameterEXT@.
  -> m ()
glBlendFuncSeparateINGR v1 v2 v3 v4 = liftIO $ dyn53 ptr_glBlendFuncSeparateINGR v1 v2 v3 v4

{-# NOINLINE ptr_glBlendFuncSeparateINGR #-}
ptr_glBlendFuncSeparateINGR :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparateINGR = unsafePerformIO $ getCommand "glBlendFuncSeparateINGR"

-- glBlendFuncSeparateIndexedAMD -----------------------------------------------

-- | This command is an alias for 'glBlendFuncSeparatei'.
glBlendFuncSeparateIndexedAMD
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @srcRGB@.
  -> GLenum -- ^ @dstRGB@.
  -> GLenum -- ^ @srcAlpha@.
  -> GLenum -- ^ @dstAlpha@.
  -> m ()
glBlendFuncSeparateIndexedAMD v1 v2 v3 v4 v5 = liftIO $ dyn54 ptr_glBlendFuncSeparateIndexedAMD v1 v2 v3 v4 v5

{-# NOINLINE ptr_glBlendFuncSeparateIndexedAMD #-}
ptr_glBlendFuncSeparateIndexedAMD :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparateIndexedAMD = unsafePerformIO $ getCommand "glBlendFuncSeparateIndexedAMD"

-- glBlendFuncSeparateOES ------------------------------------------------------

glBlendFuncSeparateOES
  :: MonadIO m
  => GLenum -- ^ @srcRGB@.
  -> GLenum -- ^ @dstRGB@.
  -> GLenum -- ^ @srcAlpha@.
  -> GLenum -- ^ @dstAlpha@.
  -> m ()
glBlendFuncSeparateOES v1 v2 v3 v4 = liftIO $ dyn53 ptr_glBlendFuncSeparateOES v1 v2 v3 v4

{-# NOINLINE ptr_glBlendFuncSeparateOES #-}
ptr_glBlendFuncSeparateOES :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparateOES = unsafePerformIO $ getCommand "glBlendFuncSeparateOES"

-- glBlendFuncSeparatei --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBlendFuncSeparate.xhtml OpenGL 4.x>.
glBlendFuncSeparatei
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @srcRGB@.
  -> GLenum -- ^ @dstRGB@.
  -> GLenum -- ^ @srcAlpha@.
  -> GLenum -- ^ @dstAlpha@.
  -> m ()
glBlendFuncSeparatei v1 v2 v3 v4 v5 = liftIO $ dyn54 ptr_glBlendFuncSeparatei v1 v2 v3 v4 v5

{-# NOINLINE ptr_glBlendFuncSeparatei #-}
ptr_glBlendFuncSeparatei :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparatei = unsafePerformIO $ getCommand "glBlendFuncSeparatei"

-- glBlendFuncSeparateiARB -----------------------------------------------------

-- | This command is an alias for 'glBlendFuncSeparatei'.
glBlendFuncSeparateiARB
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @srcRGB@.
  -> GLenum -- ^ @dstRGB@.
  -> GLenum -- ^ @srcAlpha@.
  -> GLenum -- ^ @dstAlpha@.
  -> m ()
glBlendFuncSeparateiARB v1 v2 v3 v4 v5 = liftIO $ dyn54 ptr_glBlendFuncSeparateiARB v1 v2 v3 v4 v5

{-# NOINLINE ptr_glBlendFuncSeparateiARB #-}
ptr_glBlendFuncSeparateiARB :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparateiARB = unsafePerformIO $ getCommand "glBlendFuncSeparateiARB"

-- glBlendFuncSeparateiEXT -----------------------------------------------------

-- | This command is an alias for 'glBlendFuncSeparatei'.
glBlendFuncSeparateiEXT
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @srcRGB@.
  -> GLenum -- ^ @dstRGB@.
  -> GLenum -- ^ @srcAlpha@.
  -> GLenum -- ^ @dstAlpha@.
  -> m ()
glBlendFuncSeparateiEXT v1 v2 v3 v4 v5 = liftIO $ dyn54 ptr_glBlendFuncSeparateiEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glBlendFuncSeparateiEXT #-}
ptr_glBlendFuncSeparateiEXT :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparateiEXT = unsafePerformIO $ getCommand "glBlendFuncSeparateiEXT"

-- glBlendFuncSeparateiOES -----------------------------------------------------

-- | This command is an alias for 'glBlendFuncSeparatei'.
glBlendFuncSeparateiOES
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @srcRGB@.
  -> GLenum -- ^ @dstRGB@.
  -> GLenum -- ^ @srcAlpha@.
  -> GLenum -- ^ @dstAlpha@.
  -> m ()
glBlendFuncSeparateiOES v1 v2 v3 v4 v5 = liftIO $ dyn54 ptr_glBlendFuncSeparateiOES v1 v2 v3 v4 v5

{-# NOINLINE ptr_glBlendFuncSeparateiOES #-}
ptr_glBlendFuncSeparateiOES :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glBlendFuncSeparateiOES = unsafePerformIO $ getCommand "glBlendFuncSeparateiOES"

-- glBlendFunci ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBlendFunc.xhtml OpenGL 4.x>.
glBlendFunci
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @src@.
  -> GLenum -- ^ @dst@.
  -> m ()
glBlendFunci v1 v2 v3 = liftIO $ dyn52 ptr_glBlendFunci v1 v2 v3

{-# NOINLINE ptr_glBlendFunci #-}
ptr_glBlendFunci :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendFunci = unsafePerformIO $ getCommand "glBlendFunci"

-- glBlendFunciARB -------------------------------------------------------------

-- | This command is an alias for 'glBlendFunci'.
glBlendFunciARB
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @src@.
  -> GLenum -- ^ @dst@.
  -> m ()
glBlendFunciARB v1 v2 v3 = liftIO $ dyn52 ptr_glBlendFunciARB v1 v2 v3

{-# NOINLINE ptr_glBlendFunciARB #-}
ptr_glBlendFunciARB :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendFunciARB = unsafePerformIO $ getCommand "glBlendFunciARB"

-- glBlendFunciEXT -------------------------------------------------------------

-- | This command is an alias for 'glBlendFunci'.
glBlendFunciEXT
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @src@.
  -> GLenum -- ^ @dst@.
  -> m ()
glBlendFunciEXT v1 v2 v3 = liftIO $ dyn52 ptr_glBlendFunciEXT v1 v2 v3

{-# NOINLINE ptr_glBlendFunciEXT #-}
ptr_glBlendFunciEXT :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendFunciEXT = unsafePerformIO $ getCommand "glBlendFunciEXT"

-- glBlendFunciOES -------------------------------------------------------------

-- | This command is an alias for 'glBlendFunci'.
glBlendFunciOES
  :: MonadIO m
  => GLuint -- ^ @buf@.
  -> GLenum -- ^ @src@.
  -> GLenum -- ^ @dst@.
  -> m ()
glBlendFunciOES v1 v2 v3 = liftIO $ dyn52 ptr_glBlendFunciOES v1 v2 v3

{-# NOINLINE ptr_glBlendFunciOES #-}
ptr_glBlendFunciOES :: FunPtr (GLuint -> GLenum -> GLenum -> IO ())
ptr_glBlendFunciOES = unsafePerformIO $ getCommand "glBlendFunciOES"

-- glBlendParameteriNV ---------------------------------------------------------

glBlendParameteriNV
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> GLint -- ^ @value@.
  -> m ()
glBlendParameteriNV v1 v2 = liftIO $ dyn55 ptr_glBlendParameteriNV v1 v2

{-# NOINLINE ptr_glBlendParameteriNV #-}
ptr_glBlendParameteriNV :: FunPtr (GLenum -> GLint -> IO ())
ptr_glBlendParameteriNV = unsafePerformIO $ getCommand "glBlendParameteriNV"

-- glBlitFramebuffer -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBlitFramebuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBlitFramebuffer.xhtml OpenGL 4.x>.
glBlitFramebuffer
  :: MonadIO m
  => GLint -- ^ @srcX0@.
  -> GLint -- ^ @srcY0@.
  -> GLint -- ^ @srcX1@.
  -> GLint -- ^ @srcY1@.
  -> GLint -- ^ @dstX0@.
  -> GLint -- ^ @dstY0@.
  -> GLint -- ^ @dstX1@.
  -> GLint -- ^ @dstY1@.
  -> GLbitfield -- ^ @mask@ of type [ClearBufferMask](Graphics-GL-Groups.html#ClearBufferMask).
  -> GLenum -- ^ @filter@.
  -> m ()
glBlitFramebuffer v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn56 ptr_glBlitFramebuffer v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

{-# NOINLINE ptr_glBlitFramebuffer #-}
ptr_glBlitFramebuffer :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
ptr_glBlitFramebuffer = unsafePerformIO $ getCommand "glBlitFramebuffer"

-- glBlitFramebufferANGLE ------------------------------------------------------

glBlitFramebufferANGLE
  :: MonadIO m
  => GLint -- ^ @srcX0@.
  -> GLint -- ^ @srcY0@.
  -> GLint -- ^ @srcX1@.
  -> GLint -- ^ @srcY1@.
  -> GLint -- ^ @dstX0@.
  -> GLint -- ^ @dstY0@.
  -> GLint -- ^ @dstX1@.
  -> GLint -- ^ @dstY1@.
  -> GLbitfield -- ^ @mask@.
  -> GLenum -- ^ @filter@.
  -> m ()
glBlitFramebufferANGLE v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn56 ptr_glBlitFramebufferANGLE v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

{-# NOINLINE ptr_glBlitFramebufferANGLE #-}
ptr_glBlitFramebufferANGLE :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
ptr_glBlitFramebufferANGLE = unsafePerformIO $ getCommand "glBlitFramebufferANGLE"

-- glBlitFramebufferEXT --------------------------------------------------------

-- | This command is an alias for 'glBlitFramebuffer'.
glBlitFramebufferEXT
  :: MonadIO m
  => GLint -- ^ @srcX0@.
  -> GLint -- ^ @srcY0@.
  -> GLint -- ^ @srcX1@.
  -> GLint -- ^ @srcY1@.
  -> GLint -- ^ @dstX0@.
  -> GLint -- ^ @dstY0@.
  -> GLint -- ^ @dstX1@.
  -> GLint -- ^ @dstY1@.
  -> GLbitfield -- ^ @mask@ of type [ClearBufferMask](Graphics-GL-Groups.html#ClearBufferMask).
  -> GLenum -- ^ @filter@.
  -> m ()
glBlitFramebufferEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn56 ptr_glBlitFramebufferEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

{-# NOINLINE ptr_glBlitFramebufferEXT #-}
ptr_glBlitFramebufferEXT :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
ptr_glBlitFramebufferEXT = unsafePerformIO $ getCommand "glBlitFramebufferEXT"

-- glBlitFramebufferNV ---------------------------------------------------------

-- | This command is an alias for 'glBlitFramebuffer'.
glBlitFramebufferNV
  :: MonadIO m
  => GLint -- ^ @srcX0@.
  -> GLint -- ^ @srcY0@.
  -> GLint -- ^ @srcX1@.
  -> GLint -- ^ @srcY1@.
  -> GLint -- ^ @dstX0@.
  -> GLint -- ^ @dstY0@.
  -> GLint -- ^ @dstX1@.
  -> GLint -- ^ @dstY1@.
  -> GLbitfield -- ^ @mask@.
  -> GLenum -- ^ @filter@.
  -> m ()
glBlitFramebufferNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn56 ptr_glBlitFramebufferNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

{-# NOINLINE ptr_glBlitFramebufferNV #-}
ptr_glBlitFramebufferNV :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
ptr_glBlitFramebufferNV = unsafePerformIO $ getCommand "glBlitFramebufferNV"

-- glBlitNamedFramebuffer ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBlitFramebuffer.xhtml OpenGL 4.x>.
glBlitNamedFramebuffer
  :: MonadIO m
  => GLuint -- ^ @readFramebuffer@.
  -> GLuint -- ^ @drawFramebuffer@.
  -> GLint -- ^ @srcX0@.
  -> GLint -- ^ @srcY0@.
  -> GLint -- ^ @srcX1@.
  -> GLint -- ^ @srcY1@.
  -> GLint -- ^ @dstX0@.
  -> GLint -- ^ @dstY0@.
  -> GLint -- ^ @dstX1@.
  -> GLint -- ^ @dstY1@.
  -> GLbitfield -- ^ @mask@.
  -> GLenum -- ^ @filter@.
  -> m ()
glBlitNamedFramebuffer v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 = liftIO $ dyn57 ptr_glBlitNamedFramebuffer v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12

{-# NOINLINE ptr_glBlitNamedFramebuffer #-}
ptr_glBlitNamedFramebuffer :: FunPtr (GLuint -> GLuint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLbitfield -> GLenum -> IO ())
ptr_glBlitNamedFramebuffer = unsafePerformIO $ getCommand "glBlitNamedFramebuffer"

-- glBufferAddressRangeNV ------------------------------------------------------

glBufferAddressRangeNV
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> GLuint -- ^ @index@.
  -> GLuint64EXT -- ^ @address@.
  -> GLsizeiptr -- ^ @length@ of type @BufferSize@.
  -> m ()
glBufferAddressRangeNV v1 v2 v3 v4 = liftIO $ dyn58 ptr_glBufferAddressRangeNV v1 v2 v3 v4

{-# NOINLINE ptr_glBufferAddressRangeNV #-}
ptr_glBufferAddressRangeNV :: FunPtr (GLenum -> GLuint -> GLuint64EXT -> GLsizeiptr -> IO ())
ptr_glBufferAddressRangeNV = unsafePerformIO $ getCommand "glBufferAddressRangeNV"

-- glBufferData ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBufferData.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBufferData.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBufferData.xhtml OpenGL 4.x>.
glBufferData
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> GLenum -- ^ @usage@ of type @BufferUsageARB@.
  -> m ()
glBufferData v1 v2 v3 v4 = liftIO $ dyn59 ptr_glBufferData v1 v2 v3 v4

{-# NOINLINE ptr_glBufferData #-}
ptr_glBufferData :: FunPtr (GLenum -> GLsizeiptr -> Ptr a -> GLenum -> IO ())
ptr_glBufferData = unsafePerformIO $ getCommand "glBufferData"

-- glBufferDataARB -------------------------------------------------------------

-- | This command is an alias for 'glBufferData'.
glBufferDataARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLsizeiptrARB -- ^ @size@ of type @BufferSizeARB@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> GLenum -- ^ @usage@ of type @BufferUsageARB@.
  -> m ()
glBufferDataARB v1 v2 v3 v4 = liftIO $ dyn60 ptr_glBufferDataARB v1 v2 v3 v4

{-# NOINLINE ptr_glBufferDataARB #-}
ptr_glBufferDataARB :: FunPtr (GLenum -> GLsizeiptrARB -> Ptr a -> GLenum -> IO ())
ptr_glBufferDataARB = unsafePerformIO $ getCommand "glBufferDataARB"

-- glBufferPageCommitmentARB ---------------------------------------------------

glBufferPageCommitmentARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLintptr -- ^ @offset@.
  -> GLsizeiptr -- ^ @size@.
  -> GLboolean -- ^ @commit@.
  -> m ()
glBufferPageCommitmentARB v1 v2 v3 v4 = liftIO $ dyn61 ptr_glBufferPageCommitmentARB v1 v2 v3 v4

{-# NOINLINE ptr_glBufferPageCommitmentARB #-}
ptr_glBufferPageCommitmentARB :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> GLboolean -> IO ())
ptr_glBufferPageCommitmentARB = unsafePerformIO $ getCommand "glBufferPageCommitmentARB"

-- glBufferParameteriAPPLE -----------------------------------------------------

glBufferParameteriAPPLE
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> GLint -- ^ @param@.
  -> m ()
glBufferParameteriAPPLE v1 v2 v3 = liftIO $ dyn62 ptr_glBufferParameteriAPPLE v1 v2 v3

{-# NOINLINE ptr_glBufferParameteriAPPLE #-}
ptr_glBufferParameteriAPPLE :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glBufferParameteriAPPLE = unsafePerformIO $ getCommand "glBufferParameteriAPPLE"

-- glBufferStorage -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBufferStorage.xhtml OpenGL 4.x>.
glBufferStorage
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLsizeiptr -- ^ @size@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> GLbitfield -- ^ @flags@.
  -> m ()
glBufferStorage v1 v2 v3 v4 = liftIO $ dyn63 ptr_glBufferStorage v1 v2 v3 v4

{-# NOINLINE ptr_glBufferStorage #-}
ptr_glBufferStorage :: FunPtr (GLenum -> GLsizeiptr -> Ptr a -> GLbitfield -> IO ())
ptr_glBufferStorage = unsafePerformIO $ getCommand "glBufferStorage"

-- glBufferStorageEXT ----------------------------------------------------------

-- | This command is an alias for 'glBufferStorage'.
glBufferStorageEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLsizeiptr -- ^ @size@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> GLbitfield -- ^ @flags@.
  -> m ()
glBufferStorageEXT v1 v2 v3 v4 = liftIO $ dyn63 ptr_glBufferStorageEXT v1 v2 v3 v4

{-# NOINLINE ptr_glBufferStorageEXT #-}
ptr_glBufferStorageEXT :: FunPtr (GLenum -> GLsizeiptr -> Ptr a -> GLbitfield -> IO ())
ptr_glBufferStorageEXT = unsafePerformIO $ getCommand "glBufferStorageEXT"

-- glBufferSubData -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBufferSubData.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBufferSubData.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBufferSubData.xhtml OpenGL 4.x>.
glBufferSubData
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> m ()
glBufferSubData v1 v2 v3 v4 = liftIO $ dyn64 ptr_glBufferSubData v1 v2 v3 v4

{-# NOINLINE ptr_glBufferSubData #-}
ptr_glBufferSubData :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> Ptr a -> IO ())
ptr_glBufferSubData = unsafePerformIO $ getCommand "glBufferSubData"

-- glBufferSubDataARB ----------------------------------------------------------

-- | This command is an alias for 'glBufferSubData'.
glBufferSubDataARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLintptrARB -- ^ @offset@ of type @BufferOffsetARB@.
  -> GLsizeiptrARB -- ^ @size@ of type @BufferSizeARB@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> m ()
glBufferSubDataARB v1 v2 v3 v4 = liftIO $ dyn65 ptr_glBufferSubDataARB v1 v2 v3 v4

{-# NOINLINE ptr_glBufferSubDataARB #-}
ptr_glBufferSubDataARB :: FunPtr (GLenum -> GLintptrARB -> GLsizeiptrARB -> Ptr a -> IO ())
ptr_glBufferSubDataARB = unsafePerformIO $ getCommand "glBufferSubDataARB"

-- glCallCommandListNV ---------------------------------------------------------

glCallCommandListNV
  :: MonadIO m
  => GLuint -- ^ @list@.
  -> m ()
glCallCommandListNV v1 = liftIO $ dyn2 ptr_glCallCommandListNV v1

{-# NOINLINE ptr_glCallCommandListNV #-}
ptr_glCallCommandListNV :: FunPtr (GLuint -> IO ())
ptr_glCallCommandListNV = unsafePerformIO $ getCommand "glCallCommandListNV"

-- glCallList ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glCallList.xml OpenGL 2.x>.
glCallList
  :: MonadIO m
  => GLuint -- ^ @list@ of type @List@.
  -> m ()
glCallList v1 = liftIO $ dyn2 ptr_glCallList v1

{-# NOINLINE ptr_glCallList #-}
ptr_glCallList :: FunPtr (GLuint -> IO ())
ptr_glCallList = unsafePerformIO $ getCommand "glCallList"

-- glCallLists -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glCallLists.xml OpenGL 2.x>.
glCallLists
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> GLenum -- ^ @type@ of type [ListNameType](Graphics-GL-Groups.html#ListNameType).
  -> Ptr a -- ^ @lists@ pointing to @COMPSIZE(n,type)@ elements of type @a@.
  -> m ()
glCallLists v1 v2 v3 = liftIO $ dyn66 ptr_glCallLists v1 v2 v3

{-# NOINLINE ptr_glCallLists #-}
ptr_glCallLists :: FunPtr (GLsizei -> GLenum -> Ptr a -> IO ())
ptr_glCallLists = unsafePerformIO $ getCommand "glCallLists"

-- glCheckFramebufferStatus ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glCheckFramebufferStatus.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCheckFramebufferStatus.xhtml OpenGL 4.x>.
glCheckFramebufferStatus
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> m GLenum
glCheckFramebufferStatus v1 = liftIO $ dyn67 ptr_glCheckFramebufferStatus v1

{-# NOINLINE ptr_glCheckFramebufferStatus #-}
ptr_glCheckFramebufferStatus :: FunPtr (GLenum -> IO GLenum)
ptr_glCheckFramebufferStatus = unsafePerformIO $ getCommand "glCheckFramebufferStatus"

-- glCheckFramebufferStatusEXT -------------------------------------------------

-- | This command is an alias for 'glCheckFramebufferStatus'.
glCheckFramebufferStatusEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> m GLenum
glCheckFramebufferStatusEXT v1 = liftIO $ dyn67 ptr_glCheckFramebufferStatusEXT v1

{-# NOINLINE ptr_glCheckFramebufferStatusEXT #-}
ptr_glCheckFramebufferStatusEXT :: FunPtr (GLenum -> IO GLenum)
ptr_glCheckFramebufferStatusEXT = unsafePerformIO $ getCommand "glCheckFramebufferStatusEXT"

-- glCheckFramebufferStatusOES -------------------------------------------------

glCheckFramebufferStatusOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m GLenum
glCheckFramebufferStatusOES v1 = liftIO $ dyn67 ptr_glCheckFramebufferStatusOES v1

{-# NOINLINE ptr_glCheckFramebufferStatusOES #-}
ptr_glCheckFramebufferStatusOES :: FunPtr (GLenum -> IO GLenum)
ptr_glCheckFramebufferStatusOES = unsafePerformIO $ getCommand "glCheckFramebufferStatusOES"

-- glCheckNamedFramebufferStatus -----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCheckFramebufferStatus.xhtml OpenGL 4.x>.
glCheckNamedFramebufferStatus
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLenum -- ^ @target@.
  -> m GLenum
glCheckNamedFramebufferStatus v1 v2 = liftIO $ dyn68 ptr_glCheckNamedFramebufferStatus v1 v2

{-# NOINLINE ptr_glCheckNamedFramebufferStatus #-}
ptr_glCheckNamedFramebufferStatus :: FunPtr (GLuint -> GLenum -> IO GLenum)
ptr_glCheckNamedFramebufferStatus = unsafePerformIO $ getCommand "glCheckNamedFramebufferStatus"

-- glCheckNamedFramebufferStatusEXT --------------------------------------------

glCheckNamedFramebufferStatusEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@ of type @Framebuffer@.
  -> GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> m GLenum -- ^ of type @FramebufferStatus@.
glCheckNamedFramebufferStatusEXT v1 v2 = liftIO $ dyn68 ptr_glCheckNamedFramebufferStatusEXT v1 v2

{-# NOINLINE ptr_glCheckNamedFramebufferStatusEXT #-}
ptr_glCheckNamedFramebufferStatusEXT :: FunPtr (GLuint -> GLenum -> IO GLenum)
ptr_glCheckNamedFramebufferStatusEXT = unsafePerformIO $ getCommand "glCheckNamedFramebufferStatusEXT"

-- glClampColor ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glClampColor.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClampColor.xhtml OpenGL 4.x>.
glClampColor
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ClampColorTargetARB@.
  -> GLenum -- ^ @clamp@ of type @ClampColorModeARB@.
  -> m ()
glClampColor v1 v2 = liftIO $ dyn51 ptr_glClampColor v1 v2

{-# NOINLINE ptr_glClampColor #-}
ptr_glClampColor :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glClampColor = unsafePerformIO $ getCommand "glClampColor"

-- glClampColorARB -------------------------------------------------------------

-- | This command is an alias for 'glClampColor'.
glClampColorARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ClampColorTargetARB@.
  -> GLenum -- ^ @clamp@ of type @ClampColorModeARB@.
  -> m ()
glClampColorARB v1 v2 = liftIO $ dyn51 ptr_glClampColorARB v1 v2

{-# NOINLINE ptr_glClampColorARB #-}
ptr_glClampColorARB :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glClampColorARB = unsafePerformIO $ getCommand "glClampColorARB"

-- glClear ---------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glClear.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glClear.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClear.xhtml OpenGL 4.x>.
glClear
  :: MonadIO m
  => GLbitfield -- ^ @mask@ of type [ClearBufferMask](Graphics-GL-Groups.html#ClearBufferMask).
  -> m ()
glClear v1 = liftIO $ dyn69 ptr_glClear v1

{-# NOINLINE ptr_glClear #-}
ptr_glClear :: FunPtr (GLbitfield -> IO ())
ptr_glClear = unsafePerformIO $ getCommand "glClear"

-- glClearAccum ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glClearAccum.xml OpenGL 2.x>.
glClearAccum
  :: MonadIO m
  => GLfloat -- ^ @red@.
  -> GLfloat -- ^ @green@.
  -> GLfloat -- ^ @blue@.
  -> GLfloat -- ^ @alpha@.
  -> m ()
glClearAccum v1 v2 v3 v4 = liftIO $ dyn49 ptr_glClearAccum v1 v2 v3 v4

{-# NOINLINE ptr_glClearAccum #-}
ptr_glClearAccum :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glClearAccum = unsafePerformIO $ getCommand "glClearAccum"

-- glClearAccumxOES ------------------------------------------------------------

glClearAccumxOES
  :: MonadIO m
  => GLfixed -- ^ @red@ of type @ClampedFixed@.
  -> GLfixed -- ^ @green@ of type @ClampedFixed@.
  -> GLfixed -- ^ @blue@ of type @ClampedFixed@.
  -> GLfixed -- ^ @alpha@ of type @ClampedFixed@.
  -> m ()
glClearAccumxOES v1 v2 v3 v4 = liftIO $ dyn50 ptr_glClearAccumxOES v1 v2 v3 v4

{-# NOINLINE ptr_glClearAccumxOES #-}
ptr_glClearAccumxOES :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glClearAccumxOES = unsafePerformIO $ getCommand "glClearAccumxOES"

-- glClearBufferData -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBufferData.xhtml OpenGL 4.x>.
glClearBufferData
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @internalformat@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type)@ elements of type @a@.
  -> m ()
glClearBufferData v1 v2 v3 v4 v5 = liftIO $ dyn70 ptr_glClearBufferData v1 v2 v3 v4 v5

{-# NOINLINE ptr_glClearBufferData #-}
ptr_glClearBufferData :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearBufferData = unsafePerformIO $ getCommand "glClearBufferData"

-- glClearBufferSubData --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBufferSubData.xhtml OpenGL 4.x>.
glClearBufferSubData
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @internalformat@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type)@ elements of type @a@.
  -> m ()
glClearBufferSubData v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn71 ptr_glClearBufferSubData v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glClearBufferSubData #-}
ptr_glClearBufferSubData :: FunPtr (GLenum -> GLenum -> GLintptr -> GLsizeiptr -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearBufferSubData = unsafePerformIO $ getCommand "glClearBufferSubData"

-- glClearBufferfi -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glClearBuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>.
glClearBufferfi
  :: MonadIO m
  => GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@ of type @DrawBufferName@.
  -> GLfloat -- ^ @depth@.
  -> GLint -- ^ @stencil@.
  -> m ()
glClearBufferfi v1 v2 v3 v4 = liftIO $ dyn72 ptr_glClearBufferfi v1 v2 v3 v4

{-# NOINLINE ptr_glClearBufferfi #-}
ptr_glClearBufferfi :: FunPtr (GLenum -> GLint -> GLfloat -> GLint -> IO ())
ptr_glClearBufferfi = unsafePerformIO $ getCommand "glClearBufferfi"

-- glClearBufferfv -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glClearBuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>.
glClearBufferfv
  :: MonadIO m
  => GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@ of type @DrawBufferName@.
  -> Ptr GLfloat -- ^ @value@ pointing to @COMPSIZE(buffer)@ elements of type @GLfloat@.
  -> m ()
glClearBufferfv v1 v2 v3 = liftIO $ dyn73 ptr_glClearBufferfv v1 v2 v3

{-# NOINLINE ptr_glClearBufferfv #-}
ptr_glClearBufferfv :: FunPtr (GLenum -> GLint -> Ptr GLfloat -> IO ())
ptr_glClearBufferfv = unsafePerformIO $ getCommand "glClearBufferfv"

-- glClearBufferiv -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glClearBuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>.
glClearBufferiv
  :: MonadIO m
  => GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@ of type @DrawBufferName@.
  -> Ptr GLint -- ^ @value@ pointing to @COMPSIZE(buffer)@ elements of type @GLint@.
  -> m ()
glClearBufferiv v1 v2 v3 = liftIO $ dyn74 ptr_glClearBufferiv v1 v2 v3

{-# NOINLINE ptr_glClearBufferiv #-}
ptr_glClearBufferiv :: FunPtr (GLenum -> GLint -> Ptr GLint -> IO ())
ptr_glClearBufferiv = unsafePerformIO $ getCommand "glClearBufferiv"

-- glClearBufferuiv ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glClearBuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>.
glClearBufferuiv
  :: MonadIO m
  => GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@ of type @DrawBufferName@.
  -> Ptr GLuint -- ^ @value@ pointing to @COMPSIZE(buffer)@ elements of type @GLuint@.
  -> m ()
glClearBufferuiv v1 v2 v3 = liftIO $ dyn75 ptr_glClearBufferuiv v1 v2 v3

{-# NOINLINE ptr_glClearBufferuiv #-}
ptr_glClearBufferuiv :: FunPtr (GLenum -> GLint -> Ptr GLuint -> IO ())
ptr_glClearBufferuiv = unsafePerformIO $ getCommand "glClearBufferuiv"

-- glClearColor ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glClearColor.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glClearColor.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClearColor.xhtml OpenGL 4.x>.
glClearColor
  :: MonadIO m
  => GLfloat -- ^ @red@ of type @ColorF@.
  -> GLfloat -- ^ @green@ of type @ColorF@.
  -> GLfloat -- ^ @blue@ of type @ColorF@.
  -> GLfloat -- ^ @alpha@ of type @ColorF@.
  -> m ()
glClearColor v1 v2 v3 v4 = liftIO $ dyn49 ptr_glClearColor v1 v2 v3 v4

{-# NOINLINE ptr_glClearColor #-}
ptr_glClearColor :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glClearColor = unsafePerformIO $ getCommand "glClearColor"

-- glClearColorIiEXT -----------------------------------------------------------

glClearColorIiEXT
  :: MonadIO m
  => GLint -- ^ @red@.
  -> GLint -- ^ @green@.
  -> GLint -- ^ @blue@.
  -> GLint -- ^ @alpha@.
  -> m ()
glClearColorIiEXT v1 v2 v3 v4 = liftIO $ dyn76 ptr_glClearColorIiEXT v1 v2 v3 v4

{-# NOINLINE ptr_glClearColorIiEXT #-}
ptr_glClearColorIiEXT :: FunPtr (GLint -> GLint -> GLint -> GLint -> IO ())
ptr_glClearColorIiEXT = unsafePerformIO $ getCommand "glClearColorIiEXT"

-- glClearColorIuiEXT ----------------------------------------------------------

glClearColorIuiEXT
  :: MonadIO m
  => GLuint -- ^ @red@.
  -> GLuint -- ^ @green@.
  -> GLuint -- ^ @blue@.
  -> GLuint -- ^ @alpha@.
  -> m ()
glClearColorIuiEXT v1 v2 v3 v4 = liftIO $ dyn77 ptr_glClearColorIuiEXT v1 v2 v3 v4

{-# NOINLINE ptr_glClearColorIuiEXT #-}
ptr_glClearColorIuiEXT :: FunPtr (GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glClearColorIuiEXT = unsafePerformIO $ getCommand "glClearColorIuiEXT"

-- glClearColorx ---------------------------------------------------------------

glClearColorx
  :: MonadIO m
  => GLfixed -- ^ @red@.
  -> GLfixed -- ^ @green@.
  -> GLfixed -- ^ @blue@.
  -> GLfixed -- ^ @alpha@.
  -> m ()
glClearColorx v1 v2 v3 v4 = liftIO $ dyn50 ptr_glClearColorx v1 v2 v3 v4

{-# NOINLINE ptr_glClearColorx #-}
ptr_glClearColorx :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glClearColorx = unsafePerformIO $ getCommand "glClearColorx"

-- glClearColorxOES ------------------------------------------------------------

glClearColorxOES
  :: MonadIO m
  => GLfixed -- ^ @red@ of type @ClampedFixed@.
  -> GLfixed -- ^ @green@ of type @ClampedFixed@.
  -> GLfixed -- ^ @blue@ of type @ClampedFixed@.
  -> GLfixed -- ^ @alpha@ of type @ClampedFixed@.
  -> m ()
glClearColorxOES v1 v2 v3 v4 = liftIO $ dyn50 ptr_glClearColorxOES v1 v2 v3 v4

{-# NOINLINE ptr_glClearColorxOES #-}
ptr_glClearColorxOES :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glClearColorxOES = unsafePerformIO $ getCommand "glClearColorxOES"

-- glClearDepth ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glClearDepth.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glClearDepth.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClearDepth.xhtml OpenGL 4.x>.
glClearDepth
  :: MonadIO m
  => GLdouble -- ^ @depth@.
  -> m ()
glClearDepth v1 = liftIO $ dyn78 ptr_glClearDepth v1

{-# NOINLINE ptr_glClearDepth #-}
ptr_glClearDepth :: FunPtr (GLdouble -> IO ())
ptr_glClearDepth = unsafePerformIO $ getCommand "glClearDepth"

-- glClearDepthdNV -------------------------------------------------------------

glClearDepthdNV
  :: MonadIO m
  => GLdouble -- ^ @depth@.
  -> m ()
glClearDepthdNV v1 = liftIO $ dyn78 ptr_glClearDepthdNV v1

{-# NOINLINE ptr_glClearDepthdNV #-}
ptr_glClearDepthdNV :: FunPtr (GLdouble -> IO ())
ptr_glClearDepthdNV = unsafePerformIO $ getCommand "glClearDepthdNV"

-- glClearDepthf ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearDepth.xhtml OpenGL 4.x>.
glClearDepthf
  :: MonadIO m
  => GLfloat -- ^ @d@.
  -> m ()
glClearDepthf v1 = liftIO $ dyn79 ptr_glClearDepthf v1

{-# NOINLINE ptr_glClearDepthf #-}
ptr_glClearDepthf :: FunPtr (GLfloat -> IO ())
ptr_glClearDepthf = unsafePerformIO $ getCommand "glClearDepthf"

-- glClearDepthfOES ------------------------------------------------------------

-- | This command is an alias for 'glClearDepthf'.
glClearDepthfOES
  :: MonadIO m
  => GLclampf -- ^ @depth@ of type @ClampedFloat32@.
  -> m ()
glClearDepthfOES v1 = liftIO $ dyn80 ptr_glClearDepthfOES v1

{-# NOINLINE ptr_glClearDepthfOES #-}
ptr_glClearDepthfOES :: FunPtr (GLclampf -> IO ())
ptr_glClearDepthfOES = unsafePerformIO $ getCommand "glClearDepthfOES"

-- glClearDepthx ---------------------------------------------------------------

glClearDepthx
  :: MonadIO m
  => GLfixed -- ^ @depth@.
  -> m ()
glClearDepthx v1 = liftIO $ dyn81 ptr_glClearDepthx v1

{-# NOINLINE ptr_glClearDepthx #-}
ptr_glClearDepthx :: FunPtr (GLfixed -> IO ())
ptr_glClearDepthx = unsafePerformIO $ getCommand "glClearDepthx"

-- glClearDepthxOES ------------------------------------------------------------

glClearDepthxOES
  :: MonadIO m
  => GLfixed -- ^ @depth@ of type @ClampedFixed@.
  -> m ()
glClearDepthxOES v1 = liftIO $ dyn81 ptr_glClearDepthxOES v1

{-# NOINLINE ptr_glClearDepthxOES #-}
ptr_glClearDepthxOES :: FunPtr (GLfixed -> IO ())
ptr_glClearDepthxOES = unsafePerformIO $ getCommand "glClearDepthxOES"

-- glClearIndex ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glClearIndex.xml OpenGL 2.x>.
glClearIndex
  :: MonadIO m
  => GLfloat -- ^ @c@ of type @MaskedColorIndexValueF@.
  -> m ()
glClearIndex v1 = liftIO $ dyn79 ptr_glClearIndex v1

{-# NOINLINE ptr_glClearIndex #-}
ptr_glClearIndex :: FunPtr (GLfloat -> IO ())
ptr_glClearIndex = unsafePerformIO $ getCommand "glClearIndex"

-- glClearNamedBufferData ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBufferData.xhtml OpenGL 4.x>.
glClearNamedBufferData
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @internalformat@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @data@.
  -> m ()
glClearNamedBufferData v1 v2 v3 v4 v5 = liftIO $ dyn82 ptr_glClearNamedBufferData v1 v2 v3 v4 v5

{-# NOINLINE ptr_glClearNamedBufferData #-}
ptr_glClearNamedBufferData :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearNamedBufferData = unsafePerformIO $ getCommand "glClearNamedBufferData"

-- glClearNamedBufferDataEXT ---------------------------------------------------

glClearNamedBufferDataEXT
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @internalformat@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type)@ elements of type @a@.
  -> m ()
glClearNamedBufferDataEXT v1 v2 v3 v4 v5 = liftIO $ dyn82 ptr_glClearNamedBufferDataEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glClearNamedBufferDataEXT #-}
ptr_glClearNamedBufferDataEXT :: FunPtr (GLuint -> GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearNamedBufferDataEXT = unsafePerformIO $ getCommand "glClearNamedBufferDataEXT"

-- glClearNamedBufferSubData ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBufferSubData.xhtml OpenGL 4.x>.
glClearNamedBufferSubData
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @internalformat@.
  -> GLintptr -- ^ @offset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @data@.
  -> m ()
glClearNamedBufferSubData v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn83 ptr_glClearNamedBufferSubData v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glClearNamedBufferSubData #-}
ptr_glClearNamedBufferSubData :: FunPtr (GLuint -> GLenum -> GLintptr -> GLsizeiptr -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearNamedBufferSubData = unsafePerformIO $ getCommand "glClearNamedBufferSubData"

-- glClearNamedBufferSubDataEXT ------------------------------------------------

glClearNamedBufferSubDataEXT
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @internalformat@.
  -> GLsizeiptr -- ^ @offset@ of type @BufferSize@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type)@ elements of type @a@.
  -> m ()
glClearNamedBufferSubDataEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn84 ptr_glClearNamedBufferSubDataEXT v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glClearNamedBufferSubDataEXT #-}
ptr_glClearNamedBufferSubDataEXT :: FunPtr (GLuint -> GLenum -> GLsizeiptr -> GLsizeiptr -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearNamedBufferSubDataEXT = unsafePerformIO $ getCommand "glClearNamedBufferSubDataEXT"

-- glClearNamedFramebufferfi ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>.
glClearNamedFramebufferfi
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@.
  -> GLfloat -- ^ @depth@.
  -> GLint -- ^ @stencil@.
  -> m ()
glClearNamedFramebufferfi v1 v2 v3 v4 v5 = liftIO $ dyn85 ptr_glClearNamedFramebufferfi v1 v2 v3 v4 v5

{-# NOINLINE ptr_glClearNamedFramebufferfi #-}
ptr_glClearNamedFramebufferfi :: FunPtr (GLuint -> GLenum -> GLint -> GLfloat -> GLint -> IO ())
ptr_glClearNamedFramebufferfi = unsafePerformIO $ getCommand "glClearNamedFramebufferfi"

-- glClearNamedFramebufferfv ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>.
glClearNamedFramebufferfv
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@.
  -> Ptr GLfloat -- ^ @value@.
  -> m ()
glClearNamedFramebufferfv v1 v2 v3 v4 = liftIO $ dyn86 ptr_glClearNamedFramebufferfv v1 v2 v3 v4

{-# NOINLINE ptr_glClearNamedFramebufferfv #-}
ptr_glClearNamedFramebufferfv :: FunPtr (GLuint -> GLenum -> GLint -> Ptr GLfloat -> IO ())
ptr_glClearNamedFramebufferfv = unsafePerformIO $ getCommand "glClearNamedFramebufferfv"

-- glClearNamedFramebufferiv ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>.
glClearNamedFramebufferiv
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@.
  -> Ptr GLint -- ^ @value@.
  -> m ()
glClearNamedFramebufferiv v1 v2 v3 v4 = liftIO $ dyn87 ptr_glClearNamedFramebufferiv v1 v2 v3 v4

{-# NOINLINE ptr_glClearNamedFramebufferiv #-}
ptr_glClearNamedFramebufferiv :: FunPtr (GLuint -> GLenum -> GLint -> Ptr GLint -> IO ())
ptr_glClearNamedFramebufferiv = unsafePerformIO $ getCommand "glClearNamedFramebufferiv"

-- glClearNamedFramebufferuiv --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearBuffer.xhtml OpenGL 4.x>.
glClearNamedFramebufferuiv
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLenum -- ^ @buffer@.
  -> GLint -- ^ @drawbuffer@.
  -> Ptr GLuint -- ^ @value@.
  -> m ()
glClearNamedFramebufferuiv v1 v2 v3 v4 = liftIO $ dyn88 ptr_glClearNamedFramebufferuiv v1 v2 v3 v4

{-# NOINLINE ptr_glClearNamedFramebufferuiv #-}
ptr_glClearNamedFramebufferuiv :: FunPtr (GLuint -> GLenum -> GLint -> Ptr GLuint -> IO ())
ptr_glClearNamedFramebufferuiv = unsafePerformIO $ getCommand "glClearNamedFramebufferuiv"

-- glClearPixelLocalStorageuiEXT -----------------------------------------------

glClearPixelLocalStorageuiEXT
  :: MonadIO m
  => GLsizei -- ^ @offset@.
  -> GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @values@.
  -> m ()
glClearPixelLocalStorageuiEXT v1 v2 v3 = liftIO $ dyn89 ptr_glClearPixelLocalStorageuiEXT v1 v2 v3

{-# NOINLINE ptr_glClearPixelLocalStorageuiEXT #-}
ptr_glClearPixelLocalStorageuiEXT :: FunPtr (GLsizei -> GLsizei -> Ptr GLuint -> IO ())
ptr_glClearPixelLocalStorageuiEXT = unsafePerformIO $ getCommand "glClearPixelLocalStorageuiEXT"

-- glClearStencil --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glClearStencil.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glClearStencil.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClearStencil.xhtml OpenGL 4.x>.
glClearStencil
  :: MonadIO m
  => GLint -- ^ @s@ of type @StencilValue@.
  -> m ()
glClearStencil v1 = liftIO $ dyn12 ptr_glClearStencil v1

{-# NOINLINE ptr_glClearStencil #-}
ptr_glClearStencil :: FunPtr (GLint -> IO ())
ptr_glClearStencil = unsafePerformIO $ getCommand "glClearStencil"

-- glClearTexImage -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearTexImage.xhtml OpenGL 4.x>.
glClearTexImage
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type)@ elements of type @a@.
  -> m ()
glClearTexImage v1 v2 v3 v4 v5 = liftIO $ dyn90 ptr_glClearTexImage v1 v2 v3 v4 v5

{-# NOINLINE ptr_glClearTexImage #-}
ptr_glClearTexImage :: FunPtr (GLuint -> GLint -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearTexImage = unsafePerformIO $ getCommand "glClearTexImage"

-- glClearTexSubImage ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClearTexSubImage.xhtml OpenGL 4.x>.
glClearTexSubImage
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type)@ elements of type @a@.
  -> m ()
glClearTexSubImage v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn91 ptr_glClearTexSubImage v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

{-# NOINLINE ptr_glClearTexSubImage #-}
ptr_glClearTexSubImage :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glClearTexSubImage = unsafePerformIO $ getCommand "glClearTexSubImage"

-- glClientActiveTexture -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glClientActiveTexture.xml OpenGL 2.x>.
glClientActiveTexture
  :: MonadIO m
  => GLenum -- ^ @texture@ of type @TextureUnit@.
  -> m ()
glClientActiveTexture v1 = liftIO $ dyn4 ptr_glClientActiveTexture v1

{-# NOINLINE ptr_glClientActiveTexture #-}
ptr_glClientActiveTexture :: FunPtr (GLenum -> IO ())
ptr_glClientActiveTexture = unsafePerformIO $ getCommand "glClientActiveTexture"

-- glClientActiveTextureARB ----------------------------------------------------

-- | This command is an alias for 'glClientActiveTexture'.
glClientActiveTextureARB
  :: MonadIO m
  => GLenum -- ^ @texture@ of type @TextureUnit@.
  -> m ()
glClientActiveTextureARB v1 = liftIO $ dyn4 ptr_glClientActiveTextureARB v1

{-# NOINLINE ptr_glClientActiveTextureARB #-}
ptr_glClientActiveTextureARB :: FunPtr (GLenum -> IO ())
ptr_glClientActiveTextureARB = unsafePerformIO $ getCommand "glClientActiveTextureARB"

-- glClientActiveVertexStreamATI -----------------------------------------------

glClientActiveVertexStreamATI
  :: MonadIO m
  => GLenum -- ^ @stream@ of type @VertexStreamATI@.
  -> m ()
glClientActiveVertexStreamATI v1 = liftIO $ dyn4 ptr_glClientActiveVertexStreamATI v1

{-# NOINLINE ptr_glClientActiveVertexStreamATI #-}
ptr_glClientActiveVertexStreamATI :: FunPtr (GLenum -> IO ())
ptr_glClientActiveVertexStreamATI = unsafePerformIO $ getCommand "glClientActiveVertexStreamATI"

-- glClientAttribDefaultEXT ----------------------------------------------------

glClientAttribDefaultEXT
  :: MonadIO m
  => GLbitfield -- ^ @mask@ of type [ClientAttribMask](Graphics-GL-Groups.html#ClientAttribMask).
  -> m ()
glClientAttribDefaultEXT v1 = liftIO $ dyn69 ptr_glClientAttribDefaultEXT v1

{-# NOINLINE ptr_glClientAttribDefaultEXT #-}
ptr_glClientAttribDefaultEXT :: FunPtr (GLbitfield -> IO ())
ptr_glClientAttribDefaultEXT = unsafePerformIO $ getCommand "glClientAttribDefaultEXT"

-- glClientWaitSync ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glClientWaitSync.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glClientWaitSync.xhtml OpenGL 4.x>.
glClientWaitSync
  :: MonadIO m
  => GLsync -- ^ @sync@ of type @sync@.
  -> GLbitfield -- ^ @flags@.
  -> GLuint64 -- ^ @timeout@.
  -> m GLenum
glClientWaitSync v1 v2 v3 = liftIO $ dyn92 ptr_glClientWaitSync v1 v2 v3

{-# NOINLINE ptr_glClientWaitSync #-}
ptr_glClientWaitSync :: FunPtr (GLsync -> GLbitfield -> GLuint64 -> IO GLenum)
ptr_glClientWaitSync = unsafePerformIO $ getCommand "glClientWaitSync"

-- glClientWaitSyncAPPLE -------------------------------------------------------

-- | This command is an alias for 'glClientWaitSync'.
glClientWaitSyncAPPLE
  :: MonadIO m
  => GLsync -- ^ @sync@.
  -> GLbitfield -- ^ @flags@.
  -> GLuint64 -- ^ @timeout@.
  -> m GLenum
glClientWaitSyncAPPLE v1 v2 v3 = liftIO $ dyn92 ptr_glClientWaitSyncAPPLE v1 v2 v3

{-# NOINLINE ptr_glClientWaitSyncAPPLE #-}
ptr_glClientWaitSyncAPPLE :: FunPtr (GLsync -> GLbitfield -> GLuint64 -> IO GLenum)
ptr_glClientWaitSyncAPPLE = unsafePerformIO $ getCommand "glClientWaitSyncAPPLE"

-- glClipControl ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glClipControl.xhtml OpenGL 4.x>.
glClipControl
  :: MonadIO m
  => GLenum -- ^ @origin@.
  -> GLenum -- ^ @depth@.
  -> m ()
glClipControl v1 v2 = liftIO $ dyn51 ptr_glClipControl v1 v2

{-# NOINLINE ptr_glClipControl #-}
ptr_glClipControl :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glClipControl = unsafePerformIO $ getCommand "glClipControl"

-- glClipPlane -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glClipPlane.xml OpenGL 2.x>.
glClipPlane
  :: MonadIO m
  => GLenum -- ^ @plane@ of type [ClipPlaneName](Graphics-GL-Groups.html#ClipPlaneName).
  -> Ptr GLdouble -- ^ @equation@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glClipPlane v1 v2 = liftIO $ dyn93 ptr_glClipPlane v1 v2

{-# NOINLINE ptr_glClipPlane #-}
ptr_glClipPlane :: FunPtr (GLenum -> Ptr GLdouble -> IO ())
ptr_glClipPlane = unsafePerformIO $ getCommand "glClipPlane"

-- glClipPlanef ----------------------------------------------------------------

glClipPlanef
  :: MonadIO m
  => GLenum -- ^ @p@.
  -> Ptr GLfloat -- ^ @eqn@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glClipPlanef v1 v2 = liftIO $ dyn94 ptr_glClipPlanef v1 v2

{-# NOINLINE ptr_glClipPlanef #-}
ptr_glClipPlanef :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glClipPlanef = unsafePerformIO $ getCommand "glClipPlanef"

-- glClipPlanefIMG -------------------------------------------------------------

glClipPlanefIMG
  :: MonadIO m
  => GLenum -- ^ @p@.
  -> Ptr GLfloat -- ^ @eqn@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glClipPlanefIMG v1 v2 = liftIO $ dyn94 ptr_glClipPlanefIMG v1 v2

{-# NOINLINE ptr_glClipPlanefIMG #-}
ptr_glClipPlanefIMG :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glClipPlanefIMG = unsafePerformIO $ getCommand "glClipPlanefIMG"

-- glClipPlanefOES -------------------------------------------------------------

glClipPlanefOES
  :: MonadIO m
  => GLenum -- ^ @plane@.
  -> Ptr GLfloat -- ^ @equation@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glClipPlanefOES v1 v2 = liftIO $ dyn94 ptr_glClipPlanefOES v1 v2

{-# NOINLINE ptr_glClipPlanefOES #-}
ptr_glClipPlanefOES :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glClipPlanefOES = unsafePerformIO $ getCommand "glClipPlanefOES"

-- glClipPlanex ----------------------------------------------------------------

glClipPlanex
  :: MonadIO m
  => GLenum -- ^ @plane@.
  -> Ptr GLfixed -- ^ @equation@ pointing to @4@ elements of type @GLfixed@.
  -> m ()
glClipPlanex v1 v2 = liftIO $ dyn95 ptr_glClipPlanex v1 v2

{-# NOINLINE ptr_glClipPlanex #-}
ptr_glClipPlanex :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glClipPlanex = unsafePerformIO $ getCommand "glClipPlanex"

-- glClipPlanexIMG -------------------------------------------------------------

glClipPlanexIMG
  :: MonadIO m
  => GLenum -- ^ @p@.
  -> Ptr GLfixed -- ^ @eqn@ pointing to @4@ elements of type @GLfixed@.
  -> m ()
glClipPlanexIMG v1 v2 = liftIO $ dyn95 ptr_glClipPlanexIMG v1 v2

{-# NOINLINE ptr_glClipPlanexIMG #-}
ptr_glClipPlanexIMG :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glClipPlanexIMG = unsafePerformIO $ getCommand "glClipPlanexIMG"

-- glClipPlanexOES -------------------------------------------------------------

glClipPlanexOES
  :: MonadIO m
  => GLenum -- ^ @plane@.
  -> Ptr GLfixed -- ^ @equation@ pointing to @4@ elements of type @GLfixed@.
  -> m ()
glClipPlanexOES v1 v2 = liftIO $ dyn95 ptr_glClipPlanexOES v1 v2

{-# NOINLINE ptr_glClipPlanexOES #-}
ptr_glClipPlanexOES :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glClipPlanexOES = unsafePerformIO $ getCommand "glClipPlanexOES"

-- glColor3b -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor3bv'.
glColor3b
  :: MonadIO m
  => GLbyte -- ^ @red@ of type @ColorB@.
  -> GLbyte -- ^ @green@ of type @ColorB@.
  -> GLbyte -- ^ @blue@ of type @ColorB@.
  -> m ()
glColor3b v1 v2 v3 = liftIO $ dyn36 ptr_glColor3b v1 v2 v3

{-# NOINLINE ptr_glColor3b #-}
ptr_glColor3b :: FunPtr (GLbyte -> GLbyte -> GLbyte -> IO ())
ptr_glColor3b = unsafePerformIO $ getCommand "glColor3b"

-- glColor3bv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor3bv
  :: MonadIO m
  => Ptr GLbyte -- ^ @v@ pointing to @3@ elements of type @ColorB@.
  -> m ()
glColor3bv v1 = liftIO $ dyn37 ptr_glColor3bv v1

{-# NOINLINE ptr_glColor3bv #-}
ptr_glColor3bv :: FunPtr (Ptr GLbyte -> IO ())
ptr_glColor3bv = unsafePerformIO $ getCommand "glColor3bv"

-- glColor3d -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor3dv'.
glColor3d
  :: MonadIO m
  => GLdouble -- ^ @red@ of type @ColorD@.
  -> GLdouble -- ^ @green@ of type @ColorD@.
  -> GLdouble -- ^ @blue@ of type @ColorD@.
  -> m ()
glColor3d v1 v2 v3 = liftIO $ dyn38 ptr_glColor3d v1 v2 v3

{-# NOINLINE ptr_glColor3d #-}
ptr_glColor3d :: FunPtr (GLdouble -> GLdouble -> GLdouble -> IO ())
ptr_glColor3d = unsafePerformIO $ getCommand "glColor3d"

-- glColor3dv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor3dv
  :: MonadIO m
  => Ptr GLdouble -- ^ @v@ pointing to @3@ elements of type @ColorD@.
  -> m ()
glColor3dv v1 = liftIO $ dyn39 ptr_glColor3dv v1

{-# NOINLINE ptr_glColor3dv #-}
ptr_glColor3dv :: FunPtr (Ptr GLdouble -> IO ())
ptr_glColor3dv = unsafePerformIO $ getCommand "glColor3dv"

-- glColor3f -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor3fv'.
glColor3f
  :: MonadIO m
  => GLfloat -- ^ @red@ of type @ColorF@.
  -> GLfloat -- ^ @green@ of type @ColorF@.
  -> GLfloat -- ^ @blue@ of type @ColorF@.
  -> m ()
glColor3f v1 v2 v3 = liftIO $ dyn40 ptr_glColor3f v1 v2 v3

{-# NOINLINE ptr_glColor3f #-}
ptr_glColor3f :: FunPtr (GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glColor3f = unsafePerformIO $ getCommand "glColor3f"

-- glColor3fVertex3fSUN --------------------------------------------------------

glColor3fVertex3fSUN
  :: MonadIO m
  => GLfloat -- ^ @r@.
  -> GLfloat -- ^ @g@.
  -> GLfloat -- ^ @b@.
  -> GLfloat -- ^ @x@.
  -> GLfloat -- ^ @y@.
  -> GLfloat -- ^ @z@.
  -> m ()
glColor3fVertex3fSUN v1 v2 v3 v4 v5 v6 = liftIO $ dyn96 ptr_glColor3fVertex3fSUN v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glColor3fVertex3fSUN #-}
ptr_glColor3fVertex3fSUN :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glColor3fVertex3fSUN = unsafePerformIO $ getCommand "glColor3fVertex3fSUN"

-- glColor3fVertex3fvSUN -------------------------------------------------------

glColor3fVertex3fvSUN
  :: MonadIO m
  => Ptr GLfloat -- ^ @c@ pointing to @3@ elements of type @GLfloat@.
  -> Ptr GLfloat -- ^ @v@ pointing to @3@ elements of type @GLfloat@.
  -> m ()
glColor3fVertex3fvSUN v1 v2 = liftIO $ dyn97 ptr_glColor3fVertex3fvSUN v1 v2

{-# NOINLINE ptr_glColor3fVertex3fvSUN #-}
ptr_glColor3fVertex3fvSUN :: FunPtr (Ptr GLfloat -> Ptr GLfloat -> IO ())
ptr_glColor3fVertex3fvSUN = unsafePerformIO $ getCommand "glColor3fVertex3fvSUN"

-- glColor3fv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor3fv
  :: MonadIO m
  => Ptr GLfloat -- ^ @v@ pointing to @3@ elements of type @ColorF@.
  -> m ()
glColor3fv v1 = liftIO $ dyn41 ptr_glColor3fv v1

{-# NOINLINE ptr_glColor3fv #-}
ptr_glColor3fv :: FunPtr (Ptr GLfloat -> IO ())
ptr_glColor3fv = unsafePerformIO $ getCommand "glColor3fv"

-- glColor3hNV -----------------------------------------------------------------

-- | The vector equivalent of this command is 'glColor3hvNV'.
glColor3hNV
  :: MonadIO m
  => GLhalfNV -- ^ @red@ of type @Half16NV@.
  -> GLhalfNV -- ^ @green@ of type @Half16NV@.
  -> GLhalfNV -- ^ @blue@ of type @Half16NV@.
  -> m ()
glColor3hNV v1 v2 v3 = liftIO $ dyn98 ptr_glColor3hNV v1 v2 v3

{-# NOINLINE ptr_glColor3hNV #-}
ptr_glColor3hNV :: FunPtr (GLhalfNV -> GLhalfNV -> GLhalfNV -> IO ())
ptr_glColor3hNV = unsafePerformIO $ getCommand "glColor3hNV"

-- glColor3hvNV ----------------------------------------------------------------

glColor3hvNV
  :: MonadIO m
  => Ptr GLhalfNV -- ^ @v@ pointing to @3@ elements of type @Half16NV@.
  -> m ()
glColor3hvNV v1 = liftIO $ dyn99 ptr_glColor3hvNV v1

{-# NOINLINE ptr_glColor3hvNV #-}
ptr_glColor3hvNV :: FunPtr (Ptr GLhalfNV -> IO ())
ptr_glColor3hvNV = unsafePerformIO $ getCommand "glColor3hvNV"

-- glColor3i -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor3iv'.
glColor3i
  :: MonadIO m
  => GLint -- ^ @red@ of type @ColorI@.
  -> GLint -- ^ @green@ of type @ColorI@.
  -> GLint -- ^ @blue@ of type @ColorI@.
  -> m ()
glColor3i v1 v2 v3 = liftIO $ dyn42 ptr_glColor3i v1 v2 v3

{-# NOINLINE ptr_glColor3i #-}
ptr_glColor3i :: FunPtr (GLint -> GLint -> GLint -> IO ())
ptr_glColor3i = unsafePerformIO $ getCommand "glColor3i"

-- glColor3iv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor3iv
  :: MonadIO m
  => Ptr GLint -- ^ @v@ pointing to @3@ elements of type @ColorI@.
  -> m ()
glColor3iv v1 = liftIO $ dyn43 ptr_glColor3iv v1

{-# NOINLINE ptr_glColor3iv #-}
ptr_glColor3iv :: FunPtr (Ptr GLint -> IO ())
ptr_glColor3iv = unsafePerformIO $ getCommand "glColor3iv"

-- glColor3s -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor3sv'.
glColor3s
  :: MonadIO m
  => GLshort -- ^ @red@ of type @ColorS@.
  -> GLshort -- ^ @green@ of type @ColorS@.
  -> GLshort -- ^ @blue@ of type @ColorS@.
  -> m ()
glColor3s v1 v2 v3 = liftIO $ dyn44 ptr_glColor3s v1 v2 v3

{-# NOINLINE ptr_glColor3s #-}
ptr_glColor3s :: FunPtr (GLshort -> GLshort -> GLshort -> IO ())
ptr_glColor3s = unsafePerformIO $ getCommand "glColor3s"

-- glColor3sv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor3sv
  :: MonadIO m
  => Ptr GLshort -- ^ @v@ pointing to @3@ elements of type @ColorS@.
  -> m ()
glColor3sv v1 = liftIO $ dyn45 ptr_glColor3sv v1

{-# NOINLINE ptr_glColor3sv #-}
ptr_glColor3sv :: FunPtr (Ptr GLshort -> IO ())
ptr_glColor3sv = unsafePerformIO $ getCommand "glColor3sv"

-- glColor3ub ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor3ubv'.
glColor3ub
  :: MonadIO m
  => GLubyte -- ^ @red@ of type @ColorUB@.
  -> GLubyte -- ^ @green@ of type @ColorUB@.
  -> GLubyte -- ^ @blue@ of type @ColorUB@.
  -> m ()
glColor3ub v1 v2 v3 = liftIO $ dyn100 ptr_glColor3ub v1 v2 v3

{-# NOINLINE ptr_glColor3ub #-}
ptr_glColor3ub :: FunPtr (GLubyte -> GLubyte -> GLubyte -> IO ())
ptr_glColor3ub = unsafePerformIO $ getCommand "glColor3ub"

-- glColor3ubv -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor3ubv
  :: MonadIO m
  => Ptr GLubyte -- ^ @v@ pointing to @3@ elements of type @ColorUB@.
  -> m ()
glColor3ubv v1 = liftIO $ dyn101 ptr_glColor3ubv v1

{-# NOINLINE ptr_glColor3ubv #-}
ptr_glColor3ubv :: FunPtr (Ptr GLubyte -> IO ())
ptr_glColor3ubv = unsafePerformIO $ getCommand "glColor3ubv"

-- glColor3ui ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor3uiv'.
glColor3ui
  :: MonadIO m
  => GLuint -- ^ @red@ of type @ColorUI@.
  -> GLuint -- ^ @green@ of type @ColorUI@.
  -> GLuint -- ^ @blue@ of type @ColorUI@.
  -> m ()
glColor3ui v1 v2 v3 = liftIO $ dyn102 ptr_glColor3ui v1 v2 v3

{-# NOINLINE ptr_glColor3ui #-}
ptr_glColor3ui :: FunPtr (GLuint -> GLuint -> GLuint -> IO ())
ptr_glColor3ui = unsafePerformIO $ getCommand "glColor3ui"

-- glColor3uiv -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor3uiv
  :: MonadIO m
  => Ptr GLuint -- ^ @v@ pointing to @3@ elements of type @ColorUI@.
  -> m ()
glColor3uiv v1 = liftIO $ dyn103 ptr_glColor3uiv v1

{-# NOINLINE ptr_glColor3uiv #-}
ptr_glColor3uiv :: FunPtr (Ptr GLuint -> IO ())
ptr_glColor3uiv = unsafePerformIO $ getCommand "glColor3uiv"

-- glColor3us ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor3usv'.
glColor3us
  :: MonadIO m
  => GLushort -- ^ @red@ of type @ColorUS@.
  -> GLushort -- ^ @green@ of type @ColorUS@.
  -> GLushort -- ^ @blue@ of type @ColorUS@.
  -> m ()
glColor3us v1 v2 v3 = liftIO $ dyn104 ptr_glColor3us v1 v2 v3

{-# NOINLINE ptr_glColor3us #-}
ptr_glColor3us :: FunPtr (GLushort -> GLushort -> GLushort -> IO ())
ptr_glColor3us = unsafePerformIO $ getCommand "glColor3us"

-- glColor3usv -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor3usv
  :: MonadIO m
  => Ptr GLushort -- ^ @v@ pointing to @3@ elements of type @ColorUS@.
  -> m ()
glColor3usv v1 = liftIO $ dyn105 ptr_glColor3usv v1

{-# NOINLINE ptr_glColor3usv #-}
ptr_glColor3usv :: FunPtr (Ptr GLushort -> IO ())
ptr_glColor3usv = unsafePerformIO $ getCommand "glColor3usv"

-- glColor3xOES ----------------------------------------------------------------

glColor3xOES
  :: MonadIO m
  => GLfixed -- ^ @red@.
  -> GLfixed -- ^ @green@.
  -> GLfixed -- ^ @blue@.
  -> m ()
glColor3xOES v1 v2 v3 = liftIO $ dyn106 ptr_glColor3xOES v1 v2 v3

{-# NOINLINE ptr_glColor3xOES #-}
ptr_glColor3xOES :: FunPtr (GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glColor3xOES = unsafePerformIO $ getCommand "glColor3xOES"

-- glColor3xvOES ---------------------------------------------------------------

glColor3xvOES
  :: MonadIO m
  => Ptr GLfixed -- ^ @components@ pointing to @3@ elements of type @GLfixed@.
  -> m ()
glColor3xvOES v1 = liftIO $ dyn107 ptr_glColor3xvOES v1

{-# NOINLINE ptr_glColor3xvOES #-}
ptr_glColor3xvOES :: FunPtr (Ptr GLfixed -> IO ())
ptr_glColor3xvOES = unsafePerformIO $ getCommand "glColor3xvOES"

-- glColor4b -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor4bv'.
glColor4b
  :: MonadIO m
  => GLbyte -- ^ @red@ of type @ColorB@.
  -> GLbyte -- ^ @green@ of type @ColorB@.
  -> GLbyte -- ^ @blue@ of type @ColorB@.
  -> GLbyte -- ^ @alpha@ of type @ColorB@.
  -> m ()
glColor4b v1 v2 v3 v4 = liftIO $ dyn108 ptr_glColor4b v1 v2 v3 v4

{-# NOINLINE ptr_glColor4b #-}
ptr_glColor4b :: FunPtr (GLbyte -> GLbyte -> GLbyte -> GLbyte -> IO ())
ptr_glColor4b = unsafePerformIO $ getCommand "glColor4b"

-- glColor4bv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor4bv
  :: MonadIO m
  => Ptr GLbyte -- ^ @v@ pointing to @4@ elements of type @ColorB@.
  -> m ()
glColor4bv v1 = liftIO $ dyn37 ptr_glColor4bv v1

{-# NOINLINE ptr_glColor4bv #-}
ptr_glColor4bv :: FunPtr (Ptr GLbyte -> IO ())
ptr_glColor4bv = unsafePerformIO $ getCommand "glColor4bv"

-- glColor4d -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor4dv'.
glColor4d
  :: MonadIO m
  => GLdouble -- ^ @red@ of type @ColorD@.
  -> GLdouble -- ^ @green@ of type @ColorD@.
  -> GLdouble -- ^ @blue@ of type @ColorD@.
  -> GLdouble -- ^ @alpha@ of type @ColorD@.
  -> m ()
glColor4d v1 v2 v3 v4 = liftIO $ dyn109 ptr_glColor4d v1 v2 v3 v4

{-# NOINLINE ptr_glColor4d #-}
ptr_glColor4d :: FunPtr (GLdouble -> GLdouble -> GLdouble -> GLdouble -> IO ())
ptr_glColor4d = unsafePerformIO $ getCommand "glColor4d"

-- glColor4dv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor4dv
  :: MonadIO m
  => Ptr GLdouble -- ^ @v@ pointing to @4@ elements of type @ColorD@.
  -> m ()
glColor4dv v1 = liftIO $ dyn39 ptr_glColor4dv v1

{-# NOINLINE ptr_glColor4dv #-}
ptr_glColor4dv :: FunPtr (Ptr GLdouble -> IO ())
ptr_glColor4dv = unsafePerformIO $ getCommand "glColor4dv"

-- glColor4f -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor4fv'.
glColor4f
  :: MonadIO m
  => GLfloat -- ^ @red@ of type @ColorF@.
  -> GLfloat -- ^ @green@ of type @ColorF@.
  -> GLfloat -- ^ @blue@ of type @ColorF@.
  -> GLfloat -- ^ @alpha@ of type @ColorF@.
  -> m ()
glColor4f v1 v2 v3 v4 = liftIO $ dyn49 ptr_glColor4f v1 v2 v3 v4

{-# NOINLINE ptr_glColor4f #-}
ptr_glColor4f :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glColor4f = unsafePerformIO $ getCommand "glColor4f"

-- glColor4fNormal3fVertex3fSUN ------------------------------------------------

glColor4fNormal3fVertex3fSUN
  :: MonadIO m
  => GLfloat -- ^ @r@.
  -> GLfloat -- ^ @g@.
  -> GLfloat -- ^ @b@.
  -> GLfloat -- ^ @a@.
  -> GLfloat -- ^ @nx@.
  -> GLfloat -- ^ @ny@.
  -> GLfloat -- ^ @nz@.
  -> GLfloat -- ^ @x@.
  -> GLfloat -- ^ @y@.
  -> GLfloat -- ^ @z@.
  -> m ()
glColor4fNormal3fVertex3fSUN v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn110 ptr_glColor4fNormal3fVertex3fSUN v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

{-# NOINLINE ptr_glColor4fNormal3fVertex3fSUN #-}
ptr_glColor4fNormal3fVertex3fSUN :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glColor4fNormal3fVertex3fSUN = unsafePerformIO $ getCommand "glColor4fNormal3fVertex3fSUN"

-- glColor4fNormal3fVertex3fvSUN -----------------------------------------------

glColor4fNormal3fVertex3fvSUN
  :: MonadIO m
  => Ptr GLfloat -- ^ @c@ pointing to @4@ elements of type @GLfloat@.
  -> Ptr GLfloat -- ^ @n@ pointing to @3@ elements of type @GLfloat@.
  -> Ptr GLfloat -- ^ @v@ pointing to @3@ elements of type @GLfloat@.
  -> m ()
glColor4fNormal3fVertex3fvSUN v1 v2 v3 = liftIO $ dyn111 ptr_glColor4fNormal3fVertex3fvSUN v1 v2 v3

{-# NOINLINE ptr_glColor4fNormal3fVertex3fvSUN #-}
ptr_glColor4fNormal3fVertex3fvSUN :: FunPtr (Ptr GLfloat -> Ptr GLfloat -> Ptr GLfloat -> IO ())
ptr_glColor4fNormal3fVertex3fvSUN = unsafePerformIO $ getCommand "glColor4fNormal3fVertex3fvSUN"

-- glColor4fv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor4fv
  :: MonadIO m
  => Ptr GLfloat -- ^ @v@ pointing to @4@ elements of type @ColorF@.
  -> m ()
glColor4fv v1 = liftIO $ dyn41 ptr_glColor4fv v1

{-# NOINLINE ptr_glColor4fv #-}
ptr_glColor4fv :: FunPtr (Ptr GLfloat -> IO ())
ptr_glColor4fv = unsafePerformIO $ getCommand "glColor4fv"

-- glColor4hNV -----------------------------------------------------------------

-- | The vector equivalent of this command is 'glColor4hvNV'.
glColor4hNV
  :: MonadIO m
  => GLhalfNV -- ^ @red@ of type @Half16NV@.
  -> GLhalfNV -- ^ @green@ of type @Half16NV@.
  -> GLhalfNV -- ^ @blue@ of type @Half16NV@.
  -> GLhalfNV -- ^ @alpha@ of type @Half16NV@.
  -> m ()
glColor4hNV v1 v2 v3 v4 = liftIO $ dyn112 ptr_glColor4hNV v1 v2 v3 v4

{-# NOINLINE ptr_glColor4hNV #-}
ptr_glColor4hNV :: FunPtr (GLhalfNV -> GLhalfNV -> GLhalfNV -> GLhalfNV -> IO ())
ptr_glColor4hNV = unsafePerformIO $ getCommand "glColor4hNV"

-- glColor4hvNV ----------------------------------------------------------------

glColor4hvNV
  :: MonadIO m
  => Ptr GLhalfNV -- ^ @v@ pointing to @4@ elements of type @Half16NV@.
  -> m ()
glColor4hvNV v1 = liftIO $ dyn99 ptr_glColor4hvNV v1

{-# NOINLINE ptr_glColor4hvNV #-}
ptr_glColor4hvNV :: FunPtr (Ptr GLhalfNV -> IO ())
ptr_glColor4hvNV = unsafePerformIO $ getCommand "glColor4hvNV"

-- glColor4i -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor4iv'.
glColor4i
  :: MonadIO m
  => GLint -- ^ @red@ of type @ColorI@.
  -> GLint -- ^ @green@ of type @ColorI@.
  -> GLint -- ^ @blue@ of type @ColorI@.
  -> GLint -- ^ @alpha@ of type @ColorI@.
  -> m ()
glColor4i v1 v2 v3 v4 = liftIO $ dyn76 ptr_glColor4i v1 v2 v3 v4

{-# NOINLINE ptr_glColor4i #-}
ptr_glColor4i :: FunPtr (GLint -> GLint -> GLint -> GLint -> IO ())
ptr_glColor4i = unsafePerformIO $ getCommand "glColor4i"

-- glColor4iv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor4iv
  :: MonadIO m
  => Ptr GLint -- ^ @v@ pointing to @4@ elements of type @ColorI@.
  -> m ()
glColor4iv v1 = liftIO $ dyn43 ptr_glColor4iv v1

{-# NOINLINE ptr_glColor4iv #-}
ptr_glColor4iv :: FunPtr (Ptr GLint -> IO ())
ptr_glColor4iv = unsafePerformIO $ getCommand "glColor4iv"

-- glColor4s -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor4sv'.
glColor4s
  :: MonadIO m
  => GLshort -- ^ @red@ of type @ColorS@.
  -> GLshort -- ^ @green@ of type @ColorS@.
  -> GLshort -- ^ @blue@ of type @ColorS@.
  -> GLshort -- ^ @alpha@ of type @ColorS@.
  -> m ()
glColor4s v1 v2 v3 v4 = liftIO $ dyn113 ptr_glColor4s v1 v2 v3 v4

{-# NOINLINE ptr_glColor4s #-}
ptr_glColor4s :: FunPtr (GLshort -> GLshort -> GLshort -> GLshort -> IO ())
ptr_glColor4s = unsafePerformIO $ getCommand "glColor4s"

-- glColor4sv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor4sv
  :: MonadIO m
  => Ptr GLshort -- ^ @v@ pointing to @4@ elements of type @ColorS@.
  -> m ()
glColor4sv v1 = liftIO $ dyn45 ptr_glColor4sv v1

{-# NOINLINE ptr_glColor4sv #-}
ptr_glColor4sv :: FunPtr (Ptr GLshort -> IO ())
ptr_glColor4sv = unsafePerformIO $ getCommand "glColor4sv"

-- glColor4ub ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor4ubv'.
glColor4ub
  :: MonadIO m
  => GLubyte -- ^ @red@ of type @ColorUB@.
  -> GLubyte -- ^ @green@ of type @ColorUB@.
  -> GLubyte -- ^ @blue@ of type @ColorUB@.
  -> GLubyte -- ^ @alpha@ of type @ColorUB@.
  -> m ()
glColor4ub v1 v2 v3 v4 = liftIO $ dyn114 ptr_glColor4ub v1 v2 v3 v4

{-# NOINLINE ptr_glColor4ub #-}
ptr_glColor4ub :: FunPtr (GLubyte -> GLubyte -> GLubyte -> GLubyte -> IO ())
ptr_glColor4ub = unsafePerformIO $ getCommand "glColor4ub"

-- glColor4ubVertex2fSUN -------------------------------------------------------

glColor4ubVertex2fSUN
  :: MonadIO m
  => GLubyte -- ^ @r@.
  -> GLubyte -- ^ @g@.
  -> GLubyte -- ^ @b@.
  -> GLubyte -- ^ @a@.
  -> GLfloat -- ^ @x@.
  -> GLfloat -- ^ @y@.
  -> m ()
glColor4ubVertex2fSUN v1 v2 v3 v4 v5 v6 = liftIO $ dyn115 ptr_glColor4ubVertex2fSUN v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glColor4ubVertex2fSUN #-}
ptr_glColor4ubVertex2fSUN :: FunPtr (GLubyte -> GLubyte -> GLubyte -> GLubyte -> GLfloat -> GLfloat -> IO ())
ptr_glColor4ubVertex2fSUN = unsafePerformIO $ getCommand "glColor4ubVertex2fSUN"

-- glColor4ubVertex2fvSUN ------------------------------------------------------

glColor4ubVertex2fvSUN
  :: MonadIO m
  => Ptr GLubyte -- ^ @c@ pointing to @4@ elements of type @GLubyte@.
  -> Ptr GLfloat -- ^ @v@ pointing to @2@ elements of type @GLfloat@.
  -> m ()
glColor4ubVertex2fvSUN v1 v2 = liftIO $ dyn116 ptr_glColor4ubVertex2fvSUN v1 v2

{-# NOINLINE ptr_glColor4ubVertex2fvSUN #-}
ptr_glColor4ubVertex2fvSUN :: FunPtr (Ptr GLubyte -> Ptr GLfloat -> IO ())
ptr_glColor4ubVertex2fvSUN = unsafePerformIO $ getCommand "glColor4ubVertex2fvSUN"

-- glColor4ubVertex3fSUN -------------------------------------------------------

glColor4ubVertex3fSUN
  :: MonadIO m
  => GLubyte -- ^ @r@.
  -> GLubyte -- ^ @g@.
  -> GLubyte -- ^ @b@.
  -> GLubyte -- ^ @a@.
  -> GLfloat -- ^ @x@.
  -> GLfloat -- ^ @y@.
  -> GLfloat -- ^ @z@.
  -> m ()
glColor4ubVertex3fSUN v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn117 ptr_glColor4ubVertex3fSUN v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glColor4ubVertex3fSUN #-}
ptr_glColor4ubVertex3fSUN :: FunPtr (GLubyte -> GLubyte -> GLubyte -> GLubyte -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glColor4ubVertex3fSUN = unsafePerformIO $ getCommand "glColor4ubVertex3fSUN"

-- glColor4ubVertex3fvSUN ------------------------------------------------------

glColor4ubVertex3fvSUN
  :: MonadIO m
  => Ptr GLubyte -- ^ @c@ pointing to @4@ elements of type @GLubyte@.
  -> Ptr GLfloat -- ^ @v@ pointing to @3@ elements of type @GLfloat@.
  -> m ()
glColor4ubVertex3fvSUN v1 v2 = liftIO $ dyn116 ptr_glColor4ubVertex3fvSUN v1 v2

{-# NOINLINE ptr_glColor4ubVertex3fvSUN #-}
ptr_glColor4ubVertex3fvSUN :: FunPtr (Ptr GLubyte -> Ptr GLfloat -> IO ())
ptr_glColor4ubVertex3fvSUN = unsafePerformIO $ getCommand "glColor4ubVertex3fvSUN"

-- glColor4ubv -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor4ubv
  :: MonadIO m
  => Ptr GLubyte -- ^ @v@ pointing to @4@ elements of type @ColorUB@.
  -> m ()
glColor4ubv v1 = liftIO $ dyn101 ptr_glColor4ubv v1

{-# NOINLINE ptr_glColor4ubv #-}
ptr_glColor4ubv :: FunPtr (Ptr GLubyte -> IO ())
ptr_glColor4ubv = unsafePerformIO $ getCommand "glColor4ubv"

-- glColor4ui ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor4uiv'.
glColor4ui
  :: MonadIO m
  => GLuint -- ^ @red@ of type @ColorUI@.
  -> GLuint -- ^ @green@ of type @ColorUI@.
  -> GLuint -- ^ @blue@ of type @ColorUI@.
  -> GLuint -- ^ @alpha@ of type @ColorUI@.
  -> m ()
glColor4ui v1 v2 v3 v4 = liftIO $ dyn77 ptr_glColor4ui v1 v2 v3 v4

{-# NOINLINE ptr_glColor4ui #-}
ptr_glColor4ui :: FunPtr (GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glColor4ui = unsafePerformIO $ getCommand "glColor4ui"

-- glColor4uiv -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor4uiv
  :: MonadIO m
  => Ptr GLuint -- ^ @v@ pointing to @4@ elements of type @ColorUI@.
  -> m ()
glColor4uiv v1 = liftIO $ dyn103 ptr_glColor4uiv v1

{-# NOINLINE ptr_glColor4uiv #-}
ptr_glColor4uiv :: FunPtr (Ptr GLuint -> IO ())
ptr_glColor4uiv = unsafePerformIO $ getCommand "glColor4uiv"

-- glColor4us ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>. The vector equivalent of this command is 'glColor4usv'.
glColor4us
  :: MonadIO m
  => GLushort -- ^ @red@ of type @ColorUS@.
  -> GLushort -- ^ @green@ of type @ColorUS@.
  -> GLushort -- ^ @blue@ of type @ColorUS@.
  -> GLushort -- ^ @alpha@ of type @ColorUS@.
  -> m ()
glColor4us v1 v2 v3 v4 = liftIO $ dyn118 ptr_glColor4us v1 v2 v3 v4

{-# NOINLINE ptr_glColor4us #-}
ptr_glColor4us :: FunPtr (GLushort -> GLushort -> GLushort -> GLushort -> IO ())
ptr_glColor4us = unsafePerformIO $ getCommand "glColor4us"

-- glColor4usv -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColor.xml OpenGL 2.x>.
glColor4usv
  :: MonadIO m
  => Ptr GLushort -- ^ @v@ pointing to @4@ elements of type @ColorUS@.
  -> m ()
glColor4usv v1 = liftIO $ dyn105 ptr_glColor4usv v1

{-# NOINLINE ptr_glColor4usv #-}
ptr_glColor4usv :: FunPtr (Ptr GLushort -> IO ())
ptr_glColor4usv = unsafePerformIO $ getCommand "glColor4usv"

-- glColor4x -------------------------------------------------------------------

glColor4x
  :: MonadIO m
  => GLfixed -- ^ @red@.
  -> GLfixed -- ^ @green@.
  -> GLfixed -- ^ @blue@.
  -> GLfixed -- ^ @alpha@.
  -> m ()
glColor4x v1 v2 v3 v4 = liftIO $ dyn50 ptr_glColor4x v1 v2 v3 v4

{-# NOINLINE ptr_glColor4x #-}
ptr_glColor4x :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glColor4x = unsafePerformIO $ getCommand "glColor4x"

-- glColor4xOES ----------------------------------------------------------------

glColor4xOES
  :: MonadIO m
  => GLfixed -- ^ @red@.
  -> GLfixed -- ^ @green@.
  -> GLfixed -- ^ @blue@.
  -> GLfixed -- ^ @alpha@.
  -> m ()
glColor4xOES v1 v2 v3 v4 = liftIO $ dyn50 ptr_glColor4xOES v1 v2 v3 v4

{-# NOINLINE ptr_glColor4xOES #-}
ptr_glColor4xOES :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glColor4xOES = unsafePerformIO $ getCommand "glColor4xOES"

-- glColor4xvOES ---------------------------------------------------------------

glColor4xvOES
  :: MonadIO m
  => Ptr GLfixed -- ^ @components@ pointing to @4@ elements of type @GLfixed@.
  -> m ()
glColor4xvOES v1 = liftIO $ dyn107 ptr_glColor4xvOES v1

{-# NOINLINE ptr_glColor4xvOES #-}
ptr_glColor4xvOES :: FunPtr (Ptr GLfixed -> IO ())
ptr_glColor4xvOES = unsafePerformIO $ getCommand "glColor4xvOES"

-- glColorFormatNV -------------------------------------------------------------

glColorFormatNV
  :: MonadIO m
  => GLint -- ^ @size@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @stride@.
  -> m ()
glColorFormatNV v1 v2 v3 = liftIO $ dyn119 ptr_glColorFormatNV v1 v2 v3

{-# NOINLINE ptr_glColorFormatNV #-}
ptr_glColorFormatNV :: FunPtr (GLint -> GLenum -> GLsizei -> IO ())
ptr_glColorFormatNV = unsafePerformIO $ getCommand "glColorFormatNV"

-- glColorFragmentOp1ATI -------------------------------------------------------

glColorFragmentOp1ATI
  :: MonadIO m
  => GLenum -- ^ @op@ of type @FragmentOpATI@.
  -> GLuint -- ^ @dst@.
  -> GLuint -- ^ @dstMask@.
  -> GLuint -- ^ @dstMod@.
  -> GLuint -- ^ @arg1@.
  -> GLuint -- ^ @arg1Rep@.
  -> GLuint -- ^ @arg1Mod@.
  -> m ()
glColorFragmentOp1ATI v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn120 ptr_glColorFragmentOp1ATI v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glColorFragmentOp1ATI #-}
ptr_glColorFragmentOp1ATI :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glColorFragmentOp1ATI = unsafePerformIO $ getCommand "glColorFragmentOp1ATI"

-- glColorFragmentOp2ATI -------------------------------------------------------

glColorFragmentOp2ATI
  :: MonadIO m
  => GLenum -- ^ @op@ of type @FragmentOpATI@.
  -> GLuint -- ^ @dst@.
  -> GLuint -- ^ @dstMask@.
  -> GLuint -- ^ @dstMod@.
  -> GLuint -- ^ @arg1@.
  -> GLuint -- ^ @arg1Rep@.
  -> GLuint -- ^ @arg1Mod@.
  -> GLuint -- ^ @arg2@.
  -> GLuint -- ^ @arg2Rep@.
  -> GLuint -- ^ @arg2Mod@.
  -> m ()
glColorFragmentOp2ATI v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn121 ptr_glColorFragmentOp2ATI v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

{-# NOINLINE ptr_glColorFragmentOp2ATI #-}
ptr_glColorFragmentOp2ATI :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glColorFragmentOp2ATI = unsafePerformIO $ getCommand "glColorFragmentOp2ATI"

-- glColorFragmentOp3ATI -------------------------------------------------------

glColorFragmentOp3ATI
  :: MonadIO m
  => GLenum -- ^ @op@ of type @FragmentOpATI@.
  -> GLuint -- ^ @dst@.
  -> GLuint -- ^ @dstMask@.
  -> GLuint -- ^ @dstMod@.
  -> GLuint -- ^ @arg1@.
  -> GLuint -- ^ @arg1Rep@.
  -> GLuint -- ^ @arg1Mod@.
  -> GLuint -- ^ @arg2@.
  -> GLuint -- ^ @arg2Rep@.
  -> GLuint -- ^ @arg2Mod@.
  -> GLuint -- ^ @arg3@.
  -> GLuint -- ^ @arg3Rep@.
  -> GLuint -- ^ @arg3Mod@.
  -> m ()
glColorFragmentOp3ATI v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 = liftIO $ dyn122 ptr_glColorFragmentOp3ATI v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13

{-# NOINLINE ptr_glColorFragmentOp3ATI #-}
ptr_glColorFragmentOp3ATI :: FunPtr (GLenum -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glColorFragmentOp3ATI = unsafePerformIO $ getCommand "glColorFragmentOp3ATI"

-- glColorMask -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glColorMask.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glColorMask.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glColorMask.xhtml OpenGL 4.x>.
glColorMask
  :: MonadIO m
  => GLboolean -- ^ @red@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @green@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @blue@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @alpha@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glColorMask v1 v2 v3 v4 = liftIO $ dyn123 ptr_glColorMask v1 v2 v3 v4

{-# NOINLINE ptr_glColorMask #-}
ptr_glColorMask :: FunPtr (GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
ptr_glColorMask = unsafePerformIO $ getCommand "glColorMask"

-- glColorMaskIndexedEXT -------------------------------------------------------

-- | This command is an alias for 'glColorMaski'.
glColorMaskIndexedEXT
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLboolean -- ^ @r@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @g@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @b@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @a@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glColorMaskIndexedEXT v1 v2 v3 v4 v5 = liftIO $ dyn124 ptr_glColorMaskIndexedEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glColorMaskIndexedEXT #-}
ptr_glColorMaskIndexedEXT :: FunPtr (GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
ptr_glColorMaskIndexedEXT = unsafePerformIO $ getCommand "glColorMaskIndexedEXT"

-- glColorMaski ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glColorMask.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glColorMask.xhtml OpenGL 4.x>.
glColorMaski
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLboolean -- ^ @r@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @g@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @b@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @a@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glColorMaski v1 v2 v3 v4 v5 = liftIO $ dyn124 ptr_glColorMaski v1 v2 v3 v4 v5

{-# NOINLINE ptr_glColorMaski #-}
ptr_glColorMaski :: FunPtr (GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
ptr_glColorMaski = unsafePerformIO $ getCommand "glColorMaski"

-- glColorMaskiEXT -------------------------------------------------------------

-- | This command is an alias for 'glColorMaski'.
glColorMaskiEXT
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLboolean -- ^ @r@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @g@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @b@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @a@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glColorMaskiEXT v1 v2 v3 v4 v5 = liftIO $ dyn124 ptr_glColorMaskiEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glColorMaskiEXT #-}
ptr_glColorMaskiEXT :: FunPtr (GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
ptr_glColorMaskiEXT = unsafePerformIO $ getCommand "glColorMaskiEXT"

-- glColorMaskiOES -------------------------------------------------------------

-- | This command is an alias for 'glColorMaski'.
glColorMaskiOES
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLboolean -- ^ @r@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @g@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @b@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @a@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glColorMaskiOES v1 v2 v3 v4 v5 = liftIO $ dyn124 ptr_glColorMaskiOES v1 v2 v3 v4 v5

{-# NOINLINE ptr_glColorMaskiOES #-}
ptr_glColorMaskiOES :: FunPtr (GLuint -> GLboolean -> GLboolean -> GLboolean -> GLboolean -> IO ())
ptr_glColorMaskiOES = unsafePerformIO $ getCommand "glColorMaskiOES"

-- glColorMaterial -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColorMaterial.xml OpenGL 2.x>.
glColorMaterial
  :: MonadIO m
  => GLenum -- ^ @face@ of type [MaterialFace](Graphics-GL-Groups.html#MaterialFace).
  -> GLenum -- ^ @mode@ of type [ColorMaterialParameter](Graphics-GL-Groups.html#ColorMaterialParameter).
  -> m ()
glColorMaterial v1 v2 = liftIO $ dyn51 ptr_glColorMaterial v1 v2

{-# NOINLINE ptr_glColorMaterial #-}
ptr_glColorMaterial :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glColorMaterial = unsafePerformIO $ getCommand "glColorMaterial"

-- glColorP3ui -----------------------------------------------------------------

glColorP3ui
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> GLuint -- ^ @color@.
  -> m ()
glColorP3ui v1 v2 = liftIO $ dyn16 ptr_glColorP3ui v1 v2

{-# NOINLINE ptr_glColorP3ui #-}
ptr_glColorP3ui :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glColorP3ui = unsafePerformIO $ getCommand "glColorP3ui"

-- glColorP3uiv ----------------------------------------------------------------

glColorP3uiv
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> Ptr GLuint -- ^ @color@ pointing to @1@ element of type @GLuint@.
  -> m ()
glColorP3uiv v1 v2 = liftIO $ dyn125 ptr_glColorP3uiv v1 v2

{-# NOINLINE ptr_glColorP3uiv #-}
ptr_glColorP3uiv :: FunPtr (GLenum -> Ptr GLuint -> IO ())
ptr_glColorP3uiv = unsafePerformIO $ getCommand "glColorP3uiv"

-- glColorP4ui -----------------------------------------------------------------

glColorP4ui
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> GLuint -- ^ @color@.
  -> m ()
glColorP4ui v1 v2 = liftIO $ dyn16 ptr_glColorP4ui v1 v2

{-# NOINLINE ptr_glColorP4ui #-}
ptr_glColorP4ui :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glColorP4ui = unsafePerformIO $ getCommand "glColorP4ui"

-- glColorP4uiv ----------------------------------------------------------------

glColorP4uiv
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> Ptr GLuint -- ^ @color@ pointing to @1@ element of type @GLuint@.
  -> m ()
glColorP4uiv v1 v2 = liftIO $ dyn125 ptr_glColorP4uiv v1 v2

{-# NOINLINE ptr_glColorP4uiv #-}
ptr_glColorP4uiv :: FunPtr (GLenum -> Ptr GLuint -> IO ())
ptr_glColorP4uiv = unsafePerformIO $ getCommand "glColorP4uiv"

-- glColorPointer --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColorPointer.xml OpenGL 2.x>.
glColorPointer
  :: MonadIO m
  => GLint -- ^ @size@.
  -> GLenum -- ^ @type@ of type [ColorPointerType](Graphics-GL-Groups.html#ColorPointerType).
  -> GLsizei -- ^ @stride@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(size,type,stride)@ elements of type @a@.
  -> m ()
glColorPointer v1 v2 v3 v4 = liftIO $ dyn126 ptr_glColorPointer v1 v2 v3 v4

{-# NOINLINE ptr_glColorPointer #-}
ptr_glColorPointer :: FunPtr (GLint -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glColorPointer = unsafePerformIO $ getCommand "glColorPointer"

-- glColorPointerEXT -----------------------------------------------------------

glColorPointerEXT
  :: MonadIO m
  => GLint -- ^ @size@.
  -> GLenum -- ^ @type@ of type [ColorPointerType](Graphics-GL-Groups.html#ColorPointerType).
  -> GLsizei -- ^ @stride@.
  -> GLsizei -- ^ @count@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(size,type,stride,count)@ elements of type @a@.
  -> m ()
glColorPointerEXT v1 v2 v3 v4 v5 = liftIO $ dyn127 ptr_glColorPointerEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glColorPointerEXT #-}
ptr_glColorPointerEXT :: FunPtr (GLint -> GLenum -> GLsizei -> GLsizei -> Ptr a -> IO ())
ptr_glColorPointerEXT = unsafePerformIO $ getCommand "glColorPointerEXT"

-- glColorPointerListIBM -------------------------------------------------------

glColorPointerListIBM
  :: MonadIO m
  => GLint -- ^ @size@.
  -> GLenum -- ^ @type@ of type [ColorPointerType](Graphics-GL-Groups.html#ColorPointerType).
  -> GLint -- ^ @stride@.
  -> Ptr (Ptr a) -- ^ @pointer@ pointing to @COMPSIZE(size,type,stride)@ elements of type @Ptr a@.
  -> GLint -- ^ @ptrstride@.
  -> m ()
glColorPointerListIBM v1 v2 v3 v4 v5 = liftIO $ dyn128 ptr_glColorPointerListIBM v1 v2 v3 v4 v5

{-# NOINLINE ptr_glColorPointerListIBM #-}
ptr_glColorPointerListIBM :: FunPtr (GLint -> GLenum -> GLint -> Ptr (Ptr a) -> GLint -> IO ())
ptr_glColorPointerListIBM = unsafePerformIO $ getCommand "glColorPointerListIBM"

-- glColorPointervINTEL --------------------------------------------------------

glColorPointervINTEL
  :: MonadIO m
  => GLint -- ^ @size@.
  -> GLenum -- ^ @type@ of type [VertexPointerType](Graphics-GL-Groups.html#VertexPointerType).
  -> Ptr (Ptr a) -- ^ @pointer@ pointing to @4@ elements of type @Ptr a@.
  -> m ()
glColorPointervINTEL v1 v2 v3 = liftIO $ dyn129 ptr_glColorPointervINTEL v1 v2 v3

{-# NOINLINE ptr_glColorPointervINTEL #-}
ptr_glColorPointervINTEL :: FunPtr (GLint -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glColorPointervINTEL = unsafePerformIO $ getCommand "glColorPointervINTEL"

-- glColorSubTable -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColorSubTable.xml OpenGL 2.x>.
glColorSubTable
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLsizei -- ^ @start@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type,count)@ elements of type @a@.
  -> m ()
glColorSubTable v1 v2 v3 v4 v5 v6 = liftIO $ dyn130 ptr_glColorSubTable v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glColorSubTable #-}
ptr_glColorSubTable :: FunPtr (GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glColorSubTable = unsafePerformIO $ getCommand "glColorSubTable"

-- glColorSubTableEXT ----------------------------------------------------------

-- | This command is an alias for 'glColorSubTable'.
glColorSubTableEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLsizei -- ^ @start@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(format,type,count)@ elements of type @a@.
  -> m ()
glColorSubTableEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn130 ptr_glColorSubTableEXT v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glColorSubTableEXT #-}
ptr_glColorSubTableEXT :: FunPtr (GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glColorSubTableEXT = unsafePerformIO $ getCommand "glColorSubTableEXT"

-- glColorTable ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColorTable.xml OpenGL 2.x>.
glColorTable
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @table@ pointing to @COMPSIZE(format,type,width)@ elements of type @a@.
  -> m ()
glColorTable v1 v2 v3 v4 v5 v6 = liftIO $ dyn131 ptr_glColorTable v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glColorTable #-}
ptr_glColorTable :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glColorTable = unsafePerformIO $ getCommand "glColorTable"

-- glColorTableEXT -------------------------------------------------------------

-- | This command is an alias for 'glColorTable'.
glColorTableEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @internalFormat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @table@ pointing to @COMPSIZE(format,type,width)@ elements of type @a@.
  -> m ()
glColorTableEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn131 ptr_glColorTableEXT v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glColorTableEXT #-}
ptr_glColorTableEXT :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glColorTableEXT = unsafePerformIO $ getCommand "glColorTableEXT"

-- glColorTableParameterfv -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColorTableParameter.xml OpenGL 2.x>.
glColorTableParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @pname@ of type @ColorTableParameterPName@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glColorTableParameterfv v1 v2 v3 = liftIO $ dyn132 ptr_glColorTableParameterfv v1 v2 v3

{-# NOINLINE ptr_glColorTableParameterfv #-}
ptr_glColorTableParameterfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glColorTableParameterfv = unsafePerformIO $ getCommand "glColorTableParameterfv"

-- glColorTableParameterfvSGI --------------------------------------------------

-- | This command is an alias for 'glColorTableParameterfv'.
glColorTableParameterfvSGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ColorTableTargetSGI](Graphics-GL-Groups.html#ColorTableTargetSGI).
  -> GLenum -- ^ @pname@ of type [ColorTableParameterPNameSGI](Graphics-GL-Groups.html#ColorTableParameterPNameSGI).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glColorTableParameterfvSGI v1 v2 v3 = liftIO $ dyn132 ptr_glColorTableParameterfvSGI v1 v2 v3

{-# NOINLINE ptr_glColorTableParameterfvSGI #-}
ptr_glColorTableParameterfvSGI :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glColorTableParameterfvSGI = unsafePerformIO $ getCommand "glColorTableParameterfvSGI"

-- glColorTableParameteriv -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glColorTableParameter.xml OpenGL 2.x>.
glColorTableParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @pname@ of type @ColorTableParameterPName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glColorTableParameteriv v1 v2 v3 = liftIO $ dyn133 ptr_glColorTableParameteriv v1 v2 v3

{-# NOINLINE ptr_glColorTableParameteriv #-}
ptr_glColorTableParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glColorTableParameteriv = unsafePerformIO $ getCommand "glColorTableParameteriv"

-- glColorTableParameterivSGI --------------------------------------------------

-- | This command is an alias for 'glColorTableParameteriv'.
glColorTableParameterivSGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ColorTableTargetSGI](Graphics-GL-Groups.html#ColorTableTargetSGI).
  -> GLenum -- ^ @pname@ of type [ColorTableParameterPNameSGI](Graphics-GL-Groups.html#ColorTableParameterPNameSGI).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glColorTableParameterivSGI v1 v2 v3 = liftIO $ dyn133 ptr_glColorTableParameterivSGI v1 v2 v3

{-# NOINLINE ptr_glColorTableParameterivSGI #-}
ptr_glColorTableParameterivSGI :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glColorTableParameterivSGI = unsafePerformIO $ getCommand "glColorTableParameterivSGI"

-- glColorTableSGI -------------------------------------------------------------

-- | This command is an alias for 'glColorTable'.
glColorTableSGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ColorTableTargetSGI](Graphics-GL-Groups.html#ColorTableTargetSGI).
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @table@ pointing to @COMPSIZE(format,type,width)@ elements of type @a@.
  -> m ()
glColorTableSGI v1 v2 v3 v4 v5 v6 = liftIO $ dyn131 ptr_glColorTableSGI v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glColorTableSGI #-}
ptr_glColorTableSGI :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glColorTableSGI = unsafePerformIO $ getCommand "glColorTableSGI"

-- glCombinerInputNV -----------------------------------------------------------

glCombinerInputNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @portion@ of type @CombinerPortionNV@.
  -> GLenum -- ^ @variable@ of type @CombinerVariableNV@.
  -> GLenum -- ^ @input@ of type @CombinerRegisterNV@.
  -> GLenum -- ^ @mapping@ of type @CombinerMappingNV@.
  -> GLenum -- ^ @componentUsage@ of type @CombinerComponentUsageNV@.
  -> m ()
glCombinerInputNV v1 v2 v3 v4 v5 v6 = liftIO $ dyn134 ptr_glCombinerInputNV v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glCombinerInputNV #-}
ptr_glCombinerInputNV :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glCombinerInputNV = unsafePerformIO $ getCommand "glCombinerInputNV"

-- glCombinerOutputNV ----------------------------------------------------------

glCombinerOutputNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @portion@ of type @CombinerPortionNV@.
  -> GLenum -- ^ @abOutput@ of type @CombinerRegisterNV@.
  -> GLenum -- ^ @cdOutput@ of type @CombinerRegisterNV@.
  -> GLenum -- ^ @sumOutput@ of type @CombinerRegisterNV@.
  -> GLenum -- ^ @scale@ of type @CombinerScaleNV@.
  -> GLenum -- ^ @bias@ of type @CombinerBiasNV@.
  -> GLboolean -- ^ @abDotProduct@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @cdDotProduct@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLboolean -- ^ @muxSum@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glCombinerOutputNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn135 ptr_glCombinerOutputNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

{-# NOINLINE ptr_glCombinerOutputNV #-}
ptr_glCombinerOutputNV :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLenum -> GLboolean -> GLboolean -> GLboolean -> IO ())
ptr_glCombinerOutputNV = unsafePerformIO $ getCommand "glCombinerOutputNV"

-- glCombinerParameterfNV ------------------------------------------------------

glCombinerParameterfNV
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> GLfloat -- ^ @param@.
  -> m ()
glCombinerParameterfNV v1 v2 = liftIO $ dyn0 ptr_glCombinerParameterfNV v1 v2

{-# NOINLINE ptr_glCombinerParameterfNV #-}
ptr_glCombinerParameterfNV :: FunPtr (GLenum -> GLfloat -> IO ())
ptr_glCombinerParameterfNV = unsafePerformIO $ getCommand "glCombinerParameterfNV"

-- glCombinerParameterfvNV -----------------------------------------------------

glCombinerParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glCombinerParameterfvNV v1 v2 = liftIO $ dyn94 ptr_glCombinerParameterfvNV v1 v2

{-# NOINLINE ptr_glCombinerParameterfvNV #-}
ptr_glCombinerParameterfvNV :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glCombinerParameterfvNV = unsafePerformIO $ getCommand "glCombinerParameterfvNV"

-- glCombinerParameteriNV ------------------------------------------------------

glCombinerParameteriNV
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> GLint -- ^ @param@.
  -> m ()
glCombinerParameteriNV v1 v2 = liftIO $ dyn55 ptr_glCombinerParameteriNV v1 v2

{-# NOINLINE ptr_glCombinerParameteriNV #-}
ptr_glCombinerParameteriNV :: FunPtr (GLenum -> GLint -> IO ())
ptr_glCombinerParameteriNV = unsafePerformIO $ getCommand "glCombinerParameteriNV"

-- glCombinerParameterivNV -----------------------------------------------------

glCombinerParameterivNV
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glCombinerParameterivNV v1 v2 = liftIO $ dyn136 ptr_glCombinerParameterivNV v1 v2

{-# NOINLINE ptr_glCombinerParameterivNV #-}
ptr_glCombinerParameterivNV :: FunPtr (GLenum -> Ptr GLint -> IO ())
ptr_glCombinerParameterivNV = unsafePerformIO $ getCommand "glCombinerParameterivNV"

-- glCombinerStageParameterfvNV ------------------------------------------------

glCombinerStageParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glCombinerStageParameterfvNV v1 v2 v3 = liftIO $ dyn132 ptr_glCombinerStageParameterfvNV v1 v2 v3

{-# NOINLINE ptr_glCombinerStageParameterfvNV #-}
ptr_glCombinerStageParameterfvNV :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glCombinerStageParameterfvNV = unsafePerformIO $ getCommand "glCombinerStageParameterfvNV"

-- glCommandListSegmentsNV -----------------------------------------------------

glCommandListSegmentsNV
  :: MonadIO m
  => GLuint -- ^ @list@.
  -> GLuint -- ^ @segments@.
  -> m ()
glCommandListSegmentsNV v1 v2 = liftIO $ dyn3 ptr_glCommandListSegmentsNV v1 v2

{-# NOINLINE ptr_glCommandListSegmentsNV #-}
ptr_glCommandListSegmentsNV :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glCommandListSegmentsNV = unsafePerformIO $ getCommand "glCommandListSegmentsNV"

-- glCompileCommandListNV ------------------------------------------------------

glCompileCommandListNV
  :: MonadIO m
  => GLuint -- ^ @list@.
  -> m ()
glCompileCommandListNV v1 = liftIO $ dyn2 ptr_glCompileCommandListNV v1

{-# NOINLINE ptr_glCompileCommandListNV #-}
ptr_glCompileCommandListNV :: FunPtr (GLuint -> IO ())
ptr_glCompileCommandListNV = unsafePerformIO $ getCommand "glCompileCommandListNV"

-- glCompileShader -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCompileShader.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCompileShader.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCompileShader.xhtml OpenGL 4.x>.
glCompileShader
  :: MonadIO m
  => GLuint -- ^ @shader@.
  -> m ()
glCompileShader v1 = liftIO $ dyn2 ptr_glCompileShader v1

{-# NOINLINE ptr_glCompileShader #-}
ptr_glCompileShader :: FunPtr (GLuint -> IO ())
ptr_glCompileShader = unsafePerformIO $ getCommand "glCompileShader"

-- glCompileShaderARB ----------------------------------------------------------

-- | This command is an alias for 'glCompileShader'.
glCompileShaderARB
  :: MonadIO m
  => GLhandleARB -- ^ @shaderObj@ of type @handleARB@.
  -> m ()
glCompileShaderARB v1 = liftIO $ dyn137 ptr_glCompileShaderARB v1

{-# NOINLINE ptr_glCompileShaderARB #-}
ptr_glCompileShaderARB :: FunPtr (GLhandleARB -> IO ())
ptr_glCompileShaderARB = unsafePerformIO $ getCommand "glCompileShaderARB"

-- glCompileShaderIncludeARB ---------------------------------------------------

glCompileShaderIncludeARB
  :: MonadIO m
  => GLuint -- ^ @shader@.
  -> GLsizei -- ^ @count@.
  -> Ptr (Ptr GLchar) -- ^ @path@ pointing to @count@ elements of type @Ptr GLchar@.
  -> Ptr GLint -- ^ @length@ pointing to @count@ elements of type @GLint@.
  -> m ()
glCompileShaderIncludeARB v1 v2 v3 v4 = liftIO $ dyn138 ptr_glCompileShaderIncludeARB v1 v2 v3 v4

{-# NOINLINE ptr_glCompileShaderIncludeARB #-}
ptr_glCompileShaderIncludeARB :: FunPtr (GLuint -> GLsizei -> Ptr (Ptr GLchar) -> Ptr GLint -> IO ())
ptr_glCompileShaderIncludeARB = unsafePerformIO $ getCommand "glCompileShaderIncludeARB"

-- glCompressedMultiTexImage1DEXT ----------------------------------------------

glCompressedMultiTexImage1DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedMultiTexImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn139 ptr_glCompressedMultiTexImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glCompressedMultiTexImage1DEXT #-}
ptr_glCompressedMultiTexImage1DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedMultiTexImage1DEXT = unsafePerformIO $ getCommand "glCompressedMultiTexImage1DEXT"

-- glCompressedMultiTexImage2DEXT ----------------------------------------------

glCompressedMultiTexImage2DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedMultiTexImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn140 ptr_glCompressedMultiTexImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCompressedMultiTexImage2DEXT #-}
ptr_glCompressedMultiTexImage2DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedMultiTexImage2DEXT = unsafePerformIO $ getCommand "glCompressedMultiTexImage2DEXT"

-- glCompressedMultiTexImage3DEXT ----------------------------------------------

glCompressedMultiTexImage3DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedMultiTexImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn141 ptr_glCompressedMultiTexImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

{-# NOINLINE ptr_glCompressedMultiTexImage3DEXT #-}
ptr_glCompressedMultiTexImage3DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedMultiTexImage3DEXT = unsafePerformIO $ getCommand "glCompressedMultiTexImage3DEXT"

-- glCompressedMultiTexSubImage1DEXT -------------------------------------------

glCompressedMultiTexSubImage1DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedMultiTexSubImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn142 ptr_glCompressedMultiTexSubImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glCompressedMultiTexSubImage1DEXT #-}
ptr_glCompressedMultiTexSubImage1DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedMultiTexSubImage1DEXT = unsafePerformIO $ getCommand "glCompressedMultiTexSubImage1DEXT"

-- glCompressedMultiTexSubImage2DEXT -------------------------------------------

glCompressedMultiTexSubImage2DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedMultiTexSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn143 ptr_glCompressedMultiTexSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

{-# NOINLINE ptr_glCompressedMultiTexSubImage2DEXT #-}
ptr_glCompressedMultiTexSubImage2DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedMultiTexSubImage2DEXT = unsafePerformIO $ getCommand "glCompressedMultiTexSubImage2DEXT"

-- glCompressedMultiTexSubImage3DEXT -------------------------------------------

glCompressedMultiTexSubImage3DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedMultiTexSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 = liftIO $ dyn144 ptr_glCompressedMultiTexSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12

{-# NOINLINE ptr_glCompressedMultiTexSubImage3DEXT #-}
ptr_glCompressedMultiTexSubImage3DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedMultiTexSubImage3DEXT = unsafePerformIO $ getCommand "glCompressedMultiTexSubImage3DEXT"

-- glCompressedTexImage1D ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexImage1D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexImage1D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexImage1D.xhtml OpenGL 4.x>.
glCompressedTexImage1D
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexImage1D v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn145 ptr_glCompressedTexImage1D v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glCompressedTexImage1D #-}
ptr_glCompressedTexImage1D :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexImage1D = unsafePerformIO $ getCommand "glCompressedTexImage1D"

-- glCompressedTexImage1DARB ---------------------------------------------------

-- | This command is an alias for 'glCompressedTexImage1D'.
glCompressedTexImage1DARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexImage1DARB v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn145 ptr_glCompressedTexImage1DARB v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glCompressedTexImage1DARB #-}
ptr_glCompressedTexImage1DARB :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexImage1DARB = unsafePerformIO $ getCommand "glCompressedTexImage1DARB"

-- glCompressedTexImage2D ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexImage2D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexImage2D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexImage2D.xhtml OpenGL 4.x>.
glCompressedTexImage2D
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexImage2D v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn146 ptr_glCompressedTexImage2D v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glCompressedTexImage2D #-}
ptr_glCompressedTexImage2D :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexImage2D = unsafePerformIO $ getCommand "glCompressedTexImage2D"

-- glCompressedTexImage2DARB ---------------------------------------------------

-- | This command is an alias for 'glCompressedTexImage2D'.
glCompressedTexImage2DARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexImage2DARB v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn146 ptr_glCompressedTexImage2DARB v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glCompressedTexImage2DARB #-}
ptr_glCompressedTexImage2DARB :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexImage2DARB = unsafePerformIO $ getCommand "glCompressedTexImage2DARB"

-- glCompressedTexImage3D ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexImage3D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexImage3D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexImage3D.xhtml OpenGL 4.x>.
glCompressedTexImage3D
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn147 ptr_glCompressedTexImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCompressedTexImage3D #-}
ptr_glCompressedTexImage3D :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexImage3D = unsafePerformIO $ getCommand "glCompressedTexImage3D"

-- glCompressedTexImage3DARB ---------------------------------------------------

-- | This command is an alias for 'glCompressedTexImage3D'.
glCompressedTexImage3DARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexImage3DARB v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn147 ptr_glCompressedTexImage3DARB v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCompressedTexImage3DARB #-}
ptr_glCompressedTexImage3DARB :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexImage3DARB = unsafePerformIO $ getCommand "glCompressedTexImage3DARB"

-- glCompressedTexImage3DOES ---------------------------------------------------

-- | This command is an alias for 'glCompressedTexImage3D'.
glCompressedTexImage3DOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLint -- ^ @level@.
  -> GLenum -- ^ @internalformat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLint -- ^ @border@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTexImage3DOES v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn147 ptr_glCompressedTexImage3DOES v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCompressedTexImage3DOES #-}
ptr_glCompressedTexImage3DOES :: FunPtr (GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexImage3DOES = unsafePerformIO $ getCommand "glCompressedTexImage3DOES"

-- glCompressedTexSubImage1D ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexSubImage1D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexSubImage1D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexSubImage1D.xhtml OpenGL 4.x>.
glCompressedTexSubImage1D
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexSubImage1D v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn148 ptr_glCompressedTexSubImage1D v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glCompressedTexSubImage1D #-}
ptr_glCompressedTexSubImage1D :: FunPtr (GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexSubImage1D = unsafePerformIO $ getCommand "glCompressedTexSubImage1D"

-- glCompressedTexSubImage1DARB ------------------------------------------------

-- | This command is an alias for 'glCompressedTexSubImage1D'.
glCompressedTexSubImage1DARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexSubImage1DARB v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn148 ptr_glCompressedTexSubImage1DARB v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glCompressedTexSubImage1DARB #-}
ptr_glCompressedTexSubImage1DARB :: FunPtr (GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexSubImage1DARB = unsafePerformIO $ getCommand "glCompressedTexSubImage1DARB"

-- glCompressedTexSubImage2D ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexSubImage2D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexSubImage2D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexSubImage2D.xhtml OpenGL 4.x>.
glCompressedTexSubImage2D
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexSubImage2D v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn149 ptr_glCompressedTexSubImage2D v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCompressedTexSubImage2D #-}
ptr_glCompressedTexSubImage2D :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexSubImage2D = unsafePerformIO $ getCommand "glCompressedTexSubImage2D"

-- glCompressedTexSubImage2DARB ------------------------------------------------

-- | This command is an alias for 'glCompressedTexSubImage2D'.
glCompressedTexSubImage2DARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexSubImage2DARB v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn149 ptr_glCompressedTexSubImage2DARB v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCompressedTexSubImage2DARB #-}
ptr_glCompressedTexSubImage2DARB :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexSubImage2DARB = unsafePerformIO $ getCommand "glCompressedTexSubImage2DARB"

-- glCompressedTexSubImage3D ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCompressedTexSubImage3D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCompressedTexSubImage3D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexSubImage3D.xhtml OpenGL 4.x>.
glCompressedTexSubImage3D
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn150 ptr_glCompressedTexSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

{-# NOINLINE ptr_glCompressedTexSubImage3D #-}
ptr_glCompressedTexSubImage3D :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexSubImage3D = unsafePerformIO $ getCommand "glCompressedTexSubImage3D"

-- glCompressedTexSubImage3DARB ------------------------------------------------

-- | This command is an alias for 'glCompressedTexSubImage3D'.
glCompressedTexSubImage3DARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @CompressedTextureARB@.
  -> m ()
glCompressedTexSubImage3DARB v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn150 ptr_glCompressedTexSubImage3DARB v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

{-# NOINLINE ptr_glCompressedTexSubImage3DARB #-}
ptr_glCompressedTexSubImage3DARB :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexSubImage3DARB = unsafePerformIO $ getCommand "glCompressedTexSubImage3DARB"

-- glCompressedTexSubImage3DOES ------------------------------------------------

-- | This command is an alias for 'glCompressedTexSubImage3D'.
glCompressedTexSubImage3DOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTexSubImage3DOES v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn150 ptr_glCompressedTexSubImage3DOES v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

{-# NOINLINE ptr_glCompressedTexSubImage3DOES #-}
ptr_glCompressedTexSubImage3DOES :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTexSubImage3DOES = unsafePerformIO $ getCommand "glCompressedTexSubImage3DOES"

-- glCompressedTextureImage1DEXT -----------------------------------------------

glCompressedTextureImage1DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTextureImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn151 ptr_glCompressedTextureImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glCompressedTextureImage1DEXT #-}
ptr_glCompressedTextureImage1DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureImage1DEXT = unsafePerformIO $ getCommand "glCompressedTextureImage1DEXT"

-- glCompressedTextureImage2DEXT -----------------------------------------------

glCompressedTextureImage2DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTextureImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn152 ptr_glCompressedTextureImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCompressedTextureImage2DEXT #-}
ptr_glCompressedTextureImage2DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureImage2DEXT = unsafePerformIO $ getCommand "glCompressedTextureImage2DEXT"

-- glCompressedTextureImage3DEXT -----------------------------------------------

glCompressedTextureImage3DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTextureImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn153 ptr_glCompressedTextureImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

{-# NOINLINE ptr_glCompressedTextureImage3DEXT #-}
ptr_glCompressedTextureImage3DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLsizei -> GLsizei -> GLsizei -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureImage3DEXT = unsafePerformIO $ getCommand "glCompressedTextureImage3DEXT"

-- glCompressedTextureSubImage1D -----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexSubImage1D.xhtml OpenGL 4.x>.
glCompressedTextureSubImage1D
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@.
  -> m ()
glCompressedTextureSubImage1D v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn154 ptr_glCompressedTextureSubImage1D v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glCompressedTextureSubImage1D #-}
ptr_glCompressedTextureSubImage1D :: FunPtr (GLuint -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureSubImage1D = unsafePerformIO $ getCommand "glCompressedTextureSubImage1D"

-- glCompressedTextureSubImage1DEXT --------------------------------------------

glCompressedTextureSubImage1DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTextureSubImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn155 ptr_glCompressedTextureSubImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glCompressedTextureSubImage1DEXT #-}
ptr_glCompressedTextureSubImage1DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureSubImage1DEXT = unsafePerformIO $ getCommand "glCompressedTextureSubImage1DEXT"

-- glCompressedTextureSubImage2D -----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexSubImage2D.xhtml OpenGL 4.x>.
glCompressedTextureSubImage2D
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@.
  -> m ()
glCompressedTextureSubImage2D v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn156 ptr_glCompressedTextureSubImage2D v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCompressedTextureSubImage2D #-}
ptr_glCompressedTextureSubImage2D :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureSubImage2D = unsafePerformIO $ getCommand "glCompressedTextureSubImage2D"

-- glCompressedTextureSubImage2DEXT --------------------------------------------

glCompressedTextureSubImage2DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTextureSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn157 ptr_glCompressedTextureSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

{-# NOINLINE ptr_glCompressedTextureSubImage2DEXT #-}
ptr_glCompressedTextureSubImage2DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureSubImage2DEXT = unsafePerformIO $ getCommand "glCompressedTextureSubImage2DEXT"

-- glCompressedTextureSubImage3D -----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCompressedTexSubImage3D.xhtml OpenGL 4.x>.
glCompressedTextureSubImage3D
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@.
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @data@.
  -> m ()
glCompressedTextureSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn158 ptr_glCompressedTextureSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

{-# NOINLINE ptr_glCompressedTextureSubImage3D #-}
ptr_glCompressedTextureSubImage3D :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureSubImage3D = unsafePerformIO $ getCommand "glCompressedTextureSubImage3D"

-- glCompressedTextureSubImage3DEXT --------------------------------------------

glCompressedTextureSubImage3DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLsizei -- ^ @imageSize@.
  -> Ptr a -- ^ @bits@ pointing to @imageSize@ elements of type @a@.
  -> m ()
glCompressedTextureSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 = liftIO $ dyn159 ptr_glCompressedTextureSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12

{-# NOINLINE ptr_glCompressedTextureSubImage3DEXT #-}
ptr_glCompressedTextureSubImage3DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glCompressedTextureSubImage3DEXT = unsafePerformIO $ getCommand "glCompressedTextureSubImage3DEXT"

-- glConservativeRasterParameterfNV --------------------------------------------

glConservativeRasterParameterfNV
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> GLfloat -- ^ @value@.
  -> m ()
glConservativeRasterParameterfNV v1 v2 = liftIO $ dyn0 ptr_glConservativeRasterParameterfNV v1 v2

{-# NOINLINE ptr_glConservativeRasterParameterfNV #-}
ptr_glConservativeRasterParameterfNV :: FunPtr (GLenum -> GLfloat -> IO ())
ptr_glConservativeRasterParameterfNV = unsafePerformIO $ getCommand "glConservativeRasterParameterfNV"

-- glConvolutionFilter1D -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionFilter1D.xml OpenGL 2.x>.
glConvolutionFilter1D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @image@ pointing to @COMPSIZE(format,type,width)@ elements of type @a@.
  -> m ()
glConvolutionFilter1D v1 v2 v3 v4 v5 v6 = liftIO $ dyn131 ptr_glConvolutionFilter1D v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glConvolutionFilter1D #-}
ptr_glConvolutionFilter1D :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glConvolutionFilter1D = unsafePerformIO $ getCommand "glConvolutionFilter1D"

-- glConvolutionFilter1DEXT ----------------------------------------------------

-- | This command is an alias for 'glConvolutionFilter1D'.
glConvolutionFilter1DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ConvolutionTargetEXT](Graphics-GL-Groups.html#ConvolutionTargetEXT).
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @image@ pointing to @COMPSIZE(format,type,width)@ elements of type @a@.
  -> m ()
glConvolutionFilter1DEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn131 ptr_glConvolutionFilter1DEXT v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glConvolutionFilter1DEXT #-}
ptr_glConvolutionFilter1DEXT :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glConvolutionFilter1DEXT = unsafePerformIO $ getCommand "glConvolutionFilter1DEXT"

-- glConvolutionFilter2D -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionFilter2D.xml OpenGL 2.x>.
glConvolutionFilter2D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @image@ pointing to @COMPSIZE(format,type,width,height)@ elements of type @a@.
  -> m ()
glConvolutionFilter2D v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn160 ptr_glConvolutionFilter2D v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glConvolutionFilter2D #-}
ptr_glConvolutionFilter2D :: FunPtr (GLenum -> GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glConvolutionFilter2D = unsafePerformIO $ getCommand "glConvolutionFilter2D"

-- glConvolutionFilter2DEXT ----------------------------------------------------

-- | This command is an alias for 'glConvolutionFilter2D'.
glConvolutionFilter2DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ConvolutionTargetEXT](Graphics-GL-Groups.html#ConvolutionTargetEXT).
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @image@ pointing to @COMPSIZE(format,type,width,height)@ elements of type @a@.
  -> m ()
glConvolutionFilter2DEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn160 ptr_glConvolutionFilter2DEXT v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glConvolutionFilter2DEXT #-}
ptr_glConvolutionFilter2DEXT :: FunPtr (GLenum -> GLenum -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glConvolutionFilter2DEXT = unsafePerformIO $ getCommand "glConvolutionFilter2DEXT"

-- glConvolutionParameterf -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionParameter.xml OpenGL 2.x>.
glConvolutionParameterf
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @pname@ of type @ConvolutionParameter@.
  -> GLfloat -- ^ @params@ of type @CheckedFloat32@.
  -> m ()
glConvolutionParameterf v1 v2 v3 = liftIO $ dyn161 ptr_glConvolutionParameterf v1 v2 v3

{-# NOINLINE ptr_glConvolutionParameterf #-}
ptr_glConvolutionParameterf :: FunPtr (GLenum -> GLenum -> GLfloat -> IO ())
ptr_glConvolutionParameterf = unsafePerformIO $ getCommand "glConvolutionParameterf"

-- glConvolutionParameterfEXT --------------------------------------------------

-- | This command is an alias for 'glConvolutionParameterf'.
glConvolutionParameterfEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ConvolutionTargetEXT](Graphics-GL-Groups.html#ConvolutionTargetEXT).
  -> GLenum -- ^ @pname@ of type [ConvolutionParameterEXT](Graphics-GL-Groups.html#ConvolutionParameterEXT).
  -> GLfloat -- ^ @params@ of type @CheckedFloat32@.
  -> m ()
glConvolutionParameterfEXT v1 v2 v3 = liftIO $ dyn161 ptr_glConvolutionParameterfEXT v1 v2 v3

{-# NOINLINE ptr_glConvolutionParameterfEXT #-}
ptr_glConvolutionParameterfEXT :: FunPtr (GLenum -> GLenum -> GLfloat -> IO ())
ptr_glConvolutionParameterfEXT = unsafePerformIO $ getCommand "glConvolutionParameterfEXT"

-- glConvolutionParameterfv ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionParameter.xml OpenGL 2.x>.
glConvolutionParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @pname@ of type @ConvolutionParameter@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glConvolutionParameterfv v1 v2 v3 = liftIO $ dyn132 ptr_glConvolutionParameterfv v1 v2 v3

{-# NOINLINE ptr_glConvolutionParameterfv #-}
ptr_glConvolutionParameterfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glConvolutionParameterfv = unsafePerformIO $ getCommand "glConvolutionParameterfv"

-- glConvolutionParameterfvEXT -------------------------------------------------

-- | This command is an alias for 'glConvolutionParameterfv'.
glConvolutionParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ConvolutionTargetEXT](Graphics-GL-Groups.html#ConvolutionTargetEXT).
  -> GLenum -- ^ @pname@ of type [ConvolutionParameterEXT](Graphics-GL-Groups.html#ConvolutionParameterEXT).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glConvolutionParameterfvEXT v1 v2 v3 = liftIO $ dyn132 ptr_glConvolutionParameterfvEXT v1 v2 v3

{-# NOINLINE ptr_glConvolutionParameterfvEXT #-}
ptr_glConvolutionParameterfvEXT :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glConvolutionParameterfvEXT = unsafePerformIO $ getCommand "glConvolutionParameterfvEXT"

-- glConvolutionParameteri -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionParameter.xml OpenGL 2.x>.
glConvolutionParameteri
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @pname@ of type @ConvolutionParameter@.
  -> GLint -- ^ @params@ of type @CheckedInt32@.
  -> m ()
glConvolutionParameteri v1 v2 v3 = liftIO $ dyn62 ptr_glConvolutionParameteri v1 v2 v3

{-# NOINLINE ptr_glConvolutionParameteri #-}
ptr_glConvolutionParameteri :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glConvolutionParameteri = unsafePerformIO $ getCommand "glConvolutionParameteri"

-- glConvolutionParameteriEXT --------------------------------------------------

-- | This command is an alias for 'glConvolutionParameteri'.
glConvolutionParameteriEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ConvolutionTargetEXT](Graphics-GL-Groups.html#ConvolutionTargetEXT).
  -> GLenum -- ^ @pname@ of type [ConvolutionParameterEXT](Graphics-GL-Groups.html#ConvolutionParameterEXT).
  -> GLint -- ^ @params@ of type @CheckedInt32@.
  -> m ()
glConvolutionParameteriEXT v1 v2 v3 = liftIO $ dyn62 ptr_glConvolutionParameteriEXT v1 v2 v3

{-# NOINLINE ptr_glConvolutionParameteriEXT #-}
ptr_glConvolutionParameteriEXT :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glConvolutionParameteriEXT = unsafePerformIO $ getCommand "glConvolutionParameteriEXT"

-- glConvolutionParameteriv ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glConvolutionParameter.xml OpenGL 2.x>.
glConvolutionParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @pname@ of type @ConvolutionParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glConvolutionParameteriv v1 v2 v3 = liftIO $ dyn133 ptr_glConvolutionParameteriv v1 v2 v3

{-# NOINLINE ptr_glConvolutionParameteriv #-}
ptr_glConvolutionParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glConvolutionParameteriv = unsafePerformIO $ getCommand "glConvolutionParameteriv"

-- glConvolutionParameterivEXT -------------------------------------------------

-- | This command is an alias for 'glConvolutionParameteriv'.
glConvolutionParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ConvolutionTargetEXT](Graphics-GL-Groups.html#ConvolutionTargetEXT).
  -> GLenum -- ^ @pname@ of type [ConvolutionParameterEXT](Graphics-GL-Groups.html#ConvolutionParameterEXT).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glConvolutionParameterivEXT v1 v2 v3 = liftIO $ dyn133 ptr_glConvolutionParameterivEXT v1 v2 v3

{-# NOINLINE ptr_glConvolutionParameterivEXT #-}
ptr_glConvolutionParameterivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glConvolutionParameterivEXT = unsafePerformIO $ getCommand "glConvolutionParameterivEXT"

-- glConvolutionParameterxOES --------------------------------------------------

glConvolutionParameterxOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> GLfixed -- ^ @param@.
  -> m ()
glConvolutionParameterxOES v1 v2 v3 = liftIO $ dyn162 ptr_glConvolutionParameterxOES v1 v2 v3

{-# NOINLINE ptr_glConvolutionParameterxOES #-}
ptr_glConvolutionParameterxOES :: FunPtr (GLenum -> GLenum -> GLfixed -> IO ())
ptr_glConvolutionParameterxOES = unsafePerformIO $ getCommand "glConvolutionParameterxOES"

-- glConvolutionParameterxvOES -------------------------------------------------

glConvolutionParameterxvOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glConvolutionParameterxvOES v1 v2 v3 = liftIO $ dyn163 ptr_glConvolutionParameterxvOES v1 v2 v3

{-# NOINLINE ptr_glConvolutionParameterxvOES #-}
ptr_glConvolutionParameterxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glConvolutionParameterxvOES = unsafePerformIO $ getCommand "glConvolutionParameterxvOES"

-- glCopyBufferSubData ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glCopyBufferSubData.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCopyBufferSubData.xhtml OpenGL 4.x>.
glCopyBufferSubData
  :: MonadIO m
  => GLenum -- ^ @readTarget@.
  -> GLenum -- ^ @writeTarget@.
  -> GLintptr -- ^ @readOffset@ of type @BufferOffset@.
  -> GLintptr -- ^ @writeOffset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> m ()
glCopyBufferSubData v1 v2 v3 v4 v5 = liftIO $ dyn164 ptr_glCopyBufferSubData v1 v2 v3 v4 v5

{-# NOINLINE ptr_glCopyBufferSubData #-}
ptr_glCopyBufferSubData :: FunPtr (GLenum -> GLenum -> GLintptr -> GLintptr -> GLsizeiptr -> IO ())
ptr_glCopyBufferSubData = unsafePerformIO $ getCommand "glCopyBufferSubData"

-- glCopyBufferSubDataNV -------------------------------------------------------

-- | This command is an alias for 'glCopyBufferSubData'.
glCopyBufferSubDataNV
  :: MonadIO m
  => GLenum -- ^ @readTarget@.
  -> GLenum -- ^ @writeTarget@.
  -> GLintptr -- ^ @readOffset@ of type @BufferOffset@.
  -> GLintptr -- ^ @writeOffset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> m ()
glCopyBufferSubDataNV v1 v2 v3 v4 v5 = liftIO $ dyn164 ptr_glCopyBufferSubDataNV v1 v2 v3 v4 v5

{-# NOINLINE ptr_glCopyBufferSubDataNV #-}
ptr_glCopyBufferSubDataNV :: FunPtr (GLenum -> GLenum -> GLintptr -> GLintptr -> GLsizeiptr -> IO ())
ptr_glCopyBufferSubDataNV = unsafePerformIO $ getCommand "glCopyBufferSubDataNV"

-- glCopyColorSubTable ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyColorSubTable.xml OpenGL 2.x>.
glCopyColorSubTable
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLsizei -- ^ @start@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyColorSubTable v1 v2 v3 v4 v5 = liftIO $ dyn165 ptr_glCopyColorSubTable v1 v2 v3 v4 v5

{-# NOINLINE ptr_glCopyColorSubTable #-}
ptr_glCopyColorSubTable :: FunPtr (GLenum -> GLsizei -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyColorSubTable = unsafePerformIO $ getCommand "glCopyColorSubTable"

-- glCopyColorSubTableEXT ------------------------------------------------------

-- | This command is an alias for 'glCopyColorSubTable'.
glCopyColorSubTableEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLsizei -- ^ @start@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyColorSubTableEXT v1 v2 v3 v4 v5 = liftIO $ dyn165 ptr_glCopyColorSubTableEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glCopyColorSubTableEXT #-}
ptr_glCopyColorSubTableEXT :: FunPtr (GLenum -> GLsizei -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyColorSubTableEXT = unsafePerformIO $ getCommand "glCopyColorSubTableEXT"

-- glCopyColorTable ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyColorTable.xml OpenGL 2.x>.
glCopyColorTable
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyColorTable v1 v2 v3 v4 v5 = liftIO $ dyn166 ptr_glCopyColorTable v1 v2 v3 v4 v5

{-# NOINLINE ptr_glCopyColorTable #-}
ptr_glCopyColorTable :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyColorTable = unsafePerformIO $ getCommand "glCopyColorTable"

-- glCopyColorTableSGI ---------------------------------------------------------

-- | This command is an alias for 'glCopyColorTable'.
glCopyColorTableSGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ColorTableTargetSGI](Graphics-GL-Groups.html#ColorTableTargetSGI).
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyColorTableSGI v1 v2 v3 v4 v5 = liftIO $ dyn166 ptr_glCopyColorTableSGI v1 v2 v3 v4 v5

{-# NOINLINE ptr_glCopyColorTableSGI #-}
ptr_glCopyColorTableSGI :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyColorTableSGI = unsafePerformIO $ getCommand "glCopyColorTableSGI"

-- glCopyConvolutionFilter1D ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyConvolutionFilter1D.xml OpenGL 2.x>.
glCopyConvolutionFilter1D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyConvolutionFilter1D v1 v2 v3 v4 v5 = liftIO $ dyn166 ptr_glCopyConvolutionFilter1D v1 v2 v3 v4 v5

{-# NOINLINE ptr_glCopyConvolutionFilter1D #-}
ptr_glCopyConvolutionFilter1D :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyConvolutionFilter1D = unsafePerformIO $ getCommand "glCopyConvolutionFilter1D"

-- glCopyConvolutionFilter1DEXT ------------------------------------------------

-- | This command is an alias for 'glCopyConvolutionFilter1D'.
glCopyConvolutionFilter1DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ConvolutionTargetEXT](Graphics-GL-Groups.html#ConvolutionTargetEXT).
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyConvolutionFilter1DEXT v1 v2 v3 v4 v5 = liftIO $ dyn166 ptr_glCopyConvolutionFilter1DEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glCopyConvolutionFilter1DEXT #-}
ptr_glCopyConvolutionFilter1DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyConvolutionFilter1DEXT = unsafePerformIO $ getCommand "glCopyConvolutionFilter1DEXT"

-- glCopyConvolutionFilter2D ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyConvolutionFilter2D.xml OpenGL 2.x>.
glCopyConvolutionFilter2D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyConvolutionFilter2D v1 v2 v3 v4 v5 v6 = liftIO $ dyn167 ptr_glCopyConvolutionFilter2D v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glCopyConvolutionFilter2D #-}
ptr_glCopyConvolutionFilter2D :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyConvolutionFilter2D = unsafePerformIO $ getCommand "glCopyConvolutionFilter2D"

-- glCopyConvolutionFilter2DEXT ------------------------------------------------

-- | This command is an alias for 'glCopyConvolutionFilter2D'.
glCopyConvolutionFilter2DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ConvolutionTargetEXT](Graphics-GL-Groups.html#ConvolutionTargetEXT).
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyConvolutionFilter2DEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn167 ptr_glCopyConvolutionFilter2DEXT v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glCopyConvolutionFilter2DEXT #-}
ptr_glCopyConvolutionFilter2DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyConvolutionFilter2DEXT = unsafePerformIO $ getCommand "glCopyConvolutionFilter2DEXT"

-- glCopyImageSubData ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCopyImageSubData.xhtml OpenGL 4.x>.
glCopyImageSubData
  :: MonadIO m
  => GLuint -- ^ @srcName@.
  -> GLenum -- ^ @srcTarget@.
  -> GLint -- ^ @srcLevel@.
  -> GLint -- ^ @srcX@.
  -> GLint -- ^ @srcY@.
  -> GLint -- ^ @srcZ@.
  -> GLuint -- ^ @dstName@.
  -> GLenum -- ^ @dstTarget@.
  -> GLint -- ^ @dstLevel@.
  -> GLint -- ^ @dstX@.
  -> GLint -- ^ @dstY@.
  -> GLint -- ^ @dstZ@.
  -> GLsizei -- ^ @srcWidth@.
  -> GLsizei -- ^ @srcHeight@.
  -> GLsizei -- ^ @srcDepth@.
  -> m ()
glCopyImageSubData v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 = liftIO $ dyn168 ptr_glCopyImageSubData v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15

{-# NOINLINE ptr_glCopyImageSubData #-}
ptr_glCopyImageSubData :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ())
ptr_glCopyImageSubData = unsafePerformIO $ getCommand "glCopyImageSubData"

-- glCopyImageSubDataEXT -------------------------------------------------------

-- | This command is an alias for 'glCopyImageSubData'.
glCopyImageSubDataEXT
  :: MonadIO m
  => GLuint -- ^ @srcName@.
  -> GLenum -- ^ @srcTarget@.
  -> GLint -- ^ @srcLevel@.
  -> GLint -- ^ @srcX@.
  -> GLint -- ^ @srcY@.
  -> GLint -- ^ @srcZ@.
  -> GLuint -- ^ @dstName@.
  -> GLenum -- ^ @dstTarget@.
  -> GLint -- ^ @dstLevel@.
  -> GLint -- ^ @dstX@.
  -> GLint -- ^ @dstY@.
  -> GLint -- ^ @dstZ@.
  -> GLsizei -- ^ @srcWidth@.
  -> GLsizei -- ^ @srcHeight@.
  -> GLsizei -- ^ @srcDepth@.
  -> m ()
glCopyImageSubDataEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 = liftIO $ dyn168 ptr_glCopyImageSubDataEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15

{-# NOINLINE ptr_glCopyImageSubDataEXT #-}
ptr_glCopyImageSubDataEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ())
ptr_glCopyImageSubDataEXT = unsafePerformIO $ getCommand "glCopyImageSubDataEXT"

-- glCopyImageSubDataNV --------------------------------------------------------

glCopyImageSubDataNV
  :: MonadIO m
  => GLuint -- ^ @srcName@.
  -> GLenum -- ^ @srcTarget@.
  -> GLint -- ^ @srcLevel@.
  -> GLint -- ^ @srcX@.
  -> GLint -- ^ @srcY@.
  -> GLint -- ^ @srcZ@.
  -> GLuint -- ^ @dstName@.
  -> GLenum -- ^ @dstTarget@.
  -> GLint -- ^ @dstLevel@.
  -> GLint -- ^ @dstX@.
  -> GLint -- ^ @dstY@.
  -> GLint -- ^ @dstZ@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> m ()
glCopyImageSubDataNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 = liftIO $ dyn168 ptr_glCopyImageSubDataNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15

{-# NOINLINE ptr_glCopyImageSubDataNV #-}
ptr_glCopyImageSubDataNV :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ())
ptr_glCopyImageSubDataNV = unsafePerformIO $ getCommand "glCopyImageSubDataNV"

-- glCopyImageSubDataOES -------------------------------------------------------

-- | This command is an alias for 'glCopyImageSubData'.
glCopyImageSubDataOES
  :: MonadIO m
  => GLuint -- ^ @srcName@.
  -> GLenum -- ^ @srcTarget@.
  -> GLint -- ^ @srcLevel@.
  -> GLint -- ^ @srcX@.
  -> GLint -- ^ @srcY@.
  -> GLint -- ^ @srcZ@.
  -> GLuint -- ^ @dstName@.
  -> GLenum -- ^ @dstTarget@.
  -> GLint -- ^ @dstLevel@.
  -> GLint -- ^ @dstX@.
  -> GLint -- ^ @dstY@.
  -> GLint -- ^ @dstZ@.
  -> GLsizei -- ^ @srcWidth@.
  -> GLsizei -- ^ @srcHeight@.
  -> GLsizei -- ^ @srcDepth@.
  -> m ()
glCopyImageSubDataOES v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15 = liftIO $ dyn168 ptr_glCopyImageSubDataOES v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 v15

{-# NOINLINE ptr_glCopyImageSubDataOES #-}
ptr_glCopyImageSubDataOES :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ())
ptr_glCopyImageSubDataOES = unsafePerformIO $ getCommand "glCopyImageSubDataOES"

-- glCopyMultiTexImage1DEXT ----------------------------------------------------

glCopyMultiTexImage1DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyMultiTexImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn169 ptr_glCopyMultiTexImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glCopyMultiTexImage1DEXT #-}
ptr_glCopyMultiTexImage1DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ())
ptr_glCopyMultiTexImage1DEXT = unsafePerformIO $ getCommand "glCopyMultiTexImage1DEXT"

-- glCopyMultiTexImage2DEXT ----------------------------------------------------

glCopyMultiTexImage2DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyMultiTexImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn170 ptr_glCopyMultiTexImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCopyMultiTexImage2DEXT #-}
ptr_glCopyMultiTexImage2DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ())
ptr_glCopyMultiTexImage2DEXT = unsafePerformIO $ getCommand "glCopyMultiTexImage2DEXT"

-- glCopyMultiTexSubImage1DEXT -------------------------------------------------

glCopyMultiTexSubImage1DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyMultiTexSubImage1DEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn171 ptr_glCopyMultiTexSubImage1DEXT v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glCopyMultiTexSubImage1DEXT #-}
ptr_glCopyMultiTexSubImage1DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyMultiTexSubImage1DEXT = unsafePerformIO $ getCommand "glCopyMultiTexSubImage1DEXT"

-- glCopyMultiTexSubImage2DEXT -------------------------------------------------

glCopyMultiTexSubImage2DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyMultiTexSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn172 ptr_glCopyMultiTexSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCopyMultiTexSubImage2DEXT #-}
ptr_glCopyMultiTexSubImage2DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyMultiTexSubImage2DEXT = unsafePerformIO $ getCommand "glCopyMultiTexSubImage2DEXT"

-- glCopyMultiTexSubImage3DEXT -------------------------------------------------

glCopyMultiTexSubImage3DEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyMultiTexSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn173 ptr_glCopyMultiTexSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

{-# NOINLINE ptr_glCopyMultiTexSubImage3DEXT #-}
ptr_glCopyMultiTexSubImage3DEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyMultiTexSubImage3DEXT = unsafePerformIO $ getCommand "glCopyMultiTexSubImage3DEXT"

-- glCopyNamedBufferSubData ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCopyBufferSubData.xhtml OpenGL 4.x>.
glCopyNamedBufferSubData
  :: MonadIO m
  => GLuint -- ^ @readBuffer@.
  -> GLuint -- ^ @writeBuffer@.
  -> GLintptr -- ^ @readOffset@.
  -> GLintptr -- ^ @writeOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> m ()
glCopyNamedBufferSubData v1 v2 v3 v4 v5 = liftIO $ dyn174 ptr_glCopyNamedBufferSubData v1 v2 v3 v4 v5

{-# NOINLINE ptr_glCopyNamedBufferSubData #-}
ptr_glCopyNamedBufferSubData :: FunPtr (GLuint -> GLuint -> GLintptr -> GLintptr -> GLsizeiptr -> IO ())
ptr_glCopyNamedBufferSubData = unsafePerformIO $ getCommand "glCopyNamedBufferSubData"

-- glCopyPathNV ----------------------------------------------------------------

glCopyPathNV
  :: MonadIO m
  => GLuint -- ^ @resultPath@ of type @Path@.
  -> GLuint -- ^ @srcPath@ of type @Path@.
  -> m ()
glCopyPathNV v1 v2 = liftIO $ dyn3 ptr_glCopyPathNV v1 v2

{-# NOINLINE ptr_glCopyPathNV #-}
ptr_glCopyPathNV :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glCopyPathNV = unsafePerformIO $ getCommand "glCopyPathNV"

-- glCopyPixels ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyPixels.xml OpenGL 2.x>.
glCopyPixels
  :: MonadIO m
  => GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @type@ of type [PixelCopyType](Graphics-GL-Groups.html#PixelCopyType).
  -> m ()
glCopyPixels v1 v2 v3 v4 v5 = liftIO $ dyn175 ptr_glCopyPixels v1 v2 v3 v4 v5

{-# NOINLINE ptr_glCopyPixels #-}
ptr_glCopyPixels :: FunPtr (GLint -> GLint -> GLsizei -> GLsizei -> GLenum -> IO ())
ptr_glCopyPixels = unsafePerformIO $ getCommand "glCopyPixels"

-- glCopyTexImage1D ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexImage1D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexImage1D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCopyTexImage1D.xhtml OpenGL 4.x>.
glCopyTexImage1D
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyTexImage1D v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn176 ptr_glCopyTexImage1D v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glCopyTexImage1D #-}
ptr_glCopyTexImage1D :: FunPtr (GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ())
ptr_glCopyTexImage1D = unsafePerformIO $ getCommand "glCopyTexImage1D"

-- glCopyTexImage1DEXT ---------------------------------------------------------

-- | This command is an alias for 'glCopyTexImage1D'.
glCopyTexImage1DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyTexImage1DEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn176 ptr_glCopyTexImage1DEXT v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glCopyTexImage1DEXT #-}
ptr_glCopyTexImage1DEXT :: FunPtr (GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ())
ptr_glCopyTexImage1DEXT = unsafePerformIO $ getCommand "glCopyTexImage1DEXT"

-- glCopyTexImage2D ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexImage2D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexImage2D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCopyTexImage2D.xhtml OpenGL 4.x>.
glCopyTexImage2D
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyTexImage2D v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn177 ptr_glCopyTexImage2D v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glCopyTexImage2D #-}
ptr_glCopyTexImage2D :: FunPtr (GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ())
ptr_glCopyTexImage2D = unsafePerformIO $ getCommand "glCopyTexImage2D"

-- glCopyTexImage2DEXT ---------------------------------------------------------

-- | This command is an alias for 'glCopyTexImage2D'.
glCopyTexImage2DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyTexImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn177 ptr_glCopyTexImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glCopyTexImage2DEXT #-}
ptr_glCopyTexImage2DEXT :: FunPtr (GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ())
ptr_glCopyTexImage2DEXT = unsafePerformIO $ getCommand "glCopyTexImage2DEXT"

-- glCopyTexSubImage1D ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexSubImage1D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexSubImage1D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCopyTexSubImage1D.xhtml OpenGL 4.x>.
glCopyTexSubImage1D
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyTexSubImage1D v1 v2 v3 v4 v5 v6 = liftIO $ dyn178 ptr_glCopyTexSubImage1D v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glCopyTexSubImage1D #-}
ptr_glCopyTexSubImage1D :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyTexSubImage1D = unsafePerformIO $ getCommand "glCopyTexSubImage1D"

-- glCopyTexSubImage1DEXT ------------------------------------------------------

-- | This command is an alias for 'glCopyTexSubImage1D'.
glCopyTexSubImage1DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyTexSubImage1DEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn178 ptr_glCopyTexSubImage1DEXT v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glCopyTexSubImage1DEXT #-}
ptr_glCopyTexSubImage1DEXT :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyTexSubImage1DEXT = unsafePerformIO $ getCommand "glCopyTexSubImage1DEXT"

-- glCopyTexSubImage2D ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexSubImage2D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexSubImage2D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCopyTexSubImage2D.xhtml OpenGL 4.x>.
glCopyTexSubImage2D
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTexSubImage2D v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn179 ptr_glCopyTexSubImage2D v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glCopyTexSubImage2D #-}
ptr_glCopyTexSubImage2D :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTexSubImage2D = unsafePerformIO $ getCommand "glCopyTexSubImage2D"

-- glCopyTexSubImage2DEXT ------------------------------------------------------

-- | This command is an alias for 'glCopyTexSubImage2D'.
glCopyTexSubImage2DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTexSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn179 ptr_glCopyTexSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glCopyTexSubImage2DEXT #-}
ptr_glCopyTexSubImage2DEXT :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTexSubImage2DEXT = unsafePerformIO $ getCommand "glCopyTexSubImage2DEXT"

-- glCopyTexSubImage3D ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCopyTexSubImage3D.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCopyTexSubImage3D.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCopyTexSubImage3D.xhtml OpenGL 4.x>.
glCopyTexSubImage3D
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTexSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn180 ptr_glCopyTexSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCopyTexSubImage3D #-}
ptr_glCopyTexSubImage3D :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTexSubImage3D = unsafePerformIO $ getCommand "glCopyTexSubImage3D"

-- glCopyTexSubImage3DEXT ------------------------------------------------------

-- | This command is an alias for 'glCopyTexSubImage3D'.
glCopyTexSubImage3DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTexSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn180 ptr_glCopyTexSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCopyTexSubImage3DEXT #-}
ptr_glCopyTexSubImage3DEXT :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTexSubImage3DEXT = unsafePerformIO $ getCommand "glCopyTexSubImage3DEXT"

-- glCopyTexSubImage3DOES ------------------------------------------------------

-- | This command is an alias for 'glCopyTexSubImage3D'.
glCopyTexSubImage3DOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLint -- ^ @x@.
  -> GLint -- ^ @y@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTexSubImage3DOES v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn180 ptr_glCopyTexSubImage3DOES v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCopyTexSubImage3DOES #-}
ptr_glCopyTexSubImage3DOES :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTexSubImage3DOES = unsafePerformIO $ getCommand "glCopyTexSubImage3DOES"

-- glCopyTextureImage1DEXT -----------------------------------------------------

glCopyTextureImage1DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyTextureImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn181 ptr_glCopyTextureImage1DEXT v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glCopyTextureImage1DEXT #-}
ptr_glCopyTextureImage1DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLint -> IO ())
ptr_glCopyTextureImage1DEXT = unsafePerformIO $ getCommand "glCopyTextureImage1DEXT"

-- glCopyTextureImage2DEXT -----------------------------------------------------

glCopyTextureImage2DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @internalformat@ of type @TextureInternalFormat@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLint -- ^ @border@ of type @CheckedInt32@.
  -> m ()
glCopyTextureImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn182 ptr_glCopyTextureImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCopyTextureImage2DEXT #-}
ptr_glCopyTextureImage2DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> GLint -> IO ())
ptr_glCopyTextureImage2DEXT = unsafePerformIO $ getCommand "glCopyTextureImage2DEXT"

-- glCopyTextureLevelsAPPLE ----------------------------------------------------

glCopyTextureLevelsAPPLE
  :: MonadIO m
  => GLuint -- ^ @destinationTexture@.
  -> GLuint -- ^ @sourceTexture@.
  -> GLint -- ^ @sourceBaseLevel@.
  -> GLsizei -- ^ @sourceLevelCount@.
  -> m ()
glCopyTextureLevelsAPPLE v1 v2 v3 v4 = liftIO $ dyn183 ptr_glCopyTextureLevelsAPPLE v1 v2 v3 v4

{-# NOINLINE ptr_glCopyTextureLevelsAPPLE #-}
ptr_glCopyTextureLevelsAPPLE :: FunPtr (GLuint -> GLuint -> GLint -> GLsizei -> IO ())
ptr_glCopyTextureLevelsAPPLE = unsafePerformIO $ getCommand "glCopyTextureLevelsAPPLE"

-- glCopyTextureSubImage1D -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCopyTexSubImage1D.xhtml OpenGL 4.x>.
glCopyTextureSubImage1D
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @x@.
  -> GLint -- ^ @y@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyTextureSubImage1D v1 v2 v3 v4 v5 v6 = liftIO $ dyn184 ptr_glCopyTextureSubImage1D v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glCopyTextureSubImage1D #-}
ptr_glCopyTextureSubImage1D :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyTextureSubImage1D = unsafePerformIO $ getCommand "glCopyTextureSubImage1D"

-- glCopyTextureSubImage1DEXT --------------------------------------------------

glCopyTextureSubImage1DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> m ()
glCopyTextureSubImage1DEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn185 ptr_glCopyTextureSubImage1DEXT v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glCopyTextureSubImage1DEXT #-}
ptr_glCopyTextureSubImage1DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> IO ())
ptr_glCopyTextureSubImage1DEXT = unsafePerformIO $ getCommand "glCopyTextureSubImage1DEXT"

-- glCopyTextureSubImage2D -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCopyTexSubImage2D.xhtml OpenGL 4.x>.
glCopyTextureSubImage2D
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @x@.
  -> GLint -- ^ @y@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTextureSubImage2D v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn186 ptr_glCopyTextureSubImage2D v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glCopyTextureSubImage2D #-}
ptr_glCopyTextureSubImage2D :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTextureSubImage2D = unsafePerformIO $ getCommand "glCopyTextureSubImage2D"

-- glCopyTextureSubImage2DEXT --------------------------------------------------

glCopyTextureSubImage2DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTextureSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn187 ptr_glCopyTextureSubImage2DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCopyTextureSubImage2DEXT #-}
ptr_glCopyTextureSubImage2DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTextureSubImage2DEXT = unsafePerformIO $ getCommand "glCopyTextureSubImage2DEXT"

-- glCopyTextureSubImage3D -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCopyTexSubImage3D.xhtml OpenGL 4.x>.
glCopyTextureSubImage3D
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLint -- ^ @x@.
  -> GLint -- ^ @y@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTextureSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn188 ptr_glCopyTextureSubImage3D v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glCopyTextureSubImage3D #-}
ptr_glCopyTextureSubImage3D :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTextureSubImage3D = unsafePerformIO $ getCommand "glCopyTextureSubImage3D"

-- glCopyTextureSubImage3DEXT --------------------------------------------------

glCopyTextureSubImage3DEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @xoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @yoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @zoffset@ of type @CheckedInt32@.
  -> GLint -- ^ @x@ of type @WinCoord@.
  -> GLint -- ^ @y@ of type @WinCoord@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glCopyTextureSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn189 ptr_glCopyTextureSubImage3DEXT v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

{-# NOINLINE ptr_glCopyTextureSubImage3DEXT #-}
ptr_glCopyTextureSubImage3DEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glCopyTextureSubImage3DEXT = unsafePerformIO $ getCommand "glCopyTextureSubImage3DEXT"

-- glCoverFillPathInstancedNV --------------------------------------------------

glCoverFillPathInstancedNV
  :: MonadIO m
  => GLsizei -- ^ @numPaths@.
  -> GLenum -- ^ @pathNameType@ of type @PathElementType@.
  -> Ptr a -- ^ @paths@ pointing to @COMPSIZE(numPaths,pathNameType,paths)@ elements of type @PathElement@.
  -> GLuint -- ^ @pathBase@ of type @Path@.
  -> GLenum -- ^ @coverMode@ of type @PathCoverMode@.
  -> GLenum -- ^ @transformType@ of type @PathTransformType@.
  -> Ptr GLfloat -- ^ @transformValues@ pointing to @COMPSIZE(numPaths,transformType)@ elements of type @GLfloat@.
  -> m ()
glCoverFillPathInstancedNV v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn190 ptr_glCoverFillPathInstancedNV v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glCoverFillPathInstancedNV #-}
ptr_glCoverFillPathInstancedNV :: FunPtr (GLsizei -> GLenum -> Ptr a -> GLuint -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glCoverFillPathInstancedNV = unsafePerformIO $ getCommand "glCoverFillPathInstancedNV"

-- glCoverFillPathNV -----------------------------------------------------------

glCoverFillPathNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> GLenum -- ^ @coverMode@ of type @PathCoverMode@.
  -> m ()
glCoverFillPathNV v1 v2 = liftIO $ dyn15 ptr_glCoverFillPathNV v1 v2

{-# NOINLINE ptr_glCoverFillPathNV #-}
ptr_glCoverFillPathNV :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glCoverFillPathNV = unsafePerformIO $ getCommand "glCoverFillPathNV"

-- glCoverStrokePathInstancedNV ------------------------------------------------

glCoverStrokePathInstancedNV
  :: MonadIO m
  => GLsizei -- ^ @numPaths@.
  -> GLenum -- ^ @pathNameType@ of type @PathElementType@.
  -> Ptr a -- ^ @paths@ pointing to @COMPSIZE(numPaths,pathNameType,paths)@ elements of type @PathElement@.
  -> GLuint -- ^ @pathBase@ of type @Path@.
  -> GLenum -- ^ @coverMode@ of type @PathCoverMode@.
  -> GLenum -- ^ @transformType@ of type @PathTransformType@.
  -> Ptr GLfloat -- ^ @transformValues@ pointing to @COMPSIZE(numPaths,transformType)@ elements of type @GLfloat@.
  -> m ()
glCoverStrokePathInstancedNV v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn190 ptr_glCoverStrokePathInstancedNV v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glCoverStrokePathInstancedNV #-}
ptr_glCoverStrokePathInstancedNV :: FunPtr (GLsizei -> GLenum -> Ptr a -> GLuint -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glCoverStrokePathInstancedNV = unsafePerformIO $ getCommand "glCoverStrokePathInstancedNV"

-- glCoverStrokePathNV ---------------------------------------------------------

glCoverStrokePathNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> GLenum -- ^ @coverMode@ of type @PathCoverMode@.
  -> m ()
glCoverStrokePathNV v1 v2 = liftIO $ dyn15 ptr_glCoverStrokePathNV v1 v2

{-# NOINLINE ptr_glCoverStrokePathNV #-}
ptr_glCoverStrokePathNV :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glCoverStrokePathNV = unsafePerformIO $ getCommand "glCoverStrokePathNV"

-- glCoverageMaskNV ------------------------------------------------------------

glCoverageMaskNV
  :: MonadIO m
  => GLboolean -- ^ @mask@.
  -> m ()
glCoverageMaskNV v1 = liftIO $ dyn191 ptr_glCoverageMaskNV v1

{-# NOINLINE ptr_glCoverageMaskNV #-}
ptr_glCoverageMaskNV :: FunPtr (GLboolean -> IO ())
ptr_glCoverageMaskNV = unsafePerformIO $ getCommand "glCoverageMaskNV"

-- glCoverageModulationNV ------------------------------------------------------

glCoverageModulationNV
  :: MonadIO m
  => GLenum -- ^ @components@.
  -> m ()
glCoverageModulationNV v1 = liftIO $ dyn4 ptr_glCoverageModulationNV v1

{-# NOINLINE ptr_glCoverageModulationNV #-}
ptr_glCoverageModulationNV :: FunPtr (GLenum -> IO ())
ptr_glCoverageModulationNV = unsafePerformIO $ getCommand "glCoverageModulationNV"

-- glCoverageModulationTableNV -------------------------------------------------

glCoverageModulationTableNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLfloat -- ^ @v@.
  -> m ()
glCoverageModulationTableNV v1 v2 = liftIO $ dyn192 ptr_glCoverageModulationTableNV v1 v2

{-# NOINLINE ptr_glCoverageModulationTableNV #-}
ptr_glCoverageModulationTableNV :: FunPtr (GLsizei -> Ptr GLfloat -> IO ())
ptr_glCoverageModulationTableNV = unsafePerformIO $ getCommand "glCoverageModulationTableNV"

-- glCoverageOperationNV -------------------------------------------------------

glCoverageOperationNV
  :: MonadIO m
  => GLenum -- ^ @operation@.
  -> m ()
glCoverageOperationNV v1 = liftIO $ dyn4 ptr_glCoverageOperationNV v1

{-# NOINLINE ptr_glCoverageOperationNV #-}
ptr_glCoverageOperationNV :: FunPtr (GLenum -> IO ())
ptr_glCoverageOperationNV = unsafePerformIO $ getCommand "glCoverageOperationNV"

-- glCreateBuffers -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateBuffers.xhtml OpenGL 4.x>.
glCreateBuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @buffers@.
  -> m ()
glCreateBuffers v1 v2 = liftIO $ dyn193 ptr_glCreateBuffers v1 v2

{-# NOINLINE ptr_glCreateBuffers #-}
ptr_glCreateBuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateBuffers = unsafePerformIO $ getCommand "glCreateBuffers"

-- glCreateCommandListsNV ------------------------------------------------------

glCreateCommandListsNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @lists@.
  -> m ()
glCreateCommandListsNV v1 v2 = liftIO $ dyn193 ptr_glCreateCommandListsNV v1 v2

{-# NOINLINE ptr_glCreateCommandListsNV #-}
ptr_glCreateCommandListsNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateCommandListsNV = unsafePerformIO $ getCommand "glCreateCommandListsNV"

-- glCreateFramebuffers --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateFramebuffers.xhtml OpenGL 4.x>.
glCreateFramebuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @framebuffers@.
  -> m ()
glCreateFramebuffers v1 v2 = liftIO $ dyn193 ptr_glCreateFramebuffers v1 v2

{-# NOINLINE ptr_glCreateFramebuffers #-}
ptr_glCreateFramebuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateFramebuffers = unsafePerformIO $ getCommand "glCreateFramebuffers"

-- glCreatePerfQueryINTEL ------------------------------------------------------

glCreatePerfQueryINTEL
  :: MonadIO m
  => GLuint -- ^ @queryId@.
  -> Ptr GLuint -- ^ @queryHandle@.
  -> m ()
glCreatePerfQueryINTEL v1 v2 = liftIO $ dyn194 ptr_glCreatePerfQueryINTEL v1 v2

{-# NOINLINE ptr_glCreatePerfQueryINTEL #-}
ptr_glCreatePerfQueryINTEL :: FunPtr (GLuint -> Ptr GLuint -> IO ())
ptr_glCreatePerfQueryINTEL = unsafePerformIO $ getCommand "glCreatePerfQueryINTEL"

-- glCreateProgram -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCreateProgram.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCreateProgram.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCreateProgram.xhtml OpenGL 4.x>.
glCreateProgram
  :: MonadIO m
  => m GLuint
glCreateProgram = liftIO $ dyn195 ptr_glCreateProgram

{-# NOINLINE ptr_glCreateProgram #-}
ptr_glCreateProgram :: FunPtr (IO GLuint)
ptr_glCreateProgram = unsafePerformIO $ getCommand "glCreateProgram"

-- glCreateProgramObjectARB ----------------------------------------------------

-- | This command is an alias for 'glCreateProgram'.
glCreateProgramObjectARB
  :: MonadIO m
  => m GLhandleARB -- ^ of type @handleARB@.
glCreateProgramObjectARB = liftIO $ dyn196 ptr_glCreateProgramObjectARB

{-# NOINLINE ptr_glCreateProgramObjectARB #-}
ptr_glCreateProgramObjectARB :: FunPtr (IO GLhandleARB)
ptr_glCreateProgramObjectARB = unsafePerformIO $ getCommand "glCreateProgramObjectARB"

-- glCreateProgramPipelines ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateProgramPipelines.xhtml OpenGL 4.x>.
glCreateProgramPipelines
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @pipelines@.
  -> m ()
glCreateProgramPipelines v1 v2 = liftIO $ dyn193 ptr_glCreateProgramPipelines v1 v2

{-# NOINLINE ptr_glCreateProgramPipelines #-}
ptr_glCreateProgramPipelines :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateProgramPipelines = unsafePerformIO $ getCommand "glCreateProgramPipelines"

-- glCreateQueries -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateQueries.xhtml OpenGL 4.x>.
glCreateQueries
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@.
  -> m ()
glCreateQueries v1 v2 v3 = liftIO $ dyn197 ptr_glCreateQueries v1 v2 v3

{-# NOINLINE ptr_glCreateQueries #-}
ptr_glCreateQueries :: FunPtr (GLenum -> GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateQueries = unsafePerformIO $ getCommand "glCreateQueries"

-- glCreateRenderbuffers -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateRenderbuffers.xhtml OpenGL 4.x>.
glCreateRenderbuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @renderbuffers@.
  -> m ()
glCreateRenderbuffers v1 v2 = liftIO $ dyn193 ptr_glCreateRenderbuffers v1 v2

{-# NOINLINE ptr_glCreateRenderbuffers #-}
ptr_glCreateRenderbuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateRenderbuffers = unsafePerformIO $ getCommand "glCreateRenderbuffers"

-- glCreateSamplers ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateSamplers.xhtml OpenGL 4.x>.
glCreateSamplers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @samplers@.
  -> m ()
glCreateSamplers v1 v2 = liftIO $ dyn193 ptr_glCreateSamplers v1 v2

{-# NOINLINE ptr_glCreateSamplers #-}
ptr_glCreateSamplers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateSamplers = unsafePerformIO $ getCommand "glCreateSamplers"

-- glCreateShader --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCreateShader.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCreateShader.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCreateShader.xhtml OpenGL 4.x>.
glCreateShader
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> m GLuint
glCreateShader v1 = liftIO $ dyn30 ptr_glCreateShader v1

{-# NOINLINE ptr_glCreateShader #-}
ptr_glCreateShader :: FunPtr (GLenum -> IO GLuint)
ptr_glCreateShader = unsafePerformIO $ getCommand "glCreateShader"

-- glCreateShaderObjectARB -----------------------------------------------------

-- | This command is an alias for 'glCreateShader'.
glCreateShaderObjectARB
  :: MonadIO m
  => GLenum -- ^ @shaderType@.
  -> m GLhandleARB -- ^ of type @handleARB@.
glCreateShaderObjectARB v1 = liftIO $ dyn198 ptr_glCreateShaderObjectARB v1

{-# NOINLINE ptr_glCreateShaderObjectARB #-}
ptr_glCreateShaderObjectARB :: FunPtr (GLenum -> IO GLhandleARB)
ptr_glCreateShaderObjectARB = unsafePerformIO $ getCommand "glCreateShaderObjectARB"

-- glCreateShaderProgramEXT ----------------------------------------------------

glCreateShaderProgramEXT
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> Ptr GLchar -- ^ @string@.
  -> m GLuint
glCreateShaderProgramEXT v1 v2 = liftIO $ dyn199 ptr_glCreateShaderProgramEXT v1 v2

{-# NOINLINE ptr_glCreateShaderProgramEXT #-}
ptr_glCreateShaderProgramEXT :: FunPtr (GLenum -> Ptr GLchar -> IO GLuint)
ptr_glCreateShaderProgramEXT = unsafePerformIO $ getCommand "glCreateShaderProgramEXT"

-- glCreateShaderProgramv ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateShaderProgram.xhtml OpenGL 4.x>.
glCreateShaderProgramv
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> GLsizei -- ^ @count@.
  -> Ptr (Ptr GLchar) -- ^ @strings@ pointing to @count@ elements of type @Ptr GLchar@.
  -> m GLuint
glCreateShaderProgramv v1 v2 v3 = liftIO $ dyn200 ptr_glCreateShaderProgramv v1 v2 v3

{-# NOINLINE ptr_glCreateShaderProgramv #-}
ptr_glCreateShaderProgramv :: FunPtr (GLenum -> GLsizei -> Ptr (Ptr GLchar) -> IO GLuint)
ptr_glCreateShaderProgramv = unsafePerformIO $ getCommand "glCreateShaderProgramv"

-- glCreateShaderProgramvEXT ---------------------------------------------------

glCreateShaderProgramvEXT
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> GLsizei -- ^ @count@.
  -> Ptr (Ptr GLchar) -- ^ @strings@ pointing to @count@ elements of type @Ptr GLchar@.
  -> m GLuint
glCreateShaderProgramvEXT v1 v2 v3 = liftIO $ dyn200 ptr_glCreateShaderProgramvEXT v1 v2 v3

{-# NOINLINE ptr_glCreateShaderProgramvEXT #-}
ptr_glCreateShaderProgramvEXT :: FunPtr (GLenum -> GLsizei -> Ptr (Ptr GLchar) -> IO GLuint)
ptr_glCreateShaderProgramvEXT = unsafePerformIO $ getCommand "glCreateShaderProgramvEXT"

-- glCreateStatesNV ------------------------------------------------------------

glCreateStatesNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @states@.
  -> m ()
glCreateStatesNV v1 v2 = liftIO $ dyn193 ptr_glCreateStatesNV v1 v2

{-# NOINLINE ptr_glCreateStatesNV #-}
ptr_glCreateStatesNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateStatesNV = unsafePerformIO $ getCommand "glCreateStatesNV"

-- glCreateSyncFromCLeventARB --------------------------------------------------

glCreateSyncFromCLeventARB
  :: MonadIO m
  => Ptr a -- ^ @context@ pointing to elements of type @cl_context@.
  -> Ptr b -- ^ @event@ pointing to elements of type @cl_event@.
  -> GLbitfield -- ^ @flags@.
  -> m GLsync -- ^ of type @sync@.
glCreateSyncFromCLeventARB v1 v2 v3 = liftIO $ dyn201 ptr_glCreateSyncFromCLeventARB v1 v2 v3

{-# NOINLINE ptr_glCreateSyncFromCLeventARB #-}
ptr_glCreateSyncFromCLeventARB :: FunPtr (Ptr a -> Ptr b -> GLbitfield -> IO GLsync)
ptr_glCreateSyncFromCLeventARB = unsafePerformIO $ getCommand "glCreateSyncFromCLeventARB"

-- glCreateTextures ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateTextures.xhtml OpenGL 4.x>.
glCreateTextures
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @textures@.
  -> m ()
glCreateTextures v1 v2 v3 = liftIO $ dyn197 ptr_glCreateTextures v1 v2 v3

{-# NOINLINE ptr_glCreateTextures #-}
ptr_glCreateTextures :: FunPtr (GLenum -> GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateTextures = unsafePerformIO $ getCommand "glCreateTextures"

-- glCreateTransformFeedbacks --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateTransformFeedbacks.xhtml OpenGL 4.x>.
glCreateTransformFeedbacks
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@.
  -> m ()
glCreateTransformFeedbacks v1 v2 = liftIO $ dyn193 ptr_glCreateTransformFeedbacks v1 v2

{-# NOINLINE ptr_glCreateTransformFeedbacks #-}
ptr_glCreateTransformFeedbacks :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateTransformFeedbacks = unsafePerformIO $ getCommand "glCreateTransformFeedbacks"

-- glCreateVertexArrays --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glCreateVertexArrays.xhtml OpenGL 4.x>.
glCreateVertexArrays
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @arrays@.
  -> m ()
glCreateVertexArrays v1 v2 = liftIO $ dyn193 ptr_glCreateVertexArrays v1 v2

{-# NOINLINE ptr_glCreateVertexArrays #-}
ptr_glCreateVertexArrays :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glCreateVertexArrays = unsafePerformIO $ getCommand "glCreateVertexArrays"

-- glCullFace ------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glCullFace.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glCullFace.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glCullFace.xhtml OpenGL 4.x>.
glCullFace
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [CullFaceMode](Graphics-GL-Groups.html#CullFaceMode).
  -> m ()
glCullFace v1 = liftIO $ dyn4 ptr_glCullFace v1

{-# NOINLINE ptr_glCullFace #-}
ptr_glCullFace :: FunPtr (GLenum -> IO ())
ptr_glCullFace = unsafePerformIO $ getCommand "glCullFace"

-- glCullParameterdvEXT --------------------------------------------------------

glCullParameterdvEXT
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @CullParameterEXT@.
  -> Ptr GLdouble -- ^ @params@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glCullParameterdvEXT v1 v2 = liftIO $ dyn93 ptr_glCullParameterdvEXT v1 v2

{-# NOINLINE ptr_glCullParameterdvEXT #-}
ptr_glCullParameterdvEXT :: FunPtr (GLenum -> Ptr GLdouble -> IO ())
ptr_glCullParameterdvEXT = unsafePerformIO $ getCommand "glCullParameterdvEXT"

-- glCullParameterfvEXT --------------------------------------------------------

glCullParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @CullParameterEXT@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glCullParameterfvEXT v1 v2 = liftIO $ dyn94 ptr_glCullParameterfvEXT v1 v2

{-# NOINLINE ptr_glCullParameterfvEXT #-}
ptr_glCullParameterfvEXT :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glCullParameterfvEXT = unsafePerformIO $ getCommand "glCullParameterfvEXT"

-- glCurrentPaletteMatrixARB ---------------------------------------------------

glCurrentPaletteMatrixARB
  :: MonadIO m
  => GLint -- ^ @index@.
  -> m ()
glCurrentPaletteMatrixARB v1 = liftIO $ dyn12 ptr_glCurrentPaletteMatrixARB v1

{-# NOINLINE ptr_glCurrentPaletteMatrixARB #-}
ptr_glCurrentPaletteMatrixARB :: FunPtr (GLint -> IO ())
ptr_glCurrentPaletteMatrixARB = unsafePerformIO $ getCommand "glCurrentPaletteMatrixARB"

-- glCurrentPaletteMatrixOES ---------------------------------------------------

glCurrentPaletteMatrixOES
  :: MonadIO m
  => GLuint -- ^ @matrixpaletteindex@.
  -> m ()
glCurrentPaletteMatrixOES v1 = liftIO $ dyn2 ptr_glCurrentPaletteMatrixOES v1

{-# NOINLINE ptr_glCurrentPaletteMatrixOES #-}
ptr_glCurrentPaletteMatrixOES :: FunPtr (GLuint -> IO ())
ptr_glCurrentPaletteMatrixOES = unsafePerformIO $ getCommand "glCurrentPaletteMatrixOES"

-- glDebugMessageCallback ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDebugMessageCallback.xhtml OpenGL 4.x>.
glDebugMessageCallback
  :: MonadIO m
  => GLDEBUGPROC -- ^ @callback@.
  -> Ptr a -- ^ @userParam@.
  -> m ()
glDebugMessageCallback v1 v2 = liftIO $ dyn202 ptr_glDebugMessageCallback v1 v2

{-# NOINLINE ptr_glDebugMessageCallback #-}
ptr_glDebugMessageCallback :: FunPtr (GLDEBUGPROC -> Ptr a -> IO ())
ptr_glDebugMessageCallback = unsafePerformIO $ getCommand "glDebugMessageCallback"

-- glDebugMessageCallbackAMD ---------------------------------------------------

glDebugMessageCallbackAMD
  :: MonadIO m
  => GLDEBUGPROCAMD -- ^ @callback@.
  -> Ptr a -- ^ @userParam@.
  -> m ()
glDebugMessageCallbackAMD v1 v2 = liftIO $ dyn203 ptr_glDebugMessageCallbackAMD v1 v2

{-# NOINLINE ptr_glDebugMessageCallbackAMD #-}
ptr_glDebugMessageCallbackAMD :: FunPtr (GLDEBUGPROCAMD -> Ptr a -> IO ())
ptr_glDebugMessageCallbackAMD = unsafePerformIO $ getCommand "glDebugMessageCallbackAMD"

-- glDebugMessageCallbackARB ---------------------------------------------------

-- | This command is an alias for 'glDebugMessageCallback'.
glDebugMessageCallbackARB
  :: MonadIO m
  => GLDEBUGPROCARB -- ^ @callback@.
  -> Ptr a -- ^ @userParam@ pointing to @COMPSIZE(callback)@ elements of type @a@.
  -> m ()
glDebugMessageCallbackARB v1 v2 = liftIO $ dyn204 ptr_glDebugMessageCallbackARB v1 v2

{-# NOINLINE ptr_glDebugMessageCallbackARB #-}
ptr_glDebugMessageCallbackARB :: FunPtr (GLDEBUGPROCARB -> Ptr a -> IO ())
ptr_glDebugMessageCallbackARB = unsafePerformIO $ getCommand "glDebugMessageCallbackARB"

-- glDebugMessageCallbackKHR ---------------------------------------------------

-- | This command is an alias for 'glDebugMessageCallback'.
glDebugMessageCallbackKHR
  :: MonadIO m
  => GLDEBUGPROCKHR -- ^ @callback@.
  -> Ptr a -- ^ @userParam@.
  -> m ()
glDebugMessageCallbackKHR v1 v2 = liftIO $ dyn205 ptr_glDebugMessageCallbackKHR v1 v2

{-# NOINLINE ptr_glDebugMessageCallbackKHR #-}
ptr_glDebugMessageCallbackKHR :: FunPtr (GLDEBUGPROCKHR -> Ptr a -> IO ())
ptr_glDebugMessageCallbackKHR = unsafePerformIO $ getCommand "glDebugMessageCallbackKHR"

-- glDebugMessageControl -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDebugMessageControl.xhtml OpenGL 4.x>.
glDebugMessageControl
  :: MonadIO m
  => GLenum -- ^ @source@.
  -> GLenum -- ^ @type@.
  -> GLenum -- ^ @severity@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @ids@ pointing to @count@ elements of type @GLuint@.
  -> GLboolean -- ^ @enabled@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glDebugMessageControl v1 v2 v3 v4 v5 v6 = liftIO $ dyn206 ptr_glDebugMessageControl v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDebugMessageControl #-}
ptr_glDebugMessageControl :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ())
ptr_glDebugMessageControl = unsafePerformIO $ getCommand "glDebugMessageControl"

-- glDebugMessageControlARB ----------------------------------------------------

-- | This command is an alias for 'glDebugMessageControl'.
glDebugMessageControlARB
  :: MonadIO m
  => GLenum -- ^ @source@.
  -> GLenum -- ^ @type@.
  -> GLenum -- ^ @severity@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @ids@ pointing to @count@ elements of type @GLuint@.
  -> GLboolean -- ^ @enabled@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glDebugMessageControlARB v1 v2 v3 v4 v5 v6 = liftIO $ dyn206 ptr_glDebugMessageControlARB v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDebugMessageControlARB #-}
ptr_glDebugMessageControlARB :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ())
ptr_glDebugMessageControlARB = unsafePerformIO $ getCommand "glDebugMessageControlARB"

-- glDebugMessageControlKHR ----------------------------------------------------

-- | This command is an alias for 'glDebugMessageControl'.
glDebugMessageControlKHR
  :: MonadIO m
  => GLenum -- ^ @source@.
  -> GLenum -- ^ @type@.
  -> GLenum -- ^ @severity@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @ids@.
  -> GLboolean -- ^ @enabled@.
  -> m ()
glDebugMessageControlKHR v1 v2 v3 v4 v5 v6 = liftIO $ dyn206 ptr_glDebugMessageControlKHR v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDebugMessageControlKHR #-}
ptr_glDebugMessageControlKHR :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ())
ptr_glDebugMessageControlKHR = unsafePerformIO $ getCommand "glDebugMessageControlKHR"

-- glDebugMessageEnableAMD -----------------------------------------------------

glDebugMessageEnableAMD
  :: MonadIO m
  => GLenum -- ^ @category@.
  -> GLenum -- ^ @severity@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @ids@ pointing to @count@ elements of type @GLuint@.
  -> GLboolean -- ^ @enabled@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glDebugMessageEnableAMD v1 v2 v3 v4 v5 = liftIO $ dyn207 ptr_glDebugMessageEnableAMD v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDebugMessageEnableAMD #-}
ptr_glDebugMessageEnableAMD :: FunPtr (GLenum -> GLenum -> GLsizei -> Ptr GLuint -> GLboolean -> IO ())
ptr_glDebugMessageEnableAMD = unsafePerformIO $ getCommand "glDebugMessageEnableAMD"

-- glDebugMessageInsert --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDebugMessageInsert.xhtml OpenGL 4.x>.
glDebugMessageInsert
  :: MonadIO m
  => GLenum -- ^ @source@.
  -> GLenum -- ^ @type@.
  -> GLuint -- ^ @id@.
  -> GLenum -- ^ @severity@.
  -> GLsizei -- ^ @length@.
  -> Ptr GLchar -- ^ @buf@ pointing to @COMPSIZE(buf,length)@ elements of type @GLchar@.
  -> m ()
glDebugMessageInsert v1 v2 v3 v4 v5 v6 = liftIO $ dyn208 ptr_glDebugMessageInsert v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDebugMessageInsert #-}
ptr_glDebugMessageInsert :: FunPtr (GLenum -> GLenum -> GLuint -> GLenum -> GLsizei -> Ptr GLchar -> IO ())
ptr_glDebugMessageInsert = unsafePerformIO $ getCommand "glDebugMessageInsert"

-- glDebugMessageInsertAMD -----------------------------------------------------

glDebugMessageInsertAMD
  :: MonadIO m
  => GLenum -- ^ @category@.
  -> GLenum -- ^ @severity@.
  -> GLuint -- ^ @id@.
  -> GLsizei -- ^ @length@.
  -> Ptr GLchar -- ^ @buf@ pointing to @length@ elements of type @GLchar@.
  -> m ()
glDebugMessageInsertAMD v1 v2 v3 v4 v5 = liftIO $ dyn209 ptr_glDebugMessageInsertAMD v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDebugMessageInsertAMD #-}
ptr_glDebugMessageInsertAMD :: FunPtr (GLenum -> GLenum -> GLuint -> GLsizei -> Ptr GLchar -> IO ())
ptr_glDebugMessageInsertAMD = unsafePerformIO $ getCommand "glDebugMessageInsertAMD"

-- glDebugMessageInsertARB -----------------------------------------------------

-- | This command is an alias for 'glDebugMessageInsert'.
glDebugMessageInsertARB
  :: MonadIO m
  => GLenum -- ^ @source@.
  -> GLenum -- ^ @type@.
  -> GLuint -- ^ @id@.
  -> GLenum -- ^ @severity@.
  -> GLsizei -- ^ @length@.
  -> Ptr GLchar -- ^ @buf@ pointing to @length@ elements of type @GLchar@.
  -> m ()
glDebugMessageInsertARB v1 v2 v3 v4 v5 v6 = liftIO $ dyn208 ptr_glDebugMessageInsertARB v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDebugMessageInsertARB #-}
ptr_glDebugMessageInsertARB :: FunPtr (GLenum -> GLenum -> GLuint -> GLenum -> GLsizei -> Ptr GLchar -> IO ())
ptr_glDebugMessageInsertARB = unsafePerformIO $ getCommand "glDebugMessageInsertARB"

-- glDebugMessageInsertKHR -----------------------------------------------------

-- | This command is an alias for 'glDebugMessageInsert'.
glDebugMessageInsertKHR
  :: MonadIO m
  => GLenum -- ^ @source@.
  -> GLenum -- ^ @type@.
  -> GLuint -- ^ @id@.
  -> GLenum -- ^ @severity@.
  -> GLsizei -- ^ @length@.
  -> Ptr GLchar -- ^ @buf@.
  -> m ()
glDebugMessageInsertKHR v1 v2 v3 v4 v5 v6 = liftIO $ dyn208 ptr_glDebugMessageInsertKHR v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDebugMessageInsertKHR #-}
ptr_glDebugMessageInsertKHR :: FunPtr (GLenum -> GLenum -> GLuint -> GLenum -> GLsizei -> Ptr GLchar -> IO ())
ptr_glDebugMessageInsertKHR = unsafePerformIO $ getCommand "glDebugMessageInsertKHR"

-- glDeformSGIX ----------------------------------------------------------------

glDeformSGIX
  :: MonadIO m
  => GLbitfield -- ^ @mask@ of type [FfdMaskSGIX](Graphics-GL-Groups.html#FfdMaskSGIX).
  -> m ()
glDeformSGIX v1 = liftIO $ dyn69 ptr_glDeformSGIX v1

{-# NOINLINE ptr_glDeformSGIX #-}
ptr_glDeformSGIX :: FunPtr (GLbitfield -> IO ())
ptr_glDeformSGIX = unsafePerformIO $ getCommand "glDeformSGIX"

-- glDeformationMap3dSGIX ------------------------------------------------------

glDeformationMap3dSGIX
  :: MonadIO m
  => GLenum -- ^ @target@ of type [FfdTargetSGIX](Graphics-GL-Groups.html#FfdTargetSGIX).
  -> GLdouble -- ^ @u1@ of type @CoordD@.
  -> GLdouble -- ^ @u2@ of type @CoordD@.
  -> GLint -- ^ @ustride@.
  -> GLint -- ^ @uorder@ of type @CheckedInt32@.
  -> GLdouble -- ^ @v1@ of type @CoordD@.
  -> GLdouble -- ^ @v2@ of type @CoordD@.
  -> GLint -- ^ @vstride@.
  -> GLint -- ^ @vorder@ of type @CheckedInt32@.
  -> GLdouble -- ^ @w1@ of type @CoordD@.
  -> GLdouble -- ^ @w2@ of type @CoordD@.
  -> GLint -- ^ @wstride@.
  -> GLint -- ^ @worder@ of type @CheckedInt32@.
  -> Ptr GLdouble -- ^ @points@ pointing to @COMPSIZE(target,ustride,uorder,vstride,vorder,wstride,worder)@ elements of type @CoordD@.
  -> m ()
glDeformationMap3dSGIX v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 = liftIO $ dyn210 ptr_glDeformationMap3dSGIX v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14

{-# NOINLINE ptr_glDeformationMap3dSGIX #-}
ptr_glDeformationMap3dSGIX :: FunPtr (GLenum -> GLdouble -> GLdouble -> GLint -> GLint -> GLdouble -> GLdouble -> GLint -> GLint -> GLdouble -> GLdouble -> GLint -> GLint -> Ptr GLdouble -> IO ())
ptr_glDeformationMap3dSGIX = unsafePerformIO $ getCommand "glDeformationMap3dSGIX"

-- glDeformationMap3fSGIX ------------------------------------------------------

glDeformationMap3fSGIX
  :: MonadIO m
  => GLenum -- ^ @target@ of type [FfdTargetSGIX](Graphics-GL-Groups.html#FfdTargetSGIX).
  -> GLfloat -- ^ @u1@ of type @CoordF@.
  -> GLfloat -- ^ @u2@ of type @CoordF@.
  -> GLint -- ^ @ustride@.
  -> GLint -- ^ @uorder@ of type @CheckedInt32@.
  -> GLfloat -- ^ @v1@ of type @CoordF@.
  -> GLfloat -- ^ @v2@ of type @CoordF@.
  -> GLint -- ^ @vstride@.
  -> GLint -- ^ @vorder@ of type @CheckedInt32@.
  -> GLfloat -- ^ @w1@ of type @CoordF@.
  -> GLfloat -- ^ @w2@ of type @CoordF@.
  -> GLint -- ^ @wstride@.
  -> GLint -- ^ @worder@ of type @CheckedInt32@.
  -> Ptr GLfloat -- ^ @points@ pointing to @COMPSIZE(target,ustride,uorder,vstride,vorder,wstride,worder)@ elements of type @CoordF@.
  -> m ()
glDeformationMap3fSGIX v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14 = liftIO $ dyn211 ptr_glDeformationMap3fSGIX v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 v13 v14

{-# NOINLINE ptr_glDeformationMap3fSGIX #-}
ptr_glDeformationMap3fSGIX :: FunPtr (GLenum -> GLfloat -> GLfloat -> GLint -> GLint -> GLfloat -> GLfloat -> GLint -> GLint -> GLfloat -> GLfloat -> GLint -> GLint -> Ptr GLfloat -> IO ())
ptr_glDeformationMap3fSGIX = unsafePerformIO $ getCommand "glDeformationMap3fSGIX"

-- glDeleteAsyncMarkersSGIX ----------------------------------------------------

glDeleteAsyncMarkersSGIX
  :: MonadIO m
  => GLuint -- ^ @marker@.
  -> GLsizei -- ^ @range@.
  -> m ()
glDeleteAsyncMarkersSGIX v1 v2 = liftIO $ dyn212 ptr_glDeleteAsyncMarkersSGIX v1 v2

{-# NOINLINE ptr_glDeleteAsyncMarkersSGIX #-}
ptr_glDeleteAsyncMarkersSGIX :: FunPtr (GLuint -> GLsizei -> IO ())
ptr_glDeleteAsyncMarkersSGIX = unsafePerformIO $ getCommand "glDeleteAsyncMarkersSGIX"

-- glDeleteBuffers -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDeleteBuffers.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteBuffers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteBuffers.xhtml OpenGL 4.x>.
glDeleteBuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @buffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteBuffers v1 v2 = liftIO $ dyn193 ptr_glDeleteBuffers v1 v2

{-# NOINLINE ptr_glDeleteBuffers #-}
ptr_glDeleteBuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteBuffers = unsafePerformIO $ getCommand "glDeleteBuffers"

-- glDeleteBuffersARB ----------------------------------------------------------

-- | This command is an alias for 'glDeleteBuffers'.
glDeleteBuffersARB
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @buffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteBuffersARB v1 v2 = liftIO $ dyn193 ptr_glDeleteBuffersARB v1 v2

{-# NOINLINE ptr_glDeleteBuffersARB #-}
ptr_glDeleteBuffersARB :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteBuffersARB = unsafePerformIO $ getCommand "glDeleteBuffersARB"

-- glDeleteCommandListsNV ------------------------------------------------------

glDeleteCommandListsNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @lists@.
  -> m ()
glDeleteCommandListsNV v1 v2 = liftIO $ dyn193 ptr_glDeleteCommandListsNV v1 v2

{-# NOINLINE ptr_glDeleteCommandListsNV #-}
ptr_glDeleteCommandListsNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteCommandListsNV = unsafePerformIO $ getCommand "glDeleteCommandListsNV"

-- glDeleteFencesAPPLE ---------------------------------------------------------

glDeleteFencesAPPLE
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @fences@ pointing to @n@ elements of type @FenceNV@.
  -> m ()
glDeleteFencesAPPLE v1 v2 = liftIO $ dyn193 ptr_glDeleteFencesAPPLE v1 v2

{-# NOINLINE ptr_glDeleteFencesAPPLE #-}
ptr_glDeleteFencesAPPLE :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteFencesAPPLE = unsafePerformIO $ getCommand "glDeleteFencesAPPLE"

-- glDeleteFencesNV ------------------------------------------------------------

glDeleteFencesNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @fences@ pointing to @n@ elements of type @FenceNV@.
  -> m ()
glDeleteFencesNV v1 v2 = liftIO $ dyn193 ptr_glDeleteFencesNV v1 v2

{-# NOINLINE ptr_glDeleteFencesNV #-}
ptr_glDeleteFencesNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteFencesNV = unsafePerformIO $ getCommand "glDeleteFencesNV"

-- glDeleteFragmentShaderATI ---------------------------------------------------

glDeleteFragmentShaderATI
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glDeleteFragmentShaderATI v1 = liftIO $ dyn2 ptr_glDeleteFragmentShaderATI v1

{-# NOINLINE ptr_glDeleteFragmentShaderATI #-}
ptr_glDeleteFragmentShaderATI :: FunPtr (GLuint -> IO ())
ptr_glDeleteFragmentShaderATI = unsafePerformIO $ getCommand "glDeleteFragmentShaderATI"

-- glDeleteFramebuffers --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteFramebuffers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteFramebuffers.xhtml OpenGL 4.x>.
glDeleteFramebuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @framebuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteFramebuffers v1 v2 = liftIO $ dyn193 ptr_glDeleteFramebuffers v1 v2

{-# NOINLINE ptr_glDeleteFramebuffers #-}
ptr_glDeleteFramebuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteFramebuffers = unsafePerformIO $ getCommand "glDeleteFramebuffers"

-- glDeleteFramebuffersEXT -----------------------------------------------------

-- | This command is an alias for 'glDeleteFramebuffers'.
glDeleteFramebuffersEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @framebuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteFramebuffersEXT v1 v2 = liftIO $ dyn193 ptr_glDeleteFramebuffersEXT v1 v2

{-# NOINLINE ptr_glDeleteFramebuffersEXT #-}
ptr_glDeleteFramebuffersEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteFramebuffersEXT = unsafePerformIO $ getCommand "glDeleteFramebuffersEXT"

-- glDeleteFramebuffersOES -----------------------------------------------------

glDeleteFramebuffersOES
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @framebuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteFramebuffersOES v1 v2 = liftIO $ dyn193 ptr_glDeleteFramebuffersOES v1 v2

{-# NOINLINE ptr_glDeleteFramebuffersOES #-}
ptr_glDeleteFramebuffersOES :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteFramebuffersOES = unsafePerformIO $ getCommand "glDeleteFramebuffersOES"

-- glDeleteLists ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glDeleteLists.xml OpenGL 2.x>.
glDeleteLists
  :: MonadIO m
  => GLuint -- ^ @list@ of type @List@.
  -> GLsizei -- ^ @range@.
  -> m ()
glDeleteLists v1 v2 = liftIO $ dyn212 ptr_glDeleteLists v1 v2

{-# NOINLINE ptr_glDeleteLists #-}
ptr_glDeleteLists :: FunPtr (GLuint -> GLsizei -> IO ())
ptr_glDeleteLists = unsafePerformIO $ getCommand "glDeleteLists"

-- glDeleteNamedStringARB ------------------------------------------------------

glDeleteNamedStringARB
  :: MonadIO m
  => GLint -- ^ @namelen@.
  -> Ptr GLchar -- ^ @name@ pointing to @namelen@ elements of type @GLchar@.
  -> m ()
glDeleteNamedStringARB v1 v2 = liftIO $ dyn213 ptr_glDeleteNamedStringARB v1 v2

{-# NOINLINE ptr_glDeleteNamedStringARB #-}
ptr_glDeleteNamedStringARB :: FunPtr (GLint -> Ptr GLchar -> IO ())
ptr_glDeleteNamedStringARB = unsafePerformIO $ getCommand "glDeleteNamedStringARB"

-- glDeleteNamesAMD ------------------------------------------------------------

glDeleteNamesAMD
  :: MonadIO m
  => GLenum -- ^ @identifier@.
  -> GLuint -- ^ @num@.
  -> Ptr GLuint -- ^ @names@ pointing to @num@ elements of type @GLuint@.
  -> m ()
glDeleteNamesAMD v1 v2 v3 = liftIO $ dyn214 ptr_glDeleteNamesAMD v1 v2 v3

{-# NOINLINE ptr_glDeleteNamesAMD #-}
ptr_glDeleteNamesAMD :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
ptr_glDeleteNamesAMD = unsafePerformIO $ getCommand "glDeleteNamesAMD"

-- glDeleteObjectARB -----------------------------------------------------------

glDeleteObjectARB
  :: MonadIO m
  => GLhandleARB -- ^ @obj@ of type @handleARB@.
  -> m ()
glDeleteObjectARB v1 = liftIO $ dyn137 ptr_glDeleteObjectARB v1

{-# NOINLINE ptr_glDeleteObjectARB #-}
ptr_glDeleteObjectARB :: FunPtr (GLhandleARB -> IO ())
ptr_glDeleteObjectARB = unsafePerformIO $ getCommand "glDeleteObjectARB"

-- glDeleteOcclusionQueriesNV --------------------------------------------------

glDeleteOcclusionQueriesNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteOcclusionQueriesNV v1 v2 = liftIO $ dyn193 ptr_glDeleteOcclusionQueriesNV v1 v2

{-# NOINLINE ptr_glDeleteOcclusionQueriesNV #-}
ptr_glDeleteOcclusionQueriesNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteOcclusionQueriesNV = unsafePerformIO $ getCommand "glDeleteOcclusionQueriesNV"

-- glDeletePathsNV -------------------------------------------------------------

glDeletePathsNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> GLsizei -- ^ @range@.
  -> m ()
glDeletePathsNV v1 v2 = liftIO $ dyn212 ptr_glDeletePathsNV v1 v2

{-# NOINLINE ptr_glDeletePathsNV #-}
ptr_glDeletePathsNV :: FunPtr (GLuint -> GLsizei -> IO ())
ptr_glDeletePathsNV = unsafePerformIO $ getCommand "glDeletePathsNV"

-- glDeletePerfMonitorsAMD -----------------------------------------------------

glDeletePerfMonitorsAMD
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @monitors@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeletePerfMonitorsAMD v1 v2 = liftIO $ dyn193 ptr_glDeletePerfMonitorsAMD v1 v2

{-# NOINLINE ptr_glDeletePerfMonitorsAMD #-}
ptr_glDeletePerfMonitorsAMD :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeletePerfMonitorsAMD = unsafePerformIO $ getCommand "glDeletePerfMonitorsAMD"

-- glDeletePerfQueryINTEL ------------------------------------------------------

glDeletePerfQueryINTEL
  :: MonadIO m
  => GLuint -- ^ @queryHandle@.
  -> m ()
glDeletePerfQueryINTEL v1 = liftIO $ dyn2 ptr_glDeletePerfQueryINTEL v1

{-# NOINLINE ptr_glDeletePerfQueryINTEL #-}
ptr_glDeletePerfQueryINTEL :: FunPtr (GLuint -> IO ())
ptr_glDeletePerfQueryINTEL = unsafePerformIO $ getCommand "glDeletePerfQueryINTEL"

-- glDeleteProgram -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDeleteProgram.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteProgram.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteProgram.xhtml OpenGL 4.x>.
glDeleteProgram
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> m ()
glDeleteProgram v1 = liftIO $ dyn2 ptr_glDeleteProgram v1

{-# NOINLINE ptr_glDeleteProgram #-}
ptr_glDeleteProgram :: FunPtr (GLuint -> IO ())
ptr_glDeleteProgram = unsafePerformIO $ getCommand "glDeleteProgram"

-- glDeleteProgramPipelines ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDeleteProgramPipelines.xhtml OpenGL 4.x>.
glDeleteProgramPipelines
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @pipelines@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteProgramPipelines v1 v2 = liftIO $ dyn193 ptr_glDeleteProgramPipelines v1 v2

{-# NOINLINE ptr_glDeleteProgramPipelines #-}
ptr_glDeleteProgramPipelines :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteProgramPipelines = unsafePerformIO $ getCommand "glDeleteProgramPipelines"

-- glDeleteProgramPipelinesEXT -------------------------------------------------

glDeleteProgramPipelinesEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @pipelines@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteProgramPipelinesEXT v1 v2 = liftIO $ dyn193 ptr_glDeleteProgramPipelinesEXT v1 v2

{-# NOINLINE ptr_glDeleteProgramPipelinesEXT #-}
ptr_glDeleteProgramPipelinesEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteProgramPipelinesEXT = unsafePerformIO $ getCommand "glDeleteProgramPipelinesEXT"

-- glDeleteProgramsARB ---------------------------------------------------------

glDeleteProgramsARB
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @programs@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteProgramsARB v1 v2 = liftIO $ dyn193 ptr_glDeleteProgramsARB v1 v2

{-# NOINLINE ptr_glDeleteProgramsARB #-}
ptr_glDeleteProgramsARB :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteProgramsARB = unsafePerformIO $ getCommand "glDeleteProgramsARB"

-- glDeleteProgramsNV ----------------------------------------------------------

-- | This command is an alias for 'glDeleteProgramsARB'.
glDeleteProgramsNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @programs@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteProgramsNV v1 v2 = liftIO $ dyn193 ptr_glDeleteProgramsNV v1 v2

{-# NOINLINE ptr_glDeleteProgramsNV #-}
ptr_glDeleteProgramsNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteProgramsNV = unsafePerformIO $ getCommand "glDeleteProgramsNV"

-- glDeleteQueries -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDeleteQueries.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteQueries.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteQueries.xhtml OpenGL 4.x>.
glDeleteQueries
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteQueries v1 v2 = liftIO $ dyn193 ptr_glDeleteQueries v1 v2

{-# NOINLINE ptr_glDeleteQueries #-}
ptr_glDeleteQueries :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteQueries = unsafePerformIO $ getCommand "glDeleteQueries"

-- glDeleteQueriesARB ----------------------------------------------------------

-- | This command is an alias for 'glDeleteQueries'.
glDeleteQueriesARB
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteQueriesARB v1 v2 = liftIO $ dyn193 ptr_glDeleteQueriesARB v1 v2

{-# NOINLINE ptr_glDeleteQueriesARB #-}
ptr_glDeleteQueriesARB :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteQueriesARB = unsafePerformIO $ getCommand "glDeleteQueriesARB"

-- glDeleteQueriesEXT ----------------------------------------------------------

glDeleteQueriesEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteQueriesEXT v1 v2 = liftIO $ dyn193 ptr_glDeleteQueriesEXT v1 v2

{-# NOINLINE ptr_glDeleteQueriesEXT #-}
ptr_glDeleteQueriesEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteQueriesEXT = unsafePerformIO $ getCommand "glDeleteQueriesEXT"

-- glDeleteRenderbuffers -------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteRenderbuffers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteRenderbuffers.xhtml OpenGL 4.x>.
glDeleteRenderbuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @renderbuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteRenderbuffers v1 v2 = liftIO $ dyn193 ptr_glDeleteRenderbuffers v1 v2

{-# NOINLINE ptr_glDeleteRenderbuffers #-}
ptr_glDeleteRenderbuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteRenderbuffers = unsafePerformIO $ getCommand "glDeleteRenderbuffers"

-- glDeleteRenderbuffersEXT ----------------------------------------------------

-- | This command is an alias for 'glDeleteRenderbuffers'.
glDeleteRenderbuffersEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @renderbuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteRenderbuffersEXT v1 v2 = liftIO $ dyn193 ptr_glDeleteRenderbuffersEXT v1 v2

{-# NOINLINE ptr_glDeleteRenderbuffersEXT #-}
ptr_glDeleteRenderbuffersEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteRenderbuffersEXT = unsafePerformIO $ getCommand "glDeleteRenderbuffersEXT"

-- glDeleteRenderbuffersOES ----------------------------------------------------

glDeleteRenderbuffersOES
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @renderbuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteRenderbuffersOES v1 v2 = liftIO $ dyn193 ptr_glDeleteRenderbuffersOES v1 v2

{-# NOINLINE ptr_glDeleteRenderbuffersOES #-}
ptr_glDeleteRenderbuffersOES :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteRenderbuffersOES = unsafePerformIO $ getCommand "glDeleteRenderbuffersOES"

-- glDeleteSamplers ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteSamplers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteSamplers.xhtml OpenGL 4.x>.
glDeleteSamplers
  :: MonadIO m
  => GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @samplers@ pointing to @count@ elements of type @GLuint@.
  -> m ()
glDeleteSamplers v1 v2 = liftIO $ dyn193 ptr_glDeleteSamplers v1 v2

{-# NOINLINE ptr_glDeleteSamplers #-}
ptr_glDeleteSamplers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteSamplers = unsafePerformIO $ getCommand "glDeleteSamplers"

-- glDeleteShader --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDeleteShader.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteShader.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteShader.xhtml OpenGL 4.x>.
glDeleteShader
  :: MonadIO m
  => GLuint -- ^ @shader@.
  -> m ()
glDeleteShader v1 = liftIO $ dyn2 ptr_glDeleteShader v1

{-# NOINLINE ptr_glDeleteShader #-}
ptr_glDeleteShader :: FunPtr (GLuint -> IO ())
ptr_glDeleteShader = unsafePerformIO $ getCommand "glDeleteShader"

-- glDeleteStatesNV ------------------------------------------------------------

glDeleteStatesNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @states@.
  -> m ()
glDeleteStatesNV v1 v2 = liftIO $ dyn193 ptr_glDeleteStatesNV v1 v2

{-# NOINLINE ptr_glDeleteStatesNV #-}
ptr_glDeleteStatesNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteStatesNV = unsafePerformIO $ getCommand "glDeleteStatesNV"

-- glDeleteSync ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteSync.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteSync.xhtml OpenGL 4.x>.
glDeleteSync
  :: MonadIO m
  => GLsync -- ^ @sync@ of type @sync@.
  -> m ()
glDeleteSync v1 = liftIO $ dyn215 ptr_glDeleteSync v1

{-# NOINLINE ptr_glDeleteSync #-}
ptr_glDeleteSync :: FunPtr (GLsync -> IO ())
ptr_glDeleteSync = unsafePerformIO $ getCommand "glDeleteSync"

-- glDeleteSyncAPPLE -----------------------------------------------------------

-- | This command is an alias for 'glDeleteSync'.
glDeleteSyncAPPLE
  :: MonadIO m
  => GLsync -- ^ @sync@.
  -> m ()
glDeleteSyncAPPLE v1 = liftIO $ dyn215 ptr_glDeleteSyncAPPLE v1

{-# NOINLINE ptr_glDeleteSyncAPPLE #-}
ptr_glDeleteSyncAPPLE :: FunPtr (GLsync -> IO ())
ptr_glDeleteSyncAPPLE = unsafePerformIO $ getCommand "glDeleteSyncAPPLE"

-- glDeleteTextures ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDeleteTextures.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteTextures.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteTextures.xhtml OpenGL 4.x>.
glDeleteTextures
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @textures@ pointing to @n@ elements of type @Texture@.
  -> m ()
glDeleteTextures v1 v2 = liftIO $ dyn193 ptr_glDeleteTextures v1 v2

{-# NOINLINE ptr_glDeleteTextures #-}
ptr_glDeleteTextures :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteTextures = unsafePerformIO $ getCommand "glDeleteTextures"

-- glDeleteTexturesEXT ---------------------------------------------------------

glDeleteTexturesEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @textures@ pointing to @n@ elements of type @Texture@.
  -> m ()
glDeleteTexturesEXT v1 v2 = liftIO $ dyn193 ptr_glDeleteTexturesEXT v1 v2

{-# NOINLINE ptr_glDeleteTexturesEXT #-}
ptr_glDeleteTexturesEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteTexturesEXT = unsafePerformIO $ getCommand "glDeleteTexturesEXT"

-- glDeleteTransformFeedbacks --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDeleteTransformFeedbacks.xhtml OpenGL 4.x>.
glDeleteTransformFeedbacks
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteTransformFeedbacks v1 v2 = liftIO $ dyn193 ptr_glDeleteTransformFeedbacks v1 v2

{-# NOINLINE ptr_glDeleteTransformFeedbacks #-}
ptr_glDeleteTransformFeedbacks :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteTransformFeedbacks = unsafePerformIO $ getCommand "glDeleteTransformFeedbacks"

-- glDeleteTransformFeedbacksNV ------------------------------------------------

-- | This command is an alias for 'glDeleteTransformFeedbacks'.
glDeleteTransformFeedbacksNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteTransformFeedbacksNV v1 v2 = liftIO $ dyn193 ptr_glDeleteTransformFeedbacksNV v1 v2

{-# NOINLINE ptr_glDeleteTransformFeedbacksNV #-}
ptr_glDeleteTransformFeedbacksNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteTransformFeedbacksNV = unsafePerformIO $ getCommand "glDeleteTransformFeedbacksNV"

-- glDeleteVertexArrays --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDeleteVertexArrays.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDeleteVertexArrays.xhtml OpenGL 4.x>.
glDeleteVertexArrays
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @arrays@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteVertexArrays v1 v2 = liftIO $ dyn193 ptr_glDeleteVertexArrays v1 v2

{-# NOINLINE ptr_glDeleteVertexArrays #-}
ptr_glDeleteVertexArrays :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteVertexArrays = unsafePerformIO $ getCommand "glDeleteVertexArrays"

-- glDeleteVertexArraysAPPLE ---------------------------------------------------

-- | This command is an alias for 'glDeleteVertexArrays'.
glDeleteVertexArraysAPPLE
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @arrays@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteVertexArraysAPPLE v1 v2 = liftIO $ dyn193 ptr_glDeleteVertexArraysAPPLE v1 v2

{-# NOINLINE ptr_glDeleteVertexArraysAPPLE #-}
ptr_glDeleteVertexArraysAPPLE :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteVertexArraysAPPLE = unsafePerformIO $ getCommand "glDeleteVertexArraysAPPLE"

-- glDeleteVertexArraysOES -----------------------------------------------------

-- | This command is an alias for 'glDeleteVertexArrays'.
glDeleteVertexArraysOES
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @arrays@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glDeleteVertexArraysOES v1 v2 = liftIO $ dyn193 ptr_glDeleteVertexArraysOES v1 v2

{-# NOINLINE ptr_glDeleteVertexArraysOES #-}
ptr_glDeleteVertexArraysOES :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glDeleteVertexArraysOES = unsafePerformIO $ getCommand "glDeleteVertexArraysOES"

-- glDeleteVertexShaderEXT -----------------------------------------------------

glDeleteVertexShaderEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glDeleteVertexShaderEXT v1 = liftIO $ dyn2 ptr_glDeleteVertexShaderEXT v1

{-# NOINLINE ptr_glDeleteVertexShaderEXT #-}
ptr_glDeleteVertexShaderEXT :: FunPtr (GLuint -> IO ())
ptr_glDeleteVertexShaderEXT = unsafePerformIO $ getCommand "glDeleteVertexShaderEXT"

-- glDepthBoundsEXT ------------------------------------------------------------

glDepthBoundsEXT
  :: MonadIO m
  => GLclampd -- ^ @zmin@ of type @ClampedFloat64@.
  -> GLclampd -- ^ @zmax@ of type @ClampedFloat64@.
  -> m ()
glDepthBoundsEXT v1 v2 = liftIO $ dyn216 ptr_glDepthBoundsEXT v1 v2

{-# NOINLINE ptr_glDepthBoundsEXT #-}
ptr_glDepthBoundsEXT :: FunPtr (GLclampd -> GLclampd -> IO ())
ptr_glDepthBoundsEXT = unsafePerformIO $ getCommand "glDepthBoundsEXT"

-- glDepthBoundsdNV ------------------------------------------------------------

glDepthBoundsdNV
  :: MonadIO m
  => GLdouble -- ^ @zmin@.
  -> GLdouble -- ^ @zmax@.
  -> m ()
glDepthBoundsdNV v1 v2 = liftIO $ dyn217 ptr_glDepthBoundsdNV v1 v2

{-# NOINLINE ptr_glDepthBoundsdNV #-}
ptr_glDepthBoundsdNV :: FunPtr (GLdouble -> GLdouble -> IO ())
ptr_glDepthBoundsdNV = unsafePerformIO $ getCommand "glDepthBoundsdNV"

-- glDepthFunc -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDepthFunc.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDepthFunc.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDepthFunc.xhtml OpenGL 4.x>.
glDepthFunc
  :: MonadIO m
  => GLenum -- ^ @func@ of type [DepthFunction](Graphics-GL-Groups.html#DepthFunction).
  -> m ()
glDepthFunc v1 = liftIO $ dyn4 ptr_glDepthFunc v1

{-# NOINLINE ptr_glDepthFunc #-}
ptr_glDepthFunc :: FunPtr (GLenum -> IO ())
ptr_glDepthFunc = unsafePerformIO $ getCommand "glDepthFunc"

-- glDepthMask -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDepthMask.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDepthMask.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDepthMask.xhtml OpenGL 4.x>.
glDepthMask
  :: MonadIO m
  => GLboolean -- ^ @flag@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glDepthMask v1 = liftIO $ dyn191 ptr_glDepthMask v1

{-# NOINLINE ptr_glDepthMask #-}
ptr_glDepthMask :: FunPtr (GLboolean -> IO ())
ptr_glDepthMask = unsafePerformIO $ getCommand "glDepthMask"

-- glDepthRange ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDepthRange.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDepthRange.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDepthRange.xhtml OpenGL 4.x>.
glDepthRange
  :: MonadIO m
  => GLdouble -- ^ @near@.
  -> GLdouble -- ^ @far@.
  -> m ()
glDepthRange v1 v2 = liftIO $ dyn217 ptr_glDepthRange v1 v2

{-# NOINLINE ptr_glDepthRange #-}
ptr_glDepthRange :: FunPtr (GLdouble -> GLdouble -> IO ())
ptr_glDepthRange = unsafePerformIO $ getCommand "glDepthRange"

-- glDepthRangeArrayfvNV -------------------------------------------------------

glDepthRangeArrayfvNV
  :: MonadIO m
  => GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLfloat -- ^ @v@.
  -> m ()
glDepthRangeArrayfvNV v1 v2 v3 = liftIO $ dyn218 ptr_glDepthRangeArrayfvNV v1 v2 v3

{-# NOINLINE ptr_glDepthRangeArrayfvNV #-}
ptr_glDepthRangeArrayfvNV :: FunPtr (GLuint -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glDepthRangeArrayfvNV = unsafePerformIO $ getCommand "glDepthRangeArrayfvNV"

-- glDepthRangeArrayv ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDepthRangeArray.xhtml OpenGL 4.x>.
glDepthRangeArrayv
  :: MonadIO m
  => GLuint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLdouble -- ^ @v@ pointing to @COMPSIZE(count)@ elements of type @GLdouble@.
  -> m ()
glDepthRangeArrayv v1 v2 v3 = liftIO $ dyn219 ptr_glDepthRangeArrayv v1 v2 v3

{-# NOINLINE ptr_glDepthRangeArrayv #-}
ptr_glDepthRangeArrayv :: FunPtr (GLuint -> GLsizei -> Ptr GLdouble -> IO ())
ptr_glDepthRangeArrayv = unsafePerformIO $ getCommand "glDepthRangeArrayv"

-- glDepthRangeIndexed ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDepthRangeIndexed.xhtml OpenGL 4.x>.
glDepthRangeIndexed
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLdouble -- ^ @n@.
  -> GLdouble -- ^ @f@.
  -> m ()
glDepthRangeIndexed v1 v2 v3 = liftIO $ dyn220 ptr_glDepthRangeIndexed v1 v2 v3

{-# NOINLINE ptr_glDepthRangeIndexed #-}
ptr_glDepthRangeIndexed :: FunPtr (GLuint -> GLdouble -> GLdouble -> IO ())
ptr_glDepthRangeIndexed = unsafePerformIO $ getCommand "glDepthRangeIndexed"

-- glDepthRangeIndexedfNV ------------------------------------------------------

glDepthRangeIndexedfNV
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLfloat -- ^ @n@.
  -> GLfloat -- ^ @f@.
  -> m ()
glDepthRangeIndexedfNV v1 v2 v3 = liftIO $ dyn221 ptr_glDepthRangeIndexedfNV v1 v2 v3

{-# NOINLINE ptr_glDepthRangeIndexedfNV #-}
ptr_glDepthRangeIndexedfNV :: FunPtr (GLuint -> GLfloat -> GLfloat -> IO ())
ptr_glDepthRangeIndexedfNV = unsafePerformIO $ getCommand "glDepthRangeIndexedfNV"

-- glDepthRangedNV -------------------------------------------------------------

glDepthRangedNV
  :: MonadIO m
  => GLdouble -- ^ @zNear@.
  -> GLdouble -- ^ @zFar@.
  -> m ()
glDepthRangedNV v1 v2 = liftIO $ dyn217 ptr_glDepthRangedNV v1 v2

{-# NOINLINE ptr_glDepthRangedNV #-}
ptr_glDepthRangedNV :: FunPtr (GLdouble -> GLdouble -> IO ())
ptr_glDepthRangedNV = unsafePerformIO $ getCommand "glDepthRangedNV"

-- glDepthRangef ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDepthRange.xhtml OpenGL 4.x>.
glDepthRangef
  :: MonadIO m
  => GLfloat -- ^ @n@.
  -> GLfloat -- ^ @f@.
  -> m ()
glDepthRangef v1 v2 = liftIO $ dyn222 ptr_glDepthRangef v1 v2

{-# NOINLINE ptr_glDepthRangef #-}
ptr_glDepthRangef :: FunPtr (GLfloat -> GLfloat -> IO ())
ptr_glDepthRangef = unsafePerformIO $ getCommand "glDepthRangef"

-- glDepthRangefOES ------------------------------------------------------------

-- | This command is an alias for 'glDepthRangef'.
glDepthRangefOES
  :: MonadIO m
  => GLclampf -- ^ @n@ of type @ClampedFloat32@.
  -> GLclampf -- ^ @f@ of type @ClampedFloat32@.
  -> m ()
glDepthRangefOES v1 v2 = liftIO $ dyn223 ptr_glDepthRangefOES v1 v2

{-# NOINLINE ptr_glDepthRangefOES #-}
ptr_glDepthRangefOES :: FunPtr (GLclampf -> GLclampf -> IO ())
ptr_glDepthRangefOES = unsafePerformIO $ getCommand "glDepthRangefOES"

-- glDepthRangex ---------------------------------------------------------------

glDepthRangex
  :: MonadIO m
  => GLfixed -- ^ @n@.
  -> GLfixed -- ^ @f@.
  -> m ()
glDepthRangex v1 v2 = liftIO $ dyn224 ptr_glDepthRangex v1 v2

{-# NOINLINE ptr_glDepthRangex #-}
ptr_glDepthRangex :: FunPtr (GLfixed -> GLfixed -> IO ())
ptr_glDepthRangex = unsafePerformIO $ getCommand "glDepthRangex"

-- glDepthRangexOES ------------------------------------------------------------

glDepthRangexOES
  :: MonadIO m
  => GLfixed -- ^ @n@ of type @ClampedFixed@.
  -> GLfixed -- ^ @f@ of type @ClampedFixed@.
  -> m ()
glDepthRangexOES v1 v2 = liftIO $ dyn224 ptr_glDepthRangexOES v1 v2

{-# NOINLINE ptr_glDepthRangexOES #-}
ptr_glDepthRangexOES :: FunPtr (GLfixed -> GLfixed -> IO ())
ptr_glDepthRangexOES = unsafePerformIO $ getCommand "glDepthRangexOES"

-- glDetachObjectARB -----------------------------------------------------------

-- | This command is an alias for 'glDetachShader'.
glDetachObjectARB
  :: MonadIO m
  => GLhandleARB -- ^ @containerObj@ of type @handleARB@.
  -> GLhandleARB -- ^ @attachedObj@ of type @handleARB@.
  -> m ()
glDetachObjectARB v1 v2 = liftIO $ dyn14 ptr_glDetachObjectARB v1 v2

{-# NOINLINE ptr_glDetachObjectARB #-}
ptr_glDetachObjectARB :: FunPtr (GLhandleARB -> GLhandleARB -> IO ())
ptr_glDetachObjectARB = unsafePerformIO $ getCommand "glDetachObjectARB"

-- glDetachShader --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDetachShader.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDetachShader.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDetachShader.xhtml OpenGL 4.x>.
glDetachShader
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @shader@.
  -> m ()
glDetachShader v1 v2 = liftIO $ dyn3 ptr_glDetachShader v1 v2

{-# NOINLINE ptr_glDetachShader #-}
ptr_glDetachShader :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glDetachShader = unsafePerformIO $ getCommand "glDetachShader"

-- glDetailTexFuncSGIS ---------------------------------------------------------

glDetailTexFuncSGIS
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLsizei -- ^ @n@.
  -> Ptr GLfloat -- ^ @points@ pointing to @n*2@ elements of type @GLfloat@.
  -> m ()
glDetailTexFuncSGIS v1 v2 v3 = liftIO $ dyn225 ptr_glDetailTexFuncSGIS v1 v2 v3

{-# NOINLINE ptr_glDetailTexFuncSGIS #-}
ptr_glDetailTexFuncSGIS :: FunPtr (GLenum -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glDetailTexFuncSGIS = unsafePerformIO $ getCommand "glDetailTexFuncSGIS"

-- glDisable -------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glEnable.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glEnable.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glEnable.xhtml OpenGL 4.x>.
glDisable
  :: MonadIO m
  => GLenum -- ^ @cap@ of type [EnableCap](Graphics-GL-Groups.html#EnableCap).
  -> m ()
glDisable v1 = liftIO $ dyn4 ptr_glDisable v1

{-# NOINLINE ptr_glDisable #-}
ptr_glDisable :: FunPtr (GLenum -> IO ())
ptr_glDisable = unsafePerformIO $ getCommand "glDisable"

-- glDisableClientState --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEnableClientState.xml OpenGL 2.x>.
glDisableClientState
  :: MonadIO m
  => GLenum -- ^ @array@ of type [EnableCap](Graphics-GL-Groups.html#EnableCap).
  -> m ()
glDisableClientState v1 = liftIO $ dyn4 ptr_glDisableClientState v1

{-# NOINLINE ptr_glDisableClientState #-}
ptr_glDisableClientState :: FunPtr (GLenum -> IO ())
ptr_glDisableClientState = unsafePerformIO $ getCommand "glDisableClientState"

-- glDisableClientStateIndexedEXT ----------------------------------------------

glDisableClientStateIndexedEXT
  :: MonadIO m
  => GLenum -- ^ @array@ of type [EnableCap](Graphics-GL-Groups.html#EnableCap).
  -> GLuint -- ^ @index@.
  -> m ()
glDisableClientStateIndexedEXT v1 v2 = liftIO $ dyn16 ptr_glDisableClientStateIndexedEXT v1 v2

{-# NOINLINE ptr_glDisableClientStateIndexedEXT #-}
ptr_glDisableClientStateIndexedEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDisableClientStateIndexedEXT = unsafePerformIO $ getCommand "glDisableClientStateIndexedEXT"

-- glDisableClientStateiEXT ----------------------------------------------------

glDisableClientStateiEXT
  :: MonadIO m
  => GLenum -- ^ @array@ of type [EnableCap](Graphics-GL-Groups.html#EnableCap).
  -> GLuint -- ^ @index@.
  -> m ()
glDisableClientStateiEXT v1 v2 = liftIO $ dyn16 ptr_glDisableClientStateiEXT v1 v2

{-# NOINLINE ptr_glDisableClientStateiEXT #-}
ptr_glDisableClientStateiEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDisableClientStateiEXT = unsafePerformIO $ getCommand "glDisableClientStateiEXT"

-- glDisableDriverControlQCOM --------------------------------------------------

glDisableDriverControlQCOM
  :: MonadIO m
  => GLuint -- ^ @driverControl@.
  -> m ()
glDisableDriverControlQCOM v1 = liftIO $ dyn2 ptr_glDisableDriverControlQCOM v1

{-# NOINLINE ptr_glDisableDriverControlQCOM #-}
ptr_glDisableDriverControlQCOM :: FunPtr (GLuint -> IO ())
ptr_glDisableDriverControlQCOM = unsafePerformIO $ getCommand "glDisableDriverControlQCOM"

-- glDisableIndexedEXT ---------------------------------------------------------

-- | This command is an alias for 'glDisablei'.
glDisableIndexedEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisableIndexedEXT v1 v2 = liftIO $ dyn16 ptr_glDisableIndexedEXT v1 v2

{-# NOINLINE ptr_glDisableIndexedEXT #-}
ptr_glDisableIndexedEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDisableIndexedEXT = unsafePerformIO $ getCommand "glDisableIndexedEXT"

-- glDisableVariantClientStateEXT ----------------------------------------------

glDisableVariantClientStateEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glDisableVariantClientStateEXT v1 = liftIO $ dyn2 ptr_glDisableVariantClientStateEXT v1

{-# NOINLINE ptr_glDisableVariantClientStateEXT #-}
ptr_glDisableVariantClientStateEXT :: FunPtr (GLuint -> IO ())
ptr_glDisableVariantClientStateEXT = unsafePerformIO $ getCommand "glDisableVariantClientStateEXT"

-- glDisableVertexArrayAttrib --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glEnableVertexAttribArray.xhtml OpenGL 4.x>.
glDisableVertexArrayAttrib
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisableVertexArrayAttrib v1 v2 = liftIO $ dyn3 ptr_glDisableVertexArrayAttrib v1 v2

{-# NOINLINE ptr_glDisableVertexArrayAttrib #-}
ptr_glDisableVertexArrayAttrib :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glDisableVertexArrayAttrib = unsafePerformIO $ getCommand "glDisableVertexArrayAttrib"

-- glDisableVertexArrayAttribEXT -----------------------------------------------

glDisableVertexArrayAttribEXT
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisableVertexArrayAttribEXT v1 v2 = liftIO $ dyn3 ptr_glDisableVertexArrayAttribEXT v1 v2

{-# NOINLINE ptr_glDisableVertexArrayAttribEXT #-}
ptr_glDisableVertexArrayAttribEXT :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glDisableVertexArrayAttribEXT = unsafePerformIO $ getCommand "glDisableVertexArrayAttribEXT"

-- glDisableVertexArrayEXT -----------------------------------------------------

glDisableVertexArrayEXT
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLenum -- ^ @array@ of type [EnableCap](Graphics-GL-Groups.html#EnableCap).
  -> m ()
glDisableVertexArrayEXT v1 v2 = liftIO $ dyn15 ptr_glDisableVertexArrayEXT v1 v2

{-# NOINLINE ptr_glDisableVertexArrayEXT #-}
ptr_glDisableVertexArrayEXT :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glDisableVertexArrayEXT = unsafePerformIO $ getCommand "glDisableVertexArrayEXT"

-- glDisableVertexAttribAPPLE --------------------------------------------------

glDisableVertexAttribAPPLE
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> m ()
glDisableVertexAttribAPPLE v1 v2 = liftIO $ dyn15 ptr_glDisableVertexAttribAPPLE v1 v2

{-# NOINLINE ptr_glDisableVertexAttribAPPLE #-}
ptr_glDisableVertexAttribAPPLE :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glDisableVertexAttribAPPLE = unsafePerformIO $ getCommand "glDisableVertexAttribAPPLE"

-- glDisableVertexAttribArray --------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glEnableVertexAttribArray.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glEnableVertexAttribArray.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glEnableVertexAttribArray.xhtml OpenGL 4.x>.
glDisableVertexAttribArray
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> m ()
glDisableVertexAttribArray v1 = liftIO $ dyn2 ptr_glDisableVertexAttribArray v1

{-# NOINLINE ptr_glDisableVertexAttribArray #-}
ptr_glDisableVertexAttribArray :: FunPtr (GLuint -> IO ())
ptr_glDisableVertexAttribArray = unsafePerformIO $ getCommand "glDisableVertexAttribArray"

-- glDisableVertexAttribArrayARB -----------------------------------------------

-- | This command is an alias for 'glDisableVertexAttribArray'.
glDisableVertexAttribArrayARB
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> m ()
glDisableVertexAttribArrayARB v1 = liftIO $ dyn2 ptr_glDisableVertexAttribArrayARB v1

{-# NOINLINE ptr_glDisableVertexAttribArrayARB #-}
ptr_glDisableVertexAttribArrayARB :: FunPtr (GLuint -> IO ())
ptr_glDisableVertexAttribArrayARB = unsafePerformIO $ getCommand "glDisableVertexAttribArrayARB"

-- glDisablei ------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glEnable.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glEnable.xhtml OpenGL 4.x>.
glDisablei
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisablei v1 v2 = liftIO $ dyn16 ptr_glDisablei v1 v2

{-# NOINLINE ptr_glDisablei #-}
ptr_glDisablei :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDisablei = unsafePerformIO $ getCommand "glDisablei"

-- glDisableiEXT ---------------------------------------------------------------

-- | This command is an alias for 'glDisablei'.
glDisableiEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisableiEXT v1 v2 = liftIO $ dyn16 ptr_glDisableiEXT v1 v2

{-# NOINLINE ptr_glDisableiEXT #-}
ptr_glDisableiEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDisableiEXT = unsafePerformIO $ getCommand "glDisableiEXT"

-- glDisableiNV ----------------------------------------------------------------

-- | This command is an alias for 'glDisablei'.
glDisableiNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisableiNV v1 v2 = liftIO $ dyn16 ptr_glDisableiNV v1 v2

{-# NOINLINE ptr_glDisableiNV #-}
ptr_glDisableiNV :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDisableiNV = unsafePerformIO $ getCommand "glDisableiNV"

-- glDisableiOES ---------------------------------------------------------------

-- | This command is an alias for 'glDisablei'.
glDisableiOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glDisableiOES v1 v2 = liftIO $ dyn16 ptr_glDisableiOES v1 v2

{-# NOINLINE ptr_glDisableiOES #-}
ptr_glDisableiOES :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDisableiOES = unsafePerformIO $ getCommand "glDisableiOES"

-- glDiscardFramebufferEXT -----------------------------------------------------

glDiscardFramebufferEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLsizei -- ^ @numAttachments@.
  -> Ptr GLenum -- ^ @attachments@ pointing to @numAttachments@ elements of type @GLenum@.
  -> m ()
glDiscardFramebufferEXT v1 v2 v3 = liftIO $ dyn226 ptr_glDiscardFramebufferEXT v1 v2 v3

{-# NOINLINE ptr_glDiscardFramebufferEXT #-}
ptr_glDiscardFramebufferEXT :: FunPtr (GLenum -> GLsizei -> Ptr GLenum -> IO ())
ptr_glDiscardFramebufferEXT = unsafePerformIO $ getCommand "glDiscardFramebufferEXT"

-- glDispatchCompute -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDispatchCompute.xhtml OpenGL 4.x>.
glDispatchCompute
  :: MonadIO m
  => GLuint -- ^ @num_groups_x@.
  -> GLuint -- ^ @num_groups_y@.
  -> GLuint -- ^ @num_groups_z@.
  -> m ()
glDispatchCompute v1 v2 v3 = liftIO $ dyn102 ptr_glDispatchCompute v1 v2 v3

{-# NOINLINE ptr_glDispatchCompute #-}
ptr_glDispatchCompute :: FunPtr (GLuint -> GLuint -> GLuint -> IO ())
ptr_glDispatchCompute = unsafePerformIO $ getCommand "glDispatchCompute"

-- glDispatchComputeGroupSizeARB -----------------------------------------------

glDispatchComputeGroupSizeARB
  :: MonadIO m
  => GLuint -- ^ @num_groups_x@.
  -> GLuint -- ^ @num_groups_y@.
  -> GLuint -- ^ @num_groups_z@.
  -> GLuint -- ^ @group_size_x@.
  -> GLuint -- ^ @group_size_y@.
  -> GLuint -- ^ @group_size_z@.
  -> m ()
glDispatchComputeGroupSizeARB v1 v2 v3 v4 v5 v6 = liftIO $ dyn227 ptr_glDispatchComputeGroupSizeARB v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDispatchComputeGroupSizeARB #-}
ptr_glDispatchComputeGroupSizeARB :: FunPtr (GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> GLuint -> IO ())
ptr_glDispatchComputeGroupSizeARB = unsafePerformIO $ getCommand "glDispatchComputeGroupSizeARB"

-- glDispatchComputeIndirect ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDispatchComputeIndirect.xhtml OpenGL 4.x>.
glDispatchComputeIndirect
  :: MonadIO m
  => GLintptr -- ^ @indirect@ of type @BufferOffset@.
  -> m ()
glDispatchComputeIndirect v1 = liftIO $ dyn228 ptr_glDispatchComputeIndirect v1

{-# NOINLINE ptr_glDispatchComputeIndirect #-}
ptr_glDispatchComputeIndirect :: FunPtr (GLintptr -> IO ())
ptr_glDispatchComputeIndirect = unsafePerformIO $ getCommand "glDispatchComputeIndirect"

-- glDrawArrays ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDrawArrays.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawArrays.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawArrays.xhtml OpenGL 4.x>.
glDrawArrays
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> m ()
glDrawArrays v1 v2 v3 = liftIO $ dyn229 ptr_glDrawArrays v1 v2 v3

{-# NOINLINE ptr_glDrawArrays #-}
ptr_glDrawArrays :: FunPtr (GLenum -> GLint -> GLsizei -> IO ())
ptr_glDrawArrays = unsafePerformIO $ getCommand "glDrawArrays"

-- glDrawArraysEXT -------------------------------------------------------------

-- | This command is an alias for 'glDrawArrays'.
glDrawArraysEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> m ()
glDrawArraysEXT v1 v2 v3 = liftIO $ dyn229 ptr_glDrawArraysEXT v1 v2 v3

{-# NOINLINE ptr_glDrawArraysEXT #-}
ptr_glDrawArraysEXT :: FunPtr (GLenum -> GLint -> GLsizei -> IO ())
ptr_glDrawArraysEXT = unsafePerformIO $ getCommand "glDrawArraysEXT"

-- glDrawArraysIndirect --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawArraysIndirect.xhtml OpenGL 4.x>.
glDrawArraysIndirect
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> Ptr a -- ^ @indirect@.
  -> m ()
glDrawArraysIndirect v1 v2 = liftIO $ dyn230 ptr_glDrawArraysIndirect v1 v2

{-# NOINLINE ptr_glDrawArraysIndirect #-}
ptr_glDrawArraysIndirect :: FunPtr (GLenum -> Ptr a -> IO ())
ptr_glDrawArraysIndirect = unsafePerformIO $ getCommand "glDrawArraysIndirect"

-- glDrawArraysInstanced -------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawArraysInstanced.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawArraysInstanced.xhtml OpenGL 4.x>.
glDrawArraysInstanced
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @instancecount@.
  -> m ()
glDrawArraysInstanced v1 v2 v3 v4 = liftIO $ dyn231 ptr_glDrawArraysInstanced v1 v2 v3 v4

{-# NOINLINE ptr_glDrawArraysInstanced #-}
ptr_glDrawArraysInstanced :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glDrawArraysInstanced = unsafePerformIO $ getCommand "glDrawArraysInstanced"

-- glDrawArraysInstancedANGLE --------------------------------------------------

-- | This command is an alias for 'glDrawArraysInstanced'.
glDrawArraysInstancedANGLE
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawArraysInstancedANGLE v1 v2 v3 v4 = liftIO $ dyn231 ptr_glDrawArraysInstancedANGLE v1 v2 v3 v4

{-# NOINLINE ptr_glDrawArraysInstancedANGLE #-}
ptr_glDrawArraysInstancedANGLE :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glDrawArraysInstancedANGLE = unsafePerformIO $ getCommand "glDrawArraysInstancedANGLE"

-- glDrawArraysInstancedARB ----------------------------------------------------

-- | This command is an alias for 'glDrawArraysInstanced'.
glDrawArraysInstancedARB
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawArraysInstancedARB v1 v2 v3 v4 = liftIO $ dyn231 ptr_glDrawArraysInstancedARB v1 v2 v3 v4

{-# NOINLINE ptr_glDrawArraysInstancedARB #-}
ptr_glDrawArraysInstancedARB :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glDrawArraysInstancedARB = unsafePerformIO $ getCommand "glDrawArraysInstancedARB"

-- glDrawArraysInstancedBaseInstance -------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawArraysInstancedBaseInstance.xhtml OpenGL 4.x>.
glDrawArraysInstancedBaseInstance
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @instancecount@.
  -> GLuint -- ^ @baseinstance@.
  -> m ()
glDrawArraysInstancedBaseInstance v1 v2 v3 v4 v5 = liftIO $ dyn232 ptr_glDrawArraysInstancedBaseInstance v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawArraysInstancedBaseInstance #-}
ptr_glDrawArraysInstancedBaseInstance :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> GLuint -> IO ())
ptr_glDrawArraysInstancedBaseInstance = unsafePerformIO $ getCommand "glDrawArraysInstancedBaseInstance"

-- glDrawArraysInstancedBaseInstanceEXT ----------------------------------------

-- | This command is an alias for 'glDrawArraysInstancedBaseInstance'.
glDrawArraysInstancedBaseInstanceEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @instancecount@.
  -> GLuint -- ^ @baseinstance@.
  -> m ()
glDrawArraysInstancedBaseInstanceEXT v1 v2 v3 v4 v5 = liftIO $ dyn232 ptr_glDrawArraysInstancedBaseInstanceEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawArraysInstancedBaseInstanceEXT #-}
ptr_glDrawArraysInstancedBaseInstanceEXT :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> GLuint -> IO ())
ptr_glDrawArraysInstancedBaseInstanceEXT = unsafePerformIO $ getCommand "glDrawArraysInstancedBaseInstanceEXT"

-- glDrawArraysInstancedEXT ----------------------------------------------------

-- | This command is an alias for 'glDrawArraysInstanced'.
glDrawArraysInstancedEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLint -- ^ @start@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawArraysInstancedEXT v1 v2 v3 v4 = liftIO $ dyn231 ptr_glDrawArraysInstancedEXT v1 v2 v3 v4

{-# NOINLINE ptr_glDrawArraysInstancedEXT #-}
ptr_glDrawArraysInstancedEXT :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glDrawArraysInstancedEXT = unsafePerformIO $ getCommand "glDrawArraysInstancedEXT"

-- glDrawArraysInstancedNV -----------------------------------------------------

-- | This command is an alias for 'glDrawArraysInstanced'.
glDrawArraysInstancedNV
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawArraysInstancedNV v1 v2 v3 v4 = liftIO $ dyn231 ptr_glDrawArraysInstancedNV v1 v2 v3 v4

{-# NOINLINE ptr_glDrawArraysInstancedNV #-}
ptr_glDrawArraysInstancedNV :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glDrawArraysInstancedNV = unsafePerformIO $ getCommand "glDrawArraysInstancedNV"

-- glDrawBuffer ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDrawBuffer.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawBuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawBuffer.xhtml OpenGL 4.x>.
glDrawBuffer
  :: MonadIO m
  => GLenum -- ^ @buf@ of type [DrawBufferMode](Graphics-GL-Groups.html#DrawBufferMode).
  -> m ()
glDrawBuffer v1 = liftIO $ dyn4 ptr_glDrawBuffer v1

{-# NOINLINE ptr_glDrawBuffer #-}
ptr_glDrawBuffer :: FunPtr (GLenum -> IO ())
ptr_glDrawBuffer = unsafePerformIO $ getCommand "glDrawBuffer"

-- glDrawBuffers ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDrawBuffers.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawBuffers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawBuffers.xhtml OpenGL 4.x>.
glDrawBuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLenum -- ^ @bufs@ pointing to @n@ elements of type @DrawBufferModeATI@.
  -> m ()
glDrawBuffers v1 v2 = liftIO $ dyn233 ptr_glDrawBuffers v1 v2

{-# NOINLINE ptr_glDrawBuffers #-}
ptr_glDrawBuffers :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
ptr_glDrawBuffers = unsafePerformIO $ getCommand "glDrawBuffers"

-- glDrawBuffersARB ------------------------------------------------------------

-- | This command is an alias for 'glDrawBuffers'.
glDrawBuffersARB
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLenum -- ^ @bufs@ pointing to @n@ elements of type @DrawBufferModeATI@.
  -> m ()
glDrawBuffersARB v1 v2 = liftIO $ dyn233 ptr_glDrawBuffersARB v1 v2

{-# NOINLINE ptr_glDrawBuffersARB #-}
ptr_glDrawBuffersARB :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
ptr_glDrawBuffersARB = unsafePerformIO $ getCommand "glDrawBuffersARB"

-- glDrawBuffersATI ------------------------------------------------------------

-- | This command is an alias for 'glDrawBuffers'.
glDrawBuffersATI
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLenum -- ^ @bufs@ pointing to @n@ elements of type @DrawBufferModeATI@.
  -> m ()
glDrawBuffersATI v1 v2 = liftIO $ dyn233 ptr_glDrawBuffersATI v1 v2

{-# NOINLINE ptr_glDrawBuffersATI #-}
ptr_glDrawBuffersATI :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
ptr_glDrawBuffersATI = unsafePerformIO $ getCommand "glDrawBuffersATI"

-- glDrawBuffersEXT ------------------------------------------------------------

-- | This command is an alias for 'glDrawBuffers'.
glDrawBuffersEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLenum -- ^ @bufs@.
  -> m ()
glDrawBuffersEXT v1 v2 = liftIO $ dyn233 ptr_glDrawBuffersEXT v1 v2

{-# NOINLINE ptr_glDrawBuffersEXT #-}
ptr_glDrawBuffersEXT :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
ptr_glDrawBuffersEXT = unsafePerformIO $ getCommand "glDrawBuffersEXT"

-- glDrawBuffersIndexedEXT -----------------------------------------------------

glDrawBuffersIndexedEXT
  :: MonadIO m
  => GLint -- ^ @n@.
  -> Ptr GLenum -- ^ @location@ pointing to @n@ elements of type @GLenum@.
  -> Ptr GLint -- ^ @indices@ pointing to @n@ elements of type @GLint@.
  -> m ()
glDrawBuffersIndexedEXT v1 v2 v3 = liftIO $ dyn234 ptr_glDrawBuffersIndexedEXT v1 v2 v3

{-# NOINLINE ptr_glDrawBuffersIndexedEXT #-}
ptr_glDrawBuffersIndexedEXT :: FunPtr (GLint -> Ptr GLenum -> Ptr GLint -> IO ())
ptr_glDrawBuffersIndexedEXT = unsafePerformIO $ getCommand "glDrawBuffersIndexedEXT"

-- glDrawBuffersNV -------------------------------------------------------------

glDrawBuffersNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLenum -- ^ @bufs@ pointing to @n@ elements of type @GLenum@.
  -> m ()
glDrawBuffersNV v1 v2 = liftIO $ dyn233 ptr_glDrawBuffersNV v1 v2

{-# NOINLINE ptr_glDrawBuffersNV #-}
ptr_glDrawBuffersNV :: FunPtr (GLsizei -> Ptr GLenum -> IO ())
ptr_glDrawBuffersNV = unsafePerformIO $ getCommand "glDrawBuffersNV"

-- glDrawCommandsAddressNV -----------------------------------------------------

glDrawCommandsAddressNV
  :: MonadIO m
  => GLenum -- ^ @primitiveMode@.
  -> Ptr GLuint64 -- ^ @indirects@.
  -> Ptr GLsizei -- ^ @sizes@.
  -> GLuint -- ^ @count@.
  -> m ()
glDrawCommandsAddressNV v1 v2 v3 v4 = liftIO $ dyn235 ptr_glDrawCommandsAddressNV v1 v2 v3 v4

{-# NOINLINE ptr_glDrawCommandsAddressNV #-}
ptr_glDrawCommandsAddressNV :: FunPtr (GLenum -> Ptr GLuint64 -> Ptr GLsizei -> GLuint -> IO ())
ptr_glDrawCommandsAddressNV = unsafePerformIO $ getCommand "glDrawCommandsAddressNV"

-- glDrawCommandsNV ------------------------------------------------------------

glDrawCommandsNV
  :: MonadIO m
  => GLenum -- ^ @primitiveMode@.
  -> GLuint -- ^ @buffer@.
  -> Ptr GLintptr -- ^ @indirects@.
  -> Ptr GLsizei -- ^ @sizes@.
  -> GLuint -- ^ @count@.
  -> m ()
glDrawCommandsNV v1 v2 v3 v4 v5 = liftIO $ dyn236 ptr_glDrawCommandsNV v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawCommandsNV #-}
ptr_glDrawCommandsNV :: FunPtr (GLenum -> GLuint -> Ptr GLintptr -> Ptr GLsizei -> GLuint -> IO ())
ptr_glDrawCommandsNV = unsafePerformIO $ getCommand "glDrawCommandsNV"

-- glDrawCommandsStatesAddressNV -----------------------------------------------

glDrawCommandsStatesAddressNV
  :: MonadIO m
  => Ptr GLuint64 -- ^ @indirects@.
  -> Ptr GLsizei -- ^ @sizes@.
  -> Ptr GLuint -- ^ @states@.
  -> Ptr GLuint -- ^ @fbos@.
  -> GLuint -- ^ @count@.
  -> m ()
glDrawCommandsStatesAddressNV v1 v2 v3 v4 v5 = liftIO $ dyn237 ptr_glDrawCommandsStatesAddressNV v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawCommandsStatesAddressNV #-}
ptr_glDrawCommandsStatesAddressNV :: FunPtr (Ptr GLuint64 -> Ptr GLsizei -> Ptr GLuint -> Ptr GLuint -> GLuint -> IO ())
ptr_glDrawCommandsStatesAddressNV = unsafePerformIO $ getCommand "glDrawCommandsStatesAddressNV"

-- glDrawCommandsStatesNV ------------------------------------------------------

glDrawCommandsStatesNV
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> Ptr GLintptr -- ^ @indirects@.
  -> Ptr GLsizei -- ^ @sizes@.
  -> Ptr GLuint -- ^ @states@.
  -> Ptr GLuint -- ^ @fbos@.
  -> GLuint -- ^ @count@.
  -> m ()
glDrawCommandsStatesNV v1 v2 v3 v4 v5 v6 = liftIO $ dyn238 ptr_glDrawCommandsStatesNV v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDrawCommandsStatesNV #-}
ptr_glDrawCommandsStatesNV :: FunPtr (GLuint -> Ptr GLintptr -> Ptr GLsizei -> Ptr GLuint -> Ptr GLuint -> GLuint -> IO ())
ptr_glDrawCommandsStatesNV = unsafePerformIO $ getCommand "glDrawCommandsStatesNV"

-- glDrawElementArrayAPPLE -----------------------------------------------------

glDrawElementArrayAPPLE
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> m ()
glDrawElementArrayAPPLE v1 v2 v3 = liftIO $ dyn229 ptr_glDrawElementArrayAPPLE v1 v2 v3

{-# NOINLINE ptr_glDrawElementArrayAPPLE #-}
ptr_glDrawElementArrayAPPLE :: FunPtr (GLenum -> GLint -> GLsizei -> IO ())
ptr_glDrawElementArrayAPPLE = unsafePerformIO $ getCommand "glDrawElementArrayAPPLE"

-- glDrawElementArrayATI -------------------------------------------------------

glDrawElementArrayATI
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> m ()
glDrawElementArrayATI v1 v2 = liftIO $ dyn239 ptr_glDrawElementArrayATI v1 v2

{-# NOINLINE ptr_glDrawElementArrayATI #-}
ptr_glDrawElementArrayATI :: FunPtr (GLenum -> GLsizei -> IO ())
ptr_glDrawElementArrayATI = unsafePerformIO $ getCommand "glDrawElementArrayATI"

-- glDrawElements --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDrawElements.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawElements.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawElements.xhtml OpenGL 4.x>.
glDrawElements
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> m ()
glDrawElements v1 v2 v3 v4 = liftIO $ dyn240 ptr_glDrawElements v1 v2 v3 v4

{-# NOINLINE ptr_glDrawElements #-}
ptr_glDrawElements :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> IO ())
ptr_glDrawElements = unsafePerformIO $ getCommand "glDrawElements"

-- glDrawElementsBaseVertex ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawElementsBaseVertex.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawElementsBaseVertex.xhtml OpenGL 4.x>.
glDrawElementsBaseVertex
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawElementsBaseVertex v1 v2 v3 v4 v5 = liftIO $ dyn241 ptr_glDrawElementsBaseVertex v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawElementsBaseVertex #-}
ptr_glDrawElementsBaseVertex :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
ptr_glDrawElementsBaseVertex = unsafePerformIO $ getCommand "glDrawElementsBaseVertex"

-- glDrawElementsBaseVertexEXT -------------------------------------------------

-- | This command is an alias for 'glDrawElementsBaseVertex'.
glDrawElementsBaseVertexEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawElementsBaseVertexEXT v1 v2 v3 v4 v5 = liftIO $ dyn241 ptr_glDrawElementsBaseVertexEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawElementsBaseVertexEXT #-}
ptr_glDrawElementsBaseVertexEXT :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
ptr_glDrawElementsBaseVertexEXT = unsafePerformIO $ getCommand "glDrawElementsBaseVertexEXT"

-- glDrawElementsBaseVertexOES -------------------------------------------------

-- | This command is an alias for 'glDrawElementsBaseVertex'.
glDrawElementsBaseVertexOES
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawElementsBaseVertexOES v1 v2 v3 v4 v5 = liftIO $ dyn241 ptr_glDrawElementsBaseVertexOES v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawElementsBaseVertexOES #-}
ptr_glDrawElementsBaseVertexOES :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
ptr_glDrawElementsBaseVertexOES = unsafePerformIO $ getCommand "glDrawElementsBaseVertexOES"

-- glDrawElementsIndirect ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawElementsIndirect.xhtml OpenGL 4.x>.
glDrawElementsIndirect
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @indirect@.
  -> m ()
glDrawElementsIndirect v1 v2 v3 = liftIO $ dyn242 ptr_glDrawElementsIndirect v1 v2 v3

{-# NOINLINE ptr_glDrawElementsIndirect #-}
ptr_glDrawElementsIndirect :: FunPtr (GLenum -> GLenum -> Ptr a -> IO ())
ptr_glDrawElementsIndirect = unsafePerformIO $ getCommand "glDrawElementsIndirect"

-- glDrawElementsInstanced -----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawElementsInstanced.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawElementsInstanced.xhtml OpenGL 4.x>.
glDrawElementsInstanced
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> m ()
glDrawElementsInstanced v1 v2 v3 v4 v5 = liftIO $ dyn243 ptr_glDrawElementsInstanced v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawElementsInstanced #-}
ptr_glDrawElementsInstanced :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
ptr_glDrawElementsInstanced = unsafePerformIO $ getCommand "glDrawElementsInstanced"

-- glDrawElementsInstancedANGLE ------------------------------------------------

-- | This command is an alias for 'glDrawElementsInstanced'.
glDrawElementsInstancedANGLE
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawElementsInstancedANGLE v1 v2 v3 v4 v5 = liftIO $ dyn243 ptr_glDrawElementsInstancedANGLE v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawElementsInstancedANGLE #-}
ptr_glDrawElementsInstancedANGLE :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
ptr_glDrawElementsInstancedANGLE = unsafePerformIO $ getCommand "glDrawElementsInstancedANGLE"

-- glDrawElementsInstancedARB --------------------------------------------------

-- | This command is an alias for 'glDrawElementsInstanced'.
glDrawElementsInstancedARB
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawElementsInstancedARB v1 v2 v3 v4 v5 = liftIO $ dyn243 ptr_glDrawElementsInstancedARB v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawElementsInstancedARB #-}
ptr_glDrawElementsInstancedARB :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
ptr_glDrawElementsInstancedARB = unsafePerformIO $ getCommand "glDrawElementsInstancedARB"

-- glDrawElementsInstancedBaseInstance -----------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawElementsInstancedBaseInstance.xhtml OpenGL 4.x>.
glDrawElementsInstancedBaseInstance
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @indices@ pointing to @count@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> GLuint -- ^ @baseinstance@.
  -> m ()
glDrawElementsInstancedBaseInstance v1 v2 v3 v4 v5 v6 = liftIO $ dyn244 ptr_glDrawElementsInstancedBaseInstance v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDrawElementsInstancedBaseInstance #-}
ptr_glDrawElementsInstancedBaseInstance :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLuint -> IO ())
ptr_glDrawElementsInstancedBaseInstance = unsafePerformIO $ getCommand "glDrawElementsInstancedBaseInstance"

-- glDrawElementsInstancedBaseInstanceEXT --------------------------------------

-- | This command is an alias for 'glDrawElementsInstancedBaseInstance'.
glDrawElementsInstancedBaseInstanceEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @indices@ pointing to @count@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> GLuint -- ^ @baseinstance@.
  -> m ()
glDrawElementsInstancedBaseInstanceEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn244 ptr_glDrawElementsInstancedBaseInstanceEXT v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDrawElementsInstancedBaseInstanceEXT #-}
ptr_glDrawElementsInstancedBaseInstanceEXT :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLuint -> IO ())
ptr_glDrawElementsInstancedBaseInstanceEXT = unsafePerformIO $ getCommand "glDrawElementsInstancedBaseInstanceEXT"

-- glDrawElementsInstancedBaseVertex -------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawElementsInstancedBaseVertex.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawElementsInstancedBaseVertex.xhtml OpenGL 4.x>.
glDrawElementsInstancedBaseVertex
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawElementsInstancedBaseVertex v1 v2 v3 v4 v5 v6 = liftIO $ dyn245 ptr_glDrawElementsInstancedBaseVertex v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDrawElementsInstancedBaseVertex #-}
ptr_glDrawElementsInstancedBaseVertex :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> IO ())
ptr_glDrawElementsInstancedBaseVertex = unsafePerformIO $ getCommand "glDrawElementsInstancedBaseVertex"

-- glDrawElementsInstancedBaseVertexBaseInstance -------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawElementsInstancedBaseVertexBaseInstance.xhtml OpenGL 4.x>.
glDrawElementsInstancedBaseVertexBaseInstance
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @indices@ pointing to @count@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> GLint -- ^ @basevertex@.
  -> GLuint -- ^ @baseinstance@.
  -> m ()
glDrawElementsInstancedBaseVertexBaseInstance v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn246 ptr_glDrawElementsInstancedBaseVertexBaseInstance v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glDrawElementsInstancedBaseVertexBaseInstance #-}
ptr_glDrawElementsInstancedBaseVertexBaseInstance :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> GLuint -> IO ())
ptr_glDrawElementsInstancedBaseVertexBaseInstance = unsafePerformIO $ getCommand "glDrawElementsInstancedBaseVertexBaseInstance"

-- glDrawElementsInstancedBaseVertexBaseInstanceEXT ----------------------------

-- | This command is an alias for 'glDrawElementsInstancedBaseVertexBaseInstance'.
glDrawElementsInstancedBaseVertexBaseInstanceEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @indices@ pointing to @count@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> GLint -- ^ @basevertex@.
  -> GLuint -- ^ @baseinstance@.
  -> m ()
glDrawElementsInstancedBaseVertexBaseInstanceEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn246 ptr_glDrawElementsInstancedBaseVertexBaseInstanceEXT v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glDrawElementsInstancedBaseVertexBaseInstanceEXT #-}
ptr_glDrawElementsInstancedBaseVertexBaseInstanceEXT :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> GLuint -> IO ())
ptr_glDrawElementsInstancedBaseVertexBaseInstanceEXT = unsafePerformIO $ getCommand "glDrawElementsInstancedBaseVertexBaseInstanceEXT"

-- glDrawElementsInstancedBaseVertexEXT ----------------------------------------

-- | This command is an alias for 'glDrawElementsInstancedBaseVertex'.
glDrawElementsInstancedBaseVertexEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawElementsInstancedBaseVertexEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn245 ptr_glDrawElementsInstancedBaseVertexEXT v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDrawElementsInstancedBaseVertexEXT #-}
ptr_glDrawElementsInstancedBaseVertexEXT :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> IO ())
ptr_glDrawElementsInstancedBaseVertexEXT = unsafePerformIO $ getCommand "glDrawElementsInstancedBaseVertexEXT"

-- glDrawElementsInstancedBaseVertexOES ----------------------------------------

-- | This command is an alias for 'glDrawElementsInstancedBaseVertex'.
glDrawElementsInstancedBaseVertexOES
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @instancecount@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawElementsInstancedBaseVertexOES v1 v2 v3 v4 v5 v6 = liftIO $ dyn245 ptr_glDrawElementsInstancedBaseVertexOES v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDrawElementsInstancedBaseVertexOES #-}
ptr_glDrawElementsInstancedBaseVertexOES :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> GLint -> IO ())
ptr_glDrawElementsInstancedBaseVertexOES = unsafePerformIO $ getCommand "glDrawElementsInstancedBaseVertexOES"

-- glDrawElementsInstancedEXT --------------------------------------------------

-- | This command is an alias for 'glDrawElementsInstanced'.
glDrawElementsInstancedEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawElementsInstancedEXT v1 v2 v3 v4 v5 = liftIO $ dyn243 ptr_glDrawElementsInstancedEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawElementsInstancedEXT #-}
ptr_glDrawElementsInstancedEXT :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
ptr_glDrawElementsInstancedEXT = unsafePerformIO $ getCommand "glDrawElementsInstancedEXT"

-- glDrawElementsInstancedNV ---------------------------------------------------

-- | This command is an alias for 'glDrawElementsInstanced'.
glDrawElementsInstancedNV
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLsizei -- ^ @primcount@.
  -> m ()
glDrawElementsInstancedNV v1 v2 v3 v4 v5 = liftIO $ dyn243 ptr_glDrawElementsInstancedNV v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawElementsInstancedNV #-}
ptr_glDrawElementsInstancedNV :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLsizei -> IO ())
ptr_glDrawElementsInstancedNV = unsafePerformIO $ getCommand "glDrawElementsInstancedNV"

-- glDrawMeshArraysSUN ---------------------------------------------------------

glDrawMeshArraysSUN
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> GLsizei -- ^ @width@.
  -> m ()
glDrawMeshArraysSUN v1 v2 v3 v4 = liftIO $ dyn231 ptr_glDrawMeshArraysSUN v1 v2 v3 v4

{-# NOINLINE ptr_glDrawMeshArraysSUN #-}
ptr_glDrawMeshArraysSUN :: FunPtr (GLenum -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glDrawMeshArraysSUN = unsafePerformIO $ getCommand "glDrawMeshArraysSUN"

-- glDrawPixels ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glDrawPixels.xml OpenGL 2.x>.
glDrawPixels
  :: MonadIO m
  => GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @pixels@ pointing to @COMPSIZE(format,type,width,height)@ elements of type @a@.
  -> m ()
glDrawPixels v1 v2 v3 v4 v5 = liftIO $ dyn247 ptr_glDrawPixels v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawPixels #-}
ptr_glDrawPixels :: FunPtr (GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glDrawPixels = unsafePerformIO $ getCommand "glDrawPixels"

-- glDrawRangeElementArrayAPPLE ------------------------------------------------

glDrawRangeElementArrayAPPLE
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLuint -- ^ @start@.
  -> GLuint -- ^ @end@.
  -> GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> m ()
glDrawRangeElementArrayAPPLE v1 v2 v3 v4 v5 = liftIO $ dyn248 ptr_glDrawRangeElementArrayAPPLE v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawRangeElementArrayAPPLE #-}
ptr_glDrawRangeElementArrayAPPLE :: FunPtr (GLenum -> GLuint -> GLuint -> GLint -> GLsizei -> IO ())
ptr_glDrawRangeElementArrayAPPLE = unsafePerformIO $ getCommand "glDrawRangeElementArrayAPPLE"

-- glDrawRangeElementArrayATI --------------------------------------------------

glDrawRangeElementArrayATI
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLuint -- ^ @start@.
  -> GLuint -- ^ @end@.
  -> GLsizei -- ^ @count@.
  -> m ()
glDrawRangeElementArrayATI v1 v2 v3 v4 = liftIO $ dyn249 ptr_glDrawRangeElementArrayATI v1 v2 v3 v4

{-# NOINLINE ptr_glDrawRangeElementArrayATI #-}
ptr_glDrawRangeElementArrayATI :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> IO ())
ptr_glDrawRangeElementArrayATI = unsafePerformIO $ getCommand "glDrawRangeElementArrayATI"

-- glDrawRangeElements ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glDrawRangeElements.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawRangeElements.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawRangeElements.xhtml OpenGL 4.x>.
glDrawRangeElements
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLuint -- ^ @start@.
  -> GLuint -- ^ @end@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> m ()
glDrawRangeElements v1 v2 v3 v4 v5 v6 = liftIO $ dyn250 ptr_glDrawRangeElements v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDrawRangeElements #-}
ptr_glDrawRangeElements :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> IO ())
ptr_glDrawRangeElements = unsafePerformIO $ getCommand "glDrawRangeElements"

-- glDrawRangeElementsBaseVertex -----------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glDrawRangeElementsBaseVertex.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glDrawRangeElementsBaseVertex.xhtml OpenGL 4.x>.
glDrawRangeElementsBaseVertex
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLuint -- ^ @start@.
  -> GLuint -- ^ @end@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawRangeElementsBaseVertex v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn251 ptr_glDrawRangeElementsBaseVertex v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glDrawRangeElementsBaseVertex #-}
ptr_glDrawRangeElementsBaseVertex :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
ptr_glDrawRangeElementsBaseVertex = unsafePerformIO $ getCommand "glDrawRangeElementsBaseVertex"

-- glDrawRangeElementsBaseVertexEXT --------------------------------------------

-- | This command is an alias for 'glDrawRangeElementsBaseVertex'.
glDrawRangeElementsBaseVertexEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLuint -- ^ @start@.
  -> GLuint -- ^ @end@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawRangeElementsBaseVertexEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn251 ptr_glDrawRangeElementsBaseVertexEXT v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glDrawRangeElementsBaseVertexEXT #-}
ptr_glDrawRangeElementsBaseVertexEXT :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
ptr_glDrawRangeElementsBaseVertexEXT = unsafePerformIO $ getCommand "glDrawRangeElementsBaseVertexEXT"

-- glDrawRangeElementsBaseVertexOES --------------------------------------------

-- | This command is an alias for 'glDrawRangeElementsBaseVertex'.
glDrawRangeElementsBaseVertexOES
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLuint -- ^ @start@.
  -> GLuint -- ^ @end@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> GLint -- ^ @basevertex@.
  -> m ()
glDrawRangeElementsBaseVertexOES v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn251 ptr_glDrawRangeElementsBaseVertexOES v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glDrawRangeElementsBaseVertexOES #-}
ptr_glDrawRangeElementsBaseVertexOES :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> GLint -> IO ())
ptr_glDrawRangeElementsBaseVertexOES = unsafePerformIO $ getCommand "glDrawRangeElementsBaseVertexOES"

-- glDrawRangeElementsEXT ------------------------------------------------------

-- | This command is an alias for 'glDrawRangeElements'.
glDrawRangeElementsEXT
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLuint -- ^ @start@.
  -> GLuint -- ^ @end@.
  -> GLsizei -- ^ @count@.
  -> GLenum -- ^ @type@ of type @DrawElementsType@.
  -> Ptr a -- ^ @indices@ pointing to @COMPSIZE(count,type)@ elements of type @a@.
  -> m ()
glDrawRangeElementsEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn250 ptr_glDrawRangeElementsEXT v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glDrawRangeElementsEXT #-}
ptr_glDrawRangeElementsEXT :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> GLenum -> Ptr a -> IO ())
ptr_glDrawRangeElementsEXT = unsafePerformIO $ getCommand "glDrawRangeElementsEXT"

-- glDrawTexfOES ---------------------------------------------------------------

glDrawTexfOES
  :: MonadIO m
  => GLfloat -- ^ @x@.
  -> GLfloat -- ^ @y@.
  -> GLfloat -- ^ @z@.
  -> GLfloat -- ^ @width@.
  -> GLfloat -- ^ @height@.
  -> m ()
glDrawTexfOES v1 v2 v3 v4 v5 = liftIO $ dyn252 ptr_glDrawTexfOES v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawTexfOES #-}
ptr_glDrawTexfOES :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glDrawTexfOES = unsafePerformIO $ getCommand "glDrawTexfOES"

-- glDrawTexfvOES --------------------------------------------------------------

glDrawTexfvOES
  :: MonadIO m
  => Ptr GLfloat -- ^ @coords@.
  -> m ()
glDrawTexfvOES v1 = liftIO $ dyn41 ptr_glDrawTexfvOES v1

{-# NOINLINE ptr_glDrawTexfvOES #-}
ptr_glDrawTexfvOES :: FunPtr (Ptr GLfloat -> IO ())
ptr_glDrawTexfvOES = unsafePerformIO $ getCommand "glDrawTexfvOES"

-- glDrawTexiOES ---------------------------------------------------------------

glDrawTexiOES
  :: MonadIO m
  => GLint -- ^ @x@.
  -> GLint -- ^ @y@.
  -> GLint -- ^ @z@.
  -> GLint -- ^ @width@.
  -> GLint -- ^ @height@.
  -> m ()
glDrawTexiOES v1 v2 v3 v4 v5 = liftIO $ dyn253 ptr_glDrawTexiOES v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawTexiOES #-}
ptr_glDrawTexiOES :: FunPtr (GLint -> GLint -> GLint -> GLint -> GLint -> IO ())
ptr_glDrawTexiOES = unsafePerformIO $ getCommand "glDrawTexiOES"

-- glDrawTexivOES --------------------------------------------------------------

glDrawTexivOES
  :: MonadIO m
  => Ptr GLint -- ^ @coords@.
  -> m ()
glDrawTexivOES v1 = liftIO $ dyn43 ptr_glDrawTexivOES v1

{-# NOINLINE ptr_glDrawTexivOES #-}
ptr_glDrawTexivOES :: FunPtr (Ptr GLint -> IO ())
ptr_glDrawTexivOES = unsafePerformIO $ getCommand "glDrawTexivOES"

-- glDrawTexsOES ---------------------------------------------------------------

glDrawTexsOES
  :: MonadIO m
  => GLshort -- ^ @x@.
  -> GLshort -- ^ @y@.
  -> GLshort -- ^ @z@.
  -> GLshort -- ^ @width@.
  -> GLshort -- ^ @height@.
  -> m ()
glDrawTexsOES v1 v2 v3 v4 v5 = liftIO $ dyn254 ptr_glDrawTexsOES v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawTexsOES #-}
ptr_glDrawTexsOES :: FunPtr (GLshort -> GLshort -> GLshort -> GLshort -> GLshort -> IO ())
ptr_glDrawTexsOES = unsafePerformIO $ getCommand "glDrawTexsOES"

-- glDrawTexsvOES --------------------------------------------------------------

glDrawTexsvOES
  :: MonadIO m
  => Ptr GLshort -- ^ @coords@.
  -> m ()
glDrawTexsvOES v1 = liftIO $ dyn45 ptr_glDrawTexsvOES v1

{-# NOINLINE ptr_glDrawTexsvOES #-}
ptr_glDrawTexsvOES :: FunPtr (Ptr GLshort -> IO ())
ptr_glDrawTexsvOES = unsafePerformIO $ getCommand "glDrawTexsvOES"

-- glDrawTextureNV -------------------------------------------------------------

glDrawTextureNV
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLuint -- ^ @sampler@.
  -> GLfloat -- ^ @x0@.
  -> GLfloat -- ^ @y0@.
  -> GLfloat -- ^ @x1@.
  -> GLfloat -- ^ @y1@.
  -> GLfloat -- ^ @z@.
  -> GLfloat -- ^ @s0@.
  -> GLfloat -- ^ @t0@.
  -> GLfloat -- ^ @s1@.
  -> GLfloat -- ^ @t1@.
  -> m ()
glDrawTextureNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn255 ptr_glDrawTextureNV v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

{-# NOINLINE ptr_glDrawTextureNV #-}
ptr_glDrawTextureNV :: FunPtr (GLuint -> GLuint -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glDrawTextureNV = unsafePerformIO $ getCommand "glDrawTextureNV"

-- glDrawTexxOES ---------------------------------------------------------------

glDrawTexxOES
  :: MonadIO m
  => GLfixed -- ^ @x@.
  -> GLfixed -- ^ @y@.
  -> GLfixed -- ^ @z@.
  -> GLfixed -- ^ @width@.
  -> GLfixed -- ^ @height@.
  -> m ()
glDrawTexxOES v1 v2 v3 v4 v5 = liftIO $ dyn256 ptr_glDrawTexxOES v1 v2 v3 v4 v5

{-# NOINLINE ptr_glDrawTexxOES #-}
ptr_glDrawTexxOES :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glDrawTexxOES = unsafePerformIO $ getCommand "glDrawTexxOES"

-- glDrawTexxvOES --------------------------------------------------------------

glDrawTexxvOES
  :: MonadIO m
  => Ptr GLfixed -- ^ @coords@.
  -> m ()
glDrawTexxvOES v1 = liftIO $ dyn107 ptr_glDrawTexxvOES v1

{-# NOINLINE ptr_glDrawTexxvOES #-}
ptr_glDrawTexxvOES :: FunPtr (Ptr GLfixed -> IO ())
ptr_glDrawTexxvOES = unsafePerformIO $ getCommand "glDrawTexxvOES"

-- glDrawTransformFeedback -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawTransformFeedback.xhtml OpenGL 4.x>.
glDrawTransformFeedback
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLuint -- ^ @id@.
  -> m ()
glDrawTransformFeedback v1 v2 = liftIO $ dyn16 ptr_glDrawTransformFeedback v1 v2

{-# NOINLINE ptr_glDrawTransformFeedback #-}
ptr_glDrawTransformFeedback :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDrawTransformFeedback = unsafePerformIO $ getCommand "glDrawTransformFeedback"

-- glDrawTransformFeedbackInstanced --------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawTransformFeedbackInstanced.xhtml OpenGL 4.x>.
glDrawTransformFeedbackInstanced
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLuint -- ^ @id@.
  -> GLsizei -- ^ @instancecount@.
  -> m ()
glDrawTransformFeedbackInstanced v1 v2 v3 = liftIO $ dyn257 ptr_glDrawTransformFeedbackInstanced v1 v2 v3

{-# NOINLINE ptr_glDrawTransformFeedbackInstanced #-}
ptr_glDrawTransformFeedbackInstanced :: FunPtr (GLenum -> GLuint -> GLsizei -> IO ())
ptr_glDrawTransformFeedbackInstanced = unsafePerformIO $ getCommand "glDrawTransformFeedbackInstanced"

-- glDrawTransformFeedbackNV ---------------------------------------------------

-- | This command is an alias for 'glDrawTransformFeedback'.
glDrawTransformFeedbackNV
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLuint -- ^ @id@.
  -> m ()
glDrawTransformFeedbackNV v1 v2 = liftIO $ dyn16 ptr_glDrawTransformFeedbackNV v1 v2

{-# NOINLINE ptr_glDrawTransformFeedbackNV #-}
ptr_glDrawTransformFeedbackNV :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glDrawTransformFeedbackNV = unsafePerformIO $ getCommand "glDrawTransformFeedbackNV"

-- glDrawTransformFeedbackStream -----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawTransformFeedbackStream.xhtml OpenGL 4.x>.
glDrawTransformFeedbackStream
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLuint -- ^ @id@.
  -> GLuint -- ^ @stream@.
  -> m ()
glDrawTransformFeedbackStream v1 v2 v3 = liftIO $ dyn17 ptr_glDrawTransformFeedbackStream v1 v2 v3

{-# NOINLINE ptr_glDrawTransformFeedbackStream #-}
ptr_glDrawTransformFeedbackStream :: FunPtr (GLenum -> GLuint -> GLuint -> IO ())
ptr_glDrawTransformFeedbackStream = unsafePerformIO $ getCommand "glDrawTransformFeedbackStream"

-- glDrawTransformFeedbackStreamInstanced --------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glDrawTransformFeedbackStreamInstanced.xhtml OpenGL 4.x>.
glDrawTransformFeedbackStreamInstanced
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [PrimitiveType](Graphics-GL-Groups.html#PrimitiveType).
  -> GLuint -- ^ @id@.
  -> GLuint -- ^ @stream@.
  -> GLsizei -- ^ @instancecount@.
  -> m ()
glDrawTransformFeedbackStreamInstanced v1 v2 v3 v4 = liftIO $ dyn249 ptr_glDrawTransformFeedbackStreamInstanced v1 v2 v3 v4

{-# NOINLINE ptr_glDrawTransformFeedbackStreamInstanced #-}
ptr_glDrawTransformFeedbackStreamInstanced :: FunPtr (GLenum -> GLuint -> GLuint -> GLsizei -> IO ())
ptr_glDrawTransformFeedbackStreamInstanced = unsafePerformIO $ getCommand "glDrawTransformFeedbackStreamInstanced"

-- glEGLImageTargetRenderbufferStorageOES --------------------------------------

glEGLImageTargetRenderbufferStorageOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLeglImageOES -- ^ @image@.
  -> m ()
glEGLImageTargetRenderbufferStorageOES v1 v2 = liftIO $ dyn258 ptr_glEGLImageTargetRenderbufferStorageOES v1 v2

{-# NOINLINE ptr_glEGLImageTargetRenderbufferStorageOES #-}
ptr_glEGLImageTargetRenderbufferStorageOES :: FunPtr (GLenum -> GLeglImageOES -> IO ())
ptr_glEGLImageTargetRenderbufferStorageOES = unsafePerformIO $ getCommand "glEGLImageTargetRenderbufferStorageOES"

-- glEGLImageTargetTexture2DOES ------------------------------------------------

glEGLImageTargetTexture2DOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLeglImageOES -- ^ @image@.
  -> m ()
glEGLImageTargetTexture2DOES v1 v2 = liftIO $ dyn258 ptr_glEGLImageTargetTexture2DOES v1 v2

{-# NOINLINE ptr_glEGLImageTargetTexture2DOES #-}
ptr_glEGLImageTargetTexture2DOES :: FunPtr (GLenum -> GLeglImageOES -> IO ())
ptr_glEGLImageTargetTexture2DOES = unsafePerformIO $ getCommand "glEGLImageTargetTexture2DOES"

-- glEdgeFlag ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEdgeFlag.xml OpenGL 2.x>. The vector equivalent of this command is 'glEdgeFlagv'.
glEdgeFlag
  :: MonadIO m
  => GLboolean -- ^ @flag@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glEdgeFlag v1 = liftIO $ dyn191 ptr_glEdgeFlag v1

{-# NOINLINE ptr_glEdgeFlag #-}
ptr_glEdgeFlag :: FunPtr (GLboolean -> IO ())
ptr_glEdgeFlag = unsafePerformIO $ getCommand "glEdgeFlag"

-- glEdgeFlagFormatNV ----------------------------------------------------------

glEdgeFlagFormatNV
  :: MonadIO m
  => GLsizei -- ^ @stride@.
  -> m ()
glEdgeFlagFormatNV v1 = liftIO $ dyn259 ptr_glEdgeFlagFormatNV v1

{-# NOINLINE ptr_glEdgeFlagFormatNV #-}
ptr_glEdgeFlagFormatNV :: FunPtr (GLsizei -> IO ())
ptr_glEdgeFlagFormatNV = unsafePerformIO $ getCommand "glEdgeFlagFormatNV"

-- glEdgeFlagPointer -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEdgeFlagPointer.xml OpenGL 2.x>.
glEdgeFlagPointer
  :: MonadIO m
  => GLsizei -- ^ @stride@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(stride)@ elements of type @a@.
  -> m ()
glEdgeFlagPointer v1 v2 = liftIO $ dyn260 ptr_glEdgeFlagPointer v1 v2

{-# NOINLINE ptr_glEdgeFlagPointer #-}
ptr_glEdgeFlagPointer :: FunPtr (GLsizei -> Ptr a -> IO ())
ptr_glEdgeFlagPointer = unsafePerformIO $ getCommand "glEdgeFlagPointer"

-- glEdgeFlagPointerEXT --------------------------------------------------------

glEdgeFlagPointerEXT
  :: MonadIO m
  => GLsizei -- ^ @stride@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLboolean -- ^ @pointer@ pointing to @COMPSIZE(stride,count)@ elements of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glEdgeFlagPointerEXT v1 v2 v3 = liftIO $ dyn261 ptr_glEdgeFlagPointerEXT v1 v2 v3

{-# NOINLINE ptr_glEdgeFlagPointerEXT #-}
ptr_glEdgeFlagPointerEXT :: FunPtr (GLsizei -> GLsizei -> Ptr GLboolean -> IO ())
ptr_glEdgeFlagPointerEXT = unsafePerformIO $ getCommand "glEdgeFlagPointerEXT"

-- glEdgeFlagPointerListIBM ----------------------------------------------------

glEdgeFlagPointerListIBM
  :: MonadIO m
  => GLint -- ^ @stride@.
  -> Ptr (Ptr GLboolean) -- ^ @pointer@ pointing to @COMPSIZE(stride)@ elements of type @Ptr BooleanPointer@.
  -> GLint -- ^ @ptrstride@.
  -> m ()
glEdgeFlagPointerListIBM v1 v2 v3 = liftIO $ dyn262 ptr_glEdgeFlagPointerListIBM v1 v2 v3

{-# NOINLINE ptr_glEdgeFlagPointerListIBM #-}
ptr_glEdgeFlagPointerListIBM :: FunPtr (GLint -> Ptr (Ptr GLboolean) -> GLint -> IO ())
ptr_glEdgeFlagPointerListIBM = unsafePerformIO $ getCommand "glEdgeFlagPointerListIBM"

-- glEdgeFlagv -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEdgeFlag.xml OpenGL 2.x>.
glEdgeFlagv
  :: MonadIO m
  => Ptr GLboolean -- ^ @flag@ pointing to @1@ element of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glEdgeFlagv v1 = liftIO $ dyn263 ptr_glEdgeFlagv v1

{-# NOINLINE ptr_glEdgeFlagv #-}
ptr_glEdgeFlagv :: FunPtr (Ptr GLboolean -> IO ())
ptr_glEdgeFlagv = unsafePerformIO $ getCommand "glEdgeFlagv"

-- glElementPointerAPPLE -------------------------------------------------------

glElementPointerAPPLE
  :: MonadIO m
  => GLenum -- ^ @type@ of type @ElementPointerTypeATI@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(type)@ elements of type @a@.
  -> m ()
glElementPointerAPPLE v1 v2 = liftIO $ dyn230 ptr_glElementPointerAPPLE v1 v2

{-# NOINLINE ptr_glElementPointerAPPLE #-}
ptr_glElementPointerAPPLE :: FunPtr (GLenum -> Ptr a -> IO ())
ptr_glElementPointerAPPLE = unsafePerformIO $ getCommand "glElementPointerAPPLE"

-- glElementPointerATI ---------------------------------------------------------

glElementPointerATI
  :: MonadIO m
  => GLenum -- ^ @type@ of type @ElementPointerTypeATI@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(type)@ elements of type @a@.
  -> m ()
glElementPointerATI v1 v2 = liftIO $ dyn230 ptr_glElementPointerATI v1 v2

{-# NOINLINE ptr_glElementPointerATI #-}
ptr_glElementPointerATI :: FunPtr (GLenum -> Ptr a -> IO ())
ptr_glElementPointerATI = unsafePerformIO $ getCommand "glElementPointerATI"

-- glEnable --------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glEnable.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glEnable.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glEnable.xhtml OpenGL 4.x>.
glEnable
  :: MonadIO m
  => GLenum -- ^ @cap@ of type [EnableCap](Graphics-GL-Groups.html#EnableCap).
  -> m ()
glEnable v1 = liftIO $ dyn4 ptr_glEnable v1

{-# NOINLINE ptr_glEnable #-}
ptr_glEnable :: FunPtr (GLenum -> IO ())
ptr_glEnable = unsafePerformIO $ getCommand "glEnable"

-- glEnableClientState ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEnableClientState.xml OpenGL 2.x>.
glEnableClientState
  :: MonadIO m
  => GLenum -- ^ @array@ of type [EnableCap](Graphics-GL-Groups.html#EnableCap).
  -> m ()
glEnableClientState v1 = liftIO $ dyn4 ptr_glEnableClientState v1

{-# NOINLINE ptr_glEnableClientState #-}
ptr_glEnableClientState :: FunPtr (GLenum -> IO ())
ptr_glEnableClientState = unsafePerformIO $ getCommand "glEnableClientState"

-- glEnableClientStateIndexedEXT -----------------------------------------------

glEnableClientStateIndexedEXT
  :: MonadIO m
  => GLenum -- ^ @array@ of type [EnableCap](Graphics-GL-Groups.html#EnableCap).
  -> GLuint -- ^ @index@.
  -> m ()
glEnableClientStateIndexedEXT v1 v2 = liftIO $ dyn16 ptr_glEnableClientStateIndexedEXT v1 v2

{-# NOINLINE ptr_glEnableClientStateIndexedEXT #-}
ptr_glEnableClientStateIndexedEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEnableClientStateIndexedEXT = unsafePerformIO $ getCommand "glEnableClientStateIndexedEXT"

-- glEnableClientStateiEXT -----------------------------------------------------

glEnableClientStateiEXT
  :: MonadIO m
  => GLenum -- ^ @array@ of type [EnableCap](Graphics-GL-Groups.html#EnableCap).
  -> GLuint -- ^ @index@.
  -> m ()
glEnableClientStateiEXT v1 v2 = liftIO $ dyn16 ptr_glEnableClientStateiEXT v1 v2

{-# NOINLINE ptr_glEnableClientStateiEXT #-}
ptr_glEnableClientStateiEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEnableClientStateiEXT = unsafePerformIO $ getCommand "glEnableClientStateiEXT"

-- glEnableDriverControlQCOM ---------------------------------------------------

glEnableDriverControlQCOM
  :: MonadIO m
  => GLuint -- ^ @driverControl@.
  -> m ()
glEnableDriverControlQCOM v1 = liftIO $ dyn2 ptr_glEnableDriverControlQCOM v1

{-# NOINLINE ptr_glEnableDriverControlQCOM #-}
ptr_glEnableDriverControlQCOM :: FunPtr (GLuint -> IO ())
ptr_glEnableDriverControlQCOM = unsafePerformIO $ getCommand "glEnableDriverControlQCOM"

-- glEnableIndexedEXT ----------------------------------------------------------

-- | This command is an alias for 'glEnablei'.
glEnableIndexedEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnableIndexedEXT v1 v2 = liftIO $ dyn16 ptr_glEnableIndexedEXT v1 v2

{-# NOINLINE ptr_glEnableIndexedEXT #-}
ptr_glEnableIndexedEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEnableIndexedEXT = unsafePerformIO $ getCommand "glEnableIndexedEXT"

-- glEnableVariantClientStateEXT -----------------------------------------------

glEnableVariantClientStateEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m ()
glEnableVariantClientStateEXT v1 = liftIO $ dyn2 ptr_glEnableVariantClientStateEXT v1

{-# NOINLINE ptr_glEnableVariantClientStateEXT #-}
ptr_glEnableVariantClientStateEXT :: FunPtr (GLuint -> IO ())
ptr_glEnableVariantClientStateEXT = unsafePerformIO $ getCommand "glEnableVariantClientStateEXT"

-- glEnableVertexArrayAttrib ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glEnableVertexAttribArray.xhtml OpenGL 4.x>.
glEnableVertexArrayAttrib
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnableVertexArrayAttrib v1 v2 = liftIO $ dyn3 ptr_glEnableVertexArrayAttrib v1 v2

{-# NOINLINE ptr_glEnableVertexArrayAttrib #-}
ptr_glEnableVertexArrayAttrib :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glEnableVertexArrayAttrib = unsafePerformIO $ getCommand "glEnableVertexArrayAttrib"

-- glEnableVertexArrayAttribEXT ------------------------------------------------

glEnableVertexArrayAttribEXT
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnableVertexArrayAttribEXT v1 v2 = liftIO $ dyn3 ptr_glEnableVertexArrayAttribEXT v1 v2

{-# NOINLINE ptr_glEnableVertexArrayAttribEXT #-}
ptr_glEnableVertexArrayAttribEXT :: FunPtr (GLuint -> GLuint -> IO ())
ptr_glEnableVertexArrayAttribEXT = unsafePerformIO $ getCommand "glEnableVertexArrayAttribEXT"

-- glEnableVertexArrayEXT ------------------------------------------------------

glEnableVertexArrayEXT
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLenum -- ^ @array@ of type [EnableCap](Graphics-GL-Groups.html#EnableCap).
  -> m ()
glEnableVertexArrayEXT v1 v2 = liftIO $ dyn15 ptr_glEnableVertexArrayEXT v1 v2

{-# NOINLINE ptr_glEnableVertexArrayEXT #-}
ptr_glEnableVertexArrayEXT :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glEnableVertexArrayEXT = unsafePerformIO $ getCommand "glEnableVertexArrayEXT"

-- glEnableVertexAttribAPPLE ---------------------------------------------------

glEnableVertexAttribAPPLE
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> m ()
glEnableVertexAttribAPPLE v1 v2 = liftIO $ dyn15 ptr_glEnableVertexAttribAPPLE v1 v2

{-# NOINLINE ptr_glEnableVertexAttribAPPLE #-}
ptr_glEnableVertexAttribAPPLE :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glEnableVertexAttribAPPLE = unsafePerformIO $ getCommand "glEnableVertexAttribAPPLE"

-- glEnableVertexAttribArray ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glEnableVertexAttribArray.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glEnableVertexAttribArray.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glEnableVertexAttribArray.xhtml OpenGL 4.x>.
glEnableVertexAttribArray
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> m ()
glEnableVertexAttribArray v1 = liftIO $ dyn2 ptr_glEnableVertexAttribArray v1

{-# NOINLINE ptr_glEnableVertexAttribArray #-}
ptr_glEnableVertexAttribArray :: FunPtr (GLuint -> IO ())
ptr_glEnableVertexAttribArray = unsafePerformIO $ getCommand "glEnableVertexAttribArray"

-- glEnableVertexAttribArrayARB ------------------------------------------------

-- | This command is an alias for 'glEnableVertexAttribArray'.
glEnableVertexAttribArrayARB
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> m ()
glEnableVertexAttribArrayARB v1 = liftIO $ dyn2 ptr_glEnableVertexAttribArrayARB v1

{-# NOINLINE ptr_glEnableVertexAttribArrayARB #-}
ptr_glEnableVertexAttribArrayARB :: FunPtr (GLuint -> IO ())
ptr_glEnableVertexAttribArrayARB = unsafePerformIO $ getCommand "glEnableVertexAttribArrayARB"

-- glEnablei -------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glEnable.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glEnable.xhtml OpenGL 4.x>.
glEnablei
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnablei v1 v2 = liftIO $ dyn16 ptr_glEnablei v1 v2

{-# NOINLINE ptr_glEnablei #-}
ptr_glEnablei :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEnablei = unsafePerformIO $ getCommand "glEnablei"

-- glEnableiEXT ----------------------------------------------------------------

-- | This command is an alias for 'glEnablei'.
glEnableiEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnableiEXT v1 v2 = liftIO $ dyn16 ptr_glEnableiEXT v1 v2

{-# NOINLINE ptr_glEnableiEXT #-}
ptr_glEnableiEXT :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEnableiEXT = unsafePerformIO $ getCommand "glEnableiEXT"

-- glEnableiNV -----------------------------------------------------------------

-- | This command is an alias for 'glEnablei'.
glEnableiNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnableiNV v1 v2 = liftIO $ dyn16 ptr_glEnableiNV v1 v2

{-# NOINLINE ptr_glEnableiNV #-}
ptr_glEnableiNV :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEnableiNV = unsafePerformIO $ getCommand "glEnableiNV"

-- glEnableiOES ----------------------------------------------------------------

-- | This command is an alias for 'glEnablei'.
glEnableiOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glEnableiOES v1 v2 = liftIO $ dyn16 ptr_glEnableiOES v1 v2

{-# NOINLINE ptr_glEnableiOES #-}
ptr_glEnableiOES :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEnableiOES = unsafePerformIO $ getCommand "glEnableiOES"

-- glEnd -----------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glBegin.xml OpenGL 2.x>.
glEnd
  :: MonadIO m
  => m ()
glEnd = liftIO $ dyn10 ptr_glEnd

{-# NOINLINE ptr_glEnd #-}
ptr_glEnd :: FunPtr (IO ())
ptr_glEnd = unsafePerformIO $ getCommand "glEnd"

-- glEndConditionalRender ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBeginConditionalRender.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBeginConditionalRender.xhtml OpenGL 4.x>.
glEndConditionalRender
  :: MonadIO m
  => m ()
glEndConditionalRender = liftIO $ dyn10 ptr_glEndConditionalRender

{-# NOINLINE ptr_glEndConditionalRender #-}
ptr_glEndConditionalRender :: FunPtr (IO ())
ptr_glEndConditionalRender = unsafePerformIO $ getCommand "glEndConditionalRender"

-- glEndConditionalRenderNV ----------------------------------------------------

-- | This command is an alias for 'glEndConditionalRender'.
glEndConditionalRenderNV
  :: MonadIO m
  => m ()
glEndConditionalRenderNV = liftIO $ dyn10 ptr_glEndConditionalRenderNV

{-# NOINLINE ptr_glEndConditionalRenderNV #-}
ptr_glEndConditionalRenderNV :: FunPtr (IO ())
ptr_glEndConditionalRenderNV = unsafePerformIO $ getCommand "glEndConditionalRenderNV"

-- glEndConditionalRenderNVX ---------------------------------------------------

-- | This command is an alias for 'glEndConditionalRender'.
glEndConditionalRenderNVX
  :: MonadIO m
  => m ()
glEndConditionalRenderNVX = liftIO $ dyn10 ptr_glEndConditionalRenderNVX

{-# NOINLINE ptr_glEndConditionalRenderNVX #-}
ptr_glEndConditionalRenderNVX :: FunPtr (IO ())
ptr_glEndConditionalRenderNVX = unsafePerformIO $ getCommand "glEndConditionalRenderNVX"

-- glEndFragmentShaderATI ------------------------------------------------------

glEndFragmentShaderATI
  :: MonadIO m
  => m ()
glEndFragmentShaderATI = liftIO $ dyn10 ptr_glEndFragmentShaderATI

{-# NOINLINE ptr_glEndFragmentShaderATI #-}
ptr_glEndFragmentShaderATI :: FunPtr (IO ())
ptr_glEndFragmentShaderATI = unsafePerformIO $ getCommand "glEndFragmentShaderATI"

-- glEndList -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glNewList.xml OpenGL 2.x>.
glEndList
  :: MonadIO m
  => m ()
glEndList = liftIO $ dyn10 ptr_glEndList

{-# NOINLINE ptr_glEndList #-}
ptr_glEndList :: FunPtr (IO ())
ptr_glEndList = unsafePerformIO $ getCommand "glEndList"

-- glEndOcclusionQueryNV -------------------------------------------------------

glEndOcclusionQueryNV
  :: MonadIO m
  => m ()
glEndOcclusionQueryNV = liftIO $ dyn10 ptr_glEndOcclusionQueryNV

{-# NOINLINE ptr_glEndOcclusionQueryNV #-}
ptr_glEndOcclusionQueryNV :: FunPtr (IO ())
ptr_glEndOcclusionQueryNV = unsafePerformIO $ getCommand "glEndOcclusionQueryNV"

-- glEndPerfMonitorAMD ---------------------------------------------------------

glEndPerfMonitorAMD
  :: MonadIO m
  => GLuint -- ^ @monitor@.
  -> m ()
glEndPerfMonitorAMD v1 = liftIO $ dyn2 ptr_glEndPerfMonitorAMD v1

{-# NOINLINE ptr_glEndPerfMonitorAMD #-}
ptr_glEndPerfMonitorAMD :: FunPtr (GLuint -> IO ())
ptr_glEndPerfMonitorAMD = unsafePerformIO $ getCommand "glEndPerfMonitorAMD"

-- glEndPerfQueryINTEL ---------------------------------------------------------

glEndPerfQueryINTEL
  :: MonadIO m
  => GLuint -- ^ @queryHandle@.
  -> m ()
glEndPerfQueryINTEL v1 = liftIO $ dyn2 ptr_glEndPerfQueryINTEL v1

{-# NOINLINE ptr_glEndPerfQueryINTEL #-}
ptr_glEndPerfQueryINTEL :: FunPtr (GLuint -> IO ())
ptr_glEndPerfQueryINTEL = unsafePerformIO $ getCommand "glEndPerfQueryINTEL"

-- glEndQuery ------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glBeginQuery.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glBeginQuery.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBeginQuery.xhtml OpenGL 4.x>.
glEndQuery
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glEndQuery v1 = liftIO $ dyn4 ptr_glEndQuery v1

{-# NOINLINE ptr_glEndQuery #-}
ptr_glEndQuery :: FunPtr (GLenum -> IO ())
ptr_glEndQuery = unsafePerformIO $ getCommand "glEndQuery"

-- glEndQueryARB ---------------------------------------------------------------

-- | This command is an alias for 'glEndQuery'.
glEndQueryARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glEndQueryARB v1 = liftIO $ dyn4 ptr_glEndQueryARB v1

{-# NOINLINE ptr_glEndQueryARB #-}
ptr_glEndQueryARB :: FunPtr (GLenum -> IO ())
ptr_glEndQueryARB = unsafePerformIO $ getCommand "glEndQueryARB"

-- glEndQueryEXT ---------------------------------------------------------------

glEndQueryEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glEndQueryEXT v1 = liftIO $ dyn4 ptr_glEndQueryEXT v1

{-# NOINLINE ptr_glEndQueryEXT #-}
ptr_glEndQueryEXT :: FunPtr (GLenum -> IO ())
ptr_glEndQueryEXT = unsafePerformIO $ getCommand "glEndQueryEXT"

-- glEndQueryIndexed -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glBeginQueryIndexed.xhtml OpenGL 4.x>.
glEndQueryIndexed
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m ()
glEndQueryIndexed v1 v2 = liftIO $ dyn16 ptr_glEndQueryIndexed v1 v2

{-# NOINLINE ptr_glEndQueryIndexed #-}
ptr_glEndQueryIndexed :: FunPtr (GLenum -> GLuint -> IO ())
ptr_glEndQueryIndexed = unsafePerformIO $ getCommand "glEndQueryIndexed"

-- glEndTilingQCOM -------------------------------------------------------------

glEndTilingQCOM
  :: MonadIO m
  => GLbitfield -- ^ @preserveMask@.
  -> m ()
glEndTilingQCOM v1 = liftIO $ dyn69 ptr_glEndTilingQCOM v1

{-# NOINLINE ptr_glEndTilingQCOM #-}
ptr_glEndTilingQCOM :: FunPtr (GLbitfield -> IO ())
ptr_glEndTilingQCOM = unsafePerformIO $ getCommand "glEndTilingQCOM"

-- glEndTransformFeedback ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glBeginTransformFeedback.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glBeginTransformFeedback.xhtml OpenGL 4.x>.
glEndTransformFeedback
  :: MonadIO m
  => m ()
glEndTransformFeedback = liftIO $ dyn10 ptr_glEndTransformFeedback

{-# NOINLINE ptr_glEndTransformFeedback #-}
ptr_glEndTransformFeedback :: FunPtr (IO ())
ptr_glEndTransformFeedback = unsafePerformIO $ getCommand "glEndTransformFeedback"

-- glEndTransformFeedbackEXT ---------------------------------------------------

-- | This command is an alias for 'glEndTransformFeedback'.
glEndTransformFeedbackEXT
  :: MonadIO m
  => m ()
glEndTransformFeedbackEXT = liftIO $ dyn10 ptr_glEndTransformFeedbackEXT

{-# NOINLINE ptr_glEndTransformFeedbackEXT #-}
ptr_glEndTransformFeedbackEXT :: FunPtr (IO ())
ptr_glEndTransformFeedbackEXT = unsafePerformIO $ getCommand "glEndTransformFeedbackEXT"

-- glEndTransformFeedbackNV ----------------------------------------------------

-- | This command is an alias for 'glEndTransformFeedback'.
glEndTransformFeedbackNV
  :: MonadIO m
  => m ()
glEndTransformFeedbackNV = liftIO $ dyn10 ptr_glEndTransformFeedbackNV

{-# NOINLINE ptr_glEndTransformFeedbackNV #-}
ptr_glEndTransformFeedbackNV :: FunPtr (IO ())
ptr_glEndTransformFeedbackNV = unsafePerformIO $ getCommand "glEndTransformFeedbackNV"

-- glEndVertexShaderEXT --------------------------------------------------------

glEndVertexShaderEXT
  :: MonadIO m
  => m ()
glEndVertexShaderEXT = liftIO $ dyn10 ptr_glEndVertexShaderEXT

{-# NOINLINE ptr_glEndVertexShaderEXT #-}
ptr_glEndVertexShaderEXT :: FunPtr (IO ())
ptr_glEndVertexShaderEXT = unsafePerformIO $ getCommand "glEndVertexShaderEXT"

-- glEndVideoCaptureNV ---------------------------------------------------------

glEndVideoCaptureNV
  :: MonadIO m
  => GLuint -- ^ @video_capture_slot@.
  -> m ()
glEndVideoCaptureNV v1 = liftIO $ dyn2 ptr_glEndVideoCaptureNV v1

{-# NOINLINE ptr_glEndVideoCaptureNV #-}
ptr_glEndVideoCaptureNV :: FunPtr (GLuint -> IO ())
ptr_glEndVideoCaptureNV = unsafePerformIO $ getCommand "glEndVideoCaptureNV"

-- glEvalCoord1d ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>. The vector equivalent of this command is 'glEvalCoord1dv'.
glEvalCoord1d
  :: MonadIO m
  => GLdouble -- ^ @u@ of type @CoordD@.
  -> m ()
glEvalCoord1d v1 = liftIO $ dyn78 ptr_glEvalCoord1d v1

{-# NOINLINE ptr_glEvalCoord1d #-}
ptr_glEvalCoord1d :: FunPtr (GLdouble -> IO ())
ptr_glEvalCoord1d = unsafePerformIO $ getCommand "glEvalCoord1d"

-- glEvalCoord1dv --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>.
glEvalCoord1dv
  :: MonadIO m
  => Ptr GLdouble -- ^ @u@ pointing to @1@ element of type @CoordD@.
  -> m ()
glEvalCoord1dv v1 = liftIO $ dyn39 ptr_glEvalCoord1dv v1

{-# NOINLINE ptr_glEvalCoord1dv #-}
ptr_glEvalCoord1dv :: FunPtr (Ptr GLdouble -> IO ())
ptr_glEvalCoord1dv = unsafePerformIO $ getCommand "glEvalCoord1dv"

-- glEvalCoord1f ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>. The vector equivalent of this command is 'glEvalCoord1fv'.
glEvalCoord1f
  :: MonadIO m
  => GLfloat -- ^ @u@ of type @CoordF@.
  -> m ()
glEvalCoord1f v1 = liftIO $ dyn79 ptr_glEvalCoord1f v1

{-# NOINLINE ptr_glEvalCoord1f #-}
ptr_glEvalCoord1f :: FunPtr (GLfloat -> IO ())
ptr_glEvalCoord1f = unsafePerformIO $ getCommand "glEvalCoord1f"

-- glEvalCoord1fv --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>.
glEvalCoord1fv
  :: MonadIO m
  => Ptr GLfloat -- ^ @u@ pointing to @1@ element of type @CoordF@.
  -> m ()
glEvalCoord1fv v1 = liftIO $ dyn41 ptr_glEvalCoord1fv v1

{-# NOINLINE ptr_glEvalCoord1fv #-}
ptr_glEvalCoord1fv :: FunPtr (Ptr GLfloat -> IO ())
ptr_glEvalCoord1fv = unsafePerformIO $ getCommand "glEvalCoord1fv"

-- glEvalCoord1xOES ------------------------------------------------------------

glEvalCoord1xOES
  :: MonadIO m
  => GLfixed -- ^ @u@.
  -> m ()
glEvalCoord1xOES v1 = liftIO $ dyn81 ptr_glEvalCoord1xOES v1

{-# NOINLINE ptr_glEvalCoord1xOES #-}
ptr_glEvalCoord1xOES :: FunPtr (GLfixed -> IO ())
ptr_glEvalCoord1xOES = unsafePerformIO $ getCommand "glEvalCoord1xOES"

-- glEvalCoord1xvOES -----------------------------------------------------------

glEvalCoord1xvOES
  :: MonadIO m
  => Ptr GLfixed -- ^ @coords@ pointing to @1@ element of type @GLfixed@.
  -> m ()
glEvalCoord1xvOES v1 = liftIO $ dyn107 ptr_glEvalCoord1xvOES v1

{-# NOINLINE ptr_glEvalCoord1xvOES #-}
ptr_glEvalCoord1xvOES :: FunPtr (Ptr GLfixed -> IO ())
ptr_glEvalCoord1xvOES = unsafePerformIO $ getCommand "glEvalCoord1xvOES"

-- glEvalCoord2d ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>. The vector equivalent of this command is 'glEvalCoord2dv'.
glEvalCoord2d
  :: MonadIO m
  => GLdouble -- ^ @u@ of type @CoordD@.
  -> GLdouble -- ^ @v@ of type @CoordD@.
  -> m ()
glEvalCoord2d v1 v2 = liftIO $ dyn217 ptr_glEvalCoord2d v1 v2

{-# NOINLINE ptr_glEvalCoord2d #-}
ptr_glEvalCoord2d :: FunPtr (GLdouble -> GLdouble -> IO ())
ptr_glEvalCoord2d = unsafePerformIO $ getCommand "glEvalCoord2d"

-- glEvalCoord2dv --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>.
glEvalCoord2dv
  :: MonadIO m
  => Ptr GLdouble -- ^ @u@ pointing to @2@ elements of type @CoordD@.
  -> m ()
glEvalCoord2dv v1 = liftIO $ dyn39 ptr_glEvalCoord2dv v1

{-# NOINLINE ptr_glEvalCoord2dv #-}
ptr_glEvalCoord2dv :: FunPtr (Ptr GLdouble -> IO ())
ptr_glEvalCoord2dv = unsafePerformIO $ getCommand "glEvalCoord2dv"

-- glEvalCoord2f ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>. The vector equivalent of this command is 'glEvalCoord2fv'.
glEvalCoord2f
  :: MonadIO m
  => GLfloat -- ^ @u@ of type @CoordF@.
  -> GLfloat -- ^ @v@ of type @CoordF@.
  -> m ()
glEvalCoord2f v1 v2 = liftIO $ dyn222 ptr_glEvalCoord2f v1 v2

{-# NOINLINE ptr_glEvalCoord2f #-}
ptr_glEvalCoord2f :: FunPtr (GLfloat -> GLfloat -> IO ())
ptr_glEvalCoord2f = unsafePerformIO $ getCommand "glEvalCoord2f"

-- glEvalCoord2fv --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalCoord.xml OpenGL 2.x>.
glEvalCoord2fv
  :: MonadIO m
  => Ptr GLfloat -- ^ @u@ pointing to @2@ elements of type @CoordF@.
  -> m ()
glEvalCoord2fv v1 = liftIO $ dyn41 ptr_glEvalCoord2fv v1

{-# NOINLINE ptr_glEvalCoord2fv #-}
ptr_glEvalCoord2fv :: FunPtr (Ptr GLfloat -> IO ())
ptr_glEvalCoord2fv = unsafePerformIO $ getCommand "glEvalCoord2fv"

-- glEvalCoord2xOES ------------------------------------------------------------

glEvalCoord2xOES
  :: MonadIO m
  => GLfixed -- ^ @u@.
  -> GLfixed -- ^ @v@.
  -> m ()
glEvalCoord2xOES v1 v2 = liftIO $ dyn224 ptr_glEvalCoord2xOES v1 v2

{-# NOINLINE ptr_glEvalCoord2xOES #-}
ptr_glEvalCoord2xOES :: FunPtr (GLfixed -> GLfixed -> IO ())
ptr_glEvalCoord2xOES = unsafePerformIO $ getCommand "glEvalCoord2xOES"

-- glEvalCoord2xvOES -----------------------------------------------------------

glEvalCoord2xvOES
  :: MonadIO m
  => Ptr GLfixed -- ^ @coords@ pointing to @2@ elements of type @GLfixed@.
  -> m ()
glEvalCoord2xvOES v1 = liftIO $ dyn107 ptr_glEvalCoord2xvOES v1

{-# NOINLINE ptr_glEvalCoord2xvOES #-}
ptr_glEvalCoord2xvOES :: FunPtr (Ptr GLfixed -> IO ())
ptr_glEvalCoord2xvOES = unsafePerformIO $ getCommand "glEvalCoord2xvOES"

-- glEvalMapsNV ----------------------------------------------------------------

glEvalMapsNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @EvalTargetNV@.
  -> GLenum -- ^ @mode@ of type @EvalMapsModeNV@.
  -> m ()
glEvalMapsNV v1 v2 = liftIO $ dyn51 ptr_glEvalMapsNV v1 v2

{-# NOINLINE ptr_glEvalMapsNV #-}
ptr_glEvalMapsNV :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glEvalMapsNV = unsafePerformIO $ getCommand "glEvalMapsNV"

-- glEvalMesh1 -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalMesh.xml OpenGL 2.x>.
glEvalMesh1
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [MeshMode1](Graphics-GL-Groups.html#MeshMode1).
  -> GLint -- ^ @i1@ of type @CheckedInt32@.
  -> GLint -- ^ @i2@ of type @CheckedInt32@.
  -> m ()
glEvalMesh1 v1 v2 v3 = liftIO $ dyn264 ptr_glEvalMesh1 v1 v2 v3

{-# NOINLINE ptr_glEvalMesh1 #-}
ptr_glEvalMesh1 :: FunPtr (GLenum -> GLint -> GLint -> IO ())
ptr_glEvalMesh1 = unsafePerformIO $ getCommand "glEvalMesh1"

-- glEvalMesh2 -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalMesh.xml OpenGL 2.x>.
glEvalMesh2
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [MeshMode2](Graphics-GL-Groups.html#MeshMode2).
  -> GLint -- ^ @i1@ of type @CheckedInt32@.
  -> GLint -- ^ @i2@ of type @CheckedInt32@.
  -> GLint -- ^ @j1@ of type @CheckedInt32@.
  -> GLint -- ^ @j2@ of type @CheckedInt32@.
  -> m ()
glEvalMesh2 v1 v2 v3 v4 v5 = liftIO $ dyn265 ptr_glEvalMesh2 v1 v2 v3 v4 v5

{-# NOINLINE ptr_glEvalMesh2 #-}
ptr_glEvalMesh2 :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> IO ())
ptr_glEvalMesh2 = unsafePerformIO $ getCommand "glEvalMesh2"

-- glEvalPoint1 ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalPoint.xml OpenGL 2.x>.
glEvalPoint1
  :: MonadIO m
  => GLint -- ^ @i@.
  -> m ()
glEvalPoint1 v1 = liftIO $ dyn12 ptr_glEvalPoint1 v1

{-# NOINLINE ptr_glEvalPoint1 #-}
ptr_glEvalPoint1 :: FunPtr (GLint -> IO ())
ptr_glEvalPoint1 = unsafePerformIO $ getCommand "glEvalPoint1"

-- glEvalPoint2 ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glEvalPoint.xml OpenGL 2.x>.
glEvalPoint2
  :: MonadIO m
  => GLint -- ^ @i@ of type @CheckedInt32@.
  -> GLint -- ^ @j@ of type @CheckedInt32@.
  -> m ()
glEvalPoint2 v1 v2 = liftIO $ dyn266 ptr_glEvalPoint2 v1 v2

{-# NOINLINE ptr_glEvalPoint2 #-}
ptr_glEvalPoint2 :: FunPtr (GLint -> GLint -> IO ())
ptr_glEvalPoint2 = unsafePerformIO $ getCommand "glEvalPoint2"

-- glEvaluateDepthValuesARB ----------------------------------------------------

glEvaluateDepthValuesARB
  :: MonadIO m
  => m ()
glEvaluateDepthValuesARB = liftIO $ dyn10 ptr_glEvaluateDepthValuesARB

{-# NOINLINE ptr_glEvaluateDepthValuesARB #-}
ptr_glEvaluateDepthValuesARB :: FunPtr (IO ())
ptr_glEvaluateDepthValuesARB = unsafePerformIO $ getCommand "glEvaluateDepthValuesARB"

-- glExecuteProgramNV ----------------------------------------------------------

glExecuteProgramNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @VertexAttribEnumNV@.
  -> GLuint -- ^ @id@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glExecuteProgramNV v1 v2 v3 = liftIO $ dyn267 ptr_glExecuteProgramNV v1 v2 v3

{-# NOINLINE ptr_glExecuteProgramNV #-}
ptr_glExecuteProgramNV :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glExecuteProgramNV = unsafePerformIO $ getCommand "glExecuteProgramNV"

-- glExtGetBufferPointervQCOM --------------------------------------------------

glExtGetBufferPointervQCOM
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> Ptr (Ptr a) -- ^ @params@.
  -> m ()
glExtGetBufferPointervQCOM v1 v2 = liftIO $ dyn268 ptr_glExtGetBufferPointervQCOM v1 v2

{-# NOINLINE ptr_glExtGetBufferPointervQCOM #-}
ptr_glExtGetBufferPointervQCOM :: FunPtr (GLenum -> Ptr (Ptr a) -> IO ())
ptr_glExtGetBufferPointervQCOM = unsafePerformIO $ getCommand "glExtGetBufferPointervQCOM"

-- glExtGetBuffersQCOM ---------------------------------------------------------

glExtGetBuffersQCOM
  :: MonadIO m
  => Ptr GLuint -- ^ @buffers@ pointing to @maxBuffers@ elements of type @GLuint@.
  -> GLint -- ^ @maxBuffers@.
  -> Ptr GLint -- ^ @numBuffers@ pointing to @1@ element of type @GLint@.
  -> m ()
glExtGetBuffersQCOM v1 v2 v3 = liftIO $ dyn269 ptr_glExtGetBuffersQCOM v1 v2 v3

{-# NOINLINE ptr_glExtGetBuffersQCOM #-}
ptr_glExtGetBuffersQCOM :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
ptr_glExtGetBuffersQCOM = unsafePerformIO $ getCommand "glExtGetBuffersQCOM"

-- glExtGetFramebuffersQCOM ----------------------------------------------------

glExtGetFramebuffersQCOM
  :: MonadIO m
  => Ptr GLuint -- ^ @framebuffers@ pointing to @maxFramebuffers@ elements of type @GLuint@.
  -> GLint -- ^ @maxFramebuffers@.
  -> Ptr GLint -- ^ @numFramebuffers@ pointing to @1@ element of type @GLint@.
  -> m ()
glExtGetFramebuffersQCOM v1 v2 v3 = liftIO $ dyn269 ptr_glExtGetFramebuffersQCOM v1 v2 v3

{-# NOINLINE ptr_glExtGetFramebuffersQCOM #-}
ptr_glExtGetFramebuffersQCOM :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
ptr_glExtGetFramebuffersQCOM = unsafePerformIO $ getCommand "glExtGetFramebuffersQCOM"

-- glExtGetProgramBinarySourceQCOM ---------------------------------------------

glExtGetProgramBinarySourceQCOM
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @shadertype@.
  -> Ptr GLchar -- ^ @source@.
  -> Ptr GLint -- ^ @length@.
  -> m ()
glExtGetProgramBinarySourceQCOM v1 v2 v3 v4 = liftIO $ dyn270 ptr_glExtGetProgramBinarySourceQCOM v1 v2 v3 v4

{-# NOINLINE ptr_glExtGetProgramBinarySourceQCOM #-}
ptr_glExtGetProgramBinarySourceQCOM :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> Ptr GLint -> IO ())
ptr_glExtGetProgramBinarySourceQCOM = unsafePerformIO $ getCommand "glExtGetProgramBinarySourceQCOM"

-- glExtGetProgramsQCOM --------------------------------------------------------

glExtGetProgramsQCOM
  :: MonadIO m
  => Ptr GLuint -- ^ @programs@ pointing to @maxPrograms@ elements of type @GLuint@.
  -> GLint -- ^ @maxPrograms@.
  -> Ptr GLint -- ^ @numPrograms@ pointing to @1@ element of type @GLint@.
  -> m ()
glExtGetProgramsQCOM v1 v2 v3 = liftIO $ dyn269 ptr_glExtGetProgramsQCOM v1 v2 v3

{-# NOINLINE ptr_glExtGetProgramsQCOM #-}
ptr_glExtGetProgramsQCOM :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
ptr_glExtGetProgramsQCOM = unsafePerformIO $ getCommand "glExtGetProgramsQCOM"

-- glExtGetRenderbuffersQCOM ---------------------------------------------------

glExtGetRenderbuffersQCOM
  :: MonadIO m
  => Ptr GLuint -- ^ @renderbuffers@ pointing to @maxRenderbuffers@ elements of type @GLuint@.
  -> GLint -- ^ @maxRenderbuffers@.
  -> Ptr GLint -- ^ @numRenderbuffers@ pointing to @1@ element of type @GLint@.
  -> m ()
glExtGetRenderbuffersQCOM v1 v2 v3 = liftIO $ dyn269 ptr_glExtGetRenderbuffersQCOM v1 v2 v3

{-# NOINLINE ptr_glExtGetRenderbuffersQCOM #-}
ptr_glExtGetRenderbuffersQCOM :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
ptr_glExtGetRenderbuffersQCOM = unsafePerformIO $ getCommand "glExtGetRenderbuffersQCOM"

-- glExtGetShadersQCOM ---------------------------------------------------------

glExtGetShadersQCOM
  :: MonadIO m
  => Ptr GLuint -- ^ @shaders@ pointing to @maxShaders@ elements of type @GLuint@.
  -> GLint -- ^ @maxShaders@.
  -> Ptr GLint -- ^ @numShaders@ pointing to @1@ element of type @GLint@.
  -> m ()
glExtGetShadersQCOM v1 v2 v3 = liftIO $ dyn269 ptr_glExtGetShadersQCOM v1 v2 v3

{-# NOINLINE ptr_glExtGetShadersQCOM #-}
ptr_glExtGetShadersQCOM :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
ptr_glExtGetShadersQCOM = unsafePerformIO $ getCommand "glExtGetShadersQCOM"

-- glExtGetTexLevelParameterivQCOM ---------------------------------------------

glExtGetTexLevelParameterivQCOM
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLenum -- ^ @face@.
  -> GLint -- ^ @level@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glExtGetTexLevelParameterivQCOM v1 v2 v3 v4 v5 = liftIO $ dyn271 ptr_glExtGetTexLevelParameterivQCOM v1 v2 v3 v4 v5

{-# NOINLINE ptr_glExtGetTexLevelParameterivQCOM #-}
ptr_glExtGetTexLevelParameterivQCOM :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> Ptr GLint -> IO ())
ptr_glExtGetTexLevelParameterivQCOM = unsafePerformIO $ getCommand "glExtGetTexLevelParameterivQCOM"

-- glExtGetTexSubImageQCOM -----------------------------------------------------

glExtGetTexSubImageQCOM
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> Ptr a -- ^ @texels@.
  -> m ()
glExtGetTexSubImageQCOM v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn272 ptr_glExtGetTexSubImageQCOM v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

{-# NOINLINE ptr_glExtGetTexSubImageQCOM #-}
ptr_glExtGetTexSubImageQCOM :: FunPtr (GLenum -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glExtGetTexSubImageQCOM = unsafePerformIO $ getCommand "glExtGetTexSubImageQCOM"

-- glExtGetTexturesQCOM --------------------------------------------------------

glExtGetTexturesQCOM
  :: MonadIO m
  => Ptr GLuint -- ^ @textures@.
  -> GLint -- ^ @maxTextures@.
  -> Ptr GLint -- ^ @numTextures@.
  -> m ()
glExtGetTexturesQCOM v1 v2 v3 = liftIO $ dyn269 ptr_glExtGetTexturesQCOM v1 v2 v3

{-# NOINLINE ptr_glExtGetTexturesQCOM #-}
ptr_glExtGetTexturesQCOM :: FunPtr (Ptr GLuint -> GLint -> Ptr GLint -> IO ())
ptr_glExtGetTexturesQCOM = unsafePerformIO $ getCommand "glExtGetTexturesQCOM"

-- glExtIsProgramBinaryQCOM ----------------------------------------------------

glExtIsProgramBinaryQCOM
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> m GLboolean
glExtIsProgramBinaryQCOM v1 = liftIO $ dyn273 ptr_glExtIsProgramBinaryQCOM v1

{-# NOINLINE ptr_glExtIsProgramBinaryQCOM #-}
ptr_glExtIsProgramBinaryQCOM :: FunPtr (GLuint -> IO GLboolean)
ptr_glExtIsProgramBinaryQCOM = unsafePerformIO $ getCommand "glExtIsProgramBinaryQCOM"

-- glExtTexObjectStateOverrideiQCOM --------------------------------------------

glExtTexObjectStateOverrideiQCOM
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> GLint -- ^ @param@.
  -> m ()
glExtTexObjectStateOverrideiQCOM v1 v2 v3 = liftIO $ dyn62 ptr_glExtTexObjectStateOverrideiQCOM v1 v2 v3

{-# NOINLINE ptr_glExtTexObjectStateOverrideiQCOM #-}
ptr_glExtTexObjectStateOverrideiQCOM :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glExtTexObjectStateOverrideiQCOM = unsafePerformIO $ getCommand "glExtTexObjectStateOverrideiQCOM"

-- glExtractComponentEXT -------------------------------------------------------

glExtractComponentEXT
  :: MonadIO m
  => GLuint -- ^ @res@.
  -> GLuint -- ^ @src@.
  -> GLuint -- ^ @num@.
  -> m ()
glExtractComponentEXT v1 v2 v3 = liftIO $ dyn102 ptr_glExtractComponentEXT v1 v2 v3

{-# NOINLINE ptr_glExtractComponentEXT #-}
ptr_glExtractComponentEXT :: FunPtr (GLuint -> GLuint -> GLuint -> IO ())
ptr_glExtractComponentEXT = unsafePerformIO $ getCommand "glExtractComponentEXT"

-- glFeedbackBuffer ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFeedbackBuffer.xml OpenGL 2.x>.
glFeedbackBuffer
  :: MonadIO m
  => GLsizei -- ^ @size@.
  -> GLenum -- ^ @type@ of type [FeedbackType](Graphics-GL-Groups.html#FeedbackType).
  -> Ptr GLfloat -- ^ @buffer@ pointing to @size@ elements of type @FeedbackElement@.
  -> m ()
glFeedbackBuffer v1 v2 v3 = liftIO $ dyn274 ptr_glFeedbackBuffer v1 v2 v3

{-# NOINLINE ptr_glFeedbackBuffer #-}
ptr_glFeedbackBuffer :: FunPtr (GLsizei -> GLenum -> Ptr GLfloat -> IO ())
ptr_glFeedbackBuffer = unsafePerformIO $ getCommand "glFeedbackBuffer"

-- glFeedbackBufferxOES --------------------------------------------------------

glFeedbackBufferxOES
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> GLenum -- ^ @type@.
  -> Ptr GLfixed -- ^ @buffer@ pointing to @n@ elements of type @GLfixed@.
  -> m ()
glFeedbackBufferxOES v1 v2 v3 = liftIO $ dyn275 ptr_glFeedbackBufferxOES v1 v2 v3

{-# NOINLINE ptr_glFeedbackBufferxOES #-}
ptr_glFeedbackBufferxOES :: FunPtr (GLsizei -> GLenum -> Ptr GLfixed -> IO ())
ptr_glFeedbackBufferxOES = unsafePerformIO $ getCommand "glFeedbackBufferxOES"

-- glFenceSync -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFenceSync.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFenceSync.xhtml OpenGL 4.x>.
glFenceSync
  :: MonadIO m
  => GLenum -- ^ @condition@.
  -> GLbitfield -- ^ @flags@.
  -> m GLsync -- ^ of type @sync@.
glFenceSync v1 v2 = liftIO $ dyn276 ptr_glFenceSync v1 v2

{-# NOINLINE ptr_glFenceSync #-}
ptr_glFenceSync :: FunPtr (GLenum -> GLbitfield -> IO GLsync)
ptr_glFenceSync = unsafePerformIO $ getCommand "glFenceSync"

-- glFenceSyncAPPLE ------------------------------------------------------------

-- | This command is an alias for 'glFenceSync'.
glFenceSyncAPPLE
  :: MonadIO m
  => GLenum -- ^ @condition@.
  -> GLbitfield -- ^ @flags@.
  -> m GLsync
glFenceSyncAPPLE v1 v2 = liftIO $ dyn276 ptr_glFenceSyncAPPLE v1 v2

{-# NOINLINE ptr_glFenceSyncAPPLE #-}
ptr_glFenceSyncAPPLE :: FunPtr (GLenum -> GLbitfield -> IO GLsync)
ptr_glFenceSyncAPPLE = unsafePerformIO $ getCommand "glFenceSyncAPPLE"

-- glFinalCombinerInputNV ------------------------------------------------------

glFinalCombinerInputNV
  :: MonadIO m
  => GLenum -- ^ @variable@ of type @CombinerVariableNV@.
  -> GLenum -- ^ @input@ of type @CombinerRegisterNV@.
  -> GLenum -- ^ @mapping@ of type @CombinerMappingNV@.
  -> GLenum -- ^ @componentUsage@ of type @CombinerComponentUsageNV@.
  -> m ()
glFinalCombinerInputNV v1 v2 v3 v4 = liftIO $ dyn53 ptr_glFinalCombinerInputNV v1 v2 v3 v4

{-# NOINLINE ptr_glFinalCombinerInputNV #-}
ptr_glFinalCombinerInputNV :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> IO ())
ptr_glFinalCombinerInputNV = unsafePerformIO $ getCommand "glFinalCombinerInputNV"

-- glFinish --------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glFinish.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glFinish.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFinish.xhtml OpenGL 4.x>.
glFinish
  :: MonadIO m
  => m ()
glFinish = liftIO $ dyn10 ptr_glFinish

{-# NOINLINE ptr_glFinish #-}
ptr_glFinish :: FunPtr (IO ())
ptr_glFinish = unsafePerformIO $ getCommand "glFinish"

-- glFinishAsyncSGIX -----------------------------------------------------------

glFinishAsyncSGIX
  :: MonadIO m
  => Ptr GLuint -- ^ @markerp@ pointing to @1@ element of type @GLuint@.
  -> m GLint
glFinishAsyncSGIX v1 = liftIO $ dyn277 ptr_glFinishAsyncSGIX v1

{-# NOINLINE ptr_glFinishAsyncSGIX #-}
ptr_glFinishAsyncSGIX :: FunPtr (Ptr GLuint -> IO GLint)
ptr_glFinishAsyncSGIX = unsafePerformIO $ getCommand "glFinishAsyncSGIX"

-- glFinishFenceAPPLE ----------------------------------------------------------

glFinishFenceAPPLE
  :: MonadIO m
  => GLuint -- ^ @fence@ of type @FenceNV@.
  -> m ()
glFinishFenceAPPLE v1 = liftIO $ dyn2 ptr_glFinishFenceAPPLE v1

{-# NOINLINE ptr_glFinishFenceAPPLE #-}
ptr_glFinishFenceAPPLE :: FunPtr (GLuint -> IO ())
ptr_glFinishFenceAPPLE = unsafePerformIO $ getCommand "glFinishFenceAPPLE"

-- glFinishFenceNV -------------------------------------------------------------

glFinishFenceNV
  :: MonadIO m
  => GLuint -- ^ @fence@ of type @FenceNV@.
  -> m ()
glFinishFenceNV v1 = liftIO $ dyn2 ptr_glFinishFenceNV v1

{-# NOINLINE ptr_glFinishFenceNV #-}
ptr_glFinishFenceNV :: FunPtr (GLuint -> IO ())
ptr_glFinishFenceNV = unsafePerformIO $ getCommand "glFinishFenceNV"

-- glFinishObjectAPPLE ---------------------------------------------------------

glFinishObjectAPPLE
  :: MonadIO m
  => GLenum -- ^ @object@ of type @ObjectTypeAPPLE@.
  -> GLint -- ^ @name@.
  -> m ()
glFinishObjectAPPLE v1 v2 = liftIO $ dyn55 ptr_glFinishObjectAPPLE v1 v2

{-# NOINLINE ptr_glFinishObjectAPPLE #-}
ptr_glFinishObjectAPPLE :: FunPtr (GLenum -> GLint -> IO ())
ptr_glFinishObjectAPPLE = unsafePerformIO $ getCommand "glFinishObjectAPPLE"

-- glFinishTextureSUNX ---------------------------------------------------------

glFinishTextureSUNX
  :: MonadIO m
  => m ()
glFinishTextureSUNX = liftIO $ dyn10 ptr_glFinishTextureSUNX

{-# NOINLINE ptr_glFinishTextureSUNX #-}
ptr_glFinishTextureSUNX :: FunPtr (IO ())
ptr_glFinishTextureSUNX = unsafePerformIO $ getCommand "glFinishTextureSUNX"

-- glFlush ---------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glFlush.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glFlush.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFlush.xhtml OpenGL 4.x>.
glFlush
  :: MonadIO m
  => m ()
glFlush = liftIO $ dyn10 ptr_glFlush

{-# NOINLINE ptr_glFlush #-}
ptr_glFlush :: FunPtr (IO ())
ptr_glFlush = unsafePerformIO $ getCommand "glFlush"

-- glFlushMappedBufferRange ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFlushMappedBufferRange.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFlushMappedBufferRange.xhtml OpenGL 4.x>.
glFlushMappedBufferRange
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @length@ of type @BufferSize@.
  -> m ()
glFlushMappedBufferRange v1 v2 v3 = liftIO $ dyn278 ptr_glFlushMappedBufferRange v1 v2 v3

{-# NOINLINE ptr_glFlushMappedBufferRange #-}
ptr_glFlushMappedBufferRange :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> IO ())
ptr_glFlushMappedBufferRange = unsafePerformIO $ getCommand "glFlushMappedBufferRange"

-- glFlushMappedBufferRangeAPPLE -----------------------------------------------

-- | This command is an alias for 'glFlushMappedBufferRange'.
glFlushMappedBufferRangeAPPLE
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> m ()
glFlushMappedBufferRangeAPPLE v1 v2 v3 = liftIO $ dyn278 ptr_glFlushMappedBufferRangeAPPLE v1 v2 v3

{-# NOINLINE ptr_glFlushMappedBufferRangeAPPLE #-}
ptr_glFlushMappedBufferRangeAPPLE :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> IO ())
ptr_glFlushMappedBufferRangeAPPLE = unsafePerformIO $ getCommand "glFlushMappedBufferRangeAPPLE"

-- glFlushMappedBufferRangeEXT -------------------------------------------------

-- | This command is an alias for 'glFlushMappedBufferRange'.
glFlushMappedBufferRangeEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLintptr -- ^ @offset@.
  -> GLsizeiptr -- ^ @length@.
  -> m ()
glFlushMappedBufferRangeEXT v1 v2 v3 = liftIO $ dyn278 ptr_glFlushMappedBufferRangeEXT v1 v2 v3

{-# NOINLINE ptr_glFlushMappedBufferRangeEXT #-}
ptr_glFlushMappedBufferRangeEXT :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> IO ())
ptr_glFlushMappedBufferRangeEXT = unsafePerformIO $ getCommand "glFlushMappedBufferRangeEXT"

-- glFlushMappedNamedBufferRange -----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glFlushMappedBufferRange.xhtml OpenGL 4.x>.
glFlushMappedNamedBufferRange
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@.
  -> GLsizeiptr -- ^ @length@ of type @BufferSize@.
  -> m ()
glFlushMappedNamedBufferRange v1 v2 v3 = liftIO $ dyn279 ptr_glFlushMappedNamedBufferRange v1 v2 v3

{-# NOINLINE ptr_glFlushMappedNamedBufferRange #-}
ptr_glFlushMappedNamedBufferRange :: FunPtr (GLuint -> GLintptr -> GLsizeiptr -> IO ())
ptr_glFlushMappedNamedBufferRange = unsafePerformIO $ getCommand "glFlushMappedNamedBufferRange"

-- glFlushMappedNamedBufferRangeEXT --------------------------------------------

glFlushMappedNamedBufferRangeEXT
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@.
  -> GLsizeiptr -- ^ @length@.
  -> m ()
glFlushMappedNamedBufferRangeEXT v1 v2 v3 = liftIO $ dyn279 ptr_glFlushMappedNamedBufferRangeEXT v1 v2 v3

{-# NOINLINE ptr_glFlushMappedNamedBufferRangeEXT #-}
ptr_glFlushMappedNamedBufferRangeEXT :: FunPtr (GLuint -> GLintptr -> GLsizeiptr -> IO ())
ptr_glFlushMappedNamedBufferRangeEXT = unsafePerformIO $ getCommand "glFlushMappedNamedBufferRangeEXT"

-- glFlushPixelDataRangeNV -----------------------------------------------------

glFlushPixelDataRangeNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @PixelDataRangeTargetNV@.
  -> m ()
glFlushPixelDataRangeNV v1 = liftIO $ dyn4 ptr_glFlushPixelDataRangeNV v1

{-# NOINLINE ptr_glFlushPixelDataRangeNV #-}
ptr_glFlushPixelDataRangeNV :: FunPtr (GLenum -> IO ())
ptr_glFlushPixelDataRangeNV = unsafePerformIO $ getCommand "glFlushPixelDataRangeNV"

-- glFlushRasterSGIX -----------------------------------------------------------

glFlushRasterSGIX
  :: MonadIO m
  => m ()
glFlushRasterSGIX = liftIO $ dyn10 ptr_glFlushRasterSGIX

{-# NOINLINE ptr_glFlushRasterSGIX #-}
ptr_glFlushRasterSGIX :: FunPtr (IO ())
ptr_glFlushRasterSGIX = unsafePerformIO $ getCommand "glFlushRasterSGIX"

-- glFlushStaticDataIBM --------------------------------------------------------

glFlushStaticDataIBM
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glFlushStaticDataIBM v1 = liftIO $ dyn4 ptr_glFlushStaticDataIBM v1

{-# NOINLINE ptr_glFlushStaticDataIBM #-}
ptr_glFlushStaticDataIBM :: FunPtr (GLenum -> IO ())
ptr_glFlushStaticDataIBM = unsafePerformIO $ getCommand "glFlushStaticDataIBM"

-- glFlushVertexArrayRangeAPPLE ------------------------------------------------

glFlushVertexArrayRangeAPPLE
  :: MonadIO m
  => GLsizei -- ^ @length@.
  -> Ptr a -- ^ @pointer@ pointing to @length@ elements of type @a@.
  -> m ()
glFlushVertexArrayRangeAPPLE v1 v2 = liftIO $ dyn260 ptr_glFlushVertexArrayRangeAPPLE v1 v2

{-# NOINLINE ptr_glFlushVertexArrayRangeAPPLE #-}
ptr_glFlushVertexArrayRangeAPPLE :: FunPtr (GLsizei -> Ptr a -> IO ())
ptr_glFlushVertexArrayRangeAPPLE = unsafePerformIO $ getCommand "glFlushVertexArrayRangeAPPLE"

-- glFlushVertexArrayRangeNV ---------------------------------------------------

glFlushVertexArrayRangeNV
  :: MonadIO m
  => m ()
glFlushVertexArrayRangeNV = liftIO $ dyn10 ptr_glFlushVertexArrayRangeNV

{-# NOINLINE ptr_glFlushVertexArrayRangeNV #-}
ptr_glFlushVertexArrayRangeNV :: FunPtr (IO ())
ptr_glFlushVertexArrayRangeNV = unsafePerformIO $ getCommand "glFlushVertexArrayRangeNV"

-- glFogCoordFormatNV ----------------------------------------------------------

glFogCoordFormatNV
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> GLsizei -- ^ @stride@.
  -> m ()
glFogCoordFormatNV v1 v2 = liftIO $ dyn239 ptr_glFogCoordFormatNV v1 v2

{-# NOINLINE ptr_glFogCoordFormatNV #-}
ptr_glFogCoordFormatNV :: FunPtr (GLenum -> GLsizei -> IO ())
ptr_glFogCoordFormatNV = unsafePerformIO $ getCommand "glFogCoordFormatNV"

-- glFogCoordPointer -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoordPointer.xml OpenGL 2.x>.
glFogCoordPointer
  :: MonadIO m
  => GLenum -- ^ @type@ of type [FogPointerTypeEXT](Graphics-GL-Groups.html#FogPointerTypeEXT).
  -> GLsizei -- ^ @stride@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(type,stride)@ elements of type @a@.
  -> m ()
glFogCoordPointer v1 v2 v3 = liftIO $ dyn46 ptr_glFogCoordPointer v1 v2 v3

{-# NOINLINE ptr_glFogCoordPointer #-}
ptr_glFogCoordPointer :: FunPtr (GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glFogCoordPointer = unsafePerformIO $ getCommand "glFogCoordPointer"

-- glFogCoordPointerEXT --------------------------------------------------------

-- | This command is an alias for 'glFogCoordPointer'.
glFogCoordPointerEXT
  :: MonadIO m
  => GLenum -- ^ @type@ of type [FogPointerTypeEXT](Graphics-GL-Groups.html#FogPointerTypeEXT).
  -> GLsizei -- ^ @stride@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(type,stride)@ elements of type @a@.
  -> m ()
glFogCoordPointerEXT v1 v2 v3 = liftIO $ dyn46 ptr_glFogCoordPointerEXT v1 v2 v3

{-# NOINLINE ptr_glFogCoordPointerEXT #-}
ptr_glFogCoordPointerEXT :: FunPtr (GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glFogCoordPointerEXT = unsafePerformIO $ getCommand "glFogCoordPointerEXT"

-- glFogCoordPointerListIBM ----------------------------------------------------

glFogCoordPointerListIBM
  :: MonadIO m
  => GLenum -- ^ @type@ of type [FogPointerTypeIBM](Graphics-GL-Groups.html#FogPointerTypeIBM).
  -> GLint -- ^ @stride@.
  -> Ptr (Ptr a) -- ^ @pointer@ pointing to @COMPSIZE(type,stride)@ elements of type @Ptr a@.
  -> GLint -- ^ @ptrstride@.
  -> m ()
glFogCoordPointerListIBM v1 v2 v3 v4 = liftIO $ dyn280 ptr_glFogCoordPointerListIBM v1 v2 v3 v4

{-# NOINLINE ptr_glFogCoordPointerListIBM #-}
ptr_glFogCoordPointerListIBM :: FunPtr (GLenum -> GLint -> Ptr (Ptr a) -> GLint -> IO ())
ptr_glFogCoordPointerListIBM = unsafePerformIO $ getCommand "glFogCoordPointerListIBM"

-- glFogCoordd -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoord.xml OpenGL 2.x>. The vector equivalent of this command is 'glFogCoorddv'.
glFogCoordd
  :: MonadIO m
  => GLdouble -- ^ @coord@ of type @CoordD@.
  -> m ()
glFogCoordd v1 = liftIO $ dyn78 ptr_glFogCoordd v1

{-# NOINLINE ptr_glFogCoordd #-}
ptr_glFogCoordd :: FunPtr (GLdouble -> IO ())
ptr_glFogCoordd = unsafePerformIO $ getCommand "glFogCoordd"

-- glFogCoorddEXT --------------------------------------------------------------

-- | The vector equivalent of this command is 'glFogCoorddvEXT'. This command is an alias for 'glFogCoordd'.
glFogCoorddEXT
  :: MonadIO m
  => GLdouble -- ^ @coord@ of type @CoordD@.
  -> m ()
glFogCoorddEXT v1 = liftIO $ dyn78 ptr_glFogCoorddEXT v1

{-# NOINLINE ptr_glFogCoorddEXT #-}
ptr_glFogCoorddEXT :: FunPtr (GLdouble -> IO ())
ptr_glFogCoorddEXT = unsafePerformIO $ getCommand "glFogCoorddEXT"

-- glFogCoorddv ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoord.xml OpenGL 2.x>.
glFogCoorddv
  :: MonadIO m
  => Ptr GLdouble -- ^ @coord@ pointing to @1@ element of type @CoordD@.
  -> m ()
glFogCoorddv v1 = liftIO $ dyn39 ptr_glFogCoorddv v1

{-# NOINLINE ptr_glFogCoorddv #-}
ptr_glFogCoorddv :: FunPtr (Ptr GLdouble -> IO ())
ptr_glFogCoorddv = unsafePerformIO $ getCommand "glFogCoorddv"

-- glFogCoorddvEXT -------------------------------------------------------------

-- | This command is an alias for 'glFogCoorddv'.
glFogCoorddvEXT
  :: MonadIO m
  => Ptr GLdouble -- ^ @coord@ pointing to @1@ element of type @CoordD@.
  -> m ()
glFogCoorddvEXT v1 = liftIO $ dyn39 ptr_glFogCoorddvEXT v1

{-# NOINLINE ptr_glFogCoorddvEXT #-}
ptr_glFogCoorddvEXT :: FunPtr (Ptr GLdouble -> IO ())
ptr_glFogCoorddvEXT = unsafePerformIO $ getCommand "glFogCoorddvEXT"

-- glFogCoordf -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoord.xml OpenGL 2.x>. The vector equivalent of this command is 'glFogCoordfv'.
glFogCoordf
  :: MonadIO m
  => GLfloat -- ^ @coord@ of type @CoordF@.
  -> m ()
glFogCoordf v1 = liftIO $ dyn79 ptr_glFogCoordf v1

{-# NOINLINE ptr_glFogCoordf #-}
ptr_glFogCoordf :: FunPtr (GLfloat -> IO ())
ptr_glFogCoordf = unsafePerformIO $ getCommand "glFogCoordf"

-- glFogCoordfEXT --------------------------------------------------------------

-- | The vector equivalent of this command is 'glFogCoordfvEXT'. This command is an alias for 'glFogCoordf'.
glFogCoordfEXT
  :: MonadIO m
  => GLfloat -- ^ @coord@ of type @CoordF@.
  -> m ()
glFogCoordfEXT v1 = liftIO $ dyn79 ptr_glFogCoordfEXT v1

{-# NOINLINE ptr_glFogCoordfEXT #-}
ptr_glFogCoordfEXT :: FunPtr (GLfloat -> IO ())
ptr_glFogCoordfEXT = unsafePerformIO $ getCommand "glFogCoordfEXT"

-- glFogCoordfv ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFogCoord.xml OpenGL 2.x>.
glFogCoordfv
  :: MonadIO m
  => Ptr GLfloat -- ^ @coord@ pointing to @1@ element of type @CoordF@.
  -> m ()
glFogCoordfv v1 = liftIO $ dyn41 ptr_glFogCoordfv v1

{-# NOINLINE ptr_glFogCoordfv #-}
ptr_glFogCoordfv :: FunPtr (Ptr GLfloat -> IO ())
ptr_glFogCoordfv = unsafePerformIO $ getCommand "glFogCoordfv"

-- glFogCoordfvEXT -------------------------------------------------------------

-- | This command is an alias for 'glFogCoordfv'.
glFogCoordfvEXT
  :: MonadIO m
  => Ptr GLfloat -- ^ @coord@ pointing to @1@ element of type @CoordF@.
  -> m ()
glFogCoordfvEXT v1 = liftIO $ dyn41 ptr_glFogCoordfvEXT v1

{-# NOINLINE ptr_glFogCoordfvEXT #-}
ptr_glFogCoordfvEXT :: FunPtr (Ptr GLfloat -> IO ())
ptr_glFogCoordfvEXT = unsafePerformIO $ getCommand "glFogCoordfvEXT"

-- glFogCoordhNV ---------------------------------------------------------------

-- | The vector equivalent of this command is 'glFogCoordhvNV'.
glFogCoordhNV
  :: MonadIO m
  => GLhalfNV -- ^ @fog@ of type @Half16NV@.
  -> m ()
glFogCoordhNV v1 = liftIO $ dyn281 ptr_glFogCoordhNV v1

{-# NOINLINE ptr_glFogCoordhNV #-}
ptr_glFogCoordhNV :: FunPtr (GLhalfNV -> IO ())
ptr_glFogCoordhNV = unsafePerformIO $ getCommand "glFogCoordhNV"

-- glFogCoordhvNV --------------------------------------------------------------

glFogCoordhvNV
  :: MonadIO m
  => Ptr GLhalfNV -- ^ @fog@ pointing to @1@ element of type @Half16NV@.
  -> m ()
glFogCoordhvNV v1 = liftIO $ dyn99 ptr_glFogCoordhvNV v1

{-# NOINLINE ptr_glFogCoordhvNV #-}
ptr_glFogCoordhvNV :: FunPtr (Ptr GLhalfNV -> IO ())
ptr_glFogCoordhvNV = unsafePerformIO $ getCommand "glFogCoordhvNV"

-- glFogFuncSGIS ---------------------------------------------------------------

glFogFuncSGIS
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLfloat -- ^ @points@ pointing to @n*2@ elements of type @GLfloat@.
  -> m ()
glFogFuncSGIS v1 v2 = liftIO $ dyn192 ptr_glFogFuncSGIS v1 v2

{-# NOINLINE ptr_glFogFuncSGIS #-}
ptr_glFogFuncSGIS :: FunPtr (GLsizei -> Ptr GLfloat -> IO ())
ptr_glFogFuncSGIS = unsafePerformIO $ getCommand "glFogFuncSGIS"

-- glFogf ----------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFog.xml OpenGL 2.x>.
glFogf
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [FogParameter](Graphics-GL-Groups.html#FogParameter).
  -> GLfloat -- ^ @param@ of type @CheckedFloat32@.
  -> m ()
glFogf v1 v2 = liftIO $ dyn0 ptr_glFogf v1 v2

{-# NOINLINE ptr_glFogf #-}
ptr_glFogf :: FunPtr (GLenum -> GLfloat -> IO ())
ptr_glFogf = unsafePerformIO $ getCommand "glFogf"

-- glFogfv ---------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFog.xml OpenGL 2.x>.
glFogfv
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [FogParameter](Graphics-GL-Groups.html#FogParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glFogfv v1 v2 = liftIO $ dyn94 ptr_glFogfv v1 v2

{-# NOINLINE ptr_glFogfv #-}
ptr_glFogfv :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glFogfv = unsafePerformIO $ getCommand "glFogfv"

-- glFogi ----------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFog.xml OpenGL 2.x>.
glFogi
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [FogParameter](Graphics-GL-Groups.html#FogParameter).
  -> GLint -- ^ @param@ of type @CheckedInt32@.
  -> m ()
glFogi v1 v2 = liftIO $ dyn55 ptr_glFogi v1 v2

{-# NOINLINE ptr_glFogi #-}
ptr_glFogi :: FunPtr (GLenum -> GLint -> IO ())
ptr_glFogi = unsafePerformIO $ getCommand "glFogi"

-- glFogiv ---------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFog.xml OpenGL 2.x>.
glFogiv
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [FogParameter](Graphics-GL-Groups.html#FogParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glFogiv v1 v2 = liftIO $ dyn136 ptr_glFogiv v1 v2

{-# NOINLINE ptr_glFogiv #-}
ptr_glFogiv :: FunPtr (GLenum -> Ptr GLint -> IO ())
ptr_glFogiv = unsafePerformIO $ getCommand "glFogiv"

-- glFogx ----------------------------------------------------------------------

glFogx
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> GLfixed -- ^ @param@.
  -> m ()
glFogx v1 v2 = liftIO $ dyn1 ptr_glFogx v1 v2

{-# NOINLINE ptr_glFogx #-}
ptr_glFogx :: FunPtr (GLenum -> GLfixed -> IO ())
ptr_glFogx = unsafePerformIO $ getCommand "glFogx"

-- glFogxOES -------------------------------------------------------------------

glFogxOES
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> GLfixed -- ^ @param@.
  -> m ()
glFogxOES v1 v2 = liftIO $ dyn1 ptr_glFogxOES v1 v2

{-# NOINLINE ptr_glFogxOES #-}
ptr_glFogxOES :: FunPtr (GLenum -> GLfixed -> IO ())
ptr_glFogxOES = unsafePerformIO $ getCommand "glFogxOES"

-- glFogxv ---------------------------------------------------------------------

glFogxv
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @param@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glFogxv v1 v2 = liftIO $ dyn95 ptr_glFogxv v1 v2

{-# NOINLINE ptr_glFogxv #-}
ptr_glFogxv :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glFogxv = unsafePerformIO $ getCommand "glFogxv"

-- glFogxvOES ------------------------------------------------------------------

glFogxvOES
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @param@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glFogxvOES v1 v2 = liftIO $ dyn95 ptr_glFogxvOES v1 v2

{-# NOINLINE ptr_glFogxvOES #-}
ptr_glFogxvOES :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glFogxvOES = unsafePerformIO $ getCommand "glFogxvOES"

-- glFragmentColorMaterialSGIX -------------------------------------------------

glFragmentColorMaterialSGIX
  :: MonadIO m
  => GLenum -- ^ @face@ of type [MaterialFace](Graphics-GL-Groups.html#MaterialFace).
  -> GLenum -- ^ @mode@ of type [MaterialParameter](Graphics-GL-Groups.html#MaterialParameter).
  -> m ()
glFragmentColorMaterialSGIX v1 v2 = liftIO $ dyn51 ptr_glFragmentColorMaterialSGIX v1 v2

{-# NOINLINE ptr_glFragmentColorMaterialSGIX #-}
ptr_glFragmentColorMaterialSGIX :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glFragmentColorMaterialSGIX = unsafePerformIO $ getCommand "glFragmentColorMaterialSGIX"

-- glFragmentCoverageColorNV ---------------------------------------------------

glFragmentCoverageColorNV
  :: MonadIO m
  => GLuint -- ^ @color@.
  -> m ()
glFragmentCoverageColorNV v1 = liftIO $ dyn2 ptr_glFragmentCoverageColorNV v1

{-# NOINLINE ptr_glFragmentCoverageColorNV #-}
ptr_glFragmentCoverageColorNV :: FunPtr (GLuint -> IO ())
ptr_glFragmentCoverageColorNV = unsafePerformIO $ getCommand "glFragmentCoverageColorNV"

-- glFragmentLightModelfSGIX ---------------------------------------------------

glFragmentLightModelfSGIX
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [FragmentLightModelParameterSGIX](Graphics-GL-Groups.html#FragmentLightModelParameterSGIX).
  -> GLfloat -- ^ @param@ of type @CheckedFloat32@.
  -> m ()
glFragmentLightModelfSGIX v1 v2 = liftIO $ dyn0 ptr_glFragmentLightModelfSGIX v1 v2

{-# NOINLINE ptr_glFragmentLightModelfSGIX #-}
ptr_glFragmentLightModelfSGIX :: FunPtr (GLenum -> GLfloat -> IO ())
ptr_glFragmentLightModelfSGIX = unsafePerformIO $ getCommand "glFragmentLightModelfSGIX"

-- glFragmentLightModelfvSGIX --------------------------------------------------

glFragmentLightModelfvSGIX
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [FragmentLightModelParameterSGIX](Graphics-GL-Groups.html#FragmentLightModelParameterSGIX).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glFragmentLightModelfvSGIX v1 v2 = liftIO $ dyn94 ptr_glFragmentLightModelfvSGIX v1 v2

{-# NOINLINE ptr_glFragmentLightModelfvSGIX #-}
ptr_glFragmentLightModelfvSGIX :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glFragmentLightModelfvSGIX = unsafePerformIO $ getCommand "glFragmentLightModelfvSGIX"

-- glFragmentLightModeliSGIX ---------------------------------------------------

glFragmentLightModeliSGIX
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [FragmentLightModelParameterSGIX](Graphics-GL-Groups.html#FragmentLightModelParameterSGIX).
  -> GLint -- ^ @param@ of type @CheckedInt32@.
  -> m ()
glFragmentLightModeliSGIX v1 v2 = liftIO $ dyn55 ptr_glFragmentLightModeliSGIX v1 v2

{-# NOINLINE ptr_glFragmentLightModeliSGIX #-}
ptr_glFragmentLightModeliSGIX :: FunPtr (GLenum -> GLint -> IO ())
ptr_glFragmentLightModeliSGIX = unsafePerformIO $ getCommand "glFragmentLightModeliSGIX"

-- glFragmentLightModelivSGIX --------------------------------------------------

glFragmentLightModelivSGIX
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [FragmentLightModelParameterSGIX](Graphics-GL-Groups.html#FragmentLightModelParameterSGIX).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glFragmentLightModelivSGIX v1 v2 = liftIO $ dyn136 ptr_glFragmentLightModelivSGIX v1 v2

{-# NOINLINE ptr_glFragmentLightModelivSGIX #-}
ptr_glFragmentLightModelivSGIX :: FunPtr (GLenum -> Ptr GLint -> IO ())
ptr_glFragmentLightModelivSGIX = unsafePerformIO $ getCommand "glFragmentLightModelivSGIX"

-- glFragmentLightfSGIX --------------------------------------------------------

glFragmentLightfSGIX
  :: MonadIO m
  => GLenum -- ^ @light@ of type @FragmentLightNameSGIX@.
  -> GLenum -- ^ @pname@ of type @FragmentLightParameterSGIX@.
  -> GLfloat -- ^ @param@ of type @CheckedFloat32@.
  -> m ()
glFragmentLightfSGIX v1 v2 v3 = liftIO $ dyn161 ptr_glFragmentLightfSGIX v1 v2 v3

{-# NOINLINE ptr_glFragmentLightfSGIX #-}
ptr_glFragmentLightfSGIX :: FunPtr (GLenum -> GLenum -> GLfloat -> IO ())
ptr_glFragmentLightfSGIX = unsafePerformIO $ getCommand "glFragmentLightfSGIX"

-- glFragmentLightfvSGIX -------------------------------------------------------

glFragmentLightfvSGIX
  :: MonadIO m
  => GLenum -- ^ @light@ of type @FragmentLightNameSGIX@.
  -> GLenum -- ^ @pname@ of type @FragmentLightParameterSGIX@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glFragmentLightfvSGIX v1 v2 v3 = liftIO $ dyn132 ptr_glFragmentLightfvSGIX v1 v2 v3

{-# NOINLINE ptr_glFragmentLightfvSGIX #-}
ptr_glFragmentLightfvSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glFragmentLightfvSGIX = unsafePerformIO $ getCommand "glFragmentLightfvSGIX"

-- glFragmentLightiSGIX --------------------------------------------------------

glFragmentLightiSGIX
  :: MonadIO m
  => GLenum -- ^ @light@ of type @FragmentLightNameSGIX@.
  -> GLenum -- ^ @pname@ of type @FragmentLightParameterSGIX@.
  -> GLint -- ^ @param@ of type @CheckedInt32@.
  -> m ()
glFragmentLightiSGIX v1 v2 v3 = liftIO $ dyn62 ptr_glFragmentLightiSGIX v1 v2 v3

{-# NOINLINE ptr_glFragmentLightiSGIX #-}
ptr_glFragmentLightiSGIX :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glFragmentLightiSGIX = unsafePerformIO $ getCommand "glFragmentLightiSGIX"

-- glFragmentLightivSGIX -------------------------------------------------------

glFragmentLightivSGIX
  :: MonadIO m
  => GLenum -- ^ @light@ of type @FragmentLightNameSGIX@.
  -> GLenum -- ^ @pname@ of type @FragmentLightParameterSGIX@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glFragmentLightivSGIX v1 v2 v3 = liftIO $ dyn133 ptr_glFragmentLightivSGIX v1 v2 v3

{-# NOINLINE ptr_glFragmentLightivSGIX #-}
ptr_glFragmentLightivSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glFragmentLightivSGIX = unsafePerformIO $ getCommand "glFragmentLightivSGIX"

-- glFragmentMaterialfSGIX -----------------------------------------------------

glFragmentMaterialfSGIX
  :: MonadIO m
  => GLenum -- ^ @face@ of type [MaterialFace](Graphics-GL-Groups.html#MaterialFace).
  -> GLenum -- ^ @pname@ of type [MaterialParameter](Graphics-GL-Groups.html#MaterialParameter).
  -> GLfloat -- ^ @param@ of type @CheckedFloat32@.
  -> m ()
glFragmentMaterialfSGIX v1 v2 v3 = liftIO $ dyn161 ptr_glFragmentMaterialfSGIX v1 v2 v3

{-# NOINLINE ptr_glFragmentMaterialfSGIX #-}
ptr_glFragmentMaterialfSGIX :: FunPtr (GLenum -> GLenum -> GLfloat -> IO ())
ptr_glFragmentMaterialfSGIX = unsafePerformIO $ getCommand "glFragmentMaterialfSGIX"

-- glFragmentMaterialfvSGIX ----------------------------------------------------

glFragmentMaterialfvSGIX
  :: MonadIO m
  => GLenum -- ^ @face@ of type [MaterialFace](Graphics-GL-Groups.html#MaterialFace).
  -> GLenum -- ^ @pname@ of type [MaterialParameter](Graphics-GL-Groups.html#MaterialParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glFragmentMaterialfvSGIX v1 v2 v3 = liftIO $ dyn132 ptr_glFragmentMaterialfvSGIX v1 v2 v3

{-# NOINLINE ptr_glFragmentMaterialfvSGIX #-}
ptr_glFragmentMaterialfvSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glFragmentMaterialfvSGIX = unsafePerformIO $ getCommand "glFragmentMaterialfvSGIX"

-- glFragmentMaterialiSGIX -----------------------------------------------------

glFragmentMaterialiSGIX
  :: MonadIO m
  => GLenum -- ^ @face@ of type [MaterialFace](Graphics-GL-Groups.html#MaterialFace).
  -> GLenum -- ^ @pname@ of type [MaterialParameter](Graphics-GL-Groups.html#MaterialParameter).
  -> GLint -- ^ @param@ of type @CheckedInt32@.
  -> m ()
glFragmentMaterialiSGIX v1 v2 v3 = liftIO $ dyn62 ptr_glFragmentMaterialiSGIX v1 v2 v3

{-# NOINLINE ptr_glFragmentMaterialiSGIX #-}
ptr_glFragmentMaterialiSGIX :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glFragmentMaterialiSGIX = unsafePerformIO $ getCommand "glFragmentMaterialiSGIX"

-- glFragmentMaterialivSGIX ----------------------------------------------------

glFragmentMaterialivSGIX
  :: MonadIO m
  => GLenum -- ^ @face@ of type [MaterialFace](Graphics-GL-Groups.html#MaterialFace).
  -> GLenum -- ^ @pname@ of type [MaterialParameter](Graphics-GL-Groups.html#MaterialParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glFragmentMaterialivSGIX v1 v2 v3 = liftIO $ dyn133 ptr_glFragmentMaterialivSGIX v1 v2 v3

{-# NOINLINE ptr_glFragmentMaterialivSGIX #-}
ptr_glFragmentMaterialivSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glFragmentMaterialivSGIX = unsafePerformIO $ getCommand "glFragmentMaterialivSGIX"

-- glFrameTerminatorGREMEDY ----------------------------------------------------

glFrameTerminatorGREMEDY
  :: MonadIO m
  => m ()
glFrameTerminatorGREMEDY = liftIO $ dyn10 ptr_glFrameTerminatorGREMEDY

{-# NOINLINE ptr_glFrameTerminatorGREMEDY #-}
ptr_glFrameTerminatorGREMEDY :: FunPtr (IO ())
ptr_glFrameTerminatorGREMEDY = unsafePerformIO $ getCommand "glFrameTerminatorGREMEDY"

-- glFrameZoomSGIX -------------------------------------------------------------

glFrameZoomSGIX
  :: MonadIO m
  => GLint -- ^ @factor@ of type @CheckedInt32@.
  -> m ()
glFrameZoomSGIX v1 = liftIO $ dyn12 ptr_glFrameZoomSGIX v1

{-# NOINLINE ptr_glFrameZoomSGIX #-}
ptr_glFrameZoomSGIX :: FunPtr (GLint -> IO ())
ptr_glFrameZoomSGIX = unsafePerformIO $ getCommand "glFrameZoomSGIX"

-- glFramebufferDrawBufferEXT --------------------------------------------------

glFramebufferDrawBufferEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@ of type @Framebuffer@.
  -> GLenum -- ^ @mode@ of type [DrawBufferMode](Graphics-GL-Groups.html#DrawBufferMode).
  -> m ()
glFramebufferDrawBufferEXT v1 v2 = liftIO $ dyn15 ptr_glFramebufferDrawBufferEXT v1 v2

{-# NOINLINE ptr_glFramebufferDrawBufferEXT #-}
ptr_glFramebufferDrawBufferEXT :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glFramebufferDrawBufferEXT = unsafePerformIO $ getCommand "glFramebufferDrawBufferEXT"

-- glFramebufferDrawBuffersEXT -------------------------------------------------

glFramebufferDrawBuffersEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@ of type @Framebuffer@.
  -> GLsizei -- ^ @n@.
  -> Ptr GLenum -- ^ @bufs@ pointing to @n@ elements of type [DrawBufferMode](Graphics-GL-Groups.html#DrawBufferMode).
  -> m ()
glFramebufferDrawBuffersEXT v1 v2 v3 = liftIO $ dyn282 ptr_glFramebufferDrawBuffersEXT v1 v2 v3

{-# NOINLINE ptr_glFramebufferDrawBuffersEXT #-}
ptr_glFramebufferDrawBuffersEXT :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> IO ())
ptr_glFramebufferDrawBuffersEXT = unsafePerformIO $ getCommand "glFramebufferDrawBuffersEXT"

-- glFramebufferParameteri -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glFramebufferParameteri.xhtml OpenGL 4.x>.
glFramebufferParameteri
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> GLint -- ^ @param@.
  -> m ()
glFramebufferParameteri v1 v2 v3 = liftIO $ dyn62 ptr_glFramebufferParameteri v1 v2 v3

{-# NOINLINE ptr_glFramebufferParameteri #-}
ptr_glFramebufferParameteri :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glFramebufferParameteri = unsafePerformIO $ getCommand "glFramebufferParameteri"

-- glFramebufferPixelLocalStorageSizeEXT ---------------------------------------

glFramebufferPixelLocalStorageSizeEXT
  :: MonadIO m
  => GLuint -- ^ @target@.
  -> GLsizei -- ^ @size@.
  -> m ()
glFramebufferPixelLocalStorageSizeEXT v1 v2 = liftIO $ dyn212 ptr_glFramebufferPixelLocalStorageSizeEXT v1 v2

{-# NOINLINE ptr_glFramebufferPixelLocalStorageSizeEXT #-}
ptr_glFramebufferPixelLocalStorageSizeEXT :: FunPtr (GLuint -> GLsizei -> IO ())
ptr_glFramebufferPixelLocalStorageSizeEXT = unsafePerformIO $ getCommand "glFramebufferPixelLocalStorageSizeEXT"

-- glFramebufferReadBufferEXT --------------------------------------------------

glFramebufferReadBufferEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@ of type @Framebuffer@.
  -> GLenum -- ^ @mode@ of type [ReadBufferMode](Graphics-GL-Groups.html#ReadBufferMode).
  -> m ()
glFramebufferReadBufferEXT v1 v2 = liftIO $ dyn15 ptr_glFramebufferReadBufferEXT v1 v2

{-# NOINLINE ptr_glFramebufferReadBufferEXT #-}
ptr_glFramebufferReadBufferEXT :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glFramebufferReadBufferEXT = unsafePerformIO $ getCommand "glFramebufferReadBufferEXT"

-- glFramebufferRenderbuffer ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferRenderbuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFramebufferRenderbuffer.xhtml OpenGL 4.x>.
glFramebufferRenderbuffer
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @renderbuffertarget@ of type @RenderbufferTarget@.
  -> GLuint -- ^ @renderbuffer@.
  -> m ()
glFramebufferRenderbuffer v1 v2 v3 v4 = liftIO $ dyn283 ptr_glFramebufferRenderbuffer v1 v2 v3 v4

{-# NOINLINE ptr_glFramebufferRenderbuffer #-}
ptr_glFramebufferRenderbuffer :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> IO ())
ptr_glFramebufferRenderbuffer = unsafePerformIO $ getCommand "glFramebufferRenderbuffer"

-- glFramebufferRenderbufferEXT ------------------------------------------------

-- | This command is an alias for 'glFramebufferRenderbuffer'.
glFramebufferRenderbufferEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @renderbuffertarget@ of type @RenderbufferTarget@.
  -> GLuint -- ^ @renderbuffer@.
  -> m ()
glFramebufferRenderbufferEXT v1 v2 v3 v4 = liftIO $ dyn283 ptr_glFramebufferRenderbufferEXT v1 v2 v3 v4

{-# NOINLINE ptr_glFramebufferRenderbufferEXT #-}
ptr_glFramebufferRenderbufferEXT :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> IO ())
ptr_glFramebufferRenderbufferEXT = unsafePerformIO $ getCommand "glFramebufferRenderbufferEXT"

-- glFramebufferRenderbufferOES ------------------------------------------------

glFramebufferRenderbufferOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @renderbuffertarget@.
  -> GLuint -- ^ @renderbuffer@.
  -> m ()
glFramebufferRenderbufferOES v1 v2 v3 v4 = liftIO $ dyn283 ptr_glFramebufferRenderbufferOES v1 v2 v3 v4

{-# NOINLINE ptr_glFramebufferRenderbufferOES #-}
ptr_glFramebufferRenderbufferOES :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> IO ())
ptr_glFramebufferRenderbufferOES = unsafePerformIO $ getCommand "glFramebufferRenderbufferOES"

-- glFramebufferSampleLocationsfvARB -------------------------------------------

glFramebufferSampleLocationsfvARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @start@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLfloat -- ^ @v@.
  -> m ()
glFramebufferSampleLocationsfvARB v1 v2 v3 v4 = liftIO $ dyn284 ptr_glFramebufferSampleLocationsfvARB v1 v2 v3 v4

{-# NOINLINE ptr_glFramebufferSampleLocationsfvARB #-}
ptr_glFramebufferSampleLocationsfvARB :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glFramebufferSampleLocationsfvARB = unsafePerformIO $ getCommand "glFramebufferSampleLocationsfvARB"

-- glFramebufferSampleLocationsfvNV --------------------------------------------

glFramebufferSampleLocationsfvNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @start@.
  -> GLsizei -- ^ @count@.
  -> Ptr GLfloat -- ^ @v@.
  -> m ()
glFramebufferSampleLocationsfvNV v1 v2 v3 v4 = liftIO $ dyn284 ptr_glFramebufferSampleLocationsfvNV v1 v2 v3 v4

{-# NOINLINE ptr_glFramebufferSampleLocationsfvNV #-}
ptr_glFramebufferSampleLocationsfvNV :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glFramebufferSampleLocationsfvNV = unsafePerformIO $ getCommand "glFramebufferSampleLocationsfvNV"

-- glFramebufferTexture --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTexture.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFramebufferTexture.xhtml OpenGL 4.x>.
glFramebufferTexture
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> m ()
glFramebufferTexture v1 v2 v3 v4 = liftIO $ dyn285 ptr_glFramebufferTexture v1 v2 v3 v4

{-# NOINLINE ptr_glFramebufferTexture #-}
ptr_glFramebufferTexture :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTexture = unsafePerformIO $ getCommand "glFramebufferTexture"

-- glFramebufferTexture1D ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTexture.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFramebufferTexture.xhtml OpenGL 4.x>.
glFramebufferTexture1D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> m ()
glFramebufferTexture1D v1 v2 v3 v4 v5 = liftIO $ dyn286 ptr_glFramebufferTexture1D v1 v2 v3 v4 v5

{-# NOINLINE ptr_glFramebufferTexture1D #-}
ptr_glFramebufferTexture1D :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTexture1D = unsafePerformIO $ getCommand "glFramebufferTexture1D"

-- glFramebufferTexture1DEXT ---------------------------------------------------

-- | This command is an alias for 'glFramebufferTexture1D'.
glFramebufferTexture1DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> m ()
glFramebufferTexture1DEXT v1 v2 v3 v4 v5 = liftIO $ dyn286 ptr_glFramebufferTexture1DEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glFramebufferTexture1DEXT #-}
ptr_glFramebufferTexture1DEXT :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTexture1DEXT = unsafePerformIO $ getCommand "glFramebufferTexture1DEXT"

-- glFramebufferTexture2D ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTexture.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFramebufferTexture.xhtml OpenGL 4.x>.
glFramebufferTexture2D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> m ()
glFramebufferTexture2D v1 v2 v3 v4 v5 = liftIO $ dyn286 ptr_glFramebufferTexture2D v1 v2 v3 v4 v5

{-# NOINLINE ptr_glFramebufferTexture2D #-}
ptr_glFramebufferTexture2D :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTexture2D = unsafePerformIO $ getCommand "glFramebufferTexture2D"

-- glFramebufferTexture2DDownsampleIMG -----------------------------------------

glFramebufferTexture2DDownsampleIMG
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xscale@.
  -> GLint -- ^ @yscale@.
  -> m ()
glFramebufferTexture2DDownsampleIMG v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn287 ptr_glFramebufferTexture2DDownsampleIMG v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glFramebufferTexture2DDownsampleIMG #-}
ptr_glFramebufferTexture2DDownsampleIMG :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLint -> GLint -> IO ())
ptr_glFramebufferTexture2DDownsampleIMG = unsafePerformIO $ getCommand "glFramebufferTexture2DDownsampleIMG"

-- glFramebufferTexture2DEXT ---------------------------------------------------

-- | This command is an alias for 'glFramebufferTexture2D'.
glFramebufferTexture2DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> m ()
glFramebufferTexture2DEXT v1 v2 v3 v4 v5 = liftIO $ dyn286 ptr_glFramebufferTexture2DEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glFramebufferTexture2DEXT #-}
ptr_glFramebufferTexture2DEXT :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTexture2DEXT = unsafePerformIO $ getCommand "glFramebufferTexture2DEXT"

-- glFramebufferTexture2DMultisampleEXT ----------------------------------------

glFramebufferTexture2DMultisampleEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLsizei -- ^ @samples@.
  -> m ()
glFramebufferTexture2DMultisampleEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn288 ptr_glFramebufferTexture2DMultisampleEXT v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glFramebufferTexture2DMultisampleEXT #-}
ptr_glFramebufferTexture2DMultisampleEXT :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLsizei -> IO ())
ptr_glFramebufferTexture2DMultisampleEXT = unsafePerformIO $ getCommand "glFramebufferTexture2DMultisampleEXT"

-- glFramebufferTexture2DMultisampleIMG ----------------------------------------

glFramebufferTexture2DMultisampleIMG
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLsizei -- ^ @samples@.
  -> m ()
glFramebufferTexture2DMultisampleIMG v1 v2 v3 v4 v5 v6 = liftIO $ dyn288 ptr_glFramebufferTexture2DMultisampleIMG v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glFramebufferTexture2DMultisampleIMG #-}
ptr_glFramebufferTexture2DMultisampleIMG :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLsizei -> IO ())
ptr_glFramebufferTexture2DMultisampleIMG = unsafePerformIO $ getCommand "glFramebufferTexture2DMultisampleIMG"

-- glFramebufferTexture2DOES ---------------------------------------------------

glFramebufferTexture2DOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> m ()
glFramebufferTexture2DOES v1 v2 v3 v4 v5 = liftIO $ dyn286 ptr_glFramebufferTexture2DOES v1 v2 v3 v4 v5

{-# NOINLINE ptr_glFramebufferTexture2DOES #-}
ptr_glFramebufferTexture2DOES :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTexture2DOES = unsafePerformIO $ getCommand "glFramebufferTexture2DOES"

-- glFramebufferTexture3D ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTexture.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFramebufferTexture.xhtml OpenGL 4.x>.
glFramebufferTexture3D
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @zoffset@.
  -> m ()
glFramebufferTexture3D v1 v2 v3 v4 v5 v6 = liftIO $ dyn289 ptr_glFramebufferTexture3D v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glFramebufferTexture3D #-}
ptr_glFramebufferTexture3D :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
ptr_glFramebufferTexture3D = unsafePerformIO $ getCommand "glFramebufferTexture3D"

-- glFramebufferTexture3DEXT ---------------------------------------------------

-- | This command is an alias for 'glFramebufferTexture3D'.
glFramebufferTexture3DEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @zoffset@.
  -> m ()
glFramebufferTexture3DEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn289 ptr_glFramebufferTexture3DEXT v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glFramebufferTexture3DEXT #-}
ptr_glFramebufferTexture3DEXT :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
ptr_glFramebufferTexture3DEXT = unsafePerformIO $ getCommand "glFramebufferTexture3DEXT"

-- glFramebufferTexture3DOES ---------------------------------------------------

-- | This command is an alias for 'glFramebufferTexture3D'.
glFramebufferTexture3DOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @textarget@.
  -> GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @zoffset@.
  -> m ()
glFramebufferTexture3DOES v1 v2 v3 v4 v5 v6 = liftIO $ dyn289 ptr_glFramebufferTexture3DOES v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glFramebufferTexture3DOES #-}
ptr_glFramebufferTexture3DOES :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
ptr_glFramebufferTexture3DOES = unsafePerformIO $ getCommand "glFramebufferTexture3DOES"

-- glFramebufferTextureARB -----------------------------------------------------

-- | This command is an alias for 'glFramebufferTexture'.
glFramebufferTextureARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> m ()
glFramebufferTextureARB v1 v2 v3 v4 = liftIO $ dyn285 ptr_glFramebufferTextureARB v1 v2 v3 v4

{-# NOINLINE ptr_glFramebufferTextureARB #-}
ptr_glFramebufferTextureARB :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTextureARB = unsafePerformIO $ getCommand "glFramebufferTextureARB"

-- glFramebufferTextureEXT -----------------------------------------------------

-- | This command is an alias for 'glFramebufferTexture'.
glFramebufferTextureEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> m ()
glFramebufferTextureEXT v1 v2 v3 v4 = liftIO $ dyn285 ptr_glFramebufferTextureEXT v1 v2 v3 v4

{-# NOINLINE ptr_glFramebufferTextureEXT #-}
ptr_glFramebufferTextureEXT :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTextureEXT = unsafePerformIO $ getCommand "glFramebufferTextureEXT"

-- glFramebufferTextureFaceARB -------------------------------------------------

glFramebufferTextureFaceARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @face@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> m ()
glFramebufferTextureFaceARB v1 v2 v3 v4 v5 = liftIO $ dyn290 ptr_glFramebufferTextureFaceARB v1 v2 v3 v4 v5

{-# NOINLINE ptr_glFramebufferTextureFaceARB #-}
ptr_glFramebufferTextureFaceARB :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLenum -> IO ())
ptr_glFramebufferTextureFaceARB = unsafePerformIO $ getCommand "glFramebufferTextureFaceARB"

-- glFramebufferTextureFaceEXT -------------------------------------------------

-- | This command is an alias for 'glFramebufferTextureFaceARB'.
glFramebufferTextureFaceEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @face@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> m ()
glFramebufferTextureFaceEXT v1 v2 v3 v4 v5 = liftIO $ dyn290 ptr_glFramebufferTextureFaceEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glFramebufferTextureFaceEXT #-}
ptr_glFramebufferTextureFaceEXT :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLenum -> IO ())
ptr_glFramebufferTextureFaceEXT = unsafePerformIO $ getCommand "glFramebufferTextureFaceEXT"

-- glFramebufferTextureLayer ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glFramebufferTextureLayer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFramebufferTextureLayer.xhtml OpenGL 4.x>.
glFramebufferTextureLayer
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @layer@ of type @CheckedInt32@.
  -> m ()
glFramebufferTextureLayer v1 v2 v3 v4 v5 = liftIO $ dyn291 ptr_glFramebufferTextureLayer v1 v2 v3 v4 v5

{-# NOINLINE ptr_glFramebufferTextureLayer #-}
ptr_glFramebufferTextureLayer :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
ptr_glFramebufferTextureLayer = unsafePerformIO $ getCommand "glFramebufferTextureLayer"

-- glFramebufferTextureLayerARB ------------------------------------------------

-- | This command is an alias for 'glFramebufferTextureLayer'.
glFramebufferTextureLayerARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @layer@ of type @CheckedInt32@.
  -> m ()
glFramebufferTextureLayerARB v1 v2 v3 v4 v5 = liftIO $ dyn291 ptr_glFramebufferTextureLayerARB v1 v2 v3 v4 v5

{-# NOINLINE ptr_glFramebufferTextureLayerARB #-}
ptr_glFramebufferTextureLayerARB :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
ptr_glFramebufferTextureLayerARB = unsafePerformIO $ getCommand "glFramebufferTextureLayerARB"

-- glFramebufferTextureLayerDownsampleIMG --------------------------------------

glFramebufferTextureLayerDownsampleIMG
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @layer@ of type @CheckedInt32@.
  -> GLint -- ^ @xscale@.
  -> GLint -- ^ @yscale@.
  -> m ()
glFramebufferTextureLayerDownsampleIMG v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn292 ptr_glFramebufferTextureLayerDownsampleIMG v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glFramebufferTextureLayerDownsampleIMG #-}
ptr_glFramebufferTextureLayerDownsampleIMG :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLint -> GLint -> GLint -> IO ())
ptr_glFramebufferTextureLayerDownsampleIMG = unsafePerformIO $ getCommand "glFramebufferTextureLayerDownsampleIMG"

-- glFramebufferTextureLayerEXT ------------------------------------------------

-- | This command is an alias for 'glFramebufferTextureLayer'.
glFramebufferTextureLayerEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @layer@ of type @CheckedInt32@.
  -> m ()
glFramebufferTextureLayerEXT v1 v2 v3 v4 v5 = liftIO $ dyn291 ptr_glFramebufferTextureLayerEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glFramebufferTextureLayerEXT #-}
ptr_glFramebufferTextureLayerEXT :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLint -> IO ())
ptr_glFramebufferTextureLayerEXT = unsafePerformIO $ getCommand "glFramebufferTextureLayerEXT"

-- glFramebufferTextureMultisampleMultiviewOVR ---------------------------------

glFramebufferTextureMultisampleMultiviewOVR
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLsizei -- ^ @samples@.
  -> GLint -- ^ @baseViewIndex@.
  -> GLsizei -- ^ @numViews@.
  -> m ()
glFramebufferTextureMultisampleMultiviewOVR v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn293 ptr_glFramebufferTextureMultisampleMultiviewOVR v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glFramebufferTextureMultisampleMultiviewOVR #-}
ptr_glFramebufferTextureMultisampleMultiviewOVR :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLsizei -> GLint -> GLsizei -> IO ())
ptr_glFramebufferTextureMultisampleMultiviewOVR = unsafePerformIO $ getCommand "glFramebufferTextureMultisampleMultiviewOVR"

-- glFramebufferTextureMultiviewOVR --------------------------------------------

glFramebufferTextureMultiviewOVR
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLint -- ^ @baseViewIndex@.
  -> GLsizei -- ^ @numViews@.
  -> m ()
glFramebufferTextureMultiviewOVR v1 v2 v3 v4 v5 v6 = liftIO $ dyn294 ptr_glFramebufferTextureMultiviewOVR v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glFramebufferTextureMultiviewOVR #-}
ptr_glFramebufferTextureMultiviewOVR :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> GLint -> GLsizei -> IO ())
ptr_glFramebufferTextureMultiviewOVR = unsafePerformIO $ getCommand "glFramebufferTextureMultiviewOVR"

-- glFramebufferTextureOES -----------------------------------------------------

-- | This command is an alias for 'glFramebufferTexture'.
glFramebufferTextureOES
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLuint -- ^ @texture@ of type @Texture@.
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> m ()
glFramebufferTextureOES v1 v2 v3 v4 = liftIO $ dyn285 ptr_glFramebufferTextureOES v1 v2 v3 v4

{-# NOINLINE ptr_glFramebufferTextureOES #-}
ptr_glFramebufferTextureOES :: FunPtr (GLenum -> GLenum -> GLuint -> GLint -> IO ())
ptr_glFramebufferTextureOES = unsafePerformIO $ getCommand "glFramebufferTextureOES"

-- glFreeObjectBufferATI -------------------------------------------------------

glFreeObjectBufferATI
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> m ()
glFreeObjectBufferATI v1 = liftIO $ dyn2 ptr_glFreeObjectBufferATI v1

{-# NOINLINE ptr_glFreeObjectBufferATI #-}
ptr_glFreeObjectBufferATI :: FunPtr (GLuint -> IO ())
ptr_glFreeObjectBufferATI = unsafePerformIO $ getCommand "glFreeObjectBufferATI"

-- glFrontFace -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glFrontFace.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glFrontFace.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glFrontFace.xhtml OpenGL 4.x>.
glFrontFace
  :: MonadIO m
  => GLenum -- ^ @mode@ of type [FrontFaceDirection](Graphics-GL-Groups.html#FrontFaceDirection).
  -> m ()
glFrontFace v1 = liftIO $ dyn4 ptr_glFrontFace v1

{-# NOINLINE ptr_glFrontFace #-}
ptr_glFrontFace :: FunPtr (GLenum -> IO ())
ptr_glFrontFace = unsafePerformIO $ getCommand "glFrontFace"

-- glFrustum -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glFrustum.xml OpenGL 2.x>.
glFrustum
  :: MonadIO m
  => GLdouble -- ^ @left@.
  -> GLdouble -- ^ @right@.
  -> GLdouble -- ^ @bottom@.
  -> GLdouble -- ^ @top@.
  -> GLdouble -- ^ @zNear@.
  -> GLdouble -- ^ @zFar@.
  -> m ()
glFrustum v1 v2 v3 v4 v5 v6 = liftIO $ dyn295 ptr_glFrustum v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glFrustum #-}
ptr_glFrustum :: FunPtr (GLdouble -> GLdouble -> GLdouble -> GLdouble -> GLdouble -> GLdouble -> IO ())
ptr_glFrustum = unsafePerformIO $ getCommand "glFrustum"

-- glFrustumf ------------------------------------------------------------------

glFrustumf
  :: MonadIO m
  => GLfloat -- ^ @l@.
  -> GLfloat -- ^ @r@.
  -> GLfloat -- ^ @b@.
  -> GLfloat -- ^ @t@.
  -> GLfloat -- ^ @n@.
  -> GLfloat -- ^ @f@.
  -> m ()
glFrustumf v1 v2 v3 v4 v5 v6 = liftIO $ dyn96 ptr_glFrustumf v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glFrustumf #-}
ptr_glFrustumf :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glFrustumf = unsafePerformIO $ getCommand "glFrustumf"

-- glFrustumfOES ---------------------------------------------------------------

glFrustumfOES
  :: MonadIO m
  => GLfloat -- ^ @l@.
  -> GLfloat -- ^ @r@.
  -> GLfloat -- ^ @b@.
  -> GLfloat -- ^ @t@.
  -> GLfloat -- ^ @n@.
  -> GLfloat -- ^ @f@.
  -> m ()
glFrustumfOES v1 v2 v3 v4 v5 v6 = liftIO $ dyn96 ptr_glFrustumfOES v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glFrustumfOES #-}
ptr_glFrustumfOES :: FunPtr (GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> GLfloat -> IO ())
ptr_glFrustumfOES = unsafePerformIO $ getCommand "glFrustumfOES"

-- glFrustumx ------------------------------------------------------------------

glFrustumx
  :: MonadIO m
  => GLfixed -- ^ @l@.
  -> GLfixed -- ^ @r@.
  -> GLfixed -- ^ @b@.
  -> GLfixed -- ^ @t@.
  -> GLfixed -- ^ @n@.
  -> GLfixed -- ^ @f@.
  -> m ()
glFrustumx v1 v2 v3 v4 v5 v6 = liftIO $ dyn296 ptr_glFrustumx v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glFrustumx #-}
ptr_glFrustumx :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glFrustumx = unsafePerformIO $ getCommand "glFrustumx"

-- glFrustumxOES ---------------------------------------------------------------

glFrustumxOES
  :: MonadIO m
  => GLfixed -- ^ @l@.
  -> GLfixed -- ^ @r@.
  -> GLfixed -- ^ @b@.
  -> GLfixed -- ^ @t@.
  -> GLfixed -- ^ @n@.
  -> GLfixed -- ^ @f@.
  -> m ()
glFrustumxOES v1 v2 v3 v4 v5 v6 = liftIO $ dyn296 ptr_glFrustumxOES v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glFrustumxOES #-}
ptr_glFrustumxOES :: FunPtr (GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> GLfixed -> IO ())
ptr_glFrustumxOES = unsafePerformIO $ getCommand "glFrustumxOES"

-- glGenAsyncMarkersSGIX -------------------------------------------------------

glGenAsyncMarkersSGIX
  :: MonadIO m
  => GLsizei -- ^ @range@.
  -> m GLuint
glGenAsyncMarkersSGIX v1 = liftIO $ dyn297 ptr_glGenAsyncMarkersSGIX v1

{-# NOINLINE ptr_glGenAsyncMarkersSGIX #-}
ptr_glGenAsyncMarkersSGIX :: FunPtr (GLsizei -> IO GLuint)
ptr_glGenAsyncMarkersSGIX = unsafePerformIO $ getCommand "glGenAsyncMarkersSGIX"

-- glGenBuffers ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGenBuffers.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGenBuffers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenBuffers.xhtml OpenGL 4.x>.
glGenBuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @buffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenBuffers v1 v2 = liftIO $ dyn193 ptr_glGenBuffers v1 v2

{-# NOINLINE ptr_glGenBuffers #-}
ptr_glGenBuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenBuffers = unsafePerformIO $ getCommand "glGenBuffers"

-- glGenBuffersARB -------------------------------------------------------------

-- | This command is an alias for 'glGenBuffers'.
glGenBuffersARB
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @buffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenBuffersARB v1 v2 = liftIO $ dyn193 ptr_glGenBuffersARB v1 v2

{-# NOINLINE ptr_glGenBuffersARB #-}
ptr_glGenBuffersARB :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenBuffersARB = unsafePerformIO $ getCommand "glGenBuffersARB"

-- glGenFencesAPPLE ------------------------------------------------------------

glGenFencesAPPLE
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @fences@ pointing to @n@ elements of type @FenceNV@.
  -> m ()
glGenFencesAPPLE v1 v2 = liftIO $ dyn193 ptr_glGenFencesAPPLE v1 v2

{-# NOINLINE ptr_glGenFencesAPPLE #-}
ptr_glGenFencesAPPLE :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenFencesAPPLE = unsafePerformIO $ getCommand "glGenFencesAPPLE"

-- glGenFencesNV ---------------------------------------------------------------

glGenFencesNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @fences@ pointing to @n@ elements of type @FenceNV@.
  -> m ()
glGenFencesNV v1 v2 = liftIO $ dyn193 ptr_glGenFencesNV v1 v2

{-# NOINLINE ptr_glGenFencesNV #-}
ptr_glGenFencesNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenFencesNV = unsafePerformIO $ getCommand "glGenFencesNV"

-- glGenFragmentShadersATI -----------------------------------------------------

glGenFragmentShadersATI
  :: MonadIO m
  => GLuint -- ^ @range@.
  -> m GLuint
glGenFragmentShadersATI v1 = liftIO $ dyn298 ptr_glGenFragmentShadersATI v1

{-# NOINLINE ptr_glGenFragmentShadersATI #-}
ptr_glGenFragmentShadersATI :: FunPtr (GLuint -> IO GLuint)
ptr_glGenFragmentShadersATI = unsafePerformIO $ getCommand "glGenFragmentShadersATI"

-- glGenFramebuffers -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGenFramebuffers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenFramebuffers.xhtml OpenGL 4.x>.
glGenFramebuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @framebuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenFramebuffers v1 v2 = liftIO $ dyn193 ptr_glGenFramebuffers v1 v2

{-# NOINLINE ptr_glGenFramebuffers #-}
ptr_glGenFramebuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenFramebuffers = unsafePerformIO $ getCommand "glGenFramebuffers"

-- glGenFramebuffersEXT --------------------------------------------------------

-- | This command is an alias for 'glGenFramebuffers'.
glGenFramebuffersEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @framebuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenFramebuffersEXT v1 v2 = liftIO $ dyn193 ptr_glGenFramebuffersEXT v1 v2

{-# NOINLINE ptr_glGenFramebuffersEXT #-}
ptr_glGenFramebuffersEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenFramebuffersEXT = unsafePerformIO $ getCommand "glGenFramebuffersEXT"

-- glGenFramebuffersOES --------------------------------------------------------

glGenFramebuffersOES
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @framebuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenFramebuffersOES v1 v2 = liftIO $ dyn193 ptr_glGenFramebuffersOES v1 v2

{-# NOINLINE ptr_glGenFramebuffersOES #-}
ptr_glGenFramebuffersOES :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenFramebuffersOES = unsafePerformIO $ getCommand "glGenFramebuffersOES"

-- glGenLists ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGenLists.xml OpenGL 2.x>.
glGenLists
  :: MonadIO m
  => GLsizei -- ^ @range@.
  -> m GLuint -- ^ of type @List@.
glGenLists v1 = liftIO $ dyn297 ptr_glGenLists v1

{-# NOINLINE ptr_glGenLists #-}
ptr_glGenLists :: FunPtr (GLsizei -> IO GLuint)
ptr_glGenLists = unsafePerformIO $ getCommand "glGenLists"

-- glGenNamesAMD ---------------------------------------------------------------

glGenNamesAMD
  :: MonadIO m
  => GLenum -- ^ @identifier@.
  -> GLuint -- ^ @num@.
  -> Ptr GLuint -- ^ @names@ pointing to @num@ elements of type @GLuint@.
  -> m ()
glGenNamesAMD v1 v2 v3 = liftIO $ dyn214 ptr_glGenNamesAMD v1 v2 v3

{-# NOINLINE ptr_glGenNamesAMD #-}
ptr_glGenNamesAMD :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
ptr_glGenNamesAMD = unsafePerformIO $ getCommand "glGenNamesAMD"

-- glGenOcclusionQueriesNV -----------------------------------------------------

glGenOcclusionQueriesNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenOcclusionQueriesNV v1 v2 = liftIO $ dyn193 ptr_glGenOcclusionQueriesNV v1 v2

{-# NOINLINE ptr_glGenOcclusionQueriesNV #-}
ptr_glGenOcclusionQueriesNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenOcclusionQueriesNV = unsafePerformIO $ getCommand "glGenOcclusionQueriesNV"

-- glGenPathsNV ----------------------------------------------------------------

glGenPathsNV
  :: MonadIO m
  => GLsizei -- ^ @range@.
  -> m GLuint -- ^ of type @Path@.
glGenPathsNV v1 = liftIO $ dyn297 ptr_glGenPathsNV v1

{-# NOINLINE ptr_glGenPathsNV #-}
ptr_glGenPathsNV :: FunPtr (GLsizei -> IO GLuint)
ptr_glGenPathsNV = unsafePerformIO $ getCommand "glGenPathsNV"

-- glGenPerfMonitorsAMD --------------------------------------------------------

glGenPerfMonitorsAMD
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @monitors@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenPerfMonitorsAMD v1 v2 = liftIO $ dyn193 ptr_glGenPerfMonitorsAMD v1 v2

{-# NOINLINE ptr_glGenPerfMonitorsAMD #-}
ptr_glGenPerfMonitorsAMD :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenPerfMonitorsAMD = unsafePerformIO $ getCommand "glGenPerfMonitorsAMD"

-- glGenProgramPipelines -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGenProgramPipelines.xhtml OpenGL 4.x>.
glGenProgramPipelines
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @pipelines@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenProgramPipelines v1 v2 = liftIO $ dyn193 ptr_glGenProgramPipelines v1 v2

{-# NOINLINE ptr_glGenProgramPipelines #-}
ptr_glGenProgramPipelines :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenProgramPipelines = unsafePerformIO $ getCommand "glGenProgramPipelines"

-- glGenProgramPipelinesEXT ----------------------------------------------------

glGenProgramPipelinesEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @pipelines@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenProgramPipelinesEXT v1 v2 = liftIO $ dyn193 ptr_glGenProgramPipelinesEXT v1 v2

{-# NOINLINE ptr_glGenProgramPipelinesEXT #-}
ptr_glGenProgramPipelinesEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenProgramPipelinesEXT = unsafePerformIO $ getCommand "glGenProgramPipelinesEXT"

-- glGenProgramsARB ------------------------------------------------------------

glGenProgramsARB
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @programs@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenProgramsARB v1 v2 = liftIO $ dyn193 ptr_glGenProgramsARB v1 v2

{-# NOINLINE ptr_glGenProgramsARB #-}
ptr_glGenProgramsARB :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenProgramsARB = unsafePerformIO $ getCommand "glGenProgramsARB"

-- glGenProgramsNV -------------------------------------------------------------

-- | This command is an alias for 'glGenProgramsARB'.
glGenProgramsNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @programs@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenProgramsNV v1 v2 = liftIO $ dyn193 ptr_glGenProgramsNV v1 v2

{-# NOINLINE ptr_glGenProgramsNV #-}
ptr_glGenProgramsNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenProgramsNV = unsafePerformIO $ getCommand "glGenProgramsNV"

-- glGenQueries ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGenQueries.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGenQueries.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenQueries.xhtml OpenGL 4.x>.
glGenQueries
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenQueries v1 v2 = liftIO $ dyn193 ptr_glGenQueries v1 v2

{-# NOINLINE ptr_glGenQueries #-}
ptr_glGenQueries :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenQueries = unsafePerformIO $ getCommand "glGenQueries"

-- glGenQueriesARB -------------------------------------------------------------

-- | This command is an alias for 'glGenQueries'.
glGenQueriesARB
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenQueriesARB v1 v2 = liftIO $ dyn193 ptr_glGenQueriesARB v1 v2

{-# NOINLINE ptr_glGenQueriesARB #-}
ptr_glGenQueriesARB :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenQueriesARB = unsafePerformIO $ getCommand "glGenQueriesARB"

-- glGenQueriesEXT -------------------------------------------------------------

glGenQueriesEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenQueriesEXT v1 v2 = liftIO $ dyn193 ptr_glGenQueriesEXT v1 v2

{-# NOINLINE ptr_glGenQueriesEXT #-}
ptr_glGenQueriesEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenQueriesEXT = unsafePerformIO $ getCommand "glGenQueriesEXT"

-- glGenRenderbuffers ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGenRenderbuffers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenRenderbuffers.xhtml OpenGL 4.x>.
glGenRenderbuffers
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @renderbuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenRenderbuffers v1 v2 = liftIO $ dyn193 ptr_glGenRenderbuffers v1 v2

{-# NOINLINE ptr_glGenRenderbuffers #-}
ptr_glGenRenderbuffers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenRenderbuffers = unsafePerformIO $ getCommand "glGenRenderbuffers"

-- glGenRenderbuffersEXT -------------------------------------------------------

-- | This command is an alias for 'glGenRenderbuffers'.
glGenRenderbuffersEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @renderbuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenRenderbuffersEXT v1 v2 = liftIO $ dyn193 ptr_glGenRenderbuffersEXT v1 v2

{-# NOINLINE ptr_glGenRenderbuffersEXT #-}
ptr_glGenRenderbuffersEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenRenderbuffersEXT = unsafePerformIO $ getCommand "glGenRenderbuffersEXT"

-- glGenRenderbuffersOES -------------------------------------------------------

glGenRenderbuffersOES
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @renderbuffers@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenRenderbuffersOES v1 v2 = liftIO $ dyn193 ptr_glGenRenderbuffersOES v1 v2

{-# NOINLINE ptr_glGenRenderbuffersOES #-}
ptr_glGenRenderbuffersOES :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenRenderbuffersOES = unsafePerformIO $ getCommand "glGenRenderbuffersOES"

-- glGenSamplers ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGenSamplers.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenSamplers.xhtml OpenGL 4.x>.
glGenSamplers
  :: MonadIO m
  => GLsizei -- ^ @count@.
  -> Ptr GLuint -- ^ @samplers@ pointing to @count@ elements of type @GLuint@.
  -> m ()
glGenSamplers v1 v2 = liftIO $ dyn193 ptr_glGenSamplers v1 v2

{-# NOINLINE ptr_glGenSamplers #-}
ptr_glGenSamplers :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenSamplers = unsafePerformIO $ getCommand "glGenSamplers"

-- glGenSymbolsEXT -------------------------------------------------------------

glGenSymbolsEXT
  :: MonadIO m
  => GLenum -- ^ @datatype@ of type @DataTypeEXT@.
  -> GLenum -- ^ @storagetype@ of type @VertexShaderStorageTypeEXT@.
  -> GLenum -- ^ @range@ of type @ParameterRangeEXT@.
  -> GLuint -- ^ @components@.
  -> m GLuint
glGenSymbolsEXT v1 v2 v3 v4 = liftIO $ dyn299 ptr_glGenSymbolsEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGenSymbolsEXT #-}
ptr_glGenSymbolsEXT :: FunPtr (GLenum -> GLenum -> GLenum -> GLuint -> IO GLuint)
ptr_glGenSymbolsEXT = unsafePerformIO $ getCommand "glGenSymbolsEXT"

-- glGenTextures ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGenTextures.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGenTextures.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenTextures.xhtml OpenGL 4.x>.
glGenTextures
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @textures@ pointing to @n@ elements of type @Texture@.
  -> m ()
glGenTextures v1 v2 = liftIO $ dyn193 ptr_glGenTextures v1 v2

{-# NOINLINE ptr_glGenTextures #-}
ptr_glGenTextures :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenTextures = unsafePerformIO $ getCommand "glGenTextures"

-- glGenTexturesEXT ------------------------------------------------------------

glGenTexturesEXT
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @textures@ pointing to @n@ elements of type @Texture@.
  -> m ()
glGenTexturesEXT v1 v2 = liftIO $ dyn193 ptr_glGenTexturesEXT v1 v2

{-# NOINLINE ptr_glGenTexturesEXT #-}
ptr_glGenTexturesEXT :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenTexturesEXT = unsafePerformIO $ getCommand "glGenTexturesEXT"

-- glGenTransformFeedbacks -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGenTransformFeedbacks.xhtml OpenGL 4.x>.
glGenTransformFeedbacks
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenTransformFeedbacks v1 v2 = liftIO $ dyn193 ptr_glGenTransformFeedbacks v1 v2

{-# NOINLINE ptr_glGenTransformFeedbacks #-}
ptr_glGenTransformFeedbacks :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenTransformFeedbacks = unsafePerformIO $ getCommand "glGenTransformFeedbacks"

-- glGenTransformFeedbacksNV ---------------------------------------------------

-- | This command is an alias for 'glGenTransformFeedbacks'.
glGenTransformFeedbacksNV
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @ids@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenTransformFeedbacksNV v1 v2 = liftIO $ dyn193 ptr_glGenTransformFeedbacksNV v1 v2

{-# NOINLINE ptr_glGenTransformFeedbacksNV #-}
ptr_glGenTransformFeedbacksNV :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenTransformFeedbacksNV = unsafePerformIO $ getCommand "glGenTransformFeedbacksNV"

-- glGenVertexArrays -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGenVertexArrays.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenVertexArrays.xhtml OpenGL 4.x>.
glGenVertexArrays
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @arrays@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenVertexArrays v1 v2 = liftIO $ dyn193 ptr_glGenVertexArrays v1 v2

{-# NOINLINE ptr_glGenVertexArrays #-}
ptr_glGenVertexArrays :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenVertexArrays = unsafePerformIO $ getCommand "glGenVertexArrays"

-- glGenVertexArraysAPPLE ------------------------------------------------------

-- | This command is an alias for 'glGenVertexArrays'.
glGenVertexArraysAPPLE
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @arrays@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenVertexArraysAPPLE v1 v2 = liftIO $ dyn193 ptr_glGenVertexArraysAPPLE v1 v2

{-# NOINLINE ptr_glGenVertexArraysAPPLE #-}
ptr_glGenVertexArraysAPPLE :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenVertexArraysAPPLE = unsafePerformIO $ getCommand "glGenVertexArraysAPPLE"

-- glGenVertexArraysOES --------------------------------------------------------

-- | This command is an alias for 'glGenVertexArrays'.
glGenVertexArraysOES
  :: MonadIO m
  => GLsizei -- ^ @n@.
  -> Ptr GLuint -- ^ @arrays@ pointing to @n@ elements of type @GLuint@.
  -> m ()
glGenVertexArraysOES v1 v2 = liftIO $ dyn193 ptr_glGenVertexArraysOES v1 v2

{-# NOINLINE ptr_glGenVertexArraysOES #-}
ptr_glGenVertexArraysOES :: FunPtr (GLsizei -> Ptr GLuint -> IO ())
ptr_glGenVertexArraysOES = unsafePerformIO $ getCommand "glGenVertexArraysOES"

-- glGenVertexShadersEXT -------------------------------------------------------

glGenVertexShadersEXT
  :: MonadIO m
  => GLuint -- ^ @range@.
  -> m GLuint
glGenVertexShadersEXT v1 = liftIO $ dyn298 ptr_glGenVertexShadersEXT v1

{-# NOINLINE ptr_glGenVertexShadersEXT #-}
ptr_glGenVertexShadersEXT :: FunPtr (GLuint -> IO GLuint)
ptr_glGenVertexShadersEXT = unsafePerformIO $ getCommand "glGenVertexShadersEXT"

-- glGenerateMipmap ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGenerateMipmap.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGenerateMipmap.xhtml OpenGL 4.x>.
glGenerateMipmap
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glGenerateMipmap v1 = liftIO $ dyn4 ptr_glGenerateMipmap v1

{-# NOINLINE ptr_glGenerateMipmap #-}
ptr_glGenerateMipmap :: FunPtr (GLenum -> IO ())
ptr_glGenerateMipmap = unsafePerformIO $ getCommand "glGenerateMipmap"

-- glGenerateMipmapEXT ---------------------------------------------------------

-- | This command is an alias for 'glGenerateMipmap'.
glGenerateMipmapEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glGenerateMipmapEXT v1 = liftIO $ dyn4 ptr_glGenerateMipmapEXT v1

{-# NOINLINE ptr_glGenerateMipmapEXT #-}
ptr_glGenerateMipmapEXT :: FunPtr (GLenum -> IO ())
ptr_glGenerateMipmapEXT = unsafePerformIO $ getCommand "glGenerateMipmapEXT"

-- glGenerateMipmapOES ---------------------------------------------------------

glGenerateMipmapOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glGenerateMipmapOES v1 = liftIO $ dyn4 ptr_glGenerateMipmapOES v1

{-# NOINLINE ptr_glGenerateMipmapOES #-}
ptr_glGenerateMipmapOES :: FunPtr (GLenum -> IO ())
ptr_glGenerateMipmapOES = unsafePerformIO $ getCommand "glGenerateMipmapOES"

-- glGenerateMultiTexMipmapEXT -------------------------------------------------

glGenerateMultiTexMipmapEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> m ()
glGenerateMultiTexMipmapEXT v1 v2 = liftIO $ dyn51 ptr_glGenerateMultiTexMipmapEXT v1 v2

{-# NOINLINE ptr_glGenerateMultiTexMipmapEXT #-}
ptr_glGenerateMultiTexMipmapEXT :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glGenerateMultiTexMipmapEXT = unsafePerformIO $ getCommand "glGenerateMultiTexMipmapEXT"

-- glGenerateTextureMipmap -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGenerateMipmap.xhtml OpenGL 4.x>.
glGenerateTextureMipmap
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> m ()
glGenerateTextureMipmap v1 = liftIO $ dyn2 ptr_glGenerateTextureMipmap v1

{-# NOINLINE ptr_glGenerateTextureMipmap #-}
ptr_glGenerateTextureMipmap :: FunPtr (GLuint -> IO ())
ptr_glGenerateTextureMipmap = unsafePerformIO $ getCommand "glGenerateTextureMipmap"

-- glGenerateTextureMipmapEXT --------------------------------------------------

glGenerateTextureMipmapEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> m ()
glGenerateTextureMipmapEXT v1 v2 = liftIO $ dyn15 ptr_glGenerateTextureMipmapEXT v1 v2

{-# NOINLINE ptr_glGenerateTextureMipmapEXT #-}
ptr_glGenerateTextureMipmapEXT :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glGenerateTextureMipmapEXT = unsafePerformIO $ getCommand "glGenerateTextureMipmapEXT"

-- glGetActiveAtomicCounterBufferiv --------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetActiveAtomicCounterBufferiv.xhtml OpenGL 4.x>.
glGetActiveAtomicCounterBufferiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @bufferIndex@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetActiveAtomicCounterBufferiv v1 v2 v3 v4 = liftIO $ dyn300 ptr_glGetActiveAtomicCounterBufferiv v1 v2 v3 v4

{-# NOINLINE ptr_glGetActiveAtomicCounterBufferiv #-}
ptr_glGetActiveAtomicCounterBufferiv :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetActiveAtomicCounterBufferiv = unsafePerformIO $ getCommand "glGetActiveAtomicCounterBufferiv"

-- glGetActiveAttrib -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetActiveAttrib.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveAttrib.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetActiveAttrib.xhtml OpenGL 4.x>.
glGetActiveAttrib
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLint -- ^ @size@ pointing to @1@ element of type @GLint@.
  -> Ptr GLenum -- ^ @type@ pointing to @1@ element of type @GLenum@.
  -> Ptr GLchar -- ^ @name@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetActiveAttrib v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn301 ptr_glGetActiveAttrib v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glGetActiveAttrib #-}
ptr_glGetActiveAttrib :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLchar -> IO ())
ptr_glGetActiveAttrib = unsafePerformIO $ getCommand "glGetActiveAttrib"

-- glGetActiveAttribARB --------------------------------------------------------

-- | This command is an alias for 'glGetActiveAttrib'.
glGetActiveAttribARB
  :: MonadIO m
  => GLhandleARB -- ^ @programObj@ of type @handleARB@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @maxLength@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLint -- ^ @size@ pointing to @1@ element of type @GLint@.
  -> Ptr GLenum -- ^ @type@ pointing to @1@ element of type @GLenum@.
  -> Ptr GLcharARB -- ^ @name@ pointing to @maxLength@ elements of type @GLcharARB@.
  -> m ()
glGetActiveAttribARB v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn302 ptr_glGetActiveAttribARB v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glGetActiveAttribARB #-}
ptr_glGetActiveAttribARB :: FunPtr (GLhandleARB -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLcharARB -> IO ())
ptr_glGetActiveAttribARB = unsafePerformIO $ getCommand "glGetActiveAttribARB"

-- glGetActiveSubroutineName ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetActiveSubroutineName.xhtml OpenGL 4.x>.
glGetActiveSubroutineName
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @shadertype@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @bufsize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @name@ pointing to @bufsize@ elements of type @GLchar@.
  -> m ()
glGetActiveSubroutineName v1 v2 v3 v4 v5 v6 = liftIO $ dyn303 ptr_glGetActiveSubroutineName v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetActiveSubroutineName #-}
ptr_glGetActiveSubroutineName :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetActiveSubroutineName = unsafePerformIO $ getCommand "glGetActiveSubroutineName"

-- glGetActiveSubroutineUniformName --------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetActiveSubroutineUniformName.xhtml OpenGL 4.x>.
glGetActiveSubroutineUniformName
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @shadertype@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @bufsize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @name@ pointing to @bufsize@ elements of type @GLchar@.
  -> m ()
glGetActiveSubroutineUniformName v1 v2 v3 v4 v5 v6 = liftIO $ dyn303 ptr_glGetActiveSubroutineUniformName v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetActiveSubroutineUniformName #-}
ptr_glGetActiveSubroutineUniformName :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetActiveSubroutineUniformName = unsafePerformIO $ getCommand "glGetActiveSubroutineUniformName"

-- glGetActiveSubroutineUniformiv ----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetActiveSubroutineUniform.xhtml OpenGL 4.x>.
glGetActiveSubroutineUniformiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @shadertype@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @values@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetActiveSubroutineUniformiv v1 v2 v3 v4 v5 = liftIO $ dyn304 ptr_glGetActiveSubroutineUniformiv v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetActiveSubroutineUniformiv #-}
ptr_glGetActiveSubroutineUniformiv :: FunPtr (GLuint -> GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetActiveSubroutineUniformiv = unsafePerformIO $ getCommand "glGetActiveSubroutineUniformiv"

-- glGetActiveUniform ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetActiveUniform.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniform.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetActiveUniform.xhtml OpenGL 4.x>.
glGetActiveUniform
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLint -- ^ @size@ pointing to @1@ element of type @GLint@.
  -> Ptr GLenum -- ^ @type@ pointing to @1@ element of type @GLenum@.
  -> Ptr GLchar -- ^ @name@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetActiveUniform v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn301 ptr_glGetActiveUniform v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glGetActiveUniform #-}
ptr_glGetActiveUniform :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLchar -> IO ())
ptr_glGetActiveUniform = unsafePerformIO $ getCommand "glGetActiveUniform"

-- glGetActiveUniformARB -------------------------------------------------------

-- | This command is an alias for 'glGetActiveUniform'.
glGetActiveUniformARB
  :: MonadIO m
  => GLhandleARB -- ^ @programObj@ of type @handleARB@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @maxLength@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLint -- ^ @size@ pointing to @1@ element of type @GLint@.
  -> Ptr GLenum -- ^ @type@ pointing to @1@ element of type @GLenum@.
  -> Ptr GLcharARB -- ^ @name@ pointing to @maxLength@ elements of type @GLcharARB@.
  -> m ()
glGetActiveUniformARB v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn302 ptr_glGetActiveUniformARB v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glGetActiveUniformARB #-}
ptr_glGetActiveUniformARB :: FunPtr (GLhandleARB -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLint -> Ptr GLenum -> Ptr GLcharARB -> IO ())
ptr_glGetActiveUniformARB = unsafePerformIO $ getCommand "glGetActiveUniformARB"

-- glGetActiveUniformBlockName -------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniformBlockName.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetActiveUniformBlockName.xhtml OpenGL 4.x>.
glGetActiveUniformBlockName
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @uniformBlockIndex@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @uniformBlockName@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetActiveUniformBlockName v1 v2 v3 v4 v5 = liftIO $ dyn305 ptr_glGetActiveUniformBlockName v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetActiveUniformBlockName #-}
ptr_glGetActiveUniformBlockName :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetActiveUniformBlockName = unsafePerformIO $ getCommand "glGetActiveUniformBlockName"

-- glGetActiveUniformBlockiv ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniformBlock.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetActiveUniformBlock.xhtml OpenGL 4.x>.
glGetActiveUniformBlockiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @uniformBlockIndex@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(program,uniformBlockIndex,pname)@ elements of type @GLint@.
  -> m ()
glGetActiveUniformBlockiv v1 v2 v3 v4 = liftIO $ dyn300 ptr_glGetActiveUniformBlockiv v1 v2 v3 v4

{-# NOINLINE ptr_glGetActiveUniformBlockiv #-}
ptr_glGetActiveUniformBlockiv :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetActiveUniformBlockiv = unsafePerformIO $ getCommand "glGetActiveUniformBlockiv"

-- glGetActiveUniformName ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniformName.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetActiveUniformName.xhtml OpenGL 4.x>.
glGetActiveUniformName
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @uniformIndex@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @uniformName@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetActiveUniformName v1 v2 v3 v4 v5 = liftIO $ dyn305 ptr_glGetActiveUniformName v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetActiveUniformName #-}
ptr_glGetActiveUniformName :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetActiveUniformName = unsafePerformIO $ getCommand "glGetActiveUniformName"

-- glGetActiveUniformsiv -------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetActiveUniformsiv.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetActiveUniformsiv.xhtml OpenGL 4.x>.
glGetActiveUniformsiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLsizei -- ^ @uniformCount@.
  -> Ptr GLuint -- ^ @uniformIndices@ pointing to @uniformCount@ elements of type @GLuint@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(uniformCount,pname)@ elements of type @GLint@.
  -> m ()
glGetActiveUniformsiv v1 v2 v3 v4 v5 = liftIO $ dyn306 ptr_glGetActiveUniformsiv v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetActiveUniformsiv #-}
ptr_glGetActiveUniformsiv :: FunPtr (GLuint -> GLsizei -> Ptr GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetActiveUniformsiv = unsafePerformIO $ getCommand "glGetActiveUniformsiv"

-- glGetActiveVaryingNV --------------------------------------------------------

glGetActiveVaryingNV
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLsizei -- ^ @size@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLenum -- ^ @type@ pointing to @1@ element of type @GLenum@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(program,index,bufSize)@ elements of type @GLchar@.
  -> m ()
glGetActiveVaryingNV v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn307 ptr_glGetActiveVaryingNV v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glGetActiveVaryingNV #-}
ptr_glGetActiveVaryingNV :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLsizei -> Ptr GLenum -> Ptr GLchar -> IO ())
ptr_glGetActiveVaryingNV = unsafePerformIO $ getCommand "glGetActiveVaryingNV"

-- glGetArrayObjectfvATI -------------------------------------------------------

glGetArrayObjectfvATI
  :: MonadIO m
  => GLenum -- ^ @array@ of type [EnableCap](Graphics-GL-Groups.html#EnableCap).
  -> GLenum -- ^ @pname@ of type @ArrayObjectPNameATI@.
  -> Ptr GLfloat -- ^ @params@ pointing to @1@ element of type @GLfloat@.
  -> m ()
glGetArrayObjectfvATI v1 v2 v3 = liftIO $ dyn132 ptr_glGetArrayObjectfvATI v1 v2 v3

{-# NOINLINE ptr_glGetArrayObjectfvATI #-}
ptr_glGetArrayObjectfvATI :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetArrayObjectfvATI = unsafePerformIO $ getCommand "glGetArrayObjectfvATI"

-- glGetArrayObjectivATI -------------------------------------------------------

glGetArrayObjectivATI
  :: MonadIO m
  => GLenum -- ^ @array@ of type [EnableCap](Graphics-GL-Groups.html#EnableCap).
  -> GLenum -- ^ @pname@ of type @ArrayObjectPNameATI@.
  -> Ptr GLint -- ^ @params@ pointing to @1@ element of type @GLint@.
  -> m ()
glGetArrayObjectivATI v1 v2 v3 = liftIO $ dyn133 ptr_glGetArrayObjectivATI v1 v2 v3

{-# NOINLINE ptr_glGetArrayObjectivATI #-}
ptr_glGetArrayObjectivATI :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetArrayObjectivATI = unsafePerformIO $ getCommand "glGetArrayObjectivATI"

-- glGetAttachedObjectsARB -----------------------------------------------------

glGetAttachedObjectsARB
  :: MonadIO m
  => GLhandleARB -- ^ @containerObj@ of type @handleARB@.
  -> GLsizei -- ^ @maxCount@.
  -> Ptr GLsizei -- ^ @count@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLhandleARB -- ^ @obj@ pointing to @maxCount@ elements of type @handleARB@.
  -> m ()
glGetAttachedObjectsARB v1 v2 v3 v4 = liftIO $ dyn308 ptr_glGetAttachedObjectsARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetAttachedObjectsARB #-}
ptr_glGetAttachedObjectsARB :: FunPtr (GLhandleARB -> GLsizei -> Ptr GLsizei -> Ptr GLhandleARB -> IO ())
ptr_glGetAttachedObjectsARB = unsafePerformIO $ getCommand "glGetAttachedObjectsARB"

-- glGetAttachedShaders --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetAttachedShaders.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetAttachedShaders.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetAttachedShaders.xhtml OpenGL 4.x>.
glGetAttachedShaders
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLsizei -- ^ @maxCount@.
  -> Ptr GLsizei -- ^ @count@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLuint -- ^ @shaders@ pointing to @maxCount@ elements of type @GLuint@.
  -> m ()
glGetAttachedShaders v1 v2 v3 v4 = liftIO $ dyn309 ptr_glGetAttachedShaders v1 v2 v3 v4

{-# NOINLINE ptr_glGetAttachedShaders #-}
ptr_glGetAttachedShaders :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLuint -> IO ())
ptr_glGetAttachedShaders = unsafePerformIO $ getCommand "glGetAttachedShaders"

-- glGetAttribLocation ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetAttribLocation.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetAttribLocation.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetAttribLocation.xhtml OpenGL 4.x>.
glGetAttribLocation
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> Ptr GLchar -- ^ @name@.
  -> m GLint
glGetAttribLocation v1 v2 = liftIO $ dyn310 ptr_glGetAttribLocation v1 v2

{-# NOINLINE ptr_glGetAttribLocation #-}
ptr_glGetAttribLocation :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
ptr_glGetAttribLocation = unsafePerformIO $ getCommand "glGetAttribLocation"

-- glGetAttribLocationARB ------------------------------------------------------

-- | This command is an alias for 'glGetAttribLocation'.
glGetAttribLocationARB
  :: MonadIO m
  => GLhandleARB -- ^ @programObj@ of type @handleARB@.
  -> Ptr GLcharARB -- ^ @name@.
  -> m GLint
glGetAttribLocationARB v1 v2 = liftIO $ dyn311 ptr_glGetAttribLocationARB v1 v2

{-# NOINLINE ptr_glGetAttribLocationARB #-}
ptr_glGetAttribLocationARB :: FunPtr (GLhandleARB -> Ptr GLcharARB -> IO GLint)
ptr_glGetAttribLocationARB = unsafePerformIO $ getCommand "glGetAttribLocationARB"

-- glGetBooleanIndexedvEXT -----------------------------------------------------

-- | This command is an alias for 'glGetBooleani_v'.
glGetBooleanIndexedvEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLboolean -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glGetBooleanIndexedvEXT v1 v2 v3 = liftIO $ dyn312 ptr_glGetBooleanIndexedvEXT v1 v2 v3

{-# NOINLINE ptr_glGetBooleanIndexedvEXT #-}
ptr_glGetBooleanIndexedvEXT :: FunPtr (GLenum -> GLuint -> Ptr GLboolean -> IO ())
ptr_glGetBooleanIndexedvEXT = unsafePerformIO $ getCommand "glGetBooleanIndexedvEXT"

-- glGetBooleani_v -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>.
glGetBooleani_v
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLboolean -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glGetBooleani_v v1 v2 v3 = liftIO $ dyn312 ptr_glGetBooleani_v v1 v2 v3

{-# NOINLINE ptr_glGetBooleani_v #-}
ptr_glGetBooleani_v :: FunPtr (GLenum -> GLuint -> Ptr GLboolean -> IO ())
ptr_glGetBooleani_v = unsafePerformIO $ getCommand "glGetBooleani_v"

-- glGetBooleanv ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGet.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>.
glGetBooleanv
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [GetPName](Graphics-GL-Groups.html#GetPName).
  -> Ptr GLboolean -- ^ @data@ pointing to @COMPSIZE(pname)@ elements of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glGetBooleanv v1 v2 = liftIO $ dyn313 ptr_glGetBooleanv v1 v2

{-# NOINLINE ptr_glGetBooleanv #-}
ptr_glGetBooleanv :: FunPtr (GLenum -> Ptr GLboolean -> IO ())
ptr_glGetBooleanv = unsafePerformIO $ getCommand "glGetBooleanv"

-- glGetBufferParameteri64v ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetBufferParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetBufferParameter.xhtml OpenGL 4.x>.
glGetBufferParameteri64v
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLenum -- ^ @pname@ of type @BufferPNameARB@.
  -> Ptr GLint64 -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint64@.
  -> m ()
glGetBufferParameteri64v v1 v2 v3 = liftIO $ dyn314 ptr_glGetBufferParameteri64v v1 v2 v3

{-# NOINLINE ptr_glGetBufferParameteri64v #-}
ptr_glGetBufferParameteri64v :: FunPtr (GLenum -> GLenum -> Ptr GLint64 -> IO ())
ptr_glGetBufferParameteri64v = unsafePerformIO $ getCommand "glGetBufferParameteri64v"

-- glGetBufferParameteriv ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetBufferParameteriv.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetBufferParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetBufferParameter.xhtml OpenGL 4.x>.
glGetBufferParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLenum -- ^ @pname@ of type @BufferPNameARB@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetBufferParameteriv v1 v2 v3 = liftIO $ dyn133 ptr_glGetBufferParameteriv v1 v2 v3

{-# NOINLINE ptr_glGetBufferParameteriv #-}
ptr_glGetBufferParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetBufferParameteriv = unsafePerformIO $ getCommand "glGetBufferParameteriv"

-- glGetBufferParameterivARB ---------------------------------------------------

-- | This command is an alias for 'glGetBufferParameteriv'.
glGetBufferParameterivARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLenum -- ^ @pname@ of type @BufferPNameARB@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetBufferParameterivARB v1 v2 v3 = liftIO $ dyn133 ptr_glGetBufferParameterivARB v1 v2 v3

{-# NOINLINE ptr_glGetBufferParameterivARB #-}
ptr_glGetBufferParameterivARB :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetBufferParameterivARB = unsafePerformIO $ getCommand "glGetBufferParameterivARB"

-- glGetBufferParameterui64vNV -------------------------------------------------

glGetBufferParameterui64vNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint64EXT -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint64EXT@.
  -> m ()
glGetBufferParameterui64vNV v1 v2 v3 = liftIO $ dyn315 ptr_glGetBufferParameterui64vNV v1 v2 v3

{-# NOINLINE ptr_glGetBufferParameterui64vNV #-}
ptr_glGetBufferParameterui64vNV :: FunPtr (GLenum -> GLenum -> Ptr GLuint64EXT -> IO ())
ptr_glGetBufferParameterui64vNV = unsafePerformIO $ getCommand "glGetBufferParameterui64vNV"

-- glGetBufferPointerv ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetBufferPointerv.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetBufferPointerv.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetBufferPointerv.xhtml OpenGL 4.x>.
glGetBufferPointerv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLenum -- ^ @pname@ of type @BufferPointerNameARB@.
  -> Ptr (Ptr a) -- ^ @params@ pointing to @1@ element of type @Ptr a@.
  -> m ()
glGetBufferPointerv v1 v2 v3 = liftIO $ dyn316 ptr_glGetBufferPointerv v1 v2 v3

{-# NOINLINE ptr_glGetBufferPointerv #-}
ptr_glGetBufferPointerv :: FunPtr (GLenum -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetBufferPointerv = unsafePerformIO $ getCommand "glGetBufferPointerv"

-- glGetBufferPointervARB ------------------------------------------------------

-- | This command is an alias for 'glGetBufferPointerv'.
glGetBufferPointervARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLenum -- ^ @pname@ of type @BufferPointerNameARB@.
  -> Ptr (Ptr a) -- ^ @params@ pointing to @1@ element of type @Ptr a@.
  -> m ()
glGetBufferPointervARB v1 v2 v3 = liftIO $ dyn316 ptr_glGetBufferPointervARB v1 v2 v3

{-# NOINLINE ptr_glGetBufferPointervARB #-}
ptr_glGetBufferPointervARB :: FunPtr (GLenum -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetBufferPointervARB = unsafePerformIO $ getCommand "glGetBufferPointervARB"

-- glGetBufferPointervOES ------------------------------------------------------

-- | This command is an alias for 'glGetBufferPointerv'.
glGetBufferPointervOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr (Ptr a) -- ^ @params@.
  -> m ()
glGetBufferPointervOES v1 v2 v3 = liftIO $ dyn316 ptr_glGetBufferPointervOES v1 v2 v3

{-# NOINLINE ptr_glGetBufferPointervOES #-}
ptr_glGetBufferPointervOES :: FunPtr (GLenum -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetBufferPointervOES = unsafePerformIO $ getCommand "glGetBufferPointervOES"

-- glGetBufferSubData ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetBufferSubData.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetBufferSubData.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetBufferSubData.xhtml OpenGL 4.x>.
glGetBufferSubData
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> m ()
glGetBufferSubData v1 v2 v3 v4 = liftIO $ dyn64 ptr_glGetBufferSubData v1 v2 v3 v4

{-# NOINLINE ptr_glGetBufferSubData #-}
ptr_glGetBufferSubData :: FunPtr (GLenum -> GLintptr -> GLsizeiptr -> Ptr a -> IO ())
ptr_glGetBufferSubData = unsafePerformIO $ getCommand "glGetBufferSubData"

-- glGetBufferSubDataARB -------------------------------------------------------

-- | This command is an alias for 'glGetBufferSubData'.
glGetBufferSubDataARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @BufferTargetARB@.
  -> GLintptrARB -- ^ @offset@ of type @BufferOffsetARB@.
  -> GLsizeiptrARB -- ^ @size@ of type @BufferSizeARB@.
  -> Ptr a -- ^ @data@ pointing to @size@ elements of type @a@.
  -> m ()
glGetBufferSubDataARB v1 v2 v3 v4 = liftIO $ dyn65 ptr_glGetBufferSubDataARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetBufferSubDataARB #-}
ptr_glGetBufferSubDataARB :: FunPtr (GLenum -> GLintptrARB -> GLsizeiptrARB -> Ptr a -> IO ())
ptr_glGetBufferSubDataARB = unsafePerformIO $ getCommand "glGetBufferSubDataARB"

-- glGetClipPlane --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetClipPlane.xml OpenGL 2.x>.
glGetClipPlane
  :: MonadIO m
  => GLenum -- ^ @plane@ of type [ClipPlaneName](Graphics-GL-Groups.html#ClipPlaneName).
  -> Ptr GLdouble -- ^ @equation@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glGetClipPlane v1 v2 = liftIO $ dyn93 ptr_glGetClipPlane v1 v2

{-# NOINLINE ptr_glGetClipPlane #-}
ptr_glGetClipPlane :: FunPtr (GLenum -> Ptr GLdouble -> IO ())
ptr_glGetClipPlane = unsafePerformIO $ getCommand "glGetClipPlane"

-- glGetClipPlanef -------------------------------------------------------------

glGetClipPlanef
  :: MonadIO m
  => GLenum -- ^ @plane@.
  -> Ptr GLfloat -- ^ @equation@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetClipPlanef v1 v2 = liftIO $ dyn94 ptr_glGetClipPlanef v1 v2

{-# NOINLINE ptr_glGetClipPlanef #-}
ptr_glGetClipPlanef :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetClipPlanef = unsafePerformIO $ getCommand "glGetClipPlanef"

-- glGetClipPlanefOES ----------------------------------------------------------

glGetClipPlanefOES
  :: MonadIO m
  => GLenum -- ^ @plane@.
  -> Ptr GLfloat -- ^ @equation@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetClipPlanefOES v1 v2 = liftIO $ dyn94 ptr_glGetClipPlanefOES v1 v2

{-# NOINLINE ptr_glGetClipPlanefOES #-}
ptr_glGetClipPlanefOES :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetClipPlanefOES = unsafePerformIO $ getCommand "glGetClipPlanefOES"

-- glGetClipPlanex -------------------------------------------------------------

glGetClipPlanex
  :: MonadIO m
  => GLenum -- ^ @plane@.
  -> Ptr GLfixed -- ^ @equation@ pointing to @4@ elements of type @GLfixed@.
  -> m ()
glGetClipPlanex v1 v2 = liftIO $ dyn95 ptr_glGetClipPlanex v1 v2

{-# NOINLINE ptr_glGetClipPlanex #-}
ptr_glGetClipPlanex :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glGetClipPlanex = unsafePerformIO $ getCommand "glGetClipPlanex"

-- glGetClipPlanexOES ----------------------------------------------------------

glGetClipPlanexOES
  :: MonadIO m
  => GLenum -- ^ @plane@.
  -> Ptr GLfixed -- ^ @equation@ pointing to @4@ elements of type @GLfixed@.
  -> m ()
glGetClipPlanexOES v1 v2 = liftIO $ dyn95 ptr_glGetClipPlanexOES v1 v2

{-# NOINLINE ptr_glGetClipPlanexOES #-}
ptr_glGetClipPlanexOES :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glGetClipPlanexOES = unsafePerformIO $ getCommand "glGetClipPlanexOES"

-- glGetColorTable -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetColorTable.xml OpenGL 2.x>.
glGetColorTable
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @table@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetColorTable v1 v2 v3 v4 = liftIO $ dyn317 ptr_glGetColorTable v1 v2 v3 v4

{-# NOINLINE ptr_glGetColorTable #-}
ptr_glGetColorTable :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetColorTable = unsafePerformIO $ getCommand "glGetColorTable"

-- glGetColorTableEXT ----------------------------------------------------------

-- | This command is an alias for 'glGetColorTable'.
glGetColorTableEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetColorTableEXT v1 v2 v3 v4 = liftIO $ dyn317 ptr_glGetColorTableEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetColorTableEXT #-}
ptr_glGetColorTableEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetColorTableEXT = unsafePerformIO $ getCommand "glGetColorTableEXT"

-- glGetColorTableParameterfv --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetColorTableParameter.xml OpenGL 2.x>.
glGetColorTableParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @pname@ of type @GetColorTableParameterPName@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetColorTableParameterfv v1 v2 v3 = liftIO $ dyn132 ptr_glGetColorTableParameterfv v1 v2 v3

{-# NOINLINE ptr_glGetColorTableParameterfv #-}
ptr_glGetColorTableParameterfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetColorTableParameterfv = unsafePerformIO $ getCommand "glGetColorTableParameterfv"

-- glGetColorTableParameterfvEXT -----------------------------------------------

-- | This command is an alias for 'glGetColorTableParameterfv'.
glGetColorTableParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @pname@ of type @GetColorTableParameterPName@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetColorTableParameterfvEXT v1 v2 v3 = liftIO $ dyn132 ptr_glGetColorTableParameterfvEXT v1 v2 v3

{-# NOINLINE ptr_glGetColorTableParameterfvEXT #-}
ptr_glGetColorTableParameterfvEXT :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetColorTableParameterfvEXT = unsafePerformIO $ getCommand "glGetColorTableParameterfvEXT"

-- glGetColorTableParameterfvSGI -----------------------------------------------

glGetColorTableParameterfvSGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ColorTableTargetSGI](Graphics-GL-Groups.html#ColorTableTargetSGI).
  -> GLenum -- ^ @pname@ of type [GetColorTableParameterPNameSGI](Graphics-GL-Groups.html#GetColorTableParameterPNameSGI).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetColorTableParameterfvSGI v1 v2 v3 = liftIO $ dyn132 ptr_glGetColorTableParameterfvSGI v1 v2 v3

{-# NOINLINE ptr_glGetColorTableParameterfvSGI #-}
ptr_glGetColorTableParameterfvSGI :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetColorTableParameterfvSGI = unsafePerformIO $ getCommand "glGetColorTableParameterfvSGI"

-- glGetColorTableParameteriv --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetColorTableParameter.xml OpenGL 2.x>.
glGetColorTableParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @pname@ of type @GetColorTableParameterPName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetColorTableParameteriv v1 v2 v3 = liftIO $ dyn133 ptr_glGetColorTableParameteriv v1 v2 v3

{-# NOINLINE ptr_glGetColorTableParameteriv #-}
ptr_glGetColorTableParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetColorTableParameteriv = unsafePerformIO $ getCommand "glGetColorTableParameteriv"

-- glGetColorTableParameterivEXT -----------------------------------------------

-- | This command is an alias for 'glGetColorTableParameteriv'.
glGetColorTableParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ColorTableTarget@.
  -> GLenum -- ^ @pname@ of type @GetColorTableParameterPName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetColorTableParameterivEXT v1 v2 v3 = liftIO $ dyn133 ptr_glGetColorTableParameterivEXT v1 v2 v3

{-# NOINLINE ptr_glGetColorTableParameterivEXT #-}
ptr_glGetColorTableParameterivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetColorTableParameterivEXT = unsafePerformIO $ getCommand "glGetColorTableParameterivEXT"

-- glGetColorTableParameterivSGI -----------------------------------------------

glGetColorTableParameterivSGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ColorTableTargetSGI](Graphics-GL-Groups.html#ColorTableTargetSGI).
  -> GLenum -- ^ @pname@ of type [GetColorTableParameterPNameSGI](Graphics-GL-Groups.html#GetColorTableParameterPNameSGI).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetColorTableParameterivSGI v1 v2 v3 = liftIO $ dyn133 ptr_glGetColorTableParameterivSGI v1 v2 v3

{-# NOINLINE ptr_glGetColorTableParameterivSGI #-}
ptr_glGetColorTableParameterivSGI :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetColorTableParameterivSGI = unsafePerformIO $ getCommand "glGetColorTableParameterivSGI"

-- glGetColorTableSGI ----------------------------------------------------------

glGetColorTableSGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ColorTableTargetSGI](Graphics-GL-Groups.html#ColorTableTargetSGI).
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @table@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetColorTableSGI v1 v2 v3 v4 = liftIO $ dyn317 ptr_glGetColorTableSGI v1 v2 v3 v4

{-# NOINLINE ptr_glGetColorTableSGI #-}
ptr_glGetColorTableSGI :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetColorTableSGI = unsafePerformIO $ getCommand "glGetColorTableSGI"

-- glGetCombinerInputParameterfvNV ---------------------------------------------

glGetCombinerInputParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @portion@ of type @CombinerPortionNV@.
  -> GLenum -- ^ @variable@ of type @CombinerVariableNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetCombinerInputParameterfvNV v1 v2 v3 v4 v5 = liftIO $ dyn318 ptr_glGetCombinerInputParameterfvNV v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetCombinerInputParameterfvNV #-}
ptr_glGetCombinerInputParameterfvNV :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetCombinerInputParameterfvNV = unsafePerformIO $ getCommand "glGetCombinerInputParameterfvNV"

-- glGetCombinerInputParameterivNV ---------------------------------------------

glGetCombinerInputParameterivNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @portion@ of type @CombinerPortionNV@.
  -> GLenum -- ^ @variable@ of type @CombinerVariableNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetCombinerInputParameterivNV v1 v2 v3 v4 v5 = liftIO $ dyn319 ptr_glGetCombinerInputParameterivNV v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetCombinerInputParameterivNV #-}
ptr_glGetCombinerInputParameterivNV :: FunPtr (GLenum -> GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetCombinerInputParameterivNV = unsafePerformIO $ getCommand "glGetCombinerInputParameterivNV"

-- glGetCombinerOutputParameterfvNV --------------------------------------------

glGetCombinerOutputParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @portion@ of type @CombinerPortionNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetCombinerOutputParameterfvNV v1 v2 v3 v4 = liftIO $ dyn320 ptr_glGetCombinerOutputParameterfvNV v1 v2 v3 v4

{-# NOINLINE ptr_glGetCombinerOutputParameterfvNV #-}
ptr_glGetCombinerOutputParameterfvNV :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetCombinerOutputParameterfvNV = unsafePerformIO $ getCommand "glGetCombinerOutputParameterfvNV"

-- glGetCombinerOutputParameterivNV --------------------------------------------

glGetCombinerOutputParameterivNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @portion@ of type @CombinerPortionNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetCombinerOutputParameterivNV v1 v2 v3 v4 = liftIO $ dyn321 ptr_glGetCombinerOutputParameterivNV v1 v2 v3 v4

{-# NOINLINE ptr_glGetCombinerOutputParameterivNV #-}
ptr_glGetCombinerOutputParameterivNV :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetCombinerOutputParameterivNV = unsafePerformIO $ getCommand "glGetCombinerOutputParameterivNV"

-- glGetCombinerStageParameterfvNV ---------------------------------------------

glGetCombinerStageParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @stage@ of type @CombinerStageNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetCombinerStageParameterfvNV v1 v2 v3 = liftIO $ dyn132 ptr_glGetCombinerStageParameterfvNV v1 v2 v3

{-# NOINLINE ptr_glGetCombinerStageParameterfvNV #-}
ptr_glGetCombinerStageParameterfvNV :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetCombinerStageParameterfvNV = unsafePerformIO $ getCommand "glGetCombinerStageParameterfvNV"

-- glGetCommandHeaderNV --------------------------------------------------------

glGetCommandHeaderNV
  :: MonadIO m
  => GLenum -- ^ @tokenID@.
  -> GLuint -- ^ @size@.
  -> m GLuint
glGetCommandHeaderNV v1 v2 = liftIO $ dyn322 ptr_glGetCommandHeaderNV v1 v2

{-# NOINLINE ptr_glGetCommandHeaderNV #-}
ptr_glGetCommandHeaderNV :: FunPtr (GLenum -> GLuint -> IO GLuint)
ptr_glGetCommandHeaderNV = unsafePerformIO $ getCommand "glGetCommandHeaderNV"

-- glGetCompressedMultiTexImageEXT ---------------------------------------------

glGetCompressedMultiTexImageEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @lod@ of type @CheckedInt32@.
  -> Ptr a -- ^ @img@ pointing to @COMPSIZE(target,lod)@ elements of type @a@.
  -> m ()
glGetCompressedMultiTexImageEXT v1 v2 v3 v4 = liftIO $ dyn323 ptr_glGetCompressedMultiTexImageEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetCompressedMultiTexImageEXT #-}
ptr_glGetCompressedMultiTexImageEXT :: FunPtr (GLenum -> GLenum -> GLint -> Ptr a -> IO ())
ptr_glGetCompressedMultiTexImageEXT = unsafePerformIO $ getCommand "glGetCompressedMultiTexImageEXT"

-- glGetCompressedTexImage -----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetCompressedTexImage.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetCompressedTexImage.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetCompressedTexImage.xhtml OpenGL 4.x>.
glGetCompressedTexImage
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> Ptr a -- ^ @img@ pointing to @COMPSIZE(target,level)@ elements of type @CompressedTextureARB@.
  -> m ()
glGetCompressedTexImage v1 v2 v3 = liftIO $ dyn324 ptr_glGetCompressedTexImage v1 v2 v3

{-# NOINLINE ptr_glGetCompressedTexImage #-}
ptr_glGetCompressedTexImage :: FunPtr (GLenum -> GLint -> Ptr a -> IO ())
ptr_glGetCompressedTexImage = unsafePerformIO $ getCommand "glGetCompressedTexImage"

-- glGetCompressedTexImageARB --------------------------------------------------

-- | This command is an alias for 'glGetCompressedTexImage'.
glGetCompressedTexImageARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> Ptr a -- ^ @img@ pointing to @COMPSIZE(target,level)@ elements of type @CompressedTextureARB@.
  -> m ()
glGetCompressedTexImageARB v1 v2 v3 = liftIO $ dyn324 ptr_glGetCompressedTexImageARB v1 v2 v3

{-# NOINLINE ptr_glGetCompressedTexImageARB #-}
ptr_glGetCompressedTexImageARB :: FunPtr (GLenum -> GLint -> Ptr a -> IO ())
ptr_glGetCompressedTexImageARB = unsafePerformIO $ getCommand "glGetCompressedTexImageARB"

-- glGetCompressedTextureImage -------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetCompressedTexImage.xhtml OpenGL 4.x>.
glGetCompressedTextureImage
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @pixels@.
  -> m ()
glGetCompressedTextureImage v1 v2 v3 v4 = liftIO $ dyn325 ptr_glGetCompressedTextureImage v1 v2 v3 v4

{-# NOINLINE ptr_glGetCompressedTextureImage #-}
ptr_glGetCompressedTextureImage :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glGetCompressedTextureImage = unsafePerformIO $ getCommand "glGetCompressedTextureImage"

-- glGetCompressedTextureImageEXT ----------------------------------------------

glGetCompressedTextureImageEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @lod@ of type @CheckedInt32@.
  -> Ptr a -- ^ @img@ pointing to @COMPSIZE(target,lod)@ elements of type @a@.
  -> m ()
glGetCompressedTextureImageEXT v1 v2 v3 v4 = liftIO $ dyn326 ptr_glGetCompressedTextureImageEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetCompressedTextureImageEXT #-}
ptr_glGetCompressedTextureImageEXT :: FunPtr (GLuint -> GLenum -> GLint -> Ptr a -> IO ())
ptr_glGetCompressedTextureImageEXT = unsafePerformIO $ getCommand "glGetCompressedTextureImageEXT"

-- glGetCompressedTextureSubImage ----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetCompressedTextureSubImage.xhtml OpenGL 4.x>.
glGetCompressedTextureSubImage
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @pixels@.
  -> m ()
glGetCompressedTextureSubImage v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 = liftIO $ dyn327 ptr_glGetCompressedTextureSubImage v1 v2 v3 v4 v5 v6 v7 v8 v9 v10

{-# NOINLINE ptr_glGetCompressedTextureSubImage #-}
ptr_glGetCompressedTextureSubImage :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLsizei -> Ptr a -> IO ())
ptr_glGetCompressedTextureSubImage = unsafePerformIO $ getCommand "glGetCompressedTextureSubImage"

-- glGetConvolutionFilter ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetConvolutionFilter.xml OpenGL 2.x>.
glGetConvolutionFilter
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @image@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetConvolutionFilter v1 v2 v3 v4 = liftIO $ dyn317 ptr_glGetConvolutionFilter v1 v2 v3 v4

{-# NOINLINE ptr_glGetConvolutionFilter #-}
ptr_glGetConvolutionFilter :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetConvolutionFilter = unsafePerformIO $ getCommand "glGetConvolutionFilter"

-- glGetConvolutionFilterEXT ---------------------------------------------------

glGetConvolutionFilterEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ConvolutionTargetEXT](Graphics-GL-Groups.html#ConvolutionTargetEXT).
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @image@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetConvolutionFilterEXT v1 v2 v3 v4 = liftIO $ dyn317 ptr_glGetConvolutionFilterEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetConvolutionFilterEXT #-}
ptr_glGetConvolutionFilterEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetConvolutionFilterEXT = unsafePerformIO $ getCommand "glGetConvolutionFilterEXT"

-- glGetConvolutionParameterfv -------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetConvolutionParameter.xml OpenGL 2.x>.
glGetConvolutionParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @pname@ of type @GetConvolutionParameterPName@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetConvolutionParameterfv v1 v2 v3 = liftIO $ dyn132 ptr_glGetConvolutionParameterfv v1 v2 v3

{-# NOINLINE ptr_glGetConvolutionParameterfv #-}
ptr_glGetConvolutionParameterfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetConvolutionParameterfv = unsafePerformIO $ getCommand "glGetConvolutionParameterfv"

-- glGetConvolutionParameterfvEXT ----------------------------------------------

glGetConvolutionParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ConvolutionTargetEXT](Graphics-GL-Groups.html#ConvolutionTargetEXT).
  -> GLenum -- ^ @pname@ of type [ConvolutionParameterEXT](Graphics-GL-Groups.html#ConvolutionParameterEXT).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetConvolutionParameterfvEXT v1 v2 v3 = liftIO $ dyn132 ptr_glGetConvolutionParameterfvEXT v1 v2 v3

{-# NOINLINE ptr_glGetConvolutionParameterfvEXT #-}
ptr_glGetConvolutionParameterfvEXT :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetConvolutionParameterfvEXT = unsafePerformIO $ getCommand "glGetConvolutionParameterfvEXT"

-- glGetConvolutionParameteriv -------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetConvolutionParameter.xml OpenGL 2.x>.
glGetConvolutionParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ConvolutionTarget@.
  -> GLenum -- ^ @pname@ of type @GetConvolutionParameterPName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetConvolutionParameteriv v1 v2 v3 = liftIO $ dyn133 ptr_glGetConvolutionParameteriv v1 v2 v3

{-# NOINLINE ptr_glGetConvolutionParameteriv #-}
ptr_glGetConvolutionParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetConvolutionParameteriv = unsafePerformIO $ getCommand "glGetConvolutionParameteriv"

-- glGetConvolutionParameterivEXT ----------------------------------------------

glGetConvolutionParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [ConvolutionTargetEXT](Graphics-GL-Groups.html#ConvolutionTargetEXT).
  -> GLenum -- ^ @pname@ of type [ConvolutionParameterEXT](Graphics-GL-Groups.html#ConvolutionParameterEXT).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetConvolutionParameterivEXT v1 v2 v3 = liftIO $ dyn133 ptr_glGetConvolutionParameterivEXT v1 v2 v3

{-# NOINLINE ptr_glGetConvolutionParameterivEXT #-}
ptr_glGetConvolutionParameterivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetConvolutionParameterivEXT = unsafePerformIO $ getCommand "glGetConvolutionParameterivEXT"

-- glGetConvolutionParameterxvOES ----------------------------------------------

glGetConvolutionParameterxvOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetConvolutionParameterxvOES v1 v2 v3 = liftIO $ dyn163 ptr_glGetConvolutionParameterxvOES v1 v2 v3

{-# NOINLINE ptr_glGetConvolutionParameterxvOES #-}
ptr_glGetConvolutionParameterxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetConvolutionParameterxvOES = unsafePerformIO $ getCommand "glGetConvolutionParameterxvOES"

-- glGetCoverageModulationTableNV ----------------------------------------------

glGetCoverageModulationTableNV
  :: MonadIO m
  => GLsizei -- ^ @bufsize@.
  -> Ptr GLfloat -- ^ @v@.
  -> m ()
glGetCoverageModulationTableNV v1 v2 = liftIO $ dyn192 ptr_glGetCoverageModulationTableNV v1 v2

{-# NOINLINE ptr_glGetCoverageModulationTableNV #-}
ptr_glGetCoverageModulationTableNV :: FunPtr (GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetCoverageModulationTableNV = unsafePerformIO $ getCommand "glGetCoverageModulationTableNV"

-- glGetDebugMessageLog --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetDebugMessageLog.xhtml OpenGL 4.x>.
glGetDebugMessageLog
  :: MonadIO m
  => GLuint -- ^ @count@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLenum -- ^ @sources@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLenum -- ^ @types@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLuint -- ^ @ids@ pointing to @count@ elements of type @GLuint@.
  -> Ptr GLenum -- ^ @severities@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLsizei -- ^ @lengths@ pointing to @count@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @messageLog@ pointing to @bufSize@ elements of type @GLchar@.
  -> m GLuint
glGetDebugMessageLog v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn328 ptr_glGetDebugMessageLog v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glGetDebugMessageLog #-}
ptr_glGetDebugMessageLog :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> Ptr GLenum -> Ptr GLuint -> Ptr GLenum -> Ptr GLsizei -> Ptr GLchar -> IO GLuint)
ptr_glGetDebugMessageLog = unsafePerformIO $ getCommand "glGetDebugMessageLog"

-- glGetDebugMessageLogAMD -----------------------------------------------------

glGetDebugMessageLogAMD
  :: MonadIO m
  => GLuint -- ^ @count@.
  -> GLsizei -- ^ @bufsize@.
  -> Ptr GLenum -- ^ @categories@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLuint -- ^ @severities@ pointing to @count@ elements of type @GLuint@.
  -> Ptr GLuint -- ^ @ids@ pointing to @count@ elements of type @GLuint@.
  -> Ptr GLsizei -- ^ @lengths@ pointing to @count@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @message@ pointing to @bufsize@ elements of type @GLchar@.
  -> m GLuint
glGetDebugMessageLogAMD v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn329 ptr_glGetDebugMessageLogAMD v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glGetDebugMessageLogAMD #-}
ptr_glGetDebugMessageLogAMD :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> Ptr GLuint -> Ptr GLuint -> Ptr GLsizei -> Ptr GLchar -> IO GLuint)
ptr_glGetDebugMessageLogAMD = unsafePerformIO $ getCommand "glGetDebugMessageLogAMD"

-- glGetDebugMessageLogARB -----------------------------------------------------

-- | This command is an alias for 'glGetDebugMessageLog'.
glGetDebugMessageLogARB
  :: MonadIO m
  => GLuint -- ^ @count@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLenum -- ^ @sources@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLenum -- ^ @types@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLuint -- ^ @ids@ pointing to @count@ elements of type @GLuint@.
  -> Ptr GLenum -- ^ @severities@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLsizei -- ^ @lengths@ pointing to @count@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @messageLog@ pointing to @bufSize@ elements of type @GLchar@.
  -> m GLuint
glGetDebugMessageLogARB v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn328 ptr_glGetDebugMessageLogARB v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glGetDebugMessageLogARB #-}
ptr_glGetDebugMessageLogARB :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> Ptr GLenum -> Ptr GLuint -> Ptr GLenum -> Ptr GLsizei -> Ptr GLchar -> IO GLuint)
ptr_glGetDebugMessageLogARB = unsafePerformIO $ getCommand "glGetDebugMessageLogARB"

-- glGetDebugMessageLogKHR -----------------------------------------------------

-- | This command is an alias for 'glGetDebugMessageLog'.
glGetDebugMessageLogKHR
  :: MonadIO m
  => GLuint -- ^ @count@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLenum -- ^ @sources@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLenum -- ^ @types@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLuint -- ^ @ids@ pointing to @count@ elements of type @GLuint@.
  -> Ptr GLenum -- ^ @severities@ pointing to @count@ elements of type @GLenum@.
  -> Ptr GLsizei -- ^ @lengths@ pointing to @count@ elements of type @GLsizei@.
  -> Ptr GLchar -- ^ @messageLog@ pointing to @bufSize@ elements of type @GLchar@.
  -> m GLuint
glGetDebugMessageLogKHR v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn328 ptr_glGetDebugMessageLogKHR v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glGetDebugMessageLogKHR #-}
ptr_glGetDebugMessageLogKHR :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> Ptr GLenum -> Ptr GLuint -> Ptr GLenum -> Ptr GLsizei -> Ptr GLchar -> IO GLuint)
ptr_glGetDebugMessageLogKHR = unsafePerformIO $ getCommand "glGetDebugMessageLogKHR"

-- glGetDetailTexFuncSGIS ------------------------------------------------------

glGetDetailTexFuncSGIS
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> Ptr GLfloat -- ^ @points@ pointing to @COMPSIZE(target)@ elements of type @GLfloat@.
  -> m ()
glGetDetailTexFuncSGIS v1 v2 = liftIO $ dyn94 ptr_glGetDetailTexFuncSGIS v1 v2

{-# NOINLINE ptr_glGetDetailTexFuncSGIS #-}
ptr_glGetDetailTexFuncSGIS :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetDetailTexFuncSGIS = unsafePerformIO $ getCommand "glGetDetailTexFuncSGIS"

-- glGetDoubleIndexedvEXT ------------------------------------------------------

-- | This command is an alias for 'glGetDoublei_v'.
glGetDoubleIndexedvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr GLdouble -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLdouble@.
  -> m ()
glGetDoubleIndexedvEXT v1 v2 v3 = liftIO $ dyn330 ptr_glGetDoubleIndexedvEXT v1 v2 v3

{-# NOINLINE ptr_glGetDoubleIndexedvEXT #-}
ptr_glGetDoubleIndexedvEXT :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
ptr_glGetDoubleIndexedvEXT = unsafePerformIO $ getCommand "glGetDoubleIndexedvEXT"

-- glGetDoublei_v --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>.
glGetDoublei_v
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLdouble -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLdouble@.
  -> m ()
glGetDoublei_v v1 v2 v3 = liftIO $ dyn330 ptr_glGetDoublei_v v1 v2 v3

{-# NOINLINE ptr_glGetDoublei_v #-}
ptr_glGetDoublei_v :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
ptr_glGetDoublei_v = unsafePerformIO $ getCommand "glGetDoublei_v"

-- glGetDoublei_vEXT -----------------------------------------------------------

-- | This command is an alias for 'glGetDoublei_v'.
glGetDoublei_vEXT
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr GLdouble -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLdouble@.
  -> m ()
glGetDoublei_vEXT v1 v2 v3 = liftIO $ dyn330 ptr_glGetDoublei_vEXT v1 v2 v3

{-# NOINLINE ptr_glGetDoublei_vEXT #-}
ptr_glGetDoublei_vEXT :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
ptr_glGetDoublei_vEXT = unsafePerformIO $ getCommand "glGetDoublei_vEXT"

-- glGetDoublev ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGet.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>.
glGetDoublev
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [GetPName](Graphics-GL-Groups.html#GetPName).
  -> Ptr GLdouble -- ^ @data@ pointing to @COMPSIZE(pname)@ elements of type @GLdouble@.
  -> m ()
glGetDoublev v1 v2 = liftIO $ dyn93 ptr_glGetDoublev v1 v2

{-# NOINLINE ptr_glGetDoublev #-}
ptr_glGetDoublev :: FunPtr (GLenum -> Ptr GLdouble -> IO ())
ptr_glGetDoublev = unsafePerformIO $ getCommand "glGetDoublev"

-- glGetDriverControlStringQCOM ------------------------------------------------

glGetDriverControlStringQCOM
  :: MonadIO m
  => GLuint -- ^ @driverControl@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@.
  -> Ptr GLchar -- ^ @driverControlString@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetDriverControlStringQCOM v1 v2 v3 v4 = liftIO $ dyn331 ptr_glGetDriverControlStringQCOM v1 v2 v3 v4

{-# NOINLINE ptr_glGetDriverControlStringQCOM #-}
ptr_glGetDriverControlStringQCOM :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetDriverControlStringQCOM = unsafePerformIO $ getCommand "glGetDriverControlStringQCOM"

-- glGetDriverControlsQCOM -----------------------------------------------------

glGetDriverControlsQCOM
  :: MonadIO m
  => Ptr GLint -- ^ @num@.
  -> GLsizei -- ^ @size@.
  -> Ptr GLuint -- ^ @driverControls@ pointing to @size@ elements of type @GLuint@.
  -> m ()
glGetDriverControlsQCOM v1 v2 v3 = liftIO $ dyn332 ptr_glGetDriverControlsQCOM v1 v2 v3

{-# NOINLINE ptr_glGetDriverControlsQCOM #-}
ptr_glGetDriverControlsQCOM :: FunPtr (Ptr GLint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glGetDriverControlsQCOM = unsafePerformIO $ getCommand "glGetDriverControlsQCOM"

-- glGetError ------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetError.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetError.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetError.xhtml OpenGL 4.x>.
glGetError
  :: MonadIO m
  => m GLenum -- ^ of type [ErrorCode](Graphics-GL-Groups.html#ErrorCode).
glGetError = liftIO $ dyn333 ptr_glGetError

{-# NOINLINE ptr_glGetError #-}
ptr_glGetError :: FunPtr (IO GLenum)
ptr_glGetError = unsafePerformIO $ getCommand "glGetError"

-- glGetFenceivNV --------------------------------------------------------------

glGetFenceivNV
  :: MonadIO m
  => GLuint -- ^ @fence@ of type @FenceNV@.
  -> GLenum -- ^ @pname@ of type @FenceParameterNameNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFenceivNV v1 v2 v3 = liftIO $ dyn334 ptr_glGetFenceivNV v1 v2 v3

{-# NOINLINE ptr_glGetFenceivNV #-}
ptr_glGetFenceivNV :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFenceivNV = unsafePerformIO $ getCommand "glGetFenceivNV"

-- glGetFinalCombinerInputParameterfvNV ----------------------------------------

glGetFinalCombinerInputParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @variable@ of type @CombinerVariableNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetFinalCombinerInputParameterfvNV v1 v2 v3 = liftIO $ dyn132 ptr_glGetFinalCombinerInputParameterfvNV v1 v2 v3

{-# NOINLINE ptr_glGetFinalCombinerInputParameterfvNV #-}
ptr_glGetFinalCombinerInputParameterfvNV :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetFinalCombinerInputParameterfvNV = unsafePerformIO $ getCommand "glGetFinalCombinerInputParameterfvNV"

-- glGetFinalCombinerInputParameterivNV ----------------------------------------

glGetFinalCombinerInputParameterivNV
  :: MonadIO m
  => GLenum -- ^ @variable@ of type @CombinerVariableNV@.
  -> GLenum -- ^ @pname@ of type @CombinerParameterNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFinalCombinerInputParameterivNV v1 v2 v3 = liftIO $ dyn133 ptr_glGetFinalCombinerInputParameterivNV v1 v2 v3

{-# NOINLINE ptr_glGetFinalCombinerInputParameterivNV #-}
ptr_glGetFinalCombinerInputParameterivNV :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFinalCombinerInputParameterivNV = unsafePerformIO $ getCommand "glGetFinalCombinerInputParameterivNV"

-- glGetFirstPerfQueryIdINTEL --------------------------------------------------

glGetFirstPerfQueryIdINTEL
  :: MonadIO m
  => Ptr GLuint -- ^ @queryId@.
  -> m ()
glGetFirstPerfQueryIdINTEL v1 = liftIO $ dyn103 ptr_glGetFirstPerfQueryIdINTEL v1

{-# NOINLINE ptr_glGetFirstPerfQueryIdINTEL #-}
ptr_glGetFirstPerfQueryIdINTEL :: FunPtr (Ptr GLuint -> IO ())
ptr_glGetFirstPerfQueryIdINTEL = unsafePerformIO $ getCommand "glGetFirstPerfQueryIdINTEL"

-- glGetFixedv -----------------------------------------------------------------

glGetFixedv
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@.
  -> m ()
glGetFixedv v1 v2 = liftIO $ dyn95 ptr_glGetFixedv v1 v2

{-# NOINLINE ptr_glGetFixedv #-}
ptr_glGetFixedv :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glGetFixedv = unsafePerformIO $ getCommand "glGetFixedv"

-- glGetFixedvOES --------------------------------------------------------------

glGetFixedvOES
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetFixedvOES v1 v2 = liftIO $ dyn95 ptr_glGetFixedvOES v1 v2

{-# NOINLINE ptr_glGetFixedvOES #-}
ptr_glGetFixedvOES :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glGetFixedvOES = unsafePerformIO $ getCommand "glGetFixedvOES"

-- glGetFloatIndexedvEXT -------------------------------------------------------

-- | This command is an alias for 'glGetFloati_v'.
glGetFloatIndexedvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLfloat@.
  -> m ()
glGetFloatIndexedvEXT v1 v2 v3 = liftIO $ dyn267 ptr_glGetFloatIndexedvEXT v1 v2 v3

{-# NOINLINE ptr_glGetFloatIndexedvEXT #-}
ptr_glGetFloatIndexedvEXT :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetFloatIndexedvEXT = unsafePerformIO $ getCommand "glGetFloatIndexedvEXT"

-- glGetFloati_v ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>.
glGetFloati_v
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLfloat@.
  -> m ()
glGetFloati_v v1 v2 v3 = liftIO $ dyn267 ptr_glGetFloati_v v1 v2 v3

{-# NOINLINE ptr_glGetFloati_v #-}
ptr_glGetFloati_v :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetFloati_v = unsafePerformIO $ getCommand "glGetFloati_v"

-- glGetFloati_vEXT ------------------------------------------------------------

-- | This command is an alias for 'glGetFloati_v'.
glGetFloati_vEXT
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetFloati_vEXT v1 v2 v3 = liftIO $ dyn267 ptr_glGetFloati_vEXT v1 v2 v3

{-# NOINLINE ptr_glGetFloati_vEXT #-}
ptr_glGetFloati_vEXT :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetFloati_vEXT = unsafePerformIO $ getCommand "glGetFloati_vEXT"

-- glGetFloati_vNV -------------------------------------------------------------

-- | This command is an alias for 'glGetFloati_v'.
glGetFloati_vNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLfloat@.
  -> m ()
glGetFloati_vNV v1 v2 v3 = liftIO $ dyn267 ptr_glGetFloati_vNV v1 v2 v3

{-# NOINLINE ptr_glGetFloati_vNV #-}
ptr_glGetFloati_vNV :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetFloati_vNV = unsafePerformIO $ getCommand "glGetFloati_vNV"

-- glGetFloatv -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGet.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>.
glGetFloatv
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [GetPName](Graphics-GL-Groups.html#GetPName).
  -> Ptr GLfloat -- ^ @data@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetFloatv v1 v2 = liftIO $ dyn94 ptr_glGetFloatv v1 v2

{-# NOINLINE ptr_glGetFloatv #-}
ptr_glGetFloatv :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetFloatv = unsafePerformIO $ getCommand "glGetFloatv"

-- glGetFogFuncSGIS ------------------------------------------------------------

glGetFogFuncSGIS
  :: MonadIO m
  => Ptr GLfloat -- ^ @points@ pointing to @COMPSIZE()@ elements of type @GLfloat@.
  -> m ()
glGetFogFuncSGIS v1 = liftIO $ dyn41 ptr_glGetFogFuncSGIS v1

{-# NOINLINE ptr_glGetFogFuncSGIS #-}
ptr_glGetFogFuncSGIS :: FunPtr (Ptr GLfloat -> IO ())
ptr_glGetFogFuncSGIS = unsafePerformIO $ getCommand "glGetFogFuncSGIS"

-- glGetFragDataIndex ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetFragDataIndex.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetFragDataIndex.xhtml OpenGL 4.x>.
glGetFragDataIndex
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> Ptr GLchar -- ^ @name@.
  -> m GLint
glGetFragDataIndex v1 v2 = liftIO $ dyn310 ptr_glGetFragDataIndex v1 v2

{-# NOINLINE ptr_glGetFragDataIndex #-}
ptr_glGetFragDataIndex :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
ptr_glGetFragDataIndex = unsafePerformIO $ getCommand "glGetFragDataIndex"

-- glGetFragDataIndexEXT -------------------------------------------------------

-- | This command is an alias for 'glGetFragDataIndex'.
glGetFragDataIndexEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> Ptr GLchar -- ^ @name@.
  -> m GLint
glGetFragDataIndexEXT v1 v2 = liftIO $ dyn310 ptr_glGetFragDataIndexEXT v1 v2

{-# NOINLINE ptr_glGetFragDataIndexEXT #-}
ptr_glGetFragDataIndexEXT :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
ptr_glGetFragDataIndexEXT = unsafePerformIO $ getCommand "glGetFragDataIndexEXT"

-- glGetFragDataLocation -------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetFragDataLocation.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetFragDataLocation.xhtml OpenGL 4.x>.
glGetFragDataLocation
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m GLint
glGetFragDataLocation v1 v2 = liftIO $ dyn310 ptr_glGetFragDataLocation v1 v2

{-# NOINLINE ptr_glGetFragDataLocation #-}
ptr_glGetFragDataLocation :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
ptr_glGetFragDataLocation = unsafePerformIO $ getCommand "glGetFragDataLocation"

-- glGetFragDataLocationEXT ----------------------------------------------------

-- | This command is an alias for 'glGetFragDataLocation'.
glGetFragDataLocationEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m GLint
glGetFragDataLocationEXT v1 v2 = liftIO $ dyn310 ptr_glGetFragDataLocationEXT v1 v2

{-# NOINLINE ptr_glGetFragDataLocationEXT #-}
ptr_glGetFragDataLocationEXT :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
ptr_glGetFragDataLocationEXT = unsafePerformIO $ getCommand "glGetFragDataLocationEXT"

-- glGetFragmentLightfvSGIX ----------------------------------------------------

glGetFragmentLightfvSGIX
  :: MonadIO m
  => GLenum -- ^ @light@ of type @FragmentLightNameSGIX@.
  -> GLenum -- ^ @pname@ of type @FragmentLightParameterSGIX@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetFragmentLightfvSGIX v1 v2 v3 = liftIO $ dyn132 ptr_glGetFragmentLightfvSGIX v1 v2 v3

{-# NOINLINE ptr_glGetFragmentLightfvSGIX #-}
ptr_glGetFragmentLightfvSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetFragmentLightfvSGIX = unsafePerformIO $ getCommand "glGetFragmentLightfvSGIX"

-- glGetFragmentLightivSGIX ----------------------------------------------------

glGetFragmentLightivSGIX
  :: MonadIO m
  => GLenum -- ^ @light@ of type @FragmentLightNameSGIX@.
  -> GLenum -- ^ @pname@ of type @FragmentLightParameterSGIX@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFragmentLightivSGIX v1 v2 v3 = liftIO $ dyn133 ptr_glGetFragmentLightivSGIX v1 v2 v3

{-# NOINLINE ptr_glGetFragmentLightivSGIX #-}
ptr_glGetFragmentLightivSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFragmentLightivSGIX = unsafePerformIO $ getCommand "glGetFragmentLightivSGIX"

-- glGetFragmentMaterialfvSGIX -------------------------------------------------

glGetFragmentMaterialfvSGIX
  :: MonadIO m
  => GLenum -- ^ @face@ of type [MaterialFace](Graphics-GL-Groups.html#MaterialFace).
  -> GLenum -- ^ @pname@ of type [MaterialParameter](Graphics-GL-Groups.html#MaterialParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetFragmentMaterialfvSGIX v1 v2 v3 = liftIO $ dyn132 ptr_glGetFragmentMaterialfvSGIX v1 v2 v3

{-# NOINLINE ptr_glGetFragmentMaterialfvSGIX #-}
ptr_glGetFragmentMaterialfvSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetFragmentMaterialfvSGIX = unsafePerformIO $ getCommand "glGetFragmentMaterialfvSGIX"

-- glGetFragmentMaterialivSGIX -------------------------------------------------

glGetFragmentMaterialivSGIX
  :: MonadIO m
  => GLenum -- ^ @face@ of type [MaterialFace](Graphics-GL-Groups.html#MaterialFace).
  -> GLenum -- ^ @pname@ of type [MaterialParameter](Graphics-GL-Groups.html#MaterialParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFragmentMaterialivSGIX v1 v2 v3 = liftIO $ dyn133 ptr_glGetFragmentMaterialivSGIX v1 v2 v3

{-# NOINLINE ptr_glGetFragmentMaterialivSGIX #-}
ptr_glGetFragmentMaterialivSGIX :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFragmentMaterialivSGIX = unsafePerformIO $ getCommand "glGetFragmentMaterialivSGIX"

-- glGetFramebufferAttachmentParameteriv ---------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetFramebufferAttachmentParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetFramebufferAttachmentParameter.xhtml OpenGL 4.x>.
glGetFramebufferAttachmentParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFramebufferAttachmentParameteriv v1 v2 v3 v4 = liftIO $ dyn321 ptr_glGetFramebufferAttachmentParameteriv v1 v2 v3 v4

{-# NOINLINE ptr_glGetFramebufferAttachmentParameteriv #-}
ptr_glGetFramebufferAttachmentParameteriv :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFramebufferAttachmentParameteriv = unsafePerformIO $ getCommand "glGetFramebufferAttachmentParameteriv"

-- glGetFramebufferAttachmentParameterivEXT ------------------------------------

-- | This command is an alias for 'glGetFramebufferAttachmentParameteriv'.
glGetFramebufferAttachmentParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @FramebufferTarget@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFramebufferAttachmentParameterivEXT v1 v2 v3 v4 = liftIO $ dyn321 ptr_glGetFramebufferAttachmentParameterivEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetFramebufferAttachmentParameterivEXT #-}
ptr_glGetFramebufferAttachmentParameterivEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFramebufferAttachmentParameterivEXT = unsafePerformIO $ getCommand "glGetFramebufferAttachmentParameterivEXT"

-- glGetFramebufferAttachmentParameterivOES ------------------------------------

glGetFramebufferAttachmentParameterivOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFramebufferAttachmentParameterivOES v1 v2 v3 v4 = liftIO $ dyn321 ptr_glGetFramebufferAttachmentParameterivOES v1 v2 v3 v4

{-# NOINLINE ptr_glGetFramebufferAttachmentParameterivOES #-}
ptr_glGetFramebufferAttachmentParameterivOES :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFramebufferAttachmentParameterivOES = unsafePerformIO $ getCommand "glGetFramebufferAttachmentParameterivOES"

-- glGetFramebufferParameteriv -------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetFramebufferParameter.xhtml OpenGL 4.x>.
glGetFramebufferParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFramebufferParameteriv v1 v2 v3 = liftIO $ dyn133 ptr_glGetFramebufferParameteriv v1 v2 v3

{-# NOINLINE ptr_glGetFramebufferParameteriv #-}
ptr_glGetFramebufferParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFramebufferParameteriv = unsafePerformIO $ getCommand "glGetFramebufferParameteriv"

-- glGetFramebufferParameterivEXT ----------------------------------------------

glGetFramebufferParameterivEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@ of type @Framebuffer@.
  -> GLenum -- ^ @pname@ of type @GetFramebufferParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetFramebufferParameterivEXT v1 v2 v3 = liftIO $ dyn334 ptr_glGetFramebufferParameterivEXT v1 v2 v3

{-# NOINLINE ptr_glGetFramebufferParameterivEXT #-}
ptr_glGetFramebufferParameterivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetFramebufferParameterivEXT = unsafePerformIO $ getCommand "glGetFramebufferParameterivEXT"

-- glGetFramebufferPixelLocalStorageSizeEXT ------------------------------------

glGetFramebufferPixelLocalStorageSizeEXT
  :: MonadIO m
  => GLuint -- ^ @target@.
  -> m GLsizei
glGetFramebufferPixelLocalStorageSizeEXT v1 = liftIO $ dyn335 ptr_glGetFramebufferPixelLocalStorageSizeEXT v1

{-# NOINLINE ptr_glGetFramebufferPixelLocalStorageSizeEXT #-}
ptr_glGetFramebufferPixelLocalStorageSizeEXT :: FunPtr (GLuint -> IO GLsizei)
ptr_glGetFramebufferPixelLocalStorageSizeEXT = unsafePerformIO $ getCommand "glGetFramebufferPixelLocalStorageSizeEXT"

-- glGetGraphicsResetStatus ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetGraphicsResetStatus.xhtml OpenGL 4.x>.
glGetGraphicsResetStatus
  :: MonadIO m
  => m GLenum
glGetGraphicsResetStatus = liftIO $ dyn333 ptr_glGetGraphicsResetStatus

{-# NOINLINE ptr_glGetGraphicsResetStatus #-}
ptr_glGetGraphicsResetStatus :: FunPtr (IO GLenum)
ptr_glGetGraphicsResetStatus = unsafePerformIO $ getCommand "glGetGraphicsResetStatus"

-- glGetGraphicsResetStatusARB -------------------------------------------------

glGetGraphicsResetStatusARB
  :: MonadIO m
  => m GLenum
glGetGraphicsResetStatusARB = liftIO $ dyn333 ptr_glGetGraphicsResetStatusARB

{-# NOINLINE ptr_glGetGraphicsResetStatusARB #-}
ptr_glGetGraphicsResetStatusARB :: FunPtr (IO GLenum)
ptr_glGetGraphicsResetStatusARB = unsafePerformIO $ getCommand "glGetGraphicsResetStatusARB"

-- glGetGraphicsResetStatusEXT -------------------------------------------------

glGetGraphicsResetStatusEXT
  :: MonadIO m
  => m GLenum
glGetGraphicsResetStatusEXT = liftIO $ dyn333 ptr_glGetGraphicsResetStatusEXT

{-# NOINLINE ptr_glGetGraphicsResetStatusEXT #-}
ptr_glGetGraphicsResetStatusEXT :: FunPtr (IO GLenum)
ptr_glGetGraphicsResetStatusEXT = unsafePerformIO $ getCommand "glGetGraphicsResetStatusEXT"

-- glGetGraphicsResetStatusKHR -------------------------------------------------

-- | This command is an alias for 'glGetGraphicsResetStatus'.
glGetGraphicsResetStatusKHR
  :: MonadIO m
  => m GLenum
glGetGraphicsResetStatusKHR = liftIO $ dyn333 ptr_glGetGraphicsResetStatusKHR

{-# NOINLINE ptr_glGetGraphicsResetStatusKHR #-}
ptr_glGetGraphicsResetStatusKHR :: FunPtr (IO GLenum)
ptr_glGetGraphicsResetStatusKHR = unsafePerformIO $ getCommand "glGetGraphicsResetStatusKHR"

-- glGetHandleARB --------------------------------------------------------------

glGetHandleARB
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> m GLhandleARB -- ^ of type @handleARB@.
glGetHandleARB v1 = liftIO $ dyn198 ptr_glGetHandleARB v1

{-# NOINLINE ptr_glGetHandleARB #-}
ptr_glGetHandleARB :: FunPtr (GLenum -> IO GLhandleARB)
ptr_glGetHandleARB = unsafePerformIO $ getCommand "glGetHandleARB"

-- glGetHistogram --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetHistogram.xml OpenGL 2.x>.
glGetHistogram
  :: MonadIO m
  => GLenum -- ^ @target@ of type @HistogramTarget@.
  -> GLboolean -- ^ @reset@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @values@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetHistogram v1 v2 v3 v4 v5 = liftIO $ dyn336 ptr_glGetHistogram v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetHistogram #-}
ptr_glGetHistogram :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetHistogram = unsafePerformIO $ getCommand "glGetHistogram"

-- glGetHistogramEXT -----------------------------------------------------------

glGetHistogramEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [HistogramTargetEXT](Graphics-GL-Groups.html#HistogramTargetEXT).
  -> GLboolean -- ^ @reset@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @values@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetHistogramEXT v1 v2 v3 v4 v5 = liftIO $ dyn336 ptr_glGetHistogramEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetHistogramEXT #-}
ptr_glGetHistogramEXT :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetHistogramEXT = unsafePerformIO $ getCommand "glGetHistogramEXT"

-- glGetHistogramParameterfv ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetHistogramParameter.xml OpenGL 2.x>.
glGetHistogramParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @HistogramTarget@.
  -> GLenum -- ^ @pname@ of type @GetHistogramParameterPName@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetHistogramParameterfv v1 v2 v3 = liftIO $ dyn132 ptr_glGetHistogramParameterfv v1 v2 v3

{-# NOINLINE ptr_glGetHistogramParameterfv #-}
ptr_glGetHistogramParameterfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetHistogramParameterfv = unsafePerformIO $ getCommand "glGetHistogramParameterfv"

-- glGetHistogramParameterfvEXT ------------------------------------------------

glGetHistogramParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [HistogramTargetEXT](Graphics-GL-Groups.html#HistogramTargetEXT).
  -> GLenum -- ^ @pname@ of type [GetHistogramParameterPNameEXT](Graphics-GL-Groups.html#GetHistogramParameterPNameEXT).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetHistogramParameterfvEXT v1 v2 v3 = liftIO $ dyn132 ptr_glGetHistogramParameterfvEXT v1 v2 v3

{-# NOINLINE ptr_glGetHistogramParameterfvEXT #-}
ptr_glGetHistogramParameterfvEXT :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetHistogramParameterfvEXT = unsafePerformIO $ getCommand "glGetHistogramParameterfvEXT"

-- glGetHistogramParameteriv ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetHistogramParameter.xml OpenGL 2.x>.
glGetHistogramParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @HistogramTarget@.
  -> GLenum -- ^ @pname@ of type @GetHistogramParameterPName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetHistogramParameteriv v1 v2 v3 = liftIO $ dyn133 ptr_glGetHistogramParameteriv v1 v2 v3

{-# NOINLINE ptr_glGetHistogramParameteriv #-}
ptr_glGetHistogramParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetHistogramParameteriv = unsafePerformIO $ getCommand "glGetHistogramParameteriv"

-- glGetHistogramParameterivEXT ------------------------------------------------

glGetHistogramParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [HistogramTargetEXT](Graphics-GL-Groups.html#HistogramTargetEXT).
  -> GLenum -- ^ @pname@ of type [GetHistogramParameterPNameEXT](Graphics-GL-Groups.html#GetHistogramParameterPNameEXT).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetHistogramParameterivEXT v1 v2 v3 = liftIO $ dyn133 ptr_glGetHistogramParameterivEXT v1 v2 v3

{-# NOINLINE ptr_glGetHistogramParameterivEXT #-}
ptr_glGetHistogramParameterivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetHistogramParameterivEXT = unsafePerformIO $ getCommand "glGetHistogramParameterivEXT"

-- glGetHistogramParameterxvOES ------------------------------------------------

glGetHistogramParameterxvOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetHistogramParameterxvOES v1 v2 v3 = liftIO $ dyn163 ptr_glGetHistogramParameterxvOES v1 v2 v3

{-# NOINLINE ptr_glGetHistogramParameterxvOES #-}
ptr_glGetHistogramParameterxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetHistogramParameterxvOES = unsafePerformIO $ getCommand "glGetHistogramParameterxvOES"

-- glGetImageHandleARB ---------------------------------------------------------

glGetImageHandleARB
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLboolean -- ^ @layered@.
  -> GLint -- ^ @layer@.
  -> GLenum -- ^ @format@.
  -> m GLuint64
glGetImageHandleARB v1 v2 v3 v4 v5 = liftIO $ dyn337 ptr_glGetImageHandleARB v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetImageHandleARB #-}
ptr_glGetImageHandleARB :: FunPtr (GLuint -> GLint -> GLboolean -> GLint -> GLenum -> IO GLuint64)
ptr_glGetImageHandleARB = unsafePerformIO $ getCommand "glGetImageHandleARB"

-- glGetImageHandleNV ----------------------------------------------------------

glGetImageHandleNV
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLboolean -- ^ @layered@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLint -- ^ @layer@.
  -> GLenum -- ^ @format@.
  -> m GLuint64
glGetImageHandleNV v1 v2 v3 v4 v5 = liftIO $ dyn337 ptr_glGetImageHandleNV v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetImageHandleNV #-}
ptr_glGetImageHandleNV :: FunPtr (GLuint -> GLint -> GLboolean -> GLint -> GLenum -> IO GLuint64)
ptr_glGetImageHandleNV = unsafePerformIO $ getCommand "glGetImageHandleNV"

-- glGetImageTransformParameterfvHP --------------------------------------------

glGetImageTransformParameterfvHP
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ImageTransformTargetHP@.
  -> GLenum -- ^ @pname@ of type @ImageTransformPNameHP@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetImageTransformParameterfvHP v1 v2 v3 = liftIO $ dyn132 ptr_glGetImageTransformParameterfvHP v1 v2 v3

{-# NOINLINE ptr_glGetImageTransformParameterfvHP #-}
ptr_glGetImageTransformParameterfvHP :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetImageTransformParameterfvHP = unsafePerformIO $ getCommand "glGetImageTransformParameterfvHP"

-- glGetImageTransformParameterivHP --------------------------------------------

glGetImageTransformParameterivHP
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ImageTransformTargetHP@.
  -> GLenum -- ^ @pname@ of type @ImageTransformPNameHP@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetImageTransformParameterivHP v1 v2 v3 = liftIO $ dyn133 ptr_glGetImageTransformParameterivHP v1 v2 v3

{-# NOINLINE ptr_glGetImageTransformParameterivHP #-}
ptr_glGetImageTransformParameterivHP :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetImageTransformParameterivHP = unsafePerformIO $ getCommand "glGetImageTransformParameterivHP"

-- glGetInfoLogARB -------------------------------------------------------------

glGetInfoLogARB
  :: MonadIO m
  => GLhandleARB -- ^ @obj@ of type @handleARB@.
  -> GLsizei -- ^ @maxLength@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLcharARB -- ^ @infoLog@ pointing to @maxLength@ elements of type @GLcharARB@.
  -> m ()
glGetInfoLogARB v1 v2 v3 v4 = liftIO $ dyn338 ptr_glGetInfoLogARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetInfoLogARB #-}
ptr_glGetInfoLogARB :: FunPtr (GLhandleARB -> GLsizei -> Ptr GLsizei -> Ptr GLcharARB -> IO ())
ptr_glGetInfoLogARB = unsafePerformIO $ getCommand "glGetInfoLogARB"

-- glGetInstrumentsSGIX --------------------------------------------------------

glGetInstrumentsSGIX
  :: MonadIO m
  => m GLint
glGetInstrumentsSGIX = liftIO $ dyn339 ptr_glGetInstrumentsSGIX

{-# NOINLINE ptr_glGetInstrumentsSGIX #-}
ptr_glGetInstrumentsSGIX :: FunPtr (IO GLint)
ptr_glGetInstrumentsSGIX = unsafePerformIO $ getCommand "glGetInstrumentsSGIX"

-- glGetInteger64i_v -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>.
glGetInteger64i_v
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint64 -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLint64@.
  -> m ()
glGetInteger64i_v v1 v2 v3 = liftIO $ dyn340 ptr_glGetInteger64i_v v1 v2 v3

{-# NOINLINE ptr_glGetInteger64i_v #-}
ptr_glGetInteger64i_v :: FunPtr (GLenum -> GLuint -> Ptr GLint64 -> IO ())
ptr_glGetInteger64i_v = unsafePerformIO $ getCommand "glGetInteger64i_v"

-- glGetInteger64v -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>.
glGetInteger64v
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr GLint64 -- ^ @data@ pointing to @COMPSIZE(pname)@ elements of type @GLint64@.
  -> m ()
glGetInteger64v v1 v2 = liftIO $ dyn341 ptr_glGetInteger64v v1 v2

{-# NOINLINE ptr_glGetInteger64v #-}
ptr_glGetInteger64v :: FunPtr (GLenum -> Ptr GLint64 -> IO ())
ptr_glGetInteger64v = unsafePerformIO $ getCommand "glGetInteger64v"

-- glGetInteger64vAPPLE --------------------------------------------------------

-- | This command is an alias for 'glGetInteger64v'.
glGetInteger64vAPPLE
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr GLint64 -- ^ @params@.
  -> m ()
glGetInteger64vAPPLE v1 v2 = liftIO $ dyn341 ptr_glGetInteger64vAPPLE v1 v2

{-# NOINLINE ptr_glGetInteger64vAPPLE #-}
ptr_glGetInteger64vAPPLE :: FunPtr (GLenum -> Ptr GLint64 -> IO ())
ptr_glGetInteger64vAPPLE = unsafePerformIO $ getCommand "glGetInteger64vAPPLE"

-- glGetIntegerIndexedvEXT -----------------------------------------------------

-- | This command is an alias for 'glGetIntegeri_v'.
glGetIntegerIndexedvEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLint@.
  -> m ()
glGetIntegerIndexedvEXT v1 v2 v3 = liftIO $ dyn342 ptr_glGetIntegerIndexedvEXT v1 v2 v3

{-# NOINLINE ptr_glGetIntegerIndexedvEXT #-}
ptr_glGetIntegerIndexedvEXT :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
ptr_glGetIntegerIndexedvEXT = unsafePerformIO $ getCommand "glGetIntegerIndexedvEXT"

-- glGetIntegeri_v -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>.
glGetIntegeri_v
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint -- ^ @data@ pointing to @COMPSIZE(target)@ elements of type @GLint@.
  -> m ()
glGetIntegeri_v v1 v2 v3 = liftIO $ dyn342 ptr_glGetIntegeri_v v1 v2 v3

{-# NOINLINE ptr_glGetIntegeri_v #-}
ptr_glGetIntegeri_v :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
ptr_glGetIntegeri_v = unsafePerformIO $ getCommand "glGetIntegeri_v"

-- glGetIntegeri_vEXT ----------------------------------------------------------

glGetIntegeri_vEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint -- ^ @data@.
  -> m ()
glGetIntegeri_vEXT v1 v2 v3 = liftIO $ dyn342 ptr_glGetIntegeri_vEXT v1 v2 v3

{-# NOINLINE ptr_glGetIntegeri_vEXT #-}
ptr_glGetIntegeri_vEXT :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
ptr_glGetIntegeri_vEXT = unsafePerformIO $ getCommand "glGetIntegeri_vEXT"

-- glGetIntegerui64i_vNV -------------------------------------------------------

glGetIntegerui64i_vNV
  :: MonadIO m
  => GLenum -- ^ @value@.
  -> GLuint -- ^ @index@.
  -> Ptr GLuint64EXT -- ^ @result@ pointing to @COMPSIZE(value)@ elements of type @GLuint64EXT@.
  -> m ()
glGetIntegerui64i_vNV v1 v2 v3 = liftIO $ dyn343 ptr_glGetIntegerui64i_vNV v1 v2 v3

{-# NOINLINE ptr_glGetIntegerui64i_vNV #-}
ptr_glGetIntegerui64i_vNV :: FunPtr (GLenum -> GLuint -> Ptr GLuint64EXT -> IO ())
ptr_glGetIntegerui64i_vNV = unsafePerformIO $ getCommand "glGetIntegerui64i_vNV"

-- glGetIntegerui64vNV ---------------------------------------------------------

glGetIntegerui64vNV
  :: MonadIO m
  => GLenum -- ^ @value@.
  -> Ptr GLuint64EXT -- ^ @result@ pointing to @COMPSIZE(value)@ elements of type @GLuint64EXT@.
  -> m ()
glGetIntegerui64vNV v1 v2 = liftIO $ dyn344 ptr_glGetIntegerui64vNV v1 v2

{-# NOINLINE ptr_glGetIntegerui64vNV #-}
ptr_glGetIntegerui64vNV :: FunPtr (GLenum -> Ptr GLuint64EXT -> IO ())
ptr_glGetIntegerui64vNV = unsafePerformIO $ getCommand "glGetIntegerui64vNV"

-- glGetIntegerv ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGet.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGet.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGet.xhtml OpenGL 4.x>.
glGetIntegerv
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [GetPName](Graphics-GL-Groups.html#GetPName).
  -> Ptr GLint -- ^ @data@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetIntegerv v1 v2 = liftIO $ dyn136 ptr_glGetIntegerv v1 v2

{-# NOINLINE ptr_glGetIntegerv #-}
ptr_glGetIntegerv :: FunPtr (GLenum -> Ptr GLint -> IO ())
ptr_glGetIntegerv = unsafePerformIO $ getCommand "glGetIntegerv"

-- glGetInternalformatSampleivNV -----------------------------------------------

glGetInternalformatSampleivNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @internalformat@.
  -> GLsizei -- ^ @samples@.
  -> GLenum -- ^ @pname@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint -- ^ @params@ pointing to @bufSize@ elements of type @GLint@.
  -> m ()
glGetInternalformatSampleivNV v1 v2 v3 v4 v5 v6 = liftIO $ dyn345 ptr_glGetInternalformatSampleivNV v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetInternalformatSampleivNV #-}
ptr_glGetInternalformatSampleivNV :: FunPtr (GLenum -> GLenum -> GLsizei -> GLenum -> GLsizei -> Ptr GLint -> IO ())
ptr_glGetInternalformatSampleivNV = unsafePerformIO $ getCommand "glGetInternalformatSampleivNV"

-- glGetInternalformati64v -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetInternalformat.xhtml OpenGL 4.x>.
glGetInternalformati64v
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @internalformat@.
  -> GLenum -- ^ @pname@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint64 -- ^ @params@ pointing to @bufSize@ elements of type @GLint64@.
  -> m ()
glGetInternalformati64v v1 v2 v3 v4 v5 = liftIO $ dyn346 ptr_glGetInternalformati64v v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetInternalformati64v #-}
ptr_glGetInternalformati64v :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLint64 -> IO ())
ptr_glGetInternalformati64v = unsafePerformIO $ getCommand "glGetInternalformati64v"

-- glGetInternalformativ -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetInternalformat.xhtml OpenGL 4.x>.
glGetInternalformativ
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @internalformat@.
  -> GLenum -- ^ @pname@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint -- ^ @params@ pointing to @bufSize@ elements of type @GLint@.
  -> m ()
glGetInternalformativ v1 v2 v3 v4 v5 = liftIO $ dyn347 ptr_glGetInternalformativ v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetInternalformativ #-}
ptr_glGetInternalformativ :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr GLint -> IO ())
ptr_glGetInternalformativ = unsafePerformIO $ getCommand "glGetInternalformativ"

-- glGetInvariantBooleanvEXT ---------------------------------------------------

glGetInvariantBooleanvEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLboolean -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glGetInvariantBooleanvEXT v1 v2 v3 = liftIO $ dyn348 ptr_glGetInvariantBooleanvEXT v1 v2 v3

{-# NOINLINE ptr_glGetInvariantBooleanvEXT #-}
ptr_glGetInvariantBooleanvEXT :: FunPtr (GLuint -> GLenum -> Ptr GLboolean -> IO ())
ptr_glGetInvariantBooleanvEXT = unsafePerformIO $ getCommand "glGetInvariantBooleanvEXT"

-- glGetInvariantFloatvEXT -----------------------------------------------------

glGetInvariantFloatvEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLfloat -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type @GLfloat@.
  -> m ()
glGetInvariantFloatvEXT v1 v2 v3 = liftIO $ dyn349 ptr_glGetInvariantFloatvEXT v1 v2 v3

{-# NOINLINE ptr_glGetInvariantFloatvEXT #-}
ptr_glGetInvariantFloatvEXT :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetInvariantFloatvEXT = unsafePerformIO $ getCommand "glGetInvariantFloatvEXT"

-- glGetInvariantIntegervEXT ---------------------------------------------------

glGetInvariantIntegervEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLint -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type @GLint@.
  -> m ()
glGetInvariantIntegervEXT v1 v2 v3 = liftIO $ dyn334 ptr_glGetInvariantIntegervEXT v1 v2 v3

{-# NOINLINE ptr_glGetInvariantIntegervEXT #-}
ptr_glGetInvariantIntegervEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetInvariantIntegervEXT = unsafePerformIO $ getCommand "glGetInvariantIntegervEXT"

-- glGetLightfv ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetLight.xml OpenGL 2.x>.
glGetLightfv
  :: MonadIO m
  => GLenum -- ^ @light@ of type [LightName](Graphics-GL-Groups.html#LightName).
  -> GLenum -- ^ @pname@ of type [LightParameter](Graphics-GL-Groups.html#LightParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetLightfv v1 v2 v3 = liftIO $ dyn132 ptr_glGetLightfv v1 v2 v3

{-# NOINLINE ptr_glGetLightfv #-}
ptr_glGetLightfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetLightfv = unsafePerformIO $ getCommand "glGetLightfv"

-- glGetLightiv ----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetLight.xml OpenGL 2.x>.
glGetLightiv
  :: MonadIO m
  => GLenum -- ^ @light@ of type [LightName](Graphics-GL-Groups.html#LightName).
  -> GLenum -- ^ @pname@ of type [LightParameter](Graphics-GL-Groups.html#LightParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetLightiv v1 v2 v3 = liftIO $ dyn133 ptr_glGetLightiv v1 v2 v3

{-# NOINLINE ptr_glGetLightiv #-}
ptr_glGetLightiv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetLightiv = unsafePerformIO $ getCommand "glGetLightiv"

-- glGetLightxOES --------------------------------------------------------------

glGetLightxOES
  :: MonadIO m
  => GLenum -- ^ @light@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetLightxOES v1 v2 v3 = liftIO $ dyn163 ptr_glGetLightxOES v1 v2 v3

{-# NOINLINE ptr_glGetLightxOES #-}
ptr_glGetLightxOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetLightxOES = unsafePerformIO $ getCommand "glGetLightxOES"

-- glGetLightxv ----------------------------------------------------------------

glGetLightxv
  :: MonadIO m
  => GLenum -- ^ @light@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetLightxv v1 v2 v3 = liftIO $ dyn163 ptr_glGetLightxv v1 v2 v3

{-# NOINLINE ptr_glGetLightxv #-}
ptr_glGetLightxv :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetLightxv = unsafePerformIO $ getCommand "glGetLightxv"

-- glGetLightxvOES -------------------------------------------------------------

glGetLightxvOES
  :: MonadIO m
  => GLenum -- ^ @light@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetLightxvOES v1 v2 v3 = liftIO $ dyn163 ptr_glGetLightxvOES v1 v2 v3

{-# NOINLINE ptr_glGetLightxvOES #-}
ptr_glGetLightxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetLightxvOES = unsafePerformIO $ getCommand "glGetLightxvOES"

-- glGetListParameterfvSGIX ----------------------------------------------------

glGetListParameterfvSGIX
  :: MonadIO m
  => GLuint -- ^ @list@ of type @List@.
  -> GLenum -- ^ @pname@ of type [ListParameterName](Graphics-GL-Groups.html#ListParameterName).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glGetListParameterfvSGIX v1 v2 v3 = liftIO $ dyn349 ptr_glGetListParameterfvSGIX v1 v2 v3

{-# NOINLINE ptr_glGetListParameterfvSGIX #-}
ptr_glGetListParameterfvSGIX :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetListParameterfvSGIX = unsafePerformIO $ getCommand "glGetListParameterfvSGIX"

-- glGetListParameterivSGIX ----------------------------------------------------

glGetListParameterivSGIX
  :: MonadIO m
  => GLuint -- ^ @list@ of type @List@.
  -> GLenum -- ^ @pname@ of type [ListParameterName](Graphics-GL-Groups.html#ListParameterName).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glGetListParameterivSGIX v1 v2 v3 = liftIO $ dyn334 ptr_glGetListParameterivSGIX v1 v2 v3

{-# NOINLINE ptr_glGetListParameterivSGIX #-}
ptr_glGetListParameterivSGIX :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetListParameterivSGIX = unsafePerformIO $ getCommand "glGetListParameterivSGIX"

-- glGetLocalConstantBooleanvEXT -----------------------------------------------

glGetLocalConstantBooleanvEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLboolean -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glGetLocalConstantBooleanvEXT v1 v2 v3 = liftIO $ dyn348 ptr_glGetLocalConstantBooleanvEXT v1 v2 v3

{-# NOINLINE ptr_glGetLocalConstantBooleanvEXT #-}
ptr_glGetLocalConstantBooleanvEXT :: FunPtr (GLuint -> GLenum -> Ptr GLboolean -> IO ())
ptr_glGetLocalConstantBooleanvEXT = unsafePerformIO $ getCommand "glGetLocalConstantBooleanvEXT"

-- glGetLocalConstantFloatvEXT -------------------------------------------------

glGetLocalConstantFloatvEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLfloat -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type @GLfloat@.
  -> m ()
glGetLocalConstantFloatvEXT v1 v2 v3 = liftIO $ dyn349 ptr_glGetLocalConstantFloatvEXT v1 v2 v3

{-# NOINLINE ptr_glGetLocalConstantFloatvEXT #-}
ptr_glGetLocalConstantFloatvEXT :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetLocalConstantFloatvEXT = unsafePerformIO $ getCommand "glGetLocalConstantFloatvEXT"

-- glGetLocalConstantIntegervEXT -----------------------------------------------

glGetLocalConstantIntegervEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLint -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type @GLint@.
  -> m ()
glGetLocalConstantIntegervEXT v1 v2 v3 = liftIO $ dyn334 ptr_glGetLocalConstantIntegervEXT v1 v2 v3

{-# NOINLINE ptr_glGetLocalConstantIntegervEXT #-}
ptr_glGetLocalConstantIntegervEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetLocalConstantIntegervEXT = unsafePerformIO $ getCommand "glGetLocalConstantIntegervEXT"

-- glGetMapAttribParameterfvNV -------------------------------------------------

glGetMapAttribParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @EvalTargetNV@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @MapAttribParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMapAttribParameterfvNV v1 v2 v3 v4 = liftIO $ dyn350 ptr_glGetMapAttribParameterfvNV v1 v2 v3 v4

{-# NOINLINE ptr_glGetMapAttribParameterfvNV #-}
ptr_glGetMapAttribParameterfvNV :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMapAttribParameterfvNV = unsafePerformIO $ getCommand "glGetMapAttribParameterfvNV"

-- glGetMapAttribParameterivNV -------------------------------------------------

glGetMapAttribParameterivNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @EvalTargetNV@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @MapAttribParameterNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMapAttribParameterivNV v1 v2 v3 v4 = liftIO $ dyn351 ptr_glGetMapAttribParameterivNV v1 v2 v3 v4

{-# NOINLINE ptr_glGetMapAttribParameterivNV #-}
ptr_glGetMapAttribParameterivNV :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMapAttribParameterivNV = unsafePerformIO $ getCommand "glGetMapAttribParameterivNV"

-- glGetMapControlPointsNV -----------------------------------------------------

glGetMapControlPointsNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @EvalTargetNV@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @type@ of type @MapTypeNV@.
  -> GLsizei -- ^ @ustride@.
  -> GLsizei -- ^ @vstride@.
  -> GLboolean -- ^ @packed@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> Ptr a -- ^ @points@ pointing to @COMPSIZE(target)@ elements of type @a@.
  -> m ()
glGetMapControlPointsNV v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn352 ptr_glGetMapControlPointsNV v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glGetMapControlPointsNV #-}
ptr_glGetMapControlPointsNV :: FunPtr (GLenum -> GLuint -> GLenum -> GLsizei -> GLsizei -> GLboolean -> Ptr a -> IO ())
ptr_glGetMapControlPointsNV = unsafePerformIO $ getCommand "glGetMapControlPointsNV"

-- glGetMapParameterfvNV -------------------------------------------------------

glGetMapParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @EvalTargetNV@.
  -> GLenum -- ^ @pname@ of type @MapParameterNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(target,pname)@ elements of type @GLfloat@.
  -> m ()
glGetMapParameterfvNV v1 v2 v3 = liftIO $ dyn132 ptr_glGetMapParameterfvNV v1 v2 v3

{-# NOINLINE ptr_glGetMapParameterfvNV #-}
ptr_glGetMapParameterfvNV :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMapParameterfvNV = unsafePerformIO $ getCommand "glGetMapParameterfvNV"

-- glGetMapParameterivNV -------------------------------------------------------

glGetMapParameterivNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @EvalTargetNV@.
  -> GLenum -- ^ @pname@ of type @MapParameterNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(target,pname)@ elements of type @GLint@.
  -> m ()
glGetMapParameterivNV v1 v2 v3 = liftIO $ dyn133 ptr_glGetMapParameterivNV v1 v2 v3

{-# NOINLINE ptr_glGetMapParameterivNV #-}
ptr_glGetMapParameterivNV :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMapParameterivNV = unsafePerformIO $ getCommand "glGetMapParameterivNV"

-- glGetMapdv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMap.xml OpenGL 2.x>.
glGetMapdv
  :: MonadIO m
  => GLenum -- ^ @target@ of type [MapTarget](Graphics-GL-Groups.html#MapTarget).
  -> GLenum -- ^ @query@ of type [GetMapQuery](Graphics-GL-Groups.html#GetMapQuery).
  -> Ptr GLdouble -- ^ @v@ pointing to @COMPSIZE(target,query)@ elements of type @GLdouble@.
  -> m ()
glGetMapdv v1 v2 v3 = liftIO $ dyn353 ptr_glGetMapdv v1 v2 v3

{-# NOINLINE ptr_glGetMapdv #-}
ptr_glGetMapdv :: FunPtr (GLenum -> GLenum -> Ptr GLdouble -> IO ())
ptr_glGetMapdv = unsafePerformIO $ getCommand "glGetMapdv"

-- glGetMapfv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMap.xml OpenGL 2.x>.
glGetMapfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type [MapTarget](Graphics-GL-Groups.html#MapTarget).
  -> GLenum -- ^ @query@ of type [GetMapQuery](Graphics-GL-Groups.html#GetMapQuery).
  -> Ptr GLfloat -- ^ @v@ pointing to @COMPSIZE(target,query)@ elements of type @GLfloat@.
  -> m ()
glGetMapfv v1 v2 v3 = liftIO $ dyn132 ptr_glGetMapfv v1 v2 v3

{-# NOINLINE ptr_glGetMapfv #-}
ptr_glGetMapfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMapfv = unsafePerformIO $ getCommand "glGetMapfv"

-- glGetMapiv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMap.xml OpenGL 2.x>.
glGetMapiv
  :: MonadIO m
  => GLenum -- ^ @target@ of type [MapTarget](Graphics-GL-Groups.html#MapTarget).
  -> GLenum -- ^ @query@ of type [GetMapQuery](Graphics-GL-Groups.html#GetMapQuery).
  -> Ptr GLint -- ^ @v@ pointing to @COMPSIZE(target,query)@ elements of type @GLint@.
  -> m ()
glGetMapiv v1 v2 v3 = liftIO $ dyn133 ptr_glGetMapiv v1 v2 v3

{-# NOINLINE ptr_glGetMapiv #-}
ptr_glGetMapiv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMapiv = unsafePerformIO $ getCommand "glGetMapiv"

-- glGetMapxvOES ---------------------------------------------------------------

glGetMapxvOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @query@.
  -> Ptr GLfixed -- ^ @v@ pointing to @COMPSIZE(query)@ elements of type @GLfixed@.
  -> m ()
glGetMapxvOES v1 v2 v3 = liftIO $ dyn163 ptr_glGetMapxvOES v1 v2 v3

{-# NOINLINE ptr_glGetMapxvOES #-}
ptr_glGetMapxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetMapxvOES = unsafePerformIO $ getCommand "glGetMapxvOES"

-- glGetMaterialfv -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMaterial.xml OpenGL 2.x>.
glGetMaterialfv
  :: MonadIO m
  => GLenum -- ^ @face@ of type [MaterialFace](Graphics-GL-Groups.html#MaterialFace).
  -> GLenum -- ^ @pname@ of type [MaterialParameter](Graphics-GL-Groups.html#MaterialParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMaterialfv v1 v2 v3 = liftIO $ dyn132 ptr_glGetMaterialfv v1 v2 v3

{-# NOINLINE ptr_glGetMaterialfv #-}
ptr_glGetMaterialfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMaterialfv = unsafePerformIO $ getCommand "glGetMaterialfv"

-- glGetMaterialiv -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMaterial.xml OpenGL 2.x>.
glGetMaterialiv
  :: MonadIO m
  => GLenum -- ^ @face@ of type [MaterialFace](Graphics-GL-Groups.html#MaterialFace).
  -> GLenum -- ^ @pname@ of type [MaterialParameter](Graphics-GL-Groups.html#MaterialParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMaterialiv v1 v2 v3 = liftIO $ dyn133 ptr_glGetMaterialiv v1 v2 v3

{-# NOINLINE ptr_glGetMaterialiv #-}
ptr_glGetMaterialiv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMaterialiv = unsafePerformIO $ getCommand "glGetMaterialiv"

-- glGetMaterialxOES -----------------------------------------------------------

glGetMaterialxOES
  :: MonadIO m
  => GLenum -- ^ @face@.
  -> GLenum -- ^ @pname@.
  -> GLfixed -- ^ @param@.
  -> m ()
glGetMaterialxOES v1 v2 v3 = liftIO $ dyn162 ptr_glGetMaterialxOES v1 v2 v3

{-# NOINLINE ptr_glGetMaterialxOES #-}
ptr_glGetMaterialxOES :: FunPtr (GLenum -> GLenum -> GLfixed -> IO ())
ptr_glGetMaterialxOES = unsafePerformIO $ getCommand "glGetMaterialxOES"

-- glGetMaterialxv -------------------------------------------------------------

glGetMaterialxv
  :: MonadIO m
  => GLenum -- ^ @face@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetMaterialxv v1 v2 v3 = liftIO $ dyn163 ptr_glGetMaterialxv v1 v2 v3

{-# NOINLINE ptr_glGetMaterialxv #-}
ptr_glGetMaterialxv :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetMaterialxv = unsafePerformIO $ getCommand "glGetMaterialxv"

-- glGetMaterialxvOES ----------------------------------------------------------

glGetMaterialxvOES
  :: MonadIO m
  => GLenum -- ^ @face@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetMaterialxvOES v1 v2 v3 = liftIO $ dyn163 ptr_glGetMaterialxvOES v1 v2 v3

{-# NOINLINE ptr_glGetMaterialxvOES #-}
ptr_glGetMaterialxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetMaterialxvOES = unsafePerformIO $ getCommand "glGetMaterialxvOES"

-- glGetMinmax -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMinmax.xml OpenGL 2.x>.
glGetMinmax
  :: MonadIO m
  => GLenum -- ^ @target@ of type @MinmaxTarget@.
  -> GLboolean -- ^ @reset@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @values@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetMinmax v1 v2 v3 v4 v5 = liftIO $ dyn336 ptr_glGetMinmax v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetMinmax #-}
ptr_glGetMinmax :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetMinmax = unsafePerformIO $ getCommand "glGetMinmax"

-- glGetMinmaxEXT --------------------------------------------------------------

glGetMinmaxEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [MinmaxTargetEXT](Graphics-GL-Groups.html#MinmaxTargetEXT).
  -> GLboolean -- ^ @reset@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @values@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> m ()
glGetMinmaxEXT v1 v2 v3 v4 v5 = liftIO $ dyn336 ptr_glGetMinmaxEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetMinmaxEXT #-}
ptr_glGetMinmaxEXT :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetMinmaxEXT = unsafePerformIO $ getCommand "glGetMinmaxEXT"

-- glGetMinmaxParameterfv ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMinmaxParameter.xml OpenGL 2.x>.
glGetMinmaxParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @MinmaxTarget@.
  -> GLenum -- ^ @pname@ of type @GetMinmaxParameterPName@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMinmaxParameterfv v1 v2 v3 = liftIO $ dyn132 ptr_glGetMinmaxParameterfv v1 v2 v3

{-# NOINLINE ptr_glGetMinmaxParameterfv #-}
ptr_glGetMinmaxParameterfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMinmaxParameterfv = unsafePerformIO $ getCommand "glGetMinmaxParameterfv"

-- glGetMinmaxParameterfvEXT ---------------------------------------------------

glGetMinmaxParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [MinmaxTargetEXT](Graphics-GL-Groups.html#MinmaxTargetEXT).
  -> GLenum -- ^ @pname@ of type [GetMinmaxParameterPNameEXT](Graphics-GL-Groups.html#GetMinmaxParameterPNameEXT).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMinmaxParameterfvEXT v1 v2 v3 = liftIO $ dyn132 ptr_glGetMinmaxParameterfvEXT v1 v2 v3

{-# NOINLINE ptr_glGetMinmaxParameterfvEXT #-}
ptr_glGetMinmaxParameterfvEXT :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMinmaxParameterfvEXT = unsafePerformIO $ getCommand "glGetMinmaxParameterfvEXT"

-- glGetMinmaxParameteriv ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetMinmaxParameter.xml OpenGL 2.x>.
glGetMinmaxParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @MinmaxTarget@.
  -> GLenum -- ^ @pname@ of type @GetMinmaxParameterPName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMinmaxParameteriv v1 v2 v3 = liftIO $ dyn133 ptr_glGetMinmaxParameteriv v1 v2 v3

{-# NOINLINE ptr_glGetMinmaxParameteriv #-}
ptr_glGetMinmaxParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMinmaxParameteriv = unsafePerformIO $ getCommand "glGetMinmaxParameteriv"

-- glGetMinmaxParameterivEXT ---------------------------------------------------

glGetMinmaxParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [MinmaxTargetEXT](Graphics-GL-Groups.html#MinmaxTargetEXT).
  -> GLenum -- ^ @pname@ of type [GetMinmaxParameterPNameEXT](Graphics-GL-Groups.html#GetMinmaxParameterPNameEXT).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMinmaxParameterivEXT v1 v2 v3 = liftIO $ dyn133 ptr_glGetMinmaxParameterivEXT v1 v2 v3

{-# NOINLINE ptr_glGetMinmaxParameterivEXT #-}
ptr_glGetMinmaxParameterivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMinmaxParameterivEXT = unsafePerformIO $ getCommand "glGetMinmaxParameterivEXT"

-- glGetMultiTexEnvfvEXT -------------------------------------------------------

glGetMultiTexEnvfvEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureEnvTarget](Graphics-GL-Groups.html#TextureEnvTarget).
  -> GLenum -- ^ @pname@ of type [TextureEnvParameter](Graphics-GL-Groups.html#TextureEnvParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMultiTexEnvfvEXT v1 v2 v3 v4 = liftIO $ dyn320 ptr_glGetMultiTexEnvfvEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetMultiTexEnvfvEXT #-}
ptr_glGetMultiTexEnvfvEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMultiTexEnvfvEXT = unsafePerformIO $ getCommand "glGetMultiTexEnvfvEXT"

-- glGetMultiTexEnvivEXT -------------------------------------------------------

glGetMultiTexEnvivEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureEnvTarget](Graphics-GL-Groups.html#TextureEnvTarget).
  -> GLenum -- ^ @pname@ of type [TextureEnvParameter](Graphics-GL-Groups.html#TextureEnvParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMultiTexEnvivEXT v1 v2 v3 v4 = liftIO $ dyn321 ptr_glGetMultiTexEnvivEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetMultiTexEnvivEXT #-}
ptr_glGetMultiTexEnvivEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMultiTexEnvivEXT = unsafePerformIO $ getCommand "glGetMultiTexEnvivEXT"

-- glGetMultiTexGendvEXT -------------------------------------------------------

glGetMultiTexGendvEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @coord@ of type [TextureCoordName](Graphics-GL-Groups.html#TextureCoordName).
  -> GLenum -- ^ @pname@ of type [TextureGenParameter](Graphics-GL-Groups.html#TextureGenParameter).
  -> Ptr GLdouble -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLdouble@.
  -> m ()
glGetMultiTexGendvEXT v1 v2 v3 v4 = liftIO $ dyn354 ptr_glGetMultiTexGendvEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetMultiTexGendvEXT #-}
ptr_glGetMultiTexGendvEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLdouble -> IO ())
ptr_glGetMultiTexGendvEXT = unsafePerformIO $ getCommand "glGetMultiTexGendvEXT"

-- glGetMultiTexGenfvEXT -------------------------------------------------------

glGetMultiTexGenfvEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @coord@ of type [TextureCoordName](Graphics-GL-Groups.html#TextureCoordName).
  -> GLenum -- ^ @pname@ of type [TextureGenParameter](Graphics-GL-Groups.html#TextureGenParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMultiTexGenfvEXT v1 v2 v3 v4 = liftIO $ dyn320 ptr_glGetMultiTexGenfvEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetMultiTexGenfvEXT #-}
ptr_glGetMultiTexGenfvEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMultiTexGenfvEXT = unsafePerformIO $ getCommand "glGetMultiTexGenfvEXT"

-- glGetMultiTexGenivEXT -------------------------------------------------------

glGetMultiTexGenivEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @coord@ of type [TextureCoordName](Graphics-GL-Groups.html#TextureCoordName).
  -> GLenum -- ^ @pname@ of type [TextureGenParameter](Graphics-GL-Groups.html#TextureGenParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMultiTexGenivEXT v1 v2 v3 v4 = liftIO $ dyn321 ptr_glGetMultiTexGenivEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetMultiTexGenivEXT #-}
ptr_glGetMultiTexGenivEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMultiTexGenivEXT = unsafePerformIO $ getCommand "glGetMultiTexGenivEXT"

-- glGetMultiTexImageEXT -------------------------------------------------------

glGetMultiTexImageEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @pixels@ pointing to @COMPSIZE(target,level,format,type)@ elements of type @a@.
  -> m ()
glGetMultiTexImageEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn355 ptr_glGetMultiTexImageEXT v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetMultiTexImageEXT #-}
ptr_glGetMultiTexImageEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetMultiTexImageEXT = unsafePerformIO $ getCommand "glGetMultiTexImageEXT"

-- glGetMultiTexLevelParameterfvEXT --------------------------------------------

glGetMultiTexLevelParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMultiTexLevelParameterfvEXT v1 v2 v3 v4 v5 = liftIO $ dyn356 ptr_glGetMultiTexLevelParameterfvEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetMultiTexLevelParameterfvEXT #-}
ptr_glGetMultiTexLevelParameterfvEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMultiTexLevelParameterfvEXT = unsafePerformIO $ getCommand "glGetMultiTexLevelParameterfvEXT"

-- glGetMultiTexLevelParameterivEXT --------------------------------------------

glGetMultiTexLevelParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMultiTexLevelParameterivEXT v1 v2 v3 v4 v5 = liftIO $ dyn357 ptr_glGetMultiTexLevelParameterivEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetMultiTexLevelParameterivEXT #-}
ptr_glGetMultiTexLevelParameterivEXT :: FunPtr (GLenum -> GLenum -> GLint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMultiTexLevelParameterivEXT = unsafePerformIO $ getCommand "glGetMultiTexLevelParameterivEXT"

-- glGetMultiTexParameterIivEXT ------------------------------------------------

glGetMultiTexParameterIivEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMultiTexParameterIivEXT v1 v2 v3 v4 = liftIO $ dyn321 ptr_glGetMultiTexParameterIivEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetMultiTexParameterIivEXT #-}
ptr_glGetMultiTexParameterIivEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMultiTexParameterIivEXT = unsafePerformIO $ getCommand "glGetMultiTexParameterIivEXT"

-- glGetMultiTexParameterIuivEXT -----------------------------------------------

glGetMultiTexParameterIuivEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetMultiTexParameterIuivEXT v1 v2 v3 v4 = liftIO $ dyn358 ptr_glGetMultiTexParameterIuivEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetMultiTexParameterIuivEXT #-}
ptr_glGetMultiTexParameterIuivEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetMultiTexParameterIuivEXT = unsafePerformIO $ getCommand "glGetMultiTexParameterIuivEXT"

-- glGetMultiTexParameterfvEXT -------------------------------------------------

glGetMultiTexParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMultiTexParameterfvEXT v1 v2 v3 v4 = liftIO $ dyn320 ptr_glGetMultiTexParameterfvEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetMultiTexParameterfvEXT #-}
ptr_glGetMultiTexParameterfvEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetMultiTexParameterfvEXT = unsafePerformIO $ getCommand "glGetMultiTexParameterfvEXT"

-- glGetMultiTexParameterivEXT -------------------------------------------------

glGetMultiTexParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @texunit@ of type @TextureUnit@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetMultiTexParameterivEXT v1 v2 v3 v4 = liftIO $ dyn321 ptr_glGetMultiTexParameterivEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetMultiTexParameterivEXT #-}
ptr_glGetMultiTexParameterivEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetMultiTexParameterivEXT = unsafePerformIO $ getCommand "glGetMultiTexParameterivEXT"

-- glGetMultisamplefv ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetMultisample.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetMultisample.xhtml OpenGL 4.x>.
glGetMultisamplefv
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @val@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetMultisamplefv v1 v2 v3 = liftIO $ dyn267 ptr_glGetMultisamplefv v1 v2 v3

{-# NOINLINE ptr_glGetMultisamplefv #-}
ptr_glGetMultisamplefv :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetMultisamplefv = unsafePerformIO $ getCommand "glGetMultisamplefv"

-- glGetMultisamplefvNV --------------------------------------------------------

-- | This command is an alias for 'glGetMultisamplefv'.
glGetMultisamplefvNV
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @GetMultisamplePNameNV@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @val@ pointing to @2@ elements of type @GLfloat@.
  -> m ()
glGetMultisamplefvNV v1 v2 v3 = liftIO $ dyn267 ptr_glGetMultisamplefvNV v1 v2 v3

{-# NOINLINE ptr_glGetMultisamplefvNV #-}
ptr_glGetMultisamplefvNV :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetMultisamplefvNV = unsafePerformIO $ getCommand "glGetMultisamplefvNV"

-- glGetNamedBufferParameteri64v -----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetBufferParameter.xhtml OpenGL 4.x>.
glGetNamedBufferParameteri64v
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint64 -- ^ @params@.
  -> m ()
glGetNamedBufferParameteri64v v1 v2 v3 = liftIO $ dyn359 ptr_glGetNamedBufferParameteri64v v1 v2 v3

{-# NOINLINE ptr_glGetNamedBufferParameteri64v #-}
ptr_glGetNamedBufferParameteri64v :: FunPtr (GLuint -> GLenum -> Ptr GLint64 -> IO ())
ptr_glGetNamedBufferParameteri64v = unsafePerformIO $ getCommand "glGetNamedBufferParameteri64v"

-- glGetNamedBufferParameteriv -------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetBufferParameter.xhtml OpenGL 4.x>.
glGetNamedBufferParameteriv
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetNamedBufferParameteriv v1 v2 v3 = liftIO $ dyn334 ptr_glGetNamedBufferParameteriv v1 v2 v3

{-# NOINLINE ptr_glGetNamedBufferParameteriv #-}
ptr_glGetNamedBufferParameteriv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedBufferParameteriv = unsafePerformIO $ getCommand "glGetNamedBufferParameteriv"

-- glGetNamedBufferParameterivEXT ----------------------------------------------

glGetNamedBufferParameterivEXT
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@ of type @VertexBufferObjectParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetNamedBufferParameterivEXT v1 v2 v3 = liftIO $ dyn334 ptr_glGetNamedBufferParameterivEXT v1 v2 v3

{-# NOINLINE ptr_glGetNamedBufferParameterivEXT #-}
ptr_glGetNamedBufferParameterivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedBufferParameterivEXT = unsafePerformIO $ getCommand "glGetNamedBufferParameterivEXT"

-- glGetNamedBufferParameterui64vNV --------------------------------------------

glGetNamedBufferParameterui64vNV
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@ of type @VertexBufferObjectParameter@.
  -> Ptr GLuint64EXT -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint64EXT@.
  -> m ()
glGetNamedBufferParameterui64vNV v1 v2 v3 = liftIO $ dyn360 ptr_glGetNamedBufferParameterui64vNV v1 v2 v3

{-# NOINLINE ptr_glGetNamedBufferParameterui64vNV #-}
ptr_glGetNamedBufferParameterui64vNV :: FunPtr (GLuint -> GLenum -> Ptr GLuint64EXT -> IO ())
ptr_glGetNamedBufferParameterui64vNV = unsafePerformIO $ getCommand "glGetNamedBufferParameterui64vNV"

-- glGetNamedBufferPointerv ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetBufferPointerv.xhtml OpenGL 4.x>.
glGetNamedBufferPointerv
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@.
  -> Ptr (Ptr a) -- ^ @params@.
  -> m ()
glGetNamedBufferPointerv v1 v2 v3 = liftIO $ dyn361 ptr_glGetNamedBufferPointerv v1 v2 v3

{-# NOINLINE ptr_glGetNamedBufferPointerv #-}
ptr_glGetNamedBufferPointerv :: FunPtr (GLuint -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetNamedBufferPointerv = unsafePerformIO $ getCommand "glGetNamedBufferPointerv"

-- glGetNamedBufferPointervEXT -------------------------------------------------

glGetNamedBufferPointervEXT
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@ of type @VertexBufferObjectParameter@.
  -> Ptr (Ptr a) -- ^ @params@ pointing to @1@ element of type @Ptr a@.
  -> m ()
glGetNamedBufferPointervEXT v1 v2 v3 = liftIO $ dyn361 ptr_glGetNamedBufferPointervEXT v1 v2 v3

{-# NOINLINE ptr_glGetNamedBufferPointervEXT #-}
ptr_glGetNamedBufferPointervEXT :: FunPtr (GLuint -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetNamedBufferPointervEXT = unsafePerformIO $ getCommand "glGetNamedBufferPointervEXT"

-- glGetNamedBufferSubData -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetBufferSubData.xhtml OpenGL 4.x>.
glGetNamedBufferSubData
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@.
  -> GLsizeiptr -- ^ @size@ of type @BufferSize@.
  -> Ptr a -- ^ @data@.
  -> m ()
glGetNamedBufferSubData v1 v2 v3 v4 = liftIO $ dyn362 ptr_glGetNamedBufferSubData v1 v2 v3 v4

{-# NOINLINE ptr_glGetNamedBufferSubData #-}
ptr_glGetNamedBufferSubData :: FunPtr (GLuint -> GLintptr -> GLsizeiptr -> Ptr a -> IO ())
ptr_glGetNamedBufferSubData = unsafePerformIO $ getCommand "glGetNamedBufferSubData"

-- glGetNamedBufferSubDataEXT --------------------------------------------------

glGetNamedBufferSubDataEXT
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@.
  -> GLsizeiptr -- ^ @size@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(size)@ elements of type @a@.
  -> m ()
glGetNamedBufferSubDataEXT v1 v2 v3 v4 = liftIO $ dyn362 ptr_glGetNamedBufferSubDataEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetNamedBufferSubDataEXT #-}
ptr_glGetNamedBufferSubDataEXT :: FunPtr (GLuint -> GLintptr -> GLsizeiptr -> Ptr a -> IO ())
ptr_glGetNamedBufferSubDataEXT = unsafePerformIO $ getCommand "glGetNamedBufferSubDataEXT"

-- glGetNamedFramebufferAttachmentParameteriv ----------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetFramebufferAttachmentParameter.xhtml OpenGL 4.x>.
glGetNamedFramebufferAttachmentParameteriv
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLenum -- ^ @attachment@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetNamedFramebufferAttachmentParameteriv v1 v2 v3 v4 = liftIO $ dyn363 ptr_glGetNamedFramebufferAttachmentParameteriv v1 v2 v3 v4

{-# NOINLINE ptr_glGetNamedFramebufferAttachmentParameteriv #-}
ptr_glGetNamedFramebufferAttachmentParameteriv :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedFramebufferAttachmentParameteriv = unsafePerformIO $ getCommand "glGetNamedFramebufferAttachmentParameteriv"

-- glGetNamedFramebufferAttachmentParameterivEXT -------------------------------

glGetNamedFramebufferAttachmentParameterivEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@ of type @Framebuffer@.
  -> GLenum -- ^ @attachment@ of type @FramebufferAttachment@.
  -> GLenum -- ^ @pname@ of type @FramebufferAttachmentParameterName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetNamedFramebufferAttachmentParameterivEXT v1 v2 v3 v4 = liftIO $ dyn363 ptr_glGetNamedFramebufferAttachmentParameterivEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetNamedFramebufferAttachmentParameterivEXT #-}
ptr_glGetNamedFramebufferAttachmentParameterivEXT :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedFramebufferAttachmentParameterivEXT = unsafePerformIO $ getCommand "glGetNamedFramebufferAttachmentParameterivEXT"

-- glGetNamedFramebufferParameteriv --------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetFramebufferParameter.xhtml OpenGL 4.x>.
glGetNamedFramebufferParameteriv
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @param@.
  -> m ()
glGetNamedFramebufferParameteriv v1 v2 v3 = liftIO $ dyn334 ptr_glGetNamedFramebufferParameteriv v1 v2 v3

{-# NOINLINE ptr_glGetNamedFramebufferParameteriv #-}
ptr_glGetNamedFramebufferParameteriv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedFramebufferParameteriv = unsafePerformIO $ getCommand "glGetNamedFramebufferParameteriv"

-- glGetNamedFramebufferParameterivEXT -----------------------------------------

glGetNamedFramebufferParameterivEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@ of type @Framebuffer@.
  -> GLenum -- ^ @pname@ of type @GetFramebufferParameter@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetNamedFramebufferParameterivEXT v1 v2 v3 = liftIO $ dyn334 ptr_glGetNamedFramebufferParameterivEXT v1 v2 v3

{-# NOINLINE ptr_glGetNamedFramebufferParameterivEXT #-}
ptr_glGetNamedFramebufferParameterivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedFramebufferParameterivEXT = unsafePerformIO $ getCommand "glGetNamedFramebufferParameterivEXT"

-- glGetNamedProgramLocalParameterIivEXT ---------------------------------------

glGetNamedProgramLocalParameterIivEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint -- ^ @params@ pointing to @4@ elements of type @GLint@.
  -> m ()
glGetNamedProgramLocalParameterIivEXT v1 v2 v3 v4 = liftIO $ dyn364 ptr_glGetNamedProgramLocalParameterIivEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetNamedProgramLocalParameterIivEXT #-}
ptr_glGetNamedProgramLocalParameterIivEXT :: FunPtr (GLuint -> GLenum -> GLuint -> Ptr GLint -> IO ())
ptr_glGetNamedProgramLocalParameterIivEXT = unsafePerformIO $ getCommand "glGetNamedProgramLocalParameterIivEXT"

-- glGetNamedProgramLocalParameterIuivEXT --------------------------------------

glGetNamedProgramLocalParameterIuivEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLuint -- ^ @params@ pointing to @4@ elements of type @GLuint@.
  -> m ()
glGetNamedProgramLocalParameterIuivEXT v1 v2 v3 v4 = liftIO $ dyn365 ptr_glGetNamedProgramLocalParameterIuivEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetNamedProgramLocalParameterIuivEXT #-}
ptr_glGetNamedProgramLocalParameterIuivEXT :: FunPtr (GLuint -> GLenum -> GLuint -> Ptr GLuint -> IO ())
ptr_glGetNamedProgramLocalParameterIuivEXT = unsafePerformIO $ getCommand "glGetNamedProgramLocalParameterIuivEXT"

-- glGetNamedProgramLocalParameterdvEXT ----------------------------------------

glGetNamedProgramLocalParameterdvEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLdouble -- ^ @params@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glGetNamedProgramLocalParameterdvEXT v1 v2 v3 v4 = liftIO $ dyn366 ptr_glGetNamedProgramLocalParameterdvEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetNamedProgramLocalParameterdvEXT #-}
ptr_glGetNamedProgramLocalParameterdvEXT :: FunPtr (GLuint -> GLenum -> GLuint -> Ptr GLdouble -> IO ())
ptr_glGetNamedProgramLocalParameterdvEXT = unsafePerformIO $ getCommand "glGetNamedProgramLocalParameterdvEXT"

-- glGetNamedProgramLocalParameterfvEXT ----------------------------------------

glGetNamedProgramLocalParameterfvEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetNamedProgramLocalParameterfvEXT v1 v2 v3 v4 = liftIO $ dyn367 ptr_glGetNamedProgramLocalParameterfvEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetNamedProgramLocalParameterfvEXT #-}
ptr_glGetNamedProgramLocalParameterfvEXT :: FunPtr (GLuint -> GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetNamedProgramLocalParameterfvEXT = unsafePerformIO $ getCommand "glGetNamedProgramLocalParameterfvEXT"

-- glGetNamedProgramStringEXT --------------------------------------------------

glGetNamedProgramStringEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLenum -- ^ @pname@ of type @ProgramStringProperty@.
  -> Ptr a -- ^ @string@ pointing to @COMPSIZE(program,pname)@ elements of type @a@.
  -> m ()
glGetNamedProgramStringEXT v1 v2 v3 v4 = liftIO $ dyn368 ptr_glGetNamedProgramStringEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetNamedProgramStringEXT #-}
ptr_glGetNamedProgramStringEXT :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetNamedProgramStringEXT = unsafePerformIO $ getCommand "glGetNamedProgramStringEXT"

-- glGetNamedProgramivEXT ------------------------------------------------------

glGetNamedProgramivEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLenum -- ^ @pname@ of type @ProgramProperty@.
  -> Ptr GLint -- ^ @params@ pointing to @1@ element of type @GLint@.
  -> m ()
glGetNamedProgramivEXT v1 v2 v3 v4 = liftIO $ dyn363 ptr_glGetNamedProgramivEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetNamedProgramivEXT #-}
ptr_glGetNamedProgramivEXT :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedProgramivEXT = unsafePerformIO $ getCommand "glGetNamedProgramivEXT"

-- glGetNamedRenderbufferParameteriv -------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetRenderbufferParameter.xhtml OpenGL 4.x>.
glGetNamedRenderbufferParameteriv
  :: MonadIO m
  => GLuint -- ^ @renderbuffer@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetNamedRenderbufferParameteriv v1 v2 v3 = liftIO $ dyn334 ptr_glGetNamedRenderbufferParameteriv v1 v2 v3

{-# NOINLINE ptr_glGetNamedRenderbufferParameteriv #-}
ptr_glGetNamedRenderbufferParameteriv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedRenderbufferParameteriv = unsafePerformIO $ getCommand "glGetNamedRenderbufferParameteriv"

-- glGetNamedRenderbufferParameterivEXT ----------------------------------------

glGetNamedRenderbufferParameterivEXT
  :: MonadIO m
  => GLuint -- ^ @renderbuffer@ of type @Renderbuffer@.
  -> GLenum -- ^ @pname@ of type @RenderbufferParameterName@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetNamedRenderbufferParameterivEXT v1 v2 v3 = liftIO $ dyn334 ptr_glGetNamedRenderbufferParameterivEXT v1 v2 v3

{-# NOINLINE ptr_glGetNamedRenderbufferParameterivEXT #-}
ptr_glGetNamedRenderbufferParameterivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedRenderbufferParameterivEXT = unsafePerformIO $ getCommand "glGetNamedRenderbufferParameterivEXT"

-- glGetNamedStringARB ---------------------------------------------------------

glGetNamedStringARB
  :: MonadIO m
  => GLint -- ^ @namelen@.
  -> Ptr GLchar -- ^ @name@ pointing to @namelen@ elements of type @GLchar@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint -- ^ @stringlen@ pointing to @1@ element of type @GLint@.
  -> Ptr GLchar -- ^ @string@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetNamedStringARB v1 v2 v3 v4 v5 = liftIO $ dyn369 ptr_glGetNamedStringARB v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetNamedStringARB #-}
ptr_glGetNamedStringARB :: FunPtr (GLint -> Ptr GLchar -> GLsizei -> Ptr GLint -> Ptr GLchar -> IO ())
ptr_glGetNamedStringARB = unsafePerformIO $ getCommand "glGetNamedStringARB"

-- glGetNamedStringivARB -------------------------------------------------------

glGetNamedStringivARB
  :: MonadIO m
  => GLint -- ^ @namelen@.
  -> Ptr GLchar -- ^ @name@ pointing to @namelen@ elements of type @GLchar@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetNamedStringivARB v1 v2 v3 v4 = liftIO $ dyn370 ptr_glGetNamedStringivARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetNamedStringivARB #-}
ptr_glGetNamedStringivARB :: FunPtr (GLint -> Ptr GLchar -> GLenum -> Ptr GLint -> IO ())
ptr_glGetNamedStringivARB = unsafePerformIO $ getCommand "glGetNamedStringivARB"

-- glGetNextPerfQueryIdINTEL ---------------------------------------------------

glGetNextPerfQueryIdINTEL
  :: MonadIO m
  => GLuint -- ^ @queryId@.
  -> Ptr GLuint -- ^ @nextQueryId@.
  -> m ()
glGetNextPerfQueryIdINTEL v1 v2 = liftIO $ dyn194 ptr_glGetNextPerfQueryIdINTEL v1 v2

{-# NOINLINE ptr_glGetNextPerfQueryIdINTEL #-}
ptr_glGetNextPerfQueryIdINTEL :: FunPtr (GLuint -> Ptr GLuint -> IO ())
ptr_glGetNextPerfQueryIdINTEL = unsafePerformIO $ getCommand "glGetNextPerfQueryIdINTEL"

-- glGetObjectBufferfvATI ------------------------------------------------------

glGetObjectBufferfvATI
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@ of type @ArrayObjectPNameATI@.
  -> Ptr GLfloat -- ^ @params@ pointing to @1@ element of type @GLfloat@.
  -> m ()
glGetObjectBufferfvATI v1 v2 v3 = liftIO $ dyn349 ptr_glGetObjectBufferfvATI v1 v2 v3

{-# NOINLINE ptr_glGetObjectBufferfvATI #-}
ptr_glGetObjectBufferfvATI :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetObjectBufferfvATI = unsafePerformIO $ getCommand "glGetObjectBufferfvATI"

-- glGetObjectBufferivATI ------------------------------------------------------

glGetObjectBufferivATI
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@ of type @ArrayObjectPNameATI@.
  -> Ptr GLint -- ^ @params@ pointing to @1@ element of type @GLint@.
  -> m ()
glGetObjectBufferivATI v1 v2 v3 = liftIO $ dyn334 ptr_glGetObjectBufferivATI v1 v2 v3

{-# NOINLINE ptr_glGetObjectBufferivATI #-}
ptr_glGetObjectBufferivATI :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetObjectBufferivATI = unsafePerformIO $ getCommand "glGetObjectBufferivATI"

-- glGetObjectLabel ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetObjectLabel.xhtml OpenGL 4.x>.
glGetObjectLabel
  :: MonadIO m
  => GLenum -- ^ @identifier@.
  -> GLuint -- ^ @name@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @label@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetObjectLabel v1 v2 v3 v4 v5 = liftIO $ dyn371 ptr_glGetObjectLabel v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetObjectLabel #-}
ptr_glGetObjectLabel :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetObjectLabel = unsafePerformIO $ getCommand "glGetObjectLabel"

-- glGetObjectLabelEXT ---------------------------------------------------------

glGetObjectLabelEXT
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> GLuint -- ^ @object@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @label@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetObjectLabelEXT v1 v2 v3 v4 v5 = liftIO $ dyn371 ptr_glGetObjectLabelEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetObjectLabelEXT #-}
ptr_glGetObjectLabelEXT :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetObjectLabelEXT = unsafePerformIO $ getCommand "glGetObjectLabelEXT"

-- glGetObjectLabelKHR ---------------------------------------------------------

-- | This command is an alias for 'glGetObjectLabel'.
glGetObjectLabelKHR
  :: MonadIO m
  => GLenum -- ^ @identifier@.
  -> GLuint -- ^ @name@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@.
  -> Ptr GLchar -- ^ @label@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetObjectLabelKHR v1 v2 v3 v4 v5 = liftIO $ dyn371 ptr_glGetObjectLabelKHR v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetObjectLabelKHR #-}
ptr_glGetObjectLabelKHR :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetObjectLabelKHR = unsafePerformIO $ getCommand "glGetObjectLabelKHR"

-- glGetObjectParameterfvARB ---------------------------------------------------

glGetObjectParameterfvARB
  :: MonadIO m
  => GLhandleARB -- ^ @obj@ of type @handleARB@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetObjectParameterfvARB v1 v2 v3 = liftIO $ dyn372 ptr_glGetObjectParameterfvARB v1 v2 v3

{-# NOINLINE ptr_glGetObjectParameterfvARB #-}
ptr_glGetObjectParameterfvARB :: FunPtr (GLhandleARB -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetObjectParameterfvARB = unsafePerformIO $ getCommand "glGetObjectParameterfvARB"

-- glGetObjectParameterivAPPLE -------------------------------------------------

glGetObjectParameterivAPPLE
  :: MonadIO m
  => GLenum -- ^ @objectType@.
  -> GLuint -- ^ @name@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetObjectParameterivAPPLE v1 v2 v3 v4 = liftIO $ dyn351 ptr_glGetObjectParameterivAPPLE v1 v2 v3 v4

{-# NOINLINE ptr_glGetObjectParameterivAPPLE #-}
ptr_glGetObjectParameterivAPPLE :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetObjectParameterivAPPLE = unsafePerformIO $ getCommand "glGetObjectParameterivAPPLE"

-- glGetObjectParameterivARB ---------------------------------------------------

glGetObjectParameterivARB
  :: MonadIO m
  => GLhandleARB -- ^ @obj@ of type @handleARB@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetObjectParameterivARB v1 v2 v3 = liftIO $ dyn373 ptr_glGetObjectParameterivARB v1 v2 v3

{-# NOINLINE ptr_glGetObjectParameterivARB #-}
ptr_glGetObjectParameterivARB :: FunPtr (GLhandleARB -> GLenum -> Ptr GLint -> IO ())
ptr_glGetObjectParameterivARB = unsafePerformIO $ getCommand "glGetObjectParameterivARB"

-- glGetObjectPtrLabel ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetObjectPtrLabel.xhtml OpenGL 4.x>.
glGetObjectPtrLabel
  :: MonadIO m
  => Ptr a -- ^ @ptr@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @label@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetObjectPtrLabel v1 v2 v3 v4 = liftIO $ dyn374 ptr_glGetObjectPtrLabel v1 v2 v3 v4

{-# NOINLINE ptr_glGetObjectPtrLabel #-}
ptr_glGetObjectPtrLabel :: FunPtr (Ptr a -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetObjectPtrLabel = unsafePerformIO $ getCommand "glGetObjectPtrLabel"

-- glGetObjectPtrLabelKHR ------------------------------------------------------

-- | This command is an alias for 'glGetObjectPtrLabel'.
glGetObjectPtrLabelKHR
  :: MonadIO m
  => Ptr a -- ^ @ptr@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @label@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetObjectPtrLabelKHR v1 v2 v3 v4 = liftIO $ dyn374 ptr_glGetObjectPtrLabelKHR v1 v2 v3 v4

{-# NOINLINE ptr_glGetObjectPtrLabelKHR #-}
ptr_glGetObjectPtrLabelKHR :: FunPtr (Ptr a -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetObjectPtrLabelKHR = unsafePerformIO $ getCommand "glGetObjectPtrLabelKHR"

-- glGetOcclusionQueryivNV -----------------------------------------------------

glGetOcclusionQueryivNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@ of type @OcclusionQueryParameterNameNV@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetOcclusionQueryivNV v1 v2 v3 = liftIO $ dyn334 ptr_glGetOcclusionQueryivNV v1 v2 v3

{-# NOINLINE ptr_glGetOcclusionQueryivNV #-}
ptr_glGetOcclusionQueryivNV :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetOcclusionQueryivNV = unsafePerformIO $ getCommand "glGetOcclusionQueryivNV"

-- glGetOcclusionQueryuivNV ----------------------------------------------------

glGetOcclusionQueryuivNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@ of type @OcclusionQueryParameterNameNV@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetOcclusionQueryuivNV v1 v2 v3 = liftIO $ dyn375 ptr_glGetOcclusionQueryuivNV v1 v2 v3

{-# NOINLINE ptr_glGetOcclusionQueryuivNV #-}
ptr_glGetOcclusionQueryuivNV :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetOcclusionQueryuivNV = unsafePerformIO $ getCommand "glGetOcclusionQueryuivNV"

-- glGetPathColorGenfvNV -------------------------------------------------------

glGetPathColorGenfvNV
  :: MonadIO m
  => GLenum -- ^ @color@ of type @PathColor@.
  -> GLenum -- ^ @pname@ of type @PathGenMode@.
  -> Ptr GLfloat -- ^ @value@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetPathColorGenfvNV v1 v2 v3 = liftIO $ dyn132 ptr_glGetPathColorGenfvNV v1 v2 v3

{-# NOINLINE ptr_glGetPathColorGenfvNV #-}
ptr_glGetPathColorGenfvNV :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetPathColorGenfvNV = unsafePerformIO $ getCommand "glGetPathColorGenfvNV"

-- glGetPathColorGenivNV -------------------------------------------------------

glGetPathColorGenivNV
  :: MonadIO m
  => GLenum -- ^ @color@ of type @PathColor@.
  -> GLenum -- ^ @pname@ of type @PathGenMode@.
  -> Ptr GLint -- ^ @value@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetPathColorGenivNV v1 v2 v3 = liftIO $ dyn133 ptr_glGetPathColorGenivNV v1 v2 v3

{-# NOINLINE ptr_glGetPathColorGenivNV #-}
ptr_glGetPathColorGenivNV :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetPathColorGenivNV = unsafePerformIO $ getCommand "glGetPathColorGenivNV"

-- glGetPathCommandsNV ---------------------------------------------------------

glGetPathCommandsNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> Ptr GLubyte -- ^ @commands@ pointing to @COMPSIZE(path)@ elements of type @PathCommand@.
  -> m ()
glGetPathCommandsNV v1 v2 = liftIO $ dyn376 ptr_glGetPathCommandsNV v1 v2

{-# NOINLINE ptr_glGetPathCommandsNV #-}
ptr_glGetPathCommandsNV :: FunPtr (GLuint -> Ptr GLubyte -> IO ())
ptr_glGetPathCommandsNV = unsafePerformIO $ getCommand "glGetPathCommandsNV"

-- glGetPathCoordsNV -----------------------------------------------------------

glGetPathCoordsNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> Ptr GLfloat -- ^ @coords@ pointing to @COMPSIZE(path)@ elements of type @GLfloat@.
  -> m ()
glGetPathCoordsNV v1 v2 = liftIO $ dyn377 ptr_glGetPathCoordsNV v1 v2

{-# NOINLINE ptr_glGetPathCoordsNV #-}
ptr_glGetPathCoordsNV :: FunPtr (GLuint -> Ptr GLfloat -> IO ())
ptr_glGetPathCoordsNV = unsafePerformIO $ getCommand "glGetPathCoordsNV"

-- glGetPathDashArrayNV --------------------------------------------------------

glGetPathDashArrayNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> Ptr GLfloat -- ^ @dashArray@ pointing to @COMPSIZE(path)@ elements of type @GLfloat@.
  -> m ()
glGetPathDashArrayNV v1 v2 = liftIO $ dyn377 ptr_glGetPathDashArrayNV v1 v2

{-# NOINLINE ptr_glGetPathDashArrayNV #-}
ptr_glGetPathDashArrayNV :: FunPtr (GLuint -> Ptr GLfloat -> IO ())
ptr_glGetPathDashArrayNV = unsafePerformIO $ getCommand "glGetPathDashArrayNV"

-- glGetPathLengthNV -----------------------------------------------------------

glGetPathLengthNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> GLsizei -- ^ @startSegment@.
  -> GLsizei -- ^ @numSegments@.
  -> m GLfloat
glGetPathLengthNV v1 v2 v3 = liftIO $ dyn378 ptr_glGetPathLengthNV v1 v2 v3

{-# NOINLINE ptr_glGetPathLengthNV #-}
ptr_glGetPathLengthNV :: FunPtr (GLuint -> GLsizei -> GLsizei -> IO GLfloat)
ptr_glGetPathLengthNV = unsafePerformIO $ getCommand "glGetPathLengthNV"

-- glGetPathMetricRangeNV ------------------------------------------------------

glGetPathMetricRangeNV
  :: MonadIO m
  => GLbitfield -- ^ @metricQueryMask@ of type @PathMetricMask@.
  -> GLuint -- ^ @firstPathName@ of type @Path@.
  -> GLsizei -- ^ @numPaths@.
  -> GLsizei -- ^ @stride@.
  -> Ptr GLfloat -- ^ @metrics@ pointing to @COMPSIZE(metricQueryMask,numPaths,stride)@ elements of type @GLfloat@.
  -> m ()
glGetPathMetricRangeNV v1 v2 v3 v4 v5 = liftIO $ dyn379 ptr_glGetPathMetricRangeNV v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetPathMetricRangeNV #-}
ptr_glGetPathMetricRangeNV :: FunPtr (GLbitfield -> GLuint -> GLsizei -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetPathMetricRangeNV = unsafePerformIO $ getCommand "glGetPathMetricRangeNV"

-- glGetPathMetricsNV ----------------------------------------------------------

glGetPathMetricsNV
  :: MonadIO m
  => GLbitfield -- ^ @metricQueryMask@ of type @PathMetricMask@.
  -> GLsizei -- ^ @numPaths@.
  -> GLenum -- ^ @pathNameType@ of type @PathElementType@.
  -> Ptr a -- ^ @paths@ pointing to @COMPSIZE(numPaths,pathNameType,paths)@ elements of type @PathElement@.
  -> GLuint -- ^ @pathBase@ of type @Path@.
  -> GLsizei -- ^ @stride@.
  -> Ptr GLfloat -- ^ @metrics@ pointing to @COMPSIZE(metricQueryMask,numPaths,stride)@ elements of type @GLfloat@.
  -> m ()
glGetPathMetricsNV v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn380 ptr_glGetPathMetricsNV v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glGetPathMetricsNV #-}
ptr_glGetPathMetricsNV :: FunPtr (GLbitfield -> GLsizei -> GLenum -> Ptr a -> GLuint -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetPathMetricsNV = unsafePerformIO $ getCommand "glGetPathMetricsNV"

-- glGetPathParameterfvNV ------------------------------------------------------

glGetPathParameterfvNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> GLenum -- ^ @pname@ of type @PathParameter@.
  -> Ptr GLfloat -- ^ @value@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetPathParameterfvNV v1 v2 v3 = liftIO $ dyn349 ptr_glGetPathParameterfvNV v1 v2 v3

{-# NOINLINE ptr_glGetPathParameterfvNV #-}
ptr_glGetPathParameterfvNV :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetPathParameterfvNV = unsafePerformIO $ getCommand "glGetPathParameterfvNV"

-- glGetPathParameterivNV ------------------------------------------------------

glGetPathParameterivNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> GLenum -- ^ @pname@ of type @PathParameter@.
  -> Ptr GLint -- ^ @value@ pointing to @4@ elements of type @GLint@.
  -> m ()
glGetPathParameterivNV v1 v2 v3 = liftIO $ dyn334 ptr_glGetPathParameterivNV v1 v2 v3

{-# NOINLINE ptr_glGetPathParameterivNV #-}
ptr_glGetPathParameterivNV :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetPathParameterivNV = unsafePerformIO $ getCommand "glGetPathParameterivNV"

-- glGetPathSpacingNV ----------------------------------------------------------

glGetPathSpacingNV
  :: MonadIO m
  => GLenum -- ^ @pathListMode@ of type @PathListMode@.
  -> GLsizei -- ^ @numPaths@.
  -> GLenum -- ^ @pathNameType@ of type @PathElementType@.
  -> Ptr a -- ^ @paths@ pointing to @COMPSIZE(numPaths,pathNameType,paths)@ elements of type @PathElement@.
  -> GLuint -- ^ @pathBase@ of type @Path@.
  -> GLfloat -- ^ @advanceScale@.
  -> GLfloat -- ^ @kerningScale@.
  -> GLenum -- ^ @transformType@ of type @PathTransformType@.
  -> Ptr GLfloat -- ^ @returnedSpacing@ pointing to @COMPSIZE(pathListMode,numPaths)@ elements of type @GLfloat@.
  -> m ()
glGetPathSpacingNV v1 v2 v3 v4 v5 v6 v7 v8 v9 = liftIO $ dyn381 ptr_glGetPathSpacingNV v1 v2 v3 v4 v5 v6 v7 v8 v9

{-# NOINLINE ptr_glGetPathSpacingNV #-}
ptr_glGetPathSpacingNV :: FunPtr (GLenum -> GLsizei -> GLenum -> Ptr a -> GLuint -> GLfloat -> GLfloat -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetPathSpacingNV = unsafePerformIO $ getCommand "glGetPathSpacingNV"

-- glGetPathTexGenfvNV ---------------------------------------------------------

glGetPathTexGenfvNV
  :: MonadIO m
  => GLenum -- ^ @texCoordSet@ of type @TextureUnit@.
  -> GLenum -- ^ @pname@ of type @PathGenMode@.
  -> Ptr GLfloat -- ^ @value@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetPathTexGenfvNV v1 v2 v3 = liftIO $ dyn132 ptr_glGetPathTexGenfvNV v1 v2 v3

{-# NOINLINE ptr_glGetPathTexGenfvNV #-}
ptr_glGetPathTexGenfvNV :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetPathTexGenfvNV = unsafePerformIO $ getCommand "glGetPathTexGenfvNV"

-- glGetPathTexGenivNV ---------------------------------------------------------

glGetPathTexGenivNV
  :: MonadIO m
  => GLenum -- ^ @texCoordSet@ of type @TextureUnit@.
  -> GLenum -- ^ @pname@ of type @PathGenMode@.
  -> Ptr GLint -- ^ @value@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetPathTexGenivNV v1 v2 v3 = liftIO $ dyn133 ptr_glGetPathTexGenivNV v1 v2 v3

{-# NOINLINE ptr_glGetPathTexGenivNV #-}
ptr_glGetPathTexGenivNV :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetPathTexGenivNV = unsafePerformIO $ getCommand "glGetPathTexGenivNV"

-- glGetPerfCounterInfoINTEL ---------------------------------------------------

glGetPerfCounterInfoINTEL
  :: MonadIO m
  => GLuint -- ^ @queryId@.
  -> GLuint -- ^ @counterId@.
  -> GLuint -- ^ @counterNameLength@.
  -> Ptr GLchar -- ^ @counterName@.
  -> GLuint -- ^ @counterDescLength@.
  -> Ptr GLchar -- ^ @counterDesc@.
  -> Ptr GLuint -- ^ @counterOffset@.
  -> Ptr GLuint -- ^ @counterDataSize@.
  -> Ptr GLuint -- ^ @counterTypeEnum@.
  -> Ptr GLuint -- ^ @counterDataTypeEnum@.
  -> Ptr GLuint64 -- ^ @rawCounterMaxValue@.
  -> m ()
glGetPerfCounterInfoINTEL v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 = liftIO $ dyn382 ptr_glGetPerfCounterInfoINTEL v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11

{-# NOINLINE ptr_glGetPerfCounterInfoINTEL #-}
ptr_glGetPerfCounterInfoINTEL :: FunPtr (GLuint -> GLuint -> GLuint -> Ptr GLchar -> GLuint -> Ptr GLchar -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint64 -> IO ())
ptr_glGetPerfCounterInfoINTEL = unsafePerformIO $ getCommand "glGetPerfCounterInfoINTEL"

-- glGetPerfMonitorCounterDataAMD ----------------------------------------------

glGetPerfMonitorCounterDataAMD
  :: MonadIO m
  => GLuint -- ^ @monitor@.
  -> GLenum -- ^ @pname@.
  -> GLsizei -- ^ @dataSize@.
  -> Ptr GLuint -- ^ @data@ pointing to @dataSize@ elements of type @GLuint@.
  -> Ptr GLint -- ^ @bytesWritten@ pointing to @1@ element of type @GLint@.
  -> m ()
glGetPerfMonitorCounterDataAMD v1 v2 v3 v4 v5 = liftIO $ dyn383 ptr_glGetPerfMonitorCounterDataAMD v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetPerfMonitorCounterDataAMD #-}
ptr_glGetPerfMonitorCounterDataAMD :: FunPtr (GLuint -> GLenum -> GLsizei -> Ptr GLuint -> Ptr GLint -> IO ())
ptr_glGetPerfMonitorCounterDataAMD = unsafePerformIO $ getCommand "glGetPerfMonitorCounterDataAMD"

-- glGetPerfMonitorCounterInfoAMD ----------------------------------------------

glGetPerfMonitorCounterInfoAMD
  :: MonadIO m
  => GLuint -- ^ @group@.
  -> GLuint -- ^ @counter@.
  -> GLenum -- ^ @pname@.
  -> Ptr a -- ^ @data@ pointing to @COMPSIZE(pname)@ elements of type @a@.
  -> m ()
glGetPerfMonitorCounterInfoAMD v1 v2 v3 v4 = liftIO $ dyn384 ptr_glGetPerfMonitorCounterInfoAMD v1 v2 v3 v4

{-# NOINLINE ptr_glGetPerfMonitorCounterInfoAMD #-}
ptr_glGetPerfMonitorCounterInfoAMD :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr a -> IO ())
ptr_glGetPerfMonitorCounterInfoAMD = unsafePerformIO $ getCommand "glGetPerfMonitorCounterInfoAMD"

-- glGetPerfMonitorCounterStringAMD --------------------------------------------

glGetPerfMonitorCounterStringAMD
  :: MonadIO m
  => GLuint -- ^ @group@.
  -> GLuint -- ^ @counter@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @counterString@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetPerfMonitorCounterStringAMD v1 v2 v3 v4 v5 = liftIO $ dyn305 ptr_glGetPerfMonitorCounterStringAMD v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetPerfMonitorCounterStringAMD #-}
ptr_glGetPerfMonitorCounterStringAMD :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetPerfMonitorCounterStringAMD = unsafePerformIO $ getCommand "glGetPerfMonitorCounterStringAMD"

-- glGetPerfMonitorCountersAMD -------------------------------------------------

glGetPerfMonitorCountersAMD
  :: MonadIO m
  => GLuint -- ^ @group@.
  -> Ptr GLint -- ^ @numCounters@ pointing to @1@ element of type @GLint@.
  -> Ptr GLint -- ^ @maxActiveCounters@ pointing to @1@ element of type @GLint@.
  -> GLsizei -- ^ @counterSize@.
  -> Ptr GLuint -- ^ @counters@ pointing to @counterSize@ elements of type @GLuint@.
  -> m ()
glGetPerfMonitorCountersAMD v1 v2 v3 v4 v5 = liftIO $ dyn385 ptr_glGetPerfMonitorCountersAMD v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetPerfMonitorCountersAMD #-}
ptr_glGetPerfMonitorCountersAMD :: FunPtr (GLuint -> Ptr GLint -> Ptr GLint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glGetPerfMonitorCountersAMD = unsafePerformIO $ getCommand "glGetPerfMonitorCountersAMD"

-- glGetPerfMonitorGroupStringAMD ----------------------------------------------

glGetPerfMonitorGroupStringAMD
  :: MonadIO m
  => GLuint -- ^ @group@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @groupString@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetPerfMonitorGroupStringAMD v1 v2 v3 v4 = liftIO $ dyn331 ptr_glGetPerfMonitorGroupStringAMD v1 v2 v3 v4

{-# NOINLINE ptr_glGetPerfMonitorGroupStringAMD #-}
ptr_glGetPerfMonitorGroupStringAMD :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetPerfMonitorGroupStringAMD = unsafePerformIO $ getCommand "glGetPerfMonitorGroupStringAMD"

-- glGetPerfMonitorGroupsAMD ---------------------------------------------------

glGetPerfMonitorGroupsAMD
  :: MonadIO m
  => Ptr GLint -- ^ @numGroups@ pointing to @1@ element of type @GLint@.
  -> GLsizei -- ^ @groupsSize@.
  -> Ptr GLuint -- ^ @groups@ pointing to @groupsSize@ elements of type @GLuint@.
  -> m ()
glGetPerfMonitorGroupsAMD v1 v2 v3 = liftIO $ dyn332 ptr_glGetPerfMonitorGroupsAMD v1 v2 v3

{-# NOINLINE ptr_glGetPerfMonitorGroupsAMD #-}
ptr_glGetPerfMonitorGroupsAMD :: FunPtr (Ptr GLint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glGetPerfMonitorGroupsAMD = unsafePerformIO $ getCommand "glGetPerfMonitorGroupsAMD"

-- glGetPerfQueryDataINTEL -----------------------------------------------------

glGetPerfQueryDataINTEL
  :: MonadIO m
  => GLuint -- ^ @queryHandle@.
  -> GLuint -- ^ @flags@.
  -> GLsizei -- ^ @dataSize@.
  -> Ptr a -- ^ @data@.
  -> Ptr GLuint -- ^ @bytesWritten@.
  -> m ()
glGetPerfQueryDataINTEL v1 v2 v3 v4 v5 = liftIO $ dyn386 ptr_glGetPerfQueryDataINTEL v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetPerfQueryDataINTEL #-}
ptr_glGetPerfQueryDataINTEL :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr a -> Ptr GLuint -> IO ())
ptr_glGetPerfQueryDataINTEL = unsafePerformIO $ getCommand "glGetPerfQueryDataINTEL"

-- glGetPerfQueryIdByNameINTEL -------------------------------------------------

glGetPerfQueryIdByNameINTEL
  :: MonadIO m
  => Ptr GLchar -- ^ @queryName@.
  -> Ptr GLuint -- ^ @queryId@.
  -> m ()
glGetPerfQueryIdByNameINTEL v1 v2 = liftIO $ dyn387 ptr_glGetPerfQueryIdByNameINTEL v1 v2

{-# NOINLINE ptr_glGetPerfQueryIdByNameINTEL #-}
ptr_glGetPerfQueryIdByNameINTEL :: FunPtr (Ptr GLchar -> Ptr GLuint -> IO ())
ptr_glGetPerfQueryIdByNameINTEL = unsafePerformIO $ getCommand "glGetPerfQueryIdByNameINTEL"

-- glGetPerfQueryInfoINTEL -----------------------------------------------------

glGetPerfQueryInfoINTEL
  :: MonadIO m
  => GLuint -- ^ @queryId@.
  -> GLuint -- ^ @queryNameLength@.
  -> Ptr GLchar -- ^ @queryName@.
  -> Ptr GLuint -- ^ @dataSize@.
  -> Ptr GLuint -- ^ @noCounters@.
  -> Ptr GLuint -- ^ @noInstances@.
  -> Ptr GLuint -- ^ @capsMask@.
  -> m ()
glGetPerfQueryInfoINTEL v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn388 ptr_glGetPerfQueryInfoINTEL v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glGetPerfQueryInfoINTEL #-}
ptr_glGetPerfQueryInfoINTEL :: FunPtr (GLuint -> GLuint -> Ptr GLchar -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> Ptr GLuint -> IO ())
ptr_glGetPerfQueryInfoINTEL = unsafePerformIO $ getCommand "glGetPerfQueryInfoINTEL"

-- glGetPixelMapfv -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetPixelMap.xml OpenGL 2.x>.
glGetPixelMapfv
  :: MonadIO m
  => GLenum -- ^ @map@ of type [PixelMap](Graphics-GL-Groups.html#PixelMap).
  -> Ptr GLfloat -- ^ @values@ pointing to @COMPSIZE(map)@ elements of type @GLfloat@.
  -> m ()
glGetPixelMapfv v1 v2 = liftIO $ dyn94 ptr_glGetPixelMapfv v1 v2

{-# NOINLINE ptr_glGetPixelMapfv #-}
ptr_glGetPixelMapfv :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetPixelMapfv = unsafePerformIO $ getCommand "glGetPixelMapfv"

-- glGetPixelMapuiv ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetPixelMap.xml OpenGL 2.x>.
glGetPixelMapuiv
  :: MonadIO m
  => GLenum -- ^ @map@ of type [PixelMap](Graphics-GL-Groups.html#PixelMap).
  -> Ptr GLuint -- ^ @values@ pointing to @COMPSIZE(map)@ elements of type @GLuint@.
  -> m ()
glGetPixelMapuiv v1 v2 = liftIO $ dyn125 ptr_glGetPixelMapuiv v1 v2

{-# NOINLINE ptr_glGetPixelMapuiv #-}
ptr_glGetPixelMapuiv :: FunPtr (GLenum -> Ptr GLuint -> IO ())
ptr_glGetPixelMapuiv = unsafePerformIO $ getCommand "glGetPixelMapuiv"

-- glGetPixelMapusv ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetPixelMap.xml OpenGL 2.x>.
glGetPixelMapusv
  :: MonadIO m
  => GLenum -- ^ @map@ of type [PixelMap](Graphics-GL-Groups.html#PixelMap).
  -> Ptr GLushort -- ^ @values@ pointing to @COMPSIZE(map)@ elements of type @GLushort@.
  -> m ()
glGetPixelMapusv v1 v2 = liftIO $ dyn389 ptr_glGetPixelMapusv v1 v2

{-# NOINLINE ptr_glGetPixelMapusv #-}
ptr_glGetPixelMapusv :: FunPtr (GLenum -> Ptr GLushort -> IO ())
ptr_glGetPixelMapusv = unsafePerformIO $ getCommand "glGetPixelMapusv"

-- glGetPixelMapxv -------------------------------------------------------------

glGetPixelMapxv
  :: MonadIO m
  => GLenum -- ^ @map@.
  -> GLint -- ^ @size@.
  -> Ptr GLfixed -- ^ @values@ pointing to @size@ elements of type @GLfixed@.
  -> m ()
glGetPixelMapxv v1 v2 v3 = liftIO $ dyn390 ptr_glGetPixelMapxv v1 v2 v3

{-# NOINLINE ptr_glGetPixelMapxv #-}
ptr_glGetPixelMapxv :: FunPtr (GLenum -> GLint -> Ptr GLfixed -> IO ())
ptr_glGetPixelMapxv = unsafePerformIO $ getCommand "glGetPixelMapxv"

-- glGetPixelTexGenParameterfvSGIS ---------------------------------------------

glGetPixelTexGenParameterfvSGIS
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [PixelTexGenParameterNameSGIS](Graphics-GL-Groups.html#PixelTexGenParameterNameSGIS).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glGetPixelTexGenParameterfvSGIS v1 v2 = liftIO $ dyn94 ptr_glGetPixelTexGenParameterfvSGIS v1 v2

{-# NOINLINE ptr_glGetPixelTexGenParameterfvSGIS #-}
ptr_glGetPixelTexGenParameterfvSGIS :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetPixelTexGenParameterfvSGIS = unsafePerformIO $ getCommand "glGetPixelTexGenParameterfvSGIS"

-- glGetPixelTexGenParameterivSGIS ---------------------------------------------

glGetPixelTexGenParameterivSGIS
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [PixelTexGenParameterNameSGIS](Graphics-GL-Groups.html#PixelTexGenParameterNameSGIS).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glGetPixelTexGenParameterivSGIS v1 v2 = liftIO $ dyn136 ptr_glGetPixelTexGenParameterivSGIS v1 v2

{-# NOINLINE ptr_glGetPixelTexGenParameterivSGIS #-}
ptr_glGetPixelTexGenParameterivSGIS :: FunPtr (GLenum -> Ptr GLint -> IO ())
ptr_glGetPixelTexGenParameterivSGIS = unsafePerformIO $ getCommand "glGetPixelTexGenParameterivSGIS"

-- glGetPixelTransformParameterfvEXT -------------------------------------------

glGetPixelTransformParameterfvEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetPixelTransformParameterfvEXT v1 v2 v3 = liftIO $ dyn132 ptr_glGetPixelTransformParameterfvEXT v1 v2 v3

{-# NOINLINE ptr_glGetPixelTransformParameterfvEXT #-}
ptr_glGetPixelTransformParameterfvEXT :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetPixelTransformParameterfvEXT = unsafePerformIO $ getCommand "glGetPixelTransformParameterfvEXT"

-- glGetPixelTransformParameterivEXT -------------------------------------------

glGetPixelTransformParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetPixelTransformParameterivEXT v1 v2 v3 = liftIO $ dyn133 ptr_glGetPixelTransformParameterivEXT v1 v2 v3

{-# NOINLINE ptr_glGetPixelTransformParameterivEXT #-}
ptr_glGetPixelTransformParameterivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetPixelTransformParameterivEXT = unsafePerformIO $ getCommand "glGetPixelTransformParameterivEXT"

-- glGetPointerIndexedvEXT -----------------------------------------------------

glGetPointerIndexedvEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr (Ptr a) -- ^ @data@ pointing to @1@ element of type @Ptr a@.
  -> m ()
glGetPointerIndexedvEXT v1 v2 v3 = liftIO $ dyn391 ptr_glGetPointerIndexedvEXT v1 v2 v3

{-# NOINLINE ptr_glGetPointerIndexedvEXT #-}
ptr_glGetPointerIndexedvEXT :: FunPtr (GLenum -> GLuint -> Ptr (Ptr a) -> IO ())
ptr_glGetPointerIndexedvEXT = unsafePerformIO $ getCommand "glGetPointerIndexedvEXT"

-- glGetPointeri_vEXT ----------------------------------------------------------

glGetPointeri_vEXT
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @TypeEnum@.
  -> GLuint -- ^ @index@.
  -> Ptr (Ptr a) -- ^ @params@ pointing to @1@ element of type @Ptr a@.
  -> m ()
glGetPointeri_vEXT v1 v2 v3 = liftIO $ dyn391 ptr_glGetPointeri_vEXT v1 v2 v3

{-# NOINLINE ptr_glGetPointeri_vEXT #-}
ptr_glGetPointeri_vEXT :: FunPtr (GLenum -> GLuint -> Ptr (Ptr a) -> IO ())
ptr_glGetPointeri_vEXT = unsafePerformIO $ getCommand "glGetPointeri_vEXT"

-- glGetPointerv ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetPointerv.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetPointerv.xhtml OpenGL 4.x>.
glGetPointerv
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [GetPointervPName](Graphics-GL-Groups.html#GetPointervPName).
  -> Ptr (Ptr a) -- ^ @params@ pointing to @1@ element of type @Ptr a@.
  -> m ()
glGetPointerv v1 v2 = liftIO $ dyn268 ptr_glGetPointerv v1 v2

{-# NOINLINE ptr_glGetPointerv #-}
ptr_glGetPointerv :: FunPtr (GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetPointerv = unsafePerformIO $ getCommand "glGetPointerv"

-- glGetPointervEXT ------------------------------------------------------------

-- | This command is an alias for 'glGetPointerv'.
glGetPointervEXT
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [GetPointervPName](Graphics-GL-Groups.html#GetPointervPName).
  -> Ptr (Ptr a) -- ^ @params@ pointing to @1@ element of type @Ptr a@.
  -> m ()
glGetPointervEXT v1 v2 = liftIO $ dyn268 ptr_glGetPointervEXT v1 v2

{-# NOINLINE ptr_glGetPointervEXT #-}
ptr_glGetPointervEXT :: FunPtr (GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetPointervEXT = unsafePerformIO $ getCommand "glGetPointervEXT"

-- glGetPointervKHR ------------------------------------------------------------

-- | This command is an alias for 'glGetPointerv'.
glGetPointervKHR
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr (Ptr a) -- ^ @params@.
  -> m ()
glGetPointervKHR v1 v2 = liftIO $ dyn268 ptr_glGetPointervKHR v1 v2

{-# NOINLINE ptr_glGetPointervKHR #-}
ptr_glGetPointervKHR :: FunPtr (GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetPointervKHR = unsafePerformIO $ getCommand "glGetPointervKHR"

-- glGetPolygonStipple ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetPolygonStipple.xml OpenGL 2.x>.
glGetPolygonStipple
  :: MonadIO m
  => Ptr GLubyte -- ^ @mask@ pointing to @COMPSIZE()@ elements of type @GLubyte@.
  -> m ()
glGetPolygonStipple v1 = liftIO $ dyn101 ptr_glGetPolygonStipple v1

{-# NOINLINE ptr_glGetPolygonStipple #-}
ptr_glGetPolygonStipple :: FunPtr (Ptr GLubyte -> IO ())
ptr_glGetPolygonStipple = unsafePerformIO $ getCommand "glGetPolygonStipple"

-- glGetProgramBinary ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramBinary.xhtml OpenGL 4.x>.
glGetProgramBinary
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLenum -- ^ @binaryFormat@ pointing to @1@ element of type @GLenum@.
  -> Ptr a -- ^ @binary@ pointing to @bufSize@ elements of type @a@.
  -> m ()
glGetProgramBinary v1 v2 v3 v4 v5 = liftIO $ dyn392 ptr_glGetProgramBinary v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetProgramBinary #-}
ptr_glGetProgramBinary :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLenum -> Ptr a -> IO ())
ptr_glGetProgramBinary = unsafePerformIO $ getCommand "glGetProgramBinary"

-- glGetProgramBinaryOES -------------------------------------------------------

-- | This command is an alias for 'glGetProgramBinary'.
glGetProgramBinaryOES
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLenum -- ^ @binaryFormat@ pointing to @1@ element of type @GLenum@.
  -> Ptr a -- ^ @binary@ pointing to @bufSize@ elements of type @a@.
  -> m ()
glGetProgramBinaryOES v1 v2 v3 v4 v5 = liftIO $ dyn392 ptr_glGetProgramBinaryOES v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetProgramBinaryOES #-}
ptr_glGetProgramBinaryOES :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLenum -> Ptr a -> IO ())
ptr_glGetProgramBinaryOES = unsafePerformIO $ getCommand "glGetProgramBinaryOES"

-- glGetProgramEnvParameterIivNV -----------------------------------------------

glGetProgramEnvParameterIivNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint -- ^ @params@ pointing to @4@ elements of type @GLint@.
  -> m ()
glGetProgramEnvParameterIivNV v1 v2 v3 = liftIO $ dyn342 ptr_glGetProgramEnvParameterIivNV v1 v2 v3

{-# NOINLINE ptr_glGetProgramEnvParameterIivNV #-}
ptr_glGetProgramEnvParameterIivNV :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
ptr_glGetProgramEnvParameterIivNV = unsafePerformIO $ getCommand "glGetProgramEnvParameterIivNV"

-- glGetProgramEnvParameterIuivNV ----------------------------------------------

glGetProgramEnvParameterIuivNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLuint -- ^ @params@ pointing to @4@ elements of type @GLuint@.
  -> m ()
glGetProgramEnvParameterIuivNV v1 v2 v3 = liftIO $ dyn214 ptr_glGetProgramEnvParameterIuivNV v1 v2 v3

{-# NOINLINE ptr_glGetProgramEnvParameterIuivNV #-}
ptr_glGetProgramEnvParameterIuivNV :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
ptr_glGetProgramEnvParameterIuivNV = unsafePerformIO $ getCommand "glGetProgramEnvParameterIuivNV"

-- glGetProgramEnvParameterdvARB -----------------------------------------------

glGetProgramEnvParameterdvARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTargetARB@.
  -> GLuint -- ^ @index@.
  -> Ptr GLdouble -- ^ @params@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glGetProgramEnvParameterdvARB v1 v2 v3 = liftIO $ dyn330 ptr_glGetProgramEnvParameterdvARB v1 v2 v3

{-# NOINLINE ptr_glGetProgramEnvParameterdvARB #-}
ptr_glGetProgramEnvParameterdvARB :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
ptr_glGetProgramEnvParameterdvARB = unsafePerformIO $ getCommand "glGetProgramEnvParameterdvARB"

-- glGetProgramEnvParameterfvARB -----------------------------------------------

glGetProgramEnvParameterfvARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTargetARB@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetProgramEnvParameterfvARB v1 v2 v3 = liftIO $ dyn267 ptr_glGetProgramEnvParameterfvARB v1 v2 v3

{-# NOINLINE ptr_glGetProgramEnvParameterfvARB #-}
ptr_glGetProgramEnvParameterfvARB :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetProgramEnvParameterfvARB = unsafePerformIO $ getCommand "glGetProgramEnvParameterfvARB"

-- glGetProgramInfoLog ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetProgramInfoLog.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetProgramInfoLog.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetProgramInfoLog.xhtml OpenGL 4.x>.
glGetProgramInfoLog
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @infoLog@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetProgramInfoLog v1 v2 v3 v4 = liftIO $ dyn331 ptr_glGetProgramInfoLog v1 v2 v3 v4

{-# NOINLINE ptr_glGetProgramInfoLog #-}
ptr_glGetProgramInfoLog :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetProgramInfoLog = unsafePerformIO $ getCommand "glGetProgramInfoLog"

-- glGetProgramInterfaceiv -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramInterface.xhtml OpenGL 4.x>.
glGetProgramInterfaceiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetProgramInterfaceiv v1 v2 v3 v4 = liftIO $ dyn363 ptr_glGetProgramInterfaceiv v1 v2 v3 v4

{-# NOINLINE ptr_glGetProgramInterfaceiv #-}
ptr_glGetProgramInterfaceiv :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetProgramInterfaceiv = unsafePerformIO $ getCommand "glGetProgramInterfaceiv"

-- glGetProgramLocalParameterIivNV ---------------------------------------------

glGetProgramLocalParameterIivNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint -- ^ @params@ pointing to @4@ elements of type @GLint@.
  -> m ()
glGetProgramLocalParameterIivNV v1 v2 v3 = liftIO $ dyn342 ptr_glGetProgramLocalParameterIivNV v1 v2 v3

{-# NOINLINE ptr_glGetProgramLocalParameterIivNV #-}
ptr_glGetProgramLocalParameterIivNV :: FunPtr (GLenum -> GLuint -> Ptr GLint -> IO ())
ptr_glGetProgramLocalParameterIivNV = unsafePerformIO $ getCommand "glGetProgramLocalParameterIivNV"

-- glGetProgramLocalParameterIuivNV --------------------------------------------

glGetProgramLocalParameterIuivNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTarget@.
  -> GLuint -- ^ @index@.
  -> Ptr GLuint -- ^ @params@ pointing to @4@ elements of type @GLuint@.
  -> m ()
glGetProgramLocalParameterIuivNV v1 v2 v3 = liftIO $ dyn214 ptr_glGetProgramLocalParameterIuivNV v1 v2 v3

{-# NOINLINE ptr_glGetProgramLocalParameterIuivNV #-}
ptr_glGetProgramLocalParameterIuivNV :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
ptr_glGetProgramLocalParameterIuivNV = unsafePerformIO $ getCommand "glGetProgramLocalParameterIuivNV"

-- glGetProgramLocalParameterdvARB ---------------------------------------------

glGetProgramLocalParameterdvARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTargetARB@.
  -> GLuint -- ^ @index@.
  -> Ptr GLdouble -- ^ @params@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glGetProgramLocalParameterdvARB v1 v2 v3 = liftIO $ dyn330 ptr_glGetProgramLocalParameterdvARB v1 v2 v3

{-# NOINLINE ptr_glGetProgramLocalParameterdvARB #-}
ptr_glGetProgramLocalParameterdvARB :: FunPtr (GLenum -> GLuint -> Ptr GLdouble -> IO ())
ptr_glGetProgramLocalParameterdvARB = unsafePerformIO $ getCommand "glGetProgramLocalParameterdvARB"

-- glGetProgramLocalParameterfvARB ---------------------------------------------

glGetProgramLocalParameterfvARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTargetARB@.
  -> GLuint -- ^ @index@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetProgramLocalParameterfvARB v1 v2 v3 = liftIO $ dyn267 ptr_glGetProgramLocalParameterfvARB v1 v2 v3

{-# NOINLINE ptr_glGetProgramLocalParameterfvARB #-}
ptr_glGetProgramLocalParameterfvARB :: FunPtr (GLenum -> GLuint -> Ptr GLfloat -> IO ())
ptr_glGetProgramLocalParameterfvARB = unsafePerformIO $ getCommand "glGetProgramLocalParameterfvARB"

-- glGetProgramNamedParameterdvNV ----------------------------------------------

glGetProgramNamedParameterdvNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLsizei -- ^ @len@.
  -> Ptr GLubyte -- ^ @name@ pointing to @1@ element of type @GLubyte@.
  -> Ptr GLdouble -- ^ @params@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glGetProgramNamedParameterdvNV v1 v2 v3 v4 = liftIO $ dyn393 ptr_glGetProgramNamedParameterdvNV v1 v2 v3 v4

{-# NOINLINE ptr_glGetProgramNamedParameterdvNV #-}
ptr_glGetProgramNamedParameterdvNV :: FunPtr (GLuint -> GLsizei -> Ptr GLubyte -> Ptr GLdouble -> IO ())
ptr_glGetProgramNamedParameterdvNV = unsafePerformIO $ getCommand "glGetProgramNamedParameterdvNV"

-- glGetProgramNamedParameterfvNV ----------------------------------------------

glGetProgramNamedParameterfvNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLsizei -- ^ @len@.
  -> Ptr GLubyte -- ^ @name@ pointing to @1@ element of type @GLubyte@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetProgramNamedParameterfvNV v1 v2 v3 v4 = liftIO $ dyn394 ptr_glGetProgramNamedParameterfvNV v1 v2 v3 v4

{-# NOINLINE ptr_glGetProgramNamedParameterfvNV #-}
ptr_glGetProgramNamedParameterfvNV :: FunPtr (GLuint -> GLsizei -> Ptr GLubyte -> Ptr GLfloat -> IO ())
ptr_glGetProgramNamedParameterfvNV = unsafePerformIO $ getCommand "glGetProgramNamedParameterfvNV"

-- glGetProgramParameterdvNV ---------------------------------------------------

glGetProgramParameterdvNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @VertexAttribEnumNV@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnumNV@.
  -> Ptr GLdouble -- ^ @params@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glGetProgramParameterdvNV v1 v2 v3 v4 = liftIO $ dyn395 ptr_glGetProgramParameterdvNV v1 v2 v3 v4

{-# NOINLINE ptr_glGetProgramParameterdvNV #-}
ptr_glGetProgramParameterdvNV :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLdouble -> IO ())
ptr_glGetProgramParameterdvNV = unsafePerformIO $ getCommand "glGetProgramParameterdvNV"

-- glGetProgramParameterfvNV ---------------------------------------------------

glGetProgramParameterfvNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @VertexAttribEnumNV@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnumNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetProgramParameterfvNV v1 v2 v3 v4 = liftIO $ dyn350 ptr_glGetProgramParameterfvNV v1 v2 v3 v4

{-# NOINLINE ptr_glGetProgramParameterfvNV #-}
ptr_glGetProgramParameterfvNV :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetProgramParameterfvNV = unsafePerformIO $ getCommand "glGetProgramParameterfvNV"

-- glGetProgramPipelineInfoLog -------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramPipelineInfoLog.xhtml OpenGL 4.x>.
glGetProgramPipelineInfoLog
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @infoLog@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetProgramPipelineInfoLog v1 v2 v3 v4 = liftIO $ dyn331 ptr_glGetProgramPipelineInfoLog v1 v2 v3 v4

{-# NOINLINE ptr_glGetProgramPipelineInfoLog #-}
ptr_glGetProgramPipelineInfoLog :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetProgramPipelineInfoLog = unsafePerformIO $ getCommand "glGetProgramPipelineInfoLog"

-- glGetProgramPipelineInfoLogEXT ----------------------------------------------

glGetProgramPipelineInfoLogEXT
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @infoLog@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetProgramPipelineInfoLogEXT v1 v2 v3 v4 = liftIO $ dyn331 ptr_glGetProgramPipelineInfoLogEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetProgramPipelineInfoLogEXT #-}
ptr_glGetProgramPipelineInfoLogEXT :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetProgramPipelineInfoLogEXT = unsafePerformIO $ getCommand "glGetProgramPipelineInfoLogEXT"

-- glGetProgramPipelineiv ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramPipeline.xhtml OpenGL 4.x>.
glGetProgramPipelineiv
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetProgramPipelineiv v1 v2 v3 = liftIO $ dyn334 ptr_glGetProgramPipelineiv v1 v2 v3

{-# NOINLINE ptr_glGetProgramPipelineiv #-}
ptr_glGetProgramPipelineiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetProgramPipelineiv = unsafePerformIO $ getCommand "glGetProgramPipelineiv"

-- glGetProgramPipelineivEXT ---------------------------------------------------

glGetProgramPipelineivEXT
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetProgramPipelineivEXT v1 v2 v3 = liftIO $ dyn334 ptr_glGetProgramPipelineivEXT v1 v2 v3

{-# NOINLINE ptr_glGetProgramPipelineivEXT #-}
ptr_glGetProgramPipelineivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetProgramPipelineivEXT = unsafePerformIO $ getCommand "glGetProgramPipelineivEXT"

-- glGetProgramResourceIndex ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramResourceIndex.xhtml OpenGL 4.x>.
glGetProgramResourceIndex
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m GLuint
glGetProgramResourceIndex v1 v2 v3 = liftIO $ dyn396 ptr_glGetProgramResourceIndex v1 v2 v3

{-# NOINLINE ptr_glGetProgramResourceIndex #-}
ptr_glGetProgramResourceIndex :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLuint)
ptr_glGetProgramResourceIndex = unsafePerformIO $ getCommand "glGetProgramResourceIndex"

-- glGetProgramResourceLocation ------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramResourceLocation.xhtml OpenGL 4.x>.
glGetProgramResourceLocation
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m GLint
glGetProgramResourceLocation v1 v2 v3 = liftIO $ dyn397 ptr_glGetProgramResourceLocation v1 v2 v3

{-# NOINLINE ptr_glGetProgramResourceLocation #-}
ptr_glGetProgramResourceLocation :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLint)
ptr_glGetProgramResourceLocation = unsafePerformIO $ getCommand "glGetProgramResourceLocation"

-- glGetProgramResourceLocationIndex -------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramResourceLocationIndex.xhtml OpenGL 4.x>.
glGetProgramResourceLocationIndex
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m GLint
glGetProgramResourceLocationIndex v1 v2 v3 = liftIO $ dyn397 ptr_glGetProgramResourceLocationIndex v1 v2 v3

{-# NOINLINE ptr_glGetProgramResourceLocationIndex #-}
ptr_glGetProgramResourceLocationIndex :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLint)
ptr_glGetProgramResourceLocationIndex = unsafePerformIO $ getCommand "glGetProgramResourceLocationIndex"

-- glGetProgramResourceLocationIndexEXT ----------------------------------------

glGetProgramResourceLocationIndexEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m GLint
glGetProgramResourceLocationIndexEXT v1 v2 v3 = liftIO $ dyn397 ptr_glGetProgramResourceLocationIndexEXT v1 v2 v3

{-# NOINLINE ptr_glGetProgramResourceLocationIndexEXT #-}
ptr_glGetProgramResourceLocationIndexEXT :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLint)
ptr_glGetProgramResourceLocationIndexEXT = unsafePerformIO $ getCommand "glGetProgramResourceLocationIndexEXT"

-- glGetProgramResourceName ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramResourceName.xhtml OpenGL 4.x>.
glGetProgramResourceName
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @name@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetProgramResourceName v1 v2 v3 v4 v5 v6 = liftIO $ dyn303 ptr_glGetProgramResourceName v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetProgramResourceName #-}
ptr_glGetProgramResourceName :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetProgramResourceName = unsafePerformIO $ getCommand "glGetProgramResourceName"

-- glGetProgramResourcefvNV ----------------------------------------------------

glGetProgramResourcefvNV
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @propCount@.
  -> Ptr GLenum -- ^ @props@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@.
  -> Ptr GLfloat -- ^ @params@.
  -> m ()
glGetProgramResourcefvNV v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn398 ptr_glGetProgramResourcefvNV v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glGetProgramResourcefvNV #-}
ptr_glGetProgramResourcefvNV :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetProgramResourcefvNV = unsafePerformIO $ getCommand "glGetProgramResourcefvNV"

-- glGetProgramResourceiv ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramResource.xhtml OpenGL 4.x>.
glGetProgramResourceiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @programInterface@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @propCount@.
  -> Ptr GLenum -- ^ @props@ pointing to @propCount@ elements of type @GLenum@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLint -- ^ @params@ pointing to @bufSize@ elements of type @GLint@.
  -> m ()
glGetProgramResourceiv v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn399 ptr_glGetProgramResourceiv v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glGetProgramResourceiv #-}
ptr_glGetProgramResourceiv :: FunPtr (GLuint -> GLenum -> GLuint -> GLsizei -> Ptr GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLint -> IO ())
ptr_glGetProgramResourceiv = unsafePerformIO $ getCommand "glGetProgramResourceiv"

-- glGetProgramStageiv ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetProgramStage.xhtml OpenGL 4.x>.
glGetProgramStageiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @shadertype@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @values@ pointing to @1@ element of type @GLint@.
  -> m ()
glGetProgramStageiv v1 v2 v3 v4 = liftIO $ dyn363 ptr_glGetProgramStageiv v1 v2 v3 v4

{-# NOINLINE ptr_glGetProgramStageiv #-}
ptr_glGetProgramStageiv :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetProgramStageiv = unsafePerformIO $ getCommand "glGetProgramStageiv"

-- glGetProgramStringARB -------------------------------------------------------

glGetProgramStringARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTargetARB@.
  -> GLenum -- ^ @pname@ of type @ProgramStringPropertyARB@.
  -> Ptr a -- ^ @string@ pointing to @COMPSIZE(target,pname)@ elements of type @a@.
  -> m ()
glGetProgramStringARB v1 v2 v3 = liftIO $ dyn242 ptr_glGetProgramStringARB v1 v2 v3

{-# NOINLINE ptr_glGetProgramStringARB #-}
ptr_glGetProgramStringARB :: FunPtr (GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetProgramStringARB = unsafePerformIO $ getCommand "glGetProgramStringARB"

-- glGetProgramStringNV --------------------------------------------------------

glGetProgramStringNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnumNV@.
  -> Ptr GLubyte -- ^ @program@ pointing to @COMPSIZE(id,pname)@ elements of type @ProgramCharacterNV@.
  -> m ()
glGetProgramStringNV v1 v2 v3 = liftIO $ dyn400 ptr_glGetProgramStringNV v1 v2 v3

{-# NOINLINE ptr_glGetProgramStringNV #-}
ptr_glGetProgramStringNV :: FunPtr (GLuint -> GLenum -> Ptr GLubyte -> IO ())
ptr_glGetProgramStringNV = unsafePerformIO $ getCommand "glGetProgramStringNV"

-- glGetProgramSubroutineParameteruivNV ----------------------------------------

glGetProgramSubroutineParameteruivNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> Ptr GLuint -- ^ @param@ pointing to @COMPSIZE(target)@ elements of type @GLuint@.
  -> m ()
glGetProgramSubroutineParameteruivNV v1 v2 v3 = liftIO $ dyn214 ptr_glGetProgramSubroutineParameteruivNV v1 v2 v3

{-# NOINLINE ptr_glGetProgramSubroutineParameteruivNV #-}
ptr_glGetProgramSubroutineParameteruivNV :: FunPtr (GLenum -> GLuint -> Ptr GLuint -> IO ())
ptr_glGetProgramSubroutineParameteruivNV = unsafePerformIO $ getCommand "glGetProgramSubroutineParameteruivNV"

-- glGetProgramiv --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetProgram.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetProgram.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetProgram.xhtml OpenGL 4.x>.
glGetProgramiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetProgramiv v1 v2 v3 = liftIO $ dyn334 ptr_glGetProgramiv v1 v2 v3

{-# NOINLINE ptr_glGetProgramiv #-}
ptr_glGetProgramiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetProgramiv = unsafePerformIO $ getCommand "glGetProgramiv"

-- glGetProgramivARB -----------------------------------------------------------

glGetProgramivARB
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ProgramTargetARB@.
  -> GLenum -- ^ @pname@ of type @ProgramPropertyARB@.
  -> Ptr GLint -- ^ @params@ pointing to @1@ element of type @GLint@.
  -> m ()
glGetProgramivARB v1 v2 v3 = liftIO $ dyn133 ptr_glGetProgramivARB v1 v2 v3

{-# NOINLINE ptr_glGetProgramivARB #-}
ptr_glGetProgramivARB :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetProgramivARB = unsafePerformIO $ getCommand "glGetProgramivARB"

-- glGetProgramivNV ------------------------------------------------------------

glGetProgramivNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnumNV@.
  -> Ptr GLint -- ^ @params@ pointing to @4@ elements of type @GLint@.
  -> m ()
glGetProgramivNV v1 v2 v3 = liftIO $ dyn334 ptr_glGetProgramivNV v1 v2 v3

{-# NOINLINE ptr_glGetProgramivNV #-}
ptr_glGetProgramivNV :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetProgramivNV = unsafePerformIO $ getCommand "glGetProgramivNV"

-- glGetQueryBufferObjecti64v --------------------------------------------------

glGetQueryBufferObjecti64v
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@.
  -> GLintptr -- ^ @offset@.
  -> m ()
glGetQueryBufferObjecti64v v1 v2 v3 v4 = liftIO $ dyn401 ptr_glGetQueryBufferObjecti64v v1 v2 v3 v4

{-# NOINLINE ptr_glGetQueryBufferObjecti64v #-}
ptr_glGetQueryBufferObjecti64v :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptr -> IO ())
ptr_glGetQueryBufferObjecti64v = unsafePerformIO $ getCommand "glGetQueryBufferObjecti64v"

-- glGetQueryBufferObjectiv ----------------------------------------------------

glGetQueryBufferObjectiv
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@.
  -> GLintptr -- ^ @offset@.
  -> m ()
glGetQueryBufferObjectiv v1 v2 v3 v4 = liftIO $ dyn401 ptr_glGetQueryBufferObjectiv v1 v2 v3 v4

{-# NOINLINE ptr_glGetQueryBufferObjectiv #-}
ptr_glGetQueryBufferObjectiv :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptr -> IO ())
ptr_glGetQueryBufferObjectiv = unsafePerformIO $ getCommand "glGetQueryBufferObjectiv"

-- glGetQueryBufferObjectui64v -------------------------------------------------

glGetQueryBufferObjectui64v
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@.
  -> GLintptr -- ^ @offset@.
  -> m ()
glGetQueryBufferObjectui64v v1 v2 v3 v4 = liftIO $ dyn401 ptr_glGetQueryBufferObjectui64v v1 v2 v3 v4

{-# NOINLINE ptr_glGetQueryBufferObjectui64v #-}
ptr_glGetQueryBufferObjectui64v :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptr -> IO ())
ptr_glGetQueryBufferObjectui64v = unsafePerformIO $ getCommand "glGetQueryBufferObjectui64v"

-- glGetQueryBufferObjectuiv ---------------------------------------------------

glGetQueryBufferObjectuiv
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLuint -- ^ @buffer@.
  -> GLenum -- ^ @pname@.
  -> GLintptr -- ^ @offset@.
  -> m ()
glGetQueryBufferObjectuiv v1 v2 v3 v4 = liftIO $ dyn401 ptr_glGetQueryBufferObjectuiv v1 v2 v3 v4

{-# NOINLINE ptr_glGetQueryBufferObjectuiv #-}
ptr_glGetQueryBufferObjectuiv :: FunPtr (GLuint -> GLuint -> GLenum -> GLintptr -> IO ())
ptr_glGetQueryBufferObjectuiv = unsafePerformIO $ getCommand "glGetQueryBufferObjectuiv"

-- glGetQueryIndexediv ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetQueryIndexed.xhtml OpenGL 4.x>.
glGetQueryIndexediv
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetQueryIndexediv v1 v2 v3 v4 = liftIO $ dyn351 ptr_glGetQueryIndexediv v1 v2 v3 v4

{-# NOINLINE ptr_glGetQueryIndexediv #-}
ptr_glGetQueryIndexediv :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetQueryIndexediv = unsafePerformIO $ getCommand "glGetQueryIndexediv"

-- glGetQueryObjecti64v --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetQueryObject.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetQueryObject.xhtml OpenGL 4.x>.
glGetQueryObjecti64v
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint64 -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint64@.
  -> m ()
glGetQueryObjecti64v v1 v2 v3 = liftIO $ dyn359 ptr_glGetQueryObjecti64v v1 v2 v3

{-# NOINLINE ptr_glGetQueryObjecti64v #-}
ptr_glGetQueryObjecti64v :: FunPtr (GLuint -> GLenum -> Ptr GLint64 -> IO ())
ptr_glGetQueryObjecti64v = unsafePerformIO $ getCommand "glGetQueryObjecti64v"

-- glGetQueryObjecti64vEXT -----------------------------------------------------

-- | This command is an alias for 'glGetQueryObjecti64v'.
glGetQueryObjecti64vEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint64 -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint64@.
  -> m ()
glGetQueryObjecti64vEXT v1 v2 v3 = liftIO $ dyn359 ptr_glGetQueryObjecti64vEXT v1 v2 v3

{-# NOINLINE ptr_glGetQueryObjecti64vEXT #-}
ptr_glGetQueryObjecti64vEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint64 -> IO ())
ptr_glGetQueryObjecti64vEXT = unsafePerformIO $ getCommand "glGetQueryObjecti64vEXT"

-- glGetQueryObjectiv ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetQueryObject.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetQueryObject.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetQueryObject.xhtml OpenGL 4.x>.
glGetQueryObjectiv
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetQueryObjectiv v1 v2 v3 = liftIO $ dyn334 ptr_glGetQueryObjectiv v1 v2 v3

{-# NOINLINE ptr_glGetQueryObjectiv #-}
ptr_glGetQueryObjectiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetQueryObjectiv = unsafePerformIO $ getCommand "glGetQueryObjectiv"

-- glGetQueryObjectivARB -------------------------------------------------------

-- | This command is an alias for 'glGetQueryObjectiv'.
glGetQueryObjectivARB
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetQueryObjectivARB v1 v2 v3 = liftIO $ dyn334 ptr_glGetQueryObjectivARB v1 v2 v3

{-# NOINLINE ptr_glGetQueryObjectivARB #-}
ptr_glGetQueryObjectivARB :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetQueryObjectivARB = unsafePerformIO $ getCommand "glGetQueryObjectivARB"

-- glGetQueryObjectivEXT -------------------------------------------------------

-- | This command is an alias for 'glGetQueryObjectiv'.
glGetQueryObjectivEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetQueryObjectivEXT v1 v2 v3 = liftIO $ dyn334 ptr_glGetQueryObjectivEXT v1 v2 v3

{-# NOINLINE ptr_glGetQueryObjectivEXT #-}
ptr_glGetQueryObjectivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetQueryObjectivEXT = unsafePerformIO $ getCommand "glGetQueryObjectivEXT"

-- glGetQueryObjectui64v -------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetQueryObject.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetQueryObject.xhtml OpenGL 4.x>.
glGetQueryObjectui64v
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint64 -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint64@.
  -> m ()
glGetQueryObjectui64v v1 v2 v3 = liftIO $ dyn402 ptr_glGetQueryObjectui64v v1 v2 v3

{-# NOINLINE ptr_glGetQueryObjectui64v #-}
ptr_glGetQueryObjectui64v :: FunPtr (GLuint -> GLenum -> Ptr GLuint64 -> IO ())
ptr_glGetQueryObjectui64v = unsafePerformIO $ getCommand "glGetQueryObjectui64v"

-- glGetQueryObjectui64vEXT ----------------------------------------------------

-- | This command is an alias for 'glGetQueryObjectui64v'.
glGetQueryObjectui64vEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint64 -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint64@.
  -> m ()
glGetQueryObjectui64vEXT v1 v2 v3 = liftIO $ dyn402 ptr_glGetQueryObjectui64vEXT v1 v2 v3

{-# NOINLINE ptr_glGetQueryObjectui64vEXT #-}
ptr_glGetQueryObjectui64vEXT :: FunPtr (GLuint -> GLenum -> Ptr GLuint64 -> IO ())
ptr_glGetQueryObjectui64vEXT = unsafePerformIO $ getCommand "glGetQueryObjectui64vEXT"

-- glGetQueryObjectuiv ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetQueryObject.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetQueryObject.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetQueryObject.xhtml OpenGL 4.x>.
glGetQueryObjectuiv
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetQueryObjectuiv v1 v2 v3 = liftIO $ dyn375 ptr_glGetQueryObjectuiv v1 v2 v3

{-# NOINLINE ptr_glGetQueryObjectuiv #-}
ptr_glGetQueryObjectuiv :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetQueryObjectuiv = unsafePerformIO $ getCommand "glGetQueryObjectuiv"

-- glGetQueryObjectuivARB ------------------------------------------------------

-- | This command is an alias for 'glGetQueryObjectuiv'.
glGetQueryObjectuivARB
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetQueryObjectuivARB v1 v2 v3 = liftIO $ dyn375 ptr_glGetQueryObjectuivARB v1 v2 v3

{-# NOINLINE ptr_glGetQueryObjectuivARB #-}
ptr_glGetQueryObjectuivARB :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetQueryObjectuivARB = unsafePerformIO $ getCommand "glGetQueryObjectuivARB"

-- glGetQueryObjectuivEXT ------------------------------------------------------

glGetQueryObjectuivEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint -- ^ @params@.
  -> m ()
glGetQueryObjectuivEXT v1 v2 v3 = liftIO $ dyn375 ptr_glGetQueryObjectuivEXT v1 v2 v3

{-# NOINLINE ptr_glGetQueryObjectuivEXT #-}
ptr_glGetQueryObjectuivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetQueryObjectuivEXT = unsafePerformIO $ getCommand "glGetQueryObjectuivEXT"

-- glGetQueryiv ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetQueryiv.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetQueryiv.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetQueryiv.xhtml OpenGL 4.x>.
glGetQueryiv
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetQueryiv v1 v2 v3 = liftIO $ dyn133 ptr_glGetQueryiv v1 v2 v3

{-# NOINLINE ptr_glGetQueryiv #-}
ptr_glGetQueryiv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetQueryiv = unsafePerformIO $ getCommand "glGetQueryiv"

-- glGetQueryivARB -------------------------------------------------------------

-- | This command is an alias for 'glGetQueryiv'.
glGetQueryivARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetQueryivARB v1 v2 v3 = liftIO $ dyn133 ptr_glGetQueryivARB v1 v2 v3

{-# NOINLINE ptr_glGetQueryivARB #-}
ptr_glGetQueryivARB :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetQueryivARB = unsafePerformIO $ getCommand "glGetQueryivARB"

-- glGetQueryivEXT -------------------------------------------------------------

glGetQueryivEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetQueryivEXT v1 v2 v3 = liftIO $ dyn133 ptr_glGetQueryivEXT v1 v2 v3

{-# NOINLINE ptr_glGetQueryivEXT #-}
ptr_glGetQueryivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetQueryivEXT = unsafePerformIO $ getCommand "glGetQueryivEXT"

-- glGetRenderbufferParameteriv ------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetRenderbufferParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetRenderbufferParameter.xhtml OpenGL 4.x>.
glGetRenderbufferParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type @RenderbufferTarget@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetRenderbufferParameteriv v1 v2 v3 = liftIO $ dyn133 ptr_glGetRenderbufferParameteriv v1 v2 v3

{-# NOINLINE ptr_glGetRenderbufferParameteriv #-}
ptr_glGetRenderbufferParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetRenderbufferParameteriv = unsafePerformIO $ getCommand "glGetRenderbufferParameteriv"

-- glGetRenderbufferParameterivEXT ---------------------------------------------

-- | This command is an alias for 'glGetRenderbufferParameteriv'.
glGetRenderbufferParameterivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type @RenderbufferTarget@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetRenderbufferParameterivEXT v1 v2 v3 = liftIO $ dyn133 ptr_glGetRenderbufferParameterivEXT v1 v2 v3

{-# NOINLINE ptr_glGetRenderbufferParameterivEXT #-}
ptr_glGetRenderbufferParameterivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetRenderbufferParameterivEXT = unsafePerformIO $ getCommand "glGetRenderbufferParameterivEXT"

-- glGetRenderbufferParameterivOES ---------------------------------------------

glGetRenderbufferParameterivOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetRenderbufferParameterivOES v1 v2 v3 = liftIO $ dyn133 ptr_glGetRenderbufferParameterivOES v1 v2 v3

{-# NOINLINE ptr_glGetRenderbufferParameterivOES #-}
ptr_glGetRenderbufferParameterivOES :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetRenderbufferParameterivOES = unsafePerformIO $ getCommand "glGetRenderbufferParameterivOES"

-- glGetSamplerParameterIiv ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetSamplerParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetSamplerParameter.xhtml OpenGL 4.x>.
glGetSamplerParameterIiv
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetSamplerParameterIiv v1 v2 v3 = liftIO $ dyn334 ptr_glGetSamplerParameterIiv v1 v2 v3

{-# NOINLINE ptr_glGetSamplerParameterIiv #-}
ptr_glGetSamplerParameterIiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetSamplerParameterIiv = unsafePerformIO $ getCommand "glGetSamplerParameterIiv"

-- glGetSamplerParameterIivEXT -------------------------------------------------

-- | This command is an alias for 'glGetSamplerParameterIiv'.
glGetSamplerParameterIivEXT
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetSamplerParameterIivEXT v1 v2 v3 = liftIO $ dyn334 ptr_glGetSamplerParameterIivEXT v1 v2 v3

{-# NOINLINE ptr_glGetSamplerParameterIivEXT #-}
ptr_glGetSamplerParameterIivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetSamplerParameterIivEXT = unsafePerformIO $ getCommand "glGetSamplerParameterIivEXT"

-- glGetSamplerParameterIivOES -------------------------------------------------

-- | This command is an alias for 'glGetSamplerParameterIiv'.
glGetSamplerParameterIivOES
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetSamplerParameterIivOES v1 v2 v3 = liftIO $ dyn334 ptr_glGetSamplerParameterIivOES v1 v2 v3

{-# NOINLINE ptr_glGetSamplerParameterIivOES #-}
ptr_glGetSamplerParameterIivOES :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetSamplerParameterIivOES = unsafePerformIO $ getCommand "glGetSamplerParameterIivOES"

-- glGetSamplerParameterIuiv ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetSamplerParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetSamplerParameter.xhtml OpenGL 4.x>.
glGetSamplerParameterIuiv
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetSamplerParameterIuiv v1 v2 v3 = liftIO $ dyn375 ptr_glGetSamplerParameterIuiv v1 v2 v3

{-# NOINLINE ptr_glGetSamplerParameterIuiv #-}
ptr_glGetSamplerParameterIuiv :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetSamplerParameterIuiv = unsafePerformIO $ getCommand "glGetSamplerParameterIuiv"

-- glGetSamplerParameterIuivEXT ------------------------------------------------

-- | This command is an alias for 'glGetSamplerParameterIuiv'.
glGetSamplerParameterIuivEXT
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetSamplerParameterIuivEXT v1 v2 v3 = liftIO $ dyn375 ptr_glGetSamplerParameterIuivEXT v1 v2 v3

{-# NOINLINE ptr_glGetSamplerParameterIuivEXT #-}
ptr_glGetSamplerParameterIuivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetSamplerParameterIuivEXT = unsafePerformIO $ getCommand "glGetSamplerParameterIuivEXT"

-- glGetSamplerParameterIuivOES ------------------------------------------------

-- | This command is an alias for 'glGetSamplerParameterIuiv'.
glGetSamplerParameterIuivOES
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetSamplerParameterIuivOES v1 v2 v3 = liftIO $ dyn375 ptr_glGetSamplerParameterIuivOES v1 v2 v3

{-# NOINLINE ptr_glGetSamplerParameterIuivOES #-}
ptr_glGetSamplerParameterIuivOES :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetSamplerParameterIuivOES = unsafePerformIO $ getCommand "glGetSamplerParameterIuivOES"

-- glGetSamplerParameterfv -----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetSamplerParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetSamplerParameter.xhtml OpenGL 4.x>.
glGetSamplerParameterfv
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetSamplerParameterfv v1 v2 v3 = liftIO $ dyn349 ptr_glGetSamplerParameterfv v1 v2 v3

{-# NOINLINE ptr_glGetSamplerParameterfv #-}
ptr_glGetSamplerParameterfv :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetSamplerParameterfv = unsafePerformIO $ getCommand "glGetSamplerParameterfv"

-- glGetSamplerParameteriv -----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetSamplerParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetSamplerParameter.xhtml OpenGL 4.x>.
glGetSamplerParameteriv
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetSamplerParameteriv v1 v2 v3 = liftIO $ dyn334 ptr_glGetSamplerParameteriv v1 v2 v3

{-# NOINLINE ptr_glGetSamplerParameteriv #-}
ptr_glGetSamplerParameteriv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetSamplerParameteriv = unsafePerformIO $ getCommand "glGetSamplerParameteriv"

-- glGetSeparableFilter --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetSeparableFilter.xml OpenGL 2.x>.
glGetSeparableFilter
  :: MonadIO m
  => GLenum -- ^ @target@ of type @SeparableTarget@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @row@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> Ptr b -- ^ @column@ pointing to @COMPSIZE(target,format,type)@ elements of type @b@.
  -> Ptr c -- ^ @span@ pointing to @COMPSIZE(target,format,type)@ elements of type @c@.
  -> m ()
glGetSeparableFilter v1 v2 v3 v4 v5 v6 = liftIO $ dyn403 ptr_glGetSeparableFilter v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetSeparableFilter #-}
ptr_glGetSeparableFilter :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> Ptr b -> Ptr c -> IO ())
ptr_glGetSeparableFilter = unsafePerformIO $ getCommand "glGetSeparableFilter"

-- glGetSeparableFilterEXT -----------------------------------------------------

glGetSeparableFilterEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [SeparableTargetEXT](Graphics-GL-Groups.html#SeparableTargetEXT).
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @row@ pointing to @COMPSIZE(target,format,type)@ elements of type @a@.
  -> Ptr b -- ^ @column@ pointing to @COMPSIZE(target,format,type)@ elements of type @b@.
  -> Ptr c -- ^ @span@ pointing to @COMPSIZE(target,format,type)@ elements of type @c@.
  -> m ()
glGetSeparableFilterEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn403 ptr_glGetSeparableFilterEXT v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetSeparableFilterEXT #-}
ptr_glGetSeparableFilterEXT :: FunPtr (GLenum -> GLenum -> GLenum -> Ptr a -> Ptr b -> Ptr c -> IO ())
ptr_glGetSeparableFilterEXT = unsafePerformIO $ getCommand "glGetSeparableFilterEXT"

-- glGetShaderInfoLog ----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetShaderInfoLog.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetShaderInfoLog.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetShaderInfoLog.xhtml OpenGL 4.x>.
glGetShaderInfoLog
  :: MonadIO m
  => GLuint -- ^ @shader@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @infoLog@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetShaderInfoLog v1 v2 v3 v4 = liftIO $ dyn331 ptr_glGetShaderInfoLog v1 v2 v3 v4

{-# NOINLINE ptr_glGetShaderInfoLog #-}
ptr_glGetShaderInfoLog :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetShaderInfoLog = unsafePerformIO $ getCommand "glGetShaderInfoLog"

-- glGetShaderPrecisionFormat --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetShaderPrecisionFormat.xhtml OpenGL 4.x>.
glGetShaderPrecisionFormat
  :: MonadIO m
  => GLenum -- ^ @shadertype@.
  -> GLenum -- ^ @precisiontype@.
  -> Ptr GLint -- ^ @range@ pointing to @2@ elements of type @GLint@.
  -> Ptr GLint -- ^ @precision@ pointing to @2@ elements of type @GLint@.
  -> m ()
glGetShaderPrecisionFormat v1 v2 v3 v4 = liftIO $ dyn404 ptr_glGetShaderPrecisionFormat v1 v2 v3 v4

{-# NOINLINE ptr_glGetShaderPrecisionFormat #-}
ptr_glGetShaderPrecisionFormat :: FunPtr (GLenum -> GLenum -> Ptr GLint -> Ptr GLint -> IO ())
ptr_glGetShaderPrecisionFormat = unsafePerformIO $ getCommand "glGetShaderPrecisionFormat"

-- glGetShaderSource -----------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetShaderSource.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetShaderSource.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetShaderSource.xhtml OpenGL 4.x>.
glGetShaderSource
  :: MonadIO m
  => GLuint -- ^ @shader@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @source@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetShaderSource v1 v2 v3 v4 = liftIO $ dyn331 ptr_glGetShaderSource v1 v2 v3 v4

{-# NOINLINE ptr_glGetShaderSource #-}
ptr_glGetShaderSource :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetShaderSource = unsafePerformIO $ getCommand "glGetShaderSource"

-- glGetShaderSourceARB --------------------------------------------------------

-- | This command is an alias for 'glGetShaderSource'.
glGetShaderSourceARB
  :: MonadIO m
  => GLhandleARB -- ^ @obj@ of type @handleARB@.
  -> GLsizei -- ^ @maxLength@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLcharARB -- ^ @source@ pointing to @maxLength@ elements of type @GLcharARB@.
  -> m ()
glGetShaderSourceARB v1 v2 v3 v4 = liftIO $ dyn338 ptr_glGetShaderSourceARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetShaderSourceARB #-}
ptr_glGetShaderSourceARB :: FunPtr (GLhandleARB -> GLsizei -> Ptr GLsizei -> Ptr GLcharARB -> IO ())
ptr_glGetShaderSourceARB = unsafePerformIO $ getCommand "glGetShaderSourceARB"

-- glGetShaderiv ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetShader.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetShader.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetShader.xhtml OpenGL 4.x>.
glGetShaderiv
  :: MonadIO m
  => GLuint -- ^ @shader@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetShaderiv v1 v2 v3 = liftIO $ dyn334 ptr_glGetShaderiv v1 v2 v3

{-# NOINLINE ptr_glGetShaderiv #-}
ptr_glGetShaderiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetShaderiv = unsafePerformIO $ getCommand "glGetShaderiv"

-- glGetSharpenTexFuncSGIS -----------------------------------------------------

glGetSharpenTexFuncSGIS
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> Ptr GLfloat -- ^ @points@ pointing to @COMPSIZE(target)@ elements of type @GLfloat@.
  -> m ()
glGetSharpenTexFuncSGIS v1 v2 = liftIO $ dyn94 ptr_glGetSharpenTexFuncSGIS v1 v2

{-# NOINLINE ptr_glGetSharpenTexFuncSGIS #-}
ptr_glGetSharpenTexFuncSGIS :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetSharpenTexFuncSGIS = unsafePerformIO $ getCommand "glGetSharpenTexFuncSGIS"

-- glGetStageIndexNV -----------------------------------------------------------

glGetStageIndexNV
  :: MonadIO m
  => GLenum -- ^ @shadertype@.
  -> m GLushort
glGetStageIndexNV v1 = liftIO $ dyn405 ptr_glGetStageIndexNV v1

{-# NOINLINE ptr_glGetStageIndexNV #-}
ptr_glGetStageIndexNV :: FunPtr (GLenum -> IO GLushort)
ptr_glGetStageIndexNV = unsafePerformIO $ getCommand "glGetStageIndexNV"

-- glGetString -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetString.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetString.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetString.xhtml OpenGL 4.x>.
glGetString
  :: MonadIO m
  => GLenum -- ^ @name@ of type [StringName](Graphics-GL-Groups.html#StringName).
  -> m (Ptr GLubyte) -- ^ pointing to elements of type @String@.
glGetString v1 = liftIO $ dyn406 ptr_glGetString v1

{-# NOINLINE ptr_glGetString #-}
ptr_glGetString :: FunPtr (GLenum -> IO (Ptr GLubyte))
ptr_glGetString = unsafePerformIO $ getCommand "glGetString"

-- glGetStringi ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetString.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetString.xhtml OpenGL 4.x>.
glGetStringi
  :: MonadIO m
  => GLenum -- ^ @name@.
  -> GLuint -- ^ @index@.
  -> m (Ptr GLubyte) -- ^ pointing to elements of type @String@.
glGetStringi v1 v2 = liftIO $ dyn407 ptr_glGetStringi v1 v2

{-# NOINLINE ptr_glGetStringi #-}
ptr_glGetStringi :: FunPtr (GLenum -> GLuint -> IO (Ptr GLubyte))
ptr_glGetStringi = unsafePerformIO $ getCommand "glGetStringi"

-- glGetSubroutineIndex --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetSubroutineIndex.xhtml OpenGL 4.x>.
glGetSubroutineIndex
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @shadertype@.
  -> Ptr GLchar -- ^ @name@.
  -> m GLuint
glGetSubroutineIndex v1 v2 v3 = liftIO $ dyn396 ptr_glGetSubroutineIndex v1 v2 v3

{-# NOINLINE ptr_glGetSubroutineIndex #-}
ptr_glGetSubroutineIndex :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLuint)
ptr_glGetSubroutineIndex = unsafePerformIO $ getCommand "glGetSubroutineIndex"

-- glGetSubroutineUniformLocation ----------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetSubroutineUniformLocation.xhtml OpenGL 4.x>.
glGetSubroutineUniformLocation
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLenum -- ^ @shadertype@.
  -> Ptr GLchar -- ^ @name@.
  -> m GLint
glGetSubroutineUniformLocation v1 v2 v3 = liftIO $ dyn397 ptr_glGetSubroutineUniformLocation v1 v2 v3

{-# NOINLINE ptr_glGetSubroutineUniformLocation #-}
ptr_glGetSubroutineUniformLocation :: FunPtr (GLuint -> GLenum -> Ptr GLchar -> IO GLint)
ptr_glGetSubroutineUniformLocation = unsafePerformIO $ getCommand "glGetSubroutineUniformLocation"

-- glGetSynciv -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetSync.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetSync.xhtml OpenGL 4.x>.
glGetSynciv
  :: MonadIO m
  => GLsync -- ^ @sync@ of type @sync@.
  -> GLenum -- ^ @pname@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLint -- ^ @values@ pointing to @bufSize@ elements of type @GLint@.
  -> m ()
glGetSynciv v1 v2 v3 v4 v5 = liftIO $ dyn408 ptr_glGetSynciv v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetSynciv #-}
ptr_glGetSynciv :: FunPtr (GLsync -> GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLint -> IO ())
ptr_glGetSynciv = unsafePerformIO $ getCommand "glGetSynciv"

-- glGetSyncivAPPLE ------------------------------------------------------------

-- | This command is an alias for 'glGetSynciv'.
glGetSyncivAPPLE
  :: MonadIO m
  => GLsync -- ^ @sync@.
  -> GLenum -- ^ @pname@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@.
  -> Ptr GLint -- ^ @values@ pointing to @bufSize@ elements of type @GLint@.
  -> m ()
glGetSyncivAPPLE v1 v2 v3 v4 v5 = liftIO $ dyn408 ptr_glGetSyncivAPPLE v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetSyncivAPPLE #-}
ptr_glGetSyncivAPPLE :: FunPtr (GLsync -> GLenum -> GLsizei -> Ptr GLsizei -> Ptr GLint -> IO ())
ptr_glGetSyncivAPPLE = unsafePerformIO $ getCommand "glGetSyncivAPPLE"

-- glGetTexBumpParameterfvATI --------------------------------------------------

glGetTexBumpParameterfvATI
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @GetTexBumpParameterATI@.
  -> Ptr GLfloat -- ^ @param@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetTexBumpParameterfvATI v1 v2 = liftIO $ dyn94 ptr_glGetTexBumpParameterfvATI v1 v2

{-# NOINLINE ptr_glGetTexBumpParameterfvATI #-}
ptr_glGetTexBumpParameterfvATI :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTexBumpParameterfvATI = unsafePerformIO $ getCommand "glGetTexBumpParameterfvATI"

-- glGetTexBumpParameterivATI --------------------------------------------------

glGetTexBumpParameterivATI
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @GetTexBumpParameterATI@.
  -> Ptr GLint -- ^ @param@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexBumpParameterivATI v1 v2 = liftIO $ dyn136 ptr_glGetTexBumpParameterivATI v1 v2

{-# NOINLINE ptr_glGetTexBumpParameterivATI #-}
ptr_glGetTexBumpParameterivATI :: FunPtr (GLenum -> Ptr GLint -> IO ())
ptr_glGetTexBumpParameterivATI = unsafePerformIO $ getCommand "glGetTexBumpParameterivATI"

-- glGetTexEnvfv ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexEnv.xml OpenGL 2.x>.
glGetTexEnvfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureEnvTarget](Graphics-GL-Groups.html#TextureEnvTarget).
  -> GLenum -- ^ @pname@ of type [TextureEnvParameter](Graphics-GL-Groups.html#TextureEnvParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetTexEnvfv v1 v2 v3 = liftIO $ dyn132 ptr_glGetTexEnvfv v1 v2 v3

{-# NOINLINE ptr_glGetTexEnvfv #-}
ptr_glGetTexEnvfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTexEnvfv = unsafePerformIO $ getCommand "glGetTexEnvfv"

-- glGetTexEnviv ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexEnv.xml OpenGL 2.x>.
glGetTexEnviv
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureEnvTarget](Graphics-GL-Groups.html#TextureEnvTarget).
  -> GLenum -- ^ @pname@ of type [TextureEnvParameter](Graphics-GL-Groups.html#TextureEnvParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexEnviv v1 v2 v3 = liftIO $ dyn133 ptr_glGetTexEnviv v1 v2 v3

{-# NOINLINE ptr_glGetTexEnviv #-}
ptr_glGetTexEnviv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexEnviv = unsafePerformIO $ getCommand "glGetTexEnviv"

-- glGetTexEnvxv ---------------------------------------------------------------

glGetTexEnvxv
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetTexEnvxv v1 v2 v3 = liftIO $ dyn163 ptr_glGetTexEnvxv v1 v2 v3

{-# NOINLINE ptr_glGetTexEnvxv #-}
ptr_glGetTexEnvxv :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetTexEnvxv = unsafePerformIO $ getCommand "glGetTexEnvxv"

-- glGetTexEnvxvOES ------------------------------------------------------------

glGetTexEnvxvOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetTexEnvxvOES v1 v2 v3 = liftIO $ dyn163 ptr_glGetTexEnvxvOES v1 v2 v3

{-# NOINLINE ptr_glGetTexEnvxvOES #-}
ptr_glGetTexEnvxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetTexEnvxvOES = unsafePerformIO $ getCommand "glGetTexEnvxvOES"

-- glGetTexFilterFuncSGIS ------------------------------------------------------

glGetTexFilterFuncSGIS
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @filter@ of type @TextureFilterSGIS@.
  -> Ptr GLfloat -- ^ @weights@ pointing to @COMPSIZE(target,filter)@ elements of type @GLfloat@.
  -> m ()
glGetTexFilterFuncSGIS v1 v2 v3 = liftIO $ dyn132 ptr_glGetTexFilterFuncSGIS v1 v2 v3

{-# NOINLINE ptr_glGetTexFilterFuncSGIS #-}
ptr_glGetTexFilterFuncSGIS :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTexFilterFuncSGIS = unsafePerformIO $ getCommand "glGetTexFilterFuncSGIS"

-- glGetTexGendv ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexGen.xml OpenGL 2.x>.
glGetTexGendv
  :: MonadIO m
  => GLenum -- ^ @coord@ of type [TextureCoordName](Graphics-GL-Groups.html#TextureCoordName).
  -> GLenum -- ^ @pname@ of type [TextureGenParameter](Graphics-GL-Groups.html#TextureGenParameter).
  -> Ptr GLdouble -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLdouble@.
  -> m ()
glGetTexGendv v1 v2 v3 = liftIO $ dyn353 ptr_glGetTexGendv v1 v2 v3

{-# NOINLINE ptr_glGetTexGendv #-}
ptr_glGetTexGendv :: FunPtr (GLenum -> GLenum -> Ptr GLdouble -> IO ())
ptr_glGetTexGendv = unsafePerformIO $ getCommand "glGetTexGendv"

-- glGetTexGenfv ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexGen.xml OpenGL 2.x>.
glGetTexGenfv
  :: MonadIO m
  => GLenum -- ^ @coord@ of type [TextureCoordName](Graphics-GL-Groups.html#TextureCoordName).
  -> GLenum -- ^ @pname@ of type [TextureGenParameter](Graphics-GL-Groups.html#TextureGenParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetTexGenfv v1 v2 v3 = liftIO $ dyn132 ptr_glGetTexGenfv v1 v2 v3

{-# NOINLINE ptr_glGetTexGenfv #-}
ptr_glGetTexGenfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTexGenfv = unsafePerformIO $ getCommand "glGetTexGenfv"

-- glGetTexGenfvOES ------------------------------------------------------------

glGetTexGenfvOES
  :: MonadIO m
  => GLenum -- ^ @coord@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetTexGenfvOES v1 v2 v3 = liftIO $ dyn132 ptr_glGetTexGenfvOES v1 v2 v3

{-# NOINLINE ptr_glGetTexGenfvOES #-}
ptr_glGetTexGenfvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTexGenfvOES = unsafePerformIO $ getCommand "glGetTexGenfvOES"

-- glGetTexGeniv ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexGen.xml OpenGL 2.x>.
glGetTexGeniv
  :: MonadIO m
  => GLenum -- ^ @coord@ of type [TextureCoordName](Graphics-GL-Groups.html#TextureCoordName).
  -> GLenum -- ^ @pname@ of type [TextureGenParameter](Graphics-GL-Groups.html#TextureGenParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexGeniv v1 v2 v3 = liftIO $ dyn133 ptr_glGetTexGeniv v1 v2 v3

{-# NOINLINE ptr_glGetTexGeniv #-}
ptr_glGetTexGeniv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexGeniv = unsafePerformIO $ getCommand "glGetTexGeniv"

-- glGetTexGenivOES ------------------------------------------------------------

glGetTexGenivOES
  :: MonadIO m
  => GLenum -- ^ @coord@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexGenivOES v1 v2 v3 = liftIO $ dyn133 ptr_glGetTexGenivOES v1 v2 v3

{-# NOINLINE ptr_glGetTexGenivOES #-}
ptr_glGetTexGenivOES :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexGenivOES = unsafePerformIO $ getCommand "glGetTexGenivOES"

-- glGetTexGenxvOES ------------------------------------------------------------

glGetTexGenxvOES
  :: MonadIO m
  => GLenum -- ^ @coord@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetTexGenxvOES v1 v2 v3 = liftIO $ dyn163 ptr_glGetTexGenxvOES v1 v2 v3

{-# NOINLINE ptr_glGetTexGenxvOES #-}
ptr_glGetTexGenxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetTexGenxvOES = unsafePerformIO $ getCommand "glGetTexGenxvOES"

-- glGetTexImage ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexImage.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexImage.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTexImage.xhtml OpenGL 4.x>.
glGetTexImage
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @pixels@ pointing to @COMPSIZE(target,level,format,type)@ elements of type @a@.
  -> m ()
glGetTexImage v1 v2 v3 v4 v5 = liftIO $ dyn409 ptr_glGetTexImage v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetTexImage #-}
ptr_glGetTexImage :: FunPtr (GLenum -> GLint -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetTexImage = unsafePerformIO $ getCommand "glGetTexImage"

-- glGetTexLevelParameterfv ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexLevelParameter.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexLevelParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTexLevelParameter.xhtml OpenGL 4.x>.
glGetTexLevelParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetTexLevelParameterfv v1 v2 v3 v4 = liftIO $ dyn410 ptr_glGetTexLevelParameterfv v1 v2 v3 v4

{-# NOINLINE ptr_glGetTexLevelParameterfv #-}
ptr_glGetTexLevelParameterfv :: FunPtr (GLenum -> GLint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTexLevelParameterfv = unsafePerformIO $ getCommand "glGetTexLevelParameterfv"

-- glGetTexLevelParameteriv ----------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexLevelParameter.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexLevelParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTexLevelParameter.xhtml OpenGL 4.x>.
glGetTexLevelParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexLevelParameteriv v1 v2 v3 v4 = liftIO $ dyn411 ptr_glGetTexLevelParameteriv v1 v2 v3 v4

{-# NOINLINE ptr_glGetTexLevelParameteriv #-}
ptr_glGetTexLevelParameteriv :: FunPtr (GLenum -> GLint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexLevelParameteriv = unsafePerformIO $ getCommand "glGetTexLevelParameteriv"

-- glGetTexLevelParameterxvOES -------------------------------------------------

glGetTexLevelParameterxvOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLint -- ^ @level@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetTexLevelParameterxvOES v1 v2 v3 v4 = liftIO $ dyn412 ptr_glGetTexLevelParameterxvOES v1 v2 v3 v4

{-# NOINLINE ptr_glGetTexLevelParameterxvOES #-}
ptr_glGetTexLevelParameterxvOES :: FunPtr (GLenum -> GLint -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetTexLevelParameterxvOES = unsafePerformIO $ getCommand "glGetTexLevelParameterxvOES"

-- glGetTexParameterIiv --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTexParameter.xhtml OpenGL 4.x>.
glGetTexParameterIiv
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexParameterIiv v1 v2 v3 = liftIO $ dyn133 ptr_glGetTexParameterIiv v1 v2 v3

{-# NOINLINE ptr_glGetTexParameterIiv #-}
ptr_glGetTexParameterIiv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexParameterIiv = unsafePerformIO $ getCommand "glGetTexParameterIiv"

-- glGetTexParameterIivEXT -----------------------------------------------------

-- | This command is an alias for 'glGetTexParameterIiv'.
glGetTexParameterIivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexParameterIivEXT v1 v2 v3 = liftIO $ dyn133 ptr_glGetTexParameterIivEXT v1 v2 v3

{-# NOINLINE ptr_glGetTexParameterIivEXT #-}
ptr_glGetTexParameterIivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexParameterIivEXT = unsafePerformIO $ getCommand "glGetTexParameterIivEXT"

-- glGetTexParameterIivOES -----------------------------------------------------

-- | This command is an alias for 'glGetTexParameterIiv'.
glGetTexParameterIivOES
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexParameterIivOES v1 v2 v3 = liftIO $ dyn133 ptr_glGetTexParameterIivOES v1 v2 v3

{-# NOINLINE ptr_glGetTexParameterIivOES #-}
ptr_glGetTexParameterIivOES :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexParameterIivOES = unsafePerformIO $ getCommand "glGetTexParameterIivOES"

-- glGetTexParameterIuiv -------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTexParameter.xhtml OpenGL 4.x>.
glGetTexParameterIuiv
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetTexParameterIuiv v1 v2 v3 = liftIO $ dyn413 ptr_glGetTexParameterIuiv v1 v2 v3

{-# NOINLINE ptr_glGetTexParameterIuiv #-}
ptr_glGetTexParameterIuiv :: FunPtr (GLenum -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetTexParameterIuiv = unsafePerformIO $ getCommand "glGetTexParameterIuiv"

-- glGetTexParameterIuivEXT ----------------------------------------------------

-- | This command is an alias for 'glGetTexParameterIuiv'.
glGetTexParameterIuivEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetTexParameterIuivEXT v1 v2 v3 = liftIO $ dyn413 ptr_glGetTexParameterIuivEXT v1 v2 v3

{-# NOINLINE ptr_glGetTexParameterIuivEXT #-}
ptr_glGetTexParameterIuivEXT :: FunPtr (GLenum -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetTexParameterIuivEXT = unsafePerformIO $ getCommand "glGetTexParameterIuivEXT"

-- glGetTexParameterIuivOES ----------------------------------------------------

-- | This command is an alias for 'glGetTexParameterIuiv'.
glGetTexParameterIuivOES
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetTexParameterIuivOES v1 v2 v3 = liftIO $ dyn413 ptr_glGetTexParameterIuivOES v1 v2 v3

{-# NOINLINE ptr_glGetTexParameterIuivOES #-}
ptr_glGetTexParameterIuivOES :: FunPtr (GLenum -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetTexParameterIuivOES = unsafePerformIO $ getCommand "glGetTexParameterIuivOES"

-- glGetTexParameterPointervAPPLE ----------------------------------------------

glGetTexParameterPointervAPPLE
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr (Ptr a) -- ^ @params@ pointing to @1@ element of type @Ptr a@.
  -> m ()
glGetTexParameterPointervAPPLE v1 v2 v3 = liftIO $ dyn316 ptr_glGetTexParameterPointervAPPLE v1 v2 v3

{-# NOINLINE ptr_glGetTexParameterPointervAPPLE #-}
ptr_glGetTexParameterPointervAPPLE :: FunPtr (GLenum -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetTexParameterPointervAPPLE = unsafePerformIO $ getCommand "glGetTexParameterPointervAPPLE"

-- glGetTexParameterfv ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexParameter.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTexParameter.xhtml OpenGL 4.x>.
glGetTexParameterfv
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetTexParameterfv v1 v2 v3 = liftIO $ dyn132 ptr_glGetTexParameterfv v1 v2 v3

{-# NOINLINE ptr_glGetTexParameterfv #-}
ptr_glGetTexParameterfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTexParameterfv = unsafePerformIO $ getCommand "glGetTexParameterfv"

-- glGetTexParameteriv ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetTexParameter.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTexParameter.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTexParameter.xhtml OpenGL 4.x>.
glGetTexParameteriv
  :: MonadIO m
  => GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTexParameteriv v1 v2 v3 = liftIO $ dyn133 ptr_glGetTexParameteriv v1 v2 v3

{-# NOINLINE ptr_glGetTexParameteriv #-}
ptr_glGetTexParameteriv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTexParameteriv = unsafePerformIO $ getCommand "glGetTexParameteriv"

-- glGetTexParameterxv ---------------------------------------------------------

glGetTexParameterxv
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetTexParameterxv v1 v2 v3 = liftIO $ dyn163 ptr_glGetTexParameterxv v1 v2 v3

{-# NOINLINE ptr_glGetTexParameterxv #-}
ptr_glGetTexParameterxv :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetTexParameterxv = unsafePerformIO $ getCommand "glGetTexParameterxv"

-- glGetTexParameterxvOES ------------------------------------------------------

glGetTexParameterxvOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glGetTexParameterxvOES v1 v2 v3 = liftIO $ dyn163 ptr_glGetTexParameterxvOES v1 v2 v3

{-# NOINLINE ptr_glGetTexParameterxvOES #-}
ptr_glGetTexParameterxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glGetTexParameterxvOES = unsafePerformIO $ getCommand "glGetTexParameterxvOES"

-- glGetTextureHandleARB -------------------------------------------------------

glGetTextureHandleARB
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> m GLuint64
glGetTextureHandleARB v1 = liftIO $ dyn414 ptr_glGetTextureHandleARB v1

{-# NOINLINE ptr_glGetTextureHandleARB #-}
ptr_glGetTextureHandleARB :: FunPtr (GLuint -> IO GLuint64)
ptr_glGetTextureHandleARB = unsafePerformIO $ getCommand "glGetTextureHandleARB"

-- glGetTextureHandleNV --------------------------------------------------------

glGetTextureHandleNV
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> m GLuint64
glGetTextureHandleNV v1 = liftIO $ dyn414 ptr_glGetTextureHandleNV v1

{-# NOINLINE ptr_glGetTextureHandleNV #-}
ptr_glGetTextureHandleNV :: FunPtr (GLuint -> IO GLuint64)
ptr_glGetTextureHandleNV = unsafePerformIO $ getCommand "glGetTextureHandleNV"

-- glGetTextureImage -----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetTexImage.xhtml OpenGL 4.x>.
glGetTextureImage
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @pixels@.
  -> m ()
glGetTextureImage v1 v2 v3 v4 v5 v6 = liftIO $ dyn415 ptr_glGetTextureImage v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetTextureImage #-}
ptr_glGetTextureImage :: FunPtr (GLuint -> GLint -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glGetTextureImage = unsafePerformIO $ getCommand "glGetTextureImage"

-- glGetTextureImageEXT --------------------------------------------------------

glGetTextureImageEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @format@ of type [PixelFormat](Graphics-GL-Groups.html#PixelFormat).
  -> GLenum -- ^ @type@ of type [PixelType](Graphics-GL-Groups.html#PixelType).
  -> Ptr a -- ^ @pixels@ pointing to @COMPSIZE(target,level,format,type)@ elements of type @a@.
  -> m ()
glGetTextureImageEXT v1 v2 v3 v4 v5 v6 = liftIO $ dyn416 ptr_glGetTextureImageEXT v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetTextureImageEXT #-}
ptr_glGetTextureImageEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> GLenum -> Ptr a -> IO ())
ptr_glGetTextureImageEXT = unsafePerformIO $ getCommand "glGetTextureImageEXT"

-- glGetTextureLevelParameterfv ------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetTexLevelParameter.xhtml OpenGL 4.x>.
glGetTextureLevelParameterfv
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfloat -- ^ @params@.
  -> m ()
glGetTextureLevelParameterfv v1 v2 v3 v4 = liftIO $ dyn417 ptr_glGetTextureLevelParameterfv v1 v2 v3 v4

{-# NOINLINE ptr_glGetTextureLevelParameterfv #-}
ptr_glGetTextureLevelParameterfv :: FunPtr (GLuint -> GLint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTextureLevelParameterfv = unsafePerformIO $ getCommand "glGetTextureLevelParameterfv"

-- glGetTextureLevelParameterfvEXT ---------------------------------------------

glGetTextureLevelParameterfvEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetTextureLevelParameterfvEXT v1 v2 v3 v4 v5 = liftIO $ dyn418 ptr_glGetTextureLevelParameterfvEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetTextureLevelParameterfvEXT #-}
ptr_glGetTextureLevelParameterfvEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTextureLevelParameterfvEXT = unsafePerformIO $ getCommand "glGetTextureLevelParameterfvEXT"

-- glGetTextureLevelParameteriv ------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetTexLevelParameter.xhtml OpenGL 4.x>.
glGetTextureLevelParameteriv
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetTextureLevelParameteriv v1 v2 v3 v4 = liftIO $ dyn419 ptr_glGetTextureLevelParameteriv v1 v2 v3 v4

{-# NOINLINE ptr_glGetTextureLevelParameteriv #-}
ptr_glGetTextureLevelParameteriv :: FunPtr (GLuint -> GLint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTextureLevelParameteriv = unsafePerformIO $ getCommand "glGetTextureLevelParameteriv"

-- glGetTextureLevelParameterivEXT ---------------------------------------------

glGetTextureLevelParameterivEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLint -- ^ @level@ of type @CheckedInt32@.
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTextureLevelParameterivEXT v1 v2 v3 v4 v5 = liftIO $ dyn271 ptr_glGetTextureLevelParameterivEXT v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetTextureLevelParameterivEXT #-}
ptr_glGetTextureLevelParameterivEXT :: FunPtr (GLuint -> GLenum -> GLint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTextureLevelParameterivEXT = unsafePerformIO $ getCommand "glGetTextureLevelParameterivEXT"

-- glGetTextureParameterIiv ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetTexParameter.xhtml OpenGL 4.x>.
glGetTextureParameterIiv
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetTextureParameterIiv v1 v2 v3 = liftIO $ dyn334 ptr_glGetTextureParameterIiv v1 v2 v3

{-# NOINLINE ptr_glGetTextureParameterIiv #-}
ptr_glGetTextureParameterIiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTextureParameterIiv = unsafePerformIO $ getCommand "glGetTextureParameterIiv"

-- glGetTextureParameterIivEXT -------------------------------------------------

glGetTextureParameterIivEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTextureParameterIivEXT v1 v2 v3 v4 = liftIO $ dyn363 ptr_glGetTextureParameterIivEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetTextureParameterIivEXT #-}
ptr_glGetTextureParameterIivEXT :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTextureParameterIivEXT = unsafePerformIO $ getCommand "glGetTextureParameterIivEXT"

-- glGetTextureParameterIuiv ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetTexParameter.xhtml OpenGL 4.x>.
glGetTextureParameterIuiv
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint -- ^ @params@.
  -> m ()
glGetTextureParameterIuiv v1 v2 v3 = liftIO $ dyn375 ptr_glGetTextureParameterIuiv v1 v2 v3

{-# NOINLINE ptr_glGetTextureParameterIuiv #-}
ptr_glGetTextureParameterIuiv :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetTextureParameterIuiv = unsafePerformIO $ getCommand "glGetTextureParameterIuiv"

-- glGetTextureParameterIuivEXT ------------------------------------------------

glGetTextureParameterIuivEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetTextureParameterIuivEXT v1 v2 v3 v4 = liftIO $ dyn420 ptr_glGetTextureParameterIuivEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetTextureParameterIuivEXT #-}
ptr_glGetTextureParameterIuivEXT :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetTextureParameterIuivEXT = unsafePerformIO $ getCommand "glGetTextureParameterIuivEXT"

-- glGetTextureParameterfv -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetTexParameter.xhtml OpenGL 4.x>.
glGetTextureParameterfv
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfloat -- ^ @params@.
  -> m ()
glGetTextureParameterfv v1 v2 v3 = liftIO $ dyn349 ptr_glGetTextureParameterfv v1 v2 v3

{-# NOINLINE ptr_glGetTextureParameterfv #-}
ptr_glGetTextureParameterfv :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTextureParameterfv = unsafePerformIO $ getCommand "glGetTextureParameterfv"

-- glGetTextureParameterfvEXT --------------------------------------------------

glGetTextureParameterfvEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetTextureParameterfvEXT v1 v2 v3 v4 = liftIO $ dyn421 ptr_glGetTextureParameterfvEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetTextureParameterfvEXT #-}
ptr_glGetTextureParameterfvEXT :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetTextureParameterfvEXT = unsafePerformIO $ getCommand "glGetTextureParameterfvEXT"

-- glGetTextureParameteriv -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetTexParameter.xhtml OpenGL 4.x>.
glGetTextureParameteriv
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetTextureParameteriv v1 v2 v3 = liftIO $ dyn334 ptr_glGetTextureParameteriv v1 v2 v3

{-# NOINLINE ptr_glGetTextureParameteriv #-}
ptr_glGetTextureParameteriv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTextureParameteriv = unsafePerformIO $ getCommand "glGetTextureParameteriv"

-- glGetTextureParameterivEXT --------------------------------------------------

glGetTextureParameterivEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> GLenum -- ^ @target@ of type [TextureTarget](Graphics-GL-Groups.html#TextureTarget).
  -> GLenum -- ^ @pname@ of type [GetTextureParameter](Graphics-GL-Groups.html#GetTextureParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetTextureParameterivEXT v1 v2 v3 v4 = liftIO $ dyn363 ptr_glGetTextureParameterivEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetTextureParameterivEXT #-}
ptr_glGetTextureParameterivEXT :: FunPtr (GLuint -> GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTextureParameterivEXT = unsafePerformIO $ getCommand "glGetTextureParameterivEXT"

-- glGetTextureSamplerHandleARB ------------------------------------------------

glGetTextureSamplerHandleARB
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLuint -- ^ @sampler@.
  -> m GLuint64
glGetTextureSamplerHandleARB v1 v2 = liftIO $ dyn422 ptr_glGetTextureSamplerHandleARB v1 v2

{-# NOINLINE ptr_glGetTextureSamplerHandleARB #-}
ptr_glGetTextureSamplerHandleARB :: FunPtr (GLuint -> GLuint -> IO GLuint64)
ptr_glGetTextureSamplerHandleARB = unsafePerformIO $ getCommand "glGetTextureSamplerHandleARB"

-- glGetTextureSamplerHandleNV -------------------------------------------------

glGetTextureSamplerHandleNV
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLuint -- ^ @sampler@.
  -> m GLuint64
glGetTextureSamplerHandleNV v1 v2 = liftIO $ dyn422 ptr_glGetTextureSamplerHandleNV v1 v2

{-# NOINLINE ptr_glGetTextureSamplerHandleNV #-}
ptr_glGetTextureSamplerHandleNV :: FunPtr (GLuint -> GLuint -> IO GLuint64)
ptr_glGetTextureSamplerHandleNV = unsafePerformIO $ getCommand "glGetTextureSamplerHandleNV"

-- glGetTextureSubImage --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetTextureSubImage.xhtml OpenGL 4.x>.
glGetTextureSubImage
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @pixels@.
  -> m ()
glGetTextureSubImage v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12 = liftIO $ dyn423 ptr_glGetTextureSubImage v1 v2 v3 v4 v5 v6 v7 v8 v9 v10 v11 v12

{-# NOINLINE ptr_glGetTextureSubImage #-}
ptr_glGetTextureSubImage :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glGetTextureSubImage = unsafePerformIO $ getCommand "glGetTextureSubImage"

-- glGetTrackMatrixivNV --------------------------------------------------------

glGetTrackMatrixivNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @VertexAttribEnumNV@.
  -> GLuint -- ^ @address@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnumNV@.
  -> Ptr GLint -- ^ @params@ pointing to @1@ element of type @GLint@.
  -> m ()
glGetTrackMatrixivNV v1 v2 v3 v4 = liftIO $ dyn351 ptr_glGetTrackMatrixivNV v1 v2 v3 v4

{-# NOINLINE ptr_glGetTrackMatrixivNV #-}
ptr_glGetTrackMatrixivNV :: FunPtr (GLenum -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTrackMatrixivNV = unsafePerformIO $ getCommand "glGetTrackMatrixivNV"

-- glGetTransformFeedbackVarying -----------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetTransformFeedbackVarying.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetTransformFeedbackVarying.xhtml OpenGL 4.x>.
glGetTransformFeedbackVarying
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLsizei -- ^ @size@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLenum -- ^ @type@ pointing to @1@ element of type @GLenum@.
  -> Ptr GLchar -- ^ @name@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetTransformFeedbackVarying v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn307 ptr_glGetTransformFeedbackVarying v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glGetTransformFeedbackVarying #-}
ptr_glGetTransformFeedbackVarying :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLsizei -> Ptr GLenum -> Ptr GLchar -> IO ())
ptr_glGetTransformFeedbackVarying = unsafePerformIO $ getCommand "glGetTransformFeedbackVarying"

-- glGetTransformFeedbackVaryingEXT --------------------------------------------

-- | This command is an alias for 'glGetTransformFeedbackVarying'.
glGetTransformFeedbackVaryingEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @index@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLsizei -- ^ @size@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLenum -- ^ @type@ pointing to @1@ element of type @GLenum@.
  -> Ptr GLchar -- ^ @name@ pointing to @bufSize@ elements of type @GLchar@.
  -> m ()
glGetTransformFeedbackVaryingEXT v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn307 ptr_glGetTransformFeedbackVaryingEXT v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glGetTransformFeedbackVaryingEXT #-}
ptr_glGetTransformFeedbackVaryingEXT :: FunPtr (GLuint -> GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLsizei -> Ptr GLenum -> Ptr GLchar -> IO ())
ptr_glGetTransformFeedbackVaryingEXT = unsafePerformIO $ getCommand "glGetTransformFeedbackVaryingEXT"

-- glGetTransformFeedbackVaryingNV ---------------------------------------------

glGetTransformFeedbackVaryingNV
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint -- ^ @location@ pointing to @1@ element of type @GLint@.
  -> m ()
glGetTransformFeedbackVaryingNV v1 v2 v3 = liftIO $ dyn424 ptr_glGetTransformFeedbackVaryingNV v1 v2 v3

{-# NOINLINE ptr_glGetTransformFeedbackVaryingNV #-}
ptr_glGetTransformFeedbackVaryingNV :: FunPtr (GLuint -> GLuint -> Ptr GLint -> IO ())
ptr_glGetTransformFeedbackVaryingNV = unsafePerformIO $ getCommand "glGetTransformFeedbackVaryingNV"

-- glGetTransformFeedbacki64_v -------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetTransformFeedback.xhtml OpenGL 4.x>.
glGetTransformFeedbacki64_v
  :: MonadIO m
  => GLuint -- ^ @xfb@.
  -> GLenum -- ^ @pname@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint64 -- ^ @param@.
  -> m ()
glGetTransformFeedbacki64_v v1 v2 v3 v4 = liftIO $ dyn425 ptr_glGetTransformFeedbacki64_v v1 v2 v3 v4

{-# NOINLINE ptr_glGetTransformFeedbacki64_v #-}
ptr_glGetTransformFeedbacki64_v :: FunPtr (GLuint -> GLenum -> GLuint -> Ptr GLint64 -> IO ())
ptr_glGetTransformFeedbacki64_v = unsafePerformIO $ getCommand "glGetTransformFeedbacki64_v"

-- glGetTransformFeedbacki_v ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetTransformFeedback.xhtml OpenGL 4.x>.
glGetTransformFeedbacki_v
  :: MonadIO m
  => GLuint -- ^ @xfb@.
  -> GLenum -- ^ @pname@.
  -> GLuint -- ^ @index@.
  -> Ptr GLint -- ^ @param@.
  -> m ()
glGetTransformFeedbacki_v v1 v2 v3 v4 = liftIO $ dyn364 ptr_glGetTransformFeedbacki_v v1 v2 v3 v4

{-# NOINLINE ptr_glGetTransformFeedbacki_v #-}
ptr_glGetTransformFeedbacki_v :: FunPtr (GLuint -> GLenum -> GLuint -> Ptr GLint -> IO ())
ptr_glGetTransformFeedbacki_v = unsafePerformIO $ getCommand "glGetTransformFeedbacki_v"

-- glGetTransformFeedbackiv ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetTransformFeedback.xhtml OpenGL 4.x>.
glGetTransformFeedbackiv
  :: MonadIO m
  => GLuint -- ^ @xfb@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @param@.
  -> m ()
glGetTransformFeedbackiv v1 v2 v3 = liftIO $ dyn334 ptr_glGetTransformFeedbackiv v1 v2 v3

{-# NOINLINE ptr_glGetTransformFeedbackiv #-}
ptr_glGetTransformFeedbackiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetTransformFeedbackiv = unsafePerformIO $ getCommand "glGetTransformFeedbackiv"

-- glGetTranslatedShaderSourceANGLE --------------------------------------------

glGetTranslatedShaderSourceANGLE
  :: MonadIO m
  => GLuint -- ^ @shader@.
  -> GLsizei -- ^ @bufsize@.
  -> Ptr GLsizei -- ^ @length@ pointing to @1@ element of type @GLsizei@.
  -> Ptr GLchar -- ^ @source@.
  -> m ()
glGetTranslatedShaderSourceANGLE v1 v2 v3 v4 = liftIO $ dyn331 ptr_glGetTranslatedShaderSourceANGLE v1 v2 v3 v4

{-# NOINLINE ptr_glGetTranslatedShaderSourceANGLE #-}
ptr_glGetTranslatedShaderSourceANGLE :: FunPtr (GLuint -> GLsizei -> Ptr GLsizei -> Ptr GLchar -> IO ())
ptr_glGetTranslatedShaderSourceANGLE = unsafePerformIO $ getCommand "glGetTranslatedShaderSourceANGLE"

-- glGetUniformBlockIndex ------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetUniformBlockIndex.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetUniformBlockIndex.xhtml OpenGL 4.x>.
glGetUniformBlockIndex
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> Ptr GLchar -- ^ @uniformBlockName@ pointing to @COMPSIZE()@ elements of type @GLchar@.
  -> m GLuint
glGetUniformBlockIndex v1 v2 = liftIO $ dyn426 ptr_glGetUniformBlockIndex v1 v2

{-# NOINLINE ptr_glGetUniformBlockIndex #-}
ptr_glGetUniformBlockIndex :: FunPtr (GLuint -> Ptr GLchar -> IO GLuint)
ptr_glGetUniformBlockIndex = unsafePerformIO $ getCommand "glGetUniformBlockIndex"

-- glGetUniformBufferSizeEXT ---------------------------------------------------

glGetUniformBufferSizeEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> m GLint
glGetUniformBufferSizeEXT v1 v2 = liftIO $ dyn427 ptr_glGetUniformBufferSizeEXT v1 v2

{-# NOINLINE ptr_glGetUniformBufferSizeEXT #-}
ptr_glGetUniformBufferSizeEXT :: FunPtr (GLuint -> GLint -> IO GLint)
ptr_glGetUniformBufferSizeEXT = unsafePerformIO $ getCommand "glGetUniformBufferSizeEXT"

-- glGetUniformIndices ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetUniformIndices.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetUniformIndices.xhtml OpenGL 4.x>.
glGetUniformIndices
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLsizei -- ^ @uniformCount@.
  -> Ptr (Ptr GLchar) -- ^ @uniformNames@ pointing to @COMPSIZE(uniformCount)@ elements of type @Ptr GLchar@.
  -> Ptr GLuint -- ^ @uniformIndices@ pointing to @COMPSIZE(uniformCount)@ elements of type @GLuint@.
  -> m ()
glGetUniformIndices v1 v2 v3 v4 = liftIO $ dyn428 ptr_glGetUniformIndices v1 v2 v3 v4

{-# NOINLINE ptr_glGetUniformIndices #-}
ptr_glGetUniformIndices :: FunPtr (GLuint -> GLsizei -> Ptr (Ptr GLchar) -> Ptr GLuint -> IO ())
ptr_glGetUniformIndices = unsafePerformIO $ getCommand "glGetUniformIndices"

-- glGetUniformLocation --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetUniformLocation.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetUniformLocation.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetUniformLocation.xhtml OpenGL 4.x>.
glGetUniformLocation
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> Ptr GLchar -- ^ @name@.
  -> m GLint
glGetUniformLocation v1 v2 = liftIO $ dyn310 ptr_glGetUniformLocation v1 v2

{-# NOINLINE ptr_glGetUniformLocation #-}
ptr_glGetUniformLocation :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
ptr_glGetUniformLocation = unsafePerformIO $ getCommand "glGetUniformLocation"

-- glGetUniformLocationARB -----------------------------------------------------

-- | This command is an alias for 'glGetUniformLocation'.
glGetUniformLocationARB
  :: MonadIO m
  => GLhandleARB -- ^ @programObj@ of type @handleARB@.
  -> Ptr GLcharARB -- ^ @name@.
  -> m GLint
glGetUniformLocationARB v1 v2 = liftIO $ dyn311 ptr_glGetUniformLocationARB v1 v2

{-# NOINLINE ptr_glGetUniformLocationARB #-}
ptr_glGetUniformLocationARB :: FunPtr (GLhandleARB -> Ptr GLcharARB -> IO GLint)
ptr_glGetUniformLocationARB = unsafePerformIO $ getCommand "glGetUniformLocationARB"

-- glGetUniformOffsetEXT -------------------------------------------------------

glGetUniformOffsetEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> m GLintptr -- ^ of type @BufferOffset@.
glGetUniformOffsetEXT v1 v2 = liftIO $ dyn429 ptr_glGetUniformOffsetEXT v1 v2

{-# NOINLINE ptr_glGetUniformOffsetEXT #-}
ptr_glGetUniformOffsetEXT :: FunPtr (GLuint -> GLint -> IO GLintptr)
ptr_glGetUniformOffsetEXT = unsafePerformIO $ getCommand "glGetUniformOffsetEXT"

-- glGetUniformSubroutineuiv ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetUniformSubroutine.xhtml OpenGL 4.x>.
glGetUniformSubroutineuiv
  :: MonadIO m
  => GLenum -- ^ @shadertype@.
  -> GLint -- ^ @location@.
  -> Ptr GLuint -- ^ @params@ pointing to @1@ element of type @GLuint@.
  -> m ()
glGetUniformSubroutineuiv v1 v2 v3 = liftIO $ dyn75 ptr_glGetUniformSubroutineuiv v1 v2 v3

{-# NOINLINE ptr_glGetUniformSubroutineuiv #-}
ptr_glGetUniformSubroutineuiv :: FunPtr (GLenum -> GLint -> Ptr GLuint -> IO ())
ptr_glGetUniformSubroutineuiv = unsafePerformIO $ getCommand "glGetUniformSubroutineuiv"

-- glGetUniformdv --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetUniform.xhtml OpenGL 4.x>.
glGetUniformdv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> Ptr GLdouble -- ^ @params@ pointing to @COMPSIZE(program,location)@ elements of type @GLdouble@.
  -> m ()
glGetUniformdv v1 v2 v3 = liftIO $ dyn430 ptr_glGetUniformdv v1 v2 v3

{-# NOINLINE ptr_glGetUniformdv #-}
ptr_glGetUniformdv :: FunPtr (GLuint -> GLint -> Ptr GLdouble -> IO ())
ptr_glGetUniformdv = unsafePerformIO $ getCommand "glGetUniformdv"

-- glGetUniformfv --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetUniform.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetUniform.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetUniform.xhtml OpenGL 4.x>.
glGetUniformfv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(program,location)@ elements of type @GLfloat@.
  -> m ()
glGetUniformfv v1 v2 v3 = liftIO $ dyn431 ptr_glGetUniformfv v1 v2 v3

{-# NOINLINE ptr_glGetUniformfv #-}
ptr_glGetUniformfv :: FunPtr (GLuint -> GLint -> Ptr GLfloat -> IO ())
ptr_glGetUniformfv = unsafePerformIO $ getCommand "glGetUniformfv"

-- glGetUniformfvARB -----------------------------------------------------------

-- | This command is an alias for 'glGetUniformfv'.
glGetUniformfvARB
  :: MonadIO m
  => GLhandleARB -- ^ @programObj@ of type @handleARB@.
  -> GLint -- ^ @location@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(programObj,location)@ elements of type @GLfloat@.
  -> m ()
glGetUniformfvARB v1 v2 v3 = liftIO $ dyn432 ptr_glGetUniformfvARB v1 v2 v3

{-# NOINLINE ptr_glGetUniformfvARB #-}
ptr_glGetUniformfvARB :: FunPtr (GLhandleARB -> GLint -> Ptr GLfloat -> IO ())
ptr_glGetUniformfvARB = unsafePerformIO $ getCommand "glGetUniformfvARB"

-- glGetUniformi64vARB ---------------------------------------------------------

glGetUniformi64vARB
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> Ptr GLint64 -- ^ @params@ pointing to @COMPSIZE(program,location)@ elements of type @GLint64@.
  -> m ()
glGetUniformi64vARB v1 v2 v3 = liftIO $ dyn433 ptr_glGetUniformi64vARB v1 v2 v3

{-# NOINLINE ptr_glGetUniformi64vARB #-}
ptr_glGetUniformi64vARB :: FunPtr (GLuint -> GLint -> Ptr GLint64 -> IO ())
ptr_glGetUniformi64vARB = unsafePerformIO $ getCommand "glGetUniformi64vARB"

-- glGetUniformi64vNV ----------------------------------------------------------

glGetUniformi64vNV
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> Ptr GLint64EXT -- ^ @params@ pointing to @COMPSIZE(program,location)@ elements of type @GLint64EXT@.
  -> m ()
glGetUniformi64vNV v1 v2 v3 = liftIO $ dyn434 ptr_glGetUniformi64vNV v1 v2 v3

{-# NOINLINE ptr_glGetUniformi64vNV #-}
ptr_glGetUniformi64vNV :: FunPtr (GLuint -> GLint -> Ptr GLint64EXT -> IO ())
ptr_glGetUniformi64vNV = unsafePerformIO $ getCommand "glGetUniformi64vNV"

-- glGetUniformiv --------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetUniform.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetUniform.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetUniform.xhtml OpenGL 4.x>.
glGetUniformiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(program,location)@ elements of type @GLint@.
  -> m ()
glGetUniformiv v1 v2 v3 = liftIO $ dyn435 ptr_glGetUniformiv v1 v2 v3

{-# NOINLINE ptr_glGetUniformiv #-}
ptr_glGetUniformiv :: FunPtr (GLuint -> GLint -> Ptr GLint -> IO ())
ptr_glGetUniformiv = unsafePerformIO $ getCommand "glGetUniformiv"

-- glGetUniformivARB -----------------------------------------------------------

-- | This command is an alias for 'glGetUniformiv'.
glGetUniformivARB
  :: MonadIO m
  => GLhandleARB -- ^ @programObj@ of type @handleARB@.
  -> GLint -- ^ @location@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(programObj,location)@ elements of type @GLint@.
  -> m ()
glGetUniformivARB v1 v2 v3 = liftIO $ dyn436 ptr_glGetUniformivARB v1 v2 v3

{-# NOINLINE ptr_glGetUniformivARB #-}
ptr_glGetUniformivARB :: FunPtr (GLhandleARB -> GLint -> Ptr GLint -> IO ())
ptr_glGetUniformivARB = unsafePerformIO $ getCommand "glGetUniformivARB"

-- glGetUniformui64vARB --------------------------------------------------------

glGetUniformui64vARB
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> Ptr GLuint64 -- ^ @params@ pointing to @COMPSIZE(program,location)@ elements of type @GLuint64@.
  -> m ()
glGetUniformui64vARB v1 v2 v3 = liftIO $ dyn437 ptr_glGetUniformui64vARB v1 v2 v3

{-# NOINLINE ptr_glGetUniformui64vARB #-}
ptr_glGetUniformui64vARB :: FunPtr (GLuint -> GLint -> Ptr GLuint64 -> IO ())
ptr_glGetUniformui64vARB = unsafePerformIO $ getCommand "glGetUniformui64vARB"

-- glGetUniformui64vNV ---------------------------------------------------------

glGetUniformui64vNV
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> Ptr GLuint64EXT -- ^ @params@ pointing to @COMPSIZE(program,location)@ elements of type @GLuint64EXT@.
  -> m ()
glGetUniformui64vNV v1 v2 v3 = liftIO $ dyn438 ptr_glGetUniformui64vNV v1 v2 v3

{-# NOINLINE ptr_glGetUniformui64vNV #-}
ptr_glGetUniformui64vNV :: FunPtr (GLuint -> GLint -> Ptr GLuint64EXT -> IO ())
ptr_glGetUniformui64vNV = unsafePerformIO $ getCommand "glGetUniformui64vNV"

-- glGetUniformuiv -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetUniform.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetUniform.xhtml OpenGL 4.x>.
glGetUniformuiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(program,location)@ elements of type @GLuint@.
  -> m ()
glGetUniformuiv v1 v2 v3 = liftIO $ dyn439 ptr_glGetUniformuiv v1 v2 v3

{-# NOINLINE ptr_glGetUniformuiv #-}
ptr_glGetUniformuiv :: FunPtr (GLuint -> GLint -> Ptr GLuint -> IO ())
ptr_glGetUniformuiv = unsafePerformIO $ getCommand "glGetUniformuiv"

-- glGetUniformuivEXT ----------------------------------------------------------

-- | This command is an alias for 'glGetUniformuiv'.
glGetUniformuivEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(program,location)@ elements of type @GLuint@.
  -> m ()
glGetUniformuivEXT v1 v2 v3 = liftIO $ dyn439 ptr_glGetUniformuivEXT v1 v2 v3

{-# NOINLINE ptr_glGetUniformuivEXT #-}
ptr_glGetUniformuivEXT :: FunPtr (GLuint -> GLint -> Ptr GLuint -> IO ())
ptr_glGetUniformuivEXT = unsafePerformIO $ getCommand "glGetUniformuivEXT"

-- glGetVariantArrayObjectfvATI ------------------------------------------------

glGetVariantArrayObjectfvATI
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@ of type @ArrayObjectPNameATI@.
  -> Ptr GLfloat -- ^ @params@ pointing to @1@ element of type @GLfloat@.
  -> m ()
glGetVariantArrayObjectfvATI v1 v2 v3 = liftIO $ dyn349 ptr_glGetVariantArrayObjectfvATI v1 v2 v3

{-# NOINLINE ptr_glGetVariantArrayObjectfvATI #-}
ptr_glGetVariantArrayObjectfvATI :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetVariantArrayObjectfvATI = unsafePerformIO $ getCommand "glGetVariantArrayObjectfvATI"

-- glGetVariantArrayObjectivATI ------------------------------------------------

glGetVariantArrayObjectivATI
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @pname@ of type @ArrayObjectPNameATI@.
  -> Ptr GLint -- ^ @params@ pointing to @1@ element of type @GLint@.
  -> m ()
glGetVariantArrayObjectivATI v1 v2 v3 = liftIO $ dyn334 ptr_glGetVariantArrayObjectivATI v1 v2 v3

{-# NOINLINE ptr_glGetVariantArrayObjectivATI #-}
ptr_glGetVariantArrayObjectivATI :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVariantArrayObjectivATI = unsafePerformIO $ getCommand "glGetVariantArrayObjectivATI"

-- glGetVariantBooleanvEXT -----------------------------------------------------

glGetVariantBooleanvEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLboolean -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glGetVariantBooleanvEXT v1 v2 v3 = liftIO $ dyn348 ptr_glGetVariantBooleanvEXT v1 v2 v3

{-# NOINLINE ptr_glGetVariantBooleanvEXT #-}
ptr_glGetVariantBooleanvEXT :: FunPtr (GLuint -> GLenum -> Ptr GLboolean -> IO ())
ptr_glGetVariantBooleanvEXT = unsafePerformIO $ getCommand "glGetVariantBooleanvEXT"

-- glGetVariantFloatvEXT -------------------------------------------------------

glGetVariantFloatvEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLfloat -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type @GLfloat@.
  -> m ()
glGetVariantFloatvEXT v1 v2 v3 = liftIO $ dyn349 ptr_glGetVariantFloatvEXT v1 v2 v3

{-# NOINLINE ptr_glGetVariantFloatvEXT #-}
ptr_glGetVariantFloatvEXT :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetVariantFloatvEXT = unsafePerformIO $ getCommand "glGetVariantFloatvEXT"

-- glGetVariantIntegervEXT -----------------------------------------------------

glGetVariantIntegervEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr GLint -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type @GLint@.
  -> m ()
glGetVariantIntegervEXT v1 v2 v3 = liftIO $ dyn334 ptr_glGetVariantIntegervEXT v1 v2 v3

{-# NOINLINE ptr_glGetVariantIntegervEXT #-}
ptr_glGetVariantIntegervEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVariantIntegervEXT = unsafePerformIO $ getCommand "glGetVariantIntegervEXT"

-- glGetVariantPointervEXT -----------------------------------------------------

glGetVariantPointervEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @value@ of type @GetVariantValueEXT@.
  -> Ptr (Ptr a) -- ^ @data@ pointing to @COMPSIZE(id)@ elements of type @Ptr a@.
  -> m ()
glGetVariantPointervEXT v1 v2 v3 = liftIO $ dyn361 ptr_glGetVariantPointervEXT v1 v2 v3

{-# NOINLINE ptr_glGetVariantPointervEXT #-}
ptr_glGetVariantPointervEXT :: FunPtr (GLuint -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetVariantPointervEXT = unsafePerformIO $ getCommand "glGetVariantPointervEXT"

-- glGetVaryingLocationNV ------------------------------------------------------

glGetVaryingLocationNV
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> Ptr GLchar -- ^ @name@ pointing to @COMPSIZE(name)@ elements of type @GLchar@.
  -> m GLint
glGetVaryingLocationNV v1 v2 = liftIO $ dyn310 ptr_glGetVaryingLocationNV v1 v2

{-# NOINLINE ptr_glGetVaryingLocationNV #-}
ptr_glGetVaryingLocationNV :: FunPtr (GLuint -> Ptr GLchar -> IO GLint)
ptr_glGetVaryingLocationNV = unsafePerformIO $ getCommand "glGetVaryingLocationNV"

-- glGetVertexArrayIndexed64iv -------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetVertexArrayIndexed.xhtml OpenGL 4.x>.
glGetVertexArrayIndexed64iv
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint64 -- ^ @param@.
  -> m ()
glGetVertexArrayIndexed64iv v1 v2 v3 v4 = liftIO $ dyn440 ptr_glGetVertexArrayIndexed64iv v1 v2 v3 v4

{-# NOINLINE ptr_glGetVertexArrayIndexed64iv #-}
ptr_glGetVertexArrayIndexed64iv :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr GLint64 -> IO ())
ptr_glGetVertexArrayIndexed64iv = unsafePerformIO $ getCommand "glGetVertexArrayIndexed64iv"

-- glGetVertexArrayIndexediv ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetVertexArrayIndexed.xhtml OpenGL 4.x>.
glGetVertexArrayIndexediv
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @param@.
  -> m ()
glGetVertexArrayIndexediv v1 v2 v3 v4 = liftIO $ dyn300 ptr_glGetVertexArrayIndexediv v1 v2 v3 v4

{-# NOINLINE ptr_glGetVertexArrayIndexediv #-}
ptr_glGetVertexArrayIndexediv :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVertexArrayIndexediv = unsafePerformIO $ getCommand "glGetVertexArrayIndexediv"

-- glGetVertexArrayIntegeri_vEXT -----------------------------------------------

glGetVertexArrayIntegeri_vEXT
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @param@.
  -> m ()
glGetVertexArrayIntegeri_vEXT v1 v2 v3 v4 = liftIO $ dyn300 ptr_glGetVertexArrayIntegeri_vEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetVertexArrayIntegeri_vEXT #-}
ptr_glGetVertexArrayIntegeri_vEXT :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVertexArrayIntegeri_vEXT = unsafePerformIO $ getCommand "glGetVertexArrayIntegeri_vEXT"

-- glGetVertexArrayIntegervEXT -------------------------------------------------

glGetVertexArrayIntegervEXT
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @param@.
  -> m ()
glGetVertexArrayIntegervEXT v1 v2 v3 = liftIO $ dyn334 ptr_glGetVertexArrayIntegervEXT v1 v2 v3

{-# NOINLINE ptr_glGetVertexArrayIntegervEXT #-}
ptr_glGetVertexArrayIntegervEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVertexArrayIntegervEXT = unsafePerformIO $ getCommand "glGetVertexArrayIntegervEXT"

-- glGetVertexArrayPointeri_vEXT -----------------------------------------------

glGetVertexArrayPointeri_vEXT
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> Ptr (Ptr a) -- ^ @param@.
  -> m ()
glGetVertexArrayPointeri_vEXT v1 v2 v3 v4 = liftIO $ dyn441 ptr_glGetVertexArrayPointeri_vEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetVertexArrayPointeri_vEXT #-}
ptr_glGetVertexArrayPointeri_vEXT :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetVertexArrayPointeri_vEXT = unsafePerformIO $ getCommand "glGetVertexArrayPointeri_vEXT"

-- glGetVertexArrayPointervEXT -------------------------------------------------

glGetVertexArrayPointervEXT
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLenum -- ^ @pname@.
  -> Ptr (Ptr a) -- ^ @param@ pointing to @1@ element of type @Ptr a@.
  -> m ()
glGetVertexArrayPointervEXT v1 v2 v3 = liftIO $ dyn361 ptr_glGetVertexArrayPointervEXT v1 v2 v3

{-# NOINLINE ptr_glGetVertexArrayPointervEXT #-}
ptr_glGetVertexArrayPointervEXT :: FunPtr (GLuint -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetVertexArrayPointervEXT = unsafePerformIO $ getCommand "glGetVertexArrayPointervEXT"

-- glGetVertexArrayiv ----------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetVertexArrayiv.xhtml OpenGL 4.x>.
glGetVertexArrayiv
  :: MonadIO m
  => GLuint -- ^ @vaobj@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @param@.
  -> m ()
glGetVertexArrayiv v1 v2 v3 = liftIO $ dyn334 ptr_glGetVertexArrayiv v1 v2 v3

{-# NOINLINE ptr_glGetVertexArrayiv #-}
ptr_glGetVertexArrayiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVertexArrayiv = unsafePerformIO $ getCommand "glGetVertexArrayiv"

-- glGetVertexAttribArrayObjectfvATI -------------------------------------------

glGetVertexAttribArrayObjectfvATI
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @ArrayObjectPNameATI@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetVertexAttribArrayObjectfvATI v1 v2 v3 = liftIO $ dyn349 ptr_glGetVertexAttribArrayObjectfvATI v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribArrayObjectfvATI #-}
ptr_glGetVertexAttribArrayObjectfvATI :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetVertexAttribArrayObjectfvATI = unsafePerformIO $ getCommand "glGetVertexAttribArrayObjectfvATI"

-- glGetVertexAttribArrayObjectivATI -------------------------------------------

glGetVertexAttribArrayObjectivATI
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @ArrayObjectPNameATI@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetVertexAttribArrayObjectivATI v1 v2 v3 = liftIO $ dyn334 ptr_glGetVertexAttribArrayObjectivATI v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribArrayObjectivATI #-}
ptr_glGetVertexAttribArrayObjectivATI :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVertexAttribArrayObjectivATI = unsafePerformIO $ getCommand "glGetVertexAttribArrayObjectivATI"

-- glGetVertexAttribIiv --------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetVertexAttrib.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetVertexAttrib.xhtml OpenGL 4.x>.
glGetVertexAttribIiv
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnum@.
  -> Ptr GLint -- ^ @params@ pointing to @1@ element of type @GLint@.
  -> m ()
glGetVertexAttribIiv v1 v2 v3 = liftIO $ dyn334 ptr_glGetVertexAttribIiv v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribIiv #-}
ptr_glGetVertexAttribIiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVertexAttribIiv = unsafePerformIO $ getCommand "glGetVertexAttribIiv"

-- glGetVertexAttribIivEXT -----------------------------------------------------

-- | This command is an alias for 'glGetVertexAttribIiv'.
glGetVertexAttribIivEXT
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnum@.
  -> Ptr GLint -- ^ @params@ pointing to @1@ element of type @GLint@.
  -> m ()
glGetVertexAttribIivEXT v1 v2 v3 = liftIO $ dyn334 ptr_glGetVertexAttribIivEXT v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribIivEXT #-}
ptr_glGetVertexAttribIivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVertexAttribIivEXT = unsafePerformIO $ getCommand "glGetVertexAttribIivEXT"

-- glGetVertexAttribIuiv -------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glGetVertexAttrib.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetVertexAttrib.xhtml OpenGL 4.x>.
glGetVertexAttribIuiv
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnum@.
  -> Ptr GLuint -- ^ @params@ pointing to @1@ element of type @GLuint@.
  -> m ()
glGetVertexAttribIuiv v1 v2 v3 = liftIO $ dyn375 ptr_glGetVertexAttribIuiv v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribIuiv #-}
ptr_glGetVertexAttribIuiv :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetVertexAttribIuiv = unsafePerformIO $ getCommand "glGetVertexAttribIuiv"

-- glGetVertexAttribIuivEXT ----------------------------------------------------

-- | This command is an alias for 'glGetVertexAttribIuiv'.
glGetVertexAttribIuivEXT
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnum@.
  -> Ptr GLuint -- ^ @params@ pointing to @1@ element of type @GLuint@.
  -> m ()
glGetVertexAttribIuivEXT v1 v2 v3 = liftIO $ dyn375 ptr_glGetVertexAttribIuivEXT v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribIuivEXT #-}
ptr_glGetVertexAttribIuivEXT :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetVertexAttribIuivEXT = unsafePerformIO $ getCommand "glGetVertexAttribIuivEXT"

-- glGetVertexAttribLdv --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetVertexAttrib.xhtml OpenGL 4.x>.
glGetVertexAttribLdv
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLdouble -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLdouble@.
  -> m ()
glGetVertexAttribLdv v1 v2 v3 = liftIO $ dyn442 ptr_glGetVertexAttribLdv v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribLdv #-}
ptr_glGetVertexAttribLdv :: FunPtr (GLuint -> GLenum -> Ptr GLdouble -> IO ())
ptr_glGetVertexAttribLdv = unsafePerformIO $ getCommand "glGetVertexAttribLdv"

-- glGetVertexAttribLdvEXT -----------------------------------------------------

-- | This command is an alias for 'glGetVertexAttribLdv'.
glGetVertexAttribLdvEXT
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLdouble -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLdouble@.
  -> m ()
glGetVertexAttribLdvEXT v1 v2 v3 = liftIO $ dyn442 ptr_glGetVertexAttribLdvEXT v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribLdvEXT #-}
ptr_glGetVertexAttribLdvEXT :: FunPtr (GLuint -> GLenum -> Ptr GLdouble -> IO ())
ptr_glGetVertexAttribLdvEXT = unsafePerformIO $ getCommand "glGetVertexAttribLdvEXT"

-- glGetVertexAttribLi64vNV ----------------------------------------------------

glGetVertexAttribLi64vNV
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint64EXT -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint64EXT@.
  -> m ()
glGetVertexAttribLi64vNV v1 v2 v3 = liftIO $ dyn443 ptr_glGetVertexAttribLi64vNV v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribLi64vNV #-}
ptr_glGetVertexAttribLi64vNV :: FunPtr (GLuint -> GLenum -> Ptr GLint64EXT -> IO ())
ptr_glGetVertexAttribLi64vNV = unsafePerformIO $ getCommand "glGetVertexAttribLi64vNV"

-- glGetVertexAttribLui64vARB --------------------------------------------------

glGetVertexAttribLui64vARB
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint64EXT -- ^ @params@.
  -> m ()
glGetVertexAttribLui64vARB v1 v2 v3 = liftIO $ dyn360 ptr_glGetVertexAttribLui64vARB v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribLui64vARB #-}
ptr_glGetVertexAttribLui64vARB :: FunPtr (GLuint -> GLenum -> Ptr GLuint64EXT -> IO ())
ptr_glGetVertexAttribLui64vARB = unsafePerformIO $ getCommand "glGetVertexAttribLui64vARB"

-- glGetVertexAttribLui64vNV ---------------------------------------------------

glGetVertexAttribLui64vNV
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint64EXT -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint64EXT@.
  -> m ()
glGetVertexAttribLui64vNV v1 v2 v3 = liftIO $ dyn360 ptr_glGetVertexAttribLui64vNV v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribLui64vNV #-}
ptr_glGetVertexAttribLui64vNV :: FunPtr (GLuint -> GLenum -> Ptr GLuint64EXT -> IO ())
ptr_glGetVertexAttribLui64vNV = unsafePerformIO $ getCommand "glGetVertexAttribLui64vNV"

-- glGetVertexAttribPointerv ---------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetVertexAttribPointerv.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetVertexAttribPointerv.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetVertexAttribPointerv.xhtml OpenGL 4.x>.
glGetVertexAttribPointerv
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribPointerPropertyARB@.
  -> Ptr (Ptr a) -- ^ @pointer@ pointing to @1@ element of type @Ptr a@.
  -> m ()
glGetVertexAttribPointerv v1 v2 v3 = liftIO $ dyn361 ptr_glGetVertexAttribPointerv v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribPointerv #-}
ptr_glGetVertexAttribPointerv :: FunPtr (GLuint -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetVertexAttribPointerv = unsafePerformIO $ getCommand "glGetVertexAttribPointerv"

-- glGetVertexAttribPointervARB ------------------------------------------------

-- | This command is an alias for 'glGetVertexAttribPointerv'.
glGetVertexAttribPointervARB
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribPointerPropertyARB@.
  -> Ptr (Ptr a) -- ^ @pointer@ pointing to @1@ element of type @Ptr a@.
  -> m ()
glGetVertexAttribPointervARB v1 v2 v3 = liftIO $ dyn361 ptr_glGetVertexAttribPointervARB v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribPointervARB #-}
ptr_glGetVertexAttribPointervARB :: FunPtr (GLuint -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetVertexAttribPointervARB = unsafePerformIO $ getCommand "glGetVertexAttribPointervARB"

-- glGetVertexAttribPointervNV -------------------------------------------------

-- | This command is an alias for 'glGetVertexAttribPointerv'.
glGetVertexAttribPointervNV
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnumNV@.
  -> Ptr (Ptr a) -- ^ @pointer@ pointing to @1@ element of type @Ptr a@.
  -> m ()
glGetVertexAttribPointervNV v1 v2 v3 = liftIO $ dyn361 ptr_glGetVertexAttribPointervNV v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribPointervNV #-}
ptr_glGetVertexAttribPointervNV :: FunPtr (GLuint -> GLenum -> Ptr (Ptr a) -> IO ())
ptr_glGetVertexAttribPointervNV = unsafePerformIO $ getCommand "glGetVertexAttribPointervNV"

-- glGetVertexAttribdv ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetVertexAttrib.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetVertexAttrib.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetVertexAttrib.xhtml OpenGL 4.x>.
glGetVertexAttribdv
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribPropertyARB@.
  -> Ptr GLdouble -- ^ @params@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glGetVertexAttribdv v1 v2 v3 = liftIO $ dyn442 ptr_glGetVertexAttribdv v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribdv #-}
ptr_glGetVertexAttribdv :: FunPtr (GLuint -> GLenum -> Ptr GLdouble -> IO ())
ptr_glGetVertexAttribdv = unsafePerformIO $ getCommand "glGetVertexAttribdv"

-- glGetVertexAttribdvARB ------------------------------------------------------

-- | This command is an alias for 'glGetVertexAttribdv'.
glGetVertexAttribdvARB
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribPropertyARB@.
  -> Ptr GLdouble -- ^ @params@ pointing to @4@ elements of type @GLdouble@.
  -> m ()
glGetVertexAttribdvARB v1 v2 v3 = liftIO $ dyn442 ptr_glGetVertexAttribdvARB v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribdvARB #-}
ptr_glGetVertexAttribdvARB :: FunPtr (GLuint -> GLenum -> Ptr GLdouble -> IO ())
ptr_glGetVertexAttribdvARB = unsafePerformIO $ getCommand "glGetVertexAttribdvARB"

-- glGetVertexAttribdvNV -------------------------------------------------------

-- | This command is an alias for 'glGetVertexAttribdv'.
glGetVertexAttribdvNV
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnumNV@.
  -> Ptr GLdouble -- ^ @params@ pointing to @1@ element of type @GLdouble@.
  -> m ()
glGetVertexAttribdvNV v1 v2 v3 = liftIO $ dyn442 ptr_glGetVertexAttribdvNV v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribdvNV #-}
ptr_glGetVertexAttribdvNV :: FunPtr (GLuint -> GLenum -> Ptr GLdouble -> IO ())
ptr_glGetVertexAttribdvNV = unsafePerformIO $ getCommand "glGetVertexAttribdvNV"

-- glGetVertexAttribfv ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetVertexAttrib.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetVertexAttrib.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetVertexAttrib.xhtml OpenGL 4.x>.
glGetVertexAttribfv
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribPropertyARB@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetVertexAttribfv v1 v2 v3 = liftIO $ dyn349 ptr_glGetVertexAttribfv v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribfv #-}
ptr_glGetVertexAttribfv :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetVertexAttribfv = unsafePerformIO $ getCommand "glGetVertexAttribfv"

-- glGetVertexAttribfvARB ------------------------------------------------------

-- | This command is an alias for 'glGetVertexAttribfv'.
glGetVertexAttribfvARB
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribPropertyARB@.
  -> Ptr GLfloat -- ^ @params@ pointing to @4@ elements of type @GLfloat@.
  -> m ()
glGetVertexAttribfvARB v1 v2 v3 = liftIO $ dyn349 ptr_glGetVertexAttribfvARB v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribfvARB #-}
ptr_glGetVertexAttribfvARB :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetVertexAttribfvARB = unsafePerformIO $ getCommand "glGetVertexAttribfvARB"

-- glGetVertexAttribfvNV -------------------------------------------------------

-- | This command is an alias for 'glGetVertexAttribfv'.
glGetVertexAttribfvNV
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnumNV@.
  -> Ptr GLfloat -- ^ @params@ pointing to @1@ element of type @GLfloat@.
  -> m ()
glGetVertexAttribfvNV v1 v2 v3 = liftIO $ dyn349 ptr_glGetVertexAttribfvNV v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribfvNV #-}
ptr_glGetVertexAttribfvNV :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetVertexAttribfvNV = unsafePerformIO $ getCommand "glGetVertexAttribfvNV"

-- glGetVertexAttribiv ---------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glGetVertexAttrib.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glGetVertexAttrib.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glGetVertexAttrib.xhtml OpenGL 4.x>.
glGetVertexAttribiv
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribPropertyARB@.
  -> Ptr GLint -- ^ @params@ pointing to @4@ elements of type @GLint@.
  -> m ()
glGetVertexAttribiv v1 v2 v3 = liftIO $ dyn334 ptr_glGetVertexAttribiv v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribiv #-}
ptr_glGetVertexAttribiv :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVertexAttribiv = unsafePerformIO $ getCommand "glGetVertexAttribiv"

-- glGetVertexAttribivARB ------------------------------------------------------

-- | This command is an alias for 'glGetVertexAttribiv'.
glGetVertexAttribivARB
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribPropertyARB@.
  -> Ptr GLint -- ^ @params@ pointing to @4@ elements of type @GLint@.
  -> m ()
glGetVertexAttribivARB v1 v2 v3 = liftIO $ dyn334 ptr_glGetVertexAttribivARB v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribivARB #-}
ptr_glGetVertexAttribivARB :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVertexAttribivARB = unsafePerformIO $ getCommand "glGetVertexAttribivARB"

-- glGetVertexAttribivNV -------------------------------------------------------

-- | This command is an alias for 'glGetVertexAttribiv'.
glGetVertexAttribivNV
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@ of type @VertexAttribEnumNV@.
  -> Ptr GLint -- ^ @params@ pointing to @1@ element of type @GLint@.
  -> m ()
glGetVertexAttribivNV v1 v2 v3 = liftIO $ dyn334 ptr_glGetVertexAttribivNV v1 v2 v3

{-# NOINLINE ptr_glGetVertexAttribivNV #-}
ptr_glGetVertexAttribivNV :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVertexAttribivNV = unsafePerformIO $ getCommand "glGetVertexAttribivNV"

-- glGetVideoCaptureStreamdvNV -------------------------------------------------

glGetVideoCaptureStreamdvNV
  :: MonadIO m
  => GLuint -- ^ @video_capture_slot@.
  -> GLuint -- ^ @stream@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLdouble -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLdouble@.
  -> m ()
glGetVideoCaptureStreamdvNV v1 v2 v3 v4 = liftIO $ dyn444 ptr_glGetVideoCaptureStreamdvNV v1 v2 v3 v4

{-# NOINLINE ptr_glGetVideoCaptureStreamdvNV #-}
ptr_glGetVideoCaptureStreamdvNV :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr GLdouble -> IO ())
ptr_glGetVideoCaptureStreamdvNV = unsafePerformIO $ getCommand "glGetVideoCaptureStreamdvNV"

-- glGetVideoCaptureStreamfvNV -------------------------------------------------

glGetVideoCaptureStreamfvNV
  :: MonadIO m
  => GLuint -- ^ @video_capture_slot@.
  -> GLuint -- ^ @stream@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glGetVideoCaptureStreamfvNV v1 v2 v3 v4 = liftIO $ dyn445 ptr_glGetVideoCaptureStreamfvNV v1 v2 v3 v4

{-# NOINLINE ptr_glGetVideoCaptureStreamfvNV #-}
ptr_glGetVideoCaptureStreamfvNV :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glGetVideoCaptureStreamfvNV = unsafePerformIO $ getCommand "glGetVideoCaptureStreamfvNV"

-- glGetVideoCaptureStreamivNV -------------------------------------------------

glGetVideoCaptureStreamivNV
  :: MonadIO m
  => GLuint -- ^ @video_capture_slot@.
  -> GLuint -- ^ @stream@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetVideoCaptureStreamivNV v1 v2 v3 v4 = liftIO $ dyn300 ptr_glGetVideoCaptureStreamivNV v1 v2 v3 v4

{-# NOINLINE ptr_glGetVideoCaptureStreamivNV #-}
ptr_glGetVideoCaptureStreamivNV :: FunPtr (GLuint -> GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVideoCaptureStreamivNV = unsafePerformIO $ getCommand "glGetVideoCaptureStreamivNV"

-- glGetVideoCaptureivNV -------------------------------------------------------

glGetVideoCaptureivNV
  :: MonadIO m
  => GLuint -- ^ @video_capture_slot@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetVideoCaptureivNV v1 v2 v3 = liftIO $ dyn334 ptr_glGetVideoCaptureivNV v1 v2 v3

{-# NOINLINE ptr_glGetVideoCaptureivNV #-}
ptr_glGetVideoCaptureivNV :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVideoCaptureivNV = unsafePerformIO $ getCommand "glGetVideoCaptureivNV"

-- glGetVideoi64vNV ------------------------------------------------------------

glGetVideoi64vNV
  :: MonadIO m
  => GLuint -- ^ @video_slot@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint64EXT -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint64EXT@.
  -> m ()
glGetVideoi64vNV v1 v2 v3 = liftIO $ dyn443 ptr_glGetVideoi64vNV v1 v2 v3

{-# NOINLINE ptr_glGetVideoi64vNV #-}
ptr_glGetVideoi64vNV :: FunPtr (GLuint -> GLenum -> Ptr GLint64EXT -> IO ())
ptr_glGetVideoi64vNV = unsafePerformIO $ getCommand "glGetVideoi64vNV"

-- glGetVideoivNV --------------------------------------------------------------

glGetVideoivNV
  :: MonadIO m
  => GLuint -- ^ @video_slot@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glGetVideoivNV v1 v2 v3 = liftIO $ dyn334 ptr_glGetVideoivNV v1 v2 v3

{-# NOINLINE ptr_glGetVideoivNV #-}
ptr_glGetVideoivNV :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glGetVideoivNV = unsafePerformIO $ getCommand "glGetVideoivNV"

-- glGetVideoui64vNV -----------------------------------------------------------

glGetVideoui64vNV
  :: MonadIO m
  => GLuint -- ^ @video_slot@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint64EXT -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint64EXT@.
  -> m ()
glGetVideoui64vNV v1 v2 v3 = liftIO $ dyn360 ptr_glGetVideoui64vNV v1 v2 v3

{-# NOINLINE ptr_glGetVideoui64vNV #-}
ptr_glGetVideoui64vNV :: FunPtr (GLuint -> GLenum -> Ptr GLuint64EXT -> IO ())
ptr_glGetVideoui64vNV = unsafePerformIO $ getCommand "glGetVideoui64vNV"

-- glGetVideouivNV -------------------------------------------------------------

glGetVideouivNV
  :: MonadIO m
  => GLuint -- ^ @video_slot@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLuint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLuint@.
  -> m ()
glGetVideouivNV v1 v2 v3 = liftIO $ dyn375 ptr_glGetVideouivNV v1 v2 v3

{-# NOINLINE ptr_glGetVideouivNV #-}
ptr_glGetVideouivNV :: FunPtr (GLuint -> GLenum -> Ptr GLuint -> IO ())
ptr_glGetVideouivNV = unsafePerformIO $ getCommand "glGetVideouivNV"

-- glGetnColorTable ------------------------------------------------------------

glGetnColorTable
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @table@.
  -> m ()
glGetnColorTable v1 v2 v3 v4 v5 = liftIO $ dyn446 ptr_glGetnColorTable v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetnColorTable #-}
ptr_glGetnColorTable :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glGetnColorTable = unsafePerformIO $ getCommand "glGetnColorTable"

-- glGetnColorTableARB ---------------------------------------------------------

glGetnColorTableARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @table@ pointing to @bufSize@ elements of type @a@.
  -> m ()
glGetnColorTableARB v1 v2 v3 v4 v5 = liftIO $ dyn446 ptr_glGetnColorTableARB v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetnColorTableARB #-}
ptr_glGetnColorTableARB :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glGetnColorTableARB = unsafePerformIO $ getCommand "glGetnColorTableARB"

-- glGetnCompressedTexImage ----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetCompressedTexImage.xhtml OpenGL 4.x>.
glGetnCompressedTexImage
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLint -- ^ @lod@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @pixels@.
  -> m ()
glGetnCompressedTexImage v1 v2 v3 v4 = liftIO $ dyn447 ptr_glGetnCompressedTexImage v1 v2 v3 v4

{-# NOINLINE ptr_glGetnCompressedTexImage #-}
ptr_glGetnCompressedTexImage :: FunPtr (GLenum -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glGetnCompressedTexImage = unsafePerformIO $ getCommand "glGetnCompressedTexImage"

-- glGetnCompressedTexImageARB -------------------------------------------------

glGetnCompressedTexImageARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLint -- ^ @lod@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @img@ pointing to @bufSize@ elements of type @a@.
  -> m ()
glGetnCompressedTexImageARB v1 v2 v3 v4 = liftIO $ dyn447 ptr_glGetnCompressedTexImageARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetnCompressedTexImageARB #-}
ptr_glGetnCompressedTexImageARB :: FunPtr (GLenum -> GLint -> GLsizei -> Ptr a -> IO ())
ptr_glGetnCompressedTexImageARB = unsafePerformIO $ getCommand "glGetnCompressedTexImageARB"

-- glGetnConvolutionFilter -----------------------------------------------------

glGetnConvolutionFilter
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @image@.
  -> m ()
glGetnConvolutionFilter v1 v2 v3 v4 v5 = liftIO $ dyn446 ptr_glGetnConvolutionFilter v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetnConvolutionFilter #-}
ptr_glGetnConvolutionFilter :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glGetnConvolutionFilter = unsafePerformIO $ getCommand "glGetnConvolutionFilter"

-- glGetnConvolutionFilterARB --------------------------------------------------

glGetnConvolutionFilterARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @image@ pointing to @bufSize@ elements of type @a@.
  -> m ()
glGetnConvolutionFilterARB v1 v2 v3 v4 v5 = liftIO $ dyn446 ptr_glGetnConvolutionFilterARB v1 v2 v3 v4 v5

{-# NOINLINE ptr_glGetnConvolutionFilterARB #-}
ptr_glGetnConvolutionFilterARB :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glGetnConvolutionFilterARB = unsafePerformIO $ getCommand "glGetnConvolutionFilterARB"

-- glGetnHistogram -------------------------------------------------------------

glGetnHistogram
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLboolean -- ^ @reset@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @values@.
  -> m ()
glGetnHistogram v1 v2 v3 v4 v5 v6 = liftIO $ dyn448 ptr_glGetnHistogram v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetnHistogram #-}
ptr_glGetnHistogram :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glGetnHistogram = unsafePerformIO $ getCommand "glGetnHistogram"

-- glGetnHistogramARB ----------------------------------------------------------

glGetnHistogramARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLboolean -- ^ @reset@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @values@ pointing to @bufSize@ elements of type @a@.
  -> m ()
glGetnHistogramARB v1 v2 v3 v4 v5 v6 = liftIO $ dyn448 ptr_glGetnHistogramARB v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetnHistogramARB #-}
ptr_glGetnHistogramARB :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glGetnHistogramARB = unsafePerformIO $ getCommand "glGetnHistogramARB"

-- glGetnMapdv -----------------------------------------------------------------

glGetnMapdv
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @query@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLdouble -- ^ @v@.
  -> m ()
glGetnMapdv v1 v2 v3 v4 = liftIO $ dyn449 ptr_glGetnMapdv v1 v2 v3 v4

{-# NOINLINE ptr_glGetnMapdv #-}
ptr_glGetnMapdv :: FunPtr (GLenum -> GLenum -> GLsizei -> Ptr GLdouble -> IO ())
ptr_glGetnMapdv = unsafePerformIO $ getCommand "glGetnMapdv"

-- glGetnMapdvARB --------------------------------------------------------------

glGetnMapdvARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @query@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLdouble -- ^ @v@ pointing to @bufSize@ elements of type @GLdouble@.
  -> m ()
glGetnMapdvARB v1 v2 v3 v4 = liftIO $ dyn449 ptr_glGetnMapdvARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetnMapdvARB #-}
ptr_glGetnMapdvARB :: FunPtr (GLenum -> GLenum -> GLsizei -> Ptr GLdouble -> IO ())
ptr_glGetnMapdvARB = unsafePerformIO $ getCommand "glGetnMapdvARB"

-- glGetnMapfv -----------------------------------------------------------------

glGetnMapfv
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @query@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLfloat -- ^ @v@.
  -> m ()
glGetnMapfv v1 v2 v3 v4 = liftIO $ dyn450 ptr_glGetnMapfv v1 v2 v3 v4

{-# NOINLINE ptr_glGetnMapfv #-}
ptr_glGetnMapfv :: FunPtr (GLenum -> GLenum -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetnMapfv = unsafePerformIO $ getCommand "glGetnMapfv"

-- glGetnMapfvARB --------------------------------------------------------------

glGetnMapfvARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @query@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLfloat -- ^ @v@ pointing to @bufSize@ elements of type @GLfloat@.
  -> m ()
glGetnMapfvARB v1 v2 v3 v4 = liftIO $ dyn450 ptr_glGetnMapfvARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetnMapfvARB #-}
ptr_glGetnMapfvARB :: FunPtr (GLenum -> GLenum -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetnMapfvARB = unsafePerformIO $ getCommand "glGetnMapfvARB"

-- glGetnMapiv -----------------------------------------------------------------

glGetnMapiv
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @query@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint -- ^ @v@.
  -> m ()
glGetnMapiv v1 v2 v3 v4 = liftIO $ dyn451 ptr_glGetnMapiv v1 v2 v3 v4

{-# NOINLINE ptr_glGetnMapiv #-}
ptr_glGetnMapiv :: FunPtr (GLenum -> GLenum -> GLsizei -> Ptr GLint -> IO ())
ptr_glGetnMapiv = unsafePerformIO $ getCommand "glGetnMapiv"

-- glGetnMapivARB --------------------------------------------------------------

glGetnMapivARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @query@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint -- ^ @v@ pointing to @bufSize@ elements of type @GLint@.
  -> m ()
glGetnMapivARB v1 v2 v3 v4 = liftIO $ dyn451 ptr_glGetnMapivARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetnMapivARB #-}
ptr_glGetnMapivARB :: FunPtr (GLenum -> GLenum -> GLsizei -> Ptr GLint -> IO ())
ptr_glGetnMapivARB = unsafePerformIO $ getCommand "glGetnMapivARB"

-- glGetnMinmax ----------------------------------------------------------------

glGetnMinmax
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLboolean -- ^ @reset@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @values@.
  -> m ()
glGetnMinmax v1 v2 v3 v4 v5 v6 = liftIO $ dyn448 ptr_glGetnMinmax v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetnMinmax #-}
ptr_glGetnMinmax :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glGetnMinmax = unsafePerformIO $ getCommand "glGetnMinmax"

-- glGetnMinmaxARB -------------------------------------------------------------

glGetnMinmaxARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLboolean -- ^ @reset@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @values@ pointing to @bufSize@ elements of type @a@.
  -> m ()
glGetnMinmaxARB v1 v2 v3 v4 v5 v6 = liftIO $ dyn448 ptr_glGetnMinmaxARB v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetnMinmaxARB #-}
ptr_glGetnMinmaxARB :: FunPtr (GLenum -> GLboolean -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glGetnMinmaxARB = unsafePerformIO $ getCommand "glGetnMinmaxARB"

-- glGetnPixelMapfv ------------------------------------------------------------

glGetnPixelMapfv
  :: MonadIO m
  => GLenum -- ^ @map@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLfloat -- ^ @values@.
  -> m ()
glGetnPixelMapfv v1 v2 v3 = liftIO $ dyn225 ptr_glGetnPixelMapfv v1 v2 v3

{-# NOINLINE ptr_glGetnPixelMapfv #-}
ptr_glGetnPixelMapfv :: FunPtr (GLenum -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetnPixelMapfv = unsafePerformIO $ getCommand "glGetnPixelMapfv"

-- glGetnPixelMapfvARB ---------------------------------------------------------

glGetnPixelMapfvARB
  :: MonadIO m
  => GLenum -- ^ @map@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLfloat -- ^ @values@ pointing to @bufSize@ elements of type @GLfloat@.
  -> m ()
glGetnPixelMapfvARB v1 v2 v3 = liftIO $ dyn225 ptr_glGetnPixelMapfvARB v1 v2 v3

{-# NOINLINE ptr_glGetnPixelMapfvARB #-}
ptr_glGetnPixelMapfvARB :: FunPtr (GLenum -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetnPixelMapfvARB = unsafePerformIO $ getCommand "glGetnPixelMapfvARB"

-- glGetnPixelMapuiv -----------------------------------------------------------

glGetnPixelMapuiv
  :: MonadIO m
  => GLenum -- ^ @map@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLuint -- ^ @values@.
  -> m ()
glGetnPixelMapuiv v1 v2 v3 = liftIO $ dyn197 ptr_glGetnPixelMapuiv v1 v2 v3

{-# NOINLINE ptr_glGetnPixelMapuiv #-}
ptr_glGetnPixelMapuiv :: FunPtr (GLenum -> GLsizei -> Ptr GLuint -> IO ())
ptr_glGetnPixelMapuiv = unsafePerformIO $ getCommand "glGetnPixelMapuiv"

-- glGetnPixelMapuivARB --------------------------------------------------------

glGetnPixelMapuivARB
  :: MonadIO m
  => GLenum -- ^ @map@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLuint -- ^ @values@ pointing to @bufSize@ elements of type @GLuint@.
  -> m ()
glGetnPixelMapuivARB v1 v2 v3 = liftIO $ dyn197 ptr_glGetnPixelMapuivARB v1 v2 v3

{-# NOINLINE ptr_glGetnPixelMapuivARB #-}
ptr_glGetnPixelMapuivARB :: FunPtr (GLenum -> GLsizei -> Ptr GLuint -> IO ())
ptr_glGetnPixelMapuivARB = unsafePerformIO $ getCommand "glGetnPixelMapuivARB"

-- glGetnPixelMapusv -----------------------------------------------------------

glGetnPixelMapusv
  :: MonadIO m
  => GLenum -- ^ @map@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLushort -- ^ @values@.
  -> m ()
glGetnPixelMapusv v1 v2 v3 = liftIO $ dyn452 ptr_glGetnPixelMapusv v1 v2 v3

{-# NOINLINE ptr_glGetnPixelMapusv #-}
ptr_glGetnPixelMapusv :: FunPtr (GLenum -> GLsizei -> Ptr GLushort -> IO ())
ptr_glGetnPixelMapusv = unsafePerformIO $ getCommand "glGetnPixelMapusv"

-- glGetnPixelMapusvARB --------------------------------------------------------

glGetnPixelMapusvARB
  :: MonadIO m
  => GLenum -- ^ @map@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLushort -- ^ @values@ pointing to @bufSize@ elements of type @GLushort@.
  -> m ()
glGetnPixelMapusvARB v1 v2 v3 = liftIO $ dyn452 ptr_glGetnPixelMapusvARB v1 v2 v3

{-# NOINLINE ptr_glGetnPixelMapusvARB #-}
ptr_glGetnPixelMapusvARB :: FunPtr (GLenum -> GLsizei -> Ptr GLushort -> IO ())
ptr_glGetnPixelMapusvARB = unsafePerformIO $ getCommand "glGetnPixelMapusvARB"

-- glGetnPolygonStipple --------------------------------------------------------

glGetnPolygonStipple
  :: MonadIO m
  => GLsizei -- ^ @bufSize@.
  -> Ptr GLubyte -- ^ @pattern@.
  -> m ()
glGetnPolygonStipple v1 v2 = liftIO $ dyn453 ptr_glGetnPolygonStipple v1 v2

{-# NOINLINE ptr_glGetnPolygonStipple #-}
ptr_glGetnPolygonStipple :: FunPtr (GLsizei -> Ptr GLubyte -> IO ())
ptr_glGetnPolygonStipple = unsafePerformIO $ getCommand "glGetnPolygonStipple"

-- glGetnPolygonStippleARB -----------------------------------------------------

glGetnPolygonStippleARB
  :: MonadIO m
  => GLsizei -- ^ @bufSize@.
  -> Ptr GLubyte -- ^ @pattern@ pointing to @bufSize@ elements of type @GLubyte@.
  -> m ()
glGetnPolygonStippleARB v1 v2 = liftIO $ dyn453 ptr_glGetnPolygonStippleARB v1 v2

{-# NOINLINE ptr_glGetnPolygonStippleARB #-}
ptr_glGetnPolygonStippleARB :: FunPtr (GLsizei -> Ptr GLubyte -> IO ())
ptr_glGetnPolygonStippleARB = unsafePerformIO $ getCommand "glGetnPolygonStippleARB"

-- glGetnSeparableFilter -------------------------------------------------------

glGetnSeparableFilter
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @rowBufSize@.
  -> Ptr a -- ^ @row@.
  -> GLsizei -- ^ @columnBufSize@.
  -> Ptr b -- ^ @column@.
  -> Ptr c -- ^ @span@.
  -> m ()
glGetnSeparableFilter v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn454 ptr_glGetnSeparableFilter v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glGetnSeparableFilter #-}
ptr_glGetnSeparableFilter :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr a -> GLsizei -> Ptr b -> Ptr c -> IO ())
ptr_glGetnSeparableFilter = unsafePerformIO $ getCommand "glGetnSeparableFilter"

-- glGetnSeparableFilterARB ----------------------------------------------------

glGetnSeparableFilterARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @rowBufSize@.
  -> Ptr a -- ^ @row@ pointing to @rowBufSize@ elements of type @a@.
  -> GLsizei -- ^ @columnBufSize@.
  -> Ptr b -- ^ @column@ pointing to @columnBufSize@ elements of type @b@.
  -> Ptr c -- ^ @span@ pointing to @0@ elements of type @c@.
  -> m ()
glGetnSeparableFilterARB v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn454 ptr_glGetnSeparableFilterARB v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glGetnSeparableFilterARB #-}
ptr_glGetnSeparableFilterARB :: FunPtr (GLenum -> GLenum -> GLenum -> GLsizei -> Ptr a -> GLsizei -> Ptr b -> Ptr c -> IO ())
ptr_glGetnSeparableFilterARB = unsafePerformIO $ getCommand "glGetnSeparableFilterARB"

-- glGetnTexImage --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetTexImage.xhtml OpenGL 4.x>.
glGetnTexImage
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLint -- ^ @level@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @pixels@.
  -> m ()
glGetnTexImage v1 v2 v3 v4 v5 v6 = liftIO $ dyn455 ptr_glGetnTexImage v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetnTexImage #-}
ptr_glGetnTexImage :: FunPtr (GLenum -> GLint -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glGetnTexImage = unsafePerformIO $ getCommand "glGetnTexImage"

-- glGetnTexImageARB -----------------------------------------------------------

glGetnTexImageARB
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLint -- ^ @level@.
  -> GLenum -- ^ @format@.
  -> GLenum -- ^ @type@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr a -- ^ @img@ pointing to @bufSize@ elements of type @a@.
  -> m ()
glGetnTexImageARB v1 v2 v3 v4 v5 v6 = liftIO $ dyn455 ptr_glGetnTexImageARB v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glGetnTexImageARB #-}
ptr_glGetnTexImageARB :: FunPtr (GLenum -> GLint -> GLenum -> GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glGetnTexImageARB = unsafePerformIO $ getCommand "glGetnTexImageARB"

-- glGetnUniformdv -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetUniform.xhtml OpenGL 4.x>.
glGetnUniformdv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLdouble -- ^ @params@.
  -> m ()
glGetnUniformdv v1 v2 v3 v4 = liftIO $ dyn456 ptr_glGetnUniformdv v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformdv #-}
ptr_glGetnUniformdv :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLdouble -> IO ())
ptr_glGetnUniformdv = unsafePerformIO $ getCommand "glGetnUniformdv"

-- glGetnUniformdvARB ----------------------------------------------------------

glGetnUniformdvARB
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLdouble -- ^ @params@ pointing to @bufSize@ elements of type @GLdouble@.
  -> m ()
glGetnUniformdvARB v1 v2 v3 v4 = liftIO $ dyn456 ptr_glGetnUniformdvARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformdvARB #-}
ptr_glGetnUniformdvARB :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLdouble -> IO ())
ptr_glGetnUniformdvARB = unsafePerformIO $ getCommand "glGetnUniformdvARB"

-- glGetnUniformfv -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetUniform.xhtml OpenGL 4.x>.
glGetnUniformfv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLfloat -- ^ @params@.
  -> m ()
glGetnUniformfv v1 v2 v3 v4 = liftIO $ dyn457 ptr_glGetnUniformfv v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformfv #-}
ptr_glGetnUniformfv :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetnUniformfv = unsafePerformIO $ getCommand "glGetnUniformfv"

-- glGetnUniformfvARB ----------------------------------------------------------

glGetnUniformfvARB
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLfloat -- ^ @params@ pointing to @bufSize@ elements of type @GLfloat@.
  -> m ()
glGetnUniformfvARB v1 v2 v3 v4 = liftIO $ dyn457 ptr_glGetnUniformfvARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformfvARB #-}
ptr_glGetnUniformfvARB :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetnUniformfvARB = unsafePerformIO $ getCommand "glGetnUniformfvARB"

-- glGetnUniformfvEXT ----------------------------------------------------------

glGetnUniformfvEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLfloat -- ^ @params@ pointing to @bufSize@ elements of type @GLfloat@.
  -> m ()
glGetnUniformfvEXT v1 v2 v3 v4 = liftIO $ dyn457 ptr_glGetnUniformfvEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformfvEXT #-}
ptr_glGetnUniformfvEXT :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetnUniformfvEXT = unsafePerformIO $ getCommand "glGetnUniformfvEXT"

-- glGetnUniformfvKHR ----------------------------------------------------------

-- | This command is an alias for 'glGetnUniformfv'.
glGetnUniformfvKHR
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLfloat -- ^ @params@.
  -> m ()
glGetnUniformfvKHR v1 v2 v3 v4 = liftIO $ dyn457 ptr_glGetnUniformfvKHR v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformfvKHR #-}
ptr_glGetnUniformfvKHR :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLfloat -> IO ())
ptr_glGetnUniformfvKHR = unsafePerformIO $ getCommand "glGetnUniformfvKHR"

-- glGetnUniformi64vARB --------------------------------------------------------

glGetnUniformi64vARB
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint64 -- ^ @params@.
  -> m ()
glGetnUniformi64vARB v1 v2 v3 v4 = liftIO $ dyn458 ptr_glGetnUniformi64vARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformi64vARB #-}
ptr_glGetnUniformi64vARB :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLint64 -> IO ())
ptr_glGetnUniformi64vARB = unsafePerformIO $ getCommand "glGetnUniformi64vARB"

-- glGetnUniformiv -------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetUniform.xhtml OpenGL 4.x>.
glGetnUniformiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetnUniformiv v1 v2 v3 v4 = liftIO $ dyn459 ptr_glGetnUniformiv v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformiv #-}
ptr_glGetnUniformiv :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLint -> IO ())
ptr_glGetnUniformiv = unsafePerformIO $ getCommand "glGetnUniformiv"

-- glGetnUniformivARB ----------------------------------------------------------

glGetnUniformivARB
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint -- ^ @params@ pointing to @bufSize@ elements of type @GLint@.
  -> m ()
glGetnUniformivARB v1 v2 v3 v4 = liftIO $ dyn459 ptr_glGetnUniformivARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformivARB #-}
ptr_glGetnUniformivARB :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLint -> IO ())
ptr_glGetnUniformivARB = unsafePerformIO $ getCommand "glGetnUniformivARB"

-- glGetnUniformivEXT ----------------------------------------------------------

glGetnUniformivEXT
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint -- ^ @params@ pointing to @bufSize@ elements of type @GLint@.
  -> m ()
glGetnUniformivEXT v1 v2 v3 v4 = liftIO $ dyn459 ptr_glGetnUniformivEXT v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformivEXT #-}
ptr_glGetnUniformivEXT :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLint -> IO ())
ptr_glGetnUniformivEXT = unsafePerformIO $ getCommand "glGetnUniformivEXT"

-- glGetnUniformivKHR ----------------------------------------------------------

-- | This command is an alias for 'glGetnUniformiv'.
glGetnUniformivKHR
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLint -- ^ @params@.
  -> m ()
glGetnUniformivKHR v1 v2 v3 v4 = liftIO $ dyn459 ptr_glGetnUniformivKHR v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformivKHR #-}
ptr_glGetnUniformivKHR :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLint -> IO ())
ptr_glGetnUniformivKHR = unsafePerformIO $ getCommand "glGetnUniformivKHR"

-- glGetnUniformui64vARB -------------------------------------------------------

glGetnUniformui64vARB
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLuint64 -- ^ @params@.
  -> m ()
glGetnUniformui64vARB v1 v2 v3 v4 = liftIO $ dyn460 ptr_glGetnUniformui64vARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformui64vARB #-}
ptr_glGetnUniformui64vARB :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLuint64 -> IO ())
ptr_glGetnUniformui64vARB = unsafePerformIO $ getCommand "glGetnUniformui64vARB"

-- glGetnUniformuiv ------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glGetUniform.xhtml OpenGL 4.x>.
glGetnUniformuiv
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLuint -- ^ @params@.
  -> m ()
glGetnUniformuiv v1 v2 v3 v4 = liftIO $ dyn461 ptr_glGetnUniformuiv v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformuiv #-}
ptr_glGetnUniformuiv :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glGetnUniformuiv = unsafePerformIO $ getCommand "glGetnUniformuiv"

-- glGetnUniformuivARB ---------------------------------------------------------

glGetnUniformuivARB
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLuint -- ^ @params@ pointing to @bufSize@ elements of type @GLuint@.
  -> m ()
glGetnUniformuivARB v1 v2 v3 v4 = liftIO $ dyn461 ptr_glGetnUniformuivARB v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformuivARB #-}
ptr_glGetnUniformuivARB :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glGetnUniformuivARB = unsafePerformIO $ getCommand "glGetnUniformuivARB"

-- glGetnUniformuivKHR ---------------------------------------------------------

-- | This command is an alias for 'glGetnUniformuiv'.
glGetnUniformuivKHR
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> GLint -- ^ @location@.
  -> GLsizei -- ^ @bufSize@.
  -> Ptr GLuint -- ^ @params@.
  -> m ()
glGetnUniformuivKHR v1 v2 v3 v4 = liftIO $ dyn461 ptr_glGetnUniformuivKHR v1 v2 v3 v4

{-# NOINLINE ptr_glGetnUniformuivKHR #-}
ptr_glGetnUniformuivKHR :: FunPtr (GLuint -> GLint -> GLsizei -> Ptr GLuint -> IO ())
ptr_glGetnUniformuivKHR = unsafePerformIO $ getCommand "glGetnUniformuivKHR"

-- glGlobalAlphaFactorbSUN -----------------------------------------------------

glGlobalAlphaFactorbSUN
  :: MonadIO m
  => GLbyte -- ^ @factor@.
  -> m ()
glGlobalAlphaFactorbSUN v1 = liftIO $ dyn462 ptr_glGlobalAlphaFactorbSUN v1

{-# NOINLINE ptr_glGlobalAlphaFactorbSUN #-}
ptr_glGlobalAlphaFactorbSUN :: FunPtr (GLbyte -> IO ())
ptr_glGlobalAlphaFactorbSUN = unsafePerformIO $ getCommand "glGlobalAlphaFactorbSUN"

-- glGlobalAlphaFactordSUN -----------------------------------------------------

glGlobalAlphaFactordSUN
  :: MonadIO m
  => GLdouble -- ^ @factor@.
  -> m ()
glGlobalAlphaFactordSUN v1 = liftIO $ dyn78 ptr_glGlobalAlphaFactordSUN v1

{-# NOINLINE ptr_glGlobalAlphaFactordSUN #-}
ptr_glGlobalAlphaFactordSUN :: FunPtr (GLdouble -> IO ())
ptr_glGlobalAlphaFactordSUN = unsafePerformIO $ getCommand "glGlobalAlphaFactordSUN"

-- glGlobalAlphaFactorfSUN -----------------------------------------------------

glGlobalAlphaFactorfSUN
  :: MonadIO m
  => GLfloat -- ^ @factor@.
  -> m ()
glGlobalAlphaFactorfSUN v1 = liftIO $ dyn79 ptr_glGlobalAlphaFactorfSUN v1

{-# NOINLINE ptr_glGlobalAlphaFactorfSUN #-}
ptr_glGlobalAlphaFactorfSUN :: FunPtr (GLfloat -> IO ())
ptr_glGlobalAlphaFactorfSUN = unsafePerformIO $ getCommand "glGlobalAlphaFactorfSUN"

-- glGlobalAlphaFactoriSUN -----------------------------------------------------

glGlobalAlphaFactoriSUN
  :: MonadIO m
  => GLint -- ^ @factor@.
  -> m ()
glGlobalAlphaFactoriSUN v1 = liftIO $ dyn12 ptr_glGlobalAlphaFactoriSUN v1

{-# NOINLINE ptr_glGlobalAlphaFactoriSUN #-}
ptr_glGlobalAlphaFactoriSUN :: FunPtr (GLint -> IO ())
ptr_glGlobalAlphaFactoriSUN = unsafePerformIO $ getCommand "glGlobalAlphaFactoriSUN"

-- glGlobalAlphaFactorsSUN -----------------------------------------------------

glGlobalAlphaFactorsSUN
  :: MonadIO m
  => GLshort -- ^ @factor@.
  -> m ()
glGlobalAlphaFactorsSUN v1 = liftIO $ dyn463 ptr_glGlobalAlphaFactorsSUN v1

{-# NOINLINE ptr_glGlobalAlphaFactorsSUN #-}
ptr_glGlobalAlphaFactorsSUN :: FunPtr (GLshort -> IO ())
ptr_glGlobalAlphaFactorsSUN = unsafePerformIO $ getCommand "glGlobalAlphaFactorsSUN"

-- glGlobalAlphaFactorubSUN ----------------------------------------------------

glGlobalAlphaFactorubSUN
  :: MonadIO m
  => GLubyte -- ^ @factor@.
  -> m ()
glGlobalAlphaFactorubSUN v1 = liftIO $ dyn464 ptr_glGlobalAlphaFactorubSUN v1

{-# NOINLINE ptr_glGlobalAlphaFactorubSUN #-}
ptr_glGlobalAlphaFactorubSUN :: FunPtr (GLubyte -> IO ())
ptr_glGlobalAlphaFactorubSUN = unsafePerformIO $ getCommand "glGlobalAlphaFactorubSUN"

-- glGlobalAlphaFactoruiSUN ----------------------------------------------------

glGlobalAlphaFactoruiSUN
  :: MonadIO m
  => GLuint -- ^ @factor@.
  -> m ()
glGlobalAlphaFactoruiSUN v1 = liftIO $ dyn2 ptr_glGlobalAlphaFactoruiSUN v1

{-# NOINLINE ptr_glGlobalAlphaFactoruiSUN #-}
ptr_glGlobalAlphaFactoruiSUN :: FunPtr (GLuint -> IO ())
ptr_glGlobalAlphaFactoruiSUN = unsafePerformIO $ getCommand "glGlobalAlphaFactoruiSUN"

-- glGlobalAlphaFactorusSUN ----------------------------------------------------

glGlobalAlphaFactorusSUN
  :: MonadIO m
  => GLushort -- ^ @factor@.
  -> m ()
glGlobalAlphaFactorusSUN v1 = liftIO $ dyn465 ptr_glGlobalAlphaFactorusSUN v1

{-# NOINLINE ptr_glGlobalAlphaFactorusSUN #-}
ptr_glGlobalAlphaFactorusSUN :: FunPtr (GLushort -> IO ())
ptr_glGlobalAlphaFactorusSUN = unsafePerformIO $ getCommand "glGlobalAlphaFactorusSUN"

-- glHint ----------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glHint.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glHint.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glHint.xhtml OpenGL 4.x>.
glHint
  :: MonadIO m
  => GLenum -- ^ @target@ of type [HintTarget](Graphics-GL-Groups.html#HintTarget).
  -> GLenum -- ^ @mode@ of type [HintMode](Graphics-GL-Groups.html#HintMode).
  -> m ()
glHint v1 v2 = liftIO $ dyn51 ptr_glHint v1 v2

{-# NOINLINE ptr_glHint #-}
ptr_glHint :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glHint = unsafePerformIO $ getCommand "glHint"

-- glHintPGI -------------------------------------------------------------------

glHintPGI
  :: MonadIO m
  => GLenum -- ^ @target@ of type @HintTargetPGI@.
  -> GLint -- ^ @mode@.
  -> m ()
glHintPGI v1 v2 = liftIO $ dyn55 ptr_glHintPGI v1 v2

{-# NOINLINE ptr_glHintPGI #-}
ptr_glHintPGI :: FunPtr (GLenum -> GLint -> IO ())
ptr_glHintPGI = unsafePerformIO $ getCommand "glHintPGI"

-- glHistogram -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glHistogram.xml OpenGL 2.x>.
glHistogram
  :: MonadIO m
  => GLenum -- ^ @target@ of type @HistogramTarget@.
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLboolean -- ^ @sink@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glHistogram v1 v2 v3 v4 = liftIO $ dyn466 ptr_glHistogram v1 v2 v3 v4

{-# NOINLINE ptr_glHistogram #-}
ptr_glHistogram :: FunPtr (GLenum -> GLsizei -> GLenum -> GLboolean -> IO ())
ptr_glHistogram = unsafePerformIO $ getCommand "glHistogram"

-- glHistogramEXT --------------------------------------------------------------

-- | This command is an alias for 'glHistogram'.
glHistogramEXT
  :: MonadIO m
  => GLenum -- ^ @target@ of type [HistogramTargetEXT](Graphics-GL-Groups.html#HistogramTargetEXT).
  -> GLsizei -- ^ @width@.
  -> GLenum -- ^ @internalformat@ of type [InternalFormat](Graphics-GL-Groups.html#InternalFormat).
  -> GLboolean -- ^ @sink@ of type [Boolean](Graphics-GL-Groups.html#Boolean).
  -> m ()
glHistogramEXT v1 v2 v3 v4 = liftIO $ dyn466 ptr_glHistogramEXT v1 v2 v3 v4

{-# NOINLINE ptr_glHistogramEXT #-}
ptr_glHistogramEXT :: FunPtr (GLenum -> GLsizei -> GLenum -> GLboolean -> IO ())
ptr_glHistogramEXT = unsafePerformIO $ getCommand "glHistogramEXT"

-- glIglooInterfaceSGIX --------------------------------------------------------

glIglooInterfaceSGIX
  :: MonadIO m
  => GLenum -- ^ @pname@ of type @IglooFunctionSelectSGIX@.
  -> Ptr a -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @IglooParameterSGIX@.
  -> m ()
glIglooInterfaceSGIX v1 v2 = liftIO $ dyn230 ptr_glIglooInterfaceSGIX v1 v2

{-# NOINLINE ptr_glIglooInterfaceSGIX #-}
ptr_glIglooInterfaceSGIX :: FunPtr (GLenum -> Ptr a -> IO ())
ptr_glIglooInterfaceSGIX = unsafePerformIO $ getCommand "glIglooInterfaceSGIX"

-- glImageTransformParameterfHP ------------------------------------------------

glImageTransformParameterfHP
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ImageTransformTargetHP@.
  -> GLenum -- ^ @pname@ of type @ImageTransformPNameHP@.
  -> GLfloat -- ^ @param@.
  -> m ()
glImageTransformParameterfHP v1 v2 v3 = liftIO $ dyn161 ptr_glImageTransformParameterfHP v1 v2 v3

{-# NOINLINE ptr_glImageTransformParameterfHP #-}
ptr_glImageTransformParameterfHP :: FunPtr (GLenum -> GLenum -> GLfloat -> IO ())
ptr_glImageTransformParameterfHP = unsafePerformIO $ getCommand "glImageTransformParameterfHP"

-- glImageTransformParameterfvHP -----------------------------------------------

glImageTransformParameterfvHP
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ImageTransformTargetHP@.
  -> GLenum -- ^ @pname@ of type @ImageTransformPNameHP@.
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glImageTransformParameterfvHP v1 v2 v3 = liftIO $ dyn132 ptr_glImageTransformParameterfvHP v1 v2 v3

{-# NOINLINE ptr_glImageTransformParameterfvHP #-}
ptr_glImageTransformParameterfvHP :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glImageTransformParameterfvHP = unsafePerformIO $ getCommand "glImageTransformParameterfvHP"

-- glImageTransformParameteriHP ------------------------------------------------

glImageTransformParameteriHP
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ImageTransformTargetHP@.
  -> GLenum -- ^ @pname@ of type @ImageTransformPNameHP@.
  -> GLint -- ^ @param@.
  -> m ()
glImageTransformParameteriHP v1 v2 v3 = liftIO $ dyn62 ptr_glImageTransformParameteriHP v1 v2 v3

{-# NOINLINE ptr_glImageTransformParameteriHP #-}
ptr_glImageTransformParameteriHP :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glImageTransformParameteriHP = unsafePerformIO $ getCommand "glImageTransformParameteriHP"

-- glImageTransformParameterivHP -----------------------------------------------

glImageTransformParameterivHP
  :: MonadIO m
  => GLenum -- ^ @target@ of type @ImageTransformTargetHP@.
  -> GLenum -- ^ @pname@ of type @ImageTransformPNameHP@.
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glImageTransformParameterivHP v1 v2 v3 = liftIO $ dyn133 ptr_glImageTransformParameterivHP v1 v2 v3

{-# NOINLINE ptr_glImageTransformParameterivHP #-}
ptr_glImageTransformParameterivHP :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glImageTransformParameterivHP = unsafePerformIO $ getCommand "glImageTransformParameterivHP"

-- glImportSyncEXT -------------------------------------------------------------

glImportSyncEXT
  :: MonadIO m
  => GLenum -- ^ @external_sync_type@.
  -> GLintptr -- ^ @external_sync@.
  -> GLbitfield -- ^ @flags@.
  -> m GLsync -- ^ of type @sync@.
glImportSyncEXT v1 v2 v3 = liftIO $ dyn467 ptr_glImportSyncEXT v1 v2 v3

{-# NOINLINE ptr_glImportSyncEXT #-}
ptr_glImportSyncEXT :: FunPtr (GLenum -> GLintptr -> GLbitfield -> IO GLsync)
ptr_glImportSyncEXT = unsafePerformIO $ getCommand "glImportSyncEXT"

-- glIndexFormatNV -------------------------------------------------------------

glIndexFormatNV
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> GLsizei -- ^ @stride@.
  -> m ()
glIndexFormatNV v1 v2 = liftIO $ dyn239 ptr_glIndexFormatNV v1 v2

{-# NOINLINE ptr_glIndexFormatNV #-}
ptr_glIndexFormatNV :: FunPtr (GLenum -> GLsizei -> IO ())
ptr_glIndexFormatNV = unsafePerformIO $ getCommand "glIndexFormatNV"

-- glIndexFuncEXT --------------------------------------------------------------

glIndexFuncEXT
  :: MonadIO m
  => GLenum -- ^ @func@ of type @IndexFunctionEXT@.
  -> GLclampf -- ^ @ref@ of type @ClampedFloat32@.
  -> m ()
glIndexFuncEXT v1 v2 = liftIO $ dyn9 ptr_glIndexFuncEXT v1 v2

{-# NOINLINE ptr_glIndexFuncEXT #-}
ptr_glIndexFuncEXT :: FunPtr (GLenum -> GLclampf -> IO ())
ptr_glIndexFuncEXT = unsafePerformIO $ getCommand "glIndexFuncEXT"

-- glIndexMask -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glIndexMask.xml OpenGL 2.x>.
glIndexMask
  :: MonadIO m
  => GLuint -- ^ @mask@ of type @MaskedColorIndexValueI@.
  -> m ()
glIndexMask v1 = liftIO $ dyn2 ptr_glIndexMask v1

{-# NOINLINE ptr_glIndexMask #-}
ptr_glIndexMask :: FunPtr (GLuint -> IO ())
ptr_glIndexMask = unsafePerformIO $ getCommand "glIndexMask"

-- glIndexMaterialEXT ----------------------------------------------------------

glIndexMaterialEXT
  :: MonadIO m
  => GLenum -- ^ @face@ of type [MaterialFace](Graphics-GL-Groups.html#MaterialFace).
  -> GLenum -- ^ @mode@ of type @IndexMaterialParameterEXT@.
  -> m ()
glIndexMaterialEXT v1 v2 = liftIO $ dyn51 ptr_glIndexMaterialEXT v1 v2

{-# NOINLINE ptr_glIndexMaterialEXT #-}
ptr_glIndexMaterialEXT :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glIndexMaterialEXT = unsafePerformIO $ getCommand "glIndexMaterialEXT"

-- glIndexPointer --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glIndexPointer.xml OpenGL 2.x>.
glIndexPointer
  :: MonadIO m
  => GLenum -- ^ @type@ of type [IndexPointerType](Graphics-GL-Groups.html#IndexPointerType).
  -> GLsizei -- ^ @stride@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(type,stride)@ elements of type @a@.
  -> m ()
glIndexPointer v1 v2 v3 = liftIO $ dyn46 ptr_glIndexPointer v1 v2 v3

{-# NOINLINE ptr_glIndexPointer #-}
ptr_glIndexPointer :: FunPtr (GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glIndexPointer = unsafePerformIO $ getCommand "glIndexPointer"

-- glIndexPointerEXT -----------------------------------------------------------

glIndexPointerEXT
  :: MonadIO m
  => GLenum -- ^ @type@ of type [IndexPointerType](Graphics-GL-Groups.html#IndexPointerType).
  -> GLsizei -- ^ @stride@.
  -> GLsizei -- ^ @count@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(type,stride,count)@ elements of type @a@.
  -> m ()
glIndexPointerEXT v1 v2 v3 v4 = liftIO $ dyn468 ptr_glIndexPointerEXT v1 v2 v3 v4

{-# NOINLINE ptr_glIndexPointerEXT #-}
ptr_glIndexPointerEXT :: FunPtr (GLenum -> GLsizei -> GLsizei -> Ptr a -> IO ())
ptr_glIndexPointerEXT = unsafePerformIO $ getCommand "glIndexPointerEXT"

-- glIndexPointerListIBM -------------------------------------------------------

glIndexPointerListIBM
  :: MonadIO m
  => GLenum -- ^ @type@ of type [IndexPointerType](Graphics-GL-Groups.html#IndexPointerType).
  -> GLint -- ^ @stride@.
  -> Ptr (Ptr a) -- ^ @pointer@ pointing to @COMPSIZE(type,stride)@ elements of type @Ptr a@.
  -> GLint -- ^ @ptrstride@.
  -> m ()
glIndexPointerListIBM v1 v2 v3 v4 = liftIO $ dyn280 ptr_glIndexPointerListIBM v1 v2 v3 v4

{-# NOINLINE ptr_glIndexPointerListIBM #-}
ptr_glIndexPointerListIBM :: FunPtr (GLenum -> GLint -> Ptr (Ptr a) -> GLint -> IO ())
ptr_glIndexPointerListIBM = unsafePerformIO $ getCommand "glIndexPointerListIBM"

-- glIndexd --------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glIndex.xml OpenGL 2.x>. The vector equivalent of this command is 'glIndexdv'.
glIndexd
  :: MonadIO m
  => GLdouble -- ^ @c@ of type @ColorIndexValueD@.
  -> m ()
glIndexd v1 = liftIO $ dyn78 ptr_glIndexd v1

{-# NOINLINE ptr_glIndexd #-}
ptr_glIndexd :: FunPtr (GLdouble -> IO ())
ptr_glIndexd = unsafePerformIO $ getCommand "glIndexd"

-- glIndexdv -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glIndex.xml OpenGL 2.x>.
glIndexdv
  :: MonadIO m
  => Ptr GLdouble -- ^ @c@ pointing to @1@ element of type @ColorIndexValueD@.
  -> m ()
glIndexdv v1 = liftIO $ dyn39 ptr_glIndexdv v1

{-# NOINLINE ptr_glIndexdv #-}
ptr_glIndexdv :: FunPtr (Ptr GLdouble -> IO ())
ptr_glIndexdv = unsafePerformIO $ getCommand "glIndexdv"

-- glIndexf --------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glIndex.xml OpenGL 2.x>. The vector equivalent of this command is 'glIndexfv'.
glIndexf
  :: MonadIO m
  => GLfloat -- ^ @c@ of type @ColorIndexValueF@.
  -> m ()
glIndexf v1 = liftIO $ dyn79 ptr_glIndexf v1

{-# NOINLINE ptr_glIndexf #-}
ptr_glIndexf :: FunPtr (GLfloat -> IO ())
ptr_glIndexf = unsafePerformIO $ getCommand "glIndexf"

-- glIndexfv -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glIndex.xml OpenGL 2.x>.
glIndexfv
  :: MonadIO m
  => Ptr GLfloat -- ^ @c@ pointing to @1@ element of type @ColorIndexValueF@.
  -> m ()
glIndexfv v1 = liftIO $ dyn41 ptr_glIndexfv v1

{-# NOINLINE ptr_glIndexfv #-}
ptr_glIndexfv :: FunPtr (Ptr GLfloat -> IO ())
ptr_glIndexfv = unsafePerformIO $ getCommand "glIndexfv"

-- glIndexi --------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glIndex.xml OpenGL 2.x>. The vector equivalent of this command is 'glIndexiv'.
glIndexi
  :: MonadIO m
  => GLint -- ^ @c@ of type @ColorIndexValueI@.
  -> m ()
glIndexi v1 = liftIO $ dyn12 ptr_glIndexi v1

{-# NOINLINE ptr_glIndexi #-}
ptr_glIndexi :: FunPtr (GLint -> IO ())
ptr_glIndexi = unsafePerformIO $ getCommand "glIndexi"

-- glIndexiv -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glIndex.xml OpenGL 2.x>.
glIndexiv
  :: MonadIO m
  => Ptr GLint -- ^ @c@ pointing to @1@ element of type @ColorIndexValueI@.
  -> m ()
glIndexiv v1 = liftIO $ dyn43 ptr_glIndexiv v1

{-# NOINLINE ptr_glIndexiv #-}
ptr_glIndexiv :: FunPtr (Ptr GLint -> IO ())
ptr_glIndexiv = unsafePerformIO $ getCommand "glIndexiv"

-- glIndexs --------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glIndex.xml OpenGL 2.x>. The vector equivalent of this command is 'glIndexsv'.
glIndexs
  :: MonadIO m
  => GLshort -- ^ @c@ of type @ColorIndexValueS@.
  -> m ()
glIndexs v1 = liftIO $ dyn463 ptr_glIndexs v1

{-# NOINLINE ptr_glIndexs #-}
ptr_glIndexs :: FunPtr (GLshort -> IO ())
ptr_glIndexs = unsafePerformIO $ getCommand "glIndexs"

-- glIndexsv -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glIndex.xml OpenGL 2.x>.
glIndexsv
  :: MonadIO m
  => Ptr GLshort -- ^ @c@ pointing to @1@ element of type @ColorIndexValueS@.
  -> m ()
glIndexsv v1 = liftIO $ dyn45 ptr_glIndexsv v1

{-# NOINLINE ptr_glIndexsv #-}
ptr_glIndexsv :: FunPtr (Ptr GLshort -> IO ())
ptr_glIndexsv = unsafePerformIO $ getCommand "glIndexsv"

-- glIndexub -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glIndex.xml OpenGL 2.x>. The vector equivalent of this command is 'glIndexubv'.
glIndexub
  :: MonadIO m
  => GLubyte -- ^ @c@ of type @ColorIndexValueUB@.
  -> m ()
glIndexub v1 = liftIO $ dyn464 ptr_glIndexub v1

{-# NOINLINE ptr_glIndexub #-}
ptr_glIndexub :: FunPtr (GLubyte -> IO ())
ptr_glIndexub = unsafePerformIO $ getCommand "glIndexub"

-- glIndexubv ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glIndex.xml OpenGL 2.x>.
glIndexubv
  :: MonadIO m
  => Ptr GLubyte -- ^ @c@ pointing to @1@ element of type @ColorIndexValueUB@.
  -> m ()
glIndexubv v1 = liftIO $ dyn101 ptr_glIndexubv v1

{-# NOINLINE ptr_glIndexubv #-}
ptr_glIndexubv :: FunPtr (Ptr GLubyte -> IO ())
ptr_glIndexubv = unsafePerformIO $ getCommand "glIndexubv"

-- glIndexxOES -----------------------------------------------------------------

glIndexxOES
  :: MonadIO m
  => GLfixed -- ^ @component@.
  -> m ()
glIndexxOES v1 = liftIO $ dyn81 ptr_glIndexxOES v1

{-# NOINLINE ptr_glIndexxOES #-}
ptr_glIndexxOES :: FunPtr (GLfixed -> IO ())
ptr_glIndexxOES = unsafePerformIO $ getCommand "glIndexxOES"

-- glIndexxvOES ----------------------------------------------------------------

glIndexxvOES
  :: MonadIO m
  => Ptr GLfixed -- ^ @component@ pointing to @1@ element of type @GLfixed@.
  -> m ()
glIndexxvOES v1 = liftIO $ dyn107 ptr_glIndexxvOES v1

{-# NOINLINE ptr_glIndexxvOES #-}
ptr_glIndexxvOES :: FunPtr (Ptr GLfixed -> IO ())
ptr_glIndexxvOES = unsafePerformIO $ getCommand "glIndexxvOES"

-- glInitNames -----------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glInitNames.xml OpenGL 2.x>.
glInitNames
  :: MonadIO m
  => m ()
glInitNames = liftIO $ dyn10 ptr_glInitNames

{-# NOINLINE ptr_glInitNames #-}
ptr_glInitNames :: FunPtr (IO ())
ptr_glInitNames = unsafePerformIO $ getCommand "glInitNames"

-- glInsertComponentEXT --------------------------------------------------------

glInsertComponentEXT
  :: MonadIO m
  => GLuint -- ^ @res@.
  -> GLuint -- ^ @src@.
  -> GLuint -- ^ @num@.
  -> m ()
glInsertComponentEXT v1 v2 v3 = liftIO $ dyn102 ptr_glInsertComponentEXT v1 v2 v3

{-# NOINLINE ptr_glInsertComponentEXT #-}
ptr_glInsertComponentEXT :: FunPtr (GLuint -> GLuint -> GLuint -> IO ())
ptr_glInsertComponentEXT = unsafePerformIO $ getCommand "glInsertComponentEXT"

-- glInsertEventMarkerEXT ------------------------------------------------------

glInsertEventMarkerEXT
  :: MonadIO m
  => GLsizei -- ^ @length@.
  -> Ptr GLchar -- ^ @marker@.
  -> m ()
glInsertEventMarkerEXT v1 v2 = liftIO $ dyn469 ptr_glInsertEventMarkerEXT v1 v2

{-# NOINLINE ptr_glInsertEventMarkerEXT #-}
ptr_glInsertEventMarkerEXT :: FunPtr (GLsizei -> Ptr GLchar -> IO ())
ptr_glInsertEventMarkerEXT = unsafePerformIO $ getCommand "glInsertEventMarkerEXT"

-- glInstrumentsBufferSGIX -----------------------------------------------------

glInstrumentsBufferSGIX
  :: MonadIO m
  => GLsizei -- ^ @size@.
  -> Ptr GLint -- ^ @buffer@ pointing to @size@ elements of type @GLint@.
  -> m ()
glInstrumentsBufferSGIX v1 v2 = liftIO $ dyn470 ptr_glInstrumentsBufferSGIX v1 v2

{-# NOINLINE ptr_glInstrumentsBufferSGIX #-}
ptr_glInstrumentsBufferSGIX :: FunPtr (GLsizei -> Ptr GLint -> IO ())
ptr_glInstrumentsBufferSGIX = unsafePerformIO $ getCommand "glInstrumentsBufferSGIX"

-- glInterleavedArrays ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glInterleavedArrays.xml OpenGL 2.x>.
glInterleavedArrays
  :: MonadIO m
  => GLenum -- ^ @format@ of type [InterleavedArrayFormat](Graphics-GL-Groups.html#InterleavedArrayFormat).
  -> GLsizei -- ^ @stride@.
  -> Ptr a -- ^ @pointer@ pointing to @COMPSIZE(format,stride)@ elements of type @a@.
  -> m ()
glInterleavedArrays v1 v2 v3 = liftIO $ dyn46 ptr_glInterleavedArrays v1 v2 v3

{-# NOINLINE ptr_glInterleavedArrays #-}
ptr_glInterleavedArrays :: FunPtr (GLenum -> GLsizei -> Ptr a -> IO ())
ptr_glInterleavedArrays = unsafePerformIO $ getCommand "glInterleavedArrays"

-- glInterpolatePathsNV --------------------------------------------------------

glInterpolatePathsNV
  :: MonadIO m
  => GLuint -- ^ @resultPath@ of type @Path@.
  -> GLuint -- ^ @pathA@ of type @Path@.
  -> GLuint -- ^ @pathB@ of type @Path@.
  -> GLfloat -- ^ @weight@.
  -> m ()
glInterpolatePathsNV v1 v2 v3 v4 = liftIO $ dyn471 ptr_glInterpolatePathsNV v1 v2 v3 v4

{-# NOINLINE ptr_glInterpolatePathsNV #-}
ptr_glInterpolatePathsNV :: FunPtr (GLuint -> GLuint -> GLuint -> GLfloat -> IO ())
ptr_glInterpolatePathsNV = unsafePerformIO $ getCommand "glInterpolatePathsNV"

-- glInvalidateBufferData ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glInvalidateBufferData.xhtml OpenGL 4.x>.
glInvalidateBufferData
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> m ()
glInvalidateBufferData v1 = liftIO $ dyn2 ptr_glInvalidateBufferData v1

{-# NOINLINE ptr_glInvalidateBufferData #-}
ptr_glInvalidateBufferData :: FunPtr (GLuint -> IO ())
ptr_glInvalidateBufferData = unsafePerformIO $ getCommand "glInvalidateBufferData"

-- glInvalidateBufferSubData ---------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glInvalidateBufferSubData.xhtml OpenGL 4.x>.
glInvalidateBufferSubData
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLintptr -- ^ @offset@ of type @BufferOffset@.
  -> GLsizeiptr -- ^ @length@ of type @BufferSize@.
  -> m ()
glInvalidateBufferSubData v1 v2 v3 = liftIO $ dyn279 ptr_glInvalidateBufferSubData v1 v2 v3

{-# NOINLINE ptr_glInvalidateBufferSubData #-}
ptr_glInvalidateBufferSubData :: FunPtr (GLuint -> GLintptr -> GLsizeiptr -> IO ())
ptr_glInvalidateBufferSubData = unsafePerformIO $ getCommand "glInvalidateBufferSubData"

-- glInvalidateFramebuffer -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glInvalidateFramebuffer.xhtml OpenGL 4.x>.
glInvalidateFramebuffer
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLsizei -- ^ @numAttachments@.
  -> Ptr GLenum -- ^ @attachments@ pointing to @numAttachments@ elements of type @GLenum@.
  -> m ()
glInvalidateFramebuffer v1 v2 v3 = liftIO $ dyn226 ptr_glInvalidateFramebuffer v1 v2 v3

{-# NOINLINE ptr_glInvalidateFramebuffer #-}
ptr_glInvalidateFramebuffer :: FunPtr (GLenum -> GLsizei -> Ptr GLenum -> IO ())
ptr_glInvalidateFramebuffer = unsafePerformIO $ getCommand "glInvalidateFramebuffer"

-- glInvalidateNamedFramebufferData --------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glInvalidateFramebuffer.xhtml OpenGL 4.x>.
glInvalidateNamedFramebufferData
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLsizei -- ^ @numAttachments@.
  -> Ptr GLenum -- ^ @attachments@.
  -> m ()
glInvalidateNamedFramebufferData v1 v2 v3 = liftIO $ dyn282 ptr_glInvalidateNamedFramebufferData v1 v2 v3

{-# NOINLINE ptr_glInvalidateNamedFramebufferData #-}
ptr_glInvalidateNamedFramebufferData :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> IO ())
ptr_glInvalidateNamedFramebufferData = unsafePerformIO $ getCommand "glInvalidateNamedFramebufferData"

-- glInvalidateNamedFramebufferSubData -----------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glInvalidateSubFramebuffer.xhtml OpenGL 4.x>.
glInvalidateNamedFramebufferSubData
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> GLsizei -- ^ @numAttachments@.
  -> Ptr GLenum -- ^ @attachments@.
  -> GLint -- ^ @x@.
  -> GLint -- ^ @y@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glInvalidateNamedFramebufferSubData v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn472 ptr_glInvalidateNamedFramebufferSubData v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glInvalidateNamedFramebufferSubData #-}
ptr_glInvalidateNamedFramebufferSubData :: FunPtr (GLuint -> GLsizei -> Ptr GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glInvalidateNamedFramebufferSubData = unsafePerformIO $ getCommand "glInvalidateNamedFramebufferSubData"

-- glInvalidateSubFramebuffer --------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glInvalidateSubFramebuffer.xhtml OpenGL 4.x>.
glInvalidateSubFramebuffer
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLsizei -- ^ @numAttachments@.
  -> Ptr GLenum -- ^ @attachments@ pointing to @numAttachments@ elements of type @GLenum@.
  -> GLint -- ^ @x@.
  -> GLint -- ^ @y@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> m ()
glInvalidateSubFramebuffer v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn473 ptr_glInvalidateSubFramebuffer v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glInvalidateSubFramebuffer #-}
ptr_glInvalidateSubFramebuffer :: FunPtr (GLenum -> GLsizei -> Ptr GLenum -> GLint -> GLint -> GLsizei -> GLsizei -> IO ())
ptr_glInvalidateSubFramebuffer = unsafePerformIO $ getCommand "glInvalidateSubFramebuffer"

-- glInvalidateTexImage --------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glInvalidateTexImage.xhtml OpenGL 4.x>.
glInvalidateTexImage
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> m ()
glInvalidateTexImage v1 v2 = liftIO $ dyn474 ptr_glInvalidateTexImage v1 v2

{-# NOINLINE ptr_glInvalidateTexImage #-}
ptr_glInvalidateTexImage :: FunPtr (GLuint -> GLint -> IO ())
ptr_glInvalidateTexImage = unsafePerformIO $ getCommand "glInvalidateTexImage"

-- glInvalidateTexSubImage -----------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glInvalidateTexSubImage.xhtml OpenGL 4.x>.
glInvalidateTexSubImage
  :: MonadIO m
  => GLuint -- ^ @texture@.
  -> GLint -- ^ @level@.
  -> GLint -- ^ @xoffset@.
  -> GLint -- ^ @yoffset@.
  -> GLint -- ^ @zoffset@.
  -> GLsizei -- ^ @width@.
  -> GLsizei -- ^ @height@.
  -> GLsizei -- ^ @depth@.
  -> m ()
glInvalidateTexSubImage v1 v2 v3 v4 v5 v6 v7 v8 = liftIO $ dyn475 ptr_glInvalidateTexSubImage v1 v2 v3 v4 v5 v6 v7 v8

{-# NOINLINE ptr_glInvalidateTexSubImage #-}
ptr_glInvalidateTexSubImage :: FunPtr (GLuint -> GLint -> GLint -> GLint -> GLint -> GLsizei -> GLsizei -> GLsizei -> IO ())
ptr_glInvalidateTexSubImage = unsafePerformIO $ getCommand "glInvalidateTexSubImage"

-- glIsAsyncMarkerSGIX ---------------------------------------------------------

glIsAsyncMarkerSGIX
  :: MonadIO m
  => GLuint -- ^ @marker@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsAsyncMarkerSGIX v1 = liftIO $ dyn273 ptr_glIsAsyncMarkerSGIX v1

{-# NOINLINE ptr_glIsAsyncMarkerSGIX #-}
ptr_glIsAsyncMarkerSGIX :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsAsyncMarkerSGIX = unsafePerformIO $ getCommand "glIsAsyncMarkerSGIX"

-- glIsBuffer ------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glIsBuffer.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glIsBuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glIsBuffer.xhtml OpenGL 4.x>.
glIsBuffer
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsBuffer v1 = liftIO $ dyn273 ptr_glIsBuffer v1

{-# NOINLINE ptr_glIsBuffer #-}
ptr_glIsBuffer :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsBuffer = unsafePerformIO $ getCommand "glIsBuffer"

-- glIsBufferARB ---------------------------------------------------------------

-- | This command is an alias for 'glIsBuffer'.
glIsBufferARB
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsBufferARB v1 = liftIO $ dyn273 ptr_glIsBufferARB v1

{-# NOINLINE ptr_glIsBufferARB #-}
ptr_glIsBufferARB :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsBufferARB = unsafePerformIO $ getCommand "glIsBufferARB"

-- glIsBufferResidentNV --------------------------------------------------------

glIsBufferResidentNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsBufferResidentNV v1 = liftIO $ dyn476 ptr_glIsBufferResidentNV v1

{-# NOINLINE ptr_glIsBufferResidentNV #-}
ptr_glIsBufferResidentNV :: FunPtr (GLenum -> IO GLboolean)
ptr_glIsBufferResidentNV = unsafePerformIO $ getCommand "glIsBufferResidentNV"

-- glIsCommandListNV -----------------------------------------------------------

glIsCommandListNV
  :: MonadIO m
  => GLuint -- ^ @list@.
  -> m GLboolean
glIsCommandListNV v1 = liftIO $ dyn273 ptr_glIsCommandListNV v1

{-# NOINLINE ptr_glIsCommandListNV #-}
ptr_glIsCommandListNV :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsCommandListNV = unsafePerformIO $ getCommand "glIsCommandListNV"

-- glIsEnabled -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glIsEnabled.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glIsEnabled.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glIsEnabled.xhtml OpenGL 4.x>.
glIsEnabled
  :: MonadIO m
  => GLenum -- ^ @cap@ of type [EnableCap](Graphics-GL-Groups.html#EnableCap).
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsEnabled v1 = liftIO $ dyn476 ptr_glIsEnabled v1

{-# NOINLINE ptr_glIsEnabled #-}
ptr_glIsEnabled :: FunPtr (GLenum -> IO GLboolean)
ptr_glIsEnabled = unsafePerformIO $ getCommand "glIsEnabled"

-- glIsEnabledIndexedEXT -------------------------------------------------------

-- | This command is an alias for 'glIsEnabledi'.
glIsEnabledIndexedEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsEnabledIndexedEXT v1 v2 = liftIO $ dyn477 ptr_glIsEnabledIndexedEXT v1 v2

{-# NOINLINE ptr_glIsEnabledIndexedEXT #-}
ptr_glIsEnabledIndexedEXT :: FunPtr (GLenum -> GLuint -> IO GLboolean)
ptr_glIsEnabledIndexedEXT = unsafePerformIO $ getCommand "glIsEnabledIndexedEXT"

-- glIsEnabledi ----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glIsEnabled.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glIsEnabled.xhtml OpenGL 4.x>.
glIsEnabledi
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsEnabledi v1 v2 = liftIO $ dyn477 ptr_glIsEnabledi v1 v2

{-# NOINLINE ptr_glIsEnabledi #-}
ptr_glIsEnabledi :: FunPtr (GLenum -> GLuint -> IO GLboolean)
ptr_glIsEnabledi = unsafePerformIO $ getCommand "glIsEnabledi"

-- glIsEnablediEXT -------------------------------------------------------------

-- | This command is an alias for 'glIsEnabledi'.
glIsEnablediEXT
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsEnablediEXT v1 v2 = liftIO $ dyn477 ptr_glIsEnablediEXT v1 v2

{-# NOINLINE ptr_glIsEnablediEXT #-}
ptr_glIsEnablediEXT :: FunPtr (GLenum -> GLuint -> IO GLboolean)
ptr_glIsEnablediEXT = unsafePerformIO $ getCommand "glIsEnablediEXT"

-- glIsEnablediNV --------------------------------------------------------------

-- | This command is an alias for 'glIsEnabledi'.
glIsEnablediNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsEnablediNV v1 v2 = liftIO $ dyn477 ptr_glIsEnablediNV v1 v2

{-# NOINLINE ptr_glIsEnablediNV #-}
ptr_glIsEnablediNV :: FunPtr (GLenum -> GLuint -> IO GLboolean)
ptr_glIsEnablediNV = unsafePerformIO $ getCommand "glIsEnablediNV"

-- glIsEnablediOES -------------------------------------------------------------

-- | This command is an alias for 'glIsEnabledi'.
glIsEnablediOES
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLuint -- ^ @index@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsEnablediOES v1 v2 = liftIO $ dyn477 ptr_glIsEnablediOES v1 v2

{-# NOINLINE ptr_glIsEnablediOES #-}
ptr_glIsEnablediOES :: FunPtr (GLenum -> GLuint -> IO GLboolean)
ptr_glIsEnablediOES = unsafePerformIO $ getCommand "glIsEnablediOES"

-- glIsFenceAPPLE --------------------------------------------------------------

glIsFenceAPPLE
  :: MonadIO m
  => GLuint -- ^ @fence@ of type @FenceNV@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsFenceAPPLE v1 = liftIO $ dyn273 ptr_glIsFenceAPPLE v1

{-# NOINLINE ptr_glIsFenceAPPLE #-}
ptr_glIsFenceAPPLE :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsFenceAPPLE = unsafePerformIO $ getCommand "glIsFenceAPPLE"

-- glIsFenceNV -----------------------------------------------------------------

glIsFenceNV
  :: MonadIO m
  => GLuint -- ^ @fence@ of type @FenceNV@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsFenceNV v1 = liftIO $ dyn273 ptr_glIsFenceNV v1

{-# NOINLINE ptr_glIsFenceNV #-}
ptr_glIsFenceNV :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsFenceNV = unsafePerformIO $ getCommand "glIsFenceNV"

-- glIsFramebuffer -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glIsFramebuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glIsFramebuffer.xhtml OpenGL 4.x>.
glIsFramebuffer
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsFramebuffer v1 = liftIO $ dyn273 ptr_glIsFramebuffer v1

{-# NOINLINE ptr_glIsFramebuffer #-}
ptr_glIsFramebuffer :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsFramebuffer = unsafePerformIO $ getCommand "glIsFramebuffer"

-- glIsFramebufferEXT ----------------------------------------------------------

-- | This command is an alias for 'glIsFramebuffer'.
glIsFramebufferEXT
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsFramebufferEXT v1 = liftIO $ dyn273 ptr_glIsFramebufferEXT v1

{-# NOINLINE ptr_glIsFramebufferEXT #-}
ptr_glIsFramebufferEXT :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsFramebufferEXT = unsafePerformIO $ getCommand "glIsFramebufferEXT"

-- glIsFramebufferOES ----------------------------------------------------------

glIsFramebufferOES
  :: MonadIO m
  => GLuint -- ^ @framebuffer@.
  -> m GLboolean
glIsFramebufferOES v1 = liftIO $ dyn273 ptr_glIsFramebufferOES v1

{-# NOINLINE ptr_glIsFramebufferOES #-}
ptr_glIsFramebufferOES :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsFramebufferOES = unsafePerformIO $ getCommand "glIsFramebufferOES"

-- glIsImageHandleResidentARB --------------------------------------------------

glIsImageHandleResidentARB
  :: MonadIO m
  => GLuint64 -- ^ @handle@.
  -> m GLboolean
glIsImageHandleResidentARB v1 = liftIO $ dyn478 ptr_glIsImageHandleResidentARB v1

{-# NOINLINE ptr_glIsImageHandleResidentARB #-}
ptr_glIsImageHandleResidentARB :: FunPtr (GLuint64 -> IO GLboolean)
ptr_glIsImageHandleResidentARB = unsafePerformIO $ getCommand "glIsImageHandleResidentARB"

-- glIsImageHandleResidentNV ---------------------------------------------------

glIsImageHandleResidentNV
  :: MonadIO m
  => GLuint64 -- ^ @handle@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsImageHandleResidentNV v1 = liftIO $ dyn478 ptr_glIsImageHandleResidentNV v1

{-# NOINLINE ptr_glIsImageHandleResidentNV #-}
ptr_glIsImageHandleResidentNV :: FunPtr (GLuint64 -> IO GLboolean)
ptr_glIsImageHandleResidentNV = unsafePerformIO $ getCommand "glIsImageHandleResidentNV"

-- glIsList --------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glIsList.xml OpenGL 2.x>.
glIsList
  :: MonadIO m
  => GLuint -- ^ @list@ of type @List@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsList v1 = liftIO $ dyn273 ptr_glIsList v1

{-# NOINLINE ptr_glIsList #-}
ptr_glIsList :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsList = unsafePerformIO $ getCommand "glIsList"

-- glIsNameAMD -----------------------------------------------------------------

glIsNameAMD
  :: MonadIO m
  => GLenum -- ^ @identifier@.
  -> GLuint -- ^ @name@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsNameAMD v1 v2 = liftIO $ dyn477 ptr_glIsNameAMD v1 v2

{-# NOINLINE ptr_glIsNameAMD #-}
ptr_glIsNameAMD :: FunPtr (GLenum -> GLuint -> IO GLboolean)
ptr_glIsNameAMD = unsafePerformIO $ getCommand "glIsNameAMD"

-- glIsNamedBufferResidentNV ---------------------------------------------------

glIsNamedBufferResidentNV
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsNamedBufferResidentNV v1 = liftIO $ dyn273 ptr_glIsNamedBufferResidentNV v1

{-# NOINLINE ptr_glIsNamedBufferResidentNV #-}
ptr_glIsNamedBufferResidentNV :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsNamedBufferResidentNV = unsafePerformIO $ getCommand "glIsNamedBufferResidentNV"

-- glIsNamedStringARB ----------------------------------------------------------

glIsNamedStringARB
  :: MonadIO m
  => GLint -- ^ @namelen@.
  -> Ptr GLchar -- ^ @name@ pointing to @namelen@ elements of type @GLchar@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsNamedStringARB v1 v2 = liftIO $ dyn479 ptr_glIsNamedStringARB v1 v2

{-# NOINLINE ptr_glIsNamedStringARB #-}
ptr_glIsNamedStringARB :: FunPtr (GLint -> Ptr GLchar -> IO GLboolean)
ptr_glIsNamedStringARB = unsafePerformIO $ getCommand "glIsNamedStringARB"

-- glIsObjectBufferATI ---------------------------------------------------------

glIsObjectBufferATI
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsObjectBufferATI v1 = liftIO $ dyn273 ptr_glIsObjectBufferATI v1

{-# NOINLINE ptr_glIsObjectBufferATI #-}
ptr_glIsObjectBufferATI :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsObjectBufferATI = unsafePerformIO $ getCommand "glIsObjectBufferATI"

-- glIsOcclusionQueryNV --------------------------------------------------------

glIsOcclusionQueryNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsOcclusionQueryNV v1 = liftIO $ dyn273 ptr_glIsOcclusionQueryNV v1

{-# NOINLINE ptr_glIsOcclusionQueryNV #-}
ptr_glIsOcclusionQueryNV :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsOcclusionQueryNV = unsafePerformIO $ getCommand "glIsOcclusionQueryNV"

-- glIsPathNV ------------------------------------------------------------------

glIsPathNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsPathNV v1 = liftIO $ dyn273 ptr_glIsPathNV v1

{-# NOINLINE ptr_glIsPathNV #-}
ptr_glIsPathNV :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsPathNV = unsafePerformIO $ getCommand "glIsPathNV"

-- glIsPointInFillPathNV -------------------------------------------------------

glIsPointInFillPathNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> GLuint -- ^ @mask@ of type @MaskedStencilValue@.
  -> GLfloat -- ^ @x@.
  -> GLfloat -- ^ @y@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsPointInFillPathNV v1 v2 v3 v4 = liftIO $ dyn480 ptr_glIsPointInFillPathNV v1 v2 v3 v4

{-# NOINLINE ptr_glIsPointInFillPathNV #-}
ptr_glIsPointInFillPathNV :: FunPtr (GLuint -> GLuint -> GLfloat -> GLfloat -> IO GLboolean)
ptr_glIsPointInFillPathNV = unsafePerformIO $ getCommand "glIsPointInFillPathNV"

-- glIsPointInStrokePathNV -----------------------------------------------------

glIsPointInStrokePathNV
  :: MonadIO m
  => GLuint -- ^ @path@ of type @Path@.
  -> GLfloat -- ^ @x@.
  -> GLfloat -- ^ @y@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsPointInStrokePathNV v1 v2 v3 = liftIO $ dyn481 ptr_glIsPointInStrokePathNV v1 v2 v3

{-# NOINLINE ptr_glIsPointInStrokePathNV #-}
ptr_glIsPointInStrokePathNV :: FunPtr (GLuint -> GLfloat -> GLfloat -> IO GLboolean)
ptr_glIsPointInStrokePathNV = unsafePerformIO $ getCommand "glIsPointInStrokePathNV"

-- glIsProgram -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glIsProgram.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glIsProgram.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glIsProgram.xhtml OpenGL 4.x>.
glIsProgram
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsProgram v1 = liftIO $ dyn273 ptr_glIsProgram v1

{-# NOINLINE ptr_glIsProgram #-}
ptr_glIsProgram :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsProgram = unsafePerformIO $ getCommand "glIsProgram"

-- glIsProgramARB --------------------------------------------------------------

glIsProgramARB
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsProgramARB v1 = liftIO $ dyn273 ptr_glIsProgramARB v1

{-# NOINLINE ptr_glIsProgramARB #-}
ptr_glIsProgramARB :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsProgramARB = unsafePerformIO $ getCommand "glIsProgramARB"

-- glIsProgramNV ---------------------------------------------------------------

-- | This command is an alias for 'glIsProgramARB'.
glIsProgramNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsProgramNV v1 = liftIO $ dyn273 ptr_glIsProgramNV v1

{-# NOINLINE ptr_glIsProgramNV #-}
ptr_glIsProgramNV :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsProgramNV = unsafePerformIO $ getCommand "glIsProgramNV"

-- glIsProgramPipeline ---------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glIsProgramPipeline.xhtml OpenGL 4.x>.
glIsProgramPipeline
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsProgramPipeline v1 = liftIO $ dyn273 ptr_glIsProgramPipeline v1

{-# NOINLINE ptr_glIsProgramPipeline #-}
ptr_glIsProgramPipeline :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsProgramPipeline = unsafePerformIO $ getCommand "glIsProgramPipeline"

-- glIsProgramPipelineEXT ------------------------------------------------------

glIsProgramPipelineEXT
  :: MonadIO m
  => GLuint -- ^ @pipeline@.
  -> m GLboolean
glIsProgramPipelineEXT v1 = liftIO $ dyn273 ptr_glIsProgramPipelineEXT v1

{-# NOINLINE ptr_glIsProgramPipelineEXT #-}
ptr_glIsProgramPipelineEXT :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsProgramPipelineEXT = unsafePerformIO $ getCommand "glIsProgramPipelineEXT"

-- glIsQuery -------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glIsQuery.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glIsQuery.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glIsQuery.xhtml OpenGL 4.x>.
glIsQuery
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsQuery v1 = liftIO $ dyn273 ptr_glIsQuery v1

{-# NOINLINE ptr_glIsQuery #-}
ptr_glIsQuery :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsQuery = unsafePerformIO $ getCommand "glIsQuery"

-- glIsQueryARB ----------------------------------------------------------------

-- | This command is an alias for 'glIsQuery'.
glIsQueryARB
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsQueryARB v1 = liftIO $ dyn273 ptr_glIsQueryARB v1

{-# NOINLINE ptr_glIsQueryARB #-}
ptr_glIsQueryARB :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsQueryARB = unsafePerformIO $ getCommand "glIsQueryARB"

-- glIsQueryEXT ----------------------------------------------------------------

glIsQueryEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m GLboolean
glIsQueryEXT v1 = liftIO $ dyn273 ptr_glIsQueryEXT v1

{-# NOINLINE ptr_glIsQueryEXT #-}
ptr_glIsQueryEXT :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsQueryEXT = unsafePerformIO $ getCommand "glIsQueryEXT"

-- glIsRenderbuffer ------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glIsRenderbuffer.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glIsRenderbuffer.xhtml OpenGL 4.x>.
glIsRenderbuffer
  :: MonadIO m
  => GLuint -- ^ @renderbuffer@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsRenderbuffer v1 = liftIO $ dyn273 ptr_glIsRenderbuffer v1

{-# NOINLINE ptr_glIsRenderbuffer #-}
ptr_glIsRenderbuffer :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsRenderbuffer = unsafePerformIO $ getCommand "glIsRenderbuffer"

-- glIsRenderbufferEXT ---------------------------------------------------------

-- | This command is an alias for 'glIsRenderbuffer'.
glIsRenderbufferEXT
  :: MonadIO m
  => GLuint -- ^ @renderbuffer@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsRenderbufferEXT v1 = liftIO $ dyn273 ptr_glIsRenderbufferEXT v1

{-# NOINLINE ptr_glIsRenderbufferEXT #-}
ptr_glIsRenderbufferEXT :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsRenderbufferEXT = unsafePerformIO $ getCommand "glIsRenderbufferEXT"

-- glIsRenderbufferOES ---------------------------------------------------------

glIsRenderbufferOES
  :: MonadIO m
  => GLuint -- ^ @renderbuffer@.
  -> m GLboolean
glIsRenderbufferOES v1 = liftIO $ dyn273 ptr_glIsRenderbufferOES v1

{-# NOINLINE ptr_glIsRenderbufferOES #-}
ptr_glIsRenderbufferOES :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsRenderbufferOES = unsafePerformIO $ getCommand "glIsRenderbufferOES"

-- glIsSampler -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glIsSampler.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glIsSampler.xhtml OpenGL 4.x>.
glIsSampler
  :: MonadIO m
  => GLuint -- ^ @sampler@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsSampler v1 = liftIO $ dyn273 ptr_glIsSampler v1

{-# NOINLINE ptr_glIsSampler #-}
ptr_glIsSampler :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsSampler = unsafePerformIO $ getCommand "glIsSampler"

-- glIsShader ------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glIsShader.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glIsShader.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glIsShader.xhtml OpenGL 4.x>.
glIsShader
  :: MonadIO m
  => GLuint -- ^ @shader@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsShader v1 = liftIO $ dyn273 ptr_glIsShader v1

{-# NOINLINE ptr_glIsShader #-}
ptr_glIsShader :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsShader = unsafePerformIO $ getCommand "glIsShader"

-- glIsStateNV -----------------------------------------------------------------

glIsStateNV
  :: MonadIO m
  => GLuint -- ^ @state@.
  -> m GLboolean
glIsStateNV v1 = liftIO $ dyn273 ptr_glIsStateNV v1

{-# NOINLINE ptr_glIsStateNV #-}
ptr_glIsStateNV :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsStateNV = unsafePerformIO $ getCommand "glIsStateNV"

-- glIsSync --------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glIsSync.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glIsSync.xhtml OpenGL 4.x>.
glIsSync
  :: MonadIO m
  => GLsync -- ^ @sync@ of type @sync@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsSync v1 = liftIO $ dyn482 ptr_glIsSync v1

{-# NOINLINE ptr_glIsSync #-}
ptr_glIsSync :: FunPtr (GLsync -> IO GLboolean)
ptr_glIsSync = unsafePerformIO $ getCommand "glIsSync"

-- glIsSyncAPPLE ---------------------------------------------------------------

-- | This command is an alias for 'glIsSync'.
glIsSyncAPPLE
  :: MonadIO m
  => GLsync -- ^ @sync@.
  -> m GLboolean
glIsSyncAPPLE v1 = liftIO $ dyn482 ptr_glIsSyncAPPLE v1

{-# NOINLINE ptr_glIsSyncAPPLE #-}
ptr_glIsSyncAPPLE :: FunPtr (GLsync -> IO GLboolean)
ptr_glIsSyncAPPLE = unsafePerformIO $ getCommand "glIsSyncAPPLE"

-- glIsTexture -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glIsTexture.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glIsTexture.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glIsTexture.xhtml OpenGL 4.x>.
glIsTexture
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsTexture v1 = liftIO $ dyn273 ptr_glIsTexture v1

{-# NOINLINE ptr_glIsTexture #-}
ptr_glIsTexture :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsTexture = unsafePerformIO $ getCommand "glIsTexture"

-- glIsTextureEXT --------------------------------------------------------------

glIsTextureEXT
  :: MonadIO m
  => GLuint -- ^ @texture@ of type @Texture@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsTextureEXT v1 = liftIO $ dyn273 ptr_glIsTextureEXT v1

{-# NOINLINE ptr_glIsTextureEXT #-}
ptr_glIsTextureEXT :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsTextureEXT = unsafePerformIO $ getCommand "glIsTextureEXT"

-- glIsTextureHandleResidentARB ------------------------------------------------

glIsTextureHandleResidentARB
  :: MonadIO m
  => GLuint64 -- ^ @handle@.
  -> m GLboolean
glIsTextureHandleResidentARB v1 = liftIO $ dyn478 ptr_glIsTextureHandleResidentARB v1

{-# NOINLINE ptr_glIsTextureHandleResidentARB #-}
ptr_glIsTextureHandleResidentARB :: FunPtr (GLuint64 -> IO GLboolean)
ptr_glIsTextureHandleResidentARB = unsafePerformIO $ getCommand "glIsTextureHandleResidentARB"

-- glIsTextureHandleResidentNV -------------------------------------------------

glIsTextureHandleResidentNV
  :: MonadIO m
  => GLuint64 -- ^ @handle@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsTextureHandleResidentNV v1 = liftIO $ dyn478 ptr_glIsTextureHandleResidentNV v1

{-# NOINLINE ptr_glIsTextureHandleResidentNV #-}
ptr_glIsTextureHandleResidentNV :: FunPtr (GLuint64 -> IO GLboolean)
ptr_glIsTextureHandleResidentNV = unsafePerformIO $ getCommand "glIsTextureHandleResidentNV"

-- glIsTransformFeedback -------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man4/html/glIsTransformFeedback.xhtml OpenGL 4.x>.
glIsTransformFeedback
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsTransformFeedback v1 = liftIO $ dyn273 ptr_glIsTransformFeedback v1

{-# NOINLINE ptr_glIsTransformFeedback #-}
ptr_glIsTransformFeedback :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsTransformFeedback = unsafePerformIO $ getCommand "glIsTransformFeedback"

-- glIsTransformFeedbackNV -----------------------------------------------------

-- | This command is an alias for 'glIsTransformFeedback'.
glIsTransformFeedbackNV
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsTransformFeedbackNV v1 = liftIO $ dyn273 ptr_glIsTransformFeedbackNV v1

{-# NOINLINE ptr_glIsTransformFeedbackNV #-}
ptr_glIsTransformFeedbackNV :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsTransformFeedbackNV = unsafePerformIO $ getCommand "glIsTransformFeedbackNV"

-- glIsVariantEnabledEXT -------------------------------------------------------

glIsVariantEnabledEXT
  :: MonadIO m
  => GLuint -- ^ @id@.
  -> GLenum -- ^ @cap@ of type @VariantCapEXT@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsVariantEnabledEXT v1 v2 = liftIO $ dyn483 ptr_glIsVariantEnabledEXT v1 v2

{-# NOINLINE ptr_glIsVariantEnabledEXT #-}
ptr_glIsVariantEnabledEXT :: FunPtr (GLuint -> GLenum -> IO GLboolean)
ptr_glIsVariantEnabledEXT = unsafePerformIO $ getCommand "glIsVariantEnabledEXT"

-- glIsVertexArray -------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man3/xhtml/glIsVertexArray.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glIsVertexArray.xhtml OpenGL 4.x>.
glIsVertexArray
  :: MonadIO m
  => GLuint -- ^ @array@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsVertexArray v1 = liftIO $ dyn273 ptr_glIsVertexArray v1

{-# NOINLINE ptr_glIsVertexArray #-}
ptr_glIsVertexArray :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsVertexArray = unsafePerformIO $ getCommand "glIsVertexArray"

-- glIsVertexArrayAPPLE --------------------------------------------------------

-- | This command is an alias for 'glIsVertexArray'.
glIsVertexArrayAPPLE
  :: MonadIO m
  => GLuint -- ^ @array@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsVertexArrayAPPLE v1 = liftIO $ dyn273 ptr_glIsVertexArrayAPPLE v1

{-# NOINLINE ptr_glIsVertexArrayAPPLE #-}
ptr_glIsVertexArrayAPPLE :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsVertexArrayAPPLE = unsafePerformIO $ getCommand "glIsVertexArrayAPPLE"

-- glIsVertexArrayOES ----------------------------------------------------------

-- | This command is an alias for 'glIsVertexArray'.
glIsVertexArrayOES
  :: MonadIO m
  => GLuint -- ^ @array@.
  -> m GLboolean
glIsVertexArrayOES v1 = liftIO $ dyn273 ptr_glIsVertexArrayOES v1

{-# NOINLINE ptr_glIsVertexArrayOES #-}
ptr_glIsVertexArrayOES :: FunPtr (GLuint -> IO GLboolean)
ptr_glIsVertexArrayOES = unsafePerformIO $ getCommand "glIsVertexArrayOES"

-- glIsVertexAttribEnabledAPPLE ------------------------------------------------

glIsVertexAttribEnabledAPPLE
  :: MonadIO m
  => GLuint -- ^ @index@.
  -> GLenum -- ^ @pname@.
  -> m GLboolean -- ^ of type [Boolean](Graphics-GL-Groups.html#Boolean).
glIsVertexAttribEnabledAPPLE v1 v2 = liftIO $ dyn483 ptr_glIsVertexAttribEnabledAPPLE v1 v2

{-# NOINLINE ptr_glIsVertexAttribEnabledAPPLE #-}
ptr_glIsVertexAttribEnabledAPPLE :: FunPtr (GLuint -> GLenum -> IO GLboolean)
ptr_glIsVertexAttribEnabledAPPLE = unsafePerformIO $ getCommand "glIsVertexAttribEnabledAPPLE"

-- glLabelObjectEXT ------------------------------------------------------------

glLabelObjectEXT
  :: MonadIO m
  => GLenum -- ^ @type@.
  -> GLuint -- ^ @object@.
  -> GLsizei -- ^ @length@.
  -> Ptr GLchar -- ^ @label@.
  -> m ()
glLabelObjectEXT v1 v2 v3 v4 = liftIO $ dyn484 ptr_glLabelObjectEXT v1 v2 v3 v4

{-# NOINLINE ptr_glLabelObjectEXT #-}
ptr_glLabelObjectEXT :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLchar -> IO ())
ptr_glLabelObjectEXT = unsafePerformIO $ getCommand "glLabelObjectEXT"

-- glLightEnviSGIX -------------------------------------------------------------

glLightEnviSGIX
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [LightEnvParameterSGIX](Graphics-GL-Groups.html#LightEnvParameterSGIX).
  -> GLint -- ^ @param@ of type @CheckedInt32@.
  -> m ()
glLightEnviSGIX v1 v2 = liftIO $ dyn55 ptr_glLightEnviSGIX v1 v2

{-# NOINLINE ptr_glLightEnviSGIX #-}
ptr_glLightEnviSGIX :: FunPtr (GLenum -> GLint -> IO ())
ptr_glLightEnviSGIX = unsafePerformIO $ getCommand "glLightEnviSGIX"

-- glLightModelf ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLightModel.xml OpenGL 2.x>.
glLightModelf
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [LightModelParameter](Graphics-GL-Groups.html#LightModelParameter).
  -> GLfloat -- ^ @param@.
  -> m ()
glLightModelf v1 v2 = liftIO $ dyn0 ptr_glLightModelf v1 v2

{-# NOINLINE ptr_glLightModelf #-}
ptr_glLightModelf :: FunPtr (GLenum -> GLfloat -> IO ())
ptr_glLightModelf = unsafePerformIO $ getCommand "glLightModelf"

-- glLightModelfv --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLightModel.xml OpenGL 2.x>.
glLightModelfv
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [LightModelParameter](Graphics-GL-Groups.html#LightModelParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfloat@.
  -> m ()
glLightModelfv v1 v2 = liftIO $ dyn94 ptr_glLightModelfv v1 v2

{-# NOINLINE ptr_glLightModelfv #-}
ptr_glLightModelfv :: FunPtr (GLenum -> Ptr GLfloat -> IO ())
ptr_glLightModelfv = unsafePerformIO $ getCommand "glLightModelfv"

-- glLightModeli ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLightModel.xml OpenGL 2.x>.
glLightModeli
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [LightModelParameter](Graphics-GL-Groups.html#LightModelParameter).
  -> GLint -- ^ @param@.
  -> m ()
glLightModeli v1 v2 = liftIO $ dyn55 ptr_glLightModeli v1 v2

{-# NOINLINE ptr_glLightModeli #-}
ptr_glLightModeli :: FunPtr (GLenum -> GLint -> IO ())
ptr_glLightModeli = unsafePerformIO $ getCommand "glLightModeli"

-- glLightModeliv --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLightModel.xml OpenGL 2.x>.
glLightModeliv
  :: MonadIO m
  => GLenum -- ^ @pname@ of type [LightModelParameter](Graphics-GL-Groups.html#LightModelParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLint@.
  -> m ()
glLightModeliv v1 v2 = liftIO $ dyn136 ptr_glLightModeliv v1 v2

{-# NOINLINE ptr_glLightModeliv #-}
ptr_glLightModeliv :: FunPtr (GLenum -> Ptr GLint -> IO ())
ptr_glLightModeliv = unsafePerformIO $ getCommand "glLightModeliv"

-- glLightModelx ---------------------------------------------------------------

glLightModelx
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> GLfixed -- ^ @param@.
  -> m ()
glLightModelx v1 v2 = liftIO $ dyn1 ptr_glLightModelx v1 v2

{-# NOINLINE ptr_glLightModelx #-}
ptr_glLightModelx :: FunPtr (GLenum -> GLfixed -> IO ())
ptr_glLightModelx = unsafePerformIO $ getCommand "glLightModelx"

-- glLightModelxOES ------------------------------------------------------------

glLightModelxOES
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> GLfixed -- ^ @param@.
  -> m ()
glLightModelxOES v1 v2 = liftIO $ dyn1 ptr_glLightModelxOES v1 v2

{-# NOINLINE ptr_glLightModelxOES #-}
ptr_glLightModelxOES :: FunPtr (GLenum -> GLfixed -> IO ())
ptr_glLightModelxOES = unsafePerformIO $ getCommand "glLightModelxOES"

-- glLightModelxv --------------------------------------------------------------

glLightModelxv
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @param@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glLightModelxv v1 v2 = liftIO $ dyn95 ptr_glLightModelxv v1 v2

{-# NOINLINE ptr_glLightModelxv #-}
ptr_glLightModelxv :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glLightModelxv = unsafePerformIO $ getCommand "glLightModelxv"

-- glLightModelxvOES -----------------------------------------------------------

glLightModelxvOES
  :: MonadIO m
  => GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @param@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glLightModelxvOES v1 v2 = liftIO $ dyn95 ptr_glLightModelxvOES v1 v2

{-# NOINLINE ptr_glLightModelxvOES #-}
ptr_glLightModelxvOES :: FunPtr (GLenum -> Ptr GLfixed -> IO ())
ptr_glLightModelxvOES = unsafePerformIO $ getCommand "glLightModelxvOES"

-- glLightf --------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLight.xml OpenGL 2.x>.
glLightf
  :: MonadIO m
  => GLenum -- ^ @light@ of type [LightName](Graphics-GL-Groups.html#LightName).
  -> GLenum -- ^ @pname@ of type [LightParameter](Graphics-GL-Groups.html#LightParameter).
  -> GLfloat -- ^ @param@ of type @CheckedFloat32@.
  -> m ()
glLightf v1 v2 v3 = liftIO $ dyn161 ptr_glLightf v1 v2 v3

{-# NOINLINE ptr_glLightf #-}
ptr_glLightf :: FunPtr (GLenum -> GLenum -> GLfloat -> IO ())
ptr_glLightf = unsafePerformIO $ getCommand "glLightf"

-- glLightfv -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLight.xml OpenGL 2.x>.
glLightfv
  :: MonadIO m
  => GLenum -- ^ @light@ of type [LightName](Graphics-GL-Groups.html#LightName).
  -> GLenum -- ^ @pname@ of type [LightParameter](Graphics-GL-Groups.html#LightParameter).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glLightfv v1 v2 v3 = liftIO $ dyn132 ptr_glLightfv v1 v2 v3

{-# NOINLINE ptr_glLightfv #-}
ptr_glLightfv :: FunPtr (GLenum -> GLenum -> Ptr GLfloat -> IO ())
ptr_glLightfv = unsafePerformIO $ getCommand "glLightfv"

-- glLighti --------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLight.xml OpenGL 2.x>.
glLighti
  :: MonadIO m
  => GLenum -- ^ @light@ of type [LightName](Graphics-GL-Groups.html#LightName).
  -> GLenum -- ^ @pname@ of type [LightParameter](Graphics-GL-Groups.html#LightParameter).
  -> GLint -- ^ @param@ of type @CheckedInt32@.
  -> m ()
glLighti v1 v2 v3 = liftIO $ dyn62 ptr_glLighti v1 v2 v3

{-# NOINLINE ptr_glLighti #-}
ptr_glLighti :: FunPtr (GLenum -> GLenum -> GLint -> IO ())
ptr_glLighti = unsafePerformIO $ getCommand "glLighti"

-- glLightiv -------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLight.xml OpenGL 2.x>.
glLightiv
  :: MonadIO m
  => GLenum -- ^ @light@ of type [LightName](Graphics-GL-Groups.html#LightName).
  -> GLenum -- ^ @pname@ of type [LightParameter](Graphics-GL-Groups.html#LightParameter).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glLightiv v1 v2 v3 = liftIO $ dyn133 ptr_glLightiv v1 v2 v3

{-# NOINLINE ptr_glLightiv #-}
ptr_glLightiv :: FunPtr (GLenum -> GLenum -> Ptr GLint -> IO ())
ptr_glLightiv = unsafePerformIO $ getCommand "glLightiv"

-- glLightx --------------------------------------------------------------------

glLightx
  :: MonadIO m
  => GLenum -- ^ @light@.
  -> GLenum -- ^ @pname@.
  -> GLfixed -- ^ @param@.
  -> m ()
glLightx v1 v2 v3 = liftIO $ dyn162 ptr_glLightx v1 v2 v3

{-# NOINLINE ptr_glLightx #-}
ptr_glLightx :: FunPtr (GLenum -> GLenum -> GLfixed -> IO ())
ptr_glLightx = unsafePerformIO $ getCommand "glLightx"

-- glLightxOES -----------------------------------------------------------------

glLightxOES
  :: MonadIO m
  => GLenum -- ^ @light@.
  -> GLenum -- ^ @pname@.
  -> GLfixed -- ^ @param@.
  -> m ()
glLightxOES v1 v2 v3 = liftIO $ dyn162 ptr_glLightxOES v1 v2 v3

{-# NOINLINE ptr_glLightxOES #-}
ptr_glLightxOES :: FunPtr (GLenum -> GLenum -> GLfixed -> IO ())
ptr_glLightxOES = unsafePerformIO $ getCommand "glLightxOES"

-- glLightxv -------------------------------------------------------------------

glLightxv
  :: MonadIO m
  => GLenum -- ^ @light@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glLightxv v1 v2 v3 = liftIO $ dyn163 ptr_glLightxv v1 v2 v3

{-# NOINLINE ptr_glLightxv #-}
ptr_glLightxv :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glLightxv = unsafePerformIO $ getCommand "glLightxv"

-- glLightxvOES ----------------------------------------------------------------

glLightxvOES
  :: MonadIO m
  => GLenum -- ^ @light@.
  -> GLenum -- ^ @pname@.
  -> Ptr GLfixed -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @GLfixed@.
  -> m ()
glLightxvOES v1 v2 v3 = liftIO $ dyn163 ptr_glLightxvOES v1 v2 v3

{-# NOINLINE ptr_glLightxvOES #-}
ptr_glLightxvOES :: FunPtr (GLenum -> GLenum -> Ptr GLfixed -> IO ())
ptr_glLightxvOES = unsafePerformIO $ getCommand "glLightxvOES"

-- glLineStipple ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLineStipple.xml OpenGL 2.x>.
glLineStipple
  :: MonadIO m
  => GLint -- ^ @factor@ of type @CheckedInt32@.
  -> GLushort -- ^ @pattern@ of type @LineStipple@.
  -> m ()
glLineStipple v1 v2 = liftIO $ dyn485 ptr_glLineStipple v1 v2

{-# NOINLINE ptr_glLineStipple #-}
ptr_glLineStipple :: FunPtr (GLint -> GLushort -> IO ())
ptr_glLineStipple = unsafePerformIO $ getCommand "glLineStipple"

-- glLineWidth -----------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glLineWidth.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glLineWidth.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glLineWidth.xhtml OpenGL 4.x>.
glLineWidth
  :: MonadIO m
  => GLfloat -- ^ @width@ of type @CheckedFloat32@.
  -> m ()
glLineWidth v1 = liftIO $ dyn79 ptr_glLineWidth v1

{-# NOINLINE ptr_glLineWidth #-}
ptr_glLineWidth :: FunPtr (GLfloat -> IO ())
ptr_glLineWidth = unsafePerformIO $ getCommand "glLineWidth"

-- glLineWidthx ----------------------------------------------------------------

glLineWidthx
  :: MonadIO m
  => GLfixed -- ^ @width@.
  -> m ()
glLineWidthx v1 = liftIO $ dyn81 ptr_glLineWidthx v1

{-# NOINLINE ptr_glLineWidthx #-}
ptr_glLineWidthx :: FunPtr (GLfixed -> IO ())
ptr_glLineWidthx = unsafePerformIO $ getCommand "glLineWidthx"

-- glLineWidthxOES -------------------------------------------------------------

glLineWidthxOES
  :: MonadIO m
  => GLfixed -- ^ @width@.
  -> m ()
glLineWidthxOES v1 = liftIO $ dyn81 ptr_glLineWidthxOES v1

{-# NOINLINE ptr_glLineWidthxOES #-}
ptr_glLineWidthxOES :: FunPtr (GLfixed -> IO ())
ptr_glLineWidthxOES = unsafePerformIO $ getCommand "glLineWidthxOES"

-- glLinkProgram ---------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glLinkProgram.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glLinkProgram.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glLinkProgram.xhtml OpenGL 4.x>.
glLinkProgram
  :: MonadIO m
  => GLuint -- ^ @program@.
  -> m ()
glLinkProgram v1 = liftIO $ dyn2 ptr_glLinkProgram v1

{-# NOINLINE ptr_glLinkProgram #-}
ptr_glLinkProgram :: FunPtr (GLuint -> IO ())
ptr_glLinkProgram = unsafePerformIO $ getCommand "glLinkProgram"

-- glLinkProgramARB ------------------------------------------------------------

-- | This command is an alias for 'glLinkProgram'.
glLinkProgramARB
  :: MonadIO m
  => GLhandleARB -- ^ @programObj@ of type @handleARB@.
  -> m ()
glLinkProgramARB v1 = liftIO $ dyn137 ptr_glLinkProgramARB v1

{-# NOINLINE ptr_glLinkProgramARB #-}
ptr_glLinkProgramARB :: FunPtr (GLhandleARB -> IO ())
ptr_glLinkProgramARB = unsafePerformIO $ getCommand "glLinkProgramARB"

-- glListBase ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glListBase.xml OpenGL 2.x>.
glListBase
  :: MonadIO m
  => GLuint -- ^ @base@ of type @List@.
  -> m ()
glListBase v1 = liftIO $ dyn2 ptr_glListBase v1

{-# NOINLINE ptr_glListBase #-}
ptr_glListBase :: FunPtr (GLuint -> IO ())
ptr_glListBase = unsafePerformIO $ getCommand "glListBase"

-- glListDrawCommandsStatesClientNV --------------------------------------------

glListDrawCommandsStatesClientNV
  :: MonadIO m
  => GLuint -- ^ @list@.
  -> GLuint -- ^ @segment@.
  -> Ptr (Ptr a) -- ^ @indirects@.
  -> Ptr GLsizei -- ^ @sizes@.
  -> Ptr GLuint -- ^ @states@.
  -> Ptr GLuint -- ^ @fbos@.
  -> GLuint -- ^ @count@.
  -> m ()
glListDrawCommandsStatesClientNV v1 v2 v3 v4 v5 v6 v7 = liftIO $ dyn486 ptr_glListDrawCommandsStatesClientNV v1 v2 v3 v4 v5 v6 v7

{-# NOINLINE ptr_glListDrawCommandsStatesClientNV #-}
ptr_glListDrawCommandsStatesClientNV :: FunPtr (GLuint -> GLuint -> Ptr (Ptr a) -> Ptr GLsizei -> Ptr GLuint -> Ptr GLuint -> GLuint -> IO ())
ptr_glListDrawCommandsStatesClientNV = unsafePerformIO $ getCommand "glListDrawCommandsStatesClientNV"

-- glListParameterfSGIX --------------------------------------------------------

glListParameterfSGIX
  :: MonadIO m
  => GLuint -- ^ @list@ of type @List@.
  -> GLenum -- ^ @pname@ of type [ListParameterName](Graphics-GL-Groups.html#ListParameterName).
  -> GLfloat -- ^ @param@ of type @CheckedFloat32@.
  -> m ()
glListParameterfSGIX v1 v2 v3 = liftIO $ dyn487 ptr_glListParameterfSGIX v1 v2 v3

{-# NOINLINE ptr_glListParameterfSGIX #-}
ptr_glListParameterfSGIX :: FunPtr (GLuint -> GLenum -> GLfloat -> IO ())
ptr_glListParameterfSGIX = unsafePerformIO $ getCommand "glListParameterfSGIX"

-- glListParameterfvSGIX -------------------------------------------------------

glListParameterfvSGIX
  :: MonadIO m
  => GLuint -- ^ @list@ of type @List@.
  -> GLenum -- ^ @pname@ of type [ListParameterName](Graphics-GL-Groups.html#ListParameterName).
  -> Ptr GLfloat -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedFloat32@.
  -> m ()
glListParameterfvSGIX v1 v2 v3 = liftIO $ dyn349 ptr_glListParameterfvSGIX v1 v2 v3

{-# NOINLINE ptr_glListParameterfvSGIX #-}
ptr_glListParameterfvSGIX :: FunPtr (GLuint -> GLenum -> Ptr GLfloat -> IO ())
ptr_glListParameterfvSGIX = unsafePerformIO $ getCommand "glListParameterfvSGIX"

-- glListParameteriSGIX --------------------------------------------------------

glListParameteriSGIX
  :: MonadIO m
  => GLuint -- ^ @list@ of type @List@.
  -> GLenum -- ^ @pname@ of type [ListParameterName](Graphics-GL-Groups.html#ListParameterName).
  -> GLint -- ^ @param@ of type @CheckedInt32@.
  -> m ()
glListParameteriSGIX v1 v2 v3 = liftIO $ dyn488 ptr_glListParameteriSGIX v1 v2 v3

{-# NOINLINE ptr_glListParameteriSGIX #-}
ptr_glListParameteriSGIX :: FunPtr (GLuint -> GLenum -> GLint -> IO ())
ptr_glListParameteriSGIX = unsafePerformIO $ getCommand "glListParameteriSGIX"

-- glListParameterivSGIX -------------------------------------------------------

glListParameterivSGIX
  :: MonadIO m
  => GLuint -- ^ @list@ of type @List@.
  -> GLenum -- ^ @pname@ of type [ListParameterName](Graphics-GL-Groups.html#ListParameterName).
  -> Ptr GLint -- ^ @params@ pointing to @COMPSIZE(pname)@ elements of type @CheckedInt32@.
  -> m ()
glListParameterivSGIX v1 v2 v3 = liftIO $ dyn334 ptr_glListParameterivSGIX v1 v2 v3

{-# NOINLINE ptr_glListParameterivSGIX #-}
ptr_glListParameterivSGIX :: FunPtr (GLuint -> GLenum -> Ptr GLint -> IO ())
ptr_glListParameterivSGIX = unsafePerformIO $ getCommand "glListParameterivSGIX"

-- glLoadIdentity --------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLoadIdentity.xml OpenGL 2.x>.
glLoadIdentity
  :: MonadIO m
  => m ()
glLoadIdentity = liftIO $ dyn10 ptr_glLoadIdentity

{-# NOINLINE ptr_glLoadIdentity #-}
ptr_glLoadIdentity :: FunPtr (IO ())
ptr_glLoadIdentity = unsafePerformIO $ getCommand "glLoadIdentity"

-- glLoadIdentityDeformationMapSGIX --------------------------------------------

glLoadIdentityDeformationMapSGIX
  :: MonadIO m
  => GLbitfield -- ^ @mask@ of type [FfdMaskSGIX](Graphics-GL-Groups.html#FfdMaskSGIX).
  -> m ()
glLoadIdentityDeformationMapSGIX v1 = liftIO $ dyn69 ptr_glLoadIdentityDeformationMapSGIX v1

{-# NOINLINE ptr_glLoadIdentityDeformationMapSGIX #-}
ptr_glLoadIdentityDeformationMapSGIX :: FunPtr (GLbitfield -> IO ())
ptr_glLoadIdentityDeformationMapSGIX = unsafePerformIO $ getCommand "glLoadIdentityDeformationMapSGIX"

-- glLoadMatrixd ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLoadMatrix.xml OpenGL 2.x>.
glLoadMatrixd
  :: MonadIO m
  => Ptr GLdouble -- ^ @m@ pointing to @16@ elements of type @GLdouble@.
  -> m ()
glLoadMatrixd v1 = liftIO $ dyn39 ptr_glLoadMatrixd v1

{-# NOINLINE ptr_glLoadMatrixd #-}
ptr_glLoadMatrixd :: FunPtr (Ptr GLdouble -> IO ())
ptr_glLoadMatrixd = unsafePerformIO $ getCommand "glLoadMatrixd"

-- glLoadMatrixf ---------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLoadMatrix.xml OpenGL 2.x>.
glLoadMatrixf
  :: MonadIO m
  => Ptr GLfloat -- ^ @m@ pointing to @16@ elements of type @GLfloat@.
  -> m ()
glLoadMatrixf v1 = liftIO $ dyn41 ptr_glLoadMatrixf v1

{-# NOINLINE ptr_glLoadMatrixf #-}
ptr_glLoadMatrixf :: FunPtr (Ptr GLfloat -> IO ())
ptr_glLoadMatrixf = unsafePerformIO $ getCommand "glLoadMatrixf"

-- glLoadMatrixx ---------------------------------------------------------------

glLoadMatrixx
  :: MonadIO m
  => Ptr GLfixed -- ^ @m@ pointing to @16@ elements of type @GLfixed@.
  -> m ()
glLoadMatrixx v1 = liftIO $ dyn107 ptr_glLoadMatrixx v1

{-# NOINLINE ptr_glLoadMatrixx #-}
ptr_glLoadMatrixx :: FunPtr (Ptr GLfixed -> IO ())
ptr_glLoadMatrixx = unsafePerformIO $ getCommand "glLoadMatrixx"

-- glLoadMatrixxOES ------------------------------------------------------------

glLoadMatrixxOES
  :: MonadIO m
  => Ptr GLfixed -- ^ @m@ pointing to @16@ elements of type @GLfixed@.
  -> m ()
glLoadMatrixxOES v1 = liftIO $ dyn107 ptr_glLoadMatrixxOES v1

{-# NOINLINE ptr_glLoadMatrixxOES #-}
ptr_glLoadMatrixxOES :: FunPtr (Ptr GLfixed -> IO ())
ptr_glLoadMatrixxOES = unsafePerformIO $ getCommand "glLoadMatrixxOES"

-- glLoadName ------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLoadName.xml OpenGL 2.x>.
glLoadName
  :: MonadIO m
  => GLuint -- ^ @name@ of type @SelectName@.
  -> m ()
glLoadName v1 = liftIO $ dyn2 ptr_glLoadName v1

{-# NOINLINE ptr_glLoadName #-}
ptr_glLoadName :: FunPtr (GLuint -> IO ())
ptr_glLoadName = unsafePerformIO $ getCommand "glLoadName"

-- glLoadPaletteFromModelViewMatrixOES -----------------------------------------

glLoadPaletteFromModelViewMatrixOES
  :: MonadIO m
  => m ()
glLoadPaletteFromModelViewMatrixOES = liftIO $ dyn10 ptr_glLoadPaletteFromModelViewMatrixOES

{-# NOINLINE ptr_glLoadPaletteFromModelViewMatrixOES #-}
ptr_glLoadPaletteFromModelViewMatrixOES :: FunPtr (IO ())
ptr_glLoadPaletteFromModelViewMatrixOES = unsafePerformIO $ getCommand "glLoadPaletteFromModelViewMatrixOES"

-- glLoadProgramNV -------------------------------------------------------------

glLoadProgramNV
  :: MonadIO m
  => GLenum -- ^ @target@ of type @VertexAttribEnumNV@.
  -> GLuint -- ^ @id@.
  -> GLsizei -- ^ @len@.
  -> Ptr GLubyte -- ^ @program@ pointing to @len@ elements of type @GLubyte@.
  -> m ()
glLoadProgramNV v1 v2 v3 v4 = liftIO $ dyn489 ptr_glLoadProgramNV v1 v2 v3 v4

{-# NOINLINE ptr_glLoadProgramNV #-}
ptr_glLoadProgramNV :: FunPtr (GLenum -> GLuint -> GLsizei -> Ptr GLubyte -> IO ())
ptr_glLoadProgramNV = unsafePerformIO $ getCommand "glLoadProgramNV"

-- glLoadTransposeMatrixd ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLoadTransposeMatrix.xml OpenGL 2.x>.
glLoadTransposeMatrixd
  :: MonadIO m
  => Ptr GLdouble -- ^ @m@ pointing to @16@ elements of type @GLdouble@.
  -> m ()
glLoadTransposeMatrixd v1 = liftIO $ dyn39 ptr_glLoadTransposeMatrixd v1

{-# NOINLINE ptr_glLoadTransposeMatrixd #-}
ptr_glLoadTransposeMatrixd :: FunPtr (Ptr GLdouble -> IO ())
ptr_glLoadTransposeMatrixd = unsafePerformIO $ getCommand "glLoadTransposeMatrixd"

-- glLoadTransposeMatrixdARB ---------------------------------------------------

-- | This command is an alias for 'glLoadTransposeMatrixd'.
glLoadTransposeMatrixdARB
  :: MonadIO m
  => Ptr GLdouble -- ^ @m@ pointing to @16@ elements of type @GLdouble@.
  -> m ()
glLoadTransposeMatrixdARB v1 = liftIO $ dyn39 ptr_glLoadTransposeMatrixdARB v1

{-# NOINLINE ptr_glLoadTransposeMatrixdARB #-}
ptr_glLoadTransposeMatrixdARB :: FunPtr (Ptr GLdouble -> IO ())
ptr_glLoadTransposeMatrixdARB = unsafePerformIO $ getCommand "glLoadTransposeMatrixdARB"

-- glLoadTransposeMatrixf ------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glLoadTransposeMatrix.xml OpenGL 2.x>.
glLoadTransposeMatrixf
  :: MonadIO m
  => Ptr GLfloat -- ^ @m@ pointing to @16@ elements of type @GLfloat@.
  -> m ()
glLoadTransposeMatrixf v1 = liftIO $ dyn41 ptr_glLoadTransposeMatrixf v1

{-# NOINLINE ptr_glLoadTransposeMatrixf #-}
ptr_glLoadTransposeMatrixf :: FunPtr (Ptr GLfloat -> IO ())
ptr_glLoadTransposeMatrixf = unsafePerformIO $ getCommand "glLoadTransposeMatrixf"

-- glLoadTransposeMatrixfARB ---------------------------------------------------

-- | This command is an alias for 'glLoadTransposeMatrixf'.
glLoadTransposeMatrixfARB
  :: MonadIO m
  => Ptr GLfloat -- ^ @m@ pointing to @16@ elements of type @GLfloat@.
  -> m ()
glLoadTransposeMatrixfARB v1 = liftIO $ dyn41 ptr_glLoadTransposeMatrixfARB v1

{-# NOINLINE ptr_glLoadTransposeMatrixfARB #-}
ptr_glLoadTransposeMatrixfARB :: FunPtr (Ptr GLfloat -> IO ())
ptr_glLoadTransposeMatrixfARB = unsafePerformIO $ getCommand "glLoadTransposeMatrixfARB"

-- glLoadTransposeMatrixxOES ---------------------------------------------------

glLoadTransposeMatrixxOES
  :: MonadIO m
  => Ptr GLfixed -- ^ @m@ pointing to @16@ elements of type @GLfixed@.
  -> m ()
glLoadTransposeMatrixxOES v1 = liftIO $ dyn107 ptr_glLoadTransposeMatrixxOES v1

{-# NOINLINE ptr_glLoadTransposeMatrixxOES #-}
ptr_glLoadTransposeMatrixxOES :: FunPtr (Ptr GLfixed -> IO ())
ptr_glLoadTransposeMatrixxOES = unsafePerformIO $ getCommand "glLoadTransposeMatrixxOES"

-- glLockArraysEXT -------------------------------------------------------------

glLockArraysEXT
  :: MonadIO m
  => GLint -- ^ @first@.
  -> GLsizei -- ^ @count@.
  -> m ()
glLockArraysEXT v1 v2 = liftIO $ dyn490 ptr_glLockArraysEXT v1 v2

{-# NOINLINE ptr_glLockArraysEXT #-}
ptr_glLockArraysEXT :: FunPtr (GLint -> GLsizei -> IO ())
ptr_glLockArraysEXT = unsafePerformIO $ getCommand "glLockArraysEXT"

-- glLogicOp -------------------------------------------------------------------

-- | Manual pages for <https://www.opengl.org/sdk/docs/man2/xhtml/glLogicOp.xml OpenGL 2.x> or <https://www.opengl.org/sdk/docs/man3/xhtml/glLogicOp.xml OpenGL 3.x> or <https://www.opengl.org/sdk/docs/man4/html/glLogicOp.xhtml OpenGL 4.x>.
glLogicOp
  :: MonadIO m
  => GLenum -- ^ @opcode@ of type [LogicOp](Graphics-GL-Groups.html#LogicOp).
  -> m ()
glLogicOp v1 = liftIO $ dyn4 ptr_glLogicOp v1

{-# NOINLINE ptr_glLogicOp #-}
ptr_glLogicOp :: FunPtr (GLenum -> IO ())
ptr_glLogicOp = unsafePerformIO $ getCommand "glLogicOp"

-- glMakeBufferNonResidentNV ---------------------------------------------------

glMakeBufferNonResidentNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> m ()
glMakeBufferNonResidentNV v1 = liftIO $ dyn4 ptr_glMakeBufferNonResidentNV v1

{-# NOINLINE ptr_glMakeBufferNonResidentNV #-}
ptr_glMakeBufferNonResidentNV :: FunPtr (GLenum -> IO ())
ptr_glMakeBufferNonResidentNV = unsafePerformIO $ getCommand "glMakeBufferNonResidentNV"

-- glMakeBufferResidentNV ------------------------------------------------------

glMakeBufferResidentNV
  :: MonadIO m
  => GLenum -- ^ @target@.
  -> GLenum -- ^ @access@.
  -> m ()
glMakeBufferResidentNV v1 v2 = liftIO $ dyn51 ptr_glMakeBufferResidentNV v1 v2

{-# NOINLINE ptr_glMakeBufferResidentNV #-}
ptr_glMakeBufferResidentNV :: FunPtr (GLenum -> GLenum -> IO ())
ptr_glMakeBufferResidentNV = unsafePerformIO $ getCommand "glMakeBufferResidentNV"

-- glMakeImageHandleNonResidentARB ---------------------------------------------

glMakeImageHandleNonResidentARB
  :: MonadIO m
  => GLuint64 -- ^ @handle@.
  -> m ()
glMakeImageHandleNonResidentARB v1 = liftIO $ dyn491 ptr_glMakeImageHandleNonResidentARB v1

{-# NOINLINE ptr_glMakeImageHandleNonResidentARB #-}
ptr_glMakeImageHandleNonResidentARB :: FunPtr (GLuint64 -> IO ())
ptr_glMakeImageHandleNonResidentARB = unsafePerformIO $ getCommand "glMakeImageHandleNonResidentARB"

-- glMakeImageHandleNonResidentNV ----------------------------------------------

glMakeImageHandleNonResidentNV
  :: MonadIO m
  => GLuint64 -- ^ @handle@.
  -> m ()
glMakeImageHandleNonResidentNV v1 = liftIO $ dyn491 ptr_glMakeImageHandleNonResidentNV v1

{-# NOINLINE ptr_glMakeImageHandleNonResidentNV #-}
ptr_glMakeImageHandleNonResidentNV :: FunPtr (GLuint64 -> IO ())
ptr_glMakeImageHandleNonResidentNV = unsafePerformIO $ getCommand "glMakeImageHandleNonResidentNV"

-- glMakeImageHandleResidentARB ------------------------------------------------

glMakeImageHandleResidentARB
  :: MonadIO m
  => GLuint64 -- ^ @handle@.
  -> GLenum -- ^ @access@.
  -> m ()
glMakeImageHandleResidentARB v1 v2 = liftIO $ dyn492 ptr_glMakeImageHandleResidentARB v1 v2

{-# NOINLINE ptr_glMakeImageHandleResidentARB #-}
ptr_glMakeImageHandleResidentARB :: FunPtr (GLuint64 -> GLenum -> IO ())
ptr_glMakeImageHandleResidentARB = unsafePerformIO $ getCommand "glMakeImageHandleResidentARB"

-- glMakeImageHandleResidentNV -------------------------------------------------

glMakeImageHandleResidentNV
  :: MonadIO m
  => GLuint64 -- ^ @handle@.
  -> GLenum -- ^ @access@.
  -> m ()
glMakeImageHandleResidentNV v1 v2 = liftIO $ dyn492 ptr_glMakeImageHandleResidentNV v1 v2

{-# NOINLINE ptr_glMakeImageHandleResidentNV #-}
ptr_glMakeImageHandleResidentNV :: FunPtr (GLuint64 -> GLenum -> IO ())
ptr_glMakeImageHandleResidentNV = unsafePerformIO $ getCommand "glMakeImageHandleResidentNV"

-- glMakeNamedBufferNonResidentNV ----------------------------------------------

glMakeNamedBufferNonResidentNV
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> m ()
glMakeNamedBufferNonResidentNV v1 = liftIO $ dyn2 ptr_glMakeNamedBufferNonResidentNV v1

{-# NOINLINE ptr_glMakeNamedBufferNonResidentNV #-}
ptr_glMakeNamedBufferNonResidentNV :: FunPtr (GLuint -> IO ())
ptr_glMakeNamedBufferNonResidentNV = unsafePerformIO $ getCommand "glMakeNamedBufferNonResidentNV"

-- glMakeNamedBufferResidentNV -------------------------------------------------

glMakeNamedBufferResidentNV
  :: MonadIO m
  => GLuint -- ^ @buffer@.
  -> GLenum -- ^ @access@.
  -> m ()
glMakeNamedBufferResidentNV v1 v2 = liftIO $ dyn15 ptr_glMakeNamedBufferResidentNV v1 v2

{-# NOINLINE ptr_glMakeNamedBufferResidentNV #-}
ptr_glMakeNamedBufferResidentNV :: FunPtr (GLuint -> GLenum -> IO ())
ptr_glMakeNamedBufferResidentNV = unsafePerformIO $ getCommand "glMakeNamedBufferResidentNV"

-- glMakeTextureHandleNonResidentARB -------------------------------------------

glMakeTextureHandleNonResidentARB
  :: MonadIO m
  => GLuint64 -- ^ @handle@.
  -> m ()
glMakeTextureHandleNonResidentARB v1 = liftIO $ dyn491 ptr_glMakeTextureHandleNonResidentARB v1

{-# NOINLINE ptr_glMakeTextureHandleNonResidentARB #-}
ptr_glMakeTextureHandleNonResidentARB :: FunPtr (GLuint64 -> IO ())
ptr_glMakeTextureHandleNonResidentARB = unsafePerformIO $ getCommand "glMakeTextureHandleNonResidentARB"

-- glMakeTextureHandleNonResidentNV --------------------------------------------

glMakeTextureHandleNonResidentNV
  :: MonadIO m
  => GLuint64 -- ^ @handle@.
  -> m ()
glMakeTextureHandleNonResidentNV v1 = liftIO $ dyn491 ptr_glMakeTextureHandleNonResidentNV v1

{-# NOINLINE ptr_glMakeTextureHandleNonResidentNV #-}
ptr_glMakeTextureHandleNonResidentNV :: FunPtr (GLuint64 -> IO ())
ptr_glMakeTextureHandleNonResidentNV = unsafePerformIO $ getCommand "glMakeTextureHandleNonResidentNV"

-- glMakeTextureHandleResidentARB ----------------------------------------------

glMakeTextureHandleResidentARB
  :: MonadIO m
  => GLuint64 -- ^ @handle@.
  -> m ()
glMakeTextureHandleResidentARB v1 = liftIO $ dyn491 ptr_glMakeTextureHandleResidentARB v1

{-# NOINLINE ptr_glMakeTextureHandleResidentARB #-}
ptr_glMakeTextureHandleResidentARB :: FunPtr (GLuint64 -> IO ())
ptr_glMakeTextureHandleResidentARB = unsafePerformIO $ getCommand "glMakeTextureHandleResidentARB"

-- glMakeTextureHandleResidentNV -----------------------------------------------

glMakeTextureHandleResidentNV
  :: MonadIO m
  => GLuint64 -- ^ @handle@.
  -> m ()
glMakeTextureHandleResidentNV v1 = liftIO $ dyn491 ptr_glMakeTextureHandleResidentNV v1

{-# NOINLINE ptr_glMakeTextureHandleResidentNV #-}
ptr_glMakeTextureHandleResidentNV :: FunPtr (GLuint64 -> IO ())
ptr_glMakeTextureHandleResidentNV = unsafePerformIO $ getCommand "glMakeTextureHandleResidentNV"

-- glMap1d ---------------------------------------------------------------------

-- | Manual page for <https://www.opengl.org/sdk/docs/man2/xhtml/glMap1.xml OpenGL 2.x>.
glMap1d
  :: MonadIO m
  => GLenum -- ^ @target@ of type [MapTarget](Graphics-GL-Groups.html#MapTarget).
  -> GLdouble -- ^ @u1@ of type @CoordD@.
  -> GLdouble -- ^ @u2@ of type @CoordD@.
  -> GLint -- ^ @stride@.
  -> GLint -- ^ @order@ of type @CheckedInt32@.
  -> Ptr GLdouble -- ^ @points@ pointing to @COMPSIZE(target,stride,order)@ elements of type @CoordD@.
  -> m ()
glMap1d v1 v2 v3 v4 v5 v6 = liftIO $ dyn493 ptr_glMap1d v1 v2 v3 v4 v5 v6

{-# NOINLINE ptr_glMap1d #-}
ptr_glMap1d :: FunPtr (GLenum -