-- |
-- Module:     Control.Wire.Tools
-- Copyright:  (c) 2011 Ertugrul Soeylemez
-- License:    BSD3
-- Maintainer: Ertugrul Soeylemez <es@ertes.de>
--
-- Utilities for creating wires.

module Control.Wire.Tools
    ( -- * Arrow tools
      distA,
      mapA,

      -- * Utility functions
      dup
    )
    where

import Control.Arrow


-- | Distribute an input value over a list of arrow computations and
-- collect the results.

distA :: forall a b (>~). Arrow (>~) => [a >~ b] -> (a >~ [b])
distA []     = arr (const [])
distA (c:cs) = arr (uncurry (:)) <<< c &&& distA cs


-- | Duplicate a value into a tuple.

dup :: a -> (a, a)
dup x = (x, x)


-- | Lift an arrow computation to lists of values.

mapA :: ArrowChoice (>~) => (a >~ b) -> ([a] >~ [b])
mapA c =
    proc list ->
        case list of
          (x':xs') -> arr (uncurry (:)) <<< c *** mapA c -< (x', xs')
          []       -> returnA -< []
