-- |
-- Module:     FRP.NetWire.IO
-- Copyright:  (c) 2011 Ertugrul Soeylemez
-- License:    BSD3
-- Maintainer: Ertugrul Soeylemez <es@ertes.de>
--
-- Access the rest of the universe.

module FRP.NetWire.IO
    ( -- * IO Actions
      execute,

      -- * Generic actions
      liftWire
    )
    where

import Control.Exception.Control
import Control.Monad
import Control.Monad.IO.Control
import FRP.NetWire.Wire


-- | Execute the IO action in the input signal at every instant.
--
-- Note: If the action throws an exception, then this wire inhibits the
-- signal.
--
-- Inhibits on exception.  No feedback.

execute :: MonadControlIO m => Wire m (m a) a
execute = mkGen $ \_ c -> liftM (, execute) (try c)


-- | Lift the given monadic computation to a wire.  The action is run at
-- every instant.
--
-- Never inhibits.  Same feedback behaviour as the given computation.

liftWire :: Monad m => Wire m (m a) a
liftWire = mkGen $ \_ c -> liftM ((, liftWire) . Right) c
