-- | A game requires the engine provided by the library, perhaps customized,
-- and game content, defined completely afresh for the particular game.
-- The general type of the content is @ContentDef@ and it has instances
-- for all content kinds, such as items kinds
-- ("Game.LambdaHack.Content.ItemKind").
--
-- The possible kinds are fixed in the library and all defined within
-- the library source code directory. On the other hand, game content,
-- that is the values whose types are @ContentDef@ instances,
-- are defined in the directory hosting the particular game definition.
module Game.LambdaHack.Common.ContentDef
  ( ContentDef(..), contentFromList
  ) where

import Prelude ()

import Game.LambdaHack.Common.Prelude

import qualified Data.Vector as V

import Game.LambdaHack.Common.Misc

-- | The general type of a particular game content, e.g., item kinds.
data ContentDef a = ContentDef
  { getSymbol      :: a -> Char     -- ^ symbol, e.g., to print on the map
  , getName        :: a -> Text     -- ^ name, e.g., to show to the player
  , getFreq        :: a -> Freqs a  -- ^ frequency within groups
  , validateSingle :: a -> [Text]
      -- ^ validate a content item and list all offences
  , validateAll    :: [a] -> [Text]
      -- ^ validate the whole defined content of this type and list all offences
  , content        :: V.Vector a    -- ^ all content of this type
  }

contentFromList :: [a] -> V.Vector a
contentFromList = V.fromList
