-- Instances.hs: OpenPGP (RFC4880) additional types for transferable keys
-- Copyright © 2012-2013  Clint Adams
-- This software is released under the terms of the ISC license.
-- (See the LICENSE file).

module Data.Conduit.OpenPGP.Keyring.Instances (
) where

import Data.IxSet (Proxy(..), Indexable(..), ixSet, ixGen, ixFun)

import Codec.Encryption.OpenPGP.Fingerprint (eightOctetKeyID, fingerprint)
import Codec.Encryption.OpenPGP.Types

import Control.Lens ((^..))
import Data.Data.Lens (biplate)

instance Indexable TK where
    empty = ixSet
                [ ixGen (Proxy :: Proxy PKPayload)
                , ixFun getEOKIs
                , ixFun getTOFs
                ]

getEOKIs :: TK -> [EightOctetKeyId]
getEOKIs tk = map eightOctetKeyID (tk ^.. biplate :: [PKPayload])
getTOFs :: TK -> [TwentyOctetFingerprint]
getTOFs tk = map fingerprint (tk ^.. biplate :: [PKPayload])

