module Main where

import System.Cmd.Utils (pipeLinesFrom)

import Graphics.Rendering.Diagrams

import CloudPacker (diagram)

main = do
    (ph, ls) <- pipeLinesFrom "fc-list" []
    let fontnames = map (takeWhile (\c -> c/=':' && c/=',')) ls
    renderAs PNG "fontlist.png" Auto $ diagram $ map mkText $ take 30 fontnames

mkText name = lw 0 $ fc black $ tf name $ textPath 12 name
