{-# OPTIONS_GHC -w #-}
{-# OPTIONS -fglasgow-exts -cpp #-}
-- |
-- Module      :  $Header$
-- Copyright   :  (c) 2013-2016 Galois, Inc.
-- License     :  BSD3
-- Maintainer  :  cryptol@galois.com
-- Stability   :  provisional
-- Portability :  portable

{-# LANGUAGE OverloadedStrings #-}
{-# LANGUAGE Trustworthy #-}
module Cryptol.Parser
  ( parseModule
  , parseProgram, parseProgramWith
  , parseExpr, parseExprWith
  , parseDecl, parseDeclWith
  , parseDecls, parseDeclsWith
  , parseLetDecl, parseLetDeclWith
  , parseRepl, parseReplWith
  , parseSchema, parseSchemaWith
  , parseModName, parseHelpName
  , ParseError(..), ppError
  , Layout(..)
  , Config(..), defaultConfig
  , guessPreProc, PreProc(..)
  ) where

import           Control.Applicative as A
import           Data.Maybe(fromMaybe)
import           Data.Text.Lazy (Text)
import qualified Data.Text.Lazy as T
import qualified Data.Text as ST
import           Control.Monad(liftM2,msum)

import Cryptol.Prims.Syntax
import Cryptol.Parser.AST
import Cryptol.Parser.Position
import Cryptol.Parser.LexerUtils hiding (mkIdent)
import Cryptol.Parser.ParserUtils
import Cryptol.Parser.Unlit(PreProc(..), guessPreProc)

import Paths_cryptol
import qualified Data.Array as Happy_Data_Array
import qualified GHC.Exts as Happy_GHC_Exts
import Control.Applicative(Applicative(..))
import Control.Monad (ap)

-- parser produced by Happy Version 1.19.5

newtype HappyAbsSyn t70 = HappyAbsSyn HappyAny
#if __GLASGOW_HASKELL__ >= 607
type HappyAny = Happy_GHC_Exts.Any
#else
type HappyAny = forall a . a
#endif
happyIn15 :: (Module PName) -> (HappyAbsSyn t70)
happyIn15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn15 #-}
happyOut15 :: (HappyAbsSyn t70) -> (Module PName)
happyOut15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut15 #-}
happyIn16 :: (([Located Import], [TopDecl PName])) -> (HappyAbsSyn t70)
happyIn16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn16 #-}
happyOut16 :: (HappyAbsSyn t70) -> (([Located Import], [TopDecl PName]))
happyOut16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut16 #-}
happyIn17 :: ([Located Import]) -> (HappyAbsSyn t70)
happyIn17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn17 #-}
happyOut17 :: (HappyAbsSyn t70) -> ([Located Import])
happyOut17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut17 #-}
happyIn18 :: (Located Import) -> (HappyAbsSyn t70)
happyIn18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn18 #-}
happyOut18 :: (HappyAbsSyn t70) -> (Located Import)
happyOut18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut18 #-}
happyIn19 :: (Maybe (Located ModName)) -> (HappyAbsSyn t70)
happyIn19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn19 #-}
happyOut19 :: (HappyAbsSyn t70) -> (Maybe (Located ModName))
happyOut19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut19 #-}
happyIn20 :: (Maybe (Located ImportSpec)) -> (HappyAbsSyn t70)
happyIn20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn20 #-}
happyOut20 :: (HappyAbsSyn t70) -> (Maybe (Located ImportSpec))
happyOut20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut20 #-}
happyIn21 :: ([LIdent]) -> (HappyAbsSyn t70)
happyIn21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn21 #-}
happyOut21 :: (HappyAbsSyn t70) -> ([LIdent])
happyOut21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut21 #-}
happyIn22 :: ([Ident] -> ImportSpec) -> (HappyAbsSyn t70)
happyIn22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn22 #-}
happyOut22 :: (HappyAbsSyn t70) -> ([Ident] -> ImportSpec)
happyOut22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut22 #-}
happyIn23 :: (Program PName) -> (HappyAbsSyn t70)
happyIn23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn23 #-}
happyOut23 :: (HappyAbsSyn t70) -> (Program PName)
happyOut23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut23 #-}
happyIn24 :: (Program PName) -> (HappyAbsSyn t70)
happyIn24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn24 #-}
happyOut24 :: (HappyAbsSyn t70) -> (Program PName)
happyOut24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut24 #-}
happyIn25 :: ([TopDecl PName]) -> (HappyAbsSyn t70)
happyIn25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn25 #-}
happyOut25 :: (HappyAbsSyn t70) -> ([TopDecl PName])
happyOut25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut25 #-}
happyIn26 :: ([TopDecl PName]) -> (HappyAbsSyn t70)
happyIn26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn26 #-}
happyOut26 :: (HappyAbsSyn t70) -> ([TopDecl PName])
happyOut26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut26 #-}
happyIn27 :: ([TopDecl PName]) -> (HappyAbsSyn t70)
happyIn27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn27 #-}
happyOut27 :: (HappyAbsSyn t70) -> ([TopDecl PName])
happyOut27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut27 #-}
happyIn28 :: ([TopDecl PName]) -> (HappyAbsSyn t70)
happyIn28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn28 #-}
happyOut28 :: (HappyAbsSyn t70) -> ([TopDecl PName])
happyOut28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut28 #-}
happyIn29 :: ([TopDecl PName]) -> (HappyAbsSyn t70)
happyIn29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn29 #-}
happyOut29 :: (HappyAbsSyn t70) -> ([TopDecl PName])
happyOut29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut29 #-}
happyIn30 :: ([TopDecl PName]) -> (HappyAbsSyn t70)
happyIn30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn30 #-}
happyOut30 :: (HappyAbsSyn t70) -> ([TopDecl PName])
happyOut30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut30 #-}
happyIn31 :: (Located String) -> (HappyAbsSyn t70)
happyIn31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn31 #-}
happyOut31 :: (HappyAbsSyn t70) -> (Located String)
happyOut31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut31 #-}
happyIn32 :: (Maybe (Located String)) -> (HappyAbsSyn t70)
happyIn32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn32 #-}
happyOut32 :: (HappyAbsSyn t70) -> (Maybe (Located String))
happyOut32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut32 #-}
happyIn33 :: (Decl PName) -> (HappyAbsSyn t70)
happyIn33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn33 #-}
happyOut33 :: (HappyAbsSyn t70) -> (Decl PName)
happyOut33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut33 #-}
happyIn34 :: (Decl PName) -> (HappyAbsSyn t70)
happyIn34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn34 #-}
happyOut34 :: (HappyAbsSyn t70) -> (Decl PName)
happyOut34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut34 #-}
happyIn35 :: (Newtype PName) -> (HappyAbsSyn t70)
happyIn35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn35 #-}
happyOut35 :: (HappyAbsSyn t70) -> (Newtype PName)
happyOut35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut35 #-}
happyIn36 :: ([Named (Type PName)]) -> (HappyAbsSyn t70)
happyIn36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn36 #-}
happyOut36 :: (HappyAbsSyn t70) -> ([Named (Type PName)])
happyOut36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut36 #-}
happyIn37 :: ([ LPName ]) -> (HappyAbsSyn t70)
happyIn37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn37 #-}
happyOut37 :: (HappyAbsSyn t70) -> ([ LPName ])
happyOut37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut37 #-}
happyIn38 :: (LPName) -> (HappyAbsSyn t70)
happyIn38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn38 #-}
happyOut38 :: (HappyAbsSyn t70) -> (LPName)
happyOut38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut38 #-}
happyIn39 :: ([Pattern PName]) -> (HappyAbsSyn t70)
happyIn39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn39 #-}
happyOut39 :: (HappyAbsSyn t70) -> ([Pattern PName])
happyOut39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut39 #-}
happyIn40 :: ([Pattern PName]) -> (HappyAbsSyn t70)
happyIn40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn40 #-}
happyOut40 :: (HappyAbsSyn t70) -> ([Pattern PName])
happyOut40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut40 #-}
happyIn41 :: ([Decl PName]) -> (HappyAbsSyn t70)
happyIn41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn41 #-}
happyOut41 :: (HappyAbsSyn t70) -> ([Decl PName])
happyOut41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut41 #-}
happyIn42 :: ([Decl PName]) -> (HappyAbsSyn t70)
happyIn42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn42 #-}
happyOut42 :: (HappyAbsSyn t70) -> ([Decl PName])
happyOut42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut42 #-}
happyIn43 :: ([Decl PName]) -> (HappyAbsSyn t70)
happyIn43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn43 #-}
happyOut43 :: (HappyAbsSyn t70) -> ([Decl PName])
happyOut43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut43 #-}
happyIn44 :: (ReplInput PName) -> (HappyAbsSyn t70)
happyIn44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn44 #-}
happyOut44 :: (HappyAbsSyn t70) -> (ReplInput PName)
happyOut44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut44 #-}
happyIn45 :: (Expr PName) -> (HappyAbsSyn t70)
happyIn45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn45 #-}
happyOut45 :: (HappyAbsSyn t70) -> (Expr PName)
happyOut45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut45 #-}
happyIn46 :: ([(Expr PName, Expr PName)]) -> (HappyAbsSyn t70)
happyIn46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn46 #-}
happyOut46 :: (HappyAbsSyn t70) -> ([(Expr PName, Expr PName)])
happyOut46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut46 #-}
happyIn47 :: ((Expr PName, Expr PName)) -> (HappyAbsSyn t70)
happyIn47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn47 #-}
happyOut47 :: (HappyAbsSyn t70) -> ((Expr PName, Expr PName))
happyOut47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut47 #-}
happyIn48 :: (Expr PName) -> (HappyAbsSyn t70)
happyIn48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn48 #-}
happyOut48 :: (HappyAbsSyn t70) -> (Expr PName)
happyOut48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut48 #-}
happyIn49 :: (Expr PName) -> (HappyAbsSyn t70)
happyIn49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn49 #-}
happyOut49 :: (HappyAbsSyn t70) -> (Expr PName)
happyOut49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut49 #-}
happyIn50 :: (Expr PName) -> (HappyAbsSyn t70)
happyIn50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn50 #-}
happyOut50 :: (HappyAbsSyn t70) -> (Expr PName)
happyOut50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut50 #-}
happyIn51 :: (Expr PName) -> (HappyAbsSyn t70)
happyIn51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn51 #-}
happyOut51 :: (HappyAbsSyn t70) -> (Expr PName)
happyOut51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut51 #-}
happyIn52 :: (LPName) -> (HappyAbsSyn t70)
happyIn52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn52 #-}
happyOut52 :: (HappyAbsSyn t70) -> (LPName)
happyOut52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut52 #-}
happyIn53 :: (LPName) -> (HappyAbsSyn t70)
happyIn53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn53 #-}
happyOut53 :: (HappyAbsSyn t70) -> (LPName)
happyOut53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut53 #-}
happyIn54 :: (LPName) -> (HappyAbsSyn t70)
happyIn54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn54 #-}
happyOut54 :: (HappyAbsSyn t70) -> (LPName)
happyOut54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut54 #-}
happyIn55 :: (LPName) -> (HappyAbsSyn t70)
happyIn55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn55 #-}
happyOut55 :: (HappyAbsSyn t70) -> (LPName)
happyOut55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut55 #-}
happyIn56 :: ([LPName]) -> (HappyAbsSyn t70)
happyIn56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn56 #-}
happyOut56 :: (HappyAbsSyn t70) -> ([LPName])
happyOut56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut56 #-}
happyIn57 :: ([Expr PName]) -> (HappyAbsSyn t70)
happyIn57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn57 #-}
happyOut57 :: (HappyAbsSyn t70) -> ([Expr PName])
happyOut57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut57 #-}
happyIn58 :: (Expr PName) -> (HappyAbsSyn t70)
happyIn58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn58 #-}
happyOut58 :: (HappyAbsSyn t70) -> (Expr PName)
happyOut58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut58 #-}
happyIn59 :: ([(Bool, Integer)]) -> (HappyAbsSyn t70)
happyIn59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn59 #-}
happyOut59 :: (HappyAbsSyn t70) -> ([(Bool, Integer)])
happyOut59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut59 #-}
happyIn60 :: ((Bool, Integer)) -> (HappyAbsSyn t70)
happyIn60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn60 #-}
happyOut60 :: (HappyAbsSyn t70) -> ((Bool, Integer))
happyOut60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut60 #-}
happyIn61 :: (Located Selector) -> (HappyAbsSyn t70)
happyIn61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn61 #-}
happyOut61 :: (HappyAbsSyn t70) -> (Located Selector)
happyOut61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut61 #-}
happyIn62 :: ([Expr PName]) -> (HappyAbsSyn t70)
happyIn62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn62 #-}
happyOut62 :: (HappyAbsSyn t70) -> ([Expr PName])
happyOut62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut62 #-}
happyIn63 :: (Named (Expr PName)) -> (HappyAbsSyn t70)
happyIn63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn63 #-}
happyOut63 :: (HappyAbsSyn t70) -> (Named (Expr PName))
happyOut63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut63 #-}
happyIn64 :: ([Named (Expr PName)]) -> (HappyAbsSyn t70)
happyIn64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn64 #-}
happyOut64 :: (HappyAbsSyn t70) -> ([Named (Expr PName)])
happyOut64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut64 #-}
happyIn65 :: (Expr PName) -> (HappyAbsSyn t70)
happyIn65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn65 #-}
happyOut65 :: (HappyAbsSyn t70) -> (Expr PName)
happyOut65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut65 #-}
happyIn66 :: ([[Match PName]]) -> (HappyAbsSyn t70)
happyIn66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn66 #-}
happyOut66 :: (HappyAbsSyn t70) -> ([[Match PName]])
happyOut66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut66 #-}
happyIn67 :: ([Match PName]) -> (HappyAbsSyn t70)
happyIn67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn67 #-}
happyOut67 :: (HappyAbsSyn t70) -> ([Match PName])
happyOut67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut67 #-}
happyIn68 :: (Match PName) -> (HappyAbsSyn t70)
happyIn68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn68 #-}
happyOut68 :: (HappyAbsSyn t70) -> (Match PName)
happyOut68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut68 #-}
happyIn69 :: (Pattern PName) -> (HappyAbsSyn t70)
happyIn69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn69 #-}
happyOut69 :: (HappyAbsSyn t70) -> (Pattern PName)
happyOut69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut69 #-}
happyIn70 :: t70 -> (HappyAbsSyn t70)
happyIn70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn70 #-}
happyOut70 :: (HappyAbsSyn t70) -> t70
happyOut70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut70 #-}
happyIn71 :: (Pattern PName) -> (HappyAbsSyn t70)
happyIn71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn71 #-}
happyOut71 :: (HappyAbsSyn t70) -> (Pattern PName)
happyOut71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut71 #-}
happyIn72 :: ([Pattern PName]) -> (HappyAbsSyn t70)
happyIn72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn72 #-}
happyOut72 :: (HappyAbsSyn t70) -> ([Pattern PName])
happyOut72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut72 #-}
happyIn73 :: (Named (Pattern PName)) -> (HappyAbsSyn t70)
happyIn73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn73 #-}
happyOut73 :: (HappyAbsSyn t70) -> (Named (Pattern PName))
happyOut73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut73 #-}
happyIn74 :: ([Named (Pattern PName)]) -> (HappyAbsSyn t70)
happyIn74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn74 #-}
happyOut74 :: (HappyAbsSyn t70) -> ([Named (Pattern PName)])
happyOut74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut74 #-}
happyIn75 :: (Schema PName) -> (HappyAbsSyn t70)
happyIn75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn75 #-}
happyOut75 :: (HappyAbsSyn t70) -> (Schema PName)
happyOut75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut75 #-}
happyIn76 :: (Located [TParam PName]) -> (HappyAbsSyn t70)
happyIn76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn76 #-}
happyOut76 :: (HappyAbsSyn t70) -> (Located [TParam PName])
happyOut76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut76 #-}
happyIn77 :: (Located [Prop PName]) -> (HappyAbsSyn t70)
happyIn77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn77 #-}
happyOut77 :: (HappyAbsSyn t70) -> (Located [Prop PName])
happyOut77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut77 #-}
happyIn78 :: (Located Kind) -> (HappyAbsSyn t70)
happyIn78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn78 #-}
happyOut78 :: (HappyAbsSyn t70) -> (Located Kind)
happyOut78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut78 #-}
happyIn79 :: (TParam PName) -> (HappyAbsSyn t70)
happyIn79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn79 #-}
happyOut79 :: (HappyAbsSyn t70) -> (TParam PName)
happyOut79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut79 #-}
happyIn80 :: ([TParam PName]) -> (HappyAbsSyn t70)
happyIn80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn80 #-}
happyOut80 :: (HappyAbsSyn t70) -> ([TParam PName])
happyOut80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut80 #-}
happyIn81 :: (TParam PName) -> (HappyAbsSyn t70)
happyIn81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn81 #-}
happyOut81 :: (HappyAbsSyn t70) -> (TParam PName)
happyOut81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut81 #-}
happyIn82 :: ([TParam PName]) -> (HappyAbsSyn t70)
happyIn82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn82 #-}
happyOut82 :: (HappyAbsSyn t70) -> ([TParam PName])
happyOut82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut82 #-}
happyIn83 :: (Type PName) -> (HappyAbsSyn t70)
happyIn83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn83 #-}
happyOut83 :: (HappyAbsSyn t70) -> (Type PName)
happyOut83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut83 #-}
happyIn84 :: (Type PName) -> (HappyAbsSyn t70)
happyIn84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn84 #-}
happyOut84 :: (HappyAbsSyn t70) -> (Type PName)
happyOut84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut84 #-}
happyIn85 :: (Type PName) -> (HappyAbsSyn t70)
happyIn85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn85 #-}
happyOut85 :: (HappyAbsSyn t70) -> (Type PName)
happyOut85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut85 #-}
happyIn86 :: ([ Type PName ]) -> (HappyAbsSyn t70)
happyIn86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn86 #-}
happyOut86 :: (HappyAbsSyn t70) -> ([ Type PName ])
happyOut86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut86 #-}
happyIn87 :: (Located [Type PName]) -> (HappyAbsSyn t70)
happyIn87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn87 #-}
happyOut87 :: (HappyAbsSyn t70) -> (Located [Type PName])
happyOut87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut87 #-}
happyIn88 :: ([Type PName]) -> (HappyAbsSyn t70)
happyIn88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn88 #-}
happyOut88 :: (HappyAbsSyn t70) -> ([Type PName])
happyOut88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut88 #-}
happyIn89 :: (Named (Type PName)) -> (HappyAbsSyn t70)
happyIn89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn89 #-}
happyOut89 :: (HappyAbsSyn t70) -> (Named (Type PName))
happyOut89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut89 #-}
happyIn90 :: ([Named (Type PName)]) -> (HappyAbsSyn t70)
happyIn90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn90 #-}
happyOut90 :: (HappyAbsSyn t70) -> ([Named (Type PName)])
happyOut90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut90 #-}
happyIn91 :: (Located Ident) -> (HappyAbsSyn t70)
happyIn91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn91 #-}
happyOut91 :: (HappyAbsSyn t70) -> (Located Ident)
happyOut91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut91 #-}
happyIn92 :: (LPName) -> (HappyAbsSyn t70)
happyIn92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn92 #-}
happyOut92 :: (HappyAbsSyn t70) -> (LPName)
happyOut92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut92 #-}
happyIn93 :: (Located ModName) -> (HappyAbsSyn t70)
happyIn93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn93 #-}
happyOut93 :: (HappyAbsSyn t70) -> (Located ModName)
happyOut93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut93 #-}
happyIn94 :: (Located PName) -> (HappyAbsSyn t70)
happyIn94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn94 #-}
happyOut94 :: (HappyAbsSyn t70) -> (Located PName)
happyOut94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut94 #-}
happyIn95 :: (Located PName) -> (HappyAbsSyn t70)
happyIn95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn95 #-}
happyOut95 :: (HappyAbsSyn t70) -> (Located PName)
happyOut95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut95 #-}
happyIn96 :: (Type PName) -> (HappyAbsSyn t70)
happyIn96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn96 #-}
happyOut96 :: (HappyAbsSyn t70) -> (Type PName)
happyOut96 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut96 #-}
happyIn97 :: (Named (Type PName)) -> (HappyAbsSyn t70)
happyIn97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn97 #-}
happyOut97 :: (HappyAbsSyn t70) -> (Named (Type PName))
happyOut97 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut97 #-}
happyIn98 :: ([Named (Type PName)]) -> (HappyAbsSyn t70)
happyIn98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn98 #-}
happyOut98 :: (HappyAbsSyn t70) -> ([Named (Type PName)])
happyOut98 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut98 #-}
happyInTok :: (Located Token) -> (HappyAbsSyn t70)
happyInTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyInTok #-}
happyOutTok :: (HappyAbsSyn t70) -> (Located Token)
happyOutTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOutTok #-}


happyActOffsets :: HappyAddr
happyActOffsets = HappyA# "\x08\x00\xad\x01\x7f\x03\xb5\x02\x83\x06\x83\x06\x7a\x03\x93\x03\x86\x02\xee\x05\xbf\x07\xf1\x02\x90\x03\xbf\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x65\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x8c\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x65\x03\x00\x00\x65\x03\xd5\x05\xd5\x05\xc5\x07\x70\x03\x00\x00\xbc\x05\xa3\x05\x00\x00\x00\x00\x8a\x05\xc2\x04\x33\x07\x00\x00\x00\x00\x5d\x03\x72\x03\x00\x00\x00\x00\xb7\x07\x00\x00\x03\x07\x5f\x03\x00\x00\x00\x00\x00\x00\x00\x00\xd3\x06\xb5\x02\x57\x02\x63\x01\x1c\x07\x43\x00\x30\x07\xd3\x06\xce\x02\xce\x02\x40\x03\x40\x03\x16\x06\x53\x03\x22\x00\xd3\x06\xc1\x01\x2a\x01\x1d\x05\xb0\x07\x71\x03\x6b\x03\x69\x03\xc2\x07\xf4\x02\xfd\x02\xa1\x06\x00\x00\x2b\x03\xf3\xff\x2b\x03\x10\x02\x2b\x03\x99\x01\x41\x03\x00\x00\x00\x00\x43\x03\x00\x00\x58\x03\x00\x00\x1d\x03\xd5\x01\x23\x03\x19\x01\x00\x00\x05\x01\x00\x00\x00\x00\x00\x00\x6f\x06\x70\x01\x00\x00\xbf\x07\x20\x03\x00\x00\x93\x05\x00\x00\x22\x03\x35\x02\x00\x00\x70\x00\x00\x00\x2c\x02\x10\x03\x00\x00\x21\x03\xdf\x02\x3f\x00\x00\x00\xc0\x02\x00\x00\xbf\x06\x00\x00\xed\x01\x2e\x00\x00\x00\x2f\x05\x94\x08\x94\x08\x94\x08\xd3\x06\xb5\x02\xd3\x06\xf7\x02\x0f\x03\xd3\x06\x41\x02\x7a\x05\x71\x05\x00\x00\x00\x00\x14\x02\x00\x00\x00\x00\x00\x00\x01\x03\x00\x00\x00\x00\x00\x00\x58\x05\xa9\x04\x1f\x00\x00\x00\x00\x00\xfa\x02\x00\x00\x00\x00\x01\x02\xab\x06\x00\x00\x04\x02\xf2\x02\x94\x02\x00\x00\xce\x02\xce\x02\xf4\x01\xf6\x02\xfb\x02\x00\x00\xc0\x01\x4d\x00\x00\x00\xb8\x00\xd3\x06\xf6\x00\xee\x02\xce\x02\x58\x05\x00\x00\xdc\x01\x00\x00\xc5\x01\xe5\x02\x2a\x07\x43\x07\x90\x02\x00\x00\x80\x04\x32\x05\x00\x00\x3f\x05\x00\x00\x26\x05\x00\x00\x26\x05\x26\x05\x26\x05\x00\x00\x94\x08\x26\x05\xc5\x07\xec\x02\xf8\x02\xda\x02\x00\x00\x94\x08\x00\x00\x94\x08\x9e\x04\x8e\x02\x00\x00\xde\x06\xd8\x02\x00\x00\x00\x00\x26\x05\x00\x00\x26\x05\x4b\x02\xc2\x07\x00\x00\xc2\x07\x00\x00\x94\x08\x00\x00\x00\x00\x00\x00\x00\x00\xcb\x02\xb5\x02\xb5\x02\xb5\x02\xb5\x02\x00\x00\xb5\x02\xb5\x02\x00\x00\xd3\x06\xb5\x02\x00\x00\x00\x00\x00\x00\xb5\x02\xc8\x02\xb5\x02\xc2\x07\x00\x00\xeb\x02\x00\x00\x41\x00\x4f\x07\x7f\x01\xb2\x02\x00\x00\x6e\x01\x00\x00\x37\x07\xb5\x02\x5b\x06\x00\x00\x5b\x06\x00\x00\x00\x00\x00\x00\x94\x08\x59\x01\xb5\x02\x00\x00\x9e\x02\x9c\x02\xa5\x02\x00\x00\x8c\x02\x8c\x02\x8c\x02\x00\x00\x16\x05\x00\x00\xc2\x07\x26\x05\x00\x00\xd3\x06\x00\x00\xd3\x06\x00\x00\x26\x05\x00\x00\x83\x02\xd3\x06\xc2\x07\x00\x00\x47\x06\x02\x06\x24\x02\x00\x00\x24\x02\x00\x00\x7f\x02\x94\x08\x24\x02\x93\x02\x00\x00\x96\x02\xc2\x07\xac\x05\x00\x00\x64\x02\xe9\x01\xe9\x01\x00\x00\x00\x00\x23\x00\x00\x00\x23\x00\x24\x02\xfd\x04\x97\x06\x00\x00\x86\x00\x16\x03\x08\x02\x74\x02\x0d\x05\x00\x00\x00\x00\xa6\x01\x00\x00\x33\x06\x00\x00\x00\x00\x00\x00\xb5\x02\x94\x08\x00\x00\x00\x00\x94\x08\x5c\x02\x00\x00\xf4\x04\x94\x08\xb5\x02\x6a\x02\x4d\x02\x00\x00\x00\x00\x00\x00\x00\x00\xc2\x07\x00\x00\xf4\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x51\x02\xb5\x02\x51\x02\x25\x02\x3f\x02\x1e\x02\x00\x00\x3b\x02\x19\x02\x19\x02\x19\x02\x00\x00\x00\x00\x19\x02\xb5\x02\x00\x00\x0b\x02\x00\x00\x00\x00\x94\x08\x00\x00\x00\x00\x94\x08\x94\x08\xf4\x04\x00\x00\xde\x06\xd5\x01\xe3\x01\x74\x00\x09\x02\xb5\x02\xd3\x06\xd3\x06\xb5\x02\x00\x00\x09\x02\x94\x08\xe1\x01\x00\x00\x00\x00\xa2\x01\x00\x00\x94\x08\x74\x00\xa2\x01\x00\x00\x00\x00\x00\x00\x85\x01\x00\x00\x00\x00\x00\x00\x8a\x01\x00\x00\x6c\x01\xb5\x02\xe4\x04\x7a\x01\x23\x01\x00\x00\x00\x00\x8d\x02\x7a\x01\x3a\x01\xb5\x02\xc2\x07\xdb\x04\x31\x01\x27\x01\x01\x01\x00\x00\xff\x00\x00\x00\x00\x00\x00\x00\x47\x02\x00\x00\xff\x00\x00\x00\xef\x00\x00\x00\x00\x00\x00\x00\xc2\x07\x00\x00\x00\x00"#

happyGotoOffsets :: HappyAddr
happyGotoOffsets = HappyA# "\x04\x01\x6d\x00\xed\x00\x44\x04\x39\x01\x0f\x01\xd5\x00\xd9\x00\xe8\x00\x73\x07\x50\x02\x7b\x02\x00\x00\x37\x02\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x08\x03\x6e\x08\x18\x07\x00\x00\x00\x00\x71\x06\xa2\x02\x00\x00\x00\x00\x62\x08\xba\x07\x27\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x06\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0b\x01\x3e\x03\x27\x03\x18\x03\x8c\x00\xd2\x01\xfa\x01\x5a\x02\x6e\x04\x6a\x04\x00\x00\x00\x00\xe6\x00\x00\x00\x00\x00\x72\x01\x32\x01\x00\x00\x99\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x01\xdf\x05\xf7\x06\x34\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9e\x00\x00\x00\xbb\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x28\x01\xd0\x00\x00\x00\x33\x02\x00\x00\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc7\x05\x00\x00\x00\x00\x00\x00\x00\x00\xb8\x01\x6e\x06\x5a\x06\x01\x06\x45\x01\x36\x04\xe2\x00\x00\x00\x00\x00\xe4\x00\x00\x00\xf0\xff\x66\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x56\x08\x9c\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x41\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x68\x03\x76\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x83\x00\xda\xff\x00\x00\x2c\x00\x4a\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x07\x00\x00\x00\x00\x44\x03\xaa\x06\x00\x00\x34\x03\x00\x00\x3e\x08\x00\x00\x32\x08\x26\x08\x97\x02\x00\x00\xaa\x06\x1a\x08\xaa\x06\x00\x00\x00\x00\x00\x00\x00\x00\xaa\x06\x00\x00\xaa\x06\xaa\x06\xaa\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x08\x00\x00\x02\x08\x8f\x07\xf0\x01\x00\x00\xdc\xff\x00\x00\xaa\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x04\x5c\x04\x4d\x03\x1d\x04\x00\x00\x0f\x04\x04\x04\x00\x00\x95\x05\xf6\x03\x00\x00\x00\x00\x00\x00\xe8\x03\x00\x00\xdd\x03\xfd\xff\x00\x00\x00\x00\x00\x00\x9c\x00\xaa\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaa\x06\x51\x04\x26\x01\x00\x00\x16\x01\x00\x00\x00\x00\x00\x00\x21\x06\x00\x00\xcf\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x82\x00\x00\x00\x3b\x00\xf6\x07\x00\x00\x23\x06\x00\x00\x55\x04\x00\x00\xea\x07\x00\x00\x00\x00\xd4\x01\xcf\xff\x00\x00\xf4\xff\xde\x00\xd7\x00\x00\x00\xcb\x00\x00\x00\x00\x00\xa8\x05\x87\x00\xaf\x00\x00\x00\x00\x00\x35\x00\x28\x02\x00\x00\x00\x00\x56\x00\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7a\x00\x2c\x01\x26\x00\x00\x00\x73\x02\x9d\x01\x00\x00\x00\x00\x59\x07\x00\x00\x00\x00\x00\x00\x00\x00\x09\x01\x00\x00\x00\x00\x00\x00\xc1\x03\x59\x05\x00\x00\x00\x00\x59\x05\x00\x00\x00\x00\xde\x07\xc3\x04\xb6\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xce\xff\x00\x00\xd2\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa8\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9a\x03\x00\x00\x00\x00\x00\x00\x00\x00\x74\x04\x00\x00\x00\x00\x74\x04\x74\x04\xc6\x07\x00\x00\x00\x00\x01\x00\x00\x00\x79\x00\x00\x00\x8f\x03\x76\x01\xaf\x05\x81\x03\x00\x00\x00\x00\x74\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x74\x04\x67\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x73\x03\x82\x00\x5f\x00\x00\x00\x00\x00\x00\x00\x3d\x03\x48\x00\x00\x00\x5b\x03\xfb\xff\x4c\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd1\xff\x00\x00\x00\x00"#

happyDefActions :: HappyAddr
happyDefActions = HappyA# "\x00\x00\xc5\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0f\xff\x91\xff\x8f\xff\x8d\xff\x15\xff\x12\xff\x10\xff\x00\x00\x1a\xff\x11\xff\x17\xff\x16\xff\x18\xff\x19\xff\x00\x00\x8b\xff\x8c\xff\x88\xff\x8a\xff\x89\xff\x8e\xff\x87\xff\x90\xff\x14\xff\x00\x00\x13\xff\x00\x00\x00\x00\x00\x00\x44\xff\x31\xff\x2e\xff\x00\x00\x2d\xff\x2c\xff\x2b\xff\x00\x00\x00\x00\x00\x00\x24\xff\xa4\xff\x00\x00\xa5\xff\xa3\xff\x9b\xff\x98\xff\x96\xff\x94\xff\x84\xff\x82\xff\x81\xff\x80\xff\x7f\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb4\xff\x00\x00\x00\x00\x54\xff\xb2\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x52\xff\x00\x00\x00\x00\x00\x00\xc5\xff\x00\x00\xc5\xff\x00\x00\xcc\xff\xc6\xff\x00\x00\xce\xff\x00\x00\xc7\xff\x00\x00\xc5\xff\x00\x00\xef\xff\xea\xff\xee\xff\xd9\xff\xcf\xff\xd0\xff\xc6\xff\x00\x00\xd6\xff\x00\x00\x18\xff\xcd\xff\x00\x00\xdb\xff\x00\x00\x00\x00\xdc\xff\x00\x00\x46\xff\x00\x00\x00\x00\x4b\xff\x00\x00\x00\x00\x56\xff\x54\xff\x00\x00\x53\xff\x00\x00\x51\xff\x00\x00\x00\x00\x4e\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xae\xff\x00\x00\x00\x00\xac\xff\xaa\xff\x00\x00\xa6\xff\x92\xff\x93\xff\x00\x00\x0d\xff\x77\xff\x0c\xff\x00\x00\x00\x00\x00\x00\x72\xff\x70\xff\x6f\xff\x74\xff\x67\xff\x00\x00\x00\x00\x7b\xff\x00\x00\x00\x00\x00\x00\x7c\xff\x8a\xff\x89\xff\x64\xff\x63\xff\x00\x00\x79\xff\x00\x00\x00\x00\x9e\xff\x00\x00\x53\xff\x00\x00\x83\xff\x00\x00\x00\x00\x39\xff\x00\x00\x1c\xff\x00\x00\x3b\xff\x40\xff\x00\x00\x00\x00\x28\xff\x00\x00\x00\x00\x23\xff\x2f\xff\x2d\xff\x00\x00\x30\xff\x00\x00\x00\x00\x00\x00\x3e\xff\x42\xff\x00\x00\x43\xff\x00\x00\x00\x00\x00\x00\x0e\xff\x41\xff\x32\xff\x33\xff\x00\x00\x00\x00\x22\xff\x21\xff\x00\x00\x26\xff\x27\xff\x00\x00\x29\xff\x00\x00\x00\x00\x00\x00\x25\xff\x00\x00\x3f\xff\x97\xff\x95\xff\x76\xff\x6d\xff\x6c\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x78\xff\x00\x00\x62\xff\x5e\xff\x00\x00\x00\x00\x7d\xff\x75\xff\x7e\xff\x00\x00\x00\x00\x00\x00\x00\x00\x7a\xff\x00\x00\x73\xff\x00\x00\x00\x00\x00\x00\x15\xff\x05\xff\x00\x00\x0a\xff\x00\x00\x00\x00\x00\x00\xa7\xff\x00\x00\xc4\xff\xb3\xff\xb2\xff\x00\x00\xad\xff\x00\x00\xab\xff\x55\xff\xc3\xff\x00\x00\x86\xff\xbb\xff\xbd\xff\xbc\xff\x35\xff\x00\x00\x37\xff\x00\x00\x00\x00\x4c\xff\x00\x00\x4d\xff\x00\x00\x4f\xff\x00\x00\x50\xff\xb1\xff\x00\x00\x00\x00\x4a\xff\x00\x00\x00\x00\xc5\xff\xdd\xff\xc5\xff\xda\xff\x00\x00\x00\x00\xc5\xff\xe7\xff\xd1\xff\x00\x00\x00\x00\x00\x00\xd5\xff\x18\xff\xc5\xff\xc5\xff\xf2\xff\xec\xff\xf1\xff\xeb\xff\xf0\xff\xc5\xff\x00\x00\x00\x00\xd4\xff\xe0\xff\x00\x00\x00\x00\x00\x00\x00\x00\xd8\xff\xd7\xff\x00\x00\xa0\xff\x00\x00\xa2\xff\x45\xff\x47\xff\x00\x00\x57\xff\x49\xff\x48\xff\xbf\xff\x00\x00\x34\xff\x00\x00\x00\x00\x00\x00\xc1\xff\x00\x00\xa9\xff\xa8\xff\x99\xff\x0b\xff\x00\x00\x09\xff\x00\x00\x07\xff\x08\xff\x71\xff\x6e\xff\x66\xff\x69\xff\x00\x00\x6b\xff\x6b\xff\x65\xff\x5c\xff\x5a\xff\x00\x00\x61\xff\x6a\xff\x9c\xff\x9d\xff\x9a\xff\xba\xff\x00\x00\x38\xff\x3b\xff\x1b\xff\x3a\xff\x1d\xff\x3c\xff\x3d\xff\x1f\xff\x1e\xff\x00\x00\x2a\xff\x20\xff\xc5\xff\x00\x00\x00\x00\xb9\xff\x00\x00\x00\x00\x00\x00\x60\xff\x5d\xff\x68\xff\x06\xff\x00\x00\x04\xff\xb1\xff\xc0\xff\x85\xff\xbe\xff\x00\x00\xc2\xff\xa1\xff\x9f\xff\xc9\xff\x00\x00\xcb\xff\xe8\xff\xe9\xff\x00\x00\xe1\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xca\xff\xb8\xff\x00\x00\x00\x00\xd2\xff\x00\x00\xe2\xff\x00\x00\x00\x00\x5f\xff\x5b\xff\x59\xff\x58\xff\xf3\xff\x36\xff\xc8\xff\x00\x00\xe3\xff\xd3\xff\xb7\xff\x00\x00\xb6\xff\xb5\xff\xe6\xff\x00\x00\xe4\xff"#

happyCheck :: HappyAddr
happyCheck = HappyA# "\xff\xff\x06\x00\x01\x00\x02\x00\x03\x00\x12\x00\x12\x00\x17\x00\x2e\x00\x3a\x00\x16\x00\x17\x00\x0b\x00\x0c\x00\x1a\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x01\x00\x02\x00\x03\x00\x16\x00\x17\x00\x11\x00\x4c\x00\x4c\x00\x40\x00\x4c\x00\x0b\x00\x0c\x00\x52\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x4c\x00\x03\x00\x4c\x00\x16\x00\x17\x00\x37\x00\x38\x00\x30\x00\x3b\x00\x0b\x00\x0c\x00\x2b\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x2f\x00\x37\x00\x38\x00\x16\x00\x17\x00\x4c\x00\x4d\x00\x18\x00\x19\x00\x4c\x00\x4d\x00\x01\x00\x21\x00\x01\x00\x22\x00\x27\x00\x4c\x00\x1a\x00\x4c\x00\x37\x00\x38\x00\x2a\x00\x4c\x00\x4d\x00\x21\x00\x24\x00\x32\x00\x4c\x00\x4d\x00\x31\x00\x4f\x00\x2a\x00\x2b\x00\x17\x00\x03\x00\x17\x00\x37\x00\x38\x00\x15\x00\x38\x00\x4c\x00\x4d\x00\x0b\x00\x0c\x00\x16\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x2a\x00\x27\x00\x1e\x00\x16\x00\x17\x00\x3a\x00\x3b\x00\x4c\x00\x4d\x00\x4c\x00\x4d\x00\x15\x00\x08\x00\x37\x00\x0a\x00\x4c\x00\x4d\x00\x0d\x00\x4f\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x4c\x00\x4c\x00\x4d\x00\x16\x00\x17\x00\x0b\x00\x0c\x00\x4c\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x37\x00\x38\x00\x09\x00\x16\x00\x17\x00\x0b\x00\x0c\x00\x24\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x24\x00\x18\x00\x19\x00\x16\x00\x17\x00\x2f\x00\x2a\x00\x2b\x00\x4c\x00\x4d\x00\x37\x00\x38\x00\x3f\x00\x33\x00\x22\x00\x0b\x00\x0c\x00\x37\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x37\x00\x38\x00\x04\x00\x16\x00\x17\x00\x30\x00\x31\x00\x3f\x00\x4c\x00\x4d\x00\x38\x00\x30\x00\x31\x00\x37\x00\x38\x00\x27\x00\x28\x00\x4c\x00\x4d\x00\x42\x00\x4f\x00\x4c\x00\x4d\x00\x0d\x00\x2d\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x4c\x00\x4c\x00\x4d\x00\x16\x00\x17\x00\x4c\x00\x4d\x00\x37\x00\x38\x00\x0c\x00\x4c\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x4c\x00\x4d\x00\x28\x00\x16\x00\x17\x00\x0c\x00\x14\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x4c\x00\x4d\x00\x13\x00\x16\x00\x17\x00\x37\x00\x12\x00\x1c\x00\x37\x00\x38\x00\x16\x00\x17\x00\x09\x00\x01\x00\x12\x00\x1b\x00\x04\x00\x13\x00\x16\x00\x17\x00\x08\x00\x09\x00\x0a\x00\x1b\x00\x37\x00\x38\x00\x00\x00\x1d\x00\x1e\x00\x4c\x00\x4d\x00\x21\x00\x22\x00\x23\x00\x24\x00\x17\x00\x37\x00\x38\x00\x21\x00\x12\x00\x2a\x00\x2b\x00\x25\x00\x37\x00\x38\x00\x4c\x00\x4d\x00\x37\x00\x38\x00\x12\x00\x38\x00\x37\x00\x38\x00\x16\x00\x17\x00\x12\x00\x21\x00\x4c\x00\x4d\x00\x16\x00\x17\x00\x22\x00\x12\x00\x1a\x00\x4c\x00\x4d\x00\x16\x00\x17\x00\x4c\x00\x4d\x00\x4c\x00\x4d\x00\x4c\x00\x4d\x00\x4c\x00\x4d\x00\x31\x00\x4f\x00\x12\x00\x12\x00\x12\x00\x22\x00\x16\x00\x17\x00\x16\x00\x17\x00\x37\x00\x38\x00\x37\x00\x38\x00\x12\x00\x22\x00\x37\x00\x38\x00\x16\x00\x17\x00\x31\x00\x12\x00\x12\x00\x37\x00\x38\x00\x16\x00\x17\x00\x20\x00\x28\x00\x30\x00\x31\x00\x4c\x00\x4d\x00\x4c\x00\x4d\x00\x18\x00\x19\x00\x4c\x00\x4d\x00\x37\x00\x38\x00\x37\x00\x38\x00\x37\x00\x4c\x00\x4d\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x37\x00\x38\x00\x08\x00\x09\x00\x0a\x00\x42\x00\x43\x00\x37\x00\x38\x00\x4c\x00\x4d\x00\x4c\x00\x4d\x00\x06\x00\x14\x00\x4c\x00\x38\x00\x17\x00\x0b\x00\x19\x00\x38\x00\x4c\x00\x4d\x00\x10\x00\x28\x00\x1f\x00\x20\x00\x2b\x00\x4c\x00\x4d\x00\x24\x00\x18\x00\x26\x00\x18\x00\x19\x00\x29\x00\x4c\x00\x4d\x00\x21\x00\x2d\x00\x4c\x00\x4d\x00\x25\x00\x28\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x04\x00\x24\x00\x06\x00\x21\x00\x08\x00\x09\x00\x0a\x00\x25\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x1f\x00\x38\x00\x35\x00\x36\x00\x37\x00\x38\x00\x2a\x00\x17\x00\x04\x00\x19\x00\x06\x00\x12\x00\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x4c\x00\x4d\x00\x4c\x00\x4d\x00\x4c\x00\x4d\x00\x17\x00\x04\x00\x19\x00\x2e\x00\x22\x00\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x12\x00\x3a\x00\x3b\x00\x15\x00\x30\x00\x31\x00\x17\x00\x04\x00\x19\x00\x2e\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x21\x00\x3a\x00\x3b\x00\x4c\x00\x25\x00\x4e\x00\x17\x00\x04\x00\x19\x00\x2e\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x42\x00\x43\x00\x3b\x00\x21\x00\x2c\x00\x2d\x00\x17\x00\x25\x00\x19\x00\x2e\x00\x4c\x00\x30\x00\x12\x00\x1a\x00\x1f\x00\x28\x00\x36\x00\x37\x00\x38\x00\x24\x00\x21\x00\x3a\x00\x1c\x00\x1d\x00\x1e\x00\x30\x00\x04\x00\x21\x00\x12\x00\x2e\x00\x08\x00\x09\x00\x0a\x00\x12\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x4c\x00\x4d\x00\x21\x00\x3a\x00\x20\x00\x21\x00\x25\x00\x17\x00\x04\x00\x19\x00\x22\x00\x12\x00\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x2a\x00\x22\x00\x12\x00\x30\x00\x31\x00\x4a\x00\x17\x00\x4c\x00\x19\x00\x2e\x00\x21\x00\x30\x00\x1c\x00\x1d\x00\x1f\x00\x30\x00\x31\x00\x4c\x00\x4d\x00\x24\x00\x4f\x00\x3a\x00\x51\x00\x01\x00\x21\x00\x03\x00\x04\x00\x05\x00\x25\x00\x2e\x00\x08\x00\x09\x00\x0a\x00\x1b\x00\x22\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x1e\x00\x3a\x00\x08\x00\x09\x00\x0a\x00\x17\x00\x12\x00\x19\x00\x30\x00\x31\x00\x20\x00\x21\x00\x28\x00\x1f\x00\x14\x00\x2b\x00\x20\x00\x17\x00\x24\x00\x19\x00\x1a\x00\x18\x00\x19\x00\x4c\x00\x4d\x00\x1f\x00\x4f\x00\x05\x00\x2e\x00\x07\x00\x24\x00\x12\x00\x26\x00\x33\x00\x4c\x00\x29\x00\x4e\x00\x37\x00\x4c\x00\x2d\x00\x4e\x00\x2a\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x35\x00\x36\x00\x08\x00\x09\x00\x0a\x00\x04\x00\x38\x00\x2f\x00\x20\x00\x08\x00\x09\x00\x0a\x00\x02\x00\x13\x00\x14\x00\x08\x00\x4c\x00\x17\x00\x4e\x00\x19\x00\x25\x00\x26\x00\x27\x00\x28\x00\x17\x00\x1f\x00\x4c\x00\x4d\x00\x1a\x00\x2a\x00\x24\x00\x28\x00\x26\x00\x21\x00\x12\x00\x29\x00\x20\x00\x21\x00\x25\x00\x2d\x00\x20\x00\x21\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x35\x00\x36\x00\x08\x00\x09\x00\x0a\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x4c\x00\x4d\x00\x14\x00\x4f\x00\x50\x00\x17\x00\x28\x00\x19\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x1f\x00\x37\x00\x08\x00\x09\x00\x0a\x00\x24\x00\x28\x00\x26\x00\x45\x00\x46\x00\x29\x00\x48\x00\x20\x00\x21\x00\x2d\x00\x4c\x00\x4d\x00\x17\x00\x4f\x00\x19\x00\x46\x00\x47\x00\x35\x00\x36\x00\x01\x00\x1f\x00\x4c\x00\x4d\x00\x28\x00\x4f\x00\x24\x00\x28\x00\x26\x00\x04\x00\x05\x00\x29\x00\x04\x00\x08\x00\x09\x00\x0a\x00\x08\x00\x09\x00\x0a\x00\x20\x00\x21\x00\x04\x00\x2a\x00\x35\x00\x36\x00\x08\x00\x09\x00\x0a\x00\x17\x00\x2f\x00\x12\x00\x17\x00\x20\x00\x19\x00\x1a\x00\x2a\x00\x1f\x00\x23\x00\x20\x00\x1f\x00\x17\x00\x1a\x00\x19\x00\x21\x00\x24\x00\x22\x00\x04\x00\x05\x00\x1f\x00\x20\x00\x08\x00\x09\x00\x0a\x00\x24\x00\x2e\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x2e\x00\x2b\x00\x17\x00\x34\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x1e\x00\x28\x00\x28\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x26\x00\x27\x00\x28\x00\x20\x00\x2a\x00\x2b\x00\x22\x00\x1e\x00\x3e\x00\x2f\x00\x21\x00\x22\x00\x23\x00\x24\x00\x44\x00\x45\x00\x46\x00\x2f\x00\x48\x00\x2a\x00\x2b\x00\x30\x00\x4c\x00\x4d\x00\x2f\x00\x4f\x00\x3b\x00\x32\x00\x02\x00\x18\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x22\x00\x4c\x00\x4d\x00\x3b\x00\x4f\x00\x2a\x00\x2b\x00\x01\x00\x1e\x00\x01\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x01\x00\x4c\x00\x4d\x00\x22\x00\x4f\x00\x2a\x00\x2b\x00\x1e\x00\x46\x00\x3b\x00\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\x23\x00\x4f\x00\x12\x00\x2a\x00\x2b\x00\x4a\x00\x4b\x00\x4c\x00\x4c\x00\x4d\x00\x24\x00\x4f\x00\x4a\x00\x4b\x00\x4c\x00\x1e\x00\x2a\x00\x2b\x00\x21\x00\x22\x00\x23\x00\x24\x00\x3b\x00\x4c\x00\x4d\x00\x2b\x00\x4f\x00\x2a\x00\x2b\x00\x1e\x00\x3b\x00\x11\x00\x21\x00\x22\x00\x23\x00\x24\x00\x13\x00\x4c\x00\x4d\x00\x2f\x00\x4f\x00\x2a\x00\x2b\x00\x1e\x00\x2f\x00\xff\xff\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\x1e\x00\x2a\x00\x2b\x00\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\x2a\x00\x2b\x00\x1e\x00\xff\xff\xff\xff\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\x2a\x00\x2b\x00\x1e\x00\xff\xff\xff\xff\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\x1e\x00\x2a\x00\x2b\x00\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\x2a\x00\x2b\x00\x1e\x00\xff\xff\xff\xff\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\x2a\x00\x2b\x00\x1e\x00\xff\xff\xff\xff\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\x1e\x00\x2a\x00\x2b\x00\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\x2a\x00\x2b\x00\x1e\x00\xff\xff\xff\xff\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\x2a\x00\x2b\x00\x1e\x00\xff\xff\xff\xff\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\x1e\x00\x2a\x00\x2b\x00\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\x2a\x00\x2b\x00\x1e\x00\xff\xff\xff\xff\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\x2a\x00\x2b\x00\x1e\x00\xff\xff\xff\xff\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\x1e\x00\x2a\x00\x2b\x00\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\x2a\x00\x2b\x00\x1e\x00\xff\xff\xff\xff\x21\x00\x22\x00\x23\x00\x24\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\x2a\x00\x2b\x00\xff\xff\xff\xff\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x2a\x00\x2b\x00\x21\x00\x22\x00\x23\x00\x24\x00\xff\xff\x4c\x00\x4d\x00\x04\x00\x4f\x00\x2a\x00\x2b\x00\x08\x00\x09\x00\x0a\x00\x36\x00\x37\x00\x38\x00\x24\x00\xff\xff\x4c\x00\x4d\x00\x24\x00\x4f\x00\x2a\x00\x2b\x00\xff\xff\x17\x00\x2a\x00\x2b\x00\x26\x00\x27\x00\x28\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\x4c\x00\x4d\x00\xff\xff\xff\xff\x25\x00\xff\xff\xff\xff\x4c\x00\x4d\x00\x01\x00\x4f\x00\x03\x00\x04\x00\x05\x00\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\xff\xff\x4c\x00\x4d\x00\x1a\x00\x4f\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x24\x00\x25\x00\xff\xff\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\x20\x00\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x04\x00\x26\x00\x27\x00\x28\x00\x08\x00\x09\x00\x0a\x00\xff\xff\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\x17\x00\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x04\x00\xff\xff\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\x2e\x00\xff\xff\x17\x00\x28\x00\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\x17\x00\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x04\x00\xff\xff\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\x2e\x00\xff\xff\x17\x00\x28\x00\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\x17\x00\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x04\x00\xff\xff\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\x2e\x00\xff\xff\x17\x00\x28\x00\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\x17\x00\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x1a\x00\xff\xff\x1f\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x2e\x00\x38\x00\x17\x00\x28\x00\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x24\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x04\x00\x26\x00\x27\x00\x28\x00\x08\x00\x09\x00\x0a\x00\xff\xff\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\x17\x00\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x04\x00\xff\xff\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\x17\x00\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x04\x00\x05\x00\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\x17\x00\x08\x00\x09\x00\x0a\x00\x24\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x26\x00\x27\x00\x28\x00\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x24\x00\x4c\x00\x4d\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x4c\x00\x4d\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\x2e\x00\xff\xff\x17\x00\x04\x00\x19\x00\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x4c\x00\x4d\x00\x36\x00\x37\x00\x38\x00\x39\x00\x17\x00\x04\x00\x19\x00\x2e\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x26\x00\x27\x00\x28\x00\x29\x00\x4c\x00\x4d\x00\x17\x00\xff\xff\x19\x00\x2e\x00\xff\xff\x30\x00\xff\xff\xff\xff\x1f\x00\xff\xff\x04\x00\xff\xff\xff\xff\x24\x00\x08\x00\x09\x00\x0a\x00\xff\xff\x0c\x00\x0d\x00\x0e\x00\x0f\x00\xff\xff\x2e\x00\xff\xff\x30\x00\x26\x00\x27\x00\x28\x00\x17\x00\x04\x00\x19\x00\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x25\x00\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x25\x00\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x26\x00\x27\x00\x28\x00\x29\x00\xff\xff\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\xff\xff\xff\xff\x04\x00\xff\xff\x24\x00\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x46\x00\x17\x00\xff\xff\xff\xff\x24\x00\xff\xff\x4c\x00\x4d\x00\x28\x00\x4f\x00\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\x25\x00\x08\x00\x09\x00\x0a\x00\x1f\x00\x25\x00\x26\x00\x27\x00\x28\x00\x24\x00\x26\x00\x27\x00\x28\x00\x28\x00\xff\xff\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x20\x00\x44\x00\x45\x00\x46\x00\x24\x00\x48\x00\x49\x00\xff\xff\xff\xff\x4c\x00\x4d\x00\x17\x00\x4f\x00\x19\x00\x2e\x00\x52\x00\x53\x00\x12\x00\xff\xff\x1f\x00\x15\x00\x16\x00\xff\xff\xff\xff\x24\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\xff\xff\x20\x00\x21\x00\x22\x00\x2e\x00\xff\xff\x25\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x2b\x00\x2c\x00\x08\x00\x09\x00\x0a\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\x3b\x00\x17\x00\xff\xff\x19\x00\x26\x00\x27\x00\x28\x00\x04\x00\xff\xff\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x26\x00\xff\xff\xff\xff\x29\x00\x36\x00\x37\x00\x38\x00\x39\x00\x01\x00\xff\xff\x17\x00\x04\x00\x05\x00\xff\xff\x04\x00\x08\x00\x09\x00\x0a\x00\x08\x00\x09\x00\x0a\x00\x26\x00\x27\x00\x28\x00\x25\x00\xff\xff\x4c\x00\x4d\x00\xff\xff\xff\xff\x17\x00\xff\xff\xff\xff\x17\x00\xff\xff\x22\x00\xff\xff\xff\xff\x1f\x00\x25\x00\x26\x00\x27\x00\x28\x00\x24\x00\x2b\x00\x2c\x00\x20\x00\x25\x00\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x20\x00\x21\x00\x3b\x00\xff\xff\x40\x00\x41\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x21\x00\x4a\x00\x4b\x00\x4c\x00\x25\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x3c\x00\x3d\x00\x3e\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\x3c\x00\x3d\x00\x3e\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\x3c\x00\x3d\x00\x3e\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\x3c\x00\x3d\x00\x3e\x00\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x04\x00\x05\x00\xff\xff\x04\x00\x08\x00\x09\x00\x0a\x00\x08\x00\x09\x00\x0a\x00\xff\xff\x3f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x44\x00\x45\x00\x46\x00\x17\x00\x48\x00\x28\x00\x17\x00\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\xff\xff\xff\xff\x2a\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\x49\x00\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x44\x00\x45\x00\x46\x00\xff\xff\x48\x00\xff\xff\xff\xff\xff\xff\x4c\x00\x4d\x00\xff\xff\x4f\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

happyTable :: HappyAddr
happyTable = HappyA# "\x00\x00\xc2\x01\x92\x01\x6f\x00\x70\x00\x81\x00\x50\x00\x19\x01\xf4\x00\x5c\x01\x51\x00\x52\x00\x71\x00\x72\x00\x5a\x01\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x6e\x00\x6f\x00\x70\x00\x51\x00\x52\x00\x0e\x00\x9c\x01\x83\x00\x85\x01\xcb\x01\x71\x00\x72\x00\x9d\x01\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\xf5\x00\x49\x01\x86\x01\x51\x00\x52\x00\x54\x00\x55\x00\x75\x01\xff\xff\x4a\x01\x72\x00\xc2\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x6e\x00\x54\x00\x55\x00\x51\x00\x52\x00\x12\x00\x1a\x01\xad\x01\x99\x00\x12\x00\x56\x00\xac\x00\x9c\x00\xac\x00\x39\x01\x0c\x01\xc3\x01\x2c\x01\xb0\x00\x54\x00\x55\x00\x9d\x00\x12\x00\x56\x00\x2d\x01\xf3\x00\x0d\x01\x12\x00\x13\x00\x3b\x01\x3f\x00\x3d\x00\x3e\x00\xad\x00\x4b\x01\xad\x00\x54\x00\x55\x00\xc5\x01\x9a\x00\x12\x00\x56\x00\x4c\x01\x72\x00\xfa\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x31\x01\xae\x00\xfb\x00\x51\x00\x52\x00\x81\x00\x82\x00\x12\x00\x56\x00\x12\x00\x8a\x00\xb3\x01\x63\x00\x97\x00\x64\x00\x12\x00\x13\x00\x65\x00\x3f\x00\x66\x00\x67\x00\x68\x00\x69\x00\x83\x00\x12\x00\x4f\x01\x51\x00\x52\x00\xb1\x01\x72\x00\x63\x01\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x54\x00\x55\x00\xad\x01\x51\x00\x52\x00\x53\x01\x72\x00\x37\x01\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\xa1\x00\xf7\x00\x99\x00\x51\x00\x52\x00\x38\x01\x3d\x00\x3e\x00\x12\x00\x56\x00\x54\x00\x55\x00\xba\x01\x8b\x01\xe5\xff\x7e\x00\x72\x00\x8c\x01\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x54\x00\x55\x00\x51\x01\x51\x00\x52\x00\xe5\xff\xe5\xff\x88\x01\x12\x00\x56\x00\x9a\x00\xae\x00\xaf\x00\x54\x00\x55\x00\x94\x00\x11\x00\x12\x00\x13\x00\x64\x01\x3f\x00\x12\x00\x56\x00\x7d\x00\x73\x01\x66\x00\x67\x00\x68\x00\x69\x00\x28\x01\x12\x00\x8a\x00\x51\x00\x52\x00\x12\x00\x56\x00\x54\x00\x55\x00\x56\x01\xb0\x00\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x12\x00\x3c\x01\xf9\x00\x51\x00\x52\x00\x57\x01\x40\x01\x73\x00\x74\x00\x75\x00\x76\x00\x77\x00\x12\x00\x56\x00\x4d\x00\x51\x00\x52\x00\x97\x00\x9e\x00\x4e\x00\x54\x00\x55\x00\x51\x00\x52\x00\x61\x00\xf7\x00\x9e\x00\x58\x01\x17\x00\x36\x00\x51\x00\x52\x00\x19\x00\x1a\x00\x1b\x00\x9f\x00\x54\x00\x55\x00\x6c\x00\x37\x00\x38\x00\x12\x00\x56\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x1c\x00\x54\x00\x55\x00\xef\x00\x81\x00\x3d\x00\x3e\x00\xc9\x01\x54\x00\x55\x00\x12\x00\x56\x00\x1f\x01\x88\x00\x97\x00\x1c\x01\x54\x00\x55\x00\x51\x00\x52\x00\x50\x00\x97\x01\x12\x00\x56\x00\x51\x00\x52\x00\x39\x01\x6a\x01\x53\x00\x12\x00\x56\x00\x51\x00\x52\x00\x12\x00\x8a\x00\x12\x00\x8a\x00\x12\x00\x56\x00\x12\x00\x13\x00\x3b\x01\x3f\x00\x6b\x01\x81\x00\x44\x01\x47\x01\x51\x00\x52\x00\x51\x00\x52\x00\x54\x00\x55\x00\xbf\x00\x88\x00\x97\x00\x39\x01\x54\x00\x55\x00\x51\x00\x52\x00\x48\x01\x5f\x00\x81\x00\x54\x00\x55\x00\x51\x00\x52\x00\xc1\x01\x96\x00\xb3\x01\x3b\x01\x12\x00\x56\x00\x12\x00\xc0\x00\x06\x01\x99\x00\x12\x00\x56\x00\x54\x00\x55\x00\x54\x00\x55\x00\x97\x00\x12\x00\x56\x00\x41\x00\x42\x00\x43\x00\x17\x00\x18\x00\x54\x00\x55\x00\x19\x00\x1a\x00\x1b\x00\x26\x01\xaf\x01\x54\x00\x55\x00\x12\x00\x56\x00\x12\x00\x56\x00\x42\x01\x45\x00\x28\x01\x9a\x00\x1c\x00\x43\x01\x46\x00\x21\x01\x12\x00\x56\x00\x44\x01\xaf\xff\x47\x00\xb6\x00\xaf\xff\x12\x00\x56\x00\x48\x00\x7c\x00\x49\x00\x98\x00\x99\x00\x4a\x00\x12\x00\x8a\x00\x6f\x01\x4b\x00\x12\x00\x8a\x00\x70\x01\xb8\x01\x1e\x00\x1f\x00\x20\x00\xb7\x00\xb8\x00\x23\x00\x24\x00\x25\x00\x17\x00\xb5\x01\x6b\x00\xeb\x00\x19\x00\x1a\x00\x1b\x00\x72\x01\x58\x00\x59\x00\x5a\x00\x5b\x00\xb9\x01\x9a\x00\xbd\x01\x7d\x01\x87\x00\x88\x00\xba\x01\x1c\x00\x17\x00\x5c\x00\x6b\x00\x81\x00\x19\x00\x1a\x00\x1b\x00\x5d\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5e\x00\x12\x00\x8a\x00\x12\x00\x90\x00\x12\x00\x8a\x00\x1c\x00\x17\x00\x5c\x00\x5f\x00\x16\x01\x19\x00\x1a\x00\x1b\x00\x5d\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5e\x00\x81\x00\x6c\x00\xdf\xff\xfc\x00\xa6\x01\x18\x01\x1c\x00\x17\x00\x5c\x00\x5f\x00\x79\x00\x19\x00\x1a\x00\x7a\x00\x5d\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5e\x00\xef\x00\x6c\x00\xde\xff\x25\x00\xf0\x00\xa9\x01\x1c\x00\x17\x00\x5c\x00\x5f\x00\x79\x00\x19\x00\x1a\x00\x7a\x00\x5d\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5e\x00\x26\x01\x27\x01\xff\xff\xf1\x00\xa9\x00\xaa\x00\x1c\x00\xf2\x00\x5c\x00\x5f\x00\x28\x01\xed\xff\x81\x00\x2e\x01\x5d\x00\x71\x01\x5d\x01\x87\x00\x88\x00\x5e\x00\x2f\x01\x6c\x00\xff\x00\x00\x01\x01\x01\xc0\x01\x17\x00\x02\x01\x81\x00\x5f\x00\x19\x00\x1a\x00\x7a\x00\x81\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x12\x00\x8a\x00\x09\x01\x6c\x00\x05\x01\x06\x01\x0a\x01\x1c\x00\x17\x00\x5c\x00\x39\x01\x81\x00\x19\x00\x1a\x00\x7a\x00\x5d\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5e\x00\x94\x01\x16\x01\x81\x00\xa9\x01\x3b\x01\x87\x01\x1c\x00\xe7\x00\x5c\x00\x5f\x00\x97\x01\x80\x00\x99\x01\x9a\x01\x5d\x00\x17\x01\x18\x01\x12\x00\x13\x00\x5e\x00\xa4\x00\x6c\x00\xa5\x00\x31\x00\x35\x01\x32\x00\x17\x00\x18\x00\x36\x01\x5f\x00\x19\x00\x1a\x00\x1b\x00\x96\x01\x39\x01\x41\x00\x42\x00\x43\x00\x17\x00\x18\x00\x98\x01\x6c\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x81\x00\x33\x00\x3a\x01\x3b\x01\xca\x01\xcb\x01\xb0\xff\x34\x00\x45\x00\xb0\xff\x9f\x01\x1c\x00\xcf\x00\x46\x00\xbc\x00\xa3\x00\x99\x00\x12\x00\x13\x00\x47\x00\x4e\x01\xaa\x01\x36\x00\xab\x01\x48\x00\x81\x00\x49\x00\x8b\x01\x25\x00\x4a\x00\x3f\x01\x8c\x01\x25\x00\x4b\x00\xdd\x00\xa3\x01\x41\x00\x42\x00\x43\x00\x17\x00\x18\x00\x4c\x00\x4d\x00\x19\x00\x1a\x00\x1b\x00\x17\x00\x9a\x00\x4e\x01\xa8\x01\x19\x00\x1a\x00\x1b\x00\x51\x01\x44\x00\x45\x00\x53\x01\x25\x00\x1c\x00\x26\x00\x46\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x1c\x00\x47\x00\x12\x00\x8a\x00\x90\x01\x56\x01\x48\x00\x5f\x01\x49\x00\x67\x01\x81\x00\x4a\x00\xea\x00\xeb\x00\xc8\x01\x4b\x00\x03\x01\xfe\x00\x41\x00\x42\x00\x43\x00\x17\x00\x18\x00\x4c\x00\x4d\x00\x19\x00\x1a\x00\x1b\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x12\x00\x13\x00\x45\x00\x14\x00\x15\x00\x1c\x00\x68\x01\x46\x00\x41\x00\x42\x00\x43\x00\x17\x00\x18\x00\x47\x00\x97\x00\x19\x00\x1a\x00\x1b\x00\x48\x00\x71\x01\x49\x00\xe1\x00\x2d\x00\x4a\x00\x2e\x00\x30\x01\x2d\x01\x4b\x00\x12\x00\x13\x00\x1c\x00\x2f\x00\x46\x00\xd0\x00\xd1\x00\x4c\x00\x4d\x00\x75\x01\x47\x00\x12\x00\x13\x00\x78\x01\xd2\x00\x48\x00\x85\x01\x49\x00\x17\x00\x18\x00\x4a\x00\x17\x00\x19\x00\x1a\x00\x1b\x00\x19\x00\x1a\x00\x1b\x00\x32\x01\x2f\x01\x17\x00\x8f\x01\x4c\x00\x4d\x00\x19\x00\x1a\x00\x1b\x00\x1c\x00\x92\x01\xdf\x00\x1c\x00\xe0\x00\x5c\x00\x90\x00\xee\x00\x1d\x00\xc2\x00\x04\x01\x8c\x00\x1c\x00\xfd\x00\x5c\x00\xfe\x00\x5e\x00\x1f\x01\x17\x00\x28\x00\x8c\x00\x8d\x00\x19\x00\x1a\x00\x1b\x00\x5e\x00\x5f\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x5f\x00\x15\x01\x1c\x00\x0b\x01\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xb2\x00\x1e\x01\x34\x01\x39\x00\x3a\x00\x3b\x00\x3c\x00\xb3\x00\x0f\x00\x10\x00\x11\x00\x33\x01\x3d\x00\x3e\x00\x3c\x01\xb8\x00\xda\x00\xb4\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\xdb\x00\x2c\x00\x2d\x00\x3f\x01\x2e\x00\x3d\x00\x3e\x00\x49\x01\x12\x00\x13\x00\xb9\x00\x2f\x00\xff\xff\xba\x00\x7b\x00\x7c\x00\xbc\x00\xbd\x00\xbe\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x7d\x00\x12\x00\x13\x00\xff\xff\x3f\x00\x3d\x00\x3e\x00\x92\x00\xbc\x00\x93\x00\x81\x01\x39\x00\x3a\x00\x3b\x00\x3c\x00\x94\x00\x12\x00\x13\x00\x9e\x00\x3f\x00\x3d\x00\x3e\x00\xc4\x01\xe5\x00\xff\xff\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\xc2\x00\xd2\x00\x81\x00\x3d\x00\x3e\x00\xc7\x00\xc6\x01\xe7\x00\x12\x00\x13\x00\xa2\x00\x3f\x00\xc7\x00\xc8\x00\xe7\x00\xb6\x01\x3d\x00\x3e\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\xff\xff\x12\x00\x13\x00\xd7\x00\x3f\x00\x3d\x00\x3e\x00\xbb\x01\xff\xff\x0e\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x44\x00\x12\x00\x13\x00\x50\x00\x3f\x00\x3d\x00\x3e\x00\xbe\x01\x63\x00\x00\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x94\x01\x3d\x00\x3e\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x00\x00\x3d\x00\x3e\x00\x9a\x01\x00\x00\x00\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x00\x00\x3d\x00\x3e\x00\x9f\x01\x00\x00\x00\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\xa3\x01\x3d\x00\x3e\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x00\x00\x3d\x00\x3e\x00\x68\x01\x00\x00\x00\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x00\x00\x3d\x00\x3e\x00\x76\x01\x00\x00\x00\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x78\x01\x3d\x00\x3e\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x00\x00\x3d\x00\x3e\x00\x79\x01\x00\x00\x00\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x00\x00\x3d\x00\x3e\x00\x7e\x01\x00\x00\x00\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x7f\x01\x3d\x00\x3e\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x00\x00\x3d\x00\x3e\x00\x80\x01\x00\x00\x00\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x00\x00\x3d\x00\x3e\x00\x83\x01\x00\x00\x00\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x20\x01\x3d\x00\x3e\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x00\x00\x3d\x00\x3e\x00\x60\x00\x00\x00\x00\x00\x39\x00\x3a\x00\x3b\x00\x3c\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x00\x00\x3d\x00\x3e\x00\x00\x00\x00\x00\x6c\x01\x3a\x00\x3b\x00\x3c\x00\x00\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x3d\x00\x3e\x00\x82\x01\x3a\x00\x3b\x00\x3c\x00\x00\x00\x12\x00\x13\x00\x17\x00\x3f\x00\x3d\x00\x3e\x00\x19\x00\x1a\x00\x1b\x00\x60\x01\x87\x00\x88\x00\xa1\x00\x00\x00\x12\x00\x13\x00\xa2\x00\x3f\x00\x3d\x00\x3e\x00\x00\x00\x1c\x00\x3d\x00\x3e\x00\xd7\x00\x10\x00\x11\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x12\x00\x8a\x00\x00\x00\x00\x00\xe9\x00\x00\x00\x00\x00\x12\x00\x13\x00\x31\x00\x3f\x00\x32\x00\x17\x00\x18\x00\x00\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x12\x00\x13\x00\x91\x01\x3f\x00\x12\x00\x13\x00\x00\x00\x3f\x00\x00\x00\x00\x00\x1c\x00\x00\x00\x33\x00\x31\x00\x00\x00\x32\x00\x17\x00\x18\x00\x34\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\xcf\x00\x13\x01\x00\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x36\x00\x00\x00\x1c\x00\x00\x00\x33\x00\x31\x00\x00\x00\x32\x00\x17\x00\x18\x00\x34\x00\xce\x00\x19\x00\x1a\x00\x1b\x00\xcf\x00\x00\x00\x17\x00\xa0\x01\x10\x00\x11\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x36\x00\x00\x00\x1c\x00\x00\x00\x33\x00\x31\x00\x00\x00\x32\x00\x17\x00\x18\x00\x34\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\x35\x00\x00\x00\x17\x00\x00\x00\x2a\x01\x00\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x36\x00\x00\x00\x1c\x00\xb6\x01\x33\x00\x31\x00\x00\x00\x32\x00\x17\x00\x18\x00\x34\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\xcf\x00\x00\x00\x17\x00\x00\x00\x2a\x01\x00\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x36\x00\x00\x00\x1c\x00\xb1\x01\x33\x00\x31\x00\x00\x00\x32\x00\x17\x00\x18\x00\x34\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\x35\x00\x00\x00\x17\x00\x00\x00\x2a\x01\x00\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x36\x00\x00\x00\x1c\x00\x66\x01\x33\x00\x31\x00\x00\x00\x32\x00\x17\x00\x18\x00\x34\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\xcf\x00\x00\x00\xe7\x00\x00\x00\x2a\x01\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x36\x00\x24\x00\x1c\x00\x2b\x01\xd4\x00\x31\x00\x00\x00\x32\x00\x17\x00\x18\x00\x34\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\xcf\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x36\x00\x00\x00\x1c\x00\x00\x00\x33\x00\x31\x00\x00\x00\x32\x00\x17\x00\x18\x00\x34\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\xcf\x00\x00\x00\x17\x00\xd7\x00\x10\x00\x11\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x36\x00\x00\x00\x1c\x00\x00\x00\x33\x00\x31\x00\x00\x00\x32\x00\x17\x00\x18\x00\x34\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\x35\x00\x00\x00\x17\x00\x00\x00\x1c\x01\x00\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x36\x00\x00\x00\x1c\x00\x00\x00\x33\x00\x31\x00\x00\x00\x32\x00\x17\x00\x18\x00\x34\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\xcf\x00\x00\x00\x17\x00\x18\x00\x3e\x01\x00\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x36\x00\x00\x00\x1c\x00\x00\x00\xd4\x00\x31\x00\x00\x00\x32\x00\x17\x00\x18\x00\x34\x00\x1c\x00\x19\x00\x1a\x00\x1b\x00\xcf\x00\x7a\x01\x7b\x01\x7c\x01\x7d\x01\x87\x00\x88\x00\x54\x01\x10\x00\x11\x00\x36\x00\x00\x00\x1c\x00\x00\x00\xd6\x00\x31\x00\x00\x00\x32\x00\x17\x00\x18\x00\x34\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\xcf\x00\x12\x00\x8a\x00\xbc\x01\x7c\x01\x7d\x01\x87\x00\x88\x00\x00\x00\x00\x00\x36\x00\x00\x00\x1c\x00\x00\x00\x33\x00\x31\x00\x00\x00\x32\x00\x17\x00\x18\x00\x34\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\xcf\x00\x00\x00\x12\x00\x8a\x00\x86\x00\x87\x00\x88\x00\x89\x00\x00\x00\x00\x00\x36\x00\x00\x00\x1c\x00\x17\x00\x33\x00\x00\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x34\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x35\x00\x12\x00\x8a\x00\x8d\x00\x87\x00\x88\x00\x8e\x00\x1c\x00\x17\x00\x5c\x00\x36\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x5d\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5e\x00\x22\x01\x10\x00\x11\x00\x23\x01\x12\x00\x8a\x00\x1c\x00\x00\x00\x5c\x00\x5f\x00\x00\x00\x5a\x01\x00\x00\x00\x00\x5d\x00\x00\x00\x17\x00\x00\x00\x00\x00\x5e\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x00\x00\x5f\x00\x00\x00\xa1\x00\x69\x01\x10\x00\x11\x00\x1c\x00\x17\x00\x5c\x00\x00\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x5d\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5e\x00\xa5\x01\x61\x01\x87\x00\x88\x00\x00\x00\x00\x00\x1c\x00\x17\x00\x5c\x00\x5f\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x5d\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5e\x00\x5c\x01\x00\x00\x00\x00\x12\x00\x8a\x00\x00\x00\x1c\x00\x17\x00\x5c\x00\x5f\x00\x00\x00\x19\x00\x1a\x00\x46\x01\x5d\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5e\x00\x22\x01\x10\x00\x11\x00\x24\x01\x00\x00\x00\x00\x1c\x00\x17\x00\x5c\x00\x5f\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x5d\x00\x58\x00\x59\x00\x5a\x00\x5b\x00\x5e\x00\x22\x01\x10\x00\x11\x00\x25\x01\x00\x00\x00\x00\x1c\x00\x17\x00\x5c\x00\x5f\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x5d\x00\x00\x00\x00\x00\x17\x00\x00\x00\x5e\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x00\x00\x1c\x00\x17\x00\x5c\x00\x5f\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x8c\x00\xd4\x00\x1c\x00\x00\x00\x00\x00\x5e\x00\x00\x00\x12\x00\x13\x00\xaf\x01\xd2\x00\x00\x00\x1c\x00\x17\x00\x5c\x00\x5f\x00\x85\x00\x19\x00\x1a\x00\x1b\x00\x8c\x00\xc3\x00\x0f\x00\x10\x00\x11\x00\x5e\x00\xd7\x00\x10\x00\x11\x00\x08\x01\x00\x00\x00\x00\x1c\x00\x17\x00\x5c\x00\x5f\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x8c\x00\x8d\x00\x0d\x01\x2c\x00\x2d\x00\x5e\x00\x2e\x00\x0e\x01\x00\x00\x00\x00\x0f\x01\x13\x00\x1c\x00\x2f\x00\x5c\x00\x5f\x00\x10\x01\x11\x01\x2a\xff\x00\x00\x8c\x00\x2a\xff\x2a\xff\x00\x00\x00\x00\x5e\x00\x2a\xff\x2a\xff\x2a\xff\x2a\xff\x2a\xff\x00\x00\x2a\xff\x2a\xff\x2a\xff\x5f\x00\x00\x00\x2a\xff\x41\x00\x42\x00\x43\x00\x17\x00\x18\x00\x2a\xff\x2a\xff\x19\x00\x1a\x00\x1b\x00\x2a\xff\x2a\xff\x2a\xff\x2a\xff\x2a\xff\x2a\xff\x2a\xff\x2a\xff\x2a\xff\x00\x00\x00\x00\x2a\xff\x1c\x00\x00\x00\x46\x00\x85\x00\x10\x00\x11\x00\x17\x00\x00\x00\x47\x00\x00\x00\x19\x00\x1a\x00\x1b\x00\x48\x00\x00\x00\x49\x00\x00\x00\x00\x00\x4a\x00\x86\x00\x87\x00\x88\x00\x89\x00\xa7\x00\x00\x00\x1c\x00\x17\x00\x18\x00\x00\x00\x17\x00\x19\x00\x1a\x00\x1b\x00\x19\x00\x1a\x00\x1b\x00\xd7\x00\x10\x00\x11\x00\xb2\x00\x00\x00\x12\x00\x8a\x00\x00\x00\x00\x00\x1c\x00\x00\x00\x00\x00\x1c\x00\x00\x00\x26\xff\x00\x00\x00\x00\xa8\x00\xdc\x00\x0f\x00\x10\x00\x11\x00\xa9\x00\x26\xff\x26\xff\x6e\x01\xcb\x00\x00\x00\x26\xff\x26\xff\x26\xff\x26\xff\x26\xff\x26\xff\x26\xff\x26\xff\x26\xff\xec\x00\xed\x00\x26\xff\x00\x00\xc5\x00\xc6\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xed\x00\xc7\x00\xc8\x00\xc9\x00\x73\x01\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xc1\x01\x29\x00\x2a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x2b\x00\x2c\x00\x2d\x00\x00\x00\x2e\x00\xa6\x01\x29\x00\x2a\x00\x12\x00\x13\x00\x00\x00\x2f\x00\x00\x00\x2b\x00\x2c\x00\x2d\x00\x00\x00\x2e\x00\x18\x01\x29\x00\x2a\x00\x12\x00\x13\x00\x00\x00\x2f\x00\x00\x00\x2b\x00\x2c\x00\x2d\x00\x00\x00\x2e\x00\x28\x00\x29\x00\x2a\x00\x12\x00\x13\x00\x00\x00\x2f\x00\x00\x00\x2b\x00\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\x17\x00\x28\x00\x00\x00\x17\x00\x19\x00\x1a\x00\x1b\x00\x19\x00\x1a\x00\x1b\x00\x00\x00\x88\x01\x00\x00\x00\x00\x00\x00\x00\x00\x89\x01\x2c\x00\x2d\x00\x1c\x00\x2e\x00\x53\xff\x1c\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\x00\x00\x00\x00\xc5\x00\x53\xff\x53\xff\x53\xff\x53\xff\x53\xff\x53\xff\x53\xff\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\xd9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\xcb\x00\x2c\x00\x2d\x00\x00\x00\x2e\x00\xcc\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\x89\x01\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\x9b\x01\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\xa1\x01\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\x5f\x01\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\x62\x01\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\x8c\x01\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\x8d\x01\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\xe0\x00\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\xe2\x00\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\xe3\x00\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\xe4\x00\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\xf2\x00\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\x13\x01\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\xcf\x00\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\xd9\x00\x2c\x00\x2d\x00\x00\x00\x2e\x00\x00\x00\x00\x00\x00\x00\x12\x00\x13\x00\x00\x00\x2f\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyReduceArr = Happy_Data_Array.array (12, 251) [
	(12 , happyReduce_12),
	(13 , happyReduce_13),
	(14 , happyReduce_14),
	(15 , happyReduce_15),
	(16 , happyReduce_16),
	(17 , happyReduce_17),
	(18 , happyReduce_18),
	(19 , happyReduce_19),
	(20 , happyReduce_20),
	(21 , happyReduce_21),
	(22 , happyReduce_22),
	(23 , happyReduce_23),
	(24 , happyReduce_24),
	(25 , happyReduce_25),
	(26 , happyReduce_26),
	(27 , happyReduce_27),
	(28 , happyReduce_28),
	(29 , happyReduce_29),
	(30 , happyReduce_30),
	(31 , happyReduce_31),
	(32 , happyReduce_32),
	(33 , happyReduce_33),
	(34 , happyReduce_34),
	(35 , happyReduce_35),
	(36 , happyReduce_36),
	(37 , happyReduce_37),
	(38 , happyReduce_38),
	(39 , happyReduce_39),
	(40 , happyReduce_40),
	(41 , happyReduce_41),
	(42 , happyReduce_42),
	(43 , happyReduce_43),
	(44 , happyReduce_44),
	(45 , happyReduce_45),
	(46 , happyReduce_46),
	(47 , happyReduce_47),
	(48 , happyReduce_48),
	(49 , happyReduce_49),
	(50 , happyReduce_50),
	(51 , happyReduce_51),
	(52 , happyReduce_52),
	(53 , happyReduce_53),
	(54 , happyReduce_54),
	(55 , happyReduce_55),
	(56 , happyReduce_56),
	(57 , happyReduce_57),
	(58 , happyReduce_58),
	(59 , happyReduce_59),
	(60 , happyReduce_60),
	(61 , happyReduce_61),
	(62 , happyReduce_62),
	(63 , happyReduce_63),
	(64 , happyReduce_64),
	(65 , happyReduce_65),
	(66 , happyReduce_66),
	(67 , happyReduce_67),
	(68 , happyReduce_68),
	(69 , happyReduce_69),
	(70 , happyReduce_70),
	(71 , happyReduce_71),
	(72 , happyReduce_72),
	(73 , happyReduce_73),
	(74 , happyReduce_74),
	(75 , happyReduce_75),
	(76 , happyReduce_76),
	(77 , happyReduce_77),
	(78 , happyReduce_78),
	(79 , happyReduce_79),
	(80 , happyReduce_80),
	(81 , happyReduce_81),
	(82 , happyReduce_82),
	(83 , happyReduce_83),
	(84 , happyReduce_84),
	(85 , happyReduce_85),
	(86 , happyReduce_86),
	(87 , happyReduce_87),
	(88 , happyReduce_88),
	(89 , happyReduce_89),
	(90 , happyReduce_90),
	(91 , happyReduce_91),
	(92 , happyReduce_92),
	(93 , happyReduce_93),
	(94 , happyReduce_94),
	(95 , happyReduce_95),
	(96 , happyReduce_96),
	(97 , happyReduce_97),
	(98 , happyReduce_98),
	(99 , happyReduce_99),
	(100 , happyReduce_100),
	(101 , happyReduce_101),
	(102 , happyReduce_102),
	(103 , happyReduce_103),
	(104 , happyReduce_104),
	(105 , happyReduce_105),
	(106 , happyReduce_106),
	(107 , happyReduce_107),
	(108 , happyReduce_108),
	(109 , happyReduce_109),
	(110 , happyReduce_110),
	(111 , happyReduce_111),
	(112 , happyReduce_112),
	(113 , happyReduce_113),
	(114 , happyReduce_114),
	(115 , happyReduce_115),
	(116 , happyReduce_116),
	(117 , happyReduce_117),
	(118 , happyReduce_118),
	(119 , happyReduce_119),
	(120 , happyReduce_120),
	(121 , happyReduce_121),
	(122 , happyReduce_122),
	(123 , happyReduce_123),
	(124 , happyReduce_124),
	(125 , happyReduce_125),
	(126 , happyReduce_126),
	(127 , happyReduce_127),
	(128 , happyReduce_128),
	(129 , happyReduce_129),
	(130 , happyReduce_130),
	(131 , happyReduce_131),
	(132 , happyReduce_132),
	(133 , happyReduce_133),
	(134 , happyReduce_134),
	(135 , happyReduce_135),
	(136 , happyReduce_136),
	(137 , happyReduce_137),
	(138 , happyReduce_138),
	(139 , happyReduce_139),
	(140 , happyReduce_140),
	(141 , happyReduce_141),
	(142 , happyReduce_142),
	(143 , happyReduce_143),
	(144 , happyReduce_144),
	(145 , happyReduce_145),
	(146 , happyReduce_146),
	(147 , happyReduce_147),
	(148 , happyReduce_148),
	(149 , happyReduce_149),
	(150 , happyReduce_150),
	(151 , happyReduce_151),
	(152 , happyReduce_152),
	(153 , happyReduce_153),
	(154 , happyReduce_154),
	(155 , happyReduce_155),
	(156 , happyReduce_156),
	(157 , happyReduce_157),
	(158 , happyReduce_158),
	(159 , happyReduce_159),
	(160 , happyReduce_160),
	(161 , happyReduce_161),
	(162 , happyReduce_162),
	(163 , happyReduce_163),
	(164 , happyReduce_164),
	(165 , happyReduce_165),
	(166 , happyReduce_166),
	(167 , happyReduce_167),
	(168 , happyReduce_168),
	(169 , happyReduce_169),
	(170 , happyReduce_170),
	(171 , happyReduce_171),
	(172 , happyReduce_172),
	(173 , happyReduce_173),
	(174 , happyReduce_174),
	(175 , happyReduce_175),
	(176 , happyReduce_176),
	(177 , happyReduce_177),
	(178 , happyReduce_178),
	(179 , happyReduce_179),
	(180 , happyReduce_180),
	(181 , happyReduce_181),
	(182 , happyReduce_182),
	(183 , happyReduce_183),
	(184 , happyReduce_184),
	(185 , happyReduce_185),
	(186 , happyReduce_186),
	(187 , happyReduce_187),
	(188 , happyReduce_188),
	(189 , happyReduce_189),
	(190 , happyReduce_190),
	(191 , happyReduce_191),
	(192 , happyReduce_192),
	(193 , happyReduce_193),
	(194 , happyReduce_194),
	(195 , happyReduce_195),
	(196 , happyReduce_196),
	(197 , happyReduce_197),
	(198 , happyReduce_198),
	(199 , happyReduce_199),
	(200 , happyReduce_200),
	(201 , happyReduce_201),
	(202 , happyReduce_202),
	(203 , happyReduce_203),
	(204 , happyReduce_204),
	(205 , happyReduce_205),
	(206 , happyReduce_206),
	(207 , happyReduce_207),
	(208 , happyReduce_208),
	(209 , happyReduce_209),
	(210 , happyReduce_210),
	(211 , happyReduce_211),
	(212 , happyReduce_212),
	(213 , happyReduce_213),
	(214 , happyReduce_214),
	(215 , happyReduce_215),
	(216 , happyReduce_216),
	(217 , happyReduce_217),
	(218 , happyReduce_218),
	(219 , happyReduce_219),
	(220 , happyReduce_220),
	(221 , happyReduce_221),
	(222 , happyReduce_222),
	(223 , happyReduce_223),
	(224 , happyReduce_224),
	(225 , happyReduce_225),
	(226 , happyReduce_226),
	(227 , happyReduce_227),
	(228 , happyReduce_228),
	(229 , happyReduce_229),
	(230 , happyReduce_230),
	(231 , happyReduce_231),
	(232 , happyReduce_232),
	(233 , happyReduce_233),
	(234 , happyReduce_234),
	(235 , happyReduce_235),
	(236 , happyReduce_236),
	(237 , happyReduce_237),
	(238 , happyReduce_238),
	(239 , happyReduce_239),
	(240 , happyReduce_240),
	(241 , happyReduce_241),
	(242 , happyReduce_242),
	(243 , happyReduce_243),
	(244 , happyReduce_244),
	(245 , happyReduce_245),
	(246 , happyReduce_246),
	(247 , happyReduce_247),
	(248 , happyReduce_248),
	(249 , happyReduce_249),
	(250 , happyReduce_250),
	(251 , happyReduce_251)
	]

happy_n_terms = 60 :: Int
happy_n_nonterms = 84 :: Int

happyReduce_12 = happyReduce 6# 0# happyReduction_12
happyReduction_12 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut93 happy_x_2 of { happy_var_2 -> 
	case happyOut16 happy_x_5 of { happy_var_5 -> 
	happyIn15
		 (let (is,ts) = happy_var_5 in Module happy_var_2 is ts
	) `HappyStk` happyRest}}

happyReduce_13 = happySpecReduce_3  0# happyReduction_13
happyReduction_13 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut16 happy_x_2 of { happy_var_2 -> 
	happyIn15
		 (let { (is,ts) = happy_var_2
            -- XXX make a location from is and ts
          ; modName = Located { srcRange = emptyRange
                              , thing    = mkModName ["Main"]
                              }
          } in Module modName is ts
	)}

happyReduce_14 = happySpecReduce_3  1# happyReduction_14
happyReduction_14 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	case happyOut26 happy_x_3 of { happy_var_3 -> 
	happyIn16
		 ((reverse happy_var_1, reverse happy_var_3)
	)}}

happyReduce_15 = happySpecReduce_3  1# happyReduction_15
happyReduction_15 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	case happyOut26 happy_x_3 of { happy_var_3 -> 
	happyIn16
		 ((reverse happy_var_1, reverse happy_var_3)
	)}}

happyReduce_16 = happySpecReduce_1  1# happyReduction_16
happyReduction_16 happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	happyIn16
		 ((reverse happy_var_1, [])
	)}

happyReduce_17 = happySpecReduce_1  1# happyReduction_17
happyReduction_17 happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	happyIn16
		 (([], reverse happy_var_1)
	)}

happyReduce_18 = happySpecReduce_0  1# happyReduction_18
happyReduction_18  =  happyIn16
		 (([], [])
	)

happyReduce_19 = happySpecReduce_3  2# happyReduction_19
happyReduction_19 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	case happyOut18 happy_x_3 of { happy_var_3 -> 
	happyIn17
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_20 = happySpecReduce_3  2# happyReduction_20
happyReduction_20 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	case happyOut18 happy_x_3 of { happy_var_3 -> 
	happyIn17
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_21 = happySpecReduce_1  2# happyReduction_21
happyReduction_21 happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	happyIn17
		 ([happy_var_1]
	)}

happyReduce_22 = happyReduce 4# 3# happyReduction_22
happyReduction_22 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_import)    _)) -> 
	case happyOut93 happy_x_2 of { happy_var_2 -> 
	case happyOut19 happy_x_3 of { happy_var_3 -> 
	case happyOut20 happy_x_4 of { happy_var_4 -> 
	happyIn18
		 (Located { srcRange = rComb happy_var_1
                                                   $ fromMaybe (srcRange happy_var_2)
                                                   $ msum [ fmap srcRange happy_var_4
                                                          , fmap srcRange happy_var_3
                                                          ]
                                        , thing    = Import
                                          { iModule    = thing happy_var_2
                                          , iAs        = fmap thing happy_var_3
                                          , iSpec      = fmap thing happy_var_4
                                          }
                                        }
	) `HappyStk` happyRest}}}}

happyReduce_23 = happySpecReduce_2  4# happyReduction_23
happyReduction_23 happy_x_2
	happy_x_1
	 =  case happyOut93 happy_x_2 of { happy_var_2 -> 
	happyIn19
		 (Just happy_var_2
	)}

happyReduce_24 = happySpecReduce_0  4# happyReduction_24
happyReduction_24  =  happyIn19
		 (Nothing
	)

happyReduce_25 = happyReduce 4# 5# happyReduction_25
happyReduction_25 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut22 happy_x_1 of { happy_var_1 -> 
	case happyOut21 happy_x_3 of { happy_var_3 -> 
	happyIn20
		 (Just Located
                                  { srcRange = case happy_var_3 of
                                      { [] -> emptyRange
                                      ; xs -> rCombs (map srcRange xs) }
                                  , thing    = happy_var_1 (reverse (map thing happy_var_3))
                                  }
	) `HappyStk` happyRest}}

happyReduce_26 = happySpecReduce_0  5# happyReduction_26
happyReduction_26  =  happyIn20
		 (Nothing
	)

happyReduce_27 = happySpecReduce_3  6# happyReduction_27
happyReduction_27 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut21 happy_x_1 of { happy_var_1 -> 
	case happyOut91 happy_x_3 of { happy_var_3 -> 
	happyIn21
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_28 = happySpecReduce_1  6# happyReduction_28
happyReduction_28 happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	happyIn21
		 ([happy_var_1]
	)}

happyReduce_29 = happySpecReduce_0  6# happyReduction_29
happyReduction_29  =  happyIn21
		 ([]
	)

happyReduce_30 = happySpecReduce_1  7# happyReduction_30
happyReduction_30 happy_x_1
	 =  happyIn22
		 (Hiding
	)

happyReduce_31 = happySpecReduce_0  7# happyReduction_31
happyReduction_31  =  happyIn22
		 (Only
	)

happyReduce_32 = happySpecReduce_1  8# happyReduction_32
happyReduction_32 happy_x_1
	 =  case happyOut25 happy_x_1 of { happy_var_1 -> 
	happyIn23
		 (Program (reverse happy_var_1)
	)}

happyReduce_33 = happySpecReduce_0  8# happyReduction_33
happyReduction_33  =  happyIn23
		 (Program []
	)

happyReduce_34 = happySpecReduce_3  9# happyReduction_34
happyReduction_34 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_2 of { happy_var_2 -> 
	happyIn24
		 (Program (reverse happy_var_2)
	)}

happyReduce_35 = happySpecReduce_2  9# happyReduction_35
happyReduction_35 happy_x_2
	happy_x_1
	 =  happyIn24
		 (Program []
	)

happyReduce_36 = happySpecReduce_2  10# happyReduction_36
happyReduction_36 happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn25
		 (happy_var_1
	)}

happyReduce_37 = happySpecReduce_3  10# happyReduction_37
happyReduction_37 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut25 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	happyIn25
		 (happy_var_2 ++ happy_var_1
	)}}

happyReduce_38 = happySpecReduce_1  11# happyReduction_38
happyReduction_38 happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	happyIn26
		 (happy_var_1
	)}

happyReduce_39 = happySpecReduce_3  11# happyReduction_39
happyReduction_39 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn26
		 (happy_var_3 ++ happy_var_1
	)}}

happyReduce_40 = happySpecReduce_3  11# happyReduction_40
happyReduction_40 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn26
		 (happy_var_3 ++ happy_var_1
	)}}

happyReduce_41 = happySpecReduce_1  12# happyReduction_41
happyReduction_41 happy_x_1
	 =  case happyOut33 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 ([exportDecl Nothing   Public happy_var_1]
	)}

happyReduce_42 = happySpecReduce_2  12# happyReduction_42
happyReduction_42 happy_x_2
	happy_x_1
	 =  case happyOut31 happy_x_1 of { happy_var_1 -> 
	case happyOut33 happy_x_2 of { happy_var_2 -> 
	happyIn27
		 ([exportDecl (Just happy_var_1) Public happy_var_2]
	)}}

happyReduce_43 = happyMonadReduce 3# 12# happyReduction_43
happyReduction_43 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_3 of { (happy_var_3@(Located _ (Token (StrLit {}) _))) -> 
	( (return . Include) `fmap` fromStrLit happy_var_3)}
	) (\r -> happyReturn (happyIn27 r))

happyReduce_44 = happyReduce 6# 12# happyReduction_44
happyReduction_44 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOut92 happy_x_3 of { happy_var_3 -> 
	case happyOut39 happy_x_4 of { happy_var_4 -> 
	case happyOut45 happy_x_6 of { happy_var_6 -> 
	happyIn27
		 ([exportDecl happy_var_1 Public (mkProperty happy_var_3 happy_var_4 happy_var_6)]
	) `HappyStk` happyRest}}}}

happyReduce_45 = happyReduce 5# 12# happyReduction_45
happyReduction_45 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOut92 happy_x_3 of { happy_var_3 -> 
	case happyOut45 happy_x_5 of { happy_var_5 -> 
	happyIn27
		 ([exportDecl happy_var_1 Public (mkProperty happy_var_3 [] happy_var_5)]
	) `HappyStk` happyRest}}}

happyReduce_46 = happySpecReduce_2  12# happyReduction_46
happyReduction_46 happy_x_2
	happy_x_1
	 =  case happyOut35 happy_x_2 of { happy_var_2 -> 
	happyIn27
		 ([exportNewtype Public happy_var_2]
	)}

happyReduce_47 = happySpecReduce_1  12# happyReduction_47
happyReduction_47 happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 (happy_var_1
	)}

happyReduce_48 = happySpecReduce_1  12# happyReduction_48
happyReduction_48 happy_x_1
	 =  case happyOut29 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 (happy_var_1
	)}

happyReduce_49 = happySpecReduce_1  13# happyReduction_49
happyReduction_49 happy_x_1
	 =  case happyOut33 happy_x_1 of { happy_var_1 -> 
	happyIn28
		 ([Decl (TopLevel {tlExport = Public, tlValue = happy_var_1 })]
	)}

happyReduce_50 = happyMonadReduce 2# 13# happyReduction_50
happyReduction_50 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_2 of { (happy_var_2@(Located _ (Token (StrLit {}) _))) -> 
	( (return . Include) `fmap` fromStrLit happy_var_2)}
	) (\r -> happyReturn (happyIn28 r))

happyReduce_51 = happySpecReduce_1  13# happyReduction_51
happyReduction_51 happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	happyIn28
		 (happy_var_1
	)}

happyReduce_52 = happyReduce 4# 14# happyReduction_52
happyReduction_52 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut26 happy_x_3 of { happy_var_3 -> 
	happyIn29
		 (changeExport Private (reverse happy_var_3)
	) `HappyStk` happyRest}

happyReduce_53 = happyReduce 5# 14# happyReduction_53
happyReduction_53 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut26 happy_x_4 of { happy_var_4 -> 
	happyIn29
		 (changeExport Private (reverse happy_var_4)
	) `HappyStk` happyRest}

happyReduce_54 = happyReduce 5# 15# happyReduction_54
happyReduction_54 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOut92 happy_x_3 of { happy_var_3 -> 
	case happyOut75 happy_x_5 of { happy_var_5 -> 
	happyIn30
		 (mkPrimDecl happy_var_1 happy_var_3 happy_var_5
	) `HappyStk` happyRest}}}

happyReduce_55 = happyReduce 7# 15# happyReduction_55
happyReduction_55 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOut53 happy_x_4 of { happy_var_4 -> 
	case happyOut75 happy_x_7 of { happy_var_7 -> 
	happyIn30
		 (mkPrimDecl happy_var_1 happy_var_4 happy_var_7
	) `HappyStk` happyRest}}}

happyReduce_56 = happySpecReduce_1  16# happyReduction_56
happyReduction_56 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (White DocStr) _))) -> 
	happyIn31
		 (mkDoc (fmap tokenText happy_var_1)
	)}

happyReduce_57 = happySpecReduce_1  17# happyReduction_57
happyReduction_57 happy_x_1
	 =  case happyOut31 happy_x_1 of { happy_var_1 -> 
	happyIn32
		 (Just happy_var_1
	)}

happyReduce_58 = happySpecReduce_0  17# happyReduction_58
happyReduction_58  =  happyIn32
		 (Nothing
	)

happyReduce_59 = happySpecReduce_3  18# happyReduction_59
happyReduction_59 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut37 happy_x_1 of { happy_var_1 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	happyIn33
		 (at (head happy_var_1,happy_var_3) $ DSignature (reverse happy_var_1) happy_var_3
	)}}

happyReduce_60 = happySpecReduce_3  18# happyReduction_60
happyReduction_60 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut45 happy_x_3 of { happy_var_3 -> 
	happyIn33
		 (at (happy_var_1,happy_var_3) $ DPatBind happy_var_1 happy_var_3
	)}}

happyReduce_61 = happyReduce 5# 18# happyReduction_61
happyReduction_61 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut53 happy_x_2 of { happy_var_2 -> 
	case happyOut45 happy_x_5 of { happy_var_5 -> 
	happyIn33
		 (at (happy_var_1,happy_var_5) $ DPatBind (PVar happy_var_2) happy_var_5
	) `HappyStk` happyRest}}}

happyReduce_62 = happyReduce 4# 18# happyReduction_62
happyReduction_62 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut38 happy_x_1 of { happy_var_1 -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	case happyOut45 happy_x_4 of { happy_var_4 -> 
	happyIn33
		 (at (happy_var_1,happy_var_4) $
                             DBind $ Bind { bName      = happy_var_1
                                          , bParams    = reverse happy_var_2
                                          , bDef       = at happy_var_4 (Located emptyRange (DExpr happy_var_4))
                                          , bSignature = Nothing
                                          , bPragmas   = []
                                          , bMono      = False
                                          , bInfix     = False
                                          , bFixity    = Nothing
                                          , bDoc       = Nothing
                                          }
	) `HappyStk` happyRest}}}

happyReduce_63 = happyReduce 5# 18# happyReduction_63
happyReduction_63 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut71 happy_x_1 of { happy_var_1 -> 
	case happyOut54 happy_x_2 of { happy_var_2 -> 
	case happyOut71 happy_x_3 of { happy_var_3 -> 
	case happyOut45 happy_x_5 of { happy_var_5 -> 
	happyIn33
		 (at (happy_var_1,happy_var_5) $
                             DBind $ Bind { bName      = happy_var_2
                                          , bParams    = [happy_var_1,happy_var_3]
                                          , bDef       = at happy_var_5 (Located emptyRange (DExpr happy_var_5))
                                          , bSignature = Nothing
                                          , bPragmas   = []
                                          , bMono      = False
                                          , bInfix     = True
                                          , bFixity    = Nothing
                                          , bDoc       = Nothing
                                          }
	) `HappyStk` happyRest}}}}

happyReduce_64 = happyMonadReduce 4# 18# happyReduction_64
happyReduction_64 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_type   ) _)) -> 
	case happyOut92 happy_x_2 of { happy_var_2 -> 
	case happyOut83 happy_x_4 of { happy_var_4 -> 
	( at (happy_var_1,happy_var_4) `fmap` mkTySyn happy_var_2 [] happy_var_4)}}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_65 = happyMonadReduce 5# 18# happyReduction_65
happyReduction_65 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_type   ) _)) -> 
	case happyOut92 happy_x_2 of { happy_var_2 -> 
	case happyOut82 happy_x_3 of { happy_var_3 -> 
	case happyOut83 happy_x_5 of { happy_var_5 -> 
	( at (happy_var_1,happy_var_5) `fmap` mkTySyn happy_var_2 (reverse happy_var_3) happy_var_5)}}}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_66 = happyMonadReduce 3# 18# happyReduction_66
happyReduction_66 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_2 of { (happy_var_2@(Located _ (Token (Num   {}) _))) -> 
	case happyOut56 happy_x_3 of { happy_var_3 -> 
	( mkFixity LeftAssoc  happy_var_2 (reverse happy_var_3))}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_67 = happyMonadReduce 3# 18# happyReduction_67
happyReduction_67 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_2 of { (happy_var_2@(Located _ (Token (Num   {}) _))) -> 
	case happyOut56 happy_x_3 of { happy_var_3 -> 
	( mkFixity RightAssoc happy_var_2 (reverse happy_var_3))}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_68 = happyMonadReduce 3# 18# happyReduction_68
happyReduction_68 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_2 of { (happy_var_2@(Located _ (Token (Num   {}) _))) -> 
	case happyOut56 happy_x_3 of { happy_var_3 -> 
	( mkFixity NonAssoc   happy_var_2 (reverse happy_var_3))}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_69 = happyReduce 4# 19# happyReduction_69
happyReduction_69 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut70 happy_x_2 of { happy_var_2 -> 
	case happyOut45 happy_x_4 of { happy_var_4 -> 
	happyIn34
		 (at (happy_var_2,happy_var_4) $ DPatBind happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_70 = happyReduce 5# 19# happyReduction_70
happyReduction_70 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut92 happy_x_2 of { happy_var_2 -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	case happyOut45 happy_x_5 of { happy_var_5 -> 
	happyIn34
		 (at (happy_var_2,happy_var_5) $
                                   DBind $ Bind { bName      = happy_var_2
                                                , bParams    = reverse happy_var_3
                                                , bDef       = at happy_var_5 (Located emptyRange (DExpr happy_var_5))
                                                , bSignature = Nothing
                                                , bPragmas   = []
                                                , bMono      = False
                                                , bInfix     = False
                                                , bFixity    = Nothing
                                                , bDoc       = Nothing
                                                }
	) `HappyStk` happyRest}}}

happyReduce_71 = happyReduce 4# 20# happyReduction_71
happyReduction_71 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut94 happy_x_2 of { happy_var_2 -> 
	case happyOut36 happy_x_4 of { happy_var_4 -> 
	happyIn35
		 (Newtype { nName = happy_var_2, nParams = [], nBody = happy_var_4 }
	) `HappyStk` happyRest}}

happyReduce_72 = happyReduce 5# 20# happyReduction_72
happyReduction_72 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut94 happy_x_2 of { happy_var_2 -> 
	case happyOut82 happy_x_3 of { happy_var_3 -> 
	case happyOut36 happy_x_5 of { happy_var_5 -> 
	happyIn35
		 (Newtype { nName = happy_var_2, nParams = happy_var_3, nBody = happy_var_5 }
	) `HappyStk` happyRest}}}

happyReduce_73 = happySpecReduce_2  21# happyReduction_73
happyReduction_73 happy_x_2
	happy_x_1
	 =  happyIn36
		 ([]
	)

happyReduce_74 = happySpecReduce_3  21# happyReduction_74
happyReduction_74 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut90 happy_x_2 of { happy_var_2 -> 
	happyIn36
		 (happy_var_2
	)}

happyReduce_75 = happySpecReduce_1  22# happyReduction_75
happyReduction_75 happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	happyIn37
		 ([ happy_var_1]
	)}

happyReduce_76 = happySpecReduce_3  22# happyReduction_76
happyReduction_76 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut37 happy_x_1 of { happy_var_1 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	happyIn37
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_77 = happySpecReduce_1  23# happyReduction_77
happyReduction_77 happy_x_1
	 =  case happyOut92 happy_x_1 of { happy_var_1 -> 
	happyIn38
		 (happy_var_1
	)}

happyReduce_78 = happySpecReduce_3  23# happyReduction_78
happyReduction_78 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut53 happy_x_2 of { happy_var_2 -> 
	happyIn38
		 (happy_var_2
	)}

happyReduce_79 = happySpecReduce_1  24# happyReduction_79
happyReduction_79 happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	happyIn39
		 ([happy_var_1]
	)}

happyReduce_80 = happySpecReduce_2  24# happyReduction_80
happyReduction_80 happy_x_2
	happy_x_1
	 =  case happyOut40 happy_x_1 of { happy_var_1 -> 
	case happyOut71 happy_x_2 of { happy_var_2 -> 
	happyIn39
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_81 = happySpecReduce_1  25# happyReduction_81
happyReduction_81 happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	happyIn40
		 ([happy_var_1]
	)}

happyReduce_82 = happySpecReduce_2  25# happyReduction_82
happyReduction_82 happy_x_2
	happy_x_1
	 =  case happyOut40 happy_x_1 of { happy_var_1 -> 
	case happyOut71 happy_x_2 of { happy_var_2 -> 
	happyIn40
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_83 = happySpecReduce_2  26# happyReduction_83
happyReduction_83 happy_x_2
	happy_x_1
	 =  case happyOut33 happy_x_1 of { happy_var_1 -> 
	happyIn41
		 ([happy_var_1]
	)}

happyReduce_84 = happySpecReduce_3  26# happyReduction_84
happyReduction_84 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOut33 happy_x_2 of { happy_var_2 -> 
	happyIn41
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_85 = happySpecReduce_1  27# happyReduction_85
happyReduction_85 happy_x_1
	 =  case happyOut33 happy_x_1 of { happy_var_1 -> 
	happyIn42
		 ([happy_var_1]
	)}

happyReduce_86 = happySpecReduce_3  27# happyReduction_86
happyReduction_86 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut42 happy_x_1 of { happy_var_1 -> 
	case happyOut33 happy_x_3 of { happy_var_3 -> 
	happyIn42
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_87 = happySpecReduce_3  27# happyReduction_87
happyReduction_87 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut42 happy_x_1 of { happy_var_1 -> 
	case happyOut33 happy_x_3 of { happy_var_3 -> 
	happyIn42
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_88 = happySpecReduce_3  28# happyReduction_88
happyReduction_88 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut42 happy_x_2 of { happy_var_2 -> 
	happyIn43
		 (happy_var_2
	)}

happyReduce_89 = happySpecReduce_2  28# happyReduction_89
happyReduction_89 happy_x_2
	happy_x_1
	 =  happyIn43
		 ([]
	)

happyReduce_90 = happySpecReduce_1  29# happyReduction_90
happyReduction_90 happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	happyIn44
		 (ExprInput happy_var_1
	)}

happyReduce_91 = happySpecReduce_1  29# happyReduction_91
happyReduction_91 happy_x_1
	 =  case happyOut34 happy_x_1 of { happy_var_1 -> 
	happyIn44
		 (LetInput happy_var_1
	)}

happyReduce_92 = happySpecReduce_1  30# happyReduction_92
happyReduction_92 happy_x_1
	 =  case happyOut48 happy_x_1 of { happy_var_1 -> 
	happyIn45
		 (happy_var_1
	)}

happyReduce_93 = happyReduce 4# 30# happyReduction_93
happyReduction_93 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym CurlyR  ) _)) -> 
	happyIn45
		 (at (happy_var_1,happy_var_4) $ EWhere happy_var_1 []
	) `HappyStk` happyRest}}

happyReduce_94 = happyReduce 5# 30# happyReduction_94
happyReduction_94 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOut41 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Located happy_var_5 (Token (Sym CurlyR  ) _)) -> 
	happyIn45
		 (at (happy_var_1,happy_var_5) $ EWhere happy_var_1 (reverse happy_var_4)
	) `HappyStk` happyRest}}}

happyReduce_95 = happyReduce 4# 30# happyReduction_95
happyReduction_95 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (KW KW_where  ) _)) -> 
	happyIn45
		 (at (happy_var_1,happy_var_2) $ EWhere happy_var_1 []
	) `HappyStk` happyRest}}

happyReduce_96 = happyReduce 5# 30# happyReduction_96
happyReduction_96 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOut42 happy_x_4 of { happy_var_4 -> 
	happyIn45
		 (at (happy_var_1,happy_var_4) $ EWhere happy_var_1 (reverse happy_var_4)
	) `HappyStk` happyRest}}

happyReduce_97 = happySpecReduce_1  31# happyReduction_97
happyReduction_97 happy_x_1
	 =  case happyOut47 happy_x_1 of { happy_var_1 -> 
	happyIn46
		 ([happy_var_1]
	)}

happyReduce_98 = happySpecReduce_3  31# happyReduction_98
happyReduction_98 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	case happyOut47 happy_x_3 of { happy_var_3 -> 
	happyIn46
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_99 = happySpecReduce_3  32# happyReduction_99
happyReduction_99 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOut45 happy_x_3 of { happy_var_3 -> 
	happyIn47
		 ((happy_var_1, happy_var_3)
	)}}

happyReduce_100 = happySpecReduce_1  33# happyReduction_100
happyReduction_100 happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	happyIn48
		 (happy_var_1
	)}

happyReduce_101 = happyReduce 4# 33# happyReduction_101
happyReduction_101 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_if     ) _)) -> 
	case happyOut46 happy_x_2 of { happy_var_2 -> 
	case happyOut48 happy_x_4 of { happy_var_4 -> 
	happyIn48
		 (at (happy_var_1,happy_var_4) $ mkIf (reverse happy_var_2) happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_102 = happyReduce 4# 33# happyReduction_102
happyReduction_102 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym Lambda  ) _)) -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	case happyOut48 happy_x_4 of { happy_var_4 -> 
	happyIn48
		 (at (happy_var_1,happy_var_4) $ EFun (reverse happy_var_2) happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_103 = happySpecReduce_1  34# happyReduction_103
happyReduction_103 happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	happyIn49
		 (happy_var_1
	)}

happyReduce_104 = happySpecReduce_3  34# happyReduction_104
happyReduction_104 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	case happyOut83 happy_x_3 of { happy_var_3 -> 
	happyIn49
		 (at (happy_var_1,happy_var_3) $ ETyped happy_var_1 happy_var_3
	)}}

happyReduce_105 = happySpecReduce_1  35# happyReduction_105
happyReduction_105 happy_x_1
	 =  case happyOut51 happy_x_1 of { happy_var_1 -> 
	happyIn50
		 (happy_var_1
	)}

happyReduce_106 = happySpecReduce_3  35# happyReduction_106
happyReduction_106 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	case happyOut52 happy_x_2 of { happy_var_2 -> 
	case happyOut51 happy_x_3 of { happy_var_3 -> 
	happyIn50
		 (binOp happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_107 = happySpecReduce_1  36# happyReduction_107
happyReduction_107 happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (mkEApp happy_var_1
	)}

happyReduce_108 = happySpecReduce_2  36# happyReduction_108
happyReduction_108 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Minus) _)) -> 
	case happyOut51 happy_x_2 of { happy_var_2 -> 
	happyIn51
		 (at (happy_var_1,happy_var_2) $ EApp (at happy_var_1 (EVar (mkUnqual "negate"))) happy_var_2
	)}}

happyReduce_109 = happySpecReduce_2  36# happyReduction_109
happyReduction_109 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Complement) _)) -> 
	case happyOut51 happy_x_2 of { happy_var_2 -> 
	happyIn51
		 (at (happy_var_1,happy_var_2) $ EApp (at happy_var_1 (EVar (mkUnqual "complement"))) happy_var_2
	)}}

happyReduce_110 = happySpecReduce_1  37# happyReduction_110
happyReduction_110 happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	happyIn52
		 (happy_var_1
	)}

happyReduce_111 = happySpecReduce_1  37# happyReduction_111
happyReduction_111 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Op  Other{}   )  _))) -> 
	happyIn52
		 (let Token (Op (Other ns i)) _ = thing happy_var_1
                                       in mkQual (mkModName ns) (mkInfix (T.toStrict i)) A.<$ happy_var_1
	)}

happyReduce_112 = happySpecReduce_1  38# happyReduction_112
happyReduction_112 happy_x_1
	 =  case happyOut54 happy_x_1 of { happy_var_1 -> 
	happyIn53
		 (happy_var_1
	)}

happyReduce_113 = happySpecReduce_1  38# happyReduction_113
happyReduction_113 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Hash) _)) -> 
	happyIn53
		 (Located happy_var_1 $ mkUnqual $ mkInfix "#"
	)}

happyReduce_114 = happySpecReduce_1  39# happyReduction_114
happyReduction_114 happy_x_1
	 =  case happyOut55 happy_x_1 of { happy_var_1 -> 
	happyIn54
		 (happy_var_1
	)}

happyReduce_115 = happySpecReduce_1  39# happyReduction_115
happyReduction_115 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Mul)   _)) -> 
	happyIn54
		 (Located happy_var_1 $ mkUnqual $ mkInfix "*"
	)}

happyReduce_116 = happySpecReduce_1  39# happyReduction_116
happyReduction_116 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Plus)  _)) -> 
	happyIn54
		 (Located happy_var_1 $ mkUnqual $ mkInfix "+"
	)}

happyReduce_117 = happySpecReduce_1  39# happyReduction_117
happyReduction_117 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Minus) _)) -> 
	happyIn54
		 (Located happy_var_1 $ mkUnqual $ mkInfix "-"
	)}

happyReduce_118 = happySpecReduce_1  39# happyReduction_118
happyReduction_118 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Complement) _)) -> 
	happyIn54
		 (Located happy_var_1 $ mkUnqual $ mkInfix "~"
	)}

happyReduce_119 = happySpecReduce_1  39# happyReduction_119
happyReduction_119 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Exp)   _)) -> 
	happyIn54
		 (Located happy_var_1 $ mkUnqual $ mkInfix "^^"
	)}

happyReduce_120 = happySpecReduce_1  40# happyReduction_120
happyReduction_120 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Op (Other [] _)) _))) -> 
	happyIn55
		 (let Token (Op (Other [] str)) _ = thing happy_var_1
                                       in mkUnqual (mkInfix (T.toStrict str)) A.<$ happy_var_1
	)}

happyReduce_121 = happySpecReduce_1  41# happyReduction_121
happyReduction_121 happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	happyIn56
		 ([happy_var_1]
	)}

happyReduce_122 = happySpecReduce_3  41# happyReduction_122
happyReduction_122 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut56 happy_x_1 of { happy_var_1 -> 
	case happyOut53 happy_x_3 of { happy_var_3 -> 
	happyIn56
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_123 = happySpecReduce_1  42# happyReduction_123
happyReduction_123 happy_x_1
	 =  case happyOut58 happy_x_1 of { happy_var_1 -> 
	happyIn57
		 ([happy_var_1]
	)}

happyReduce_124 = happySpecReduce_2  42# happyReduction_124
happyReduction_124 happy_x_2
	happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	case happyOut58 happy_x_2 of { happy_var_2 -> 
	happyIn57
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_125 = happySpecReduce_1  43# happyReduction_125
happyReduction_125 happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	happyIn58
		 (at happy_var_1 $ EVar (thing happy_var_1)
	)}

happyReduce_126 = happySpecReduce_1  43# happyReduction_126
happyReduction_126 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	happyIn58
		 (at happy_var_1 $ numLit (tokenType (thing happy_var_1))
	)}

happyReduce_127 = happySpecReduce_1  43# happyReduction_127
happyReduction_127 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (StrLit {}) _))) -> 
	happyIn58
		 (at happy_var_1 $ ELit $ ECString $ getStr happy_var_1
	)}

happyReduce_128 = happySpecReduce_1  43# happyReduction_128
happyReduction_128 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (ChrLit {}) _))) -> 
	happyIn58
		 (at happy_var_1 $ ELit $ ECNum (getNum happy_var_1) CharLit
	)}

happyReduce_129 = happySpecReduce_3  43# happyReduction_129
happyReduction_129 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut45 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn58
		 (at (happy_var_1,happy_var_3) $ EParens happy_var_2
	)}}}

happyReduce_130 = happySpecReduce_3  43# happyReduction_130
happyReduction_130 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut62 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn58
		 (at (happy_var_1,happy_var_3) $ ETuple (reverse happy_var_2)
	)}}}

happyReduce_131 = happySpecReduce_2  43# happyReduction_131
happyReduction_131 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym ParenR  ) _)) -> 
	happyIn58
		 (at (happy_var_1,happy_var_2) $ ETuple []
	)}}

happyReduce_132 = happySpecReduce_2  43# happyReduction_132
happyReduction_132 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn58
		 (at (happy_var_1,happy_var_2) $ ERecord []
	)}}

happyReduce_133 = happySpecReduce_3  43# happyReduction_133
happyReduction_133 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut64 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn58
		 (at (happy_var_1,happy_var_3) $ ERecord (reverse happy_var_2)
	)}}}

happyReduce_134 = happySpecReduce_2  43# happyReduction_134
happyReduction_134 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym BracketR) _)) -> 
	happyIn58
		 (at (happy_var_1,happy_var_2) $ EList []
	)}}

happyReduce_135 = happySpecReduce_3  43# happyReduction_135
happyReduction_135 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut65 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn58
		 (at (happy_var_1,happy_var_3) happy_var_2
	)}}}

happyReduce_136 = happySpecReduce_2  43# happyReduction_136
happyReduction_136 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BackTick) _)) -> 
	case happyOut96 happy_x_2 of { happy_var_2 -> 
	happyIn58
		 (at (happy_var_1,happy_var_2) $ ETypeVal happy_var_2
	)}}

happyReduce_137 = happySpecReduce_3  43# happyReduction_137
happyReduction_137 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut58 happy_x_1 of { happy_var_1 -> 
	case happyOut61 happy_x_3 of { happy_var_3 -> 
	happyIn58
		 (at (happy_var_1,happy_var_3) $ ESel happy_var_1 (thing happy_var_3)
	)}}

happyReduce_138 = happySpecReduce_3  43# happyReduction_138
happyReduction_138 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut52 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn58
		 (at (happy_var_1,happy_var_3) $ EVar $ thing happy_var_2
	)}}}

happyReduce_139 = happyMonadReduce 2# 43# happyReduction_139
happyReduction_139 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym TriL    ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym TriR    ) _)) -> 
	( mkPoly (rComb happy_var_1 happy_var_2) [])}}
	) (\r -> happyReturn (happyIn58 r))

happyReduce_140 = happyMonadReduce 3# 43# happyReduction_140
happyReduction_140 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym TriL    ) _)) -> 
	case happyOut59 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym TriR    ) _)) -> 
	( mkPoly (rComb happy_var_1 happy_var_3) happy_var_2)}}}
	) (\r -> happyReturn (happyIn58 r))

happyReduce_141 = happySpecReduce_1  44# happyReduction_141
happyReduction_141 happy_x_1
	 =  case happyOut60 happy_x_1 of { happy_var_1 -> 
	happyIn59
		 ([happy_var_1]
	)}

happyReduce_142 = happySpecReduce_3  44# happyReduction_142
happyReduction_142 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	case happyOut60 happy_x_3 of { happy_var_3 -> 
	happyIn59
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_143 = happyMonadReduce 1# 45# happyReduction_143
happyReduction_143 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	( polyTerm (srcRange happy_var_1) (getNum happy_var_1) 0)}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_144 = happyMonadReduce 1# 45# happyReduction_144
happyReduction_144 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_x)       _)) -> 
	( polyTerm happy_var_1 1 1)}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_145 = happyMonadReduce 3# 45# happyReduction_145
happyReduction_145 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_x)       _)) -> 
	case happyOutTok happy_x_3 of { (happy_var_3@(Located _ (Token (Num   {}) _))) -> 
	( polyTerm (rComb happy_var_1 (srcRange happy_var_3))
                                                            1 (getNum happy_var_3))}}
	) (\r -> happyReturn (happyIn60 r))

happyReduce_146 = happySpecReduce_1  46# happyReduction_146
happyReduction_146 happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	happyIn61
		 (fmap (`RecordSel` Nothing) happy_var_1
	)}

happyReduce_147 = happyMonadReduce 1# 46# happyReduction_147
happyReduction_147 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	( mkTupleSel (srcRange happy_var_1) (getNum happy_var_1))}
	) (\r -> happyReturn (happyIn61 r))

happyReduce_148 = happySpecReduce_3  47# happyReduction_148
happyReduction_148 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOut45 happy_x_3 of { happy_var_3 -> 
	happyIn62
		 ([ happy_var_3, happy_var_1]
	)}}

happyReduce_149 = happySpecReduce_3  47# happyReduction_149
happyReduction_149 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut62 happy_x_1 of { happy_var_1 -> 
	case happyOut45 happy_x_3 of { happy_var_3 -> 
	happyIn62
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_150 = happySpecReduce_3  48# happyReduction_150
happyReduction_150 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	case happyOut45 happy_x_3 of { happy_var_3 -> 
	happyIn63
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_151 = happyReduce 4# 48# happyReduction_151
happyReduction_151 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut91 happy_x_1 of { happy_var_1 -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	case happyOut45 happy_x_4 of { happy_var_4 -> 
	happyIn63
		 (Named { name = happy_var_1, value = EFun (reverse happy_var_2) happy_var_4 }
	) `HappyStk` happyRest}}}

happyReduce_152 = happySpecReduce_1  49# happyReduction_152
happyReduction_152 happy_x_1
	 =  case happyOut63 happy_x_1 of { happy_var_1 -> 
	happyIn64
		 ([happy_var_1]
	)}

happyReduce_153 = happySpecReduce_3  49# happyReduction_153
happyReduction_153 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut64 happy_x_1 of { happy_var_1 -> 
	case happyOut63 happy_x_3 of { happy_var_3 -> 
	happyIn64
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_154 = happySpecReduce_3  50# happyReduction_154
happyReduction_154 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOut66 happy_x_3 of { happy_var_3 -> 
	happyIn65
		 (EComp happy_var_1 (reverse happy_var_3)
	)}}

happyReduce_155 = happySpecReduce_1  50# happyReduction_155
happyReduction_155 happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	happyIn65
		 (EList [happy_var_1]
	)}

happyReduce_156 = happySpecReduce_1  50# happyReduction_156
happyReduction_156 happy_x_1
	 =  case happyOut62 happy_x_1 of { happy_var_1 -> 
	happyIn65
		 (EList (reverse happy_var_1)
	)}

happyReduce_157 = happyMonadReduce 2# 50# happyReduction_157
happyReduction_157 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym DotDot  ) _)) -> 
	( eFromTo happy_var_2 happy_var_1 Nothing   Nothing)}}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_158 = happyMonadReduce 3# 50# happyReduction_158
happyReduction_158 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym DotDot  ) _)) -> 
	case happyOut45 happy_x_3 of { happy_var_3 -> 
	( eFromTo happy_var_2 happy_var_1 Nothing   (Just happy_var_3))}}}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_159 = happyMonadReduce 4# 50# happyReduction_159
happyReduction_159 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOut45 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym DotDot  ) _)) -> 
	( eFromTo happy_var_4 happy_var_1 (Just happy_var_3) Nothing)}}}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_160 = happyMonadReduce 5# 50# happyReduction_160
happyReduction_160 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOut45 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym DotDot  ) _)) -> 
	case happyOut45 happy_x_5 of { happy_var_5 -> 
	( eFromTo happy_var_4 happy_var_1 (Just happy_var_3) (Just happy_var_5))}}}}
	) (\r -> happyReturn (happyIn65 r))

happyReduce_161 = happySpecReduce_2  50# happyReduction_161
happyReduction_161 happy_x_2
	happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	happyIn65
		 (EInfFrom happy_var_1 Nothing
	)}

happyReduce_162 = happyReduce 4# 50# happyReduction_162
happyReduction_162 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOut45 happy_x_3 of { happy_var_3 -> 
	happyIn65
		 (EInfFrom happy_var_1 (Just happy_var_3)
	) `HappyStk` happyRest}}

happyReduce_163 = happySpecReduce_1  51# happyReduction_163
happyReduction_163 happy_x_1
	 =  case happyOut67 happy_x_1 of { happy_var_1 -> 
	happyIn66
		 ([ reverse happy_var_1 ]
	)}

happyReduce_164 = happySpecReduce_3  51# happyReduction_164
happyReduction_164 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut66 happy_x_1 of { happy_var_1 -> 
	case happyOut67 happy_x_3 of { happy_var_3 -> 
	happyIn66
		 (reverse happy_var_3 : happy_var_1
	)}}

happyReduce_165 = happySpecReduce_1  52# happyReduction_165
happyReduction_165 happy_x_1
	 =  case happyOut68 happy_x_1 of { happy_var_1 -> 
	happyIn67
		 ([happy_var_1]
	)}

happyReduce_166 = happySpecReduce_3  52# happyReduction_166
happyReduction_166 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut67 happy_x_1 of { happy_var_1 -> 
	case happyOut68 happy_x_3 of { happy_var_3 -> 
	happyIn67
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_167 = happySpecReduce_3  53# happyReduction_167
happyReduction_167 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut69 happy_x_1 of { happy_var_1 -> 
	case happyOut45 happy_x_3 of { happy_var_3 -> 
	happyIn68
		 (Match happy_var_1 happy_var_3
	)}}

happyReduce_168 = happySpecReduce_3  54# happyReduction_168
happyReduction_168 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut83 happy_x_3 of { happy_var_3 -> 
	happyIn69
		 (at (happy_var_1,happy_var_3) $ PTyped happy_var_1 happy_var_3
	)}}

happyReduce_169 = happySpecReduce_1  54# happyReduction_169
happyReduction_169 happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	happyIn69
		 (happy_var_1
	)}

happyReduce_170 = happySpecReduce_3  55# happyReduction_170
happyReduction_170 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn70
		 (at (happy_var_1,happy_var_3) $ PSplit happy_var_1 happy_var_3
	)}}

happyReduce_171 = happySpecReduce_1  55# happyReduction_171
happyReduction_171 happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	happyIn70
		 (happy_var_1
	)}

happyReduce_172 = happySpecReduce_1  56# happyReduction_172
happyReduction_172 happy_x_1
	 =  case happyOut92 happy_x_1 of { happy_var_1 -> 
	happyIn71
		 (PVar happy_var_1
	)}

happyReduce_173 = happySpecReduce_1  56# happyReduction_173
happyReduction_173 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym Underscore ) _)) -> 
	happyIn71
		 (at happy_var_1       $ PWild
	)}

happyReduce_174 = happySpecReduce_2  56# happyReduction_174
happyReduction_174 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym ParenR  ) _)) -> 
	happyIn71
		 (at (happy_var_1,happy_var_2) $ PTuple []
	)}}

happyReduce_175 = happySpecReduce_3  56# happyReduction_175
happyReduction_175 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut69 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn71
		 (at (happy_var_1,happy_var_3)   happy_var_2
	)}}}

happyReduce_176 = happySpecReduce_3  56# happyReduction_176
happyReduction_176 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn71
		 (at (happy_var_1,happy_var_3) $ PTuple (reverse happy_var_2)
	)}}}

happyReduce_177 = happySpecReduce_2  56# happyReduction_177
happyReduction_177 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym BracketR) _)) -> 
	happyIn71
		 (at (happy_var_1,happy_var_2) $ PList []
	)}}

happyReduce_178 = happySpecReduce_3  56# happyReduction_178
happyReduction_178 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut69 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn71
		 (at (happy_var_1,happy_var_3) $ PList [happy_var_2]
	)}}}

happyReduce_179 = happySpecReduce_3  56# happyReduction_179
happyReduction_179 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut72 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn71
		 (at (happy_var_1,happy_var_3) $ PList (reverse happy_var_2)
	)}}}

happyReduce_180 = happySpecReduce_2  56# happyReduction_180
happyReduction_180 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn71
		 (at (happy_var_1,happy_var_2) $ PRecord []
	)}}

happyReduce_181 = happySpecReduce_3  56# happyReduction_181
happyReduction_181 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut74 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn71
		 (at (happy_var_1,happy_var_3) $ PRecord (reverse happy_var_2)
	)}}}

happyReduce_182 = happySpecReduce_3  57# happyReduction_182
happyReduction_182 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut69 happy_x_1 of { happy_var_1 -> 
	case happyOut69 happy_x_3 of { happy_var_3 -> 
	happyIn72
		 ([happy_var_3, happy_var_1]
	)}}

happyReduce_183 = happySpecReduce_3  57# happyReduction_183
happyReduction_183 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut72 happy_x_1 of { happy_var_1 -> 
	case happyOut69 happy_x_3 of { happy_var_3 -> 
	happyIn72
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_184 = happySpecReduce_3  58# happyReduction_184
happyReduction_184 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	case happyOut69 happy_x_3 of { happy_var_3 -> 
	happyIn73
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_185 = happySpecReduce_1  59# happyReduction_185
happyReduction_185 happy_x_1
	 =  case happyOut73 happy_x_1 of { happy_var_1 -> 
	happyIn74
		 ([happy_var_1]
	)}

happyReduce_186 = happySpecReduce_3  59# happyReduction_186
happyReduction_186 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut74 happy_x_1 of { happy_var_1 -> 
	case happyOut73 happy_x_3 of { happy_var_3 -> 
	happyIn74
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_187 = happySpecReduce_1  60# happyReduction_187
happyReduction_187 happy_x_1
	 =  case happyOut83 happy_x_1 of { happy_var_1 -> 
	happyIn75
		 (at happy_var_1 $ mkSchema [] [] happy_var_1
	)}

happyReduce_188 = happySpecReduce_2  60# happyReduction_188
happyReduction_188 happy_x_2
	happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	case happyOut83 happy_x_2 of { happy_var_2 -> 
	happyIn75
		 (at (happy_var_1,happy_var_2) $ mkSchema (thing happy_var_1) [] happy_var_2
	)}}

happyReduce_189 = happySpecReduce_2  60# happyReduction_189
happyReduction_189 happy_x_2
	happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	case happyOut83 happy_x_2 of { happy_var_2 -> 
	happyIn75
		 (at (happy_var_1,happy_var_2) $ mkSchema [] (thing happy_var_1) happy_var_2
	)}}

happyReduce_190 = happySpecReduce_3  60# happyReduction_190
happyReduction_190 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	case happyOut77 happy_x_2 of { happy_var_2 -> 
	case happyOut83 happy_x_3 of { happy_var_3 -> 
	happyIn75
		 (at (happy_var_1,happy_var_3) $ mkSchema (thing happy_var_1)
                                                          (thing happy_var_2) happy_var_3
	)}}}

happyReduce_191 = happySpecReduce_2  61# happyReduction_191
happyReduction_191 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn76
		 (Located (rComb happy_var_1 happy_var_2) []
	)}}

happyReduce_192 = happySpecReduce_3  61# happyReduction_192
happyReduction_192 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut80 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn76
		 (Located (rComb happy_var_1 happy_var_3) (reverse happy_var_2)
	)}}}

happyReduce_193 = happyMonadReduce 2# 62# happyReduction_193
happyReduction_193 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut83 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym FatArrR ) _)) -> 
	( fmap (\x -> at (x,happy_var_2) x) (mkProp happy_var_1))}}
	) (\r -> happyReturn (happyIn77 r))

happyReduce_194 = happySpecReduce_1  63# happyReduction_194
happyReduction_194 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Hash) _)) -> 
	happyIn78
		 (Located happy_var_1 KNum
	)}

happyReduce_195 = happySpecReduce_1  63# happyReduction_195
happyReduction_195 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Mul)   _)) -> 
	happyIn78
		 (Located happy_var_1 KType
	)}

happyReduce_196 = happyMonadReduce 1# 64# happyReduction_196
happyReduction_196 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut91 happy_x_1 of { happy_var_1 -> 
	( mkTParam happy_var_1 Nothing)}
	) (\r -> happyReturn (happyIn79 r))

happyReduce_197 = happyMonadReduce 3# 64# happyReduction_197
happyReduction_197 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut91 happy_x_1 of { happy_var_1 -> 
	case happyOut78 happy_x_3 of { happy_var_3 -> 
	( mkTParam (at (happy_var_1,happy_var_3) happy_var_1) (Just (thing happy_var_3)))}}
	) (\r -> happyReturn (happyIn79 r))

happyReduce_198 = happySpecReduce_1  65# happyReduction_198
happyReduction_198 happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	happyIn80
		 ([happy_var_1]
	)}

happyReduce_199 = happySpecReduce_3  65# happyReduction_199
happyReduction_199 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut80 happy_x_1 of { happy_var_1 -> 
	case happyOut79 happy_x_3 of { happy_var_3 -> 
	happyIn80
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_200 = happyMonadReduce 1# 66# happyReduction_200
happyReduction_200 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut91 happy_x_1 of { happy_var_1 -> 
	( mkTParam happy_var_1 Nothing)}
	) (\r -> happyReturn (happyIn81 r))

happyReduce_201 = happyMonadReduce 5# 66# happyReduction_201
happyReduction_201 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut91 happy_x_2 of { happy_var_2 -> 
	case happyOut78 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Located happy_var_5 (Token (Sym ParenR  ) _)) -> 
	( mkTParam (at (happy_var_1,happy_var_5) happy_var_2) (Just (thing happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn81 r))

happyReduce_202 = happySpecReduce_1  67# happyReduction_202
happyReduction_202 happy_x_1
	 =  case happyOut81 happy_x_1 of { happy_var_1 -> 
	happyIn82
		 ([happy_var_1]
	)}

happyReduce_203 = happySpecReduce_2  67# happyReduction_203
happyReduction_203 happy_x_2
	happy_x_1
	 =  case happyOut82 happy_x_1 of { happy_var_1 -> 
	case happyOut81 happy_x_2 of { happy_var_2 -> 
	happyIn82
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_204 = happySpecReduce_3  68# happyReduction_204
happyReduction_204 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut84 happy_x_1 of { happy_var_1 -> 
	case happyOut83 happy_x_3 of { happy_var_3 -> 
	happyIn83
		 (at (happy_var_1,happy_var_3) $ TFun happy_var_1 happy_var_3
	)}}

happyReduce_205 = happySpecReduce_3  68# happyReduction_205
happyReduction_205 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut83 happy_x_1 of { happy_var_1 -> 
	case happyOut53 happy_x_2 of { happy_var_2 -> 
	case happyOut84 happy_x_3 of { happy_var_3 -> 
	happyIn83
		 (at (happy_var_1,happy_var_3) $ TInfix happy_var_1 happy_var_2 defaultFixity happy_var_3
	)}}}

happyReduce_206 = happySpecReduce_1  68# happyReduction_206
happyReduction_206 happy_x_1
	 =  case happyOut84 happy_x_1 of { happy_var_1 -> 
	happyIn83
		 (happy_var_1
	)}

happyReduce_207 = happySpecReduce_2  69# happyReduction_207
happyReduction_207 happy_x_2
	happy_x_1
	 =  case happyOut87 happy_x_1 of { happy_var_1 -> 
	case happyOut85 happy_x_2 of { happy_var_2 -> 
	happyIn84
		 (at (happy_var_1,happy_var_2) $ foldr TSeq happy_var_2 (reverse (thing happy_var_1))
	)}}

happyReduce_208 = happySpecReduce_2  69# happyReduction_208
happyReduction_208 happy_x_2
	happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_2 of { happy_var_2 -> 
	happyIn84
		 (at (happy_var_1,head happy_var_2)
                                     $ TUser (thing happy_var_1) (reverse happy_var_2)
	)}}

happyReduce_209 = happySpecReduce_1  69# happyReduction_209
happyReduction_209 happy_x_1
	 =  case happyOut85 happy_x_1 of { happy_var_1 -> 
	happyIn84
		 (happy_var_1
	)}

happyReduce_210 = happySpecReduce_1  70# happyReduction_210
happyReduction_210 happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	happyIn85
		 (at happy_var_1 $ TUser (thing happy_var_1) []
	)}

happyReduce_211 = happySpecReduce_1  70# happyReduction_211
happyReduction_211 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	happyIn85
		 (at happy_var_1 $ TNum  (getNum happy_var_1)
	)}

happyReduce_212 = happySpecReduce_1  70# happyReduction_212
happyReduction_212 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (ChrLit {}) _))) -> 
	happyIn85
		 (at happy_var_1 $ TChar (toEnum $ fromInteger
                                                          $ getNum happy_var_1)
	)}

happyReduce_213 = happySpecReduce_3  70# happyReduction_213
happyReduction_213 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut83 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn85
		 (at (happy_var_1,happy_var_3) $ TSeq happy_var_2 TBit
	)}}}

happyReduce_214 = happySpecReduce_3  70# happyReduction_214
happyReduction_214 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut83 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn85
		 (at (happy_var_1,happy_var_3) $ TParens happy_var_2
	)}}}

happyReduce_215 = happySpecReduce_2  70# happyReduction_215
happyReduction_215 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym ParenR  ) _)) -> 
	happyIn85
		 (at (happy_var_1,happy_var_2) $ TTuple []
	)}}

happyReduce_216 = happySpecReduce_3  70# happyReduction_216
happyReduction_216 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut88 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn85
		 (at (happy_var_1,happy_var_3) $ TTuple  (reverse happy_var_2)
	)}}}

happyReduce_217 = happySpecReduce_2  70# happyReduction_217
happyReduction_217 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn85
		 (at (happy_var_1,happy_var_2) $ TRecord []
	)}}

happyReduce_218 = happySpecReduce_3  70# happyReduction_218
happyReduction_218 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut90 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn85
		 (at (happy_var_1,happy_var_3) $ TRecord (reverse happy_var_2)
	)}}}

happyReduce_219 = happySpecReduce_1  70# happyReduction_219
happyReduction_219 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym Underscore ) _)) -> 
	happyIn85
		 (at happy_var_1 TWild
	)}

happyReduce_220 = happySpecReduce_1  71# happyReduction_220
happyReduction_220 happy_x_1
	 =  case happyOut85 happy_x_1 of { happy_var_1 -> 
	happyIn86
		 ([ happy_var_1 ]
	)}

happyReduce_221 = happySpecReduce_2  71# happyReduction_221
happyReduction_221 happy_x_2
	happy_x_1
	 =  case happyOut86 happy_x_1 of { happy_var_1 -> 
	case happyOut85 happy_x_2 of { happy_var_2 -> 
	happyIn86
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_222 = happySpecReduce_3  72# happyReduction_222
happyReduction_222 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut83 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn87
		 (Located (rComb happy_var_1 happy_var_3) [ happy_var_2 ]
	)}}}

happyReduce_223 = happyReduce 4# 72# happyReduction_223
happyReduction_223 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut87 happy_x_1 of { happy_var_1 -> 
	case happyOut83 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym BracketR) _)) -> 
	happyIn87
		 (at (happy_var_1,happy_var_4) (fmap (happy_var_3 :) happy_var_1)
	) `HappyStk` happyRest}}}

happyReduce_224 = happySpecReduce_3  73# happyReduction_224
happyReduction_224 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut83 happy_x_1 of { happy_var_1 -> 
	case happyOut83 happy_x_3 of { happy_var_3 -> 
	happyIn88
		 ([ happy_var_3, happy_var_1]
	)}}

happyReduce_225 = happySpecReduce_3  73# happyReduction_225
happyReduction_225 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	case happyOut83 happy_x_3 of { happy_var_3 -> 
	happyIn88
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_226 = happySpecReduce_3  74# happyReduction_226
happyReduction_226 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	case happyOut83 happy_x_3 of { happy_var_3 -> 
	happyIn89
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_227 = happySpecReduce_1  75# happyReduction_227
happyReduction_227 happy_x_1
	 =  case happyOut89 happy_x_1 of { happy_var_1 -> 
	happyIn90
		 ([happy_var_1]
	)}

happyReduce_228 = happySpecReduce_3  75# happyReduction_228
happyReduction_228 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut90 happy_x_1 of { happy_var_1 -> 
	case happyOut89 happy_x_3 of { happy_var_3 -> 
	happyIn90
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_229 = happySpecReduce_1  76# happyReduction_229
happyReduction_229 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Ident [] _) _))) -> 
	happyIn91
		 (let Token (Ident _ str) _ = thing happy_var_1
                         in happy_var_1 { thing = mkIdent (T.toStrict str) }
	)}

happyReduce_230 = happySpecReduce_1  76# happyReduction_230
happyReduction_230 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_x)       _)) -> 
	happyIn91
		 (Located { srcRange = happy_var_1, thing = mkIdent "x" }
	)}

happyReduce_231 = happySpecReduce_1  76# happyReduction_231
happyReduction_231 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_private)   _)) -> 
	happyIn91
		 (Located { srcRange = happy_var_1, thing = mkIdent "private" }
	)}

happyReduce_232 = happySpecReduce_1  76# happyReduction_232
happyReduction_232 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_as)        _)) -> 
	happyIn91
		 (Located { srcRange = happy_var_1, thing = mkIdent "as" }
	)}

happyReduce_233 = happySpecReduce_1  76# happyReduction_233
happyReduction_233 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_hiding)    _)) -> 
	happyIn91
		 (Located { srcRange = happy_var_1, thing = mkIdent "hiding" }
	)}

happyReduce_234 = happySpecReduce_1  77# happyReduction_234
happyReduction_234 happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	happyIn92
		 (fmap mkUnqual happy_var_1
	)}

happyReduce_235 = happySpecReduce_1  78# happyReduction_235
happyReduction_235 happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	happyIn93
		 (fmap identText happy_var_1
	)}

happyReduce_236 = happySpecReduce_1  78# happyReduction_236
happyReduction_236 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token  Ident{}     _))) -> 
	happyIn93
		 (let Token (Ident ns i) _ = thing happy_var_1
                                     in mkModName (ns ++ [i]) A.<$ happy_var_1
	)}

happyReduce_237 = happySpecReduce_1  79# happyReduction_237
happyReduction_237 happy_x_1
	 =  case happyOut92 happy_x_1 of { happy_var_1 -> 
	happyIn94
		 (happy_var_1
	)}

happyReduce_238 = happySpecReduce_1  79# happyReduction_238
happyReduction_238 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token  Ident{}     _))) -> 
	happyIn94
		 (let Token (Ident ns i) _ = thing happy_var_1
                                     in mkQual (mkModName ns) (mkIdent (T.toStrict i)) A.<$ happy_var_1
	)}

happyReduce_239 = happySpecReduce_1  80# happyReduction_239
happyReduction_239 happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	happyIn95
		 (happy_var_1
	)}

happyReduce_240 = happySpecReduce_1  80# happyReduction_240
happyReduction_240 happy_x_1
	 =  case happyOut52 happy_x_1 of { happy_var_1 -> 
	happyIn95
		 (happy_var_1
	)}

happyReduce_241 = happySpecReduce_3  80# happyReduction_241
happyReduction_241 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut52 happy_x_2 of { happy_var_2 -> 
	happyIn95
		 (happy_var_2
	)}

happyReduce_242 = happySpecReduce_1  81# happyReduction_242
happyReduction_242 happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	happyIn96
		 (at happy_var_1 $ TUser (thing happy_var_1) []
	)}

happyReduce_243 = happySpecReduce_1  81# happyReduction_243
happyReduction_243 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	happyIn96
		 (at happy_var_1 $ TNum  (getNum happy_var_1)
	)}

happyReduce_244 = happyMonadReduce 3# 81# happyReduction_244
happyReduction_244 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut83 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	( validDemotedType (rComb happy_var_1 happy_var_3) happy_var_2)}}}
	) (\r -> happyReturn (happyIn96 r))

happyReduce_245 = happySpecReduce_2  81# happyReduction_245
happyReduction_245 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn96
		 (at (happy_var_1,happy_var_2) (TRecord [])
	)}}

happyReduce_246 = happySpecReduce_3  81# happyReduction_246
happyReduction_246 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut98 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn96
		 (at (happy_var_1,happy_var_3) (TRecord (reverse happy_var_2))
	)}}}

happyReduce_247 = happySpecReduce_3  81# happyReduction_247
happyReduction_247 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut83 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn96
		 (anonRecord (getLoc (happy_var_1,happy_var_3)) [happy_var_2]
	)}}}

happyReduce_248 = happySpecReduce_3  81# happyReduction_248
happyReduction_248 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut88 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn96
		 (anonRecord (getLoc (happy_var_1,happy_var_3)) (reverse happy_var_2)
	)}}}

happyReduce_249 = happySpecReduce_3  82# happyReduction_249
happyReduction_249 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	case happyOut83 happy_x_3 of { happy_var_3 -> 
	happyIn97
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_250 = happySpecReduce_1  83# happyReduction_250
happyReduction_250 happy_x_1
	 =  case happyOut97 happy_x_1 of { happy_var_1 -> 
	happyIn98
		 ([happy_var_1]
	)}

happyReduce_251 = happySpecReduce_3  83# happyReduction_251
happyReduction_251 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut98 happy_x_1 of { happy_var_1 -> 
	case happyOut97 happy_x_3 of { happy_var_3 -> 
	happyIn98
		 (happy_var_3 : happy_var_1
	)}}

happyNewToken action sts stk
	= lexerP(\tk -> 
	let cont i = happyDoAction i tk action sts stk in
	case tk of {
	Located _ (Token EOF _) -> happyDoAction 59# tk action sts stk;
	happy_dollar_dollar@(Located _ (Token (Num   {}) _)) -> cont 1#;
	happy_dollar_dollar@(Located _ (Token (StrLit {}) _)) -> cont 2#;
	happy_dollar_dollar@(Located _ (Token (ChrLit {}) _)) -> cont 3#;
	happy_dollar_dollar@(Located _ (Token (Ident [] _) _)) -> cont 4#;
	happy_dollar_dollar@(Located _ (Token  Ident{}     _)) -> cont 5#;
	Located happy_dollar_dollar (Token (KW KW_include)   _) -> cont 6#;
	Located happy_dollar_dollar (Token (KW KW_import)    _) -> cont 7#;
	Located happy_dollar_dollar (Token (KW KW_as)        _) -> cont 8#;
	Located happy_dollar_dollar (Token (KW KW_hiding)    _) -> cont 9#;
	Located happy_dollar_dollar (Token (KW KW_private)   _) -> cont 10#;
	Located happy_dollar_dollar (Token (KW KW_property)  _) -> cont 11#;
	Located happy_dollar_dollar (Token (KW KW_infix)     _) -> cont 12#;
	Located happy_dollar_dollar (Token (KW KW_infixl)    _) -> cont 13#;
	Located happy_dollar_dollar (Token (KW KW_infixr)    _) -> cont 14#;
	Located happy_dollar_dollar (Token (KW KW_type   ) _) -> cont 15#;
	Located happy_dollar_dollar (Token (KW KW_newtype) _) -> cont 16#;
	Located happy_dollar_dollar (Token (KW KW_module ) _) -> cont 17#;
	Located happy_dollar_dollar (Token (KW KW_where  ) _) -> cont 18#;
	Located happy_dollar_dollar (Token (KW KW_let    ) _) -> cont 19#;
	Located happy_dollar_dollar (Token (KW KW_if     ) _) -> cont 20#;
	Located happy_dollar_dollar (Token (KW KW_then   ) _) -> cont 21#;
	Located happy_dollar_dollar (Token (KW KW_else   ) _) -> cont 22#;
	Located happy_dollar_dollar (Token (KW KW_x)       _) -> cont 23#;
	Located happy_dollar_dollar (Token (KW KW_primitive) _) -> cont 24#;
	Located happy_dollar_dollar (Token (Sym BracketL) _) -> cont 25#;
	Located happy_dollar_dollar (Token (Sym BracketR) _) -> cont 26#;
	Located happy_dollar_dollar (Token (Sym ArrL    ) _) -> cont 27#;
	Located happy_dollar_dollar (Token (Sym DotDot  ) _) -> cont 28#;
	Located happy_dollar_dollar (Token (Sym DotDotDot) _) -> cont 29#;
	Located happy_dollar_dollar (Token (Sym Bar     ) _) -> cont 30#;
	Located happy_dollar_dollar (Token (Sym ParenL  ) _) -> cont 31#;
	Located happy_dollar_dollar (Token (Sym ParenR  ) _) -> cont 32#;
	Located happy_dollar_dollar (Token (Sym Comma   ) _) -> cont 33#;
	Located happy_dollar_dollar (Token (Sym Semi    ) _) -> cont 34#;
	Located happy_dollar_dollar (Token (Sym Dot     ) _) -> cont 35#;
	Located happy_dollar_dollar (Token (Sym CurlyL  ) _) -> cont 36#;
	Located happy_dollar_dollar (Token (Sym CurlyR  ) _) -> cont 37#;
	Located happy_dollar_dollar (Token (Sym TriL    ) _) -> cont 38#;
	Located happy_dollar_dollar (Token (Sym TriR    ) _) -> cont 39#;
	Located happy_dollar_dollar (Token (Sym EqDef   ) _) -> cont 40#;
	Located happy_dollar_dollar (Token (Sym BackTick) _) -> cont 41#;
	Located happy_dollar_dollar (Token (Sym Colon   ) _) -> cont 42#;
	Located happy_dollar_dollar (Token (Sym ArrR    ) _) -> cont 43#;
	Located happy_dollar_dollar (Token (Sym FatArrR ) _) -> cont 44#;
	Located happy_dollar_dollar (Token (Sym Lambda  ) _) -> cont 45#;
	Located happy_dollar_dollar (Token (Sym Underscore ) _) -> cont 46#;
	Located happy_dollar_dollar (Token (Virt VCurlyL)  _) -> cont 47#;
	Located happy_dollar_dollar (Token (Virt VCurlyR)  _) -> cont 48#;
	Located happy_dollar_dollar (Token (Virt VSemi)    _) -> cont 49#;
	Located happy_dollar_dollar (Token (Op Plus)  _) -> cont 50#;
	Located happy_dollar_dollar (Token (Op Mul)   _) -> cont 51#;
	Located happy_dollar_dollar (Token (Op Exp)   _) -> cont 52#;
	Located happy_dollar_dollar (Token (Op Minus) _) -> cont 53#;
	Located happy_dollar_dollar (Token (Op Complement) _) -> cont 54#;
	Located happy_dollar_dollar (Token (Op Hash) _) -> cont 55#;
	happy_dollar_dollar@(Located _ (Token (Op (Other [] _)) _)) -> cont 56#;
	happy_dollar_dollar@(Located _ (Token (Op  Other{}   )  _)) -> cont 57#;
	happy_dollar_dollar@(Located _ (Token (White DocStr) _)) -> cont 58#;
	_ -> happyError' tk
	})

happyError_ 59# tk = happyError' tk
happyError_ _ tk = happyError' tk

happyThen :: () => ParseM a -> (a -> ParseM b) -> ParseM b
happyThen = (>>=)
happyReturn :: () => a -> ParseM a
happyReturn = (return)
happyThen1 = happyThen
happyReturn1 :: () => a -> ParseM a
happyReturn1 = happyReturn
happyError' :: () => (Located Token) -> ParseM a
happyError' tk = (\token -> happyError) tk

vmodule = happySomeParser where
  happySomeParser = happyThen (happyParse 0#) (\x -> happyReturn (happyOut15 x))

program = happySomeParser where
  happySomeParser = happyThen (happyParse 1#) (\x -> happyReturn (happyOut23 x))

programLayout = happySomeParser where
  happySomeParser = happyThen (happyParse 2#) (\x -> happyReturn (happyOut24 x))

expr = happySomeParser where
  happySomeParser = happyThen (happyParse 3#) (\x -> happyReturn (happyOut45 x))

decl = happySomeParser where
  happySomeParser = happyThen (happyParse 4#) (\x -> happyReturn (happyOut33 x))

decls = happySomeParser where
  happySomeParser = happyThen (happyParse 5#) (\x -> happyReturn (happyOut41 x))

declsLayout = happySomeParser where
  happySomeParser = happyThen (happyParse 6#) (\x -> happyReturn (happyOut43 x))

letDecl = happySomeParser where
  happySomeParser = happyThen (happyParse 7#) (\x -> happyReturn (happyOut34 x))

repl = happySomeParser where
  happySomeParser = happyThen (happyParse 8#) (\x -> happyReturn (happyOut44 x))

schema = happySomeParser where
  happySomeParser = happyThen (happyParse 9#) (\x -> happyReturn (happyOut75 x))

modName = happySomeParser where
  happySomeParser = happyThen (happyParse 10#) (\x -> happyReturn (happyOut93 x))

helpName = happySomeParser where
  happySomeParser = happyThen (happyParse 11#) (\x -> happyReturn (happyOut95 x))

happySeq = happyDontSeq


parseModName :: String -> Maybe ModName
parseModName txt =
  case parseString defaultConfig { cfgModuleScope = False } modName txt of
    Right a -> Just (thing a)
    Left _  -> Nothing

parseHelpName :: String -> Maybe PName
parseHelpName txt =
  case parseString defaultConfig { cfgModuleScope = False } helpName txt of
    Right a -> Just (thing a)
    Left _  -> Nothing

addImplicitIncludes :: Config -> Program PName -> Program PName
addImplicitIncludes cfg (Program ds) =
  Program $ map path (cfgAutoInclude cfg) ++ ds
  where path p = Include Located { srcRange = rng, thing = p }
        rng    = Range { source = cfgSource cfg, from = start, to = start }


parseProgramWith :: Config -> Text -> Either ParseError (Program PName)
parseProgramWith cfg s = case res s of
                          Left err -> Left err
                          Right a  -> Right (addImplicitIncludes cfg a)
  where
  res = parse cfg $ case cfgLayout cfg of
                      Layout   -> programLayout
                      NoLayout -> program

parseModule :: Config -> Text -> Either ParseError (Module PName)
parseModule cfg = parse cfg { cfgModuleScope = True } vmodule

parseProgram :: Layout -> Text -> Either ParseError (Program PName)
parseProgram l = parseProgramWith defaultConfig { cfgLayout = l }

parseExprWith :: Config -> Text -> Either ParseError (Expr PName)
parseExprWith cfg = parse cfg { cfgModuleScope = False } expr

parseExpr :: Text -> Either ParseError (Expr PName)
parseExpr = parseExprWith defaultConfig

parseDeclWith :: Config -> Text -> Either ParseError (Decl PName)
parseDeclWith cfg = parse cfg { cfgModuleScope = False } decl

parseDecl :: Text -> Either ParseError (Decl PName)
parseDecl = parseDeclWith defaultConfig

parseDeclsWith :: Config -> Text -> Either ParseError [Decl PName]
parseDeclsWith cfg = parse cfg { cfgModuleScope = ms } decls'
  where (ms, decls') = case cfgLayout cfg of
                         Layout   -> (True, declsLayout)
                         NoLayout -> (False, decls)

parseDecls :: Text -> Either ParseError [Decl PName]
parseDecls = parseDeclsWith defaultConfig

parseLetDeclWith :: Config -> Text -> Either ParseError (Decl PName)
parseLetDeclWith cfg = parse cfg { cfgModuleScope = False } letDecl

parseLetDecl :: Text -> Either ParseError (Decl PName)
parseLetDecl = parseLetDeclWith defaultConfig

parseReplWith :: Config -> Text -> Either ParseError (ReplInput PName)
parseReplWith cfg = parse cfg { cfgModuleScope = False } repl

parseRepl :: Text -> Either ParseError (ReplInput PName)
parseRepl = parseReplWith defaultConfig

parseSchemaWith :: Config -> Text -> Either ParseError (Schema PName)
parseSchemaWith cfg = parse cfg { cfgModuleScope = False } schema

parseSchema :: Text -> Either ParseError (Schema PName)
parseSchema = parseSchemaWith defaultConfig

-- vim: ft=haskell
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 19 "<built-in>" #-}
{-# LINE 1 "/usr/local/Cellar/ghc/8.0.2/lib/ghc-8.0.2/include/ghcversion.h" #-}


















{-# LINE 20 "<built-in>" #-}
{-# LINE 1 "/var/folders/n8/s7z9ns8d4k39v2y_2sn__12m0000gp/T/ghc5977_0/ghc_2.h" #-}





























































































































































































































































































































































{-# LINE 21 "<built-in>" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- Id: GenericTemplate.hs,v 1.26 2005/01/14 14:47:22 simonmar Exp 


{-# LINE 13 "templates/GenericTemplate.hs" #-}





-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ > 706
#define LT(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.<# m)) :: Bool)
#define GTE(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.>=# m)) :: Bool)
#define EQ(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.==# m)) :: Bool)
#else
#define LT(n,m) (n Happy_GHC_Exts.<# m)
#define GTE(n,m) (n Happy_GHC_Exts.>=# m)
#define EQ(n,m) (n Happy_GHC_Exts.==# m)
#endif

{-# LINE 46 "templates/GenericTemplate.hs" #-}


data Happy_IntList = HappyCons Happy_GHC_Exts.Int# Happy_IntList






{-# LINE 67 "templates/GenericTemplate.hs" #-}


{-# LINE 77 "templates/GenericTemplate.hs" #-}










infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is 0#, it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept 0# tk st sts (_ `HappyStk` ans `HappyStk` _) =
        happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
        (happyTcHack j (happyTcHack st)) (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action



happyDoAction i tk st
        = {- nothing -}
          

          case action of
                0#           -> {- nothing -}
                                     happyFail i tk st
                -1#          -> {- nothing -}
                                     happyAccept i tk st
                n | LT(n,(0# :: Happy_GHC_Exts.Int#)) -> {- nothing -}
                                                   
                                                   (happyReduceArr Happy_Data_Array.! rule) i tk st
                                                   where rule = (Happy_GHC_Exts.I# ((Happy_GHC_Exts.negateInt# ((n Happy_GHC_Exts.+# (1# :: Happy_GHC_Exts.Int#))))))
                n                 -> {- nothing -}
                                     

                                     happyShift new_state i tk st
                                     where new_state = (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#))
   where off    = indexShortOffAddr happyActOffsets st
         off_i  = (off Happy_GHC_Exts.+# i)
         check  = if GTE(off_i,(0# :: Happy_GHC_Exts.Int#))
                  then EQ(indexShortOffAddr happyCheck off_i, i)
                  else False
         action
          | check     = indexShortOffAddr happyTable off_i
          | otherwise = indexShortOffAddr happyDefActions st


indexShortOffAddr (HappyA# arr) off =
        Happy_GHC_Exts.narrow16Int# i
  where
        i = Happy_GHC_Exts.word2Int# (Happy_GHC_Exts.or# (Happy_GHC_Exts.uncheckedShiftL# high 8#) low)
        high = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr (off' Happy_GHC_Exts.+# 1#)))
        low  = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr off'))
        off' = off Happy_GHC_Exts.*# 2#





data HappyAddr = HappyA# Happy_GHC_Exts.Addr#




-----------------------------------------------------------------------------
-- HappyState data type (not arrays)


{-# LINE 170 "templates/GenericTemplate.hs" #-}

-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state 0# tk st sts stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--     trace "shifting the error token" $
     happyDoAction i tk new_state (HappyCons (st) (sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state (HappyCons (st) (sts)) ((happyInTok (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_0 nt fn j tk st@((action)) sts stk
     = happyGoto nt j tk st (HappyCons (st) (sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@((HappyCons (st@(action)) (_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_2 nt fn j tk _ (HappyCons (_) (sts@((HappyCons (st@(action)) (_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_3 nt fn j tk _ (HappyCons (_) ((HappyCons (_) (sts@((HappyCons (st@(action)) (_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) sts of
         sts1@((HappyCons (st1@(action)) (_))) ->
                let r = fn stk in  -- it doesn't hurt to always seq here...
                happyDoSeq r (happyGoto nt j tk st1 sts1 r)

happyMonadReduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
          let drop_stk = happyDropStk k stk in
          happyThen1 (fn stk tk) (\r -> happyGoto nt j tk st1 sts1 (r `HappyStk` drop_stk))

happyMonad2Reduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonad2Reduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
         let drop_stk = happyDropStk k stk

             off = indexShortOffAddr happyGotoOffsets st1
             off_i = (off Happy_GHC_Exts.+# nt)
             new_state = indexShortOffAddr happyTable off_i



          in
          happyThen1 (fn stk tk) (\r -> happyNewToken new_state sts1 (r `HappyStk` drop_stk))

happyDrop 0# l = l
happyDrop n (HappyCons (_) (t)) = happyDrop (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) t

happyDropStk 0# l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n Happy_GHC_Exts.-# (1#::Happy_GHC_Exts.Int#)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction


happyGoto nt j tk st = 
   {- nothing -}
   happyDoAction j tk new_state
   where off = indexShortOffAddr happyGotoOffsets st
         off_i = (off Happy_GHC_Exts.+# nt)
         new_state = indexShortOffAddr happyTable off_i




-----------------------------------------------------------------------------
-- Error recovery (0# is the error token)

-- parse error if we are in recovery and we fail again
happyFail 0# tk old_st _ stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--      trace "failing" $ 
        happyError_ i tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  0# tk old_st (HappyCons ((action)) (sts)) 
                                                (saved_tok `HappyStk` _ `HappyStk` stk) =
--      trace ("discarding state, depth " ++ show (length stk))  $
        happyDoAction 0# tk action sts ((saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail  i tk (action) sts stk =
--      trace "entering error recovery" $
        happyDoAction 0# tk action sts ( (Happy_GHC_Exts.unsafeCoerce# (Happy_GHC_Exts.I# (i))) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll :: a
notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions


happyTcHack :: Happy_GHC_Exts.Int# -> a -> a
happyTcHack x y = y
{-# INLINE happyTcHack #-}


-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--      happySeq = happyDoSeq
-- otherwise it emits
--      happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.


{-# NOINLINE happyDoAction #-}
{-# NOINLINE happyTable #-}
{-# NOINLINE happyCheck #-}
{-# NOINLINE happyActOffsets #-}
{-# NOINLINE happyGotoOffsets #-}
{-# NOINLINE happyDefActions #-}

{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.

