{-# OPTIONS_GHC -w #-}
{-# OPTIONS -fglasgow-exts -cpp #-}
-- |
-- Module      :  $Header$
-- Copyright   :  (c) 2013-2016 Galois, Inc.
-- License     :  BSD3
-- Maintainer  :  cryptol@galois.com
-- Stability   :  provisional
-- Portability :  portable

{-# LANGUAGE Trustworthy #-}
module Cryptol.Parser
  ( parseModule
  , parseProgram, parseProgramWith
  , parseExpr, parseExprWith
  , parseDecl, parseDeclWith
  , parseDecls, parseDeclsWith
  , parseLetDecl, parseLetDeclWith
  , parseRepl, parseReplWith
  , parseSchema, parseSchemaWith
  , parseModName, parseHelpName
  , ParseError(..), ppError
  , Layout(..)
  , Config(..), defaultConfig
  , guessPreProc, PreProc(..)
  ) where

import           Control.Applicative as A
import           Data.Maybe(fromMaybe)
import           Data.Text.Lazy (Text)
import qualified Data.Text.Lazy as T
import qualified Data.Text as ST
import           Control.Monad(liftM2,msum)

import Cryptol.Prims.Syntax
import Cryptol.Parser.AST
import Cryptol.Parser.Position
import Cryptol.Parser.LexerUtils
import Cryptol.Parser.ParserUtils
import Cryptol.Parser.Unlit(PreProc(..), guessPreProc)
import Cryptol.Utils.Ident (packIdent,packInfix)

import Paths_cryptol
import qualified Data.Array as Happy_Data_Array
import qualified GHC.Exts as Happy_GHC_Exts
import Control.Applicative(Applicative(..))
import Control.Monad (ap)

-- parser produced by Happy Version 1.19.5

newtype HappyAbsSyn t67 = HappyAbsSyn HappyAny
#if __GLASGOW_HASKELL__ >= 607
type HappyAny = Happy_GHC_Exts.Any
#else
type HappyAny = forall a . a
#endif
happyIn15 :: (Module PName) -> (HappyAbsSyn t67)
happyIn15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn15 #-}
happyOut15 :: (HappyAbsSyn t67) -> (Module PName)
happyOut15 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut15 #-}
happyIn16 :: (([Located Import], [TopDecl PName])) -> (HappyAbsSyn t67)
happyIn16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn16 #-}
happyOut16 :: (HappyAbsSyn t67) -> (([Located Import], [TopDecl PName]))
happyOut16 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut16 #-}
happyIn17 :: ([Located Import]) -> (HappyAbsSyn t67)
happyIn17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn17 #-}
happyOut17 :: (HappyAbsSyn t67) -> ([Located Import])
happyOut17 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut17 #-}
happyIn18 :: (Located Import) -> (HappyAbsSyn t67)
happyIn18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn18 #-}
happyOut18 :: (HappyAbsSyn t67) -> (Located Import)
happyOut18 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut18 #-}
happyIn19 :: (Maybe (Located ModName)) -> (HappyAbsSyn t67)
happyIn19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn19 #-}
happyOut19 :: (HappyAbsSyn t67) -> (Maybe (Located ModName))
happyOut19 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut19 #-}
happyIn20 :: (Maybe (Located ImportSpec)) -> (HappyAbsSyn t67)
happyIn20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn20 #-}
happyOut20 :: (HappyAbsSyn t67) -> (Maybe (Located ImportSpec))
happyOut20 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut20 #-}
happyIn21 :: ([LIdent]) -> (HappyAbsSyn t67)
happyIn21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn21 #-}
happyOut21 :: (HappyAbsSyn t67) -> ([LIdent])
happyOut21 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut21 #-}
happyIn22 :: ([Ident] -> ImportSpec) -> (HappyAbsSyn t67)
happyIn22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn22 #-}
happyOut22 :: (HappyAbsSyn t67) -> ([Ident] -> ImportSpec)
happyOut22 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut22 #-}
happyIn23 :: (Program PName) -> (HappyAbsSyn t67)
happyIn23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn23 #-}
happyOut23 :: (HappyAbsSyn t67) -> (Program PName)
happyOut23 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut23 #-}
happyIn24 :: (Program PName) -> (HappyAbsSyn t67)
happyIn24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn24 #-}
happyOut24 :: (HappyAbsSyn t67) -> (Program PName)
happyOut24 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut24 #-}
happyIn25 :: ([TopDecl PName]) -> (HappyAbsSyn t67)
happyIn25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn25 #-}
happyOut25 :: (HappyAbsSyn t67) -> ([TopDecl PName])
happyOut25 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut25 #-}
happyIn26 :: ([TopDecl PName]) -> (HappyAbsSyn t67)
happyIn26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn26 #-}
happyOut26 :: (HappyAbsSyn t67) -> ([TopDecl PName])
happyOut26 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut26 #-}
happyIn27 :: ([TopDecl PName]) -> (HappyAbsSyn t67)
happyIn27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn27 #-}
happyOut27 :: (HappyAbsSyn t67) -> ([TopDecl PName])
happyOut27 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut27 #-}
happyIn28 :: ([TopDecl PName]) -> (HappyAbsSyn t67)
happyIn28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn28 #-}
happyOut28 :: (HappyAbsSyn t67) -> ([TopDecl PName])
happyOut28 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut28 #-}
happyIn29 :: ([TopDecl PName]) -> (HappyAbsSyn t67)
happyIn29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn29 #-}
happyOut29 :: (HappyAbsSyn t67) -> ([TopDecl PName])
happyOut29 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut29 #-}
happyIn30 :: ([TopDecl PName]) -> (HappyAbsSyn t67)
happyIn30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn30 #-}
happyOut30 :: (HappyAbsSyn t67) -> ([TopDecl PName])
happyOut30 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut30 #-}
happyIn31 :: (Located String) -> (HappyAbsSyn t67)
happyIn31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn31 #-}
happyOut31 :: (HappyAbsSyn t67) -> (Located String)
happyOut31 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut31 #-}
happyIn32 :: (Maybe (Located String)) -> (HappyAbsSyn t67)
happyIn32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn32 #-}
happyOut32 :: (HappyAbsSyn t67) -> (Maybe (Located String))
happyOut32 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut32 #-}
happyIn33 :: (Decl PName) -> (HappyAbsSyn t67)
happyIn33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn33 #-}
happyOut33 :: (HappyAbsSyn t67) -> (Decl PName)
happyOut33 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut33 #-}
happyIn34 :: (Decl PName) -> (HappyAbsSyn t67)
happyIn34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn34 #-}
happyOut34 :: (HappyAbsSyn t67) -> (Decl PName)
happyOut34 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut34 #-}
happyIn35 :: (Newtype PName) -> (HappyAbsSyn t67)
happyIn35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn35 #-}
happyOut35 :: (HappyAbsSyn t67) -> (Newtype PName)
happyOut35 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut35 #-}
happyIn36 :: ([Named (Type PName)]) -> (HappyAbsSyn t67)
happyIn36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn36 #-}
happyOut36 :: (HappyAbsSyn t67) -> ([Named (Type PName)])
happyOut36 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut36 #-}
happyIn37 :: ([ LPName ]) -> (HappyAbsSyn t67)
happyIn37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn37 #-}
happyOut37 :: (HappyAbsSyn t67) -> ([ LPName ])
happyOut37 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut37 #-}
happyIn38 :: (LPName) -> (HappyAbsSyn t67)
happyIn38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn38 #-}
happyOut38 :: (HappyAbsSyn t67) -> (LPName)
happyOut38 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut38 #-}
happyIn39 :: ([Pattern PName]) -> (HappyAbsSyn t67)
happyIn39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn39 #-}
happyOut39 :: (HappyAbsSyn t67) -> ([Pattern PName])
happyOut39 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut39 #-}
happyIn40 :: ([Decl PName]) -> (HappyAbsSyn t67)
happyIn40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn40 #-}
happyOut40 :: (HappyAbsSyn t67) -> ([Decl PName])
happyOut40 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut40 #-}
happyIn41 :: ([Decl PName]) -> (HappyAbsSyn t67)
happyIn41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn41 #-}
happyOut41 :: (HappyAbsSyn t67) -> ([Decl PName])
happyOut41 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut41 #-}
happyIn42 :: ([Decl PName]) -> (HappyAbsSyn t67)
happyIn42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn42 #-}
happyOut42 :: (HappyAbsSyn t67) -> ([Decl PName])
happyOut42 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut42 #-}
happyIn43 :: (ReplInput PName) -> (HappyAbsSyn t67)
happyIn43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn43 #-}
happyOut43 :: (HappyAbsSyn t67) -> (ReplInput PName)
happyOut43 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut43 #-}
happyIn44 :: (Expr PName) -> (HappyAbsSyn t67)
happyIn44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn44 #-}
happyOut44 :: (HappyAbsSyn t67) -> (Expr PName)
happyOut44 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut44 #-}
happyIn45 :: ([(Expr PName, Expr PName)]) -> (HappyAbsSyn t67)
happyIn45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn45 #-}
happyOut45 :: (HappyAbsSyn t67) -> ([(Expr PName, Expr PName)])
happyOut45 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut45 #-}
happyIn46 :: ((Expr PName, Expr PName)) -> (HappyAbsSyn t67)
happyIn46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn46 #-}
happyOut46 :: (HappyAbsSyn t67) -> ((Expr PName, Expr PName))
happyOut46 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut46 #-}
happyIn47 :: (Expr PName) -> (HappyAbsSyn t67)
happyIn47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn47 #-}
happyOut47 :: (HappyAbsSyn t67) -> (Expr PName)
happyOut47 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut47 #-}
happyIn48 :: (Expr PName) -> (HappyAbsSyn t67)
happyIn48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn48 #-}
happyOut48 :: (HappyAbsSyn t67) -> (Expr PName)
happyOut48 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut48 #-}
happyIn49 :: (Expr PName) -> (HappyAbsSyn t67)
happyIn49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn49 #-}
happyOut49 :: (HappyAbsSyn t67) -> (Expr PName)
happyOut49 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut49 #-}
happyIn50 :: (Expr PName) -> (HappyAbsSyn t67)
happyIn50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn50 #-}
happyOut50 :: (HappyAbsSyn t67) -> (Expr PName)
happyOut50 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut50 #-}
happyIn51 :: (LPName) -> (HappyAbsSyn t67)
happyIn51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn51 #-}
happyOut51 :: (HappyAbsSyn t67) -> (LPName)
happyOut51 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut51 #-}
happyIn52 :: (LPName) -> (HappyAbsSyn t67)
happyIn52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn52 #-}
happyOut52 :: (HappyAbsSyn t67) -> (LPName)
happyOut52 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut52 #-}
happyIn53 :: ([LPName]) -> (HappyAbsSyn t67)
happyIn53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn53 #-}
happyOut53 :: (HappyAbsSyn t67) -> ([LPName])
happyOut53 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut53 #-}
happyIn54 :: ([Expr PName]) -> (HappyAbsSyn t67)
happyIn54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn54 #-}
happyOut54 :: (HappyAbsSyn t67) -> ([Expr PName])
happyOut54 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut54 #-}
happyIn55 :: (Expr PName) -> (HappyAbsSyn t67)
happyIn55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn55 #-}
happyOut55 :: (HappyAbsSyn t67) -> (Expr PName)
happyOut55 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut55 #-}
happyIn56 :: ([(Bool, Integer)]) -> (HappyAbsSyn t67)
happyIn56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn56 #-}
happyOut56 :: (HappyAbsSyn t67) -> ([(Bool, Integer)])
happyOut56 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut56 #-}
happyIn57 :: ((Bool, Integer)) -> (HappyAbsSyn t67)
happyIn57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn57 #-}
happyOut57 :: (HappyAbsSyn t67) -> ((Bool, Integer))
happyOut57 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut57 #-}
happyIn58 :: (Located Selector) -> (HappyAbsSyn t67)
happyIn58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn58 #-}
happyOut58 :: (HappyAbsSyn t67) -> (Located Selector)
happyOut58 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut58 #-}
happyIn59 :: ([Expr PName]) -> (HappyAbsSyn t67)
happyIn59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn59 #-}
happyOut59 :: (HappyAbsSyn t67) -> ([Expr PName])
happyOut59 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut59 #-}
happyIn60 :: (Named (Expr PName)) -> (HappyAbsSyn t67)
happyIn60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn60 #-}
happyOut60 :: (HappyAbsSyn t67) -> (Named (Expr PName))
happyOut60 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut60 #-}
happyIn61 :: ([Named (Expr PName)]) -> (HappyAbsSyn t67)
happyIn61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn61 #-}
happyOut61 :: (HappyAbsSyn t67) -> ([Named (Expr PName)])
happyOut61 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut61 #-}
happyIn62 :: (Expr PName) -> (HappyAbsSyn t67)
happyIn62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn62 #-}
happyOut62 :: (HappyAbsSyn t67) -> (Expr PName)
happyOut62 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut62 #-}
happyIn63 :: ([[Match PName]]) -> (HappyAbsSyn t67)
happyIn63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn63 #-}
happyOut63 :: (HappyAbsSyn t67) -> ([[Match PName]])
happyOut63 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut63 #-}
happyIn64 :: ([Match PName]) -> (HappyAbsSyn t67)
happyIn64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn64 #-}
happyOut64 :: (HappyAbsSyn t67) -> ([Match PName])
happyOut64 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut64 #-}
happyIn65 :: (Match PName) -> (HappyAbsSyn t67)
happyIn65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn65 #-}
happyOut65 :: (HappyAbsSyn t67) -> (Match PName)
happyOut65 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut65 #-}
happyIn66 :: (Pattern PName) -> (HappyAbsSyn t67)
happyIn66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn66 #-}
happyOut66 :: (HappyAbsSyn t67) -> (Pattern PName)
happyOut66 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut66 #-}
happyIn67 :: t67 -> (HappyAbsSyn t67)
happyIn67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn67 #-}
happyOut67 :: (HappyAbsSyn t67) -> t67
happyOut67 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut67 #-}
happyIn68 :: (Pattern PName) -> (HappyAbsSyn t67)
happyIn68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn68 #-}
happyOut68 :: (HappyAbsSyn t67) -> (Pattern PName)
happyOut68 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut68 #-}
happyIn69 :: ([Pattern PName]) -> (HappyAbsSyn t67)
happyIn69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn69 #-}
happyOut69 :: (HappyAbsSyn t67) -> ([Pattern PName])
happyOut69 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut69 #-}
happyIn70 :: (Named (Pattern PName)) -> (HappyAbsSyn t67)
happyIn70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn70 #-}
happyOut70 :: (HappyAbsSyn t67) -> (Named (Pattern PName))
happyOut70 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut70 #-}
happyIn71 :: ([Named (Pattern PName)]) -> (HappyAbsSyn t67)
happyIn71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn71 #-}
happyOut71 :: (HappyAbsSyn t67) -> ([Named (Pattern PName)])
happyOut71 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut71 #-}
happyIn72 :: (Schema PName) -> (HappyAbsSyn t67)
happyIn72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn72 #-}
happyOut72 :: (HappyAbsSyn t67) -> (Schema PName)
happyOut72 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut72 #-}
happyIn73 :: (Located [TParam PName]) -> (HappyAbsSyn t67)
happyIn73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn73 #-}
happyOut73 :: (HappyAbsSyn t67) -> (Located [TParam PName])
happyOut73 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut73 #-}
happyIn74 :: (Located [Prop PName]) -> (HappyAbsSyn t67)
happyIn74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn74 #-}
happyOut74 :: (HappyAbsSyn t67) -> (Located [Prop PName])
happyOut74 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut74 #-}
happyIn75 :: (Located Kind) -> (HappyAbsSyn t67)
happyIn75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn75 #-}
happyOut75 :: (HappyAbsSyn t67) -> (Located Kind)
happyOut75 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut75 #-}
happyIn76 :: (TParam PName) -> (HappyAbsSyn t67)
happyIn76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn76 #-}
happyOut76 :: (HappyAbsSyn t67) -> (TParam PName)
happyOut76 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut76 #-}
happyIn77 :: ([TParam PName]) -> (HappyAbsSyn t67)
happyIn77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn77 #-}
happyOut77 :: (HappyAbsSyn t67) -> ([TParam PName])
happyOut77 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut77 #-}
happyIn78 :: (TParam PName) -> (HappyAbsSyn t67)
happyIn78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn78 #-}
happyOut78 :: (HappyAbsSyn t67) -> (TParam PName)
happyOut78 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut78 #-}
happyIn79 :: ([TParam PName]) -> (HappyAbsSyn t67)
happyIn79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn79 #-}
happyOut79 :: (HappyAbsSyn t67) -> ([TParam PName])
happyOut79 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut79 #-}
happyIn80 :: (Type PName) -> (HappyAbsSyn t67)
happyIn80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn80 #-}
happyOut80 :: (HappyAbsSyn t67) -> (Type PName)
happyOut80 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut80 #-}
happyIn81 :: (Type PName) -> (HappyAbsSyn t67)
happyIn81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn81 #-}
happyOut81 :: (HappyAbsSyn t67) -> (Type PName)
happyOut81 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut81 #-}
happyIn82 :: (Type PName) -> (HappyAbsSyn t67)
happyIn82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn82 #-}
happyOut82 :: (HappyAbsSyn t67) -> (Type PName)
happyOut82 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut82 #-}
happyIn83 :: ([ Type PName ]) -> (HappyAbsSyn t67)
happyIn83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn83 #-}
happyOut83 :: (HappyAbsSyn t67) -> ([ Type PName ])
happyOut83 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut83 #-}
happyIn84 :: (Located [Type PName]) -> (HappyAbsSyn t67)
happyIn84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn84 #-}
happyOut84 :: (HappyAbsSyn t67) -> (Located [Type PName])
happyOut84 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut84 #-}
happyIn85 :: ([Type PName]) -> (HappyAbsSyn t67)
happyIn85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn85 #-}
happyOut85 :: (HappyAbsSyn t67) -> ([Type PName])
happyOut85 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut85 #-}
happyIn86 :: (Named (Type PName)) -> (HappyAbsSyn t67)
happyIn86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn86 #-}
happyOut86 :: (HappyAbsSyn t67) -> (Named (Type PName))
happyOut86 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut86 #-}
happyIn87 :: ([Named (Type PName)]) -> (HappyAbsSyn t67)
happyIn87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn87 #-}
happyOut87 :: (HappyAbsSyn t67) -> ([Named (Type PName)])
happyOut87 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut87 #-}
happyIn88 :: (Located Ident) -> (HappyAbsSyn t67)
happyIn88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn88 #-}
happyOut88 :: (HappyAbsSyn t67) -> (Located Ident)
happyOut88 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut88 #-}
happyIn89 :: (LPName) -> (HappyAbsSyn t67)
happyIn89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn89 #-}
happyOut89 :: (HappyAbsSyn t67) -> (LPName)
happyOut89 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut89 #-}
happyIn90 :: (Located ModName) -> (HappyAbsSyn t67)
happyIn90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn90 #-}
happyOut90 :: (HappyAbsSyn t67) -> (Located ModName)
happyOut90 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut90 #-}
happyIn91 :: (Located PName) -> (HappyAbsSyn t67)
happyIn91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn91 #-}
happyOut91 :: (HappyAbsSyn t67) -> (Located PName)
happyOut91 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut91 #-}
happyIn92 :: (Located PName) -> (HappyAbsSyn t67)
happyIn92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn92 #-}
happyOut92 :: (HappyAbsSyn t67) -> (Located PName)
happyOut92 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut92 #-}
happyIn93 :: (Type PName) -> (HappyAbsSyn t67)
happyIn93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn93 #-}
happyOut93 :: (HappyAbsSyn t67) -> (Type PName)
happyOut93 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut93 #-}
happyIn94 :: (Named (Type PName)) -> (HappyAbsSyn t67)
happyIn94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn94 #-}
happyOut94 :: (HappyAbsSyn t67) -> (Named (Type PName))
happyOut94 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut94 #-}
happyIn95 :: ([Named (Type PName)]) -> (HappyAbsSyn t67)
happyIn95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyIn95 #-}
happyOut95 :: (HappyAbsSyn t67) -> ([Named (Type PName)])
happyOut95 x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOut95 #-}
happyInTok :: (Located Token) -> (HappyAbsSyn t67)
happyInTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyInTok #-}
happyOutTok :: (HappyAbsSyn t67) -> (Located Token)
happyOutTok x = Happy_GHC_Exts.unsafeCoerce# x
{-# INLINE happyOutTok #-}


happyActOffsets :: HappyAddr
happyActOffsets = HappyA# "\xf9\xff\x8d\x01\x9a\x03\x95\x02\xa4\x06\xa4\x06\x99\x03\xb4\x03\x66\x02\xe6\x05\xfd\x06\xd1\x02\xb1\x03\xfd\x06\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x82\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xea\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x82\x03\x00\x00\x82\x03\xcd\x05\xcd\x05\x18\x08\x8c\x03\x00\x00\xb4\x05\x9b\x05\x00\x00\x00\x00\x82\x05\xba\x04\xc2\x06\x00\x00\x00\x00\x6e\x03\x9d\x03\x00\x00\x00\x00\x0a\x08\x00\x00\x81\x07\x7b\x03\x00\x00\x00\x00\x00\x00\x00\x00\x47\x07\x95\x02\x37\x02\xf9\x00\x2a\x04\x05\x00\x9a\x07\x47\x07\xae\x02\xae\x02\x5f\x03\x5f\x03\x0e\x06\x72\x03\x8c\x00\x00\x00\xa1\x01\x46\x06\x12\x03\x98\x03\x8e\x03\x84\x03\x52\x07\x3e\x07\xdd\x02\xfc\x03\x00\x00\x4e\x03\xf5\xff\x4e\x03\xf0\x01\x4e\x03\x79\x01\x64\x03\x00\x00\x00\x00\x63\x03\x00\x00\x74\x03\x00\x00\x39\x03\xb5\x01\x45\x03\x40\x00\x00\x00\x25\x00\x00\x00\x00\x00\x00\x00\x90\x06\xd4\x01\x00\x00\xfd\x06\x41\x03\x00\x00\xa4\x05\x00\x00\x4a\x03\x15\x02\x00\x00\x82\x00\x00\x00\xe5\x01\x43\x03\x00\x00\x34\x03\x42\x03\xe4\xff\x00\x00\x2c\x03\x00\x00\x25\x07\x00\x00\xa3\x00\x36\x00\x00\x00\x0e\x05\x2c\x05\x2c\x05\x2c\x05\x11\x07\x00\x00\x47\x07\x95\x02\x13\x03\x8b\x05\x69\x05\x00\x00\x00\x00\xf4\x01\x00\x00\x00\x00\x00\x00\x08\x07\x00\x00\x00\x00\x00\x00\x50\x05\xa1\x04\x7a\x00\x00\x00\x00\x00\xf6\x02\x00\x00\x00\x00\xcd\x01\xf4\x06\x00\x00\xe1\x01\x0d\x03\x21\x03\x00\x00\xae\x02\xae\x02\x36\x02\x02\x03\xe8\x02\x00\x00\xf4\x00\xc3\x00\x00\x00\xf8\x02\x47\x07\xcb\x07\xce\x02\xae\x02\x50\x05\x00\x00\xc6\x01\x00\x00\xbc\x01\xbf\x02\x90\x07\xa7\x05\x1e\x03\x00\x00\x97\x03\x43\x05\x00\x00\x37\x05\x00\x00\x1e\x05\x00\x00\x1e\x05\x1e\x05\x1e\x05\x00\x00\x2c\x05\x1e\x05\x18\x08\xde\x02\xda\x02\xb3\x02\x00\x00\x2c\x05\x00\x00\x2c\x05\x11\x05\x40\x02\x00\x00\x5c\x07\xb6\x02\x00\x00\x00\x00\x1e\x05\x00\x00\x1e\x05\x2b\x02\x52\x07\x00\x00\x52\x07\x00\x00\x2c\x05\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x06\x95\x02\x95\x02\x95\x02\x95\x02\x00\x00\x95\x02\x95\x02\x00\x00\x47\x07\x95\x02\x00\x00\x00\x00\x00\x00\x95\x02\xcc\x06\x95\x02\x52\x07\x00\x00\xd7\x02\x00\x00\x48\x00\xa8\x07\xa5\x01\xa7\x02\x00\x00\x5f\x01\x00\x00\xc0\x05\x00\x00\x95\x02\x7c\x06\x00\x00\x7c\x06\x00\x00\x00\x00\x00\x00\x2c\x05\x00\x00\xba\x02\x97\x02\x95\x02\x00\x00\x9b\x02\x9b\x02\x9b\x02\x00\x00\xf5\x04\x00\x00\x52\x07\x1e\x05\x00\x00\x47\x07\x00\x00\x47\x07\x00\x00\x1e\x05\x47\x07\x00\x00\x00\x00\x47\x07\x52\x07\x00\x00\x68\x06\xfa\x05\x04\x02\x00\x00\x04\x02\x00\x00\x7a\x02\x2c\x05\x04\x02\x8d\x02\x00\x00\x8c\x02\x52\x07\xe9\x06\x00\x00\x51\x02\xc9\x01\xc9\x01\x00\x00\x00\x00\x25\x00\x00\x00\x25\x00\x04\x02\xdc\x04\xb8\x06\x00\x00\x86\x01\x4d\x06\xb9\x01\x43\x02\x05\x05\x00\x00\x00\x00\xde\x00\x00\x00\x41\x06\x00\x00\x00\x00\x00\x00\x2a\x02\x2c\x05\x00\x00\x00\x00\x2c\x05\x35\x02\x00\x00\xec\x04\x2c\x05\x4a\x02\x95\x02\x00\x00\x00\x00\x00\x00\x00\x00\x52\x07\x00\x00\xec\x04\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x02\x95\x02\x4a\x02\x5f\x02\x3a\x02\x34\x02\x00\x00\x22\x02\x31\x02\x31\x02\x31\x02\x00\x00\x00\x00\x31\x02\x95\x02\x00\x00\x0c\x02\x00\x00\x00\x00\x2c\x05\x00\x00\x00\x00\x2c\x05\x2c\x05\xec\x04\x00\x00\x5c\x07\xb5\x01\x01\x02\x2c\x01\x0a\x02\x95\x02\x47\x07\x47\x07\x95\x02\x00\x00\x0a\x02\x2c\x05\xfa\x01\x00\x00\x07\x02\x00\x00\x2c\x05\x2c\x01\x00\x00\x00\x00\x00\x00\xeb\x01\x00\x00\x00\x00\x00\x00\xec\x01\x00\x00\x15\x03\x95\x02\x9e\x02\xc2\x01\x1c\x00\x00\x00\x00\x00\x69\x03\xc2\x01\xe9\x01\x95\x02\x52\x07\xd3\x04\xd0\x01\xcc\x01\x94\x01\x00\x00\xa0\x01\x00\x00\x00\x00\x00\x00\x17\x03\x00\x00\xa0\x01\x00\x00\x5e\x00\x00\x00\x00\x00\x00\x00\x52\x07\x00\x00\x00\x00"#

happyGotoOffsets :: HappyAddr
happyGotoOffsets = HappyA# "\xa3\x01\x59\x00\x8b\x01\x6d\x04\x32\x01\x05\x01\x85\x01\x76\x01\xca\x00\xd1\x07\xfe\x01\x55\x01\x00\x00\xe2\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x07\xc4\x08\x53\x01\x00\x00\x00\x00\x77\x02\x4e\x04\x00\x00\x00\x00\xb8\x08\x10\x08\x44\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xf3\x02\x00\x00\x92\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xe0\x00\x3e\x03\x61\x02\x2e\x03\x37\x00\x5d\x02\x57\x02\x2d\x01\x80\x04\xa1\x02\x00\x00\x00\x00\x2b\x00\x00\x00\x00\x00\x00\x00\x29\x01\x4a\x01\x24\x01\x00\x00\x00\x00\x00\x00\x1c\x02\xf2\x02\xa9\x02\xe2\xff\x00\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\xaf\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x13\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x27\x01\x58\x01\x00\x00\xd6\x01\x00\x00\x00\x00\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x17\x01\x00\x00\x00\x00\x00\x00\x00\x00\x35\x01\x0a\x03\xc9\x02\x27\x02\x6f\x00\x00\x00\x69\x00\x64\x04\x00\x00\xee\xff\xc4\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x51\x00\x00\x00\x00\x00\x00\x00\xac\x08\xe9\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdd\x01\xce\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbe\x00\xde\xff\x00\x00\x41\x01\xa0\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x30\x01\x00\x00\x00\x00\x10\x03\x30\x01\x00\x00\x48\x02\x00\x00\x94\x08\x00\x00\x88\x08\x7c\x08\xcf\x08\x00\x00\x30\x01\x70\x08\x30\x01\x00\x00\x00\x00\x00\x00\x00\x00\x30\x01\x00\x00\x30\x01\x30\x01\x30\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x64\x08\x00\x00\x58\x08\xdd\x07\x82\x01\x00\x00\x1e\x00\x00\x00\x30\x01\x00\x00\x00\x00\x00\x00\x00\x00\x51\x00\x54\x04\x1f\x06\xd8\x02\x36\x04\x00\x00\x26\x04\x1d\x04\x00\x00\x9c\x03\x08\x04\x00\x00\x00\x00\x00\x00\xef\x03\x51\x00\xda\x03\xf3\xff\x00\x00\x00\x00\x00\x00\x1d\x01\xfc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xfc\x00\x00\x00\x13\x06\x21\x01\x00\x00\x11\x01\x00\x00\x00\x00\x00\x00\xf5\x00\x00\x00\x00\x00\x00\x00\xd1\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa6\x00\x00\x00\xc8\x00\x4c\x08\x00\x00\x7e\x04\x00\x00\x02\x04\x00\x00\x40\x08\xab\x00\x00\x00\x00\x00\x6f\x03\xd4\xff\x00\x00\xc1\x00\x29\x00\xbb\x00\x00\x00\x99\x00\x00\x00\x00\x00\xe7\x00\x79\x00\xc4\x00\x00\x00\x00\x00\xec\x00\x87\x02\x00\x00\x00\x00\x43\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x6b\x00\x14\x01\x9f\x00\x00\x00\x87\x01\x07\x01\x00\x00\x00\x00\xb7\x07\x00\x00\x00\x00\x00\x00\x00\x00\x0e\x01\x00\x00\x00\x00\x00\x00\x00\x00\xda\x00\x00\x00\x00\x00\xda\x00\x00\x00\x00\x00\x34\x08\xd2\x00\x00\x00\xc1\x03\x00\x00\x00\x00\x00\x00\x00\x00\x4a\x00\x00\x00\x28\x08\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xa3\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x93\x03\x00\x00\x00\x00\x00\x00\x00\x00\xc9\x00\x00\x00\x00\x00\xc9\x00\xc9\x00\x1c\x08\x00\x00\x00\x00\x01\x00\x00\x00\x42\x00\x00\x00\x8a\x03\xd9\x05\x2f\x04\x75\x03\x00\x00\x00\x00\xb0\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb0\x00\x32\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x51\x00\x5c\x03\xa6\x00\x8a\x00\x00\x00\x00\x00\x00\x00\xc5\x02\x18\x00\x00\x00\x47\x03\xfb\xff\xaa\x07\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xbf\xff\x00\x00\x00\x00"#

happyDefActions :: HappyAddr
happyDefActions = HappyA# "\x00\x00\xc5\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x14\xff\x94\xff\x1a\xff\x17\xff\x15\xff\x00\x00\x1f\xff\x16\xff\x1c\xff\x1b\xff\x1d\xff\x1e\xff\x00\x00\x90\xff\x91\xff\x8d\xff\x8f\xff\x8e\xff\x8c\xff\x92\xff\x93\xff\x19\xff\x00\x00\x18\xff\x00\x00\x00\x00\x00\x00\x49\xff\x36\xff\x33\xff\x00\x00\x32\xff\x31\xff\x30\xff\x00\x00\x00\x00\x00\x00\x29\xff\xa7\xff\x00\x00\xa8\xff\xa6\xff\x9e\xff\x9b\xff\x99\xff\x97\xff\x89\xff\x87\xff\x86\xff\x85\xff\x84\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb5\xff\x00\x00\x00\x00\xb3\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x57\xff\x00\x00\x00\x00\x00\x00\xc5\xff\x00\x00\xc5\xff\x00\x00\xcc\xff\xc6\xff\x00\x00\xce\xff\x00\x00\xc7\xff\x00\x00\xc5\xff\x00\x00\xef\xff\xea\xff\xee\xff\xd9\xff\xcf\xff\xd0\xff\xc6\xff\x00\x00\xd6\xff\x00\x00\x1d\xff\xcd\xff\x00\x00\xdb\xff\x00\x00\x00\x00\xdc\xff\x00\x00\x4b\xff\x00\x00\x00\x00\x50\xff\x00\x00\x00\x00\x5b\xff\x59\xff\x00\x00\x58\xff\x00\x00\x56\xff\x00\x00\x00\x00\x53\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xb1\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xaf\xff\xad\xff\x00\x00\xa9\xff\x95\xff\x96\xff\x00\x00\x12\xff\x7c\xff\x11\xff\x00\x00\x00\x00\x00\x00\x77\xff\x75\xff\x74\xff\x79\xff\x6c\xff\x00\x00\x00\x00\x80\xff\x00\x00\x00\x00\x00\x00\x81\xff\x8f\xff\x8e\xff\x69\xff\x68\xff\x00\x00\x7e\xff\x00\x00\x00\x00\xa1\xff\x00\x00\x58\xff\x00\x00\x88\xff\x00\x00\x00\x00\x3e\xff\x00\x00\x21\xff\x00\x00\x40\xff\x45\xff\x00\x00\x00\x00\x2d\xff\x00\x00\x00\x00\x28\xff\x34\xff\x32\xff\x00\x00\x35\xff\x00\x00\x00\x00\x00\x00\x43\xff\x47\xff\x00\x00\x48\xff\x00\x00\x00\x00\x00\x00\x13\xff\x46\xff\x37\xff\x38\xff\x00\x00\x00\x00\x27\xff\x26\xff\x00\x00\x2b\xff\x2c\xff\x00\x00\x2e\xff\x00\x00\x00\x00\x00\x00\x2a\xff\x00\x00\x44\xff\x9a\xff\x98\xff\x7b\xff\x72\xff\x71\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x7d\xff\x00\x00\x67\xff\x63\xff\x00\x00\x00\x00\x82\xff\x7a\xff\x83\xff\x00\x00\x00\x00\x00\x00\x00\x00\x7f\xff\x00\x00\x78\xff\x00\x00\x00\x00\x00\x00\x1a\xff\x0a\xff\x00\x00\x0f\xff\x00\x00\xb0\xff\x00\x00\x00\x00\xaa\xff\x00\x00\xc4\xff\xb4\xff\xb3\xff\x00\x00\xae\xff\xc3\xff\x00\x00\x00\x00\x8b\xff\xbc\xff\xbe\xff\xbd\xff\x3a\xff\x00\x00\x3c\xff\x00\x00\x00\x00\x51\xff\x00\x00\x52\xff\x00\x00\x54\xff\x00\x00\x00\x00\x55\xff\xb2\xff\x00\x00\x00\x00\x4f\xff\x00\x00\x00\x00\xc5\xff\xdd\xff\xc5\xff\xda\xff\x00\x00\x00\x00\xc5\xff\xe7\xff\xd1\xff\x00\x00\x00\x00\x00\x00\xd5\xff\x1d\xff\xc5\xff\xc5\xff\xf2\xff\xec\xff\xf1\xff\xeb\xff\xf0\xff\xc5\xff\x00\x00\x00\x00\xd4\xff\xe0\xff\x00\x00\x00\x00\x00\x00\x00\x00\xd8\xff\xd7\xff\x00\x00\xa3\xff\x00\x00\xa5\xff\x4a\xff\x4c\xff\x5a\xff\x5c\xff\x4e\xff\x4d\xff\xc0\xff\x00\x00\x39\xff\x00\x00\x00\x00\xc2\xff\x00\x00\xac\xff\xab\xff\x9c\xff\x10\xff\x00\x00\x0e\xff\x00\x00\x0c\xff\x0d\xff\x76\xff\x73\xff\x6b\xff\x6e\xff\x00\x00\x70\xff\x70\xff\x6a\xff\x61\xff\x5f\xff\x00\x00\x66\xff\x6f\xff\x9f\xff\xa0\xff\x9d\xff\xbb\xff\x00\x00\x3d\xff\x40\xff\x20\xff\x3f\xff\x22\xff\x41\xff\x42\xff\x24\xff\x23\xff\x00\x00\x2f\xff\x25\xff\xc5\xff\x00\x00\x00\x00\xba\xff\x00\x00\x00\x00\x00\x00\x65\xff\x62\xff\x6d\xff\x0b\xff\x00\x00\x09\xff\xc1\xff\x8a\xff\xbf\xff\x00\x00\xa4\xff\xa2\xff\xc9\xff\x00\x00\xcb\xff\xe8\xff\xe9\xff\x00\x00\xe1\xff\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xca\xff\xb9\xff\x00\x00\x00\x00\xd2\xff\x00\x00\xe2\xff\x00\x00\x00\x00\x64\xff\x60\xff\x5e\xff\x5d\xff\xf3\xff\x3b\xff\xc8\xff\x00\x00\xe3\xff\xd3\xff\xb8\xff\x00\x00\xb7\xff\xb6\xff\xe6\xff\x00\x00\xe4\xff"#

happyCheck :: HappyAddr
happyCheck = HappyA# "\xff\xff\x06\x00\x01\x00\x02\x00\x03\x00\x17\x00\x01\x00\x12\x00\x49\x00\x2b\x00\x11\x00\x37\x00\x0b\x00\x0c\x00\x2a\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x01\x00\x02\x00\x03\x00\x16\x00\x17\x00\x37\x00\x38\x00\x37\x00\x17\x00\x49\x00\x0b\x00\x0c\x00\x2d\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x03\x00\x49\x00\x2f\x00\x16\x00\x17\x00\x49\x00\x27\x00\x15\x00\x0b\x00\x0c\x00\x3b\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x35\x00\x49\x00\x4a\x00\x16\x00\x17\x00\x12\x00\x49\x00\x12\x00\x22\x00\x16\x00\x17\x00\x16\x00\x17\x00\x1a\x00\x49\x00\x1a\x00\x03\x00\x22\x00\x35\x00\x01\x00\x49\x00\x4a\x00\x30\x00\x31\x00\x0b\x00\x0c\x00\x1a\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x31\x00\x21\x00\x35\x00\x16\x00\x17\x00\x3d\x00\x49\x00\x4a\x00\x35\x00\x17\x00\x35\x00\x08\x00\x22\x00\x0a\x00\x2d\x00\x2e\x00\x0d\x00\x49\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x49\x00\x4a\x00\x3c\x00\x16\x00\x17\x00\x31\x00\x49\x00\x4a\x00\x49\x00\x4a\x00\x0b\x00\x0c\x00\x35\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x3c\x00\x21\x00\x49\x00\x16\x00\x17\x00\x25\x00\x0b\x00\x0c\x00\x35\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x49\x00\x4a\x00\x35\x00\x16\x00\x17\x00\x0b\x00\x0c\x00\x49\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x4f\x00\x49\x00\x4a\x00\x16\x00\x17\x00\x35\x00\x15\x00\x35\x00\x27\x00\x49\x00\x4a\x00\x35\x00\x0c\x00\x24\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x32\x00\x21\x00\x35\x00\x16\x00\x17\x00\x2f\x00\x49\x00\x4a\x00\x49\x00\x4a\x00\x2a\x00\x18\x00\x49\x00\x4a\x00\x28\x00\x35\x00\x0d\x00\x1a\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x49\x00\x4a\x00\x21\x00\x16\x00\x17\x00\x0c\x00\x04\x00\x0e\x00\x0f\x00\x10\x00\x11\x00\x12\x00\x35\x00\x49\x00\x4a\x00\x16\x00\x17\x00\x12\x00\x35\x00\x25\x00\x18\x00\x16\x00\x17\x00\x16\x00\x19\x00\x49\x00\x4a\x00\x13\x00\x4c\x00\x34\x00\x35\x00\x1e\x00\x49\x00\x4a\x00\x35\x00\x3f\x00\x1c\x00\x1d\x00\x49\x00\x4a\x00\x20\x00\x21\x00\x22\x00\x23\x00\x25\x00\x49\x00\x35\x00\x27\x00\x28\x00\x35\x00\x49\x00\x4a\x00\x35\x00\x25\x00\x49\x00\x4a\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x25\x00\x22\x00\x08\x00\x09\x00\x0a\x00\x49\x00\x4a\x00\x12\x00\x49\x00\x4a\x00\x15\x00\x49\x00\x4a\x00\x25\x00\x14\x00\x30\x00\x31\x00\x17\x00\x49\x00\x19\x00\x49\x00\x4a\x00\x35\x00\x4c\x00\x12\x00\x1f\x00\x20\x00\x25\x00\x16\x00\x17\x00\x24\x00\x19\x00\x26\x00\x12\x00\x25\x00\x29\x00\x12\x00\x16\x00\x17\x00\x2d\x00\x16\x00\x17\x00\x49\x00\x4a\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x12\x00\x18\x00\x49\x00\x4a\x00\x16\x00\x17\x00\x12\x00\x35\x00\x12\x00\x18\x00\x16\x00\x17\x00\x16\x00\x17\x00\x49\x00\x4a\x00\x35\x00\x12\x00\x18\x00\x35\x00\x2a\x00\x16\x00\x17\x00\x33\x00\x34\x00\x35\x00\x36\x00\x49\x00\x4a\x00\x49\x00\x35\x00\x4b\x00\x3f\x00\x40\x00\x25\x00\x35\x00\x49\x00\x4a\x00\x35\x00\x49\x00\x4a\x00\x35\x00\x49\x00\x35\x00\x33\x00\x49\x00\x4a\x00\x35\x00\x37\x00\x23\x00\x49\x00\x4a\x00\x35\x00\x27\x00\x28\x00\x49\x00\x4a\x00\x14\x00\x49\x00\x4a\x00\x25\x00\x49\x00\x4a\x00\x49\x00\x4a\x00\x3f\x00\x40\x00\x49\x00\x4a\x00\x25\x00\x24\x00\x25\x00\x49\x00\x4a\x00\x04\x00\x49\x00\x06\x00\x21\x00\x08\x00\x09\x00\x0a\x00\x25\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x13\x00\x49\x00\x4a\x00\x05\x00\x4c\x00\x07\x00\x09\x00\x17\x00\x04\x00\x19\x00\x06\x00\x09\x00\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x49\x00\x4a\x00\x1b\x00\x4c\x00\x4d\x00\x00\x00\x17\x00\x04\x00\x19\x00\x2e\x00\x22\x00\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x12\x00\x3a\x00\x3b\x00\x21\x00\x30\x00\x31\x00\x17\x00\x04\x00\x19\x00\x2e\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x21\x00\x3a\x00\x3b\x00\x47\x00\x25\x00\x49\x00\x17\x00\x04\x00\x19\x00\x2e\x00\x07\x00\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x06\x00\x22\x00\x3b\x00\x21\x00\x12\x00\x0b\x00\x17\x00\x25\x00\x19\x00\x2e\x00\x10\x00\x30\x00\x24\x00\x21\x00\x1f\x00\x30\x00\x31\x00\x25\x00\x18\x00\x24\x00\x21\x00\x3a\x00\x20\x00\x23\x00\x25\x00\x12\x00\x04\x00\x27\x00\x28\x00\x2e\x00\x08\x00\x09\x00\x0a\x00\x12\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x23\x00\x20\x00\x21\x00\x3a\x00\x27\x00\x28\x00\x21\x00\x17\x00\x04\x00\x19\x00\x25\x00\x1f\x00\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x2a\x00\x22\x00\x49\x00\x4a\x00\x12\x00\x4c\x00\x17\x00\x12\x00\x19\x00\x2e\x00\x49\x00\x30\x00\x4b\x00\x28\x00\x1f\x00\x30\x00\x31\x00\x49\x00\x4a\x00\x24\x00\x4c\x00\x3a\x00\x49\x00\x01\x00\x4b\x00\x03\x00\x04\x00\x05\x00\x30\x00\x2e\x00\x08\x00\x09\x00\x0a\x00\x2a\x00\x22\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x1b\x00\x3a\x00\x08\x00\x09\x00\x0a\x00\x17\x00\x12\x00\x19\x00\x30\x00\x31\x00\x49\x00\x12\x00\x4b\x00\x1f\x00\x14\x00\x25\x00\x26\x00\x17\x00\x24\x00\x19\x00\x1a\x00\x1c\x00\x1d\x00\x1e\x00\x21\x00\x1f\x00\x21\x00\x1e\x00\x2e\x00\x1a\x00\x24\x00\x12\x00\x26\x00\x33\x00\x2a\x00\x29\x00\x37\x00\x37\x00\x20\x00\x2d\x00\x49\x00\x4a\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x35\x00\x36\x00\x08\x00\x09\x00\x0a\x00\x12\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x13\x00\x14\x00\x1c\x00\x1d\x00\x17\x00\x1d\x00\x19\x00\x2f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x1f\x00\x29\x00\x2a\x00\x27\x00\x28\x00\x24\x00\x43\x00\x26\x00\x2c\x00\x02\x00\x29\x00\x2f\x00\x49\x00\x4a\x00\x2d\x00\x4c\x00\x08\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x35\x00\x36\x00\x08\x00\x09\x00\x0a\x00\x49\x00\x4a\x00\x04\x00\x4c\x00\x2a\x00\x4e\x00\x08\x00\x09\x00\x0a\x00\x14\x00\x49\x00\x4a\x00\x17\x00\x4c\x00\x19\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x1f\x00\x17\x00\x08\x00\x09\x00\x0a\x00\x24\x00\x43\x00\x26\x00\x21\x00\x1f\x00\x29\x00\x28\x00\x49\x00\x4a\x00\x2d\x00\x4c\x00\x23\x00\x17\x00\x28\x00\x19\x00\x27\x00\x28\x00\x35\x00\x36\x00\x12\x00\x1f\x00\x25\x00\x28\x00\x49\x00\x4a\x00\x24\x00\x4c\x00\x26\x00\x04\x00\x05\x00\x29\x00\x01\x00\x08\x00\x09\x00\x0a\x00\x33\x00\x34\x00\x35\x00\x36\x00\x2a\x00\x04\x00\x2f\x00\x35\x00\x36\x00\x08\x00\x09\x00\x0a\x00\x17\x00\x2a\x00\x49\x00\x4a\x00\x12\x00\x4c\x00\x25\x00\x26\x00\x1f\x00\x23\x00\x49\x00\x4a\x00\x17\x00\x1d\x00\x19\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x1f\x00\x20\x00\x20\x00\x27\x00\x28\x00\x24\x00\x1a\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x2e\x00\x47\x00\x48\x00\x49\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x04\x00\x24\x00\x25\x00\x04\x00\x08\x00\x09\x00\x0a\x00\x08\x00\x09\x00\x0a\x00\x28\x00\x49\x00\x4a\x00\x21\x00\x4c\x00\x33\x00\x34\x00\x35\x00\x36\x00\x17\x00\x34\x00\x19\x00\x17\x00\x20\x00\x19\x00\x25\x00\x26\x00\x1f\x00\x24\x00\x25\x00\x1f\x00\x22\x00\x24\x00\x20\x00\x21\x00\x24\x00\x28\x00\x49\x00\x4a\x00\x28\x00\x20\x00\x21\x00\x2e\x00\x20\x00\x21\x00\x2e\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x1d\x00\x20\x00\x21\x00\x20\x00\x21\x00\x22\x00\x23\x00\x24\x00\x25\x00\x20\x00\x27\x00\x28\x00\x47\x00\x48\x00\x49\x00\x2c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x20\x00\x21\x00\x1d\x00\x27\x00\x28\x00\x20\x00\x21\x00\x22\x00\x23\x00\x28\x00\x22\x00\x04\x00\x27\x00\x28\x00\x2f\x00\x08\x00\x09\x00\x0a\x00\x3b\x00\x30\x00\x02\x00\x49\x00\x4a\x00\x1d\x00\x4c\x00\x18\x00\x20\x00\x21\x00\x22\x00\x23\x00\x17\x00\x3d\x00\x3e\x00\x27\x00\x28\x00\x01\x00\x22\x00\x49\x00\x4a\x00\x3b\x00\x4c\x00\x47\x00\x48\x00\x49\x00\x25\x00\x01\x00\x49\x00\x4a\x00\x1d\x00\x4c\x00\x22\x00\x20\x00\x21\x00\x22\x00\x23\x00\x01\x00\x3b\x00\x04\x00\x27\x00\x28\x00\x23\x00\x08\x00\x09\x00\x0a\x00\x33\x00\x34\x00\x35\x00\x49\x00\x4a\x00\x1d\x00\x4c\x00\x3b\x00\x20\x00\x21\x00\x22\x00\x23\x00\x17\x00\x12\x00\x1d\x00\x27\x00\x28\x00\x20\x00\x21\x00\x22\x00\x23\x00\x2b\x00\x49\x00\x4a\x00\x27\x00\x28\x00\x25\x00\x3b\x00\x49\x00\x4a\x00\x1d\x00\x4c\x00\x11\x00\x20\x00\x21\x00\x22\x00\x23\x00\x13\x00\x2f\x00\x2f\x00\x27\x00\x28\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\x1d\x00\x4c\x00\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x49\x00\x4a\x00\xff\xff\x27\x00\x28\x00\xff\xff\xff\xff\x49\x00\x4a\x00\x1d\x00\x4c\x00\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\xff\xff\xff\xff\x1d\x00\x27\x00\x28\x00\x20\x00\x21\x00\x22\x00\x23\x00\xff\xff\xff\xff\x04\x00\x27\x00\x28\x00\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\x1d\x00\x4c\x00\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x17\x00\xff\xff\xff\xff\x27\x00\x28\x00\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\x25\x00\xff\xff\x49\x00\x4a\x00\x1d\x00\x4c\x00\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\xff\xff\xff\xff\x04\x00\x27\x00\x28\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x33\x00\x34\x00\x35\x00\x49\x00\x4a\x00\x1d\x00\x4c\x00\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x17\x00\xff\xff\x1d\x00\x27\x00\x28\x00\x20\x00\x21\x00\x22\x00\x23\x00\xff\xff\x49\x00\x4a\x00\x27\x00\x28\x00\x25\x00\xff\xff\x49\x00\x4a\x00\x1d\x00\x4c\x00\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\xff\xff\xff\xff\xff\xff\x27\x00\x28\x00\xff\xff\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\x1d\x00\x4c\x00\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\x49\x00\x4a\x00\xff\xff\x27\x00\x28\x00\xff\xff\xff\xff\x49\x00\x4a\x00\x1d\x00\x4c\x00\xff\xff\x20\x00\x21\x00\x22\x00\x23\x00\xff\xff\xff\xff\x1d\x00\x27\x00\x28\x00\x20\x00\x21\x00\x22\x00\x23\x00\x43\x00\x44\x00\xff\xff\x27\x00\x28\x00\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\xff\xff\x01\x00\x23\x00\x03\x00\x04\x00\x05\x00\x27\x00\x28\x00\x08\x00\x09\x00\x0a\x00\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\x49\x00\x4a\x00\x17\x00\x4c\x00\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x24\x00\x25\x00\x49\x00\x4a\x00\x49\x00\x4a\x00\xff\xff\x4c\x00\xff\xff\xff\xff\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\x20\x00\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x04\x00\xff\xff\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\x17\x00\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x04\x00\xff\xff\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\x2e\x00\xff\xff\x17\x00\x28\x00\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\x17\x00\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x04\x00\xff\xff\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\x2e\x00\xff\xff\x17\x00\x28\x00\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\x17\x00\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x1a\x00\xff\xff\x1f\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x2e\x00\xff\xff\x17\x00\x28\x00\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x24\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x1a\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x24\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x04\x00\xff\xff\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\x17\x00\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x04\x00\xff\xff\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\x17\x00\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\xff\xff\xff\xff\x20\x00\x21\x00\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x24\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x20\x00\xff\xff\x2e\x00\xff\xff\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\x03\x00\x04\x00\x05\x00\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x24\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\x2e\x00\xff\xff\x17\x00\x04\x00\x19\x00\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x32\x00\x33\x00\x34\x00\x35\x00\xff\xff\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x17\x00\xff\xff\x19\x00\x2e\x00\xff\xff\x30\x00\xff\xff\xff\xff\x1f\x00\xff\xff\xff\xff\xff\xff\xff\xff\x24\x00\x20\x00\x21\x00\x22\x00\x23\x00\xff\xff\xff\xff\xff\xff\x27\x00\x28\x00\x2e\x00\xff\xff\x30\x00\x20\x00\x21\x00\x22\x00\x23\x00\xff\xff\xff\xff\x04\x00\x27\x00\x28\x00\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x04\x00\x05\x00\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\x17\x00\xff\xff\x19\x00\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x1f\x00\xff\xff\xff\xff\xff\xff\x17\x00\x24\x00\x25\x00\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x04\x00\xff\xff\x28\x00\x2e\x00\x08\x00\x09\x00\x0a\x00\xff\xff\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x17\x00\x04\x00\x19\x00\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\x25\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x0c\x00\x0d\x00\x0e\x00\x0f\x00\x24\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\xff\xff\xff\xff\x04\x00\xff\xff\x24\x00\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\xff\xff\x17\x00\xff\xff\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\x25\x00\x08\x00\x09\x00\x0a\x00\x1f\x00\xff\xff\x04\x00\x05\x00\xff\xff\x24\x00\x08\x00\x09\x00\x0a\x00\x28\x00\xff\xff\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x17\x00\x04\x00\x05\x00\xff\xff\x24\x00\x08\x00\x09\x00\x0a\x00\x28\x00\xff\xff\xff\xff\x17\x00\x04\x00\x19\x00\x2e\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x17\x00\x04\x00\xff\xff\xff\xff\x24\x00\x08\x00\x09\x00\x0a\x00\x28\x00\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\x2e\x00\xff\xff\xff\xff\xff\xff\xff\xff\x1f\x00\x17\x00\x04\x00\x19\x00\xff\xff\x24\x00\x08\x00\x09\x00\x0a\x00\x1f\x00\xff\xff\xff\xff\x2b\x00\xff\xff\x24\x00\x2e\x00\xff\xff\xff\xff\x28\x00\xff\xff\xff\xff\x17\x00\xff\xff\x19\x00\x2e\x00\xff\xff\xff\xff\x04\x00\xff\xff\x1f\x00\x20\x00\x08\x00\x09\x00\x0a\x00\x24\x00\xff\xff\x04\x00\xff\xff\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\x2e\x00\xff\xff\x17\x00\x04\x00\x19\x00\x1a\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x1f\x00\x17\x00\xff\xff\x19\x00\xff\xff\x24\x00\xff\xff\xff\xff\xff\xff\x1f\x00\xff\xff\xff\xff\x17\x00\xff\xff\x24\x00\x2e\x00\xff\xff\x12\x00\xff\xff\xff\xff\x15\x00\x16\x00\xff\xff\xff\xff\x2e\x00\x1a\x00\x1b\x00\x1c\x00\x1d\x00\x1e\x00\xff\xff\x20\x00\x21\x00\x22\x00\xff\xff\xff\xff\x25\x00\x01\x00\x02\x00\x03\x00\x04\x00\x05\x00\x2b\x00\x2c\x00\x08\x00\x09\x00\x0a\x00\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\xff\xff\xff\xff\x3b\x00\x17\x00\xff\xff\x19\x00\x01\x00\xff\xff\xff\xff\x04\x00\x05\x00\x1f\x00\xff\xff\x08\x00\x09\x00\x0a\x00\x24\x00\x3b\x00\x26\x00\xff\xff\xff\xff\x29\x00\xff\xff\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\x17\x00\x22\x00\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\xff\xff\x1f\x00\xff\xff\x2b\x00\x2c\x00\xff\xff\x24\x00\xff\xff\x30\x00\x31\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x21\x00\xff\xff\x3b\x00\x01\x00\x25\x00\xff\xff\x04\x00\xff\xff\xff\xff\xff\xff\x08\x00\x09\x00\x0a\x00\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\xff\xff\x17\x00\x39\x00\x3a\x00\x3b\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\x39\x00\x3a\x00\x3b\x00\x49\x00\x4a\x00\xff\xff\x4c\x00\xff\xff\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\x39\x00\x3a\x00\x3b\x00\x49\x00\x4a\x00\xff\xff\x4c\x00\xff\xff\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\x39\x00\x3a\x00\x3b\x00\x49\x00\x4a\x00\xff\xff\x4c\x00\xff\xff\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\x3c\x00\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\x46\x00\xff\xff\xff\xff\x49\x00\x4a\x00\x2a\x00\x4c\x00\xff\xff\xff\xff\x4f\x00\x50\x00\xff\xff\xff\xff\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\x2c\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\x46\x00\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x41\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x42\x00\x43\x00\xff\xff\x45\x00\xff\xff\xff\xff\xff\xff\x49\x00\x4a\x00\xff\xff\x4c\x00\x32\x00\x33\x00\x34\x00\x35\x00\x36\x00\x37\x00\x38\x00\x39\x00\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff"#

happyTable :: HappyAddr
happyTable = HappyA# "\x00\x00\xba\x01\x8c\x01\x6c\x00\x6d\x00\x15\x01\xa7\x00\x7e\x00\xc3\x01\xef\x00\x0e\x00\x57\x01\x6e\x00\x6f\x00\x2b\x01\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x6b\x00\x6c\x00\x6d\x00\x4f\x00\x50\x00\x7e\x00\x7f\x00\x2c\x01\xa8\x00\x80\x00\x6e\x00\x6f\x00\x6f\x01\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x44\x01\xf0\x00\x6b\x00\x4f\x00\x50\x00\x80\x00\xa9\x00\xbd\x01\x45\x01\x6f\x00\xff\xff\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x52\x00\x10\x00\x16\x01\x4f\x00\x50\x00\x99\x00\xab\x00\x99\x00\x34\x01\x4f\x00\x50\x00\x4f\x00\x50\x00\x53\x01\xbb\x01\x9a\x00\x46\x01\x34\x01\x52\x00\xa7\x00\x10\x00\x53\x00\xab\x01\x36\x01\x47\x01\x6f\x00\x26\x01\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x36\x01\x27\x01\x52\x00\x4f\x00\x50\x00\x7f\x01\x10\x00\x53\x00\x52\x00\xa8\x00\x52\x00\x60\x00\x42\x01\x61\x00\xa9\x00\xaa\x00\x62\x00\x80\x01\x63\x00\x64\x00\x65\x00\x66\x00\x10\x00\x53\x00\xb2\x01\x4f\x00\x50\x00\x43\x01\x10\x00\x53\x00\x10\x00\x53\x00\xa9\x01\x6f\x00\x52\x00\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x82\x01\xea\x00\xab\x00\x4f\x00\x50\x00\xc1\x01\x4e\x01\x6f\x00\x0f\x01\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x10\x00\x53\x00\x52\x00\x4f\x00\x50\x00\x7b\x00\x6f\x00\x96\x01\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x97\x01\x10\x00\x87\x00\x4f\x00\x50\x00\x1a\x01\xab\x01\x52\x00\x07\x01\x10\x00\x53\x00\x0f\x01\x51\x01\x32\x01\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x08\x01\x97\x00\x52\x00\x4f\x00\x50\x00\x33\x01\x10\x00\x87\x00\x10\x00\x53\x00\x98\x00\xa5\x01\x10\x00\x87\x00\xbd\x00\x52\x00\x7a\x00\x28\x01\x63\x00\x64\x00\x65\x00\x66\x00\x10\x00\x53\x00\x29\x01\x4f\x00\x50\x00\x52\x01\x4c\x01\x70\x00\x71\x00\x72\x00\x73\x00\x74\x00\x52\x00\x10\x00\x53\x00\x4f\x00\x50\x00\x4e\x00\x92\x00\xd2\x00\xf2\x00\x4f\x00\x50\x00\xf5\x00\x55\x01\x10\x00\x11\x00\x34\x00\x3d\x00\x59\x01\x85\x00\xf6\x00\x10\x00\x53\x00\x52\x00\x5f\x01\x35\x00\x36\x00\x10\x00\x87\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xd2\x00\x22\x01\x52\x00\x3b\x00\x3c\x00\x92\x00\x10\x00\x87\x00\x52\x00\x99\x01\x10\x00\x53\x00\x3f\x00\x40\x00\x41\x00\x15\x00\x16\x00\xd2\x00\x12\x01\x17\x00\x18\x00\x19\x00\x10\x00\x53\x00\x7e\x00\x10\x00\x87\x00\xf7\x00\x10\x00\x53\x00\x4f\x01\x43\x00\x9e\x01\x14\x01\x1a\x00\x5e\x01\x44\x00\x10\x00\x11\x00\xba\x00\x3d\x00\x4e\x00\x45\x00\xb1\x00\x82\x00\x4f\x00\x50\x00\x46\x00\x51\x00\x47\x00\x95\x00\xd2\x00\x48\x00\x64\x01\x4f\x00\x50\x00\x49\x00\x4f\x00\x50\x00\x10\x00\xbb\x00\x1c\x00\x1d\x00\x1e\x00\xb2\x00\xb3\x00\x21\x00\x22\x00\x23\x00\x65\x01\x01\x01\x10\x00\x4a\x01\x4f\x00\x50\x00\x3f\x01\x52\x00\x95\x00\x91\x00\x4f\x00\x50\x00\x4f\x00\x50\x00\x10\x00\x37\x01\x52\x00\x5c\x00\x9e\x00\x52\x00\x6d\x01\x4f\x00\x50\x00\x83\x00\x84\x00\x85\x00\x86\x00\x10\x00\x53\x00\x23\x00\x92\x00\xa1\x01\x20\x01\xa7\x01\xd2\x00\x52\x00\x10\x00\x53\x00\x92\x00\x10\x00\x53\x00\x52\x00\x22\x01\x52\x00\x85\x01\x10\x00\x87\x00\x92\x00\x86\x01\xee\x00\x10\x00\x87\x00\x52\x00\x3b\x00\x3c\x00\x10\x00\x53\x00\x3b\x01\x10\x00\x87\x00\x93\x00\x10\x00\x53\x00\x10\x00\x53\x00\x20\x01\x21\x01\x10\x00\x87\x00\xd2\x00\x0e\x00\x0f\x00\x10\x00\x53\x00\x15\x00\x22\x01\x68\x00\x69\x01\x17\x00\x18\x00\x19\x00\x6a\x01\x55\x00\x56\x00\x57\x00\x58\x00\x4b\x00\x10\x00\x11\x00\xa2\x01\x3d\x00\xa3\x01\xa5\x01\x1a\x00\x15\x00\x59\x00\x68\x00\x5e\x00\x17\x00\x18\x00\x19\x00\x5a\x00\x55\x00\x56\x00\x57\x00\x58\x00\x5b\x00\x10\x00\x11\x00\x4c\x00\x12\x00\x13\x00\x69\x00\x1a\x00\x15\x00\x59\x00\x5c\x00\xe5\xff\x17\x00\x18\x00\x19\x00\x5a\x00\x55\x00\x56\x00\x57\x00\x58\x00\x5b\x00\x7e\x00\x69\x00\xdf\xff\x91\x01\xe5\xff\xe5\xff\x1a\x00\x15\x00\x59\x00\x5c\x00\x76\x00\x17\x00\x18\x00\x77\x00\x5a\x00\x55\x00\x56\x00\x57\x00\x58\x00\x5b\x00\xe6\x00\x69\x00\xde\xff\x81\x01\x6c\x01\xe2\x00\x1a\x00\x15\x00\x59\x00\x5c\x00\x76\x00\x17\x00\x18\x00\x77\x00\x5a\x00\x55\x00\x56\x00\x57\x00\x58\x00\x5b\x00\x3d\x01\x34\x01\xff\xff\xea\x00\x7e\x00\x3e\x01\x1a\x00\xeb\x00\x59\x00\x5c\x00\x3f\x01\xed\xff\xad\x01\xec\x00\x5a\x00\xa1\x01\x36\x01\xed\x00\x79\x00\x5b\x00\x04\x01\x69\x00\xb9\x01\x9c\x00\x05\x01\x7e\x00\x15\x00\x3b\x00\x3c\x00\x5c\x00\x17\x00\x18\x00\x77\x00\x7e\x00\x55\x00\x56\x00\x57\x00\x58\x00\x9d\x00\x00\x01\x01\x01\x69\x00\x3b\x00\x3c\x00\x30\x01\x1a\x00\x15\x00\x59\x00\x31\x01\xb1\x01\x17\x00\x18\x00\x77\x00\x5a\x00\x55\x00\x56\x00\x57\x00\x58\x00\x5b\x00\xb2\x01\x12\x01\x10\x00\x11\x00\x7e\x00\x3d\x00\x1a\x00\x7e\x00\x59\x00\x5c\x00\x23\x00\x7d\x00\x3a\x01\x6b\x01\x5a\x00\x13\x01\x14\x01\x10\x00\x11\x00\x5b\x00\x3d\x00\x69\x00\x23\x00\x2f\x00\xd8\x00\x30\x00\x15\x00\x16\x00\xb8\x01\x5c\x00\x17\x00\x18\x00\x19\x00\x8e\x01\x34\x01\x3f\x00\x40\x00\x41\x00\x15\x00\x16\x00\x90\x01\x69\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x7e\x00\x31\x00\x35\x01\x36\x01\x23\x00\x7e\x00\x24\x00\x32\x00\x43\x00\x1c\x01\x1d\x01\x1a\x00\xca\x00\x44\x00\xb7\x00\xfa\x00\xfb\x00\xfc\x00\x91\x01\x45\x00\xfd\x00\x92\x01\x34\x00\x8a\x01\x46\x00\x7e\x00\x47\x00\x85\x01\x9c\x01\x48\x00\x2c\x01\x86\x01\xa0\x01\x49\x00\x10\x00\x8d\x00\x3f\x00\x40\x00\x41\x00\x15\x00\x16\x00\x4a\x00\x4b\x00\x17\x00\x18\x00\x19\x00\x7e\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x42\x00\x43\x00\x93\x01\x94\x01\x1a\x00\xb3\x00\x44\x00\x49\x01\x37\x00\x38\x00\x39\x00\x3a\x00\x45\x00\xa4\x00\xa5\x00\x3b\x00\x3c\x00\x46\x00\xe0\x00\x47\x00\xb4\x00\x4c\x01\x48\x00\xb5\x00\x10\x00\x11\x00\x49\x00\xcd\x00\x4e\x01\x3f\x00\x40\x00\x41\x00\x15\x00\x16\x00\x4a\x00\x4b\x00\x17\x00\x18\x00\x19\x00\x10\x00\x11\x00\x15\x00\x9f\x00\x51\x01\xa0\x00\x17\x00\x18\x00\x19\x00\x43\x00\x10\x00\x11\x00\x1a\x00\x3d\x00\x44\x00\x3f\x00\x40\x00\x41\x00\x15\x00\x16\x00\x45\x00\x1a\x00\x17\x00\x18\x00\x19\x00\x46\x00\xcf\x00\x47\x00\x62\x01\x24\x01\x48\x00\x64\x01\x10\x00\x11\x00\x49\x00\xcd\x00\x9c\x00\x1a\x00\xae\x01\x44\x00\x3b\x00\x3c\x00\x4a\x00\x4b\x00\x7e\x00\x45\x00\x82\x00\x6b\x01\x10\x00\x11\x00\x46\x00\x49\x01\x47\x00\x15\x00\x16\x00\x48\x00\x6f\x01\x17\x00\x18\x00\x19\x00\x83\x00\x84\x00\x85\x00\x86\x00\x89\x01\x15\x00\x8c\x01\x4a\x00\x4b\x00\x17\x00\x18\x00\x19\x00\x1a\x00\xe9\x00\x10\x00\x11\x00\xda\x00\x3d\x00\x1c\x01\x1e\x01\x1b\x00\xbd\x00\x10\x00\x87\x00\x1a\x00\xb7\x00\x59\x00\x7b\x01\x37\x00\x38\x00\x39\x00\x3a\x00\x89\x00\x8a\x00\xdb\x00\x3b\x00\x3c\x00\x5b\x00\xf8\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x5c\x00\xc2\x00\xbe\x01\xe2\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x15\x00\xbe\x00\x0f\x00\x15\x00\x17\x00\x18\x00\x19\x00\x17\x00\x18\x00\x19\x00\xf4\x00\x10\x00\x11\x00\xf9\x00\x3d\x00\x8a\x00\x84\x00\x85\x00\x8b\x00\x1a\x00\x06\x01\x59\x00\x1a\x00\xff\x00\x59\x00\x1c\x01\x1f\x01\x89\x00\xd7\x00\x0f\x00\x89\x00\x19\x01\x5b\x00\xc2\x01\xc3\x01\x5b\x00\x58\xff\x10\x00\x87\x00\xb0\x01\xe5\x00\xe6\x00\x5c\x00\xfe\x00\xf9\x00\x5c\x00\x58\xff\x58\xff\x58\xff\x58\xff\x58\xff\x58\xff\x58\xff\xad\x00\x2a\x01\x27\x01\x37\x00\x38\x00\x39\x00\x3a\x00\xae\x00\x0f\x00\x2e\x01\x3b\x00\x3c\x00\xc2\x00\xc3\x00\xe2\x00\xaf\x00\xb7\x00\xb8\x00\xb9\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x2d\x01\x29\x01\xbc\x01\x3b\x00\x3c\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x2f\x01\x37\x01\x15\x00\x3b\x00\x3c\x00\x3a\x01\x17\x00\x18\x00\x19\x00\xff\xff\x44\x01\x78\x00\x10\x00\x11\x00\xae\x01\x3d\x00\x79\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x1a\x00\xc0\x00\xc1\x00\x3b\x00\x3c\x00\x8f\x00\x7a\x00\x10\x00\x11\x00\xff\xff\x3d\x00\xc2\x00\xc3\x00\xc4\x00\xc0\x01\x90\x00\x10\x00\x11\x00\xb3\x01\x3d\x00\x99\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x91\x00\xff\xff\x15\x00\x3b\x00\x3c\x00\xbd\x00\x17\x00\x18\x00\x19\x00\x58\x01\x84\x00\x85\x00\x10\x00\x11\x00\xb6\x01\x3d\x00\xff\xff\x37\x00\x38\x00\x39\x00\x3a\x00\x1a\x00\x7e\x00\x8e\x01\x3b\x00\x3c\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xd2\x00\x10\x00\x87\x00\x3b\x00\x3c\x00\xe4\x00\xff\xff\x10\x00\x11\x00\x94\x01\x3d\x00\x0e\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x42\x00\x4e\x00\x60\x00\x3b\x00\x3c\x00\x74\x01\x75\x01\x76\x01\x77\x01\x84\x00\x85\x00\x00\x00\x10\x00\x11\x00\x00\x00\x3d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x98\x01\x3d\x00\x00\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x10\x00\x87\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x00\x00\x10\x00\x11\x00\x62\x01\x3d\x00\x00\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x00\x00\x00\x00\x70\x01\x3b\x00\x3c\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x00\x00\x00\x00\x15\x00\x3b\x00\x3c\x00\x00\x00\x17\x00\x18\x00\x19\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x72\x01\x3d\x00\x00\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x1a\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x3d\x00\x00\x00\x00\x00\x00\x00\x82\x00\x00\x00\x10\x00\x11\x00\x73\x01\x3d\x00\x00\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x00\x00\x00\x00\x15\x00\x3b\x00\x3c\x00\x00\x00\x17\x00\x18\x00\x19\x00\x5b\x01\x84\x00\x85\x00\x10\x00\x11\x00\x78\x01\x3d\x00\x00\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x1a\x00\x00\x00\x79\x01\x3b\x00\x3c\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x00\x00\x10\x00\x87\x00\x3b\x00\x3c\x00\xad\x00\x00\x00\x10\x00\x11\x00\x7a\x01\x3d\x00\x00\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x00\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\xb4\x01\x76\x01\x77\x01\x84\x00\x85\x00\x00\x00\x10\x00\x11\x00\x00\x00\x3d\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x7d\x01\x3d\x00\x00\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x10\x00\x87\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x00\x00\x10\x00\x11\x00\x19\x01\x3d\x00\x00\x00\x37\x00\x38\x00\x39\x00\x3a\x00\x00\x00\x00\x00\x5d\x00\x3b\x00\x3c\x00\x37\x00\x38\x00\x39\x00\x3a\x00\xcb\x00\xcc\x00\x00\x00\x3b\x00\x3c\x00\x00\x00\x10\x00\x11\x00\x00\x00\xcd\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x3d\x00\x00\x00\x2f\x00\x9d\x00\x30\x00\x15\x00\x16\x00\x3b\x00\x3c\x00\x17\x00\x18\x00\x19\x00\x00\x00\x10\x00\x11\x00\x00\x00\x3d\x00\x5c\x01\x84\x00\x85\x00\x00\x00\x00\x00\x10\x00\x11\x00\x1a\x00\x3d\x00\x31\x00\x2f\x00\x00\x00\x30\x00\x15\x00\x16\x00\x32\x00\x00\x00\x17\x00\x18\x00\x19\x00\xca\x00\x0e\x01\x10\x00\x87\x00\x10\x00\x11\x00\x00\x00\x3d\x00\x00\x00\x00\x00\x34\x00\x00\x00\x1a\x00\x00\x00\x31\x00\x2f\x00\x00\x00\x30\x00\x15\x00\x16\x00\x32\x00\xc9\x00\x17\x00\x18\x00\x19\x00\xca\x00\x00\x00\x15\x00\x00\x00\x00\x00\x00\x00\x17\x00\x18\x00\x19\x00\x00\x00\x34\x00\x00\x00\x1a\x00\x00\x00\x31\x00\x2f\x00\x00\x00\x30\x00\x15\x00\x16\x00\x32\x00\x1a\x00\x17\x00\x18\x00\x19\x00\x33\x00\x00\x00\x15\x00\x00\x00\x24\x01\x00\x00\x17\x00\x18\x00\x19\x00\x00\x00\x34\x00\x00\x00\x1a\x00\xa9\x01\x31\x00\x2f\x00\x00\x00\x30\x00\x15\x00\x16\x00\x32\x00\x1a\x00\x17\x00\x18\x00\x19\x00\xca\x00\x00\x00\x15\x00\x00\x00\x24\x01\x00\x00\x17\x00\x18\x00\x19\x00\x00\x00\x34\x00\x00\x00\x1a\x00\x61\x01\x31\x00\x2f\x00\x00\x00\x30\x00\x15\x00\x16\x00\x32\x00\x1a\x00\x17\x00\x18\x00\x19\x00\x33\x00\x00\x00\x8b\x01\x00\x00\x24\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x34\x00\x00\x00\x1a\x00\x25\x01\x31\x00\x2f\x00\x00\x00\x30\x00\x15\x00\x16\x00\x32\x00\x00\x00\x17\x00\x18\x00\x19\x00\xca\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x34\x00\x00\x00\x1a\x00\x00\x00\xcf\x00\x2f\x00\x00\x00\x30\x00\x15\x00\x16\x00\x32\x00\x00\x00\x17\x00\x18\x00\x19\x00\xca\x00\x00\x00\xe2\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x34\x00\x00\x00\x1a\x00\x00\x00\x31\x00\x2f\x00\x00\x00\x30\x00\x15\x00\x16\x00\x32\x00\x00\x00\x17\x00\x18\x00\x19\x00\xca\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x34\x00\x00\x00\x1a\x00\x00\x00\x31\x00\x2f\x00\x00\x00\x30\x00\x15\x00\x16\x00\x32\x00\x00\x00\x17\x00\x18\x00\x19\x00\x33\x00\x00\x00\x15\x00\x00\x00\x00\x00\x00\x00\x17\x00\x18\x00\x19\x00\x00\x00\x34\x00\x00\x00\x1a\x00\x00\x00\x31\x00\x2f\x00\x00\x00\x30\x00\x15\x00\x16\x00\x32\x00\x1a\x00\x17\x00\x18\x00\x19\x00\xca\x00\x00\x00\x15\x00\x00\x00\x18\x01\x00\x00\x17\x00\x18\x00\x19\x00\x00\x00\x34\x00\x00\x00\x1a\x00\x00\x00\xcf\x00\x2f\x00\x00\x00\x30\x00\x15\x00\x16\x00\x32\x00\x1a\x00\x17\x00\x18\x00\x19\x00\xca\x00\x00\x00\x00\x00\x00\x00\x39\x01\x00\x00\x00\x00\x00\x00\xe7\x00\xe8\x00\x34\x00\x00\x00\x1a\x00\x00\x00\xd1\x00\x2f\x00\x00\x00\x30\x00\x15\x00\x16\x00\x32\x00\x00\x00\x17\x00\x18\x00\x19\x00\xca\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x68\x01\x00\x00\x34\x00\x00\x00\x1a\x00\x00\x00\x31\x00\x2f\x00\x00\x00\x30\x00\x15\x00\x16\x00\x32\x00\x00\x00\x17\x00\x18\x00\x19\x00\xca\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x00\x00\x34\x00\x00\x00\x1a\x00\x15\x00\x31\x00\x00\x00\x00\x00\x17\x00\x18\x00\x19\x00\x32\x00\x55\x00\x56\x00\x57\x00\x58\x00\x33\x00\xb5\x01\x77\x01\x84\x00\x85\x00\x00\x00\x00\x00\x1a\x00\x15\x00\x59\x00\x34\x00\x00\x00\x17\x00\x18\x00\x19\x00\x5a\x00\x55\x00\x56\x00\x57\x00\x58\x00\x5b\x00\x00\x00\x00\x00\x00\x00\x10\x00\x87\x00\x00\x00\x1a\x00\x00\x00\x59\x00\x5c\x00\x00\x00\x55\x01\x00\x00\x00\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x00\x00\x5b\x00\x66\x01\x38\x00\x39\x00\x3a\x00\x00\x00\x00\x00\x00\x00\x3b\x00\x3c\x00\x5c\x00\x00\x00\x9c\x00\x7c\x01\x38\x00\x39\x00\x3a\x00\x00\x00\x00\x00\x15\x00\x3b\x00\x3c\x00\x00\x00\x17\x00\x18\x00\x19\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x15\x00\x26\x00\x00\x00\x00\x00\x17\x00\x18\x00\x19\x00\x1a\x00\x00\x00\x59\x00\x00\x00\x10\x00\x11\x00\x00\x00\x3d\x00\x5a\x00\x00\x00\x00\x00\x00\x00\x1a\x00\x5b\x00\x9d\x01\x00\x00\x10\x00\x11\x00\x00\x00\x3d\x00\x15\x00\x00\x00\x95\x00\x5c\x00\x17\x00\x18\x00\x19\x00\x00\x00\x55\x00\x56\x00\x57\x00\x58\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x1a\x00\x15\x00\x59\x00\x00\x00\x00\x00\x17\x00\x18\x00\x19\x00\x5a\x00\x55\x00\x56\x00\x57\x00\x58\x00\x5b\x00\x57\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1a\x00\x15\x00\x59\x00\x5c\x00\x00\x00\x17\x00\x18\x00\x41\x01\x5a\x00\x55\x00\x56\x00\x57\x00\x58\x00\x5b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1a\x00\x15\x00\x59\x00\x5c\x00\x00\x00\x17\x00\x18\x00\x19\x00\x5a\x00\x55\x00\x56\x00\x57\x00\x58\x00\x5b\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1a\x00\x15\x00\x59\x00\x5c\x00\x00\x00\x17\x00\x18\x00\x19\x00\x5a\x00\x00\x00\x00\x00\x15\x00\x00\x00\x5b\x00\x00\x00\x17\x00\x18\x00\x19\x00\x00\x00\x00\x00\x1a\x00\x15\x00\x59\x00\x5c\x00\x00\x00\x17\x00\x18\x00\x19\x00\x89\x00\x00\x00\x1a\x00\x00\x00\x00\x00\x5b\x00\x00\x00\x00\x00\x00\x00\xa7\x01\x00\x00\x00\x00\x1a\x00\x15\x00\x59\x00\x5c\x00\xc6\x00\x17\x00\x18\x00\x19\x00\x89\x00\x00\x00\x15\x00\x16\x00\x00\x00\x5b\x00\x17\x00\x18\x00\x19\x00\x72\x01\x00\x00\x00\x00\x1a\x00\x15\x00\x59\x00\x5c\x00\x00\x00\x17\x00\x18\x00\x19\x00\x89\x00\x1a\x00\x15\x00\x26\x00\x00\x00\x5b\x00\x17\x00\x18\x00\x19\x00\x7f\x01\x00\x00\x00\x00\x1a\x00\x15\x00\x59\x00\x5c\x00\x00\x00\x17\x00\x18\x00\x19\x00\x89\x00\x1a\x00\x15\x00\x00\x00\x00\x00\x5b\x00\x17\x00\x18\x00\x19\x00\x03\x01\x00\x00\x00\x00\x1a\x00\x00\x00\x59\x00\x5c\x00\x00\x00\x00\x00\x00\x00\x00\x00\x89\x00\x1a\x00\x15\x00\x59\x00\x00\x00\x5b\x00\x17\x00\x18\x00\x19\x00\x89\x00\x00\x00\x00\x00\x11\x01\x00\x00\x5b\x00\x5c\x00\x00\x00\x00\x00\x1c\x01\x00\x00\x00\x00\x1a\x00\x00\x00\x59\x00\x5c\x00\x00\x00\x00\x00\x15\x00\x00\x00\x89\x00\x8a\x00\x17\x00\x18\x00\x19\x00\x5b\x00\x00\x00\x15\x00\x00\x00\x00\x00\x00\x00\x17\x00\x18\x00\x19\x00\x00\x00\x5c\x00\x00\x00\x1a\x00\x15\x00\x59\x00\x8d\x00\x00\x00\x17\x00\x18\x00\x19\x00\x89\x00\x1a\x00\x00\x00\x59\x00\x00\x00\x5b\x00\x00\x00\x00\x00\x00\x00\x89\x00\x00\x00\x00\x00\x1a\x00\x00\x00\x5b\x00\x5c\x00\x00\x00\x2f\xff\x00\x00\x00\x00\x2f\xff\x2f\xff\x00\x00\x00\x00\x5c\x00\x2f\xff\x2f\xff\x2f\xff\x2f\xff\x2f\xff\x00\x00\x2f\xff\x2f\xff\x2f\xff\x00\x00\x00\x00\x2f\xff\x3f\x00\x40\x00\x41\x00\x15\x00\x16\x00\x2f\xff\x2f\xff\x17\x00\x18\x00\x19\x00\x2f\xff\x2f\xff\x2f\xff\x2f\xff\x2f\xff\x2f\xff\x2f\xff\x2f\xff\x2f\xff\x00\x00\x00\x00\x2f\xff\x1a\x00\x00\x00\x44\x00\xa2\x00\x00\x00\x00\x00\x15\x00\x16\x00\x45\x00\x00\x00\x17\x00\x18\x00\x19\x00\x46\x00\xd5\x00\x47\x00\x00\x00\x00\x00\x48\x00\x00\x00\xd6\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\x1a\x00\x2b\xff\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\x00\x00\xa3\x00\x00\x00\x2b\xff\x2b\xff\x00\x00\xa4\x00\x00\x00\x2b\xff\x2b\xff\x2b\xff\x2b\xff\x2b\xff\x2b\xff\x2b\xff\x2b\xff\x2b\xff\xe8\x00\x00\x00\x2b\xff\xf2\x00\x6d\x01\x00\x00\x15\x00\x00\x00\x00\x00\x00\x00\x17\x00\x18\x00\x19\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x00\x00\x1a\x00\xb9\x01\x27\x00\x28\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x29\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\x9e\x01\x27\x00\x28\x00\x10\x00\x11\x00\x00\x00\x2d\x00\x00\x00\x29\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\x14\x01\x27\x00\x28\x00\x10\x00\x11\x00\x00\x00\x2d\x00\x00\x00\x29\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\x26\x00\x27\x00\x28\x00\x10\x00\x11\x00\x00\x00\x2d\x00\x00\x00\x29\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x82\x01\x10\x00\x11\x00\x00\x00\x2d\x00\x83\x01\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\x08\x01\x2a\x00\x2b\x00\x00\x00\x2c\x00\x09\x01\x00\x00\x00\x00\x0a\x01\x11\x00\xc0\x00\x2d\x00\x00\x00\x00\x00\x0b\x01\x0c\x01\x00\x00\x00\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\xd4\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\xc6\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\xc7\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\x83\x01\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\x95\x01\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\x9a\x01\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\x5a\x01\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\x5d\x01\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\x86\x01\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\x87\x01\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\xdb\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\xdd\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\xde\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\xdf\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\xed\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\x0e\x01\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\xca\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\xd4\x00\x2a\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\xdc\x00\x2b\x00\x00\x00\x2c\x00\x00\x00\x00\x00\x00\x00\x10\x00\x11\x00\x00\x00\x2d\x00\x1c\x00\x1d\x00\x1e\x00\x1f\x00\x20\x00\x21\x00\x22\x00\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"#

happyReduceArr = Happy_Data_Array.array (12, 246) [
	(12 , happyReduce_12),
	(13 , happyReduce_13),
	(14 , happyReduce_14),
	(15 , happyReduce_15),
	(16 , happyReduce_16),
	(17 , happyReduce_17),
	(18 , happyReduce_18),
	(19 , happyReduce_19),
	(20 , happyReduce_20),
	(21 , happyReduce_21),
	(22 , happyReduce_22),
	(23 , happyReduce_23),
	(24 , happyReduce_24),
	(25 , happyReduce_25),
	(26 , happyReduce_26),
	(27 , happyReduce_27),
	(28 , happyReduce_28),
	(29 , happyReduce_29),
	(30 , happyReduce_30),
	(31 , happyReduce_31),
	(32 , happyReduce_32),
	(33 , happyReduce_33),
	(34 , happyReduce_34),
	(35 , happyReduce_35),
	(36 , happyReduce_36),
	(37 , happyReduce_37),
	(38 , happyReduce_38),
	(39 , happyReduce_39),
	(40 , happyReduce_40),
	(41 , happyReduce_41),
	(42 , happyReduce_42),
	(43 , happyReduce_43),
	(44 , happyReduce_44),
	(45 , happyReduce_45),
	(46 , happyReduce_46),
	(47 , happyReduce_47),
	(48 , happyReduce_48),
	(49 , happyReduce_49),
	(50 , happyReduce_50),
	(51 , happyReduce_51),
	(52 , happyReduce_52),
	(53 , happyReduce_53),
	(54 , happyReduce_54),
	(55 , happyReduce_55),
	(56 , happyReduce_56),
	(57 , happyReduce_57),
	(58 , happyReduce_58),
	(59 , happyReduce_59),
	(60 , happyReduce_60),
	(61 , happyReduce_61),
	(62 , happyReduce_62),
	(63 , happyReduce_63),
	(64 , happyReduce_64),
	(65 , happyReduce_65),
	(66 , happyReduce_66),
	(67 , happyReduce_67),
	(68 , happyReduce_68),
	(69 , happyReduce_69),
	(70 , happyReduce_70),
	(71 , happyReduce_71),
	(72 , happyReduce_72),
	(73 , happyReduce_73),
	(74 , happyReduce_74),
	(75 , happyReduce_75),
	(76 , happyReduce_76),
	(77 , happyReduce_77),
	(78 , happyReduce_78),
	(79 , happyReduce_79),
	(80 , happyReduce_80),
	(81 , happyReduce_81),
	(82 , happyReduce_82),
	(83 , happyReduce_83),
	(84 , happyReduce_84),
	(85 , happyReduce_85),
	(86 , happyReduce_86),
	(87 , happyReduce_87),
	(88 , happyReduce_88),
	(89 , happyReduce_89),
	(90 , happyReduce_90),
	(91 , happyReduce_91),
	(92 , happyReduce_92),
	(93 , happyReduce_93),
	(94 , happyReduce_94),
	(95 , happyReduce_95),
	(96 , happyReduce_96),
	(97 , happyReduce_97),
	(98 , happyReduce_98),
	(99 , happyReduce_99),
	(100 , happyReduce_100),
	(101 , happyReduce_101),
	(102 , happyReduce_102),
	(103 , happyReduce_103),
	(104 , happyReduce_104),
	(105 , happyReduce_105),
	(106 , happyReduce_106),
	(107 , happyReduce_107),
	(108 , happyReduce_108),
	(109 , happyReduce_109),
	(110 , happyReduce_110),
	(111 , happyReduce_111),
	(112 , happyReduce_112),
	(113 , happyReduce_113),
	(114 , happyReduce_114),
	(115 , happyReduce_115),
	(116 , happyReduce_116),
	(117 , happyReduce_117),
	(118 , happyReduce_118),
	(119 , happyReduce_119),
	(120 , happyReduce_120),
	(121 , happyReduce_121),
	(122 , happyReduce_122),
	(123 , happyReduce_123),
	(124 , happyReduce_124),
	(125 , happyReduce_125),
	(126 , happyReduce_126),
	(127 , happyReduce_127),
	(128 , happyReduce_128),
	(129 , happyReduce_129),
	(130 , happyReduce_130),
	(131 , happyReduce_131),
	(132 , happyReduce_132),
	(133 , happyReduce_133),
	(134 , happyReduce_134),
	(135 , happyReduce_135),
	(136 , happyReduce_136),
	(137 , happyReduce_137),
	(138 , happyReduce_138),
	(139 , happyReduce_139),
	(140 , happyReduce_140),
	(141 , happyReduce_141),
	(142 , happyReduce_142),
	(143 , happyReduce_143),
	(144 , happyReduce_144),
	(145 , happyReduce_145),
	(146 , happyReduce_146),
	(147 , happyReduce_147),
	(148 , happyReduce_148),
	(149 , happyReduce_149),
	(150 , happyReduce_150),
	(151 , happyReduce_151),
	(152 , happyReduce_152),
	(153 , happyReduce_153),
	(154 , happyReduce_154),
	(155 , happyReduce_155),
	(156 , happyReduce_156),
	(157 , happyReduce_157),
	(158 , happyReduce_158),
	(159 , happyReduce_159),
	(160 , happyReduce_160),
	(161 , happyReduce_161),
	(162 , happyReduce_162),
	(163 , happyReduce_163),
	(164 , happyReduce_164),
	(165 , happyReduce_165),
	(166 , happyReduce_166),
	(167 , happyReduce_167),
	(168 , happyReduce_168),
	(169 , happyReduce_169),
	(170 , happyReduce_170),
	(171 , happyReduce_171),
	(172 , happyReduce_172),
	(173 , happyReduce_173),
	(174 , happyReduce_174),
	(175 , happyReduce_175),
	(176 , happyReduce_176),
	(177 , happyReduce_177),
	(178 , happyReduce_178),
	(179 , happyReduce_179),
	(180 , happyReduce_180),
	(181 , happyReduce_181),
	(182 , happyReduce_182),
	(183 , happyReduce_183),
	(184 , happyReduce_184),
	(185 , happyReduce_185),
	(186 , happyReduce_186),
	(187 , happyReduce_187),
	(188 , happyReduce_188),
	(189 , happyReduce_189),
	(190 , happyReduce_190),
	(191 , happyReduce_191),
	(192 , happyReduce_192),
	(193 , happyReduce_193),
	(194 , happyReduce_194),
	(195 , happyReduce_195),
	(196 , happyReduce_196),
	(197 , happyReduce_197),
	(198 , happyReduce_198),
	(199 , happyReduce_199),
	(200 , happyReduce_200),
	(201 , happyReduce_201),
	(202 , happyReduce_202),
	(203 , happyReduce_203),
	(204 , happyReduce_204),
	(205 , happyReduce_205),
	(206 , happyReduce_206),
	(207 , happyReduce_207),
	(208 , happyReduce_208),
	(209 , happyReduce_209),
	(210 , happyReduce_210),
	(211 , happyReduce_211),
	(212 , happyReduce_212),
	(213 , happyReduce_213),
	(214 , happyReduce_214),
	(215 , happyReduce_215),
	(216 , happyReduce_216),
	(217 , happyReduce_217),
	(218 , happyReduce_218),
	(219 , happyReduce_219),
	(220 , happyReduce_220),
	(221 , happyReduce_221),
	(222 , happyReduce_222),
	(223 , happyReduce_223),
	(224 , happyReduce_224),
	(225 , happyReduce_225),
	(226 , happyReduce_226),
	(227 , happyReduce_227),
	(228 , happyReduce_228),
	(229 , happyReduce_229),
	(230 , happyReduce_230),
	(231 , happyReduce_231),
	(232 , happyReduce_232),
	(233 , happyReduce_233),
	(234 , happyReduce_234),
	(235 , happyReduce_235),
	(236 , happyReduce_236),
	(237 , happyReduce_237),
	(238 , happyReduce_238),
	(239 , happyReduce_239),
	(240 , happyReduce_240),
	(241 , happyReduce_241),
	(242 , happyReduce_242),
	(243 , happyReduce_243),
	(244 , happyReduce_244),
	(245 , happyReduce_245),
	(246 , happyReduce_246)
	]

happy_n_terms = 60 :: Int
happy_n_nonterms = 81 :: Int

happyReduce_12 = happyReduce 6# 0# happyReduction_12
happyReduction_12 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut90 happy_x_2 of { happy_var_2 -> 
	case happyOut16 happy_x_5 of { happy_var_5 -> 
	happyIn15
		 (let (is,ts) = happy_var_5 in Module happy_var_2 is ts
	) `HappyStk` happyRest}}

happyReduce_13 = happySpecReduce_3  0# happyReduction_13
happyReduction_13 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut16 happy_x_2 of { happy_var_2 -> 
	happyIn15
		 (let { (is,ts) = happy_var_2
            -- XXX make a location from is and ts
          ; modName = Located { srcRange = emptyRange
                              , thing    = mkModName ["Main"]
                              }
          } in Module modName is ts
	)}

happyReduce_14 = happySpecReduce_3  1# happyReduction_14
happyReduction_14 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	case happyOut26 happy_x_3 of { happy_var_3 -> 
	happyIn16
		 ((reverse happy_var_1, reverse happy_var_3)
	)}}

happyReduce_15 = happySpecReduce_3  1# happyReduction_15
happyReduction_15 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	case happyOut26 happy_x_3 of { happy_var_3 -> 
	happyIn16
		 ((reverse happy_var_1, reverse happy_var_3)
	)}}

happyReduce_16 = happySpecReduce_1  1# happyReduction_16
happyReduction_16 happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	happyIn16
		 ((reverse happy_var_1, [])
	)}

happyReduce_17 = happySpecReduce_1  1# happyReduction_17
happyReduction_17 happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	happyIn16
		 (([], reverse happy_var_1)
	)}

happyReduce_18 = happySpecReduce_0  1# happyReduction_18
happyReduction_18  =  happyIn16
		 (([], [])
	)

happyReduce_19 = happySpecReduce_3  2# happyReduction_19
happyReduction_19 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	case happyOut18 happy_x_3 of { happy_var_3 -> 
	happyIn17
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_20 = happySpecReduce_3  2# happyReduction_20
happyReduction_20 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut17 happy_x_1 of { happy_var_1 -> 
	case happyOut18 happy_x_3 of { happy_var_3 -> 
	happyIn17
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_21 = happySpecReduce_1  2# happyReduction_21
happyReduction_21 happy_x_1
	 =  case happyOut18 happy_x_1 of { happy_var_1 -> 
	happyIn17
		 ([happy_var_1]
	)}

happyReduce_22 = happyReduce 4# 3# happyReduction_22
happyReduction_22 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_import)    _)) -> 
	case happyOut90 happy_x_2 of { happy_var_2 -> 
	case happyOut19 happy_x_3 of { happy_var_3 -> 
	case happyOut20 happy_x_4 of { happy_var_4 -> 
	happyIn18
		 (Located { srcRange = rComb happy_var_1
                                                   $ fromMaybe (srcRange happy_var_2)
                                                   $ msum [ fmap srcRange happy_var_4
                                                          , fmap srcRange happy_var_3
                                                          ]
                                        , thing    = Import
                                          { iModule    = thing happy_var_2
                                          , iAs        = fmap thing happy_var_3
                                          , iSpec      = fmap thing happy_var_4
                                          }
                                        }
	) `HappyStk` happyRest}}}}

happyReduce_23 = happySpecReduce_2  4# happyReduction_23
happyReduction_23 happy_x_2
	happy_x_1
	 =  case happyOut90 happy_x_2 of { happy_var_2 -> 
	happyIn19
		 (Just happy_var_2
	)}

happyReduce_24 = happySpecReduce_0  4# happyReduction_24
happyReduction_24  =  happyIn19
		 (Nothing
	)

happyReduce_25 = happyReduce 4# 5# happyReduction_25
happyReduction_25 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut22 happy_x_1 of { happy_var_1 -> 
	case happyOut21 happy_x_3 of { happy_var_3 -> 
	happyIn20
		 (Just Located
                                  { srcRange = case happy_var_3 of
                                      { [] -> emptyRange
                                      ; xs -> rCombs (map srcRange xs) }
                                  , thing    = happy_var_1 (reverse (map thing happy_var_3))
                                  }
	) `HappyStk` happyRest}}

happyReduce_26 = happySpecReduce_0  5# happyReduction_26
happyReduction_26  =  happyIn20
		 (Nothing
	)

happyReduce_27 = happySpecReduce_3  6# happyReduction_27
happyReduction_27 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut21 happy_x_1 of { happy_var_1 -> 
	case happyOut88 happy_x_3 of { happy_var_3 -> 
	happyIn21
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_28 = happySpecReduce_1  6# happyReduction_28
happyReduction_28 happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	happyIn21
		 ([happy_var_1]
	)}

happyReduce_29 = happySpecReduce_0  6# happyReduction_29
happyReduction_29  =  happyIn21
		 ([]
	)

happyReduce_30 = happySpecReduce_1  7# happyReduction_30
happyReduction_30 happy_x_1
	 =  happyIn22
		 (Hiding
	)

happyReduce_31 = happySpecReduce_0  7# happyReduction_31
happyReduction_31  =  happyIn22
		 (Only
	)

happyReduce_32 = happySpecReduce_1  8# happyReduction_32
happyReduction_32 happy_x_1
	 =  case happyOut25 happy_x_1 of { happy_var_1 -> 
	happyIn23
		 (Program (reverse happy_var_1)
	)}

happyReduce_33 = happySpecReduce_0  8# happyReduction_33
happyReduction_33  =  happyIn23
		 (Program []
	)

happyReduce_34 = happySpecReduce_3  9# happyReduction_34
happyReduction_34 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_2 of { happy_var_2 -> 
	happyIn24
		 (Program (reverse happy_var_2)
	)}

happyReduce_35 = happySpecReduce_2  9# happyReduction_35
happyReduction_35 happy_x_2
	happy_x_1
	 =  happyIn24
		 (Program []
	)

happyReduce_36 = happySpecReduce_2  10# happyReduction_36
happyReduction_36 happy_x_2
	happy_x_1
	 =  case happyOut28 happy_x_1 of { happy_var_1 -> 
	happyIn25
		 (happy_var_1
	)}

happyReduce_37 = happySpecReduce_3  10# happyReduction_37
happyReduction_37 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut25 happy_x_1 of { happy_var_1 -> 
	case happyOut28 happy_x_2 of { happy_var_2 -> 
	happyIn25
		 (happy_var_2 ++ happy_var_1
	)}}

happyReduce_38 = happySpecReduce_1  11# happyReduction_38
happyReduction_38 happy_x_1
	 =  case happyOut27 happy_x_1 of { happy_var_1 -> 
	happyIn26
		 (happy_var_1
	)}

happyReduce_39 = happySpecReduce_3  11# happyReduction_39
happyReduction_39 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn26
		 (happy_var_3 ++ happy_var_1
	)}}

happyReduce_40 = happySpecReduce_3  11# happyReduction_40
happyReduction_40 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut26 happy_x_1 of { happy_var_1 -> 
	case happyOut27 happy_x_3 of { happy_var_3 -> 
	happyIn26
		 (happy_var_3 ++ happy_var_1
	)}}

happyReduce_41 = happySpecReduce_1  12# happyReduction_41
happyReduction_41 happy_x_1
	 =  case happyOut33 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 ([exportDecl Nothing   Public happy_var_1]
	)}

happyReduce_42 = happySpecReduce_2  12# happyReduction_42
happyReduction_42 happy_x_2
	happy_x_1
	 =  case happyOut31 happy_x_1 of { happy_var_1 -> 
	case happyOut33 happy_x_2 of { happy_var_2 -> 
	happyIn27
		 ([exportDecl (Just happy_var_1) Public happy_var_2]
	)}}

happyReduce_43 = happyMonadReduce 3# 12# happyReduction_43
happyReduction_43 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_3 of { (happy_var_3@(Located _ (Token (StrLit {}) _))) -> 
	( (return . Include) `fmap` fromStrLit happy_var_3)}
	) (\r -> happyReturn (happyIn27 r))

happyReduce_44 = happyReduce 6# 12# happyReduction_44
happyReduction_44 (happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOut89 happy_x_3 of { happy_var_3 -> 
	case happyOut39 happy_x_4 of { happy_var_4 -> 
	case happyOut44 happy_x_6 of { happy_var_6 -> 
	happyIn27
		 ([exportDecl happy_var_1 Public (mkProperty happy_var_3 happy_var_4 happy_var_6)]
	) `HappyStk` happyRest}}}}

happyReduce_45 = happyReduce 5# 12# happyReduction_45
happyReduction_45 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOut89 happy_x_3 of { happy_var_3 -> 
	case happyOut44 happy_x_5 of { happy_var_5 -> 
	happyIn27
		 ([exportDecl happy_var_1 Public (mkProperty happy_var_3 [] happy_var_5)]
	) `HappyStk` happyRest}}}

happyReduce_46 = happySpecReduce_2  12# happyReduction_46
happyReduction_46 happy_x_2
	happy_x_1
	 =  case happyOut35 happy_x_2 of { happy_var_2 -> 
	happyIn27
		 ([exportNewtype Public happy_var_2]
	)}

happyReduce_47 = happySpecReduce_1  12# happyReduction_47
happyReduction_47 happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 (happy_var_1
	)}

happyReduce_48 = happySpecReduce_1  12# happyReduction_48
happyReduction_48 happy_x_1
	 =  case happyOut29 happy_x_1 of { happy_var_1 -> 
	happyIn27
		 (happy_var_1
	)}

happyReduce_49 = happySpecReduce_1  13# happyReduction_49
happyReduction_49 happy_x_1
	 =  case happyOut33 happy_x_1 of { happy_var_1 -> 
	happyIn28
		 ([Decl (TopLevel {tlExport = Public, tlValue = happy_var_1 })]
	)}

happyReduce_50 = happyMonadReduce 2# 13# happyReduction_50
happyReduction_50 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_2 of { (happy_var_2@(Located _ (Token (StrLit {}) _))) -> 
	( (return . Include) `fmap` fromStrLit happy_var_2)}
	) (\r -> happyReturn (happyIn28 r))

happyReduce_51 = happySpecReduce_1  13# happyReduction_51
happyReduction_51 happy_x_1
	 =  case happyOut30 happy_x_1 of { happy_var_1 -> 
	happyIn28
		 (happy_var_1
	)}

happyReduce_52 = happyReduce 4# 14# happyReduction_52
happyReduction_52 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut26 happy_x_3 of { happy_var_3 -> 
	happyIn29
		 (changeExport Private (reverse happy_var_3)
	) `HappyStk` happyRest}

happyReduce_53 = happyReduce 5# 14# happyReduction_53
happyReduction_53 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut26 happy_x_4 of { happy_var_4 -> 
	happyIn29
		 (changeExport Private (reverse happy_var_4)
	) `HappyStk` happyRest}

happyReduce_54 = happyReduce 5# 15# happyReduction_54
happyReduction_54 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOut89 happy_x_3 of { happy_var_3 -> 
	case happyOut72 happy_x_5 of { happy_var_5 -> 
	happyIn30
		 (mkPrimDecl happy_var_1 happy_var_3 happy_var_5
	) `HappyStk` happyRest}}}

happyReduce_55 = happyReduce 7# 15# happyReduction_55
happyReduction_55 (happy_x_7 `HappyStk`
	happy_x_6 `HappyStk`
	happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut32 happy_x_1 of { happy_var_1 -> 
	case happyOut52 happy_x_4 of { happy_var_4 -> 
	case happyOut72 happy_x_7 of { happy_var_7 -> 
	happyIn30
		 (mkPrimDecl happy_var_1 happy_var_4 happy_var_7
	) `HappyStk` happyRest}}}

happyReduce_56 = happySpecReduce_1  16# happyReduction_56
happyReduction_56 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (White DocStr) _))) -> 
	happyIn31
		 (mkDoc (fmap tokenText happy_var_1)
	)}

happyReduce_57 = happySpecReduce_1  17# happyReduction_57
happyReduction_57 happy_x_1
	 =  case happyOut31 happy_x_1 of { happy_var_1 -> 
	happyIn32
		 (Just happy_var_1
	)}

happyReduce_58 = happySpecReduce_0  17# happyReduction_58
happyReduction_58  =  happyIn32
		 (Nothing
	)

happyReduce_59 = happySpecReduce_3  18# happyReduction_59
happyReduction_59 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut37 happy_x_1 of { happy_var_1 -> 
	case happyOut72 happy_x_3 of { happy_var_3 -> 
	happyIn33
		 (at (head happy_var_1,happy_var_3) $ DSignature (reverse happy_var_1) happy_var_3
	)}}

happyReduce_60 = happySpecReduce_3  18# happyReduction_60
happyReduction_60 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut68 happy_x_1 of { happy_var_1 -> 
	case happyOut44 happy_x_3 of { happy_var_3 -> 
	happyIn33
		 (at (happy_var_1,happy_var_3) $ DPatBind happy_var_1 happy_var_3
	)}}

happyReduce_61 = happyReduce 4# 18# happyReduction_61
happyReduction_61 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut89 happy_x_1 of { happy_var_1 -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	case happyOut44 happy_x_4 of { happy_var_4 -> 
	happyIn33
		 (at (happy_var_1,happy_var_4) $
                             DBind $ Bind { bName      = happy_var_1
                                          , bParams    = reverse happy_var_2
                                          , bDef       = at happy_var_4 (Located emptyRange (DExpr happy_var_4))
                                          , bSignature = Nothing
                                          , bPragmas   = []
                                          , bMono      = False
                                          , bInfix     = False
                                          , bFixity    = Nothing
                                          , bDoc       = Nothing
                                          }
	) `HappyStk` happyRest}}}

happyReduce_62 = happyReduce 5# 18# happyReduction_62
happyReduction_62 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut68 happy_x_1 of { happy_var_1 -> 
	case happyOut52 happy_x_2 of { happy_var_2 -> 
	case happyOut68 happy_x_3 of { happy_var_3 -> 
	case happyOut44 happy_x_5 of { happy_var_5 -> 
	happyIn33
		 (at (happy_var_1,happy_var_5) $
                             DBind $ Bind { bName      = happy_var_2
                                          , bParams    = [happy_var_1,happy_var_3]
                                          , bDef       = at happy_var_5 (Located emptyRange (DExpr happy_var_5))
                                          , bSignature = Nothing
                                          , bPragmas   = []
                                          , bMono      = False
                                          , bInfix     = True
                                          , bFixity    = Nothing
                                          , bDoc       = Nothing
                                          }
	) `HappyStk` happyRest}}}}

happyReduce_63 = happyMonadReduce 4# 18# happyReduction_63
happyReduction_63 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_type   ) _)) -> 
	case happyOut89 happy_x_2 of { happy_var_2 -> 
	case happyOut80 happy_x_4 of { happy_var_4 -> 
	( at (happy_var_1,happy_var_4) `fmap` mkTySyn happy_var_2 [] happy_var_4)}}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_64 = happyMonadReduce 5# 18# happyReduction_64
happyReduction_64 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_type   ) _)) -> 
	case happyOut89 happy_x_2 of { happy_var_2 -> 
	case happyOut79 happy_x_3 of { happy_var_3 -> 
	case happyOut80 happy_x_5 of { happy_var_5 -> 
	( at (happy_var_1,happy_var_5) `fmap` mkTySyn happy_var_2 (reverse happy_var_3) happy_var_5)}}}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_65 = happyMonadReduce 3# 18# happyReduction_65
happyReduction_65 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_2 of { (happy_var_2@(Located _ (Token (Num   {}) _))) -> 
	case happyOut53 happy_x_3 of { happy_var_3 -> 
	( mkFixity LeftAssoc  happy_var_2 (reverse happy_var_3))}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_66 = happyMonadReduce 3# 18# happyReduction_66
happyReduction_66 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_2 of { (happy_var_2@(Located _ (Token (Num   {}) _))) -> 
	case happyOut53 happy_x_3 of { happy_var_3 -> 
	( mkFixity RightAssoc happy_var_2 (reverse happy_var_3))}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_67 = happyMonadReduce 3# 18# happyReduction_67
happyReduction_67 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_2 of { (happy_var_2@(Located _ (Token (Num   {}) _))) -> 
	case happyOut53 happy_x_3 of { happy_var_3 -> 
	( mkFixity NonAssoc   happy_var_2 (reverse happy_var_3))}}
	) (\r -> happyReturn (happyIn33 r))

happyReduce_68 = happyReduce 4# 19# happyReduction_68
happyReduction_68 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut68 happy_x_2 of { happy_var_2 -> 
	case happyOut44 happy_x_4 of { happy_var_4 -> 
	happyIn34
		 (at (happy_var_2,happy_var_4) $ DPatBind happy_var_2 happy_var_4
	) `HappyStk` happyRest}}

happyReduce_69 = happyReduce 5# 19# happyReduction_69
happyReduction_69 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut89 happy_x_2 of { happy_var_2 -> 
	case happyOut39 happy_x_3 of { happy_var_3 -> 
	case happyOut44 happy_x_5 of { happy_var_5 -> 
	happyIn34
		 (at (happy_var_2,happy_var_5) $
                                   DBind $ Bind { bName      = happy_var_2
                                                , bParams    = reverse happy_var_3
                                                , bDef       = at happy_var_5 (Located emptyRange (DExpr happy_var_5))
                                                , bSignature = Nothing
                                                , bPragmas   = []
                                                , bMono      = False
                                                , bInfix     = False
                                                , bFixity    = Nothing
                                                , bDoc       = Nothing
                                                }
	) `HappyStk` happyRest}}}

happyReduce_70 = happyReduce 4# 20# happyReduction_70
happyReduction_70 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut91 happy_x_2 of { happy_var_2 -> 
	case happyOut36 happy_x_4 of { happy_var_4 -> 
	happyIn35
		 (Newtype { nName = happy_var_2, nParams = [], nBody = happy_var_4 }
	) `HappyStk` happyRest}}

happyReduce_71 = happyReduce 5# 20# happyReduction_71
happyReduction_71 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut91 happy_x_2 of { happy_var_2 -> 
	case happyOut79 happy_x_3 of { happy_var_3 -> 
	case happyOut36 happy_x_5 of { happy_var_5 -> 
	happyIn35
		 (Newtype { nName = happy_var_2, nParams = happy_var_3, nBody = happy_var_5 }
	) `HappyStk` happyRest}}}

happyReduce_72 = happySpecReduce_2  21# happyReduction_72
happyReduction_72 happy_x_2
	happy_x_1
	 =  happyIn36
		 ([]
	)

happyReduce_73 = happySpecReduce_3  21# happyReduction_73
happyReduction_73 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut87 happy_x_2 of { happy_var_2 -> 
	happyIn36
		 (happy_var_2
	)}

happyReduce_74 = happySpecReduce_1  22# happyReduction_74
happyReduction_74 happy_x_1
	 =  case happyOut38 happy_x_1 of { happy_var_1 -> 
	happyIn37
		 ([ happy_var_1]
	)}

happyReduce_75 = happySpecReduce_3  22# happyReduction_75
happyReduction_75 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut37 happy_x_1 of { happy_var_1 -> 
	case happyOut38 happy_x_3 of { happy_var_3 -> 
	happyIn37
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_76 = happySpecReduce_1  23# happyReduction_76
happyReduction_76 happy_x_1
	 =  case happyOut89 happy_x_1 of { happy_var_1 -> 
	happyIn38
		 (happy_var_1
	)}

happyReduce_77 = happySpecReduce_3  23# happyReduction_77
happyReduction_77 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut52 happy_x_2 of { happy_var_2 -> 
	happyIn38
		 (happy_var_2
	)}

happyReduce_78 = happySpecReduce_1  24# happyReduction_78
happyReduction_78 happy_x_1
	 =  case happyOut68 happy_x_1 of { happy_var_1 -> 
	happyIn39
		 ([happy_var_1]
	)}

happyReduce_79 = happySpecReduce_2  24# happyReduction_79
happyReduction_79 happy_x_2
	happy_x_1
	 =  case happyOut39 happy_x_1 of { happy_var_1 -> 
	case happyOut68 happy_x_2 of { happy_var_2 -> 
	happyIn39
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_80 = happySpecReduce_2  25# happyReduction_80
happyReduction_80 happy_x_2
	happy_x_1
	 =  case happyOut33 happy_x_1 of { happy_var_1 -> 
	happyIn40
		 ([happy_var_1]
	)}

happyReduce_81 = happySpecReduce_3  25# happyReduction_81
happyReduction_81 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut40 happy_x_1 of { happy_var_1 -> 
	case happyOut33 happy_x_2 of { happy_var_2 -> 
	happyIn40
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_82 = happySpecReduce_1  26# happyReduction_82
happyReduction_82 happy_x_1
	 =  case happyOut33 happy_x_1 of { happy_var_1 -> 
	happyIn41
		 ([happy_var_1]
	)}

happyReduce_83 = happySpecReduce_3  26# happyReduction_83
happyReduction_83 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOut33 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_84 = happySpecReduce_3  26# happyReduction_84
happyReduction_84 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_1 of { happy_var_1 -> 
	case happyOut33 happy_x_3 of { happy_var_3 -> 
	happyIn41
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_85 = happySpecReduce_3  27# happyReduction_85
happyReduction_85 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut41 happy_x_2 of { happy_var_2 -> 
	happyIn42
		 (happy_var_2
	)}

happyReduce_86 = happySpecReduce_2  27# happyReduction_86
happyReduction_86 happy_x_2
	happy_x_1
	 =  happyIn42
		 ([]
	)

happyReduce_87 = happySpecReduce_1  28# happyReduction_87
happyReduction_87 happy_x_1
	 =  case happyOut44 happy_x_1 of { happy_var_1 -> 
	happyIn43
		 (ExprInput happy_var_1
	)}

happyReduce_88 = happySpecReduce_1  28# happyReduction_88
happyReduction_88 happy_x_1
	 =  case happyOut34 happy_x_1 of { happy_var_1 -> 
	happyIn43
		 (LetInput happy_var_1
	)}

happyReduce_89 = happySpecReduce_1  29# happyReduction_89
happyReduction_89 happy_x_1
	 =  case happyOut47 happy_x_1 of { happy_var_1 -> 
	happyIn44
		 (happy_var_1
	)}

happyReduce_90 = happyReduce 4# 29# happyReduction_90
happyReduction_90 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym CurlyR  ) _)) -> 
	happyIn44
		 (at (happy_var_1,happy_var_4) $ EWhere happy_var_1 []
	) `HappyStk` happyRest}}

happyReduce_91 = happyReduce 5# 29# happyReduction_91
happyReduction_91 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOut40 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Located happy_var_5 (Token (Sym CurlyR  ) _)) -> 
	happyIn44
		 (at (happy_var_1,happy_var_5) $ EWhere happy_var_1 (reverse happy_var_4)
	) `HappyStk` happyRest}}}

happyReduce_92 = happyReduce 4# 29# happyReduction_92
happyReduction_92 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (KW KW_where  ) _)) -> 
	happyIn44
		 (at (happy_var_1,happy_var_2) $ EWhere happy_var_1 []
	) `HappyStk` happyRest}}

happyReduce_93 = happyReduce 5# 29# happyReduction_93
happyReduction_93 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOut41 happy_x_4 of { happy_var_4 -> 
	happyIn44
		 (at (happy_var_1,happy_var_4) $ EWhere happy_var_1 (reverse happy_var_4)
	) `HappyStk` happyRest}}

happyReduce_94 = happySpecReduce_1  30# happyReduction_94
happyReduction_94 happy_x_1
	 =  case happyOut46 happy_x_1 of { happy_var_1 -> 
	happyIn45
		 ([happy_var_1]
	)}

happyReduce_95 = happySpecReduce_3  30# happyReduction_95
happyReduction_95 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut45 happy_x_1 of { happy_var_1 -> 
	case happyOut46 happy_x_3 of { happy_var_3 -> 
	happyIn45
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_96 = happySpecReduce_3  31# happyReduction_96
happyReduction_96 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOut44 happy_x_3 of { happy_var_3 -> 
	happyIn46
		 ((happy_var_1, happy_var_3)
	)}}

happyReduce_97 = happySpecReduce_1  32# happyReduction_97
happyReduction_97 happy_x_1
	 =  case happyOut48 happy_x_1 of { happy_var_1 -> 
	happyIn47
		 (happy_var_1
	)}

happyReduce_98 = happyReduce 4# 32# happyReduction_98
happyReduction_98 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_if     ) _)) -> 
	case happyOut45 happy_x_2 of { happy_var_2 -> 
	case happyOut47 happy_x_4 of { happy_var_4 -> 
	happyIn47
		 (at (happy_var_1,happy_var_4) $ mkIf (reverse happy_var_2) happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_99 = happyReduce 4# 32# happyReduction_99
happyReduction_99 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym Lambda  ) _)) -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	case happyOut47 happy_x_4 of { happy_var_4 -> 
	happyIn47
		 (at (happy_var_1,happy_var_4) $ EFun (reverse happy_var_2) happy_var_4
	) `HappyStk` happyRest}}}

happyReduce_100 = happySpecReduce_1  33# happyReduction_100
happyReduction_100 happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	happyIn48
		 (happy_var_1
	)}

happyReduce_101 = happySpecReduce_3  33# happyReduction_101
happyReduction_101 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_3 of { happy_var_3 -> 
	happyIn48
		 (at (happy_var_1,happy_var_3) $ ETyped happy_var_1 happy_var_3
	)}}

happyReduce_102 = happySpecReduce_1  34# happyReduction_102
happyReduction_102 happy_x_1
	 =  case happyOut50 happy_x_1 of { happy_var_1 -> 
	happyIn49
		 (happy_var_1
	)}

happyReduce_103 = happySpecReduce_3  34# happyReduction_103
happyReduction_103 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut49 happy_x_1 of { happy_var_1 -> 
	case happyOut51 happy_x_2 of { happy_var_2 -> 
	case happyOut50 happy_x_3 of { happy_var_3 -> 
	happyIn49
		 (binOp happy_var_1 happy_var_2 happy_var_3
	)}}}

happyReduce_104 = happySpecReduce_1  35# happyReduction_104
happyReduction_104 happy_x_1
	 =  case happyOut54 happy_x_1 of { happy_var_1 -> 
	happyIn50
		 (mkEApp happy_var_1
	)}

happyReduce_105 = happySpecReduce_2  35# happyReduction_105
happyReduction_105 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Minus) _)) -> 
	case happyOut50 happy_x_2 of { happy_var_2 -> 
	happyIn50
		 (at (happy_var_1,happy_var_2) $ EApp (at happy_var_1 (EVar (mkUnqual (packIdent "negate")))) happy_var_2
	)}}

happyReduce_106 = happySpecReduce_2  35# happyReduction_106
happyReduction_106 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Complement) _)) -> 
	case happyOut50 happy_x_2 of { happy_var_2 -> 
	happyIn50
		 (at (happy_var_1,happy_var_2) $ EApp (at happy_var_1 (EVar (mkUnqual (packIdent "complement")))) happy_var_2
	)}}

happyReduce_107 = happySpecReduce_1  36# happyReduction_107
happyReduction_107 happy_x_1
	 =  case happyOut52 happy_x_1 of { happy_var_1 -> 
	happyIn51
		 (happy_var_1
	)}

happyReduce_108 = happySpecReduce_1  36# happyReduction_108
happyReduction_108 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Op  Other{}   )  _))) -> 
	happyIn51
		 (let Token (Op (Other ns i)) _ = thing happy_var_1
                                       in mkQual (mkModName ns) (packInfix i) A.<$ happy_var_1
	)}

happyReduce_109 = happySpecReduce_1  37# happyReduction_109
happyReduction_109 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Op (Other [] _)) _))) -> 
	happyIn52
		 (let Token (Op (Other [] str)) _ = thing happy_var_1
                                       in mkUnqual (packInfix str) A.<$ happy_var_1
	)}

happyReduce_110 = happySpecReduce_1  37# happyReduction_110
happyReduction_110 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Mul)   _)) -> 
	happyIn52
		 (Located happy_var_1 $ mkUnqual $ packInfix "*"
	)}

happyReduce_111 = happySpecReduce_1  37# happyReduction_111
happyReduction_111 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Plus)  _)) -> 
	happyIn52
		 (Located happy_var_1 $ mkUnqual $ packInfix "+"
	)}

happyReduce_112 = happySpecReduce_1  37# happyReduction_112
happyReduction_112 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Minus) _)) -> 
	happyIn52
		 (Located happy_var_1 $ mkUnqual $ packInfix "-"
	)}

happyReduce_113 = happySpecReduce_1  37# happyReduction_113
happyReduction_113 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Complement) _)) -> 
	happyIn52
		 (Located happy_var_1 $ mkUnqual $ packInfix "~"
	)}

happyReduce_114 = happySpecReduce_1  37# happyReduction_114
happyReduction_114 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Exp)   _)) -> 
	happyIn52
		 (Located happy_var_1 $ mkUnqual $ packInfix "^^"
	)}

happyReduce_115 = happySpecReduce_1  37# happyReduction_115
happyReduction_115 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Hash) _)) -> 
	happyIn52
		 (Located happy_var_1 $ mkUnqual $ packInfix "#"
	)}

happyReduce_116 = happySpecReduce_1  38# happyReduction_116
happyReduction_116 happy_x_1
	 =  case happyOut52 happy_x_1 of { happy_var_1 -> 
	happyIn53
		 ([happy_var_1]
	)}

happyReduce_117 = happySpecReduce_3  38# happyReduction_117
happyReduction_117 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut53 happy_x_1 of { happy_var_1 -> 
	case happyOut52 happy_x_3 of { happy_var_3 -> 
	happyIn53
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_118 = happySpecReduce_1  39# happyReduction_118
happyReduction_118 happy_x_1
	 =  case happyOut55 happy_x_1 of { happy_var_1 -> 
	happyIn54
		 ([happy_var_1]
	)}

happyReduce_119 = happySpecReduce_2  39# happyReduction_119
happyReduction_119 happy_x_2
	happy_x_1
	 =  case happyOut54 happy_x_1 of { happy_var_1 -> 
	case happyOut55 happy_x_2 of { happy_var_2 -> 
	happyIn54
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_120 = happySpecReduce_1  40# happyReduction_120
happyReduction_120 happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	happyIn55
		 (at happy_var_1 $ EVar (thing happy_var_1)
	)}

happyReduce_121 = happySpecReduce_1  40# happyReduction_121
happyReduction_121 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	happyIn55
		 (at happy_var_1 $ numLit (tokenType (thing happy_var_1))
	)}

happyReduce_122 = happySpecReduce_1  40# happyReduction_122
happyReduction_122 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (StrLit {}) _))) -> 
	happyIn55
		 (at happy_var_1 $ ELit $ ECString $ getStr happy_var_1
	)}

happyReduce_123 = happySpecReduce_1  40# happyReduction_123
happyReduction_123 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (ChrLit {}) _))) -> 
	happyIn55
		 (at happy_var_1 $ ELit $ ECNum (getNum happy_var_1) CharLit
	)}

happyReduce_124 = happySpecReduce_3  40# happyReduction_124
happyReduction_124 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut44 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn55
		 (at (happy_var_1,happy_var_3) $ EParens happy_var_2
	)}}}

happyReduce_125 = happySpecReduce_3  40# happyReduction_125
happyReduction_125 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut59 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn55
		 (at (happy_var_1,happy_var_3) $ ETuple (reverse happy_var_2)
	)}}}

happyReduce_126 = happySpecReduce_2  40# happyReduction_126
happyReduction_126 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym ParenR  ) _)) -> 
	happyIn55
		 (at (happy_var_1,happy_var_2) $ ETuple []
	)}}

happyReduce_127 = happySpecReduce_2  40# happyReduction_127
happyReduction_127 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn55
		 (at (happy_var_1,happy_var_2) $ ERecord []
	)}}

happyReduce_128 = happySpecReduce_3  40# happyReduction_128
happyReduction_128 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut61 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn55
		 (at (happy_var_1,happy_var_3) $ ERecord (reverse happy_var_2)
	)}}}

happyReduce_129 = happySpecReduce_2  40# happyReduction_129
happyReduction_129 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym BracketR) _)) -> 
	happyIn55
		 (at (happy_var_1,happy_var_2) $ EList []
	)}}

happyReduce_130 = happySpecReduce_3  40# happyReduction_130
happyReduction_130 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut62 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn55
		 (at (happy_var_1,happy_var_3) happy_var_2
	)}}}

happyReduce_131 = happySpecReduce_2  40# happyReduction_131
happyReduction_131 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BackTick) _)) -> 
	case happyOut93 happy_x_2 of { happy_var_2 -> 
	happyIn55
		 (at (happy_var_1,happy_var_2) $ ETypeVal happy_var_2
	)}}

happyReduce_132 = happySpecReduce_3  40# happyReduction_132
happyReduction_132 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut55 happy_x_1 of { happy_var_1 -> 
	case happyOut58 happy_x_3 of { happy_var_3 -> 
	happyIn55
		 (at (happy_var_1,happy_var_3) $ ESel happy_var_1 (thing happy_var_3)
	)}}

happyReduce_133 = happySpecReduce_3  40# happyReduction_133
happyReduction_133 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut51 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn55
		 (at (happy_var_1,happy_var_3) $ EVar $ thing happy_var_2
	)}}}

happyReduce_134 = happyMonadReduce 2# 40# happyReduction_134
happyReduction_134 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym TriL    ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym TriR    ) _)) -> 
	( mkPoly (rComb happy_var_1 happy_var_2) [])}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_135 = happyMonadReduce 3# 40# happyReduction_135
happyReduction_135 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym TriL    ) _)) -> 
	case happyOut56 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym TriR    ) _)) -> 
	( mkPoly (rComb happy_var_1 happy_var_3) happy_var_2)}}}
	) (\r -> happyReturn (happyIn55 r))

happyReduce_136 = happySpecReduce_1  41# happyReduction_136
happyReduction_136 happy_x_1
	 =  case happyOut57 happy_x_1 of { happy_var_1 -> 
	happyIn56
		 ([happy_var_1]
	)}

happyReduce_137 = happySpecReduce_3  41# happyReduction_137
happyReduction_137 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut56 happy_x_1 of { happy_var_1 -> 
	case happyOut57 happy_x_3 of { happy_var_3 -> 
	happyIn56
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_138 = happyMonadReduce 1# 42# happyReduction_138
happyReduction_138 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	( polyTerm (srcRange happy_var_1) (getNum happy_var_1) 0)}
	) (\r -> happyReturn (happyIn57 r))

happyReduce_139 = happyMonadReduce 1# 42# happyReduction_139
happyReduction_139 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_x)       _)) -> 
	( polyTerm happy_var_1 1 1)}
	) (\r -> happyReturn (happyIn57 r))

happyReduce_140 = happyMonadReduce 3# 42# happyReduction_140
happyReduction_140 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_x)       _)) -> 
	case happyOutTok happy_x_3 of { (happy_var_3@(Located _ (Token (Num   {}) _))) -> 
	( polyTerm (rComb happy_var_1 (srcRange happy_var_3))
                                                            1 (getNum happy_var_3))}}
	) (\r -> happyReturn (happyIn57 r))

happyReduce_141 = happySpecReduce_1  43# happyReduction_141
happyReduction_141 happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	happyIn58
		 (fmap (`RecordSel` Nothing) happy_var_1
	)}

happyReduce_142 = happyMonadReduce 1# 43# happyReduction_142
happyReduction_142 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	( mkTupleSel (srcRange happy_var_1) (getNum happy_var_1))}
	) (\r -> happyReturn (happyIn58 r))

happyReduce_143 = happySpecReduce_3  44# happyReduction_143
happyReduction_143 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOut44 happy_x_3 of { happy_var_3 -> 
	happyIn59
		 ([ happy_var_3, happy_var_1]
	)}}

happyReduce_144 = happySpecReduce_3  44# happyReduction_144
happyReduction_144 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	case happyOut44 happy_x_3 of { happy_var_3 -> 
	happyIn59
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_145 = happySpecReduce_3  45# happyReduction_145
happyReduction_145 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	case happyOut44 happy_x_3 of { happy_var_3 -> 
	happyIn60
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_146 = happyReduce 4# 45# happyReduction_146
happyReduction_146 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut88 happy_x_1 of { happy_var_1 -> 
	case happyOut39 happy_x_2 of { happy_var_2 -> 
	case happyOut44 happy_x_4 of { happy_var_4 -> 
	happyIn60
		 (Named { name = happy_var_1, value = EFun (reverse happy_var_2) happy_var_4 }
	) `HappyStk` happyRest}}}

happyReduce_147 = happySpecReduce_1  46# happyReduction_147
happyReduction_147 happy_x_1
	 =  case happyOut60 happy_x_1 of { happy_var_1 -> 
	happyIn61
		 ([happy_var_1]
	)}

happyReduce_148 = happySpecReduce_3  46# happyReduction_148
happyReduction_148 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut61 happy_x_1 of { happy_var_1 -> 
	case happyOut60 happy_x_3 of { happy_var_3 -> 
	happyIn61
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_149 = happySpecReduce_3  47# happyReduction_149
happyReduction_149 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOut63 happy_x_3 of { happy_var_3 -> 
	happyIn62
		 (EComp happy_var_1 (reverse happy_var_3)
	)}}

happyReduce_150 = happySpecReduce_1  47# happyReduction_150
happyReduction_150 happy_x_1
	 =  case happyOut44 happy_x_1 of { happy_var_1 -> 
	happyIn62
		 (EList [happy_var_1]
	)}

happyReduce_151 = happySpecReduce_1  47# happyReduction_151
happyReduction_151 happy_x_1
	 =  case happyOut59 happy_x_1 of { happy_var_1 -> 
	happyIn62
		 (EList (reverse happy_var_1)
	)}

happyReduce_152 = happyMonadReduce 2# 47# happyReduction_152
happyReduction_152 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym DotDot  ) _)) -> 
	( eFromTo happy_var_2 happy_var_1 Nothing   Nothing)}}
	) (\r -> happyReturn (happyIn62 r))

happyReduce_153 = happyMonadReduce 3# 47# happyReduction_153
happyReduction_153 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym DotDot  ) _)) -> 
	case happyOut44 happy_x_3 of { happy_var_3 -> 
	( eFromTo happy_var_2 happy_var_1 Nothing   (Just happy_var_3))}}}
	) (\r -> happyReturn (happyIn62 r))

happyReduce_154 = happyMonadReduce 4# 47# happyReduction_154
happyReduction_154 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOut44 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym DotDot  ) _)) -> 
	( eFromTo happy_var_4 happy_var_1 (Just happy_var_3) Nothing)}}}
	) (\r -> happyReturn (happyIn62 r))

happyReduce_155 = happyMonadReduce 5# 47# happyReduction_155
happyReduction_155 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOut44 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym DotDot  ) _)) -> 
	case happyOut44 happy_x_5 of { happy_var_5 -> 
	( eFromTo happy_var_4 happy_var_1 (Just happy_var_3) (Just happy_var_5))}}}}
	) (\r -> happyReturn (happyIn62 r))

happyReduce_156 = happySpecReduce_2  47# happyReduction_156
happyReduction_156 happy_x_2
	happy_x_1
	 =  case happyOut44 happy_x_1 of { happy_var_1 -> 
	happyIn62
		 (EInfFrom happy_var_1 Nothing
	)}

happyReduce_157 = happyReduce 4# 47# happyReduction_157
happyReduction_157 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut44 happy_x_1 of { happy_var_1 -> 
	case happyOut44 happy_x_3 of { happy_var_3 -> 
	happyIn62
		 (EInfFrom happy_var_1 (Just happy_var_3)
	) `HappyStk` happyRest}}

happyReduce_158 = happySpecReduce_1  48# happyReduction_158
happyReduction_158 happy_x_1
	 =  case happyOut64 happy_x_1 of { happy_var_1 -> 
	happyIn63
		 ([ reverse happy_var_1 ]
	)}

happyReduce_159 = happySpecReduce_3  48# happyReduction_159
happyReduction_159 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut63 happy_x_1 of { happy_var_1 -> 
	case happyOut64 happy_x_3 of { happy_var_3 -> 
	happyIn63
		 (reverse happy_var_3 : happy_var_1
	)}}

happyReduce_160 = happySpecReduce_1  49# happyReduction_160
happyReduction_160 happy_x_1
	 =  case happyOut65 happy_x_1 of { happy_var_1 -> 
	happyIn64
		 ([happy_var_1]
	)}

happyReduce_161 = happySpecReduce_3  49# happyReduction_161
happyReduction_161 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut64 happy_x_1 of { happy_var_1 -> 
	case happyOut65 happy_x_3 of { happy_var_3 -> 
	happyIn64
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_162 = happySpecReduce_3  50# happyReduction_162
happyReduction_162 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut66 happy_x_1 of { happy_var_1 -> 
	case happyOut44 happy_x_3 of { happy_var_3 -> 
	happyIn65
		 (Match happy_var_1 happy_var_3
	)}}

happyReduce_163 = happySpecReduce_3  51# happyReduction_163
happyReduction_163 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut67 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_3 of { happy_var_3 -> 
	happyIn66
		 (at (happy_var_1,happy_var_3) $ PTyped happy_var_1 happy_var_3
	)}}

happyReduce_164 = happySpecReduce_1  51# happyReduction_164
happyReduction_164 happy_x_1
	 =  case happyOut67 happy_x_1 of { happy_var_1 -> 
	happyIn66
		 (happy_var_1
	)}

happyReduce_165 = happySpecReduce_3  52# happyReduction_165
happyReduction_165 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut67 happy_x_1 of { happy_var_1 -> 
	case happyOut67 happy_x_3 of { happy_var_3 -> 
	happyIn67
		 (at (happy_var_1,happy_var_3) $ PSplit happy_var_1 happy_var_3
	)}}

happyReduce_166 = happySpecReduce_1  52# happyReduction_166
happyReduction_166 happy_x_1
	 =  case happyOut68 happy_x_1 of { happy_var_1 -> 
	happyIn67
		 (happy_var_1
	)}

happyReduce_167 = happySpecReduce_1  53# happyReduction_167
happyReduction_167 happy_x_1
	 =  case happyOut89 happy_x_1 of { happy_var_1 -> 
	happyIn68
		 (PVar happy_var_1
	)}

happyReduce_168 = happySpecReduce_1  53# happyReduction_168
happyReduction_168 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym Underscore ) _)) -> 
	happyIn68
		 (at happy_var_1       $ PWild
	)}

happyReduce_169 = happySpecReduce_2  53# happyReduction_169
happyReduction_169 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym ParenR  ) _)) -> 
	happyIn68
		 (at (happy_var_1,happy_var_2) $ PTuple []
	)}}

happyReduce_170 = happySpecReduce_3  53# happyReduction_170
happyReduction_170 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut66 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn68
		 (at (happy_var_1,happy_var_3)   happy_var_2
	)}}}

happyReduce_171 = happySpecReduce_3  53# happyReduction_171
happyReduction_171 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut69 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn68
		 (at (happy_var_1,happy_var_3) $ PTuple (reverse happy_var_2)
	)}}}

happyReduce_172 = happySpecReduce_2  53# happyReduction_172
happyReduction_172 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym BracketR) _)) -> 
	happyIn68
		 (at (happy_var_1,happy_var_2) $ PList []
	)}}

happyReduce_173 = happySpecReduce_3  53# happyReduction_173
happyReduction_173 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut66 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn68
		 (at (happy_var_1,happy_var_3) $ PList [happy_var_2]
	)}}}

happyReduce_174 = happySpecReduce_3  53# happyReduction_174
happyReduction_174 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut69 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn68
		 (at (happy_var_1,happy_var_3) $ PList (reverse happy_var_2)
	)}}}

happyReduce_175 = happySpecReduce_2  53# happyReduction_175
happyReduction_175 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn68
		 (at (happy_var_1,happy_var_2) $ PRecord []
	)}}

happyReduce_176 = happySpecReduce_3  53# happyReduction_176
happyReduction_176 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut71 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn68
		 (at (happy_var_1,happy_var_3) $ PRecord (reverse happy_var_2)
	)}}}

happyReduce_177 = happySpecReduce_3  54# happyReduction_177
happyReduction_177 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut66 happy_x_1 of { happy_var_1 -> 
	case happyOut66 happy_x_3 of { happy_var_3 -> 
	happyIn69
		 ([happy_var_3, happy_var_1]
	)}}

happyReduce_178 = happySpecReduce_3  54# happyReduction_178
happyReduction_178 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut69 happy_x_1 of { happy_var_1 -> 
	case happyOut66 happy_x_3 of { happy_var_3 -> 
	happyIn69
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_179 = happySpecReduce_3  55# happyReduction_179
happyReduction_179 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	case happyOut66 happy_x_3 of { happy_var_3 -> 
	happyIn70
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_180 = happySpecReduce_1  56# happyReduction_180
happyReduction_180 happy_x_1
	 =  case happyOut70 happy_x_1 of { happy_var_1 -> 
	happyIn71
		 ([happy_var_1]
	)}

happyReduce_181 = happySpecReduce_3  56# happyReduction_181
happyReduction_181 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut71 happy_x_1 of { happy_var_1 -> 
	case happyOut70 happy_x_3 of { happy_var_3 -> 
	happyIn71
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_182 = happySpecReduce_1  57# happyReduction_182
happyReduction_182 happy_x_1
	 =  case happyOut80 happy_x_1 of { happy_var_1 -> 
	happyIn72
		 (at happy_var_1 $ mkSchema [] [] happy_var_1
	)}

happyReduce_183 = happySpecReduce_2  57# happyReduction_183
happyReduction_183 happy_x_2
	happy_x_1
	 =  case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_2 of { happy_var_2 -> 
	happyIn72
		 (at (happy_var_1,happy_var_2) $ mkSchema (thing happy_var_1) [] happy_var_2
	)}}

happyReduce_184 = happySpecReduce_2  57# happyReduction_184
happyReduction_184 happy_x_2
	happy_x_1
	 =  case happyOut74 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_2 of { happy_var_2 -> 
	happyIn72
		 (at (happy_var_1,happy_var_2) $ mkSchema [] (thing happy_var_1) happy_var_2
	)}}

happyReduce_185 = happySpecReduce_3  57# happyReduction_185
happyReduction_185 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut73 happy_x_1 of { happy_var_1 -> 
	case happyOut74 happy_x_2 of { happy_var_2 -> 
	case happyOut80 happy_x_3 of { happy_var_3 -> 
	happyIn72
		 (at (happy_var_1,happy_var_3) $ mkSchema (thing happy_var_1)
                                                          (thing happy_var_2) happy_var_3
	)}}}

happyReduce_186 = happySpecReduce_2  58# happyReduction_186
happyReduction_186 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn73
		 (Located (rComb happy_var_1 happy_var_2) []
	)}}

happyReduce_187 = happySpecReduce_3  58# happyReduction_187
happyReduction_187 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut77 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn73
		 (Located (rComb happy_var_1 happy_var_3) (reverse happy_var_2)
	)}}}

happyReduce_188 = happyMonadReduce 2# 59# happyReduction_188
happyReduction_188 (happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut80 happy_x_1 of { happy_var_1 -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym FatArrR ) _)) -> 
	( fmap (\x -> at (x,happy_var_2) x) (mkProp happy_var_1))}}
	) (\r -> happyReturn (happyIn74 r))

happyReduce_189 = happySpecReduce_1  60# happyReduction_189
happyReduction_189 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Hash) _)) -> 
	happyIn75
		 (Located happy_var_1 KNum
	)}

happyReduce_190 = happySpecReduce_1  60# happyReduction_190
happyReduction_190 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Op Mul)   _)) -> 
	happyIn75
		 (Located happy_var_1 KType
	)}

happyReduce_191 = happyMonadReduce 1# 61# happyReduction_191
happyReduction_191 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut88 happy_x_1 of { happy_var_1 -> 
	( mkTParam happy_var_1 Nothing)}
	) (\r -> happyReturn (happyIn76 r))

happyReduce_192 = happyMonadReduce 3# 61# happyReduction_192
happyReduction_192 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut88 happy_x_1 of { happy_var_1 -> 
	case happyOut75 happy_x_3 of { happy_var_3 -> 
	( mkTParam (at (happy_var_1,happy_var_3) happy_var_1) (Just (thing happy_var_3)))}}
	) (\r -> happyReturn (happyIn76 r))

happyReduce_193 = happySpecReduce_1  62# happyReduction_193
happyReduction_193 happy_x_1
	 =  case happyOut76 happy_x_1 of { happy_var_1 -> 
	happyIn77
		 ([happy_var_1]
	)}

happyReduce_194 = happySpecReduce_3  62# happyReduction_194
happyReduction_194 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut77 happy_x_1 of { happy_var_1 -> 
	case happyOut76 happy_x_3 of { happy_var_3 -> 
	happyIn77
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_195 = happyMonadReduce 1# 63# happyReduction_195
happyReduction_195 (happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOut88 happy_x_1 of { happy_var_1 -> 
	( mkTParam happy_var_1 Nothing)}
	) (\r -> happyReturn (happyIn78 r))

happyReduce_196 = happyMonadReduce 5# 63# happyReduction_196
happyReduction_196 (happy_x_5 `HappyStk`
	happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut88 happy_x_2 of { happy_var_2 -> 
	case happyOut75 happy_x_4 of { happy_var_4 -> 
	case happyOutTok happy_x_5 of { (Located happy_var_5 (Token (Sym ParenR  ) _)) -> 
	( mkTParam (at (happy_var_1,happy_var_5) happy_var_2) (Just (thing happy_var_4)))}}}}
	) (\r -> happyReturn (happyIn78 r))

happyReduce_197 = happySpecReduce_1  64# happyReduction_197
happyReduction_197 happy_x_1
	 =  case happyOut78 happy_x_1 of { happy_var_1 -> 
	happyIn79
		 ([happy_var_1]
	)}

happyReduce_198 = happySpecReduce_2  64# happyReduction_198
happyReduction_198 happy_x_2
	happy_x_1
	 =  case happyOut79 happy_x_1 of { happy_var_1 -> 
	case happyOut78 happy_x_2 of { happy_var_2 -> 
	happyIn79
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_199 = happySpecReduce_3  65# happyReduction_199
happyReduction_199 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut81 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_3 of { happy_var_3 -> 
	happyIn80
		 (at (happy_var_1,happy_var_3) $ TFun happy_var_1 happy_var_3
	)}}

happyReduce_200 = happySpecReduce_3  65# happyReduction_200
happyReduction_200 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut80 happy_x_1 of { happy_var_1 -> 
	case happyOut52 happy_x_2 of { happy_var_2 -> 
	case happyOut81 happy_x_3 of { happy_var_3 -> 
	happyIn80
		 (at (happy_var_1,happy_var_3) $ TInfix happy_var_1 happy_var_2 defaultFixity happy_var_3
	)}}}

happyReduce_201 = happySpecReduce_1  65# happyReduction_201
happyReduction_201 happy_x_1
	 =  case happyOut81 happy_x_1 of { happy_var_1 -> 
	happyIn80
		 (happy_var_1
	)}

happyReduce_202 = happySpecReduce_2  66# happyReduction_202
happyReduction_202 happy_x_2
	happy_x_1
	 =  case happyOut84 happy_x_1 of { happy_var_1 -> 
	case happyOut82 happy_x_2 of { happy_var_2 -> 
	happyIn81
		 (at (happy_var_1,happy_var_2) $ foldr TSeq happy_var_2 (reverse (thing happy_var_1))
	)}}

happyReduce_203 = happySpecReduce_2  66# happyReduction_203
happyReduction_203 happy_x_2
	happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	case happyOut83 happy_x_2 of { happy_var_2 -> 
	happyIn81
		 (at (happy_var_1,head happy_var_2)
                                     $ TUser (thing happy_var_1) (reverse happy_var_2)
	)}}

happyReduce_204 = happySpecReduce_1  66# happyReduction_204
happyReduction_204 happy_x_1
	 =  case happyOut82 happy_x_1 of { happy_var_1 -> 
	happyIn81
		 (happy_var_1
	)}

happyReduce_205 = happySpecReduce_1  67# happyReduction_205
happyReduction_205 happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	happyIn82
		 (at happy_var_1 $ TUser (thing happy_var_1) []
	)}

happyReduce_206 = happySpecReduce_1  67# happyReduction_206
happyReduction_206 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	happyIn82
		 (at happy_var_1 $ TNum  (getNum happy_var_1)
	)}

happyReduce_207 = happySpecReduce_1  67# happyReduction_207
happyReduction_207 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (ChrLit {}) _))) -> 
	happyIn82
		 (at happy_var_1 $ TChar (toEnum $ fromInteger
                                                          $ getNum happy_var_1)
	)}

happyReduce_208 = happySpecReduce_3  67# happyReduction_208
happyReduction_208 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut80 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn82
		 (at (happy_var_1,happy_var_3) $ TSeq happy_var_2 TBit
	)}}}

happyReduce_209 = happySpecReduce_3  67# happyReduction_209
happyReduction_209 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut80 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn82
		 (at (happy_var_1,happy_var_3) $ TParens happy_var_2
	)}}}

happyReduce_210 = happySpecReduce_2  67# happyReduction_210
happyReduction_210 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym ParenR  ) _)) -> 
	happyIn82
		 (at (happy_var_1,happy_var_2) $ TTuple []
	)}}

happyReduce_211 = happySpecReduce_3  67# happyReduction_211
happyReduction_211 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut85 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	happyIn82
		 (at (happy_var_1,happy_var_3) $ TTuple  (reverse happy_var_2)
	)}}}

happyReduce_212 = happySpecReduce_2  67# happyReduction_212
happyReduction_212 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn82
		 (at (happy_var_1,happy_var_2) $ TRecord []
	)}}

happyReduce_213 = happySpecReduce_3  67# happyReduction_213
happyReduction_213 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut87 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn82
		 (at (happy_var_1,happy_var_3) $ TRecord (reverse happy_var_2)
	)}}}

happyReduce_214 = happySpecReduce_1  67# happyReduction_214
happyReduction_214 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym Underscore ) _)) -> 
	happyIn82
		 (at happy_var_1 TWild
	)}

happyReduce_215 = happySpecReduce_1  68# happyReduction_215
happyReduction_215 happy_x_1
	 =  case happyOut82 happy_x_1 of { happy_var_1 -> 
	happyIn83
		 ([ happy_var_1 ]
	)}

happyReduce_216 = happySpecReduce_2  68# happyReduction_216
happyReduction_216 happy_x_2
	happy_x_1
	 =  case happyOut83 happy_x_1 of { happy_var_1 -> 
	case happyOut82 happy_x_2 of { happy_var_2 -> 
	happyIn83
		 (happy_var_2 : happy_var_1
	)}}

happyReduce_217 = happySpecReduce_3  69# happyReduction_217
happyReduction_217 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym BracketL) _)) -> 
	case happyOut80 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym BracketR) _)) -> 
	happyIn84
		 (Located (rComb happy_var_1 happy_var_3) [ happy_var_2 ]
	)}}}

happyReduce_218 = happyReduce 4# 69# happyReduction_218
happyReduction_218 (happy_x_4 `HappyStk`
	happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest)
	 = case happyOut84 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_3 of { happy_var_3 -> 
	case happyOutTok happy_x_4 of { (Located happy_var_4 (Token (Sym BracketR) _)) -> 
	happyIn84
		 (at (happy_var_1,happy_var_4) (fmap (happy_var_3 :) happy_var_1)
	) `HappyStk` happyRest}}}

happyReduce_219 = happySpecReduce_3  70# happyReduction_219
happyReduction_219 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut80 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_3 of { happy_var_3 -> 
	happyIn85
		 ([ happy_var_3, happy_var_1]
	)}}

happyReduce_220 = happySpecReduce_3  70# happyReduction_220
happyReduction_220 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut85 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_3 of { happy_var_3 -> 
	happyIn85
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_221 = happySpecReduce_3  71# happyReduction_221
happyReduction_221 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_3 of { happy_var_3 -> 
	happyIn86
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_222 = happySpecReduce_1  72# happyReduction_222
happyReduction_222 happy_x_1
	 =  case happyOut86 happy_x_1 of { happy_var_1 -> 
	happyIn87
		 ([happy_var_1]
	)}

happyReduce_223 = happySpecReduce_3  72# happyReduction_223
happyReduction_223 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut87 happy_x_1 of { happy_var_1 -> 
	case happyOut86 happy_x_3 of { happy_var_3 -> 
	happyIn87
		 (happy_var_3 : happy_var_1
	)}}

happyReduce_224 = happySpecReduce_1  73# happyReduction_224
happyReduction_224 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Ident [] _) _))) -> 
	happyIn88
		 (let Token (Ident _ str) _ = thing happy_var_1
                         in happy_var_1 { thing = packIdent str }
	)}

happyReduce_225 = happySpecReduce_1  73# happyReduction_225
happyReduction_225 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_x)       _)) -> 
	happyIn88
		 (Located { srcRange = happy_var_1, thing = packIdent "x" }
	)}

happyReduce_226 = happySpecReduce_1  73# happyReduction_226
happyReduction_226 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_private)   _)) -> 
	happyIn88
		 (Located { srcRange = happy_var_1, thing = packIdent "private" }
	)}

happyReduce_227 = happySpecReduce_1  73# happyReduction_227
happyReduction_227 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_as)        _)) -> 
	happyIn88
		 (Located { srcRange = happy_var_1, thing = packIdent "as" }
	)}

happyReduce_228 = happySpecReduce_1  73# happyReduction_228
happyReduction_228 happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (KW KW_hiding)    _)) -> 
	happyIn88
		 (Located { srcRange = happy_var_1, thing = packIdent "hiding" }
	)}

happyReduce_229 = happySpecReduce_1  74# happyReduction_229
happyReduction_229 happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	happyIn89
		 (fmap mkUnqual happy_var_1
	)}

happyReduce_230 = happySpecReduce_1  75# happyReduction_230
happyReduction_230 happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	happyIn90
		 (fmap identText happy_var_1
	)}

happyReduce_231 = happySpecReduce_1  75# happyReduction_231
happyReduction_231 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token  Ident{}     _))) -> 
	happyIn90
		 (let Token (Ident ns i) _ = thing happy_var_1
                                     in mkModName (ns ++ [i]) A.<$ happy_var_1
	)}

happyReduce_232 = happySpecReduce_1  76# happyReduction_232
happyReduction_232 happy_x_1
	 =  case happyOut89 happy_x_1 of { happy_var_1 -> 
	happyIn91
		 (happy_var_1
	)}

happyReduce_233 = happySpecReduce_1  76# happyReduction_233
happyReduction_233 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token  Ident{}     _))) -> 
	happyIn91
		 (let Token (Ident ns i) _ = thing happy_var_1
                                     in mkQual (mkModName ns) (packIdent i) A.<$ happy_var_1
	)}

happyReduce_234 = happySpecReduce_1  77# happyReduction_234
happyReduction_234 happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	happyIn92
		 (happy_var_1
	)}

happyReduce_235 = happySpecReduce_1  77# happyReduction_235
happyReduction_235 happy_x_1
	 =  case happyOut51 happy_x_1 of { happy_var_1 -> 
	happyIn92
		 (happy_var_1
	)}

happyReduce_236 = happySpecReduce_3  77# happyReduction_236
happyReduction_236 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut51 happy_x_2 of { happy_var_2 -> 
	happyIn92
		 (happy_var_2
	)}

happyReduce_237 = happySpecReduce_1  78# happyReduction_237
happyReduction_237 happy_x_1
	 =  case happyOut91 happy_x_1 of { happy_var_1 -> 
	happyIn93
		 (at happy_var_1 $ TUser (thing happy_var_1) []
	)}

happyReduce_238 = happySpecReduce_1  78# happyReduction_238
happyReduction_238 happy_x_1
	 =  case happyOutTok happy_x_1 of { (happy_var_1@(Located _ (Token (Num   {}) _))) -> 
	happyIn93
		 (at happy_var_1 $ TNum  (getNum happy_var_1)
	)}

happyReduce_239 = happyMonadReduce 3# 78# happyReduction_239
happyReduction_239 (happy_x_3 `HappyStk`
	happy_x_2 `HappyStk`
	happy_x_1 `HappyStk`
	happyRest) tk
	 = happyThen (case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym ParenL  ) _)) -> 
	case happyOut80 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym ParenR  ) _)) -> 
	( validDemotedType (rComb happy_var_1 happy_var_3) happy_var_2)}}}
	) (\r -> happyReturn (happyIn93 r))

happyReduce_240 = happySpecReduce_2  78# happyReduction_240
happyReduction_240 happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOutTok happy_x_2 of { (Located happy_var_2 (Token (Sym CurlyR  ) _)) -> 
	happyIn93
		 (at (happy_var_1,happy_var_2) (TRecord [])
	)}}

happyReduce_241 = happySpecReduce_3  78# happyReduction_241
happyReduction_241 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut95 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn93
		 (at (happy_var_1,happy_var_3) (TRecord (reverse happy_var_2))
	)}}}

happyReduce_242 = happySpecReduce_3  78# happyReduction_242
happyReduction_242 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut80 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn93
		 (anonRecord (getLoc (happy_var_1,happy_var_3)) [happy_var_2]
	)}}}

happyReduce_243 = happySpecReduce_3  78# happyReduction_243
happyReduction_243 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOutTok happy_x_1 of { (Located happy_var_1 (Token (Sym CurlyL  ) _)) -> 
	case happyOut85 happy_x_2 of { happy_var_2 -> 
	case happyOutTok happy_x_3 of { (Located happy_var_3 (Token (Sym CurlyR  ) _)) -> 
	happyIn93
		 (anonRecord (getLoc (happy_var_1,happy_var_3)) (reverse happy_var_2)
	)}}}

happyReduce_244 = happySpecReduce_3  79# happyReduction_244
happyReduction_244 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut88 happy_x_1 of { happy_var_1 -> 
	case happyOut80 happy_x_3 of { happy_var_3 -> 
	happyIn94
		 (Named { name = happy_var_1, value = happy_var_3 }
	)}}

happyReduce_245 = happySpecReduce_1  80# happyReduction_245
happyReduction_245 happy_x_1
	 =  case happyOut94 happy_x_1 of { happy_var_1 -> 
	happyIn95
		 ([happy_var_1]
	)}

happyReduce_246 = happySpecReduce_3  80# happyReduction_246
happyReduction_246 happy_x_3
	happy_x_2
	happy_x_1
	 =  case happyOut95 happy_x_1 of { happy_var_1 -> 
	case happyOut94 happy_x_3 of { happy_var_3 -> 
	happyIn95
		 (happy_var_3 : happy_var_1
	)}}

happyNewToken action sts stk
	= lexerP(\tk -> 
	let cont i = happyDoAction i tk action sts stk in
	case tk of {
	Located _ (Token EOF _) -> happyDoAction 59# tk action sts stk;
	happy_dollar_dollar@(Located _ (Token (Num   {}) _)) -> cont 1#;
	happy_dollar_dollar@(Located _ (Token (StrLit {}) _)) -> cont 2#;
	happy_dollar_dollar@(Located _ (Token (ChrLit {}) _)) -> cont 3#;
	happy_dollar_dollar@(Located _ (Token (Ident [] _) _)) -> cont 4#;
	happy_dollar_dollar@(Located _ (Token  Ident{}     _)) -> cont 5#;
	Located happy_dollar_dollar (Token (KW KW_include)   _) -> cont 6#;
	Located happy_dollar_dollar (Token (KW KW_import)    _) -> cont 7#;
	Located happy_dollar_dollar (Token (KW KW_as)        _) -> cont 8#;
	Located happy_dollar_dollar (Token (KW KW_hiding)    _) -> cont 9#;
	Located happy_dollar_dollar (Token (KW KW_private)   _) -> cont 10#;
	Located happy_dollar_dollar (Token (KW KW_property)  _) -> cont 11#;
	Located happy_dollar_dollar (Token (KW KW_infix)     _) -> cont 12#;
	Located happy_dollar_dollar (Token (KW KW_infixl)    _) -> cont 13#;
	Located happy_dollar_dollar (Token (KW KW_infixr)    _) -> cont 14#;
	Located happy_dollar_dollar (Token (KW KW_type   ) _) -> cont 15#;
	Located happy_dollar_dollar (Token (KW KW_newtype) _) -> cont 16#;
	Located happy_dollar_dollar (Token (KW KW_module ) _) -> cont 17#;
	Located happy_dollar_dollar (Token (KW KW_where  ) _) -> cont 18#;
	Located happy_dollar_dollar (Token (KW KW_let    ) _) -> cont 19#;
	Located happy_dollar_dollar (Token (KW KW_if     ) _) -> cont 20#;
	Located happy_dollar_dollar (Token (KW KW_then   ) _) -> cont 21#;
	Located happy_dollar_dollar (Token (KW KW_else   ) _) -> cont 22#;
	Located happy_dollar_dollar (Token (KW KW_x)       _) -> cont 23#;
	Located happy_dollar_dollar (Token (KW KW_primitive) _) -> cont 24#;
	Located happy_dollar_dollar (Token (Sym BracketL) _) -> cont 25#;
	Located happy_dollar_dollar (Token (Sym BracketR) _) -> cont 26#;
	Located happy_dollar_dollar (Token (Sym ArrL    ) _) -> cont 27#;
	Located happy_dollar_dollar (Token (Sym DotDot  ) _) -> cont 28#;
	Located happy_dollar_dollar (Token (Sym DotDotDot) _) -> cont 29#;
	Located happy_dollar_dollar (Token (Sym Bar     ) _) -> cont 30#;
	Located happy_dollar_dollar (Token (Sym ParenL  ) _) -> cont 31#;
	Located happy_dollar_dollar (Token (Sym ParenR  ) _) -> cont 32#;
	Located happy_dollar_dollar (Token (Sym Comma   ) _) -> cont 33#;
	Located happy_dollar_dollar (Token (Sym Semi    ) _) -> cont 34#;
	Located happy_dollar_dollar (Token (Sym Dot     ) _) -> cont 35#;
	Located happy_dollar_dollar (Token (Sym CurlyL  ) _) -> cont 36#;
	Located happy_dollar_dollar (Token (Sym CurlyR  ) _) -> cont 37#;
	Located happy_dollar_dollar (Token (Sym TriL    ) _) -> cont 38#;
	Located happy_dollar_dollar (Token (Sym TriR    ) _) -> cont 39#;
	Located happy_dollar_dollar (Token (Sym EqDef   ) _) -> cont 40#;
	Located happy_dollar_dollar (Token (Sym BackTick) _) -> cont 41#;
	Located happy_dollar_dollar (Token (Sym Colon   ) _) -> cont 42#;
	Located happy_dollar_dollar (Token (Sym ArrR    ) _) -> cont 43#;
	Located happy_dollar_dollar (Token (Sym FatArrR ) _) -> cont 44#;
	Located happy_dollar_dollar (Token (Sym Lambda  ) _) -> cont 45#;
	Located happy_dollar_dollar (Token (Sym Underscore ) _) -> cont 46#;
	Located happy_dollar_dollar (Token (Virt VCurlyL)  _) -> cont 47#;
	Located happy_dollar_dollar (Token (Virt VCurlyR)  _) -> cont 48#;
	Located happy_dollar_dollar (Token (Virt VSemi)    _) -> cont 49#;
	Located happy_dollar_dollar (Token (Op Plus)  _) -> cont 50#;
	Located happy_dollar_dollar (Token (Op Mul)   _) -> cont 51#;
	Located happy_dollar_dollar (Token (Op Exp)   _) -> cont 52#;
	Located happy_dollar_dollar (Token (Op Minus) _) -> cont 53#;
	Located happy_dollar_dollar (Token (Op Complement) _) -> cont 54#;
	Located happy_dollar_dollar (Token (Op Hash) _) -> cont 55#;
	happy_dollar_dollar@(Located _ (Token (Op (Other [] _)) _)) -> cont 56#;
	happy_dollar_dollar@(Located _ (Token (Op  Other{}   )  _)) -> cont 57#;
	happy_dollar_dollar@(Located _ (Token (White DocStr) _)) -> cont 58#;
	_ -> happyError' tk
	})

happyError_ 59# tk = happyError' tk
happyError_ _ tk = happyError' tk

happyThen :: () => ParseM a -> (a -> ParseM b) -> ParseM b
happyThen = (>>=)
happyReturn :: () => a -> ParseM a
happyReturn = (return)
happyThen1 = happyThen
happyReturn1 :: () => a -> ParseM a
happyReturn1 = happyReturn
happyError' :: () => (Located Token) -> ParseM a
happyError' tk = (\token -> happyError) tk

vmodule = happySomeParser where
  happySomeParser = happyThen (happyParse 0#) (\x -> happyReturn (happyOut15 x))

program = happySomeParser where
  happySomeParser = happyThen (happyParse 1#) (\x -> happyReturn (happyOut23 x))

programLayout = happySomeParser where
  happySomeParser = happyThen (happyParse 2#) (\x -> happyReturn (happyOut24 x))

expr = happySomeParser where
  happySomeParser = happyThen (happyParse 3#) (\x -> happyReturn (happyOut44 x))

decl = happySomeParser where
  happySomeParser = happyThen (happyParse 4#) (\x -> happyReturn (happyOut33 x))

decls = happySomeParser where
  happySomeParser = happyThen (happyParse 5#) (\x -> happyReturn (happyOut40 x))

declsLayout = happySomeParser where
  happySomeParser = happyThen (happyParse 6#) (\x -> happyReturn (happyOut42 x))

letDecl = happySomeParser where
  happySomeParser = happyThen (happyParse 7#) (\x -> happyReturn (happyOut34 x))

repl = happySomeParser where
  happySomeParser = happyThen (happyParse 8#) (\x -> happyReturn (happyOut43 x))

schema = happySomeParser where
  happySomeParser = happyThen (happyParse 9#) (\x -> happyReturn (happyOut72 x))

modName = happySomeParser where
  happySomeParser = happyThen (happyParse 10#) (\x -> happyReturn (happyOut90 x))

helpName = happySomeParser where
  happySomeParser = happyThen (happyParse 11#) (\x -> happyReturn (happyOut92 x))

happySeq = happyDontSeq


parseModName :: String -> Maybe ModName
parseModName txt =
  case parseString defaultConfig { cfgModuleScope = False } modName txt of
    Right a -> Just (thing a)
    Left _  -> Nothing

parseHelpName :: String -> Maybe PName
parseHelpName txt =
  case parseString defaultConfig { cfgModuleScope = False } helpName txt of
    Right a -> Just (thing a)
    Left _  -> Nothing

addImplicitIncludes :: Config -> Program PName -> Program PName
addImplicitIncludes cfg (Program ds) =
  Program $ map path (cfgAutoInclude cfg) ++ ds
  where path p = Include Located { srcRange = rng, thing = p }
        rng    = Range { source = cfgSource cfg, from = start, to = start }


parseProgramWith :: Config -> Text -> Either ParseError (Program PName)
parseProgramWith cfg s = case res s of
                          Left err -> Left err
                          Right a  -> Right (addImplicitIncludes cfg a)
  where
  res = parse cfg $ case cfgLayout cfg of
                      Layout   -> programLayout
                      NoLayout -> program

parseModule :: Config -> Text -> Either ParseError (Module PName)
parseModule cfg = parse cfg { cfgModuleScope = True } vmodule

parseProgram :: Layout -> Text -> Either ParseError (Program PName)
parseProgram l = parseProgramWith defaultConfig { cfgLayout = l }

parseExprWith :: Config -> Text -> Either ParseError (Expr PName)
parseExprWith cfg = parse cfg { cfgModuleScope = False } expr

parseExpr :: Text -> Either ParseError (Expr PName)
parseExpr = parseExprWith defaultConfig

parseDeclWith :: Config -> Text -> Either ParseError (Decl PName)
parseDeclWith cfg = parse cfg { cfgModuleScope = False } decl

parseDecl :: Text -> Either ParseError (Decl PName)
parseDecl = parseDeclWith defaultConfig

parseDeclsWith :: Config -> Text -> Either ParseError [Decl PName]
parseDeclsWith cfg = parse cfg { cfgModuleScope = ms } decls'
  where (ms, decls') = case cfgLayout cfg of
                         Layout   -> (True, declsLayout)
                         NoLayout -> (False, decls)

parseDecls :: Text -> Either ParseError [Decl PName]
parseDecls = parseDeclsWith defaultConfig

parseLetDeclWith :: Config -> Text -> Either ParseError (Decl PName)
parseLetDeclWith cfg = parse cfg { cfgModuleScope = False } letDecl

parseLetDecl :: Text -> Either ParseError (Decl PName)
parseLetDecl = parseLetDeclWith defaultConfig

parseReplWith :: Config -> Text -> Either ParseError (ReplInput PName)
parseReplWith cfg = parse cfg { cfgModuleScope = False } repl

parseRepl :: Text -> Either ParseError (ReplInput PName)
parseRepl = parseReplWith defaultConfig

parseSchemaWith :: Config -> Text -> Either ParseError (Schema PName)
parseSchemaWith cfg = parse cfg { cfgModuleScope = False } schema

parseSchema :: Text -> Either ParseError (Schema PName)
parseSchema = parseSchemaWith defaultConfig

-- vim: ft=haskell
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 19 "<built-in>" #-}
{-# LINE 1 "/usr/local/Cellar/ghc/7.10.3a/lib/ghc-7.10.3/include/ghcversion.h" #-}


















{-# LINE 20 "<built-in>" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- Id: GenericTemplate.hs,v 1.26 2005/01/14 14:47:22 simonmar Exp 


{-# LINE 13 "templates/GenericTemplate.hs" #-}





-- Do not remove this comment. Required to fix CPP parsing when using GCC and a clang-compiled alex.
#if __GLASGOW_HASKELL__ > 706
#define LT(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.<# m)) :: Bool)
#define GTE(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.>=# m)) :: Bool)
#define EQ(n,m) ((Happy_GHC_Exts.tagToEnum# (n Happy_GHC_Exts.==# m)) :: Bool)
#else
#define LT(n,m) (n Happy_GHC_Exts.<# m)
#define GTE(n,m) (n Happy_GHC_Exts.>=# m)
#define EQ(n,m) (n Happy_GHC_Exts.==# m)
#endif

{-# LINE 46 "templates/GenericTemplate.hs" #-}


data Happy_IntList = HappyCons Happy_GHC_Exts.Int# Happy_IntList






{-# LINE 67 "templates/GenericTemplate.hs" #-}


{-# LINE 77 "templates/GenericTemplate.hs" #-}










infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is 0#, it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept 0# tk st sts (_ `HappyStk` ans `HappyStk` _) =
        happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
        (happyTcHack j (happyTcHack st)) (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action



happyDoAction i tk st
        = {- nothing -}
          

          case action of
                0#           -> {- nothing -}
                                     happyFail i tk st
                -1#          -> {- nothing -}
                                     happyAccept i tk st
                n | LT(n,(0# :: Happy_GHC_Exts.Int#)) -> {- nothing -}
                                                   
                                                   (happyReduceArr Happy_Data_Array.! rule) i tk st
                                                   where rule = (Happy_GHC_Exts.I# ((Happy_GHC_Exts.negateInt# ((n Happy_GHC_Exts.+# (1# :: Happy_GHC_Exts.Int#))))))
                n                 -> {- nothing -}
                                     

                                     happyShift new_state i tk st
                                     where new_state = (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#))
   where off    = indexShortOffAddr happyActOffsets st
         off_i  = (off Happy_GHC_Exts.+# i)
         check  = if GTE(off_i,(0# :: Happy_GHC_Exts.Int#))
                  then EQ(indexShortOffAddr happyCheck off_i, i)
                  else False
         action
          | check     = indexShortOffAddr happyTable off_i
          | otherwise = indexShortOffAddr happyDefActions st


indexShortOffAddr (HappyA# arr) off =
        Happy_GHC_Exts.narrow16Int# i
  where
        i = Happy_GHC_Exts.word2Int# (Happy_GHC_Exts.or# (Happy_GHC_Exts.uncheckedShiftL# high 8#) low)
        high = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr (off' Happy_GHC_Exts.+# 1#)))
        low  = Happy_GHC_Exts.int2Word# (Happy_GHC_Exts.ord# (Happy_GHC_Exts.indexCharOffAddr# arr off'))
        off' = off Happy_GHC_Exts.*# 2#





data HappyAddr = HappyA# Happy_GHC_Exts.Addr#




-----------------------------------------------------------------------------
-- HappyState data type (not arrays)


{-# LINE 170 "templates/GenericTemplate.hs" #-}

-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state 0# tk st sts stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--     trace "shifting the error token" $
     happyDoAction i tk new_state (HappyCons (st) (sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state (HappyCons (st) (sts)) ((happyInTok (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_0 nt fn j tk st@((action)) sts stk
     = happyGoto nt j tk st (HappyCons (st) (sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@((HappyCons (st@(action)) (_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_2 nt fn j tk _ (HappyCons (_) (sts@((HappyCons (st@(action)) (_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happySpecReduce_3 nt fn j tk _ (HappyCons (_) ((HappyCons (_) (sts@((HappyCons (st@(action)) (_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (happyGoto nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) sts of
         sts1@((HappyCons (st1@(action)) (_))) ->
                let r = fn stk in  -- it doesn't hurt to always seq here...
                happyDoSeq r (happyGoto nt j tk st1 sts1 r)

happyMonadReduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
          let drop_stk = happyDropStk k stk in
          happyThen1 (fn stk tk) (\r -> happyGoto nt j tk st1 sts1 (r `HappyStk` drop_stk))

happyMonad2Reduce k nt fn 0# tk st sts stk
     = happyFail 0# tk st sts stk
happyMonad2Reduce k nt fn j tk st sts stk =
      case happyDrop k (HappyCons (st) (sts)) of
        sts1@((HappyCons (st1@(action)) (_))) ->
         let drop_stk = happyDropStk k stk

             off = indexShortOffAddr happyGotoOffsets st1
             off_i = (off Happy_GHC_Exts.+# nt)
             new_state = indexShortOffAddr happyTable off_i



          in
          happyThen1 (fn stk tk) (\r -> happyNewToken new_state sts1 (r `HappyStk` drop_stk))

happyDrop 0# l = l
happyDrop n (HappyCons (_) (t)) = happyDrop (n Happy_GHC_Exts.-# (1# :: Happy_GHC_Exts.Int#)) t

happyDropStk 0# l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n Happy_GHC_Exts.-# (1#::Happy_GHC_Exts.Int#)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction


happyGoto nt j tk st = 
   {- nothing -}
   happyDoAction j tk new_state
   where off = indexShortOffAddr happyGotoOffsets st
         off_i = (off Happy_GHC_Exts.+# nt)
         new_state = indexShortOffAddr happyTable off_i




-----------------------------------------------------------------------------
-- Error recovery (0# is the error token)

-- parse error if we are in recovery and we fail again
happyFail 0# tk old_st _ stk@(x `HappyStk` _) =
     let i = (case Happy_GHC_Exts.unsafeCoerce# x of { (Happy_GHC_Exts.I# (i)) -> i }) in
--      trace "failing" $ 
        happyError_ i tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  0# tk old_st (HappyCons ((action)) (sts)) 
                                                (saved_tok `HappyStk` _ `HappyStk` stk) =
--      trace ("discarding state, depth " ++ show (length stk))  $
        happyDoAction 0# tk action sts ((saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail  i tk (action) sts stk =
--      trace "entering error recovery" $
        happyDoAction 0# tk action sts ( (Happy_GHC_Exts.unsafeCoerce# (Happy_GHC_Exts.I# (i))) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll :: a
notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions


happyTcHack :: Happy_GHC_Exts.Int# -> a -> a
happyTcHack x y = y
{-# INLINE happyTcHack #-}


-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--      happySeq = happyDoSeq
-- otherwise it emits
--      happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.


{-# NOINLINE happyDoAction #-}
{-# NOINLINE happyTable #-}
{-# NOINLINE happyCheck #-}
{-# NOINLINE happyActOffsets #-}
{-# NOINLINE happyGotoOffsets #-}
{-# NOINLINE happyDefActions #-}

{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.

