{-# language CPP #-}

module Clocked.Common where


#ifdef darwin_HOST_OS


import Control.Applicative ((<$>))

import Data.Time.Clock.POSIX

getTimeDouble = realToFrac <$> getPOSIXTime


#else


import Control.Applicative ((<$>))

import System.Clock

-- | returns a monotonic time in seconds
getTimeDouble :: IO Double
getTimeDouble =
    toSeconds <$> getTime Monotonic
  where
    toSeconds (TimeSpec seconds nanoSeconds) =
        fromIntegral seconds + fromIntegral nanoSeconds * 10 ** (- 9)


#endif
